(function(window,dom){
var mystream=window.MYSTREAM=window.MYSTREAM||{},
domFocus=dom.FOCUS,
contentManager,
stbDetailScreen,
thumnailEvent,
logoEvent;
thumnailEvent=function(event){
if(stbDetailScreen.screenState!==
stbDetailScreen.SCREEN_STATE.OPENED){
return;}
if(event.type==='error'){
this.src=stbDetailScreen.content.getDefaultImagePath();}else {
this.parentNode.classList.add('display');
if(mystream.checkImageSize(this)==='horizontal'){
this.classList.add('hWide');}else {
this.classList.remove('hWide');}
}
};
logoEvent=function(event){
var parent;
if(stbDetailScreen.screenState!==
stbDetailScreen.SCREEN_STATE.OPENED||
event.type==='error'){
return;}
parent=this.parentNode;
if(!parent){
return;}
parent.classList.add('display');
if(this.naturalWidth>this.naturalHeight*2){
parent.classList.add('hWide');}else {
parent.classList.remove('hWide');}
};
stbDetailScreen={
SCREEN_STATE:{
CLOSED:0,
OPENED:1
},
FOCUS_POSITION:{
NONE:0,
DETAIL:1,
BUTTON:2
},
screenState:0,
loadingData:false,
scrollBox:null,
content:null,
buttonList:[],
buttonIndex:0,
focus:null,
focusPosition:0,
init:function(callback){
this.closeCallback=callback;
this.focus=new domFocus.Focus(document.getElementById('stbFocus'));
contentManager=mystream.CONTENT_MANAGER;
return this;},
open:function(content){
DEBUG.console(DEBUG.LVL.VERBOSE,'make search screen');
var i,max,that=this,scrollBox,scheme,tvState,
eleScreen,eleLeftArea,eleRightArea,eleThumnailWrap,
eleThumnail,eleLogo,eleService,eleInfoArea,
eleInfoLine1,eleInfoLine2,eleTitleArea,eleTitleMain,
eleTitleSub,eleGenre,eleDetailArea,eleLoadingIcon,
eleBtnTemplate,eleBtn,eleBtnArea;
this.focusPosition=this.FOCUS_POSITION.NONE;
this.buttonList=[];
this.buttonIndex=0;
if(content.kind===contentManager.KIND.ONAIR){
tvState=mystream.app_launcher.checkTvService(content);
if(tvState==='live'){
this.buttonList.push({type:'watch',
elementId:'stbBtnWatch',
name:LANG('LT_WATCH')});}else if(tvState==='future'){
if(mystream.Configurations.timerProgramming===true){
this.buttonList.push({type:'timer',
elementId:'stbBtnTimer',
name:LANG('LT_TIMER_PROGRAMMING')});}
scheme=content.attr.src.slice(0,content.attr.src.indexOf(':'));
if(mystream.Configurations.accurateRecording===true&&
content.attr.eventId!==-1&&
(scheme==='dvb-t'||
scheme==='dvb-c'||
(mystream.Configurations.accurateRecordingDvbSatDvbIp===true&&scheme==='dvb-s')||
(mystream.Configurations.accurateRecordingDvbSatDvbIp===true&&scheme==='dvb-ip'))){
this.buttonList.push({type:'timer_acc',
elementId:'stbBtnAccRec',
name:LANG('LT_SIGNAL_SUPPORT_REC')});}
}
}
eleScreen=dom.createElement('div',{id:'stbDetailScreen'});
eleLeftArea=dom.createElement('div',{id:'stbLeftArea'});
eleRightArea=dom.createElement('div',{id:'stbRightArea'});
eleThumnailWrap=dom.createElement('div',{id:'stbThumnailWrap'});
eleThumnail=dom.createElement('img',{id:'stbThumnail',
src:content.attr.thumnail1});
eleThumnail.addEventListener('load',thumnailEvent,false);
eleThumnail.addEventListener('error',thumnailEvent,false);
eleThumnailWrap.appendChild(eleThumnail);
eleLeftArea.appendChild(eleThumnailWrap);
if(this.buttonList.length>0){
eleBtnArea=dom.createElement('div',{id:'stbBtnArea'});
eleBtnTemplate=dom.createElement('div',{className:'commonBtn stbBtn'});
for(i=0,max=this.buttonList.length;i<max;i+=1){
eleBtn=eleBtnTemplate.cloneNode(false);
eleBtn.id=this.buttonList[i].elementId;
eleBtn.textContent=this.buttonList[i].name;
eleBtnArea.appendChild(eleBtn);}
eleLeftArea.appendChild(eleBtnArea);}
eleInfoArea=dom.createElement('div',{id:'stbInfoArea'});
eleInfoLine1=dom.createElement('div',{id:'stbInfoLine1'});
eleService=dom.createElement('p',{id:'stbService'});
eleLogo=dom.createElement('div',{id:'stbLogo'});
eleLogo.appendChild(document.createElement('img'));
eleLogo.firstChild.addEventListener('load',logoEvent,false);
eleLogo.firstChild.addEventListener('error',logoEvent,false);
eleInfoLine1.appendChild(eleLogo);
eleInfoLine1.appendChild(eleService);
eleService.textContent=content.attr.srvName||'';
eleInfoLine2=dom.createElement('p',{id:'stbInfoLine2'});
eleInfoLine2.appendChild(content.getOnAirTimeText());
eleInfoArea.appendChild(eleInfoLine1);
eleInfoArea.appendChild(eleInfoLine2);
eleTitleArea=dom.createElement('div',{id:'stbTitleArea'});
eleTitleMain=dom.createElement('div',{id:'stbTitleMain'});
eleTitleSub=dom.createElement('div',{id:'stbTitleSub'});
eleGenre=dom.createElement('div',{id:'stbGenre'});
eleTitleMain.textContent=content.attr.title||'';
eleTitleArea.appendChild(eleTitleMain);
eleTitleArea.appendChild(eleTitleSub);
eleTitleArea.appendChild(eleGenre);
this.scrollBox=new mystream.ScrollBox();
eleDetailArea=this.scrollBox.createElement('stbDetailArea');
eleRightArea.appendChild(eleInfoArea);
eleRightArea.appendChild(eleTitleArea);
eleRightArea.appendChild(eleDetailArea);
eleScreen.appendChild(eleLeftArea);
eleScreen.appendChild(eleRightArea);
eleLoadingIcon=mystream.createLoadingIcon('stbLoadingIcon');
eleScreen.appendChild(eleLoadingIcon);
document.body.appendChild(eleScreen);
this.content=content;
this.loading=true;
this.screenState=this.SCREEN_STATE.OPENED;
if(this.buttonList.length>0){
eleBtn=document.getElementById(this.buttonList[this.buttonIndex].elementId);
if(eleBtn){
this.focus.set(eleBtn);
this.focusPosition=this.FOCUS_POSITION.BUTTON;}
}
return this;},
close:function(callback){
DEBUG.console(DEBUG.LVL.INFO,'stbDetailScreen.close');
var eleDetailScreen=document.getElementById('stbDetailScreen'),
eleThumnail=document.getElementById('stbThumnail'),
eleLogo=document.getElementById('stbLogo');
if(eleThumnail){
eleThumnail.removeEventListener('load',thumnailEvent,false);
eleThumnail.removeEventListener('error',thumnailEvent,false);}
if(eleLogo&&eleLogo.firstChild){
eleLogo.firstChild.removeEventListener('load',logoEvent,false);
eleLogo.firstChild.removeEventListener('error',logoEvent,false);}
this.content=null;
this.loading=false;
if(this.scrollBox){
this.scrollBox.destroy();}
this.scrollBox=null;
this.buttonList=[];
this.buttonIndex=0;
if(eleDetailScreen){
eleDetailScreen.innerHTML='';
eleDetailScreen.parentNode.removeChild(eleDetailScreen);
eleDetailScreen=null;}
this.focus.off();
this.focus.ele.classList.remove('onStbDetail');
this.screenState=this.SCREEN_STATE.CLOSED;
this.focusPosition=this.FOCUS_POSITION.NONE;
if(callback){
callback();}else if(this.closeCallback){
this.closeCallback();}
return this;},
keyDownHandler:function(event){
var eleBtn,eleDetailArea,btnType;
if(this.screenState!==this.SCREEN_STATE.OPENED){
return this;}
switch(event.keyCode){
case KeyEvent.DOM_VK_UP:
switch(this.focusPosition){
case this.FOCUS_POSITION.DETAIL:
case this.FOCUS_POSITION.NONE:
this.scrollBox.scrollUp();
break;
case this.FOCUS_POSITION.BUTTON:
if(this.buttonList.length===1){
return this;}
if(this.buttonIndex===0){
this.buttonIndex=this.buttonList.length-1;}else {
this.buttonIndex-=1;}
eleBtn=document.getElementById(this.buttonList[this.buttonIndex].elementId);
this.focus.move(eleBtn);
break;
default:
}
break;
case KeyEvent.DOM_VK_DOWN:
switch(this.focusPosition){
case this.FOCUS_POSITION.DETAIL:
case this.FOCUS_POSITION.NONE:
this.scrollBox.scrollDown();
break;
case this.FOCUS_POSITION.BUTTON:
if(this.buttonList.length===1){
return this;}
if(this.buttonIndex>=this.buttonList.length-1){
this.buttonIndex=0;}else {
this.buttonIndex+=1;}
eleBtn=document.getElementById(this.buttonList[this.buttonIndex].elementId);
this.focus.move(eleBtn);
break;
default:
}
break;
case KeyEvent.DOM_VK_RIGHT:
if(this.focusPosition===this.FOCUS_POSITION.BUTTON&&
this.loading===false){
eleDetailArea=document.getElementById('stbDetailArea');
this.focus.set(eleDetailArea);
this.focus.ele.classList.add('onStbDetail');
this.focusPosition=this.FOCUS_POSITION.DETAIL;}
break;
case KeyEvent.DOM_VK_LEFT:
if(this.focusPosition===this.FOCUS_POSITION.DETAIL&&
this.buttonList.length>0){
eleBtn=document.getElementById(this.buttonList[this.buttonIndex].elementId);
this.focus.set(eleBtn);
this.focus.ele.classList.remove('onStbDetail');
this.focusPosition=this.FOCUS_POSITION.BUTTON;}
break;
case KeyEvent.DOM_VK_RETURN:
if(this.focusPosition===this.FOCUS_POSITION.BUTTON&&
this.buttonList.length>0&&this.content){
btnType=this.buttonList[this.buttonIndex].type;
switch(btnType){
case 'watch':
mystream.app_launcher.launch_application(this.content,'watch');
break;
case 'timer':
mystream.app_launcher.launch_application(this.content,'timer');
break;
case 'timer_acc':
mystream.app_launcher.launch_application(this.content,'timer_acc');
break;
default:
}
}
break;
case KeyEvent.DOM_VK_BACK_SPACE:
this.close();
break;
default:
}
return this;},
setTVDetailInfo:function(detailInfo){
var eleTitleMain,eleTitleSub,eleGenre,
eleBtn,eleLogo,
txtSubTitle='',txtDetail='';
if(this.screenState!==this.SCREEN_STATE.OPENED||
this.loading===false){
return this;}
this.stopLoading();
if(detailInfo){
txtSubTitle=detailInfo.subTitle||'';
txtDetail=detailInfo.detail||'';
eleLogo=document.getElementById('stbLogo');
if(eleLogo&&detailInfo.logo_url){
eleLogo.firstChild.src=detailInfo.logo_url;}
}
eleTitleSub=document.getElementById('stbTitleSub');
if(eleTitleSub){
eleTitleSub.textContent=txtSubTitle;}
this.scrollBox.setText(txtDetail).setMoveValue().update();
return this;},
stopLoading:function(){
var eleLoadingIcon;
if(this.screenState!==this.SCREEN_STATE.OPENED||
this.loading===false){
return this;}
this.loading=false;
eleLoadingIcon=document.getElementById('stbLoadingIcon');
if(eleLoadingIcon){
eleLoadingIcon.parentNode.removeChild(eleLoadingIcon);}
return this;}
};
mystream.TV_DETAIL_SCREEN=stbDetailScreen;}(window,DOMUTIL));
