(function(window,dom){
var searchScreen,
mystream=window.MYSTREAM=window.MYSTREAM||{},
system=window.system||{socket:{write:function(){}}},
domFocus=dom.FOCUS,
historyList,
TIME_DELAY_KEYBOARD=500;
searchScreen={
SCREEN_STATE:{
CLOSED:0,
OPENED:1,
TRANSITION:2
},
FOCUS_POSITION:{
NONE:0,
INPUT:1,
HISTORY0:2,
HISTORY1:3,
HISTORY2:4,
HISTORY3:5,
HISTORY4:6,
DEL_HISTORY:7,
TRANSITION:8
},
MAX_HISTORY_NUM:5,
TIME_WAIT_CLOSE:1000,
TIME_RESTRAIN_KEY:1500,
MAX_TEXT_LENGTH:100,
screenState:0,
focusPosition:0,
historyIndex:0,
displayKeyboard:false,
focus:null,
closeCallback:null,
forceCloseCallback:null,
keyEnable:true,
init:function(callback){
this.closeCallback=callback;},
open:function(){
DEBUG.console(DEBUG.LVL.VERBOSE,'make search screen');
var i,max,that=this,classDir,eleTemp,eleScreen,eleScreenTop,
eleSearchIcon,eleInputBox,eleHistoryBox,eleHistoryList,
eleHistoryText,eleHistoryDelIcon,eleFocus,eleTemplate;
this.forceCloseCallback=null;
eleScreen=dom.createElement('div',{id:'searchScreen'});
eleScreen.addEventListener('keydown',this.keyDownHandler,false);
eleScreenTop=dom.createElement('div',{id:'searchScreenTop'});
eleInputBox=dom.createElement('div',{id:'searchInputBox'});
eleTemp=dom.createElement('div',{id:'searchGuideText'});
eleInputBox.appendChild(eleTemp);
eleTemp=dom.createElement('label',{id:'searchInputLabel'});
eleTemp.setAttribute('for','searchInput');
eleSearchIcon=document.createElement('img');
eleSearchIcon.setAttribute('id','searchAreaIcon');
eleSearchIcon.setAttribute('src','img/se_loupe.png');
eleTemp.appendChild(eleSearchIcon);
eleTemp.appendChild(document.createTextNode(' '+LANG('LT_HOME_SEARCH')));
eleInputBox.appendChild(eleTemp);
eleTemp=dom.createElement('input',{id:'searchInputText',name:'searchInput',
type:'text',maxlength:this.MAX_TEXT_LENGTH});
if(mystream.textDirection==='rtl'){
eleTemp.classList.add('dirRtl');}
eleInputBox.appendChild(eleTemp);
eleScreenTop.appendChild(eleInputBox);
eleScreen.appendChild(eleScreenTop);
eleHistoryBox=dom.createElement('div',{id:'searchHistoryBox'});
eleTemp=dom.createElement('div',{id:'searchHistoryHead'});
eleTemp.textContent=LANG('LT_SE_HISTORY');
eleHistoryBox.appendChild(eleTemp);
eleTemp=dom.createElement('div',{id:'searchHistoryArrow'});
eleTemp.textContent='>';
eleHistoryBox.appendChild(eleTemp);
eleHistoryList=dom.createElement('div',{id:'searchHistoryList'});
eleTemplate=dom.createElement('div',{className:'searchHistoryText'});
if(mystream.textDirection==='rtl'){
eleTemplate.classList.add('dirRtl');}
eleTemplate.appendChild(document.createElement('span'));
this.historyList=that.getSearchHistory();
if(this.historyList){
for(i=0;i<this.historyList.length;i++){
eleHistoryText=eleTemplate.cloneNode(true);
eleHistoryText.firstChild.textContent=this.historyList[i].toString();
eleHistoryText.id='searchHistoryText'+i;
eleHistoryList.appendChild(eleHistoryText);}
}
eleHistoryBox.appendChild(eleHistoryList);
eleTemp=dom.createElement('label',{id:'historyDelLabel'});
eleTemp.setAttribute('for','historyDel');
eleHistoryDelIcon=document.createElement('img');
eleHistoryDelIcon.setAttribute('id','historyDelIcon');
eleHistoryDelIcon.setAttribute('src','img/minus_icon.png');
eleTemp.appendChild(eleHistoryDelIcon);
eleTemp.appendChild(document.createTextNode(' '+LANG('LT_DELETE')));
eleHistoryBox.appendChild(eleTemp);
eleScreen.appendChild(eleHistoryBox);
eleFocus=dom.createElement('div',{id:'searchFocus',className:'cmn_focus'});
eleScreen.appendChild(eleFocus);
this.focus=new domFocus.Focus(eleFocus);
this.screenState=this.SCREEN_STATE.TRANSITION;
dom.addAnimationEndCallback(eleScreen,'slideInBottom',function(){
var eleInputText=document.getElementById('searchInputText');
that.screenState=that.SCREEN_STATE.OPENED;
if(that.forceCloseCallback){
that.close();
return;}
eleInputText.focus();
that.focus.set(eleInputText);
that.focusPosition=that.FOCUS_POSITION.INPUT;});
document.body.appendChild(eleScreen);},
close:function(callback,closeType){
DEBUG.console(DEBUG.LVL.INFO,'searchScreen.close callback:'+callback+
', closeType:'+closeType);
var that=this,searchText=null,eleScreen,closeCallback;
if(callback){
this.forceCloseCallback=callback;}
if(this.screenState===this.SCREEN_STATE.TRANSITION){
return;}
this.screenState=this.SCREEN_STATE.TRANSITION;
document.documentElement.focus();
if(closeType==='Done'){
searchText=document.getElementById('searchInputText').value.trim();}
eleScreen=document.getElementById('searchScreen');
eleScreen.removeEventListener('keydown',this.keyDownHandler,false);
this.focus.destroy();
this.focus=null;
this.setSearchHistory(searchText);
eleScreen.parentNode.removeChild(eleScreen);
eleScreen=null;
setTimeout(function(){
var callback=that.closeCallback;
that.screenState=that.SCREEN_STATE.CLOSED;
if(that.forceCloseCallback){
callback=that.forceCloseCallback;
that.forceCloseCallback=null;}
callback(searchText);},this.TIME_WAIT_CLOSE);},
setSearchHistory:function(word){
var index;
if(typeof word!=='string'||word.length<=0){
DEBUG.console(DEBUG.LVL.INFO,'setSearchHistory: not string or length 0'+word);
return;}
if(this.historyList){
if((index=this.historyList.indexOf(word))!=-1){
this.historyList.splice(index,1);}
if(this.historyList.length>=this.MAX_HISTORY_NUM){
this.historyList.pop();}
}else {
this.historyList=[];}
this.historyList.unshift(word);
localStorage.setItem('searchHistory',JSON.stringify(this.historyList));},
getSearchHistory:function(){
var h_array,h=localStorage.getItem('searchHistory');
if(!h){
return null;}
h_array=JSON.parse(h);
if(!Array.isArray(h_array)){
return null;}
DEBUG.console(DEBUG.LVL.INFO,'getSearchHistory from localstorage:'+h_array);
return h_array;},
deleteSearchHistory:function(){
var that=searchScreen;
var hl=document.getElementById('searchHistoryList');
for(var i=hl.childNodes.length-1;i>=0;i--){
hl.removeChild(hl.childNodes[i]);}
this.historyList=[];
localStorage.removeItem('searchHistory');},
toggleKeyboard:function(){
this.keyEnable=false;
setTimeout(this.toKeyEnable.bind(this),this.TIME_RESTRAIN_KEY);
try{
if(this.displayKeyboard){
system.socket.write(JSON.stringify({command:'dismiss_osk'}));}else {
system.socket.write(JSON.stringify({command:'invoke_osk'}));}
this.displayKeyboard=!this.displayKeyboard;}catch(e){}
},
toKeyEnable:function(){
this.keyEnable=true;},
keyDownHandler:function(event){
var that=searchScreen;
var eleInputText=document.getElementById('searchInputText');
function getHistoryTextDiv(focus_index){
var i=focus_index-that.FOCUS_POSITION.HISTORY0;
if(i<0)return null;
return document.getElementById('searchHistoryText'+i);}
event.stopPropagation();
if(!that.keyEnable){
event.preventDefault();
return;}
if(that.displayKeyboard){
switch(event.keyCode){
case KeyEvent.DOM_VK_RETURN:
that.toggleKeyboard();
that.close(false,'Done');
event.preventDefault();
break;
case KeyEvent.DOM_VK_ESCAPE:
that.toggleKeyboard();
event.preventDefault();
break;
case KeyEvent.DOM_VK_RIGHT:
if(event.target.selectionEnd===event.target.value.length){
event.preventDefault();}
break;
default:
DEBUG.console(DEBUG.LVL.INFO,'event.keyCode='+event.keyCode);
break;}
return;}
event.preventDefault();
if(that.focus.currentState===domFocus.STATE.OFF||
that.screenState!==that.SCREEN_STATE.OPENED||
that.displayKeyboard){
return;}
if(event.keyCode==KeyEvent.DOM_VK_BACK_SPACE){
that.close(false,'Exit');}
DEBUG.console(DEBUG.LVL.VERBOSE,'that.focusPosition = '+that.focusPosition);
switch(that.focusPosition){
case that.FOCUS_POSITION.INPUT:
switch(event.keyCode){
case KeyEvent.DOM_VK_RETURN:
that.toggleKeyboard();
break;
case KeyEvent.DOM_VK_DOWN:
var s0=document.getElementById('searchHistoryText0');
if(s0){
that.focus.move(s0);
that.focusPosition=that.FOCUS_POSITION.HISTORY0;}
break;
default:
break;}
break;
case that.FOCUS_POSITION.HISTORY0:
case that.FOCUS_POSITION.HISTORY1:
case that.FOCUS_POSITION.HISTORY2:
case that.FOCUS_POSITION.HISTORY3:
case that.FOCUS_POSITION.HISTORY4:
switch(event.keyCode){
case KeyEvent.DOM_VK_RETURN:
var s_cur=getHistoryTextDiv(that.focusPosition);
if(s_cur){
eleInputText.value=s_cur.textContent;
that.focus.move(eleInputText);
that.focusPosition=that.FOCUS_POSITION.INPUT;
that.toggleKeyboard();}else {
that.deleteSearchHistory();}
break;
case KeyEvent.DOM_VK_UP:
that.focus.move(eleInputText);
that.focusPosition=that.FOCUS_POSITION.INPUT;
break;
case KeyEvent.DOM_VK_LEFT:
var s_left=getHistoryTextDiv(that.focusPosition-1);
if(s_left){
that.focus.move(s_left);
that.focusPosition--;}
break;
case KeyEvent.DOM_VK_RIGHT:
var s_right=getHistoryTextDiv(that.focusPosition+1);
if(s_right){
that.focus.move(s_right);
that.focusPosition++;}else {
that.focus.move(document.getElementById('historyDelLabel'));
that.focusPosition=that.FOCUS_POSITION.DEL_HISTORY;}
break;
default:
break;}
break;
case that.FOCUS_POSITION.DEL_HISTORY:
switch(event.keyCode){
case KeyEvent.DOM_VK_RETURN:
that.deleteSearchHistory();
that.focus.move(eleInputText);
that.focusPosition=that.FOCUS_POSITION.INPUT;
break;
case KeyEvent.DOM_VK_UP:
that.focus.move(eleInputText);
that.focusPosition=that.FOCUS_POSITION.INPUT;
break;
case KeyEvent.DOM_VK_LEFT:
var s_left=null;
for(var i=that.FOCUS_POSITION.HISTORY4;i>=that.FOCUS_POSITION.HISTORY0;i--){
s_left=getHistoryTextDiv(i);
if(s_left){
that.focus.move(s_left);
that.focusPosition=i;
break;}
}
break;
case KeyEvent.DOM_VK_RIGHT:
default:
break;}
break;
default:
break;}
}
};
mystream.SEARCH_SCREEN=searchScreen;}(window,DOMUTIL));
