(function(window,dom){
var PostcodeInput,
mystream=window.MYSTREAM=window.MYSTREAM||{},
domFocus=dom.FOCUS,
MAX_LENGTH=10,
FIX_TEXTS;
PostcodeInput=function(callback){
var defaultValue=mystream.msUtil.getPostCode(),
createCommandData;
this.eles=null;
this.focus=null;
this.focusPos={column:0,row:0};
this.type=mystream.serviceConfig.postcodeType;
this.hyphenIndex=mystream.serviceConfig.postcodeHyphenIndex;
this.value=defaultValue||'';
this.valueList=[];
this.label=LANG('LT_POSTCODE');
this.currentState=this.STATE.NOT_READY;
this.keyList=[];
this.commandRow=1;
this.errDialog=false;
this.callback=callback;
createCommandData=function(){
var infoDel,infoDelAll,infoOk,infoCancel;
infoDel={type:'delete',value:LANG('LT_DELETE'),index:0};
infoDelAll={type:'del_all',value:LANG('LT_DEL_ALL'),index:1};
infoOk={type:'ok',value:LANG('LT_OK'),index:2};
infoCancel={type:'cancel',value:LANG('LT_CANCEL'),index:3};
return [
infoDel,infoDel,infoDel,
infoDelAll,infoDelAll,infoDelAll,
infoOk,infoOk,infoOk,
infoCancel
];};
if(this.type==='ascii'){
this.keyList[0]=[
KeyEvent.DOM_VK_0,KeyEvent.DOM_VK_1,KeyEvent.DOM_VK_2,
KeyEvent.DOM_VK_3,KeyEvent.DOM_VK_4,KeyEvent.DOM_VK_5,
KeyEvent.DOM_VK_6,KeyEvent.DOM_VK_7,KeyEvent.DOM_VK_8,
KeyEvent.DOM_VK_9
];
this.keyList[1]=[
KeyEvent.DOM_VK_A,KeyEvent.DOM_VK_B,KeyEvent.DOM_VK_C,
KeyEvent.DOM_VK_D,KeyEvent.DOM_VK_E,KeyEvent.DOM_VK_F,
KeyEvent.DOM_VK_G,KeyEvent.DOM_VK_H,KeyEvent.DOM_VK_I,
KeyEvent.DOM_VK_J
];
this.keyList[2]=[
KeyEvent.DOM_VK_K,KeyEvent.DOM_VK_L,KeyEvent.DOM_VK_M,
KeyEvent.DOM_VK_N,KeyEvent.DOM_VK_O,KeyEvent.DOM_VK_P,
KeyEvent.DOM_VK_Q,KeyEvent.DOM_VK_R,KeyEvent.DOM_VK_S,
KeyEvent.DOM_VK_T
];
this.keyList[3]=[
KeyEvent.DOM_VK_U,KeyEvent.DOM_VK_V,KeyEvent.DOM_VK_W,
KeyEvent.DOM_VK_X,KeyEvent.DOM_VK_Y,KeyEvent.DOM_VK_Z,
KeyEvent.DOM_VK_SPACE,
false,false,false
];
this.commandRow=4;
this.keyList[4]=createCommandData();}else {
this.keyList[0]=[
KeyEvent.DOM_VK_0,KeyEvent.DOM_VK_1,KeyEvent.DOM_VK_2,
KeyEvent.DOM_VK_3,KeyEvent.DOM_VK_4,KeyEvent.DOM_VK_5,
KeyEvent.DOM_VK_6,KeyEvent.DOM_VK_7,KeyEvent.DOM_VK_8,
KeyEvent.DOM_VK_9
];
this.commandRow=1;
this.keyList[1]=createCommandData();}
};
PostcodeInput.prototype.STATE=PostcodeInput.STATE={
NOT_READY:0,
READY:1,
CLOSED:2
};
PostcodeInput.prototype.open=function(id,parent,focus){
var row,col,rMax,cMax,oldInfo,text,eleScreen,eleDialog,eleHead,
eleInput,eleLabel,eleValue,eleValueText,eleKeyArea,eleKeyLine,
eleKeyTemp,eleKey,eleErrDialog,eleText,eleCursor;
eleScreen=dom.createElement('div',{id:id,
className:'fullScreenOverlay'});
eleDialog=dom.createElement('div',{className:'postcodeDialog'});
eleHead=dom.createElement('p',{className:'postcodeHead'});
eleHead.textContent=LANG('LT_MYSTRM_PLS_ENTER_POSTCODE');
eleInput=dom.createElement('div',{className:'postcodeInputArea'});
eleLabel=dom.createElement('p',{className:'postcodeInputLabel'});
eleLabel.textContent=LANG('LT_POSTCODE');
eleValue=dom.createElement('div',{className:'postcodeInputValue'});
eleValueText=document.createElement('p');
eleValueText.appendChild(document.createElement('span'));
eleValueText.firstChild.textContent=this.getDisplayValue();
eleValue.appendChild(eleValueText);
eleInput.appendChild(eleLabel);
eleInput.appendChild(eleValue);
eleKeyArea=dom.createElement('div',{className:'postcodeKeyArea'});
eleKeyTemp=dom.createElement('span',{className:'postcodeKey'});
eleText=document.createElement('p');
for(row=0,rMax=this.keyList.length-1;row<rMax;row+=1){
eleKeyLine=dom.createElement('div',{className:'postcodeKeyLine'});
for(col=0,cMax=this.keyList[row].length;col<cMax;col+=1){
if(this.keyList[row][col]===false){
break;}
eleKey=eleKeyTemp.cloneNode(false);
text=String.fromCharCode(this.keyList[row][col]);
if(this.keyList[row][col]>=KeyEvent.DOM_VK_A&&
this.keyList[row][col]<=KeyEvent.DOM_VK_Z){
text.toUpperCase();}
eleKey.textContent=text;
eleKeyLine.appendChild(eleKey);}
eleKeyArea.appendChild(eleKeyLine);}
eleKeyLine=dom.createElement('div',{className:'postcodeKeyLine command'});
oldInfo=null;
for(col=0,cMax=this.keyList[this.commandRow].length;col<cMax;col+=1){
if(this.keyList[this.commandRow][col]!==false&&
this.keyList[this.commandRow][col]!==oldInfo){
eleKey=eleKeyTemp.cloneNode(false);
eleKey.textContent=this.keyList[this.commandRow][col].value;
eleKeyLine.appendChild(eleKey);}
oldInfo=this.keyList[this.commandRow][col];}
eleKeyArea.appendChild(eleKeyLine);
if(mystream.textDirection==='rtl'){
}
eleDialog.appendChild(eleHead);
eleDialog.appendChild(eleInput);
eleDialog.appendChild(eleKeyArea);
eleScreen.appendChild(eleDialog);
parent.appendChild(eleScreen);
this.eles={
screen:eleScreen,
dialog:eleDialog,
value:eleValueText.firstChild,
keys:eleKeyArea
};
this.focus=new domFocus.Focus(focus);
this.setFocus();
this.currentState=this.STATE.READY;
this.callback('open');
return this;};
PostcodeInput.prototype.setFocus=function(keyCode){
var row,col,rMax,cMax,eleKey,pos;
if(keyCode!==undefined){
for(row=0,rMax=this.keyList.length-1;row<rMax;row+=1){
for(col=0,cMax=this.keyList[row].length;col<cMax;col+=1){
if(keyCode===this.keyList[row][col]){
this.focusPos.row=row;
this.focusPos.column=col;
break;}
}
}
}
row=this.focusPos.row;
col=this.focusPos.column;
if(this.eles.keys.children[row]&&
this.eles.keys.children[row].children[col]){
this.focus.set(this.eles.keys.children[row].children[col]);}
return this;};
PostcodeInput.prototype.moveFocus=function(keyCode){
var row,col,target,cmdBtnInfo,index;
switch(keyCode){
case KeyEvent.DOM_VK_LEFT:
if(this.focusPos.row!==this.commandRow){
if(this.focusPos.column>0){
this.focusPos.column-=1;}else {
this.focusPos.column=this.keyList[this.focusPos.row].length-1;
target=this.keyList[this.focusPos.row][this.focusPos.column];
while(target===false){
this.focusPos.column-=1;
target=this.keyList[this.focusPos.row][this.focusPos.column];}
}
}else {
cmdBtnInfo=this.keyList[this.focusPos.row][this.focusPos.column];
switch(cmdBtnInfo.type){
case 'delete':
this.focusPos.column=9;
break;
case 'del_all':
this.focusPos.column=0;
break;
case 'ok':
this.focusPos.column=3;
break;
case 'cancel':
this.focusPos.column=6;
break;
default:
}
}
break;
case KeyEvent.DOM_VK_UP:
if(this.focusPos.row>0){
this.focusPos.row-=1;}else {
this.focusPos.row=this.keyList.length-1;}
target=this.keyList[this.focusPos.row][this.focusPos.column];
while(target===false){
this.focusPos.row-=1;
target=this.keyList[this.focusPos.row][this.focusPos.column];}
break;
case KeyEvent.DOM_VK_RIGHT:
if(this.focusPos.row!==this.commandRow){
if(this.focusPos.column<this.keyList[this.focusPos.row].length-1){
this.focusPos.column+=1;
target=this.keyList[this.focusPos.row][this.focusPos.column];
if(target===false){
this.focusPos.column=0;}
}else {
this.focusPos.column=0;}
}else {
cmdBtnInfo=this.keyList[this.focusPos.row][this.focusPos.column];
switch(cmdBtnInfo.type){
case 'delete':
this.focusPos.column=3;
break;
case 'del_all':
this.focusPos.column=6;
break;
case 'ok':
this.focusPos.column=9;
break;
case 'cancel':
this.focusPos.column=0;
default:
}
}
break;
case KeyEvent.DOM_VK_DOWN:
if(this.focusPos.row<this.keyList.length-1){
this.focusPos.row+=1;
target=this.keyList[this.focusPos.row][this.focusPos.column];
while(target===false){
this.focusPos.row+=1;
if(this.focusPos.row>this.keyList.length-1){
this.focusPos.row=0;
break;}
target=this.keyList[this.focusPos.row][this.focusPos.column];}
}else {
this.focusPos.row=0;}
break;
default:
}
row=this.focusPos.row;
col=this.focusPos.column;
if(row===this.commandRow){
col=this.keyList[this.focusPos.row][this.focusPos.column].index;}
if(this.eles.keys.children[row]&&
this.eles.keys.children[row].children[col]){
this.focus.move(this.eles.keys.children[row].children[col]);}
return this;};
PostcodeInput.prototype.updatePostcode=function(){
var that=this,message,callback,options,oldValue;
oldValue=mystream.msUtil.getPostCode();
if(mystream.serviceConfig.postcodeInclude===true){
if(this.value===oldValue){
if(this.value!==''){
this.callback('same');
return this;}
}else if(mystream.msUtil.setPostCode(this.value)===true){
if(this.value!==''){
this.callback('update');
return this;}else {
this.callback('clear');
}
}
}else {
if(this.value===oldValue){
this.callback('same');
return this;}else if(mystream.msUtil.setPostCode(this.value)===true){
if(this.value===''){
this.callback('clear');}else {
this.callback('update');}
return this;}
}
callback=function(type){
if(that.currentState===that.STATE.READY){
if(type==='yes'){
that.focus.on();}else {
that.close();}
}
};
message=LANG('LT_POSTCODE_INVALID');
options={textAlign:'center',size:'small',
textYes:LANG('LT_RETRY'),textNo:LANG('LT_CANCEL')};
mystream.dialogUI.open('postcode-error','yes-no',message,callback,options);
this.focus.off();
return this;};
PostcodeInput.prototype.getDisplayValue=function(){
var value=this.value;
if(this.hyphenIndex<0){
return value;}
if(value.length>=this.hyphenIndex){
value=value.slice(0,this.hyphenIndex)+'-'+
value.slice(this.hyphenIndex);}
return value;};
PostcodeInput.prototype.close=function(){
if(this.currentState===this.STATE.READY){
this.focus.off();
this.currentState=this.STATE.CLOSED;
this.remove();
this.callback('close');}
return this;};
PostcodeInput.prototype.remove=function(){
if(this.eles){
this.eles.value=null;
this.eles.keys=null;
this.eles.dialog=null;
this.eles.screen.parentNode.removeChild(this.eles.screen);
this.eles=this.eles.screen=null;}
return this;};
PostcodeInput.prototype.destroy=function(){
if(this.eles){
this.remove();}
this.msUtil=null;
if(this.focus){
this.focus.off();}
this.focus=null;
this.callback=null;
this.currentState=this.STATE.NOT_READY;
return this;};
PostcodeInput.prototype.keyDownHandler=function(event){
var chr,info;
if(this.currentState!==this.STATE.READY){
return this;}
switch(event.keyCode){
case KeyEvent.DOM_VK_BACK_SPACE:
this.close();
break;
case KeyEvent.DOM_VK_RETURN:
if(this.focus.currentState===domFocus.STATE.OFF){
return this;}
info=this.keyList[this.focusPos.row][this.focusPos.column];
if(this.focusPos.row!==this.commandRow){
this.addChar(info);}else {
if(info.type==='delete'||info.type==='del_all'){
this.removeChar(info.type);}else if(info.type==='ok'){
this.updatePostcode();}else {
this.close();}
}
break;
case KeyEvent.DOM_VK_LEFT:
case KeyEvent.DOM_VK_UP:
case KeyEvent.DOM_VK_RIGHT:
case KeyEvent.DOM_VK_DOWN:
if(this.focus.currentState!==domFocus.STATE.OFF){
this.moveFocus(event.keyCode);}
break;
default:
if((event.keyCode>=KeyEvent.DOM_VK_0&&
event.keyCode<=KeyEvent.DOM_VK_9)){
this.addChar(event.keyCode);
this.setFocus(event.keyCode);}else if(this.type==='ascii'){
if(event.keyCode>=KeyEvent.DOM_VK_A&&
event.keyCode<=KeyEvent.DOM_VK_Z){
this.addChar(event.keyCode,true);
this.setFocus(event.keyCode);}else if(event.keyCode===KeyEvent.DOM_VK_SPACE){
this.addChar(event.keyCode);
this.setFocus(event.keyCode);}
}
}
return this;};
PostcodeInput.prototype.addChar=function(keyCode,toUpper){
var chr;
if(this.value.length>=MAX_LENGTH){
return this;}
chr=String.fromCharCode(keyCode);
if(toUpper===true){
chr=chr.toUpperCase();}
this.value+=chr;
this.eles.value.textContent=this.getDisplayValue();
return this;};
PostcodeInput.prototype.removeChar=function(type){
if(this.value.length===0){
return this;}
if(type==='delete'){
this.value=this.value.slice(0,-1);}else {
this.value='';}
this.eles.value.textContent=this.getDisplayValue();
return this;};
mystream.POSTCODE_INPUT=PostcodeInput;}(window,DOMUTIL));
