var s = new stage ({});

//font_path = "PUDGoDp-regular";
//font_path = "PUDGoDp-bold";
//font_path = "IWATA_RG";

s.symbol = "uraepg";
s.in = [{"from": ["default"],}];

 /*var IS_MULTI_WINDOW  2:multi(2tuner) or 1:sinple multi(1tuner)  or 0:single mode */
var IS_MULTI_WINDOW;
var SINGLE_WIN=0, SINPLE_WIN=1, MULTI_WIN=2;
var TD = 0, BS = 1, CS1 = 2, CS2 = 3, INPUT = 4, HIKARI = 5;
var DVBS = 0, DVBC = 1, DVBT = 2, DVBIP = 3;
var base_png = "file:///usr/local/png/uraepg_background.png";
var base_cover_png = "file:///usr/local/png/uraepg_cover.png";
var nw_focus_png = "file:///usr/local/png/uraepg_tab_selected.png";
var title_name = gettext ("Pre-view");
var guide_enter_mes = gettext ("Swap");
var network_name = ["DVB-T","DVB-C","DVB-S","INPUT"];
var guide_blue_name = ["View\nView","Info\nInfo"];
var ONAIR_NET_COUNT = 5;
var MEDIA_INPUT_ID_HDMI1 = 14;
var MEDIA_INPUT_ID_DP = 12;
var top_epg_index = 0;
var epg_focus_index;
/* model */
var JP_MODEL = 0, UK_MODEL = 1, PAL_MODEL = 2;
var zapping_model = JP_MODEL;
var is_lang_ire = 0;

/* --------- font_size ------------------------------ */
var DEFAULT_F_SIZE = 24;  /* default */
var NW_FOCUS_F_SIZE = 33;
var NW_DEFAULT_F_SIZE = 21;  /* default */
var PTITLE_DEFAULT_F_SIZE = 24;
var SNAME_DEFAULT_F_SIZE = 22;
var TITLE_F_SIZE = 35;
/*--- component(object) ---*/
var uraepg_background;
var title_base;
var uraepg_program;
var button_list;
var aspect_cover = new container({});
var program_info = new container({});
var nw_button_list;
var rem_guide_list;
var focus_button_list;
/*--- button ---*/
var URAEPG_DRAW_COUNT = 7;
var URAEPG_LIST_COUNT = 9;
var FOCUS_NO = 4;
var current_list_no = 0;  //move
var BUTTON_POS_CH = 1, BUTTON_POS_SNAME = 2, BUTTON_POS_TITLE = 3;
var uraepg_button_list = new Array();
var GGUIDE_ON=1, GGUIDE_OFF=0;
var TAB_PNG=0, TAB_TEXT=1;
var epg_info_tmp = new Array();
var pos_list = new Array();
var nw_list = new Array();
var main_nw;
var main_inp_serv = 0;
var cursor_move = 0;  /* cursor move flg */
var change_nw_flg = 0; /* while nw change */
/*--- translate ---*/
var l_margin_leading = 2;
var p_info_margin_leading = 3;
var p_info_top_y = -270; // -(1080/4)
var p_info_width = 480+1; // 1920/4  +1:for HD panel
var p_info_height = 270+3;
var p_info_top_margin = 5;
var p_info_date_h = (DEFAULT_F_SIZE + p_info_margin_leading) * 2;
var p_info_date_y = -p_info_top_margin - (p_info_date_h/2);
var p_info_text_h = (DEFAULT_F_SIZE + p_info_margin_leading) * 7;
var p_info_text_y = -p_info_top_margin - p_info_date_h - (p_info_text_h/2);
var nw_button_margin = 105;
var nw_button_w = 185;
var title_x = -110;
var title_w = 270;

/* write back data */
var WING_COM_URAEPG = 1; /* jp model */
var WING_ID_URAEPG = 2; /* pal model */
var GWIN_COM_URAEPG = WING_COM_URAEPG;
var URAEPG_UPDOWN = 0, URAEPG_ENTER=1, URAEPG_NW_CHANGE=2, URAEPG_RECALL=3;
var URAEPG_BLUE=4, URAEPG_RETURN=5, URAEPG_CURSOR_RESET=6, URAEPG_GREEN=7, URAEPG_FILE_UPDATE=8;
var repeat_key = false;
var repeat_timer = false;

/* /tmp file data */
var epg_info = new Array();
var ONID=0, TSID=1, SID=2, CH=3, INDEX=4, TITLE=5, SNAME=6;
var epg_program_info = new Array();
var service_count;
var moto_service_count;
var current_service;  /* C */
var current_nw;       /* C */
var nw_useflg =  [0,0,0,0,0,0];;
var gguide;
var rec_flg2 = 0;
var rec_flg = 0;
var enter_cancel_flg = 0;
var sub_window;
var input_list = new Array();
var main_current_nw;

/* JS data */
var focus_service;    /* JS */
var focus_nw;         /* JS */
var last_service_list = ["","","","","",""]; /* TD, BS, CS1, CS2, HIKARI */
var delay_update = false;

//******* test data ***************
/*
epg_info = [[0, 0, 0, "100-1", "title0\nたいとるたいとるたいとる"],
	    [1, 1, 1, "110-3", "title1\nたいとるたいとるたいとる"],
	    [2, 2, 2, "160-3", "title2\nたいとるたいとるたいとる"],
	    [3, 3, 3, "161-3", "title3\nたいとるたいとるたいとる"],
	    [4, 4, 4, "185-3", "title4\nたいとるたいとるたいとる"],
	    [5, 5, 5, "221-3", "title5\nたいとるたいとるたいとる"],
	    [6, 6, 6, "222-3", "title6\nたいとるたいとるたいとる"],
	    [7, 7, 7, "223-3", "title7\nたいとるたいとるたいと"],
	    [8, 8, 8, "224-3", "title8\nたいとるたいとるたいと"],
	    [9, 9, 9, "229-2", "title9\nたいとるたいとるたいとる"]];

epg_program_info = {"160-3":{date:"10/14 10:00～11:00", info:"番組概要概要\n概要があるよ\n"},
		    "161-3":{date:"10/14 10:00～11:30", info:"番組概要2概要だよ\n概要があるよ\n"},
		   };
service_count = 10;
current_service = [2, 2, 2];
current_nw = CS2;
nw_useflg = [1,1,1,1,1];
gguide = 1;
rec_flg2 = 0;
sub_window = 0;
*/

/* --------- color ------------------------------ */
var COL_BLACK = [0, 0, 0, 255];
var COL_TITLE_TEXT = system.fdp_color.TEXT_ONBASE;
var COL_BG_BASE = system.fdp_color.BASE;
var COL_TAB_FOCUS = system.fdp_color.POINT;
var COL_BUTTON = system.fdp_color.BASE_SUB_A;
var COL_BTN_BORDER = system.fdp_color.BTN_BORDER;
var COL_EPG_TEXT = system.fdp_color.TEXT_SUB_ONBASE;
var COL_EPG_CH_TEXT = system.fdp_color.POINT;
var COL_EPG_SNAME_TEXT = system.fdp_color.POINT_ONBASE;
var COL_EPG_INFO_TEXT = system.fdp_color.TEXT_ONBASE;
var COL_EPG_INFO_BOX = COL_BG_BASE;
var COL_REM_BLUE = COL_EPG_INFO_TEXT;
var COL_REM_BLUE_REC = system.fdp_color.TEXT_ONBASE_A;
var NW_DEFAULT_COL = system.fdp_color.TEXT_SUB_ONBASE;
var NW_FOCUS_COL = system.fdp_color.TEXT_ONBASE;
var NW_SKIP_COL = system.fdp_color.TEXT_ONBASE_A;
var COL_ARROW = system.fdp_color.ICON_ONBASE;

//type: 0=date, 1=info
function get_program_info(type)
{
    var text = "";

    if((service_count > 0) && (epg_program_info[focus_service]))
    {
	switch (type){
	case 0:
	    if (epg_program_info[focus_service]["date"])
		text = epg_program_info[focus_service]["date"];
	    break;
	case 1:
	    if (epg_program_info[focus_service]["info"])
		text = epg_program_info[focus_service]["info"];
	    break;
	default:
	    break;
	}
    }
    return text;
}

function make_title_base ()
{
    var name_no = 0;

    if(focus_nw == HIKARI)
    {
	name_no = 1;
    }

    var base_cover =
    	new gbox ({"translate" : [0, 294-13+40, 0],
                   "height": 95+80,
                   "width": 480+1, // +1:for HD panel
		   "color" : COL_BG_BASE,
                   "visible_p" : true
                    });

    var title_text =
    	new gtext ({
	    "visible_p" : true,
	    "translate" : [title_x, 360, 0],
	    "width"     : title_w,
	    "height"    : 100,
	    "color"     : COL_TITLE_TEXT,
	    "text"      : title_name,
	    "font_size" : TITLE_F_SIZE,
	    "font_name" : font_name,
	    "margin"    : [0,0, 24,24],
	    "align"     : LEFT,});

    var title = new container
    ({  
	"translate" : [721, 136, 0 ],
        "components":[
	    base_cover,
	    title_text,
            ]
    });

    return title;
}

function change_nw(rl)
{
    var nw, cp, check_nw_list=0;

    for(cp=0; cp < ONAIR_NET_COUNT; cp++)
    {
    	if(nw_list[cp] == focus_nw)
    	{
    	    break;
    	}
    }

    switch (rl){
    case 0: /* R */
	if (cp >= nw_list.length-1){
	    nw = nw_list[0];
	}
	else{
	    nw = nw_list[cp +1];
	}
	break;
    case 1: /* L */
	if (cp <= 0){
	    nw = nw_list[nw_list.length-1];
	}
	else{
	    nw = nw_list[cp -1];
	}
	break;
    default:
	nw = cp;
	break;
    }

    return nw;
}

function make_nw_tab (nw, x, txt_w){
    //set default(unfocus)
    var font_col = NW_DEFAULT_COL;
    var font_size = NW_DEFAULT_F_SIZE;
    var focus_v = false;
    var png_w = txt_w - 65;  /* ONAIR DIGITAL */

    if (focus_nw == nw)
    {
	font_size = NW_FOCUS_F_SIZE;
	font_col = NW_FOCUS_COL;
	focus_v = true;
    }
    else if (nw_useflg[nw] == 0)
    {
	font_col = NW_SKIP_COL;
    }

    /* change nw_tab font size */
    if (is_lang_chinese == 1 && network_name[nw].length > 3)
    {
	font_size = Math.floor((NW_FOCUS_F_SIZE * 3.3) / network_name[nw].length);
	if (focus_nw != nw)
	    font_size -= 3;
    }
   else if (network_name[nw].length > 7)
    {
	font_size = Math.floor((NW_FOCUS_F_SIZE * 7) / network_name[nw].length);
	if (focus_nw != nw)
	    font_size -= 3;
    }

    /* HIKARI */
    if (focus_nw == HIKARI)
    {
	png_w = 200;
    }

    var tab_png = 
    	new gbox ({"translate" : [0, -22, 0],
		   "height": 5,
		   "width": png_w,
    		   "color" : COL_TAB_FOCUS,
		   "visible_p" : focus_v
                    });

    var tab_text =
    	new gtext ({
	    "visible_p" : true,
	    "width"     : txt_w,
	    "height"    : 100,
	    "color"     : font_col,
	    "text"      : network_name[nw],
	    "font_size" : font_size,
	    "font_name" : font_name,
	    "margin"    : [0,0, 24,24],
	    "align"     : CENTER,});
    
    var tab = new container
    ({  
	"translate": [x, 0, 0],
        "components":[
	    tab_png,
	    tab_text,]
    });

    return tab;
}

function make_nw_button_list ()
{
    var list = new Array();
    var tab_obj = new Array ();
    var nw_count = 0;
    var l_start_x = -160;
    var l_text_w = nw_button_w;
    var l_btn_margin = nw_button_margin;
    if (zapping_model == JP_MODEL)
	l_start_x = -155;

    if (focus_nw == HIKARI)
    {
	tab_obj[0] = make_nw_tab(HIKARI, 0, l_text_w);
    	list.push(tab_obj[0]);
    }
    else
    {
	for(var i=0; i < ONAIR_NET_COUNT; i++)
	{
    	    if((nw_useflg[i] == 1) || (focus_nw == i))
    	    {
    		//push (TD,BS,CS1,CS2)
    		nw_list.push(i);
    	    }
	    if(nw_useflg[i] != -1)
	    {
		if (zapping_model == PAL_MODEL && nw_useflg[DVBIP] != -1 && i < INPUT)
		{
		    l_text_w = 100;
		    l_btn_margin = 60;
		}
		else
		{
		    l_text_w = nw_button_w;
		    l_btn_margin = nw_button_margin;
		}
		if (nw_count == 0)
		    l_start_x = l_start_x;
		else
		    l_start_x += l_btn_margin;
		tab_obj[i] = make_nw_tab(i, l_start_x, l_text_w);
    		list.push(tab_obj[i]);
		nw_count++;
	    }
	}
    }

    var nw_l = new container
    ({  
    	"translate": [720, 420+10,0 ],
        "components":
	list,
    });

    return nw_l;
}

function make_nw_button_cursor ()
{
    var arrow_v = false;

    // 1network => not draw arrow
    if (nw_list.length > 1)
    {
    	arrow_v = true;
    }

    var nw_arrow_disable_l =
	new gimage ({"src": "file:///usr/local/png/uraepg_tab_arrow_l.png",
		     "translate" : [-220,0,0],
		     "width" : 14,
		     "height" : 30,
		     "color" : COL_ARROW,
		     "visible_p" : true,
		    });
    var nw_arrow_disable_r =
	new gimage ({"src": "file:///usr/local/png/uraepg_tab_arrow_r.png",
		     "translate" : [155+70,0,0],
		     "width" : 14,
		     "height" : 30,
		     "color" : COL_ARROW,
		     "visible_p" : true,
		    });

    var nw_c = new container
    ({  
    	"translate": [720, 420+10,0 ],
	"visible_p": arrow_v,
        "components":[
	    nw_arrow_disable_l,
	    nw_arrow_disable_r,
	]	
    });

    return nw_c;
}

function update_nw_tab ()
{
    nw_list.length = 0;

    for(var i=0; i < ONAIR_NET_COUNT; i++)
    {
    	if((nw_useflg[i] == 1) || (focus_nw == i))
    	{
    	    //push (TD,BS,CS1,CS2)
    	    nw_list.push(i);
    	}
	
    }
    update_nw_button_list(ONAIR_NET_COUNT);//nw_list.length);
}

function get_ch_name(pos, ch_name)
{
    var ch_title = [ch_name,""];
    if (pos == 3)
    {
	var index = ch_name.indexOf("-");
	if (index != -1)
	{
	    ch_title = ch_name.split("-");
	    ch_title[1] = "-" + ch_title[1];
	}
    }

    return ch_title;
}

function make_button (i, list_no)
{
    var ch_title_text = "";
    var program_title_name = "";
    var service_name = "";
    var ch_font_col = COL_EPG_CH_TEXT;
    var title_font_col = COL_EPG_TEXT;
//    var sname_font_col = [250,200,160,255];  //orange
//    var sname_font_col = [250,200,225,255];  //pink
//    var sname_font_col = [230,249,217,255];  //green
//    var sname_font_col = [178, 235, 250, 255]; //COL_EPG_CH_TEXT; //[153,204,255,255];
    var sname_font_col = COL_EPG_SNAME_TEXT;
    var title_font = button_list.title_font;
    var sname_font = button_list.sname_font;
    var w_list = 330+40*2-20;
    var x_list = [160, 160, 160, 160];
    var draw_flg = false;
    var p; /* pos_list No */
    var title_h = (button_list.title_font*2)+l_margin_leading+10;
    var l_margin = [0,0, 20,20];
    if (zapping_model == JP_MODEL || current_nw == INPUT)
    {
	l_margin_leading = 4;
	title_h = (button_list.title_font*2)+l_margin_leading;
	l_margin = [0,0, 24,24];
    }
    if (current_nw == INPUT)
	title_font = DEFAULT_F_SIZE;


    //data nothing
    if (service_count <= 0)
    {
	draw_flg = true;
	p = i;
    }
    else /* service_count > 0 */
    {
	draw_flg = true;
	p = i;

	if (list_no < 0 && service_count < FOCUS_NO)
	{
	    if (service_count == 1)
	    {
		list_no = 0;
	    }
	    else
	    {
		list_no = (list_no * (-1)) % service_count;
	    }
	}

 	if (current_nw != INPUT)
 	{
 	    program_title_name = epg_info[list_no][TITLE];
 	    ch_title_text = epg_info[list_no][CH];
	    service_name = epg_info[list_no][SNAME];
 	}
 	else
 	{
 	    program_title_name = input_list[list_no][1];
 	}
    }

    var uraepg_button =
	new gbox ({"translate" : [120+1, 0, 0],
		   "width" : 480,
		   "height": 78,
		   "color" : COL_BUTTON,
		   "visible_p" : true
		  });
    var ch_title =
	new gtext ({
            "visible_p" : true,
            "translate" : [-65, 0, 0],
            "width"     : 150,
            "height"    : 200,
            "color"     : ch_font_col,
            "text"      : ch_title_text,
            "font_size" : 30,
	    "font_name" : font_name,
            "margin"    : [0,0, 24,24],
            "align"     : CENTER,});

    if (zapping_model == JP_MODEL || current_nw == INPUT)
    {
	var program_title =
	    new gtextbox ({
		"visible_p" : true,
		"translate" : [160, -1, 0],
		"width"     : w_list,
		"height"    : title_h,
		"color"     : title_font_col,
		"text"      : program_title_name,
		"font_size" : title_font,
		"font_name" : font_name,
		"word_break": 1,
		"margin_leading": l_margin_leading,
		"margin"    : l_margin,
		"align"     : LEFT,});
    }
    else
    {
	var sname =
	    new gtext ({
		"visible_p" : true,
		"translate" : [160, 13, 0],
		"width"     : w_list,
		"height"    : title_h,
		"color"     : sname_font_col,
		"text"      : service_name,
		"font_size" : sname_font,
		"font_name" : font_name,
		"margin"    : l_margin,
		"align"     : LEFT,});
	var program_title =
	    new gtext ({
		"visible_p" : true,
		"translate" : [160, -13, 0],
		"width"     : w_list,
		"height"    : title_h,
		"color"     : title_font_col,
		"text"      : program_title_name,
		"font_size" : title_font,
		"font_name" : font_name,
		"margin"    : l_margin,
		"align"     : LEFT,});
    }

    var button_y = button_list.invisible_pos;
    if (draw_flg == true || p == 0)
    {
	button_y = 80-80*p;
    }

    if (zapping_model == JP_MODEL || current_nw == INPUT)
    {
	var button_group = new container
	({  
	    "translate": [0, button_y, 0],
	    "visible_p": draw_flg,
            "components":[
		uraepg_button,
		ch_title,
		program_title,
	    ]
	});
    }
    else
    {
	var button_group = new container
	({  
	    "translate": [0, button_y, 0],
	    "visible_p": draw_flg,
            "components":[
		uraepg_button,
		ch_title,
		sname,
		program_title,
	    ]
	});
    }

    return button_group;
}

//make draw position list (add epg_info[pos])
function make_pos_list()
{
    var current_list_no = 0;
    var pos_num = 0;

    //pos_list init
    pos_list = [];
    pos_list.length = 0;

    /* get current list no */
    for(var i=0; i < service_count; i++)
    {
 	if (current_nw != INPUT)
  	{
 	    if (epg_info[i][CH] == focus_service)
 	    {
 		current_list_no = parseInt(i);
 		break;
 	    }
 	}
 	else
 	{
 	    if (input_list[i][0] == focus_service)
 	    {
 		current_list_no = parseInt(i);
 		break;
 	    }
  	}
    }

    if ( current_list_no < FOCUS_NO)
    {
	pos_num = epg_info_tmp.length - FOCUS_NO + current_list_no;
    }
    else
    {
	pos_num = current_list_no - FOCUS_NO;
    }

    for (var i=0; i < URAEPG_LIST_COUNT; i++)
    {
	if (pos_num < 0)
	{
	    pos_num = epg_info_tmp.length - 1;
	}
	else if(pos_num > epg_info_tmp.length-1)
	{
	    pos_num = 0;
	}
	pos_list[i] = pos_num;
	pos_num++;
    }
    var tmp_focus_index = 0;
    top_epg_index = 0;
    for(var i=0; i < service_count; i++)
    {
 	if (current_nw != INPUT)
  	{
	    if (epg_info[i][CH] == focus_service)
	    {
		tmp_focus_index = parseInt(i);
		break;
	    }
	}
 	else
 	{
 	    if (input_list[i][0] == focus_service)
	    {
		tmp_focus_index = parseInt(i);
		break;
	    }
	}
    }
    top_epg_index = tmp_focus_index - FOCUS_NO;
    if (top_epg_index < 0){
	top_epg_index = service_count + top_epg_index;
    }
}

function reset_epg_index(focus_index){
    epg_focus_index = focus_index;
    top_epg_index = epg_focus_index - FOCUS_NO;
    if (top_epg_index < 0){
	top_epg_index = service_count + top_epg_index;
    }
}


function set_top_epg_index(is_up){
    if (is_up == false){
	top_epg_index++;
	if (top_epg_index == service_count){
	    top_epg_index = 0;
	}
    }
    else{
	top_epg_index--;
	if(top_epg_index < 0){
	    top_epg_index = service_count-1;
	}
    }
    return top_epg_index;
}
function get_top_epg_index(index){
    var ret_index = top_epg_index+index;
    if (ret_index >= service_count){
	ret_index = ret_index - service_count;
    }
    return ret_index;
}
function make_epg_info_tmp()
{
    var num = service_count;
    var count=1;

    //epg_info_tmp init
    epg_info_tmp = [];
    epg_info_tmp.length = 0;

    while(num < URAEPG_LIST_COUNT)
    {
	num = service_count * count;
	count++;
    }
    for(var i=0; i < num; i++)
    {
	if(service_count < URAEPG_LIST_COUNT)
	{
	    epg_info_tmp[i] = i%service_count;
	}
	else
	{
	    epg_info_tmp[i] = i;
	}
    }
}

button_list = new container({});
button_list.init = function()
{
    var _this = this;

    this.cur_index = 0;
    if (zapping_model == JP_MODEL)
	this.title_font = DEFAULT_F_SIZE;
    else
	this.title_font = PTITLE_DEFAULT_F_SIZE;
    this.sname_font = SNAME_DEFAULT_F_SIZE;
    this.invisible_pos = 160;
    this.moving = false;
    //cursor pos
    this.gap = 80;
    this.move_time = 25; //5
    this.move_count = 5; //20
    this.up_pos = -1;
    this.pos_y = 332;
    this.dst_y = this.pos_y;
}
button_list.create = function(focus_service)
{
    var _this = this;

    var prg_button_obj = new Array ();

    //create pos_list
    if (service_count > 0)
    {
	make_epg_info_tmp();
	make_pos_list();
    }
    
    if (service_count == 0)
    {
	for (var i=0; i < URAEPG_LIST_COUNT; i++)
	{
	    prg_button_obj[i] = make_button(i, 0);
    	    uraepg_button_list.push(prg_button_obj[i]);
	}
    }
    else
    {
	var tmp_index = top_epg_index;
	for (var i=0; i < URAEPG_LIST_COUNT; i++)
	{
	    if(tmp_index == service_count){
		tmp_index = 0;
	    }
	    prg_button_obj[i] = make_button(i, tmp_index);
    	    uraepg_button_list.push(prg_button_obj[i]);
	    tmp_index++;
	}
	epg_focus_index = top_epg_index + FOCUS_NO;
	if(epg_focus_index >= service_count){
	    epg_focus_index = epg_focus_index - service_count;
	}
	update_focus_service ();
    }

    this.translate = [600, this.pos_y,0 ];
    this.components = uraepg_button_list;
}

button_list.move = function(updown, y, dis_pos) {
    if (this.moving != false) {
      for (var a = 0; a < URAEPG_LIST_COUNT; a++){
        button_list.components[a].translate[1] = 80-80*a;
      }
      if (updown == 0) { //up
        update_pos_list(TXK_UP);
      } else {
        update_pos_list(TXK_DOWN);
      }
    }

    for(var i=0; i < URAEPG_LIST_COUNT; i++)
    {
	if (i == dis_pos)
	    button_list.components[i].visible_p = false;
	else
	    button_list.components[i].visible_p = true;
    }
    this.moving = true;
    this.COUNT = this.move_count-1;

    if (updown == 0) //up
    {
	this.dst_offset = this.gap * -1;
    }
    else //down
    {
	this.dst_offset = this.gap;
    }

    delete_timer(this);
    this.effect (this, 0);
    append_timer(this, this.move_time, this.effect);
}
button_list.effect = function(obj, count) {
    if (count == this.COUNT) {
	delete_timer(obj);
	this.moving = false;
	for (var i = 0; i < URAEPG_LIST_COUNT; i++){
	    this.components[i].translate[1] = 80-80*i;
	}
	if (this.dst_offset < 0){
	    update_pos_list(TXK_UP);
	}
	else{
	    update_pos_list(TXK_DOWN);
	}
    } else {
	for (var i = 0; i < URAEPG_LIST_COUNT; i++){
	    this.components[i].translate[1] += (this.dst_offset)/this.COUNT;
	}
    }
    force_redraw();
};

aspect_cover.create = function()
{
    var _this = this;

    this.translate = [720,-426,0 ];  //1680/8 = 210, -840+210=-630
    this.components = [
            new gbox({
		"translate" : [-209, 0, 0],
		"visible_p" : true,
		"height": 300,
		"width" : 60, 
		"color" : COL_BLACK,}),
            new gbox({
		"translate" : [211, 0, 0],
		"visible_p" : true,
		"height": 300,
		"width" : 60,
		"color" : COL_BLACK,}),
    ];
};

program_info.create = function(p_info_visible)
{
    var _this = this;
    var p_date_text = "", p_info_text = "";
    if(p_info_visible == true)
    {
	p_date_text = get_program_info(0);
	p_info_text = get_program_info(1);
    }

    this.translate = [720+1, p_info_top_y, 0];
    this.components = [
            new gbox({
		"translate" : [0, -(p_info_height/2), 0],
		"visible_p" : true,
		"height": p_info_height,
		"width" : p_info_width,
		"color" : COL_EPG_INFO_BOX,}),
    this.text_date = new gtextbox ({
		"translate" : [0, p_info_date_y, 0],
		"visible_p" : true,
		"width"     : p_info_width,
		"height"    : p_info_date_h,
		"color"     : COL_EPG_INFO_TEXT,
		"text"      : p_date_text,
		"font_size" : DEFAULT_F_SIZE,
 		"font_name" : font_name,
		"word_break": 1,
		"margin_leading": p_info_margin_leading,
		"margin"    : [0,0, 24,24],
		"align"     : LEFT,}),
    this.text_info = new gtextbox ({
		"translate" : [0, p_info_text_y, 0],
		"visible_p" : true,
		"width"     : p_info_width,
		"height"    : p_info_text_h+1,
		"color"     : COL_EPG_INFO_TEXT,
		"text"      : p_info_text,
		"font_size" : DEFAULT_F_SIZE,
		"font_name" : font_name,
		"word_break": 1,
		"margin_leading": p_info_margin_leading,
		"margin"    : [0,0, 24,24],
		"align"     : LEFT,}),
    ];
};

rem_guide_list = new container({});
rem_guide_list.create = function()
{
    var _this = this;
    var blue_guide = sub_window;
    var blue_color = COL_REM_BLUE;
    var blue_visible = true;
    var green_visible = true;
    var blue_png_x =  -190;
    var green_png_x = -190;
    var ok_text_x = blue_text_x =green_text_x = 30;
    var return_visible = false;
    var guide_x_margin = -20;
    var guide_x_margin0 = -10;
    var g_png_y1 = 25;
    var green_png_y = -3; 
    var blue_png_y = -29;
    var blue_png_path = "file:///usr/local/png/m_widget3/rem_guide_blue.png";
    var green_png_path = "file:///usr/local/png//m_widget3/rem_guide_green.png";
    var ok_png = "file:///usr/local/png/rem_guide_zap_ok.png";
    var tmp_x;
    if (zapping_model == JP_MODEL)
    {
	g_png_y1 = green_png_y = blue_png_y = 0;
	blue_png_x =  80;
	blue_text_x = 330;
	green_png_x = -80;
	green_text_x = 170;
	ok_text_x = 50;
	blue_png = "file:///usr/local/png/m_widget3/color_guide_blue_jp.png";
	green_png = "file:///usr/local/png/m_widget3/color_guide_green_jp.png";
	ok_png = "file:///usr/local/png/rem_guide_kettei_osusume.png";
	tmp_x = blue_png_x;
	blue_png_x = green_png_x;
	green_png_x = tmp_x;
	tmp_x = blue_text_x;
	blue_text_x = green_text_x;
	green_text_x = tmp_x;

	this.ok_text = new gtextbox ({
	    "translate" : [ok_text_x+guide_x_margin0, 0, 0],
	    "visible_p" : true,
	    "width"     : 500,
	    "height"    : 30*10,
	    "color"     : COL_EPG_INFO_TEXT,
	    "text"      : guide_enter_mes,
	    "font_size" : DEFAULT_F_SIZE,
	    "font_name" : font_name,
	    "margin"    : [0,0, 24,24],
	    "align"     : LEFT,}),
	//blue text
	this.blue_text = new gtext ({
	    "translate" : [blue_text_x+guide_x_margin, 0, 0],
	    "visible_p" : blue_visible,
	    "width"     : 500,
	    "height"    : 30*10,
	    "color"     : blue_color,
	    "text"      : guide_blue_name[blue_guide],
	    "font_size" : DEFAULT_F_SIZE,
	    "font_name" : font_name,
	    "margin"    : [0,0, 24,24],
	    "align"     : LEFT,});
	this.green_text = new gtext ({
	    "translate" : [green_text_x+guide_x_margin, 0, 0],
	    "visible_p" : green_visible,
	    "width"     : 500,
	    "height"    : 30*10,
	    "color"     : COL_EPG_INFO_TEXT,
//	    "text"      : "２画面で見る",
	    "text"      : gettext("Change view"),
	    "font_size" : DEFAULT_F_SIZE,
	    "font_name" : font_name,
	    "margin"    : [0,0, 24,24],
	    "align"     : LEFT,});
    }
    else
    {
	this.ok_text = new gtextbox ({
	    "translate" : [ok_text_x+guide_x_margin0, g_png_y1, 0],
	    "visible_p" : true,
	    "width"     : 440,
	    "height"    : DEFAULT_F_SIZE+10,
	    "color"     : COL_EPG_INFO_TEXT,
	    "text"      : guide_enter_mes,
	    "font_size" : DEFAULT_F_SIZE,
	    "font_name" : font_name,
	    "margin"    : [0,0, 24,24],
	    "align"     : LEFT,});
	this.blue_text = new gtextbox ({
	    "translate" : [blue_text_x+guide_x_margin0, blue_png_y, 0],
	    "visible_p" : blue_visible,
	    "width"     : 440,
	    "height"    : DEFAULT_F_SIZE+10,
	    "color"     : blue_color,
	    "text"      : guide_blue_name[blue_guide],
	    "font_size" : DEFAULT_F_SIZE,
	    "font_name" : font_name,
	    "margin"    : [0,0, 24,24],
	    "align"     : LEFT,});
	this.green_text = new gtextbox ({
	    "translate" : [green_text_x+guide_x_margin0, green_png_y, 0],
	    "visible_p" : green_visible,
	    "width"     : 440,
	    "height"    : DEFAULT_F_SIZE+10,
	    "color"     : COL_EPG_INFO_TEXT,
	    "text"      : gettext("Change view"),
	    "font_size" : DEFAULT_F_SIZE,
	    "font_name" : font_name,
	    "margin"    : [0,0, 24,24],
	    "align"     : LEFT,});
    }

    if (IS_MULTI_WINDOW == SINGLE_WIN)
    {
	guide_x_margin = 0;
	guide_x_margin0 = 0;
	blue_visible = false;
	green_visible = false;
	return_visible = true;
    }	
    else if ((rec_flg == 1) || (focus_nw == HIKARI) || (focus_nw == INPUT))
    {
    	blue_guide = 0; /* eizou */
    	blue_color = COL_REM_BLUE_REC;
 	this.blue_text.color = blue_color;
    }

    this.translate = [720,-228,0 ];  //1680/8 = 210, -840+210=-630
    this.components = [
        new gbox ({"translate" : [1, -1, 0],
                   "height": 84, //90
                   "width": 480, // +1:for HD panel
		   "color" : COL_BG_BASE,
                   "visible_p" : true
                    }),
	new gimage ({"src": ok_png,
		     "translate" : [-200+guide_x_margin0, g_png_y1,0],
		     "width" : 30,
		     "height": 30,
		     "visible_p" : true,
		    }),
	this.ok_text,
	//return
	new gimage ({"src": "file:///usr/local/png/RemGuide_exit.png",
		     "translate" : [-60, 0,0],
		     "width" : 30,
		     "height": 30,
		     "visible_p" : return_visible,
		    }),
	new gtext ({
	    "translate" : [190, g_png_y1, 0],
	    "visible_p" : return_visible,
	    "width"     : 500,
	    "height"    : 30*10,
	    "color"     : COL_EPG_INFO_TEXT,
	    "text"      : "戻る",
	    "font_size" : DEFAULT_F_SIZE,
	    "font_name" : font_name,
	    "margin"    : [0,0, 24,24],
	    "align"     : LEFT,}),
	//blue, green
	new gimage ({"src": blue_png_path,
		     "translate" : [blue_png_x+guide_x_margin, blue_png_y, 0],
		     "width": 40,
		     "height": 40,
		     "visible_p" : blue_visible,
		    }),
	this.blue_text,
	new gimage ({"src": green_png_path,
		     "translate" : [green_png_x+guide_x_margin, green_png_y, 0],
		     "width": 40,
		     "height": 40,
		     "visible_p" : green_visible,
		    }),
	this.green_text,
    ];
};

focus_button = new container({});
focus_button.create = function()
{
    var _this = this;

    this.translate = [600, 350,0 ];
    this.components = [
    	new gimage ({"src": "file:///usr/local/png/uraepg_focus.png",
    		     "width" : 476,
    		     "height" : 78,
    		     "translate" : [120, -80*3-20+2, 0],
    		     "visible_p" : true,
    		    }),
    ];
};

uraepg_background = new container({});
uraepg_background.create = function()
{
    var _this = this;

    this.translate = [721, 136,0 ];
    this.components = [
	new gbox ({"translate" : [0, 0, 0],
                   "height": 814,
                   "width": 480 + 1,
    		   "color" : COL_BTN_BORDER,
                   "visible_p" : true
    		    })
    ];
};

/* ---------------- update --------------------- */
function update_nw_button_list(list_count)
{
    var l_nw = 0, r_nw = 0;
    var nw_cur = 0;

    if (list_count <= 1)
    {
	return 0;
    }

    // set defalt tab
    for (var i = 0; i < list_count; i++)
    {
	if (nw_useflg[i] == 1)
	{
	    var nw_blist = nw_button_list.components[nw_cur];
	    var nw_text = nw_blist.components[TAB_TEXT].text;
	    /* change nw_tab font size */
	    if(is_lang_chinese == 1 && nw_text.length > 3)
	    {
		font_size = Math.floor((NW_FOCUS_F_SIZE * 3.3) / nw_text.length);
		if (i != focus_nw)
		    font_size -= 3;
	    }
	    else if (nw_text.length > 7)
	    {
		font_size = Math.floor((NW_FOCUS_F_SIZE * 7) / nw_text.length);
		if (i != focus_nw)
		    font_size -= 3;
	    }
	    else
	    {
		font_size = NW_DEFAULT_F_SIZE;
		if (i == focus_nw)
		    font_size = NW_FOCUS_F_SIZE;
	    }

	    if (((IS_MULTI_WINDOW == SINGLE_WIN) && 
		 (nw_useflg[i] == 0) && (i != main_nw))
		|| ((IS_MULTI_WINDOW != SINGLE_WIN) && (nw_useflg[i] == 0)))
	    {
		if (nw_blist.components[TAB_TEXT].color != NW_SKIP_COL)
		{
		    nw_blist.components[TAB_TEXT].color = NW_SKIP_COL;
		    nw_blist.components[TAB_TEXT].font_size = font_size;
		    setf_text(nw_blist.components[TAB_TEXT], nw_blist.components[TAB_TEXT].text);
		    nw_blist.components[TAB_PNG].visible_p = false;
		}
	    }
	    else if (i == focus_nw)
	    {
		//change focus
		if (nw_blist.components[TAB_TEXT].color != NW_FOCUS_COL)
		{
		    //change focus
		    nw_blist.components[TAB_TEXT].color = NW_FOCUS_COL;
		    nw_blist.components[TAB_TEXT].font_size = font_size;
		    setf_text(nw_blist.components[TAB_TEXT], nw_blist.components[TAB_TEXT].text);
		    nw_blist.components[TAB_PNG].visible_p = true;
		}
	    }
	    else if (nw_blist.components[TAB_TEXT].color != NW_DEFAULT_COL)
	    {
		//change default focus
		nw_blist.components[TAB_TEXT].color = NW_DEFAULT_COL;
		nw_blist.components[TAB_TEXT].font_size = font_size;
		setf_text(nw_blist.components[TAB_TEXT], nw_blist.components[TAB_TEXT].text);
		nw_blist.components[TAB_PNG].visible_p = false;
	    }
	    nw_cur++;
	}
	else if (nw_useflg[i] == 0)
	{
	    nw_cur++;
	}
    }
    force_redraw();
}

button_list.update = function()
{
    var _this = this;

    //update ch/title
    this.components.length = 0;
    delete this.components;
    s.components[10]=0;
	    
    this.create(focus_service);
    this.dst_y = this.pos_y;  //init dst_y
    this.visible_p = true;
	    
    s.components[10]=button_list;
    force_redraw();
}

function update_button_list_data()
{
    for (var i = 0; i < URAEPG_LIST_COUNT; i++)
    {
    	pos = get_top_epg_index(i);
    	if(epg_info[pos])
    	{
    	    if (button_list.components[i].components[BUTTON_POS_CH].text != epg_info[pos][CH])
    	    {
    		setf_text(button_list.components[i].components[BUTTON_POS_CH], epg_info[pos][CH]);
    	    }
    	    if (button_list.components[i].components[BUTTON_POS_SNAME].text != 
    		epg_info[pos][SNAME])
    	    {
    		setf_text(button_list.components[i].components[BUTTON_POS_SNAME], 
    			  epg_info[pos][SNAME]);
    	    }
    	    if (button_list.components[i].components[BUTTON_POS_TITLE].text != 
    		epg_info[pos][TITLE])
    	    {
    		setf_text(button_list.components[i].components[BUTTON_POS_TITLE], 
    			  epg_info[pos][TITLE]);
    	    }
    	}
    }
    force_redraw();
}

function update_program_info()
{
   /* change program info */
    var p_date_text = get_program_info(0);
    if (program_info.text_date.text != p_date_text)
    {
    	setf_text(program_info.text_date, p_date_text);
    }

    var p_info_text = get_program_info(1);
    if (program_info.text_info.text != p_info_text) 
    {
    	setf_text(program_info.text_info, p_info_text);
    }
    force_redraw();
}

function update_focus_service ()
{
    //update focus_service
    if (current_nw == INPUT)
    {   
	if(input_list && input_list[epg_focus_index])
            focus_service = input_list[epg_focus_index][0];
    }
    else
    {   
	if(epg_info[epg_focus_index])
            focus_service = epg_info[epg_focus_index][CH];
    }
}

function update_pos_list(key)
{
    for(var i=0; i<uraepg_button_list.length;i++){
	switch (key) {
	case TXK_UP:
	    uraepg_button_list[i].translate[1] -= 80;
	    break;
	case TXK_DOWN:
	    uraepg_button_list[i].translate[1] += 80;
	    break;
	}
    }
    var prg_button_obj;
    switch (key) {
    case TXK_UP:
	set_top_epg_index(true);
	set_epg_focus_index(true);
	uraepg_button_list.pop(); //delete bottom
	prg_button_obj = make_button(0, top_epg_index);
	uraepg_button_list.unshift(prg_button_obj); //add top
	break;
    case TXK_DOWN:
	set_top_epg_index(false);
	set_epg_focus_index(false);
	uraepg_button_list.shift(); //delete top
	prg_button_obj = make_button((URAEPG_LIST_COUNT - 1), set_epg_info_bottom());
	uraepg_button_list.push(prg_button_obj); //add botton
	break;
    }
    
    update_focus_service();
    if (IS_MULTI_WINDOW == SINGLE_WIN)
      update_program_info();
    else
      change_sub_window_no_input();
}
function set_epg_focus_index(is_up){
    if (is_up == false){
	epg_focus_index++;
	if (service_count == epg_focus_index){
	    epg_focus_index = 0;
	}
    }
    else{
	epg_focus_index--;
	if (0 > epg_focus_index){
	    epg_focus_index = service_count - 1;
	}
    }
}
function set_epg_info_bottom(){
    var tmp_index = top_epg_index + (URAEPG_LIST_COUNT - 1);
    while (tmp_index >= service_count){
	tmp_index = tmp_index - service_count;
    }
    return tmp_index;
}

/* ------------------- */
// cursor scroll
function cursor_updown(key)
{
    var start_pos = 0;
    var end_pos = URAEPG_LIST_COUNT - 1;

    cursor_move = 1; 
    switch (key) {
    case TXK_UP:
	button_list.move(0, (button_list.moving) ? button_list.dst_y : button_list.translate[1], end_pos);
	break;
    case TXK_DOWN:
	button_list.move(1, (button_list.moving) ? button_list.dst_y : button_list.translate[1], start_pos);
	break;
    default:
	break;
    }
    force_redraw();
    cursor_move = 0;
}

function change_sub_window(rec_change)
{
    var set_program_info = function()
    {
	program_info.visible_p = true;
	update_program_info();
    }

    /* change program info */
    if (rec_flg == 1)
    {
	set_program_info();
 	rem_guide_list.blue_text.color = COL_REM_BLUE_REC;
 	setf_text(rem_guide_list.blue_text, guide_blue_name[0]);
    }
    else 
    {
	if (rec_change == 1)
	{
	    if (sub_window == 1) /* picture */
	    {
		program_info.visible_p = false;
	    }
	    else  /* program info */
	    {
		set_program_info();
	    }
	}
	else
	{
	    if (sub_window == 1) /* picture => program info */
	    {
		sub_window = 0;
		set_program_info();
	    }
	    else  /* program info => picture */
	    {
		sub_window = 1;
		program_info.visible_p = false;
	    }
	}

	//change rem guide(blue)
	rem_guide_list.blue_text.color = COL_REM_BLUE;
	setf_text(rem_guide_list.blue_text, guide_blue_name[sub_window]);
    }
    force_redraw();
}

function check_ext_tune ()
{
    if((current_nw == INPUT)
       && ((focus_service >= MEDIA_INPUT_ID_HDMI1)
	   || (focus_service == MEDIA_INPUT_ID_DP)))
 	return 0;
    return 1;
}
 
function change_sub_window_no_input()
{
    var info_mes = gettext("External input is in use.");
    if (zapping_model == JP_MODEL)
	info_mes = "外部入力使用中";

    if (IS_MULTI_WINDOW == SINGLE_WIN)
  	return ret_val;
     
    //console.log("focus_nw:", focus_nw ," main_nw:", main_nw, " focus_service:", focus_service);
    /* change program info */
    if (((focus_nw == INPUT) && (main_nw == INPUT))
 	|| (!check_ext_tune())) /* 8: video2 */
    {
	if (focus_service == MEDIA_INPUT_ID_DP)
	{
	    if (zapping_model == JP_MODEL)
		info_mes = "DisplayPort入力は表示できません";
	    else
		info_mes = gettext ("DisplayPort cannot be displayed."); /* LT_MW_DP_MES */
	}
	else if (focus_service >= MEDIA_INPUT_ID_HDMI1)
	{
	    if (zapping_model == JP_MODEL)
		info_mes = "ＨＤＭＩ入力は表示できません";
	    else
		info_mes = gettext ("HDMI cannot be displayed."); /* LT_MW_HDMI_MES */
	}

 	program_info.visible_p = true;
 	//change rem guide(blue) and font(gray out)
 	rem_guide_list.blue_text.color = COL_REM_BLUE_REC;
 	setf_text(rem_guide_list.blue_text, guide_blue_name[sub_window]);
 	
 	setf_text(program_info.text_date, "");
 	setf_text(program_info.text_info, info_mes);
    }
    else if (((IS_MULTI_WINDOW == SINPLE_WIN) 
     	      && ((focus_nw != INPUT) && (main_nw != INPUT)))
	     || focus_nw == INPUT)
    {
 	//change rem guide(blue) and font(gray out)
 	rem_guide_list.blue_text.color = COL_REM_BLUE_REC;
 	setf_text(rem_guide_list.blue_text, guide_blue_name[sub_window]);
 	if (IS_MULTI_WINDOW == MULTI_WIN)
	{
 	    program_info.visible_p = false;
	}
    }
    else
    {
	change_sub_window(1);
    }
    force_redraw ();
}

function update_current_nw(key)
{
    var nw_change = 0;
    
    if(focus_nw == HIKARI)
    {
	return nw_change;
    }

    switch (key) {
    case TXK_LEFT:
	if(nw_list.length <= 1)
	{
	    nw_change = 2;
	}
	else
	{
	    focus_nw = change_nw(1);
	    nw_change = 1;
	}
	break;
    case TXK_RIGHT:
	if(nw_list.length <= 1)
	{
	    nw_change = 2;
	}
	else
	{
	    focus_nw = change_nw(0);
	    nw_change = 1;
	}
	break;
    case TXK_NET_TD:
    	if (nw_useflg[TD] == 1) 
    	{
    	    focus_nw = TD;
    	    nw_change = 1;
    	}
        else
        {
            if ( main_nw == TD ) {
    		focus_nw = TD;
                nw_change = 1;
            } else {
    	        nw_change = 2;
            }
        }
    	break;
    case TXK_NET_BS:
        if (nw_useflg[BS] == 1) 
    	{
    	    focus_nw = BS;
    	    nw_change = 1;
    	}
        else
        {
            if ( main_nw == BS ) {
    		focus_nw = BS;
                nw_change = 1;
            } else {
    	        nw_change = 2;
            }
        }
    	break;
    case TXK_NET_CS:
        if (nw_useflg[CS1] == 1)
    	{
    	    if(focus_nw == CS1)
    	    {
    		focus_nw = CS2;
    	    }
    	    else
    	    {
    		focus_nw = CS1;
    	    }
    	    nw_change = 1;
    	}
        else
        {
            if ( main_nw == CS1 || main_nw == CS2 ) {
    	        if (focus_nw != CS1 && focus_nw != CS2){
    	            if (main_nw == CS1) {
    		        focus_nw = CS1;
    	            } else {
    		        focus_nw = CS2;
    	            }
                }
    	        nw_change = 1;
            } else {
    	        nw_change = 2;
            }
        }
    	break;
    default:
	break;
    }

    return nw_change;
}

function check_data_update()
{
    var service_max = 100;
    var update_check_size = service_max - URAEPG_LIST_COUNT -1;
    var ret = 0;
    if (focus_nw != INPUT
	&& all_service_count > service_max
	&& (get_top_epg_index(0) < (URAEPG_LIST_COUNT + 1)
	    || get_top_epg_index(0) > update_check_size
	    || get_top_epg_index((URAEPG_LIST_COUNT - 1)) < (URAEPG_LIST_COUNT + 1)
	    || get_top_epg_index((URAEPG_LIST_COUNT - 1)) > update_check_size))
    {
	ret = 1;
    }
    else if (rec_flg2 == 1)
    {
	ret = 1;
    }
	
    return ret;
}

function data_update_request()
{
    var update = check_data_update();
    if (update == 1)
    {
	if (epg_info[epg_focus_index])
	{
	    write_back_bytes ([5, GWIN_COM_URAEPG, 24, URAEPG_FILE_UPDATE, 
	    		       epg_info[epg_focus_index][ONID], 
			       epg_info[epg_focus_index][TSID], 
	    		       epg_info[epg_focus_index][SID], 
			       epg_info[epg_focus_index][INDEX], focus_nw, update]);
	}

    }
}

function write_back_updown()
{
    var update = check_data_update();
    delete_uraepg_program_timer();

    if (focus_nw != INPUT)
    {
	if (epg_info[epg_focus_index])
	{
	    write_back_bytes ([5, GWIN_COM_URAEPG, 24, URAEPG_UPDOWN, 
	    		       epg_info[epg_focus_index][ONID], 
			       epg_info[epg_focus_index][TSID], 
	    		       epg_info[epg_focus_index][SID], 
			       epg_info[epg_focus_index][INDEX], 
			       focus_nw, update]);
	}
    }
    else
    {
 	write_back_bytes ([5, GWIN_COM_URAEPG, 24, URAEPG_UPDOWN, 
 	    		   -1, input_list[epg_focus_index][0], -1, -1, -1, 0]);
    }
}

function delete_uraepg_program_timer ()
{
    delete_timer (uraepg_program);
    delay_update = false;
}

function delay_write_back_updown (time)
{
    append_timer (uraepg_program, time, write_back_updown);
    delay_update = true;
}

var updown_cnt = 0; 
function updown_synthe (repeat)
{
    var pos_ch;
    if (focus_nw == INPUT)
    {
 	pos_ch = input_list[epg_focus_index][1];
    }
    else
    {
 	pos_ch = epg_info[epg_focus_index][CH];
    }
    if (pos_ch == last_service_list[focus_nw]) {
        //console.log("updown_synthe (",repeat,"): ", epg_info[pos][CH], " SND_LOOP");
        send_lisp_code("(synthe-req 'SYT_PLAY (list SND_LOOP nil))");
        updown_cnt = 0;
    } else {
        updown_cnt += 1;
        
        //console.log("updown_synthe (",repeat,"): ", epg_info[pos][CH]);
        if ( repeat == 0 || updown_cnt >= 2) {
            //console.log("updown_synthe (",repeat,"): ", epg_info[pos][CH], " SND_MV");
            send_lisp_code("(synthe-req 'SYT_PLAY (list SND_CURSOR_MV nil))");            
            updown_cnt = 0;
        }
    }
}

function left_right_synthe (move_type)
{
    switch (move_type){
    case 2:
	send_lisp_code("(synthe-req 'SYT_PLAY (list SND_CURSOR_MV2 nil))");
	break;
    case 1:
	if (main_nw == focus_nw)
	{
	    send_lisp_code("(synthe-req 'SYT_PLAY (list SND_LOOP nil))");
	}
	else
	{
	    send_lisp_code("(synthe-req 'SYT_PLAY (list SND_CURSOR_MV nil))");
	}
	break;
    case 0:
    default:
	break;
    }
}

/* --- key repeat --- */
var updown_key_repeat = function (new_key, repeat_key) {
    var initial_timer = function () {
	button_list.move_count = 5;
	button_list.move_time = 25;
	cursor_updown (new_key);
	updown_synthe (1);
	delete_uraepg_program_timer();
	append_timer (uraepg_program, button_list.move_time*button_list.move_count, interval_timer);
    }

    var interval_timer = function () {
	button_list.move_count = 5;
	button_list.move_time = 25;
	cursor_updown (new_key);
	updown_synthe (1);
	if (focus_nw != INPUT)
	    data_update_request();
    }

    if (repeat_key == false)
    {
	delete_uraepg_program_timer();
	append_timer (uraepg_program, (50*10)*3/2, initial_timer);
	repeat_timer = true;
    }
    else
    {
	delete_uraepg_program_timer();
	repeat_timer = false;
    }
}

var left_right_press = function (key) {
    var pre_focus_nw = focus_nw;
    var ret = update_current_nw(key);
    left_right_synthe(ret);

    if (ret != 1) {
        return; /* do nothing */
    }
    change_nw_flg = 1;
    delete_uraepg_program_timer();

    //update_nw_guide
    if (IS_MULTI_WINDOW == SINGLE_WIN)
    {
 	update_nw_button_list(ONAIR_NET_COUNT);
    }
    else
    {
	if (rec_flg == 1)
	    change_sub_window(1);
	else
	    change_sub_window_no_input();
    }

    var interval_timer = function () {
	delete_timer(nw_button_list);
	if (IS_MULTI_WINDOW == SINGLE_WIN)
	{
	    write_back_bytes ([5, GWIN_COM_URAEPG, 8, URAEPG_NW_CHANGE, -1, focus_nw]);
	}
	else
	{
	    write_back_bytes ([5, GWIN_COM_URAEPG, 12, URAEPG_NW_CHANGE, 
			       pre_focus_nw, focus_nw]);
	}
    }
    append_timer (nw_button_list, 500, interval_timer);
}

/* key action */
var enter_action = function ()
{
    if (((IS_MULTI_WINDOW == SINPLE_WIN) && (main_nw == INPUT))
	|| (IS_MULTI_WINDOW == MULTI_WIN))
    {
	var tmp_nw;
	var cur_serv = 0;
	var pos = epg_focus_index;

	if (focus_nw == INPUT && input_list)
	{
	    cur_serv = input_list[pos][0];
	}
	else if (delay_update == true)
	{
	    write_back_updown();
	}
	//delete timer
	delete_uraepg_program_timer();
	delete_timer (button_list);
	delete_timer(focus_button);

	if ((rec_flg2 == 1) && (focus_nw != INPUT))
	{
            write_back_bytes ([5, GWIN_COM_URAEPG, 28, URAEPG_ENTER,
                               focus_nw, main_nw, 
			       epg_info[pos][ONID], epg_info[pos][TSID],
                               epg_info[pos][SID], epg_info[pos][INDEX]]);
	}
	else
	{
	    write_back_bytes ([5, GWIN_COM_URAEPG, 24, URAEPG_ENTER, 
	    		       focus_nw, main_nw, cur_serv, -1, -1]);
	}

	if (enter_cancel_flg != 1)
	  {
	    if(!((main_nw == INPUT) && (main_inp_serv > 8))) /* 8: AV2 */
	      {
		update_nw_tab ();
	      }
	    tmp_nw = focus_nw;
	    focus_nw = main_nw;
	    main_nw = tmp_nw;
	  }
    }
    else /* single mode */
    {
	if ((main_nw != focus_nw) && (nw_useflg[main_nw] == 0))
        {   
	    for(var n=0; n < nw_list.length; n++)
	    {   
                if(nw_list[n] == main_nw)
                {   
		    //delete
		    nw_list.splice(n,1);
		    
		    main_nw = focus_nw;
		    update_nw_button_list(ONAIR_NET_COUNT);
		    break;
                }
	    }
        }
	var pos = epg_focus_index;
        write_back_bytes ([5, GWIN_COM_URAEPG, 24, URAEPG_ENTER,
                           epg_info[pos][ONID], epg_info[pos][TSID],
                           epg_info[pos][SID], -1, -1]);
    }
}

/* --------------------------------*/
s.key_hook = function (up_down, key) {
    var pos;
    if (up_down==1) {
	switch (key) {
	case TXK_UP:
	case TXK_DOWN:
	    if (change_nw_flg == 1)
		break;

	    if (service_count > 1)
	    {
		if (repeat_key == false)
		{
		    cursor_updown (key);
		    updown_synthe (0);
		}
		updown_key_repeat(key, repeat_key);
	    }
            else if (service_count <= 1)
            {
		send_lisp_code("(synthe-req 'SYT_PLAY (list SND_CURSOR_MV2 nil))");
            }
            break;
	case TXK_GREEN:
	    if (IS_MULTI_WINDOW != SINGLE_WIN)
	    {
		var cur_serv = 0;
		var pos = epg_focus_index;
		if (focus_nw == INPUT)
		    cur_serv = input_list[pos][0];
		    
		write_back_bytes ([5, GWIN_COM_URAEPG, 12, URAEPG_GREEN, 
				   focus_nw, main_nw, cur_serv]);
	    }
            break;
	case TXK_LEFT:
	case TXK_RIGHT:
	    left_right_press(key);
	    break;
	case TXK_NET_TD:
	case TXK_NET_BS:
	case TXK_NET_CS:
	    if (IS_MULTI_WINDOW == SINGLE_WIN)
		left_right_press(key);
	    break;
	case TXK_BLUE:
	    if ((change_nw_flg == 1) || (IS_MULTI_WINDOW == SINGLE_WIN)
		|| (focus_nw == INPUT))
		break;

	    if((rec_flg == 0) && (focus_nw != HIKARI))  /* not rec */
	    {
		change_sub_window(0);
		write_back_bytes ([5, GWIN_COM_URAEPG, 8, URAEPG_BLUE, sub_window]);
	    }
	    break;
	case TXK_ENTER:
	    if ((change_nw_flg == 0) && (service_count > 0))
		enter_action ();
            break;
	case TXK_INFO:
	    if ((change_nw_flg == 0) && (service_count > 0))
      		write_back_bytes ([5, GWIN_COM_URAEPG, 4, URAEPG_RECALL]);
            break;
	case TXK_RETURN:
	    write_back_bytes ([5, GWIN_COM_URAEPG, 4, URAEPG_RETURN]);
            break;
	default:
            break;
	}
	repeat_key = key;
    }
   else if (up_down==0)
    {
	switch (repeat_key){
	case TXK_UP:
	case TXK_DOWN:
	    delete_uraepg_program_timer();
	    if (repeat_timer == true)
	    {
		delay_write_back_updown (400);
	    }
	    break;
	case TXK_LEFT:
	case TXK_RIGHT:
	case TXK_NET_TD:
	case TXK_NET_BS:
	case TXK_NET_CS:
            if (change_nw_flg == 1) {
		delete_uraepg_program_timer();
            }
            break;
	default:
	    break;
	}
	repeat_key = false;
	repeat_timer = false;
    }
};

function reload_uraepg_data()
{
    try{
	eval_js_file ("file:///tmp/zapping_data.js");
    }catch (e) {
	//console.log("---detact eval errror!");
	write_back_bytes ([5, GWIN_COM_URAEPG, 4, URAEPG_RETURN]);
    }
}

//eval_js_file ("file:///tmp/zapping_data.js");

/*  
 *  Call from C
 */
function set_zapping_model_data (model_mode, is_ire)
{
    zapping_model = model_mode;
    is_lang_ire = is_ire;
}

function uraepg_change_window_mode (window)
{
    IS_MULTI_WINDOW = window;
    if (window == 1)
	IS_MULTI_WINDOW = MULTI_WIN;

    switch (zapping_model)
    {
    case JP_MODEL:
	network_name = ["地上Ｄ","ＢＳ","ＣＳ１","ＣＳ２","入力","ひかり"];
	guide_blue_name = ["映像","番組内容"];
        BUTTON_POS_TITLE = 2;
	if (IS_MULTI_WINDOW == SINGLE_WIN)
	{
	    title_name = "裏番組一覧";
	    guide_enter_mes = "選局";
	    ONAIR_NET_COUNT = 4;
	    /* --------- font_size ------------------------------ */
	    NW_FOCUS_F_SIZE = 35;
	    NW_DEFAULT_F_SIZE = DEFAULT_F_SIZE;  /* default */
	}
	else 
	{
	    title_name = "２画面で探す";
	    guide_enter_mes = "入換";
	    /*--- translate ---*/
	    nw_button_margin = 80;
	}
	break;
    case UK_MODEL:
    case PAL_MODEL:
    default:
	GWIN_COM_URAEPG = WING_ID_URAEPG;
	title_name = gettext ("Pre-view");
	guide_enter_mes = gettext ("Swap");
	guide_blue_name = [gettext("Watch"),gettext("Info")];
	title_x = -20;
	title_w = 470;
	if (zapping_model == UK_MODEL)
	{
	    if (is_lang_ire)
		network_name = [gettext("DVB"),gettext("Satellite"),"","",gettext("Input")];
	    else
		network_name = [gettext("Freesat"),gettext("DVB"),gettext("Other Sat."),"",gettext("Input")];
	}
	else
	{
	    if (nw_useflg[DVBIP] != -1)
		network_name = ["S","C","T","IP",gettext("Input")];
	    else
		network_name = [gettext("DVB-S"),gettext("DVB-C"),gettext("DVB-T"),gettext("DVB-via-IP"),gettext("Input")];
	}
	break;
    }
}

function set_media_id(hdmi1, dp)
{
  MEDIA_INPUT_ID_HDMI1 = hdmi1;
  MEDIA_INPUT_ID_DP = dp;
}

function create_uraepg(aspect_onoff)
{
    /* LOAD:uraepg_data.js */
    reload_uraepg_data();

    /* set focus data */
    focus_service = current_service;
    focus_nw = current_nw;
    moto_service_count = service_count;
    //main_nw = current_nw;
    /* set last service */
    last_service_list[focus_nw] = current_service;

    //base , title, gguide
    title_base = make_title_base();

    //button(CH, program_name)
    nw_button_list = make_nw_button_list();
    nw_button_cursor = make_nw_button_cursor();
    button_list.init();
    button_list.create(focus_service);

    //program_info
    var prog_info_visible = false;
    if(((rec_flg == 1) && (focus_nw != INPUT))
       || (sub_window == 0)
       || (focus_nw == HIKARI)
       || (IS_MULTI_WINDOW == SINGLE_WIN))
    {
	prog_info_visible = true;
    }
//  console.log("info visible = ", prog_info_visible, "\n");

    //4:3 aspect cover
    aspect_cover.create();
    if (aspect_onoff == 1)
    {
	aspect_cover.visible_p = true;
    }
    else
    {
	aspect_cover.visible_p = false;
    }
    //program info
    program_info.create(prog_info_visible);
    program_info.visible_p = prog_info_visible;
    //remmocon guide
    rem_guide_list.create();
    uraepg_background.create();
    focus_button.create();

    change_sub_window_no_input();

    uraepg_program = new container({
	translate:[0,0,0],
	visible_p: true,
	components:[
	    title_base,
	    nw_button_list,
	    nw_button_cursor,
	    aspect_cover,
	    program_info,
	]
    });

    s.components[5] = uraepg_background;
    s.components[10] = button_list;
    s.components[15] = uraepg_program;
    s.components[20] = focus_button;
    s.components[25] = rem_guide_list;
    force_redraw();
}

function update_uraepg_program_info(mode)
{
    if (change_nw_flg == 1)
	return;

    if (focus_nw == INPUT)
    {
	change_sub_window_no_input();
    }
    else
    {
	if(mode || !epg_program_info[focus_service])
	{
	    reload_uraepg_data();
	}
	change_sub_window(1);
    }
}

function update_uraepg()
{
    var f_search = 0;
    var move_flg = 0;
    var tmp_current_service_focus = 0;
    
    if (change_nw_flg == 1)
	return;

    //not update while up/down timer
    if (cursor_move == 1)
    {
	delete_timer(focus_button);
	append_timer(focus_button, 50, update_uraepg);
    	return 0;
    }
    else
    {
	delete_timer(focus_button);
    }

    reload_uraepg_data();
    for (var focus=0; focus < service_count; focus++)
    {
	if (focus_service == epg_info[focus][CH])
	{
	    reset_epg_index(focus);
	    f_search = 1;
	    break;
	}
	if (current_service == epg_info[focus][CH])
	{
	    tmp_current_service_focus = focus;
	}
    }

    /* JS:focus_service, C:current_service */
    if(focus_service != current_service)
    {
	if (f_search != 1)
	{
	    //share event
	    focus_service = current_service;
	    reset_epg_index(tmp_current_service_focus);
	}
	else
	{
	    update_button_list_data();
	    if (epg_info[epg_focus_index])
	    {
		/* epg_info list : discovery */
		write_back_bytes ([5, GWIN_COM_URAEPG, 16, URAEPG_CURSOR_RESET, 
	    			   epg_info[epg_focus_index][ONID], epg_info[epg_focus_index][TSID], 
	    			   epg_info[epg_focus_index][SID]]);
	    }
	    return;
	}
    }

    if(service_count <= 0)
    {
	button_list.update();
    }
    else
    {
 	//button_list.update();  ?? hituyou??
	//update ch/title
	if((moto_service_count != service_count) || (f_search != 1))
	{
	    button_list.update();
	}
	else
	{
	    update_button_list_data();
	}
    }

    moto_service_count = service_count;
    //update program info
    if (IS_MULTI_WINDOW == SINGLE_WIN) 
	update_program_info();
    else
	change_sub_window_no_input();
}

//change nw
function update_nw_uraepg(nw_change_mode)
{
    delete_timer(focus_button);

    reload_uraepg_data();

    /* network change */
    if(nw_change_mode == 1)
    {
	/* set last service list */
	last_service_list[focus_nw] = current_service;
    }

    focus_service = current_service;

    if(IS_MULTI_WINDOW != SINGLE_WIN)
	update_nw_tab();
    button_list.update();

    //update program info
    if (IS_MULTI_WINDOW == SINGLE_WIN) 
	update_program_info();
    else
	change_sub_window_no_input();

    /* set default */
    change_nw_flg = 0;
}

//change rec mode
function change_uraepg_subwindow()
{
    if (focus_nw == HIKARI)
    {
	return 0;
    }

    reload_uraepg_data();
    if (focus_nw == INPUT)
	change_sub_window_no_input();
    else
	change_sub_window(1);
}

//change aspect 4:3 (=> add obi)
function update_uraepg_aspect_4_3_cover(onoff)
{
    if (onoff == 1)
    {
	aspect_cover.visible_p = true;
    }
    else
    {
	aspect_cover.visible_p = false;
    }
    force_redraw();
}

function destroy_uraepg()
{
    //data init
    nw_list.length = 0;
    epg_program_info.length = 0;
    uraepg_button_list.length = 0;
    pos_list.length = 0;
    epg_info.length = 0;
    epg_info_tmp.length = 0;
    button_list.components.length = 0;
    button_list.length = 0;
    input_list.length = 0;

    //delete timer
    delete_uraepg_program_timer();
    delete_timer (button_list);
    delete_timer(focus_button);

    //undraw components
    s.components[5]  = 0;
    s.components[10] = 0;
    s.components[15] = 0;
    s.components[20] = 0;
    s.components[25] = 0;
}
