/*
 *  Copyright (C) 2013 Panasonic. All rights reserved.
 */
var oipfChannelList = {
	_vbo: null,
	_oipf: null,
	_oipfLen: 0,
	_cached: [],
	_currentPos: -1,
	_currentCCID: -1,

	init: function(vbo) {
		this._vbo = vbo;
		// get channel list
		this._oipf = this._vbo.getChannelConfig().channelList;
		this._oipfLen = this._oipf.length;
		
		// create cached list.. all values are unset to start with
		for (var i=0; i<this._oipfLen; i++) {
			var ch = {
				mypos: i,
				lcn: -1,
				ccid: '',
				name: '',
				freesatServiceID: '',
				hidden: false,
				programmes: []
			};
			this._cached.push(ch);
		}
		
		// find current pos
		this.setCurrentPos();
	},
	getTimeString: function(ts) {
		var dstart = 0;
		if (ts == 0) {
			dstart = new Date();
		}
		else {
			dstart = new Date(ts * 1000);
		}
		var fromhrs = dstart.getHours();
		var frommin = dstart.getMinutes();
		var str = (fromhrs<10?'0':'')+fromhrs+(frommin<10?':0':':')+frommin;
		return str;
	},
	
	// ---------------------------------------------------------------
	// cache getters
	// ---------------------------------------------------------------
	
	getLength: function() {
		return this._oipfLen;
	},
	getItem: function(pos) {
		return this._oipf[pos];
	},
	getLcn: function(pos) {
		if (this._cached[pos].lcn === -1) {
			this._cached[pos].ccid = this._oipf[pos].ccid;
			this._cached[pos].lcn = this._cached[pos].ccid.replace("ccid:","");
		}
		return this._cached[pos].lcn;
	},
	getChannelID: function(pos) {
		if (this._cached[pos].ccid === '') {
			this._cached[pos].ccid = this._oipf[pos].ccid;
			this._cached[pos].lcn = this._cached[pos].ccid.replace("ccid:","");
		}
		return this._cached[pos].ccid;
	},
	getName: function(pos) {
		if (this._cached[pos].name === '') {
			this._cached[pos].name = this._oipf[pos].name;
		}
		return this._cached[pos].name;
	},
	getFreesatServiceID: function(pos) {
		if (this._cached[pos].freesatServiceID === '') {
			this._cached[pos].freesatServiceID = this._oipf[pos].freesatServiceID;
		}
		return this._cached[pos].freesatServiceID;
	},
	getHidden: function(pos) {
		if (this._cached[pos].hidden === '') {
			this._cached[pos].hidden = this._oipf[pos].hidden;
		}
		return this._cached[pos].hidden;
	},
	getProgrammes: function(pos) {
		return this._cached[pos].programmes;
	},
	setProgrammes: function(programmes) {
		var progs = [];
		if (programmes !== undefined) {
			var pLen = programmes.length;
			if (pLen) {
				var ccid = programmes[0].channelID;
				// find pos
				var pos = this.findListPosByCCID(ccid);

				this._cached[pos].programmes = [];
				for (var i=0; i<pLen; i++) {
					var startTime = programmes[i].startTime,
						duration = programmes[i].duration;
					var e = {
						myPos: pos,
						channelID: programmes[i].channelID,
						name: programmes[i].name,
						startTime: startTime,
						duration: duration,
						startTimeString: this.getTimeString(startTime),
						endTimeString: this.getTimeString(startTime+duration),
						progEnd: (startTime + duration) * 1000,
						description: programmes[i].description,
						longDescription: programmes[i].longDescription,
                        progObj: programmes[i]
					}
					this._cached[pos].programmes.push(e);
				}
				progs = this._cached[pos].programmes;
			}
		}

		return progs;
	},
	findListPosByCCID: function(ccid) {
		var pos = -1;
		for (i=0; i<this._oipfLen; i++) {
			if (ccid == this.getChannelID(i)) {
				pos = i;
				break;
			}
		}
		return pos;
	},
	// ---------------------------------------------------------------
	// other
	// ---------------------------------------------------------------
	setCurrentPos: function() {
		var currentCh = this._vbo.currentChannel;
		var currentFSSID = currentCh.freesatServiceID;
		this._currentCCID = currentCh.ccid;
        for (var i=0; i<this._oipfLen; i++) {
			if (currentFSSID == this.getFreesatServiceID(i)) {
				this._currentPos = i;
				break;
			}
		}
	},
	getCurrentPos: function() {
		return this._currentPos;
	}
};
