(load "/usr/local/slisp/station.lsp")

(defvar msg-pipe nil)(defvar msg-form nil)(defun send-event (event size data)(when msg-pipe
(unless msg-form
(setf msg-form (register-message 'msg-form
:fd msg-pipe
:header-size 4
:length-field 4)))(write-bytes msg-form event size data)))

(defvar dlnad-prio 1)(defvar current-video-ch nil)

(register-node 'decoder-open
#'(lambda ()
t)
#'(lambda ()(video-config 'video
:codec 'VIDEO_CODEC_NONE
:use "DISPLAY_MAIN")(my-device-priority 'video dlnad-prio)(my-device-open 'video (video-openquery :ch (+ current-video-ch 1)))(init-video-object 'video))
#'(lambda ()(my-device-close 'video)))

(register-node 'tuner-open
#'(lambda ()
t)
#'(lambda ()(my-device-open 'ca nil)(my-device-priority 'ca dlnad-prio)(my-device-priority 'psi dlnad-prio)(open-psi-with (device-source 'video))(init-psi-object 'psi #'pmt-parser)

(my-device-priority 'cp dlnad-prio)(my-device-open 'cp nil)(init-cp-object 'cp)

(my-device-priority 'tsport dlnad-prio)(my-device-open 'tsport (device-source 'video))

(my-device-priority 'tuner dlnad-prio)(when (boundp 'config-tuner)(tuner-config 'tuner config-tuner))(open-tuner-with (device-source 'video))(init-tuner-object 'tuner)(init-section-object 'pat)(init-section-object 'pmt))
#'(lambda ()(my-device-close 'ca)(my-device-close 'psi)(my-device-close 'cp)(my-device-close 'tsport)(my-device-close 'tuner)))


(register-node 'tuner-monitor
#'(lambda ()(and (< (device-source 'video) 5)(eq (tuner-status 'tuner) 'TUNER_LOCK)))
#'(lambda ()(eval-events (list 'tuner-lock 'tuner-unlock 'tuner-disconnect)))
#'(lambda ()))

(defun open-psi-with (no)(if (eq dlnad-area 'pal)(if (eq no 2)(setf no 2)(setf no 0))(setf no 0))(my-device-open 'psi no))

(defun open-tuner-with (no)(if (eq dlnad-area 'pal)(if (eq no 2) (setf no 1)))(my-device-open 'tuner no))

(defun initialize (prio)

(append-t
'decoder-open
'tuner-open
'tuner-monitor
'psi-valid
'parse-pmt))

(defun restart-monitor (ch)(if (device-open-p 'video)(progn
(cancel-node 'decoder-open)))

(setf current-video-ch ch)(eval-node 'decoder-open))
