(defvar keymap
(list
'(TXK_OFF 0x0200)
'(TXK_POWER 0x0201)
'(TXK_POWON 0x0202)
'(TXK_POWOFF 0x0203)
'(TXK_VOLUP 0x00b7)
'(TXK_VOLDOWN 0x00b6)
'(TXK_MUTE 0x00b5)
'(TXK_CH_UP 0x0204)
'(TXK_CH_DOWN 0x0205)
'(TXK_1 0x02ff)
'(TXK_2 0x0300)
'(TXK_3 0x0301)
'(TXK_4 0x0302)
'(TXK_5 0x0303)
'(TXK_6 0x0304)
'(TXK_7 0x0305)
'(TXK_8 0x0306)
'(TXK_9 0x0307)
'(TXK_10 0x0308)
'(TXK_11 0x0206)
'(TXK_12 0x0207)
'(TXK_13 0x0208)
'(TXK_14 0x0209)
'(TXK_15 0x020a)
'(TXK_16 0x020b)
'(TXK_TD01 0x020c)
'(TXK_TD02 0x020d)
'(TXK_TD03 0x020e)
'(TXK_TD04 0x020f)
'(TXK_TD05 0x0210)
'(TXK_TD06 0x0211)
'(TXK_TD07 0x0212)
'(TXK_TD08 0x0213)
'(TXK_TD09 0x0214)
'(TXK_TD10 0x0215)
'(TXK_TD11 0x0216)
'(TXK_TD12 0x0217)
'(TXK_BS01 0x0218)
'(TXK_BS02 0x0219)
'(TXK_BS03 0x021a)
'(TXK_BS04 0x021b)
'(TXK_BS05 0x021c)
'(TXK_BS06 0x021d)
'(TXK_BS07 0x021e)
'(TXK_BS08 0x021f)
'(TXK_BS09 0x0220)
'(TXK_BS10 0x0221)
'(TXK_BS11 0x0222)
'(TXK_BS12 0x0223)
'(TXK_CS01 0x0224)
'(TXK_CS02 0x0225)
'(TXK_CS03 0x0226)
'(TXK_CS04 0x0227)
'(TXK_CS05 0x0228)
'(TXK_CS06 0x0229)
'(TXK_CS07 0x022a)
'(TXK_CS08 0x022b)
'(TXK_CS09 0x022c)
'(TXK_CS10 0x022d)
'(TXK_CS11 0x022e)
'(TXK_CS12 0x022f)
'(TXK_NET_BS 0x0230)
'(TXK_NET_CS1 0x0231)
'(TXK_NET_CS2 0x0232)
'(TXK_NET_TER 0x0233)
'(TXK_NET_TD 0x0234)
'(TXK_NET_CS 0x0235)
'(TXK_NET_TER_A 0x0236)
'(TXK_NET_TER_D 0x0237)
'(TXK_NET_CABLE 0x0238)
'(TXK_NET_SAT 0x0239)
'(TXK_NET_FREESAT 0x023a)
'(TXK_CHG_INPUT 0x023b)
'(TXK_TV 0x023c)
'(TXK_VIDEO1 0x023d)
'(TXK_VIDEO2 0x023e)
'(TXK_VIDEO3 0x023f)
'(TXK_VIDEO4 0x0240)
'(TXK_CVIDEO1 0x0241)
'(TXK_CVIDEO2 0x0242)
'(TXK_CVIDEO3 0x0243)
'(TXK_HDMI1 0x0244)
'(TXK_HDMI2 0x0245)
'(TXK_HDMI3 0x0246)
'(TXK_HDMI4 0x0247)
'(TXK_PC1 0x0248)
'(TXK_MEDIA_TV 0x0249)
'(TXK_MEDIA_RADIO 0x024a)
'(TXK_MEDIA_DATA 0x024b)
'(TXK_RED 0x024c)
'(TXK_GREEN 0x024d)
'(TXK_YELLOW 0x024e)
'(TXK_BLUE 0x024f)
'(TXK_ENTER 0x000d)
'(TXK_UP 0x0026)
'(TXK_DOWN 0x0028)
'(TXK_LEFT 0x0025)
'(TXK_RIGHT 0x0027)
'(TXK_RETURN 0x0008)
'(TXK_CANCEL 0x001b)
'(TXK_RIGHT_UP 0x0250)
'(TXK_RIGHT_DOWN 0x0251)
'(TXK_LEFT_DOWN 0x0252)
'(TXK_LEFT_UP 0x0253)
'(TXK_PAGE_DN 0x0022)
'(TXK_PAGE_UP 0x0021)
'(TXK_PROG_UP 0x0254)
'(TXK_PROG_DN 0x0255)
'(TXK_SKIP_PREV 0x0256)
'(TXK_SKIP_NEXT 0x0257)
'(TXK_PLAY 0x00fa)
'(TXK_PAUSE 0x0013)
'(TXK_STOP 0x0258)
'(TXK_FF 0x0259)
'(TXK_REW 0x025a)
'(TXK_REC 0x025b)
'(TXK_REC_LIST 0x025c)
'(TXK_30SEC_SKIP 0x025d)
'(TXK_OFFTIMER 0x025e)
'(TXK_CHANNEL 0x025f)
'(TXK_CHG_SERVICE 0x0260)
'(TXK_DIRECT 0x0261)
'(TXK_MPX 0x0262)
'(TXK_SURROUND 0x0263)
'(TXK_AD_CHANGE 0x0264)
'(TXK_AUDIO_SWAP 0x0265)
'(TXK_EARPHONE 0x0266)
'(TXK_INFO 0x0267)
'(TXK_VTOOLS 0x0268)
'(TXK_EPG 0x0269)
'(TXK_VMENU 0x026a)
'(TXK_SOUND 0x026b)
'(TXK_MENU 0x026c)
'(TXK_PRG_NAVI 0x026d)
'(TXK_DMODE 0x026e)
'(TXK_SUBMENU 0x026f)
'(TXK_TMODE 0x0270)
'(TXK_FAVORITE 0x0271)
'(TXK_BROWS_MENU 0x0272)
'(TXK_VIERA_LINK 0x0273)
'(TXK_MANUAL 0x0006)
'(TXK_KIKI_NAVI 0x0274)
'(TXK_OPERATION_PANEL 0x0275)
'(TXK_EVENT_INFO 0x0276)
'(TXK_INTERNET 0x0277)
'(TXK_NETFLIX 0x0278)
'(TXK_ON_DEMAND 0x0279)
'(TXK_OCAP_MENU 0x027a)
'(TXK_VOD 0x027b)
'(TXK_JIMAKU 0x027c)
'(TXK_CC 0x027d)
'(TXK_STILL 0x027e)
'(TXK_STTL 0x027f)
'(TXK_KO_STILL 0x0280)
'(TXK_HOLD 0x0281)
'(TXK_DISP_MODE 0x0282)
'(TXK_ASP_NORMAL 0x0283)
'(TXK_ASP_CINEM 0x0284)
'(TXK_ASP_ZOOM 0x0285)
'(TXK_ASP_JUST 0x0286)
'(TXK_SELF_WIDE 0x0287)
'(TXK_ASP_FULL 0x0288)
'(TXK_MULTI 0x0289)
'(TXK_SWAP 0x028a)
'(TXK_R_TUNE 0x028b)
'(TXK_R_SCREEN 0x028c)
'(TXK_TEXT 0x028d)
'(TXK_CHG_CHAR 0x028e)
'(TXK_SPACE 0x0020)
'(TXK_BACK_SPACE 0x0008)
'(TXK_SHARP 0x028f)
'(TXK_ASTERISK 0x00aa)
'(TXK_CLEAR 0x000c)
'(TXK_SLASH 0x00bf)
'(TXK_INDEX 0x0290)
'(TXK_NORMAL 0x0291)
'(TXK_DRIVE 0x0292)
'(TXK_3D 0x0293)
'(TXK_BD 0x0294)
'(TXK_DIGA_CTL 0x0295)
'(TXK_IPOD 0x0296)
'(TXK_GAME 0x0297)
'(TXK_SD_CARD 0x0298)
'(TXK_NEWS 0x0299)
'(TXK_PICTAI 0x029a)
'(TXK_AUDIOAI 0x029b)
'(TXK_P_NR 0x029c)
'(TXK_DIGAINPUT 0x029d)
'(TXK_ECO 0x029e)
'(TXK_FUNC1 0x029f)
'(TXK_FUNC2 0x02a0)
'(TXK_FUNC3 0x02a1)
'(TXK_FUNC4 0x02a2)
'(TXK_SECURE_SDDL 0x02a3)
'(TXK_SDBOOT 0x02a4)
'(TXK_USB_SHARING 0x02a5)
'(TXK_06 0x02a6)
'(TXK_07 0x02a7)
'(TXK_E1 0x02a8)
'(TXK_E2 0x02a9)
'(TXK_FACT2C 0x02aa)
'(TXK_FACT30 0x02ab)
'(TXK_FACT40 0x02ac)
'(TXK_FACT62 0x02ad)
'(TXK_FACT68 0x02ae)
'(TXK_FACT69 0x02af)
'(TXK_FACT6A 0x02b0)
'(TXK_FACT6B 0x02b1)
'(TXK_FACT6E 0x02b2)
'(TXK_FACT6F 0x02b3)
'(TXK_FACT74 0x02b4)
'(TXK_FACT81 0x02b5)
'(TXK_ERASE_MAG 0x02b6)
'(TXK_DEMO 0x02b7)
'(TXK_POS_SIZE 0x02b8)
'(TXK_PROG 0x02b9)
'(TXK_F0 0x02ba)
'(TXK_F1 0x02bb)
'(TXK_FACTF9 0x02bc)
'(TXK_FA 0x02bd)
'(TXK_BUS_UNLOCK 0x02be)
'(TXK_BUS_LOCK 0x02bf)
'(TXK_FD 0x02c0)
'(TXK_FE 0x02c1)
'(TXK_SELFCHK 0x02c2)
'(TXK_NULL 0x02c3)
'(TXK_DMS_CH_UP 0x02c4)
'(TXK_DMS_CH_DOWN 0x02c5)
'(TXK_TV_MUTE_ON 0x02c6)
'(TXK_TV_MUTE_OFF 0x02c7)
'(TXK_OSD_REMOTE 0x02c8)
'(TXK_PAD_MENU 0x02c9)
'(TXK_APPS 0x02ca)
'(TXK_HOME 0x0024)
'(TXK_MEDIA_SERVER 0x02cb)
'(TXK_MIC_START 0x02cc)
'(TXK_MIC_STOP 0x02cd)
'(TXK_MIC_NRC 0x02ce)
'(TXK_FUREAI_READING 0x02cf)
'(TXK_FUREAI_TV 0x02d0)
'(TXK_FUREAI_ALBUM 0x02d1)
'(TXK_FUREAI_MSG 0x02d2)
'(TXK_FUREAI_RECOMMEND 0x02d3)
'(TXK_FUREAI_HEALTH 0x02d4)
'(FXK_OFF 0x02d5)
'(FXK_CH_UP 0x02d6)
'(FXK_CH_DOWN 0x02d7)
'(FXK_CHG_INPUT 0x02d8)
'(FXK_CHG_NETWORK 0x02d9)
'(FXK_CHG_SERVICE 0x02da)
'(FXK_AD_CHANGE 0x02db)
'(FXK_VOLUP 0x02dc)
'(FXK_VOLDOWN 0x02dd)
'(FXK_FUNC 0x02de)
'(FXK_MENU 0x02df)
'(FXK_CH_SETTING 0x02e0)
'(FXK_POWER 0x02e1)
'(FXK_POWER_OFF 0x02e2)
'(FXK_POWER_ON 0x02e3)
'(FXK_REC 0x02e4)
'(FXK_PLAY 0x02e5)
'(FXK_STOP 0x02e6)
'(FXK_EJECT 0x02e7)
'(FXK_DISP_MODE 0x02e8)
'(FXK_TV_GUIDE 0x02e9)
'(FXK_DEMO 0x02ea)
'(FXK_ENTER 0x02eb)
'(FXK_OFFTIMER 0x02ec)
'(FXK_STORE 0x02ed)
'(MXK_OFF 0x02ee)
'(MXK_CHDOWN_AV 0x02ef)
'(MXK_CHDOWN_INFO 0x02f0)
'(MXK_CHDOWN_MENU 0x02f1)
'(MXK_CHDOWN_ENTER 0x02f2)
'(MXK_CHDOWN_POS10 0x02f3)
'(MXK_CHDOWN_SUBMENU 0x02f4)
'(MXK_C_RECALL 0x02f5)
'(MXK_C_MENU 0x02f6)
'(MXK_C_ENTER 0x02f7)
'(MXK_C_CHUP 0x02f8)
'(MXK_C_INPUT 0x02f9)
'(MXK_C_VOLUP 0x02fa)
'(MXK_C_SUBMENU 0x02fb)
'(MXK_C_RED 0x02fc)
'(MXK_C_GREEN 0x02fd)
'(MXK_C_BLUE 0x02fe)
'(TXK_D1 0x02ff)
'(TXK_D2 0x0300)
'(TXK_D3 0x0301)
'(TXK_D4 0x0302)
'(TXK_D5 0x0303)
'(TXK_D6 0x0304)
'(TXK_D7 0x0305)
'(TXK_D8 0x0306)
'(TXK_D9 0x0307)
'(TXK_D0 0x0308)
'(TXK_MANUAL 0x0309)
'(TXK_MYBUTTON 0x030a)
'(TXK_TP_PAIRING 0x030b)
'(TXK_CHAT_MODE 0x030c)
'(TXKB_BackSpace 0x0008)
'(TXKB_Tab 0x0009)
'(TXKB_Return 0x000d)
'(TXKB_Pause 0x0013)
'(TXKB_Scroll_Lock 0x0091)
'(TXKB_Escape 0x001b)
'(TXKB_Delete 0x002e)
'(TXKB_Kanji 0x0019)
'(TXKB_Muhenkan 0x001d)
'(TXKB_Home 0x0024)
'(TXKB_Left 0x0025)
'(TXKB_Up 0x0026)
'(TXKB_Right 0x0027)
'(TXKB_Down 0x0028)
'(TXKB_End 0x0023)
'(TXKB_Select 0x0029)
'(TXKB_Print 0x002a)
'(TXKB_Execute 0x002b)
'(TXKB_Insert 0x002d)
'(TXKB_Cancel 0x0003)
'(TXKB_Help 0x0006)
'(TXKB_Num_Lock 0x0090)
'(TXKB_F1 0x0024)
'(TXKB_F2 0x02ca)
'(TXKB_F3 0x026c)
'(TXKB_F4 0x023b)
'(TXKB_F5 0x0205)
'(TXKB_F6 0x0204)
'(TXKB_F7 0x00b6)
'(TXKB_F8 0x00b7)
'(TXKB_F9 0x024c)
'(TXKB_F10 0x024d)
'(TXKB_F11 0x024e)
'(TXKB_F12 0x024f)
'(TXKB_Shift_L 0x0010)
'(TXKB_Shift_R 0x0010)
'(TXKB_Control_L 0x0011)
'(TXKB_Control_R 0x0011)
'(TXKB_Caps_Lock 0x0014)
'(TXKB_Alt_L 0x0012)
'(TXKB_Alt_R 0x0012)
'(TXKB_0 0x0030)
'(TXKB_1 0x0031)
'(TXKB_2 0x0032)
'(TXKB_3 0x0033)
'(TXKB_4 0x0034)
'(TXKB_5 0x0035)
'(TXKB_6 0x0036)
'(TXKB_7 0x0037)
'(TXKB_8 0x0038)
'(TXKB_9 0x0039)
'(TXKB_minus 0x00ad)
'(TXKB_KP_Space 0x0020)
'(TXKB_KP_Tab 0x0009)
'(TXKB_KP_Enter 0x000d)
'(TXKB_KP_F1 0x0024)
'(TXKB_KP_F2 0x02ca)
'(TXKB_KP_F3 0x026c)
'(TXKB_KP_F4 0x023b)
'(TXKB_KP_Home 0x0024)
'(TXKB_KP_Left 0x0025)
'(TXKB_KP_Up 0x0026)
'(TXKB_KP_Right 0x0027)
'(TXKB_KP_Down 0x0028)
'(TXKB_KP_End 0x0023)
'(TXKB_KP_Insert 0x002d)
'(TXKB_KP_Delete 0x002e)
'(TXKB_KP_Equal 0x003d)
'(TXKB_KP_Multiply 0x006a)
'(TXKB_KP_Add 0x006b)
'(TXKB_KP_Separator 0x006c)
'(TXKB_KP_Subtract 0x006d)
'(TXKB_KP_Decimal 0x006e)
'(TXKB_KP_Divide 0x006f)
'(TXKB_KP_0 0x0060)
'(TXKB_KP_1 0x0061)
'(TXKB_KP_2 0x0062)
'(TXKB_KP_3 0x0063)
'(TXKB_KP_4 0x0064)
'(TXKB_KP_5 0x0065)
'(TXKB_KP_6 0x0066)
'(TXKB_KP_7 0x0067)
'(TXKB_KP_8 0x0068)
'(TXKB_KP_9 0x0069)
))

(defvar keymap_dtv
(list
'(0x01000020 0x0020)
'(0x01000021 0x00a1)
'(0x01000022 0x00a2)
'(0x01000023 0x00a3)
'(0x01000024 0x00a4)
'(0x01000025 0x00a5)
'(0x01000026 0x00a6)
'(0x01000027 0x00de)
'(0x01000028 0x00a8)
'(0x01000029 0x00a9)
'(0x0100002a 0x00aa)
'(0x0100002b 0x00ab)
'(0x0100002c 0x00bc)
'(0x0100002e 0x00be)
'(0x0100002f 0x00bf)
'(0x0100005b 0x00db)
'(0x0100005c 0x00dc)
'(0x0100005d 0x00dd)
'(0x0100005e 0x00a0)
'(0x0100005f 0x00a7)
'(0x01000060 0x00c0)
'(0x0100007b 0x00ae)
'(0x0100007c 0x00ac)
'(0x0100007d 0x00af)
'(0x0100007e 0x00b0)
))

(defvar frame-list nil)
(defvar focused-frame nil)

(defun set-focused-frame (frame)
(setf focused-frame frame))

(defun set-frame-key-request (frame lst)
(let ((req (assoc frame frame-list)))
(if req
(setf (nth 1 req) lst)
(setf frame-list (cons (list frame lst nil nil) frame-list)))))

(defun get-focused-key-request ()
(nth 1 (assoc focused-frame frame-list)))

(defun key-request-p (vkey)
(find-if #'(lambda (lst)
(or (eq (nth 1 lst) t)
(find vkey (nth 1 lst))))
frame-list))

(defun set-frame-key-block (frame lst)
(let ((req (assoc frame frame-list)))
(if req
(setf (nth 2 req) lst)
(setf frame-list (cons (list frame nil lst nil) frame-list)))))

(defun get-focused-key-block ()
(nth 2 (assoc focused-frame frame-list)))

(defun key-block-p (vkey)
(or (eq (get-focused-key-block) t)
(find vkey (get-focused-key-block))))

(defun set-frame-wheel-request (frame flag)
(let ((req (assoc frame frame-list)))
(if req
(setf (nth 3 req) flag)
(setf frame-list (cons (list frame nil nil flag) frame-list)))))

(defun get-focused-wheel-request ()
(nth 3 (assoc focused-frame frame-list)))

(defun wheel-request-p ()
(find-if #'(lambda (lst)
(nth 3 lst))
frame-list))

(defun delete-frame-event (frame)
(setf frame-list (delete (assoc frame frame-list) frame-list)))

(setf platinum-system-frame
(make-gframe 0 0 1 1 nil 0 nil nil nil nil nil nil nil nil nil))

(defvar last-press-key nil)
(defun platinum-system-key-hook (key on-off)
(platinum-system-key-hook-internal key on-off 0))
(defun platinum-system-key-hook-internal (key on-off state)
(let ((vkey
(if (eq (symbol-type key) nil)
(cond
((and (>= key 0x100003A) (<= key 0x1000040))
(- key 0x1000000))
((and (>= key 0x1000041) (<= key 0x100005A))
(- key 0x1000000))
((and (>= key 0x1000061) (<= key 0x100007A))
(- key 0x1000020))
(t
(second (assoc key keymap_dtv))
))
(second (assoc key keymap))))
(keysym
(if (eq (symbol-type key) nil)
key
(symbol-value key))))
(if (and vkey (or (eq (get-focused-key-request) t)
(find vkey (get-focused-key-request))
(eq vkey last-press-key)))
(progn
(remove-timer-hook 'key-repeat-timer)
(remove-timer-hook 'key-repeat-timer2)
(if (eq on-off 'key-release)
(progn
(if (eq last-press-key vkey)
(progn
(setf last-press-key nil)
(write-back-bytes 1 12 vkey keysym state)
t)
nil))
(progn
(setf last-press-key vkey)
(write-back-bytes 0 12 vkey keysym state)
(add-timer-hook #'(lambda (x)
(write-back-bytes 2
12
(car x)
(cadr x)
(cadr (cdr x)))
(add-timer-hook #'(lambda (x)
(write-back-bytes 2 12 (car x) (cadr x) (cadr (cdr x)))
)
'key-repeat-timer2
x
100
100))
'key-repeat-timer
(list vkey keysym state)
500
0)
t)))
(if (or (key-request-p vkey) (key-block-p vkey))
(progn
(write-back-bytes 5 8
(if (eq on-off 'key-release) 0 1) vkey)
t)
nil)
)))

(defvar touchpad-org-x 0)
(defvar touchpad-org-y 0)
(defvar touchpad-charging 0)
(defun touchpad-abs (x)
(cond ((>= x 0) x)
(t (- 0 x))))
(defvar scrolltick (/ 160 3))

(defun platinum-system-touchpad-hook (type dx dy)
(let ((ret nil)
(cur-x) (cur-y) (diff-x) (diff-y))
(case type
(touch-press
(setf touchpad-charging 1)
(setf touchpad-org-x current-touch-pos-x0)
(setf touchpad-org-y current-touch-pos-y0))
(touch-release
)
(touch-move
(if (get-focused-key-request)
(progn
(if (eq touchpad-charging 1)
(progn
(setf cur-x current-touch-pos-x0)
(setf cur-y current-touch-pos-y0)
(setf diff-x (touchpad-abs (- cur-x touchpad-org-x)))
(setf diff-y (touchpad-abs (- cur-y touchpad-org-y)))
(when (or (>= diff-x 4000)
(>= diff-y 3200))
(if (> diff-x diff-y)
(if (> cur-x touchpad-org-x)
(progn
(platinum-system-key-hook 'TXK_RIGHT 'key-press)
(platinum-system-key-hook 'TXK_RIGHT 'key-release)
)
(progn
(platinum-system-key-hook 'TXK_LEFT 'key-press)
(platinum-system-key-hook 'TXK_LEFT 'key-release)
))
(if (> cur-y touchpad-org-y)
(progn
(platinum-system-key-hook 'TXK_UP 'key-press)
(platinum-system-key-hook 'TXK_UP 'key-release)
)
(progn
(platinum-system-key-hook 'TXK_DOWN 'key-press)
(platinum-system-key-hook 'TXK_DOWN 'key-release)
)))
(setf touchpad-org-x current-touch-pos-x0)
(setf touchpad-org-y current-touch-pos-y0)
(setf touchpad-charging 0)))
(progn
(setf touchpad-org-x current-touch-pos-x0)
(setf touchpad-org-y current-touch-pos-y0)
(setf touchpad-charging 1)))
(setf ret t))))
(touch-gesture-tap
(setf ret (platinum-system-key-hook 'TXK_ENTER 'key-press))
(platinum-system-key-hook 'TXK_ENTER 'key-release))
(touch-gesture-wheel
(when (eq dx 0)
(write-back-bytes 4 4 0))
(if (wheel-request-p)
(progn
(when (or (eq dx 0) (eq dx 1))
(write-back-bytes 3 8 0 (if (>= dy 1) (- 0 scrolltick)
(if (<= dy -1) scrolltick
dy))))
(setf ret t))
(setf ret (if (wheel-request-p)
t
nil))))
(touch-button-changed
(cond ((eq (logand dx 1) 1)
(setf ret (platinum-system-key-hook 'TXK_ENTER 'key-press)))
((eq (logand dx 2) 2)
)
(t
(setf ret (platinum-system-key-hook 'TXK_ENTER 'key-release)))))
)
ret))

(defun platinum-system-usbkb-event (key on-off kcode state dev)
(platinum-system-key-hook-internal key on-off state))

(defun platinum-system-input-string-event (str)
(do ((i 0 (1+ i)))
((>= i (length str)))
(let ((c (char str i)))
(if (and (>= c 32) (<= c 126))
(let ((key (logior 0x1000000 c)))
(progn
(platinum-system-key-hook-internal key 'key-press 0)
(platinum-system-key-hook-internal key 'key-release 0)))))))

(defun get-frame (zorder)
(if (>= zorder 110)
LOCAL_TV_GROUP
SCR_LOCAL))

(defun platinum-force-send-key (key)
(let ((req (rassoc key keymap)))
(when req
(force-send-key-frame platinum-system-frame (car req) 'key-press)
(force-send-key-frame platinum-system-frame (car req) 'key-release)
)))

(defun init-frame (zorder)
(register-frame2 'platinum-system-frame
"/usr/local/platinum/data/platinum_event-fun.lsp"
(get-frame zorder)
zorder
#'(lambda (f)
nil
)
#'(lambda (f)
nil)
(function platinum-system-key-hook)
nil
nil)
(map-frame 'platinum-system-frame)
(set-frame-touchpad-hook 'platinum-system-frame #'platinum-system-touchpad-hook)
(set-frame-keyboard-hook 'platinum-system-frame #'platinum-system-usbkb-event)
(set-frame-input-string-hook 'platinum-system-frame #'platinum-system-input-string-event)
(set-frame-independent-on-off-top 'platinum-system-frame t))
