(function(window,dom){
var settingMenu,
mystream=window.MYSTREAM=window.MYSTREAM||{},
domFocus=dom.FOCUS,
loadingIconPath=null,
PostcodeInput,
scrollList;
settingMenu={
SCREEN_STATE:{
CLOSED:0,
LIST:1,
CHOICE:2,
INPUT_POSTCODE:3,
SCROLL_LIST:4,
TRANSITION:5
},
screenState:0,
focusState:0,
listIndex:0,
settingListData:null,
focus:null,
scrollList:null,
requestId:null,
postcodeInput:null,
closeCallback:null,
forceCloseCallback:null,
init:function(config,iconPath,callback){
var info;
PostcodeInput=mystream.POSTCODE_INPUT;
loadingIconPath=iconPath;
dom.changeSvgFillColor([document.getElementById('iconSetting')],'rgb(204,204,204)');
this.focus=new domFocus.Focus(document.getElementById('settingFocus'));
this.closeCallback=callback;
this.scrollList=scrollList;
this.settingListData=[];
if(config.streamingUI===true){
info={
id:'scroll_type',
storedKey:'scroll_type',
title:LANG('LT_MYSTRM_SCROLL_TYPE'),
type:'choice',
list:[
{id:'stream',title:LANG('LT_MYSTRM_SMOOTH')},
{id:'page',title:LANG('LT_TOP_PAGE_TITLE')}
],
selected:0,
enable:true
};
this.settingListData.push(info);}
info={
id:'scroll_interval',
storedKey:'scroll_interval',
title:LANG('LT_MYSTRM_REFRESHTIME'),
type:'choice',
list:[
{id:'15s',title:'15'+LANG('LT_TM_SECONDS')},
{id:'30s',title:'30'+LANG('LT_TM_SECONDS')},
{id:'60s',title:'60'+LANG('LT_TM_SECONDS')}
],
selected:0,
enable:true
};
this.settingListData.push(info);
if(false){
this.settingListData.push({
id:'post_code',title:LANG('LT_POSTCODE'),type:'unique',
message:LANG('LT_MYSTRM_PLS_ENTER_POSTCODE'),enable:true
});
this.settingListData.push({
id:'srvprv',title:LANG('LT_MYSTRM_SERVICE_PROVIDER'),
type:'scroll_list',list:null,enable:true,
message:LANG('LT_MYSTRM_PLS_SELECT_SERVICE_PROVIDER')
});}
var i,max;
for(i=0,max=this.settingListData.length;i<max;i+=1){
var target=this.settingListData[i];
if(target.storedKey){
var val=parseInt(localStorage.getItem(target.storedKey));
if((val>=0)&&(val<target.list.length)){
target.selected=val;}
}
}
},
getSetting:function(id){
var i,max,target;
for(i=0,max=this.settingListData.length;i<max;i+=1){
target=this.settingListData[i];
if(id===target.id){
return target.list[target.selected];}
}
return null;},
open:function(){
DEBUG.console(DEBUG.LVL.VERBOSE,'open setting menu');
var eleSettingPopupBox,eleLiTemplate,eleWrap,eleChoiceBox,eleScrollBox,eleDiv,eleLi,
eleUl,eleTemp,appendDataElement,that=this;
appendDataElement=function(info,index){
var eleLi=eleLiTemplate.cloneNode(true);
eleLi.id='settingList'+index;
eleLi.children[0].textContent=info.title;
if(info.type==='choice'){
eleLi.children[1].textContent=info.list[info.selected].title;}
if(info.enable===false){
eleLi.classList.add('disable');}
eleUl.appendChild(eleLi);};
this.forceCloseCallback=null,
this.listIndex=0;
dom.changeSvgFillColor([document.getElementById('iconSetting')],'rgb(64,163,255)');
eleSettingPopupBox=document.getElementById('settingPopupBox');
eleWrap=dom.createElement('div',{id:'settingListBoxWrap'});
eleUl=dom.createElement('ul',{id:'settingListBox'});
eleLiTemplate=dom.createElement('li',{className:'settingList'});
eleDiv=dom.createElement('div',{className:'settingListTitle'});
eleLiTemplate.appendChild(eleDiv);
eleDiv=dom.createElement('div',{className:'settingListValue'});
eleLiTemplate.appendChild(eleDiv);
this.settingListData.forEach(appendDataElement);
eleWrap.appendChild(eleUl);
eleChoiceBox=dom.createElement('ul',{id:'settingChoiceBox'});
eleWrap.appendChild(eleChoiceBox);
eleScrollBox=dom.createElement('div',{id:'settingScrollBox'});
eleTemp=dom.createElement('p',{id:'settingScrollHead'});
eleScrollBox.appendChild(eleTemp);
eleTemp=dom.createElement('div',{id:'settingSAUp',
className:'settingScrollArrow'});
eleScrollBox.appendChild(eleTemp);
eleTemp=dom.createElement('div',{id:'settingScrollList'});
eleScrollBox.appendChild(eleTemp);
eleTemp=dom.createElement('div',{id:'settingSADown',
className:'settingScrollArrow'});
eleScrollBox.appendChild(eleTemp);
eleWrap.appendChild(eleScrollBox);
eleSettingPopupBox.appendChild(eleWrap);
eleTemp=dom.createElement('div',{id:'settingTriangleBorder'});
eleSettingPopupBox.appendChild(eleTemp);
eleTemp=dom.createElement('div',{id:'settingTriangle'});
eleSettingPopupBox.appendChild(eleTemp);
this.screenState=this.SCREEN_STATE.TRANSITION;
eleSettingPopupBox.classList.add('open');
dom.addTransitionEndCallback(eleSettingPopupBox,'opacity',function(){
that.screenState=that.SCREEN_STATE.LIST;
if(that.forceCloseCallback){
that.close();
return;}
that.focus.set(document.getElementById('settingList'+that.listIndex));});},
close:function(callback){
DEBUG.console(DEBUG.LVL.VERBOSE,'close setting menu');
var that=this,eleSettingPopupBox=document.getElementById('settingPopupBox');
if(callback){
this.forceCloseCallback=callback;}
if(this.screenState===this.SCREEN_STATE.TRANSITION){
return;}
this.screenState=this.SCREEN_STATE.TRANSITION;
that.focus.off();
dom.changeSvgFillColor([document.getElementById('iconSetting')],'rgb(204,204,204)');
eleSettingPopupBox.classList.add('close');
eleSettingPopupBox.classList.remove('open');
dom.addTransitionEndCallback(eleSettingPopupBox,'opacity',function(){
var callback=that.closeCallback;
eleSettingPopupBox.innerHTML='';
eleSettingPopupBox.classList.remove('close');
that.screenState=that.SCREEN_STATE.CLOSED;
if(that.forceCloseCallback){
callback=that.forceCloseCallback;
that.forceCloseCallback=null;}
callback();});},
setSelectListStyle:function(callback){
var i,max,eleSettingList;
if(typeof callback!=='function'){
callback=false;}
for(i=0,max=this.settingListData.length;i<max;i+=1){
eleSettingList=document.getElementById('settingList'+i);
if(i===this.listIndex){
eleSettingList.classList.add('selected');
if(callback){
callback(eleSettingList);}
}else {
eleSettingList.classList.add('unselect');}
}
},
setUnselectListStyle:function(){
var i,max,eleSettingList;
for(i=0,max=this.settingListData.length;i<max;i+=1){
eleSettingList=document.getElementById('settingList'+i);
if(eleSettingList.classList.contains('selected')){
eleSettingList.classList.remove('selected');}
if(eleSettingList.classList.contains('unselect')){
eleSettingList.classList.remove('unselect');}
}
},
showChoiceList:function(){
var that=this,i,max,choiceList,appendDataElement,offsetTop,
eleUl,eleSettingList,eleLiTemplate,df,choiceIndex=0;
appendDataElement=function(info,index){
var eleLi=eleLiTemplate.cloneNode(true);
eleLi.id='settingChoice'+index;
eleLi.textContent=info.title;
df.appendChild(eleLi);};
this.focus.off();
df=document.createDocumentFragment();
this.setSelectListStyle(function(ele){
offsetTop=ele.offsetTop+'px';});
eleLiTemplate=dom.createElement('li',{className:'settingChoice'});
eleUl=document.getElementById('settingChoiceBox');
choiceIndex=this.settingListData[this.listIndex].selected;
choiceList=this.settingListData[this.listIndex].list;
choiceList.forEach(appendDataElement);
eleUl.innerHTML='';
eleUl.appendChild(df);
eleUl.style.opacity='1.0';
eleUl.style.top=offsetTop;
this.screenState=this.SCREEN_STATE.CHOICE;
this.focus.set(document.getElementById('settingChoice'+choiceIndex));},
showScrollList:function(){
var offsetTop,list,selected,
info=this.settingListData[this.listIndex];
this.focus.off();
this.setSelectListStyle(function(ele){
offsetTop=ele.offsetTop+'px';});
if(info.list===null){
mystream.requestSettingList(info.id);}else {
list=info.list;
selected=info.selected;}
this.scrollList.create(offsetTop,info.message,list,selected);
this.screenState=this.SCREEN_STATE.SCROLL_LIST;},
startInputPostcode:function(info){
DEBUG.console(DEBUG.LVL.INFO,'startInputPostcode');
var that=this,eleParent,eleDialogArea,elePosFocus,
offsetTop,options={},callback,messages;
eleParent=document.getElementById('settingListBoxWrap');
elePosFocus=document.getElementById('postcodeFocus');
callback=function(eventName){
if(eventName==='close'){
that.postcodeInput.destroy();
that.postcodeInput=null;
that.endInputPostcode();}else if(eventName==='update'){
that.postcodeInput.close();}
};
this.focus.off();
this.setSelectListStyle(function(ele){
offsetTop=ele.offsetTop+'px';});
options.styles={top:offsetTop};
this.screenState=this.SCREEN_STATE.INPUT_POSTCODE;
this.postcodeInput=new PostcodeInput('uk',callback);
this.postcodeInput.open('settingPosInput',eleParent,elePosFocus,options);
return this;},
endInputPostcode:function(){
DEBUG.console(DEBUG.LVL.INFO,'endInputPostcode');
this.setUnselectListStyle();
this.screenState=this.SCREEN_STATE.LIST;
this.focus.set(document.getElementById('settingList'+this.listIndex));
return this;},
setList:function(list,selected){
if(this.scrollList.currentState===this.scrollList.STATE.WAITING){
this.scrollList.createList(list,selected);}
return this;},
keyDownHandler:function(event){
var that=this,i,max,selectInfo,eleSettingPopupBox,eleSettingList,
choiceList,choiceSelectedIndex;
switch(this.screenState){
case this.SCREEN_STATE.LIST:
if(this.focus.currentState===domFocus.STATE.OFF){
return;}
switch(event.keyCode){
case KeyEvent.DOM_VK_RETURN:
case KeyEvent.DOM_VK_RIGHT:
selectInfo=this.settingListData[this.listIndex];
if(selectInfo.enable===false){
return;}
switch(selectInfo.type){
case 'choice':
this.showChoiceList();
break;
case 'scroll_list':
this.showScrollList();
break;
default:
switch(selectInfo.id){
case 'post_code':
this.startInputPostcode(selectInfo);
break;
case '':
break;
default:
}
}
break;
case KeyEvent.DOM_VK_UP:
if(this.settingListData.length===1){
return;}
if(this.listIndex===0){
this.listIndex=this.settingListData.length-1;}else {
this.listIndex-=1;}
this.focus.move(document.getElementById('settingList'+this.listIndex));
break;
case KeyEvent.DOM_VK_DOWN:
if(this.settingListData.length===1){
return;}
if(this.listIndex>=this.settingListData.length-1){
this.listIndex=0;}else {
this.listIndex+=1;}
this.focus.move(document.getElementById('settingList'+this.listIndex));
break;
case KeyEvent.DOM_VK_BACK_SPACE:
this.close();
break;
default:
}
break;
case this.SCREEN_STATE.CHOICE:
if(this.focus.currentState!==domFocus.STATE.ON){
return;}
choiceList=this.settingListData[this.listIndex].list;
choiceSelectedIndex=this.settingListData[this.listIndex].selected;
switch(event.keyCode){
case KeyEvent.DOM_VK_UP:
if(choiceSelectedIndex===0){
choiceSelectedIndex=choiceList.length-1;}else {
choiceSelectedIndex-=1;}
this.settingListData[this.listIndex].selected=choiceSelectedIndex;
eleSettingList=document.getElementById('settingList'+this.listIndex);
eleSettingList.children[1].textContent=choiceList[choiceSelectedIndex].title;
this.focus.move(document.getElementById('settingChoice'+choiceSelectedIndex));
break;
case KeyEvent.DOM_VK_DOWN:
if(choiceSelectedIndex>=choiceList.length-1){
choiceSelectedIndex=0;}else {
choiceSelectedIndex+=1;}
this.settingListData[this.listIndex].selected=choiceSelectedIndex;
eleSettingList=document.getElementById('settingList'+this.listIndex);
eleSettingList.children[1].textContent=choiceList[choiceSelectedIndex].title;
this.focus.move(document.getElementById('settingChoice'+choiceSelectedIndex));
break;
case KeyEvent.DOM_VK_LEFT:
case KeyEvent.DOM_VK_RETURN:
case KeyEvent.DOM_VK_BACK_SPACE:
document.getElementById('settingChoiceBox').style.opacity='0.0';
this.focus.off();
this.setUnselectListStyle();
this.screenState=this.SCREEN_STATE.LIST;
this.focus.set(document.getElementById('settingList'+this.listIndex));
var target=this.settingListData[this.listIndex];
if(target.storedKey){
localStorage.setItem(target.storedKey,target.selected);}
break;
default:
}
break;
case this.SCREEN_STATE.SCROLL_LIST:
switch(event.keyCode){
case KeyEvent.DOM_VK_UP:
case KeyEvent.DOM_VK_DOWN:
this.scrollList.moveFocus((event.keyCode===KeyEvent.DOM_VK_UP)?-1:1);
break;
case KeyEvent.DOM_VK_RETURN:
if(this.scrollList.currentState===this.scrollList.STATE.READY){
this.focus.off();
this.setUnselectListStyle();
this.scrollList.remove();
this.screenState=this.SCREEN_STATE.LIST;
this.focus.set(document.getElementById('settingList'+this.listIndex));}
break;
case KeyEvent.DOM_VK_LEFT:
case KeyEvent.DOM_VK_BACK_SPACE:
if(this.scrollList.currentState===this.scrollList.STATE.READY||
this.scrollList.currentState===this.scrollList.STATE.WAITING){
this.focus.off();
this.setUnselectListStyle();
this.scrollList.remove();
this.screenState=this.SCREEN_STATE.LIST;
this.focus.set(document.getElementById('settingList'+this.listIndex));}
break;
default:
}
break;
case this.SCREEN_STATE.INPUT_POSTCODE:
this.postcodeInput.keyDownHandler(event);
break;
default:
}
}
};
scrollList={
MAX_SIZE:4,
STATE:{
NONE:0,
WAITING:1,
READY:2,
SCROLLING:3
},
eleList:null,
currentState:0,
viewListIndex:0,
selectIndex:0,
lastSelectIndex:0,
list:null,
listCount:0,
callback:null,
transEndHandler:function(event){
var that=scrollList;
dom.stopEvent(event);
if(that.currentState===that.STATE.SCROLLING){
that.currentState=that.STATE.READY;}
},
create:function(offsetTop,head,list,selectIndex){
var eleScrollBox=document.getElementById('settingScrollBox'),
eleScrollHead=document.getElementById('settingScrollHead'),
eleScrollList=document.getElementById('settingScrollList'),
eleLoadingIcon;
this.eleList=eleScrollList;
eleScrollHead.textContent=head||'';
eleScrollBox.style.top=offsetTop;
if(list){
this.createList(list,selectIndex);}else {
eleLoadingIcon=dom.createElement('div',{id:'settingLoad',
className:'loadingIcon spin'});
eleLoadingIcon.appendChild(dom.createElement('img',
{src:loadingIconPath}));
eleScrollList.appendChild(eleLoadingIcon);
this.currentState=this.STATE.WAITING;}
eleScrollBox.classList.add('show');
return this;},
createList:function(list,selectIndex){
DEBUG.console(DEBUG.LVL.INFO,'createList');
var that=this,i,max,listIndex=0,focusIndex=0,
eleTemplate,eleValue,df=document.createDocumentFragment(),
eleScrollList=this.eleList;
eleTemplate=dom.createElement('p',{className:'settingScrollValue'});
eleScrollList.innerHTML='';
this.lastSelectIndex=this.selectIndex=selectIndex||0;
this.list=list;
this.listCount=list.length;
if(this.list.length<=this.MAX_SIZE){
this.viewListIndex=0;}else if(this.list.length>this.MAX_SIZE&&
this.selectIndex>this.listCount-this.MAX_SIZE){
this.viewListIndex=this.listCount-this.MAX_SIZE;}else {
this.viewListIndex=this.selectIndex;}
listIndex=this.viewListIndex;
for(i=0;i<this.MAX_SIZE+2;i+=1){
eleValue=eleTemplate.cloneNode(false);
eleValue.id='settingScrollValue'+i;
if(listIndex>0&&this.list[listIndex-1]){
eleValue.textContent=this.list[listIndex-1].title;}
df.appendChild(eleValue);
listIndex+=1;}
eleScrollList.appendChild(df);
eleScrollList.addEventListener(dom.eventName.transitionend,this.transEndHandler,false);
this.setArrowStyle();
focusIndex=this.selectIndex-this.viewListIndex;
settingMenu.focus.set(eleScrollList.children[focusIndex+1]);
this.currentState=this.STATE.READY;
return this;},
setArrowStyle:function(){
var eleArrowUp=document.getElementById('settingSAUp'),
eleArrowDown=document.getElementById('settingSADown');
if(this.viewListIndex>0){
eleArrowUp.classList.add('active');}else {
eleArrowUp.classList.remove('active');}
if(this.viewListIndex+this.MAX_SIZE<this.listCount){
eleArrowDown.classList.add('active');}else {
eleArrowDown.classList.remove('active');}
return this;},
remove:function(){
var eleScrollBox=document.getElementById('settingScrollBox'),
eleArrowUp=document.getElementById('settingSAUp'),
eleArrowDown=document.getElementById('settingSADown');
eleScrollBox.classList.remove('show');
this.eleList.removeEventListener(dom.eventName.transitionend,
this.transEndHandler,false);
eleArrowUp.classList.remove('active');
eleArrowDown.classList.remove('active');
this.eleList.innerHTML='';
this.eleList=null;
this.list=null;
this.listCount=0;
this.lastSelectIndex=this.selectIndex=0;
this.currentState=this.STATE.NONE;
return this;},
moveFocus:function(direction){
var info,eleValue,eleScrollList,focusIndex;
if(this.currentState!=this.STATE.READY||
settingMenu.focus.currentState===domFocus.STATE.OFF){
return this;}
focusIndex=this.selectIndex-this.viewListIndex;
if(direction>0){if(this.selectIndex>=this.listCount-1){
return this;}
this.selectIndex+=1;
if(focusIndex<this.MAX_SIZE-1){
focusIndex=this.selectIndex-this.viewListIndex;
settingMenu.focus.move(this.eleList.children[focusIndex+1]);}else {
this.currentState=this.STATE.SCROLLING;
this.viewListIndex+=1;
eleValue=this.eleList.firstChild;
info=this.list[this.selectIndex+1];
eleValue.textContent=(info)?info.title:'';
this.eleList.appendChild(eleValue);}
}else {if(this.selectIndex===0){
return this;}
this.selectIndex-=1;
if(focusIndex>0){
focusIndex=this.selectIndex-this.viewListIndex;
settingMenu.focus.move(this.eleList.children[focusIndex+1]);}else {
this.currentState=this.STATE.SCROLLING;
this.viewListIndex-=1;
eleValue=this.eleList.lastChild;
info=this.list[this.selectIndex-1];
eleValue.textContent=(info)?info.title:'';
this.eleList.insertBefore(eleValue,this.eleList.firstChild);}
}
this.setArrowStyle();
return this;}
};
mystream.SETTING_MENU=settingMenu;}(window,DOMUTIL));
