(function(window,dom){
var PostcodeInput,
mystream=window.MYSTREAM=window.MYSTREAM||{},
domFocus=dom.FOCUS,
FIX_TEXTS;
PostcodeInput=function(type,callback,messages){
var defaultValue=mystream.msUtil.getPostCode();
this.eles=null;
this.focus=null;
this.focusPos={column:0,row:0};
this.type=type;
this.value=defaultValue||'';
this.label=LANG('LT_POSTCODE');
this.currentState=this.STATE.NOT_READY;
this.keyList=[];
this.commandRow=1;
this.errDialog=false;
this.callback=callback;
this.animationEndHandler=(function(event){
dom.stopEvent(event);
if(this.currentState===this.STATE.OPENING&&
event.animationName==='slideFromR'){
this.setFocus();
this.currentState=this.STATE.READY;
this.callback('open');}else if(this.currentState===this.STATE.CLOSING&&
event.animationName==='slideToR'){
this.currentState=this.STATE.CLOSED;
this.remove();
this.callback('close');}
}).bind(this);
if(this.type==='uk'){
this.keyList[0]=[
48,49,50,51,52,53,54,55,56,57];
this.keyList[1]=[
65,66,67,68,69,70,71,72,73,74];
this.keyList[2]=[
75,76,77,78,79,80,81,82,83,84];
this.keyList[3]=[
85,86,87,88,89,90,32,false,
false,
false
];
this.commandRow=4;
this.keyList[4]=(function(){
var infoDel,infoDelAll,infoConf;
infoDel={type:'delete',value:'Delete',index:0};
infoDelAll={type:'deleteAll',value:'Delete All',index:1};
infoConf={type:'ok',value:'Ok',index:2};
return [
infoDel,infoDel,infoDel,
infoDelAll,infoDelAll,infoDelAll,
infoConf,infoConf,infoConf,
false
];}());}
};
PostcodeInput.prototype.STATE=PostcodeInput.STATE={
NOT_READY:0,
OPENING:1,
READY:2,
ERR_DIALOG:3,
CLOSING:4,
CLOSED:5
};
PostcodeInput.prototype.open=function(id,parent,focus,options){
var row,col,rMax,cMax,oldInfo,text,eleDialog,eleHead,
eleInput,eleLabel,eleValue,eleValueText,eleKeyArea,eleKeyLine,
eleKeyTemp,eleKey,eleErrDialog,eleText;
eleDialog=dom.createElement('div',{id:id,className:'postcodeDialog'});
eleHead=dom.createElement('p',{className:'postcodeHead'});
eleHead.textContent=LANG('LT_MYSTRM_PLS_ENTER_POSTCODE');
eleInput=dom.createElement('div',{className:'postcodeInputArea'});
eleLabel=dom.createElement('p',{className:'postcodeInputLabel'});
eleLabel.textContent=LANG('LT_POSTCODE');
eleValue=dom.createElement('div',{className:'postcodeInputValue'});
eleValueText=document.createElement('p');
eleValueText.textContent=this.value;
eleValue.appendChild(eleValueText);
eleInput.appendChild(eleLabel);
eleInput.appendChild(eleValue);
eleKeyArea=dom.createElement('div',{className:'postcodeKeyArea'});
eleKeyTemp=dom.createElement('span',{className:'postcodeKey'});
eleText=document.createElement('p');

for(row=0,rMax=this.keyList.length-1;row<rMax;row+=1){
eleKeyLine=dom.createElement('div',{className:'postcodeKeyLine'});
for(col=0,cMax=this.keyList[row].length;col<cMax;col+=1){
if(this.keyList[row][col]===false){
break;}
eleKey=eleKeyTemp.cloneNode(false);
text=String.fromCharCode(this.keyList[row][col]);
if(this.keyList[row][col]>=65&&this.keyList[row][col]<=90){
text.toUpperCase();}
eleKey.textContent=text;
eleKeyLine.appendChild(eleKey);}
eleKeyArea.appendChild(eleKeyLine);}
eleKeyLine=dom.createElement('div',{className:'postcodeKeyLine command'});
oldInfo=null;
for(col=0,cMax=this.keyList[this.commandRow].length;col<cMax;col+=1){
if(this.keyList[this.commandRow][col]!==false&&
this.keyList[this.commandRow][col]!==oldInfo){
eleKey=eleKeyTemp.cloneNode(false);
eleKey.textContent=this.keyList[this.commandRow][col].value;
eleKeyLine.appendChild(eleKey);}
oldInfo=this.keyList[this.commandRow][col];}
eleKeyArea.appendChild(eleKeyLine);
if(options){
if(options.styles){
dom.setStyles(eleDialog,options.styles);}
if(options.textDirection){
}
}
eleDialog.appendChild(eleHead);
eleDialog.appendChild(eleInput);
eleDialog.appendChild(eleKeyArea);
eleDialog.addEventListener(dom.eventName.animationend,
this.animationEndHandler,false);
parent.appendChild(eleDialog);
this.eles={
dialog:eleDialog,
value:eleValueText,
keys:eleKeyArea
};
this.focus=new domFocus.Focus(focus);
this.currentState=this.STATE.OPENING;
return this;};
PostcodeInput.prototype.setFocus=function(keyCode){
var row,col,rMax,cMax,eleKey,pos;
if(keyCode!==undefined){
for(row=0,rMax=this.keyList.length-1;row<rMax;row+=1){
for(col=0,cMax=this.keyList[row].length;col<cMax;col+=1){
if(keyCode===this.keyList[row][col]){
this.focusPos.row=row;
this.focusPos.column=col;
break;}
}
}
}
row=this.focusPos.row;
col=this.focusPos.column;
if(this.eles.keys.children[row]&&
this.eles.keys.children[row].children[col]){
this.focus.set(this.eles.keys.children[row].children[col]);}
return this;};
PostcodeInput.prototype.moveFocus=function(keyCode){
var row,col,target,cmdBtnInfo,index;
switch(keyCode){
case KeyEvent.DOM_VK_LEFT:
if(this.focusPos.row!==this.commandRow){
if(this.focusPos.column>0){
this.focusPos.column-=1;}else {
this.focusPos.column=this.keyList[this.focusPos.row].length-1;
target=this.keyList[this.focusPos.row][this.focusPos.column];
while(target===false){
this.focusPos.column-=1;
target=this.keyList[this.focusPos.row][this.focusPos.column];}
}
}else {
cmdBtnInfo=this.keyList[this.focusPos.row][this.focusPos.column];
switch(cmdBtnInfo.type){
case 'delete':
this.focusPos.column=6;
break;
case 'deleteAll':
this.focusPos.column=0;
break;
case 'ok':
this.focusPos.column=3;
break;
default:
}
}
break;
case KeyEvent.DOM_VK_UP:
if(this.focusPos.row>0){
this.focusPos.row-=1;}else {
this.focusPos.row=this.keyList.length-1;}
target=this.keyList[this.focusPos.row][this.focusPos.column];
while(target===false){
this.focusPos.row-=1;
target=this.keyList[this.focusPos.row][this.focusPos.column];}
break;
case KeyEvent.DOM_VK_RIGHT:
if(this.focusPos.row!==this.commandRow){
if(this.focusPos.column<this.keyList[this.focusPos.row].length-1){
this.focusPos.column+=1;
target=this.keyList[this.focusPos.row][this.focusPos.column];
if(target===false){
this.focusPos.column=0;}
}else {
this.focusPos.column=0;}
}else {
cmdBtnInfo=this.keyList[this.focusPos.row][this.focusPos.column];
switch(cmdBtnInfo.type){
case 'delete':
this.focusPos.column=3;
break;
case 'deleteAll':
this.focusPos.column=6;
break;
case 'ok':
this.focusPos.column=0;
break;
default:
}
}
break;
case KeyEvent.DOM_VK_DOWN:
if(this.focusPos.row<this.keyList.length-1){
this.focusPos.row+=1;
target=this.keyList[this.focusPos.row][this.focusPos.column];
while(target===false){
this.focusPos.row+=1;
if(this.focusPos.row>this.keyList.length-1){
this.focusPos.row=0;
break;}
target=this.keyList[this.focusPos.row][this.focusPos.column];}
}else {
this.focusPos.row=0;}
break;
default:
}
row=this.focusPos.row;
col=this.focusPos.column;
if(row===this.commandRow){
col=this.keyList[this.focusPos.row][this.focusPos.column].index;}
if(this.eles.keys.children[row]&&
this.eles.keys.children[row].children[col]){
this.focus.move(this.eles.keys.children[row].children[col]);}
return this;};
PostcodeInput.prototype.updatePostcode=function(){
var that=this,message,callback;
if(mystream.msUtil.setPostCode(this.value)===true){
this.callback('update');}else {
callback=function(){
if(that.currentState===that.STATE.READY&&
that.focus.currentState===domFocus.STATE.OFF){
that.focus.on();}
};
message='Postcode Invalid\nExit: cancel\nReturn: Re-enter',
mystream.dialogUI.open('postcodeErr','plane',message,callback);
this.focus.off();
}
return false;};
PostcodeInput.prototype.close=function(){
if(this.currentState===this.STATE.READY){
this.focus.off();
this.currentState=this.STATE.CLOSING;
this.eles.dialog.classList.add('close');}
return this;};
PostcodeInput.prototype.remove=function(){
if(this.eles){
this.eles.value=null;
this.eles.keys=null;
this.eles.dialog.removeEventListener(dom.eventName.animationend,
this.animationEndHandler,false);
this.eles.dialog.parentNode.removeChild(this.eles.dialog);
this.eles=this.eles.dialog=null;}
return this;};
PostcodeInput.prototype.destroy=function(){
if(this.eles){
this.remove();}
this.msUtil=null;
this.focus=null;
this.callback=null;
this.currentState=this.STATE.NOT_READY;
return this;};
PostcodeInput.prototype.keyDownHandler=function(event){
var chr,info;
if(this.currentState!==this.STATE.READY){
return this;}
switch(event.keyCode){
case KeyEvent.DOM_VK_BACK_SPACE:
this.close();
break;
case KeyEvent.DOM_VK_RETURN:
if(this.focus.currentState===domFocus.STATE.OFF){
return this;}
info=this.keyList[this.focusPos.row][this.focusPos.column];
if(this.focusPos.row!==this.commandRow){
this.addChar(info);}else {
if(info.type==='delete'||info.type==='deleteAll'){
this.removeChar(info.type);}else {
this.updatePostcode();}
}
break;
case KeyEvent.DOM_VK_LEFT:
case KeyEvent.DOM_VK_UP:
case KeyEvent.DOM_VK_RIGHT:
case KeyEvent.DOM_VK_DOWN:
if(this.focus.currentState!==domFocus.STATE.OFF){
this.moveFocus(event.keyCode);}
break;
default:
if((event.keyCode>=48&&
event.keyCode<=57)){
this.addChar(event.keyCode);
this.setFocus(event.keyCode);}else if(this.type==='uk'){
if(event.keyCode>=65&&
event.keyCode<=90){
this.addChar(event.keyCode,true);}else if(event.keyCode===KeyEvent.DOM_VK_SPACE){
this.addChar(event.keyCode);}
}
}
return this;};
PostcodeInput.prototype.addChar=function(keyCode,toUpper){
var chr=String.fromCharCode(keyCode);
if(toUpper===true){
chr=chr.toUpperCase();}
this.eles.value.textContent=this.value+=chr;
return this;};
PostcodeInput.prototype.removeChar=function(type){
if(this.value.length===0){
return this;}
if(type==='delete'){
this.value=this.value.slice(0,-1);}else {
this.value='';}
this.eles.value.textContent=this.value;
return this;};
mystream.POSTCODE_INPUT=PostcodeInput;}(window,DOMUTIL));
