(function(window,mystream,dom){
'use strict';
var USE_DUMMY=(navigator.userAgent.indexOf('Viera')==-1);
var DEBUG_MODE=false;
var contentManager=mystream.CONTENT_MANAGER,
dataManager=mystream.DATA_MANAGER,
searchScreen=mystream.SEARCH_SCREEN,
vodScreen=mystream.VOD_SCREEN,
settingMenu=mystream.SETTING_MENU,
filterMenu=mystream.FILTER_MENU,
msUtil=false;
if(USE_DUMMY){
contentManager=DUMMYCONTENTS;
if(!window.system){
window.system={socket:{write:function(){}}};}
}
if(!window.system.effect){
window.system.effect={
pattern:0,
timerId:-1,
start:function(){
clearTimeout(this.timerId);
DEBUG.console(DEBUG.LVL.NONE,'system.effect.start(pattern='+this.pattern+'):'+
Array.prototype.join.call(arguments));
return true;},
end:function(){
clearTimeout(this.timerId);
DEBUG.console(DEBUG.LVL.NONE,'system.effect.end:'+
Array.prototype.join.call(arguments));},
stop:function(){
clearTimeout(this.timerId);
DEBUG.console(DEBUG.LVL.NONE,'system.effect.stop:'+
Array.prototype.join.call(arguments));},
scroll:function(){
clearTimeout(this.timerId);
DEBUG.console(DEBUG.LVL.NONE,'system.effect.scroll:'+
Array.prototype.join.call(arguments));
this.timerId=setTimeout(this.onScroll,3000);}
};}
contentManager.init={
done:false,
config:(USE_DUMMY?true:false),
lang:false
};
var domFocus=dom.FOCUS;
var EFFECT={
PAGE_PREV:1,
PAGE_NEXT:0,
GATHER:6,
INOUT:7,
STREAM:10
},
CONTENT={
TV:1,
PICTURE:2,
VIDEO:3,
AUDIO:4,
TEXT:5,
OTHER:6
},
KIND={
ONAIR:'OnAir',
RECORDED:'Recorded',
SD:'SD',
USB:'USB',
YOUTUBE:'YouTube',
VOD:'VOD',
DIMORA:'Dimora',DIGA:'DIGA',
ACTVILA:'Actvila',
SAMBA:'Samba',
MEMO:'Memo',
FILE:'File',
BOOKMARK:'Bookmark'
},
FILTER_ID=mystream.FILTER_ID,
SCREEN_STATE={
MAIN_LOADING:0,
MAIN_READY:1,
MAIN_WAITING_MSG:2,
SETTING_POPUP:3,
VOD_PURCHASE:4,
SEARCH:5,
FILTER:6,
MYBUTTON:7
},
FOCUS_POSITION={
NONE:0,
GRID:1,
MODE_BUTTON:2,
SETTING:3,
USER_LIST:4,
LIST_FILTER:5,
SCROLL_BAR:6,
TRANSITION:7,
FILTER:8,
USER_SETTING:9
},
TIME={
AUTO_WAVE:15000,
WAIT_YOUTUBE_READY:1000,
SWITCH_PLAY:1500,
WAIT_LAUNCH_APP:1000,
WAIT_LOAD_IMAGE:2000,
DELAY_STREAMING:6000,
DELAY_WAVE_SLIDE:160,
DELAY_WAVE_ZOOM:260,
DELAY_WAVE_FADE:260,
DELAY_WAVE_VIDEO:260,
REQUEST_TIMEOUT:60000,
DELAY_DISP_OFFLINE:2000
},
REQ_CONTENTS_NUM=150,
REQ_TYPE={
RECOMMEND:'Recommend',
POPULAR:'Popular',
FAVORITE:'Favorite',
SEARCH:'Search',
INFO:'Info',
SERVICE_PROVIDER:'ServiceProvider'
},
MAX_COLUMN=5,MAX_ROW=3,
Configurations={
with_multi_profile:false,
profile_id:-1,
voice_req:false,
searchReq:false,
video_num:1,
auto_launch_appli:false,
auto_launch_ratio:100,
supportBroadcast:true,
supportRecordedTV:false,
supportMemo:true,
supportYoutube:false,
supportBookmark:false,
supportVOD:false,
displayInfoType:0,streamingUI:false,
pixelShift:0
},
authProfileId=-1,
maxVideoNum=1,
forceSingleMode=false,
SEARCH_STATUS,
FIX_WORDS,
VALID_BASE_TIME=(function(){
return (new Date(2000,0,1)).getTime()/1000;}()),
app_launcher,
myButton,
contentsList,
renderFin=false,
displayOfflinePanel=false,
screenState=SCREEN_STATE.MAIN_LOADING,
focusPosition=FOCUS_POSITION.NONE,
usingSystemEffect=false,
mainFocus,sizeInfo,offsetColumn=0,
gridFocusPos={x:-1,y:-1},contentsData,
gridData,
YouTube,
listPosition=0,
maxViewContents=0,
eventTransitionEnd=dom.eventName.transitionend,
domStyleNameTransition=dom.domStyleName.transition,
domStyleNameAnimation=dom.domStyleName.animation,
domStyleNameTransform=dom.domStyleName.transform,
cssNameTransform=dom.cssName.transform,
gridPlayControl,
scrollControl,
userControl,
modeControl,
systemEffect,
requestManager,
imageLoadObserver,
appendQueue,
dialogUI,
tooltipUI,
GridFrame,
ContentOfGrid,
msContentId=0,
ICON_PATH={
BOOKMARK:'img/bookmark.png',
DLNA:'img/dlna.png',
INPUT:'img/input.png',
MEMO:'img/memo.png',
MUSIC:'img/music.png',
PHOTO:'img/photo.png',
RECORDED:'img/recorded.png',
TV_CABLE:'img/tv_cab.png',
TV_SATELLITE:'img/tv_sat.png',
TV_TERR_ANA:'img/tv_terrA.png',
TV_TERR_DIGI:'img/tv_terrD.png',
TV_DVB_IP:'img/tv_dvb_ip.png',
VOD:'img/vod.png',
VIDEO:'img/video.png',
VIDEO_MEMO:'img/videomemo.png',
VOICE_MEMO:'img/voice.png',
YOUTUBE:'img/youtube.png',
DIGA:'img/diga.png',
ACTVILA:'img/actvila.png',
LOUPE:'img/se_loupe.png',
STAR:'img/star.png',
LOADING_CIRCLE:'img/loading_circle.png',
USER_SETTING:'img/usrprof_setting.png',
DEFAULT_AUDIO:'img/def_audio.png',
DEFAULT_OTHER:'img/def_other.png',
DEFAULT_PICTURE:'img/def_picture.png',
DEFAULT_TV:'img/def_tv.png',
DEFAULT_TV_FUTURE:'img/def_tv_future.png',
DEFAULT_VIDEO:'img/def_video.png',
INFO:'img/info.png'
};
YouTube={
enable:false,ready:false,waiting:true,stateNameList:{},
commonPlayerVars:{
controls:0,
autoplay:1,
loop:1,
showinfo:0,
disablekb:1},
commonEvents:{
onStateChange:function(event){
var state=event.data,player=event.target,stateName;
if(event.data===YT.PlayerState.ENDED){
player.seekTo(0);
player.playVideo();}
stateName=YouTube.stateNameList[event.data];
DEBUG.console(DEBUG.LVL.VERBOSE,'YouTubePlayer stateChange data:'+(stateName||event.data));},
onError:function(){
DEBUG.console(DEBUG.LVL.ERROR,'YouTubePlayer error!');}
}
};
(function(){
var css,name,srcList=[],
htmlFontSize=(62.5*(window.outerWidth/1920))+'%';
css=(function(){
var s=document.createElement('style');
s.setAttribute('type','text/css');
document.getElementsByTagName('head').item(0).appendChild(s);
var stylesheet=s.sheet;
return function(sel,sty){
stylesheet.insertRule(sel+'{'+sty+'}',0);};}());
css('html','font-size:'+htmlFontSize);
for(name in ICON_PATH){
srcList.push(ICON_PATH[name]);}
dom.preloadImages(srcList);}());
document.addEventListener('DOMContentLoaded',function(){
ready();});
window.onYouTubeIframeAPIReady=function(){
DEBUG.console(DEBUG.LVL.VERBOSE,'YouTube ready');
if(YouTube.enable&&YouTube.waiting){
YouTube.ready=true;
YouTube.stateNameList[YT.PlayerState.ENDED]='ended';
YouTube.stateNameList[YT.PlayerState.PLAYING]='playing';
YouTube.stateNameList[YT.PlayerState.PAUSED]='paused';
YouTube.stateNameList[YT.PlayerState.BUFFERING]='buffering';
YouTube.stateNameList[YT.PlayerState.CUED]='videocued';}
};
app_launcher={
launch_application:function(content){
var contents=JSON.stringify(contentsData.orgList);
DEBUG.console(DEBUG.LVL.INFO,contents.length+' '+contents);
localStorage.setItem('contents',contents);
var eleSearchParams=document.getElementById('searchParamsBox');
localStorage.setItem('search_words',eleSearchParams.textContent);
var lastGrid={pos:listPosition};
lastGrid.x=gridFocusPos.x;
lastGrid.y=gridFocusPos.y;
lastGrid.layout=gridData.getLayoutData();
lastGrid.filter_id=contentsData.filterId;
lastGrid.launch_app_info={kind:content.kind,
content:content.attr.content,
src:content.attr.src};
localStorage.setItem('last_grid',JSON.stringify(lastGrid));
localStorage.setItem('last_profile_id',userControl.getCurrentUserId());
if(content.kind===KIND.YOUTUBE){
contentManager.send({type:'Viewlog',
kind:KIND.YOUTUBE,
src:content.attr.src});}
var obj={command:'launch'};
switch(this.checkTvService(content)){
case 'live':
case 'past':
obj.appli='tv';
obj.param=content.attr.src;
break;
case 'future':
obj.appli='epg';
obj.param=content.attr.src;
obj.param+=';';
obj.param+=content.attr.eventId;
break;
default:
obj.appli=content.attr.appli;
if(content.kind===KIND.MEMO){
obj.param=content.attr.ex_src;}else {
obj.param=content.attr.src;}
break;}
DEBUG.console(DEBUG.LVL.INFO,JSON.stringify(obj));
system.socket.write(JSON.stringify(obj));},
checkTvService:function(content){
var result='other';
if(content.attr.content===CONTENT.TV){
var dt=new Date();
if(content.attr.time&&content.attr.time>0){
var start=content.attr.time;
var nowTime=dt.getTime()/1000;
if(start>nowTime){
result='future';}else {
if(content.attr.duration>=0){
var end=start+content.attr.duration;
if(end<nowTime){
result='past';}else {
result='live';}
}else {
result='live';}
}
}else {
result='live';}
}
return result;}
};
myButton={
lastRequest:{},
launch:function(content){
this.lastRequest={};
if(!Configurations.with_multi_profile){
return;}
var cmd={command:'mybutton'};
if(content.attr.content===CONTENT.TV){
if(content.attr.eventId&&content.attr.eventId!=-1){
cmd.key=content.attr.src;
cmd.key+='.';
cmd.key+=content.attr.eventId;}else {
return;}
}else {
if(content.attr.favInfo&&content.attr.favInfo.length){
cmd.key=content.attr.favInfo;}else if(content.attr.src!==undefined){
cmd.key=content.attr.src;}else {
return;}
}
cmd.kind=this.convKind(content.attr.content,content.kind);
if(cmd.kind==0){
return;}
cmd.fav_id=msUtil.getFavRegistProfile(cmd.key);
var curUserId=userControl.getCurrentUserId();
if(curUserId!==undefined&&curUserId!==null){
cmd.cur_user_id=curUserId;}
if(content.attr.time!==undefined&&content.attr.time!==null){
cmd.start_time=content.attr.time;}else {
cmd.start_time=-1;}
if(content.attr.duration!==undefined&&content.attr.duration!==null){
cmd.duration=content.attr.duration;}else {
cmd.duration=-1;}
this.lastRequest=cmd;
system.socket.write(JSON.stringify(cmd));
screenState=SCREEN_STATE.MYBUTTON;},
convKind:function(type,kind){
switch(kind){
case KIND.ONAIR:
return 0x01;
case KIND.RECORDED:
return 0x02;
case KIND.SD:
case KIND.USB:
case KIND.SAMBA:
if(type===CONTENT.PICTURE){
return 0x03;}else if(type===CONTENT.VIDEO){
return 0x04;}else if(type==CONTENT.AUDIO){
return 0x05;}
return 0x00;
case KIND.YOUTUBE:
return 0x06;
case KIND.VOD:
case KIND.ACTVILA:
return 0x07;
case KIND.DIGA:
return 0x08;
case KIND.MEMO:
if(type==CONTENT.TEXT){
return 0x09;}else if(type===CONTENT.VIDEO){
return 0x0A;}else if(type==CONTENT.AUDIO){
return 0x0B;}
return 0x00;
case KIND.BOOKMARK:
return 0x0C;
default:
return 0x00;}
}
};
var commonThumnailEvent=function(event){
var frame;
if(event.type==='load'){
if(checkImageSize(this)==='horizontal'){
this.classList.add('hWide');}else {
this.classList.remove('hWide');}
this.parentNode.classList.add('visible');
return;}
frame=searchFrameFromViewTableById(event.target.id,'thumnail');
if(frame&&frame.content){
event.target.src=frame.content.getDefaultImagePath();
event.target.parentNode.parentNode.classList.remove('dispThumnail');
frame.content.dispThumnail=false;}
};
var commonDurationChangeEvent=function(embed){
var target,frame,content,eleText,dateEnd,eleDuration,
format='hh:mm:ss';
frame=searchFrameFromViewTableById(embed.id,'player');
if(!frame||!frame.content||!frame.content.player){
return;}
frame.content.attr.duration=embed.duration;
frame.setTextInfo(frame.content.player.parentNode);
if(focusPosition!==FOCUS_POSITION.GRID||
gridFocusPos.x<offsetColumn||gridFocusPos.y<0){
return;}
target=gridData.viewTable[gridFocusPos.x][gridFocusPos.y];
if(target.frame&&target.frame.content&&
target.frame.content===frame.content){
if(frame.content.kind!==KIND.RECORDED){
eleText=document.getElementById('contentInfoCol2');
eleDuration=eleText.querySelector('.cnInfoDuration');
if(eleDuration){
eleDuration.textContent=formatSeconds(embed.duration||0,format);}
}else {
content=frame.content;
if(!isValidTime(content.attr.time)||!content.attr.duration){
return;}
eleText=document.getElementById('contentInfoCol3');
eleDuration=eleText.querySelector('.cnInfoDuration');
if(!eleDuration){
return;}
dateEnd=new Date((content.attr.time+content.attr.duration)*1000);
eleDuration.textContent=formatTime(dateEnd);}
}
};
var commonMediaErrorEvent=function(embed){
DEBUG.console(DEBUG.LVL.INFO,'commonMediaErrorEvent');
var target,frame;
frame=searchFrameFromViewTableById(embed.id,'player');
if(!frame||!frame.content||!frame.content.player){
return;}
gridPlayControl.giveUpContent(frame.content);};
ContentOfGrid=function(content,contentId,thumnailId,size,column,row){
this.kind=content.kind;
this.attr=content.attr;
this.id=contentId;
this.thumnailId=thumnailId;
this.width=size.width;
this.height=size.height;
this.currentState=this.STATE.NONE;
this.player=null;
this.muted=false;
this.dispThumnail=false;
this.mainOnly=false;
this.column=column;
this.row=row;
this.playerInfo={
prepare:false,
playing:false,
streaming:false
};
if(Configurations.streamingUI===false&&
(maxVideoNum===1||
this.kind===KIND.ONAIR&&
this.attr.src.slice(0,this.attr.src.indexOf(':'))==='ana')){
this.mainOnly=true;}
};
ContentOfGrid.prototype.STATE=ContentOfGrid.STATE={
NONE:0,THUMNAIL:1,PLAYER:2,YT_BLANK:3,YT_PLAYER:4
};
ContentOfGrid.prototype.isLocalContent=function(){
return (this.kind===KIND.SD||
this.kind===KIND.USB||
this.kind===KIND.SAMBA);};
ContentOfGrid.prototype.createPlayerElement=function(muted,paramVC){
var element,type,options,vContainer;
this.currentState=this.STATE.PLAYER;
this.muted=muted;
type=(this.kind===KIND.ONAIR)?
'application/tvplayer':
'application/mplayer';
options={id:this.id,className:'content',type:type,
loop:true,src:this.attr.src,muted:muted
};
if(Configurations.streamingUI===false){
vContainer=(this.mainOnly||this.isMainArea())?'0':'1';
options.video_container=vContainer;}else {
options.streaming=false;
vContainer='0';
if(paramVC!==undefined){
vContainer=paramVC.toString();}
options.video_container=vContainer;}
if(this.kind===KIND.RECORDED||this.isLocalContent()){
options.poster=this.attr.thumnail1;}
element=dom.createElement('embed',options);
if(this.attr.content===CONTENT.AUDIO){
element.classList.add('audioPlayer');
element.width='0';
element.height='0';}
this.player=element;
return element;};
ContentOfGrid.prototype.createThumnailElement=function(){
var element,src;
if(this.attr.thumnail1){
src=this.attr.thumnail1;
this.dispThumnail=true;}else {
src=this.getDefaultImagePath();
this.dispThumnail=false;}
this.currentState=this.STATE.THUMNAIL;
element=dom.createElement('img',{id:this.thumnailId,
className:'cnThumnail',src:src
});
element.addEventListener('error',commonThumnailEvent,false);
element.addEventListener('load',commonThumnailEvent,false);
return element;};
ContentOfGrid.prototype.createYTBlankElement=function(){
this.currentState=this.STATE.YT_BLANK;
return dom.createElement('div',{id:this.id,className:'content'});};
ContentOfGrid.prototype.toYTPlayer=function(){
var player;
if(this.currentState!==this.STATE.YT_BLANK){
DEBUG.console(DEBUG.LVL.WARN,'toYTPlayer invalid state:'+
this.currentState);
return this;}
this.player=new YT.Player(this.id,{
width:this.width,
height:this.height,
videoId:this.attr.src,
playerVars:YouTube.commonPlayerVars,
events:YouTube.commonEvents
});
this.currentState=this.STATE.YT_PLAYER;
return this;};
ContentOfGrid.prototype.reloadThumnail=function(){
var eleThumnail;
if(!this.attr.thumnail1){
return this;}
eleThumnail=document.getElementById(this.thumnailId);
if(!eleThumnail){
DEBUG.console(DEBUG.LVL.WARN,'reloadThumnail element not found');
return this;}
eleThumnail.src=this.attr.thumnail1+'?'+Date.now();
this.dispThumnail=true;
eleThumnail.parentNode.parentNode.classList.add('dispThumnail');
eleThumnail.parentNode.classList.remove('visible');
return this;};
ContentOfGrid.prototype.getIconFilePath=function(){
var path=null,scheme;
switch(this.kind){
case KIND.YOUTUBE:
path=ICON_PATH.YOUTUBE;
break;
case KIND.ONAIR:
if(this.attr.content===CONTENT.TV&&this.attr.src){
scheme=this.attr.src.slice(0,this.attr.src.indexOf(':'));
switch(scheme){
case 'dvb-t':
case 'isdb-t':
path=ICON_PATH.TV_TERR_DIGI;
break;
case 'ana':
path=ICON_PATH.TV_TERR_ANA;
break;
case 'dvb-c':
case 'ana-c':
path=ICON_PATH.TV_CABLE;
break;
case 'dvb-s':
case 'freesat':
case 'isdb-s':
path=ICON_PATH.TV_SATELLITE;
break;
case 'dvb-ip':
path=ICON_PATH.TV_DVB_IP;
break;
default:
}
}else if(this.attr.content===CONTENT.OTHER){
path=ICON_PATH.INPUT;}
break;
case KIND.VOD:
path=ICON_PATH.VOD;
break;
case KIND.RECORDED:
path=ICON_PATH.RECORDED;
break;
case KIND.SD:
case KIND.USB:
case KIND.SAMBA:
switch(this.attr.content){
case CONTENT.PICTURE:
path=ICON_PATH.PHOTO;
break;
case CONTENT.VIDEO:
path=ICON_PATH.VIDEO;
break;
case CONTENT.AUDIO:
path=ICON_PATH.MUSIC;
break;
default:
}
break;
case KIND.DIGA:
path=ICON_PATH.DIGA;
break;
case KIND.ACTVILA:
path=ICON_PATH.ACTVILA;
break;
case KIND.MEMO:
switch(this.attr.content){
case CONTENT.VIDEO:
path=ICON_PATH.VIDEO_MEMO;
break;
case CONTENT.AUDIO:
path=ICON_PATH.VOICE_MEMO;
break;
default:
path=ICON_PATH.MEMO;}
break;
case KIND.BOOKMARK:
path=ICON_PATH.BOOKMARK;
break;
default:
}
return path;};
ContentOfGrid.prototype.getDefaultImagePath=function(){
var path=null;
switch(this.attr.content){
case CONTENT.TV:
if(app_launcher.checkTvService(this)==='future'){
path=ICON_PATH.DEFAULT_TV_FUTURE;}else {
path=ICON_PATH.DEFAULT_TV;}
break;
case CONTENT.PICTURE:
path=ICON_PATH.DEFAULT_PICTURE;
break;
case CONTENT.VIDEO:
path=ICON_PATH.DEFAULT_VIDEO;
break;
case CONTENT.AUDIO:
path=ICON_PATH.DEFAULT_AUDIO;
break;
case CONTENT.OTHER:
path=ICON_PATH.DEFAULT_OTHER;
break;
default:
path=ICON_PATH.DEFAULT_OTHER;}
return path;};
ContentOfGrid.prototype.getTextElement=function(type){
var textAll=[],ele1,ele2,ele3,ele4,textList,
date,dateEnd,dateSec,timezoneOffset;
ele1=document.createElement('span');
ele2=document.createElement('span');
ele3=document.createElement('span');
ele4=document.createElement('span');
switch(this.kind){
case KIND.ONAIR:
if(this.attr.content===CONTENT.OTHER){
ele1.textContent=this.attr.title||'';
textAll.push(ele1);}else {
if(type==='detail'){
ele1.textContent=this.attr.srvName||'';
ele2.textContent=this.attr.title||'';
ele3.appendChild(this.getOnAirTimeText());
textAll.push(ele1,ele2,ele3);}else {
ele4.textContent=this.attr.srvName||'';
ele1.textContent=this.attr.title||'';
textList=this.getOnAirTimeText(true);
ele2.appendChild(textList[0]);
ele3.appendChild(textList[1]);
textAll.push(ele1,ele2,ele3,ele4);}
}
break;
case KIND.RECORDED:
case KIND.DIGA:
if(type==='detail'){
ele1.textContent=this.attr.srvName||'';
ele2.textContent=this.attr.title||'';
ele3.appendChild(this.getOnAirTimeText());
textAll.push(ele1,ele2,ele3);}else {
ele4.textContent=this.attr.srvName||'';
ele1.textContent=this.attr.title||'';
textList=this.getOnAirTimeText(true);
ele2.appendChild(textList[0]);
ele3.appendChild(textList[1]);
textAll.push(ele1,ele2,ele3,ele4);}
break;
case KIND.SD:
case KIND.USB:
case KIND.SAMBA:
ele1.textContent=this.attr.title||'';
ele2=this.getTimeAndDurationElement();
textAll.push(ele1,ele2);
break;
case KIND.YOUTUBE:
ele1.textContent=this.attr.title||'';
ele2=this.getTimeAndDurationElement();
ele3.textContent=this.attr.viewCount+' '+
FIX_WORDS.VIEWS+' '+
this.attr.commentCount+' '+
FIX_WORDS.COMMENTS;
textAll.push(ele1,ele2,ele3);
break;
case KIND.ACTVILA:
ele1.textContent=this.attr.title||'';
ele2=this.getTimeAndDurationElement();
textAll.push(ele1,ele2);
break;
case KIND.MEMO:
if(typeof this.attr.time==='number'&&isValidTime(this.attr.time)){
date=new Date(this.attr.time*1000);
ele1.textContent=formatDateOfMedia(date);}
if(typeof this.attr.duration==='number'){
ele2.textContent=formatSeconds(this.attr.duration);}
textAll.push(ele1,ele2);
break;
case KIND.BOOKMARK:
ele1.textContent=this.attr.title||'';
textAll.push(ele1);
break;
case KIND.VOD:
ele1.textContent=this.attr.title||'';
ele2=this.getTimeAndDurationElement();
textAll.push(ele1,ele2);
break;
default:
}
return textAll;};
ContentOfGrid.prototype.getOnAirTimeText=function(splitFlag){
var eleText1,eleText0,eleDuration,eleStart,eleHy,eleEnd,tmpStr,
textNode,text,textList,timeFormat,dateFormat,date,dateEnd;
eleText0=document.createElement('span');
eleText1=document.createElement('span');
if((this.kind!==KIND.ONAIR&&this.kind!==KIND.RECORDED&&
this.kind!==KIND.DIGA)||!isValidTime(this.attr.time)){
return (splitFlag!==true)?eleText1:([eleText0,eleText1]);}
date=new Date(this.attr.time*1000);
switch(Configurations.displayInfoType){
case 0:
timeFormat='hh:mm';
dateFormat='Nnn dd.mm';
break;
case 1:
timeFormat='hh:mm';
dateFormat='Nnn d.Mmm';
break;
case 2:
timeFormat='hh:mm cc';
dateFormat='Nnn dd.Mmm';
break;
case 3:
timeFormat='hh:mm';
dateFormat='Nnn dd.Mmm';
break;
case 4:
timeFormat='hh:mm';
dateFormat='dd/mm Nnn';
break;
case 5:
timeFormat='hh:mm';
dateFormat='MnnDdd(Nnn)';
break;
case 6:
timeFormat='hh:mm cc';
dateFormat='Mm/dd Nnn';
break;
default:
timeFormat='hh:mm';
dateFormat='Nnn dd.mm';}
eleText1.textContent=formatTime(date)+' - ';
eleDuration=dom.createElement('span',{className:'cnInfoDuration'});
if(this.attr.duration&&this.attr.duration!==-1){
dateEnd=new Date((this.attr.time+this.attr.duration)*1000);
eleDuration.textContent=formatTime(dateEnd);}
eleText1.appendChild(eleDuration);
if(splitFlag!==true){
tmpStr=' '+formatDate(date,this.kind===KIND.ONAIR?false:true);
textNode=document.createTextNode(tmpStr);
eleText1.appendChild(textNode);
return eleText1;}else {
textList=[];
eleText0.textContent=formatDate(date,this.kind===KIND.ONAIR?false:true);
textList[0]=eleText0;
textList[1]=eleText1;
return textList;}
};
ContentOfGrid.prototype.getTimeAndDurationElement=function(){
var date,eleTime,eleDuration,format='hh:mm:ss',
df=document.createDocumentFragment();
if(typeof this.attr.time!=='number'){
return df;}
date=new Date(this.attr.time*1000);
eleTime=dom.createElement('span',{className:'cnInfoTime'});
eleTime.textContent=formatDateOfMedia(date);
df.appendChild(eleTime);
if(this.attr.content==CONTENT.TV||
this.attr.content===CONTENT.VIDEO||
this.attr.content===CONTENT.AUDIO){
eleDuration=dom.createElement('span',{className:'cnInfoDuration'});
if(typeof this.attr.duration==='number'){
if(this.kind===KIND.RECORDED||this.kind===KIND.DIGA){
format='hh:mm';}
eleDuration.textContent=formatSeconds(this.attr.duration,format);}
df.appendChild(eleDuration);}
return df;};
ContentOfGrid.prototype.isPlayable=function(){
var playable=false;
if(!this.attr.src){
return false;}
if(this.attr.content===CONTENT.TV){
if(app_launcher.checkTvService(this)=='live'){
return true;}else {
return false;}
}
switch(this.kind){
case KIND.ONAIR:
playable=true;
break;
case KIND.RECORDED:
playable=true;
break;
case KIND.SD:
case KIND.USB:
case KIND.SAMBA:
if(this.attr.content===CONTENT.VIDEO||
this.attr.content===CONTENT.AUDIO){
playable=true;}
break;
case KIND.DIGA:
playable=true;
break;
case KIND.MEMO:
if(this.attr.content===CONTENT.VIDEO||
this.attr.content===CONTENT.AUDIO){
playable=true;}
break;
default:
}
return playable;};
ContentOfGrid.prototype.isPlayer=function(){
return (this.currentState===this.STATE.PLAYER||
this.currentState===this.STATE.YT_BLANK||
this.currentState===this.STATE.YT_PLAYER);};
ContentOfGrid.prototype.preparePlay=function(){
if(this.currentState===this.STATE.PLAYER&&this.player){
if(this.playerInfo.prepare===false){
this.player.addEventListener('error',function(embed){
commonMediaErrorEvent(embed);},false);
if(this.kind===KIND.RECORDED||
(this.isLocalContent()&&
typeof this.attr.duration!=='number')){
this.player.addEventListener('durationchange',
function(embed){
commonDurationChangeEvent(embed);},
false);}
if(this.attr.content!==CONTENT.AUDIO){
this.player.parentNode.classList.add('playingVideo');}
this.playerInfo.prepare=true;}
if(this.attr.content===CONTENT.AUDIO){
if(this.muted===false){
this.play();}
}else {
this.play();}
}else if(this.currentState===this.STATE.YT_BLANK){
this.toYTPlayer();
this.playerInfo.prepare=true;}
return this;};
ContentOfGrid.prototype.play=function(){
if(!this.player||this.playerInfo.playing){
return this;}
if(this.kind===KIND.YOUTUBE){
try{
this.player.playVideo();}catch(e){
}
}else {
if(typeof this.player.play==='function'){
DEBUG.console(DEBUG.LVL.VERBOSE,'player.play: id='+this.id);
this.player.play();}
}
this.playerInfo.playing=true;
return this;};
ContentOfGrid.prototype.stop=function(){
if(!this.player){
return this;}
if(this.kind===KIND.YOUTUBE){
try{
this.player.stopVideo();}catch(e){
}
}else {
if(typeof this.player.stop==='function'){
DEBUG.console(DEBUG.LVL.VERBOSE,'player.stop: id='+this.id);
this.player.stop();}
}
this.playerInfo.playing=false;
return this;};
ContentOfGrid.prototype.beforeStreaming=function(){
if(!this.player){
return this;}
if(this.kind!==KIND.YOUTUBE&&
this.playerInfo.streaming===false){
this.player.streaming=this.playerInfo.streaming=true;}
return this;};
ContentOfGrid.prototype.afterStreaming=function(){
if(!this.player){
return this;}
if(this.kind!==KIND.YOUTUBE&&
this.playerInfo.streaming===true){
this.player.streaming=this.playerInfo.streaming=false;}
return this;};
ContentOfGrid.prototype.mute=function(){
if(!this.player){
return this;}
if(this.kind===KIND.YOUTUBE){
}else {
if(this.muted===false){
this.player.muted=this.muted=true;
if(this.attr.content===CONTENT.AUDIO){
this.stop();}
}
}
return this;};
ContentOfGrid.prototype.unmute=function(){
if(!this.player){
return this;}
if(this.kind===KIND.YOUTUBE){
}else {
if(this.muted===true){
this.player.muted=this.muted=false;
if(this.attr.content===CONTENT.AUDIO){
this.play();}
}
}
return this;};
ContentOfGrid.prototype.isMainArea=function(){
return (this.column<=1);};
ContentOfGrid.prototype.removePlayer=function(){
var elePlayer;
if(!this.player){
return this;}
if(this.kind===KIND.YOUTUBE){
try{
this.player.clearVideo();}catch(e){
}
try{
this.player.destroy();}catch(e){
}
}else {
this.player.parentNode.classList.remove('playingVideo');}
elePlayer=document.getElementById(this.id);
if(elePlayer){
elePlayer.parentNode.removeChild(elePlayer);
elePlayer=null;}
this.player=null;
this.playerInfo.prepare=false;
this.currentState=this.STATE.THUMNAIL;
return this;};
ContentOfGrid.prototype.remove=function(){
var elePlayer,eleThumnail;
if(this.player){
this.stop().removePlayer();}
eleThumnail=document.getElementById(this.thumnailId);
if(eleThumnail){
eleThumnail.removeEventListener('error',commonThumnailEvent,false);
eleThumnail.removeEventListener('load',commonThumnailEvent,false);
eleThumnail.parentNode.removeChild(eleThumnail);
eleThumnail=null;}
this.currentState=this.STATE.NONE;
return this;};
ContentOfGrid.prototype.destroy=function(){
this.attr=null;
return this;};
GridFrame=function(id,fourFrame,contentId,content){
this.id=id;
this.fourFrame=fourFrame;
this.contentId=contentId;
this.contentThumnailId=contentId+'_thum';
this.content=content||null;};
GridFrame.prototype.hideOverlay=function(eleFrame){
var eleOverlay;
if(!eleFrame){
eleFrame=document.getElementById(this.id);}
eleOverlay=eleFrame.lastChild;
if(eleOverlay.className==='contentOverlay'){
eleOverlay.style.display='none';}
return this;};
GridFrame.prototype.showOverlay=function(eleFrame){
var eleOverlay;
if(this.content===null){
return this;}
if(!eleFrame){
eleFrame=document.getElementById(this.id);}
eleOverlay=eleFrame.lastChild;
if(eleOverlay.className==='contentOverlay'){
eleOverlay.style.display='block';}
return this;};
GridFrame.prototype.setOverlayInfo=function(eleFrame){
var eleOverlay;
if(!eleFrame){
eleFrame=document.getElementById(this.id);}
eleOverlay=eleFrame.lastChild;
if(eleOverlay.className!=='contentOverlay'){
return this;}
if(this.content!==null){
if(this.content.kind!==KIND.ACTVILA){
eleOverlay.children[0].classList.remove('hidden');
eleOverlay.children[0].children[0].src=this.content.getIconFilePath();}else {
eleOverlay.children[0].classList.add('hidden');
eleOverlay.children[0].children[0].removeAttribute('src');}
if(this.content.attr.favRegist){
eleOverlay.children[1].classList.add('show');}else {
eleOverlay.children[1].classList.remove('show');}
eleOverlay.style.display='block';}else {
eleOverlay.children[0].children[0].src=null;
eleOverlay.children[1].classList.remove('show');
eleOverlay.style.display='none';}
return this;};
GridFrame.prototype.setTextInfo=function(eleFrame){
var eleTextWrap,textList;
if(!eleFrame){
eleFrame=document.getElementById(this.id);}
eleTextWrap=eleFrame.lastChild.previousSibling;
if(eleTextWrap.className!=='contentTextWrap'){
return this;}
eleTextWrap.children[0].innerHTML='';
eleTextWrap.children[1].innerHTML='';
eleTextWrap.children[2].innerHTML='';
eleTextWrap.children[3].innerHTML='';
eleTextWrap.children[3].classList.remove('bottomEnd');
if(this.content!==null){
textList=this.content.getTextElement('frame');
if(textList[0]){
eleTextWrap.children[0].appendChild(textList[0]);}
if(textList[1]){
eleTextWrap.children[1].appendChild(textList[1]);}
if(textList[2]){
eleTextWrap.children[2].appendChild(textList[2]);}
if(textList[3]){
eleTextWrap.children[3].appendChild(textList[3]);
if(this.content.kind===KIND.ONAIR||
this.content.kind===KIND.RECORDED||
this.content.kind===KIND.DIGA){
eleTextWrap.children[3].classList.add('bottomEnd');}
}
}
return this;};
gridPlayControl={
timerId:-1,
list:[],
conMainArea:null,
conSubArea:null,
unmuteTarget:null,
add:function(content){
var info,vContainer;
this.unmuteTarget=content;
if(Configurations.streamingUI===false){
if(maxVideoNum===1){
this.conMainArea=content;
return this;}
if(content.isMainArea()){
this.conMainArea=content;
if(this.conSubArea&&this.conSubArea.mainOnly){
this.conSubArea=null;}
}else {
this.conSubArea=content;
if(content.mainOnly){
this.conMainArea=null;}
}
}else {
vContainer=0;
if(this.list.length===0){
vContainer=0;}else if(this.list.length<maxVideoNum){
info=this.list[0];
if(info.vc===0){
vContainer=1;}
}else {
info=this.list.shift();
vContainer=(maxVideoNum===1)?0:info.vc;}
this.list.push({vc:vContainer,content:content});}
return this;},
isMax:function(){
if(Configurations.streamingUI===false){
if(maxVideoNum===1){
if(this.conMainArea!==null){
return true;}
}else {
if(this.conMainArea!==null&&
this.conSubArea!==null){
return true;}
}
if(maxVideoNum===1&&this.conMainArea){
return true;}
}else {
if(this.list.length>=maxVideoNum){
return true;}
}
return false;},
beforeStreaming:function(){
DEBUG.console(DEBUG.LVL.VERBOSE,'beforeStreaming');
var i,max;
if(Configurations.streamingUI===false||
scrollControl.scrollType!=='stream'){
return this;}
for(i=0,max=this.list.length;i<max;i+=1){
this.list[i].content.beforeStreaming();}
return this;},
afterStreaming:function(){
DEBUG.console(DEBUG.LVL.VERBOSE,'afterStreaming');
var i,max;
if(Configurations.streamingUI===false||
scrollControl.scrollType!=='stream'){
return this;}
for(i=0,max=this.list.length;i<max;i+=1){
this.list[i].content.afterStreaming();}
return this;},
startTimer:function(){
if(this.timerId>=0){
clearTimeout(this.timerId);}
this.timerId=setTimeout(this.switchPlay.bind(this),TIME.SWITCH_PLAY);
return this;},
stopTimer:function(){
if(this.timerId>=0){
clearTimeout(this.timerId);
this.timerId=-1;}
return this;},
existContent:function(content){
var i,max;
if(content===null){
return false;}
if(Configurations.streamingUI===false){
if(content===this.conMainArea||content===this.conSubArea){
return true;}
}else {
for(i=0,max=this.list.length;i<max;i+=1){
if(content===this.list[i].content){
return true;}
}
}
return false;},
giveUpContent:function(content){
DEBUG.console(DEBUG.LVL.INFO,'gridPlayControl.giveUpContent');
var i,max;
if(content===null){
return this;}
if(Configurations.streamingUI===false){
if(content===this.conMainArea||content===this.conSubArea){
content.stop().removePlayer();
this.unmuteTarget=null;
if(content===this.conMainArea){
this.conMainArea=null;
if(this.conSubArea!==null){
this.unmuteTarget=this.conSubArea.unmute();}
}else {
this.conSubArea=null;
if(this.conMainArea!==null){
this.unmuteTarget=this.conMainArea.unmute();}
}
}
}else {
this.unmuteTarget=null;
for(i=0,max=this.list.length;i<max;i+=1){
if(content===this.list[i].content){
content.stop().removePlayer();
this.list.splice(i,1);
break;}
}
for(i=0,max=this.list.length;i<max;i+=1){
if(content!==this.list[i].content){
this.unmuteTarget=this.list[i].content.unmute();
break;}
}
}
return this;},
giveUpMuteContent:function(){
DEBUG.console(DEBUG.LVL.INFO,'gridPlayControl.giveUpMuteContent');
var i,max,content;
if(Configurations.streamingUI===false){
if(this.unmuteTarget===null){
return this;}
if(this.conMainArea!==null&&
this.conMainArea!==this.unmuteTarget){
content=this.conMainArea;
content.stop().removePlayer();
this.conMainArea=null;
if(this.conSubArea!==null){
this.conSubArea.unmute();}
}else if(this.conSubArea!==null&&
this.conSubArea!==this.unmuteTarget){
content=this.conSubArea;
content.stop().removePlayer();
this.conSubArea=null;
this.conSubArea=null;
if(this.conMainArea!==null){
this.conMainArea.unmute();}
}
}else {
if(this.unmuteTarget===null){
return this;}
for(i=0,max=this.list.length;i<max;i+=1){
if(this.unmuteTarget!==this.list[i].content){
content=this.list[i].content;
content.stop().removePlayer();
this.list.splice(i,1);
break;}
}
for(i=0,max=this.list.length;i<max;i+=1){
this.list[i].content.unmute();
break;}
}
return this;},
giveUpAll:function(){
DEBUG.console(DEBUG.LVL.WARN,'gridPlayControl.giveUpAll');
var i,max,content;
if(Configurations.streamingUI===false){
if(this.conMainArea!==null){
content=this.conMainArea;
content.stop().removePlayer();}
if(this.conSubArea!==null){
content=this.conSubArea;
content.stop().removePlayer();}
}else {
for(i=0,max=this.list.length;i<max;i+=1){
content=this.list[i].content;
content.stop().removePlayer();}
}
this.clearList();
return this;},
switchPlay:function(){
DEBUG.console(DEBUG.LVL.VERBOSE,'switchPlay start.');
var i,max,targetObj,content,frame,contentStop,stopList=[],
eleFrame,elePlayer,vContainer;
targetObj=gridData.viewTable[gridFocusPos.x][gridFocusPos.y];
content=targetObj.frame.content;
if(!content||!content.isPlayable()){
return this;}
if(Configurations.streamingUI===false){
if(content===this.conMainArea&&this.conSubArea===null||
content===this.conSubArea&&this.conMainArea===null){
return this;}
if(content===this.conMainArea||content===this.conSubArea){
this.switchMute(content);
return this;}
this.stopForSwitch(content);}else {
for(i=0,max=this.list.length;i<max;i+=1){
if(content===this.list[i].content){
if(content!==this.unmuteTarget){
this.switchMuteLD6(content);}
return this;}
}
this.stopForSwitchLD6(content);
vContainer=this.getVideoContainer(content);}
eleFrame=document.getElementById(targetObj.frame.id);
elePlayer=content.createPlayerElement(false,vContainer);
eleFrame.insertBefore(elePlayer,eleFrame.firstChild.nextSibling);
content.preparePlay();
return this;},
stopForSwitch:function(content){
DEBUG.console(DEBUG.LVL.VERBOSE,'stopForSwitch start.');
var i,max,contentStop,stopList=[];
if(maxVideoNum===1&&this.conMainArea!==null){
stopList.push(this.conMainArea);
this.unmuteTarget=this.conMainArea=content;}else if(maxVideoNum>1){
if(content.isMainArea()){
if(this.conMainArea!==null){
stopList.push(this.conMainArea);}
this.unmuteTarget=this.conMainArea=content;
if(this.conSubArea!==null&&this.conSubArea.mainOnly){
stopList.push(this.conSubArea);
this.conSubArea=null;}
}else {
if(this.conSubArea!==null){
stopList.push(this.conSubArea);}
this.unmuteTarget=this.conSubArea=content;
if(this.conMainArea!==null&&content.mainOnly){
stopList.push(this.conMainArea);
this.conMainArea=null;}
}
}
for(i=0,max=stopList.length;i<max;i+=1){
contentStop=stopList[i];
contentStop.stop().removePlayer();
if(!contentStop.dispThumnail&&
(contentStop.kind===KIND.RECORDED||contentStop.isLocalContent())){
contentStop.reloadThumnail();}
}
if(this.conMainArea!==null&&this.conMainArea!==content){
this.conMainArea.mute();}
if(this.conSubArea!==null&&this.conSubArea!==content){
this.conSubArea.mute();}
return this;},
stopForSwitchLD6:function(content){
DEBUG.console(DEBUG.LVL.VERBOSE,'stopForSwitchLD6 start.');
var i,max,info;
if(this.list.length>=maxVideoNum){
info=this.list.shift();
if(info){
info.content.stop().removePlayer();
if(!info.content.dispThumnail&&
(info.content.kind===KIND.RECORDED||
info.content.isLocalContent())){
info.content.reloadThumnail();}
}
}
for(i=0,max=this.list.length;i<max;i+=1){
this.list[i].content.mute();}
this.add(content);
return this;},
switchMute:function(content){
if(this.conMainArea===null||this.conSubArea===null){
return this;}
if(content===this.conMainArea){
this.conSubArea.mute();
this.unmuteTarget=this.conMainArea.unmute();}else {
this.conMainArea.mute();
this.unmuteTarget=this.conSubArea.unmute();}
return this;},
switchMuteLD6:function(content){
var target;
if(this.list.length!==2){
return this;}
if(content===this.list[0].content){
this.list[1].content.mute();
this.unmuteTarget=this.list[0].content.unmute();}else {
this.list[0].content.mute();
this.unmuteTarget=this.list[1].content.unmute();}
return this;},
setUnmuteTarget:function(content){
var i,max;
if(content===null){
return this;}
if(Configurations.streamingUI===false){
if(content===this.conMainArea||content===this.conSubArea){
this.unmuteTarget=content;}
}else {
for(i=0,max=this.list.length;i<max;i+=1){
if(content===this.list[i].content){
this.unmuteTarget=content;
break;}
}
}
return this;},
getVideoContainer:function(content){
var i,max;
if(Configurations.streamingUI===false||
!content||this.list.length===0){
return 0;}
for(i=0,max=this.list.length;i<max;i+=1){
if(content===this.list[i].content){
return this.list[i].vc;}
}
return 0;},
startPlay:function(onlyPlay){
var i,max;
if(Configurations.streamingUI===false){
if(onlyPlay===true){
if(this.conMainArea!==null){
this.conMainArea.play();}
if(this.conSubArea!==null){
this.conSubArea.play();}
}else {
if(this.conMainArea!==null){
this.conMainArea.preparePlay();}
if(this.conSubArea!==null){
this.conSubArea.preparePlay();}
}
}else {
for(i=0,max=this.list.length;i<max;i+=1){
if(onlyPlay===true){
this.list[i].content.play();}else {
this.list[i].content.preparePlay();}
}
}
return this;},
stopPlay:function(){
var i,max;
if(Configurations.streamingUI===false){
if(this.conMainArea!==null){
this.conMainArea.stop();}
if(this.conSubArea!==null){
this.conSubArea.stop();}
}else {
for(i=0,max=this.list.length;i<max;i+=1){
this.list[i].content.stop();}
}
return this;},
clearList:function(){
var target;
if(Configurations.streamingUI===false){
this.conSubArea=this.conMainArea=null;}else {
target=this.list.pop();
while(target){
target=this.list.pop();}
}
this.unmuteTarget=null;
return this;}
};
scrollControl={
WHEEL_DOWN:-1,
WHEEL_UP:1,
SCROLL_PREV:0,
SCROLL_NEXT:1,
timerId:-1,
isScrolling:false,
pageCount:1,
pageIndex:0,
barSize:0,
scrollType:'page',lastTrigger:null,
delayTimerId:-1,
init:function(){
var that=this,target,focusIndex,selectId;
if(Configurations.streamingUI===false){
return this;}
selectId=settingMenu.getSetting('scroll_type').id;
if(selectId==='stream'){
this.scrollType='stream';
this.setScrollTypeStyle();}
system.effect.onScroll=function(){
DEBUG.console(DEBUG.LVL.INFO,'system.effect.onScroll');
if(that.isScrolling===true){
updateContentsAfterStreamScroll(scrollControl.SCROLL_NEXT);
that.exeScroll(scrollControl.SCROLL_NEXT,'onscroll');}
};
return this;},
setScrollTypeStyle:function(){
var ele=document.getElementById('cAreaMove');
if(!ele){
return this;}
if(this.scrollType==='page'){
ele.classList.remove('typeStream');
mainFocus.ele.classList.remove('cmn_on_with_scaling');
mainFocus.ele.classList.remove('cmn_origin_center');}else {
ele.classList.add('typeStream');
mainFocus.ele.classList.add('cmn_on_with_scaling');
mainFocus.ele.classList.add('cmn_origin_center');}
return this;},
updateScrollType:function(selectId){
if(selectId==='stream'){
this.scrollType='stream';}else {
this.scrollType='page';}
this.setScrollTypeStyle();},
startTimer:function(time){
var delayTime,selectId;
if(time){
delayTime=time;}else if(this.scrollType==='stream'){
delayTime=TIME.DELAY_STREAMING;}else {
selectId=settingMenu.getSetting('scroll_interval').id;
switch(selectId){
case '15s':
delayTime=15000;
break;
case '30s':
delayTime=30000;
break;
case '60s':
delayTime=60000;
break;
default:
delayTime=TIME.AUTO_WAVE;}
}
if(this.timerId>=0){
clearTimeout(this.timerId);}
this.timerId=setTimeout(this.wheelHandler.bind(this,this.WHEEL_DOWN,'timer'),delayTime);
return this;},
stopTimer:function(){
if(this.timerId>=0){
clearTimeout(this.timerId);
this.timerId=-1;}
return this;},
wheelHandler:function(delta,trigger){
var direction=(delta<0)?this.SCROLL_NEXT:this.SCROLL_PREV;
if(this.isScrolling){
return this;}
switch(screenState){
case SCREEN_STATE.MAIN_READY:if(mainFocus.enable===true&&!dialogUI.isOpen()){
this.exeScroll(direction,trigger);}else {
this.startTimer();}
break;
default:
}
return this;},
resizeScrollBar:function(contentsNum,contentsIndex){
DEBUG.console(DEBUG.LVL.VERBOSE,'scrollControl.resizeScrollBar contentsNum:'+
contentsNum+', contentsIndex:'+contentsIndex);
var ele,pageCount=0,viewPage=0;
ele=document.getElementById('scrollBarParam');
pageCount=Math.ceil(contentsNum/maxViewContents);
viewPage=Math.floor(contentsIndex/maxViewContents);
this.pageCount=(pageCount===0)?1:pageCount;
this.barSize=100/this.pageCount;
this.pageIndex=viewPage;
ele.style.width=this.barSize+'%';
ele.style.left=(this.pageIndex*this.barSize)+'%';
return this;},
moveScrollBar:function(direction,contentsNum){
var ele=document.getElementById('scrollBarParam');
if(direction===this.SCROLL_PREV){
if(this.pageIndex>0){
this.pageIndex-=1;}else {
this.pageIndex=this.pageCount-1;}
}else {
if(this.pageIndex<this.pageCount-1){
this.pageIndex+=1;}else {
this.pageIndex=0;}
}
ele.style.left=(this.pageIndex*this.barSize)+'%';},
exeScroll:function(direction,trigger){
DEBUG.console(DEBUG.LVL.INFO,'exeScroll start. direction:'+direction);
var scrollPosition,that=this;
if(contentsList.length<=maxViewContents){
return;}
hideContentInfo();
if(this.scrollType==='page'){
if(focusPosition===FOCUS_POSITION.GRID&&
mainFocus.currentState!==domFocus.STATE.OFF){
mainFocus.off();}
}else {
if(mainFocus.currentState!==domFocus.STATE.OFF){
mainFocus.off();
mainFocus.ele.classList.remove('cmn_circle');
if(trigger==='timer'){
mainFocus.ele.style[domStyleNameTransform]='scale(1.3)';
gridFocusPos.y=0;}
tooltipUI.hide();}
}
this.isScrolling=true;
this.lastTrigger=trigger;
clearTimeout(this.delayTimerId);
this.delayTimerId=setTimeout(function(){
var duration,selectId;
clearTimeout(that.delayTimerId);
that.delayTimerId=-1;
if(that.scrollType==='page'){
if(screenState!==SCREEN_STATE.MAIN_READY){
that.isScrolling=false;
return;}
that.startPageScroll(direction);}else {
if(trigger==='timer'||trigger==='user'){
selectId=settingMenu.getSetting('scroll_interval').id;
switch(selectId){
case '15s':
duration=15;
break;
case '30s':
duration=30;
break;
case '60s':
duration=60;
break;
default:
duration=15;}
systemEffect.start(EFFECT.STREAM,duration);}
gridPlayControl.beforeStreaming();
that.startStreamScroll(direction,trigger);}
},100);},
startPageScroll:function(direction){
DEBUG.console(DEBUG.LVL.INFO,'startPageScroll');
var effectType,column,row,target,removeIndexList,lessThanPosList,
scrollable=true,resize=false,checkLessThanPos,
readyContents,afterTimeoutFunc,content;
systemEffect.start(direction===scrollControl.SCROLL_PREV?
EFFECT.PAGE_PREV:EFFECT.PAGE_NEXT);
gridPlayControl.stopPlay().clearList();
imageLoadObserver.clear();
if(contentsList.length){
removeIndexList=checkContentsList(contentsList);
if(contentsData.filterId){
checkContentsList(contentsData.orgList);}
if(contentsList.length<=maxViewContents){
scrollable=false;
resize=true;}else if(removeIndexList.length>0){
resize=true;
checkLessThanPos=function(value){
return (listPosition>=value);};
lessThanPosList=removeIndexList.filter(checkLessThanPos);
listPosition-=lessThanPosList.length;
if(listPosition<0){
listPosition=0;}
}
}
if(scrollable){
if(direction===scrollControl.SCROLL_PREV){
listPosition=(listPosition-maxViewContents<0)?
contentsList.length+(listPosition-maxViewContents):
listPosition-maxViewContents;}else {
listPosition=(listPosition+maxViewContents<contentsList.length)?
listPosition+maxViewContents:
(listPosition+maxViewContents)-contentsList.length;}
}else {
listPosition=0;}
if(resize){
scrollControl.resizeScrollBar(contentsList.length,listPosition);}else {
scrollControl.moveScrollBar(direction);}
setContentToViewTable();
if(focusPosition===FOCUS_POSITION.GRID&&
gridFocusPos.x>=0&&gridFocusPos.y>=0){
content=gridData.viewTable[gridFocusPos.x][gridFocusPos.y].frame.content;
if(content&&content.isPlayable()){
if(!gridPlayControl.existContent(content)){
gridPlayControl.add(content);}else {
gridPlayControl.setUnmuteTarget(content);}
}
}
for(column=0;column<MAX_COLUMN;column+=1){
for(row=0;row<MAX_ROW;row+=1){
target=gridData.viewTable[column][row];
if(typeof target==='object'&&target.frame.content){
appendContentElement(target.frame);}
}
}
gridPlayControl.startPlay();
afterTimeoutFunc=function(){
if(screenState===SCREEN_STATE.MAIN_READY){
return true;}
scrollControl.isScrolling=false;
return false;};
readyContents=function(){
if(afterTimeoutFunc()===false){
return;}
systemEffect.finish();
setTimeout(function(){
if(afterTimeoutFunc()===false){
return;}
systemEffect.stop();
setTimeout(function(){
var target,focusIndex,frameId;
if(afterTimeoutFunc()===false){
return;}
scrollControl.isScrolling=false;
scrollControl.startTimer();
if(focusPosition!==FOCUS_POSITION.GRID){
return;}
target=gridData.viewTable[gridFocusPos.x][gridFocusPos.y];
if(target.frame.content!==null){
setContentInfo(gridData.viewTable[gridFocusPos.x][gridFocusPos.y].frame.content);
frameId=gridData.viewTable[gridFocusPos.x][gridFocusPos.y].frame.id;
mainFocus.set(document.getElementById(frameId));}else {
focusIndex=modeControl.changeFocusIndex('left').focusIndex;
mainFocus.set(document.getElementById('fillBtn'+focusIndex));
focusPosition=FOCUS_POSITION.MODE_BUTTON;}
},0);},0);};
if(imageLoadObserver.observeList.length>0){
imageLoadObserver.observe(readyContents);}else {
setTimeout(function(){
readyContents();},0);}
},
startStreamScroll:function(direction,trigger){
DEBUG.console(DEBUG.LVL.INFO,'startSmoothScroll');
var that=this,effectType,column,row,i,max,target,removeIndexList,lessThanPosList,
scrollable=true,resize=false,areaName,eleAreaMove,eleFrameArea,
checkLessThanPos,readyContents,afterTimeoutFunc,area,moveColumn,
moveNum,needPlay=false,mscidList=[],side,restrainKey;
imageLoadObserver.clear();
if(contentsList.length){
if(direction===scrollControl.SCROLL_PREV){
area=gridData.area[gridData.areaOrder[1]];}else {
area=gridData.area[gridData.areaOrder[6]];}
for(i=0,max=area.sortList.length;i<max;i+=1){
target=area.sortList[i];
if(target.frame&&target.frame.content&&
target.frame.content.attr&&
target.frame.content.attr.mscid!==undefined){
mscidList.push(target.frame.content.attr.mscid);}
}
removeIndexList=checkContentsListByMscid(contentsList,mscidList);
if(contentsData.filterId){
checkContentsList(contentsData.orgList);}
if(contentsList.length<=maxViewContents){
scrollable=false;
listPosition=0;}else if(removeIndexList.length>0){
checkLessThanPos=function(value){
return (listPosition>=value);};
lessThanPosList=removeIndexList.filter(checkLessThanPos);
listPosition-=lessThanPosList.length;
if(listPosition<0){
listPosition=0;}
}
}
if(!scrollable){
this.stopScroll(null,true);
scrollControl.resizeScrollBar(contentsList.length,listPosition);
setFocusAfterStopScroll();
return;}
eleAreaMove=document.getElementById('cAreaMove');
if(direction===scrollControl.SCROLL_PREV){
area=gridData.area[gridData.areaOrder[5]];
moveColumn=area.columnWidth;
area=gridData.getLastArea();
gridData.moveArea('last');
eleFrameArea=document.getElementById('frameArea'+area.name);
if(eleFrameArea){
eleAreaMove.insertBefore(eleFrameArea,eleAreaMove.firstChild);}
updateOffsetColumn();
listPosition=(listPosition-3<0)?
contentsList.length+(listPosition-3):
listPosition-3;}else {
area=gridData.area[gridData.areaOrder[2]];
moveColumn=area.columnWidth*-1;
area=gridData.getFirstArea();
gridData.moveArea('first');
eleFrameArea=document.getElementById('frameArea'+area.name);
if(eleFrameArea){
eleAreaMove.appendChild(eleFrameArea);}
updateOffsetColumn();
listPosition=(listPosition+3<contentsList.length)?
listPosition+3:
(listPosition+3)-contentsList.length;}
afterTimeoutFunc=function(){
if(screenState===SCREEN_STATE.MAIN_READY&&scrollControl.isScrolling===true){
return true;}
scrollControl.isScrolling=false;
return false;};
readyContents=function(){
if(afterTimeoutFunc()===false){
return;}
systemEffect.scroll(moveColumn);
setTimeout(function(){
var side;
scrollControl.resizeScrollBar(contentsList.length,listPosition);
if(afterTimeoutFunc()===false){
return;}
if(trigger!=='user'){
return;}
that.stopScroll(direction);
side=(direction===scrollControl.SCROLL_NEXT)?
'right':'left';
setFocusAfterStopScroll(side);},0);};
setTimeout(function(){
readyContents();},0);},
stopScroll:function(direction,isBreak){
DEBUG.console(DEBUG.LVL.INFO,'stopScroll');
var needUpdate=true,restrainKey=function(){
mainFocus.enable=false;
setTimeout(function(){
mainFocus.enable=true;
scrollControl.startTimer();},100);};
if(direction===undefined){
direction=scrollControl.SCROLL_NEXT;}
systemEffect.stop();
if(this.delayTimerId>=0){
clearTimeout(this.delayTimerId);
this.delayTimerId=-1;
needUpdate=false;}
if(isBreak===true){
needUpdate=false;}
if(needUpdate){
updateContentsAfterStreamScroll(direction);}
gridPlayControl.afterStreaming();
stopPlayOutsideScreen();
this.isScrolling=false;
if(mainFocus.enable){
restrainKey();}
return this;}
};
userControl={
selectIndex:-1,
focusIndex:0,
userCount:0,
userIds:{},
userProfiles:{},
init:function(){
var i,max,targetId=null;
if(MHC.userProfile.getIds){
this.userIds=MHC.userProfile.getIds;
this.userCount=this.userIds.length;}
if(Configurations.profile_id>=0){
targetId=Configurations.profile_id;}else if(MHC.userProfile.current_id>=0){
targetId=MHC.userProfile.current_id;}
if(authProfileId>=0){
targetId=authProfileId;}
if(targetId!==null){
for(i=0,max=this.userIds.length;i<max;i++){
if(targetId===this.userIds[i]){
this.selectIndex=this.focusIndex=i;
break;}
}
}
this.renderUserInfo();},
setCurrentUserId:function(userId){
var i,max;
for(i=0,max=this.userIds.length;i<max;i++){
if(userId===this.userIds[i]){
this.selectIndex=this.focusIndex=i;
break;}
}
this.renderUserInfo();},
getCurrentUserId:function(){
if((Configurations.with_multi_profile)&&(this.userCount>0)&&this.selectIndex>=0){
return this.userIds[this.selectIndex];}else {
return null;}
},
getFocusUserProfile:function(){
var uid;
if((Configurations.with_multi_profile)&&(this.userCount>0)){
uid=this.userIds[this.focusIndex];
if(this.userProfiles[uid]){
return this.userProfiles[uid];}
return null;}else {
return null;}
},
renderUserInfo:function(){
var i,eleUserTemplate,eleParentUserDiv,eleUserDiv,eleUserIcon,
eleUserAreaId=document.getElementById('userArea');
for(i=eleUserAreaId.childNodes.length-1;i>=0;i--){
eleUserAreaId.removeChild(eleUserAreaId.childNodes[i]);}
eleParentUserDiv=document.createElement('div');
eleParentUserDiv.setAttribute('id','parentUserDiv');
eleUserTemplate=document.createElement('div');
eleUserTemplate.className='userDivParam';
for(i=0;i<this.userCount;i+=1){
eleUserDiv=eleUserTemplate.cloneNode(false);
eleUserDiv.id='user'+i;
if(i===this.selectIndex){
eleUserDiv.classList.add('activeUser');}
eleUserIcon=document.createElement('img');
eleUserIcon.setAttribute('id','userIcon'+i);
eleUserIcon.setAttribute('class','userIconParam');
var prof=MHC.userProfile.getById(this.userIds[i]);
if(prof){
this.userProfiles[this.userIds[i]]=prof;}
if(prof&&prof.icon){
eleUserIcon.setAttribute('src',prof.icon);}
eleUserDiv.appendChild(eleUserIcon);
eleParentUserDiv.appendChild(eleUserDiv);}
eleParentUserDiv.appendChild(dom.createElement('img',{
id:'userSettingIcon',
src:ICON_PATH.USER_SETTING,
alt:'setting icon'
}));
eleUserAreaId.appendChild(eleParentUserDiv);},
setFocus:function(lastSelected){
var eleUser,tmpIndex;
if(lastSelected){
tmpIndex=(this.selectIndex>=0)?this.selectIndex:this.userCount-1;}else {
tmpIndex=this.userCount-1;}
eleUser=document.getElementById('user'+tmpIndex);
mainFocus.ele.classList.add('cmn_circle');
if(mainFocus.currentState===domFocus.STATE.ON){
mainFocus.move(eleUser);}else {
mainFocus.set(eleUser);}
this.focusIndex=tmpIndex;
return this;},
moveFocus:function(direction){
var eleUser;
if(direction===1){if(this.focusIndex>=this.userCount-1){
return false;}
this.focusIndex+=1;}else {if(this.focusIndex===0){
return false;}
this.focusIndex-=1;}
eleUser=document.getElementById('user'+this.focusIndex);
mainFocus.move(eleUser);
return this;},
changeUser:function(){
var eleUser,lastSelectIndex=this.selectIndex,style;
if(this.selectIndex!==this.focusIndex){
this.selectIndex=this.focusIndex;
if(lastSelectIndex>=0){
eleUser=document.getElementById('user'+lastSelectIndex);
eleUser.classList.remove('activeUser');}else {
modeControl.setEnable('favorite',true);}
eleUser=document.getElementById('user'+this.selectIndex);
eleUser.classList.add('activeUser');
eleUser.classList.add('hoverFocus');}
if(eleUser){
mainFocus.off();}
return this;},
clearFocusStyle:function(){
var eleUser;
if(this.selectIndex<0){
return this;}
eleUser=document.getElementById('user'+this.selectIndex);
if(eleUser){
eleUser.classList.remove('hoverFocus');}
return this;}
};
modeControl={
selectIndex:0,
focusIndex:0,
modeList:null,
columnToIndexList:null,
indexToColumnList:null,
init:function(){
var eleWrap,eleBtn,eleBtnTemplate;
this.modeList=[
{name:'recommend',reqType:REQ_TYPE.RECOMMEND,
value:LANG('LT_MYSTRM_RECOMMEND'),enable:true},
{name:'popular',reqType:REQ_TYPE.POPULAR,
value:LANG('LT_MYSTRM_POPULAR'),enable:true}
];
if(Configurations.with_multi_profile){
this.modeList.push({name:'favorite',reqType:REQ_TYPE.FAVORITE,
value:LANG('LT_MYSTRM_FAVORITE'),enable:true});}
this.modeList.push({name:'search',reqType:REQ_TYPE.SEARCH,
value:LANG('LT_HOME_SEARCH'),enable:true});
this.modeList.push({name:'information',reqType:REQ_TYPE.INFO,enable:true});
if(this.modeList.length===4){
this.columnToIndexList=[0,0,1,2,3];
this.indexToColumnList=[1,2,3,4];}else {
this.columnToIndexList=[0,1,2,3,4];
this.indexToColumnList=[0,1,2,3,4];}
eleWrap=dom.createElement('div',{id:'filList'});
eleBtnTemplate=dom.createElement('div',{className:'fillBtn'});
var setModeInfoToButton=function(info,index){
var eleBtn=eleBtnTemplate.cloneNode(false);
eleBtn.id='fillBtn'+index;
if(info.name!=='information'){
eleBtn.textContent=info.value;
if(info.enable===false){
eleBtn.classList.add('disable');}
}else {
eleBtn.appendChild(dom.createElement('img',{className:'infoBtnIcon',
src:ICON_PATH.INFO}));
eleBtn.classList.add('infoBtn');}
eleWrap.appendChild(eleBtn);};
this.modeList.forEach(setModeInfoToButton);
document.getElementById('filter').appendChild(eleWrap);
return this;},
changeFocusIndex:function(pos_or_column){
var position,index;
if(typeof pos_or_column==='number'){
index=this.columnToIndexList[pos_or_column-offsetColumn];
this.focusIndex=index||0;}else {
switch(pos_or_column){
case 'left':
this.focusIndex=0;
break;
case 'center':
this.focusIndex=Math.floor(this.modeList.length/2);
break;
case 'right':
this.focusIndex=this.modeList.length-1;
break;
default:
}
}
return this;},
nextFocus:function(){
if(this.focusIndex>=this.modeList.length-1){
return false;}
this.focusIndex+=1;
mainFocus.move(document.getElementById('fillBtn'+this.focusIndex));
return true;},
prevFocus:function(){
if(this.focusIndex===0){
return false;}
this.focusIndex-=1;
mainFocus.move(document.getElementById('fillBtn'+this.focusIndex));
return true;},
getModeName:function(){
return this.modeList[this.focusIndex].name;},
getEnable:function(){
return this.modeList[this.focusIndex].enable;},
setEnable:function(name,enable){
var i,max,eleBtn;
for(i=0,max=this.modeList.length;i<max;i+=1){
if(name===this.modeList[i].name&&
this.modeList[i].enable!==enable){
this.modeList[i].enable=enable;
eleBtn=document.getElementById('fillBtn'+i);
if(enable){
eleBtn.classList.remove('disable');}else {
eleBtn.classList.add('disable');}
break;}
}
return this;},
getRequestType:function(){
return this.modeList[this.focusIndex].reqType;},
getColumn:function(){
var column=this.indexToColumnList[this.focusIndex]+offsetColumn;
return (column||0);}
};
requestManager={
reqId:0,
timerId:-1,
timerCancelId:-1,
lastType:null,
effectCallback:function(effectType,reqObj){
var that=requestManager;
systemEffect.forceStop().start(effectType);
removeAndClearContents();
contentManager.getContentsWithShow(reqObj);
},
request:function(type,num,userId,filter,options){
var reqObj,useEffect=true,effectType=0,that=this;
this.lastType=type;
msContentId=0;
this.reqId+=1;
if(this.reqId>=0xFFFF){
this.reqId=0;}
reqObj={reqId:this.reqId,type:{id:type},num:num};
if(userId){
reqObj.uid=userId;}else {
if(userId===0){
reqObj.uid=userId;}
}
if(filter){
reqObj.filter=filter;}
if(options){
if(options.useEffect===false){
useEffect=false;}
if(options.effectType){
effectType=options.effectType;}
}
showSearchFactors(reqObj);
hideContentInfo();
gridPlayControl.stopPlay();
appendQueue.clear();
if(this.timerId>=0){
clearTimeout(this.timerId);}
if(useEffect){
this.timerId=setTimeout(function(){
that.effectCallback(effectType,reqObj);},300);}else {
contentManager.getContentsWithShow(reqObj);
}
},
cancel:function(){
this.lastType='cancel';
this.reqId+=1;
if(this.reqId>=0xFFFF){
this.reqId=0;}
showSearchFactors({type:{id:'Cancel'}});
prepareContents([],'cancel');
return this;},
stopCancelTimer:function(){
if(this.timerCancelId>=0){
clearTimeout(this.timerCancelId);
this.timerCancelId=-1;}
return this;},
startCancelTimer:function(){
this.stopCancelTimer();
this.timerCancelId=setTimeout(this.cancel.bind(this),TIME.REQUEST_TIMEOUT);
return this;}
};
systemEffect={
using:false,
start:function(type,duration){
if(this.using){
this.forceStop();}
system.effect.pattern=type;
if(duration!==undefined){
system.effect.duration=duration;}
this.using=system.effect.start(sizeInfo.contentAreaLeft,
sizeInfo.contentAreaTop,
sizeInfo.contentAreaWidth,
sizeInfo.contentAreaHeight,
sizeInfo.contentMoveAreaLeft,
sizeInfo.contentMoveAreaTop,
sizeInfo.contentMoveAreaWidth,
sizeInfo.contentMoveAreaHeight);
return this;},
finish:function(){
if(this.using){
system.effect.end();
this.using=false;}
return this;},
stop:function(){
if(scrollControl.scrollType==='page'){
if(this.using){
return this.forceStop();}
system.effect.stop(0);
}else {
system.effect.stop(0);
this.using=false;}
return this;},
forceStop:function(){
system.effect.stop(1);
this.using=false;
return this;},
scroll:function(moveColumn){
if(this.using){
system.effect.scroll(moveColumn*sizeInfo.contentWidth,0);
}
return this;}
};
imageLoadObserver={
timerId:-1,
observeList:[],
loadCount:0,
callback:null,
commonEvent:function(event){
var that=imageLoadObserver,callback=false;
that.loadCount+=1;
if(that.loadCount>=that.observeList.length){
DEBUG.console(DEBUG.LVL.VERBOSE,'imageLoadObserver.commonEvent: loaded all');
if(that.callback){
callback=that.callback;}
that.clear();
if(callback){
callback();}
}
},
timeOutFunc:function(){
DEBUG.console(DEBUG.LVL.INFO,'imageLoadObserver.timeOutFunc:');
var that=imageLoadObserver,callback=false;
if(that.callback){
callback=that.callback;}
that.clear();
if(callback){
callback();}
},
add:function(element,reserve){
var obj={element:element};
element.onload=this.commonEvent;
if(reserve){
obj.reserve=reserve;}
this.observeList.push(obj);
return this;},
clear:function(){
var target=this.observeList.pop();
while(target){
target.element.onload=null;
target.element=null;
target=this.observeList.pop();}
this.loadCount=0;
if(this.timerId>=0){
clearTimeout(this.timerId);}
this.timerId=-1;
this.callback=null;
return this;},
observe:function(callback){
this.loadCount=0;
if(this.timerId>=0){
clearTimeout(this.timerId);}
this.callback=callback||null;
this.timerId=setTimeout(this.timeOutFunc,TIME.WAIT_LOAD_IMAGE);
return this;}
};
appendQueue={
list:[],
enqueue:function(data){
this.list.push(data);
return this;},
dequeue:function(){
if(this.list.length===0){
return null;}
return this.list.shift();},
clear:function(){
var obj=this.list.pop();
if(obj){
obj=this.list.pop();}
return this;},
isEmpty:function(){
return (this.list.length===0);}
};
dialogUI={
eleArea:null,
focus:null,
levels:{
mhcRegist:1,
postcodeErr:2
},
currentInfo:null,
dialogs:null,
init:function(){
this.eleArea=document.getElementById('dialogArea');
this.focus=new domFocus.Focus(document.getElementById('dialogFocus'));
return this;},
isOpen:function(){
return (this.currentInfo!==null);},
open:function(dialogId,type,message,callback,title){
var i,max,index,eleDialog,eleText,eleChkArea,eleChk,
eleChkImg,eleChkText,eleBtnArea,eleHead,eleBtn;

eleDialog=dom.createElement('div',{id:'commonDialog',className:'show'});
switch(type){
case 'plane':
eleDialog.classList.add('typePlane');
eleText=document.createElement('p');
eleText.textContent=message||'';
eleDialog.appendChild(eleText);
this.eleArea.appendChild(eleDialog);
this.currentInfo={id:dialogId,type:type,callback:callback};
break;
case 'yes-no':
eleHead=dom.createElement('h2',{id:'dialogHead'});
eleHead.textContent=title||'';
eleDialog.classList.add('typeYesNo');
eleText=dom.createElement('p',{id:'dialogExp'});
eleText.textContent=message||'';
eleChkArea=dom.createElement('div',{id:'dialogChkArea'});
eleChk=dom.createElement('div',{id:'dialogChk'});
eleChkImg=document.createElement('img');
eleChkImg.src='img/check.png';
eleChk.appendChild(eleChkImg);
eleChkText=dom.createElement('p',{id:'dialogChkText'});
eleChkText.textContent='Don\'t show this message again';
eleChkArea.appendChild(eleChk);
eleChkArea.appendChild(eleChkText);
eleBtnArea=dom.createElement('div',{id:'dialogBtnArea'});
eleBtn=dom.createElement('div',{id:'dialogBtnYes',className:'commonBtn'});
eleBtn.textContent='Yes';
eleBtnArea.appendChild(eleBtn);
eleBtn=dom.createElement('div',{id:'dialogBtnNo',className:'commonBtn'});
eleBtn.textContent='No';
eleBtnArea.appendChild(eleBtn);
eleDialog.appendChild(eleHead);
eleDialog.appendChild(eleText);
eleDialog.appendChild(eleChkArea);
eleDialog.appendChild(eleBtnArea);
this.eleArea.appendChild(eleDialog);
this.focus.set(document.getElementById('dialogBtnYes'));
this.currentInfo={id:dialogId,type:type,focus:'yes',
check:false,callback:callback};
break;
default:
}
return this;},
close:function(buttonName){
var eleDialog,callback;
if(this.currentInfo){
callback=this.currentInfo.callback;
eleDialog=document.getElementById('commonDialog');
if(eleDialog){
eleDialog.parentNode.removeChild(eleDialog);}
this.focus.off();
this.currentInfo=null;
if(typeof callback==='function'){
callback('close');}
}
return this;},
moveFocus:function(keyCode){
var info=this.currentInfo;
switch(keyCode){
case KeyEvent.DOM_VK_LEFT:
if(info.type==='yes-no'&&info.focus==='no'){
this.focus.move(document.getElementById('dialogBtnYes'));
info.focus='yes';}
break;
case KeyEvent.DOM_VK_RIGHT:
if(info.type==='yes-no'&&info.focus==='yes'){
this.focus.move(document.getElementById('dialogBtnNo'));
info.focus='no';}
break;
case KeyEvent.DOM_VK_UP:
if(info.type==='yes-no'&&
(info.focus==='yes'||info.focus==='no')){
this.focus.move(document.getElementById('dialogChk'));
info.focus='check';}
break;
case KeyEvent.DOM_VK_DOWN:
if(info.type==='yes-no'&&info.focus==='check'){
this.focus.move(document.getElementById('dialogBtnYes'));
info.focus='yes';}
break;
default:
}
return this;},
changeCheck:function(){
var eleChk;
if(this.currentInfo.check===undefined){
return this;}
eleChk=document.getElementById('dialogChk');
this.currentInfo.check=!this.currentInfo.check;
if(this.currentInfo.check){
eleChk.classList.add('check');}else {
eleChk.classList.remove('check');}
return this;},
keyDownHandler:function(event){
var info;
if(!this.currentInfo){
return this;}
info=this.currentInfo;
if(event.keyCode===KeyEvent.DOM_VK_BACK_SPACE){
this.close();
return this;}
if(this.focus.currentState!==domFocus.STATE.ON){
return this;}
switch(info.type){
case 'plane':
break;
case 'yes-no':
switch(event.keyCode){
case KeyEvent.DOM_VK_LEFT:
case KeyEvent.DOM_VK_RIGHT:
case KeyEvent.DOM_VK_UP:
case KeyEvent.DOM_VK_DOWN:
this.moveFocus(event.keyCode);
break;
case KeyEvent.DOM_VK_RETURN:
if(info.focus==='check'){
this.changeCheck();}else {
this.close(info.focus);}
break;
default:
}
break;
default:
}
return this;}
};
tooltipUI={
timerId:-1,
ele:null,
init:function(){
this.ele=document.getElementById('tooltip');
return this;},
show:function(){
var prof,eleUser,offset;
if(screenState!==SCREEN_STATE.MAIN_READY){
return this;}
switch(focusPosition){
case FOCUS_POSITION.SETTING:
this.ele.style.left=null;
this.ele.className='show settings';
this.ele.firstChild.textContent=FIX_WORDS.SETTINGS;
break;
case FOCUS_POSITION.USER_SETTING:
this.ele.style.left=null;
this.ele.className='show userSettings';
this.ele.firstChild.textContent=FIX_WORDS.USER_SETTINGS;
break;
case FOCUS_POSITION.USER_LIST:
prof=userControl.getFocusUserProfile();
if(prof&&prof.name){
eleUser=document.getElementById('user'+userControl.focusIndex);
if(eleUser){
offset=dom.getOffset(eleUser);
this.ele.style.left=offset.left+'px';
if(eleUser.classList.contains('activeUser')){
this.ele.className='show userList hasActive';}else {
this.ele.className='show userList';}
this.ele.firstChild.textContent=prof.name;}
}
break;
default:
}
return this;},
hide:function(){
this.ele.style.left=null;
this.ele.className='';
this.ele.firstChild.textContent='';
return this;}
};
var formatSeconds=function(seconds,format){
var timeStr,hours,minutes,remainder;
if(!format){
format='hh:mm:ss';}
hours=Math.floor(seconds/3600);
remainder=(seconds%3600);
if(hours<100){
timeStr=('0'+hours).slice(-2)+':';}else {
timeStr=''+hours+':';}
minutes=Math.floor(remainder/60);
timeStr+=('0'+minutes).slice(-2);
if(format==='hh:mm:ss'){
timeStr+=':'+('0'+(remainder%60)).slice(-2);}
return timeStr;};
var formatTime=function(date){
var timeStr='',hours,cc;
if(Configurations.displayInfoType!==2&&
Configurations.displayInfoType!==6){
timeStr=('0'+date.getHours()).slice(-2)+':'+
('0'+date.getMinutes()).slice(-2);}else {
hours=date.getHours();
if(hours===0){
hours=12;
cc='am';}else if(hours>=1&&hours<=12){
cc=(hours===12)?'pm':'am';}else {
hours-=12;
cc='pm';}
timeStr=('0'+hours).slice(-2)+':'+
('0'+date.getMinutes()).slice(-2)+' '+cc;}
return timeStr;};
var formatDate=function(date,displayYear){
var dateStr='',format;
switch(Configurations.displayInfoType){
case 0:dateStr=FIX_WORDS.DAY_LIST[date.getDay()]+' '+
('0'+date.getDate()).slice(-2)+'.'+
('0'+(date.getMonth()+1)).slice(-2);
if(displayYear){
dateStr+=' '+date.getFullYear();}
break;
case 1:dateStr=FIX_WORDS.DAY_LIST[date.getDay()]+' '+
date.getDate()+'.'+
FIX_WORDS.MONTH_LIST[(date.getMonth())];
if(displayYear){
dateStr+=' '+date.getFullYear();}
break;
case 2:case 3:
dateStr=FIX_WORDS.DAY_LIST[date.getDay()]+' '+
('0'+date.getDate()).slice(-2)+'.'+
FIX_WORDS.MONTH_LIST[(date.getMonth())];
if(displayYear){
dateStr+=' '+date.getFullYear();}
break;
case 4:dateStr=('0'+date.getDate()).slice(-2)+'/'+
('0'+(date.getMonth()+1)).slice(-2);
if(!displayYear){
dateStr+=' ';}else {
dateStr+='/'+date.getFullYear()+' ';}
dateStr+=FIX_WORDS.DAY_LIST[date.getDay()];
break;
case 5:dateStr=(date.getMonth()+1).toString()+FIX_WORDS.MONTH+
(date.getDate())+FIX_WORDS.DATE+
FIX_WORDS.DAY_LIST[date.getDay()];
if(displayYear){
dateStr=(''+date.getFullYear()).slice(-2)+FIX_WORDS.YEAR+dateStr;}
break;
case 6:dateStr=('0'+(date.getMonth()+1)).slice(-2)+'/'+
('0'+date.getDate()).slice(-2);
if(!displayYear){
dateStr+=' '+FIX_WORDS.DAY_LIST[date.getDay()];}else {
dateStr+='/'+date.getFullYear()+' '+FIX_WORDS.DAY_LIST[date.getDay()];}
break;
default:
dateStr=FIX_WORDS.DAY_LIST[date.getDay()]+' '+
('0'+date.getDate()).slice(-2)+'.'+
('0'+(date.getMonth()+1)).slice(-2);
if(displayYear){
dateStr+=' '+date.getFullYear();}
}
return dateStr;};
var formatDateOfMedia=function(date){
var dateStr='';
switch(Configurations.displayInfoType){
case 2:case 3:case 5:dateStr=''+date.getFullYear()+'/'+
('0'+(date.getMonth()+1)).slice(-2)+'/'+
('0'+date.getDate()).slice(-2);
break;
case 6:dateStr=('0'+(date.getMonth()+1)).slice(-2)+'/'+
('0'+date.getDate()).slice(-2)+'/'+
date.getFullYear();
break;
default:dateStr=('0'+date.getDate()).slice(-2)+'/'+
('0'+(date.getMonth()+1)).slice(-2)+'/'+
date.getFullYear();}
dateStr+=' '+('0'+date.getHours()).slice(-2)+':'+
('0'+date.getMinutes()).slice(-2);
return dateStr;};
var isValidTime=function(time){
return (time&&time>=VALID_BASE_TIME);};
var checkImageSize=function(element){
if(16*element.naturalHeight/element.naturalWidth<=9){
return 'horizontal';}
return 'vertical';};
var hideContentInfo=function(){
var contentExp=document.getElementById('contentExp');
contentExp.style.opacity=0;};
var prepareContents=function(list,resultType,options){
var renderInit,frameId,focusIndex=0,oldListLength=0;
switch(screenState){
case SCREEN_STATE.MAIN_LOADING:
case SCREEN_STATE.MAIN_WAITING_MSG:
if(screenState===SCREEN_STATE.MAIN_LOADING){
YouTube.waiting=false;
focusPosition=FOCUS_POSITION.GRID;}else {
listPosition=0;
gridFocusPos.x=-1;
gridFocusPos.y=-1;}
mainFocus.enable=false;
scrollControl.startTimer();
wsRead(list,resultType,options);
renderFrameAndContents();
screenState=SCREEN_STATE.MAIN_READY;
userControl.clearFocusStyle();
if(focusPosition===FOCUS_POSITION.USER_LIST&&
mainFocus.currentState===domFocus.STATE.OFF){
userControl.setFocus(1);
tooltipUI.show();}else if(focusPosition===FOCUS_POSITION.GRID||
mainFocus.currentState===domFocus.STATE.OFF){
mainFocus.ele.classList.remove('cmn_circle');
if(contentsList.length>0){
setContentInfo(gridData.viewTable[gridFocusPos.x][gridFocusPos.y].frame.content);
frameId=gridData.viewTable[gridFocusPos.x][gridFocusPos.y].frame.id;
focusPosition=FOCUS_POSITION.GRID;
mainFocus.set(document.getElementById(frameId));}else {
focusPosition=FOCUS_POSITION.MODE_BUTTON;
focusIndex=modeControl.changeFocusIndex('left').focusIndex;
mainFocus.set(document.getElementById('fillBtn'+focusIndex));}
tooltipUI.show();}
break;
case SCREEN_STATE.MAIN_READY:
if(resultType==='append'){
if(contentsList){
oldListLength=contentsList.length;}
if(wsRead(list,resultType)===true){
updateDisplayContents(function(){
if(renderFin===false){
system.socket.write(JSON.stringify({command:'render_fin'}));
renderFin=true;
if(displayOfflinePanel===true){
setTimeout(function(){
system.socket.write(JSON.stringify({command:'network_check'}));},TIME.DELAY_DISP_OFFLINE);}
}
mainFocus.enable=true;});
if(focusPosition===FOCUS_POSITION.GRID){
setContentInfo(gridData.viewTable[gridFocusPos.x][gridFocusPos.y].frame.content);}
}
if(oldListLength<=maxViewContents){
scrollControl.startTimer();}
}else {
DEBUG.console(DEBUG.LVL.ERROR,'prepareContents mismatch parameter. '+
'resultType='+resultType+', screenState='+screenState);}
break;
case SCREEN_STATE.SETTING_POPUP:
case SCREEN_STATE.VOD_PURCHASE:
case SCREEN_STATE.SEARCH:
case SCREEN_STATE.FILTER:
case SCREEN_STATE.MYBUTTON:
if(resultType==='append'){
appendQueue.enqueue(list);}else {
DEBUG.console(DEBUG.LVL.ERROR,'prepareContents mismatch parameter. '+
'resultType='+resultType+', screenState='+screenState);}
break;
default:
}
};
function renderFrameAndContents(){
DEBUG.console(DEBUG.LVL.INFO,'renderFrameAndContents');
var i,column,row,max,target,eleFrame,eleAreaMove,frameTemplate,
eleArea,area,viewTable,
df=document.createDocumentFragment(),
createFrame,afterTimeoutFunc,loadComplete,vContainer;
imageLoadObserver.clear();
frameTemplate=(function(){
var eleFrame,eleThumnailWrap,eleSource,eleSourceBox,eleTitle,
eleOverlay,eleTextWrap,eleText,eleTextDetail,eleFavMark;
eleFrame=document.createElement('div');
eleThumnailWrap=dom.createElement('div',{className:'cnThumnailWrap'});
eleText=dom.createElement('p',{className:'contentText'});
eleTextWrap=dom.createElement('div',{className:'contentTextWrap'});
eleTextWrap.appendChild(eleText.cloneNode(false));
eleTextWrap.appendChild(eleText.cloneNode(false));
eleTextWrap.appendChild(eleText.cloneNode(false));
eleTextWrap.appendChild(eleText.cloneNode(false));
eleSource=dom.createElement('img',{className:'contentSource'});
eleSourceBox=dom.createElement('div',{className:'contentSourceBox'});
eleFavMark=dom.createElement('img',{className:'contentFavMark',src:ICON_PATH.STAR});
eleOverlay=dom.createElement('div',{className:'contentOverlay'});
eleSourceBox.appendChild(eleSource);
eleOverlay.appendChild(eleSourceBox);
eleOverlay.appendChild(eleFavMark);
eleFrame.appendChild(eleThumnailWrap);
eleFrame.appendChild(eleTextWrap);
eleFrame.appendChild(eleOverlay);
return eleFrame;}());
createFrame=function(frame){
var eleFrame,elePlayer,eleThumnail,index,muted;
eleFrame=frameTemplate.cloneNode(true);
if(target.fourFrame){
eleFrame.className='bigFrame';}else {
eleFrame.className='normalFrame';}
eleFrame.id=frame.id;
if(frame.content===null){
return eleFrame;}
eleThumnail=frame.content.createThumnailElement();
if(frame.content.dispThumnail){
eleFrame.classList.add('dispThumnail');}
imageLoadObserver.add(eleThumnail,frame.content.getDefaultImagePath());
eleFrame.firstChild.appendChild(eleThumnail);
if(gridPlayControl.existContent(frame.content)){
muted=(gridPlayControl.unmuteTarget===frame.content)?false:true;
if(Configurations.streamingUI===true){
vContainer=gridPlayControl.getVideoContainer(frame.content);}
elePlayer=frame.content.createPlayerElement(muted,vContainer);
eleFrame.insertBefore(elePlayer,eleFrame.firstChild.nextSibling);}
frame.setOverlayInfo(eleFrame).setTextInfo(eleFrame);
return eleFrame;};
for(i=0,max=gridData.areaOrder.length;i<max;i+=1){
area=gridData.area[gridData.areaOrder[i]];
eleArea=dom.createElement('div',{id:'frameArea'+area.name,
className:'frameArea column'+
area.columnWidth});
for(column=0;column<area.columnWidth;column+=1){
for(row=0;row<MAX_ROW;row+=1){
target=area.viewTable[column][row];
if(typeof target==='object'){
eleFrame=createFrame(target.frame);
eleFrame.style.top=row*sizeInfo.contentHeight+'px';
eleFrame.style.left=column*sizeInfo.contentWidth+'px';
eleArea.appendChild(eleFrame);}
}
}
df.appendChild(eleArea);}
eleAreaMove=document.getElementById('cAreaMove');
eleAreaMove.innerHTML='';
eleAreaMove.appendChild(df);
gridPlayControl.startPlay();
afterTimeoutFunc=function(){
if(screenState!==SCREEN_STATE.MAIN_READY){
mainFocus.enable=true;
return false;}
return true;};
loadComplete=function(){
if(renderFin===false){
system.socket.write(JSON.stringify({command:'render_fin'}));
renderFin=true;
if(displayOfflinePanel===true){
setTimeout(function(){
system.socket.write(JSON.stringify({command:'network_check'}));},TIME.DELAY_DISP_OFFLINE);}
}
if(afterTimeoutFunc()===false){
return;}
systemEffect.finish();
setTimeout(function(){
if(afterTimeoutFunc()===false){
return;}
systemEffect.stop();
setTimeout(function(){
mainFocus.enable=true;},0);},0);};
if(imageLoadObserver.observeList.length>0){
imageLoadObserver.observe(loadComplete);}else {
setTimeout(function(){
loadComplete();},100);}
}
function updateDisplayContents(callback){
DEBUG.console(DEBUG.LVL.INFO,'updateDisplayContents');
var column,row,target,readyContents;
imageLoadObserver.clear();
for(column=offsetColumn;column<MAX_COLUMN+offsetColumn;column+=1){
for(row=0;row<MAX_ROW;row+=1){
target=gridData.viewTable[column][row];
if(typeof target==='object'&&target.frame.content){
appendContentElement(target.frame);}
}
}
if(scrollControl.scrollType==='stream'){
renderContentsOutsideScreen();}
gridPlayControl.startPlay();
if(typeof callback!=='function'){
imageLoadObserver.observe();
return;}
if(imageLoadObserver.observeList.length>0){
imageLoadObserver.observe(callback);}else {
setTimeout(function(){
callback();},0);}
}
function updateDisplayContentsWithEffect(callback){
systemEffect.start(EFFECT.INOUT);
updateDisplayContents();
setTimeout(callback,1600);}
function updateContent(data){
var column,row,max,target,ele,content;
for(column=0,max=gridData.viewTable.length;column<max;column+=1){
for(row=0;row<MAX_ROW;row+=1){
target=gridData.viewTable[column][row];
if(typeof target==='object'&&target.frame&&
target.frame.content&&
target.frame.content.attr.thumnail1===data.thumnail1&&
target.frame.content.STATE!==ContentOfGrid.STATE.NONE){
target.frame.content.reloadThumnail();
return;}
}
}
}
function updateContentsAfterStreamScroll(direction){
DEBUG.console(DEBUG.LVL.INFO,'updateContentsAfterStreamScroll: direction='+direction);
var i,max,target,area,sortList;
if(direction===scrollControl.SCROLL_PREV){
area=gridData.area[gridData.areaOrder[7]];}else {
area=gridData.area[gridData.areaOrder[0]];}
sortList=area.sortList;
for(i=0,max=sortList.length;i<max;i+=1){
target=sortList[i];
if(target.frame&&
gridPlayControl.existContent(target.frame.content)){
gridPlayControl.giveUpContent(target.frame.content);}
}
removeAndClearContents(sortList);
setContentToOutsideViewTable(direction);
renderContentsOutsideScreen(direction);

gridPlayControl.beforeStreaming().startPlay();}
function setFocusAfterStopScroll(side){
DEBUG.console(DEBUG.LVL.INFO,'setFocusAfterStopScroll side='+side);
var focusIndex,target=null,searchTarget,content,column,row,
loopContinue;
if(side===undefined){
if(gridPlayControl.unmuteTarget!==null){
content=gridPlayControl.unmuteTarget;
for(column=offsetColumn;column<MAX_COLUMN+offsetColumn;column+=1){
for(row=0;row<MAX_ROW;row+=1){
searchTarget=gridData.viewTable[column][row];
if(typeof searchTarget==='object'&&
searchTarget.frame&&
searchTarget.frame.content===content){
target=searchTarget;
gridFocusPos.x=column;
gridFocusPos.y=row;
break;}
}
if(target!==null){
break;}
}
}
if(!target){
side='left';}
}
if(side==='left'){
gridFocusPos.x=offsetColumn;}else if(side==='right'){
gridFocusPos.x=MAX_COLUMN+offsetColumn-1;}
scrollControl.startTimer();
focusPosition=FOCUS_POSITION.GRID;
if(target===null){
target=gridData.viewTable[gridFocusPos.x][gridFocusPos.y];
switch(target){
case gridData.LINK.LEFT:
gridFocusPos.x-=1;
break;
case gridData.LINK.UP:
gridFocusPos.y-=1;
break;
case gridData.LINK.DIAGONAL:
gridFocusPos.x-=1;
gridFocusPos.y-=1;
break;
default:
}
target=gridData.viewTable[gridFocusPos.x][gridFocusPos.y];}
if(target.frame&&target.frame.content){
mainFocus.set(document.getElementById(target.frame.id));
setContentInfo(target.frame.content);
gridPlayControl.switchPlay();
return;}
focusPosition=FOCUS_POSITION.MODE_BUTTON;
focusIndex=modeControl.changeFocusIndex('left').focusIndex;
mainFocus.set(document.getElementById('fillBtn'+focusIndex));}
function removeAndClearContents(list){
var i,max,callback=function(obj){
var eleFrame;
if(obj.frame.content!==null){
obj.frame.content.remove().destroy();
obj.frame.content=null;}
if(obj.frame){
eleFrame=document.getElementById(obj.frame.id);
if(eleFrame){
eleFrame.firstChild.classList.remove('visible');
obj.frame.setOverlayInfo(eleFrame).setTextInfo(eleFrame);}
}
};
if(list===undefined){
gridData.forEachAllArea(callback);}else {
for(i=0,max=list.length;i<max;i+=1){
callback(list[i]);}
}
}
function getPlayTargetList(){
var column,row,target,loopContinue=true,list=[];
for(column=offsetColumn;column<MAX_COLUMN+offsetColumn;column+=1){
for(row=0;row<MAX_ROW;row+=1){
target=gridData.viewTable[column][row];
if(typeof target==='object'&&target.fourFrame===true){
list.push(target);
if(maxVideoNum>1){
if(column>=offsetColumn&&column<=offsetColumn+1){
list.push(gridData.viewTable[column+2][0]);}else {
list.push(gridData.viewTable[offsetColumn][0]);}
}
loopContinue=false;}
}
if(loopContinue===false){
break;}
}
return list;}
function preloadOutsideThumnail(){
var index,count,max=3,thumnailList=[];
index=listPosition+maxViewContents;
for(count=0;count<max;count+=1){
if(index<contentsList.length){
if(contentsList[index].attr.thumnail1){
thumnailList.push(contentsList[index].attr.thumnail1);}
}else {
break;}
index+=1;}
index=listPosition-1;
for(count=0;count<max;count+=1){
if(index>=0&&index<contentsList.length){
if(contentsList[index].attr.thumnail1){
thumnailList.push(contentsList[index].attr.thumnail1);}
}else {
break;}
index-=1;}
dom.preloadImages(thumnailList);}
function renderContentsOutsideScreen(direction){
DEBUG.console(DEBUG.LVL.INFO,'renderContentsOutsideScreen: direction='+direction);
var area,i,j,max,list=[],target,areaLen,areaList=[];
if(direction===scrollControl.SCROLL_PREV){
areaList.push(gridData.area[gridData.areaOrder[1]]);}else if(direction===scrollControl.SCROLL_NEXT){
areaList.push(gridData.area[gridData.areaOrder[6]]);}else {
areaList.push(gridData.area[gridData.areaOrder[1]]);
areaList.push(gridData.area[gridData.areaOrder[6]]);}
for(i=0,areaLen=areaList.length;i<areaLen;i+=1){
area=areaList[i];
for(j=0,max=area.sortList.length;j<max;j+=1){
target=area.sortList[j];
if(target.frame.content){
appendContentElement(target.frame,false);}else {
DEBUG.console(DEBUG.LVL.WARN,'frame.content is invalid:'+
target.frame.content);}
}
}
}
function stopPlayOutsideScreen(){
DEBUG.console(DEBUG.LVL.INFO,'stopPlayOutsideScreen');
var i,j,areaLen,max,area,target,areaList=[];
areaList.push(gridData.area[gridData.areaOrder[1]]);
areaList.push(gridData.area[gridData.areaOrder[6]]);
for(i=0,areaLen=areaList.length;i<areaLen;i+=1){
area=areaList[i];
for(j=0,max=area.sortList.length;j<max;j+=1){
target=area.sortList[j];
if(target.frame&&target.frame.content&&
gridPlayControl.existContent(target.frame.content)){
gridPlayControl.giveUpContent(target.frame.content);}
}
}
}
function searchNextContentFromList(mscid){
var i,max,index=-1;
for(i=0,max=contentsList.length;i<max;i+=1){
if(contentsList[i].attr.mscid!==undefined&&
contentsList[i].attr.mscid>mscid){
index=i;
break;}
}
return index;}
function searchPrevContentFromList(mscid){
var i,max,index=-1;
for(i=contentsList.length-1;i>=0;i-=1){
if(contentsList[i].attr.mscid!==undefined&&
contentsList[i].attr.mscid<mscid){
index=i;
break;}
}
return index;}
function updateOffsetColumn(){
var ele;
if(scrollControl.scrollType==='page'){
offsetColumn=0;}else {
offsetColumn=gridData.area[gridData.areaOrder[0]].columnWidth+
gridData.area[gridData.areaOrder[1]].columnWidth;}
ele=document.getElementById('cAreaMove');
if(offsetColumn===3||offsetColumn===0){
ele.classList.remove('withMargin');}else {
ele.classList.add('withMargin');}
}
function setContentToViewTable(lastLaunch){
DEBUG.console(DEBUG.LVL.INFO,'setContentToViewTable');
var target,area0,area1,index,column,row,loopContinue,content,i,curUserId,favRegist,
findVideoList=[],notPlayList=[],notPlayIndex=0,playConList=[],
fourFrameSize,oneFrameSize,count=0,startListPosition=listPosition,
setContent,clearContent,targetList,max;
updateOffsetColumn();
if(scrollControl.scrollType==='page'){
}
gridPlayControl.stopPlay().clearList();
fourFrameSize={
width:(sizeInfo.contentWidth*2-sizeInfo.contentMargin*2).toString(),
height:(sizeInfo.contentHeight*2-sizeInfo.contentMargin*2).toString()
},
oneFrameSize={
width:(sizeInfo.contentWidth-sizeInfo.contentMargin*2).toString(),
height:(sizeInfo.contentHeight-sizeInfo.contentMargin*2).toString()
};
for(index=listPosition,count=0;count<maxViewContents&&contentsList[index];count+=1){
if(ContentOfGrid.prototype.isPlayable.call(contentsList[index])&&
findVideoList.length<maxVideoNum){
findVideoList.push(index);}else {
notPlayList.push(index);}
index+=1;
if(index>=contentsList.length){
index=0;}
if(index===startListPosition){
break;}
}
removeAndClearContents();
targetList=getPlayTargetList();
if(targetList.length>1&&targetList.length>findVideoList.length){
targetList.pop();}
for(column=offsetColumn;column<MAX_COLUMN+offsetColumn;column+=1){
for(row=0;row<MAX_ROW;row+=1){
target=gridData.viewTable[column][row];
if(typeof target==='object'&&targetList.indexOf(target)>=0){
if(findVideoList.length>0){
index=findVideoList.shift();
contentsList[index].attr.favRegist=getFavRegist(contentsList[index]);
target.frame.content=new ContentOfGrid(contentsList[index],
target.frame.contentId,
target.frame.contentThumnailId,
fourFrameSize,
column,row);
if(!gridPlayControl.existContent(target.frame.content)){
playConList.push(target.frame.content);}
if(target.frame.fourFrame&&
(gridFocusPos.x<0||gridFocusPos.y<0)){
gridFocusPos.x=column;
gridFocusPos.y=row;}
}
}
}
}
for(i=playConList.length-1;i>=0;i-=1){
gridPlayControl.add(playConList[i]);}
if(targetList[0]&&targetList[0].frame.content&&
targetList[0].frame.content.isPlayable()&&
gridPlayControl.existContent(targetList[0].frame.content)){
gridPlayControl.setUnmuteTarget(targetList[0].frame.content);}
setContent=function(obj,column,row){
var content,contentIndex;
if(obj.frame.content!==null){
return true;}
if(obj.frame.content===null&&notPlayList.length>notPlayIndex){
contentIndex=notPlayList[notPlayIndex];
content=contentsList[contentIndex];
notPlayIndex+=1;
content.attr.favRegist=getFavRegist(content);
obj.frame.content=new ContentOfGrid(content,
obj.frame.contentId,
obj.frame.contentThumnailId,
obj.fourFrame?fourFrameSize:oneFrameSize,
column,row);
if(gridFocusPos.x<0||gridFocusPos.y<0){
gridFocusPos.x=column;
gridFocusPos.y=row;}
}
return (notPlayList.length>notPlayIndex);};
for(column=offsetColumn;column<MAX_COLUMN+offsetColumn;column+=1){
for(row=0;row<MAX_ROW;row+=1){
target=gridData.viewTable[column][row];
if(typeof target==='object'){
loopContinue=setContent(target,column,row);
if(!loopContinue){
break;}
}
}
if(!loopContinue){
break;}
}
if(gridFocusPos.x<0||gridFocusPos.y<0){
gridFocusPos.x=offsetColumn;
gridFocusPos.y=0;}
if(scrollControl.scrollType==='stream'&&
contentsList.length>=maxViewContents){
setContentToOutsideViewTable();}
if(!lastLaunch){
return;}
for(column=offsetColumn;column<MAX_COLUMN+offsetColumn;column+=1){
for(row=0;row<MAX_ROW;row+=1){
target=gridData.viewTable[column][row];
if(typeof target==='object'){
content=target.frame.content;
if(content&&
content.kind===lastLaunch.kind&&
content.attr.content===lastLaunch.content&&
content.attr.src===lastLaunch.src){
gridFocusPos.x=column;
gridFocusPos.y=row;
if(!content.isPlayable()){
return;}
if(!gridPlayControl.existContent(content)){
gridPlayControl.add(content);}else {
gridPlayControl.setUnmuteTarget(content);}
return;}
}
}
}
}
function setContentToOutsideViewTable(direction){
DEBUG.console(DEBUG.LVL.INFO,'setContentToOutsideViewTable: direction='+direction);
var index,row,column,count,target,i,max,content,
getTarget,setContent,fourFrameSize,oneFrameSize,
conFirst=null,conLast=null,area,columnWidth,
mscidLeftList=[],mscidRightList=[],checkDuplicate;
fourFrameSize={
width:(sizeInfo.contentWidth*2-sizeInfo.contentMargin*2).toString(),
height:(sizeInfo.contentHeight*2-sizeInfo.contentMargin*2).toString()
},
oneFrameSize={
width:(sizeInfo.contentWidth-sizeInfo.contentMargin*2).toString(),
height:(sizeInfo.contentHeight-sizeInfo.contentMargin*2).toString()
};
setContent=function(obj,column,row){
var content;
if(obj.frame.content!==null){
obj.frame.content.remove().destroy();
obj.frame.content=null;}
if(contentsList[index]){
content=contentsList[index];
content.attr.favRegist=getFavRegist(content);
obj.frame.content=new ContentOfGrid(content,
obj.frame.contentId,
obj.frame.contentThumnailId,
obj.fourFrame?fourFrameSize:oneFrameSize,
column,row);
if(direction!==undefined&&
obj.frame.content.isPlayable()&&!gridPlayControl.isMax()){
gridPlayControl.add(obj.frame.content);}
}
};
getTarget=function(column,row){
var target=gridData.viewTable[column][row];
if(typeof target==='number'){
switch(target){
case gridData.LINK.LEFT:
column-=1;
break;
case gridData.LINK.UP:
row-=1;
break;
case gridData.LINK.DIAGONAL:
column-=1;
row-=1;
break;
default:
}
target=gridData.viewTable[column][row];}
return target;};
if(direction===undefined||
direction===scrollControl.SCROLL_NEXT){
area=gridData.area[gridData.areaOrder[5]];
for(i=0,max=area.sortList.length;i<max;i+=1){
target=area.sortList[i];
if(target.frame&&target.frame.content&&
target.frame.content.attr.mscid!==undefined){
mscidRightList.push(target.frame.content.attr.mscid);}
if(conLast===null){
if(target.frame&&target.frame.content){
conLast=target.frame.content;}
}else {
if(target.frame&&target.frame.content&&
target.frame.content.attr.mscid>conLast.attr.mscid){
conLast=target.frame.content;}
}
}
}
if(direction===undefined||
direction===scrollControl.SCROLL_PREV){
area=gridData.area[gridData.areaOrder[2]];
for(i=0,max=area.sortList.length;i<max;i+=1){
target=area.sortList[i];
if(target.frame&&target.frame.content&&
target.frame.content.attr.mscid!==undefined){
mscidLeftList.push(target.frame.content.attr.mscid);}
if(conFirst===null){
if(target.frame&&target.frame.content){
conFirst=target.frame.content;}
}else {
if(target.frame&&target.frame.content&&
target.frame.content.attr.mscid<conFirst.attr.mscid){
conFirst=target.frame.content;}
}
}
}
if(conLast){
checkDuplicate=function(index){
var content,tmpIndex=index;
content=contentsList[index];
while(mscidRightList.indexOf(content.attr.mscid)>=0){
index+=1;
if(index>contentsList.length-1){
index=0;}
if(tmpIndex===index){
break;}
content=contentsList[index];}
return index;};
index=searchNextContentFromList(conLast.attr.mscid);
if(index<0){
index=0;}
index=checkDuplicate(index);
area=gridData.area[gridData.areaOrder[6]];
columnWidth=area.columnWidth;
column=MAX_COLUMN+offsetColumn;
for(count=0;count<columnWidth;count+=1,column+=1){
for(row=0;row<MAX_ROW;row+=1){
target=gridData.viewTable[column][row];
if(typeof target==='object'){
setContent(target,column,row);
index+=1;
if(index>contentsList.length-1){
index=0;}
index=checkDuplicate(index);}
}
}
}
if(conFirst){
checkDuplicate=function(index){
var content,tmpIndex=index;
content=contentsList[index];
while(mscidLeftList.indexOf(content.attr.mscid)>=0){
index-=1;
if(index<0){
index=contentsList.length-1;}
if(tmpIndex===index){
break;}
content=contentsList[index];}
return index;};
index=searchPrevContentFromList(conFirst.attr.mscid);
if(index<0){
index=contentsList.length-1;}
index=checkDuplicate(index);
area=gridData.area[gridData.areaOrder[1]];
columnWidth=area.columnWidth;
column=offsetColumn-1;
for(count=0;count<columnWidth;count+=1,column-=1){
for(row=MAX_ROW-1;row>=0;row-=1){
target=gridData.viewTable[column][row];
if(typeof target==='object'){
setContent(target,column,row);
index-=1;
if(index<0){
index=contentsList.length-1;}
index=checkDuplicate(index);}
}
}
}
}
function searchFocusPositionFromViewTable(start,priority){
var result=null,column=0,row=0,getPosition;
getPosition=function(column,row){
var position=null,x=column,y=row,
target=gridData.viewTable[x][y];
if(typeof target==='number'){
switch(target){
case gridData.LINK.LEFT:
if(start.horizontal==='right'){
x-=1;}
break;
case gridData.LINK.UP:
if(start.vertical==='bottom'){
y-=1;}
break;
case gridData.LINK.DIAGONAL:
if(start.horizontal==='right'){
x-=1;}
if(start.vertical==='bottom'){
y-=1;}
break;
default:
}
target=gridData.viewTable[x][y];}
if(typeof target==='object'&&target.frame.content!==null){
position={x:x,y:y};}
return position;};
if(priority){
result=getPosition(priority.column,priority.row);
if(result!==null){
return result;}
}
if(start.horizontal==='right'&&start.vertical==='top'){
for(row=0;row<MAX_ROW;row+=1){
for(column=MAX_COLUMN+offsetColumn-1;column>=offsetColumn;column-=1){
result=getPosition(column,row);
if(result!==null){
return result;}
}
}
}else if(start.horizontal==='left'&&start.vertical==='bottom'){
for(row=MAX_ROW-1;row>=0;row-=1){
for(column=offsetColumn;column<MAX_COLUMN+offsetColumn;column+=1){
result=getPosition(column,row);
if(result!==null){
return result;}
}
}
}else if(start.horizontal==='right'&&start.vertical==='bottom'){
for(row=MAX_ROW-1;row>=0;row-=1){
for(column=MAX_COLUMN+offsetColumn-1;column>=offsetColumn;column-=1){
result=getPosition(column,row);
if(result!==null){
return result;}
}
}
}
for(row=0;row<MAX_ROW;row+=1){
for(column=offsetColumn;column<MAX_COLUMN+offsetColumn;column+=1){
result=getPosition(column,row);
if(result!==null){
return result;}
}
}
return result;}
function searchFrameFromViewTableById(id,type){
var row,column,target,idName,columnLen;
columnLen=gridData.viewTable.length;
idName=(type==='player')?'id':'thumnailId';
for(column=0;column<columnLen;column+=1){
for(row=0;row<MAX_ROW;row+=1){
target=gridData.viewTable[column][row];
if(typeof target==='object'&&target.frame&&
target.frame.content&&target.frame.content[idName]===id){
return target.frame;}
}
}
return null;}
function getContentFilterId(content){
var filterId=null,onAirState;
switch(content.kind){
case KIND.YOUTUBE:
filterId=FILTER_ID.YOUTUBE;
break;
case KIND.ONAIR:
onAirState=app_launcher.checkTvService(content);
if(onAirState==='live'||onAirState==='future'){
filterId=FILTER_ID.BROADCAST;}
break;
case KIND.VOD:
filterId=FILTER_ID.VOD;
break;
case KIND.RECORDED:
filterId=FILTER_ID.RECORDED;
break;
case KIND.DIGA:
filterId=FILTER_ID.RECORDED;
break;
case KIND.SD:
case KIND.USB:
case KIND.SAMBA:
switch(content.attr.content){
case CONTENT.PICTURE:
filterId=FILTER_ID.PHOTO;
break;
case CONTENT.VIDEO:
filterId=FILTER_ID.VIDEO;
break;
case CONTENT.AUDIO:
filterId=FILTER_ID.MUSIC;
break;
default:
}
break;
case KIND.MEMO:
filterId=FILTER_ID.MEMO;
break;
case KIND.BOOKMARK:
filterId=FILTER_ID.BOOKMARK;
break;
default:
}
return filterId;}
function checkValidContent(content){
return (app_launcher.checkTvService(content)!=='past');}
function checkContentFilterId(content,filterId){
return (getContentFilterId(content)===filterId);}
function updateFilter(filterId){
var frameId=null,column,row,target,afterTimeoutFunc;
systemEffect.start(EFFECT.INOUT);
if(filterId===FILTER_ID.ALL){
contentsData.clearFilter();
contentsList=contentsData.orgList;
checkContentsList(contentsList);}else {
contentsData.setFilter(filterId,checkContentFilterId);
contentsList=contentsData.filterList;}
checkAppendContents();
listPosition=0;
gridFocusPos.x=-1;
gridFocusPos.y=-1;
scrollControl.resizeScrollBar(contentsList.length,listPosition);
gridPlayControl.stopPlay().clearList();
setContentToViewTable();
afterTimeoutFunc=function(){
if(screenState!==SCREEN_STATE.FILTER){
mainFocus.on();
return false;}
return true;};
updateDisplayContents(function(){
if(afterTimeoutFunc()===false){
return;}
systemEffect.finish();
setTimeout(function(){
if(afterTimeoutFunc()===false){
return;}
systemEffect.stop();
setTimeout(function(){
mainFocus.on();
if(screenState!==SCREEN_STATE.FILTER){
return;}
screenState=SCREEN_STATE.MAIN_READY;
scrollControl.startTimer();},0);},0);});}
function appendContentElement(frame,observeFlag){
var eleFrame,eleThumnail,elePlayer,needPlay,index,muted,vContainer;
needPlay=gridPlayControl.existContent(frame.content);
eleFrame=document.getElementById(frame.id);
frame.setOverlayInfo(eleFrame).setTextInfo(eleFrame);
eleThumnail=document.getElementById(frame.content.thumnailId);
if(eleThumnail){
DEBUG.console(DEBUG.LVL.NONE,'thumnail element already exist!');
eleThumnail.parentNode.removeChild(eleThumnail);}
eleThumnail=frame.content.createThumnailElement();
eleFrame.firstChild.appendChild(eleThumnail);
if(frame.content.dispThumnail){
eleFrame.classList.add('dispThumnail');}else {
eleFrame.classList.remove('dispThumnail');}
if(observeFlag!==false){
imageLoadObserver.add(eleThumnail,frame.content.getDefaultImagePath());}
if(needPlay){
muted=(gridPlayControl.unmuteTarget===frame.content)?false:true;
if(Configurations.streamingUI===true){
vContainer=gridPlayControl.getVideoContainer(frame.content);}
elePlayer=document.getElementById(frame.content.id);
if(elePlayer){
DEBUG.console(DEBUG.LVL.NONE,'player element already exist!');
elePlayer.parentNode.removeChild(elePlayer);}
elePlayer=frame.content.createPlayerElement(muted,vContainer);
eleFrame.insertBefore(elePlayer,eleFrame.firstChild.nextSibling);}
}
function setContentIdToList(list){
var i,max=list.length,content;
for(i=0;i<max;i+=1){
content=list[i];
if(content&&content.attr){
content.attr.mscid=msContentId;
msContentId+=1;}
}
}
function wsRead(list,resultType,options){
DEBUG.console(DEBUG.LVL.INFO,'wsRead list.length:'+list.length+
', resultType:'+resultType);
var column,row,target,oldContentsNum=0,setFrame,
gdOptions={shuffle:true},lastLaunchApp;
setFrame=function(obj,areaIndex,area){
if(obj.frame&&obj.frame.content){
obj.frame.content.remove().destroy();
obj.frame.content=null;}
obj.frame=null;
obj.frame=new GridFrame('frame'+area.name+'_'+areaIndex,obj.fourFrame,
'content'+area.name+'_'+areaIndex);};
switch(resultType){
case 'new':
case 'cancel':
case 'return':case 'append':
if(resultType==='append'&&
screenState!==SCREEN_STATE.MAIN_LOADING&&
screenState!==SCREEN_STATE.MAIN_WAITING_MSG){
setContentIdToList(list);
oldContentsNum=contentsList.length;
contentsData.appendList(list,checkValidContent,checkContentFilterId);
scrollControl.resizeScrollBar(contentsList.length,listPosition);}else {
if(resultType==='append'){
DEBUG.console(DEBUG.LVL.WARN,'first response is append!!!');}
if(resultType==='new'||resultType==='append'){
setContentIdToList(list);}
if(gridData){
gridData.destroy();}
if(options&&options.layout){
gdOptions.layout=options.layout;}
if(options&&options.isInfo===true){
gdOptions.shuffle=false;}
if(scrollControl.scrollType==='stream'){
gdOptions.pageCount=2;}
mystream.gridData=gridData=new dataManager.GridData(1,gdOptions);
if(options&&options.isInfo===true&&
scrollControl.scrollType==='stream'){
gridData.moveArea('first').moveArea('first');}
gridData.forEachAllArea(setFrame);
contentsData.replaceList(list);
if(options&&options.filterId){
filterMenu.resetFilter(options.filterId);
contentsData.setFilter(options.filterId,checkContentFilterId);
contentsList=contentsData.filterList;}else {
contentsList=contentsData.orgList;}
scrollControl.resizeScrollBar(contentsList.length,listPosition);}
break;
case 'change_scroll_type':
if(gridData){
gridData.destroy();}
if(requestManager.lastType===REQ_TYPE.INFO){
gdOptions.shuffle=false;}
if(scrollControl.scrollType==='stream'){
gdOptions.pageCount=2;}
mystream.gridData=gridData=new dataManager.GridData(1,gdOptions);
if(requestManager.lastType===REQ_TYPE.INFO&&
scrollControl.scrollType==='stream'){
gridData.moveArea('first').moveArea('first');}
gridData.forEachAllArea(setFrame);
scrollControl.resizeScrollBar(contentsList.length,listPosition);
break;
default:
}
if((Configurations.auto_launch_appli==true)&&
(contentsList.length>0)&&(contentsList[0].attr.hitratio>Configurations.auto_launch_ratio)){
app_launcher.launch_application(contentsList[0]);}
if(resultType==='append'&&
(oldContentsNum>=maxViewContents||oldContentsNum===contentsList.length)){
return false;}
if(options&&options.launchAppInfo){
lastLaunchApp=options.launchAppInfo;}
setContentToViewTable(lastLaunchApp);
return true;}
function checkContentsList(list){
var removeIndexList=[];
for(var i=(list.length-1);i>=0;i--){
if(app_launcher.checkTvService(list[i])=='past'){
list.splice(i,1);
removeIndexList.push(i);}
}
return removeIndexList;}
function checkContentsListByMscid(list,mscidList){
DEBUG.console(DEBUG.LVL.VERBOSE,'checkContentsListByMscid');
var i,j,mscid,mscidLen,removeIndexList=[];
for(i=(list.length-1);i>=0;i--){
for(j=0,mscidLen=mscidList.length;j<mscidLen;j+=1){
if(mscidList[j]===list[i].attr.mscid&&
app_launcher.checkTvService(list[i])=='past'){
list.splice(i,1);
removeIndexList.push(i);
break;}
}
}
return removeIndexList;}
function checkAppendContents(){
var list,oldContentsNum=contentsList.length,checkFunc;
if(appendQueue.isEmpty()){
return false;}
list=appendQueue.dequeue();
while(list){
setContentIdToList(list);
contentsData.appendList(list,checkValidContent,checkContentFilterId);
list=appendQueue.dequeue();}
scrollControl.resizeScrollBar(contentsList.length,listPosition);
return (oldContentsNum>=maxViewContents||
oldContentsNum===contentsList.length)?false:true;}
function beforeBackToMain(){
if(!checkAppendContents()){
return;}
setContentToViewTable();
updateDisplayContents();}
function setContentInfo(info){
DEBUG.console(DEBUG.LVL.VERBOSE,'setContentInfo');
var contentExp,infoTime,contentInfo,textList;
contentExp=document.getElementById('contentExp');
if(!info){
contentExp.style.opacity=0;
return;}
contentExp.style.opacity=1;
var contentInfoDiv1=document.getElementById('contentInfoCol1'),
contentInfoDiv2=document.getElementById('contentInfoCol2'),
contentInfoDiv3=document.getElementById('contentInfoCol3'),
contentInfoStr=document.getElementById('contentInfoStr'),
contentInfoIconImg=document.getElementById('contentIconImg'),
favStarIcon=document.getElementById('favStarIcon');
contentInfoDiv1.style.opacity=0;
contentInfoDiv2.style.opacity=0;
contentInfoDiv3.style.opacity=0;
contentInfoStr.innerHTML='';
contentInfoDiv2.innerHTML='';
contentInfoDiv3.innerHTML='';
contentInfoIconImg.style.display='block';
if(info.attr.favRegist){
favStarIcon.classList.add('show');}else {
favStarIcon.classList.remove('show');}
contentInfoIconImg.src=info.getIconFilePath();
textList=info.getTextElement('detail');
if(textList[0]){
contentInfoStr.appendChild(textList[0]);}
if(textList[1]){
contentInfoDiv2.appendChild(textList[1]);
contentInfoDiv2.style.opacity=1;}
if(textList[2]){
contentInfoDiv3.appendChild(textList[2]);
contentInfoDiv3.style.opacity=1;}
contentInfoDiv1.style.opacity=1;}
var getFavRegist=function(info){
var key=null,curUserId=userControl.getCurrentUserId();
if(info&&msUtil&&curUserId!==null){
if(info.attr.content===CONTENT.TV){
if(info.attr.eventId&&info.attr.eventId!=-1){
key=info.attr.src;
key+='.';
key+=info.attr.eventId;}
}else {
if(info.attr.favInfo&&info.attr.favInfo.length){
key=info.attr.favInfo;}else if(info.attr.src!==undefined){
key=info.attr.src;}
}
if(key!==null){
return msUtil.getFavRegistStat(key,curUserId);}
}
return false;};
var showSearchFactors=function(queryObj){
DEBUG.console(DEBUG.LVL.VERBOSE,'showSearchFactors');
var obj,words='';
if(typeof queryObj=='string'){
obj=JSON.parse(queryObj);}else {
obj=queryObj;}
function append_word(cur_word,append_word)
{
if(cur_word.length!=0)
cur_word+=' - ';
cur_word+=append_word;
return cur_word;}
var eleSearchIcon=document.getElementById('searchIcon');
var eleInfoIcon=document.getElementById('infoIcon');
var eleSearchParams=document.getElementById('searchParamsBox');
var eleFilterText=document.getElementById('listFilterText');
filterMenu.resetFilter();
contentsData.clearFilter();
if(obj.type.id=='Search'){
}else if(obj.type.id=='Restore'){
words=append_word(words,obj.words);}else if(obj.type.id=='Recommend'){
words=append_word(words,SEARCH_STATUS.Recommend);}else if(obj.type.id=='Popular'){
words=append_word(words,SEARCH_STATUS.Popular);}else if(obj.type.id=='Favorite'){
words=append_word(words,SEARCH_STATUS.Favorite);}else if(obj.type.id=='Info'){
eleSearchParams.textContent='';
eleSearchIcon.classList.remove('show');
eleInfoIcon.classList.add('show');
return;}else {
eleSearchParams.textContent=words;
eleSearchIcon.classList.remove('show');
eleInfoIcon.classList.remove('show');
return;}
if(obj.filter){
if(obj.filter.keyword)
words=append_word(words,'\"'+obj.filter.keyword+'\"');
if(obj.filter.content&&obj.filter.content.word)
words=append_word(words,obj.filter.content.word);
if(obj.filter.timeline&&obj.filter.timeline.word)
words=append_word(words,obj.filter.timeline.word);
if(obj.filter.genre&&obj.filter.genre.word)
words=append_word(words,obj.filter.genre.word);}
eleSearchParams.textContent=words;
eleSearchIcon.classList.add('show');
eleInfoIcon.classList.remove('show');};
function ready(){
(function(){
var retry=0;
var lang=navigator.language;
var load_lang=function(arg){
var script=document.createElement('script');
script.src='js/lang/pkg_lang_'+arg+'.min.js';
DEBUG.console(DEBUG.LVL.INFO,'LANG src = '+script.src);
script.onload=function(){
contentManager.init.lang=true;
onload_main('lang');};
script.onerror=function(){
document.body.removeChild(this);
retry++;
if(retry==1){
load_lang(lang.substr(0,2));}else {
load_lang('en-IE');}
};
document.body.appendChild(script);};
if(lang=='zh'){
lang='zh-CN';}else if((lang=='en')||(lang=='en-CN')){
lang='en-HK';}else if(lang=='en-NZ'){
lang='en-AU';}else if(lang=='en-BR'){
lang='en-JM';}else if(lang=='es-BR'){
lang='es-AR';}
load_lang(lang);
if(lang.slice(0,2)==='ar'||
lang.slice(0,2)==='fa'||
lang.slice(0,2)==='he'){
mystream.textDirection='rtl';}else {
mystream.textDirection='ltr';}
})();
contentManager.onReceiveConfigurarion=function(param){
if(DEBUG.level>=DEBUG.LVL.INFO){
for(var key in param){
DEBUG.console(DEBUG.LVL.INFO,key+' : '+param[key]);}
}
if(param.with_multi_profile!=null){
Configurations.with_multi_profile=param.with_multi_profile;}
if(param.profile_id!=null){
Configurations.profile_id=param.profile_id;}
if(param.voice_req!=null){
Configurations.voice_req=param.voice_req;}
if((param.csearch_type!=null)&&(param.csearch_word!=null)){
Configurations.searchReq={type:param.csearch_type,
word:param.csearch_word};}
if(param.video_num!=null){
Configurations.video_num=param.video_num;}
if(param.auto_launch_appli!=null){
Configurations.auto_launch_appli=param.auto_launch_appli;}
if(param.auto_launch_ratio!=null){
Configurations.auto_launch_ratio=param.auto_launch_ratio;}
if(param.supportBroadcast!=null){
Configurations.supportBroadcast=param.supportBroadcast;}
if(param.supportRecordedTV!=null){
Configurations.supportRecordedTV=param.supportRecordedTV;}
if(param.supportMemo!=null){
Configurations.supportMemo=param.supportMemo;}
if(param.supportYoutube!=null){
Configurations.supportYoutube=param.supportYoutube;}
if(param.supportBookmark!=null){
Configurations.supportBookmark=param.supportBookmark;}
if(param.supportVOD!=null){
Configurations.supportVOD=param.supportVOD;}
if(param.displayInfoType!=null){
Configurations.displayInfoType=param.displayInfoType;}
if(param.streamingUI!=null){
Configurations.streamingUI=param.streamingUI;}
if(param.pixelShift!=null){
Configurations.pixelShift=param.pixelShift;}
if(param.forceSingleMode!=null){
forceSingleMode=param.forceSingleMode;}
contentManager.onReceiveConfigurarion=onReceiveConfigurarion;
contentManager.init.config=true;
onload_main('config');};
function onload_main(msg){
for(var key in contentManager.init){
if(key=='done')continue;
if(contentManager.init[key]==false)
return;}
contentManager.init.done=true;
if(!USE_DUMMY&&Configurations.auto_launch_appli==false){
Configurations.profile_id=parseInt(localStorage.getItem('last_profile_id'));
if(isNaN(Configurations.profile_id)){
Configurations.profile_id=-1;}
}
maxViewContents=(MAX_COLUMN*MAX_ROW)-3;
maxVideoNum=Configurations.video_num;
if(forceSingleMode){
maxVideoNum=1;}
msUtil=document.createElement('object');
msUtil.setAttribute('id','msUtil');
msUtil.setAttribute('type','application/mystream');
msUtil.width='0';
msUtil.height='0';
document.body.appendChild(msUtil);
mystream.msUtil=msUtil;
if(USE_DUMMY){
msUtil.getFavRegistProfile=function(){};
msUtil.getFavRegistStat=function(){return true;};
msUtil.setFavRegistStat=function(){};
msUtil.getPostCode=function(){return '12345678';};
msUtil.setPostCode=function(){};}
if(Configurations.with_multi_profile){
userControl.init();}
sizeInfo=(function(){
var obj={},scale,offset,eleContentArea;
eleContentArea=document.getElementById('contentArea');
offset=dom.getOffset(eleContentArea);
obj.windowWidth=window.outerWidth;
obj.windowHeight=window.outerHeight;
scale=obj.windowWidth/1920;
obj.contentAreaTop=offset.top;
obj.contentAreaLeft=offset.left;
obj.contentAreaWidth=eleContentArea.clientWidth;
obj.contentAreaHeight=eleContentArea.clientHeight;
obj.contentMoveAreaTop=obj.contentAreaTop;
obj.contentMoveAreaLeft=obj.contentAreaLeft;
obj.contentMoveAreaWidth=obj.contentAreaWidth;
obj.contentMoveAreaHeight=obj.contentAreaHeight;
obj.contentMargin=4*scale;
if(Configurations.pixelShift===0){
eleContentArea.classList.add('full');
eleContentArea.firstChild.classList.add('full');}else {
obj.contentAreaHeight-=6*scale;
obj.contentMoveAreaTop=obj.contentAreaTop;
obj.contentMoveAreaLeft=obj.contentAreaLeft+(10*scale);
obj.contentMoveAreaWidth=obj.contentAreaWidth-(20*scale);
obj.contentMoveAreaHeight=obj.contentAreaHeight;
obj.contentMargin=3*scale;
eleContentArea.classList.add('narrow');
eleContentArea.firstChild.classList.add('narrow');}
obj.contentWidth=obj.contentMoveAreaWidth/5;
obj.contentHeight=obj.contentMoveAreaHeight/3;
return obj;}());
mystream.contentsData=contentsData=new dataManager.ContentsData();
mystream.requestSettingList=function(id){
if(id==='srvprv'){
contentManager.getContents({type:{id:REQ_TYPE.SERVICE_PROVIDER}});}
};
mainFocus=new domFocus.Focus(document.getElementById('mainFocus'));
mainFocus.enable=false;
SEARCH_STATUS={
Recommend:LANG('LT_MYSTRM_RECOMMEND'),
Popular:LANG('LT_MYSTRM_POPULAR'),
Favorite:LANG('LT_MYSTRM_FAVORITE')
};
FIX_WORDS={
VIEWS:LANG('LT_MYSTRM_YOUTUBE_VIEWS'),
COMMENTS:LANG('LT_MYSTRM_YOUTUBE_COMMENTS'),
SETTINGS:LANG('LT_PH_SETTINGS'),
USER_SETTINGS:LANG('LT_USER_SETTINGS'),
YEAR:LANG('LT_CL_YEAR'),
MONTH:LANG('LT_CL_MONTH'),
DATE:LANG('LT_CL_DATE'),
MONTH_LIST:[
LANG('LT_JAN'),
LANG('LT_FEB'),
LANG('LT_MAR'),
LANG('LT_APR'),
LANG('LT_MAY'),
LANG('LT_JUN'),
LANG('LT_JUL'),
LANG('LT_AUG'),
LANG('LT_SEP'),
LANG('LT_OCT'),
LANG('LT_NOV'),
LANG('LT_DEC')
],
DAY_LIST:[
LANG('LT_SUN'),
LANG('LT_MON'),
LANG('LT_TUE'),
LANG('LT_WED'),
LANG('LT_THU'),
LANG('LT_FRI'),
LANG('LT_SAT')
]
};
document.getElementById('myCh').textContent=LANG('LT_MYSTREAM');
settingMenu.init(Configurations,ICON_PATH.LOADING_CIRCLE,function(){
var selectId;
if(Configurations.streamingUI===false){
beforeBackToMain();}else {
selectId=settingMenu.getSetting('scroll_type').id;
if(selectId==='page'&&
scrollControl.scrollType==='page'){
beforeBackToMain();}else if(selectId==='stream'&&
scrollControl.scrollType==='stream'){
beforeBackToMain();}else {
scrollControl.updateScrollType(selectId);
checkAppendContents();
systemEffect.start(EFFECT.INOUT);
removeAndClearContents();
listPosition=0;
gridFocusPos.x=-1;
gridFocusPos.y=-1;
mainFocus.enable=false;
scrollControl.startTimer();
wsRead([],'change_scroll_type');
renderFrameAndContents();}
}
screenState=SCREEN_STATE.MAIN_READY;
scrollControl.startTimer();
mainFocus.on();
tooltipUI.show();});
tooltipUI.init();
dialogUI.init();
modeControl.init();
scrollControl.init();
filterMenu.init(Configurations,function(filterId){
if(filterId===null||filterId===contentsData.filterId||
(filterId===FILTER_ID.ALL&&!contentsData.filterId)){
beforeBackToMain();
screenState=SCREEN_STATE.MAIN_READY;
scrollControl.startTimer();
mainFocus.on();}else {
updateFilter(filterId);}
});
searchScreen.init(function(searchText){
var ele;
if(searchText){
screenState=SCREEN_STATE.MAIN_WAITING_MSG;
gridPlayControl.stopPlay().clearList();
setTimeout(function(){
requestManager.request('Search',REQ_CONTENTS_NUM,null,
{keyword:searchText},{effectType:EFFECT.INOUT});},0);}else {
beforeBackToMain();
screenState=SCREEN_STATE.MAIN_READY;
focusPosition=FOCUS_POSITION.MODE_BUTTON;
scrollControl.startTimer();}
});
vodScreen.init(function(){
beforeBackToMain();
screenState=SCREEN_STATE.MAIN_READY;
scrollControl.startTimer();});
var wheelFlag=false;
function whFlagChange(){
wheelFlag=false;}
function wheel(event){
var delta=0;
if(!event){
event=document.event;}
if(event.wheelDelta){
delta=event.wheelDelta/120;
if(document.opera){
delta=-delta;}
}else if(event.detail){
delta=-event.detail/3;}
if(delta){
scrollControl.wheelHandler(delta,'user');}
if(event.preventDefault){
event.preventDefault();}
event.returnValue=false;}
if(window.addEventListener){
document.addEventListener('DOMMouseScroll',wheel,false);}
document.onmousewheel=document.onmousewheel=wheel;
var activateContent=function(frame){
var restrainKey=function(){
mainFocus.enable=false;
setTimeout(function(){
mainFocus.enable=true;},TIME.WAIT_LAUNCH_APP);};
switch(frame.content.attr.content){
case CONTENT.TV:
app_launcher.launch_application(frame.content);
restrainKey();
break;
case CONTENT.PICTURE:
app_launcher.launch_application(frame.content);
restrainKey();
break;
case CONTENT.VIDEO:
if(frame.content.kind!==KIND.VOD){
app_launcher.launch_application(frame.content);
restrainKey();}
break;
case CONTENT.AUDIO:
app_launcher.launch_application(frame.content);
restrainKey();
break;
case CONTENT.OTHER:
app_launcher.launch_application(frame.content);
restrainKey();
break;
default:
}
};
var moveFocusOnGrid=function(keyCode){
DEBUG.console(DEBUG.LVL.VERBOSE,'moveFocusOnGrid start');
var target,content=null,column=gridFocusPos.x,row=gridFocusPos.y;
switch(keyCode){
case KeyEvent.DOM_VK_UP:
if(row<=0){
return false;}
while(content===null){
row-=1;
if(row<0){
break;}
if(typeof gridData.viewTable[column][row]==='number'){
switch(gridData.viewTable[column][row]){
case gridData.LINK.UP:
row-=1;
break;
case gridData.LINK.DIAGONAL:
row-=1;
column-=1;
break;
default:
}
}
content=gridData.viewTable[column][row].frame.content;}
if(content===null){
for(row=gridFocusPos.y-1;row>=0;row-=1){
for(column=0+offsetColumn;column<MAX_COLUMN+offsetColumn;column+=1){
if(typeof gridData.viewTable[column][row]==='object'){
content=gridData.viewTable[column][row].frame.content;}
if(content!==null){
break;}
}
if(content!==null){
break;}
}
}
if(content===null){
return false;}
gridFocusPos.x=column;
gridFocusPos.y=row;
break;
case KeyEvent.DOM_VK_DOWN:
if(row>=MAX_ROW-1||
(gridData.viewTable[column][row].fourFrame===true&&
row+1>=MAX_ROW-1)){
return false;}
while(content===null){
row+=(gridData.viewTable[column][row].fourFrame===true)?2:1;
if(row>=MAX_ROW){
break;}
if(typeof gridData.viewTable[column][row]==='number'&&
gridData.viewTable[column][row]===gridData.LINK.LEFT){
column-=1;}
content=gridData.viewTable[column][row].frame.content;}
if(content===null){
if(gridData.viewTable[gridFocusPos.x][gridFocusPos.y].fourFrame===true){
row=gridFocusPos.y+2;}else {
row=gridFocusPos.y+1;}
for(;row<MAX_ROW;row+=1){
for(column=0+offsetColumn;column<MAX_COLUMN+offsetColumn;column+=1){
if(typeof gridData.viewTable[column][row]==='object'){
content=gridData.viewTable[column][row].frame.content;}
if(content!==null){
break;}
}
if(content!==null){
break;}
}
}
if(content===null){
return false;}
gridFocusPos.x=column;
gridFocusPos.y=row;
break;
case KeyEvent.DOM_VK_LEFT:
if(column<=0+offsetColumn){
if(mainFocus.currentState===domFocus.STATE.ON){
scrollControl.exeScroll(scrollControl.SCROLL_PREV,'user');}else {
gridPlayControl.startTimer();}
return true;}
while(content===null){
column-=1;
if(column<0){
break;}
if(typeof gridData.viewTable[column][row]==='number'){
switch(gridData.viewTable[column][row]){
case gridData.LINK.LEFT:
column-=1;
break;
case gridData.LINK.DIAGONAL:
row-=1;
column-=1;
break;
default:
}
}
content=gridData.viewTable[column][row].frame.content;}
if(content===null){
for(column=gridFocusPos.x-1;column>=0+offsetColumn;column-=1){
for(row=0;row<MAX_ROW;row+=1){
if(typeof gridData.viewTable[column][row]==='object'){
content=gridData.viewTable[column][row].frame.content;}
if(content!==null){
break;}
}
if(content!==null){
break;}
}
}
if(content===null){
return false;}
gridFocusPos.x=column;
gridFocusPos.y=row;
break;
case KeyEvent.DOM_VK_RIGHT:
if(column===MAX_COLUMN+offsetColumn-1||
(column===MAX_COLUMN+offsetColumn-2&&
gridData.viewTable[column][row].fourFrame===true)){
if(mainFocus.currentState===domFocus.STATE.ON){
scrollControl.exeScroll(scrollControl.SCROLL_NEXT,'user');}else {
gridPlayControl.startTimer();}
return true;}
while(content===null){
column+=(gridData.viewTable[column][row].fourFrame===true)?2:1;
if(column>=MAX_COLUMN+offsetColumn){
break;}
if(typeof gridData.viewTable[column][row]==='number'&&
gridData.viewTable[column][row]===gridData.LINK.UP){
row-=1;}
content=gridData.viewTable[column][row].frame.content;}
if(content===null){
if(gridData.viewTable[gridFocusPos.x][gridFocusPos.y].fourFrame===true){
column=gridFocusPos.x+2;}else {
column=gridFocusPos.x+1;}
for(;column<MAX_COLUMN+offsetColumn;column+=1){
for(row=0;row<MAX_ROW;row+=1){
if(typeof gridData.viewTable[column][row]==='object'){
content=gridData.viewTable[column][row].frame.content;}
if(content!==null){
break;}
}
if(content!==null){
break;}
}
}
if(content===null){
return false;}
gridFocusPos.x=column;
gridFocusPos.y=row;
break;
default:
}
target=gridData.viewTable[gridFocusPos.x][gridFocusPos.y];
mainFocus.move(document.getElementById(target.frame.id));
setContentInfo(target.frame.content);
gridPlayControl.startTimer();
return true;};
var keyDownHandlerOnGrid=function(event){
DEBUG.console(DEBUG.LVL.VERBOSE,'keyDownHandlerOnGrid');
var currentState=screenState,focusIndex=0,content;
switch(event.keyCode){
case KeyEvent.DOM_VK_UP:
if(!moveFocusOnGrid(event.keyCode)){
hideContentInfo();
mainFocus.move(document.getElementById('listFilterArrow'));
focusPosition=FOCUS_POSITION.FILTER;}
break;
case KeyEvent.DOM_VK_DOWN:
if(!moveFocusOnGrid(event.keyCode)){
hideContentInfo();
focusIndex=modeControl.changeFocusIndex(gridFocusPos.x).focusIndex;
mainFocus.move(document.getElementById('fillBtn'+focusIndex));
focusPosition=FOCUS_POSITION.MODE_BUTTON;}
break;
case KeyEvent.DOM_VK_LEFT:
moveFocusOnGrid(event.keyCode);
break;
case KeyEvent.DOM_VK_RIGHT:
moveFocusOnGrid(event.keyCode);
break;
case KeyEvent.DOM_VK_RETURN:
if(gridData.viewTable[gridFocusPos.x][gridFocusPos.y].frame.content!==null){
content=gridData.viewTable[gridFocusPos.x][gridFocusPos.y].frame.content;
if(content.kind===KIND.VOD){
screenState=SCREEN_STATE.VOD_PURCHASE;
vodScreen.open();}else {
activateContent(gridData.viewTable[gridFocusPos.x][gridFocusPos.y].frame);}
}
break;
case KeyEvent.DOM_VK_BACK_SPACE:
break;
case KeyEvent.DOM_VK_MYBUTTON:
myButton.launch(gridData.viewTable[gridFocusPos.x][gridFocusPos.y].frame.content);
break;
default:
}
};
var keyDownHandlerOnModeButton=function(event){
DEBUG.console(DEBUG.LVL.VERBOSE,'keyDownHandlerOnModeButton');
var target,position,column,modeName,reqType,options,userId=null;
switch(event.keyCode){
case KeyEvent.DOM_VK_UP:
column=modeControl.getColumn();
position=searchFocusPositionFromViewTable(
{horizontal:(column<Math.floor(MAX_COLUMN/2))?'left':'right',
vertical:'bottom'},
{column:column,row:MAX_ROW-1}
);
if(position){
gridFocusPos.x=position.x;
gridFocusPos.y=position.y;
target=gridData.viewTable[gridFocusPos.x][gridFocusPos.y];
mainFocus.move(document.getElementById(target.frame.id),function(){
setContentInfo(target.frame.content);
gridPlayControl.startTimer();});
focusPosition=FOCUS_POSITION.GRID;}else {
mainFocus.move(document.getElementById('listFilterArrow'));
focusPosition=FOCUS_POSITION.FILTER;}
break;
case KeyEvent.DOM_VK_LEFT:
modeControl.prevFocus();
break;
case KeyEvent.DOM_VK_RIGHT:
modeControl.nextFocus();
break;
case KeyEvent.DOM_VK_RETURN:
if(modeControl.getEnable()===false){
return;}
modeName=modeControl.getModeName();
switch(modeName){
case 'recommend':
case 'favorite':
case 'popular':
case 'information':
screenState=SCREEN_STATE.MAIN_WAITING_MSG;
options={effectType:EFFECT.INOUT};
reqType=modeControl.getRequestType();
if(reqType===REQ_TYPE.RECOMMEND||
reqType===REQ_TYPE.FAVORITE){
userId=userControl.getCurrentUserId();}
requestManager.request(reqType,REQ_CONTENTS_NUM,userId,null,options);
break;
case 'search':
screenState=SCREEN_STATE.SEARCH;
searchScreen.open();
break;
default:
}
break;
default:
}
};
var keyDownHandlerOnSetting=function(event){
DEBUG.console(DEBUG.LVL.VERBOSE,'keyDownHandlerOnSetting');
var ele,target;
switch(event.keyCode){
case KeyEvent.DOM_VK_RETURN:
mainFocus.off();
screenState=SCREEN_STATE.SETTING_POPUP;
settingMenu.open();
break;
case KeyEvent.DOM_VK_DOWN:
if(Configurations.with_multi_profile){
if(userControl.userCount>0){
userControl.setFocus(1);
focusPosition=FOCUS_POSITION.USER_LIST;}else {
mainFocus.move(document.getElementById('userSettingIcon'));
focusPosition=FOCUS_POSITION.USER_SETTING;}
}else {
mainFocus.move(document.getElementById('listFilterArrow'));
focusPosition=FOCUS_POSITION.FILTER;}
break;
default:
}
};
var keyDownHandlerOnFilter=function(event){
DEBUG.console(DEBUG.LVL.VERBOSE,'keyDownHandlerOnFilter');
var target,position,frameId=null,focusIndex=0;
switch(event.keyCode){
case KeyEvent.DOM_VK_RETURN:
screenState=SCREEN_STATE.FILTER;
mainFocus.off();
scrollControl.startTimer();
filterMenu.open();
break;
case KeyEvent.DOM_VK_UP:
if(Configurations.with_multi_profile){
if(userControl.userCount>0){
userControl.setFocus(1);
focusPosition=FOCUS_POSITION.USER_LIST;}else {
mainFocus.move(document.getElementById('userSettingIcon'));
focusPosition=FOCUS_POSITION.USER_SETTING;}
}else {
mainFocus.move(document.getElementById('iconSettingBox'));
focusPosition=FOCUS_POSITION.SETTING;}
break;
case KeyEvent.DOM_VK_DOWN:
position=searchFocusPositionFromViewTable(
{horizontal:'right',vertical:'top'});
if(position){
gridFocusPos.x=position.x;
gridFocusPos.y=position.y;
target=gridData.viewTable[gridFocusPos.x][gridFocusPos.y];
mainFocus.move(document.getElementById(target.frame.id),function(){
setContentInfo(target.frame.content);
gridPlayControl.startTimer();});
focusPosition=FOCUS_POSITION.GRID;}else {
hideContentInfo();
focusIndex=modeControl.changeFocusIndex('right').focusIndex;
mainFocus.move(document.getElementById('fillBtn'+focusIndex));
focusPosition=FOCUS_POSITION.MODE_BUTTON;}
break;
default:
}
};
var keyDownHandlerOnUserList=function(event){
DEBUG.console(DEBUG.LVL.VERBOSE,'keyDownHandlerOnUserList');
var target,column,row,frameId=null;
switch(event.keyCode){
case KeyEvent.DOM_VK_RETURN:
userControl.changeUser();
screenState=SCREEN_STATE.MAIN_WAITING_MSG;
DEBUG.console(DEBUG.LVL.INFO,'uId:'+userControl.getCurrentUserId());
requestManager.request('Recommend',REQ_CONTENTS_NUM,
userControl.getCurrentUserId(),null,
{effectType:EFFECT.GATHER});
break;
case KeyEvent.DOM_VK_UP:
mainFocus.ele.classList.remove('cmn_circle');
mainFocus.move(document.getElementById('iconSettingBox'));
focusPosition=FOCUS_POSITION.SETTING;
break;
case KeyEvent.DOM_VK_DOWN:
mainFocus.ele.classList.remove('cmn_circle');
mainFocus.move(document.getElementById('listFilterArrow'));
focusPosition=FOCUS_POSITION.FILTER;
break;
case KeyEvent.DOM_VK_LEFT:
userControl.moveFocus(-1);
break;
case KeyEvent.DOM_VK_RIGHT:
if(!userControl.moveFocus(1)){
mainFocus.ele.classList.remove('cmn_circle');
mainFocus.move(document.getElementById('userSettingIcon'));
focusPosition=FOCUS_POSITION.USER_SETTING;}
break;
default:
}
};
var keyDownHandlerOnUserSetting=function(event){
DEBUG.console(DEBUG.LVL.VERBOSE,'keyDownHandlerOnUserSetting');
var restrainKey;
switch(event.keyCode){
case KeyEvent.DOM_VK_RETURN:
restrainKey=function(){
mainFocus.enable=false;
setTimeout(function(){
mainFocus.enable=true;},TIME.WAIT_LAUNCH_APP);};
if(userControl.userCount<6){
system.socket.write(JSON.stringify({command:'create_user'}));
restrainKey();}
break;
case KeyEvent.DOM_VK_UP:
mainFocus.move(document.getElementById('iconSettingBox'));
focusPosition=FOCUS_POSITION.SETTING;
break;
case KeyEvent.DOM_VK_DOWN:
mainFocus.move(document.getElementById('listFilterArrow'));
focusPosition=FOCUS_POSITION.FILTER;
break;
case KeyEvent.DOM_VK_LEFT:
if(userControl.userCount>0){
userControl.setFocus(0);
focusPosition=FOCUS_POSITION.USER_LIST;}
break;
case KeyEvent.DOM_VK_RIGHT:
default:
break;}
};
document.addEventListener('keydown',function(event){
DEBUG.console(DEBUG.LVL.VERBOSE,'keycode='+event.keyCode);
var focusIndex;
dom.stopEvent(event);
if(dialogUI.isOpen()){
dialogUI.keyDownHandler(event);
return;}
scrollControl.stopTimer();
gridPlayControl.stopTimer();
if(event.keyCode===KeyEvent.DOM_VK_PAGE_UP){
if(scrollControl.scrollType==='page'){
scrollControl.wheelHandler(scrollControl.WHEEL_UP,'user');}else {
if(scrollControl.isScrolling){
if(scrollControl.lastTrigger!=='user'){
scrollControl.stopScroll();
setFocusAfterStopScroll();}
return;}
if(mainFocus.enable){
scrollControl.wheelHandler(scrollControl.WHEEL_UP,'user');}
}
return;}else if(event.keyCode===KeyEvent.DOM_VK_PAGE_DOWN){
if(scrollControl.scrollType==='page'){
scrollControl.wheelHandler(scrollControl.WHEEL_DOWN,'user');}else {
if(scrollControl.isScrolling){
if(scrollControl.lastTrigger!=='user'){
scrollControl.stopScroll();
setFocusAfterStopScroll();}
return;}
if(mainFocus.enable){
scrollControl.wheelHandler(scrollControl.WHEEL_DOWN,'user');}
}
return;}
tooltipUI.hide();
switch(screenState){
case SCREEN_STATE.MAIN_LOADING:
case SCREEN_STATE.MAIN_WAITING_MSG:
if(event.keyCode==KeyEvent.DOM_VK_BACK_SPACE){
requestManager.cancel();}
return;
break;
case SCREEN_STATE.MYBUTTON:
return;
break;
case SCREEN_STATE.MAIN_READY:if(scrollControl.scrollType==='page'){
scrollControl.startTimer();
if(scrollControl.isScrolling||
mainFocus.enable!==true){
tooltipUI.show();
return;}
}else {
if(scrollControl.isScrolling){
if(scrollControl.lastTrigger!=='user'){
scrollControl.stopScroll();
setFocusAfterStopScroll();}
return;}
scrollControl.startTimer();
if(mainFocus.enable!==true){
tooltipUI.show();
return;}
}
switch(focusPosition){
case FOCUS_POSITION.GRID:
keyDownHandlerOnGrid(event);
break;
case FOCUS_POSITION.MODE_BUTTON:
keyDownHandlerOnModeButton(event);
break;
case FOCUS_POSITION.SETTING:
keyDownHandlerOnSetting(event);
break;
case FOCUS_POSITION.USER_LIST:
keyDownHandlerOnUserList(event);
break;
case FOCUS_POSITION.LIST_FILTER:
break;
case FOCUS_POSITION.FILTER:
keyDownHandlerOnFilter(event);
break;
case FOCUS_POSITION.USER_SETTING:
keyDownHandlerOnUserSetting(event);
break;
default:
tooltipUI.show();
return;}
tooltipUI.show();
break;
case SCREEN_STATE.SETTING_POPUP:
scrollControl.startTimer();
settingMenu.keyDownHandler(event);
return;
break;
case SCREEN_STATE.VOD_PURCHASE:
vodScreen.keyDownHandler(event);
return;
break;
case SCREEN_STATE.FILTER:
filterMenu.keyDownHandler(event);
return;
break;
default:
return;}
if(event.keyCode==KeyEvent.DOM_VK_BACK_SPACE){
system.socket.write(JSON.stringify({command:'exit'}));}
},false);
var handleWebSocketMessage=function(data){
DEBUG.console(DEBUG.LVL.INFO,'handleWebSocketMessage');
var options;
switch(data.resultType){
case 'new':
case 'append':
if(data.status!=='OK'){
DEBUG.console(DEBUG.LVL.ERROR,'Error. status='+data.status);
return;}
if(data.type===REQ_TYPE.SERVICE_PROVIDER){
settingMenu.setList(data.info,data.selected);
return;}
if(data.reqId!==requestManager.reqId){
DEBUG.console(DEBUG.LVL.INFO,'Invalid reqId='+data.reqId);
return;}
if(data.guide===1){
displayOfflinePanel=true;}
if(data.resultType==='new'&&
data.type===REQ_TYPE.INFO){
options={};
options.isInfo=true;}
prepareContents(data.info,data.resultType,options);
break;
case 'update':
updateContent(data);
break;
default:
DEBUG.console(DEBUG.LVL.INFO,'Unknown resultType='+data.resultType);}
};
contentManager.getContentsWithShow=function(requestInfo){
var query_obj=contentManager.getContents(requestInfo);
};
contentManager.addCallback(handleWebSocketMessage);
if(!USE_DUMMY&&Configurations.auto_launch_appli==false){
var words=localStorage.getItem('search_words');
if(words){
var obj={type:{id:'Restore'},words:words};
showSearchFactors(obj);}else {
showSearchFactors({type:{id:REQ_TYPE.INFO},words:''});}
var lastGrid=JSON.parse(localStorage.getItem('last_grid'));
listPosition=parseInt(lastGrid.pos);
gridFocusPos.x=parseInt(lastGrid.x);
gridFocusPos.y=parseInt(lastGrid.y);
var contents=localStorage.getItem('contents');
var options={layout:lastGrid.layout,
filterId:lastGrid.filter_id,
launchAppInfo:lastGrid.launch_app_info};
prepareContents(JSON.parse(contents),'return',options);}else {
var firstReq={type:'Recommend',filter:null};
if(Configurations.voice_req){
var voiceReq=JSON.parse(Configurations.voice_req);
if(voiceReq.type&&voiceReq.type.id){
firstReq.type=voiceReq.type.id;}
if(voiceReq.filter){
firstReq.filter=voiceReq.filter;}
}else if(Configurations.searchReq){
firstReq.type='Search';
firstReq.filter={keyword:Configurations.searchReq.word};
switch(Configurations.searchReq.type){
case 2:
firstReq.filter.content={word:LANG('LT_SE_DIC_VIDEOS')};
firstReq.filter.content.id=CONTENT.VIDEO;
break;
case 3:
firstReq.filter.content={word:LANG('LT_SE_PROGRAM_GUIDE')};
firstReq.filter.content.id=CONTENT.TV;
break;
case 4:
firstReq.filter.kind={id:KIND.RECORDED};
firstReq.filter.content={word:LANG('LT_SE_RECORDED_TV')};
firstReq.filter.content.id=CONTENT.VIDEO;
break;
case 5:
firstReq.filter.kind={id:KIND.FILE};
firstReq.filter.content={word:LANG('LT_SE_STORED_CONTENT')};
break;}
}
requestManager.request(firstReq.type,REQ_CONTENTS_NUM,
userControl.getCurrentUserId(),firstReq.filter,
{useEffect:false});}
(function(){
if(!DEBUG_MODE){
return;}
var watchingTime=500,
lastScreenState=null,
lastFocusPos=null,
lastFocusState=null,
lastPlayControlIds=null,
lastIsScrolling=null,
screenKeys=Object.keys(SCREEN_STATE),
focusPosKeys=Object.keys(FOCUS_POSITION),
focusStateKeys=Object.keys(domFocus.STATE);
var watchingState=function(){
var i,max,value=-1;
setTimeout(watchingState,watchingTime);
if(lastScreenState!==screenState){
for(i=0,max=screenKeys.length;i<max;i+=1){
if(screenState===SCREEN_STATE[screenKeys[i]]){
DEBUG.console(DEBUG.LVL.NONE,'screenState:'+screenKeys[i]);
break;}
}
}
if(lastFocusPos!==focusPosition){
for(i=0,max=focusPosKeys.length;i<max;i+=1){
if(focusPosition===FOCUS_POSITION[focusPosKeys[i]]){
DEBUG.console(DEBUG.LVL.NONE,'focusPosition:'+focusPosKeys[i]);
break;}
}
}
if(lastFocusState!==mainFocus.currentState){
for(i=0,max=focusStateKeys.length;i<max;i+=1){
if(mainFocus.currentState===domFocus.STATE[focusStateKeys[i]]){
DEBUG.console(DEBUG.LVL.NONE,'maiFocus state:'+focusStateKeys[i]);
break;}
}
}
if(lastIsScrolling!==scrollControl.isScrolling){
DEBUG.console(DEBUG.LVL.NONE,'isScrolling:'+scrollControl.isScrolling);}
lastScreenState=screenState;
lastFocusPos=focusPosition;
lastFocusState=mainFocus.currentState;
lastIsScrolling=scrollControl.isScrolling;};
watchingState();}());};}
contentManager.onUpdateMyButton=function(param){
if(msUtil&&msUtil.setFavRegistStat){
if(param.key===myButton.lastRequest.key){
msUtil.setFavRegistStat(myButton.lastRequest.kind,
myButton.lastRequest.key,
param.id,param.regist,
myButton.lastRequest.start_time,
myButton.lastRequest.duration);}
}
};
contentManager.onExitMyButton=function(){
DEBUG.console(DEBUG.LVL.INFO,'exit my button');
var content,favStarIcon,eleFrame,eleOverlay,
target=gridData.viewTable[gridFocusPos.x][gridFocusPos.y];
if(target&&target.frame&&target.frame.content){
content=target.frame.content;
content.attr.favRegist=getFavRegist(content);
eleFrame=document.getElementById(target.frame.id);
eleOverlay=eleFrame.lastChild;
favStarIcon=document.getElementById('favStarIcon');
if(content.attr.favRegist){
favStarIcon.classList.add('show');
if(eleOverlay.className==='contentOverlay'){
eleOverlay.children[1].classList.add('show');}
}else {
favStarIcon.classList.remove('show');
if(eleOverlay.className==='contentOverlay'){
eleOverlay.children[1].classList.remove('show');}
}
}
screenState=SCREEN_STATE.MAIN_READY;
scrollControl.startTimer();};
contentManager.onNotifyAuthenticatedUserId=function(param){
if(contentManager.init.done){
userControl.setCurrentUserId(param);
var type=REQ_TYPE.RECOMMEND;
var filter=null;
var requestFunc=function(){
scrollControl.stopTimer();
tooltipUI.hide();
screenState=SCREEN_STATE.MAIN_WAITING_MSG;
mainFocus.off();
focusPosition=FOCUS_POSITION.GRID;
gridPlayControl.stopPlay().clearList();
appendQueue.clear();
requestManager.request(type,REQ_CONTENTS_NUM,
userControl.getCurrentUserId(),filter,
{effectType:EFFECT.GATHER});};
switch(screenState){
case SCREEN_STATE.MAIN_LOADING:
case SCREEN_STATE.MYBUTTON:
break;
case SCREEN_STATE.MAIN_WAITING_MSG:
mainFocus.off();
focusPosition=FOCUS_POSITION.GRID;
requestManager.request(type,REQ_CONTENTS_NUM,
userControl.getCurrentUserId(),filter,
{effectType:EFFECT.GATHER});
break;
case SCREEN_STATE.MAIN_READY:
requestFunc();
break;
case SCREEN_STATE.SETTING_POPUP:
break;
case SCREEN_STATE.VOD_PURCHASE:
break;
case SCREEN_STATE.SEARCH:
searchScreen.close(requestFunc);
break;
case SCREEN_STATE.FILTER:
filterMenu.close(requestFunc);
break;}
}else {
authProfileId=param;}
};
contentManager.onNotifyForceSingleMode=function(mode){
DEBUG.console(DEBUG.LVL.WARN,'onNotifyForceSingleMode:'+mode);
if(mode===true){
maxVideoNum=1;
gridPlayControl.giveUpMuteContent();}else {
maxVideoNum=Configurations.video_num;}
};
var onReceiveConfigurarion=function(obj){
};
var requestContents=function(reqObj){
var obj,type,filter,requestFunc;
if(typeof reqObj=='string'){
obj=JSON.parse(reqObj);}else {
obj=reqObj;}
if(obj.type&&obj.type.id&&obj.filter){
var userId=null;
type=obj.type.id;
filter=obj.filter;
if(type===REQ_TYPE.RECOMMEND||
type===REQ_TYPE.FAVORITE){
userId=userControl.getCurrentUserId();}
requestFunc=function(){
if(scrollControl.scrollType==='stream'&&
scrollControl.isScrolling===true){
scrollControl.stopScroll();}
scrollControl.stopTimer();
tooltipUI.hide();
screenState=SCREEN_STATE.MAIN_WAITING_MSG;
mainFocus.off();
focusPosition=FOCUS_POSITION.GRID;
gridPlayControl.stopPlay().clearList();
appendQueue.clear();
requestManager.request(type,REQ_CONTENTS_NUM,userId,filter,
{effectType:EFFECT.INOUT});};
switch(screenState){
case SCREEN_STATE.MAIN_LOADING:
case SCREEN_STATE.MYBUTTON:
break;
case SCREEN_STATE.MAIN_WAITING_MSG:
mainFocus.off();
focusPosition=FOCUS_POSITION.GRID;
requestManager.request(type,REQ_CONTENTS_NUM,userId,filter,
{effectType:EFFECT.INOUT});
break;
case SCREEN_STATE.MAIN_READY:
requestFunc();
break;
case SCREEN_STATE.SETTING_POPUP:
break;
case SCREEN_STATE.VOD_PURCHASE:
break;
case SCREEN_STATE.SEARCH:
searchScreen.close(requestFunc);
break;
case SCREEN_STATE.FILTER:
filterMenu.close(requestFunc);
break;
default:
}
}else {
DEBUG.console(DEBUG.LVL.ERROR,'requestContents: No type or filter defined\n');}
};
mystream.settingMenu=settingMenu;
mystream.requestContents=requestContents;
mystream.gridPlayControl=gridPlayControl;
mystream.filterMenu=filterMenu;
mystream.Configurations=Configurations;
mystream.dialogUI=dialogUI;}(window,MYSTREAM,DOMUTIL));
