
'use strict';
var kbDbg={log:function(){}};
if(0)kbDbg=console;
var kbErrLog=function(str){
console.log('MngFocusBar:'+str);};
FDP.KBD=FDP.KBD||{};

FDP.KBD.keys=(function(){
var self={};
self.columnMax=20;
var that={};
var buildKey=function(label,className,width,dataset,
attributeList){
var contentNode=document.createElement('button');
contentNode.className='keyboard-key '+className;

if(attributeList){
attributeList.forEach(function(attribute){
contentNode.setAttribute(attribute.key,attribute.value);});}
dataset.forEach(function(data){
contentNode.dataset[data.key]=data.value;});
var vWrapperNode=document.createElement('span');
vWrapperNode.className='visual-wrapper';
var labelNode=document.createElement('span');
labelNode.innerHTML=label;
labelNode.classList.add('fdp-color-base-sub');
labelNode.classList.add('fdp-color-text-sub-onbase');
vWrapperNode.appendChild(labelNode);
contentNode.appendChild(vWrapperNode);
return contentNode;};
that.make=function(layout){

var kbd=document.createElement('div');
kbd.id='keyboard-ele';
self.columnMax=layout.width||20;
var keyArys=FDP.KBD.mngLayouts.convLayoutKeyArys(layout.keys,self.columnMax);


var content=document.createDocumentFragment();
keyArys.forEach((function buildKeyboardRow(row,nrow){
var kbRow=document.createElement('div');
var rowLayoutWidth=0;
kbRow.classList.add('keyboard-row');

row.forEach((function buildKeyboardColumns(key,ncolumn){
var keyChar=key;
var code=keyChar.charCodeAt(0);
var className='';
var keyWidth=0;
var dataset=[{'key':'row','value':nrow}];
dataset.push({'key':'column','value':ncolumn});
dataset.push({'key':'keycode','value':code});
var attributeList=[];
if(key.disabled){
attributeList.push({
key:'disabled',
value:'true'
});}
kbRow.appendChild(buildKey(keyChar,className,keyWidth+'px',
dataset,attributeList));}));
kbRow.dataset.layoutWidth=rowLayoutWidth;
content.appendChild(kbRow);}));
kbd.innerHTML='';
kbd.appendChild(content);
return kbd;};
that.setKeysWidth=function(ele,width){
var layoutWidth=self.columnMax;
var totalWidth=width*0.9;
var placeHolderWidth=totalWidth/layoutWidth;
placeHolderWidth+='px';
var eles=ele.getElementsByClassName('keyboard-key');
for(var i=0;i<eles.length;i++){
eles[i].setAttribute('style','width: '+placeHolderWidth+';');}
};
that.stripButton=function(ele){
return ele.getElementsByClassName('visual-wrapper')[0];};
return that;}());
FDP.KBD.mngEdited=(function(){
var self={};
var that={};
self.curNumKey={
key:-1,
repeat:0,
max:0
};
that.init=function(getValue,setValue,maxLength,upperCase){
var srcTxt=getValue();
self.getValue=getValue;
self.setValue=setValue;
self.maxLength=maxLength||0;
self.selectionStart=srcTxt.length;
self.selectionEnd=srcTxt.length;
self.upperCase=upperCase.assoc;
self.curNumKey.key=-1;
self.curNumKey.repeat=0;
self.curNumKey.max=0;};
that.resetNumKeyRepeat=function(){
self.curNumKey.key=-1;
self.curNumKey.repeat=0;
self.curNumKey.max=0;};
that.sendKeycode=function(keycode){
if((self.maxLength!=0)&&(self.selectionEnd>(self.maxLength-1))){
return;}
var srcTxt=self.getValue();
self.setValue(srcTxt+String.fromCharCode(keycode));
self.selectionStart++;
self.selectionEnd++;};
that.getKeyCodeByNumKey=function(key){
var cur=self.curNumKey;
var keycode;
if(key!=cur.key){
cur.key=key;
cur.repeat=0;
cur.max=self.upperCase[key].length;}else {
cur.repeat++;
cur.repeat=cur.repeat%cur.max;}
keycode=self.upperCase[cur.key][cur.repeat];
kbDbg.log('keycode '+keycode);
return {keycode:keycode,length:cur.max};};
that.keyDelete=function(){
var srcTxt=self.getValue();
if(self.selectionStart>0){
self.selectionStart--;
self.selectionEnd--;
self.setValue(srcTxt.substring(0,self.selectionStart)+
srcTxt.substring(self.selectionStart,self.selectionEnd));}
};
that.keyAllDelete=function(){
self.selectionStart=0;
self.selectionEnd=0;
self.setValue('');};
that.checkNumKeyChanged=function(key){
var cur=self.curNumKey;
if(cur.key==-1){
return false;}
if(key==cur.key){
return false;}
return true;};
return that;}());
FDP.KBD.MngMoveTable=function(wrapEle,rowClassName,colClassName){
var i;
wrapEle=wrapEle||'document';
this.rowsObj=wrapEle.getElementsByClassName(rowClassName);
this.rowLength=this.rowsObj.length;
this.colLength=[];
for(i=0;i<this.rowsObj.length;i++){
this.colLength.push(this.rowsObj[i].getElementsByClassName(colClassName).length);}
this.className={row:rowClassName,col:colClassName};
this.current={row:0,col:0,obj:null};
this.getObjByIncrement(0,0);};
(function(){
var MngMvTbl=FDP.KBD.MngMoveTable;
MngMvTbl.prototype.getObj=function(){
var cur=this.current;
var cName=this.className;
var rowObj=this.rowsObj[cur.row];
return rowObj.getElementsByClassName(cName.col)[cur.col];
};
MngMvTbl.prototype.incFocus=function(cur,inc,max,loop){
kbDbg.log(cur+' '+inc+' '+max);
cur=cur||0;
inc=inc||0;
max=max||0;
var val=cur+inc;
if(isNaN(val)){
val=0;}
var over=((val<0)||(val>=max));
if(loop){
val=((val+max)%max);}else {
val=Math.max(Math.min(val,max-1),0);}
return {val:val||0,over:over};};
MngMvTbl.prototype.getObjByIncrement=function(mvRow,mvCol){
var cur=this.current;
var tmp={};
tmp.over=false;
if(mvRow!=0){
tmp.val=cur.row;
for(var i=0;i<this.rowLength;i++){tmp=this.incFocus(tmp.val,mvRow,this.rowLength,true);
if(!this.incFocus(cur.col,0,this.colLength[tmp.val],true).over){
cur.row=tmp.val;
break;}
}
}else {
tmp=this.incFocus(cur.col,mvCol,this.colLength[cur.row],true);
cur.col=tmp.val;}
cur.obj=this.getObj();
return {obj:cur.obj,over:tmp.over};};
MngMvTbl.prototype.getCurrentObj=function(){
return this.current.obj;};
MngMvTbl.prototype.serchObj=function(keycode){
var i,j;
var cur=this.current;
var Obj;
var rowObj;
for(i=0;i<this.rowsObj.length;i++){
rowObj=this.rowsObj[i].getElementsByClassName(this.className.col);
for(j=0;j<rowObj.length;j++){
if(rowObj[j].dataset.keycode==keycode){
cur.row=i;
cur.col=j;
cur.obj=this.getObj();
return cur.obj;}
}
}
return null;};}());
