eval_js_file ("file:///usr/local/javascript/wing/epop/tween.js"); 

var sd_testmode = 0;
var epop_data_path = "file:///usr/local/png/";
var epop_ex_data_path = "file:///edata/epop/ex/";

/*
x range (-960 <=> 960, total 1920)
y range (-540 <=> 540, total 1080)
z range (???)
***display center translate [0, 0, 0]

var win_w = 1920;
var win_h = 1080;
var win_half_w = win_w/2;
var win_half_h = win_h/2;
*/

var epop_timer = new container ({});
var epop_timeout_timer = new container ({});
var epop_key_timer = new container ({});

///* use process *///
var epop_count = 0;
var epop_count_max = 6;
var epop_stop = 0;
var epop_ex_enable = 0;
var epop_left = 0;
var epop_top = 0;
////////////////////

var key_enable = false; /* key action enable flag. */

var image_x_out = -1300; /* Each image frame out position. (Use 1st and end) */
var pict_next_x_out = 1000; /* Each pict out position. (Next pict frame in.) */

var floor_y = -440; /* floor(panasonic/series/panel logo) image y base position */
var floor_x = -775; /* floor(panasonic/series/panel logo) image x base position */
var floor_w = 373; /* floor(panasonic/series/panel logo) image width */
var floor_h = 170; /* floor(panasonic/series/panel logo) image height */

var pictfloor_y = floor_y; /* pictfloor image y 1st position */
//var pictfloor_x is set calc position.
var pictfloor_w = 222; /* pictfloor image width */
var pictfloor_h = 170; /* pictfloor image height */

var pict_y = floor_y /* pict image y 1st position */
//var pict_x is set calc position.
var pict_w = 168; /* pict image width */
var pict_h = 105; /* pict image height */

var pict0_base_x = 850; /* pict0 image x 1st position */
var pict_move_x = -pictfloor_w; /* pict image x position */

var pickup_pict_x = -455; /* pickup pict x position(right pattern) */
var pickup_pict_x_left = -463;//-465; /* pickup pict x position(left pattern) */

var slide_x = 115; /* ePOP slide image x position(right pattern) */
var slide_x_left = 106; /* ePOP slide image x position(left pattern) */
var slide_y = floor_y /* ePOP slide image y position */

/////* Other */////
var pict_rotate_angle = -90 /* param set in feeling. */
var pict_rotate_y_space = -40; /* param set in feeling. */
///////////////////

//////* Each file name *//////
var pictfloor_png = "pict_base.png";
var pict_base_black_png = "pict_base_b.png";
var floor_png = "logo_base.png";
//////////////////////////////


var s = new stage ({});

var pict_anim = new gscenario;
pict_anim.init ();
var slide_anim = new gscenario;
slide_anim.init ();
var pictfloor_black_anim = new gscenario;
pictfloor_black_anim.init ();

var epop_title_font_name = "F015T-regular";
var epop_font_name = "F015T-regular";
var epop_text_align = LEFT;

var reduce_step = 0;

var epop_data = new epop_data_func ();

function epop_data_func ()
{
    this.area;
    this.model;
    this.inch;
    this.country;
    this.lang;
    this.series_logo = "";
    this.panel_logo = "";
    this.data = [];
    
    this.init = function (config) {	
	if (sd_testmode) {
	    eval_js_file ("file:///mnt/sdcard/epop_data.js");
	    eval_js_file ("file:///mnt/sdcard/epop_config_data.js");
	    epop_data_path = "file:///mnt/sdcard/data/";
	    epop_ex_data_path = "file:///mnt/sdcard/data/";
	    
	    this.area    = epop_config_list[0];
	    this.model   = epop_config_list[1];
	    this.inch    = epop_config_list[2];
	    this.country = epop_config_list[3];
	    this.lang    = epop_config_list[4];
	    epop_font_name = epop_config_list[5];
	}
	else {
	    eval_js_file ("file:///usr/local/javascript/wing/epop/epop_data.js");
	    epop_data_path = "file:///usr/local/png/";
	    epop_ex_data_path = "file:///edata/epop/ex/";
	    
	    this.area    = config[0];
	    this.model   = config[1];
	    this.inch    = config[2];
	    this.country = config[3];
	    this.lang    = config[4];
	}
	
	this.set_data();
	
	//console.log (config);
	//for (var i in this.data)
	//    console.log (this.data[i]);	    
    }
    
    this.set_data = function () {
	var main_list_no = -1;
	var scenario_list_no = 0;
	
	for (var i in epop_main_list) {
	    if (epop_main_list[i][0] == this.model) {	    
		if (epop_main_list[i][1] == this.inch) {
		    /* best match */
		    main_list_no = i;
		    break;
		}
		else if (epop_main_list[i][1] == "*") {
		    main_list_no = i;
		}
	    }
	}

	if (main_list_no == -1) {
	    main_list_no = 0;
	    epop_finish3 ();
	}
	
	for (var i in epop_series_list) {
	    if (epop_series_list[i][0] == epop_main_list[main_list_no][2])
	    {
		this.series_logo = epop_series_list[i][1];
		this.panel_logo = epop_series_list[i][2];
	    }   
	}
	
	for (var i in epop_scenario_list) {
	    if (epop_scenario_list[i][0] == epop_main_list[main_list_no][3])
		scenario_list_no = i;
	}
	
	for (var i in epop_scenario_list[scenario_list_no]) {
	    if (i == 0)
		continue; /* skip scneario name */
	    
	    var func_list_no = -1;
	    for (var j in epop_function_list) {
		if (epop_scenario_list[scenario_list_no][i] == epop_function_list[j][0]) {
		    if (this.area == "PAL") {
			func_list_no = j;
			break;
		    }
		    if (epop_function_list[j][2] == this.lang) {
			/* best match */
			func_list_no = j;
			break;
		    }
		    else if (epop_function_list[j][2] == "*") {
			func_list_no = j;			
		    }
		}
	    }
	    if (func_list_no != -1) {
		this.data.unshift (epop_function_list[func_list_no].slice(3));
	    }
	}    
	
	while (this.data.length < 7)
	    this.data.push (["","","T.B.D.","T.B.D."]); //push dummy data
	
	if (epop_ex_enable)
	    this.data.push (["func_logo_ex.png","epop_ex.png"," "," "]); //push epop_ex data
    }
    
    this.shift_data = function ()
	{
	    this.data.unshift(this.data.pop());
	}
}

var make_obj = function (config){

    if (epop_top) {
	floor_y = -floor_y;
	pictfloor_y = -pictfloor_y;
	pict_y = -pict_y;
	slide_y = -slide_y;
    }

    if (epop_left) {
        pict0_base_x = -pict0_base_x;
        pict_move_x = -pict_move_x;

	floor_x = -floor_x;
	image_x_out = -image_x_out;
	pict_next_x_out = -pict_next_x_out;

	pict_rotate_angle = -pict_rotate_angle;
	pict_rotate_y_space = -pict_rotate_y_space;

        slide_x = slide_x_left;
	pickup_pict_x = pickup_pict_x_left;
    }

    pict0 = 
    new container ({
	"translate": [image_x_out, pict_y, 0],
	    "components":[
			  new gimage ({
				  "translate": [0, 0, 0],
				  "width": pict_w,
				  "height": pict_h,
				  "src": epop_data_path + epop_data.data[0][0]}),
			  ]
	});

    pict1 = 
    new container ({
	"translate": [(image_x_out + pict_move_x), pict_y, 0],
	    "components":[
			  new gimage ({
				  "translate": [0, 0, 0],
				  "width": pict_w,
				  "height": pict_h,
				  "src": epop_data_path + epop_data.data[1][0]}),
			  ]
	});

    pict2 = 
    new container ({
	    "translate": [(image_x_out + (pict_move_x * 2)), pict_y, 0],
	    "components":[
			  new gimage ({
				  "translate": [0, 0, 0],
				  "width": pict_w,
				  "height": pict_h,
				  "src": epop_data_path + epop_data.data[2][0]}),
			  ]
	});

    pict3 = 
    new container ({
	    "translate": [(image_x_out + (pict_move_x * 3)), pict_y, 0],
	    "components":[
			  new gimage ({
				  "translate": [0, 0, 0],
				  "width": pict_w,
				  "height": pict_h,
				  "src": epop_data_path + epop_data.data[3][0]}),
			  ]
	});

    pict4 = 
    new container ({
	    "translate": [(image_x_out + (pict_move_x * 4)), pict_y, 0],
	    "components":[
			  new gimage ({
				  "translate": [0, 0, 0],
				  "width": pict_w,
				  "height": pict_h,
				  "src": epop_data_path + epop_data.data[4][0]}),
			  ]
	});

    pict5= 
    new container ({
	    "translate": [(image_x_out + (pict_move_x * 5)), pict_y, 0],
	    "components":[
			  new gimage ({
				  "translate": [0, 0, 0],
				  "width": pict_w,
				  "height": pict_h,
				  "src": epop_data_path + epop_data.data[5][0]}),
			  ]
	});

    pict6 = 
    new container ({
	    "translate": [(image_x_out + (pict_move_x * 6)), pict_y, 0],
	    "components":[
			  new gimage ({
				  "translate": [0, 0, 0],
				  "width": pict_w,
				  "height": pict_h,
				  "src": epop_data_path + epop_data.data[6][0]}),
			  ]
	});
    pict_group = 
    [
     pict0,
     pict1,
     pict2,
     pict3,
     pict4,
     pict5,
     pict6,
     ];

    pictfloor0 = 
	new container ({
		"translate": [image_x_out, pictfloor_y, 0],
		"components":[
			      new gimage ({
				  "width": pictfloor_w,
				  "height": pictfloor_h,
				  "src":  epop_data_path + pictfloor_png}),
			      ]
	    });
    pictfloor1 = 
	new container ({
		"translate": [(image_x_out + pict_move_x), pictfloor_y, 0],
		"components":[
			      new gimage ({
				  "width": pictfloor_w,
				  "height": pictfloor_h,
				  "src":  epop_data_path + pictfloor_png}),
			      ]
	    });
    pictfloor2 = 
	new container ({
		"translate": [(image_x_out + (pict_move_x * 2)), pictfloor_y, 0],
		"components":[
			      new gimage ({
				  "width": pictfloor_w,
				  "height": pictfloor_h,
				  "src":  epop_data_path + pictfloor_png}),
			      ]
	    });
    pictfloor3 = 
	new container ({
		"translate": [(image_x_out + (pict_move_x * 3)), pictfloor_y, 0],
		"components":[
			      new gimage ({
				  "width": pictfloor_w,
				  "height": pictfloor_h,
				  "src":  epop_data_path + pictfloor_png}),
			      ]
	    });
    pictfloor4 = 
	new container ({
	    "translate": [(image_x_out + (pict_move_x * 4)), pictfloor_y, 0],
		"components":[
			      new gimage ({
				  "width": pictfloor_w,
				  "height": pictfloor_h,
				  "src":  epop_data_path + pictfloor_png}),
			      ]
	    });
    pictfloor5 = 
	new container ({
		"translate": [(image_x_out + (pict_move_x * 5)), pictfloor_y, 0],
		"components":[
			      new gimage ({
				  "width": pictfloor_w,
				  "height": pictfloor_h,
				  "src":  epop_data_path + pictfloor_png}),
			      ]
	    });
    pictfloor6 = 
	new container ({
		"translate": [(image_x_out + (pict_move_x * 6)), pictfloor_y, 0],
		"components":[
			      new gimage ({
				  "width": pictfloor_w,
				  "height": pictfloor_h,
				  "src":  epop_data_path + pictfloor_png}),
			      ]
	    });
    pictfloor_group =
	[
	    pictfloor0,
	    pictfloor1,
	    pictfloor2,
	    pictfloor3,
	    pictfloor4,
	    pictfloor5,
	    pictfloor6,
	];

    pictfloor_black = 
	new container ({
	    "translate": [pickup_pict_x, floor_y, 0],
		"components":[
			      new gimage ({
				  "width": pictfloor_w,
				  "height": pictfloor_h,
				  "src":  epop_data_path + pict_base_black_png}),
			      ]
	    });

    floor = 
	new container ({
		"translate": [image_x_out, floor_y, 0],
		"components":[
			      new gimage ({
				  "translate": [0, 0, 0],
				  "width": floor_w,
				  "height": floor_h,
				  "src":  epop_data_path + floor_png}),
		              new gimage ({
				  "translate": [-81, -40, 0],
				  "width": 210, /* Set image width */
				  "height": (floor_h/2),
				  "src": epop_data_path + epop_data.series_logo}),
		              new gimage ({
				  "translate": [105, -40, 0],
				  "width": 163, /* Set image width */
				  "height": (floor_h/2),
				  "src": epop_data_path + epop_data.panel_logo}),
			      ]
	    });

    slide = 
    new container ({
	"translate": [pickup_pict_x, slide_y, 0],
	    "components":[
		new gimage ({
		    "translate": [0, 0, 0],
		    "width": 1, /* Defult minimum. */
		    "height": 170,
		    "visible_p": false,
		    "src": "",
		}),
		new gtextbox ({
		    "translate": [-145, 64, 0],
		    "text" : "",
		    "font_name" : epop_title_font_name,
		    "font_size" : 33,
		    "width" : 590,
		    "height" : 42,
		    "align" : epop_text_align,
		    "color" : [230,230,230,0], /* Defult alpha 0 */
		}),
		new gtextbox ({
		    "translate": [-145, -20, 0],
		    "text" : "",
		    "font_name" : epop_font_name,
		    "font_size" : 23,
		    "width" : 590,
		    "height" : 120,
		    "align" : epop_text_align,
		    "color" : [230,230,230,0], /* Defult alpha 0 */
		}),
	    ]
    });
    
}

var clear_obj = function () {
    var pict_comp_num;
    var pictfloor_comp_num;
    var pictfloor_black_comp_num;
    var floor_comp_num;
    var slide_comp_num;

    /* current set timer delete */
    delete_timer (slide);
    delete_timer (epop_key_timer);
    delete_timer (epop_timer);
    delete_timer (epop_key_timer);
    delete_timer (pict_group);
    delete_timer (epop_timeout_timer);

    /* current action anim finish */
    slide_anim.finish();
    pict_anim.finish();

    /* current param reset */
    epop_count = 0;
    epop_stop = 0;
    epop_ex_enable = 0;

    /* reset position */
    if (epop_top) {
	floor_y = -floor_y;
	pictfloor_y = -pictfloor_y;
	pict_y = -pict_y;
	slide_y = -slide_y;
    }
    if (epop_left) {
	pict0_base_x = -pict0_base_x;
	pict_move_x = -pict_move_x;

	floor_x = -floor_x;
	image_x_out = -image_x_out;
	pict_next_x_out = -pict_next_x_out;

	pict_rotate_angle = -pict_rotate_angle;
	pict_rotate_y_space = -pict_rotate_y_space;

	slide_x = 115;
	pickup_pict_x = -455;
    }

    /* current use obj clear */
    for(var i=0; i < 7; i++) 
    {
	pict_comp_num = pict_group[i].components.length;
	for (var j = 0; j < pict_comp_num; j++)
	{
	    pict_group[i].components[j] = 0;

	}
	pictfloor_comp_num = pictfloor_group[i].components.length;
	for (var j = 0; j < pict_comp_num; j++)
	{
	    pictfloor_group[i].components[j] = 0;
	}
    }

    pictfloor_black_comp_num = pictfloor_black.components.length;
    for (var j = 0; j < pictfloor_black_comp_num; j++)
    {
	pictfloor_black.components[j] = 0;	
    }

    floor_comp_num = floor.components.length;
    for (var j = 0; j < floor_comp_num; j++)
    {
	floor.components[j] = 0;	
    }

    slide_comp_num = slide.components.length;
    for (var j = 0; j < slide_comp_num; j++)
    {
	slide.components[j] = 0;	
    }

    force_redraw();
}

s.symbol = "home-screen";
s.key_hook = function (up_down, key) {
    if (key_enable == true)
    {
	if (key==TXK_RIGHT && epop_left==1) {
	    epop_count = 0;
	    append_timer (epop_key_timer, 500, slide_anim_undisplay);
	    update_epop_timeout_timer ();
	}
	else if (key==TXK_LEFT && epop_left==0) {
	    epop_count = 0;
	    append_timer (epop_key_timer, 500, slide_anim_undisplay);
	    update_epop_timeout_timer ();
	}
	else if (key==FXK_CH_UP) {
	    epop_count = 0;
	    append_timer (epop_key_timer, 500, slide_anim_undisplay);
	    update_epop_timeout_timer ();
	}
	else if (key==TXK_ENTER || key==FXK_CH_DOWN) {
	    epop_count = 0;
	    delete_timer (epop_key_timer);
	    
	    if (epop_stop) {
		epop_stop = 0;
		append_timer (epop_key_timer, 500, slide_anim_undisplay);
	    } else {
		epop_stop = 1;
	    }
	    update_epop_timeout_timer ();
	}
    }
};
s.in = [
  {
    "from": ["default"],
  }
];

function appear_obj (config)
{
    if (config[5]) {
	epop_ex_enable = 1;
	epop_count_max++;
    }

    if (config[11] || config[12]) {
	reduce_step = 1;
    }

    if (config[6] == 0) {
	/* buttom left */
	epop_left = 0;
	epop_top = 0;
    } else if (config[6] == 1) {
	/* buttom right */
	epop_left = 1;
	epop_top = 0;
    } else if (config[6] == 2) {
	/* top left */
	epop_left = 0;
	epop_top = 1;
    } else if (config[6] == 3) {
	/* top right */
	epop_left = 1;
	epop_top = 1;
    }

    if (config[12])
    {
	pictfloor_png = "pict_base_4k.png";
	pict_base_black_png = "pict_base_b_4k.png";
	floor_png = "logo_base_4k.png";
    }

    if (config[13] == 1)
    {
	epop_text_align = RIGHT;
    }

    epop_data.init(config);

    make_obj(config);

    s.components.push (floor);
    
    dotween (floor,
		{time:1.5,
		     x:floor_x,
		     y:floor_y,
		     transition:"easeInOutQuart"});
    append_timer (epop_timer, 1000, epop_anim_first);
    update_epop_timeout_timer ();
}

function epop_anim_first ()
{
    delete_timer (epop_timer);

    s.components.pop (); // floor pop
    
    all_image_push ();
    
    for(var i=0; i < 7; i++) 
	{
	    dotween (pictfloor_group[i],
		     {time:(1.5 + (0.1 * i)),
		      x:(pict0_base_x + (pict_move_x * i)),
		      transition:"easeInOutQuart"});
	    
	    dotween (pict_group[i],
		     {time:(1.5 + (0.1 * i)),
		      x:(pict0_base_x + (pict_move_x * i)),
		      transition:"easeInOutQuart"});
	}

    append_timer (pict_group, 4000, pict_anim_rotate);
    append_timer (slide, 5000, slide_anim_display);
}

function pict_anim_rotate ()
{
    delete_timer (pict_group);
    pict_anim.init ();

    for(var i=0; i < 7; i++) 
    {
	if (i != 6)
	{
	    dotween (pictfloor_group[i],
		     {time:1.0,
		      x:(pict0_base_x + (pict_rotate_y_space * i)),
		      transition:"easeInOutQuart"});
	    
	    dotween (pict_group[i],
		     {time:1.0,
		      x:(pict0_base_x + (pict_rotate_y_space * i)),
		      transition:"easeInOutQuart"});
	    
	    pict_anim.set_anim_rotate (pictfloor_group[i].components[0], [0, 0, 1, 0], [pict_rotate_angle, 0, 1, 0], 1, 20);
	    pict_anim.set_anim_rotate (pict_group[i].components[0], [0, 0, 1, 0], [pict_rotate_angle, 0, 1, 0], 1, 20);

	    /* Size adjustment */
	    pict_anim.set_anim_height (pictfloor_group[i].components[0], pictfloor_h, 136, 1, 20);
	    pict_anim.set_anim_height (pict_group[i].components[0], pict_h, 84, 1, 20);
	}
	else
	{
	    //No.7(1st pick up slide) slide does not need rotate.
	    dotween (pictfloor_group[i],
		     {time:1.0,
		      x:pickup_pict_x,
		      transition:"easeInOutQuart"});
	    
	    dotween (pict_group[i],
		     {time:1.0,
		      x:pickup_pict_x,
		      transition:"easeInOutQuart"});
	}
    }

    pict_anim.run();
}

function update_slide_data ()
{
    if (epop_data.data[6][1] == "epop_ex.png")
	slide.components[0].src = epop_ex_data_path + epop_data.data[6][1];
    else
	slide.components[0].src = epop_data_path + epop_data.data[6][1];

    setf_text (slide.components[1], gettext (epop_data.data[6][2]));
    setf_text (slide.components[2], gettext (epop_data.data[6][3]));

    force_redraw ();
}

function slide_anim_display ()
{
    delete_timer (slide);

    key_enable = true;

    s.components.push (pictfloor_black);
    s.components.push (pict_group[6]);

    update_slide_data ();

    slide_anim.init();
    slide.components[0].visible_p = true;
    slide_anim.set_anim_translate (slide, 
					[pickup_pict_x, slide_y, 0],
					[slide_x, slide_y, 0], 
					2, 10);
    slide_anim.set_anim_width (slide.components[0], 1, 918, 2, 10);
    slide_anim.run();

    append_timer (slide, 500, slide_anim_display2);
}

function slide_anim_display2 ()
{
    delete_timer (slide);

    slide_anim.finish();

    slide_anim.set_anim_color (slide.components[1],
				    [230, 230, 230, 0], 
				    [230, 230, 230, 255], 
				    2, 10);
    slide_anim.set_anim_color (slide.components[2],
				    [230, 230, 230, 0], 
				    [230, 230, 230, 255], 
				    2, 10);
    slide_anim.run();

    if (!epop_stop)
    {
	append_timer (epop_key_timer, 5000, slide_anim_undisplay);
    }
}

function slide_anim_undisplay ()
{
    key_enable = false;

    delete_timer (epop_key_timer);

    slide_anim.finish();
    slide_anim.set_anim_color (slide.components[1],
				    [230, 230, 230, 255], 
				    [230, 230, 230, 0], 
				    2, 1);
    slide_anim.set_anim_color (slide.components[2],
				    [230, 230, 230, 255], 
				    [230, 230, 230, 0], 
				    2, 1);
    slide_anim.set_anim_translate (slide, 
					[slide_x, slide_y, 0], 
					[pickup_pict_x, slide_y, 0],
					2, 10);
    slide_anim.set_anim_width (slide.components[0], 918, 1, 2, 10);
    slide_anim.run();

    /* Next ePOP or finish. */
    epop_count++;
    if ((epop_count > epop_count_max)
	&& (epop_count_max == 7))
    {
	append_timer (epop_timer, 350, pict_anim_next_ex);
    }
    else
    {
	append_timer (epop_timer, 350, pict_anim_next);
    }
}

function pict_anim_next ()
{
    delete_timer (epop_timer);
    pict_anim.finish ();

    slide.components[0].visible_p = false;
    s.components.pop (); // pict_group[6] pop
    s.components.pop (); // pictfloor_black pop

    for(var i=0; i < 7; i++) 
	{
	    if (i == 6) /* pickup pict go to out. */
		{
		    dotween (pictfloor_group[i],
			     {time:1.0,
			      x:image_x_out,
			      transition:"easeInOutQuart"});
		    
		    dotween (pict_group[i],
			     {time:1.0,
			      x:image_x_out,
			      transition:"easeInOutQuart"});
		}
	    else if (i == 5) /* next pict go to pickup pict position. */
		{
		    pict_anim.set_anim_rotate (pictfloor_group[i].components[0], [pict_rotate_angle, 0, 1, 0], [0, 0, 1, 0], 1, 20);
		    pict_anim.set_anim_rotate (pict_group[i].components[0], [pict_rotate_angle, 0, 1, 0], [0, 0, 1, 0], 1, 20);

		    dotween (pictfloor_group[i],
			     {time:1.0,
			      x:pickup_pict_x,
			      transition:"easeInOutQuart"});
		    
		    dotween (pict_group[i],
			     {time:1.0,
			      x:pickup_pict_x,
			      transition:"easeInOutQuart"});

		    /* Size adjustment */
		    pict_anim.set_anim_height (pictfloor_group[i].components[0], 136, pictfloor_h, 1, 20);
		    pict_anim.set_anim_height (pict_group[i].components[0], 84, pict_h, 1, 20);
		}
	    else
		{
		    /* Other pict move next position. */
		    dotween (pictfloor_group[i],
			     {time:1.0,
			      x:(pict0_base_x + (pict_rotate_y_space * (i + 1))),
			      transition:"easeInOutQuart"});
	    
		    dotween (pict_group[i],
			     {time:1.0,
			      x:(pict0_base_x + (pict_rotate_y_space * (i + 1))),
			      transition:"easeInOutQuart"});
		}
	}
    pict_anim.run();

    append_timer (epop_timer, 1000, pict_anim_next2);
}

function all_image_pop ()
{
    s.components.pop (); /* For floor */
    for(var i=0; i < 7; i++) 
    {
	s.components.pop (); /* For pictfloor */
	s.components.pop (); /* For pict */
    }
    s.components.pop (); /* For slide */
}

function all_image_push ()
{
    s.components.push (slide);
    for(var i=0; i < 7; i++) 
    {
	s.components.push (pictfloor_group[i]);
	s.components.push (pict_group[i]);
    }
    s.components.push (floor);
}

function pict_anim_next2 ()
{
    delete_timer (epop_timer);

    if (epop_ex_enable) {
	if (epop_data.data[7][0] == "func_logo_ex.png")
	    pict_group[6].components[0].src = epop_ex_data_path + epop_data.data[7][0];
        else
	    pict_group[6].components[0].src = epop_data_path + epop_data.data[7][0];
    }

    pict_anim.finish();
    pict_anim.set_anim_translate (pictfloor_group[6], [pict_next_x_out, pict_y, 0], [pict0_base_x, pict_y, 0], 1, 5);
    pict_anim.set_anim_translate (pict_group[6], [pict_next_x_out, pict_y, 0], [pict0_base_x, pict_y, 0], 1, 5);

    pict_anim.set_anim_rotate (pictfloor_group[6].components[0], [0, 0, 1, 0], [pict_rotate_angle, 0, 1, 0], 1, 1);
    pict_anim.set_anim_rotate (pict_group[6].components[0], [0, 0, 1, 0], [pict_rotate_angle, 0, 1, 0], 1, 1);

    /* Size adjustment */
    pict_anim.set_anim_height (pictfloor_group[6].components[0], pictfloor_h, 136, 1, 1);
    pict_anim.set_anim_height (pict_group[6].components[0], pict_h, 84, 1, 1);

    pict_anim.run();

    /* ePOP list shift.   */
    pict_group.unshift(pict_group.pop ());
    pictfloor_group.unshift(pictfloor_group.pop ());
    epop_data.shift_data();

    /* Re-draw for frame overlap. */
    all_image_pop ();
    all_image_push ();

    if ((epop_count > epop_count_max)
	&& (epop_count_max == 7))
    {
	append_timer (epop_timer, 500, pict_anim_rotate_return_ex);
    }
    else if ((epop_count > epop_count_max)
	     && (epop_count_max == 6))
    {
	append_timer (epop_timer, 500, pict_anim_rotate_return);
    }
    else
    {
	append_timer (slide, 500, slide_anim_display);
    }
}

function pict_anim_next_ex ()
{
    delete_timer (epop_timer);
    pict_anim.finish ();

    slide.components[0].visible_p = false;
    s.components.pop (); // pict_group[6] pop
    s.components.pop (); // pictfloor_black pop

    for(var i=0; i < 7; i++) 
	{
	    if (i == 6) /* pickup pict go to out. */
		{
		    dotween (pictfloor_group[i],
			     {time:1.0,
			      x:image_x_out,
			      transition:"easeInOutQuart"});
		    
		    dotween (pict_group[i],
			     {time:1.0,
			      x:image_x_out,
			      transition:"easeInOutQuart"});
		}
	    else
		{
		    /* Other pict move next position. */
		    dotween (pictfloor_group[i],
			     {time:1.0,
			      x:(pict0_base_x + (pict_rotate_y_space * (i + 1))),
			      transition:"easeInOutQuart"});
	    
		    dotween (pict_group[i],
			     {time:1.0,
			      x:(pict0_base_x + (pict_rotate_y_space * (i + 1))),
			      transition:"easeInOutQuart"});
		}
	}
    pict_anim.run();

    append_timer (epop_timer, 1000, pict_anim_next2);
}

function pict_anim_rotate_return ()
{
    delete_timer (epop_timer);
    pict_anim.finish ();

    for(var i=6; i >= 0; i--) 
    {
	if (i != 6)
	{
	    /* Size adjustment */
	    pict_anim.set_anim_height (pictfloor_group[i].components[0], 136, pictfloor_h, 1, 20);
	    pict_anim.set_anim_height (pict_group[i].components[0], 84, pict_h, 1, 20);
	    
	    pict_anim.set_anim_rotate (pictfloor_group[i].components[0], [pict_rotate_angle, 0, 1, 0], [0, 0, 1, 0], 1, 20);
	    pict_anim.set_anim_rotate (pict_group[i].components[0], [pict_rotate_angle, 0, 1, 0], [0, 0, 1, 0], 1, 20);
	    
	    dotween (pictfloor_group[i],
		     {time:1.0,
		      x:(pict0_base_x + (pict_move_x * i)),
		      transition:"easeInOutQuart"});
	    
	    dotween (pict_group[i],
		     {time:1.0,
		      x:(pict0_base_x + (pict_move_x * i)),
		      transition:"easeInOutQuart"});
	}
	else
	{
	    //No.7(1st pick up slide) slide does not need rotate.
	    dotween (pictfloor_group[i],
		     {time:1.0,
		      x:(pict0_base_x + (pict_move_x * i)),
		      transition:"easeInOutQuart"});
	    
	    dotween (pict_group[i],
		     {time:1.0,
		      x:(pict0_base_x + (pict_move_x * i)),
		      transition:"easeInOutQuart"});
	}
    }
    pict_anim.run();

    append_timer (epop_timer, 3000, epop_finish);
}

function pict_anim_rotate_return_ex ()
{
    delete_timer (epop_timer);
    pict_anim.finish ();

    for(var i=6; i >= 0; i--) 
    {
	/* Size adjustment */
	pict_anim.set_anim_height (pictfloor_group[i].components[0], 136, pictfloor_h, 1, 20);
	pict_anim.set_anim_height (pict_group[i].components[0], 84, pict_h, 1, 20);

	pict_anim.set_anim_rotate (pictfloor_group[i].components[0], [pict_rotate_angle, 0, 1, 0], [0, 0, 1, 0], 1, 20);
	pict_anim.set_anim_rotate (pict_group[i].components[0], [pict_rotate_angle, 0, 1, 0], [0, 0, 1, 0], 1, 20);

	dotween (pictfloor_group[i],
		 {time:1.0,
		  x:(pict0_base_x + (pict_move_x * i)),
		  transition:"easeInOutQuart"});
	
	dotween (pict_group[i],
		 {time:1.0,
		  x:(pict0_base_x + (pict_move_x * i)),
		  transition:"easeInOutQuart"});
    }
    pict_anim.run();

    append_timer (epop_timer, 3000, epop_finish);
}

function epop_finish ()
{
    delete_timer (epop_timer);

    for(var i=0; i < 7; i++) 
	{
	    dotween (pictfloor_group[i],
		     {time:(1.5 + (0.1 * i)),
		      x:(image_x_out + (pict_move_x * i)),
		      transition:"easeInOutQuart"});

	    dotween (pict_group[i],
		     {time:(1.5 + (0.1 * i)),
		      x:(image_x_out + (pict_move_x * i)),
		      transition:"easeInOutQuart"});
	}

    append_timer (epop_timer, 1000, epop_finish2);
}

function epop_finish2 ()
{
    delete_timer (epop_timer);
    
    dotween (floor,
	     {time:1.5,
		     x:image_x_out,
		     y:floor_y,
		     transition:"easeInOutQuart"});
    
    append_timer (epop_timer, 1500, epop_finish3); 
}

function epop_finish3 ()
{
    write_back_bytes2 (0, [0]);
}

function update_epop_timeout_timer ()
{
    delete_timer (epop_timeout_timer);
    append_timer (epop_timeout_timer, 70000, epop_finish3);
}
