
var create=function(param){
var cont=new container({});
if(param.singleline||param.passwd_mode)
cont.textarea=new TextArea();
else
cont.textarea=new TextAreaMulti();
cont.textarea.create(param);
cont.components.push(cont.textarea);
cont.free=function(){
this.textarea.free();};
cont.enter_focus=function(){
this.textarea.enter_focus();};
cont.leave_focus=function(){
this.textarea.leave_focus();};
cont.set_translate=function(tran){
if(typeof tran=="object"&&tran.length==3)
this.translate=tran.slice();};
cont.get_text=function(){
return this.textarea.get_text();};
cont.set_text=function(text,valign){
this.textarea.set_text(text,valign);};
cont.set_text_color=function(color){
this.textarea.set_text_color(color);};
cont.set_reverse_text_color=function(color){
this.textarea.set_reverse_text_color(color);};
cont.get_visible=function(){
return this.visible_p;};
cont.set_visible=function(visible){
if(this.visible_p!=visible)
this.visible_p=visible;};
cont.set_align=function(align){
switch(align){
case LEFT:
case CENTER:
case RIGHT:
this.textarea.set_align(align);}
};
cont.do_confirm_composition=function(text){
this.textarea.do_confirm_composition(text);};
cont.do_set_composition=function(convert_info){
this.textarea.do_set_composition(convert_info);};
cont.do_cancel_composition=function(){
this.textarea.do_cancel_composition();};
cont.do_move_caret=function(key){
this.textarea.do_move_caret(key);};
cont.do_enter_backspace=function(){
this.textarea.do_enter_backspace();};
cont.do_enter_linefeed=function(){
this.textarea.do_enter_linefeed();};
cont.do_enter_allclear=function(){
this.textarea.do_enter_allclear();};
cont.do_set_from_left_mode=function(){
this.textarea.do_set_from_left_mode();};
cont.do_set_from_right_mode=function(){
this.textarea.do_set_from_right_mode();};
cont.enable_cursor=function(){
this.textarea.enable_cursor();};
cont.disable_cursor=function(){
this.textarea.disable_cursor();};
cont.set_unconf_bg_param=function(param){
this.textarea.set_unconf_bg_param(param);};
cont.show_unconf_bg=function(){
this.textarea.show_unconf_bg();};
cont.hide_unconf_bg=function(){
this.textarea.hide_unconf_bg();};
cont.set_toggle_force_caret_tail_cb=function(func){
this.textarea.set_toggle_force_caret_tail_cb(func);};
cont.do_scroll_up=function(){
if(typeof this.textarea.do_scroll_up!="function")
return null;
return this.textarea.do_scroll_up();};
cont.do_scroll_down=function(){
if(typeof this.textarea.do_scroll_down!="function")
return null;
return this.textarea.do_scroll_down();};
cont.is_singleline=function(){
return this.textarea.is_singleline();};
cont.key_hook=function(up_down,key){
this.textarea.key_hook(up_down,key);};
return cont;};
var TextArea=function(){
this.width=100;
this.height=100;
this.unconf_margin=10;
this.singleline=false;
this.components=[];};
TextArea.prototype=new container({});
TextArea.prototype.create=function(param){
if(typeof param.width=="number")
this.width=param.width;
if(typeof param.height=="number")
this.height=param.height;
this.singleline=param.singleline||false;
this.force_align=param.align||LEFT;
this.unconf_pos=param.unconf_pos||"under";
if(typeof param.unconf_margin=="number")
this.unconf_margin=param.unconf_margin;
this.color_reverse=param.color_reverse?true:false;
this.textbox=new TextBox(param);
this.unconf_bg=new UnconfBG(param);
this.unconf_textbox=new TextBox(param);
this.components=[this.textbox,this.unconf_bg,this.unconf_textbox];
if(param.font_size)this.set_font_size(param.font_size);
if(param.font_name)this.set_font_name(param.font_name);
this.set_textarea_color(this.color_reverse);
if(param.omitter)this.set_omitter(param.omitter);
if(param.passwd_mode)this.set_passwd_mode(param.passwd_mode);
if(param.align)this.set_align(param.align);
if(param.unconf_bg_width==undefined)
param.unconf_bg_width=this.width+this.unconf_bg.PADDING;
if(param.unconf_bg_height==undefined)
param.unconf_bg_height=this.unconf_textbox.get_height()+this.unconf_bg.PADDING;
if(param.unconf_bg_color==undefined)
param.unconf_bg_color=this.textbox.get_bg_color();
this.unconf_bg.create(param);
this.set_unconf_position();};
TextArea.prototype.free=function(){};
TextArea.prototype.enter_focus=function(){};
TextArea.prototype.leave_focus=function(){};
TextArea.prototype.get_text=function(){
return this.textbox.get_text();};
TextArea.prototype.set_text=function(text,valign){
this.textbox.set_text(text);};
TextArea.prototype.set_text_color=function(color){
this.textbox.set_text_color(color);
this.unconf_textbox.set_text_color(color);
this.set_textarea_color(this.color_reverse);};
TextArea.prototype.set_reverse_text_color=function(color){
this.textbox.set_reverse_text_color(color);
this.unconf_textbox.set_reverse_text_color(color);
this.set_textarea_color(this.color_reverse);};
TextArea.prototype.set_font_size=function(font_size){
this.textbox.set_font_size(font_size);
this.unconf_textbox.set_font_size(font_size);};
TextArea.prototype.set_font_name=function(font_name){
this.textbox.set_font_name(font_name);
this.unconf_textbox.set_font_name(font_name);};
TextArea.prototype.set_textarea_color=function(reverse){
this.textbox.set_textarea_color(reverse);
this.unconf_textbox.set_textarea_color(reverse);};
TextArea.prototype.set_omitter=function(omitter){
this.textbox.set_omitter(omitter);};
TextArea.prototype.unset_omitter=function(){
this.textbox.unset_omitter();};
TextArea.prototype.set_align=function(align){
this.force_align=align;
this.textbox.set_align(align);};
TextArea.prototype.unset_align=function(align){
this.textbox.set_align(this.force_align);};
TextArea.prototype.set_unconf_position=function(){
var ypos=this.textbox.get_height()/2
+this.unconf_textbox.get_height()/2
+this.unconf_margin;
switch(this.unconf_pos){
case "under":
ypos=-ypos;
break;
case "over":
break;
default:
ypos=-ypos;
break;}
this.unconf_textbox.set_trans_y(ypos);
this.unconf_bg.set_trans_y(ypos);};
TextArea.prototype.do_confirm_composition=function(text){
this.textbox.enable_cursor();
this.unconf_textbox.disable_reverse();
this.unconf_textbox.disable_under_bar();
this.unconf_textbox.disable_cursor();
this.unconf_textbox.free();
if(!this.unconf_bg.force_visible)
this.unconf_bg.set_visible(false);
this.textbox.add_text(text);};
TextArea.prototype.do_set_composition=function(convert_info){
this.unconf_textbox.enable_reverse();
this.unconf_textbox.enable_under_bar();
this.unconf_textbox.disable_cursor();
this.unconf_bg.set_visible(true);
this.unconf_textbox.add_unconfirmed_text(convert_info);
if(this.textbox.input_array.length>0){
}else {
this.unconf_textbox.text_box.translate[0]=0;}
};
TextArea.prototype.do_cancel_composition=function(){
this.unconf_textbox.disable_reverse();
this.unconf_textbox.disable_under_bar();
this.unconf_textbox.free();
if(!this.unconf_bg.force_visible)
this.unconf_bg.set_visible(false);};
TextArea.prototype.do_move_caret=function(key){
if(!this.textbox.is_caret_movable())
return;
switch(key){
case TXK_UP:
break;
case TXK_DOWN:
break;
case TXK_LEFT:
this.textbox.cursor_left();
break;
case TXK_RIGHT:
this.textbox.cursor_right();
break;};};
TextArea.prototype.do_enter_backspace=function(){
this.textbox.do_backspace();};
TextArea.prototype.do_enter_linefeed=function(){
this.textbox.add_linefeed();};
TextArea.prototype.do_enter_allclear=function(){
this.textbox.allclear();};
TextArea.prototype.do_set_from_left_mode=function(){
this.textbox.set_from_left_mode();};
TextArea.prototype.do_set_from_right_mode=function(){
this.textbox.set_from_right_mode();};
TextArea.prototype.enable_cursor=function(){
this.textbox.enable_cursor();
if(this.textbox.input_array.length>0){
setf_text(this.textbox.text_box,this.textbox.latter_half.join(""));}
this.textbox.set_edit_start_align();};
TextArea.prototype.disable_cursor=function(){
this.textbox.disable_cursor();
this.unconf_textbox.disable_cursor();
if(this.textbox.input_array.length>0){
setf_text(this.textbox.text_box,this.textbox.input_array.join(""));}
this.unset_align();};
TextArea.prototype.set_unconf_bg_param=function(param){
this.unconf_bg.set_param(param);};
TextArea.prototype.show_unconf_bg=function(){
this.unconf_bg.show();};
TextArea.prototype.hide_unconf_bg=function(){
this.unconf_bg.hide();};
TextArea.prototype.set_toggle_force_caret_tail_cb=function(func){
this.textbox.set_toggle_force_caret_tail_cb(func);};
TextArea.prototype.is_singleline=function(){
return this.singleline;};
TextArea.prototype.set_passwd_mode=function(passwd_mode){
if(passwd_mode){
this.textbox.enable_password_mode();}else {
this.textbox.disable_password_mode();}
};
TextArea.prototype.key_hook=function(up_down,key){
if(up_down!=KEY_PRESS)
return true;
if(this.cursor&&this.cursor.key_hook&&this.cursor.key_hook(up_down,key)){
force_redraw();
return true;}
return false;};
TextArea.prototype.move_unconf_textbox=function(){
var unconf_h_w=this.unconf_textbox.text_box_bg.width/2;
if(this.textbox.insert_mode){
var cursor_s=this.textbox.cursor_obj.translate[0]-this.textbox.cursor_obj.width/2;
var insert_on_x=cursor_s+unconf_h_w;
this.unconf_textbox.text_box.translate[0]=this.width/2+cursor_s;
this.unconf_textbox.text_box_bg.translate[0]=insert_on_x;
this.unconf_textbox.under_bar.translate[0]=insert_on_x;
if(this.unconf_textbox.text_box_bg.width==this.unconf_textbox.reverse_text_box_bg.width){
this.unconf_textbox.reverse_text_box.translate[0]=insert_on_x;
this.unconf_textbox.reverse_text_box_bg.translate[0]=insert_on_x;}else {
this.unconf_textbox.reverse_text_box.translate[0]=insert_on_x
-this.unconf_textbox.text_box_bg.width/2
+this.unconf_textbox.reverse_text_box_bg.width/2;
this.unconf_textbox.reverse_text_box_bg.translate[0]=insert_on_x
-this.unconf_textbox.text_box_bg.width/2
+this.unconf_textbox.reverse_text_box_bg.width/2;}
}else {
var c_char=this.textbox.input_array[this.textbox.cursor_pos-1];
var c_char_width=this.textbox._get_char_width(c_char);
var cursor_e=this.textbox.cursor_obj.translate[0]+this.textbox.cursor_obj.width/2;
var insert_off_x=this.textbox.cursor_obj.translate[0]+c_char_width/2+unconf_h_w;
this.unconf_textbox.text_box.translate[0]=this.width/2+cursor_e;
this.unconf_textbox.text_box_bg.translate[0]=insert_off_x;
this.unconf_textbox.under_bar.translate[0]=insert_off_x;
if(this.unconf_textbox.text_box_bg.width==this.unconf_textbox.reverse_text_box_bg.width){
this.unconf_textbox.reverse_text_box.translate[0]=insert_off_x;
this.unconf_textbox.reverse_text_box_bg.translate[0]=insert_off_x;}else {
this.unconf_textbox.reverse_text_box.translate[0]=insert_off_x
-this.unconf_textbox.text_box_bg.width/2
+this.unconf_textbox.reverse_text_box_bg.width/2;
this.unconf_textbox.reverse_text_box_bg.translate[0]=insert_off_x
-this.unconf_textbox.text_box_bg.width/2
+this.unconf_textbox.reverse_text_box_bg.width/2;}
}
var unconf_end_pos=this.unconf_textbox.text_box_bg.translate[0]+this.unconf_textbox.text_box_bg.width/2;
if(unconf_end_pos>this.width/2){
var over_char_w=unconf_end_pos-this.width/2;
this.unconf_textbox.text_box.translate[0]-=over_char_w;
this.unconf_textbox.text_box_bg.translate[0]-=over_char_w;
this.unconf_textbox.reverse_text_box.translate[0]-=over_char_w;
this.unconf_textbox.reverse_text_box_bg.translate[0]-=over_char_w;
this.unconf_textbox.under_bar.translate[0]-=over_char_w;}
};
function TextBox(param){
var font_size=param.font_size||32;
this.height=font_size+6;
this.translate=[0,0,0];
this.text_color=param.text_color||[0,0,0,255];
this.reverse_text_color=param.reverse_text_color||[255,255,255,255];
this.toggle_force_caret_tail_cb=null;
this.width_limit=param.width;
if(typeof param.char_length_limit=="undefined"||param.char_length_limit<0){
this.char_length_limit=100;}else {
this.char_length_limit=param.char_length_limit;}

this.text_box_bg=new gbox({
height:this.height,
});
this.text_box=new gtext({
width:param.width,text:param.text,align:LEFT,
font_size:32
});

this.reverse_text_box_bg=new gbox({
height:this.height,
});
this.reverse_text_box=new gtext({
width:this.height,text:"",
visible_p:false,font_size:32
});
this.cursor_obj=new gbox({
width:10,height:this.height,visible_p:false
});

this.cursor_text=new gtext({
width:this.height,text:"",color:[255,255,255,255],
visible_p:false,font_size:32
});
this.under_bar=new gbox({
translate:[0,-this.height/2,0],width:100,height:2,
visible_p:false
});

this.end_cursor_obj=new gbox({
width:8,height:this.height,visible_p:false
});
this.components=[
this.text_box_bg,
this.text_box,
this.reverse_text_box_bg,
this.reverse_text_box,
this.under_bar,
this.cursor_obj,
this.cursor_text,
this.end_cursor_obj,
];

this.init();
this.cursor_on=false;
this.under_bar_on=false;
this.reverse_on=true;
this.empty_hook=null;
this.change_text_hook=null;
this.password_mode=false;
this.conversion_mode=false;

this.rightToLeftToggle=false;};

TextBox.prototype=new container({});
TextBox.prototype.init=function (){
this.input_array=[];
this.password_array=[];
this.cursor_pos=0;
this.cursor_pos_bias=0;
this.no_appear_text_width=0;
this.no_appear_text=[];
this.no_appear_latter_text=[];
this.latter_half=[];
this.latter_pos=0;
this.firsthalf_pos=0;
this.appear_width=0;
this.text_box_gb_width=0;
this.cursor_left_pos=0;
this.insert_mode=false;
this.pending_p=false;
this.under_bar.width=0;
this.bias_width=0;
this.force_caret_tail=false;};
TextBox.prototype.set_from_right_mode=function (){
this.rightToLeftToggle=true;
this._update_force_caret_tail();
this._update_view();};
TextBox.prototype.set_from_left_mode=function (){
this.rightToLeftToggle=false;
this._update_force_caret_tail();
this._update_view();};
TextBox.prototype.get_height=function (){
return this.height;};
TextBox.prototype.get_bg_color=function (){
return this.text_box_bg.color.slice();};
TextBox.prototype._get_char_width=function (character){
return get_text_width(this.cursor_text,character);};
TextBox.prototype.set_trans_y=function (y){
if(typeof y!="number")
return;
var tran=this.translate.slice();
tran[1]=y;
this.translate=tran;};
TextBox.prototype.get_text=function (){
var ret=null;
if(this.password_mode){
ret=this.password_array.join("");}else {
ret=this.input_array.join("");}
return ret;};
TextBox.prototype.get_text_array=function (){
var ret=null;
if(this.password_mode){
ret=this.password_array.slice(0);}else {
ret=this.input_array.slice(0);}
return ret;}
TextBox.prototype.get_text_array_left=function (){
var ret=null;
var current_pos=this.cursor_pos;
if(this.insert_mode){
current_pos--;}
if(this.password_mode){
ret=this.password_array.slice(0,current_pos);}else {
ret=this.input_array.slice(0,current_pos);}
return ret;}
TextBox.prototype.get_text_array_right=function (){
var ret=null;
var current_pos=this.cursor_pos;
if(this.insert_mode){
current_pos--;}
if(this.password_mode){
ret=this.password_array.slice(current_pos);}else {
ret=this.input_array.slice(current_pos);}
return ret;}

TextBox.prototype.get_cursor_position=function (){
if(this.is_end_cursor_mode()){
return this.cursor_left_pos+this.cursor_obj.width;}else {
return this.cursor_left_pos;}
}

TextBox.prototype.get_cursor_width=function (){
return this.cursor_obj.width;}

TextBox.prototype.get_text_width=function (){
return this.under_bar.width;}
TextBox.prototype.set_text_color=function (color){
this.text_color=color;}
TextBox.prototype.set_reverse_text_color=function (color){
this.reverse_text_color=color;}
TextBox.prototype.set_text=function (text,cursor_pos,composition_mode){
var text_len=text.length;
if(typeof composition_mode=="undefined"){
if(this.char_length_limit!=null&&this.char_length_limit>0){
if(text.length>this.char_length_limit){
console.log("[ERROR] Over char length limit!");
text_len=this.char_length_limit;}
}
}
this.init();
for(var i=0;i<text_len;i++){
if(this.password_mode){
this.password_array.push(text[i]);}else {
this.input_array.push(text[i]);}
}
if(this.password_mode){
var len=this.password_array.length;
this.input_array=this._fill_asterisk(len);}
if(cursor_pos>0&&cursor_pos<=this.input_array.length){
this.cursor_pos=cursor_pos;}else {
this.cursor_pos=this.input_array.length;}
this._update_force_caret_tail();
this._update_view();};
TextBox.prototype._change_under_bar_view=function (){
if(this.input_array.length>0){
this.under_bar.width=this.appear_width;
this.under_bar.translate[0]=this.appear_width/2-this.text_box.width/2;
if(this.under_bar_on){
this.under_bar.visible_p=true;}
}else {
this.under_bar.visible_p=false;}
};
TextBox.prototype._change_reverse_view=function (){
if(this.input_array.length>0){
this.reverse_text_box_bg.width=this.appear_width;
this.reverse_text_box.width=this.appear_width;
this.text_box_bg.width=this.text_box_gb_width;
this.reverse_text_box_bg.translate[0]=this.appear_width/2-this.text_box.width/2;
this.reverse_text_box.translate[0]=this.appear_width/2-this.text_box.width/2;
this.text_box_bg.translate[0]=this.text_box_gb_width/2-this.text_box.width/2;
if(this.reverse_on){
this.text_box_bg.visible_p=true;
this.reverse_text_box_bg.visible_p=true;
this.reverse_text_box.visible_p=true;}
}else {
this.text_box_bg.visible_p=false;
this.reverse_text_box_bg.visible_p=false;
this.reverse_text_box.visible_p=false;}
};
TextBox.prototype._change_cursor_pos=function (){
if(this.input_array.length>0){
var c_array=this.input_array.slice(0,this.cursor_pos);
var c_array_width=this._get_char_width(c_array.join(""));
var c_char=this.input_array[this.cursor_pos-1];
var c_char_width=this._get_char_width(c_char);

this.cursor_left_pos=c_array_width-this.no_appear_text_width-c_char_width;
var cursor_x_pos=0;
if(!this.rightToLeftToggle){
cursor_x_pos=c_array_width-c_char_width/2
-this.text_box.width/2-this.no_appear_text_width;}else {
cursor_x_pos=-c_array_width+c_char_width/2
+this.text_box.width/2+this.no_appear_text_width;}
this.cursor_obj.translate[0]=cursor_x_pos;
this.cursor_obj.width=c_char_width;
this.cursor_text.translate[0]=cursor_x_pos;
this.cursor_text.width=c_char_width;
setf_text(this.cursor_text,c_char);
if(!this.rightToLeftToggle){
this.end_cursor_obj.translate[0]=-this.text_box.width/2+this.appear_width
+this.end_cursor_obj.width/2;}else {
this.end_cursor_obj.translate[0]=this.text_box.width/2-this.appear_width
-this.end_cursor_obj.width/2;}
}else {
this.cursor_obj.translate[0]=0;
this.cursor_text.translate[0]=0;
this.cursor_obj.width=0;
this.cursor_text.width=0;
setf_text(this.cursor_text,"");
if(!this.rightToLeftToggle){
this.end_cursor_obj.translate[0]=-this.text_box.width/2+this.appear_width
+this.end_cursor_obj.width/2;}else {
this.end_cursor_obj.translate[0]=this.text_box.width/2-this.appear_width
-this.end_cursor_obj.width/2;}
}
this._change_cursor_visible();}
TextBox.prototype.enable_password_mode=function (){
if(this.password_mode==true){
return;}
this.password_mode=true;
this.password_array=this.input_array.slice(0);
var len=this.password_array.length;
this.input_array=this._fill_asterisk(len);
this._update_view();}
TextBox.prototype.disable_password_mode=function (){
if(this.password_mode==false){
return;}
this.password_mode=false;
this.input_array=this.password_array.slice(0);
this.password_array=[];
this._update_view();}
TextBox.prototype.get_password_mode=function (){
return this.password_mode;};
TextBox.prototype.get_cursor_visible=function (){
return this.cursor_on;}
TextBox.prototype.get_end_cursor_visible=function (){
return this.end_cursor_obj.visible_p;}
TextBox.prototype.is_end_cursor_mode=function (){
return !this.insert_mode;}
TextBox.prototype._appear_end_cursor=function (){
this.end_cursor_obj.visible_p=true;};
TextBox.prototype._disappear_end_cursor=function (){
this.end_cursor_obj.visible_p=false;};
TextBox.prototype._appear_cursor=function (){
this.cursor_obj.visible_p=true;
this.cursor_text.visible_p=true;};
TextBox.prototype._disappear_cursor=function (){
this.cursor_obj.visible_p=false;
this.cursor_text.visible_p=false;};
TextBox.prototype.enable_cursor=function (){
this.cursor_on=true;
this._change_cursor_visible();};
TextBox.prototype.disable_cursor=function (){
this.cursor_on=false;
this._change_cursor_visible();};
TextBox.prototype.enable_under_bar=function (){
this.under_bar_on=true;
this.under_bar.visible_p=true;};
TextBox.prototype.disable_under_bar=function (){
this.under_bar_on=false;
this.under_bar.visible_p=false;};
TextBox.prototype.enable_reverse=function (){
this.reverse_on=true;
this.reverse_text_box_bg.visible_p=true;
this.reverse_text_box.visible_p=true;
this.text_box_bg.visible_p=true;};
TextBox.prototype.disable_reverse=function (){
this.reverse_on=false;
this.reverse_text_box_bg.visible_p=false;
this.reverse_text_box.visible_p=false;
this.text_box_bg.visible_p=false;};
TextBox.prototype.is_end=function (){
if(this.cursor_pos==this.input_array.length){
return true;}else {
return false;}
};

TextBox.prototype.is_empty=function (){
console_log("[END][TextBox.is_empty]length:"+this.input_array.length);
if(this.input_array.length==0){
return true;}else {
return false;}
};

TextBox.prototype.is_first=function (){
if(this.cursor_pos==1){
return true;}else {
return false;}
};
TextBox.prototype._adjust_text_as_firsthalf=function (){
var tmp_text="";
var tmp_array=[];
var bw=0;

this.appear_width=this._get_char_width(this.input_array.join(""));
this.no_appear_text=[];
this.no_appear_latter_text=[];
this.latter_half=[];
this.no_appear_text_width=0;
this.latter_half=this.input_array.slice(0);

for(var i=0;i<(this.firsthalf_pos-1);i++){
tmp_text=this.latter_half.shift();
this.no_appear_text.push(tmp_text);}
while(bw<this.bias_width){
tmp_text=this.latter_half.shift();
if(typeof tmp_text=="undefined"){
break;}
tmp_array.push(tmp_text);
this.no_appear_text.push(tmp_text);
this.firsthalf_pos++;
bw=this._get_char_width(tmp_array.join(""));}

this.appear_width=this._get_char_width(this.latter_half.join(""));
while(this.appear_width>this.width_limit){
tmp_text=this.latter_half.pop();
this.no_appear_latter_text.unshift(tmp_text);
this.appear_width=this._get_char_width(this.latter_half.join(""));}
}
TextBox.prototype._adjust_text_init=function (){
this.appear_width=this._get_char_width(this.input_array.join(""));
this.no_appear_text=[];
this.no_appear_latter_text=[];
this.latter_half=[];
this.no_appear_text_width=0;
this.latter_half=this.input_array.slice(0);}
TextBox.prototype._adjust_text_as_latterhalf=function (){
var tmp_text="";
var tmp_array=[];
var bw=0;
while(this.latter_half.length>this.latter_pos){
tmp_text=this.latter_half.pop();
this.no_appear_latter_text.unshift(tmp_text);}

this.appear_width=this._get_char_width(this.latter_half.join(""));
while(this.appear_width>this.width_limit){
tmp_text=this.latter_half.shift();
this.no_appear_text.push(tmp_text);
this.appear_width=this._get_char_width(this.latter_half.join(""));}
}
TextBox.prototype.is_caret_movable=function (){
return !this.force_caret_tail;};
TextBox.prototype._update_text_box=function (){
this._adjust_text_init();
if(!this.rightToLeftToggle){
this.text_box.align=LEFT;}else {
this.text_box.align=RIGHT;}
if(this.appear_width>=this.width_limit
||this.bias_width>0){
if((this.firsthalf_pos>0)||(this.conversion_mode)){
this._adjust_text_as_firsthalf();}else {this._adjust_text_as_latterhalf();
if(this.bias_width>0){
var l_len=this.latter_half.length;
this.firsthalf_pos=this.latter_pos-(l_len-1);
this.latter_pos=0;
this._adjust_text_init();
this._adjust_text_as_firsthalf();}
}
setf_text(this.text_box,this.latter_half.join(""));
setf_text(this.reverse_text_box,this.latter_half.join(""));
this.no_appear_text_width=this._get_char_width(this.no_appear_text.join(""));}else {
setf_text(this.text_box,this.input_array.join(""));}

this.bias_width=0;};

TextBox.prototype.set_bias_width=function (width){
this.bias_width=width;
this._update_view();};
TextBox.prototype._update_view=function (){
if(this.bias_width==0){
if(this.cursor_pos<=this.no_appear_text.length){
this.firsthalf_pos=this.cursor_pos;
this.latter_pos=0;}else if(this.cursor_pos
>=(this.input_array.length-this.no_appear_latter_text.length)){
this.firsthalf_pos=0;
this.latter_pos=this.cursor_pos;}
}

if(this.password_mode){
var len=this.password_array.length;
this.input_array=this._fill_asterisk(len);}
this._update_text_box();
this._change_cursor_pos();
this._change_under_bar_view();
force_redraw();};
TextBox.prototype._update_force_caret_tail=function (){
var array=null;
if(this.password_mode)
array=this.password_array;
else
array=this.input_array;
if(array.length==0){
if(this.rightToLeftToggle){
this.call_toggle_force_caret_tail_cb(false);
return;}
}
for(var i=0;i<array.length;i++){
var text=array[i];
if(!this._toggle_force_caret_tail(text)){this.call_toggle_force_caret_tail_cb(false);
return;}
}
this.call_toggle_force_caret_tail_cb(true);
this.force_caret_tail=false;};
TextBox.prototype._insert_to_next_of_cursor_pos=function (array_in,text){
var array=array_in;
var latter_half=array.slice(0);
var len=array.length;
array.splice(this.cursor_pos,len-this.cursor_pos);
latter_half.splice(0,this.cursor_pos);
latter_half.unshift(text);
array=array.concat(latter_half);
return array;};
TextBox.prototype._insert_to_cursor_pos=function (array_in,text){
var array=array_in;
var latter_half=array.slice(0);
var len=array.length;
array.splice(this.cursor_pos-1,len-this.cursor_pos+1);
latter_half.splice(0,this.cursor_pos-1);
latter_half.unshift(text);
array=array.concat(latter_half);
return array;};
TextBox.prototype.fix_char=function (len){
var ret=false;
this.pending_p=false;
this._update_view();
return ret;};
TextBox.prototype._fill_asterisk=function (len){
var tmp=[];
for(var i=0;i<len;i++){
tmp.push("*");}
return tmp;};
TextBox.prototype.add_text=function (text){
if(text==""||text==null||typeof text!="string"){
console.log("[ERROR] Add invalid object to TextBox!");}
if(this.char_length_limit!=null&&this.char_length_limit>0){
if(this.input_array.length>=this.char_length_limit){
console.log("[ERROR] Over char length limit!");
this.pending_p=false;
return;}
}
var res=this._toggle_force_caret_tail(text);
if(!res)
this.call_toggle_force_caret_tail_cb(res);
this.pending_p=true;
if(this.input_array.length==this.cursor_pos
&&this.insert_mode==false){
this.cursor_pos++;
if(this.password_mode){
this.password_array.push(text);}else {
this.input_array.push(text);}
}else {
if(this.password_mode){
this.password_array
=this._insert_to_cursor_pos(this.password_array,text);}else {
this.input_array
=this._insert_to_cursor_pos(this.input_array,text);}
this.cursor_pos++;}
if(this.change_text_hook!=null&&typeof this.change_text_hook=="function"){
this.change_text_hook();}

this._update_view();};

TextBox.prototype.add_unconfirmed_text=function (convert_info){
if(convert_info[0]==""||convert_info[0]==null||typeof convert_info[0]!="string"){
}
var cursor_pos=0;
var composition_mode=true;
if(convert_info[1].h!=convert_info[1].t){
cursor_pos=convert_info[0].length;}else {
cursor_pos=convert_info[1].h;}
if(convert_info[2]!=1){
this.conversion_mode=true;}else {
this.conversion_mode=false;
if(cursor_pos!=convert_info[0].length){
var input_width=get_text_width(this.text_box,convert_info[0]);
if(input_width>this.width_limit){
var tmp_text="";
var tmp_array=[];
for(var i=0;i<convert_info[0].length;i++){
tmp_array.push(convert_info[0][i]);}
var cursor_pos_array=tmp_array.slice(0,cursor_pos);
var cursor_pos_width=this._get_char_width(cursor_pos_array.join(""));
var c_width=0;
if(cursor_pos_width>this.width_limit){
c_width=cursor_pos_width;}else {
c_width=this.width_limit;}
while(input_width>c_width){
tmp_text=tmp_array.pop();
input_width=this._get_char_width(tmp_array.join(""));}
convert_info[0]=tmp_array.join("");}
}
}
this.set_text(convert_info[0],cursor_pos,composition_mode);
if(this.no_appear_text_width==0){
var c_array=this.input_array.slice(0,cursor_pos);
var c_array_width=this._get_char_width(c_array.join(""));
this.appear_width=c_array_width;
this.text_box_gb_width=get_text_width(this.text_box,convert_info[0]);
this._change_reverse_view();
setf_text(this.reverse_text_box,c_array.join(""));}
if((this.conversion_mode)&&(this.no_appear_latter_text.length!=0)){
var c_array=this.input_array.slice(0,cursor_pos);
var c_array_width=this._get_char_width(c_array.join(""));
this.appear_width=c_array_width;
this.text_box_gb_width=this._get_char_width(this.latter_half.join(""));
this._change_reverse_view();
setf_text(this.reverse_text_box,c_array.join(""));}
};
TextBox.prototype.replace_text=function (text){
if(this.pending_p==false){
return;}

if(text==""||text==null||typeof text!="string"){
console.log("[ERROR] Replace char of TextBox with invalid object!");}
if(this.input_array.length==this.cursor_pos){
if(this.password_mode){
this.password_array.pop();
this.password_array.push(text);}else {
this.input_array.pop();
this.input_array.push(text);}
}else {
var replace_cursor_pos=0;
replace_cursor_pos=this.cursor_pos-2;
if(this.password_mode){
this.password_array.splice(replace_cursor_pos,1,text);}else {
this.input_array.splice(replace_cursor_pos,1,text);}
}
if(this.change_text_hook!=null&&typeof this.change_text_hook=="function"){
this.change_text_hook();}
this._update_view();};
TextBox.prototype.replace_romaji_text=function (rep_text,fixed_size){
var i=0;
var del_num=fixed_size;
var rep_num=rep_text.length;
var dif_num=rep_num-del_num;
var left_array=[];
var right_array=[];
var rep_array=[];
for(i=0;i<rep_num;i++){
rep_array[i]=rep_text.charAt(i);}
left_array=this.get_text_array_left();
for(i=0;i<del_num;i++){
left_array.pop();}
if(this.input_array.length==this.cursor_pos
&&this.insert_mode==false){
if(this.password_mode){
this.password_array=left_array.concat(rep_array);}else {
this.input_array=left_array.concat(rep_array);}
}else {
right_array=this.get_text_array_right();
if(this.password_mode){
this.password_array=left_array.concat(rep_array,right_array);}else {
this.input_array=left_array.concat(rep_array,right_array);}
}
this.cursor_pos+=dif_num;
if(this.change_text_hook!=null&&typeof this.change_text_hook=="function"){
this.change_text_hook();}
this._update_view();};

TextBox.prototype.set_empty_hook=function (func){
this.empty_hook=func;}
TextBox.prototype.set_change_text_hook=function (func){
this.change_text_hook=func;}

TextBox.prototype.delete_text=function (){
if(this.input_array.length==0){
return;}

this.pending_p=false;
if(this.cursor_pos==this.input_array.length){
if(this.password_mode){
if(this.insert_mode&&this.password_array[this.cursor_pos-2]){this.password_array.splice(this.cursor_pos-2,1);}else {this.password_array.pop();
this.insert_mode=false;}
}else {
if(this.insert_mode&&this.input_array[this.cursor_pos-2]){this.input_array.splice(this.cursor_pos-2,1);}else {this.input_array.pop();
this.insert_mode=false;}
}
this.cursor_pos--;
if(this.cursor_pos<=0){
this.cursor_pos=0;
if(this.empty_hook!=null&&typeof this.empty_hook=="function"){
append_timer(this.empty_hook,1,function(obj,count){
delete_timer(obj);
obj();});}
}
}else {
if(this.password_mode){
if(this.password_array[this.cursor_pos-2]){this.password_array.splice(this.cursor_pos-2,1);
this.cursor_pos--;}else {this.password_array.splice(this.cursor_pos-1,1);}
}else {
if(this.input_array[this.cursor_pos-2]){this.input_array.splice(this.cursor_pos-2,1);
this.cursor_pos--;}else {this.input_array.splice(this.cursor_pos-1,1);}
}
}
if(this.change_text_hook!=null&&typeof this.change_text_hook=="function"){
this.change_text_hook();}
this._update_force_caret_tail();
this._update_view();};
TextBox.prototype.delete_left_text=function (){
if(this.input_array.length==0){
return;}
this.pending_p=false;
if(this.cursor_pos==this.input_array.length&&
this.insert_mode==false){
if(this.password_mode){
this.password_array.pop();}else {
this.input_array.pop();}
this.cursor_pos--;
if(this.cursor_pos<=0){
this.cursor_pos=0;
if(this.empty_hook!=null&&typeof this.empty_hook=="function"){
append_timer(this.empty_hook,1,function(obj,count){
delete_timer(obj);
obj();});}
}
}else {
if(this.cursor_pos>1){
if(this.password_mode){
this.password_array.splice(this.cursor_pos-2,1);}else {
this.input_array.splice(this.cursor_pos-2,1);}
this.cursor_pos--;}else {
this.cursor_pos=1;}
}
if(this.change_text_hook!=null&&typeof this.change_text_hook=="function"){
this.change_text_hook();}
this._update_view();};
TextBox.prototype.delete_right_text=function (){
if(this.input_array.length==0){
return;}
this.pending_p=false;
if(this.cursor_pos<this.input_array.length){
if(this.password_mode){
this.password_array.splice(this.cursor_pos-1,1);}else {
this.input_array.splice(this.cursor_pos-1,1);}
this._update_view();}else if(this.cursor_pos==this.input_array.length&&
this.insert_mode==true){
this.insert_mode=false;
if(this.password_mode){
this.password_array.pop();}else {
this.input_array.pop();}
this.cursor_pos--;
if(this.cursor_pos<=0){
this.cursor_pos=0;
if(this.empty_hook!=null&&typeof this.empty_hook=="function"){
append_timer(this.empty_hook,1,function(obj,count){
delete_timer(obj);
obj();});}
}
this._update_view();
this.cursor_right();}else {
return false;}
if(this.change_text_hook!=null&&typeof this.change_text_hook=="function"){
this.change_text_hook();}
};

TextBox.prototype.clear=function (){
this.cursor_obj.visible_p=false;
this.cursor_text.visible_p=false;
this.under_bar.visible_p=false;
this.reverse_text_box_bg.visible_p=false;
this.reverse_text_box.visible_p=false;
this.text_box_bg.visible_p=false;
this.init();
setf_text(this.text_box,this.input_array.join(""));};
TextBox.prototype._toggle_force_caret_tail=function (text){
if(this.rightToLeftToggle||isRight(text)){
if(!this.force_caret_tail)
this.force_caret_tail=true;
if(this.cursor_pos<this.input_array.length)
this.cursor_pos=this.input_array.length;
if(this.insert_mode)
this.insert_mode=false;
return false;}
return true;};
TextBox.prototype.cursor_left=function (){
if(!this.rightToLeftToggle){
return this._cursor_left();}else {
return this._cursor_right();}
};
TextBox.prototype._cursor_left=function (){
this.pending_p=false;
var ret=true;
if(this.insert_mode==true){
this.cursor_pos-=1;
if(this.cursor_pos<=0){
this.cursor_pos=1;
ret=false;}
}else if(this.input_array.length==0){
ret=false;}else {
this.insert_mode=true;}
this._update_view();
return ret;}
TextBox.prototype.cursor_right=function (){
if(!this.rightToLeftToggle){
return this._cursor_right(true);}else {
return this._cursor_left(true);}
};
TextBox.prototype._cursor_right=function (){
this.pending_p=false;
var text_len=this.input_array.length;
this.cursor_pos+=1;
var ret=true;
if(this.cursor_pos>text_len){
this.cursor_pos=text_len;
if(this.insert_mode==true){
this.insert_mode=false;}else {
ret=false;}
}
this._update_view();

return ret;}
TextBox.prototype._change_cursor_visible=function (obj,target_x,end_func){
if(this.cursor_on){
if(this.insert_mode){
this.cursor_obj.visible_p=true;
this.cursor_text.visible_p=true;
this.end_cursor_obj.visible_p=false;}else {
this.cursor_obj.visible_p=false;
this.cursor_text.visible_p=false;
this.end_cursor_obj.visible_p=true;}
}else {
this.cursor_obj.visible_p=false;
this.cursor_text.visible_p=false;
this.end_cursor_obj.visible_p=false;}
};
TextBox.prototype._move=function (obj,target_x,end_func){
delete_timer(obj);
var delta=0;
var func=end_func;
append_timer(obj,TIMER_RESOLUTION,
function (obj,count){
delta=(target_x-obj.translate[0])/2;
if(count>=7){
delete_timer(obj);
obj.translate[0]=target_x;
if(func){
func();}
}else {
obj.translate[0]+=delta;}
force_redraw();});}
TextBox.prototype.free=function (){
this.set_text("");
setf_text(this.text_box,"");
setf_text(this.reverse_text_box,"");
setf_text(this.cursor_text,"");
return;};
TextBox.prototype.revive=function (){
return;};
TextBox.prototype.get_text_length=function (){
return this.input_array.length;};
TextBox.prototype.do_backspace=function (){
this.delete_text();};
TextBox.prototype.add_linefeed=function (){};
TextBox.prototype.allclear=function (){
if(this.input_array.length==0){
return;}
if(this.password_mode){
this.password_array.splice(0,this.password_array.length);}else {
this.input_array.splice(0,this.input_array.length);}
this.cursor_pos=0;
this.insert_mode=false;
this._update_force_caret_tail();
this._update_view();};
TextBox.prototype.set_toggle_force_caret_tail_cb=function (func){
this.toggle_force_caret_tail_cb=func;};
TextBox.prototype.call_toggle_force_caret_tail_cb=function (bool){
if(this.toggle_force_caret_tail_cb
&&typeof this.toggle_force_caret_tail_cb=="function"){
this.toggle_force_caret_tail_cb(bool);}
};
TextBox.prototype.set_font_size=function (font_size){
this.text_box.font_size=font_size;
this.reverse_text_box.font_size=font_size;
this.cursor_text.font_size=font_size;};
TextBox.prototype.set_font_name=function (font_name){
this.text_box.font_name=font_name;
this.reverse_text_box.font_name=font_name;
this.cursor_text.font_name=font_name;};
TextBox.prototype.set_textarea_color=function (reverse){
var color=this.text_color;
var reverse_color=this.reverse_text_color;
if(reverse){
color=this.reverse_text_color;
reverse_color=this.text_color;}
this.text_box_bg.color=reverse_color;
this.text_box.color=color;
this.reverse_text_box_bg.color=color;
this.reverse_text_box.color=reverse_color;
this.cursor_obj.color=color;
this.cursor_text.color=reverse_color;
this.under_bar.color=color;
this.end_cursor_obj.color=color;}

TextBox.prototype.set_omitter=function (omitter){
this.text_box.omitter=omitter;};

TextBox.prototype.unset_omitter=function (){
this.text_box.omitter="";};
TextBox.prototype.set_align=function (align){
this.text_box.align=align;
setf_text(this.text_box,this.input_array.join(""));};

TextBox.prototype.set_edit_start_align=function (){
this._update_text_box();};

TextBox.prototype.set_edit_end__align=function (){};

var TextAreaMulti=function(){
this.width=100;
this.height=100;
this.unconf_margin=10;
this.singleline=false;
this.components=[];};
TextAreaMulti.prototype=new container({});
TextAreaMulti.prototype.create=function(param){

if(typeof param.width=="number")
this.width=param.width;
if(typeof param.height=="number")
this.height=param.height;
this.singleline=param.singleline||false;
this.force_align=param.align||LEFT;
this.unconf_pos=param.unconf_pos||"under";
if(typeof param.unconf_margin=="number")
this.unconf_margin=param.unconf_margin;
this.color_reverse=param.color_reverse?true:false;
this.scrollable=param.scrollable=param.scrollable?true:false;
this.textbox=new TextBoxMulti(param);
this.unconf_bg=new UnconfBG(param);
this.unconf_textbox=new TextBox(param);
this.components=[this.textbox,this.unconf_bg,this.unconf_textbox];
if(param.font_size)this.set_font_size(param.font_size);
if(param.font_name)this.set_font_name(param.font_name);
this.set_textarea_color(this.color_reverse);
if(param.omitter)this.set_omitter(param.omitter);
if(param.align)this.set_align(param.align);
if(this.scrollable){
this.override_textbox_scrollable();
this.right_char_num=0;
this.all_length_limit=1000;
if(typeof param.char_length_limit=="number"
&&param.char_length_limit<this.all_length_limit)
this.all_length_limit=param.char_length_limit;
this.scroll_bar=new ScrollBar();
this.scroll_bar.create(param);
this.scroll_bar.set_in_row_num(this.textbox.max_row_num);
this.components.unshift(this.scroll_bar);}
this.textbox.update_row_info_array();
if(param.unconf_bg_width==undefined)
param.unconf_bg_width=this.width+this.unconf_bg.PADDING;
if(param.unconf_bg_height==undefined)
param.unconf_bg_height=this.unconf_textbox.get_height()+this.unconf_bg.PADDING;
if(param.unconf_bg_color==undefined)
param.unconf_bg_color=this.textbox.get_bg_color();
this.unconf_bg.create(param);
this.set_unconf_position();
this.all_input_array=[];
this.all_headlines=[];
this.top_row_pos=0;};
TextAreaMulti.prototype.free=function(){
};
TextAreaMulti.prototype.enter_focus=function(){
};
TextAreaMulti.prototype.leave_focus=function(){
};
TextAreaMulti.prototype.get_text=function(){
if(this.scrollable)
return this.all_input_array.join("");
else
return this.textbox.get_text();};
TextAreaMulti.prototype.set_text=function(text,valign){
if(this.scrollable){
this._set_text_scrollable(text,valign);}else {
this.textbox.set_text(text);}
};
TextAreaMulti.prototype._set_text_scrollable=function(text,valign){
valign=(typeof valign=="number")?valign:BOTTOM;this.all_input_array=[];
this.all_input_array=text.slice(0,this.all_length_limit).split("");
this.right_char_num=0;
for(var i=0;i<this.all_input_array.length;i++){
if(isRight(this.all_input_array[i]))
this.right_char_num++;}
var max_row_num=this.textbox.max_row_num;
var dummy_tbox=this.textbox.gen_dummy_textbox(this.all_input_array.join(""));
this.all_lineheads=get_lineheads_textbox(dummy_tbox,65536);
var all_array_row_num=this.all_lineheads.indexOf(null,1);
if(all_array_row_num==-1)
all_array_row_num=1;
if(valign==TOP){
this.top_row_pos=1;}else if(max_row_num<all_array_row_num){this.top_row_pos=all_array_row_num-max_row_num+1;}else {
this.top_row_pos=1;}
var head_array_pos=this.all_lineheads[this.top_row_pos-1];
this.scroll_bar.update(all_array_row_num,this.top_row_pos);
var tail_array_pos=this.all_input_array.length;
if(valign==TOP){
if(this.all_lineheads[this.top_row_pos+max_row_num-1]!=null){
tail_array_pos=this.all_lineheads[this.top_row_pos+max_row_num-1]-1;}
}
var input_array=this.all_input_array.slice(head_array_pos,tail_array_pos);
this.textbox.set_text(input_array.join(""));};
TextAreaMulti.prototype.set_text_color=function(color){
this.textbox.set_text_color(color);
this.unconf_textbox.set_text_color(color);
this.set_textarea_color(this.color_reverse);};
TextAreaMulti.prototype.set_reverse_text_color=function(color){
this.textbox.set_reverse_text_color(color);
this.unconf_textbox.set_reverse_text_color(color);
this.set_textarea_color(this.color_reverse);};
TextAreaMulti.prototype.set_font_size=function(font_size){
this.textbox.set_font_size(font_size);
this.unconf_textbox.set_font_size(font_size);};
TextAreaMulti.prototype.set_font_name=function(font_name){
this.textbox.set_font_name(font_name);
this.unconf_textbox.set_font_name(font_name);};
TextAreaMulti.prototype.set_textarea_color=function(reverse){
this.textbox.set_textarea_color(reverse);
this.unconf_textbox.set_textarea_color(reverse);};
TextAreaMulti.prototype.set_omitter=function(omitter){
this.textbox.set_omitter(omitter);};
TextAreaMulti.prototype.unset_omitter=function(){
this.textbox.unset_omitter();};
TextAreaMulti.prototype.set_align=function(align){
this.force_align=align;
this.textbox.set_align(align);};
TextAreaMulti.prototype.unset_align=function(align){
this.textbox.set_align(this.force_align);};
TextAreaMulti.prototype.set_unconf_position=function(){
var ypos=this.textbox.get_height()/2
+this.unconf_textbox.get_height()/2
+this.unconf_margin;
switch(this.unconf_pos){
case "under":
ypos=-ypos;
break;
case "over":
break;
default:
ypos=-ypos;
break;}
this.unconf_textbox.set_trans_y(ypos);
this.unconf_bg.set_trans_y(ypos);};
TextAreaMulti.prototype._add_text_scrollable=function(text){
if(typeof text!="string"||text==""){
console.log("[ERROR] Add invalid object to TextAreaMulti!");
return;}
if(this.all_input_array.length>=this.all_length_limit)
return;
if(isRight(text))
this.right_char_num++;
var tbox=this.textbox;
var cur_cursor_pos=tbox.cursor_pos;
var all_cursor_pos=this.all_lineheads[this.top_row_pos-1]+cur_cursor_pos;
if(this.all_lineheads[this.top_row_pos-1]!=null){
all_cursor_pos=this.all_lineheads[this.top_row_pos-1]+cur_cursor_pos;}else {
all_cursor_pos=cur_cursor_pos;}
if(tbox.is_end_cursor_mode()){if(this.all_input_array.length==all_cursor_pos){this.all_input_array.push(text);}else {var array=this.all_input_array;
var latter_half=array.slice(0);
array.splice(all_cursor_pos,array.length-all_cursor_pos);
latter_half.splice(0,all_cursor_pos);
latter_half.unshift(text);
this.all_input_array=array.concat(latter_half);}
}else {
var array=this.all_input_array;
var latter_half=array.slice(0);
array.splice(all_cursor_pos-1,array.length-all_cursor_pos+1);
latter_half.splice(0,all_cursor_pos-1);
latter_half.unshift(text);
this.all_input_array=array.concat(latter_half);}
cur_cursor_pos++;
all_cursor_pos++;
var old_all_array_row_num=this.all_lineheads.indexOf(null,1);
var dummy_tbox=this.textbox.gen_dummy_textbox(this.all_input_array.join(""));
this.all_lineheads=get_lineheads_textbox(dummy_tbox,65536);
var all_array_row_num=this.all_lineheads.indexOf(null,1);
var max_row_num=this.textbox.max_row_num;
var scrolled=false;
if(all_array_row_num>old_all_array_row_num
&&tbox._get_cursor_pos_row()==max_row_num){this.top_row_pos+=all_array_row_num-old_all_array_row_num;
scrolled=true;}
var last_row_pos=this.top_row_pos+max_row_num-2;
var head_array_pos=this.all_lineheads[this.top_row_pos-1];
var tail_array_pos=0;
var cursor_tail=false;
if(tbox.is_end_cursor_mode()){if(all_array_row_num<max_row_num||last_row_pos+1==all_array_row_num){tail_array_pos=this.all_input_array.length;
cursor_tail=true;}else {tail_array_pos=this.all_lineheads[this.top_row_pos+max_row_num-1]-1;}
}else {if(this.all_lineheads[this.top_row_pos+max_row_num-1]==null){tail_array_pos=this.all_input_array.length;}else {tail_array_pos=this.all_lineheads[this.top_row_pos+max_row_num-1]-1;}
if(scrolled){
var scrolled_row_len=this.all_lineheads[this.top_row_pos-1]-this.all_lineheads[this.top_row_pos-2];
cur_cursor_pos-=scrolled_row_len;}
}
var input_array=this.all_input_array.slice(head_array_pos,tail_array_pos);
this.scroll_bar.update(all_array_row_num,this.top_row_pos);
if(cursor_tail)
this.textbox.set_text(input_array.join(""));
else
this.textbox.set_text(input_array.join(""),cur_cursor_pos);};
TextAreaMulti.prototype._do_backspace_scrollable=function(){
if(this.all_input_array.length==0)return;
var tbox=this.textbox;
var cur_cursor_pos=tbox.cursor_pos;
var all_cursor_pos;
if(this.all_lineheads[this.top_row_pos-1]!=null){
all_cursor_pos=this.all_lineheads[this.top_row_pos-1]+cur_cursor_pos;}else {
all_cursor_pos=cur_cursor_pos;}
var cursor_tail=false;
var need_scroll=false;
var deleted_char="";
if(tbox.is_end_cursor_mode()){
if(all_cursor_pos==this.all_input_array.length){deleted_char=this.all_input_array.pop();
all_cursor_pos--;
if(all_cursor_pos<=0)
all_cursor_pos=0;
cursor_tail=true;}else {
deleted_char=this.all_input_array.splice(all_cursor_pos-1,1);}
}else {
if(this.all_input_array[all_cursor_pos-2]){deleted_char=this.all_input_array.splice(all_cursor_pos-2,1);
all_cursor_pos--;
if(cur_cursor_pos-1<=0)
need_scroll=true;
if(all_cursor_pos<=0)
all_cursor_pos=1;}else {deleted_char=this.all_input_array.splice(all_cursor_pos-1,1);}
}
deleted_char=deleted_char.toString();
if(isRight(deleted_char))
this.right_char_num--;
if(this.right_char_num<0)
this.right_char_num=0;
var old_all_array_row_num=this.all_lineheads.indexOf(null,1);
var dummy_tbox=tbox.gen_dummy_textbox(this.all_input_array.join(""));
this.all_lineheads=get_lineheads_textbox(dummy_tbox,65536);
var all_array_row_num=this.all_lineheads.indexOf(null,1);
var max_row_num=tbox.max_row_num;
var old_top_row_pos=this.top_row_pos;
if(all_array_row_num<old_all_array_row_num){this.top_row_pos-=old_all_array_row_num-all_array_row_num;}else if(need_scroll){this.top_row_pos--;}
if(this.top_row_pos<1){
this.top_row_pos=1;}
if(this.top_row_pos<old_top_row_pos){
if(tbox._get_cursor_pos_row()>=max_row_num-1){
this.top_row_pos=old_top_row_pos;}
};
var last_row_pos=this.top_row_pos+max_row_num-2;
var head_array_pos=this.all_lineheads[this.top_row_pos-1];
var tail_array_pos=0;
if(tbox.is_end_cursor_mode()){if(all_array_row_num<=last_row_pos+1){tail_array_pos=this.all_input_array.length;}else {tail_array_pos=this.all_lineheads[this.top_row_pos+max_row_num-1]-1;}
}else {if(this.all_lineheads[this.top_row_pos+max_row_num-1]==null){tail_array_pos=this.all_input_array.length;}else {tail_array_pos=this.all_lineheads[this.top_row_pos+max_row_num-1]-1;}
};
this.scroll_bar.update(all_array_row_num,this.top_row_pos);
var input_array=this.all_input_array.slice(head_array_pos,tail_array_pos);
if(cursor_tail){
tbox.set_text(input_array.join(""));}else {
cur_cursor_pos=input_array.length;
for(var i=1;i<=all_array_row_num;i++){
if(this.all_lineheads[i]==null||all_cursor_pos<=this.all_lineheads[i]){
cur_cursor_pos=all_cursor_pos-this.all_lineheads[this.top_row_pos-1];
if(cur_cursor_pos<=0)
cur_cursor_pos=1;
break;}
}
tbox.set_text(input_array.join(""),cur_cursor_pos);}
};
TextAreaMulti.prototype._do_scroll_over_cursor=function(key){
var need_update=false;
var max_row_num=this.textbox.max_row_num;
var all_array_row_num=this.all_lineheads.indexOf(null,1);
var scrolled_cursor_pos=null;
switch(key){
case TXK_UP:
if(this.top_row_pos>1){
this.top_row_pos--;
scrolled_cursor_pos=this._calc_scrolled_cursor_pos_up();
need_update=true;}
break;
case TXK_DOWN:
if(all_array_row_num-this.top_row_pos>=max_row_num){
this.top_row_pos++;
scrolled_cursor_pos=this._calc_scrolled_cursor_pos_down();
need_update=true;}
break;
case TXK_LEFT:
if(this.top_row_pos>1){
this.top_row_pos--;
scrolled_cursor_pos=this._calc_scrolled_cursor_pos_left();
need_update=true;}
break;
case TXK_RIGHT:
if(all_array_row_num-this.top_row_pos>=max_row_num){
this.top_row_pos++;
scrolled_cursor_pos=this._calc_scrolled_cursor_pos_right();
need_update=true;}
break;}
if(!need_update)
return;
var head_array_pos=this.all_lineheads[this.top_row_pos-1];
var tail_array_pos;
if((this.top_row_pos-1+max_row_num)>=all_array_row_num){
tail_array_pos=this.all_input_array.length;}else {
tail_array_pos=this.all_lineheads[this.top_row_pos-1+max_row_num]-1;}
this.scroll_bar.update(all_array_row_num,this.top_row_pos);
var input_array=this.all_input_array.slice(head_array_pos,tail_array_pos);
if(scrolled_cursor_pos==null)
this.textbox.set_text(input_array.join(""));
else
this.textbox.set_text(input_array.join(""),scrolled_cursor_pos);};
TextAreaMulti.prototype._calc_scrolled_cursor_pos_up=function(){
var scrolled_cursor_pos=0;
var tbox=this.textbox;
var cur_cursor_pos=tbox.cursor_pos;
if(tbox._is_line_head(cur_cursor_pos)){
return 1;}
if(tbox._is_line_tail(cur_cursor_pos)){
scrolled_cursor_pos=this._calc_scrolled_cursor_pos_left();
return scrolled_cursor_pos;}
var dummy_tbox=tbox.gen_dummy_textbox();
var front_cur_cursor_text=tbox.input_array.slice(0,cur_cursor_pos).join("");
var front_cur_cursor_text_width=get_text_width(dummy_tbox,front_cur_cursor_text);
var c_char=tbox.input_array[cur_cursor_pos-1];
var c_char_width=tbox._get_char_width(c_char);
var trg_width=Math.floor(front_cur_cursor_text_width-c_char_width/2);
var up_line_text=this.all_input_array.slice(
this.all_lineheads[this.top_row_pos-1],this.all_lineheads[this.top_row_pos]).join("");
var up_line_text_width=get_text_width(dummy_tbox,up_line_text);
var tmp_index=0;
var head=0,tail=up_line_text.length;
var tmp_text="";
var tmp_text_width=0;
while((tail-head)>1){
tmp_index=Math.floor((tail-head)/2)+head;
tmp_text=up_line_text.slice(0,tmp_index);
tmp_text_width=Math.floor(get_text_width(dummy_tbox,tmp_text)
-tbox._get_char_width(tmp_text[tmp_index-1]));
if(trg_width<=tmp_text_width){
tail=tmp_index;}else {
head=tmp_index;}
}
scrolled_cursor_pos=head;
return scrolled_cursor_pos;};
TextAreaMulti.prototype._calc_scrolled_cursor_pos_down=function(){
var scrolled_cursor_pos=0;
var tbox=this.textbox;
var cur_cursor_pos=tbox.cursor_pos;
if(tbox._is_line_head(cur_cursor_pos)){
return this._calc_scrolled_cursor_pos_right();}
if(tbox._is_line_tail(cur_cursor_pos)){
return null;}
var dummy_tbox=tbox.gen_dummy_textbox();
var max_row_num=this.textbox.max_row_num;
var front_cur_cursor_text=tbox.input_array.slice(
tbox.row_info_array[max_row_num-1].head_pos,cur_cursor_pos).join("");
var front_cur_cursor_text_width=get_text_width(dummy_tbox,front_cur_cursor_text);
var c_char=tbox.input_array[cur_cursor_pos-1];
var c_char_width=tbox._get_char_width(c_char);
var trg_width=Math.floor(front_cur_cursor_text_width-c_char_width/2);
var last_row_pos=this.top_row_pos+max_row_num-2;
var down_line_text="";
if(this.all_lineheads[last_row_pos+1]==null){down_line_text=this.all_input_array.slice(
this.all_lineheads[last_row_pos],this.all_input_array.length).join("");}else {
down_line_text=this.all_input_array.slice(
this.all_lineheads[last_row_pos],this.all_lineheads[last_row_pos+1]).join("");}
var down_line_text_width=get_text_width(dummy_tbox,down_line_text);
if(down_line_text_width<trg_width){
return null;}
var tmp_index=0;
var head=0,tail=down_line_text.length;
var tmp_text;
while((tail-head)>1){
tmp_index=Math.floor((tail-head)/2)+head;
tmp_text=down_line_text.slice(0,tmp_index);
var tmp_text_width=Math.floor(get_text_width(dummy_tbox,tmp_text)
-tbox._get_char_width(tmp_text[tmp_index-1]));
if(trg_width<=tmp_text_width){
tail=tmp_index;}else {
head=tmp_index;}
}
scrolled_cursor_pos=this.all_lineheads[last_row_pos]-this.all_lineheads[this.top_row_pos-1]+head;
return scrolled_cursor_pos;};
TextAreaMulti.prototype._calc_scrolled_cursor_pos_left=function(){
var head_row_text_len=this.all_lineheads[this.top_row_pos]-this.all_lineheads[this.top_row_pos-1];
var scrolled_cursor_pos=head_row_text_len;
return scrolled_cursor_pos;};
TextAreaMulti.prototype._calc_scrolled_cursor_pos_right=function(){
var max_row_num=this.textbox.max_row_num;
var scrolled_cursor_pos=this.all_lineheads[this.top_row_pos+max_row_num-2]
-this.all_lineheads[this.top_row_pos-1]+1;
return scrolled_cursor_pos;};
TextAreaMulti.prototype._allclear_scrollable=function(){
if(this.all_input_array.length==0)
return;
this.set_text("");};
TextAreaMulti.prototype.do_confirm_composition=function(text){
this.textbox.enable_cursor();
this.unconf_textbox.disable_reverse();
this.unconf_textbox.disable_under_bar();
this.unconf_textbox.disable_cursor();
this.unconf_textbox.free();
if(!this.unconf_bg.force_visible)
this.unconf_bg.set_visible(false);
if(this.scrollable){
this._add_text_scrollable(text);}else {
this.textbox.add_text(text);}
};
TextAreaMulti.prototype.do_set_composition=function(convert_info){
this.unconf_textbox.enable_reverse();
this.unconf_textbox.enable_under_bar();
this.unconf_textbox.disable_cursor();
this.unconf_bg.set_visible(true);
this.unconf_textbox.add_unconfirmed_text(convert_info);
if(this.textbox.input_array.length>0){
}else {
this.unconf_textbox.text_box.translate[0]=0;}
};
TextAreaMulti.prototype.do_cancel_composition=function(){
this.unconf_textbox.disable_reverse();
this.unconf_textbox.disable_under_bar();
this.unconf_textbox.free();
if(!this.unconf_bg.force_visible)
this.unconf_bg.set_visible(false);};
TextAreaMulti.prototype.do_move_caret=function(key){
if(!this.textbox.is_caret_movable())
return;
var ret=false;
switch(key){
case TXK_UP:
if(this.textbox.cursor_up&&typeof this.textbox.cursor_up=="function")
ret=this.textbox.cursor_up();
break;
case TXK_DOWN:
if(this.textbox.cursor_down&&typeof this.textbox.cursor_down=="function")
ret=this.textbox.cursor_down();
break;
case TXK_LEFT:
ret=this.textbox.cursor_left();
break;
case TXK_RIGHT:
ret=this.textbox.cursor_right();
break;
default:
return;};
if(!ret&&this.scrollable)
this._do_scroll_over_cursor(key);};
TextAreaMulti.prototype.do_enter_backspace=function(){
if(this.scrollable)
this._do_backspace_scrollable();
else
this.textbox.do_backspace();};
TextAreaMulti.prototype.do_enter_linefeed=function(){
if(this.scrollable)
this._add_text_scrollable("\n");
else
this.textbox.add_linefeed();};
TextAreaMulti.prototype.do_enter_allclear=function(){
if(this.scrollable)
this._allclear_scrollable();
else
this.textbox.allclear();};
TextAreaMulti.prototype.do_set_from_left_mode=function(){
this.textbox.set_from_left_mode();};
TextAreaMulti.prototype.do_set_from_right_mode=function(){
this.textbox.set_from_right_mode();};
TextAreaMulti.prototype.enable_cursor=function(){
this.textbox.enable_cursor();};
TextAreaMulti.prototype.disable_cursor=function(){
this.textbox.disable_cursor();
this.unconf_textbox.disable_cursor();};
TextAreaMulti.prototype.set_unconf_bg_param=function(param){
this.unconf_bg.set_param(param);};
TextAreaMulti.prototype.show_unconf_bg=function(){
this.unconf_bg.show();};
TextAreaMulti.prototype.hide_unconf_bg=function(){
this.unconf_bg.hide();};
TextAreaMulti.prototype.set_toggle_force_caret_tail_cb=function(func){
this.textbox.set_toggle_force_caret_tail_cb(func);};
TextAreaMulti.prototype.is_singleline=function(){
return this.singleline;};
TextAreaMulti.prototype.do_scroll_up=function(){
this._do_scroll_over_cursor(TXK_UP);};
TextAreaMulti.prototype.do_scroll_down=function(){
this._do_scroll_over_cursor(TXK_DOWN);};
TextAreaMulti.prototype.override_textbox_scrollable=function(){
var self=this;
this.textbox._toggle_force_caret_tail=function (){
if(!this.force_caret_tail)
this.force_caret_tail=true;
if(this.cursor_pos<this.input_array.length)
this.cursor_pos=this.input_array.length;
if(this.insert_mode)
this.insert_mode=false;};
this.textbox._update_force_caret_tail=function (){
if(self.all_input_array.length==0){
if(this.rightToLeftToggle){
this.call_toggle_force_caret_tail_cb(false);
return;}
}
if(self.right_char_num>0){
this._toggle_force_caret_tail();
this.call_toggle_force_caret_tail_cb(false);
return;}
this.call_toggle_force_caret_tail_cb(true);
this.force_caret_tail=false;};};
TextAreaMulti.prototype.key_hook=function(up_down,key){
if(up_down!=KEY_PRESS)
return true;
if(this.cursor&&this.cursor.key_hook&&this.cursor.key_hook(up_down,key)){
force_redraw();
return true;}
return false;};
TextAreaMulti.prototype.move_unconf_textbox=function(){
var unconf_h_w=this.unconf_textbox.text_box_bg.width/2;
if(this.textbox.insert_mode){
var cursor_s=this.textbox.cursor_obj.translate[0]-this.textbox.cursor_obj.width/2;
var insert_on_x=cursor_s+unconf_h_w;
this.unconf_textbox.text_box.translate[0]=this.width/2+cursor_s;
this.unconf_textbox.text_box_bg.translate[0]=insert_on_x;
this.unconf_textbox.under_bar.translate[0]=insert_on_x;
if(this.unconf_textbox.text_box_bg.width==this.unconf_textbox.reverse_text_box_bg.width){
this.unconf_textbox.reverse_text_box.translate[0]=insert_on_x;
this.unconf_textbox.reverse_text_box_bg.translate[0]=insert_on_x;}else {
this.unconf_textbox.reverse_text_box.translate[0]=insert_on_x
-this.unconf_textbox.text_box_bg.width/2
+this.unconf_textbox.reverse_text_box_bg.width/2;
this.unconf_textbox.reverse_text_box_bg.translate[0]=insert_on_x
-this.unconf_textbox.text_box_bg.width/2
+this.unconf_textbox.reverse_text_box_bg.width/2;}
}else {
var c_char=this.textbox.input_array[this.textbox.cursor_pos-1];
var c_char_width=this.textbox._get_char_width(c_char);
var cursor_e=this.textbox.cursor_obj.translate[0]+this.textbox.cursor_obj.width/2;
var insert_off_x=this.textbox.cursor_obj.translate[0]+c_char_width/2+unconf_h_w;
this.unconf_textbox.text_box.translate[0]=this.width/2+cursor_e;
this.unconf_textbox.text_box_bg.translate[0]=insert_off_x;
this.unconf_textbox.under_bar.translate[0]=insert_off_x;
if(this.unconf_textbox.text_box_bg.width==this.unconf_textbox.reverse_text_box_bg.width){
this.unconf_textbox.reverse_text_box.translate[0]=insert_off_x;
this.unconf_textbox.reverse_text_box_bg.translate[0]=insert_off_x;}else {
this.unconf_textbox.reverse_text_box.translate[0]=insert_off_x
-this.unconf_textbox.text_box_bg.width/2
+this.unconf_textbox.reverse_text_box_bg.width/2;
this.unconf_textbox.reverse_text_box_bg.translate[0]=insert_off_x
-this.unconf_textbox.text_box_bg.width/2
+this.unconf_textbox.reverse_text_box_bg.width/2;}
}
var unconf_end_pos=this.unconf_textbox.text_box_bg.translate[0]+this.unconf_textbox.text_box_bg.width/2;
if(unconf_end_pos>this.width/2){
var over_char_w=unconf_end_pos-this.width/2;
this.unconf_textbox.text_box.translate[0]-=over_char_w;
this.unconf_textbox.text_box_bg.translate[0]-=over_char_w;
this.unconf_textbox.reverse_text_box.translate[0]-=over_char_w;
this.unconf_textbox.reverse_text_box_bg.translate[0]-=over_char_w;
this.unconf_textbox.under_bar.translate[0]-=over_char_w;}
};
function TextBoxMulti(param){
this.width=param.width;
this.height=param.height;
this.width_limit=this.width;
this.height_limit=this.height;
this.text_color=param.text_color||[0,0,0,255];
this.reverse_text_color=param.reverse_text_color||[255,255,255,255];
this.scrollable=param.scrollable;
var font_size=param.font_size||32;
this.cursor_height=font_size+6;
this.toggle_force_caret_tail_cb=null;
if(typeof param.char_length_limit=="undefined"||param.char_length_limit<0){
this.char_length_limit=200;}else {
this.char_length_limit=param.char_length_limit;}
this.text_box_bg=new gbox({
width:this.width,height:this.height,color:[0,0,0,0]
});
this.text_box=new gtextbox({
width:this.width,height:this.height,align:LEFT,valign:TOP,
font_size:32
});
this.cursor_obj=new gbox({
width:10,height:this.cursor_height,visible_p:false
});

this.cursor_text=new gtext({
width:this.height,text:"",
visible_p:false,font_size:32
});
this.end_cursor_obj=new gbox({
width:8,height:this.cursor_height,visible_p:false
});

this.components=[
this.text_box_bg,
this.text_box,
this.cursor_obj,
this.cursor_text,
this.end_cursor_obj
];
this.init();
this.cursor_on=false;
this.rightToLeftToggle=false;};
TextBoxMulti.prototype=new container({});
TextBoxMulti.prototype.init=function (){
this.input_array=[];
this.cursor_pos=0;
this.cursor_pos_bias=0;
this.no_appear_text_width=0;
this.no_appear_text=[];
this.no_appear_latter_text=[];
this.latter_half=[];
this.latter_pos=0;
this.firsthalf_pos=0;
this.appear_width=0;
this.text_box_gb_width=0;
this.cursor_left_pos=0;
this.insert_mode=false;
this.pending_p=false;
this.force_caret_tail=false;
this.init_font_info();};
TextBoxMulti.prototype.init_font_info=function(){
this.font_height=get_text_font_height(this.text_box," ");
this.font_inner_height=get_text_font_height(this.text_box,"\n\n")-this.font_height;
this.margin_reading=this.text_box.margin_leading;
this.max_row_num=this.calc_max_row_num();
this.row_info_array=this.gen_row_info_array();};
TextBoxMulti.prototype.calc_max_row_num=function (){
var tbox_margin=this.text_box.margin;
var inner_height=this.height-tbox_margin[0]-tbox_margin[1];
var max_row_num=0;
while(inner_height>=this.font_inner_height){
max_row_num++;
inner_height-=this.font_inner_height+this.margin_reading;}
return max_row_num;};
TextBoxMulti.prototype.gen_row_info_array=function (){
var info_array=[];
if(this.max_row_num<=0)
return info_array;
var info={};
info.y=(this.height-this.font_height)/2-this.text_box.margin[0];
info.head_pos=0;
info_array.push(info);
var texts_space=(this.font_inner_height+this.margin_reading);
for(var i=1;i<this.max_row_num;i++){
info={};
info.y=info_array[0].y-texts_space*i;
info.head_pos=0;
info_array.push(info);}
return info_array;};
TextBoxMulti.prototype.set_from_right_mode=function (){
this.rightToLeftToggle=true;
this._update_force_caret_tail();
this._update_view();};
TextBoxMulti.prototype.set_from_left_mode=function (){
this.rightToLeftToggle=false;
this._update_force_caret_tail();
this._update_view();};
TextBoxMulti.prototype.get_height=function (){
return this.height;};
TextBoxMulti.prototype.get_bg_color=function (){
return this.cursor_text.color.slice();};
TextBoxMulti.prototype._get_char_width=function (character){
return get_text_width(this.cursor_text,character);};
TextBoxMulti.prototype.get_text=function (){
return this.input_array.join("");};
TextBoxMulti.prototype.get_text_array=function (){
return this.input_array.slice(0);};
TextBoxMulti.prototype.get_text_array_left=function (){
var current_pos=this.cursor_pos;
if(this.insert_mode){
current_pos--;}
return this.input_array.slice(0,current_pos);}
TextBoxMulti.prototype.get_text_array_right=function (){
var current_pos=this.cursor_pos;
if(this.insert_mode){
current_pos--;}
return this.input_array.slice(current_pos);}

TextBoxMulti.prototype.get_cursor_position=function (){
if(this.is_end_cursor_mode()){
return this.cursor_left_pos+this.cursor_obj.width;}else {
return this.cursor_left_pos;}
}

TextBoxMulti.prototype.get_cursor_trans_y=function (){
var ret_y=0;
var cursor_pos_row=this._get_cursor_pos_row();
if(this.row_info_array[cursor_pos_row-1])
ret_y=this.row_info_array[cursor_pos_row-1].y;
return ret_y;};

TextBoxMulti.prototype.set_text_color=function (color){
this.text_color=color;}
TextBoxMulti.prototype.set_reverse_text_color=function (color){
this.reverse_text_color=color;}
TextBoxMulti.prototype.set_text=function (text,cursor_pos,composition_mode){
var text_len=text.length;
if(typeof composition_mode=="undefined"&&!this.scrollable){
if(this.char_length_limit!=null&&this.char_length_limit>0){
if(text.length>this.char_length_limit){
console.log("[ERROR] Over char length limit!!");
text_len=this.char_length_limit;}
}
}
this.init();
for(var i=0;i<text_len;i++){
this.input_array.push(text[i]);}
if(!this.scrollable){
var over_f=this.check_text_over();
while(!over_f){
this.input_array.pop();
over_f=this.check_text_over();}
}
if(cursor_pos>0&&cursor_pos<=this.input_array.length){
this.cursor_pos=cursor_pos;
this.insert_mode=true;}else {
this.cursor_pos=this.input_array.length;}
this._update_force_caret_tail();
this._update_view();};
TextBoxMulti.prototype._change_cursor_pos=function (){
var cursor_pos_row=this._get_cursor_pos_row();
var trg_row_info=this.row_info_array[cursor_pos_row-1];
if(this.input_array.length>0){
var row_head_to_cursor_text="";
row_head_to_cursor_text=this.input_array.slice(trg_row_info.head_pos,this.cursor_pos).join("");
var row_head_to_cursor_text_width=get_text_width(this.text_box,row_head_to_cursor_text);

var c_char=this.input_array[this.cursor_pos-1];
var c_char_width=this._get_char_width(c_char);
var cursor_x_pos=0;
var cursor_y_pos=trg_row_info.y;
if(!this.rightToLeftToggle){
cursor_x_pos=-(this.width/ 2) + row_head_to_cursor_text_width - c_char_width /2;
if(this.width/2<cursor_x_pos)
cursor_x_pos=this.width/2;}else {
cursor_x_pos=(this.width/ 2) - row_head_to_cursor_text_width + c_char_width /2;
if(cursor_x_pos<-this.width/2)
cursor_x_pos=-this.width/2;}
if(this._is_return_code_by_text(c_char)){
if(!this.rightToLeftToggle)
cursor_x_pos+=c_char_width;
else
cursor_x_pos-=c_char_width;}

this.cursor_obj.translate[0]=cursor_x_pos;
this.cursor_obj.translate[1]=cursor_y_pos;
this.cursor_obj.width=c_char_width;
this.cursor_text.translate[0]=cursor_x_pos;
this.cursor_text.translate[1]=cursor_y_pos;
this.cursor_text.width=c_char_width;
setf_text(this.cursor_text,c_char);
if(this.input_array.length==this.cursor_pos
&&this.insert_mode==false
&&this._is_return_code_by_text(this.input_array[this.input_array.length-1])
&&(cursor_pos_row<this.max_row_num)){
var trg_row_next_info=this.row_info_array[cursor_pos_row];
if(!this.rightToLeftToggle){
cursor_x_pos=-(this.width/ 2) + (c_char_width /2)-(this.end_cursor_obj.width/2);}else {
cursor_x_pos=(this.width/ 2) - (c_char_width /2)+(this.end_cursor_obj.width/2);}
this.end_cursor_obj.translate[0]=cursor_x_pos;
this.end_cursor_obj.translate[1]=trg_row_next_info.y;}else {
if(!this.rightToLeftToggle){
cursor_x_pos=cursor_x_pos+(c_char_width+this.end_cursor_obj.width)/2;}else {
cursor_x_pos=cursor_x_pos-(c_char_width+this.end_cursor_obj.width)/2;}
this.end_cursor_obj.translate[0]=cursor_x_pos;
this.end_cursor_obj.translate[1]=cursor_y_pos;}
}else {
this.cursor_obj.translate[0]=0;
this.cursor_text.translate[0]=0;
this.cursor_obj.width=0;
this.cursor_text.width=0;
setf_text(this.cursor_text,"");
if(!this.rightToLeftToggle){
this.end_cursor_obj.translate[0]=-this.text_box.width/2+this.appear_width
+this.end_cursor_obj.width/2;}else {
this.end_cursor_obj.translate[0]=this.text_box.width/2-this.appear_width
-this.end_cursor_obj.width/2;}
this.end_cursor_obj.translate[1]=trg_row_info.y;}
this._change_cursor_visible();};
TextBoxMulti.prototype._get_cursor_pos_row=function (){
var cursor_pos_row=1;
var ri_array=this.row_info_array;
for(var i=1;i<ri_array.length;i++){
if(ri_array[i].head_pos==null)
break;
if(this.cursor_pos-1<ri_array[i].head_pos)
break;
cursor_pos_row++;}
return cursor_pos_row;};
TextBoxMulti.prototype._get_current_max_row_num=function (){
var ri_array=this.row_info_array;
var cur_max_row_num=1;
if(this.input_array.length==0)
return cur_max_row_num;
for(var i=1;i<ri_array.length;i++){
if(ri_array.head_pos!=null)
break;
cur_max_row_num++;}
return cur_max_row_num;};
TextBoxMulti.prototype.get_password_mode=function (){
return false;};
TextBoxMulti.prototype.get_cursor_visible=function (){
return this.cursor_on;}
TextBoxMulti.prototype.get_end_cursor_visible=function (){
return this.end_cursor_obj.visible_p;}
TextBoxMulti.prototype.is_end_cursor_mode=function (){
return !this.insert_mode;}
TextBoxMulti.prototype._appear_end_cursor=function (){
this.end_cursor_obj.visible_p=true;};
TextBoxMulti.prototype._disappear_end_cursor=function (){
this.end_cursor_obj.visible_p=false;};
TextBoxMulti.prototype._appear_cursor=function (){
this.cursor_obj.visible_p=true;
this.cursor_text.visible_p=true;};
TextBoxMulti.prototype._disappear_cursor=function (){
this.cursor_obj.visible_p=false;
this.cursor_text.visible_p=false;};
TextBoxMulti.prototype.enable_cursor=function (){
this.cursor_on=true;
this._change_cursor_visible();};
TextBoxMulti.prototype.disable_cursor=function (){
this.cursor_on=false;
this._change_cursor_visible();};
TextBoxMulti.prototype.is_end=function (){
if(this.cursor_pos==this.input_array.length){
return true;}else {
return false;}
};

TextBoxMulti.prototype.is_empty=function (){
if(this.input_array.length==0){
return true;}else {
return false;}
};

TextBoxMulti.prototype.is_first=function (){
if(this.cursor_pos==1){
return true;}else {
return false;}
};
TextBoxMulti.prototype.is_caret_movable=function (){
return !this.force_caret_tail;};
TextBoxMulti.prototype._update_text_box=function (){
if(!this.rightToLeftToggle){
this.text_box.align=LEFT;}else {
this.text_box.align=RIGHT;}
setf_text(this.text_box,this.input_array.join(""));};

TextBoxMulti.prototype._update_view=function (){
this._update_text_box();
this._update_row_info_array();
this._change_cursor_pos();
force_redraw();};
TextBoxMulti.prototype._update_force_caret_tail=function (){
if(this.input_array.length==0){
if(this.rightToLeftToggle){
this.call_toggle_force_caret_tail_cb(false);
return;}
}
for(var i=0;i<this.input_array.length;i++){
var text=this.input_array[i];
if(!this._toggle_force_caret_tail(text)){this.call_toggle_force_caret_tail_cb(false);
return;}
}
this.call_toggle_force_caret_tail_cb(true);
this.force_caret_tail=false;};
TextBoxMulti.prototype._update_row_info_array=function (){
var lineheads=get_lineheads_textbox(this.text_box,this.max_row_num);
var ri_array=this.row_info_array;
for(var i in ri_array){
ri_array[i].head_pos=lineheads[i];}
};
TextBoxMulti.prototype.update_row_info_array=function (){
this._update_row_info_array();};
TextBoxMulti.prototype._get_row_length_by_text=function (text){
if(!text||text.length<=0)
return 1;
if(typeof text=="object")
text=text.join("");
var tbox=this.text_box;
var all_text_height=get_text_font_height(tbox,text);
if(all_text_height<=this.font_height){
return 1;}
var row_length=Math.floor((all_text_height)/this.height*this.max_row_num)+1;
return row_length;};
TextBoxMulti.prototype.gen_dummy_textbox=function (text){
var tbox=this.text_box;
var dummy_tbox=new gtextbox({
width:tbox.width,height:tbox.height,color:tbox.color.slice(),
font_size:tbox.font_size,font_name:tbox.font_name,align:tbox.align,
valign:tbox.valign,margin:tbox.margin,margin_leading:tbox.margin_leading,
text:(typeof text=="string")?text:""
});
return dummy_tbox;};
TextBoxMulti.prototype._insert_to_cursor_pos=function (array_in,text){
var array=array_in;
var latter_half=array.slice(0);
var len=array.length;
array.splice(this.cursor_pos-1,len-this.cursor_pos+1);
latter_half.splice(0,this.cursor_pos-1);
latter_half.unshift(text);
array=array.concat(latter_half);
return array;};
TextBoxMulti.prototype.add_text=function (text){
if(text==""||text==null||typeof text!="string"){
console.log("[ERROR] Add invalid object to TextBox!");}
if(!this.scrollable){
if(this.char_length_limit!=null&&this.char_length_limit>0){
if(this.input_array.length>=this.char_length_limit){
console.log("[ERROR] Over char length limit!");
this.pending_p=false;
return;}
}
}
if(this._is_return_code_by_text(text)>0){
if(this._get_cursor_pos_row()>=this.max_row_num){
return;}
}
var tmp_input_array=this.input_array.slice();
var tmp_cursor_pos=this.cursor_pos;
var tmp_force_caret_tail=this.force_caret_tail;
var res=this._toggle_force_caret_tail(text);
if(!res)
this.call_toggle_force_caret_tail_cb(res);

this.pending_p=true;
if(this.input_array.length==this.cursor_pos
&&this.insert_mode==false){
this.cursor_pos++;
this.input_array.push(text);}else {
this.input_array
=this._insert_to_cursor_pos(this.input_array,text);
this.cursor_pos++;}
if(!this.check_text_over()){
this.input_array=tmp_input_array.slice();
this.cursor_pos=tmp_cursor_pos;
this.force_caret_tail=tmp_force_caret_tail;
return;};
if(this.change_text_hook!=null&&typeof this.change_text_hook=="function"){
this.change_text_hook();}
this._update_view();};

TextBoxMulti.prototype.check_text_over=function (){
var text=this.input_array.slice().join("");
var row_length=this._get_row_length_by_text(text);
if(row_length>this.max_row_num)
return false;
return true;};
TextBoxMulti.prototype.delete_text=function (){
if(this.input_array.length==0){
return;}

this.pending_p=false;
if(this.cursor_pos==this.input_array.length){
this.insert_mode=false;
this.input_array.pop();
this.cursor_pos--;
if(this.cursor_pos<=0){
this.cursor_pos=0;
if(this.empty_hook!=null&&typeof this.empty_hook=="function"){
append_timer(this.empty_hook,1,function(obj,count){
delete_timer(obj);
obj();});}
}
}else {
if(this.input_array[this.cursor_pos-2]){this.input_array.splice(this.cursor_pos-2,1);
this.cursor_pos--;}else {this.input_array.splice(this.cursor_pos-1,1);}
}
if(this.change_text_hook!=null&&typeof this.change_text_hook=="function"){
this.change_text_hook();}
this._update_force_caret_tail();
this._update_view();};
TextBoxMulti.prototype.delete_left_text=function (){
if(this.input_array.length==0){
return;}
this.pending_p=false;
if(this.cursor_pos==this.input_array.length&&
this.insert_mode==false){
this.input_array.pop();
this.cursor_pos--;
if(this.cursor_pos<=0){
this.cursor_pos=0;
if(this.empty_hook!=null&&typeof this.empty_hook=="function"){
append_timer(this.empty_hook,1,function(obj,count){
delete_timer(obj);
obj();});}
}
}else {
if(this.cursor_pos>1){
this.input_array.splice(this.cursor_pos-2,1);
this.cursor_pos--;}else {
this.cursor_pos=1;}
}
if(this.change_text_hook!=null&&typeof this.change_text_hook=="function"){
this.change_text_hook();}
this._update_view();};
TextBoxMulti.prototype.delete_right_text=function (){
if(this.input_array.length==0){
return;}
this.pending_p=false;
if(this.cursor_pos<this.input_array.length){
this.input_array.splice(this.cursor_pos-1,1);
this._update_view();}else if(this.cursor_pos==this.input_array.length&&
this.insert_mode==true){
this.insert_mode=false;
this.input_array.pop();
this.cursor_pos--;
if(this.cursor_pos<=0){
this.cursor_pos=0;
if(this.empty_hook!=null&&typeof this.empty_hook=="function"){
append_timer(this.empty_hook,1,function(obj,count){
delete_timer(obj);
obj();});}
}
this._update_view();
this.cursor_right();}else {
return false;}
if(this.change_text_hook!=null&&typeof this.change_text_hook=="function"){
this.change_text_hook();}
};

TextBoxMulti.prototype.clear=function (){
this.cursor_obj.visible_p=false;
this.cursor_text.visible_p=false;
this.reverse_text_box_bg.visible_p=false;
this.reverse_text_box.visible_p=false;
this.text_box_bg.visible_p=false;
this.init();
setf_text(this.text_box,this.input_array.join(""));};
TextBoxMulti.prototype._toggle_force_caret_tail=function (text){
if(this.rightToLeftToggle||isRight(text)){
if(!this.force_caret_tail)
this.force_caret_tail=true;
if(this.cursor_pos<this.input_array.length)
this.cursor_pos=this.input_array.length;
if(this.insert_mode)
this.insert_mode=false;
return false;}
return true;};
TextBoxMulti.prototype.cursor_left=function (){
if(!this.rightToLeftToggle){
return this._cursor_left();}else {
return this._cursor_right();}
};
TextBoxMulti.prototype._cursor_left=function (){
this.pending_p=false;
var ret=true;
if(this.insert_mode==true){
this.cursor_pos-=1;
if(this.cursor_pos<=0){
this.cursor_pos=1;
ret=false;}
}else if(this.input_array.length==0){
ret=false;}else {
this.insert_mode=true;}
this._update_view();
return ret;}
TextBoxMulti.prototype.cursor_right=function (){
if(!this.rightToLeftToggle){
return this._cursor_right(true);}else {
return this._cursor_left(true);}
};
TextBoxMulti.prototype._cursor_right=function (){
this.pending_p=false;
var text_len=this.input_array.length;
this.cursor_pos+=1;
var ret=true;
if(this.cursor_pos>text_len){
this.cursor_pos=text_len;
if(this.insert_mode==true){
this.insert_mode=false;}else {
ret=false;}
}
this._update_view();

return ret;}
TextBoxMulti.prototype.cursor_up=function (){
return this._cursor_up();};
TextBoxMulti.prototype._cursor_up=function (){
this.pending_p=false;
var ret=false;
var cursor_pos_row=this._get_cursor_pos_row();
if(cursor_pos_row<=1)
return false;
if(this._is_line_head(this.cursor_pos)){
return this._cursor_up_head(cursor_pos_row);}
if(this._is_line_tail(this.cursor_pos)){
return this._cursor_up_tail(cursor_pos_row);}
var up_info=this.row_info_array[cursor_pos_row-2];
if(!up_info)
return false;
var current_row_info=this.row_info_array[cursor_pos_row-1];
var row_ftont_cursor_text=this.input_array.slice(current_row_info.head_pos,this.cursor_pos).join("");
var row_ftont_cursor_text_width=get_text_width(this.text_box,row_ftont_cursor_text);
var c_char=this.input_array[this.cursor_pos-1];
var c_char_width=this._get_char_width(c_char);
var trg_width=Math.floor(row_ftont_cursor_text_width-c_char_width/2);
var up_line_text=this.input_array.slice(up_info.head_pos,current_row_info.head_pos).join("");
var up_line_text_width=get_text_width(this.text_box,up_line_text);
var tmp_index=0;
var head=0,tail=up_line_text.length;
var tmp_text="";
var tmp_text_width=0;
while((tail-head)>1){
tmp_index=Math.floor((tail-head)/2)+head;
tmp_text=up_line_text.slice(0,tmp_index);
tmp_text_width=Math.floor(get_text_width(this.text_box,tmp_text)
-this._get_char_width(tmp_text[tmp_index-1]));
if(trg_width<=tmp_text_width){
tail=tmp_index;}else {
head=tmp_index;}
}
this.cursor_pos=up_info.head_pos+head;
this.insert_mode=true;
ret=true;
this._update_view();

return ret;};
TextBoxMulti.prototype._cursor_up_head=function (cursor_pos_row){
var ri_array=this.row_info_array;
if(!ri_array[cursor_pos_row-2]||ri_array[cursor_pos_row-2].head_pos<0)
return false;
var cur_pos=ri_array[cursor_pos_row-2].head_pos+1;
this.cursor_pos=cur_pos;
this.insert_mode=true;
this._update_view();
return true;};
TextBoxMulti.prototype._cursor_up_tail=function (cursor_pos_row){
var ri_array=this.row_info_array;
if(!ri_array[cursor_pos_row-1]||ri_array[cursor_pos_row-1].head_pos<0)
return false;
var cur_pos=ri_array[cursor_pos_row-1].head_pos;
if(cur_pos<0)
return false;
this.cursor_pos=cur_pos;
this.insert_mode=true;
this._update_view();
return true;};
TextBoxMulti.prototype.cursor_down=function (){
return this._cursor_down();};
TextBoxMulti.prototype._cursor_down=function (){
this.pending_p=false;
var ret=false;
if(!this.insert_mode)
return false;
var cursor_pos_row=this._get_cursor_pos_row();
if(cursor_pos_row>=this.max_row_num){
return false;}
if(this._is_line_head(this.cursor_pos)){
return this._cursor_down_head(cursor_pos_row);}
if(this._is_line_tail(this.cursor_pos)){
return this._cursor_down_tail(cursor_pos_row);}
var down_info=this.row_info_array[cursor_pos_row];
if(!down_info||!down_info.head_pos){
return false;}
var current_row_info=this.row_info_array[cursor_pos_row-1];
var row_ftont_cursor_text=this.input_array.slice(current_row_info.head_pos,this.cursor_pos).join("");
var row_ftont_cursor_text_width=get_text_width(this.text_box,row_ftont_cursor_text);
var c_char=this.input_array[this.cursor_pos-1];
var c_char_width=this._get_char_width(c_char);
var trg_width=Math.floor(row_ftont_cursor_text_width-c_char_width/2);
var down2_info=this.row_info_array[cursor_pos_row+1];
var down_last_line=false;
var down_line_end_pos=0;
if(down2_info&&down2_info.head_pos>0){
down_line_end_pos=down2_info.head_pos;}else {
down_line_end_pos=this.input_array.length;
down_last_line=true;}
var down_line_text=this.input_array.slice(down_info.head_pos,down_line_end_pos).join("");
var down_line_text_width=get_text_width(this.text_box,down_line_text);
if(down_last_line){
if(down_line_text_width<trg_width){
this.cursor_pos=this.input_array.length;
this.insert_mode=false;
ret=true;}
}
if(!ret){
var tmp_index=0;
var head=0,tail=down_line_text.length;
var tmp_text;
while((tail-head)>1){
tmp_index=Math.floor((tail-head)/2)+head;
tmp_text=down_line_text.slice(0,tmp_index);
var tmp_text_width=Math.floor(get_text_width(this.text_box,tmp_text)
-this._get_char_width(tmp_text[tmp_index-1]));
if(trg_width<=tmp_text_width){
tail=tmp_index;}else {
head=tmp_index;}
}
this.cursor_pos=down_info.head_pos+head;
ret=true;}
this._update_view();

return ret;};
TextBoxMulti.prototype._cursor_down_head=function (cursor_pos_row){
var ri_array=this.row_info_array;
if(!ri_array[cursor_pos_row]||ri_array[cursor_pos_row].head_pos==null)
return false;
var cur_pos=ri_array[cursor_pos_row].head_pos+1;
this.cursor_pos=cur_pos;
this.insert_mode=true;
this._update_view();
return true;};
TextBoxMulti.prototype._cursor_down_tail=function (cursor_pos_row){
var ri_array=this.row_info_array;
if(!ri_array[cursor_pos_row+1]||ri_array[cursor_pos_row+1].head_pos==null){
if(this.cursor_pos>this.input_array.length)
return false;
this.cursor_pos=this.input_array.length;
this.insert_mode=false;}else {
var cur_pos=ri_array[cursor_pos_row+1].head_pos;
if(cur_pos<0)
return false;
this.cursor_pos=cur_pos;
this.insert_mode=true;}
this._update_view();
return true;};
TextBoxMulti.prototype._change_cursor_visible=function (obj,target_x,end_func){
if(this.cursor_on){
if(this.insert_mode){
this.cursor_obj.visible_p=true;
this.cursor_text.visible_p=true;
this.end_cursor_obj.visible_p=false;}else {
this.cursor_obj.visible_p=false;
this.cursor_text.visible_p=false;
this.end_cursor_obj.visible_p=true;}
}else {
this.cursor_obj.visible_p=false;
this.cursor_text.visible_p=false;
this.end_cursor_obj.visible_p=false;}
};
TextBoxMulti.prototype._move=function (obj,target_x,end_func){
delete_timer(obj);
var delta=0;
var func=end_func;
append_timer(obj,TIMER_RESOLUTION,
function (obj,count){
delta=(target_x-obj.translate[0])/2;
if(count>=7){
delete_timer(obj);
obj.translate[0]=target_x;
if(func){
func();}
}else {
obj.translate[0]+=delta;}
force_redraw();});}
TextBoxMulti.prototype.free=function (){
this.set_text("");
return;};
TextBoxMulti.prototype.revive=function (){
return;};
TextBoxMulti.prototype.get_text_length=function (){
return this.input_array.length;};
TextBoxMulti.prototype.do_backspace=function (){
this.delete_text();};
TextBoxMulti.prototype.add_linefeed=function (){
var lf_text=this.input_array.join("")+"\n";
if(this.max_row_num<=this._get_row_length_by_text(lf_text))
return;
this.add_text("\n");};
TextBoxMulti.prototype.allclear=function (){
if(this.input_array.length==0){
return;}
this.input_array.splice(0,this.input_array.length);
this.cursor_pos=0;
this.insert_mode=false;
this._update_force_caret_tail();
this._update_view();};
TextBoxMulti.prototype.set_toggle_force_caret_tail_cb=function (func){
this.toggle_force_caret_tail_cb=func;};
TextBoxMulti.prototype.call_toggle_force_caret_tail_cb=function (bool){
if(this.toggle_force_caret_tail_cb
&&typeof this.toggle_force_caret_tail_cb=="function"){
this.toggle_force_caret_tail_cb(bool);}
};
TextBoxMulti.prototype.set_font_size=function (font_size){
this.text_box.font_size=font_size;
this.cursor_text.font_size=font_size;
this.init_font_info();};
TextBoxMulti.prototype.set_font_name=function (font_name){
this.text_box.font_name=font_name;
this.cursor_text.font_name=font_name;};
TextBoxMulti.prototype.set_textarea_color=function (reverse){
var color=this.text_color;
var reverse_color=this.reverse_text_color;
if(reverse){
color=this.reverse_text_color;
reverse_color=this.text_color;}
this.text_box.color=color;
this.cursor_obj.color=color;
this.cursor_text.color=reverse_color;
this.end_cursor_obj.color=color;};

TextBoxMulti.prototype.set_omitter=function (omitter){};

TextBoxMulti.prototype.unset_omitter=function (){};
TextBoxMulti.prototype.set_align=function (align){
this.text_box.align=align;
if(align==RIGHT)
this.rightToLeftToggle=true;
else
this.rightToLeftToggle=false;
setf_text(this.text_box,this.input_array.join(""));};

TextBoxMulti.prototype.set_edit_start_align=function (){
this._update_text_box();};

TextBoxMulti.prototype.set_edit_end__align=function (){};
TextBoxMulti.prototype._is_return_code_by_text=function (text){
var ret=false;
if(text=="\n"){
ret=true;}
return ret;};
TextBoxMulti.prototype._is_line_head=function (cursor_pos){
cursor_pos-=1;
var ri_array=this.row_info_array;
if(this.input_array.length==0)
return true;
for(var i in ri_array){
if(ri_array[i].head_pos==null)
break;
if(ri_array[i].head_pos==cursor_pos)
return true;}
return false;};
TextBoxMulti.prototype._is_line_tail=function (cursor_pos){
cursor_pos-=1;
var ri_array=this.row_info_array;
if(this.input_array.length==0)
return true;
if(cursor_pos==this.input_array.length-1&&!this.insert_mode)
return true;
for(var i in ri_array){
if(ri_array[i].head_pos==null)
break;
if(ri_array[i].head_pos==0&&ri_array[i].head_pos==cursor_pos)
return true;
if(ri_array[i].head_pos-1==cursor_pos)
return true;}
return false;};
var UnconfBG=function(){
this.PADDING=20;
this.translate=[0,0,0];
this.bg_round_enable=true;
this.bg_round_width=4;
this.bg_round_height=4;
this.components=[];};
UnconfBG.prototype=new container({});
UnconfBG.prototype.create=function(param){
this.width=param.unconf_bg_width;
this.height=param.unconf_bg_height;
this.color=param.unconf_bg_color.slice();
this.bg=new gbox({
width:this.width,height:this.height,color:this.color.slice(),
round_enable:this.bg_round_enable,round_width:this.bg_round_width,
round_height:this.bg_round_height
});
this.force_visible=true;
this.visible_p=false;
this.components=[this.bg];};
UnconfBG.prototype.free=function(){
for(var i=0;i<this.components.length;i++){
var comp=this.components[i];
if(comp&&comp.free&&typeof comp.free=="function")
comp.free();}
this.components.splice(0,this.components.length);};
UnconfBG.prototype.set_param=function(param){
param=param||{};
if(typeof param.width=="number"){
this.width=param.width;
this.bg.width=this.width;}
if(typeof param.height=="number"){
this.height=param.height;
this.bg.height=this.height;}
if(typeof param.color=="object"){
this.color=param.color.slice();
this.bg.color=this.color.slice();}
if(typeof param.round_enable=="boolean"){
this.bg_round_enable=param.round_enable;
this.bg.round_enable=this.bg_round_enable;}
if(typeof param.round_width=="number"){
this.bg_round_width=param.round_width;
this.bg.round_width=this.bg_round_width;}
if(typeof param.round_height=="number"){
this.bg_round_height=param.round_height;
this.bg.round_height=this.bg_round_height;}
if(typeof param.force_visible=="boolean"){
this.force_visible=param.force_visible;}
if(param.bg_obj!=undefined){
this.bg=param.bg_obj;
this.components=[this.bg];}
};
UnconfBG.prototype.set_trans_y=function(y){
if(typeof y!="number")
return;
var tran=this.translate.slice();
tran[1]=y;
this.translate=tran;};
UnconfBG.prototype.show=function(){
if(!this.force_visible)
return;
this.set_visible(true);};
UnconfBG.prototype.hide=function(){
this.set_visible(false);};
UnconfBG.prototype.set_visible=function(bool){
if(this.visible_p!=bool)
this.visible_p=bool;};
var ScrollBar=function(){};
ScrollBar.prototype=new container({});
ScrollBar.prototype.create=function(param){
this.width=(param.scroll_bar_width!=undefined)?param.scroll_bar_width:16;
this.height=(param.scroll_bar_height!=undefined)?param.scroll_bar_height:param.height;
this.translate=[(param.width+this.width)/2,0,0];
this.in_row_num=this.out_row_num=this.row_pos=1;
this.bg_color=(param.scroll_bar_bg_color!=undefined)?param.scroll_bar_bg_color:[255,255,255,255];
this.scr_color=(param.scroll_bar_scr_color!=undefined)?param.scroll_bar_scr_color:[33,33,33,255];
var ar_size=Math.floor(this.width/2);
this.ar_top=new gpolygon({
vertex:[-ar_size,-ar_size,0,ar_size,-ar_size,0,0,ar_size,0],
color:this.scr_color,translate:[0,(this.height-this.width)/2,0]
});
this.ar_bottom=new gpolygon({
vertex:[-ar_size,ar_size,0,0,-ar_size,0,ar_size,ar_size,0],
color:this.scr_color,translate:[0,-(this.height-this.width)/2,0]
});
this.bg=new gbox({width:Math.floor(this.width/2),height:this.height-this.width*3,color:this.bg_color});
this.scr=new gbox({width:Math.floor(this.width/2),height:this.height-this.width*3,color:this.scr_color});
this.components=[this.ar_top,this.ar_bottom,this.bg,this.scr];};
ScrollBar.prototype.free=function(){
for(var i=0;i<this.components.length;i++){
var comp=this.components[i];
if(comp&&comp.free&&typeof comp.free=="function")
comp.free();}
this.components.splice(0,this.components.length);};
ScrollBar.prototype.set_in_row_num=function(row_num){
if(typeof row_num=="number"){
this.in_row_num=row_num;
this.update(this.out_row_num,this.row_pos);}
};
ScrollBar.prototype.update=function(out_row_num,row_pos){
if(typeof out_row_num!="number"||typeof row_pos!="number")
return;
if(this.out_row_num==out_row_num&&this.row_pos==row_pos)
return;
this.out_row_num=out_row_num;
this.row_pos=row_pos;
if(this.out_row_num<=this.in_row_num){
this.scr.height=this.bg.height;
this.scr.translate[1]=0;
return;}
this.scr.height=Math.floor(this.bg.height/ (this.out_row_num /this.in_row_num));
if(this.scr.height<10)
this.scr.height=10;
var inner_h=this.bg.height-this.scr.height;
var scr_top_y=inner_h/2;
var scr_pos=this.row_pos-1;
if(scr_pos<0)
scr_pos=0;
var rate=(scr_pos/(this.out_row_num-this.in_row_num));
if(rate>1)rate=1;
this.scr.translate[1]=scr_top_y-inner_h*rate;};
function isArabicNumber(c){
var code=c.charCodeAt();
if((0x0600<=code&&code<=0x0604)
||(0x0660<=code&&code<=0x0669)
||(0x066B<=code&&code<=0x066C)
||(0x06DD==code))
return true;
return false;};
function isNonspacingMark(c){
var code=c.charCodeAt();
if((0x0610<=code&&code<=0x0614)
||(0x0615<=code&&code<=0x061A)
||(0x06D6<=code&&code<=0x06DC)
||(0x06DF<=code&&code<=0x06E4)
||(0x06E7<=code&&code<=0x06ED)
||(0x0616==code)
||(0x064B<=code&&code<=0x065F)
||(0x0670==code))
return true;
return false;};
function isOtherArabic(c){
var code=c.charCodeAt();
if((0x0606<=code&&code<=0x0607)
||(0x0609==code)
||(0x060A==code)
||(0x060C==code)
||(0x066A==code)
||(0x060E<=code&&code<=0x0614)
||(0x066E<=code&&code<=0x0670)
||(0x06F0<=code&&code<=0x06F9))
return true;
return false;};
function isRight(c){
if(!c)return false;
if((get_text_align(c)==RIGHT))return true;
if(isArabicNumber(c))return true;
if(isNonspacingMark(c))return true;
if(isOtherArabic(c))return true;
return false;};
provide("textarea");
