var app_name="0387878700140020";
var js_path=APPLI_PATH+app_name+"/gadget/";
var png_path=js_path;

add_package_load_path("calendar_util",js_path+"calendar_util.js");
add_package_load_path("calendar_obj",js_path+"calendar_obj.js");
require("calendar_util");
require("calendar_obj");
var CL_MSG=load_pkg_lang(js_path+"lang",app_name);
var COUNTRY=system.locale.country;
var skin_path=js_path+"pkg_keyboard_skin.js";
var OAUTH_URL="https://accounts.google.com/o/oauth2/";
var CALENDAR_API_URL="https://www.googleapis.com/calendar/v3/";
var SCOPE="https://www.googleapis.com/auth/calendar%20https://www.googleapis.com/auth/calendar.readonly%20https://www.googleapis.com/auth/userinfo.profile";
var NVRAM_CALENDAR="calendar_info";
var LOGIN="1";
var LOGOUT="0";
var GOOGLE="Google";
var DEFAULT="Default";
var AM="AM";
var PM="PM";
var MAX_CALENDAR_VALUE=5;
var MAX_ACCOUNT_VALUE=5;
var HALF_MONTH=15;
var HALF_DAY_HOUR=12;
var ADVANCE_MONTH=2;
var SUMMARY=0;
var START_TIME=1;
var END_TIME=2;
var ALLDAY=3;
var DESCRIPTION=4;
var CALENDAR_LIST=5;
var OK=6;
var CANCEL=7;
require("textarea");
var SETTING_KEY;
var UPDATE_KEY;
var CHANGE_KEY;
if(COUNTRY=="JP"){
SETTING_KEY={"symbol":TXK_YELLOW,"image":png_path+"rem_guide_yellow.png"};
UPDATE_KEY={"symbol":TXK_GREEN,"image":png_path+"rem_guide_green.png"};
CHANGE_KEY={"symbol":TXK_RED,"image":png_path+"rem_guide_red.png"};}else {
SETTING_KEY={"symbol":TXK_BLUE,"image":png_path+"rem_guide_blue.png"};
UPDATE_KEY={"symbol":TXK_YELLOW,"image":png_path+"rem_guide_yellow.png"};
CHANGE_KEY={"symbol":TXK_GREEN,"image":png_path+"rem_guide_green.png"};}
var is_ampm=(system.locale.country=="US"||system.locale.country=="AU");
function getFontSizeOfText(obj,text,min_font_size){
var w=obj.width;
var orig_size=obj.font_size;
for(var s=orig_size;s>min_font_size;s--){
var l=get_text_width(obj,text);
if(l<w){
break;}else {
obj.font_size=s;}
}
obj.font_size=orig_size;
return s;};
function rfc_3339_format(full_day){
if(!full_day||isNaN(full_day))return "";
var zero_digit=function(num){
return num<10?"0"+num:num;};
return full_day.getFullYear()+"-"
+zero_digit(full_day.getMonth()+1)+"-"
+zero_digit(full_day.getDate())+"T"
+zero_digit(full_day.getHours())+":"
+zero_digit(full_day.getMinutes())+":"
+zero_digit(full_day.getSeconds())+"Z";};
function make_allday_format(full_day){
if(!full_day||isNaN(full_day))return "";
var zero_digit=function(num){
return num<10?"0"+num:num;};
return full_day.getFullYear()+"-"
+zero_digit(full_day.getMonth()+1)+"-"
+zero_digit(full_day.getDate());};

var set_cursor=function(sobj,cobj){
var old=sobj.cursor;
if(old==cobj)return;
if(old){
if(old.leave_focus)old.leave_focus(old);
old.in_cursor=false;
old.toggle_cursor=false;}
if(cobj){
if(cobj.enter_focus)cobj.enter_focus(cobj);
cobj.in_cursor=true;}
sobj.cursor=cobj;};
var nvram_manager={};
nvram_manager.read=function(){
var read_data="";
try{
var ret=apps_nvram_file.read({
filename:NVRAM_CALENDAR,
async:false,
finished:function(){},
product_id:"home"
});
ret=sysutil.tconv.binary_to_string(ret);
read_data=eval(ret);}catch(e){
console.log("nvram_file read unsuccessful");}
return read_data;};
nvram_manager.write=function(write_data){
if(!write_data)return;
try{
apps_nvram_file.write({
filename:NVRAM_CALENDAR,
data:write_data.toSource(),
async:false,
product_id:"home"
});}catch(e){
console.log("nvram_file write unsuccesful");}
};
nvram_manager.write_account=function(account){
if(!account)return;
var read_data=this.read();
var update=false;
var update_index=-1;
if(read_data.account_data&&read_data.account_data.length>0){
for(var i=0;i<read_data.account_data.length;i++){
read_data.account_data[i].login_status=LOGOUT;}
for(var i=0;i<read_data.account_data.length;i++){
if(read_data.account_data[i].summary==account.summary){
update=true;
update_index=i;
break;}
}
if(update&&update_index>-1){
this.update_account(read_data,update_index,account);}else {
this.add_account(read_data,account);}
}else {
this.add_account(read_data,account);}
};
nvram_manager.add_account=function(read_data,add_account){
if(!read_data||!add_account)return;
if(read_data.account_data){
read_data.account_data.push(add_account);}else {
read_data.account_data=[];
read_data.account_data.push(add_account);}
this.write(read_data);};
nvram_manager.update_account=function(read_data,update_index,param){
if(!read_data||update_index<0||!param)return;
if(param.summary)read_data.account_data[update_index].summary=param.summary;
if(param.access_token)read_data.account_data[update_index].access_token=param.access_token;
if(param.refresh_token)read_data.account_data[update_index].refresh_token=param.refresh_token;
if(param.login_status)read_data.account_data[update_index].login_status=param.login_status;
this.write(read_data);};
nvram_manager.remove_account=function(del_index){
if(del_index<0)return;
var read_data=this.read();
if(read_data&&read_data.account_data){
read_data.account_data.splice(del_index,1)
}
this.write(read_data);};
nvram_manager.get_login_data=function(){
var account_data=this.read_account_data();
var login_data="";
for(var i=0;i<account_data.length;i++){
if(account_data[i].login_status==LOGIN){
login_data=account_data[i];}
}
return login_data;};
nvram_manager.read_account_data=function(){
var account_data="";
var read_data=this.read();
if(read_data.account_data){
account_data=read_data.account_data;}
return account_data;};
nvram_manager.write_mode=function(mode){
var read_data=this.read();
if(!read_data)return;
read_data.mode=mode;
this.write(read_data);};
nvram_manager.read_mode=function(){
var mode=DEFAULT;
var read_data=this.read();
if(read_data&&read_data.mode)mode=read_data.mode;
return mode;};
var google_calendar={
http_req:0,
client_id:"616672080153.apps.googleusercontent.com",
client_secret:"6kAV-SpanqwnFJNbYTC8PC5_",
scope:SCOPE,
grant_type:"http://oauth.net/grant_type/device/1.0",
calendar_list:[],
calendar_data:[],
get_index:0,
};
google_calendar.add_error=function(error_code){
if(!error_code)error_code=404;
this.polling_stop();
set_cursor(sobj,account_list);
account_list.close_link_panel();
notice_panel.show({
title:CL_MSG("LT_CL_ADD_FAILED"),
description:CL_MSG("LT_LD_NETWORK_ERROR")+"("+error_code+")",
});
this.init();};
google_calendar.login_error=function(){
account_list.logout();
this.init();};
google_calendar.oAuthRequest=function(param){
var self=this;
var get_callback=param.get_callback||function(){};
var error_callback=param.error_callback||function(){};
this.http_req=http_request({
method:"POST",
url:OAUTH_URL+"device/code?client_id="+self.client_id+"&scope="+self.scope,
limit_mode:LIMIT_NONE,
sync:false,
onload:function(status,header,body){
self.http_req=0;
if(status==200){
var data={};
try{
data=JSON.parse(body);
get_callback(data);}catch(e){
error_callback(status);}
}else {
error_callback(status);}
}
});};
google_calendar.link_polling=function(device_code){
append_timer(this,5000,function(obj,count){
obj.get_access_token(device_code);});};
google_calendar.polling_stop=function(){
delete_timer(this);};
google_calendar.request_cancel=function(){
if(this.http_req){
cancel_http_request(this.http_req);
this.init();}
};
google_calendar.init=function(){
this.http_req=0;
this.calendar_list=[];
this.calendar_data=[];
this.get_index=0;};
google_calendar.get_access_token=function(device_code){
this.request_cancel();
var self=this;
var post_body="client_id="+self.client_id;
post_body+="&client_secret="+self.client_secret;
post_body+="&code="+device_code;
post_body+="&grant_type="+self.grant_type;
this.http_req=http_request({
method:"POST",
url:OAUTH_URL+"token",
limit_mode:LIMIT_NONE,
body:post_body,
sync:false,
onload:function(status,header,body){
self.http_req=0;
if(status==200){
try{
var data=JSON.parse(body);
if(data.access_token){
account_list.close_link_panel();
TopBar.set_account_text("");
loading.show();
full_calendar_obj.sch_obj.google_reset();
self.polling_stop();
self.get_account_calendar({
access_token:data.access_token,
refresh_token:data.refresh_token,
get_callback:function(access_token,user_id){
google_calendar.get_user_info({
access_token:access_token,
user_id:user_id,
callback:function(){
account_list.set_account_item();
account_list.google_select();
set_cursor(sobj,account_list);
loading.hide();}
});},
error_callback:function(error_code){
loading.hide();
set_cursor(sobj,account_list);
notice_panel.show({
title:CL_MSG("LT_CL_ADD_FAILED"),
description:CL_MSG("LT_LD_NETWORK_ERROR")+"("+error_code+")",
});
self.init();}
});}
}catch(e){
self.add_error(status);}
}else {
self.add_error(status);}
}
});};
google_calendar.refresh_access_token=function(refresh_token,refresh_callback,error_callback){
this.request_cancel();
if(!refresh_token)return;
var self=this;
var post_body="refresh_token="+refresh_token;
post_body+="&client_id="+self.client_id;
post_body+="&client_secret="+self.client_secret;
post_body+="&grant_type=refresh_token";
this.http_req=http_request({
method:"POST",
url:OAUTH_URL+"token",
limit_mode:LIMIT_NONE,
body:post_body,
sync:false,
onload:function(status,header,body){
self.http_req=0;
if(status==200){
try{
var data=JSON.parse(body);
if(data&&data.access_token&&refresh_callback){
refresh_callback(data.access_token,refresh_token);}
}catch(e){
if(error_callback)error_callback(status);}
}else {
if(error_callback)error_callback(status);}
}
});};
google_calendar.get_account_calendar=function(param){
if(!param)return;
this.request_cancel();
var access_token=param.access_token;
var refresh_token=param.refresh_token;
if(!access_token||!refresh_token)return;
var self=this;
var error_callback=param.error_callback||function(){};
var header=[["Authorization","Bearer"+" "+access_token]];
this.http_req=http_request({
method:"GET",
url:CALENDAR_API_URL+"users/me/calendarList?"+"minAccessRole=owner&fields=items(id,primary,summary,timeZone,backgroundColor)",
limit_mode:LIMIT_NONE,
header:header,
sync:false,
onload:function(status,header,body){
self.http_req=0;
if(status==200){
try{
var data=JSON.parse(body);
var cal_list=[];
for(var i=0;i<data.items.length;i++){
var cal_info={};
cal_info.calendar_id=data.items[i].id;
cal_info.color=data.items[i].backgroundColor;
cal_info.calendar_name=data.items[i].summary;
cal_info.timeZone=data.items[i].timeZone;
if(data.items[i].primary){
cal_list.unshift(cal_info);}else {
cal_list.push(cal_info);}
}
if(cal_list.length>0){
if(cal_list.length>MAX_CALENDAR_VALUE){
self.calendar_list=cal_list.slice(0,MAX_CALENDAR_VALUE);}else {
self.calendar_list=cal_list;}
if(self.calendar_list[0].calendar_id==self.calendar_list[0].calendar_name){
var topbar_name=TopBar.get_account_name();
if(topbar_name)self.calendar_list[0].calendar_name=topbar_name;}
self.get_calendar_info({
access_token:access_token,
refresh_token:refresh_token,
get_callback:param.get_callback,
error_callback:error_callback,
});}
}catch(e){
self.login_error();
error_callback(status);}
}else if(status==401){
self.refresh_access_token(refresh_token,function(new_token,refresh_token){
self.get_account_calendar({
access_token:new_token,
refresh_token:refresh_token,
get_callback:param.get_callback,
error_callback:error_callback,
});},error_callback);}else {
self.login_error();
error_callback(status);}
}
});};
google_calendar.get_calendar_info=function(param){
if(!param)return;
this.request_cancel();
var access_token=param.access_token;
var refresh_token=param.refresh_token;
var get_callback=param.get_callback;
var error_callback=param.error_callback;
var calendar_id=this.calendar_list[this.get_index].calendar_id;
var header=[["Authorization","Bearer"+" "+access_token]];
var self=this;
var first_day=this.get_first_day();
var last_day=this.get_last_day();
var timeMin=first_day?"timeMin="+first_day+"&":"";
var timeMax=last_day?"timeMax="+last_day+"&":"";
var timeZone=this.calendar_list[0].timeZone;
this.http_req=http_request({
method:"GET",
url:CALENDAR_API_URL+"calendars/"+calendar_id+"/events?"+timeMin+timeMax+
"timeZone="+timeZone+"&"+"singleEvents=true&orderBy=startTime"+
"&fields=items",
limit_mode:LIMIT_NONE,
header:header,
sync:false,
onload:function(status,header,body){
self.http_req=0;
if(status==200){
try{
var data=JSON.parse(body);
self.addGoogleData(data.items);
self.get_index++;
if(self.calendar_list[self.get_index]){
self.get_calendar_info({
access_token:access_token,
refresh_token:refresh_token,
get_callback:get_callback,
});}else {
full_calendar_obj.sch_obj.addGoogleSchedule(self.calendar_data);
full_calendar_obj.sch_obj.addCalendarList(self.calendar_list);
var summary=self.calendar_list[0].calendar_id;
nvram_manager.write_account({"summary":summary,"access_token":access_token,
"refresh_token":refresh_token,"login_status":LOGIN});
full_calendar_obj.sch_obj.setGooglemark();
if(get_callback)get_callback(access_token,summary);
full_calendar_obj.sch_obj.set_tab(true);
full_calendar_obj.sch_obj.refreshSchedule();
self.init();}
}catch(e){
self.login_error();
if(error_callback)error_callback(status);}
}else if(status==401){
self.refresh_access_token(refresh_token,function(new_token,refresh_token){
self.get_calendar_info(new_token,refresh_token);},error_callback);}else {
self.login_error();
if(error_callback)error_callback(status);}
}
});};
google_calendar.get_first_day=function(date){
var first_day=full_calendar_obj.sch_obj.cal_obj.get_first_day();
var date=new Date(first_day);
if(isNaN(date))return "";
date.setHours(-HALF_DAY_HOUR);
return rfc_3339_format(date);};
google_calendar.get_last_day=function(date){
var last_day=full_calendar_obj.sch_obj.cal_obj.get_last_day();
var date=new Date(last_day);
if(isNaN(date))return "";
var two_next_month=date.getMonth()+ADVANCE_MONTH;
date.setMonth(two_next_month);
date.setDate(HALF_MONTH);
return rfc_3339_format(date);};
google_calendar.addGoogleData=function(items){
if(!items||items.length==0)return;
var rep_date_func=function(time){
var format_time;
if(time){
if(time.dateTime){
format_time=time.dateTime.toString().replace("T"," ").substr(0,16).replace(/-/g,"/");}else if(time.date){
format_time=time.date.toString().replace(/-/g,"/")+" "+"00:00";}
}
return format_time;};
for(var i=0;i<items.length;i++){
var sch_data={};
sch_data.calendar_id=this.calendar_list[this.get_index].calendar_id;
sch_data.calendar_name=this.calendar_list[this.get_index].calendar_name;
sch_data.bg_color=this.calendar_list[this.get_index].color;
sch_data.start_date=rep_date_func(items[i].start);
sch_data.end_date=rep_date_func(items[i].end);
sch_data.timeZone=this.calendar_list[0].timeZone;
sch_data.items=items[i];
this.calendar_data.push(sch_data);};};
google_calendar.delete_schedule=function(param){
if(!param)return;
loading.show();
var calendar_id=param.calendar_id;
var event_id=param.event_id;
var notification=param.notification||false;
var login_account=nvram_manager.get_login_data();
var access_token=login_account.access_token;
var refresh_token=login_account.refresh_token;
var callback=param.callback||function(){};
var error_callback=param.error_callback||function(){};
var header=[["Authorization","Bearer"+" "+access_token]];
var scope="scope=https://www.googleapis.com/auth/calendar"
var self=this;
this.http_req=http_request({
method:"DELETE",
url:CALENDAR_API_URL+"calendars/"+calendar_id+"/events/"+event_id+"?sendNotifications="+notification+"&"+scope,
limit_mode:LIMIT_NONE,
header:header,
onload:function(status,header,body){
self.http_req=0;
if(status==204){
console.log("Schedule delete COMPLETE!!");
callback();
loading.hide();}else if(status==401){
self.refresh_access_token(refresh_token,function(new_token,refresh_token){
nvram_manager.write_account({
"summary":login_account.summary,"access_token":new_token,
"refresh_token":refresh_token,"login_status":LOGIN
});
self.delete_schedule({
calendar_id:calendar_id,
event_id:event_id,
notification:notification,
callback:callback,
error_callback:error_callback
});},error_callback);}else {
error_callback(status);
loading.hide();
console.log("Schedule delete unsuccesful");}
}
});};
google_calendar.update=function(param){
var login_account=nvram_manager.get_login_data();
if(login_account){
if(param.start_action)param.start_action();
this.request_cancel();
this.get_account_calendar({
access_token:login_account.access_token,
refresh_token:login_account.refresh_token,
get_callback:param.get_callback,
error_callback:function(error_code){
full_calendar_obj.sch_obj.loading_view(false);
notice_panel.show({
title:CL_MSG("LT_CL_READ_ERROR"),
description:CL_MSG("LT_LD_NETWORK_ERROR")+"("+error_code+")",
});}
});}
};
google_calendar.get_user_info=function(param){
if(!param)return;
var self=this;
var header=[["Authorization","Bearer"+" "+param.access_token]];
var name=param.user_id||"";
this.request_cancel();
this.http_req=http_request({
method:"GET",
url:"https://www.googleapis.com/oauth2/v2/userinfo",
limit_mode:LIMIT_NONE,
header:header,
sync:false,
onload:function(status,header,body){
self.http_req=0;
try{
if(status==200){
var data=JSON.parse(body);
if(data.name)name=data.name;}else {
console.log("Get UserName unsuccesful.");}
}catch(e){
console.log("Get UserName unsuccesful.");}
TopBar.set_account_text(name);
full_calendar_obj.sch_obj.update_primary_name(name);
if(param.callback)param.callback();}
});};
google_calendar.make_post_body=function(param){
if(!param.end||!param.start)return "";
var body={};
var end={};
var start={};
if(param.all_day){
end.date=make_allday_format(new Date(param.end));
body.end=end;
start.date=make_allday_format(new Date(param.start));
body.start=start;}else {
end.dateTime=rfc_3339_format(new Date(param.end));
end.dateTime=end.dateTime.replace("Z","");
if(param.end_tz){
end.timeZone=param.end_tz;}else if(param.timeZone){
end.timeZone=param.timeZone;}
body.end=end;
start.dateTime=rfc_3339_format(new Date(param.start));
start.dateTime=start.dateTime.replace("Z","");
if(param.start_tz){
start.timeZone=param.start_tz;}else if(param.timeZone){
start.timeZone=param.timeZone;}
body.start=start;}
if(param.summary)body.summary=param.summary;
if(param.description)body.description=param.description;
if(param.sequence)body.sequence=param.sequence+2;
return body;};
google_calendar.create_schedule=function(param){
if(!param)return;
full_calendar_obj.sch_obj.loading_view(true);
var self=this;
var login_account=nvram_manager.get_login_data();
var access_token=login_account.access_token;
var refresh_token=login_account.refresh_token;
var header=[["Authorization","Bearer"+" "+access_token],
["Content-Type","application/json"]];
var method=param.method||"POST";
var post_body=this.make_post_body({
all_day:param.all_day,
start:param.start,end:param.end,
timeZone:param.timeZone,
summary:param.summary,
description:param.description,
});
var calendar_id=param.destination||"";
var create_callback=param.create_callback||function(){};
var error_callback=param.error_callback||function(){};
this.request_cancel();
this.http_req=http_request({
method:method,
url:CALENDAR_API_URL+"calendars/"+calendar_id+"/events?",
limit_mode:LIMIT_NONE,
header:header,
body:JSON.stringify(post_body),
sync:false,
onload:function(status,header,body){
self.http_req=0;
if(status==200){
if(param.create_callback)param.create_callback();}else if(status==401){
self.refresh_access_token(refresh_token,function(new_token,refresh_token){
nvram_manager.write_account({
"summary":login_account.summary,"access_token":new_token,
"refresh_token":refresh_token,"login_status":LOGIN
});
self.create_schedule(param);},error_callback);}else {
error_callback(status);}
}
});};
google_calendar.edit_schedule=function(param){
if(!param)return;
full_calendar_obj.sch_obj.loading_view(true);
var self=this;
var login_account=nvram_manager.get_login_data();
var access_token=login_account.access_token;
var refresh_token=login_account.refresh_token;
var header=[["Authorization","Bearer"+" "+access_token],
["Content-Type","application/json"]];
var destination=param.destination||"";
var belong=param.belong||"";
var post_body=param.post_body||"";
var event_id=post_body.id?"/"+post_body.id:"";
var edit_callback=param.edit_callback||function(){};
var error_callback=param.error_callback||function(){};
this.request_cancel();
this.http_req=http_request({
method:"PUT",
url:CALENDAR_API_URL+"calendars/"+belong+"/events"+event_id+"?",
limit_mode:LIMIT_NONE,
header:header,
body:JSON.stringify(post_body),
sync:false,
onload:function(status,header,body){
self.http_req=0;
if(status==200){
if(event_id&&belong&&destination!=belong){
self.move_schedule({
login_account:login_account,
access_token:access_token,
refresh_token:refresh_token,
event_id:event_id,
calendar_id:belong,
destination:destination,
move_callback:edit_callback,
error_callback:error_callback,
});}else {
edit_callback();}
}else if(status==401){
self.refresh_access_token(refresh_token,function(new_token,refresh_token){
nvram_manager.write_account({
"summary":login_account.summary,"access_token":new_token,
"refresh_token":refresh_token,"login_status":LOGIN
});
self.edit_schedule(param);},error_callback);}else {
error_callback(status);}
}
});};
google_calendar.move_schedule=function(param){
if(!param)return;
var self=this;
var header=[["Authorization","Bearer"+" "+param.access_token]];
var refresh_token=param.refresh_token||"";
var calendar_id=param.calendar_id||""
var event_id=param.event_id||"";
var destination=param.destination||"";
var move_callback=param.move_callback||function(){};
var error_callback=param.error_callback||function(){};
this.request_cancel();
this.http_req=http_request({
method:"POST",
url:CALENDAR_API_URL+"calendars/"+calendar_id+"/events"+event_id+"/move?"+
"destination="+destination,
limit_mode:LIMIT_NONE,
header:header,
onload:function(status,header,body){
self.http_req=0;
if(status==200){
move_callback();}else if(status==401){
var login_account=param.login_account;
self.refresh_access_token(refresh_token,function(new_token,refresh_token){
nvram_manager.write_account({
"summary":login_account.summary,"access_token":new_token,
"refresh_token":refresh_token,"login_status":LOGIN
});
self.move_schedule(param);},error_callback);}else {
full_calendar_obj.sch_obj.loading_view(false);
error_callback(status);}
}
});};
var loading=new container({visible_p:false});
loading.create=function(){
this.components=[
this.shade=new gbox({
width:1920,height:1080,
color:[0,0,0,200]
}),
this.circle=new gimage({
width:150,height:150,
src:png_path+"loading_circle.png",
color:[129,142,149,255],
rotation:[0,0,0,1],
}),
this.login_text=new gtext({
width:500,translate:[0,-100,0],
font_size:50,align:CENTER
})
];
this.login_text.font_size=getFontSizeOfText(this.login_text,CL_MSG("LT_CL_LOADING"),40);
setf_text(this.login_text,CL_MSG("LT_CL_LOADING"));};
loading.enter_focus=function(){
};
loading.leave_focus=function(){
};
loading.appear=function(){
this.create();};
loading.show=function(){
set_cursor(sobj,this);
this.visible_p=true;
this.animation();};
loading.animation=function(){
var self=this;
append_timer(this,100,function(obj,count){
self.circle.rotation[0]-=30;
force_redraw();});};
loading.hide=function(){
if(this.visible_p){
this.visible_p=false;
delete_timer(this);
this.circle.rotation[0]=0;}
};
loading.disappear=function(){
this.free();};
loading.free=function(){
this.circle.src="";
setf_text(this.login_text,"");};
loading.key_hook=function(up_down,key){
return true;};
var account_list=new container({});
account_list.create=function(){
this.translate=[1050,-42,0];
this.index=-1;
this.mode=DEFAULT;
this.focus=new Focus();
this.focus.setShow(false);
this.focus.setTranslate(0,340,0);
this.item=new container({});
this.view_item=new container({});
this.login_index=-1;
this.open=false;
this.key_lock=false;
this.components=[
this.center=new gimage({
width:460,height:1000,
src:png_path+"card_bg.png",
draw_type:DIRECT,
}),
this.left=new gimage({
width:50,height:1000,
translate:[-(460/2+50/2),0,0],
src:png_path+"card_bg_l.png",
draw_type:DIRECT,
}),
this.right=new gimage({
width:50,height:1000,
translate:[460/2+50/2,0,0],
src:png_path+"card_bg_r.png",
draw_type:DIRECT,
}),
this.list_bg=new gbox({
width:430,height:350,
translate:[0,100,0],
}),
this.title=new gtext({
width:460,
translate:[0,438,0],
color:[104,96,80,255],
font_size:45,align:CENTER,
text:CL_MSG("LT_CL_SETTING2"),
}),
this.addBtn=new calendar_util.Btn({
width:340,height:62,
font_size:28,align:CENTER,
translate:[0,340,0],
text:CL_MSG("LT_CL_ADD_ACCOUNT")
}),
this.under_left_bg=new gimage({
width:50,height:1000,
src:png_path+"memo_bg_l.png",
translate:[-(450/2+50/2),-700,0],
draw_type:DIRECT,
}),
this.under_center_bg=new gimage({
width:450,height:1000,
src:png_path+"memo_bg.png",
translate:[0,-700,0],
draw_type:DIRECT,
}),
this.under_right_bg=new gimage({
width:50,height:1000,
src:png_path+"memo_bg_r.png",
translate:[450/2+50/2,-700,0],
draw_type:DIRECT,
}),
this.select=new gtext({
width:460,translate:[0,-262,0],
color:[104,96,80,255],
font_size:36,align:CENTER,
text:CL_MSG("LT_CL_SELECT_TAB"),
}),
this.view_bg=new gbox({
width:430,height:140,
translate:[0,-390,0],
}),
this.item,
this.view_item,
this.term_button=new calendar_util.Btn({
width:430,height:60,
font_size:30,align:CENTER,
translate:[0,-160,0],
}),
this.focus,
this.edit_popup=account_edit_popup,
];
this.title.font_size=getFontSizeOfText(this.title,this.title.text,15);
setf_text(this.title,this.title.text);
if(COUNTRY=="JP"){
this.term_button.setText("本アプリケーション利用規約");}else if(is_china){
this.term_button.setText("使用条款");}else {
this.term_button.setText("Terms of use");}
this.set_account_item();
this.set_view_item();
this.link_panel=device_link_panel;
this.moveTo=MoveTo;};
account_list.appear=function(){
this.create();
this.edit_popup.create();
this.link_panel.create();};
account_list.show=function(){
set_cursor(sobj,this);
this.open=true;
if(full_calendar_obj.sch_obj.edit_mode){
full_calendar_obj.sch_obj.focus.setShow(false);
full_calendar_obj.sch_obj.guide_view(false);}else {
full_calendar_obj.sch_obj.cal_obj.offFocus();}
this.move_focus(this.index);
full_calendar_obj.moveTo({x:-360,y:0,z:0,end_func:null});};
account_list.hide=function(){
this.open=false;
this.key_lock=false;
if(full_calendar_obj.sch_obj.edit_mode){
full_calendar_obj.sch_obj.focus.setShow(true);
full_calendar_obj.sch_obj.guide_view(true);}else {
full_calendar_obj.sch_obj.cal_obj.onFocus();}
set_cursor(sobj,null);
full_calendar_obj.moveTo({x:0,y:0,z:0,end_func:null});};
account_list.close_link_panel=function(){
if(this.link_panel.visible_p)this.link_panel.hide();};
account_list.disappear=function(){
this.edit_popup.free();
this.item_free();
this.mode_view_free();
this.link_panel.free();
this.free();};
account_list.free=calendar_util.FREE_FUNC;
account_list.item_free=function(){
for(var i=0;i<this.item.components.length;i++){
this.item.components[i].free();}
this.item.components=[];};
account_list.mode_view_free=function(){
for(var i=0;i<this.view_item.components.length;i++){
this.view_item.components[i].free();}
this.view_item.components=[];};
account_list.set_account_item=function(){
this.item_free()
var account_data=nvram_manager.read_account_data();
if(!account_data||account_data.length<1)return;
var self=this;
this.login_index=-1;
for(var i=0;i<account_data.length;i++){
var y=240-i*70;
var line_view=true;
var login=false;
if(account_data[i].login_status==LOGIN){
this.login_index=i;
login=true;}
if(i==(MAX_ACCOUNT_VALUE-1))line_view=false;
this.item.components.push(
new list_item({
width:430,height:70,
icon_width:40,icon_height:40,
translate:[0,y,0],text:account_data[i].summary,
line:line_view,choice:login,
})
);}
};
account_list.google_select_action=function(){
var account_data=nvram_manager.read_account_data();
if(account_data&&account_data.length){
var login_account=nvram_manager.get_login_data();
if(!login_account){
var self=this;
notice_panel.show({
title:CL_MSG("LT_CL_DO_LOGIN"),
description:"",
});}else {
this.google_select();
google_calendar.update({
start_action:function(){
full_calendar_obj.sch_obj.loading_view(true);},
get_callback:function(){
full_calendar_obj.sch_obj.loading_view(false);}
});}
}else {
var self=this;
notice_panel.show({
title:CL_MSG("LT_CL_DO_ADD"),
description:"",
});}
};
account_list.set_view_item=function(){
var self=this;
this.view_item.components=[
this.default_mode=new mode_view_item({
translate:[0,-355,0],
check_pos:[-175,0,0],
text:CL_MSG("LT_CL_MEMO"),
line:true,icon:png_path+"sch_mark_large.png",
action:function(){
self.default_select();}
}),
this.google_mode=new mode_view_item({
translate:[0,-426,0],
check_pos:[-175,0,0],
text:CL_MSG("LT_CL_GOOGLE_CAL"),
line:false,icon:png_path+"google_logo_large.png",
action:function(){
self.google_select_action();}
})
];

this.mode=nvram_manager.read_mode();
if(this.mode==DEFAULT){
this.default_mode.enable();
this.google_mode.disable();}else {
this.default_mode.disable();
this.google_mode.enable();}
};
account_list.is_visible=function(){
return this.open;};
account_list.get_view_mode=function(){
return this.mode;};
account_list.move_focus=function(index){
if(index<0){
this.index=-1;
set_cursor(this,null);
this.focus.moveTo(this.addBtn.translate,[this.addBtn.width,this.addBtn.height],0,50,null);}else if(this.item.components[index]){
this.index=index;
set_cursor(this,this.item.components[this.index]);
this.focus.moveTo(this.item.components[this.index].translate,[430,68],0,50,null);}else if(index==this.item.components.length){
this.index=index;
set_cursor(this,null);
this.focus.moveTo(
this.term_button.translate,[this.term_button.width,this.term_button.height],0,50,null
);}else if(this.view_item.components[index-this.item.components.length-1]){
this.index=index;
set_cursor(this,this.view_item.components[this.index-this.item.components.length-1]);
this.focus.moveTo(
this.view_item.components[this.index-this.item.components.length-1].translate,[430,68],0,50,null
);}
};
account_list.login=function(){
var account_data=nvram_manager.read_account_data();
if(!account_data)return;
var self=this;
loading.show();
TopBar.set_account_text("");
full_calendar_obj.sch_obj.google_reset();
google_calendar.get_account_calendar({
access_token:account_data[this.index].access_token,
refresh_token:account_data[this.index].refresh_token,
get_callback:function(access_token,user_id){
google_calendar.get_user_info({
access_token:access_token,
user_id:user_id,
callback:function(){
self.set_account_item();
self.google_select();
set_cursor(sobj,self);
loading.hide();}
});},
error_callback:function(error_code){
loading.hide();
notice_panel.show({
title:CL_MSG("LT_CL_LOGIN_FAILED"),
description:CL_MSG("LT_LD_NETWORK_ERROR")+"("+error_code+")",
close_callback:function(){
set_cursor(sobj,self);}
});},
});};
account_list.logout=function(){
google_calendar.request_cancel();
var read_data=nvram_manager.read();
if(read_data&&read_data.account_data){
for(var i=0;i<read_data.account_data.length;i++){
read_data.account_data[i].login_status=LOGOUT;}
}
nvram_manager.write(read_data);
TopBar.set_account_text("");
full_calendar_obj.sch_obj.google_reset();
full_calendar_obj.sch_obj.set_tab(false);
this.set_account_item();
this.default_select();};
account_list.delete_item=function(){
nvram_manager.remove_account(this.index);
if(this.index==this.login_index){
google_calendar.request_cancel();
full_calendar_obj.sch_obj.google_reset();
full_calendar_obj.sch_obj.view_change_text(false);
TopBar.set_account_text("");
this.default_select();}
this.set_account_item();
this.move_focus(this.index-1);
set_cursor(sobj,this);};
account_list.default_select=function(){
this.default_mode.enable();
this.google_mode.disable();
this.mode=DEFAULT;
nvram_manager.write_mode(this.mode);
full_calendar_obj.sch_obj.change_tab(this.mode);
full_calendar_obj.sch_obj.refreshSchedule();
TopBar.disable_update_menu();
force_redraw();};
account_list.google_select=function(){
this.default_mode.disable();
this.google_mode.enable();
this.mode=GOOGLE;
nvram_manager.write_mode(this.mode);
full_calendar_obj.sch_obj.change_tab(this.mode);
full_calendar_obj.sch_obj.refreshSchedule();
TopBar.enable_update_menu();
force_redraw();};
account_list.enter_focus=function(){
this.key_lock=false;
this.focus.setShow(true);};
account_list.leave_focus=function(){
this.focus.setShow(false);};
account_list.key_hook=function(up_down,key){
if(up_down!=KEY_PRESS)return true;
if(this.key_lock)return true;
if(this.cursor&&this.cursor.key_hook&&this.cursor.key_hook(up_down,key)){
return true;}
switch(key){
case SETTING_KEY.symbol:
case TXK_RETURN:
case TXK_LEFT:
this.hide();
return true;
case TXK_ENTER:
var self=this;
if(this.index<0){
this.focus.setShow(false);
if(this.item.components.length<MAX_ACCOUNT_VALUE){
this.key_lock=true;
this.link_panel.show();}else {
notice_panel.show({
title:CL_MSG("LT_CL_ACCOUNT_FULL"),
description:CL_MSG("LT_CL_FULL_ALERT")+"\n"+CL_MSG("LT_CL_FULL_ALERT_2"),
});}
}else if(this.index==this.item.components.length){
terms_of_use.show({
first:false,
close_callback:function(){
set_cursor(sobj,self);}
});}else {
var login=(this.index==this.login_index);
var pos=[0,180-(this.index+1)*70,0];
this.edit_popup.show({
login:login,pos:pos,
login_func:function(){self.login()},
logout_func:function(){
self.logout();
set_cursor(sobj,self);},
delete_func:function(){self.delete_item()}
});
set_cursor(sobj,this.edit_popup);}
return true;
case TXK_UP:
if(this.index==-1)return true;
this.move_focus(this.index-1);
return true;
case TXK_DOWN:
this.move_focus(this.index+1);
return true;
case TXK_RIGHT:
return true;}
return false;};
var account_edit_popup=new container({visible_p:false});
account_edit_popup.create=function(param){
this.width=250;
this.height=150;
this.index=0;
this.login=false;
this.login_func=null;
this.logout_func=null;
this.delete_func=null;
this.focus=new Focus();
this.focus.setShow(false);
this.components=[
this.popup_m=new gimage({
width:this.width,height:this.height,
src:png_path+"edit_option_m.png",
draw_type:DIRECT,
}),
this.popup_t=new gimage({
width:this.width,height:36,
translate:[0,this.height/2+36/2,0],
src:png_path+"edit_option_t.png",
draw_type:DIRECT,
}),
this.popup_b=new gimage({
width:this.width,height:18,
translate:[0,-(this.height/2+18/2),0],
src:png_path+"edit_option_b.png",
draw_type:DIRECT,
}),
this.login_logout=new calendar_util.Btn({
width:210,height:60,
font_size:35,align:CENTER,
translate:[0,38,0],
}),
this.delete_btn=new calendar_util.Btn({
width:210,height:60,
font_size:35,align:CENTER,
translate:[0,-32,0],
text:CL_MSG("LT_CL_DELETE")
}),
this.focus,
];};
account_edit_popup.show=function(param){
if(!param)return;
this.login=param.login||false;
if(this.login){
this.login_logout.setText(CL_MSG("LT_GOOGLE_LOGOUT"));}else {
this.login_logout.setText(CL_MSG("LT_GOOGLE_LOGIN"));}
this.login_func=param.login_func||function(){};
this.logout_func=param.logout_func||function(){};
this.delete_func=param.delete_func||function(){};
this.focus.setSize(210,60);
this.focus.setTranslate(this.login_logout.translate[0],this.login_logout.translate[1],0);
this.translate=param.pos||[0,180,0];
this.visible_p=true;};
account_edit_popup.hide=function(){
this.visible_p=false;
this.index=0;};
account_edit_popup.free=calendar_util.FREE_FUNC;
account_edit_popup.enter_focus=function(){
this.focus.setShow(true);};
account_edit_popup.leave_focus=function(){
this.focus.setShow(false);};
account_edit_popup.key_hook=function(up_down,key){
if(up_down!=KEY_PRESS)return true;
switch(key){
case TXK_RETURN:
this.hide();
set_cursor(sobj,account_list);
return true;
case TXK_ENTER:
if(this.index==0){
if(this.login){
this.logout_func();}else {
this.login_func();}
}else if(this.index==1){
this.delete_func();}
this.hide();
return true;
case TXK_UP:
if(this.index==0){
this.index++;
this.focus.moveTo(this.delete_btn.translate,[210,60],0,50,null);}else if(this.index==1){
this.index--;
this.focus.moveTo(this.login_logout.translate,[210,60],0,50,null);}
return true;
case TXK_DOWN:
if(this.index==0){
this.index++;
this.focus.moveTo(this.delete_btn.translate,[210,60],0,50,null);}else if(this.index==1){
this.index--;
this.focus.moveTo(this.login_logout.translate,[210,60],0,50,null);}
return true;}
return true;};
var device_link_panel=new container({visible_p:false});
device_link_panel.create=function(param){
this.key_lock=false;
this.translate=[0,-1000,0];
this.components=[
this.bg=new gimage({
width:1200,height:780,
draw_type:DIRECT
}),
this.title=new gtext({
width:1150,
translate:[10,310,0],font_size:40,
align:LC_TEXT_ALIGN,
}),
this.upper_text=new gtextbox({
width:1150,height:120,
translate:[10,200,0],
align:LC_TEXT_ALIGN
}),
this.square=new gbox({
width:500,height:200,
}),
this.square_hole=new gbox({
width:470,height:170,
color:[0,0,0,255]
}),
this.under_text=new gtextbox({
width:1150,height:200,
translate:[10,-230,0],
align:LC_TEXT_ALIGN
}),
this.link_code=new gtext({
width:470,color:[255,255,255,255],
align:CENTER,font_size:80,
})
];
this.moveTo=MoveTo;};
device_link_panel.show=function(){
this.key_lock=true;
var self=this;
google_calendar.oAuthRequest({
get_callback:function(data){
self.key_lock=false;
if(notice_panel.is_visible())return;
set_cursor(sobj,self);
self.set_data(data);
self.visible_p=true;
self.moveTo({x:0,y:0,z:0,end_func:function(){
google_calendar.link_polling(data.device_code);
google_calendar.get_access_token(data.device_code);}});},
error_callback:function(error_code){
if(!error_code)error_code=404;
notice_panel.show({
title:CL_MSG("LT_TZ_CLOCK_ERROR_NW"),
description:CL_MSG("LT_LD_NETWORK_ERROR")+"("+error_code+")",
});}
});};
device_link_panel.hide=function(){
var self=this;
this.visible_p=true;
this.moveTo({x:0,y:-1000,z:0,end_func:function(){
self.visible_p=false
self.free();}});};
device_link_panel.set_data=function(data){
this.bg.src=png_path+"kbd_bg.png";
setf_text(this.title,CL_MSG("LT_CL_ADD_ACCOUNT"));
setf_text(this.upper_text,CL_MSG("LT_CL_DESCRIPTION_1")+"\n"+data.verification_url+"\n"+CL_MSG("LT_CL_DESCRIPTION_2"));
setf_text(this.under_text,CL_MSG("LT_CL_DESCRIPTION_3"));
setf_text(this.link_code,data.user_code||"");};
device_link_panel.free=function(){
this.bg.src="";
setf_text(this.title,"");
setf_text(this.upper_text,"");
setf_text(this.under_text,"");
setf_text(this.link_code,"");};
device_link_panel.enter_focus=function(){
}
device_link_panel.leave_focus=function(){
};
device_link_panel.view=function(){
return this.visible_p;};
device_link_panel.key_hook=function(up_down,key){
if(up_down!=KEY_PRESS)return true;
if(this.key_lock)return true;
switch(key){
case TXK_RETURN:
google_calendar.polling_stop();
this.hide();
set_cursor(sobj,account_list);
return true;}
return true;};
var list_item=function(param){
if(!param)return;
this.width=param.width||420;
this.height=param.height||70;
this.enter_action=param.action||function(){};
this.translate=param.translate||[0,0,0];
this.choice=param.choice||false;
this.components=[
this.select_bg=new gbox({
width:this.width,height:this.height,
color:[61,130,255,100],
round_enable:true,round_width:4,round_height:4,
visible_p:this.choice,
}),
this.choice_icon=new gimage({
width:param.icon_width||40,
height:param.icon_height||40,
translate:[Math.floor(-this.width/2+param.icon_width),0,0],
src:png_path+"google_logo.png",
draw_type:DIRECT,
visible_p:this.choice,
}),
this.name=new gtext({
width:this.width-this.choice_icon.width*2,
text:param.text||"",
translate:[this.choice_icon.width,2,0],
color:[104,96,80,255],
align:LEFT,
omitter:"...",
}),
this.line=new gbox({
width:this.width-10,height:2,
translate:[0,-this.height/2,0],
color:[104,96,80,255],
visible_p:param.line
})
];};
list_item.prototype=new container({});
list_item.prototype.free=calendar_util.FREE_FUNC;
list_item.prototype.select=function(){
this.select_bg.visible_p=true;
this.choice_icon.visible_p=true;};
list_item.prototype.unselect=function(){
this.select_bg.visible_p=false;
this.choice_icon.visible_p=false;};
list_item.prototype.get_label=function(){
return this.name.text;};
var mode_view_item=function(param){
if(!param)return;
this.select_action=param.action||function(){};
this.translate=param.translate||[0,0,0];
this.components=[
this.bg=new gbox({
width:430,height:70,
color:[61,130,255,100],
round_enable:true,
round_width:4,round_height:4,
visible_p:false
}),
this.check=new checkBox({
width:40,height:40,
translate:param.check_pos||[0,0,0],
}),
this.kind_icon=new gimage({
width:40,height:40,
translate:[-115,0,0],
src:param.icon||"",draw_type:DIRECT
}),
this.item_name=new gtext({
width:420-this.kind_icon.width-25,
text:param.text||"",
translate:[this.kind_icon.width+55,2,0],
color:[104,96,80,255],
align:LEFT,
omitter:"...",
}),
this.line=new gbox({
width:420,height:2,
translate:[0,-35,0],
color:[104,96,80,255],
visible_p:param.line
})
];};
mode_view_item.prototype=new container({});
mode_view_item.prototype.enable=function(){
this.bg.visible_p=true;
this.check.enable();};
mode_view_item.prototype.disable=function(){
this.bg.visible_p=false;
this.check.disable();};
mode_view_item.prototype.free=calendar_util.FREE_FUNC;
mode_view_item.prototype.enter_focus=function(){
};
mode_view_item.prototype.leave_focus=function(){
};
mode_view_item.prototype.key_hook=function(up_down,key){
if(up_down!=KEY_PRESS)return true;
switch(key){
case TXK_ENTER:
this.select_action();
return true;}
return false;};
var TIMER_RESOLUTION=40;
function MoveTo(param){
delete_timer(this);
if(param.func)param.func(this);
this.tmp={};
this.endpos={};
this.tmp.RATE=0.6;
this.tmp.max_count=param.count?param.count:9;
if(param.rate){
this.tmp.RATE=param.rate;}
if(param.count)this.tmp.max_count=param.count;
this.endpos.x=param.x;
this.endpos.y=param.y;
this.endpos.z=param.z;
this.tmp.dx=param.x-this.translate[0];
this.tmp.dy=param.y-this.translate[1];
this.tmp.dz=param.z-this.translate[2];
this.translate[0]+=this.tmp.dx*this.tmp.RATE;
this.translate[1]+=this.tmp.dy*this.tmp.RATE;
this.translate[2]+=this.tmp.dz*this.tmp.RATE;
if(!param.angle)param.angle=0;
this.tmp.da=param.angle-this.rotation[0];
this.rotation[0]+=this.tmp.da*this.tmp.RATE

force_redraw();
append_timer(this,TIMER_RESOLUTION,function (obj,count){
obj.tmp.dx=param.x-obj.translate[0];
obj.tmp.dy=param.y-obj.translate[1];
obj.tmp.dz=param.z-obj.translate[2];
obj.translate[0]+=Math.floor(obj.tmp.dx*obj.tmp.RATE);
obj.translate[1]+=Math.floor(obj.tmp.dy*obj.tmp.RATE);
obj.translate[2]+=Math.floor(obj.tmp.dz*obj.tmp.RATE);
obj.tmp.da=param.angle-obj.rotation[0];
obj.rotation[0]+=obj.tmp.da*obj.tmp.RATE;
if(count>=obj.tmp.max_count){
delete_timer(obj);

obj.translate[0]=param.x;
obj.translate[1]=param.y;
obj.translate[2]=param.z;
obj.rotation[0]=param.angle;
if(typeof param.end_func=="function"){
param.end_func(obj);}
}
force_redraw();});}

var WIDTH=1920;
var HEIGHT=1080;
var TOPBAR_WIDTH=WIDTH;
var TOPBAR_HEIGHT=100;
var Background=new container({});
Background.create=function(){
if(this.components.length>0)return;
this.bg=new gimage({
width:WIDTH,height:HEIGHT,draw_type:DIRECT,src:png_path+"bg.png",
translate:[0,0,0],
});
this.components=[this.bg];};
Background.free=calendar_util.FREE_FUNC;
Background.appear=function(){
this.create();};
Background.disappear=function(){
this.free();};
var TopBar=new container({});
TopBar.create=function(){
if(this.components.length>0)return;
this.width=TOPBAR_WIDTH;
this.height=TOPBAR_HEIGHT;
var title_l_spc=100;
this.components=[
this.title=new gtext({
width:400,color:[255,255,255,255],text:CL_MSG("LT_CL_CALENDAR"),
font_size:60
}),
this.account=new gtext({
width:700,color:[255,255,255,255],
font_size:36,align:CENTER,
translate:[0,500,0],
font_name:"F015T-bold"
}),
this.update_color=new gimage({
width:45,height:40,
translate:[0,493,0],
src:UPDATE_KEY.image,
draw_type:DIRECT,
visible_p:false
}),
this.update_menu=new gtext({
width:110,color:[255,255,255,255],
translate:[635,495,0],
font_size:30,
text:CL_MSG("LT_CL_UPDATE"),
visible_p:false
}),
this.setting_color=new gimage({
width:45,height:40,
translate:[0,495,0],
src:SETTING_KEY.image,
draw_type:DIRECT
}),
this.setting_menu=new gtext({
width:200,color:[255,255,255,255],
translate:[855,498,0],
font_size:30,
text:CL_MSG("LT_CL_SETTING2")
})
];
this.title.translate=[-(this.width-this.title.width)/2+title_l_spc,502,0];
this.update_menu.font_size=getFontSizeOfText(this.update_menu,this.update_menu.text,15);
setf_text(this.update_menu,this.update_menu.text);
this.update_color.translate[0]=this.update_menu.translate[0]-this.update_menu.width/2-this.update_color.width/2-12;
this.setting_menu.font_size=getFontSizeOfText(this.setting_menu,this.setting_menu.text,15);
setf_text(this.setting_menu,this.setting_menu.text);
this.setting_color.translate[0]=this.setting_menu.translate[0]-this.setting_menu.width/2-this.setting_color.width/2-12;};
TopBar.free=calendar_util.FREE_FUNC;
TopBar.appear=function(){
this.create();};
TopBar.disappear=function(){
this.free();};
TopBar.set_account_text=function(name){
this.account.font_size=getFontSizeOfText(this.account,name,28);
setf_text(this.account,name);};
TopBar.enable_update_menu=function(){
this.update_color.visible_p=true;
this.update_menu.visible_p=true;};
TopBar.disable_update_menu=function(){
this.update_color.visible_p=false;
this.update_menu.visible_p=false;};
TopBar.get_menu_width=function(){
return this.setting_color.width+this.setting_menu.width;};
TopBar.get_account_name=function(){
return this.account.text;};
var notice_panel=new container({});
notice_panel.create=function(){
this.visible_p=false;
this.start_up=false;
this.close_callback=null;
this.last_cursor=null;
this.focus=new Focus();
this.focus.setShow(false);
this.components=[
this.right_shade=new gbox({
width:1920,height:1000,
color:[0,0,0,230],
translate:[823,-40,0],
visible_p:false,
}),
this.left_shade=new gbox({
width:1920,height:1080,
color:[0,0,0,230],
visible_p:false,
}),
this.right_upper_shade=new gbox({
width:1000,height:1000,
color:[0,0,0,230],
translate:[823,0,0],
visible_p:false,
}),
this.bg=new gimage({
width:800,height:420,
src:png_path+"kbd_bg.png",
draw_type:DIRECT,
}),
this.title=new gtext({
width:720,
translate:[0,this.bg.height/2-70,0],
font_size:42,align:LC_TEXT_ALIGN
}),
this.description=new gtextbox({
width:720,height:400,
translate:[0,-120,0],
font_size:32,align:LC_TEXT_ALIGN
}),
this.ok=new calendar_util.Btn({
width:140,height:60,
font_size:30,align:CENTER,
translate:[0,-130,0],
}),
this.focus,
]
};
notice_panel.appear=function(){
this.create();};
notice_panel.disappear=function(){
this.free();};
notice_panel.show=function(param){
if(!param)return;
this.last_cursor=sobj.cursor;
set_cursor(sobj,this);
this.set_data(param);};
notice_panel.hide=function(){
delete_timer(this);
this.visible_p=false;
if(device_link_panel.view()){
set_cursor(sobj,device_link_panel);}else {
set_cursor(sobj,this.last_cursor);}
this.last_cursor=null;
this.close_callback();};
notice_panel.set_data=function(param){
var title_text=param.title||"";
this.title.font_size=getFontSizeOfText(this.title,title_text,30);
setf_text(this.title,title_text);
setf_text(this.description,param.description||"");
this.ok.setText(CL_MSG("LT_OK"));
this.close_callback=param.close_callback||function(){};
if(param.start_up){
this.start_up=true;
this.right_shade.visible_p=true;
this.left_shade.visible_p=true;
this.right_shade.width=TopBar.get_menu_width()+30;
this.right_upper_shade.width=this.right_shade.width;
this.left_shade.width-=this.right_shade.width;
this.left_shade.translate[0]-=this.right_shade.width/2;
this.right_upper_shade.height=this.left_shade.height-this.right_shade.height;
this.right_upper_shade.translate[1]=this.right_shade.height/2;
this.right_shade.width+=1;
this.right_shade.height+=1;
this.right_upper_shade.height+=1;
this.left_shade.width+=1;
this.left_shade.height+=1;
this.animation_start();}else {
this.start_up=false;
this.right_shade.visible_p=false;
this.left_shade.translate=[0,0,0];
this.left_shade.width=1920;
this.left_shade.height=1080;
this.left_shade.visible_p=true;
this.right_upper_shade.visible_p=false;}

this.focus.setSize(this.ok.width,this.ok.height);
this.focus.setTranslate(0,-130,0);
this.focus.setShow(true);
this.visible_p=true;};
notice_panel.free=calendar_util.FREE_FUNC;
notice_panel.animation_start=function(){
append_timer(this,800,function(obj,count){
if(obj.right_upper_shade.visible_p){
obj.right_upper_shade.visible_p=false;}else {
obj.right_upper_shade.visible_p=true;}
force_redraw();});};
notice_panel.is_visible=function(){
return this.visible_p;};
notice_panel.enter_focus=function(){
};
notice_panel.leave_focus=function(){
};
notice_panel.key_hook=function(up_down,key){
if(up_down!=KEY_PRESS)return true;
switch(key){
case TXK_ENTER:
this.hide();
return true;
case TXK_RETURN:
this.hide();
return true;}
return true;};
var terms_of_use=new container({});
terms_of_use.create=function(){
this.visible_p=false;
this.is_first=false;
this.index=0;
this.ok_callback=null;
this.cancel_callback=null;
this.close_callback=null;
this.focus=new Focus();
this.focus.setShow(false);
this.components=[
this.shade=new gbox({
width:1922,height:1082,
color:[0,0,0,200]
}),
this.bg=new gimage({
width:1500,height:1000,
src:png_path+"kbd_bg.png",
draw_type:DIRECT
}),
this.title=new gtext({
width:1400,
translate:[0,410,0],
align:CENTER,font_size:55,
}),
this.description=new gtextbox({
width:1400,height:700,
font_size:27,
}),
this.ok=new calendar_util.Btn({
width:190,height:60,
font_size:30,align:CENTER,
translate:[-160,-420,0],
text:CL_MSG("LT_OK")
}),
this.cancel=new calendar_util.Btn({
width:190,height:60,
font_size:30,align:CENTER,
translate:[160,-420,0],
text:CL_MSG("LT_CANCEL")
}),
this.close=new calendar_util.Btn({
width:190,height:60,
font_size:30,align:CENTER,
translate:[0,-420,0],
text:CL_MSG("LT_CL_CLOSE")
}),
this.focus
];};
terms_of_use.appear=function(){
this.create();};
terms_of_use.disappear=function(){
this.free();};
terms_of_use.show=function(param){
set_cursor(sobj,this);
this.is_first=param.first||false;
this.ok_callback=param.ok_callback||function(){};
this.cancel_callback=param.cancel_callback||function(){};
this.close_callback=param.close_callback||function(){};
this.set_data(param.first);
this.visible_p=true;
force_redraw();};
terms_of_use.hide=function(){
this.visible_p=false;
force_redraw();};
terms_of_use.set_data=function(){
this.index=0;
if(COUNTRY=="JP"){
setf_text(this.title,"本アプリケーション利用規約");
this.description.translate[1]=-30;
setf_text(this.description,"本アプリケーションを利用いただくにあたり、お客様には下記の利用規約（以下、「本利用規約」といいます）に合意いただきます。\n\n1. お客様は、お客様が現在操作されているTV上にて本アプリケーションを無償で利用することができます。\n\n2. 本アプリケーションは、Google Inc.（以下、\"Google\"といいます） の提供するGoogle Calendarの機能を利用することができます。\n\n3. お客様は、Google Calendarの機能を利用いただく際、適用される法律、Googleの規約(Google API Terms of Serviceを含む)及びポリシーを遵守しなくてはいけません。\n\n4. お客様は、本アプリケーションを通してGoogle Calendarに対して投稿された情報やコンテンツがGoogleによって管理または保存されること及びそれらの情報やコンテンツが米国またはGoogle、その子会社またはその関係会社の所在国に送信され保存されることがあることを予め合意します。なお、パナソニック株式会社またはその関連会社（以下、\"当社\"といいます）はGoogle Calendarに投稿されたお客様の情報やコンテンツを収集、保存、利用等することはございません。\n\n5. お客様は、自らの責任で本アプリケーション及びGoogle Calendarを利用します。適用される法律が許容する範囲において、当社は、本アプリケーションを現状有姿で提供するものとし、本アプリケーションまたはGoogle Calendarについて、商品性、特定目的への適合性または知的財産権の非侵害を含む明示的または黙示的な一切の保証を行いません。また、適用される法律が許容する範囲において、当社は、お客様の本アプリケーション及びGoogle Calendarの利用に関して、一切の責任も義務も負いません。");}else if(is_china){
setf_text(this.title,"使用条款");
this.description.translate[1]=0;
setf_text(this.description,"为了使用该应用，您必须首先接受本使用条款。\n\n"
+"注意：您承认并同意，本使用条款仅以其英文文本为准，任何其他语言的翻译文本仅供参考。\n\n"
+"1.您可以在现在操作中的电视机上免费使用本应用。\n\n"
+"2.本应用可访问并使用由Google Inc.（以下称为“Google”）提供的Google Calendar功能。\n\n"
+"3.当您使用Google Calendar的功能时，应当遵守相关法律、Google条款（包括Google API 服务的条款）以及Google的使用协议。\n\n"
+"4.您同意并承认您提供给Google Calendar的任何信息会被Google处理及保存，这些信息也可能被位于美国或任何其他国家的Google以及子公司和关联公司的设备进行保存和维护。PANASONIC及其关联公司不会收集、保存和使用您提供给Google Calendar的任何信息及内容。\n\n"
+"5.您明确了解并同意，您应自行承担使用本应用和Google Calendar而引发的风险。在现有法律允许的范围内，本应用均按照“现状”和“现有”的状态提供，且无任何保证。在现有法律允许的范围内，关于本应用及Google Calendar，PANASONIC不会提供任何担保或承诺，包括但不限于任何适销性、特定用途的适用性以及第三方知识产权的非侵害性的明示或暗示性的保证。在现有法律允许的范围内，对于您在使用本应用及Google Calendar时造成的任何损失，PANASONIC均不会承担责任。");}else {
setf_text(this.title,"Terms of Use");
this.description.translate[1]=0;
setf_text(this.description,"Prior to your use of this application (“Application”), you shall agree with these Terms of Use (“Terms”).\n\n1. You can use this application on TV which you are operating now without charge.\n\n2. This Application can access and use “Google Calendar” provided by Google Inc. (“Google”).\n\n3. When you use the functions of Google Calendar, you shall comply with all applicable laws, Google rules (including Google API Terms of Service), and Google policies.\n\n4. You agree and acknowledge that any information provided by you to Google Calendar will be handled and stored by Google and that such information may be stored and processed in facilities located in the United States or any other country in which Google or its subsidiaries or affiliated legal entities maintain or possess. Panasonic Corporation and its affiliates (“Panasonic”) will not collect, handle, store or use your information or contents provided to Google Calendar.\n\n5.You shall use this Application and Google Calendar at your own risk. TO THE EXTENT PERMITTED BY APPLICABLE LAW, THIS APPLICATION IS PROVIDED \"AS IS\" WITHOUT ANY WARRANTY. TO THE EXTENT PERMITTED BY APPLICABLE LAW, WITH RESPECT TO THE APPLICATION AND GOOGLE CALENDAR, PANASONIC SHALL NOT MAKE TO YOU, ANY WARRANTY OR REPRESENTATION INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT OF THIRD PARTY’S RIGHT. TO THE EXTENT PERMITTED BY APPLICABLE LAW, PANASONIC SHALL NOT BE LIABLE FOR ANY DAMAGE ARISING FROM YOUR USE OF THE APPLICATION OR GOOGLE CALENDAR.");}

var desc_height=get_text_font_height(this.description,this.description.text);
if(this.is_first){
this.ok.visible_p=true;
this.cancel.visible_p=true;
this.close.visible_p=false;
this.ok.translate=[-160,-desc_height/2-70,0];
this.cancel.translate=[160,-desc_height/2-70,0];
this.focus.setTranslate(-160,-desc_height/2-70,0);
this.focus.setSize(this.ok.width,this.ok.height);}else {
this.ok.visible_p=false;
this.cancel.visible_p=false;
this.close.visible_p=true;
this.close.translate=[0,-desc_height/2-70,0];
this.focus.setTranslate(0,-desc_height/2-70,0);
this.focus.setSize(this.close.width,this.close.height);}
this.focus.setShow(true);};
terms_of_use.ok_action=function(){
this.hide();
this.ok_callback();};
terms_of_use.cancel_action=function(){
this.hide();
this.cancel_callback();};
terms_of_use.close_action=function(){
this.hide();
this.close_callback();};
terms_of_use.free=calendar_util.FREE_FUNC;
terms_of_use.enter_focus=function(){
};
terms_of_use.leave_focus=function(){
};
terms_of_use.key_hook=function(up_down,key){
if(up_down!=KEY_PRESS)return true;
switch(key){
case TXK_ENTER:
if(this.is_first){
if(this.index==0){
this.ok_action();}else {
this.cancel_action();}
}else {
this.close_action();}
return true;
case TXK_RETURN:
if(this.is_first){
this.cancel_action();}else {
this.close_action();}
return true;
case TXK_LEFT:
case TXK_RIGHT:
if(!this.is_first)return true;
if(this.index==0){
this.index++;
this.focus.moveTo(this.cancel.translate,[190,60],0,50,null);}else {
this.index--;
this.focus.moveTo(this.ok.translate,[190,60],0,50,null);}
return true;}
return true;};
var char_over=new container({});
char_over.create=function(){
this.visible_p=false;
this.ok_action=null;
this.cancel_action=null;
this.focus=new Focus();
this.focus.setShow(false);
this.index=0;
this.components=[
this.bg=new gimage({
width:800,height:420,
src:png_path+"kbd_bg.png",
draw_type:DIRECT,
}),
this.confirm=new gtextbox({
width:700,height:300,
}),
this.ok=new calendar_util.Btn({
width:150,height:60,
translate:[-150,-130,0],
font_size:25,align:CENTER,
}),
this.cancel=new calendar_util.Btn({
width:150,height:60,
translate:[150,-130,0],
font_size:25,align:CENTER,
}),
this.focus,
];};
char_over.show=function(param){
set_cursor(sobj,this);
this.ok_action=param.ok_callback||function(){};
this.cancel_action=param.cancel_callback||function(){};
setf_text(this.confirm,CL_MSG("LT_CL_CHAR_OVER"));
this.ok.setText(CL_MSG("LT_OK"));
this.cancel.setText(CL_MSG("LT_CANCEL"));
this.focus.setTranslate(this.ok.translate[0],this.ok.translate[1],0);
this.focus.setSize(150,60);
this.focus.setShow(true);
this.visible_p=true;
force_redraw();};
char_over.hide=function(){
this.index=0;
this.visible_p=false;
setf_text(this.confirm,"");
this.ok.setText("");
this.cancel.setText("");
this.focus.setShow(false);};
char_over.free_func=calendar_util.FREE_FUNC;
char_over.free=function(){
this.bg.src="";
setf_text(this.confirm,"");
this.ok.setText("");
this.cancel.setText("");
this.free_func();};
char_over.enter_focus=function(){
};
char_over.leave_focus=function(){
};
char_over.key_hook=function(up_down,key){
if(up_down!=KEY_PRESS)return true;
switch(key){
case TXK_ENTER:
if(this.index==0){
this.ok_action();}else {
this.cancel_action();}
this.hide();
return true;
case TXK_RETURN:
this.cancel_action();
this.hide();
return true;
case TXK_LEFT:
case TXK_RIGHT:
if(this.index==0){
this.index++;
this.focus.moveTo(this.cancel.translate,[150,60],0,50,null);}else {
this.index--;
this.focus.moveTo(this.ok.translate,[150,60],0,50,null);}
return true;};
return true;};
var sch_edit_panel=new container({});
sch_edit_panel.create=function(){
this.visible_p=false;
this.index=0;
this.key_lock=false;
this.char_font=38;
this.focus=new Focus();
this.focus.setShow(false);
this.post_callback=null;
this.close_callback=null;
this.translate=[0,-1200,0];
this.cal_list=[];
this.post_item="";
this.focus_day="";
this.start_time="";
this.end_time="";
this.start_tz="";
this.end_tz="";
this.belong="";
this.destination="";
this.field=new container({});
this.field.components=[
this.summary=new char_field({
width:1200,height:50,
translate:[-10,310,0],
font_size:35,multi:false,
align:LC_TEXT_ALIGN
}),
this.start=new char_field({
width:290,height:50,
translate:[-465,195,0],
font_size:35,multi:false,
}),
this.end=new char_field({
width:290,height:50,
translate:[90,195,0],
font_size:35,multi:false,
}),
this.all_day_check=new checkBox({
width:50,height:50,
translate:[565,200,0]
}),
this.description=new char_field({
width:1200,height:300,
translate:[-10,-50,0],
font_size:35,multi:true,
align:LC_TEXT_ALIGN
}),
this.cal_btn=new calendar_util.Btn({
width:700,height:50,
font_size:25,align:CENTER,
translate:[-80,-260,0],
}),
this.ok=new calendar_util.Btn({
width:170,height:60,
font_size:30,align:CENTER,
translate:[-150,-350,0],
text:CL_MSG("LT_OK"),
}),
this.cancel=new calendar_util.Btn({
width:170,height:60,
font_size:30,align:CENTER,
translate:[150,-350,0],
text:CL_MSG("LT_CANCEL"),
})
];
this.components=[
this.bg=new gimage({
width:1300,height:900,
src:png_path+"kbd_bg.png",
draw_type:DIRECT
}),
this.summary_title=new gtext({
width:1200,
translate:[-10,370,0],
font_size:this.char_font,
}),
this.start_title=new gtext({
width:350,
translate:[-435,250,0],
font_size:this.char_font,
}),
this.tilde=new gtext({
width:50,
translate:[-185,180,0],
font_size:65,text:"~",
}),
this.end_title=new gtext({
width:350,
translate:[120,250,0],
font_size:this.char_font,
}),
this.all_day=new gtext({
width:250,
translate:[400,200,0],
font_size:this.char_font,
align:RIGHT,
}),
this.description_title=new gtext({
width:1200,
translate:[-10,135,0],
font_size:this.char_font,
}),
this.cal_title=new gtext({
width:160,
translate:[-530,-260,0],
font_size:this.char_font,
}),
this.field,
this.focus,
this.shade=new gbox({
width:1920,height:1080,
color:[0,0,0,200],
visible_p:false,
}),
];
this.moveTo=MoveTo;
this.time_edit_panel=time_edit_panel;
this.cal_list_view=cal_list_view;
this.char_over=char_over;};
sch_edit_panel.appear=function(){
this.create();
this.char_over.create();
this.time_edit_panel.create();};
sch_edit_panel.disappear=function(){
this.free_field();
this.time_edit_panel.free();
this.cal_list_view.free();
this.char_over.free();
this.free();};
sch_edit_panel.show=function(param){
if(!param)return;
this.focus.setSize(this.summary.width,this.summary.height);
this.focus.setTranslate(this.summary.translate[0],this.summary.translate[1],0);
this.focus.setShow(true);
this.set_data(param);
this.animation(true);};
sch_edit_panel.free_field=function(){
for(var i=0;i<this.field.components.length;i++){
this.field.components[i].free();}
};
sch_edit_panel.set_all_day=function(){
if(!this.focus_day)return;
var date=new Date(this.focus_day[0],this.focus_day[1],this.focus_day[2]);
this.start.setText(getFormattedDateString(date));
date.setDate(date.getDate()+1);
this.end.setText(getFormattedDateString(date));};
sch_edit_panel.set_default_day=function(){
this.start.setText(getFormattedDateString(new Date(this.start_time)));
this.end.setText(getFormattedDateString(new Date(this.end_time)));};
sch_edit_panel.set_data=function(param){
if(is_ampm){
this.start.set_width(360);
this.start.translate[0]=-430;
this.end.set_width(360);
this.end.translate[0]=125;
this.tilde.translate[0]=-150;}
setf_text(this.summary_title,CL_MSG("LT_CL_SUMMARY"));
setf_text(this.start_title,CL_MSG("LT_CL_START"));
setf_text(this.end_title,CL_MSG("LT_CL_END"));
setf_text(this.description_title,CL_MSG("LT_CL_DESCRIPTION"));
this.cal_title.font_size=getFontSizeOfText(this.cal_title,CL_MSG("LT_CL_CALENDAR"),30);
setf_text(this.cal_title,CL_MSG("LT_CL_CALENDAR"));
this.all_day.font_size=getFontSizeOfText(this.all_day,CL_MSG("LT_CL_ALLDAY"),30);
setf_text(this.all_day,CL_MSG("LT_CL_ALLDAY"));

this.post_callback=param.post_callback||function(){};
this.close_callback=param.close_callback||function(){};
this.focus_day=param.focus_day;
this.cal_list=param.calendar_list;
if(param.sch_info){
var sch_info=param.sch_info;
this.post_item=sch_info.items;
this.summary.setText(this.post_item.summary||"");
var start_tz=this.post_item.start.timeZone;
if(start_tz&&start_tz!=sch_info.timeZone){
var start_title=this.start_title.text+" "+"("+start_tz+")";
this.start_title.font_size=getFontSizeOfText(this.start_title,start_title,25);
setf_text(this.start_title,start_title);
this.start_tz=start_tz
}else {
this.post_item.start.timeZone=sch_info.timeZone;
this.start_tz=sch_info.timeZone;}
var end_tz=this.post_item.end.timeZone;
if(end_tz&&end_tz!=sch_info.timeZone){
var end_title=this.end_title.text+" "+"("+this.post_item.end.timeZone+")";
this.end_title.font_size=getFontSizeOfText(this.end_title,end_title,25);
setf_text(this.end_title,end_title);
this.end_tz=end_tz;}else {
this.post_item.end.timeZone=sch_info.timeZone;
this.end_tz=sch_info.timeZone;}
if(this.start_title.font_size<this.end_title.font_size){
this.end_title.font_size=this.start_title.font_size;}else if(this.start_title.font_size>this.end_title.font_size){
this.start_title.font_size=this.end_title.font_size;}
setf_text(this.start_title,this.start_title.text);
setf_text(this.end_title,this.end_title.text);

this.start_time=sch_info.start_date;
this.start.setText(getFormattedDateString(new Date(sch_info.start_date)));
this.end_time=sch_info.end_date;
this.end.setText(getFormattedDateString(new Date(sch_info.end_date)));
if(this.post_item.start.date&&this.post_item.end.date)this.all_day_action(true);
this.description.setText(this.post_item.description||"");
this.cal_btn.setText(this.cal_list[0].calendar_name);
for(var i=0;i<this.cal_list.length;i++){
if(this.cal_list[i].calendar_name==sch_info.calendar_name){
this.cal_btn.setText(this.cal_list[i].calendar_name);
break;}
}
this.destination=sch_info.calendar_id;
this.belong=sch_info.calendar_id;}else {
var date=new Date(this.focus_day[0],this.focus_day[1],this.focus_day[2],10,0);
this.start_time=date.getFullYear()+"/"+(date.getMonth()+1)+"/"+date.getDate()+" "
+date.getHours()+":"+date.getMinutes();
this.start.setText(getFormattedDateString(date));
date.setHours(date.getHours()+1);
this.end_time=date.getFullYear()+"/"+(date.getMonth()+1)+"/"+date.getDate()+" "
+date.getHours()+":"+date.getMinutes();
this.end.setText(getFormattedDateString(date));
this.destination=this.cal_list[0].calendar_id;
this.cal_btn.setText(this.cal_list[0].calendar_name);}
};
sch_edit_panel.hide=function(){
this.index=0;
this.key_lock=false;
this.post_item="";
this.cal_list=[];
this.focus_day="";
this.start_time="";
this.start_tz="";
this.end_time="";
this.end_tz="";
this.belong="";
this.destination="";
this.summary.setText("");
this.start.setText("");
this.end.setText("");
this.description.setText("");
this.cal_btn.setText("");
this.all_day_check.disable();
this.start.set_lock(false);
this.end.set_lock(false);
this.start_title.font_size=this.char_font;
this.end_title.font_size=this.char_font;
setf_text(this.summary_title,"");
setf_text(this.start_title,"");
setf_text(this.end_title,"");
setf_text(this.all_day,"");
setf_text(this.description_title,"");
setf_text(this.cal_title,"");
this.animation(false);};
sch_edit_panel.animation=function(view){
var self=this;
if(view){
this.visible_p=true;
set_cursor(sobj,self);
this.moveTo({x:0,y:0,z:0,end_func:null});}else {
this.moveTo({x:0,y:-1000,z:0,end_func:function(){
self.visible_p=false;}});}
};
sch_edit_panel.free=calendar_util.FREE_FUNC;
sch_edit_panel.open_summary_keyboard=function(){
if(sft_keyboard.visible_p)return;
var self=this;
sft_keyboard_mask.appear();
sft_keyboard.appear({
multi:false,
subject:this.summary_title.text,
text:this.summary.getText(),
done_cb:function(text){
self.summary.setText(text);
self.close_keyboard();},
cancel_cb:function(){
self.close_keyboard();}
});};
sch_edit_panel.open_description_keyboard=function(){
if(sft_keyboard.visible_p)return;
var self=this;
this.focus.setShow(false);
sft_keyboard_mask.appear();
sft_keyboard.appear({
fix:true,multi:true,
textarea_width:this.description.width-10,
textarea_height:this.description.height,
kbd_bg_height:980,kbd_bg_pos:[0,60,0],
textarea_bg_width:this.description.width,
textarea_bg_height:this.description.height,
textarea_bg_pos:[0,65,0],
textarea_pos:[0,62,0],move_pos:-100,
subject:this.description_title.text,
subject_pos_y:475,text:this.description.getText(),
font_size:35,sft_kbd_pos:[0,-60,0],
done_cb:function(text){
self.description.setText(text);
self.close_keyboard();},
cancel_cb:function(){
self.close_keyboard();}
});};
sch_edit_panel.close_keyboard=function(){
sft_keyboard.disappear();
sft_keyboard_mask.disappear();
set_cursor(sobj,this);
this.focus.setShow(true);};
sch_edit_panel.close_time_edit_panel=function(){
set_cursor(sobj,this);
this.shade.visible_p=false;
this.focus.setShow(true);};
sch_edit_panel.time_edit_action=function(param){
if(!param||!param.time_obj)return;
var time=new Date(param.time_obj);
if(isNaN(time))return;
this.shade.visible_p=true;
this.focus.setShow(false);
var self=this;
this.time_edit_panel.show({
title:param.title||"",
time:time,
set_callback:function(time){
if(param.set_callback)param.set_callback(time);},
close_callback:function(){
self.close_time_edit_panel();}
});};
sch_edit_panel.enable_time_field=function(){
this.start.set_lock(false);
this.end.set_lock(false);};
sch_edit_panel.disable_time_field=function(){
this.start.set_lock(true);
this.end.set_lock(true);};
sch_edit_panel.all_day_action=function(bool){
if(bool){
this.all_day_check.enable();
this.disable_time_field();
this.set_all_day();}else {
this.all_day_check.disable();
this.enable_time_field();
this.set_default_day();}
force_redraw();};
sch_edit_panel.enter_action=function(){
var self=this;
switch(this.index){
case SUMMARY:
this.open_summary_keyboard();
break;
case START_TIME:
if(this.start.lock_status())return;
this.time_edit_action({
title:this.start_title.text,
time_obj:this.start_time,
set_callback:function(set_time){
self.start_time=set_time;
self.start.setText(getFormattedDateString(new Date(set_time)));}
});
break;
case END_TIME:
if(this.start.lock_status())return;
this.time_edit_action({
title:this.end_title.text,
time_obj:this.end_time,
set_callback:function(set_time){
self.end_time=set_time;
self.end.setText(getFormattedDateString(new Date(set_time)));}
});
break;
case ALLDAY:
if(this.all_day_check.is_check){
this.all_day_action(false);}else {
this.all_day_action(true);}
break;
case DESCRIPTION:
var dimension=get_dimension_textbox({
width:this.description.width-4,
height:this.description.height-4,
text:this.description.getText(),
});
if(dimension[1]>this.description.height-4){
this.shade.visible_p=true;
this.char_over.show({
ok_callback:function(){
self.shade.visible_p=false;
self.open_description_keyboard();},
cancel_callback:function(){
self.shade.visible_p=false;
set_cursor(sobj,self);}
});}else {
this.open_description_keyboard();}
break;
case CALENDAR_LIST:
set_cursor(sobj,this.cal_list_view);
this.focus.setShow(false);
this.shade.visible_p=true;
this.cal_list_view.show({
choice:this.cal_btn.get_text(),
list:this.cal_list,
set_callback:function(select){
if(select<0)return;
self.destination=self.cal_list[select].calendar_id;
self.cal_btn.setText(self.cal_list[select].calendar_name);},
close_callback:function(){
self.shade.visible_p=false;
set_cursor(sobj,self);
self.focus.setShow(true);}
});
break;
case OK:
this.key_lock=true;
this.focus.setShow(false);
if(this.post_item){
this.post_item.summary=this.summary.getText();
this.post_item.start={};
this.post_item.end={};
if(this.all_day_check.is_check){
var date=new Date(this.focus_day[0],this.focus_day[1],this.focus_day[2]);
this.post_item.start.date=rfc_3339_format(date).substr(0,10);
date.setDate(date.getDate()+1);
this.post_item.end.date=rfc_3339_format(date).substr(0,10);}else {
var start=rfc_3339_format(new Date(this.start_time));
var end=rfc_3339_format(new Date(this.end_time));
this.post_item.start.dateTime=start.replace("Z","").substr(0,19);
this.post_item.start.timeZone=this.start_tz;
this.post_item.end.dateTime=end.replace("Z","").substr(0,19);
this.post_item.end.timeZone=this.end_tz;}
this.post_item.description=this.description.getText();
google_calendar.edit_schedule({
destination:this.destination,
belong:this.belong,
post_body:this.post_item,
edit_callback:function(){
self.hide();
self.post_callback();
google_calendar.update({
get_callback:function(){
full_calendar_obj.sch_obj.loading_view(false);}
});},
error_callback:function(error_code){
full_calendar_obj.sch_obj.loading_view(false);
notice_panel.show({
title:CL_MSG("LT_CL_EDIT_FAILED"),
description:CL_MSG("LT_LD_NETWORK_ERROR")+"("+error_code+")",
close_callback:function(){
self.key_lock=false;
self.focus.setShow(true);}
});}
});}else {
if(this.all_day_check.is_check){
var date=new Date(this.focus_day[0],this.focus_day[1],this.focus_day[2]);
this.start_time=date.getFullYear()+"/"+(date.getMonth()+1)+"/"+date.getDate();
date.setDate(date.getDate()+1);
this.end_time=date.getFullYear()+"/"+(date.getMonth()+1)+"/"+date.getDate();}
google_calendar.create_schedule({
all_day:this.all_day_check.is_check,
method:"POST",
destination:this.destination,
start:this.start_time,end:this.end_time,
summary:this.summary.getText(),
description:this.description.getText(),
timeZone:this.cal_list[0].timeZone,
create_callback:function(){
self.hide();
self.post_callback();
google_calendar.update({
get_callback:function(){
full_calendar_obj.sch_obj.loading_view(false);}
});},
error_callback:function(error_code){
full_calendar_obj.sch_obj.loading_view(false);
notice_panel.show({
title:CL_MSG("LT_CL_CREATE_FAILED"),
description:CL_MSG("LT_LD_NETWORK_ERROR")+"("+error_code+")",
close_callback:function(){
self.key_lock=false;
self.focus.setShow(true);}
});}
});}
break;
case CANCEL:
this.hide();
this.close_callback();
break;}
}
sch_edit_panel.move_focus=function(obj){
if(!obj)return;
if(this.index==ALLDAY){
this.focus.moveTo([obj.translate[0],obj.translate[1]-4,0],[obj.width-12,obj.height-12],0,50,null);}else {
this.focus.moveTo(obj.translate,[obj.width,obj.height],0,50,null);}
};
sch_edit_panel.enter_focus=function(){
};
sch_edit_panel.leave_focus=function(){
};
sch_edit_panel.key_hook=function(up_down,key){
if(up_down!=KEY_PRESS)return true;
if(this.key_lock)return true;
switch(key){
case TXK_RETURN:
this.hide();
this.close_callback();
return true;
case TXK_ENTER:
this.enter_action();
return true;
case TXK_UP:
if(this.index==0)return true;
if(this.index>=1&&this.index<=3){
this.index=0;}else if(this.index>3&&this.index<7){
this.index--;}else if(this.index==this.field.components.length-1){
this.index-=2;}
this.move_focus(this.field.components[this.index]);
return true;
case TXK_DOWN:
if(this.index>=this.field.components.length)return true;
if(this.index==0){
this.index++;}else if(this.index>=1&&this.index<=3){
this.index=4;}else if(this.index==4||this.index==5){
this.index++;}
this.move_focus(this.field.components[this.index]);
return true;
case TXK_LEFT:
if(this.index==0)return true;
this.index--;
this.move_focus(this.field.components[this.index]);
return true;
case TXK_RIGHT:
if(this.index>=this.field.components.length-1)return true;
this.index++;
this.move_focus(this.field.components[this.index]);
return true;}
return true;};
var char_field=function(param){
if(!param)return;
var font=param.font_size||38;
this.width=param.width||1000;
this.height=param.height||100;
this.translate=param.translate||[0,0,0];
this.multi=param.multi||false;
this.align=param.align||LEFT;
this.is_lock=false;
this.components=[
this.back_field=new gbox({
width:this.width+4,height:this.height+4,
color:[0,0,0,50]
}),
this.field=new gbox({
width:this.width,height:this.height,
}),
this.single_text=new gtext({
width:this.width-4,align:LEFT,
font_size:font,translate:[0,2,0],
color:[0,0,0,255],align:this.align
}),
this.multi_text=new gtextbox({
width:this.width-10,height:this.height,
font_size:font,color:[0,0,0,255],
align:this.align,
})
];
if(this.multi){
this.single_text.visible_p=false;}else {
this.multi_text.visible_p=false;}
};
char_field.prototype=new container({});
char_field.prototype.setText=function(text){
if(!text)text="";
if(this.multi){
setf_text(this.multi_text,text);}else {
setf_text(this.single_text,text);}
};
char_field.prototype.getText=function(){
if(this.multi){
return this.multi_text.text;}else {
return this.single_text.text;}
};
char_field.prototype.set_lock=function(bool){
if(bool){
this.is_lock=true;
this.field.color=[162,162,162,150];}else {
this.is_lock=false;
this.field.color=[255,255,255,255];}
};
char_field.prototype.lock_status=function(){
return this.is_lock;};
char_field.prototype.set_width=function(width){
if(!width)return;
this.width=width;
this.back_field.width=width+4;
this.field.width=width;
this.single_text.width=width-4;
this.multi_text.width=width-10;};
char_field.prototype.free=calendar_util.FREE_FUNC;
char_field.prototype.key_hook=function(up_down,key){
if(up_down!=KEY_PRESS)return true;};
var checkBox=function(param){
if(!param)return;
this.translate=param.translate||[0,0,0];
this.width=param.width;
this.height=param.height;
this.is_check=false;
this.components=[
this.non_check=new gimage({
width:this.width,height:this.height,
src:png_path+"check_none.png",
}),
this.check=new gimage({
width:this.width,height:this.height,
src:png_path+"check_box.png",
visible_p:false
})
];};
checkBox.prototype=new container({});
checkBox.prototype.enable=function(){
this.is_check=true;
this.check.visible_p=true;};
checkBox.prototype.disable=function(){
this.is_check=false;
this.check.visible_p=false;};
checkBox.prototype.free=calendar_util.FREE_FUNC;
var time_edit_panel=new container({});
time_edit_panel.create=function(param){
this.focus=new Focus();
this.focus.setShow(false);
this.translate=[0,-1000,0];
this.visible_p=false;
this.index=0;
this.set_callback=null;
this.close_callback=null;
this.field=new container({});
this.components=[
this.shade=new gbox({
width:1920,height:1080,
color:[0,0,0,200],
visible_p:false
}),
this.bg=new gimage({
width:800,height:540,
src:png_path+"kbd_bg.png",
draw_type:DIRECT
}),
this.title=new gtext({
width:700,height:50,
translate:[0,210,0],
font_size:40,align:CENTER,
}),
this.slash_one=new gtext({
width:30,translate:[-30,98,0],
font_size:80,
text:"/"
}),
this.slash_two=new gtext({
width:30,translate:[135,98,0],
font_size:80,
text:"/"
}),
new gtext({
width:20,translate:[0,-62,0],
font_size:80,
text:":"
}),
this.am_pm=new gtext({
width:100,font_size:40,
translate:[20,0,0],
visible_p:is_ampm
}),
this.field,
this.focus
];
this.set_parts_position();
this.moveTo=MoveTo;};
time_edit_panel.show=function(param){
var time=param.time;
if(!time||isNaN(time))return;
set_cursor(sobj,this);
this.set_callback=param.set_callback||function(){};
this.close_callback=param.close_callback||function(){};
setf_text(this.title,param.title||"");
this.year.set_value(time.getFullYear());
this.month.set_value(time.getMonth()+1);
this.day.set_value(time.getDate());
if(is_ampm){
var hour=time.getHours();
if(hour>=12){
setf_text(this.am_pm,PM);
if(hour!=12)hour-=12;}else {
setf_text(this.am_pm,AM);
if(hour==0)hour=12;}
this.hour.set_value(hour);}else {
this.hour.set_value(time.getHours());}
this.min.set_value(time.getMinutes());
this.visible_p=true;
this.focus.setSize(this.field.components[0].width,this.field.components[0].height);
this.focus.setTranslate(this.field.components[0].translate[0],this.field.components[0].translate[1],0);
this.focus.setShow(true);
var self=this;
this.moveTo({x:0,y:0,z:0,end_func:function(){
set_cursor(self,self.field.components[0]);}});};
time_edit_panel.hide=function(){
this.index=0;
set_cursor(this,null);
var self=this;
this.close_callback();
this.moveTo({x:0,y:-1000,z:0,end_func:function(){
self.year.set_value("");
self.month.set_value("");
self.day.set_value("");
self.hour.set_value("");
self.min.set_value("");}});};
time_edit_panel.set_parts_position=function(){
this.year=new num_field({
width:200,height:80,
min:1900,max:2100,
});
this.month=new num_field({
width:100,height:80,
min:1,max:12,
});
this.day=new num_field({
width:100,height:80,
min:1,max:31,
});
this.hour=new num_field({
width:100,height:80,
min:is_ampm?1:0,max:is_ampm?12:23,
translate:[-90,-70,0],
});
this.min=new num_field({
width:100,height:80,
min:0,max:59,
translate:[90,-70,0],
});
this.ok=new calendar_util.Btn({
width:180,height:50,
font_size:28,align:CENTER,
translate:[0,-200,0],
text:"OK"
});
if(is_ampm){
var self=this;
var ampm_change=function(){
if(self.am_pm.text==AM){
setf_text(self.am_pm,PM);}else {
setf_text(self.am_pm,AM);}
};
this.hour.set_change_callback(ampm_change);}
try{
var country=system.locale.country;
var product=system.product;}catch(e){
var country="DE";
var product="GBL13MT5590_EU";}
if(product.match(/GBL.+JP/)
||(country=="SG")||(country=="HK")||(country=="CN")||(country=="TW")){
this.year.translate=[-165,90,0];
this.slash_one.translate=[-30,98,0];
this.month.translate=[50,90,0];
this.slash_two.translate=[135,98,0];
this.day.translate=[220,90,0];
this.field.components.push(this.year);
this.field.components.push(this.month);
this.field.components.push(this.day);}else if(product.match(/GBL.+US/)){
this.month.translate=[-220,90,0];
this.slash_one.translate=[-130,98,0];
this.day.translate=[-45,90,0];
this.slash_two.translate=[50,98,0];
this.year.translate=[195,90,0];
this.field.components.push(this.month);
this.field.components.push(this.day);
this.field.components.push(this.year);}else {
this.day.translate=[-220,90,0];
this.slash_one.translate=[-130,98,0];
this.month.translate=[-45,90,0];
this.slash_two.translate=[50,98,0];
this.year.translate=[195,90,0];
this.field.components.push(this.day);
this.field.components.push(this.month);
this.field.components.push(this.year);}
this.field.components.push(this.hour);
this.field.components.push(this.min);
this.field.components.push(this.ok);};
time_edit_panel.get_ampm=function(){
return this.am_pm.text||AM;};
time_edit_panel.get_date=function(){
var hour=this.hour.get_value();
if(is_ampm){
var am_pm=this.get_ampm();
if(am_pm==PM){
if(hour!=12)hour=Number(hour)+12;}else {
if(hour==12)hour=0;}
}
return this.year.get_value()+"/"+
this.month.get_value()+"/"+
this.day.get_value()+" "+
hour+":"+
this.min.get_value();};
time_edit_panel.valid_check=function(){
var input_date=this.year.get_value()+"/"+this.month.get_value()+"/"+this.day.get_value();
var conv_date=new Date(input_date);
if(isNaN(conv_date))return false;
var year=conv_date.getFullYear();
var month=(conv_date.getMonth()+1)<10?"0"+(conv_date.getMonth()+1):(conv_date.getMonth()+1);
var date=conv_date.getDate()<10?"0"+conv_date.getDate():conv_date.getDate();
if(input_date==(year+"/"+month+"/"+date)){
return true;}
return false;};
time_edit_panel.move_focus=function(obj){
if(!obj)return;
this.focus.moveTo(obj.translate,[obj.width,obj.height],0,50,null);};
time_edit_panel.free_func=calendar_util.FREE_FUNC;
time_edit_panel.free=function(){
for(var i=0;i<this.field.components.length;i++){
this.field.components[0].free();}
this.free_func();};
time_edit_panel.enter_focus=function(){
};
time_edit_panel.leave_focus=function(){
};
time_edit_panel.key_hook=function(up_down,key){
if(up_down!=KEY_PRESS)return true;
if(this.cursor&&this.cursor.key_hook&&this.cursor.key_hook(up_down,key)){
return true;}
switch(key){
case TXK_RETURN:
this.hide();
return true;
case TXK_ENTER:
var judge=this.valid_check();
if(judge){
var set_date=this.get_date();
this.set_callback(set_date);
this.hide();}else {
}
return true;
case TXK_UP:
if(this.index==this.field.components.length-1){
this.index--;
set_cursor(this,this.field.components[this.index]);
this.move_focus(this.field.components[this.index]);}
return true;
case TXK_LEFT:
if(this.index==0)return true;
this.index--;
set_cursor(this,this.field.components[this.index]);
this.move_focus(this.field.components[this.index]);
return true;
case TXK_RIGHT:
if(this.index>=this.field.components.length-1)return true;
this.index++;
if(this.index==this.field.components.length-1){
set_cursor(this,null);}else {
set_cursor(this,this.field.components[this.index]);}
this.move_focus(this.field.components[this.index]);
return true;};
return true;};
var num_field=function(param){
if(!param)return;
this.min=param.min||0;
this.max=param.max||2100;
this.width=param.width||100;
this.height=param.height||400;
this.translate=param.translate||[0,0,0];
this.change_callback=function(){};
this.components=[
this.back_field=new gbox({
width:this.width+4,height:this.height+4,
color:[0,0,0,50]
}),
this.field=new gbox({
width:this.width,height:this.height,
}),
this.num=new gtext({
width:this.width,
color:[0,0,0,255],
align:CENTER,font_size:80,
text:param.text
}),
this.up=new gimage({
width:20,height:20,
src:png_path+"up.png",
translate:[0,this.height/2+20,0],
visible_p:false,
}),
this.down=new gimage({
width:20,height:20,
src:png_path+"down.png",
translate:[0,-this.height/2-20,0],
visible_p:false
})
];};
num_field.prototype=new container({});
num_field.prototype.set_value=function(value){
if(value<10)value="0"+value;
setf_text(this.num,value.toString());};
num_field.prototype.get_value=function(){
return this.num.text;};
num_field.prototype.set_change_callback=function(callback){
this.change_callback=callback||function(){};};
num_field.prototype.num_up=function(){
var value=Number(this.num.text);
value++;
if(is_ampm){
if(this.max==value){
this.change_callback();}
if(this.max<value){
value=this.min;}
}else {
if(this.max<value)value=this.min;}
this.set_value(value);};
num_field.prototype.num_down=function(){
var value=Number(this.num.text);
value--;
if(is_ampm){
if((this.max-1)==value){
value=this.max-1;
this.change_callback();}else if(this.min>value){
value=this.max;}
}else {
if(this.min>value){
value=this.max;
this.change_callback();}
}
this.set_value(value);};
num_field.prototype.enter_focus=function(){
this.up.visible_p=true;
this.down.visible_p=true;
force_redraw();};
num_field.prototype.leave_focus=function(){
this.up.visible_p=false;
this.down.visible_p=false;
force_redraw();};
num_field.prototype.free=calendar_util.FREE_FUNC;
num_field.prototype.key_hook=function(up_down,key){
if(up_down!=KEY_PRESS)return true;
switch(key){
case TXK_ENTER:
return true;
case TXK_UP:
this.num_up();
return true;
case TXK_DOWN:
this.num_down();
return true;}
return false;};
var cal_list_view=new container({visible_p:false});
cal_list_view.create=function(){
this.focus=new Focus();
this.focus.setShow(false);
this.translate=[0,0,0];
this.index=0;
this.select_index=0;
this.set_callback=null;
this.close_callback=null;
this.item=new container({});
this.components=[
this.bg=new gimage({
width:500,height:600,
src:png_path+"kbd_bg.png",
draw_type:DIRECT
}),
this.title=new gtext({
width:500,
translate:[0,240,0],
font_size:42,align:CENTER,
text:CL_MSG("LT_CL_CALENDAR")
}),
this.field=new gbox({
width:400,height:350,
translate:[0,10,0]
}),
this.item,
this.ok=new calendar_util.Btn({
width:150,height:60,
font_size:28,align:CENTER,
translate:[0,-225,0],
text:CL_MSG("LT_OK")
}),
this.focus
];};
cal_list_view.show=function(param){
if(!param)return;
this.set_data(param)
this.focus.setSize(400,70);
this.focus.setTranslate(0,150,0);
this.focus.setShow(true);
this.visible_p=true;};
cal_list_view.hide=function(){
this.visible_p=false
this.index=0;
this.close_callback();};
cal_list_view.free_func=calendar_util.FREE_FUNC;
cal_list_view.free=function(){
this.ok.free();
for(var i=0;i<this.item.components.length;i++){
this.item.components[i].free();}
this.free_func();};
cal_list_view.set_data=function(param){
if(!param)return;
this.set_callback=param.set_callback||function(){};
this.close_callback=param.close_callback||function(){};
var cal_list=param.list;
var choice_cal=param.choice;
this.item.components=[];
for(var i=0;i<cal_list.length;i++){
var y=(140+this.field.translate[1])-i*70;
var choice=false;
if(choice_cal==cal_list[i].calendar_name){
choice=true;
this.select_index=i;}
this.item.components.push(
new list_item({
width:400,height:70,
icon_width:35,icon_height:35,
translate:[0,y,0],
text:cal_list[i].calendar_name,
line:true,choice:choice
})
);};};
cal_list_view.enter_action=function(){
if(this.index<this.item.components.length){
for(var i=0;i<this.item.components.length;i++){
this.item.components[i].unselect();}
this.item.components[this.index].select();
this.select_index=this.index;}else {
this.set_callback(this.select_index);
this.hide();}
};
cal_list_view.move_focus=function(obj){
if(!obj)return;
this.focus.moveTo(obj.translate,[obj.width,obj.height],0,50,null);};
cal_list_view.enter_focus=function(){
};
cal_list_view.leave_focus=function(){
};
cal_list_view.key_hook=function(up_down,key){
if(up_down!=KEY_PRESS)return true;
switch(key){
case TXK_RETURN:
this.hide();
break;
case TXK_ENTER:
this.enter_action();
break;
case TXK_UP:
if(this.index==0)return true;
this.index--
this.move_focus(this.item.components[this.index]);
break;
case TXK_DOWN:
if(this.index>this.item.components.length-1)return true;
this.index++;
if(this.index<this.item.components.length){
this.move_focus(this.item.components[this.index]);}else {
this.move_focus(this.ok);}
break;}
return true;};
var sft_keyboard_mask=new container({});
sft_keyboard_mask.create=function(){
this.mask=new gbox({
width:1922,
height:1080-80+2,color:[25,25,25,128],
translate:[0,-40,0]});
this.mask.action=function(obj){return;};
this.mask.mouseover=function(obj){return;};
this.mask.mouseout=function(obj){return;};
this.components.push(this.mask);};
sft_keyboard_mask.free=function(){
if(this.components.length==0)return;
this.components.splice(0,this.components.length);};
sft_keyboard_mask.appear=function(){
this.create();};
sft_keyboard_mask.disappear=function(){
this.free();};
var sft_keyboard=new container({visible_p:false});
sft_keyboard.create=function(){
var self=this;
require("kbd");
kbd.set_kbd_skin_path(skin_path);
kbd.set_skin_info({color:"white",size:"MEDIUM"});
this.kbd_bg=new gimage({width:1500,height:780,
src:png_path+"kbd_bg.png",
draw_type:DIRECT,});
this.subject=new gtext({
width:400,
translate:[-460,300,0],
font_size:40,align:LEFT,
color:[255,255,255,255],});
this.kb_item=kbd.create();
this.textarea_cont=new container({});
this.create_textarea_cont({width:this.kb_item.get_kbd_width()});
this.kb_item.set_trg_textarea(this.textarea);
this.components.push(this.kbd_bg,this.subject,this.kb_item);
this.components.push(this.textarea_cont);
this.kb_item.set_height_change_callback(this.change_kb_height);
this.kb_item.set_done_callback(self.done_enter_action);
this.kb_item.set_cancel_callback(self.cancel_enter_action);
if(ebus&&ebus.kbd&&ebus.kbd.supported){
sobj.add_event_hook(ebus.kbd,function(){return self.usb_key_hook(arguments);});}
this.change_kb_height(this.kb_item.get_height());
this.pos_y=-540+this.height/2;
this.focus_out_mode=false;
this.not_appear=false;
this.moveTo=MoveTo;};
sft_keyboard.create_textarea_cont=function(param){
if(this.textarea_cont.components.length>0){
this.textarea_cont.components.splice(0,this.textarea_cont.components.length);}else {
this.textarea_cont.translate=[0,0,0];
this.textarea_cont.set_translate=function(tran){
this.translate=tran.slice();};}
var width=param.width;
var font_size=32;
this.textarea_bg=new gbox({
width:width,height:font_size*1.5,color:[23,23,23,240],
round_enable:true,round_width:4,round_height:4
});
if(this.textarea)this.textarea.free();
if(this.multi){
this.textarea_bg.width=1215;
this.textarea=textarea.create({
width:this.multi_textarea_width,
height:this.multi_textarea_height,
font_size:this.multi_font_size,
char_length_limit:1100,
color_reverse:false,
unconf_margin:10
});}else {
this.textarea=textarea.create({
width:width-20,
font_size:font_size,
char_length_limit:300,
singleline:true,
color_reverse:true,
unconf_margin:20,
});}
this.textarea.set_unconf_bg_param({force_visible:false});
this.textarea_cont.components=[this.textarea_bg,this.textarea];
this.textarea.set_text(this.__text);};
sft_keyboard.set_passwd_mode=function(){
this.kb_item.set_mode("PASSWD");};
sft_keyboard.set_input_char=function(val){
this.kb_item.change_input_char_set({type:val});};
sft_keyboard.appear=function(param){
this.fix=param.fix||false;
this.multi=param.multi;
this.__text=param.text||"";
this.multi_textarea_width=param.textarea_width;
this.multi_textarea_height=param.textarea_height;
this.multi_font_size=param.font_size;
this.done_action_cb=(param.done_cb)?param.done_cb:null;
this.cancel_action_cb=(param.cancel_cb)?param.cancel_cb:null;
this.create();
setf_text(this.subject,param.subject||"");
this.translate[1]=-740-this.height/2;
if(this.multi){
this.textarea_bg.color=[255,255,255,255];
this.kbd_bg.height=param.kbd_bg_height||880;
this.kbd_bg.translate=param.kbd_bg_pos||[0,80,0];
this.textarea_bg.width=param.textarea_bg_width||900;
this.textarea_bg.height=param.textarea_bg_height||200;
this.textarea_bg.translate=param.textarea_bg_pos||[0,70,0];
this.textarea.set_translate(param.textarea_pos||[0,0,0]);
this.subject.translate[1]=param.subject_pos_y||440;
this.subject.translate[0]=-this.textarea_bg.width/2+this.subject.width/2;
this.kb_item.set_softwarekbd_translate(param.sft_kbd_pos||[0,0,0]);
this.moveTo({x:0,y:-100,z:0,end_func:function(){}});}else {
this.moveTo({x:0,y:0,z:0,end_func:function(){}});}
this.kb_item.setText(param.text);
this.visible_p=true;
set_cursor(sobj,this);
if(InputDevManager.get_pointer_status())
this.set_move_mode("free");
else
this.set_move_mode("key");};
sft_keyboard.disappear=function(hook_func){
var self=this;
sobj.del_event_hook(ebus.kbd);
this.moveTo({x:0,y:-940-this.height/2,z:0,end_func:function(){
self.visible_p=false;
self.free();
self.focus_out_mode=false;
if(hook_func)
hook_func();}});};
sft_keyboard.free=function(){
if(this.components.length==0){
return;}
for(var i=0;i<this.components.length;i++){
if(this.components[i] instanceof gtext||this.components[i] instanceof gtextbox){
setf_text(this.components[i],"");}else if(this.components[i] instanceof gimage){
this.components[i].src="";}else if(this.components[i] instanceof container){
for(var j=0,max=this.components[i].components.length;j<max;j++){
if(this.components[i].components[j] instanceof gimage){
this.components[i].components[j].src="";}
}
}
if(this.components[i].free)this.components[i].free();}
this.components.splice(0,this.components.length);};
sft_keyboard.enter_focus=function(){
set_cursor(this,this.kb_item);};
sft_keyboard.leave_focus=function(){
set_cursor(this,null);};
sft_keyboard.done_enter_action=function(){
var self=sft_keyboard;
if(sft_keyboard.done_action_cb){
var text=self.textarea.get_text();
sft_keyboard.done_action_cb(text);
return;}
};
sft_keyboard.cancel_enter_action=function(){
if(sft_keyboard.cancel_action_cb){
sft_keyboard.cancel_action_cb();
return;}
};
sft_keyboard.change_kb_height=function(height){
var self=sft_keyboard;
self.kb_item.set_translate([0,-50+233,0]);
self.textarea_cont.set_translate([0,233,0]);
self.height=height;
if(self.fix)return;
self.subject.translate[0]=-self.kb_item.get_kbd_width()*0.5+200;
self.subject.translate[0]=-self.kb_item.get_kbd_width()*0.5+200;
self.__text=self.textarea.get_text();
self.create_textarea_cont({width:self.kb_item.get_kbd_width()});
self.kb_item.set_trg_textarea(self.textarea);
self.pos_y=self.translate[1];};
sft_keyboard.set_move_mode=function(mode){
if(ebus.mouse){
this.kb_item.set_move_mode(mode);}
};
sft_keyboard.key_hook=function(up_down,key){
var ret=false;
if((this.cursor==this.kb_item)&&(!this.focus_out_mode)){
if((key==TXK_UP)||(key==TXK_DOWN)||(key==TXK_LEFT)||(key==TXK_RIGHT)){
this.set_move_mode("key");}
ret=this.kb_item.keyhook(up_down,key);
switch(key){
case TXK_UP:
case TXK_DOWN:
case TXK_LEFT:
case TXK_RIGHT:
case TXK_ENTER:
return true;}
}
if(up_down!=KEY_PRESS)return true;
return ret;};
sft_keyboard.usb_key_hook=function(arg){
if(InputDevManager.get_pointer_status()){
InputDevManager.pointer_disappear();}
this.set_move_mode("key");
return this.kb_item.usb_key_hook(
arg[0],arg[1],arg[2],arg[3],arg[4],arg[5],arg[6]
);};
sft_keyboard.asr_hook=function(arg){
if(this.kb_item.asr_hook&&typeof this.kb_item.asr_hook=="function"){
this.kb_item.asr_hook(arg);}
};
var obutton=0;
var mouse_hook=function (){
var ret=false;
var button=arguments[3];
var mouse_pos_x=system.cursor_pointer.get_pos_x();
var mouse_pos_y=system.cursor_pointer.get_pos_y();
InputDevManager.pointer_appear();
if(sft_keyboard.visible_p){
sft_keyboard.kb_item.set_move_mode("free");
ret=sft_keyboard.kb_item.mouse_hook(arguments);}
obutton=button;
return ret;};
function asr_hook(stage,device,event){
if(sft_keyboard.visible_p){
sft_keyboard.asr_hook(arguments);}
}
var InputDevManager={};
InputDevManager.init=function(){
this.move_mode="key";
this.pointer_status=true;};
InputDevManager.set_move_mode=function(mode){
if(mode==this.move_mode)return;
if(mode=="free"){
this.pointer_appear();
this.move_mode="free";
this.set_free();}else if(mode=="key"){
this.pointer_disappear();
this.move_mode="key";
this.set_key();}else{
this.pointer_appear();
this.move_mode="hybrid";
this.set_hybrid();}
};
InputDevManager.get_move_mode=function(){
return this.move_mode;};
InputDevManager.pointer_appear=function(){
if(system.cursor_pointer){
system.cursor_pointer.set_timeout(0);
system.cursor_pointer.force_show();
this.set_pointer_status(true);}
};
InputDevManager.pointer_disappear=function(){
if(system.cursor_pointer){
system.cursor_pointer.set_timeout(1);
system.cursor_pointer.force_show();
this.set_pointer_status(false);}
};
InputDevManager.set_pointer_status=function(state){
this.pointer_status=state;};
InputDevManager.get_pointer_status=function(){
return this.pointer_status;};
InputDevManager.set_key=function(){};
InputDevManager.set_free=function(){};
InputDevManager.set_hybrid=function(){};
var sch_setting=
{
width:1488,
height:920,
translate:[0,-333,0],
src:png_path+"memo_bg_no_up.png",
src_l:png_path+"memo_bg_no_up_l.png",
src_r:png_path+"memo_bg_no_up_r.png",
src_lr_width:50,
move_y:195,
memo_text:
{
width:100,
translate:[-670,118,0],
font_size:25,
text:CL_MSG("LT_CL_MEMO"),
color:[104,96,80,255],
},
guide:
{
width:1560,
height:100,
translate:[0,-300,0],
move_y:-180,
color:[112,112,112,196],
font_size:48,
text:CL_MSG("LT_CL_SELECT_DATE"),
text_color:[255,255,255,255],
},
button:
{
width:300,
height:80,
translate:[0,-670,0],
font_size:40,
text:CL_MSG("LT_PM_RETURN"),
},
edit_guide:
{
width:1400,
translate:[0,-550,0],
font_size:48,
text:CL_MSG("LT_CL_ADD_MEMO"),
text_color:[24,24,24,255],
},
max_sch_num:4,
};
var EDIT_MODE=
{
CREATE:0,
EDIT:1,
DELETE:2,
};
var sch_detail_popup=new container({visible_p:false});
sch_detail_popup.create=function(){
this.width=1200;
this.height=470;
this.edit_func=null;
this.delete_callback=null;
this.close_callback=null;
this.focus=new Focus();
this.focus.setShow(false);
this.index=0;
this.calendar_id="";
this.event_id="";
this.components=[
this.bg_mask=new gbox({
width:this.width-60,height:this.height-10,
translate:[-11,4,0],
color:[0,0,0,255],
}),
this.popup_m=new gimage({
width:this.width,height:this.height,
src:"edit_option_m.png",
draw_type:DIRECT,
}),
this.popup_t=new gimage({
width:this.width,height:36,
translate:[0,this.height/2+36/2,0],
src:"edit_option_t.png",
draw_type:DIRECT,
}),
this.popup_b=new gimage({
width:this.width,height:18,
translate:[0,-(this.height/2+18/2),0],
src:"edit_option_b.png",
draw_type:DIRECT,
}),
this.sch_title=new gtextbox({
width:this.width-100,
height:78,
translate:[-10,0,0],
font_size:40,align:LC_TEXT_ALIGN,
}),
this.time=new gtext({
width:this.width-100,
translate:[-10,120,0],
font_size:25,
align:LEFT,
}),
this.description=new gtextbox({
width:this.width-100,height:270,
translate:[-10,-73,0],
font_size:25,align:LC_TEXT_ALIGN,
}),
this.edit=new calendar_util.Btn({
width:140,height:50,
font_size:25,align:CENTER,
translate:[-130,-175,0],
text:CL_MSG("LT_CL_EDIT")
}),
this.del=new calendar_util.Btn({
width:140,height:50,
font_size:25,align:CENTER,
translate:[130,-175,0],
text:CL_MSG("LT_CL_DELETE")
}),
this.focus,
];};
sch_detail_popup.appear=function(){
this.create();};
sch_detail_popup.disappear=function(){
this.visible_p=false;
this.free();};
sch_detail_popup.free=calendar_util.FREE_FUNC;
sch_detail_popup.show=function(param){
if(!param)return;
set_cursor(sobj,this);
this.set_data(param);
this.focus.setTranslate(-130,-175,0);
this.focus.setSize(this.edit.width,this.edit.height);
this.visible_p=true;};
sch_detail_popup.set_data=function(param){
this.calendar_id=param.calendar_id||"";
this.event_id=param.event_id||"";
this.translate=param.translate||[0,0,0];

this.edit_func=param.edit_func||function(){};
this.delete_callback=param.delete_func||function(){};
this.close_callback=param.close_func||function(){};
var limit=this.bg_mask.height-30-this.edit.height-30;
var size_over=false;
this.sch_title.height=get_text_font_height(this.sch_title,param.summary);
if(limit<this.sch_title.height){
this.sch_title.height=limit;
size_over=true;}
this.sch_title.translate[1]=Math.floor(this.bg_mask.height/2-this.sch_title.height/2-10);
setf_text(this.sch_title,param.summary||"");
if(size_over)return;

limit-=this.sch_title.height;
var timeZone=param.timeZone;
var start=getFormattedDateString(new Date(param.start));
if(param.start_tz&&param.start_tz!=timeZone)start+=" "+"("+param.start_tz+")";
var end=getFormattedDateString(new Date(param.end));
if(param.end_tz&&param.end_tz!=timeZone)end+=" "+"("+param.end_tz+")";
var time=start+"  -  "+end;
if(limit<get_text_font_height(this.time,this.time.text)){
time="";
size_over=true;}
this.time.translate[1]=Math.floor(this.sch_title.translate[1]-this.sch_title.height/2-25);
setf_text(this.time,time);
limit-=get_text_font_height(this.time,this.time.text);
if(size_over)return;
if((limit-30)>0){
this.description.height=limit-30;
this.description.translate[1]=Math.floor(this.time.translate[1]-this.description.height/2-30);
setf_text(this.description,param.description||"");}
};
sch_detail_popup.hide=function(){
this.visible_p=false;
this.index=0;
this.calendar_id="";
this.event_id="";
setf_text(this.sch_title,"");
setf_text(this.time,"");
setf_text(this.description,"");
set_cursor(sobj,null);
this.close_callback();};
sch_detail_popup.edit_action=function(){
this.edit_func();};
sch_detail_popup.delete_action=function(){
var self=this;
google_calendar.delete_schedule({
calendar_id:this.calendar_id,
event_id:this.event_id,
callback:function(){
self.hide();
self.delete_callback();},
error_callback:function(error_code){
loading.hide();
notice_panel.show({
title:CL_MSG("LT_CL_DEL_FAILED"),
description:CL_MSG("LT_LD_NETWORK_ERROR")+"("+error_code+")",
close_callback:function(){
set_cursor(sobj,self);
self.focus.setShow(true);}
});}
});};
sch_detail_popup.enter_focus=function(){
this.focus.setShow(true);};
sch_detail_popup.leave_focus=function(){
this.focus.setShow(false);};
sch_detail_popup.key_hook=function(up_down,key){
switch(key){
case TXK_RETURN:
this.hide();
break;
case TXK_LEFT:
case TXK_RIGHT:
if(this.index==0){
this.index++;
this.focus.moveTo(this.del.translate,[140,50],0,50,null);}else {
this.index--;
this.focus.moveTo(this.edit.translate,[140,50],0,50,null);}
break;
case TXK_ENTER:
if(this.index==0){
this.edit_action();}else {
this.delete_action();}
break;}
return true;};
var sch_tab=function(param){
if(!param)return;
var width=param.width||200;
var height=param.height||80;
var left_width=param.left_width||30;
var right_width=param.right_width||30;
this.translate=param.translate||[0,0,0];
this.components=[
this.unselect_tab=new gimage({
width:width,height:height,
draw_type:DIRECT,
src:png_path+"unselect_tab.png",
}),
this.unselect_tab_l=new gimage({
width:left_width,height:height,
draw_type:DIRECT,
translate:[this.unselect_tab.translate[0]-this.unselect_tab.width/2-left_width/2,0,0],
src:png_path+"unselect_tab_l.png",
}),
this.unselect_tab_r=new gimage({
width:right_width,height:height,
draw_type:DIRECT,
translate:[this.unselect_tab.translate[0]+this.unselect_tab.width/2+right_width/2,0,0],
src:png_path+"unselect_tab_r.png",
}),
this.select_tab=new gimage({
width:width,height:height,
draw_type:DIRECT,
src:png_path+"select_tab.png",
}),
this.select_tab_l=new gimage({
width:left_width,height:height,
draw_type:DIRECT,
translate:[this.select_tab.translate[0]-this.select_tab.width/2-left_width/2,0,0],
src:png_path+"select_tab_l.png",
}),
this.select_tab_r=new gimage({
width:right_width,height:height,
draw_type:DIRECT,
translate:[this.select_tab.translate[0]+this.select_tab.width/2+right_width/2,0,0],
src:png_path+"select_tab_r.png",
}),
this.label=new gtext({
width:195,translate:param.label_pos,
font_size:sch_setting.memo_text.font_size,
color:sch_setting.memo_text.color,
translate:[12,-6,0],
text:param.label,
}),
];
this.label.font_size=getFontSizeOfText(this.label,this.label.text,22);
setf_text(this.label,this.label.text);};
sch_tab.prototype=new container({});
sch_tab.prototype.select=function(){
this.select_tab.visible_p=true;
this.select_tab_l.visible_p=true;
this.select_tab_r.visible_p=true;
this.unselect_tab.visible_p=false;
this.unselect_tab_l.visible_p=false;
this.unselect_tab_r.visible_p=false;
force_redraw();};
sch_tab.prototype.unselect=function(){
this.select_tab.visible_p=false;
this.select_tab_l.visible_p=false;
this.select_tab_r.visible_p=false;
this.unselect_tab.visible_p=true;
this.unselect_tab_l.visible_p=true;
this.unselect_tab_r.visible_p=true;
force_redraw();};
var schObj=function(cal_obj)
{
var i;
this.superClass=container;
this.superClass({});
this.translate=sch_setting.translate.slice();
this.focus=new Focus();
this.focus.setShow(false);
this.cal_obj=cal_obj;
this.moveTo=MoveTo;
this.select_tab_view=false;
this.edit_mode=false;
this.is_popup=false;
this.is_open_guide=false;
this.is_return_focus=false;
this.is_err=false;
this.google_view=false;
this.slide_index=0;
this.move_page=0;
this.calendar_list=[];
this.google_data=[];
this.all_data=[];
this.detail_popup=sch_detail_popup;
this.edit_panel=sch_edit_panel;
this.base
=new gimage({
width:sch_setting.width,
height:sch_setting.height,
draw_type:DIRECT,
src:sch_setting.src,
translate:sch_setting.translate,
visible_p:true,});
this.base_l
=new gimage({
width:sch_setting.src_lr_width,
height:sch_setting.height,
draw_type:DIRECT,
src:sch_setting.src_l,
translate:[
sch_setting.translate[0]
-Math.floor(sch_setting.width/2
+sch_setting.src_lr_width/2),
sch_setting.translate[1],
sch_setting.translate[2]
],
visible_p:true,});
this.base_r
=new gimage({
width:sch_setting.src_lr_width,
height:sch_setting.height,
draw_type:DIRECT,
src:sch_setting.src_r,
translate:[
sch_setting.translate[0]
+Math.floor(sch_setting.width/2
+sch_setting.src_lr_width/2),
sch_setting.translate[1]-2,
sch_setting.translate[2]
],
visible_p:true,});
this.memo_icon=new gimage({
width:18,height:18,
translate:[270,115,0],
draw_type:DIRECT,
src:png_path+"sch_mark.png",
});
this.memo_tab=new sch_tab({
label:CL_MSG("LT_CL_MEMO"),
label_pos:[0,0,0],
width:180,height:64,
left_width:50,right_width:50,
translate:[375,123,0],
});
this.google_icon=new gimage({
width:23,height:23,
translate:[535,115,0],
draw_type:DIRECT,
src:png_path+"google_logo.png",
});
this.google_tab=new sch_tab({
label:CL_MSG("LT_CL_GOOGLE_CAL"),
label_pos:[0,0,0],
width:180,height:64,
left_width:50,right_width:50,
translate:[638,123,0],
});
this.tab_bg=new gimage({
width:1550,height:82,
translate:[0,113,0],
draw_type:DIRECT,
src:png_path+"tab_bg.png"
});
this.change_color=new gimage({
width:25,height:20,
draw_type:DIRECT,
src:CHANGE_KEY.image,
translate:[-225,115,0],
visible_p:false
});
this.change_text=new gtext({
width:370,
translate:[45,116,0],
font_size:22,
color:[104,96,80,255],
align:RIGHT,
visible_p:false
});
this.append_list=new calendar_util.appendList(sch_setting.max_sch_num);
this.append_list.setTranslate(0,14,0);
this.scrollbar=new container({visible_p:false});
this.scrollbar.translate=[580,-60,0];
this.more_text=new gtext({
width:200,
translate:[665,-180,0],
color:[104,96,80,255],
font_size:42,
visible_p:false,
});
this.more_text.font_size=getFontSizeOfText(this.more_text,CL_MSG("LT_CL_MORE"),20);
setf_text(this.more_text,CL_MSG("LT_CL_MORE"));

this.scroll_bg=new gbox({
width:16,height:290,
round_enable:true,
round_width:5,round_height:5,
});
this.bar=new gbox({
width:12,height:65,
color:[206,198,188,255],
round_enable:true,
round_width:5,round_height:5,
});
this.scrollbar.components.push(this.scroll_bg);
this.scrollbar.components.push(this.bar);
this.return_btn=new calendar_util.Btn({
width:sch_setting.button.width,
height:sch_setting.button.height,
font_size:sch_setting.button.font_size,align:CENTER,
translate:sch_setting.button.translate.slice(),
text:sch_setting.button.text,
});
this.guide=new container({});
this.guide.translate=
[
sch_setting.guide.translate[0],
sch_setting.guide.translate[1],
sch_setting.guide.translate[2]
];
this.guide_bg=new gbox({
width:sch_setting.guide.width,
height:sch_setting.guide.height,
color:sch_setting.guide.color});
this.guide_text
=new gtext({
width:sch_setting.guide.width,
translate:[0,10,0],
text:sch_setting.guide.text,align:CENTER,
font_size:sch_setting.guide.font_size,
color:sch_setting.guide.text_color,
});
this.guide.moveTo=MoveTo;
this.edit_guide_text
=new gtext({
width:sch_setting.edit_guide.width,
translate:sch_setting.edit_guide.translate,
text:sch_setting.edit_guide.text,align:CENTER,
font_size:sch_setting.edit_guide.font_size,
color:sch_setting.edit_guide.text_color,
visible_p:false,
});
this.guide.components.push(this.guide_bg,this.guide_text);
this.components.push(
this.tab_bg,
this.frame,
this.base,
this.base_l,
this.base_r,
this.memo_tab,
this.memo_icon,
this.google_tab,
this.google_icon,
this.change_color,
this.change_text,
this.edit_guide_text,
this.append_list,
this.guide,
this.return_btn,
this.focus,
this.scrollbar,
this.more_text,
this.detail_popup
);
this.cal_obj.onFocus();
this.refreshSchedule();
this.openGuide();
this.setFocusObj(this.focus);
this.set_tab();}
schObj.prototype.setFocusObj=function(focus_obj)
{
this.append_list.setFocusObj(focus_obj);}
schObj.prototype.setErrPanel=function(panel)
{
this.err_pnl=panel;}
schObj.prototype.openGuide=function()
{
var self=this;
this.guide.visible_p=true;
this.guide.moveTo({x:0,y:sch_setting.guide.move_y,
z:0,rate:0,end_func:function(){}});
this.is_open_guide=true;
this.closeGuideByTimer=function()
{
delete_timer(self);
if(self.is_open_guide)
{
self.closeGuide();}
}
append_timer(this,5000,this.closeGuideByTimer);}
schObj.prototype.closeGuide=function()
{
if(this.is_open_guide)
{
this.guide.moveTo({x:0,y:sch_setting.guide.translate[1],
z:0,rate:0,end_func:function(){}});
this.is_open_guide=false;
this.guide.visible_p=false;}
}
schObj.prototype.view_scroll_bar=function(bool){
this.scrollbar.visible_p=bool;};
schObj.prototype.scroll_move=function(down){
if(down){
this.bar.translate[1]-=this.bar.height;}else {
this.bar.translate[1]+=this.bar.height;}
};
schObj.prototype.scroll_reset=function(){
this.bar.height=(this.scroll_bg.height-5)/(this.all_data.length-3);
this.bar.translate[1]=(this.scroll_bg.height-5)/2-this.bar.height/2;};
schObj.prototype.view_more_text=function(bool){
this.more_text.visible_p=bool;};
schObj.prototype.delete_google_schedule=function(key,value){
for(var i=0;i<this.google_data.length;i++){
if(this.google_data[i].items[key]==value){
this.google_data.splice(i,1);}
}
for(var i=0;i<this.all_data.length;i++){
if(this.all_data[i].items[key]&&this.all_data[i].items[key]==value){
this.all_data.splice(i,1);}
};};
schObj.prototype.openSchedule=function()
{
if(this.all_data.length>4){
this.view_scroll_bar(true);
this.view_more_text(false);}
this.cal_obj.offFocus();
this.moveTo({x:0,y:sch_setting.move_y,z:0,end_func:function(){}});
this.edit_mode=true;
this.edit_guide_text.visible_p=true;
this.cal_obj.changeYMText(this.edit_mode);
this.append_list.onFocus(this.translate);
this.setGuide(this.append_list.getListIndex());
this.focus.setShow(true);}
schObj.prototype.closeSchedule=function()
{
this.view_scroll_bar(false);
if(this.all_data.length>4)this.view_more_text(true);
this.append_list.setFocusOnTop();
this.append_list.offFocus();
this.edit_guide_text.visible_p=false;
this.moveTo({x:0,y:sch_setting.translate[1],z:0,end_func:function(){}});
this.edit_mode=false;
this.cal_obj.changeYMText(this.edit_mode);
this.cal_obj.onFocus();
this.is_return_focus=false;}
schObj.prototype.view_change_text=function(bool){
if(!this.select_tab_view)return;
if(bool){
this.change_color.visible_p=true;
this.change_text.visible_p=true;}else {
this.change_color.visible_p=false;
this.change_text.visible_p=false;}
};
schObj.prototype.change_tab=function(mode){
if(!mode)return;
if(mode==DEFAULT){
this.memo_tab.select();
this.google_tab.unselect();
setf_text(this.change_text,CL_MSG("LT_CL_CHANGE_GOOGLE"));}else {
this.google_tab.select();
this.memo_tab.unselect();
var change_memo=CL_MSG("LT_CL_CHANGE_MEMO");
setf_text(this.change_text,change_memo.replace("_LT_CL_MEMO_",CL_MSG("LT_CL_MEMO")));}
var text_width=get_text_width(this.change_text,this.change_text.text);
this.change_color.translate[0]=this.change_text.translate[0]+this.change_text.width/2-
text_width-20;};
schObj.prototype.set_tab=function(){
var mode=nvram_manager.read_mode();
if(mode){
this.change_tab(mode);}else {
this.change_tab(DEFAULT);}
var login_account=nvram_manager.get_login_data();
if(login_account){
this.select_tab_view=true;
this.view_change_text(true);}else {
this.view_change_text(false);
this.select_tab_view=false;}
};
schObj.prototype.loading_view=function(bool){
if(bool){
if(this.edit_mode){
this.append_list.loading_view(true);}else {
this.cal_obj.loading_view(true);}
}else {
this.append_list.loading_view(false);
this.cal_obj.loading_view(false);}
};
schObj.prototype.refreshSchedule=function()
{
var year,month,date,day,ret;
var mode=account_list.get_view_mode();
if(!mode)mode=nvram_manager.read_mode();
ret=this.cal_obj.focus_info.getFocusDate();
year=ret[0];
month=ret[1];
date=ret[2];
day=ret[3];
this.all_data=[];
this.slide_index=0;
if(mode==DEFAULT){
this.setSchedule(year,month+1,date);}else {
this.searchGoogleSchedule(year,month+1,date);}
var default_num=0;
var tab=account_list.get_view_mode();
if(tab==DEFAULT){
default_num=this.append_list.getNewIndex()
}
this.append_list.setDefaultNum(default_num);
this.scroll_reset();
if(this.edit_mode){
if(this.all_data.length>4){
this.view_scroll_bar(true);}else {
this.view_scroll_bar(false);}
this.updateFocus();}else {
if(this.all_data.length>4){
this.view_more_text(true);}else {
this.view_more_text(false);}
}
force_redraw();}
schObj.prototype.guide_view=function(bool){
if(!this.edit_mode||this.is_return_focus)return;
if(bool){
this.edit_guide_text.visible_p=true;}else {
this.edit_guide_text.visible_p=false;}
force_redraw();};
schObj.prototype.setGuide=function(idx)
{
if(idx==-1){
setf_text(this.edit_guide_text,CL_MSG("LT_CL_ADD_MEMO"));}else if(this.append_list.getFrom(idx)==DEFAULT){
setf_text(this.edit_guide_text,CL_MSG("LT_CL_EDIT_MEMO"));}else {
var detail=CL_MSG("LT_CL_VIEW_DETAIL").replace("_LT_OK_",CL_MSG("LT_OK"))
this.edit_guide_text.font_size=getFontSizeOfText(this.edit_guide_text,detail,43);
setf_text(this.edit_guide_text,detail);}
force_redraw();}
schObj.prototype.editSchedule=function(edit_idx)
{
var idx;
var text;
idx=this.append_list.getListIndex();
if(idx!=-1)
{
if(edit_idx==0)
{
text=this.append_list.getText(idx);
this.launchKeyBoard(text);}else
{
this.deleteSchedule(idx);
this.is_popup=false;
this.edit_guide_text.visible_p=true;
this.append_list.closeEditPanel();}
}
else
{
this.launchKeyBoard("");}
}
schObj.prototype.launchKeyBoard=function(in_text)
{
if(sft_keyboard.visible_p)
return;
var self=this;
this.focus.setShow(false);
sft_keyboard_mask.appear();
sft_keyboard.appear({
subject:CL_MSG("LT_CL_MEMO"),
text:in_text,
done_cb:function(text){
self.kbd_done_hook(text);},
cancel_cb:function(){
self.kbd_cancel_hook();}
});}
schObj.prototype.kbd_done_hook=function(text)
{
var idx;
this.close_kbd();
this.append_list.closeEditPanel();
this.is_popup=false;
this.edit_guide_text.visible_p=true;
idx=this.append_list.getListIndex();
this.modifySchedule(idx,text);
}
schObj.prototype.kbd_cancel_hook=function()
{
this.close_kbd();}
schObj.prototype.close_kbd=function()
{
sft_keyboard.disappear();
sft_keyboard_mask.disappear();
set_cursor(sobj,this);
this.focus.setShow(true);}
schObj.prototype.setSchedule=function(year,month,date)
{
var i;
var cal_util=new CalendarUtility();
var sch_list=cal_util.readScheduleData(year,month,date);
this.append_list.resetList();
for(i=0;i<sch_list.length;i++)
{
if(sch_list[i].length!=0)
{
this.append_list.setList(sch_list[i]);
this.append_list.unSetColor(i);
this.all_data.push({"from":DEFAULT,"schedule":sch_list[i]});}
}
}
schObj.prototype.google_reset=function(){
this.google_data=[];
this.refreshSchedule();
this.cal_obj.clearGoogleSchedule();
this.loading_view(false);};
schObj.prototype.updateFocus=function(){
this.append_list.drawBtn();
if(this.is_return_focus||this.is_popup||this.detail_popup.visible_p)return;
this.append_list.onFocus();
this.setGuide(this.append_list.getListIndex());};
schObj.prototype.add_timeZone=function(timeZone,start_tz,end_tz){
if(!timeZone||!start_tz&&!end_tz)return "";
if(timeZone==start_tz&&timeZone==end_tz)return "";
if(timeZone!=start_tz)return start_tz;
return end_tz;};
schObj.prototype.setGoogleSchedule=function(year,month,date,add_list){
var cal_util=new CalendarUtility();
var sch_list=cal_util.readScheduleData(year,month,date);
for(var i=0;i<add_list.length;i++){
if(i==sch_setting.max_sch_num)break;
var time=this.get_format_time(add_list[i].start_date,add_list[i].end_date);
var timeZone=add_list[i].timeZone;
var start_tz=add_list[i].items.start.timeZone;
var end_tz=add_list[i].items.end.timeZone;
var summary=add_list[i].items.summary||"("+CL_MSG("LT_CL_NO_TITLE")+")";
var add_tz=this.add_timeZone(timeZone,start_tz,end_tz);
if(add_tz){
this.append_list.setGoogleList(time,"("+add_tz+")"+summary);}else {
this.append_list.setGoogleList(time,summary);}
this.append_list.setColor(i,add_list[i].bg_color);}
};
schObj.prototype.get_format_time=function(start,end){
var ret=this.cal_obj.focus_info.getFocusDate();
var year=ret[0];
var month=ret[1]+1;
var day=ret[2];
var today=new Date(year+"/"+month+"/"+day);
var start_date=new Date(start.substr(0,10));
var end_date=new Date(end.substr(0,10));
if(isNaN(start_date)||isNaN(end_date))return "";
var start_time="";
if(today.getTime()==start_date.getTime()){
start_time=start.substr(11,5);}else {
start_time="00:00";}
var end_time="";
if(today.getTime()==end_date.getTime()){
end_time=end.substr(11,5);}else {
end_time="24:00";}
return start_time+" - "+end_time;};
schObj.prototype.update_primary_name=function(name){
if(!name||this.calendar_list.length==0)return;
if(this.calendar_list[0].calendar_id==this.calendar_list[0].calendar_name){
this.calendar_list[0].calendar_name=name;}
};
schObj.prototype.addCalendarList=function(calendar_list){
this.calendar_list=[];
this.calendar_list=calendar_list;};
schObj.prototype.addGoogleSchedule=function(sch_data){
this.google_data=[];
this.google_data=sch_data;};
schObj.prototype.setGooglemark=function(){
this.cal_obj.checkGoogleSchedule(this.google_data);};
schObj.prototype.searchGoogleSchedule=function(year,month,date){
var focus_date=new Date(year+"/"+month+"/"+date);
if(isNaN(focus_date))return;
this.append_list.resetList();
var add_list=[];
for(var i=0;i<this.google_data.length;i++){
var start_day=new Date(this.google_data[i].start_date.substr(0,10));
var end_day=new Date(this.google_data[i].end_date);
if(isNaN(start_day)||isNaN(end_day))continue;
if((start_day.getTime()<=focus_date.getTime())&&
(end_day.getTime()>focus_date.getTime())){
add_list.push(this.google_data[i]);}
}
if(add_list.length==0)return;

var object_sort=function(obj,member){
obj.sort(function(a,b){
var x=a[member];
var y=b[member];
if(x<y)return -1;
if(x>y)return 1;
return 0;});};
object_sort(add_list,"end");
object_sort(add_list,"start");
this.all_data=add_list;
if(add_list.length!=0){
this.setGoogleSchedule(year,month,date,add_list);}

};
schObj.prototype.modifySchedule=function(idx,data)
{
var year,month,date,day,ret;
var sch_list;
var mode,str_len;
var cal_util=new CalendarUtility();
ret=this.cal_obj.focus_info.getFocusDate();
year=ret[0];
month=ret[1];
date=ret[2];
day=ret[3];
sch_list=cal_util.readScheduleData(year,month+1,date);
if(idx==-1&&(data.length!=0)){
mode=EDIT_MODE.CREATE;}else if((idx!=-1)&&((sch_list[idx].length>0)&&(data.length==0))){
this.deleteSchedule(idx);
return true;}else if((idx==-1)&&(data.length==0)){
return true;}else {
mode=EDIT_MODE.EDIT;}
if(idx==-1){
idx=this.append_list.getNewIndex();
str_len=data.length;}else {
str_len=data.length-sch_list[idx].length;}
sch_list[idx+this.slide_index]=data;
this.registSchedule(sch_list,mode,str_len);
this.refreshSchedule();
this.append_list.moveFocus(idx);
this.setGuide(this.append_list.getListIndex());
return true;}
schObj.prototype.deleteSchedule=function(idx)
{
var year,month,date,day,ret;
var sch_list=new Array(sch_setting.max_sch_num);
var cal_util=new CalendarUtility();
ret=this.cal_obj.focus_info.getFocusDate();
year=ret[0];
month=ret[1];
date=ret[2];
day=ret[3];

this.append_list.unsetList(idx);

for(i=0;i<this.append_list.getNewIndex();i++)
{
sch_list[i]=this.append_list.getText(i);}
this.registSchedule(sch_list,EDIT_MODE.DELETE,0);
this.append_list.moveFocus(idx-1);
this.setGuide(this.append_list.getListIndex());}
schObj.prototype.registSchedule=function(sch_list,edit_mode,len)
{
var year,month,date,day,ret;
var cal_util=new CalendarUtility();
var oldest;
var is_enable_write=true;
var cur_date=new Date();
var cur_month=cur_date.getMonth()+1;
var cur_year=cur_date.getFullYear();
ret=this.cal_obj.focus_info.getFocusDate();
year=ret[0];
month=ret[1];
date=ret[2];
day=ret[3];
if((edit_mode!=EDIT_MODE.DELETE)&&(len>0))
{
while(cal_util.canWriteScheduleData(edit_mode,len)==0)
{
oldest=cal_util.getOldestScheduleIdx();

if((oldest[0]==-1)||(oldest[1]==-1))
{
is_enable_write=false;
break;}
else if((oldest[0]<cur_year)||
((oldest[0]==cur_year)&&(oldest[1]<cur_month)))
{
cal_util.cleanUpScheduleData(oldest[0],oldest[1]);}
else
{
is_enable_write=false;
break;}
}
}
if(is_enable_write)
{
if(cal_util.checkScheduleData(year,month+1,date))
{
cal_util.deleteScheduleData(year,month+1,date);}
cal_util.writeScheduleData(year,month+1,date,sch_list);
this.cal_obj.checkSchedule();
this.setSchedule(year,month+1,date);}
else
{
this.focus.setShow(false);
this.err_pnl.appear(CL_MSG("LT_CL_MEMO_MAX_ERROR"));
this.err_pnl.set_focus();
this.is_err=true;}
}
schObj.prototype.open_account_list=function(){
account_list.show();};
schObj.prototype.key_hook=function(up_down,key)
{
if(this.is_err)
{
if(this.err_pnl.key_hook(up_down,key))
{
this.is_err=false;
this.append_list.onFocus();
this.focus.setShow(true);
return true;}
return false;}
if(this.is_popup==true)
{
switch(key)
{
case TXK_UP:
case TXK_DOWN:
this.append_list.edit_panel.key_hook(up_down,key);
return true;
case TXK_ENTER:
this.view_change_text(true);
this.editSchedule(this.append_list.edit_panel.getFocusIdx());
return true;
case TXK_RETURN:
this.view_change_text(true);
this.is_popup=false;
this.edit_guide_text.visible_p=true;
this.append_list.closeEditPanel(false);
return true;}
return true;}
if(this.edit_mode==true)
{
switch(key){
case TXK_RIGHT:
this.open_account_list();
return true;}
if(this.is_return_focus==true)
{
if(key==TXK_ENTER)
{
this.is_return_focus=false;
this.edit_guide_text.visible_p=true;
this.closeSchedule();
return true;}
switch(key)
{
case TXK_UP:
this.append_list.setFocusOnBottom();
this.setGuide(this.append_list.getListIndex());
this.is_return_focus=false;
this.edit_guide_text.visible_p=true;
return true;
case TXK_DOWN:
this.append_list.setFocusOnTop();
this.setGuide(this.append_list.getListIndex());
this.is_return_focus=false;
this.edit_guide_text.visible_p=true;
return true;
default:
break;}
}
else
{
if(this.append_list.checkOutFocus(key)){
var focus_idx=this.append_list.getListIndex();
if(focus_idx==-1||(focus_idx==0&&this.slide_index==0)||
(focus_idx+this.slide_index)==this.all_data.length-1){
var view=account_list.get_view_mode();
if(view==GOOGLE&&key==TXK_DOWN&&focus_idx!=-1){
this.append_list.key_hook(up_down,key);
this.setGuide(this.append_list.getListIndex());}else {
this.setGuide(this.append_list.getListIndex());
this.is_return_focus=true;
this.edit_guide_text.visible_p=false;
var to_pos=[
this.return_btn.translate[0],
this.return_btn.translate[1],
0,
];
var to_size=[this.return_btn.width,this.return_btn.height];
this.focus.moveTo(to_pos,to_size,0,40,function(){});}
return true;}else {
switch(key){
case TXK_DOWN:
if((this.slide_index+sch_setting.max_sch_num)<this.all_data.length){
this.slide_index++;
this.append_list.resetList();
for(var i=this.slide_index;i<(sch_setting.max_sch_num+this.slide_index);i++){
var time=this.get_format_time(this.all_data[i].start_date,this.all_data[i].end_date);
var timeZone=this.all_data[i].timeZone;
var start_tz=this.all_data[i].items.start.timeZone;
var end_tz=this.all_data[i].items.end.timeZone;
var add_tz=this.add_timeZone(timeZone,start_tz,end_tz);
var summary=this.all_data[i].items.summary||"("+CL_MSG("LT_CL_NO_TITLE")+")";
if(add_tz){
this.append_list.setGoogleList(time,"("+add_tz+")"+summary);}else {
this.append_list.setGoogleList(time,summary);}
this.append_list.setColor(i-this.slide_index,this.all_data[i].bg_color);}
this.scroll_move(true);}
return true;
case TXK_UP:
if(this.slide_index>0){
this.slide_index--;
this.append_list.resetList();
for(var i=this.slide_index;i<(sch_setting.max_sch_num+this.slide_index);i++){
var time=this.get_format_time(this.all_data[i].start_date,this.all_data[i].end_date);
var timeZone=this.all_data[i].timeZone;
var start_tz=this.all_data[i].items.start.timeZone;
var end_tz=this.all_data[i].items.end.timeZone;
var add_tz=this.add_timeZone(timeZone,start_tz,end_tz);
var summary=this.all_data[i].items.summary||"("+CL_MSG("LT_CL_NO_TITLE")+")";
if(add_tz){
this.append_list.setGoogleList(time,"("+add_tz+")"+summary);}else {
this.append_list.setGoogleList(time,summary);}
this.append_list.setColor(i-this.slide_index,this.all_data[i].bg_color);}
this.scroll_move(false);}
return true;}
return true;}
}else {
if(this.append_list.key_hook(up_down,key)){
this.setGuide(this.append_list.getListIndex());
return true;}
}
}
if((key!=TXK_ENTER)&&(key!=TXK_RETURN))
{
return false;}
switch(key)
{
case TXK_ENTER:
var mode=account_list.get_view_mode();
if(mode==GOOGLE){
var focus_day=this.cal_obj.focus_info.getFocusDate();
var choice=this.append_list.getListIndex();
var self=this;
if(choice!=-1){
var index=choice+this.slide_index;
var choice_sch=this.all_data[index];
this.view_change_text(false);
this.guide_view(false);
this.focus.setShow(false);
this.detail_popup.show({
translate:[0,-240-(choice*70)-10,0],
summary:choice_sch.items.summary||"("+CL_MSG("LT_CL_NO_TITLE")+")",
start:choice_sch.start_date,
end:choice_sch.end_date,
timeZone:choice_sch.timeZone,
start_tz:choice_sch.items.start.timeZone,
end_tz:choice_sch.items.end.timeZone,
description:choice_sch.items.description,
calendar_id:choice_sch.calendar_id,
event_id:choice_sch.items.id,
edit_func:function(){
self.edit_panel.show({
focus_day:focus_day,
sch_info:choice_sch,
calendar_list:self.calendar_list,
post_callback:function(){
self.view_change_text(true);
self.detail_popup.hide();
set_cursor(sobj,null);},
close_callback:function(){
set_cursor(sobj,self.detail_popup);}
});},
delete_func:function(){
self.view_change_text(true);
self.delete_google_schedule("id",choice_sch.items.id);
self.setGooglemark();
self.refreshSchedule();},
close_func:function(){
self.view_change_text(true);
self.focus.setShow(true);
self.guide_view(true);
set_cursor(sobj,null);}
});}else {
this.edit_panel.show({
focus_day:focus_day,
calendar_list:this.calendar_list,
post_callback:function(){
set_cursor(sobj,null);},
close_callback:function(){
set_cursor(sobj,null);}
});}
break;}else {
this.is_popup=this.append_list.openEditPanel(true);
if(this.is_popup==false){
this.edit_guide_text.visible_p=true;
this.editSchedule(0);}else {
this.view_change_text(false);
this.edit_guide_text.visible_p=false;}
}
break;
case TXK_RETURN:
this.closeSchedule();
break;
default:
break;}
}
else
{
if((key!=TXK_UP)&&(key!=TXK_DOWN)&&
(key!=TXK_LEFT)&&(key!=TXK_RIGHT)&&
(key!=TXK_ENTER))
{
return false;}
if(this.is_open_guide)
{
this.closeGuide();}
var self=this;
var month_move=function(next){
var login_account=nvram_manager.get_login_data();
if(!login_account)return;
if(next){
google_calendar.update({
start_action:function(){
self.move_page++;
if(self.move_page>ADVANCE_MONTH){
self.google_reset();
self.loading_view(true);}
self.setGooglemark();},
get_callback:function(){
self.move_page=0;
self.loading_view(false);}
});}else {
google_calendar.update({
start_action:function(){
self.google_reset();
self.loading_view(true);},
get_callback:function(){
self.move_page=0;
self.loading_view(false);}
});}
}
switch(key)
{
case TXK_UP:
this.cal_obj.moveUp(month_move);
this.refreshSchedule();
break;
case TXK_DOWN:
this.cal_obj.moveDown(month_move);
this.refreshSchedule();
break;
case TXK_LEFT:
this.cal_obj.moveLeft();
this.refreshSchedule();
break;
case TXK_RIGHT:
this.cal_obj.moveRight(this.open_account_list);
this.refreshSchedule();
break;
case TXK_ENTER:
this.openSchedule();
default:
break;}
}
return true;}
var FullCalendarObj=function(width,height){
this.superClass=container;
this.superClass({});
this.components.push(account_list);

this.err_pnl=new calendar_util.errPanel({translate:[0,0,0]});
this.cal_main=new calendar_obj.CalendarObj(
width,height,calendar_obj.DISP_MODE.FULL);
this.cal_main.setTranslate(0,180,0);
this.components.push(this.cal_main);
this.cal_main.drawNow();
this.sch_obj=new schObj(this.cal_main);
this.components.push(this.sch_obj,this.err_pnl);
this.sch_obj.setErrPanel(this.err_pnl);
this.moveTo=MoveTo;}
var full_calendar_obj=new FullCalendarObj(1600,640);
var in_hook=function(obj){
complete_on_stage(obj);
Background.appear();
TopBar.appear();
account_list.appear();
loading.appear();
notice_panel.appear();
terms_of_use.appear();
sch_detail_popup.create();
sch_edit_panel.appear();
cal_list_view.create();
if(ebus.mouse){
add_event_hook(ebus.mouse,mouse_hook);
ebus.mouse.set_callback_symbol("click","action");}
if(ebus.asr)
sobj.add_event_hook(ebus.asr,asr_hook);
InputDevManager.init();

var read_data=nvram_manager.read();
if(!read_data||!read_data.start_up){
var data={mode:DEFAULT};
nvram_manager.write(data);
terms_of_use.show({
first:true,
ok_callback:function(){
var read_data=nvram_manager.read();
read_data.start_up=true;
nvram_manager.write(read_data);
notice_panel.show({
title:CL_MSG("LT_CL_WELCOME"),
description:CL_MSG("LT_CL_SYNC"),
start_up:true,
close_callback:function(){
set_cursor(sobj,null);}
});},
cancel_callback:function(){
on_stage("HOME");}
});}else {
var login_account=nvram_manager.get_login_data();
if(login_account){
loading.show();
google_calendar.get_account_calendar({
access_token:login_account.access_token,
refresh_token:login_account.refresh_token,
get_callback:function(access_token,user_id){
google_calendar.get_user_info({
access_token:access_token,
user_id:user_id,
callback:function(){
account_list.google_select();
set_cursor(sobj,null);
loading.hide();}
});},
error_callback:function(error_code){
loading.hide();
notice_panel.show({
title:CL_MSG("LT_CL_LOGIN_FAILED"),
description:CL_MSG("LT_LD_NETWORK_ERROR")+"("+error_code+")",
close_callback:function(){
set_cursor(sobj,null);}
});}
});}
}
calendar_obj.focus.setShow(true);};
var out_hook=function(obj){
if(ebus.asr)
sobj.del_event_hook(ebus.asr);
TopBar.disappear();
Background.disappear();
loading.disappear();
account_list.disappear();
notice_panel.disappear();
terms_of_use.disappear();
sch_detail_popup.disappear();
sch_edit_panel.disappear();
calendar_obj.focus.setShow(false);
discard_package("kbd");
discard_package("textarea");
discard_package("calendar_obj");
discard_package("calendar_util");
complete_off_stage(obj);};
var sobj=stage(
{
"symbol":"0387878700140020",
"in":[{"from":["default"],"hook":in_hook}],
"out":[{"to":["default"],"hook":out_hook}],
"components":[
Background,
TopBar,
full_calendar_obj,
device_link_panel,
terms_of_use,
sch_edit_panel,
time_edit_panel,
cal_list_view,
loading,
char_over,

sft_keyboard_mask,
sft_keyboard,
notice_panel,
],
}
);
sobj.key_hook=function(up_down,keysym){
if(up_down!=KEY_PRESS)return true;
if((keysym==TXK_UP)||(keysym==TXK_DOWN)||
(keysym==TXK_LEFT)||(keysym==TXK_RIGHT))
{
if(InputDevManager.get_pointer_status())
{
InputDevManager.pointer_disappear();}
}

switch(keysym){
case TXK_HOME:
case TXK_EXIT:
return false;}
if(this.cursor&&this.cursor.key_hook&&
this.cursor.key_hook(up_down,keysym))
{
force_redraw();
return true;}
if(this.full_calendar_obj.sch_obj.key_hook(up_down,keysym))
{
return true;}
switch(keysym){
case SETTING_KEY.symbol:
account_list.show();
return true;
case UPDATE_KEY.symbol:
var mode=account_list.get_view_mode();
if(mode==DEFAULT)return;
google_calendar.update({
start_action:function(){
full_calendar_obj.sch_obj.loading_view(true);},
get_callback:function(){
full_calendar_obj.sch_obj.loading_view(false);}
});
return true;
case CHANGE_KEY.symbol:
var login_account=nvram_manager.get_login_data();
if(login_account){
var mode=account_list.get_view_mode();
if(mode!=DEFAULT){
account_list.default_select();}else {
account_list.google_select_action();}
}
return true;
case TXK_RETURN:
case TXK_HOME:
case TXK_EXIT:
on_stage("HOME");
return true;}
force_redraw();
return false;};
