var model, lastPage, callId, y;
var verInput = '';

(function() {
	var query = location.search.replace('?', '').split('&');
	var queryList = [];
	
	for (var i in query) {
		var queryArray = query[i].split('=');
		queryList[queryArray[0]] = queryArray[1];
	}
	model = queryList['model'];
	var isAll = true;
	for (var i=0; i < modelArray.length; i++) {
		if (model == modelArray[i]) {
			isAll = false;
			break;
		}
	}
	if (isAll) {
		model = "ALL";
	}
	lastPage = queryList['lastPage'];
	callId = queryList['callId'];
	innerId = queryList['inner'];
	extraId = queryList['extra'];
	hyperlink = queryList['hyperlink'];
	anchor = queryList['anchor'];
	prepage = queryList['prepage'];
	pretitle = queryList['pretitle'];
	y = queryList['y'];
})();

function $(element) {
	return document.getElementById(element);
}
function $tag(element,tag) {
	return $(element).getElementsByTagName(tag);
}



function cookieRead(kword){
	if (kword == "") {return "none"};
	
	kword = kword + "=";
	kdata = "";
	scookie = document.cookie + ";";
	start = scookie.indexOf(kword);

	if (start != -1) {
		end = scookie.indexOf(";", start);
		kdata = unescape(scookie.substring(start + kword.length, end));
	}
	return kdata;
}

function moveFocus() {
	if (browser == 'tv') {
		document.activeElement.style.outlineColor = 'rgba(0,0,0,0)';
		var readNext = document.createElement('div');
		readNext.id = 'read_next';
		readNext.innerHTML = '<div id="read_bg"></div><p>Loading ...</p>';
		document.body.appendChild(readNext);
	}
}
function setFocus() {
	document.activeElement.style.outlineColor = 'rgba(255,187,0,255)';
}
function getModel() {
	return cookieRead('Model');
}

window.onerror = function(msg, url, line) {
	if (onerror.num++ < onerror.max) {
		alert("ERROR: " + msg + "\n" + url + ":" + line);
		return true;
	}
	onerror.max = 3;
	onerror.num = 0;
}

function setKey(e) {
	if (e) {
		return e.keyCode;
	} else {
		return event.keyCode;
	}
}

function delTop() {
	delCookie('topHistory');
	delCookie('referpage');
	delCookie('jumpnum');
}

function delCookie(item) {
	var delTime = new Date();
	delTime.setHours(delTime.getHours() -1);
	delTime = delTime.toGMTString();
	
	document.cookie = item + '=;expires=' + delTime;
}

function browser() {
	return (navigator.userAgent.toLowerCase().indexOf('viera') != -1)?'tv':'pc';
}

function h(string) {
	if (typeof(string) == 'string') {
		string = string.replace(/<b>/g,'<span class="bold">');
		string = string.replace(/<i>/g,'<span class="italic">');
		string = string.replace(/<u>/g,'<span class="underline">');
		string = string.replace(/<en>/g,'<span class="en">');
		string = string.replace(/<right>/g,'<span class="right">');
		string = string.replace(/<center>/g,'<span class="center">');
		string = string.replace(/<\/b>|<\/i>|<\/u>|<\/en>|<\/right>|<\/center>/g,'</span>');
		string = string.replace(/<(\d)>/g,'<span class="s$1">');
		string = string.replace(/<\/\d>/g,'</span>');
		string = string.replace(/\n/g,'<br>');
		string = string.replace(/<>/g,'<br>');
		string = string.replace(/<span class="en"><br><\/span>/g,'<br>');
		return string;
	}
}

var verCode;
var setVer = function(key) {
	if (verInput) {
		verInput += key;
		if (verInput.length == 6) {
			if (verInput == 'ululul' || verInput == 'lululu') {
				$('ver').style.display = 'block';
				verMode = 1;
				verInput = '';
			} else {
				clearVer();
			}
		}
	} else {
		verInput += key;
		verCode = setTimeout(function() {
			verInput = '';
		}, 5000);
	}
};

var clearVer = function() {
	clearTimeout(verCode);
	verInput = '';
};

function checkModel(condition, modelName) {

	var contain = false;

	if (typeof condition == 'undefined' || condition == "" || modelName == "") {
		return contain;
	}

	if (FuncSettings.isFuncSetting()) {

		if (modelName == 'ALL') {
			contain = true;
		} else {
			contain = FuncSettings.isContainModel(condition, modelName);
		}
	} else {


		var conditionList = condition.replace(/ /g, '').split('|');

		var modelTypeArray = [];
		for (var i=0, ilen=conditionList.length; i<ilen; i++) {
			var modelTypeParts = conditionList[i].split('_');
			var modelTypePostfix = modelTypeParts[1].split('/');
			for (var j=0, jlen=modelTypePostfix.length; j<jlen; j++) {
				modelTypeArray.push(modelTypeParts[0] + modelTypePostfix[j]);
			}
		}

		if (modelName == 'ALL') {
			contain = true;
		} else {
			for (var i=0, ilen=modelTypeArray.length; i<ilen; i++) {
				if (modelTypeArray[i].indexOf(modelName) != -1) {
					contain = true;
				}
			}
		}
	}

	return contain;
}

function moveupTitleSquare() {

	var titleSquareList = document.getElementsByClassName('Contents_TitleSquare_Lv01');
	var processingTitleSquare;


	for (var i=0, iLen=titleSquareList.length; i<iLen; i++) {

		processingTitleSquare = titleSquareList[i];
		var siblingCount = processingTitleSquare.parentNode.childNodes.length;
		if (siblingCount >= 1) {

			var prevNode = processingTitleSquare.previousSibling;
			while (prevNode != null && (prevNode.nodeName == '#text')) {
				prevNode = prevNode.previousSibling;
			}

			if (prevNode.className.toLowerCase().indexOf('diverge_model') != -1) {

				prevNode = processingTitleSquare.parentNode.previousSibling;
			} else {
				prevNode = processingTitleSquare.previousSibling;
				if (processingTitleSquare.parentNode.nodeName == 'DIV'
					&& (processingTitleSquare.parentNode.id != 'read_first' || processingTitleSquare.parentNode.id != 'content_inner')
				    && prevNode == null) {
					prevNode = processingTitleSquare.parentNode.previousSibling;
				}
			}
			while (prevNode != null && 
				(
					prevNode.nodeName == 'SCRIPT' ||
					prevNode.nodeName == '#text' ||
					prevNode.className.indexOf('display_none') != -1
				 )
			) {
				prevNode = prevNode.previousSibling;
			}

			if (prevNode == null ||  prevNode.className.indexOf('Contents_Title_Lv') != -1) {

				processingTitleSquare.className += ' moveup_TitleSquare_Lv01';
			}
		}
	}
}

function showDivergeBlock() {
	
	var divergeList = document.getElementsByClassName('Diverge_Block');
	var index = divergeList.length - 1;
	for (var divergeCount = index; divergeCount >= 0; divergeCount--) {


		var processingDivergeObject = divergeList[divergeCount];
		

		var divergeModelNode = processingDivergeObject.getElementsByClassName("Diverge_Model")[0];


		var conditiontext = divergeModelNode.innerHTML.replace(/&amp;/g, '&');

		if (model === 'ALL') {
		if (FuncSettings.isFuncSetting()) {


				divergeModelNode.innerHTML = "<span>" + conditiontext + "</span>" + getDivergeLabelText(conditiontext);
			} else {

				divergeModelNode.innerHTML = getDivergeLabelText(conditiontext);
			}
		} else {

			processingDivergeObject.className = processingDivergeObject.className.replace(/Diverge_Block/g, '');


			if (!isTargetModel(conditiontext)) {
				continue;
			} else {

				divergeModelNode.className += " display_none";

				processingDivergeObject.className += ' moveup';
			}
		}


		processingDivergeObject.className = processingDivergeObject.className.replace(/display_none/g, '');
	}
	return divergeList;
}


function getDivergeLabelText(condition) {
	var modelNameList = '';

	if (FuncSettings.isFuncSetting()) {

		modelNameList = FuncSettings.createModelLabel(condition);
	} else {

		var modelTypeList = condition.replace(/ /g, '').split('|');
		for (var i=0, ilen=modelTypeList.length; i<ilen; i++) {
			var modelTypeParts = modelTypeList[i].split('_');
			var modelTypePostfix = modelTypeParts[1].split('/');
			if (i !== 0) {
				modelNameList += ' | ';
			}
			modelNameList += "[" + modelTypeParts[0] + "] ";
			for (var j=0, jlen=modelTypePostfix.length; j<jlen; j++) {
				if (j !== 0) {
					modelNameList += "/";
				}
				modelNameList += modelTypePostfix[j];
			}
		}
	}
	return modelNameList;
}


function isTargetModel(condition) {

	var target = false;
	var modelTypeArray = [];

	if (FuncSettings.isFuncSetting()) {


		target = FuncSettings.isContainModel(condition, model);
	} else {


		var modelTypeList = condition.replace(/ /g, '').split('|');
		for (var i=0, ilen=modelTypeList.length; i<ilen; i++) {
			var modelTypeParts = modelTypeList[i].split('_');
			var modelTypePostfix = modelTypeParts[1].split('/');
			for (var j=0, jlen=modelTypePostfix.length; j<jlen; j++) {
				modelTypeArray.push(modelTypeParts[0] + modelTypePostfix[j]);
			}
		}

		for (var i=0, ilen=modelTypeArray.length; i<ilen; i++) {
			if (modelTypeArray[i].indexOf(model) != -1) {
				target = true;
				break;
			}
		}
	}
	return target;
}

function copyArray(arrSrc) {
	var resultArray = [];
	var arrayLength;
	for (var i = 0, arrayLength = arrSrc.length; i < arrayLength; i++) {
		if (arrSrc[i] instanceof Array) {
			resultArray[i] = copyArray(arrSrc[i]);
		} else {
			resultArray[i] = arrSrc[i];
		}
	}
	return resultArray;
}


function convertToModelList(modelCondition) {
	var modelTypeArray = [];

	if (typeof modelCondition == 'undefined' || modelCondition == "") {
		return modelTypeArray;
	}

	var modelConditionList = modelCondition.replace(/ /g, '').split('|');

	for (var i=0, ilen=modelConditionList.length; i<ilen; i++) {
		var modelTypeParts = modelConditionList[i].split('_');
		var modelTypePostfix = modelTypeParts[1].split('/');
		for (var j=0, jlen=modelTypePostfix.length; j<jlen; j++) {
			modelTypeArray.push([modelTypeParts[0], modelTypePostfix[j]]);
		}
	}
	return modelTypeArray;
}


var ModelSettings = {


	and: function (arrSrc, arrTarget) {
		var resultArray = [];
		var processingModelName;
		var arrayLength;
		for (var i = 0, arrayLength = arrSrc.length; i < arrayLength; i++) {

			processingModelName = arrSrc[i];
			if (this.isContain(arrTarget, processingModelName)) {
				resultArray.push(processingModelName);
			}
		}
		return resultArray;
	},

	or: function (arrSrc, arrTarget) {
		var resultArray = copyArray(arrSrc);
		var processingModelName;
		var arrayLength;
		for (var i = 0, arrayLength = arrTarget.length; i < arrayLength; i++) {

			processingModelName = arrTarget[i];
			if (!this.isContain(arrSrc, processingModelName)) {
				resultArray.push(processingModelName);
			}
		}
		return resultArray;
	},

	nand: function (arrSrc, arrTarget) {
		var resultArray = [];
		var processingModelName;
		var arrayLength;
		for (var i = 0, arrayLength = arrSrc.length; i < arrayLength; i++) {

			processingModelName = arrSrc[i];
			if (!this.isContain(arrTarget, processingModelName)) {
				resultArray.push(processingModelName);
			}
		}
		return resultArray;
	},

	isContain: function(arrSrc, arrModel) {
		var contain = false;

		var processingModelName;
		var arrayLength;
		for (var i = 0, arrayLength = arrSrc.length; i < arrayLength; i++) {
			processingModelName = arrSrc[i];
			if (processingModelName[0] == arrModel[0] && processingModelName[1] == arrModel[1]) {
				contain = true;
				break;
			}
		}

		return contain;
	},

	find: function(arrSrc, strModel) {
		var contain = false;

		var processingModelName;
		var arrayLength;
		for (var i = 0, arrayLength = arrSrc.length; i < arrayLength; i++) {
			processingModelName = arrSrc[i];
			if (processingModelName[0] + processingModelName[1] == strModel) {
				contain = true;
				break;
			}
		}

		return contain;
	},

	serialize: function(arrSrc) {
		var resultArray = [];
		var arrayLength;
		for (var i = 0, arrayLength = arrSrc.length; i < arrayLength; i++) {
			resultArray.push(arrSrc[i].join("-"));
		}
		return resultArray.toString();
	},

	sortByGroup: function(arrSrc) {
		var resultArray = arrSrc.sort(function(elment1, element2){
			
				if (elment1[0] == element2[0]) {
					return 0;
				} else if(elment1[0] < element2[0]) {
					return -1;
				} else {
					return 1;
				}
			}
		);
		return resultArray;
	},

	groupBy: function(arrSrc) {
		var resultArray = [];
		var arrayForCalc = [];
		var arrayLength;
		var models = [];

		for (var index = 0, arrayLength = arrSrc.length; index < arrayLength; index++) {
			var currentModelName = arrSrc[index][0];
			if (models.indexOf(currentModelName) == -1) {
				arrayForCalc[currentModelName] = [];
				models.push(currentModelName);
			}

			arrayForCalc[currentModelName].push(arrSrc[index][1]);
		}

		for (index = 0, arrayLength = models.length; index < arrayLength; index++) {
			var modelName = models[index];
			var suffixArray = arrayForCalc[modelName];
			var suffixLength;
			for (var suffixIndex = 0, suffixLength = suffixArray.length;  suffixLength > suffixIndex; suffixIndex++) {

				resultArray.push([modelName, suffixArray[suffixIndex]]);
			}
		}
		return resultArray;
	},

	createLabel: function(arrSrc) {
		var modelArray = this.groupBy(arrSrc);
		var processingModel = "";
		var modelLabel = "";

		modelLabel = modelArray.reduce(function(preValue, currentElement) {
				var resultLabel = "";
				if (preValue == "") {
					resultLabel = "[" + currentElement[0] + "] " + currentElement[1];
				} else if (processingModel != currentElement[0]) {
					resultLabel = preValue + " | [" + currentElement[0] + "] " + currentElement[1];
				} else {

					resultLabel = preValue + "/" + currentElement[1];
				}

				processingModel = currentElement[0];
				return resultLabel;
			}, processingModel
		);
		return modelLabel;
	}
};


var FuncSettings = {


	RESERVEWORD_AND: "&",
	RESERVEWORD_OR: "|",
	RESERVEWORD_NAND: "^",
	RESERVEWORD_LEFT_PARENTHESIS: "(",
	RESERVEWORD_RIGHT_PARENTHESIS: ")",
	NOT_RESERVEWORD: "FUNCNAME",


	isFuncSetting: function() {
		var active = false;
		if ("funclist" in window && funclist != undefined) {
			if (!(funclist.hasOwnProperty("NOUSE") && funclist.NOUSE == "TRUE")) {

				active = true;
			}
		}
		return active;
	},

	getModelList: function (funcname) {
		var modelcondition = funclist[funcname];
		if (!modelcondition) {
			console.log("[UNDEFINED FUNCNAME] getModelList(): " + funcname);
		}
		return convertToModelList(modelcondition);
	},

	calc: function(funccondition, subTotal){
		var modellist = [];


		var checkReservedWord = this.splitReservedWord(funccondition);
		var type = checkReservedWord[0];
		var remainedCondition = checkReservedWord[1];

		switch (type) {


			case this.NOT_RESERVEWORD:


				var funcNameInfo = this.splitFuncName(funccondition);

				modellist = this.getModelList(funcNameInfo[0]);
				if (funcNameInfo[1] == "") {

					break;
				} else {

					modellist = this.calc(funcNameInfo[1], modellist);
				}

				break;


			case this.RESERVEWORD_AND:

				modellist = ModelSettings.and(subTotal ,this.calc(remainedCondition));
				break;


			case this.RESERVEWORD_OR:

				modellist = ModelSettings.or(subTotal ,this.calc(remainedCondition));
				break;


			case this.RESERVEWORD_NAND:

				modellist = ModelSettings.nand(subTotal ,this.calc(remainedCondition));
				break;


			case this.RESERVEWORD_LEFT_PARENTHESIS:


				var rightParenthesisIndex = this.findParenthesis(remainedCondition);


				var parenthesCondition = remainedCondition.slice(0, rightParenthesisIndex);
				var newCondition = remainedCondition.slice(rightParenthesisIndex + 1);


				var modelInParenthes = this.calc(parenthesCondition);

				if (newCondition == "") {

					modellist = modelInParenthes;
				} else {

					modellist = this.calc(newCondition, modelInParenthes);
				}
				break;

			default:
				console.log("[PARSE ERROR] calc(): " + funccondition);
				break;
		}

		return modellist;
	},

	splitFuncName: function(funccondition){

		var arrCondition = [];

		var isPlaneFuncName = true;
		var charIndex = 0;
		var charlength = funccondition.length;
		for (charIndex = 0; charIndex < charlength; charIndex++) {
			var char = funccondition.charAt(charIndex);
			if (char == "(") {

				console.log("[PARSE ERR] splitFuncName(): " + funccondition);

				return undefined;
			} else if (
				char == "&" ||
				char == "|" ||
				char == "^" ||
				char == ")"
			) {
				isPlaneFuncName = false;
				break;
			}
		}

		if (isPlaneFuncName) {

			arrCondition[0] = funccondition.trim();
			arrCondition[1] = "";
		} else {
			arrCondition[0] = funccondition.slice(0, charIndex).trim();
			arrCondition[1] = funccondition.slice(charIndex).trim();
		}

		return arrCondition;
	},

	splitReservedWord: function(funccondition){


		var arrCondition = [];
		var type = this.NOT_RESERVEWORD;
		funccondition = funccondition.trim();
		var remainedCondition = funccondition.slice(1).trim();


		var char = funccondition.charAt(0);
		if (char == "(") {
			type = this.RESERVEWORD_LEFT_PARENTHESIS
		} else if (char == ")") {
			type = this.RESERVEWORD_RIGHT_PARENTHESIS
		} else if (char == "&") {
			type = this.RESERVEWORD_AND;
		} else if (char == "|") {
			type = this.RESERVEWORD_OR;
		} else if (char == "^") {
			type = this.RESERVEWORD_NAND;
		} else {

			remainedCondition = funccondition;
		}


		arrCondition[0] = type;
		arrCondition[1] = remainedCondition.trim();
		return arrCondition;
	},

	findParenthesis: function (funccondition) {
		var count = 1;	
		var charIndex = 0;
		var charlength = funccondition.length;
		for (charIndex = 0; charIndex < charlength; charIndex++) {
			var char = funccondition.charAt(charIndex);
			if (char == "(") {
				count++;
			} else if (char == ")") {
				count--;
			}
			if (count == 0) {
				break;
			}
		}

		if (charIndex == charlength) {

			charIndex = -1;
			console.log("[FORMAT ERR] findParenthesis(): (" + funccondition);
		}

		return charIndex;
	},

	isContainModel: function (funccondition, modelname) {

		var modellist = this.calc(funccondition);


		return ModelSettings.find(modellist, modelname);
	},

	createModelLabel: function(funccondition){

		var modellist = this.calc(funccondition);


		return ModelSettings.createLabel(modellist);
	}
};


function showModelInFooter(condition) {

	var strModel = "";

	if (condition && condition != 'ALL') {

		if (FuncSettings.isFuncSetting()) {


			strModel = condition;
		} else {

			strModel = convertConditionToLabel(condition);
		}

		if (!$('modelName')) {
			var modelDiv = document.createElement('div');
			modelDiv.id = "modelName";
			modelDiv.innerHTML = strModel;
			if ($('footer')) {
				$('footer').appendChild(modelDiv);
			}
		} else {
			$('modelName').innerHTML = strModel;
		}
	} else {
		if ((typeof condition == 'undefined' || condition == '') && $('modelName')) {
			$('footer').removeChild($('modelName'));
		}
	}
}

function convertConditionToLabel(condition) {

	var strModel = "";
	strModel = condition.replace(/_/g, '] ');
	strModel = strModel.replace(/\| /g, '| [');
	strModel = "[" + strModel;

	return strModel;
}
