eval_js_file ("file:///usr/local/javascript/wing/epop/tween.js"); 

var sd_testmode = 0;
var epop_data_path = "file:///usr/local/png/";
var epop_ex_data_path = "file:///edata/epop/ex/";

/*
x range (-960 <=> 960, total 1920)
y range (-540 <=> 540, total 1080)
z range (???)
***display center translate [0, 0, 0]

var win_w = 1920;
var win_h = 1080;
var win_half_w = win_w/2;
var win_half_h = win_h/2;
*/

var epop_timer = new container ({});
var epop_timeout_timer = new container ({});
var epop_key_timer = new container ({});
var slide_timer = new container ({});

///* use process *///
var epop_num = 5;

var epop_count = 0;
var epop_count_max = epop_num - 1;
var epop_stop = 0;
var epop_ex_enable = 0;
var epop_left = 0;
var epop_top = 0;
////////////////////

var key_enable = false; /* key action enable flag. */

var floor_x_out = -2300; /* floor 1st position.(screen out.) */
var logo_x_out = -1500; /* logo 1st position.(screen out.) */
var pict_x_out = -1500; /* Each pict 1st position.(screen out.) */

var floor_y = -417; /* floor y base position */
var floor_w = 2300; /* Each floor width */
var floor_h = 245; /* floor height */

var floor_left_y  = -323;
var floor_left_top_y = 513; 

var floor_right_y = -445;
var floor_right_top_y = 391;

var floor_cross_x = -411;
var floor_cross_y = floor_y;

var floor_varline_x = -190;
var floor_varline_y = floor_y;

var series_logo_x = -801;
var series_logo_y = -385;

var pict_y = floor_y; /* pict image y 1st position */
//var pict_x is set calc position.
var pict_w = 264; /* pict image width */
var pict_h = 165; /* pict image height */

var pict0_base_x = -470; /* pict0 image x 1st position */
var pict_move_x = pict_w + 50; /* pict image x position */

var pict_focus_x = -38;

var pict_small_w = 176;
var pict_small_h = 110;
var pict_small_space_x = 34;

var pict_small_left_x = -524;
var pict_small_right_x = -298;

var pict_small_upper_y = floor_y + (floor_h/4);
var pict_small_lower_y = floor_y - (floor_h/4);

var slide_x = 537; /* 114 + (820/2) ePOP slide image x position(right pattern) */
var slide_y = floor_y; /* ePOP slide image y position */
var slide_w = 846;
var slide_h = floor_h;

var slide_font_size = 35;  /* ePOP slide font size */
var slide_text_y = -40;    /* ePOP slide sentence position */

//////* Each file name *//////
var floor_png = "floor.png";
var floor_left_png = "floor_left.png";
var floor_right_png = "floor_right.png";
var floor_cross_png = "floor_cross.png";
var floor_varline_png = "floor_varline.png";

var panasonic_logo_png = "panasonic.png";
//////////////////////////////

var s = new stage ({});

var pict_anim = new gscenario;
pict_anim.init ();
var slide_anim = new gscenario;
slide_anim.init ();
var floor_anim = new gscenario;
floor_anim.init ();

var epop_title_font_name = "F015T-regular";
var epop_font_name = "F015T-regular";
var epop_text_align = LEFT;

var no_need_translation = 0;

var epop_data = new epop_data_func ();

function epop_data_func ()
{
    this.area;
    this.model;
    this.inch;
    this.country;
    this.lang;
    this.series_logo = "";
    this.panel_logo = "";
    this.data = [];
    
    this.init = function (config) {	
	if (sd_testmode) {
	    eval_js_file ("file:///mnt/sdcard/epop_data.js");
	    eval_js_file ("file:///mnt/sdcard/epop_config_data.js");
	    epop_data_path = "file:///mnt/sdcard/data/";
	    epop_ex_data_path = "file:///mnt/sdcard/data/";
	    
	    this.area    = epop_config_list[0];
	    this.model   = epop_config_list[1];
	    this.inch    = epop_config_list[2];
	    this.country = epop_config_list[3];
	    this.lang    = epop_config_list[4];
	    epop_font_name = epop_config_list[5];
	}
	else {
	    eval_js_file ("file:///usr/local/javascript/wing/epop/epop_data.js");
	    epop_data_path = "file:///usr/local/png/";
	    epop_ex_data_path = "file:///edata/epop/ex/";

	    this.area = config[0];
	    if (this.area == "MX")
	    {
		this.area = "US";
	    }
	    this.model   = config[1];
	    this.inch    = config[2];
	    this.country = config[3];
	    this.lang    = config[4];
	}
	
	this.set_data();
	
	//console.log (config);
	//for (var i in this.data)
	//    console.log (this.data[i]);	    
    }
    
    this.set_data = function () {
	var main_list_no = -1;
        var series_list_no = 0;
	var scenario_list_no = 0;
	
	for (var i in epop_main_list) {
	    if (epop_main_list[i][0] == this.model) {	    
		if (epop_main_list[i][1] == this.inch) {
		    /* best match */
		    main_list_no = i;
		    break;
		}
		else if (epop_main_list[i][1] == "*") {
		    main_list_no = i;
		}
	    }
	}

	if (main_list_no == -1) {
	    main_list_no = 0;
	    epop_finish_writeback ();
	}
	
	for (var i in epop_series_list) {
	    if (epop_series_list[i][0] == epop_main_list[main_list_no][2]) {
		if (this.area == "PAL") {
		    series_list_no = i;
		    break;
		}
		if (epop_series_list[i][2] == this.lang) {
		    /* best match */
		    series_list_no = i;
		    break;
		}
		else if (epop_series_list[i][2] == "*") {
		    series_list_no = i;			
		}
	    }
	}
	if (series_list_no != -1) {
	    this.series_logo = epop_series_list[series_list_no][3];
	    this.panel_logo = epop_series_list[series_list_no][4];
	}
	
	for (var i in epop_scenario_list) {
	    if (epop_scenario_list[i][0] == epop_main_list[main_list_no][3])
		scenario_list_no = i;
	}
	
	for (var i in epop_scenario_list[scenario_list_no]) {
	    if (i == 0)
		continue; /* skip scneario name */
	    
	    var func_list_no = -1;
	    for (var j in epop_function_list) {
		if (epop_scenario_list[scenario_list_no][i] == epop_function_list[j][0]) {
		    if (this.area == "PAL") {
			func_list_no = j;
			break;
		    }
		    if (epop_function_list[j][2] == this.lang) {
			/* best match */
			func_list_no = j;
			break;
		    }
		    else if (epop_function_list[j][2] == "*") {
			func_list_no = j;			
		    }
		}
	    }
	    if (func_list_no != -1) {
		this.data.unshift (epop_function_list[func_list_no].slice(3));
	    }
	}    
	
	while (this.data.length < epop_num)
	    this.data.push (["","","T.B.D.","T.B.D."]); //push dummy data
    }
    
    this.shift_data = function ()
	{
	    this.data.unshift(this.data.pop());
	}
}

var make_obj = function (config){

    pict0 = 
	new container ({
	    "translate": [pict_x_out, pict_y, 0],
	    "components":[
		new gimage ({
		    "translate": [0, 0, 0],
		    "width": pict_w,
		    "height": pict_h,
		    "src": epop_data_path + epop_data.data[0][0]}),
	    ]
	});

    pict1 = 
	new container ({
	    "translate": [pict_x_out, pict_y, 0],
	    "components":[
		new gimage ({
		    "translate": [0, 0, 0],
		    "width": pict_w,
		    "height": pict_h,
		    "src": epop_data_path + epop_data.data[1][0]}),
	    ]
	});

    pict2 = 
	new container ({
	    "translate": [pict_x_out, pict_y, 0],
	    "components":[
		new gimage ({
		    "translate": [0, 0, 0],
		    "width": pict_w,
		    "height": pict_h,
		    "src": epop_data_path + epop_data.data[2][0]}),
	    ]
	});

    pict3 = 
	new container ({
	    "translate": [pict_x_out, pict_y, 0],
	    "components":[
		new gimage ({
		    "translate": [0, 0, 0],
		    "width": pict_w,
		    "height": pict_h,
		    "src": epop_data_path + epop_data.data[3][0]}),
	    ]
	});

    pict4 = 
	new container ({
	    "translate": [pict_x_out, pict_y, 0],
	    "components":[
		new gimage ({
		    "translate": [0, 0, 0],
		    "width": pict_w,
		    "height": pict_h,
		    "src": epop_data_path + epop_data.data[4][0]}),
	    ]
	});
    
    pict_group = 
    [
     pict0,
     pict1,
     pict2,
     pict3,
     pict4,
     ];

    floor = 
	new container ({
		"translate": [-floor_x_out, floor_y, 0],
		"components":[
			      new gimage ({
				  "translate": [0, 0, 0],
				  "width": floor_w,
				  "height": floor_h,
				  "src":  epop_data_path + floor_png}),
			      ]
	    });
    floor_left = 
	new container ({
		"translate": [floor_x_out, floor_left_y, 0],
		"components":[
			      new gimage ({
				  "translate": [0, 0, 0],
				  "width": floor_w,
				  "height": 55,
				  "src":  epop_data_path + floor_left_png}),
		             ]
	    });
    floor_right = 
	new container ({
		"translate": [-floor_x_out, floor_right_y, 0],
		"components":[
			      new gimage ({
				  "translate": [0, 0, 0],
				  "width": floor_w,
				  "height": 190,
				  "src":  epop_data_path + floor_right_png}),
			      ]
	    });

    floor_cross = 
	new container ({
		"translate": [floor_cross_x, floor_cross_y, 0],
		"components":[
			      new gimage ({
				  "translate": [0, 0, 0],
				  "width": 190,
				  "height": 190,
				  "color" : [0,0,0,0], /* Defult alpha 0 */
				  "src":  epop_data_path + floor_cross_png}),
			      ]
	    });
    floor_varline = 
	new container ({
		"translate": [floor_varline_x, floor_varline_y, 0],
		"components":[
			      new gimage ({
				  "translate": [0, 0, 0],
				  "width": 20,
				  "height": 190,
				  "color" : [0,0,0,0], /* Defult alpha 0 */
				  "src":  epop_data_path + floor_varline_png}),
			      ]
	    });


    panasonic_logo = 
	new container ({
		"translate": [logo_x_out, floor_left_y, 0],
		"components":[
			      new gimage ({
				  "translate": [0, 0, 0],
				  "width": 245,
				  "height": 55,
				  "src":  epop_data_path + panasonic_logo_png}),
		             ]
	    });
    panel_logo = 
	new container ({
		"translate": [-logo_x_out, floor_right_y, 0],
		"components":[
			      new gimage ({
				  "translate": [0, 0, 0],
				  "width": 245,
				  "height": 190,
				  "src":  epop_data_path + epop_data.panel_logo}),
			      ]
	    });
    series_logo = 
	new container ({
		"translate": [0, series_logo_y, 0],
		"components":[
			      new gimage ({
				  "translate": [0, 0, 0, 0],
				  "color": [0, 0, 0, 0],
				  "width": 318,
				  "height": 310,
				  "src":  epop_data_path + epop_data.series_logo}),
			      ]
	    });

    slide = 
    new container ({
	"translate": [slide_x, slide_y, 0],
	    "components":[
		new gimage ({
		    "translate": [0, 0, 0],
		    "width": slide_w,
		    "height": slide_h,
		    "src": "",
		    "color" : [0,0,0,0], /* Defult alpha 0 */
		}),
		new gtextbox ({
		    "translate": [-10, 90, 0],
		    "text" : "",
		    "font_name" : epop_title_font_name,
		    "font_size" : 42,
		    "width" : slide_w,
		    "height" : 55,
		    "align" : epop_text_align,
		    "color" : [0,0,0,0], /* Defult alpha 0 */
		}),
		new gtextbox ({
		    "translate": [-10, slide_text_y, 0],
		    "text" : "",
		    "font_name" : epop_font_name,
		    "font_size" : slide_font_size,
		    "width" : slide_w,
		    "height" : 191,
		    "align" : epop_text_align,
		    "color" : [0,0,0,0], /* Defult alpha 0 */
		}),
	    ]
    });
}

var clear_obj = function () {

	var pict_comp_num;
	var floor_comp_num;
	var floor_left_comp_num;
	var floor_right_comp_num;
	var floor_cross_comp_num;
	var floor_varline_comp_num;
	var panasonic_logo_comp_num;
	var panel_logo_comp_num;
	var series_logo_comp_num;
	var slide_comp_num;
	
	/* current set timer delete */
	delete_timer (slide_timer);
	delete_timer (epop_key_timer);
	delete_timer (epop_timer);
	delete_timer (epop_timeout_timer);
	
	/* current action anim finish */
	slide_anim.finish();
	pict_anim.finish();
	floor_anim.finish();
	
	/* current param reset */
	epop_count = 0;
	epop_stop = 0;
	epop_ex_enable = 0;
        slide_font_size = 35;
        slide_text_y = -40;
	no_need_translation = 0;
	
	/* reset position */
	if (epop_top) {
	    floor_y = -floor_y;
	    floor_left_y = floor_left_top_y;
	    floor_right_y = floor_right_top_y;
	    floor_cross_y = -floor_cross_y;
	    floor_varline_y = -floor_varline_y;
	    
	    series_logo_y = -series_logo_y;
	    
	    pict_y = -pict_y;
	    slide_y = -slide_y;
	    
	    // calc top/buttom.
	    pict_small_upper_y = floor_y + (floor_h/4);
	    pict_small_lower_y = floor_y - (floor_h/4);
	}
	
	/* current use obj clear */
	for(var i=0; i < epop_num; i++) 
	{
	    pict_comp_num = pict_group[i].components.length;
	    for (var j = 0; j < pict_comp_num; j++)
	    {
		pict_group[i].components[j] = 0;
		
	    }
	}
	
	floor_comp_num = floor.components.length;
	for (var j = 0; j < floor_comp_num; j++)
	{
	    floor.components[j] = 0;	
	}

	floor_left_comp_num = floor_left.components.length;
	for (var j = 0; j < floor_left_comp_num; j++)
	{
	    floor_left.components[j] = 0;	
	}

	floor_right_comp_num = floor_right.components.length;
	for (var j = 0; j < floor_right_comp_num; j++)
	{
	    floor_right.components[j] = 0;	
	}
	
	floor_cross_comp_num = floor_cross.components.length;
	for (var j = 0; j < floor_cross_comp_num; j++)
	{
	    floor_cross.components[j] = 0;	
	}

	floor_varline_comp_num = floor_varline.components.length;
	for (var j = 0; j < floor_varline_comp_num; j++)
	{
	    floor_varline.components[j] = 0;	
	}

	panasonic_logo_comp_num = panasonic_logo.components.length;
	for (var j = 0; j < panasonic_logo_comp_num; j++)
	{
	    panasonic_logo.components[j] = 0;	
	}

	panel_logo_comp_num = panel_logo.components.length;
	for (var j = 0; j < panel_logo_comp_num; j++)
	{
	    panel_logo.components[j] = 0;	
	}

	series_logo_comp_num = series_logo.components.length;
	for (var j = 0; j < series_logo_comp_num; j++)
	{
	    series_logo.components[j] = 0;	
	}

	slide_comp_num = slide.components.length;
	for (var j = 0; j < slide_comp_num; j++)
	{
	    slide.components[j] = 0;	
	}

    force_redraw();
}

s.symbol = "home-screen";
s.key_hook = function (up_down, key) {
    if (key_enable == true)
    {
	if (key==TXK_RIGHT || key==TXK_LEFT) {
	    epop_count = 0;
	    append_timer (epop_key_timer, 500, epop_slide_undisplay);
	    update_epop_timeout_timer ();
	}
	else if (key==FXK_CH_UP) {
	    epop_count = 0;
	    append_timer (epop_key_timer, 500, epop_slide_undisplay);
	    update_epop_timeout_timer ();
	}
	else if (key==TXK_ENTER || key==FXK_CH_DOWN) {
	    epop_count = 0;
	    delete_timer (epop_key_timer);
	    
	    if (epop_stop) {
		epop_stop = 0;
		append_timer (epop_key_timer, 500, epop_slide_undisplay);
	    } else {
		epop_stop = 1;
	    }
	    update_epop_timeout_timer ();
	}
    }
};
s.in = [
  {
    "from": ["default"],
  }
];

function appear_obj (config)
{
    if (config[5]) {
	epop_ex_enable = 1;
    }
    
    if (config[13] == 1)
    {
	epop_text_align = RIGHT;
    }

    if (config[16])
    {
	no_need_translation = 1;
    }

    if (config[6] == 0) {
	/* buttom left */
	epop_left = 0;
	epop_top = 0;
    } else if (config[6] == 1) {
	/* top left */
	epop_left = 0;
	epop_top = 1;
    } else if (config[6] == 2) {
	/* buttom left */
	epop_left = 0;
	epop_top = 0;
    } else if (config[6] == 3) {
	/* top left */
	epop_left = 0;
	epop_top = 1;
    }

    if (epop_top) {
	floor_y = -floor_y;
	floor_left_y = floor_left_top_y;
	floor_right_y = floor_right_top_y;
	floor_cross_y = -floor_cross_y;
	floor_varline_y = -floor_varline_y;

	series_logo_y = -series_logo_y;

	pict_y = -pict_y;
	slide_y = -slide_y;

	// calc top/buttom.
	pict_small_upper_y = floor_y + (floor_h/4);
	pict_small_lower_y = floor_y - (floor_h/4);
    }

    if (config[15])
    {
	/* Display large font and position. */
	slide_font_size = 38;
	slide_text_y = -55;
    }
    else
    {
	slide_font_size = 35;
	slide_text_y = -40;
    }
    
    epop_data.init(config);
    make_obj(config);

    if (epop_ex_enable)
    {
	epop_data.data[0][0] = "func_logo_ex.png";
	epop_data.data[0][1] = "epop_ex.png";
	epop_data.data[0][2] = " ";
	epop_data.data[0][3] = " ";

	pict_group[0].components[0].src = epop_ex_data_path + epop_data.data[0][0];
    }

    all_1st_image_push ();
    
    append_timer (epop_timer, 1500, epop_1st_display);

}

function epop_1st_display ()
{
    delete_timer (epop_timer);

    dotween (floor_left,
	     {time:1.0,
	      x:100,
	      y:floor_left_y,
	      transition:"easeNone"});
    dotween (floor_right,
	     {time:1.0,
	      x:-100,
	      y:floor_right_y,
	      transition:"easeNone"});
    dotween (panasonic_logo,
	     {time:0.8,
	      x:0,
	      y:floor_left_y,
	      transition:"easeNone"});
    dotween (panel_logo,
	     {time:0.8,
	      x:0,
	      y:floor_right_y,
	      transition:"easeNone"});

    append_timer (epop_timer, 2000, epop_series_logo_display);
    update_epop_timeout_timer ();
}

function epop_series_logo_display ()
{
    delete_timer (epop_timer);

    panasonic_logo.components[0].visible_p = false;
    panel_logo.components[0].visible_p = false;

    floor_anim.init();
    floor_anim.set_anim_color (series_logo.components[0],
				    [0, 0, 0, 0], 
				    [255, 255, 255, 255], 
				    1, 10);
    floor_anim.run();

    append_timer (epop_timer, 2000, epop_move_1st_position);
}

function epop_move_1st_position ()
{
    delete_timer (epop_timer);

    dotween (floor,
	     {time:1.0,
	      x:-150,
	      y:floor_y,
	      transition:"easeNone"});
    dotween (series_logo,
	     {time:1.0,
	      x:series_logo_x,
	      y:series_logo_y,
	      transition:"easeNone"});

    for(var i=0; i < epop_num; i++) 
    {
	dotween (pict_group[i],
		 {time:1.0,
		  x:(pict0_base_x + (pict_move_x * i)),
		  transition:"easeNone"});
    }
    
    append_timer (epop_timer, 2500, epop_move_rotate_1st_position);
}

function epop_move_rotate_1st_position ()
{
    delete_timer (epop_timer);

    all_first_image_pop ();
    all_2nd_image_push ();

    pict_anim.init ();

    for(var i=0; i < epop_num; i++) 
    {
	if (i != epop_count_max)
	{
	    pict_anim.set_anim_height (pict_group[i].components[0], pict_h, pict_small_h, 1, 10);
	}
	else
	{
	}
    }

    pict_anim.set_anim_translate (pict_group[0],
				  [pict0_base_x, floor_y, 0],
				  [pict_small_right_x, pict_small_lower_y, 0],
				  1, 10);

    pict_anim.set_anim_translate (pict_group[1], 
				  [(pict0_base_x + (pict_move_x * 1)), floor_y, 0],
				  [pict_small_left_x, pict_small_lower_y, 0],
				  1, 10);

    pict_anim.set_anim_translate (pict_group[2], 
				  [(pict0_base_x + (pict_move_x * 2)), floor_y, 0],
				  [pict_small_left_x, pict_small_upper_y, 0],
				   1, 10);

    pict_anim.set_anim_translate (pict_group[3], 
				   [(pict0_base_x + (pict_move_x * 3)), floor_y, 0],
				   [pict_small_right_x, pict_small_upper_y, 0],
				   1, 10);

    pict_anim.set_anim_translate (pict_group[4], 
				   [(pict0_base_x + (pict_move_x * 4)), floor_y, 0],
				   [pict_focus_x, pict_y, 0],
				   1, 10);

    pict_anim.run();

    append_timer (epop_timer, 1000, epop_floor_line_display);
}

function epop_floor_line_display ()
{
    delete_timer (epop_timer);

    floor_anim.init();
    floor_anim.set_anim_color (floor_cross.components[0],
				    [0, 0, 0, 0], 
				    [255, 255, 255, 255], 
				    1, 10);
    floor_anim.set_anim_color (floor_varline.components[0],
				    [0, 0, 0, 0], 
				    [255, 255, 255, 255], 
				    1, 10);
    floor_anim.run();


    append_timer (slide_timer, 500, epop_slide_display);
}

function update_slide_data ()
{

    if (epop_data.data[epop_num-1][1] == "epop_ex.png")
	slide.components[0].src = epop_ex_data_path + epop_data.data[epop_num-1][1];
    else
	slide.components[0].src = epop_data_path + epop_data.data[epop_num-1][1];

    if (no_need_translation)
    {
	setf_text (slide.components[1], epop_data.data[epop_num-1][2]);
	setf_text (slide.components[2], epop_data.data[epop_num-1][3]);
    }
    else
    {
	setf_text (slide.components[1], gettext (epop_data.data[epop_num-1][2]));
	setf_text (slide.components[2], gettext (epop_data.data[epop_num-1][3]));
    }

    force_redraw ();
}

function epop_slide_display ()
{
    delete_timer (slide_timer);

    key_enable = true;

    update_slide_data ();

    slide_anim.init();

    slide_anim.set_anim_color (slide.components[0],
				    [0, 0, 0, 0], 
				    [255, 255, 255, 255], 
				    1, 10);
    slide_anim.set_anim_color (slide.components[1],
				    [0, 0, 0, 0], 
				    [0, 0, 0, 255], 
				    1, 10);
    slide_anim.set_anim_color (slide.components[2],
				    [0, 0, 0, 0], 
				    [0, 0, 0, 255], 
				    1, 10);
    slide_anim.run();

    if (!epop_stop)
    {
	append_timer (epop_key_timer, 5000, epop_slide_undisplay);
    }
}

function epop_slide_undisplay ()
{
    delete_timer (epop_key_timer);

    key_enable = false;

    slide_anim.init();
    slide_anim.set_anim_color (slide.components[0],
				    [255, 255, 255, 255], 
				    [0, 0, 0, 0], 
				    1, 10);
    slide_anim.set_anim_color (slide.components[1],
				    [0, 0, 0, 255], 
				    [0, 0, 0, 0], 
				    1, 10);
    slide_anim.set_anim_color (slide.components[2],
				    [0, 0, 0, 255], 
				    [0, 0, 0, 0], 
				    1, 10);
    slide_anim.run();

    /* Next ePOP or finish. */
    epop_count++;

    append_timer (epop_timer, 1000, epop_pict_rotate);
}

function epop_pict_rotate ()
{
    delete_timer (epop_timer);

    pict_anim.init();

    pict_anim.set_anim_rotate (floor_cross.components[0], [0, 0, 0, 0], [90, 0, 0, -90], 1, 10);

    pict_anim.set_anim_translate (pict_group[0], 
				   [pict_small_right_x, pict_small_lower_y, 0],
				   [pict_small_left_x, pict_small_lower_y, 0], 
				   1, 10);

    pict_anim.set_anim_translate (pict_group[1], 
				   [pict_small_left_x, pict_small_lower_y, 0],
				   [pict_small_left_x, pict_small_upper_y, 0], 
				   1, 10);

    pict_anim.set_anim_translate (pict_group[2], 
				   [pict_small_left_x, pict_small_upper_y, 0],
				   [pict_small_right_x, pict_small_upper_y, 0], 
				   1, 10);

    pict_anim.set_anim_translate (pict_group[3], 
				   [pict_small_right_x, pict_small_upper_y, 0],
				   [pict_focus_x, pict_y, 0], 
				   1, 10);
    pict_anim.set_anim_height (pict_group[3].components[0], pict_small_h, pict_h, 1, 10);

    pict_anim.set_anim_translate (pict_group[4], 
				   [pict_focus_x, pict_y, 0],
				   [pict_small_right_x, pict_small_lower_y, 0], 
				   1, 10);
    pict_anim.set_anim_height (pict_group[4].components[0], pict_h, pict_small_h, 1, 10);

    pict_anim.run();


    /* ePOP list shift.   */
    pict_group.unshift(pict_group.pop ());
    epop_data.shift_data();


    if (epop_count > epop_count_max)
    {
	append_timer (epop_timer, 1000, epop_move_finish_position);
    }
    else
    {
	append_timer (slide_timer, 1000, epop_slide_display);
    }
}

function epop_move_finish_position ()
{
    delete_timer (epop_timer);

    floor_cross.components[0].visible_p = false;
    floor_varline.components[0].visible_p = false;

    pict_anim.init ();

    for(var i=0; i < epop_num; i++) 
    {
	if (i != epop_count_max)
	{
	    pict_anim.set_anim_height (pict_group[i].components[0], pict_small_h, pict_h, 1, 10);
	}
	else
	{

	}
    }

    pict_anim.set_anim_translate (pict_group[0],
				  [pict_small_right_x, pict_small_lower_y, 0],
				  [pict0_base_x, floor_y, 0],
				  1, 10);

    pict_anim.set_anim_translate (pict_group[1], 
				  [pict_small_left_x, pict_small_lower_y, 0],
				  [(pict0_base_x + (pict_move_x * 1)), floor_y, 0],
				  1, 10);

    pict_anim.set_anim_translate (pict_group[2], 
				  [pict_small_left_x, pict_small_upper_y, 0],
				  [(pict0_base_x + (pict_move_x * 2)), floor_y, 0],
				   1, 10);

    pict_anim.set_anim_translate (pict_group[3], 
				   [pict_small_right_x, pict_small_upper_y, 0],
				   [(pict0_base_x + (pict_move_x * 3)), floor_y, 0],
				   1, 10);

    pict_anim.set_anim_translate (pict_group[4], 
				   [pict_focus_x, pict_y, 0],
				   [(pict0_base_x + (pict_move_x * 4)), floor_y, 0],
				   1, 10);

    pict_anim.run();

    append_timer (epop_timer, 2500, epop_finish);
}

function epop_finish ()
{
    delete_timer (epop_timer);

    pict_anim.init ();
    for(var i=0; i < epop_num; i++) 
    {
	pict_anim.set_anim_color (pict_group[i].components[0],
				  [255, 255, 255, 255], 
				  [0, 0, 0, 0],
				  1, 10);
    }
    pict_anim.run();

    floor_anim.init();
    floor_anim.set_anim_color (series_logo.components[0],
			       [255, 255, 255, 255],
			       [0, 0, 0, 0], 
			       1, 10);
    floor_anim.set_anim_color (floor.components[0],
			       [255, 255, 255, 255],
			       [0, 0, 0, 0], 
			       1, 10);
    floor_anim.run();

    append_timer (epop_timer, 1000, epop_finish2);
}

function epop_finish2 ()
{
    delete_timer (epop_timer);
    all_2nd_image_pop ();
    append_timer (epop_timer, 1000, epop_finish_writeback);
}

//////////////////////////////////////////////////////////////////////////

function all_first_image_pop ()
{
    s.components.pop (); /* for series_logo */
    for(var i=0; i < epop_num; i++) 
    {
	s.components.pop (); /* For pict */
    }
    s.components.pop (); /* For floor */
    s.components.pop (); /* For panel_logo */
    s.components.pop (); /* For panasonic_logo */
    s.components.pop (); /* For floor_right */
    s.components.pop (); /* For floor_left */
}

function all_1st_image_push ()
{
    s.components.push (floor_left);
    s.components.push (floor_right);
    s.components.push (panasonic_logo);
    s.components.push (panel_logo);
    s.components.push (floor);
    for(var i=0; i < epop_num; i++) 
    {
	s.components.push (pict_group[i]);
    }
    s.components.push (series_logo);

}

function all_2nd_image_pop ()
{
    s.components.pop (); /* for series_logo */
    for(var i=0; i < epop_num; i++) 
    {
	s.components.pop (); /* For pict */
    }
    s.components.pop (); /* For floor_varline */
    s.components.pop (); /* For floor_cross */
    s.components.pop (); /* For floor */
    s.components.pop (); /* For slide */
}

function all_2nd_image_push ()
{
    s.components.push (floor);
    s.components.push (floor_cross);
    s.components.push (floor_varline);
    for(var i=0; i < epop_num; i++) 
    {
	s.components.push (pict_group[i]);
    }
    s.components.push (series_logo);
    s.components.push (slide);
}

function epop_finish_writeback ()
{
    write_back_bytes2 (0, [0]);
}

function update_epop_timeout_timer ()
{
    delete_timer (epop_timeout_timer);
    append_timer (epop_timeout_timer, 70000, epop_finish_writeback);
}
