accedo.ui.View.create('freesat.view.Tvguide', ['freesat.widget.ChannelLogo'], {
    type: accedo.ui.layout.Normal,
    defaultFocus: '',
    id: '#tvguide',
    children: [
        {
            type: accedo.ui.widget.Image,
            id: '#background',
            src: 'images/1280x720/background/back_guide.jpg'
        },
        {
            id: '#header-controller',
            controller: 'freesat.controllers.subcontrollers.Empty'
        },
        {
            type: accedo.ui.Container,
            css: 'straplinebackground',
            id: '#straplinebackground'
        },
        {
            type: accedo.ui.Container,
            id: '#epgContainer',
            css: 'epg-container',
            children: [
                {
                    type: accedo.ui.widget.Button,
                    id: '#hidden-button'
                },
                {
                    type: accedo.ui.Container,
                    id: '#nowNextPage',
                    css: 'page-nownext',
                    children: [
                        {
                            type: accedo.ui.Container,
                            id: '#straplineNowNextContainer',
                            children: [
                                {
                                    type: accedo.ui.widget.Label,
                                    id: '#straplineNow',
                                    css: 'highlight',
                                    text: 'now'
                                },
                                {
                                    type: accedo.ui.widget.Label,
                                    id: '#straplineNext',
                                    text: 'next'
                                }
                            ]
                        },
                        {
                            type: accedo.ui.Container,
                            id: '#channelFilter',
                            css: 'channel-filter',
                            children: [
                                {
                                    type: accedo.ui.widget.Label,
                                    id: '#channelFilterLabel',
                                    css: 'channel-filter-label',
                                    text: 'All channels'
                                }
                            ]
                        },
                        {
                            type: accedo.ui.Container,
                            id: '#epgGuideMask',
                            css: 'epgGuideMask',
                            children: [
                                {
                                    type: accedo.ui.Container,
                                    id: '#epgGuideContainer',
                                    css: 'epgGuideContainer',
                                    children: [
                                        {
                                            type: accedo.ui.Container,
                                            id: '#channelbarcontainer',
                                            css: 'channelbarcontainer',
                                            children: [
                                                {
                                                    type: accedo.ui.Container,
                                                    id: '#channelbarpage',
                                                    css: 'channelbarpage'
                                                }

                                            ]
                                        },
                                        {
                                            type: accedo.ui.Container,
                                            id: '#epgNowNextMask',
                                            css: 'epgNowNextMask',
                                            children: [
                                                {
                                                    type: accedo.ui.Container,
                                                    id: '#epgNowNextContainer',
                                                    css: 'epgNowNextContainer',
                                                    children: [
                                                        {
                                                            type: accedo.ui.Container,
                                                            id : '#epgPage',
                                                            css: 'epgPage',
                                                            children: [
                                                                {
                                                                    type: accedo.ui.Container,
                                                                    id: '#epgNowContainer',
                                                                    css: 'epgNowContainer'
                                                                },
                                                                {
                                                                    type: accedo.ui.Container,
                                                                    id: '#epgNextContainer',
                                                                    css: 'epgNextContainer'
                                                                }
                                                            ]
                                                        }
                                                    ]
                                                }
                                            ]
                                        }

                                    ]
                                }
                            ]

                        }
                    ]
                },
                {
                    type: accedo.ui.Container,
                    id: '#earlierPage',
                    css: 'page-earlier hidden',
                    children: [
                        {
                            type: accedo.ui.Container,
                            id: '#straplineEarlierContainer',
                            children:
                                [
                                    {
                                        type: accedo.ui.widget.Label,
                                        id: '#straplineEarlierTitle',
                                        css: 'straplineTitle'
                                    },
                                    {
                                        type: accedo.ui.widget.Label,
                                        id: '#straplineEarlierChannelName',
                                        css: 'straplineChannelName'
                                    }
                                ]
                        },
                        {
                            type: accedo.ui.Container,
                            id: '#earlier-container',
                            css: 'container',
                            children: [
                                {
                                    type: accedo.ui.Container,
                                    id: '#earlierProgrammeItemMask',
                                    css: 'earlierProgrammeItemMask',
                                    children: [
                                        {
                                            type: accedo.ui.Container,
                                            id: '#earlierProgrammeItemContainer',
                                            css: 'earlierProgrammeItemContainer'
                                        }
                                    ]
                                },
                                {
                                    type: accedo.ui.Container,
                                    id: '#programmeImageContainer',
                                    css: 'programmeImageContainer'
                                },
                                {
                                    type : accedo.ui.Container,
                                    id: '#earlier-connection-message',
                                    css : 'earlier-connection-message hidden',
                                    children :
                                        [
                                            {
                                                type: accedo.ui.widget.Image,
                                                src: 'images/1280x720/not_connected/earlier.png',
                                                css: 'earlier-not-connected-image'
                                            },
                                            {
                                                type : accedo.ui.widget.Label,
                                                id: '#earlier-connectionLabel',
                                                css:'earlier-connectionLabel',
                                                text : ''
                                            },
                                            {
                                                type : accedo.ui.Container,
                                                id :'#earlier-message-container',
                                                css:'earlier-message-container',
                                                children:
                                                [
                                                    {
                                                        type : accedo.ui.widget.Label,
                                                        id: '#earlier-connectionmessageLabel',
                                                        css:'earlier-connectionmessageLabel',
                                                        text : ''
                                                    },
                                                    {
                                                        type : accedo.ui.widget.Button,
                                                        id: '#earlier-connectionBackButton',
                                                        css:'earlier-connectionBackButton',
                                                        text : 'Back',
                                                        nextUp:''
                                                    }
                                                ]
                                            }

                                        ]
                                }
                            ]
                        }
                    ]
                },
                {
                    type: accedo.ui.Container,
                    id: '#laterPage',
                    css: 'page-later hidden',
                    children: [
                        {
                            type: accedo.ui.Container,
                            id: '#straplineTimeStripMask',
                            css: 'laterTimeStripMask'

                        },
                        {
                            type: accedo.ui.Container,
                            id: '#laterProgrammeItemMask',
                            css: 'laterProgrammeItemMask'
                        }
                    ]
                }
            ]
        },
        {
            type: accedo.ui.Container,
            id: '#peekChannelGradient'
        },
        {
            id: '#footer-controller',
            controller: 'freesat.controllers.subcontrollers.Empty'
        },
        {
            type: accedo.ui.Container,
            id: '#arrowContainer',
            children: [
                {
                    type: freesat.widget.VTextImageButton,
                    id: '#leftArrow',
                    src: 'images/1280x720/arrow/arrow_left_dark_L.png',
                    focusedsrc: 'images/1280x720/arrow/arrow_left_green_L.png',
                    text: 'earlier',
                    align: 'left'
                },
                {
                    type: freesat.widget.VTextImageButton,
                    id: '#rightArrow',
                    src: 'images/1280x720/arrow/arrow_right_dark_L.png',
                    focusedsrc: 'images/1280x720/arrow/arrow_right_green_L.png',
                    text: 'later',
                    align: 'right'
                }
            ]
        },
        {
            type: accedo.ui.Container,
            id: '#channelFilterOverlay',
            css: 'filter-overlay'
        },
        {
            type: accedo.ui.Container,
            id: '#channelFilterMenu',
            css: 'channel-filter-menu',
            children: [
                {
                    type: accedo.ui.Container,
                    id: '#channelFilterSelection',
                    css: 'channel-filter-selection',
                    children: [
                        {
                            type: accedo.ui.widget.Label,
                            id: '#channelFilterTypes',
                            css: 'channel-filter-types',
                            text: 'Select channel type:'
                        }
                    ]
                }
            ]
        }
    ]
});
/**
 * User: Dean Clancy
 * Date: 19/02/14
 * Time: 11:15
 */
/*global accedo: false */
/**
 * Creates a new HandleSelection instance.
 * @name HandleSelection
 * @memberof freesat.HandleSelection
 * @class A HandleSelection class, HandleSelection functionality.
 * @author <a href="mailto:dean.clancy@accedo.tv">Dean Clancy</a>
 */
accedo.Class.create("freesat.controllers.tvguide.HandleSelection", [], {},
    {
        handleEarlierItemSelection: function(isPromo){
            return function(vKey) {
                if(!freesat.behind.earlierChannelFocused){
                    if (vKey === accedo.VKey.KEY_OK ) {
                        freesat.setBackFocus(accedo.ui.FocusManager.singleton().getCurrentFocus());
                        this.addClass('disable');
                        freesat.actionData = new freesat.models.vo.MenuObject();
                        freesat.actionData.context = 'Watch now';
                        freesat.actionData.timeZone = 'earlier';
                        freesat.actionData.backFocus = this;
                        //                    freesat.actionData.left = this.parent.root._dom.offsetLeft-8;
                        freesat.actionData.left = this.parent.parent.parent.parent.root._dom.offsetLeft + //earlierProgrammeItemMask
                            this.parent.parent.parent.parent.parent.parent.root._dom.offsetLeft + // earlierPage
                            this.parent.parent.parent.parent.parent.parent.parent.root._dom.offsetLeft; // epgContainer
                        if(isPromo){
                            freesat.actionData.top = this.root._dom.offsetTop +
                                this.parent.parent.parent.parent.parent.root._dom.offsetTop+ // earlier-container
                                280;
                            freesat.actionData.height = (freesat.behind.ITEM_HEIGHT * 4) - 10;
                        }else{
                            freesat.actionData.top = this.root._dom.offsetTop +
                                this.parent.parent.parent.parent.parent.root._dom.offsetTop + // earlier-container
                                this.parent.parent.parent.parent.parent.parent.parent.root._dom.offsetTop; // epgContainer
                            freesat.actionData.height = freesat.behind.ITEM_HEIGHT;
                        }
                        freesat.actionData.width = this.parent.root._dom.offsetWidth;
                        freesat.actionData.hasMask = true;
                        freesat.actionData.programObject = this._data;
                        freesat.masterController.instanciateSelectionMenu();
                    } else if (vKey === accedo.VKey.KEY_INFO) {
                        if(freesat.masterController.showInfo == false){
                            freesat.masterController.showInfo = true;
                            freesat.setBackFocus(accedo.ui.FocusManager.singleton().getCurrentFocus());
                            freesat.actionData = new freesat.models.vo.MenuObject();
                            freesat.actionData.timeZone = freesat.getZone();
                            freesat.actionData.backFocus = this;
                            freesat.actionData.hasMask = true;
                            freesat.actionData.programObject = this._data;
                            freesat.actionData.location = 'Tvguide';
                            freesat.masterController.instanciateAbout();
                        }
                    }
                }
            };
        },
        handleItemSelection: function(vKey) {

            if (vKey === accedo.VKey.KEY_REC) {
                freesat.behind.handleSelection.handleRecord(this._data);
            } else  if (vKey === accedo.VKey.KEY_STOP) {
                freesat.behind.handleSelection.handleCancelRecord(this._data);
            } else if (vKey === accedo.VKey.KEY_OK) {
                if (this._data.deepLink) {
                    if (freesat.ipavailable) {
                        freesat.setBackCookieValue('row', freesat.behind.row);
                        freesat.setBackCookieValue('name', btoa("promo" + this._data.name));
                        freesat.setBackCookieValue('day', freesat.behind.day);
                        freesat.setBackCookieValue('ccid', 'ccid:'+ freesat.behind.highlightedChannelId);
                        freesat.setBackCookieValue('section','earlier');
                        setTimeout(function () {
                            window.location = this._data.deepLink;
                        }, 200);
                    }
                    return;
                }
                freesat.setBackFocus(accedo.ui.FocusManager.singleton().getCurrentFocus());
                var actionLeft, actionTop;
                var timeZoneVar = freesat.getZone();
                if (timeZoneVar === 'now') {
                    timeZoneVar = freesat.behind.column;
                }
                this.addClass('disable');
                if (this._class === 'freesat.widget.ProgramItemWithImage') {
                    actionLeft = this.parent.parent.parent.parent.root._dom.offsetLeft; // epgContainer
                    actionTop = this.root._dom.offsetTop +
                        this.parent.parent.root._dom.offsetTop + // earlier-container
                        this.parent.parent.parent.parent.root._dom.offsetTop; // epgContainer
                } else {
                    actionLeft = this.parent.root._dom.offsetLeft + // epgNowContainer or epgNextContainer
                        this.parent.parent.parent.parent.root._dom.offsetLeft + //  epgNowNextMask
                        this.parent.parent.parent.parent.parent.parent.parent.parent.root._dom.offsetLeft; // epgContainer
                    actionTop = this.root._dom.offsetTop +
                        this.parent.parent.parent.parent.parent.parent.root._dom.offsetTop + // epgGuideMask
                        this.parent.parent.parent.parent.parent.parent.parent.parent.root._dom.offsetTop; // epgContainer
                }

                freesat.actionData = new freesat.models.vo.MenuObject();
                freesat.actionData.timeZone = timeZoneVar;
                freesat.actionData.backFocus = this;
                freesat.actionData.left = actionLeft;
                freesat.actionData.top = actionTop;
                freesat.actionData.width = this.root._dom.offsetWidth;
                freesat.actionData.height = freesat.behind.ITEM_HEIGHT;
                freesat.actionData.hasMask = true;
                freesat.actionData.programObject = this._data;
                freesat.console.log('selected item: ' + this._data.name);
                freesat.actionData.nownext = true;
                freesat.masterController.instanciateSelectionMenu();

            } else if (vKey === accedo.VKey.KEY_INFO) {
                if(freesat.masterController.showInfo == false){
                    freesat.masterController.showInfo = true;
                    freesat.setBackFocus(accedo.ui.FocusManager.singleton().getCurrentFocus());
                    freesat.actionData = new freesat.models.vo.MenuObject();
                    freesat.actionData.timeZone = freesat.getZone();
                    freesat.actionData.backFocus = this;
                    freesat.actionData.hasMask = true;
                    freesat.actionData.programObject = this._data;
                    freesat.actionData.location = 'Tvguide';
                    freesat.actionData.nownext = true;
                    freesat.masterController.instanciateAbout();
                }
            }
        },
        handleLaterItemSelection: function(vKey) {

            if (!freesat.isAnimating) {
                if (vKey === accedo.VKey.KEY_REC) {
                    freesat.behind.handleSelection.handleRecord(this._data);
                } else  if (vKey === accedo.VKey.KEY_STOP) {
                    freesat.behind.handleSelection.handleCancelRecord(this._data);
                } else if (vKey === accedo.VKey.KEY_OK) {
                    freesat.setBackFocus(accedo.ui.FocusManager.singleton().getCurrentFocus());

                    this.addClass('disable');
                    freesat.actionData = new freesat.models.vo.MenuObject();
                    freesat.actionData.context = 'Watch now';
                    if (this.timeZone === 'now') {
                        freesat.actionData.timeZone = 'now';
                    } else {
                        freesat.actionData.timeZone = 'later';
                    }
                    freesat.actionData.backFocus = this;
                    freesat.actionData.left = this.root._dom.offsetLeft +
                        this.parent.parent.parent.parent.root._dom.offsetLeft + // laterProgrammeItemMask
                        this.parent.parent.parent.parent.parent.parent.root._dom.offsetLeft; // epgContainer

                    freesat.actionData.top = this.parent.root._dom.offsetTop + // channel_row
                        this.parent.parent.parent.parent.root._dom.offsetTop + // laterProgrammeItemMask
                        this.parent.parent.parent.parent.parent.parent.root._dom.offsetTop; // epgContainer
                    freesat.actionData.width = this.root._dom.offsetWidth;
                    freesat.actionData.height = freesat.behind.ITEM_HEIGHT;
                    freesat.actionData.hasMask = true;
                    freesat.actionData.programObject = this._data;
                    freesat.actionData.later = true;
                    freesat.masterController.instanciateSelectionMenu();

                } else if (vKey === accedo.VKey.KEY_INFO) {
                    if(freesat.masterController.showInfo == false){
                        freesat.masterController.showInfo = true;
                        freesat.setBackFocus(accedo.ui.FocusManager.singleton().getCurrentFocus());
                        freesat.actionData = new freesat.models.vo.MenuObject();
                        freesat.actionData.timeZone = freesat.getZone();
                        if (this.timeZone === 'now') {
                            freesat.actionData.timeZone = 'now';
                        } else {
                            freesat.actionData.timeZone = 'later';
                        }
                        freesat.actionData.later = true;
                        freesat.actionData.backFocus = this;
                        freesat.actionData.hasMask = true;
                        freesat.actionData.programObject = this._data;
                        freesat.actionData.location = 'Tvguide';
                        freesat.masterController.instanciateAbout();
                    }
                }
            }
        },
        handleRecord: function(programme) {
            if (!freesat.masterController.recordingsHandler.hasPVR()) {
                freesat.masterController.recordingsHandler.showNoHddWarning();
                return;
            }
            if (!programme) {
                freesat.console.log('ERROR: no OIPF Programme object available - aborting');
                return;
            }
            if (programme.hasRecording) {
                // already has a recording - toggle it off
                this.handleCancelRecord(programme);
                return;
            }
            switch (freesat.masterController.recordingsHandler.setRecording(programme)) {
            case freesat.masterController.recordingsHandler.RECORDING_CLASH:
                // ignore as recording will have been set correctly and warning dialog will be shown: fall through
            case freesat.masterController.recordingsHandler.RECORDING_CHANGE_OK:
                console.log("set recording");

                accedo.ui.FocusManager.singleton().getCurrentFocus().setRecording(true);
                freesat.header.metaIcons.unset(freesat.header.programmeMetadataIconsContainer);
                freesat.header.metaIcons.set(programme, freesat.header.programmeMetadataIconsContainer);
                break;
            default:
                console.log("RECORDING FAILURE!!!!");
                break;
            }
        },
        handleCancelRecord: function(programme) {
            if (!freesat.masterController.recordingsHandler.hasPVR()) {
                freesat.console.log('ERROR: not PVR enabled, ignoring one-touch STOP keypress.');
                return;
            } else  if (!programme) {
                freesat.console.log('ERROR: no OIPF Programme object available - aborting');
                return;
            }

            console.log('cancelling recording of ' + programme.name);

            freesat.masterController.recordingsHandler.removeRecording(programme);

            accedo.ui.FocusManager.singleton().getCurrentFocus().setRecording(false);
            freesat.header.metaIcons.unset(freesat.header.programmeMetadataIconsContainer);
            freesat.header.metaIcons.set(programme, freesat.header.programmeMetadataIconsContainer);

            //freesat.masterController.selectionMenuBack();
        }
    }
);
/**
 * Created with JetBrains WebStorm.
 * User: Dean Clancy
 * Date: 16/10/13
 * Time: 08:31
 */
/*global accedo: false */
/**
 * Creates a new KeyHandler instance.
 * @name KeyHandler
 * @memberof freesat.controllers.tvguide
 * @class A KeyHandler class, bla functionality.
 * @author <a href="mailto:dean.clancy@accedo.tv">Dean Clancy</a>
 */
accedo.Class.create("freesat.controllers.tvguide.KeyHandler", [], {},
    {
        /**
         * This function the calls relevant activity for all key presses in the zapper/tlg.
         * @name onKey
         * @function
         * @memberof freesat.controllers.tvguide.keyHandler#
         * @public
         */
        onKey: function(vKey) {
            freesat.console.log('[tvguide.KeyHandler] key '+ vKey);

            if(freesat.behind.earlierFunc.channelBarChangeInterval && freesat.behind.earlierChannelNavigating && (vKey === accedo.VKey.KEY_UP || vKey === accedo.VKey.KEY_DOWN)){
                clearInterval(freesat.behind.earlierFunc.channelBarChangeInterval);
            }
            if(freesat.header && !freesat.masterController.showInfo){
                switch (vKey) {
                    case accedo.VKey.KEY_RIGHT:
                        return this.onRightKey();
                    case accedo.VKey.KEY_LEFT:
                        return this.onLeftKey();
                    case accedo.VKey.KEY_UP:
                        return this.onUpKey();
                    case accedo.VKey.KEY_DOWN:
                        return this.onDownKey();
                    case accedo.VKey.KEY_PAGE_UP:
                    case accedo.VKey.KEY_KEYBOARD_PAGE_UP:
                        return this.onPageUpKey();
                    case accedo.VKey.KEY_PAGE_DOWN:
                    case accedo.VKey.KEY_KEYBOARD_PAGE_DOWN:
                        return this.onPageDownKey();
                    case accedo.VKey.KEY_GREEN:
                        if(freesat.behind.earlierChannelFocused){
                            return true;
                        }else{
                            return this.onGreenKey();
                        }
                    case accedo.VKey.KEY_RED:
                        if (!freesat.masterController.loadingIcon.isShowing()) {
                            freesat.setBackFocus(accedo.ui.FocusManager.singleton().getCurrentFocus());
                        }
                        return false;

                    case accedo.VKey.KEY_YELLOW:
                        return this.onYellowKey();

                    case accedo.VKey.KEY_BLUE:
                        return this.onBlueKey();

                    case accedo.VKey.KEY_BACK:
                        if (freesat.behind.filter.isVisible) {
                            freesat.behind.filter.toggleMenu();
                            return true;
                        } else if (freesat.behind.column === 'earlier') {
                            freesat.behind.animationClass.firstStepAniEarlierToNowNext();
                            return true;
                        } else if (freesat.getZone() === 'later') {
                            freesat.behind.animationClass.firstStepAniLaterToNowNext();
                            return true;
                        }
                        break;

                }
            }
        },

        /**
         * This function the calls relevant activity for the right key.
         * @name onRightKey
         * @function
         * @memberof freesat.controllers.tvguide.keyHandler#
         * @public
         */
        onRightKey: function() {

            if (freesat.behind.filter.isVisible) {
                return true;
            }
            if (freesat.behind.column === 'now') {
                freesat.behind.column = 'next';
                freesat.behind.setItemFocus();
                freesat.behind.get('straplineNow').removeClass('highlight');
                freesat.behind.get('straplineNext').addClass('highlight');
                freesat.behind.highlightRightArrow();

            } else if (freesat.behind.column === 'next') {
                freesat.behind.animationClass.startNowNextTransition('later'); // firstStepAniNowNextToLater();

            } else if (freesat.behind.column === 'earlier') {

                if (freesat.behind.earlierChannelFocused && freesat.behind.earlierChannelNavigating) {
                    return false;
                }

                if (freesat.behind.earlierChannelFocused) {

                    if (freesat.behind.day === 0) {
                        freesat.behind.animationClass.firstStepAniEarlierToNowNext();
                    } else {
                        freesat.behind.day += 1;
                        freesat.behind.animationClass.firstStepAniEarlierPlus24Hours();
                    }

                } else {
                    freesat.behind.earlierChannelFocused = true;
                    var currentFocus = freesat.behind.itemsContainers[~~(freesat.behind.topPositionIndex / 7)].getChildren()[freesat.behind.row];

                    if (currentFocus) {
                        currentFocus.blur();
                        currentFocus.dispatchEvent(accedo.ui.Evt.BLUR);
                    }
                    this.focusChannel();
                    freesat.behind.highlightRightArrow();
                }

            } else if (freesat.behind.column === 'picture') {
                freesat.behind.setEarlierFocus();

            } else if (freesat.getZone() === 'later') {
                freesat.behind.laterFunc.setLaterFocus('right');
            }
        },
        removeFocusFromChannel: function(){
            freesat.behind.get('chlogo' + (freesat.behind.earlierChannelRow +1) + 'p' + freesat.behind.page).defocused();
        },
        defocusChannel: function(){
            freesat.behind.get('chlogo' + (freesat.behind.earlierChannelRow +1) + 'p' + freesat.behind.page).defocused();
            freesat.behind.get('ch' + (freesat.behind.earlierChannelRow + 1) + 'p' + freesat.behind.page).addClass('highlight');
            freesat.behind.get('chlogo' + (freesat.behind.earlierChannelRow +1) + 'p' + freesat.behind.page).highlight();
        },
        focusChannel: function(){
            freesat.console.log('#### #### freesat.behind.earlierChannelRow : '+freesat.behind.earlierChannelRow);
            freesat.console.log('#### #### freesat.behind.lastRow : '+freesat.behind.lastRow);
            freesat.behind.resetHeader();
            freesat.behind.get('chlogo' + (freesat.behind.earlierChannelRow +1) + 'p' + freesat.behind.page).dehighlight();
            freesat.behind.get('ch' + (freesat.behind.earlierChannelRow + 1) + 'p' + freesat.behind.page).removeClass('highlight');
            freesat.behind.get('chlogo' + (freesat.behind.earlierChannelRow+1) + 'p' + freesat.behind.page).focused();
        },
        /**
         * This function the calls relevant activity for the left key.
         * @name onLeftKey
         * @function
         * @memberof freesat.controllers.tvguide.keyHandler#
         * @public
         */
        onLeftKey: function() {

            if (freesat.behind.filter.isVisible) {
                return true;
            }
            if (freesat.behind.column === 'now') {

                if (freesat.behind.channelUtils.hasHighlightedChannelGotTsTV()) {
                    freesat.behind.get('straplineNow').removeClass('highlight');
                    freesat.behind.animationClass.startNowNextTransition('earlier'); //firstStepAniNowNextToEarlier();

                }

            } else if (freesat.behind.column === 'next') {
                freesat.behind.column = 'now';
                freesat.behind.setItemFocus();
                freesat.behind.get('straplineNext').removeClass('highlight');
                freesat.behind.get('straplineNow').addClass('highlight');

            } else if (freesat.behind.column === 'earlier') {

                if (freesat.behind.earlierChannelFocused && freesat.behind.earlierChannelNavigating) {
                    return false;
                }

                if (freesat.behind.earlierChannelFocused) {

                    if (freesat.dataStore.allData.earlierAll[freesat.behind.freesatServiceID].length > 0) {
                        this.defocusChannel();
                        freesat.behind.earlierChannelFocused = false;
                        freesat.behind.itemsContainers[~~(freesat.behind.topPositionIndex / 7)].getChildren()[freesat.behind.row].setFocus();
                        freesat.behind.rightArrow.deactivateFocus();

                        if (!freesat.behind.hasEarlierPromo) {
                            freesat.behind.highlightLeftArrow();
                        }
                    }
                } else if (freesat.behind.hasEarlierPromo) {
                    freesat.behind.column = 'picture';
                    freesat.behind.setEarlierPictureFocus();
                    freesat.behind.highlightLeftArrow();
                } else {
                    freesat.behind.handleEarlierEarlier();
                }


            } else if (freesat.behind.column === 'picture') {
                freesat.behind.handleEarlierEarlier();
            } else if (freesat.getZone() === 'later') {
                freesat.behind.laterFunc.setLaterFocus('left');
            }
        },
        /**
         * This function the calls relevant activity for the up key.
         * @name onUpKey
         * @function
         * @memberof freesat.controllers.tvguide.keyHandler#
         * @public
         */
         onUpKey: function() {
            var zone = freesat.getZone();
            
            if ((zone === 'now' && freesat.behind.filter.isVisible) || (zone === 'later' && freesat.behind.filter.isVisible)) {
                freesat.behind.filter.navigate('up');
            } else if (zone === 'now') {
                if (freesat.behind.row === 0) {
                    // dehighlight channel number and logo
                    freesat.behind.get('chlogo' + (freesat.behind.row +1) + 'p' + freesat.behind.page).dehighlight();
                    freesat.behind.get('ch' + (freesat.behind.row + 1) + 'p' + freesat.behind.page).removeClass('highlight');
                    freesat.behind.row = 6;
                    freesat.behind.tapPageUp = true;
                    freesat.behind.animationClass.startPaging('up'); //pageUp();
                } else {
                    freesat.behind.row -= 1;
                    freesat.behind.setItemFocus();
                }
            } else if (zone === 'earlier' && freesat.behind.column !== 'picture') {
                if(freesat.behind.earlierChannelFocused){
                    freesat.behind.earlierChannelNavigating = true;
                    if(freesat.behind.earlierChannelRow > 0){
                        this.removeFocusFromChannel();
                        freesat.behind.earlierChannelRow = freesat.behind.earlierChannelRow - 1;
                        this.focusChannel();
                        freesat.behind.earlierChannel = freesat.channelData.channelList.getChannel('ccid:'+freesat.behind.channelLCNlist[freesat.behind.earlierTopPositionIndex + freesat.behind.earlierChannelRow]);
                        freesat.behind.earlierFunc.channelBarChangeInterval = setInterval(freesat.behind.earlierFunc.refreshEarlier, 800);
                        return;
                    }else if(freesat.behind.earlierTopPositionIndex > 0){
                        this.removeFocusFromChannel();
                        freesat.behind.earlierChannelRow = 6;
                        freesat.behind.earlierTopPositionIndex -= 7;
//                        freesat.behind.lastRow = 6;
                        freesat.behind.channelUtils.createChannelBar(7, freesat.behind.earlierTopPositionIndex);
                        this.focusChannel();
                        freesat.behind.earlierChannel = freesat.channelData.channelList.getChannel('ccid:'+freesat.behind.channelLCNlist[freesat.behind.earlierTopPositionIndex + freesat.behind.earlierChannelRow]);
                        freesat.behind.earlierFunc.callEarlier();
                        return;
                    }
                    return;
                }else if (freesat.behind.row === 0) {
                    if (freesat.behind.topPositionIndex > 0) {
                        freesat.behind.row = 6;
                        freesat.behind.tapPageUp = true;
                        freesat.behind.animationClass.pageUp();
                        return;
                    }
                } else {
                    freesat.behind.row -= 1;
                }
                freesat.behind.itemsContainers[~~(freesat.behind.topPositionIndex / 7)].getChildren()[freesat.behind.row].setFocus();
            } else if (zone === 'later') {
                freesat.behind.laterFunc.setLaterFocus('up');
            }
        },
        /**
         * This function the calls relevant activity for the down key.
         * @name onDownKey
         * @function
         * @memberof freesat.controllers.tvguide.keyHandler#
         * @public
         */
        onDownKey: function() {
            var zone = freesat.getZone(),
                limit = 6;
            if ((zone === 'now' && freesat.behind.filter.isVisible) || (zone === 'later' && freesat.behind.filter.isVisible)) {
                freesat.behind.filter.navigate('down');

            } else if (zone === 'now') {
                freesat.behind.tapPageUp = false;

                if (freesat.behind.pageRows < 7) {
                    limit = (freesat.behind.pageRows - 1);
                }
                
                if (freesat.behind.row === limit) {
                    // dehighlight channel number and logo
                    freesat.behind.get('chlogo' + (freesat.behind.row +1) + 'p' + freesat.behind.page).dehighlight();
                    freesat.behind.get('ch' + (freesat.behind.row + 1) + 'p' + freesat.behind.page).removeClass('highlight');
                    freesat.behind.row = 0;
                    freesat.behind.tapPageDown = true;
                    freesat.behind.animationClass.startPaging('down'); //pageDown();
                } else {
                    freesat.behind.row += 1;
                    freesat.behind.setItemFocus();
                }
            } else if (zone === 'earlier' && freesat.behind.column !== 'picture') {
                if(freesat.behind.earlierChannelFocused){
                    freesat.behind.earlierChannelNavigating = true;
                    if(freesat.behind.earlierChannelRow < (freesat.behind.channelLCNlist.length - 1) && freesat.behind.earlierChannelRow + 1 < freesat.behind.earlierChannelList.length){
                        this.removeFocusFromChannel();
                        freesat.behind.earlierChannelRow = freesat.behind.earlierChannelRow + 1;
                        this.focusChannel();
                        freesat.behind.earlierFunc.channelBarChangeInterval = setInterval(freesat.behind.earlierFunc.refreshEarlier, 800);
                        return;
                    }else if(freesat.behind.earlierTopPositionIndex+7 < freesat.behind.earlierChannelList.length){ // freesat.behind.earlierTopPositionIndex > 0 &&
                        this.removeFocusFromChannel();
                        freesat.behind.earlierChannelRow = 0;
                        freesat.behind.earlierTopPositionIndex += 7;
                        freesat.behind.channelUtils.createChannelBar(7, freesat.behind.earlierTopPositionIndex);
                        this.focusChannel();
                        freesat.behind.earlierFunc.callEarlier();
                        return;
                    }
                    return;
                }else if (freesat.behind.row === 6) {
                    freesat.behind.row = 0;
                    freesat.behind.animationClass.pageDown();
                    return;
                } else if (freesat.behind.currentRows < 7) {
                    if (freesat.behind.row < freesat.behind.currentRows - 1) {
                        freesat.behind.row += 1;
                    }
                } else {
                    freesat.behind.row += 1;
                }
                freesat.behind.itemsContainers[~~(freesat.behind.topPositionIndex / 7)].getChildren()[freesat.behind.row].setFocus();
            } else if (zone === 'later') {
                freesat.behind.laterFunc.setLaterFocus('down');
            }
        },

        onPageDownKey: function() {
            var zone = freesat.getZone();

            if (freesat.behind.filter.isVisible) {
                return;
            }

            if (zone === 'earlier' && freesat.behind.column !== 'picture' && freesat.behind.earlierChannelFocused) {
                if (freesat.behind.earlierTopPositionIndex + 7 < freesat.behind.earlierChannelList.length) {
                    freesat.behind.earlierChannelNavigating = true;
                    this.removeFocusFromChannel();
                    freesat.behind.earlierTopPositionIndex += 7;
                    if (freesat.behind.earlierTopPositionIndex + freesat.behind.earlierChannelRow >= freesat.behind.earlierChannelList.length) {
                        freesat.behind.earlierChannelRow = (freesat.behind.earlierChannelList.length - 1) % 7;
                    }
                    freesat.behind.channelUtils.createChannelBar(7, freesat.behind.earlierTopPositionIndex);
                    this.focusChannel();
                    freesat.behind.earlierFunc.callEarlier();
                }
            } else {
                freesat.behind.tapPageDown = false;
                freesat.behind.animationClass.startPaging('down'); //pageDown();
            }
        },

        onPageUpKey: function() {
            var zone = freesat.getZone();

            if (freesat.behind.filter.isVisible) {
                return;
            }

            if (zone === 'earlier' && freesat.behind.column !== 'picture' && freesat.behind.earlierChannelFocused) {
                if (freesat.behind.earlierTopPositionIndex > 0) {
                    freesat.behind.earlierChannelNavigating = true;
                    this.removeFocusFromChannel();
                    freesat.behind.earlierTopPositionIndex -= 7;
                    freesat.behind.channelUtils.createChannelBar(7, freesat.behind.earlierTopPositionIndex);
                    this.focusChannel();
                    freesat.behind.earlierFunc.callEarlier();
                } else if ((freesat.behind.earlierTopPositionIndex == 0) && freesat.behind.earlierChannelRow > 0) {
                    freesat.behind.earlierChannelNavigating = true;
                    this.removeFocusFromChannel();
                    freesat.behind.earlierChannelRow = 0;
                    this.focusChannel();
                    freesat.behind.earlierFunc.callEarlier();
                }
            } else {
                freesat.behind.tapPageUp = false;
                freesat.behind.animationClass.startPaging('up'); //pageUp();
            }
        },

        onGreenKey: function() {
            var zone = freesat.getZone();
            
            if ((zone === 'now' && freesat.behind.hasNowNext) || (zone === 'later' && freesat.behind.hasLater)) {
                freesat.behind.filter.toggleMenu();
                freesat.setBackFocus(accedo.ui.FocusManager.singleton().getCurrentFocus());

            }
        },

        onYellowKey: function() {
            var zone = freesat.getZone();

            if ((zone === 'now' && freesat.behind.filter.isVisible) || (freesat.getZone() === 'later' && freesat.behind.filter.isVisible)) {
                return true;

            } else if ((zone === 'later' && freesat.behind.day > 0) ||
                (zone === 'later' && freesat.behind.gridStartTime > freesat.behind.nowStartTime)) {
                freesat.behind.day -= 1;
                freesat.behind.animationClass.startLaterToLater('minus24'); // firstStepAniMinus24Hours();

            } else if (zone === 'later' && freesat.behind.gridStartTime === freesat.behind.nowStartTime) {
                if (freesat.behind.column > 0) {
                    freesat.behind.laterFunc.setLaterFocus('plus24');
                } else if (freesat.behind.channelUtils.channelCheck()) {
                    freesat.behind.animationClass.startLaterToEarlier(); // firstStepAniLaterToEarlier();
                }

            } else if (zone === 'now' && freesat.behind.channelUtils.channelCheck()) {
                freesat.behind.day -= 1;
                freesat.behind.nowMinus24 = true;
                freesat.behind.animationClass.startNowNextTransition('earlier'); // firstStepAniNowNextToEarlier();
                
            } else if (zone === 'earlier' && -freesat.behind.day < freesat.dataStore.allData.earlierAll[freesat.behind.freesatServiceID].length - 1) {
                freesat.behind.day -= 1;
                freesat.behind.animationClass.firstStepAniEarlierMinus24Hours();
            }
        },

        onBlueKey: function() {
            var zone = freesat.getZone();
            
            if ((zone === 'now' && freesat.behind.filter.isVisible) || (freesat.getZone() === 'later' && freesat.behind.filter.isVisible)) {
                return true;

            } else if (zone === 'later' && freesat.behind.day < 7) {
                freesat.behind.day += 1;
                try{
                    freesat.behind.animationClass.startLaterToLater('plus24'); // firstStepAniPlus24Hours();
                }catch (e){
                    freesat.behind.animationClass = new freesat.controllers.tvguide.Later();
                    freesat.behind.animationClass.startLaterToLater('plus24');
                }
            } else if (zone === 'now') {
                freesat.behind.day = 1;
                freesat.behind.animationClass.startNowNextTransition('plus24');
//                freesat.behind.animationClass.firstStepAniNowNextToPlus24Hours();

            } else if (zone === 'earlier') {

                if (freesat.behind.day < 0) {
                    freesat.behind.day += 1;
                    freesat.behind.animationClass.firstStepAniEarlierPlus24Hours();
                } else {
                    freesat.behind.animationClass.firstStepAniEarlierToNowNext();
                }
            }
        }
    }
);
/**
 * User: Dean Clancy
 * Date: 31/01/14
 * Time: 09:47
 */
/*global accedo: false */
/**
 * Creates a new Earlier instance.
 * @name Earlier
 * @memberof freesat.Earlier
 * @class A Earlier class, bla functionality.
 * @author <a href="mailto:dean.clancy@accedo.tv">Dean Clancy</a>
 */
accedo.Class.create("freesat.controllers.tvguide.func.Earlier", [], {},
    {
        channelBarChangeInterval: null,
        refreshEarlier: function(){
            clearInterval(freesat.behind.earlierFunc.channelBarChangeInterval);
            freesat.behind.earlierFunc.callEarlier();
        },
        callEarlier: function() {
            freesat.isAnimating = true;
            var rowVal = freesat.behind.earlierChannelRow;
            freesat.behind.arrowContainer.addClass('fade-out');

            if (!freesat.behind.earlierChannelFocused) {
                freesat.behind.footerButtons.addClass('fade-out');
            }
            freesat.behind.channelFilter.addClass('hidden');

            freesat.behind.get('channelNumberColumnContainer' + freesat.behind.page).addClass('fade-out');
            var stashRow = rowVal;
            if (freesat.behind.dataInterface) {
                freesat.behind.dataInterface.getEarlierData(freesat.channelData.channelList.getChannel('ccid:'+String(freesat.behind.channelLCNlist[rowVal])),freesat.behind.day,6,18,freesat.behind.onData.earlierLoaded);
            }
            freesat.behind.earlierChannelRow  = stashRow;
            freesat.behind.highlightedChannelId = freesat.behind.channelLCNlist[rowVal];
            freesat.behind.lastRow = rowVal;

            freesat.behind.channelTopIndex = freesat.behind.topPositionIndex;
//            freesat.header.get('freesatLogo').setSrc("images/1280x720/logo/freetime-125x24.png");

        },

        earlierGridSetup: function () {
            if (freesat.behind.dataInterface.earlier.isIpAvailable()) {
                freesat.behind.get('earlier-connection-message').addClass('hidden');
                freesat.behind.programmeContainer = freesat.behind.get('earlierProgrammeItemContainer');
                freesat.behind.programmeImages = freesat.behind.get('programmeImageContainer');
                freesat.behind.programmeContainer.removeAll();
                freesat.behind.programmeImages.removeAll();
                freesat.behind.row = 0;
                freesat.behind.get('rightArrow').removeClass('hidden');
                freesat.behind.populateEarlier(true);

                if (freesat.behind.leftArrowHidden && -freesat.behind.day < freesat.dataStore.allData.earlierAll[freesat.behind.freesatServiceID].length - 1) {
                    freesat.behind.get('leftArrow').removeClass('hidden');
                    freesat.behind.leftArrowHidden = false;
                }
                if (freesat.behind.launchedInEarlier) {
                    setTimeout(freesat.loadRemainingSections, 200);
                }
            } else {
                this.showNotConnected();
            }
        },
        showNotConnected: function(){
            freesat.behind.get('earlier-connectionmessageLabel').setText('To use this section, please make sure your TV is connected to the internet');
            freesat.behind.get('earlier-connectionLabel').setText('get connected');
            this.displayErrorMessage();
        },
        showNotAvailable: function(){
            freesat.behind.get('earlier-connectionmessageLabel').setText('This service is currently unavailable. Please try again later.');
            freesat.behind.get('earlier-connectionLabel').setText('not available');
            this.displayErrorMessage();
        },
        displayErrorMessage: function(){
            freesat.behind.hasEarlierError = true;
            freesat.behind.get('earlier-connection-message').removeClass('hidden');
            freesat.behind.get('footer').addClass('hidden');
            freesat.behind.get('straplineEarlierContainer').addClass('hidden');
            freesat.behind.get('peekChannelGradient').addClass('hidden');
            freesat.behind.get('leftArrow').addClass('hidden');
            freesat.behind.get('rightArrow').addClass('hidden');
            freesat.behind.get('earlier-connectionBackButton').setFocus();
        },
        populateEarlier: function(freshDrawn) {
            var topPositionIndex = freesat.behind.topPositionIndex,
                day,
                earlierData,
                earlierProgrammes,
                _programmeItems = [],
                _maxLines,
                channel = freesat.behind.earlierChannel,
                initialFocus,
                initialPage,
                lastBlock = 0,
                promoInitialFocus,
                len,
                i;

            freesat.behind.freesatServiceID = channel.freesatServiceID;

            if (freesat.behind.nowMinus24 && -freesat.behind.day > freesat.dataStore.allData.earlierAll[freesat.behind.freesatServiceID].length - 1) {
                freesat.behind.day = -(freesat.dataStore.allData.earlierAll[freesat.behind.freesatServiceID].length - 1);
                freesat.behind.nowMinus24 = false;
            }
            day = freesat.behind.day;

            if (day < 0) {
                day = -day;
            }

            try {
                earlierData = freesat.dataStore.allData.earlierAll[channel.freesatServiceID][day];
                earlierProgrammes = earlierData.programmes;

                if (freshDrawn) {
                    if(freesat.backJourney){
                        freesat.console.log("searching for " + freesat.backItemName);
                        freesat.behind.channelList = freesat.channelData.channelList;
                        var indexAdjust = freesat.behind.topPositionIndex;
                        var display_length;
                        if (freesat.channelData.channelListLength < 7) {
                            display_length = freesat.channelData.channelListLength;
                        } else {
                            display_length = (freesat.channelData.channelListLength - indexAdjust);
                            if (display_length > 7) {
                                display_length = 7;
                            }
                            freesat.behind.canPage = true;
                        }
                        freesat.behind.channelUtils.createChannelBar(display_length, indexAdjust);
                        freesat.behind.get('channelNumberColumnContainer' + freesat.behind.page).addClass('fade-out');
                        freesat.behind.channelUtils.highlightGivenChannel(freesat.behind.lastRow);
                        freesat.behind.firstBack = true;
                        for (i = 0; i < earlierProgrammes.length; i++) {
                            if (earlierProgrammes[i].StartText + earlierProgrammes[i].name === freesat.backItemName) {
                                initialFocus = i + 1;
                                freesat.console.log("Found it at index " + i);
                                delete freesat.backItemName;
                                break;
                            }
                        }
                        freesat.backJourney = false;
                    }

                    initialFocus = initialFocus || earlierData.initialItem || 1; // fallback chain

                    freesat.console.log('INITIAL ITEM: ' + initialFocus + '; ' + earlierData.heading_title);
                    initialPage = Math.floor((initialFocus - 1) / freesat.behind.PAGE_ITEMS);
                    topPositionIndex = initialPage * freesat.behind.PAGE_ITEMS;

                    freesat.console.log('PAGE: ' + initialPage + '; INDEX: ' + topPositionIndex + '; LENGTH: ' + earlierProgrammes.length);
                    freesat.behind.topPositionIndex = topPositionIndex;
                    initialFocus = (initialFocus % freesat.behind.PAGE_ITEMS) - 1;

                    if (initialFocus < 0) {
                        initialFocus = freesat.behind.PAGE_ITEMS - 1;
                    }
                    freesat.console.log('INITIAL ROW: ' + initialFocus);
                    freesat.behind.row = initialFocus;
                }

                if (freshDrawn && freesat.behind.itemsContainer && freesat.behind.itemsContainers) {
                    freesat.behind.itemsContainer.detach();
                    delete freesat.behind.itemsContainer;
                    delete freesat.behind.itemsContainers;
                }
                if (!freesat.behind.itemsContainer) {
                    freesat.behind.itemsContainer = new accedo.ui.Container({
                        id: '#earlierProgrammeItems',
                        css: 'earlierProgrammeItems'
                    });
                    freesat.behind.programmeContainer.attach(freesat.behind.itemsContainer);
                }
                if (!freesat.behind.itemsContainers) {
                    freesat.behind.itemsContainers = [];
                }
                if (freesat.behind.itemsContainers.length > 0) {
                    lastBlock = freesat.behind.itemsContainers[freesat.behind.itemsContainers.length - 1].opts.topIndex;
                } else {
                    freesat.behind.itemsContainers.push(new accedo.ui.Container({
                        css: 'earlierProgrammeItems',
                        topIndex: 0,
                        empty: true
                    }));
                }
                while (earlierProgrammes.length - 1 >= lastBlock + freesat.behind.PAGE_ITEMS &&
                    (freesat.behind.topPositionIndex + freesat.behind.PAGE_ITEMS > lastBlock || lastBlock <= freesat.behind.PAGE_ITEMS)) { // if the last visible item is > last block's first item
                    lastBlock += freesat.behind.PAGE_ITEMS;
                    freesat.behind.itemsContainers.push(new accedo.ui.Container({
                        css: 'earlierProgrammeItems',
                        topIndex: lastBlock,
                        empty: true
                    }));
                }

                len = freesat.behind.itemsContainers.length;

                for (i = 0; i < len; i++) {
                    if (freesat.behind.itemsContainers[i].opts.empty) {
                        _maxLines = Math.min(earlierProgrammes.length, freesat.behind.itemsContainers[i].opts.topIndex + freesat.behind.PAGE_ITEMS);
                        for (var j = freesat.behind.itemsContainers[i].opts.topIndex; j < _maxLines; j++) {
                            var lineObj = {
                                css: 'earlierProgrammeGridItem',
                                action: earlierProgrammes[j].available,
                                nextLeft: 'image_one',
                                data: earlierProgrammes[j],
                                index: j
                            };
                            var line = new freesat.widget.EarlierProgrammeGridItem(lineObj);
                            line.onKey = freesat.behind.handleSelection.handleEarlierItemSelection();
                            line.notifyFocused = freesat.behind.setEarlierHeader;
                            freesat.behind.itemsContainers[i].attach(line);
                        }
                    }
                }

                freesat.behind.get('straplineEarlierTitle').setText(earlierData.heading_title);
                freesat.behind.leftArrow.setText(earlierData.backwardtext);
                freesat.behind.rightArrow.setText(earlierData.forwardtext);
                freesat.behind.get('straplineEarlierChannelName').setText(channel.name);

                if (earlierProgrammes.length > topPositionIndex + freesat.behind.PAGE_ITEMS) {
                    if (earlierProgrammes.length > topPositionIndex + freesat.behind.MAX_PAGE_ITEMS) {
                        _maxLines = freesat.behind.MAX_PAGE_ITEMS;
                    } else {
                        _maxLines = earlierProgrammes.length - topPositionIndex;
                    }
                    freesat.behind.canPageDown = true;
                } else {
                    _maxLines = earlierProgrammes.length - topPositionIndex;
                    freesat.behind.canPageDown = false;
                }
                freesat.behind.numOfRows = _maxLines - 1;

                if (topPositionIndex > 0) {
                    freesat.behind.canPageUp = true;
                } else {
                    freesat.behind.canPageUp = false;
                }

                if (_maxLines < freesat.behind.PAGE_ITEMS) {
                    freesat.behind.currentRows = _maxLines;
                } else {
                    freesat.behind.currentRows = freesat.behind.PAGE_ITEMS;
                }

                freesat.behind.hasEarlier = true;

                if(freesat.behind.programmeImages.getChildren().length < 1){
                    promoInitialFocus = this.populateEarlierPromo();
                }
                var second = false;
                len = freesat.behind.itemsContainers.length;
                for (i = 0; i < len; i++) {
                    if (freesat.behind.itemsContainers[i].opts.empty) {
                        freesat.behind.itemsContainers[i].opts.empty = false;
                        freesat.behind.itemsContainer.attach(freesat.behind.itemsContainers[i]);
                    }
                    if (freesat.behind.itemsContainers[i].opts.topIndex >= freesat.behind.topPositionIndex &&
                        freesat.behind.itemsContainers[i].opts.topIndex <= freesat.behind.topPositionIndex + freesat.behind.PAGE_ITEMS) {
                        if (second) {
                            freesat.behind.itemsContainers[i].addClass("second-page");
                        } else {
                            freesat.behind.itemsContainers[i].removeClass("second-page");
                        }
                        second = true;
                        freesat.behind.itemsContainers[i].show();
                    } else {
                        freesat.behind.itemsContainers[i].hide();
                    }
                }
                if (!promoInitialFocus && !freesat.behind.earlierChannelFocused) {
                    freesat.behind.itemsContainers[~~(freesat.behind.topPositionIndex / 7)].getChildren()[freesat.behind.row].setFocus();
                }
                if (!freesat.behind.canPageUp && !freesat.behind.canPageDown) {
                    freesat.footer.hide('paging');
                } else {
                    freesat.footer.show('paging');
                }
            } catch (e) {
                freesat.console.log('ERROR: No earlier programme data');
                freesat.console.log('Caught: ' + e);
            }
        },

        populateEarlierPromo: function() {

            var promos,
                day = freesat.behind.day,
                promoImage,
                initialFocusPromo,
                imageFactory = new freesat.models.Imagefactory(),
                i, len, opts;

            function goToGrid() {
                freesat.behind.row = 0;
                freesat.behind.itemsContainers[~~(freesat.behind.topPositionIndex / 7)].getChildren()[0].setFocus();
            }

            if (day < 0) {
                day = -day;
            }
            promos = freesat.dataStore.allData.earlierAll[freesat.behind.freesatServiceID][day].promos;

            len = promos.length;

            if (len > 0) {
                for (i = 0; i < len; i++) {
                    opts = {
                        id:'#promoImage' + i,
                        css:'programItemWithImage',
                        url: imageFactory.getImageURL(promos[i].image,213,174,true),
                        data: promos[i],
                        nextRight: goToGrid
                    };

                    if (day < (freesat.dataStore.allData.earlierAll[freesat.behind.freesatServiceID].length - 1)) {
                        opts.nextLeft = 'leftArrow';
                    }

                    if (len > 1) {
                        opts.nextDown = 'promoImage' + (i + 1);
                    }

                    if (i === 1) {
                        opts.nextUp = 'promoImage' + (i - 1);
                    }
                    promoImage = new freesat.widget.ProgramItemWithImage(opts);
                    promoImage.notifyFocused = freesat.behind.setEarlierHeader;
                    freesat.behind.programmeImages.attach(promoImage);
//                    promoImage.onKey = freesat.behind.handleItemSelection;
                    promoImage.onKey = freesat.behind.handleSelection.handleEarlierItemSelection(true);
                    if ("promo" + promos[i].StartText + promos[i].name === freesat.backItemName) {
                        initialFocusPromo = promoImage;
                        delete freesat.backItemName;
                    }
                }
                freesat.behind.hasEarlierPromo = true;
            } else {
                freesat.behind.hasEarlierPromo = false;

                if (!freesat.behind.earlierChannelFocused) {
                    freesat.behind.highlightLeftArrow();
                }
            }
            if (initialFocusPromo) {
                initialFocusPromo.setFocus();
                freesat.behind.column = 'picture';
                setTimeout(freesat.behind.highlightLeftArrow, 0);
                return true;
            }
        }
    }
);
/**
 * User: Dean Clancy
 * Date: 31/01/14
 * Time: 10:19
 */
/*global accedo: false */
/**
 * Creates a new Later instance.
 * @name Later
 * @memberof freesat.Later
 * @class A Later class, later functionality.
 * @author <a href="mailto:dean.clancy@accedo.tv">Dean Clancy</a>
 */
accedo.Class.create("freesat.controllers.tvguide.func.Later", [], {},
    {
        startTime: null,

        onNowLaterDataFirstCallback: function(channelIndex, startday, starthour, numberofhours) {
//            timeTrack('onNowLaterDataFirstCallback');
            freesat.console.log('onNowLaterDataFirstCallback');
            freesat.behind.laterFunc.createLaterGrid(channelIndex, startday, starthour, numberofhours);
//            timeTrack('createLaterGrid completed');
            freesat.console.log('onNowLaterDataFirstCallback created later grid');
            freesat.behind.animationClass = new freesat.controllers.tvguide.Later();
            freesat.behind.animationClass.AM_ScreenView();
            freesat.behind.laterFunc.setLaterFocus('load');
//            timeTrack('setLaterFocus');
            freesat.isAnimating = false;
        },

        onLaterPagingCallback: function(channelIndex, startday, starthour, numberofhours) {

            freesat.behind.laterProgrammeItemContainer = freesat.behind.get('laterProgrammeItemContainer').detach();
            freesat.behind.laterFunc.populateLater(false, channelIndex, startday, starthour, numberofhours);
            freesat.behind.laterProgrammeItemMask.attach(freesat.behind.laterProgrammeItemContainer);

            // Set focus and variable flags
            freesat.behind.isSetLaterFocus = false;
            freesat.behind.laterFunc.setLaterFocus('paging');
            freesat.isAnimating = false;
            freesat.behind.laterPaging = false;
        },

        onLaterPageDownCallback: function(channelIndex, startday, starthour, numberofhours) {
            this.populateLater(false, channelIndex, startday, starthour, numberofhours);
            freesat.behind.animationClass.animatePageDown();
        },

        onLaterPageUpCallback: function(channelIndex, startday, starthour, numberofhours) {
            this.populateLater(true, channelIndex, startday, starthour, numberofhours);
            freesat.behind.animationClass.animatePageUp();
        },

        onLaterGenreCallback: function(channelIndex, startday, starthour, numberofhours) {
            var rows = freesat.behind.PAGE_ITEMS,
                channelList = freesat.behind.channelList,
                length = channelList.length,
                i;

            freesat.console.log('onLaterGenreCallback');
            // Get new channel list
            freesat.behind.channelLCNlist = [];

            if (rows > length) {
                rows = length;
            }

            for (i = 0; i < rows; i++) {
                var channelLCN,
                    index = i + freesat.behind.topPositionIndex;

                channelLCN = parseInt(channelList[index].ccid.split(':')[1], null);
                freesat.behind.channelLCNlist.push(channelLCN);
            }
            freesat.behind.laterFunc.populateLater(false, channelIndex, startday, starthour, numberofhours);
            freesat.behind.laterFunc.setLaterFocus('plus24');
        },

        /**
         *
         * @param {boolean} prepend: value to pass to container attach method,
         * as to whether new elements are prepended or appended
         */
        populateLater: function(prepend, channelIndex, startday, starthour, numberofhours) {
            var laterArray = freesat.dataStore.allData.laterAll,
                row_width, row_item_id, programmeData, programmeDataLength, container, opts, i, j, col_id, programme,
                grid, cell_width, prog_item, diff, durationInSeconds, firstTimeBlock, x = 0, isNow = false,
                row_arr, prog_obj, programmeDay, overflow,
                now;

            window.laterItemNum = 0;
            freesat.behind.laterGridModel = [];

            firstTimeBlock = freesat.behind.gridStartTime + (30 * 60);

            if (freesat.behind.hasLater) {

                try {
                    freesat.behind.laterProgrammeItemContainer.get('laterGrid').detach(); //.removeAll();
                } catch (e) {
                    freesat.console.log('CANNOT DETACH GRID: ' + e);
                }
            }
            freesat.console.log('tvguide.later : freesat.behind.isGenreList : '+freesat.behind.isGenreList);
            if (freesat.behind.isGenreList) {
                laterArray = freesat.dataStore.allData.laterGenre;
            }

            grid = new accedo.ui.Container({
                id: '#laterGrid', //_' + freesat.behind.gridX + '_' + freesat.behind.gridY,
                css: 'laterGridContainer'
            });

            if (freesat.behind.updateChannelbar || freesat.behind.updateGenreTitle) { // If paged or genre list, update channelbar
                freesat.behind.channelUtils.createChannelBar(freesat.behind.pageRows, freesat.behind.topPositionIndex);
                freesat.behind.updateChannelbar = false;
            }

            // Set now time in seconds
            if (freesat.behind.gridStartTime === freesat.behind.nowStartTime) {
                now = Math.round(new Date().getTime() / 1000);
            }

            freesat.console.log('tvguide.populateLater : GRID START: ' + freesat.getEasyTime(freesat.behind.gridStartTime) + ' :freesat.behind.pageRows:'+freesat.behind.pageRows);

            for (i = 0; i < freesat.behind.pageRows; i++) {
                row_arr = [];
                freesat.behind.laterGridModel.push(row_arr);
                row_width = 0;
                row_item_id = 0;

                try {
                    programmeDay = laterArray[channelIndex+i][startday];
                    programmeData = programmeDay[freesat.behind.dataInterface.getLater3rdDimension(starthour,numberofhours)];
                    programmeDataLength = programmeData.length;
                    container = freesat.behind.createItem.createContainer('later_channel_'+ freesat.behind.gridX + '_' + freesat.behind.gridY + '_' + i,'channel_row');
                    freesat.console.log('tvGuide.populateLater programmeDataLength ' +programmeDataLength);
                    freesat.console.log('ROW: ' + i + ', PROGRAMMES: ' + programmeDataLength);
                    for (j = 0; j < programmeDataLength; j++) {

                        col_id = 0;
                        programme = programmeData[j];
                        if (programme !== undefined) {

                            try {
                                if (programme.startTime + programme.duration > freesat.behind.gridStartTime) {
//                                freesat.console.log('[tvGuide] populateLater startTime + duration > gridStartTime');
                                    if (programme.startTime < freesat.behind.gridStartTime) {
                                        x = 0;
                                        // Calculate difference from programme start and grid start time
                                        diff = freesat.behind.gridStartTime - programme.startTime;
                                        durationInSeconds = programme.duration - diff;
                                    } else {
                                        durationInSeconds = programme.duration;

                                        if (programme.startTime === freesat.behind.gridStartTime) {
                                            x = 0;
                                        } else {
                                            x = Math.floor(((programme.startTime - freesat.behind.gridStartTime) / 1800) * 189.2);
                                        }
                                    }
                                    cell_width = Math.round((durationInSeconds / 1800) * 189.2);

                                    if (x < 945) {
                                        overflow = x + cell_width;

                                        if (overflow > 945) {
                                            overflow = overflow - 945;
                                            cell_width -= overflow;
                                        }

                                        if (now) {
                                            isNow = (programme.startTime <= now && (programme.startTime + programme.duration > now));
                                        }
                                        prog_item = freesat.behind.createItem.laterItem(i, freesat.behind.gridY, row_item_id, cell_width, {
                                            prog: programme,
                                            isNow: isNow
                                        });
                                        prog_item.root._dom.style.left = x + 'px';
                                        prog_item.root._dom.style.width = cell_width + 'px';
                                        container.attach(prog_item);
                                        prog_obj = freesat.behind.createItem.laterGrid({
                                            row_id: i,
                                            row_item_id: row_item_id,
                                            xPos: x,
                                            width: cell_width,
                                            isLastItem: (j === (programmeDataLength - 1)),
                                            startTime: programme.startTime,
                                            duration: programme.duration
                                        });
                                        freesat.behind.laterGridModel[i].push(prog_obj);
                                        col_id++;
                                        row_item_id++;
                                    } else {
                                        freesat.console.log(programme.name + '::' + freesat.getEasyTime(programme.startTime) + ' : ' + x);
                                    }
//                                    row_width += cell_width;
                                }
                            }catch(e){
                                freesat.console.log('tvguide populateLater '+e);
                            }
                        }
                    }

                    if (freesat.behind.laterGridModel[i].length === 0) {

                        programme = freesat.behind.dataInterface.returnNoDataProgramme(programme.channelID, startday, starthour, numberofhours);
                        x = 0;
                        cell_width = 946;

                        prog_item = freesat.behind.createItem.laterItem(i, freesat.behind.gridY, row_item_id, {
                            prog: programme,
                            isNow: (programme.startTime <= now && (programme.startTime + programme.duration > now))
                        });
                        prog_item.root._dom.style.left = x + 'px';
                        prog_item.root._dom.style.width = cell_width + 'px';
                        container.attach(prog_item);
                        prog_obj = freesat.behind.createItem.laterGrid({
                            row_id: i,
                            row_item_id: row_item_id,
                            xPos: x,
                            width: cell_width,
                            isLastItem: true,
                            startTime: programme.startTime,
                            duration: programme.duration
                        });
                        freesat.behind.laterGridModel[i].push(prog_obj);
                    }
                    grid.attach(container);

                    try {
                        freesat.behind.laterProgrammeItemContainer.removeClass('hide');
                    } catch (e) {
                        freesat.console.log('laterProgrammeItemContainer does not have "hide" class' + e);
                    }
                } catch (e) {
                    freesat.console.log('LATER CHANNEL RENDER FAIL '+ e);
                }
            }
            freesat.behind.laterProgrammeItemContainer.attach(grid, prepend);

            if (freesat.behind.filter.isVisible) {
                freesat.behind.filter.toggleMenu();
            }

            if (freesat.behind.updateGenreTitle) {
                freesat.behind.get('channelFilterLabel').setText(freesat.behind.filter.genres[freesat.behind.filter.selected]);
                freesat.behind.updateGenreTitle = false;
            }
        },

        createLaterGrid: function(channelIndex, startday, starthour, numberofhours) {
            if (freesat.dataStore.allData.laterAll !== null && freesat.dataStore.allData.laterAll !== undefined) {

                if (!freesat.behind.hasLater) {
                    freesat.behind.laterProgrammeItemContainer = new accedo.ui.Container({
                        id: '#laterProgrammeItemContainer', // + freesat.behind.gridX
                        css: 'laterProgrammeItemContainer'
                    });
                } else {
                    freesat.behind.laterProgrammeItemContainer = freesat.behind.get('laterProgrammeItemContainer').detach();
                }
                this.populateLater(false, channelIndex, startday, starthour, numberofhours);

                freesat.behind.laterProgrammeItemMask.attach(freesat.behind.laterProgrammeItemContainer);

                freesat.behind.hasLater = true;
                freesat.behind.animationClass.isLaterLoaded = true;
                if(freesat.behind.laterAniCallback){
                    freesat.behind.laterAniCallback();
                    freesat.behind.laterAniCallback = null;
                }
            }
        },

        /**
         *
         * @param       {number}    startTime: pass in a startTime in seconds or null if resetting
         * @property    {number}    freesat.behind.laterFunc.startTime
         *
         * Sets a startTime property for use when navigating vertically in the programme guide.
         *
         */

        setLaterStartTime: function(startTime) {
            freesat.behind.laterFunc.startTime = startTime;

        },
        /**
         *
         * @param {object} current: pass the current programme object from freesat.behind.laterGridModel
         * go through the next row of programme objects and select the first programme that has an end
         * time greater than the current start time.
         * @returns {string}
         */
        setLaterSelector: function(current) {
            var start,
                next_row,
                row_items,
                selector,
                i=0, j;

            freesat.console.log('PAGE ROWS: ' + freesat.behind.pageRows + '; ROW: ' + freesat.behind.row);

            if (freesat.behind.row > (freesat.behind.pageRows - 1)) {
                freesat.behind.row = (freesat.behind.pageRows - 1);
                freesat.console.log('NEW ROW: ' + freesat.behind.row);
            }

            next_row = freesat.behind.laterGridModel[freesat.behind.row];
            row_items = next_row.length;

            freesat.console.log('ROW:'+freesat.behind.row+'  ROW ITEMS: ' + row_items);

            if (freesat.behind.laterFunc.startTime) {
                start = freesat.behind.laterFunc.startTime;
            } else if(current){
                start = current.startTime;
                freesat.behind.laterFunc.setLaterStartTime(start);
            }

            if(start){
                for (i = 0; i < row_items; i++) {

                    if (start < next_row[i].endTime ) {
                        freesat.behind.column = i;
                        selector = i;
                        break;
                    }
                }
            }
            if (!selector) { // Use last programme item
                j = (i > 0) ? i - 1 : i;
                freesat.behind.column = j;
            }

            selector = 'event_' + freesat.behind.gridX + '_' + freesat.behind.gridY + '_' + freesat.behind.row + '_' +freesat.behind.column;
            return selector;
        },
        /**
         * Loop through the laterGridModel for the first array which isn't empty
         * Calls setLaterFocus('plus24')
         */
        findAvailableLaterEvent: function() {
            var len = freesat.behind.laterGridModel.length,
                i;

            for (i = 0; i < len; i++) {

                if (freesat.behind.laterGridModel[i].length > 0) {
                    freesat.behind.row = i;
                    freesat.behind.column = 0;
                    this.setLaterFocus('plus24');
                    break;
                }
            }

        },
        /**
         *
         * @param {string} on : load|plus24|up|down|left|right|paging
         * navigate the Later grid using the freesat.behind.laterGridModel
         * and return the selector string to setFocus to the appropriate element
         * or return the appropriate animation call for paging
         */
        setLaterFocus: function(on) {
            var rows, len, selector, current, next, on = on;

            if (!freesat.behind.isSetLaterFocus) {
                rows = freesat.behind.pageRows;
                freesat.behind.isSetLaterFocus = true;
                freesat.console.log('setLaterFocus on: ' + on + ', row: ' + freesat.behind.row + ' of ' + rows);

                if (on !== 'load' && on !== 'paging' && on !== 'plus24') {
                    current = freesat.behind.laterGridModel[freesat.behind.row][freesat.behind.column];
                }
                if(!current) current = freesat.behind.laterGridModel[0][0];
                if(!current) current = freesat.behind.laterGridModel[1][0];
                if(!current) current = freesat.behind.laterGridModel[2][0];

                if (freesat.behind.laterUpdate) {
                    on = 'update';
                    freesat.behind.laterUpdate = false;
                }

                try{
                    switch (on) {
                        case 'update':
                            selector = 'event_' + freesat.behind.gridX + '_' + freesat.behind.gridY + '_' + freesat.behind.row + '_' + freesat.behind.column;
                            break;

                        case 'load':
                            len = freesat.behind.laterGridModel[freesat.behind.row].length;
                            if (len > 2) {
                                selector = 'event_' + freesat.behind.gridX + '_' + freesat.behind.gridY + '_' + freesat.behind.row + '_2';
                                freesat.behind.column = 2;
                            } else {
                                selector = 'event_' + freesat.behind.gridX + '_' + freesat.behind.gridY + '_' + freesat.behind.row + '_' + (len - 1);
                                freesat.behind.column = (len - 1);
                            }
                            break;

                        case 'plus24':
                            freesat.behind.column = 0; // default to first item
                            freesat.behind.laterFunc.setLaterStartTime(null); // Reset Later startTime
                            selector = 'event_' + freesat.behind.gridX + '_' + freesat.behind.gridY + '_' + freesat.behind.row + '_' + freesat.behind.column;
                            break;
                        case 'up':
                            if (freesat.behind.row === 0) {
                                freesat.behind.row = 6;
                                freesat.behind.tapPageUp = true;
                                selector = freesat.behind.animationClass.startPaging('up');
                            } else {
                                freesat.behind.row -= 1;
                                selector = freesat.behind.laterFunc.setLaterSelector(current);
                            }
                            break;
                        case 'down':
                            if (freesat.behind.row === (rows - 1)) {
                                freesat.behind.row = 0;
                                freesat.behind.tapPageDown = true;
                                selector = freesat.behind.animationClass.startPaging('down');
                            } else {
                                freesat.behind.row += 1;
                                selector = freesat.behind.laterFunc.setLaterSelector(current);
                            }
                            break;
                        case 'left':
                            try{
                                selector = current.nextLeft;
                            }catch(e){
                                selector = null;
                            }
                            if (typeof selector === 'string') {
                                freesat.behind.column -= 1;
                                next = freesat.behind.laterGridModel[freesat.behind.row][freesat.behind.column];
                                freesat.behind.laterFunc.setLaterStartTime(next.startTime);
                            }
                            break;
                        case 'right':
                            try{
                                selector = current.nextRight;
                            }catch(e){
                                selector = null;
                            }
                            if (typeof selector === 'string') {
                                freesat.behind.column += 1;
                                next = freesat.behind.laterGridModel[freesat.behind.row][freesat.behind.column];
                                freesat.behind.laterFunc.setLaterStartTime(next.startTime);
                            }
                            break;
                        case 'paging':
                            selector = freesat.behind.laterFunc.setLaterSelector(freesat.behind.laterCurrent);
                            break;
                        case 'jump':
                            selector = freesat.behind.laterFunc.setLaterSelector(current);
                            break;
                    }
                    freesat.behind.isSetLaterFocus = false;
                } catch (e) {
                    freesat.console.log('[Error] tvguide setLaterFocus switch '+ e );
                    freesat.behind.isSetLaterFocus = false;
                }
                try{
                    if (selector) {

                        if (typeof selector === 'string') {

                            try {
                                freesat.console.log('SETTING Focus '+selector);
                                freesat.behind.get(selector).setFocus();
                                freesat.behind.channelUtils.highlightChannel();
                                freesat.behind.channelUtils.channelCheck();

                            } catch(e) {
                                freesat.console.log('setLaterFocus no selector programme :' + e);

                                freesat.behind.laterFunc.findAvailableLaterEvent();

                            }
                        } else {
                            selector();
                        }
                    }
                } catch (e) {
                    freesat.console.log('[Error] tvguide setLaterFocus if '+ e );
                    freesat.behind.isSetLaterFocus = false;
                }
            }
        }
    }
);
/*global accedo: false */
/**
 * Creates a new Filter instance.
 * @name Filter
 * @memberof freesat.controllers.tvguide
 * @class A Filter class
 * @author <a href='mailto:rhys.jeffreys@accedo.tv'>Rhys Jeffreys</a>
 */
accedo.Class.create('freesat.controllers.tvguide.Filter', [], {}, {

    hasMenu: false,
    isVisible: false,
    genres: [],
    order: [],
    selected: 0,

    getGenres: function() {
        if (freesat.oipfElement.videoBroadcast) {
            var vbo = freesat.oipfElement.videoBroadcast,
                genres = vbo.getChannelConfig().genres,
                len = genres.length,
                i;

            if (len > 0) {
                freesat.behind.filter.genres.push('All Channels');

                for (i = 0; i < len; i++) {
                    freesat.behind.filter.genres.push(genres[i]);
                }
            }
            freesat.behind.filter.populateFilterMenu();

        } else {
            freesat.console.log('NO freesat.oipfElement.videoBroadcast');
        }
    },

    getChannels: function() {
        var vbo = freesat.oipfElement.videoBroadcast,
            genre = freesat.behind.filter.genres[freesat.behind.filter.selected],
            zone = freesat.getZone(),
            rows,
            starthour,
            hours,
            channels,
            i;

        freesat.console.log('GET FILTER CHANNELS');

        if (!freesat.behind.isGenreList) {
            freesat.behind.previousTopPositionIndex = freesat.behind.topPositionIndex;
            freesat.behind.previousRow = freesat.behind.row;
            freesat.behind.previousLCNList = freesat.behind.channelLCNlist;
        }

        freesat.behind.pageRows = 7;
        if (genre !== 'All Channels') {
            freesat.behind.updateChannelbar = true;
            freesat.channelData.genreList = vbo.getChannelConfig().opalCreateFilteredList(genre);
            freesat.behind.channelList = freesat.channelData.genreList;
            channels = freesat.behind.channelList.length;

            freesat.console.log('GENRE LIST LENGTH: ' + channels);

            if (channels > 0) {
                freesat.behind.isGenreList = true;
                // Reset row and index to 0
                freesat.behind.row = 0;
                freesat.behind.topPositionIndex = 0;
                freesat.behind.updateGenreTitle = true;
                freesat.behind.dataInterface.genreCollected = 0;

                freesat.dataStore.setLaterGenre();

                if (zone === 'now') {
                    // Reset freesat.dataStore.allData.nowNextGenre
                    freesat.dataStore.allData.nowNextGenre = [];
                    freesat.behind.dataInterface.nownext.nowNextFilteredData = [];

                    for (i = 0; i < channels; i++) {
                        freesat.dataStore.allData.nowNextGenre.push([]);
                        freesat.behind.dataInterface.nownext.nowNextFilteredData.push(0);
                    }
                    freesat.behind.dataInterface.getNowAndNextGenre(freesat.behind.onData.nowNextGenreLoaded, freesat.behind.topPositionIndex, 8);
                } else if (zone === 'later') {
                    rows = (channels < freesat.behind.PAGE_ITEMS) ? channels : freesat.behind.PAGE_ITEMS;
                    starthour = new Date(freesat.behind.gridStartTime * 1000).getHours();
                    hours = 3;

                    freesat.behind.laterCallback = freesat.behind.onLaterGenreCallback;
                    freesat.behind.dataInterface.getLaterData(rows, freesat.behind.topPositionIndex,freesat.behind.day,starthour,hours,freesat.behind.onData.laterLoaded);

                }
            } else {
                // Reset to all

                freesat.console.log('EMPTY CHANNEL LIST');

//                freesat.behind.isGenreList = false;
                freesat.behind.nowNextData = freesat.dataStore.allData.nowNextAll;
                freesat.behind.channelList = freesat.channelData.channelList;

                freesat.behind.filter.toggleMenu();

//                freesat.masterController.instanciateGenericError();
            }
        } else {
            freesat.behind.updateGenreTitle = true;
            freesat.behind.isGenreList = false;
            freesat.behind.nowNextData = freesat.dataStore.allData.nowNextAll;
            freesat.behind.channelList = freesat.channelData.channelList;

            freesat.behind.topPositionIndex = freesat.behind.previousTopPositionIndex;
            freesat.behind.row = freesat.behind.previousRow;
            freesat.behind.channelLCNlist = freesat.behind.previousLCNList;

            channels = freesat.channelData.channelListLength;



            if (zone === 'now') {
                freesat.console.log('POPULATE GENRE NOW NEXT: ' + freesat.behind.topPositionIndex + '::' + freesat.behind.row);
                freesat.behind.populateNowNext();
//                freesat.behind.dataInterface.getNowAndNextGenre(freesat.behind.onData.nowNextGenreLoaded, freesat.behind.topPositionIndex, 8);
            } else if (zone === 'later') {
                freesat.behind.column = 0;
                rows = (channels < freesat.behind.PAGE_ITEMS) ? channels : freesat.behind.PAGE_ITEMS;
                starthour = new Date(freesat.behind.gridStartTime * 1000).getHours();
                hours = 3;

                freesat.behind.laterCallback = freesat.behind.onLaterGenreCallback;
                freesat.behind.dataInterface.getLaterData(rows, freesat.behind.topPositionIndex,freesat.behind.day,starthour,hours,freesat.behind.onData.laterLoaded);
            }
        }
    },

    populateFilterMenu: function() {
        var len = freesat.behind.filter.genres.length,
            item, i, height, y = 0;

        if (len > 0) {

            freesat.behind.filterSelectionMenu = new accedo.ui.Container({
                id: '#filterSelectionMenu',
                css: 'filter-selection-menu'
            });

            for (i = 0; i < len; i++) {
                if (i === 0) {
                    height = 0;
                } else if (i === 1) {
                    height = 50;
                } else {
                    height = 40;
                }
                y = y + height;

                item = freesat.behind.createItem.channelFilter({
                    index: i,
                    text: freesat.behind.filter.genres[i],
                    yPos: y
                });
                freesat.behind.filterSelectionMenu.attach(item);
                freesat.behind.filter.order.push(i);

            }
            freesat.behind.get('channelFilterMenu').attach(freesat.behind.filterSelectionMenu);
            freesat.behind.filter.hasMenu = true;
            freesat.behind.filter.toggleMenu();
        }
    },

    toggleMenu: function() {
        var zone, selector;
        freesat.console.log('tvguide.filter.toggleMenu : freesat.behind.filter.hasMenu : '+ freesat.behind.filter.hasMenu + '   : freesat.behind.filter.isVisible : '+freesat.behind.filter.isVisible);
        if (freesat.behind.filter.hasMenu && freesat.behind.filter.isVisible) { // hide
            freesat.behind.tvguide.removeClass('show-channel-filter');
            zone = freesat.getZone();
            if (zone === 'now') {
                selector = freesat.behind.column + freesat.behind.page + '_' + (freesat.behind.row + 1);
            } else if (zone === 'later') {
                selector = 'event_' + freesat.behind.gridX + '_' + freesat.behind.gridY + '_' + freesat.behind.row + '_' + freesat.behind.column;
            }
            freesat.console.log('TOGGLE MENU SET FOCUS: ' + selector);
            try{
                freesat.behind.get(selector).setFocus();
            }catch(e){
                freesat.behind.row = 0;
                selector = 'event_' + freesat.behind.gridX + '_' + freesat.behind.gridY + '_' + freesat.behind.row + '_' + freesat.behind.column;
                freesat.behind.get(selector).setFocus();
            }
            freesat.behind.filter.isVisible = false;

        } else if (freesat.behind.filter.hasMenu && !freesat.behind.filter.isVisible) { // show
            freesat.behind.tvguide.addClass('show-channel-filter');
            freesat.behind.get('filter' + freesat.behind.filter.selected).setFocus();
            freesat.behind.filter.isVisible = true;
        } else {
            freesat.behind.filter.getGenres();
        }
    },

    orderMenu: function() {
        var arr = freesat.behind.filter.order,
            len = arr.length,
            height,
            i, y = 0;

        for (i = 0; i < len; i++) {
            var filterItem = freesat.behind.get('filter' + freesat.behind.filter.order[i]);

            if (i === 0) {
                height = 0;
            } else if (i === 1) {
                height = 50;
            } else {
                height = 40;
            }
            y = y + height;
            filterItem.root.setStyle({
                top: y + 'px'
            });
        }
        freesat.behind.filter.selected = freesat.behind.filter.order[0];
        freesat.behind.get('filter' + freesat.behind.filter.selected).setFocus();
    },

    navigate: function(dir) {

        if (dir === 'up') {
            freesat.behind.filter.order.unshift(freesat.behind.filter.order.pop());
        } else {
            freesat.behind.filter.order.push(freesat.behind.filter.order.shift());
        }
        freesat.behind.filter.orderMenu();
    },

    selectedItem: function(vKey) {

        if (vKey === accedo.VKey.KEY_OK) {
            freesat.behind.filter.getChannels();
        }
    }
});
/**
 * @namespace freesat.controllers.tvguide
 * @memberOf freesat.controllers
 */

/**
 * Creates a new ChannelUtils instance.
 * @name ChannelUtils
 * @memberof freesat.controllers.tvguide
 * @class A ChannelUtils class, bla functionality.
 * @author <a href="mailto:dean.clancy@accedo.tv">Dean Clancy</a>
 */
accedo.Class.create("freesat.controllers.tvguide.ChannelUtils", [], {},
    {
        highlightChannel: function(){
            var len, channelListLength, i;

            try {
                channelListLength = freesat.behind.channelList.length;

                if (channelListLength < 7) {
                    len = channelListLength;
                } else {
                    len = channelListLength - freesat.behind.topPositionIndex;

                    if (len > 7) {
                        len = 7;
                    }
                }

            } catch (e) {
                freesat.console.log('[ERROR] tvguide.channelUtils '+e);
            }

            for (i = 0; i < len; i++) {
                if (freesat.behind.row == i) {
                    try {
                        freesat.behind.get('chlogo' + (i+1) + 'p' + freesat.behind.page).highlight();
                        freesat.behind.get('ch' + (i + 1) + 'p' + freesat.behind.page).addClass('highlight');
                    } catch (e) {
                        console.log('CHANNEL HIGHLIGHT: ' + e);
                    }

                } else {
                    this.removeChannelHighlight(i);
                }
            }
        },
        removeChannelHighlight: function(index){

            try {
                freesat.behind.get('chlogo' + (index+1) + 'p' + freesat.behind.page).dehighlight();
                freesat.behind.get('ch' + (index + 1) + 'p' + freesat.behind.page).removeClass('highlight');
            } catch (e) {
                console.log('REMOVE CHANNEL HIGHLIGHT: ' + e);
            }
        },
        highlightGivenChannel: function(channelRow){
            var len, channelListLength;

            channelListLength = freesat.behind.channelList.length;

            if (channelListLength < 7) {
                len = channelListLength;
            } else {
                len = channelListLength - freesat.behind.topPositionIndex;

                if (len > 7) {
                    len = 7;
                }
            }

            for (var i = 0; i < len; i++){
                var chObj = freesat.behind.get('chlogo' + (i+1) + 'p' + freesat.behind.page);
                if(chObj){
                    if (channelRow == i) {
                        chObj.highlight();
                    }else{
                        chObj.dehighlight();
                    }
                }
            }
        },
        hasHighlightedChannelGotTsTV: function(){
            if (freesat.behind.dataInterface.earlier.isIpAvailable()) {
                try{
                    var channelLCN = freesat.behind.channelLCNlist[freesat.behind.row];
                    var channel = freesat.channelData.channelList.getChannel('ccid:'+channelLCN);
                    if(channel){
                        return freesat.channelData.getHasTSTVfromChannel(channel);
                    }
                }catch(e){
                    freesat.console.log('[ERROR] tvguide.channelUtils.hasHighlightedChannelGotTsTV()');
                    freesat.console.log('[ERROR] ' + e);
                }
                return false;
            }else{
                return true;
            }

        },
        channelCheck: function(){
            var tstv;

            if(freesat.getZone() == 'now'){
                if(freesat.behind.column == 'now'){
                    tstv = freesat.behind.channelUtils.checkTsTV();
                }else{
                    tstv = freesat.behind.channelUtils.checkTsTVDeact();
                }
                return tstv;
            }else if (freesat.getZone() == 'later'){
                if(freesat.behind.column === 0 && freesat.behind.day === 0){
                    tstv = freesat.behind.channelUtils.checkTsTV();
                    return tstv;
                }else{
                    freesat.behind.channelUtils.checkTsTVDeact();
                }
            }
        },
        checkTsTV: function(){
            freesat.behind.get('rightArrow').deactivateFocus();
            if(freesat.behind.channelUtils.hasHighlightedChannelGotTsTV()){
                freesat.behind.get('leftArrow').removeClass('hidden');
                freesat.behind.get('leftArrow').activateFocus();
                return true;
            }else{
                freesat.behind.get('leftArrow').addClass('hidden');
                freesat.behind.get('leftArrow').deactivateFocus();
                return false;
            }
        },
        checkTsTVDeact: function(){
            freesat.behind.get('leftArrow').deactivateFocus();
            if(freesat.behind.channelUtils.hasHighlightedChannelGotTsTV()){
                freesat.behind.get('leftArrow').removeClass('hidden');
                return true;
            }else{
                freesat.behind.get('leftArrow').addClass('hidden');
                return false;
            }
        },
        returnChannelIndex: function(channelLCN, sChannelList){
            var i,
                channelData = (sChannelList)?sChannelList:freesat.channelData.channelList,
                channelDataLength = (sChannelList)?sChannelList.length:freesat.channelData.channelListLength;

            for (i = 0;i<channelDataLength;i++){
                if (parseInt(channelData[i].ccid.split(':')[1], null)===channelLCN){
                    return i;
                }
            }
            return 0;
        },
        createChannelBar: function(display_length, indexAdjust){
            var channelBar, channelNumberColumnContainer, channelLogoColumnContainer,
                empty_channel, has_channelbar = false;

            empty_channel = {
                name: '',

                getlcn: function() {
                    return '';
                },
                getlogoURL : function(){
                    return 'missing-channel';
                },
                getchannelname: function(){
                    return '';
                }
            };

            if (document.getElementById('channelbarpage' + freesat.behind.page)) {
                channelBar = freesat.behind.get('channelbarpage' + freesat.behind.page).detach();
                has_channelbar = true;
//            channelBar.removeAll();
            } else {
                channelBar = freesat.behind.createItem.createContainer('channelbarpage' + freesat.behind.page, 'channelbarpage');
            }

            if (!has_channelbar) {
                channelNumberColumnContainer = freesat.behind.createItem.createContainer('channelNumberColumnContainer' + freesat.behind.page, 'channelNumberColumnContainer');
                channelLogoColumnContainer = freesat.behind.createItem.createContainer('channelLogoColumnContainer' + freesat.behind.page, 'channelLogoColumnContainer');
            }
            freesat.behind.channelLCNlist = [];
            freesat.behind.channelUtils.populateChannelLCNlist(indexAdjust, display_length);
            for (var i = 0; i < 7; i++) {
                var index = i + indexAdjust,
                    channel, channelLCN, channelNumber, channelLogo, number_text;

                if (i < display_length) {
                    try {
                        channel = freesat.channelData.channelList.getChannel('ccid:'+freesat.behind.channelLCNlist[i]);
                        channelLCN = freesat.behind.channelLCNlist[i];
                        freesat.console.log('LCN: ' + channelLCN + '; freesatServiceID: ' + channel.freesatServiceID);
                    } catch (e) {
                        channel = null;
                        freesat.console.log('Missing '+index+' LCN: ' + e);
                    }
                } else {
                    channelLCN = '';
                    channel = empty_channel;
                }
                if (!channel) {
                    channel = empty_channel;
                }
                if (!has_channelbar) {
                    // Create Channel number object
                    channelNumber = this.createChannelNumber({
                        container_id: '#channelNumbernContainer' + (i + 1),
                        container_css: 'channelNumbernContainer',
                        number_id: '#ch' + (i + 1) + 'p' + freesat.behind.page,
                        number_css: 'channelNumber',
                        number_text: channelLCN,
                        background_id: '#ch' + (i + 1) + 'bg',
                        background_css: 'channelNumberBack'
                    });
                    channelNumberColumnContainer.attach(channelNumber);

                    // Create Channel logo object
                    channelLogo = this.createChannelLogo({
                        container_id: '#channelLogoContainer' + (i + 1),
                        container_css: 'channelLogoContainer',
                        logo_id: '#chlogo' + (i + 1) + 'p' + freesat.behind.page,
                        logo_css: 'channelLogo',
                        name: channel.name,
                        channel: channel
                    });
                    channelLogoColumnContainer.attach(channelLogo);
                } else {
                    channelNumber = channelBar.get('ch' + (i + 1) + 'p' + freesat.behind.page);
                    number_text = (channelLCN) ? channelLCN : ''; // Check LCN isn't undefined
                    channelNumber.setText(number_text);

                    channelLogo = channelBar.get('chlogo' + (i + 1) + 'p' + freesat.behind.page);
                    channelLogo.setText(channel.name);
                    channelLogo._labelText = channel.name;
                    channelLogo._imageSrc = freesat.channelData.getChannelLogo(channel.freesatServiceID, false) || 'missing-logo'; // Need bad url to clear an existing image
                    channelLogo._focusedSrc = freesat.channelData.getChannelLogo(channel.freesatServiceID, true) || 'missing-logo';
                    channelLogo.setSrc(channelLogo._imageSrc);
                }
            }

            if (!has_channelbar) {
                channelBar.attach(channelNumberColumnContainer);
                channelBar.attach(channelLogoColumnContainer);
            }
            freesat.behind.channelbar.attach(channelBar, true);

        },
        populateChannelLCNlist: function(indexAdjust, display_length){
            freesat.console.log('[tvguide.channelUtils.populateChannelLCNlist] indexAdjust:'+indexAdjust + '   :display_length:'+display_length);
            if(freesat.getZone() === 'earlier') {

                if (!freesat.behind.earlierChannelList) {
                    freesat.channelData.assignCCIDtoTSTVchannels();
                    freesat.behind.earlierChannelList = freesat.channelData.returnCUTVchannellist();
                }
                freesat.behind.channelLCNlist = freesat.behind.earlierChannelList.slice(indexAdjust, (indexAdjust + display_length));

            }else{
                for (var i = 0; i < 7; i++) {
                    var index = i + indexAdjust,
                        channel, channelLCN;
                    freesat.console.log('[tvguide.channelUtils.populateChannelLCNlist] index:'+index);
                    if (i < display_length) {
                        try {
                            channel = freesat.behind.channelList[index];
                            channelLCN = parseInt(String(channel.ccid).split(':')[1], null);
                            freesat.behind.channelLCNlist.push(channelLCN);
                            freesat.console.log('[tvguide.channelUtils.populateChannelLCNlist] channelLCN:'+channelLCN);
                        } catch (e) {
                            freesat.console.log('Missing '+index+' LCN: ' + e);
                        }
                    }
                }
            }
        },
        createChannelNumber: function(opts) {
            var container,
                number,
                background;

            container = new accedo.ui.Container({
                id: opts.container_id,
                css: opts.container_css
            });

            number = new accedo.ui.widget.Label({
                id: opts.number_id,
                css: opts.number_css,
                text: opts.number_text
            });

            background = new accedo.ui.Container({
                id: opts.background_id,
                css: opts.background_css
            });
            container.attach(number);
            container.attach(background);

            return container;
        },
        createChannelLogo: function(opts) {
            var name = opts.name || '',
                channel = opts.channel,
                container,
                logo,
                url, url_hi;

            if (name.length > 9) {
                name = name.substring(0, 7) + "...";
            }

            container = new accedo.ui.Container({
                id: opts.container_id,
                css: opts.container_css
            });
            url = freesat.channelData.getChannelLogo(channel.freesatServiceID, false) || '';
            url_hi = freesat.channelData.getChannelLogo(channel.freesatServiceID, true) || '';

            freesat.console.log('HIGHLIGHT IMAGE: ' + url_hi);

            logo = new freesat.widget.ChannelLogo({
                id: opts.logo_id,
                css: opts.logo_css,
                text: name,
                src: url,
                focusedsrc: url_hi
            });
            container.attach(logo);

            return container;
        }
    }

);
/*global accedo: false */
/**
 * Creates a new CreateItem instance.
 * @name CreateItem
 * @memberof freesat.controllers.tvguide
 * @class A CreateItem class
 * @author <a href='mailto:rhys.jeffreys@accedo.tv'>Rhys Jeffreys</a>
 */
accedo.Class.create('freesat.controllers.tvguide.CreateItem', [], {}, {
    createContainer: function(id, css){
        return new accedo.ui.Container({
            id: '#' + id,
            css: css
        });
    },
    nowNextContainer: function(isNow){
        var isNowStr= (isNow)?'epgNowContainer':'epgNextContainer';
        return this.createContainer(isNowStr + freesat.behind.page, isNowStr);

    },
    nowNextItem: function(nData, nContainer, i, isNow){
        var isNowStr= (isNow)?'#now':'#next';
        var nItem = new freesat.widget.ProgrammeGridItemWithIcon({
            id : isNowStr + freesat.behind.page + '_' + (i + 1),
            css: 'programmeGridItem'
        });
        if(nData){
            nItem.onKey = freesat.behind.handleSelection.handleItemSelection;
            nItem.notifyFocused = freesat.behind.setHeader;

            // Add a isNow property
            nData.isNow = isNow;
        }
        try{
            nItem.setProgrammeData(nData);
            nContainer.attach(nItem);
        } catch (e) {
            freesat.console.log('tvguide.createItem.nowNextItem : '+e);
        }
    },

    isNowNext: function(isNow) {
        var css_class = "";

        if (isNow) { // col === 0 && freesat.behind.nowStartTime === freesat.behind.gridStartTime
            css_class = " later-now";
        } //else if (col === 1 && freesat.behind.nowStartTime === freesat.behind.gridStartTime) {
//            css_class = " later-next";
//        }
        return css_class;
    },
    laterItem: function(rowId, colId, rowItemId, cellWidth, optObject) {
        var item, programmeLabel;

        if (!window.laterItemPool[window.laterItemNum]) {
            freesat.console.log("laterItem new " + window.laterItemNum);
            item = new freesat.widget.LaterEpgLineItem({
                id: '#event_' + freesat.behind.gridX + '_' + freesat.behind.gridY + '_' + rowId + '_'  + rowItemId,
                css: 'epg_later_event' + this.isNowNext(optObject.isNow),
                cellWidth: cellWidth,
                opts: optObject.prog
            });
            window.laterItemPool.push(item);
        } else {
            freesat.console.log("laterItem reuse " + window.laterItemNum);
            item = window.laterItemPool[window.laterItemNum];
            item.setId('#event_' + freesat.behind.gridX + '_' + freesat.behind.gridY + '_' + rowId + '_'  + rowItemId);
            item.root.removeClass('later-now');
            item.timeZone = null;
            item.root.addClass('epg_later_event' + this.isNowNext(optObject.isNow));
            item._data = optObject.prog;
            if (optObject.prog.truncate) {
                programmeLabel = '..';
            } else {
                programmeLabel = optObject.prog.name;
            }
            item._programmeNameLabel.setId('#programmeNameLabel_'+item.getId());
            item._programmeNameLabel.setText(programmeLabel || '');
            item.setCellWidth(cellWidth);
        }
        item.setIconType(optObject.prog);
        window.laterItemNum++;

        if (optObject.isNow) {
            item.timeZone = 'now';
            item.setAsNowItem();
            item._data.isNow = true;
        }
        item.onKey = freesat.behind.handleSelection.handleLaterItemSelection;
        item.notifyFocused = freesat.behind.setHeader;

        if (cellWidth <= 32) {
            item.setProgrammeName('');
        }

        return item;
    },

    laterGrid: function(opts) {
        var obj = {
            startTime: opts.startTime,
            endTime: opts.startTime + opts.duration,
            xPos: opts.xPos,
            width: opts.width,
            row: opts.row_id,
            isLastItem: opts.isLastItem
        };

        if (opts.row_item_id === 0) {
            if (freesat.behind.gridStartTime === freesat.behind.nowStartTime) {
                obj.nextLeft = freesat.behind.handleLaterToEarlier;
            } else {
                obj.nextLeft = freesat.behind.handleLaterToEarlierLater;
            }

        } else {
            obj.nextLeft = 'event_' + freesat.behind.gridX + '_' + freesat.behind.gridY + '_' + opts.row_id + '_' + (opts.row_item_id - 1);
        }

        if (opts.xPos + opts.width >= 945 || opts.isLastItem) {
            obj.nextRight = freesat.behind.handleLaterToLater;
        } else {
            obj.nextRight = 'event_' + freesat.behind.gridX + '_' + freesat.behind.gridY + '_' + opts.row_id + '_' + (opts.row_item_id + 1);
        }

        return obj;
    },

    createLaterTimeStrip: function() {
        var timeLabelContainer,
            hourLabel,
            minLabel,
            time,
            n = 1,
            hour,
            mins,
            now = Math.round(new Date().getTime() / 1000.0),
            nowStartTime = (Math.floor(now/1800)) * 1800,
            gridStartTime,
            i;

        // Set the now grid start time
        freesat.behind.nowStartTime = nowStartTime;

        if (freesat.behind.gridStartTime < freesat.behind.nowStartTime) {
            freesat.behind.gridStartTime = freesat.behind.nowStartTime;
        }
        gridStartTime = new Date(freesat.behind.gridStartTime * 1000);

        hour = gridStartTime.getHours();
        mins = gridStartTime.getMinutes();
        time = gridStartTime.getTime();

        if (mins === 30) {
            mins = '30';
        } else {
            mins = '00';
        }

        if (!freesat.behind.hasLater) {
            freesat.behind.timestrip = new accedo.ui.Container({
                id: '#straplineTimeStrip', //  + freesat.behind.gridX
                css: 'laterTimeStrip'
            });
        } else {
            freesat.behind.timestrip = freesat.behind.get('straplineTimeStrip'); //  + freesat.behind.gridX
            // Remove existing time
            freesat.behind.timestrip.removeAll();
        }

        for (i = 0; i < 5; i++) { // 5 half hour blocks
            timeLabelContainer = new accedo.ui.Container({
                id: '#timelabelcontainer' + i,
                css: 'timelabelcontainer'
            });

            if (i === 0 && freesat.behind.nowStartTime === freesat.behind.gridStartTime) { // Now
                hourLabel = new accedo.ui.widget.Label({
                    id: 'hourLable_' + i,
                    css: 'later_hourlabel is-now',
                    text: 'now'
                });

                timeLabelContainer.attach(hourLabel);
            } else {

                if (!hour || hour === 0) {
                    hour = '0';
                }
                hourLabel = new accedo.ui.widget.Label({
                    id: 'hourLable_' + i,
                    css: 'later_hourlabel',
                    text: hour
                });

                minLabel = new accedo.ui.widget.Label({
                    id: 'minLable_' + i,
                    css: 'later_minlabel',
                    text: mins
                });

                timeLabelContainer.attach(hourLabel);
                timeLabelContainer.attach(minLabel);
            }

            // Set minutes for next loop
            if (mins === '30') {
                mins = '00';
                time += 60 * 60 * 1000;
                hour = new Date(time).getHours();
                if (!hour || hour === 0) {
                    hour = '0';
                }
                n++;
            } else {
                mins = '30';
            }
            freesat.behind.timestrip.attach(timeLabelContainer);

            if (!freesat.behind.hasLater) {
                freesat.behind.straplineTimeStripMask.attach(freesat.behind.timestrip);
            }
        }
    },

    channelFilter: function(opts) {
        var item = new accedo.ui.widget.Button({
            id: '#filter' + opts.index,
            css: 'filter-menu-item',
            text: opts.text
        });

        item.root.setStyle({
            top: opts.yPos + 'px'
        });

        item.onKey = freesat.behind.filter.selectedItem;
        return item;
    }
});
/**
 * Creates a new earlier instance.
 * @name Earlier
 * @memberof freesat.controllers.tvguide
 * @class A Earlier class, providing animation functionality.
 * @author <a href="mailto:rhys.jeffreys@accedo.tv">Rhys Jeffreys</a>
 */
accedo.Class.create("freesat.controllers.tvguide.Earlier", [], {},
    {
        isEarlierLoaded: false,
        minus24Hours: false,
        plus24Hours: false,
        fresh: false,
        pageOffset: 0,

        onTransitionEnd: function() {
            freesat.console.log('Earlier paging onTransitionEnd');
            freesat.behind.programmeContainer.root._dom.removeEventListener('webkitTransitionEnd', freesat.behind.onEarlierPageTransitionEnd);
            freesat.behind.programmeContainer.removeClass('transition-vertical').removeClass('off-top');

            if (freesat.behind.isPageDown) {
                // freesat.behind.get('programmeGridItem_' + freesat.behind.row).setFocus();
                freesat.behind.itemsContainers[~~(freesat.behind.topPositionIndex / 7)].getChildren()[freesat.behind.row].setFocus();
                freesat.behind.populateEarlier();
                freesat.behind.isPageDown = false;
            }
            freesat.isAnimating = false;
        },

        startPaging: function (dir) {
            
            // don't allow this if we're on an edge page
            if (freesat.isAnimating || dir === 'up' && !freesat.behind.canPageUp || dir === 'down' && !freesat.behind.canPageDown) {
                return;
            }

            var f;

            freesat.behind.hideFocus();
            if (dir === 'up') {
                f = freesat.behind.animationClass.pageUp;
            } else {
                f = freesat.behind.animationClass.pageDown;
            }

            if (freesat.behind.transitionTimer) {
                clearTimeout(freesat.behind.transitionTimer);
            }
            // Delay before next step
            freesat.behind.transitionTimer = setTimeout(function() {
                f();
            },100);
        },

        pageUp: function() {
            var newIndex;

            if (!freesat.isAnimating && freesat.behind.canPageUp) {
                freesat.isAnimating = true;
                newIndex = freesat.behind.topPositionIndex - 7;

                if (newIndex < 0) {
                    freesat.behind.topPositionIndex = 0;
                } else {
                    freesat.behind.topPositionIndex = newIndex;
                }
                freesat.behind.earlierPageOffset--;

                freesat.behind.animationClass.AM_ScreenView();

                freesat.behind.programmeContainer.addClass('off-top');
                freesat.behind.populateEarlier();
                setTimeout(function() {
                    // Remove the page down event listener
                    freesat.behind.programmeContainer.root._dom.addEventListener('webkitTransitionEnd', freesat.behind.animationClass.onTransitionEnd, false);
                    freesat.behind.programmeContainer.addClass('transition-vertical');
                    freesat.behind.programmeContainer.removeClass('off-top');
                },25);
            }
        },
        pageDown: function() { //moveNum
            var newIndex,
                rowIndex,
                freesatServiceID,
                day,
                programmesLength;

            freesat.console.log('[earlier] pageDown freesat.isAnimating:'+freesat.isAnimating+'    freesat.behind.canPageDown:'+freesat.behind.canPageDown);
            if (!freesat.isAnimating && freesat.behind.canPageDown) {
                freesat.isAnimating = true;
                freesat.behind.isPageDown = true; // Flag for onTransitionEnd

                newIndex = freesat.behind.topPositionIndex + 7;
                freesatServiceID = freesat.behind.earlierChannel.freesatServiceID;
                day = (freesat.behind.day<0)?-freesat.behind.day:freesat.behind.day;
                freesat.console.log('[earlier] pageDown freesatServiceID:'+freesatServiceID+ '   day:'+ day);
                programmesLength = freesat.dataStore.allData.earlierAll[freesatServiceID][day].programmes.length;

                if (!freesat.behind.tapPageDown) {

                    if ((freesat.behind.row+7) > freesat.behind.numOfRows) {
                        rowIndex = freesat.behind.numOfRows;
                        freesat.behind.row = rowIndex-7;
                    }
                }

                if (newIndex < programmesLength) {
                    freesat.behind.topPositionIndex = newIndex;
                } else {
                    freesat.behind.topPositionIndex = newIndex - programmesLength;
                }
                freesat.behind.earlierPageOffset++;

                freesat.behind.animationClass.AM_ScreenView();

                freesat.console.log('PAGING EARLIER = INDEX: ' + freesat.behind.topPositionIndex + ', PROGRAMMES: ' + programmesLength);

                freesat.behind.programmeContainer.root._dom.addEventListener('webkitTransitionEnd', freesat.behind.animationClass.onTransitionEnd, false);
                freesat.behind.programmeContainer.addClass('off-top transition-vertical');
            }
        },

        /*
         *
         * Animate Earlier to NowNext
         */
        firstStepAniEarlierToNowNext: function(){
            freesat.console.log('[earlier] firstStepAniEarlierToNowNext');
            freesat.isAnimating = true;

            if (!freesat.behind.hasEarlierError) {
                freesat.behind.get('chlogo' + (freesat.behind.earlierChannelRow +1) + 'p' + freesat.behind.page).defocused();
            }
            freesat.behind.earlierChannelFocused = false;

            var currentIndex = 0;
            for (var i = 0; i < freesat.behind.channelList.length; i++) {
                var channel = freesat.behind.channelList[i];
                if (channel.ccid === freesat.behind.earlierChannel.ccid) {
                    currentIndex = i;
                    break;
                }
            }

//            var currentIndex = freesat.channelData.returnChannelListIndexFromCCID(freesat.behind.earlierChannel.ccid);
            freesat.behind.row = currentIndex % 7;
            freesat.behind.topPositionIndex = (~~(currentIndex /7))*7;
            freesat.behind.channelTopIndex = freesat.behind.topPositionIndex;
            var display_length = (freesat.behind.channelList.length>6)?7:freesat.behind.channelList.length;
            freesat.setZone('now');
            freesat.behind.channelUtils.createChannelBar(display_length, freesat.behind.topPositionIndex);
            freesat.behind.channelUtils.highlightChannel();


            freesat.behind.hideFocus();
            freesat.behind.arrowContainer.addClass('fade-out');
            freesat.behind.footerButtons.addClass('fade-out');
            freesat.behind.resetHeader();
            freesat.header.get('header').removeClass('earlier-page').addClass('now-page');
            document.getElementById('arrowContainer').addEventListener('webkitAnimationEnd', freesat.behind.animationClass.middleStepAniEarlierToNowNext);
            if(freesat.datamode === 'dtt') {
                freesat.header.get('freesatLogo').setSrc("images/1280x720/logo/freeview_logo.png");
            } else {
                freesat.header.get('freesatLogo').setSrc("images/1280x720/logo/logo_freesat.png");
            }
            freesat.behind.earlierToNNInterval = setInterval(this.middleStepAniEarlierToNowNext, 800);
        },
        middleStepAniEarlierToNowNext: function(){
            clearInterval(freesat.behind.earlierToNNInterval);
            freesat.console.log('[earlier] middleStepAniEarlierToNowNext');
            document.getElementById('arrowContainer').removeEventListener('webkitAnimationEnd', freesat.behind.animationClass.middleStepAniEarlierToNowNext);
            freesat.behind.column = 'now';
            freesat.setZone('now');
//            freesat.behind.row = freesat.behind.lastRow;
//            freesat.behind.topPositionIndex = freesat.behind.channelTopIndex;

            if (freesat.behind.channelTopIndex !== freesat.behind.nowNextTopPositionIndex) {
                freesat.behind.nowNextGrid.addClass('hidden').removeClass('faded-out');
                freesat.behind.topPositionIndex = freesat.behind.channelTopIndex;
            }
            freesat.behind.rightArrow.setText('later');

            document.getElementById('earlierPage').addEventListener('webkitAnimationEnd', freesat.behind.animationClass.finalStepAniEarlierToNowNext);
            freesat.behind.nowNextPage.removeClass('channel-logo-right').addClass('channel-logo-left');
            freesat.behind.earlierPage.removeClass('earlier-epg-right').addClass('earlier-epg-left fade-out');
            freesat.behind.nowNextStrapline.removeClass('hidden').removeClass('fade-out').addClass('fade-in');
            if (freesat.behind.channelTopIndex === freesat.behind.nowNextTopPositionIndex) {
                freesat.behind.nowNextGrid.removeClass('hidden').removeClass('faded-out').removeClass('fade-out').addClass('fade-in');
            }

            freesat.behind.get('straplineNow').addClass('highlight');
        },
        finalStepAniEarlierToNowNext: function(){
            freesat.console.log('[earlier] finalStepAniEarlierToNowNext');
            freesat.behind.day = 0;

            document.getElementById('earlierPage').removeEventListener('webkitAnimationEnd', freesat.behind.animationClass.finalStepAniEarlierToNowNext);
            freesat.behind.earlierPage.addClass('hidden').removeClass('earlier-epg-left').removeClass('fade-out');
            freesat.behind.nowNextPage.removeClass('channel-logo-left');
            freesat.behind.leftArrow.setText('earlier'); // TODO: get text label from language file
            freesat.footer.show('green');

            if (freesat.behind.hasEarlierError) {
                freesat.behind.get('earlier-connection-message').addClass('hidden');
                freesat.behind.hasEarlierError = false;
            } else {
                freesat.behind.itemsContainer.removeAll();
            }
            // Needs to explicitly show these again since they might have been hidden by non connected page
            freesat.behind.get('footer').removeClass('hidden');
            freesat.behind.get('straplineEarlierContainer').removeClass('hidden');
            freesat.behind.get('peekChannelGradient').removeClass('hidden');
            freesat.behind.get('leftArrow').removeClass('hidden');
            freesat.behind.get('rightArrow').removeClass('hidden');
            freesat.behind.laterProgrammeItemMask.removeClass('hidden');

            freesat.behind.arrowContainer.removeClass('fade-out').addClass('fade-in');
            freesat.behind.footerButtons.removeClass('fade-out').addClass('fade-in');
            freesat.behind.channelFilter.removeClass('hidden').removeClass('fade-out').addClass('fade-in');

            freesat.behind.highlightLeftArrow();
            var channelNumberColumnContainer = freesat.behind.get('channelNumberColumnContainer' + freesat.behind.page);
            channelNumberColumnContainer.removeClass('hidden').removeClass('fade-out').addClass('fade-in');

            if(freesat.behind.channelTopIndex === freesat.behind.nowNextTopPositionIndex ) {

                if (!freesat.behind.firstBack){
//            freesat.front.setRowAndTopIndex(freesat.front.allData.nowNextAll, freesat.front.highlightedChannelId);
                    freesat.behind.get('now' + freesat.behind.page + '_' + (freesat.behind.row + 1)).setFocus();
                }else{
//                freesat.behind.firstBack = false;
                    freesat.setZone('now');
                    freesat.behind.dataInterface.getNowAndNextAll(freesat.behind.onData.nownextLoaded, freesat.behind.topPositionIndex, 8);
                    freesat.behind.dataInterface.updateFunc = freesat.behind.updateNowNext;
                    freesat.behind.nowNextGrid.removeAll();
                    freesat.behind.nowNextGrid.removeClass('hidden');
                }
            }

            freesat.behind.animationClass = new freesat.controllers.tvguide.Nownext();
            freesat.behind.animationClass.AM_ScreenView();

            freesat.isAnimating = false;
//            timeTrack('finalStepAniEarlierToNowNext');
            if (freesat.behind.launchedInEarlier) {
                freesat.behind.launchedInEarlier = false;
                freesat.behind.nowNextGrid.removeClass('hidden');
                freesat.behind.nowNextRestart();
            }

            if (freesat.behind.channelTopIndex !== freesat.behind.nowNextTopPositionIndex && !freesat.behind.firstBack) {
//                freesat.behind.dataInterface.abortiveSearch = false;
                freesat.behind.nowNextRedraw();
            } else {
                freesat.behind.firstBack = false;
            }
//            freesat.behind.row = freesat.behind.lastRow;
            freesat.behind.earlierPageOffset = 1;
            freesat.oipfElement.setKeysetWithoutNumbers();
        },

        removeFadeInClass: function() {

        },

        firstStepAniEarlierMinus24Hours: function() {
            freesat.behind.hideFocus();
            freesat.behind.animationClass.minus24Hours = true;
            freesat.behind.animationClass.isEarlierLoaded = false;
            document.getElementById('earlierPage').addEventListener('webkitAnimationEnd', freesat.behind.animationClass.secondStepAniEarlierMinus24Hours);
            freesat.behind.resetHeader();
            freesat.behind.earlierPageOffset = 1;
            freesat.behind.earlierPage.removeClass('earlier-epg-right').addClass('fade-out');
            freesat.isAnimating = true;
            freesat.behind.arrowContainer.addClass('fade-out');
        },

        secondStepAniEarlierMinus24Hours: function() {
            document.getElementById('earlierPage').removeEventListener('webkitAnimationEnd', freesat.behind.animationClass.secondStepAniEarlierMinus24Hours);

            if (freesat.behind.dataInterface) {
                freesat.console.log('getEarlierData LCN: ' + freesat.behind.channelLCNlist[freesat.behind.earlierChannelRow]);
                freesat.behind.dataInterface.getEarlierData(freesat.channelData.channelList.getChannel('ccid:'+String(freesat.behind.channelLCNlist[freesat.behind.earlierChannelRow])),freesat.behind.day,6,18,freesat.behind.onData.earlierLoaded);
            }
        },

        thirdStepAniEarlierMinus24Hours: function() {

            if (freesat.behind.animationClass.isEarlierLoaded) {
                document.getElementById('earlierPage').addEventListener('webkitAnimationEnd', freesat.behind.animationClass.finalStepAniEarlierMinus24Hours);
                freesat.behind.earlierPage.addClass('hidden').removeClass('fade-out').removeClass('hidden').addClass('earlier-epg-right');
            }
        },

        finalStepAniEarlierMinus24Hours: function() {
            document.getElementById('earlierPage').removeEventListener('webkitAnimationEnd', freesat.behind.animationClass.finalStepAniEarlierMinus24Hours);
            freesat.behind.earlierPage.removeClass('earlier-epg-right');
            if (-freesat.behind.day >= (freesat.dataStore.allData.earlierAll[freesat.behind.freesatServiceID].length - 1)) {
                freesat.behind.leftArrow.addClass('hidden');
                freesat.behind.leftArrowHidden = true;
                freesat.footer.hide('yellow');
            } else if (!freesat.behind.earlierChannelFocused) {
                freesat.behind.highlightLeftArrow();
            }

            freesat.behind.arrowContainer.removeClass('fade-out').addClass('fade-in');
            freesat.behind.column = 'earlier';
            freesat.isAnimating = false;
            freesat.behind.animationClass.minus24Hours = false;
            freesat.behind.earlierPageOffset = 1;

            freesat.behind.animationClass.AM_ScreenView();
        },

        firstStepAniEarlierPlus24Hours: function() {
            freesat.behind.hideFocus();
            freesat.behind.animationClass.plus24Hours = true;
            freesat.behind.animationClass.isEarlierLoaded = false;
            document.getElementById('earlierPage').addEventListener('webkitAnimationEnd', freesat.behind.animationClass.secondStepAniEarlierPlus24Hours);
            freesat.behind.resetHeader();
            freesat.behind.earlierPage.removeClass('earlier-epg-right').addClass('fade-out');
            freesat.isAnimating = true;
            freesat.behind.arrowContainer.addClass('fade-out');
        },

        secondStepAniEarlierPlus24Hours: function() {
            document.getElementById('earlierPage').removeEventListener('webkitAnimationEnd', freesat.behind.animationClass.secondStepAniEarlierPlus24Hours);

            if (freesat.behind.dataInterface) {
                freesat.behind.dataInterface.getEarlierData(freesat.channelData.channelList.getChannel('ccid:'+String(freesat.behind.channelLCNlist[freesat.behind.earlierChannelRow])),freesat.behind.day,6,18,freesat.behind.onData.earlierLoaded);
            }
        },

        thirdStepAniEarlierPlus24Hours: function() {
            document.getElementById('earlierPage').addEventListener('webkitAnimationEnd', freesat.behind.animationClass.finalStepAniEarlierPlus24Hours);
            freesat.behind.earlierPage.addClass('hidden').removeClass('fade-out').removeClass('hidden').addClass('earlier-epg-on-right');
        },

        finalStepAniEarlierPlus24Hours: function() {
            document.getElementById('earlierPage').removeEventListener('webkitAnimationEnd', freesat.behind.animationClass.finalStepAniEarlierPlus24Hours);
            freesat.behind.earlierPage.removeClass('earlier-epg-on-right');

            if (-freesat.behind.day === (freesat.dataStore.allData.earlierAll[freesat.behind.freesatServiceID].length - 2)) {
                freesat.footer.show('yellow');
            }
            freesat.behind.arrowContainer.removeClass('fade-out').addClass('fade-in');

            freesat.behind.column = 'earlier';
            freesat.isAnimating = false;
            freesat.behind.animationClass.plus24Hours = false;
            freesat.behind.earlierPageOffset = 1;

            freesat.behind.animationClass.AM_ScreenView();
        },

        updateNowNext: function() {
            freesat.behind.populateNowNext();
            freesat.behind.gridIsSetup = true;
            freesat.behind.setItemFocus();
        },

        AM_ScreenView: function(){
            var urlParam = this.getAM_urlParam();
            freesat.am.screenView(urlParam);
        },

        getAM_urlParam: function(){
            var pageOffset = freesat.behind.earlierPageOffset,
                dayOffset = freesat.behind.day;

            return '/tvGuide/earlier/day' + Math.abs(dayOffset) + '/page' + pageOffset;
        }
    }
);
/**
 * Creates a new later instance.
 * @name Later
 * @memberof freesat.controllers.tvguide
 * @class A later  class, providing animation functionality
 * @author <a href="mailto:rhys.jeffreys@accedo.tv">Rhys Jeffreys</a>
 */
accedo.Class.create("freesat.controllers.tvguide.Later", [], {},
    {
        isLaterLoaded: false,
        gridX: 0,
        blueVisible: true,
        forwardDays: 8,

        onTransitionEnd: function() {
            freesat.console.log('LATER PAGING - onTransitionEnd');
            document.getElementById('laterProgrammeItemContainer' + freesat.behind.gridX).removeEventListener('webkitTransitionEnd', freesat.behind.animationClass.onTransitionEnd);
            freesat.behind.get('laterGrid_' + freesat.behind.gridX + '_' + (freesat.behind.gridY - 1)).detach();
            freesat.behind.laterProgrammeItemContainer.removeClass('transition-vertical').removeClass('off-top');
            freesat.behind.epgGuideContainer.removeClass('transition-vertical').removeClass('off-top');

            try {
                freesat.behind.get('epgPage' + (freesat.behind.page - 1)).detach();
                freesat.behind.get('channelbarpage' + (freesat.behind.page - 1)).detach();
            } catch (e) {
                freesat.console.log('ERROR Removing EPG page' + (freesat.behind.page - 1) + ': ' + e);
            }

            if (freesat.behind.isPageDown) {
                freesat.behind.isPageDown = false;
            }

            if (freesat.behind.isPageUp) {
                freesat.behind.isPageUp = false;
            }
            freesat.behind.isSetLaterFocus = false;
            freesat.behind.laterFunc.setLaterFocus('paging');
            freesat.isAnimating = false;
            freesat.behind.laterPaging = false;
        },
        goToChannel: function (channelNumber) {
            if (freesat.behind.hasEarlierError) {
                console.log('Ignoring channel change because dialogue is showing');
                return;
            }

            var prevTopIndex = freesat.behind.topPositionIndex;
            freesat.behind.setTopPositionIndex();
            if (prevTopIndex > freesat.behind.topPositionIndex) {
                freesat.behind.animationClass.startPaging('up', true);
            } else if (prevTopIndex < freesat.behind.topPositionIndex) {
                freesat.behind.animationClass.startPaging('down', true);
            } else {
                freesat.behind.laterFunc.setLaterFocus('jump');
            }
        },

        startPaging: function (dir, alreadyUpdatedIndex) {
            var f,
                row = freesat.behind.row;

            freesat.behind.hideFocus();
            freesat.behind.updateChannelbar = true;
            freesat.behind.channelUtils.checkTsTVDeact();

            if (dir === 'up') {
                f = freesat.behind.animationClass.pageUp;
            } else {
                f = freesat.behind.animationClass.pageDown;
            }

            if (freesat.behind.tapPageUp) {
                row = 0;
            } else if (freesat.behind.tapPageDown) {
                row = freesat.behind.pageRows - 1;
            }

            freesat.behind.channelUtils.removeChannelHighlight(row);

            if (freesat.behind.transitionTimer) {
                clearTimeout(freesat.behind.transitionTimer);
            }
            // Delay before next step
            freesat.behind.transitionTimer = setTimeout(function() {
                freesat.masterController.showLoading();
                f(alreadyUpdatedIndex);
            },100);
        },

        pageUp: function(alreadyUpdatedIndex) {
            freesat.behind.isPageUp = true;

            var PAGE_ITEMS = freesat.behind.PAGE_ITEMS,
                channelList = freesat.behind.channelList,
                channelLength = channelList.length,
                starthour = new Date(freesat.behind.gridStartTime * 1000).getHours(),
                newIndex,
                hours = 3,
                rows = PAGE_ITEMS,
                last,
                row,
                i;

            freesat.behind.gridY += 1;

            freesat.isAnimating = true;
            freesat.behind.laterPaging = true;

            if (freesat.behind.tapPageUp) {
                row = 0;
                freesat.behind.tapPageUp = false;
            } else {
                row = freesat.behind.row;
            }
            freesat.behind.laterCurrent = freesat.behind.laterGridModel[row][freesat.behind.column];
            
            if (!alreadyUpdatedIndex) {
                newIndex = freesat.behind.topPositionIndex - PAGE_ITEMS;
                if (newIndex < 0) {
                    last = Math.floor(channelLength / PAGE_ITEMS);

                    freesat.behind.topPositionIndex = (last * PAGE_ITEMS);

                    if (freesat.behind.topPositionIndex === channelLength) {
                        freesat.behind.topPositionIndex = channelLength - PAGE_ITEMS;
                    }
                    rows = channelLength - freesat.behind.topPositionIndex;
                } else {
                    freesat.behind.topPositionIndex = newIndex;
                }
                freesat.behind.nowNextPageOffset--;
                freesat.behind.animationClass.AM_ScreenView();

                freesat.console.log('TOP POSITION INDEX: ' + freesat.behind.topPositionIndex);
            }
//            freesat.behind.epgGuideContainer.addClass('off-top');

            // dehighlight channel number and logo
//            freesat.behind.get('chlogo' + (freesat.behind.row +1) + 'p' + freesat.behind.page).dehighlight();
//            freesat.behind.get('ch' + (freesat.behind.row + 1) + 'p' + freesat.behind.page).removeClass('highlight');
//            freesat.behind.pageRows = rows;
//            freesat.behind.page += 1;
//            freesat.behind.populateNowNext();

            // Get new channel list
            freesat.behind.channelLCNlist = [];

            for (i = 0; i < rows; i++) {
                var index = i + freesat.behind.topPositionIndex,
                    channelLCN;

                channelLCN = parseInt(channelList[index].ccid.split(':')[1], null);
                freesat.behind.channelLCNlist.push(channelLCN);
            }

            freesat.behind.pageRows = rows;

            freesat.behind.laterProgrammeItemContainer.addClass('hide');
            // Remove existing later grid
//            freesat.behind.get('laterGrid_' + freesat.behind.gridX + '_' + (freesat.behind.gridY - 1)).detach();

            freesat.behind.laterCallback = freesat.behind.onLaterPagingCallback;
            freesat.behind.dataInterface.getLaterData(rows, freesat.behind.topPositionIndex,freesat.behind.day,starthour,hours,freesat.behind.onData.laterLoaded);
        },

        pageDown: function(alreadyUpdatedIndex) {

            if (!freesat.isAnimating) {
                var PAGE_ITEMS = freesat.behind.PAGE_ITEMS,
                    channelList = freesat.behind.channelList,
                    channelLength = channelList.length,
                    starthour = new Date(freesat.behind.gridStartTime * 1000).getHours(),
                    hours = 3,
                    rows = PAGE_ITEMS,
                    newIndex,
                    last,
                    lastPageTopIndex,
                    row,
                    i;

                freesat.behind.isPageDown = true; // Flag for onTransitionEnd
                freesat.behind.gridY += 1;
                freesat.isAnimating = true;
                freesat.behind.laterPaging = true;

                if (freesat.behind.tapPageDown) {
                    if (freesat.behind.pageRows < 7) {
                        row = freesat.behind.pageRows - 1;
                    } else {
                        row = 6;
                    }
                    freesat.behind.tapPageDown = false;
                } else {
                    row = freesat.behind.row;
                }
                freesat.behind.laterCurrent = freesat.behind.laterGridModel[row][freesat.behind.column];

                if (!alreadyUpdatedIndex) {
                    newIndex = freesat.behind.topPositionIndex + PAGE_ITEMS;
                    if (newIndex < channelLength) {
                        freesat.behind.topPositionIndex = newIndex;
                        last = Math.floor(channelLength / PAGE_ITEMS);
                        lastPageTopIndex = (last * PAGE_ITEMS);

                        if (newIndex === lastPageTopIndex) {
                            rows = channelLength - lastPageTopIndex;
                        }
                    } else {
                        freesat.behind.pageRows = 7;
                        freesat.behind.topPositionIndex = 0;
                    }
                    freesat.behind.nowNextPageOffset++;
                    freesat.behind.animationClass.AM_ScreenView();

                    freesat.console.log('TOP POSITION INDEX: ' + freesat.behind.topPositionIndex);
                }

                // Get new channel list
                freesat.behind.channelLCNlist = [];

                for (i = 0; i < rows; i++) {
                    var index = i + freesat.behind.topPositionIndex,
                        channelLCN;

                    channelLCN = parseInt(channelList[index].ccid.split(':')[1], null);
                    freesat.behind.channelLCNlist.push(channelLCN);
                }

                freesat.behind.pageRows = rows;


//                freesat.behind.page += 1;
//                freesat.behind.populateNowNext();

                freesat.behind.laterProgrammeItemContainer.addClass('hide');

                // Remove existing later grid
//                freesat.behind.get('laterGrid_' + freesat.behind.gridX + '_' + (freesat.behind.gridY - 1)).detach();


                freesat.behind.laterCallback = freesat.behind.onLaterPagingCallback;
                freesat.behind.dataInterface.getLaterData(rows, freesat.behind.topPositionIndex,freesat.behind.day,starthour,hours,freesat.behind.onData.laterLoaded);

            }
        },

        animatePageDown: function() {
            freesat.console.log('animatePageDown');
            document.getElementById('laterProgrammeItemContainer' + freesat.behind.gridX).addEventListener('webkitTransitionEnd', freesat.behind.animationClass.onTransitionEnd);
//            freesat.behind.isSetLaterFocus = false;
//            freesat.behind.setLaterFocus('paging');
            freesat.behind.epgGuideContainer.addClass('off-top transition-vertical');
            freesat.behind.laterProgrammeItemContainer.addClass('off-top transition-vertical');
        },

        animatePageUp: function() {
            freesat.console.log('animatePageUp');
            freesat.behind.laterProgrammeItemContainer.addClass('off-top');
//            freesat.behind.isSetLaterFocus = false;
//            freesat.behind.setLaterFocus('paging');
            setTimeout(function() {
                document.getElementById('laterProgrammeItemContainer' + freesat.behind.gridX).addEventListener('webkitTransitionEnd', freesat.behind.animationClass.onTransitionEnd);
                freesat.behind.epgGuideContainer.addClass('transition-vertical').removeClass('off-top');
                freesat.behind.laterProgrammeItemContainer.addClass('transition-vertical').removeClass('off-top');
            },25);
        },

        firstStepAniLaterToEarlier: function(){

            if (freesat.behind.channelUtils.channelCheck()) {
                freesat.isAnimating = true;
                freesat.behind.arrowContainer.addClass('fade-out');
                freesat.behind.footerButtons.addClass('fade-out');
                freesat.behind.channelFilter.removeClass('fade-in').addClass('fade-out');
                freesat.behind.resetHeader();
                freesat.header.get('header').removeClass('later-page').addClass('earlier-page');
                document.getElementById('arrowContainer').addEventListener('webkitAnimationEnd', freesat.behind.animationClass.middleStepAniLaterToEarlier);
                freesat.behind.get('channelNumberColumnContainer' + freesat.behind.page).addClass('fade-out');

                if (freesat.behind.dataInterface) {
                    freesat.behind.dataInterface.getEarlierData(freesat.channelData.channelList.getChannel('ccid:'+String(freesat.behind.channelLCNlist[freesat.behind.row])),freesat.behind.day,6,18,freesat.behind.onData.earlierLoaded);
                }
                freesat.behind.highlightedChannelId = freesat.behind.channelLCNlist[freesat.behind.row];
                freesat.behind.lastRow = freesat.behind.row;
                freesat.behind.channelTopIndex = freesat.behind.topPositionIndex;
            }
        },

        startLaterToEarlier: function() {
            freesat.console.log('startLaterToEarlier');

            if (freesat.behind.channelUtils.channelCheck()) {
                freesat.isAnimating = true;
                freesat.behind.hideFocus();

                if (freesat.behind.transitionTimer) {
                    clearTimeout(freesat.behind.transitionTimer);
                }
                // Delay before next step
                freesat.behind.transitionTimer = setTimeout(function() {
                    freesat.behind.animationClass.hideLaterToEarlierGrid();
                },100);
            }
        },

        hideLaterToEarlierGrid: function() {

            freesat.console.log('hideLaterGrid');
            // Hide Now & Next
            freesat.behind.resetHeader();
            freesat.behind.laterTopPositionIndex = freesat.behind.topPositionIndex;
            freesat.behind.animationClass.callEarlier();
            freesat.behind.arrowContainer.addClass('hidden');
            freesat.behind.nowNextStrapline.addClass('hidden');
            freesat.behind.laterProgrammeItemMask.addClass('hidden');
            freesat.behind.lastGridStartTime = freesat.behind.gridStartTime;

            freesat.header.get('header').removeClass('later-page').addClass('earlier-page');
            freesat.behind.nowNextGrid.addClass('hidden').removeClass('fade-in');

            if (freesat.behind.transitionTimer) {
                clearTimeout(freesat.behind.transitionTimer);
            }

            // Delay before next step
            freesat.behind.transitionTimer = setTimeout(function() {
                freesat.behind.animationClass.middleStepAniLaterToEarlier();
            },100);
        },

        callEarlier: function() {
            var rowVal = (freesat.behind.earlierChannelFocused)? freesat.behind.earlierChannelRow : freesat.behind.row;

            freesat.behind.arrowContainer.addClass('fade-out');
            freesat.behind.footerButtons.addClass('fade-out');
            freesat.behind.channelFilter.addClass('fade-out');

            freesat.behind.get('channelNumberColumnContainer' + freesat.behind.page).addClass('fade-out');

            var stashRow = rowVal;
            if (freesat.behind.dataInterface) {
                freesat.behind.dataInterface.getEarlierData(freesat.channelData.channelList.getChannel('ccid:'+String(freesat.behind.channelLCNlist[freesat.behind.row])),freesat.behind.day,6,18,freesat.behind.onData.earlierLoaded);
            }

            if(freesat.behind.earlierChannelFocused){
                freesat.behind.earlierChannelRow  = stashRow;
            }else{
                freesat.behind.row  = stashRow;
            }
            freesat.behind.highlightedChannelId = freesat.behind.channelLCNlist[rowVal];
            freesat.behind.lastRow = rowVal;
            freesat.behind.channelTopIndex = freesat.behind.topPositionIndex;
            freesat.header.get('freesatLogo').setSrc("images/1280x720/logo/freetime-125x24.png");
        },

        middleStepAniLaterToEarlier: function() {
            freesat.console.log('middleStepAniLaterToEarlier');
//            document.getElementById('arrowContainer').removeEventListener('webkitAnimationEnd', freesat.behind.animationClass.middleStepAniLaterToEarlier);
            freesat.behind.column = 'earlier';
            freesat.setZone('earlier');
            freesat.behind.rightArrow.removeClass('fade-out').setText('now');
            document.getElementById('earlierPage').addEventListener('webkitAnimationEnd', freesat.behind.animationClass.finalStepAniLaterToEarlier);
            freesat.behind.nowNextPage.addClass('channel-logo-right');
            freesat.behind.laterPage.addClass('channel-logo-right');
            freesat.behind.earlierPage.removeClass('hidden').addClass('earlier-epg-right');
            freesat.behind.nowNextStrapline.addClass('fade-out');
            freesat.behind.nowNextGrid.addClass('faded-out');
        },

        finalStepAniLaterToEarlier: function() {
            freesat.console.log('finalStepAniLaterToEarlier');
            freesat.behind.channelUtils.removeChannelHighlight(freesat.behind.row);
            document.getElementById('earlierPage').removeEventListener('webkitAnimationEnd', freesat.behind.animationClass.finalStepAniLaterToEarlier);
            freesat.behind.tvguide.removeClass('hide-next-timeline');
            freesat.behind.nowNextGrid.removeClass('hidden');
            freesat.behind.laterPage.addClass('hidden').removeClass('channel-logo-right');
            freesat.behind.arrowContainer.removeClass('hidden').removeClass('fade-out').addClass('fade-in');
            freesat.footer.hide('green');
            freesat.behind.footerButtons.removeClass('fade-out').addClass('fade-in');
            freesat.behind.get('channelNumberColumnContainer' + freesat.behind.page).addClass('hidden');
            freesat.behind.animationClass = new freesat.controllers.tvguide.Earlier();
            freesat.behind.createEarlierChannelList();
            freesat.isAnimating = false;
        },

        firstStepAniLaterToNowNext: function(){
            var channel_number_column, channel_logo_column, lcn, channel_number, channel, channel_logo, i;

            freesat.isAnimating = true;
//            document.getElementById('straplineTimeStrip' + freesat.behind.gridX).addEventListener('webkitTransitionEnd', freesat.behind.animationClass.middleStepAniLaterToNowNext, false);
//            freesat.behind.tvguide.addClass('load-later');
//            freesat.behind.arrowContainer.addClass('fade-out');

            freesat.behind.resetHeader();
            freesat.behind.laterFunc.setLaterStartTime(null); // Reset Later startTime
            freesat.header.get('header').removeClass('later-page').addClass('now-page');
            freesat.behind.tvguide.removeClass('hide-next-timeline');

            freesat.behind.column = 'next';
            freesat.setZone('now');
            freesat.behind.nowNextGrid.removeClass('hidden');
            freesat.behind.laterPage.addClass('hidden');

            if (freesat.behind.gridY > 0 || freesat.behind.updateChannelbar) { // Check if channelbar needs updating
                freesat.behind.row = freesat.behind.nowNextRow;
                freesat.behind.pageRows = freesat.behind.nowNextRows;
                freesat.behind.topPositionIndex = freesat.behind.nowNextTopPositionIndex;
                freesat.behind.channelLCNlist = freesat.behind.nowNextLCNList;

                freesat.behind.channelUtils.createChannelBar(freesat.behind.pageRows, freesat.behind.topPositionIndex);
                freesat.behind.channelUtils.highlightChannel();
                freesat.behind.channelUtils.channelCheck();
                freesat.behind.updateChannelbar = false;
            }
            freesat.behind.get(freesat.behind.column + freesat.behind.page + '_' + (freesat.behind.row + 1)).setFocus();
            freesat.behind.rightArrow.removeClass('hidden').setText('later');
            freesat.behind.arrowContainer.removeClass('hidden');
            freesat.behind.get('laterProgrammeItemContainer').removeAll(); //  + freesat.behind.gridX
            freesat.behind.get('straplineTimeStrip').removeAll(); //  + freesat.behind.gridX
            freesat.behind.nowNextStrapline.removeClass('hidden');
            freesat.behind.straplineNext.addClass('highlight').removeClass('hidden');
            freesat.behind.highlightRightArrow();
            freesat.behind.animationClass = new freesat.controllers.tvguide.Nownext();
            freesat.behind.animationClass.AM_ScreenView();
            freesat.isAnimating = false;
        },

        middleStepAniLaterToNowNext: function() {
            document.getElementById('straplineTimeStrip' + freesat.behind.gridX).removeEventListener('webkitTransitionEnd', freesat.behind.animationClass.middleStepAniLaterToNowNext);

            document.getElementById('arrowContainer').addEventListener('webkitAnimationEnd', freesat.behind.animationClass.finalStepAniLaterToNowNext);

            freesat.behind.resetHeader();
            freesat.header.get('header').removeClass('later-page').addClass('now-page');
            freesat.behind.epgGuideContainer.removeClass('fade-now-out');
            freesat.behind.tvguide.removeClass('hide-next-timeline');

            freesat.behind.column = 'next';
            freesat.setZone('now');
            freesat.behind.nowNextGrid.removeClass('hidden');
            freesat.behind.laterPage.addClass('hidden');
            freesat.behind.get(freesat.behind.column + freesat.behind.page + '_' + (freesat.behind.row + 1)).setFocus();
            freesat.behind.rightArrow.removeClass('fade-out').setText('later');
            freesat.behind.arrowContainer.removeClass('fade-out').addClass('fade-in');
        },

        finalStepAniLaterToNowNext: function() {
            document.getElementById('arrowContainer').removeEventListener('webkitAnimationEnd', freesat.behind.animationClass.finalStepAniLaterToNowNext);
            // Remove later contents
            freesat.behind.get('laterProgrammeItemContainer' + freesat.behind.gridX).removeAll();
            freesat.behind.get('straplineTimeStrip' + freesat.behind.gridX).removeAll();
            freesat.behind.straplineNext.addClass('highlight');
            freesat.behind.tvguide.removeClass('load-later');
            freesat.behind.highlightRightArrow();
            freesat.behind.animationClass = new freesat.controllers.tvguide.Nownext();
            freesat.isAnimating = false;
        },

        firstStepAniLaterToLater: function() {
            var starthour,
                hours = 3,
                dayInSeconds = Math.round(24 * 60 * 60),
                today = new Date(freesat.behind.nowStartTime * 1000),
                dayStartTime = (new Date(today.getFullYear(), today.getMonth(), today.getDate()).getTime() / 1000),
                timeDifference;

            freesat.isAnimating = true;
            freesat.behind.animationClass.isLaterLoaded = false;
            freesat.behind.gridStartTime += (2 * 60 * 60);
            timeDifference = freesat.behind.gridStartTime - dayStartTime;
            starthour = new Date(freesat.behind.gridStartTime * 1000).getHours();
            freesat.behind.day = Math.floor(timeDifference / dayInSeconds);

            freesat.console.log('firstStepAniLaterToLater: ' + new Date(freesat.behind.gridStartTime * 1000));

            if (freesat.behind.day < 7) {
                freesat.behind.animationClass.gridX = freesat.behind.gridX;
//                document.getElementById('laterProgrammeItemContainer' + this.gridX).addEventListener('webkitAnimationEnd', freesat.behind.animationClass.middleStepAniPlus24Hours);
//
                // Hide don't fade out
                freesat.behind.get('laterProgrammeItemContainer' + freesat.behind.gridX).addClass('hidden');
                freesat.behind.get('straplineTimeStrip' + freesat.behind.gridX).addClass('hidden');
                freesat.behind.nowNextStrapline.addClass('hidden');

                // Data calls
                freesat.behind.laterCallback = freesat.behind.onPlus24DataFirstCallback;
                freesat.behind.dataInterface.getLaterData(freesat.behind.pageRows, freesat.behind.topPositionIndex,freesat.behind.day,starthour,hours,freesat.behind.onData.laterLoaded);
            } else {
                // Reset values
                freesat.behind.day -= 1;
                freesat.behind.gridStartTime -= (2 * 60 * 60);
                freesat.console.log('CANNOT GO ANY LATER');
                freesat.isAnimating = false;
            }
        },

        firstStepAniLaterToEarlierLater: function() {
            var starthour,
                hours = 3;

            if (freesat.behind.gridStartTime > freesat.behind.nowStartTime) {
                freesat.isAnimating = true;
                freesat.behind.animationClass.isLaterLoaded = false;
                freesat.behind.gridStartTime -= (2 * 60 * 60);

                freesat.console.log('firstStepAniLaterToEarlierLater: ' + new Date(freesat.behind.gridStartTime * 1000));

                if (freesat.behind.gridStartTime < freesat.behind.nowStartTime) {
                    freesat.behind.gridStartTime = freesat.behind.nowStartTime;
                }
                starthour = new Date(freesat.behind.gridStartTime * 1000).getHours();

                if (starthour > 21) {
                    freesat.behind.day -= 1;
                }
                freesat.behind.animationClass.gridX = freesat.behind.gridX;
//                document.getElementById('laterProgrammeItemContainer' + this.gridX).addEventListener('webkitAnimationEnd', freesat.behind.animationClass.middleStepAniMinus24Hours);

                // Hide don't fade out
                freesat.behind.get('laterProgrammeItemContainer' + freesat.behind.gridX).addClass('hidden');
                freesat.behind.get('straplineTimeStrip' + freesat.behind.gridX).addClass('hidden');
                freesat.behind.nowNextStrapline.addClass('hidden');

                // Date calls
                freesat.behind.laterCallback = freesat.behind.onMinus24DataFirstCallback;
                freesat.behind.dataInterface.getLaterData(freesat.behind.pageRows, freesat.behind.topPositionIndex,freesat.behind.day,starthour,hours,freesat.behind.onData.laterLoaded);
            }
        },

        firstStepAniPlus24Hours: function() {
            var starthour,
                hours = 3;

            freesat.isAnimating = true;
            freesat.behind.day += 1;
            freesat.behind.animationClass.isLaterLoaded = false;
            freesat.behind.gridStartTime += (24 * 60 * 60);
            freesat.console.log('firstStepAniPlus24Hours: ' + new Date(freesat.behind.gridStartTime * 1000));

            starthour = new Date(freesat.behind.gridStartTime * 1000).getHours();
            freesat.behind.animationClass.gridX = freesat.behind.gridX;
//            document.getElementById('laterProgrammeItemContainer' + freesat.behind.animationClass.gridX).addEventListener('webkitAnimationEnd', freesat.behind.animationClass.middleStepAniPlus24Hours);

            // Hide don't fade out
            freesat.behind.get('laterProgrammeItemContainer' + freesat.behind.gridX).addClass('hidden');
            freesat.behind.get('straplineTimeStrip' + freesat.behind.gridX).addClass('hidden');
            freesat.behind.nowNextStrapline.addClass('hidden');

            // Data calls
            freesat.behind.laterCallback = freesat.behind.onPlus24DataFirstCallback;
            freesat.behind.dataInterface.getLaterData(freesat.behind.pageRows, freesat.behind.topPositionIndex,freesat.behind.day,starthour,hours,freesat.behind.onData.laterLoaded);
        },

        middleStepAniPlus24Hours: function() {
            freesat.console.log('middleStepAniPlus24Hours');
            document.getElementById('laterProgrammeItemContainer' + freesat.behind.animationClass.gridX).removeEventListener('webkitAnimationEnd', freesat.behind.animationClass.middleStepAniPlus24Hours);

            if (freesat.behind.animationClass.isLaterLoaded) {

                document.getElementById('laterProgrammeItemContainer' + freesat.behind.gridX).addEventListener('webkitTransitionEnd', freesat.behind.animationClass.finalStepAniPlus24Hours);

                // Added slight delay to instigate the webkitTransitionEnd event
                setTimeout(function() {
                    freesat.behind.laterProgrammeItemContainer.removeClass('later-off-right');
                    freesat.behind.timestrip.removeClass('later-off-right');
                }, 50);

            } else {
                freesat.behind.laterAniCallback = freesat.behind.animationClass.middleStepAniPlus24Hours;
            }
        },

        finalStepAniPlus24Hours: function() {
            freesat.console.log('finalStepAniPlus24Hours');
            document.getElementById('laterProgrammeItemContainer' + freesat.behind.gridX).removeEventListener('webkitTransitionEnd', freesat.behind.animationClass.finalStepAniPlus24Hours);
            freesat.behind.laterProgrammeItemContainer.removeClass('transition-horizontal');
            // Remove previous gridX container
            freesat.behind.get('laterProgrammeItemContainer' + (freesat.behind.gridX - 1)).detach();
            freesat.behind.get('straplineTimeStrip' + (freesat.behind.gridX - 1)).detach();
            freesat.behind.isSetLaterFocus = false;
            freesat.behind.laterFunc.setLaterFocus('plus24');

            if (freesat.behind.day === 6) {
                freesat.footer.hide('blue');
            }
            freesat.isAnimating = false;
        },

        firstStepAniMinus24Hours: function() {
            var starthour,
                hours = 3;

            freesat.isAnimating = true;
            freesat.behind.day -= 1;
            freesat.behind.animationClass.isLaterLoaded = false;
            freesat.behind.gridStartTime -= (24 * 60 * 60);

            freesat.console.log('firstStepAniMinus24Hours: ' + new Date(freesat.behind.gridStartTime * 1000));

            if (freesat.behind.gridStartTime < freesat.behind.nowStartTime) {
                freesat.behind.gridStartTime = freesat.behind.nowStartTime;
            }

            if (freesat.behind.day < 0) {
                freesat.behind.day = 0;
            }
            starthour = new Date(new Date(freesat.behind.gridStartTime * 1000)).getHours();

            freesat.behind.animationClass.gridX = freesat.behind.gridX;
//            document.getElementById('laterProgrammeItemContainer' + freesat.behind.animationClass.gridX).addEventListener('webkitAnimationEnd', freesat.behind.animationClass.middleStepAniMinus24Hours);

            // Hide don't fade out
            freesat.behind.get('laterProgrammeItemContainer' + freesat.behind.gridX).addClass('hidden');
            freesat.behind.get('straplineTimeStrip' + freesat.behind.animationClass.gridX).addClass('hidden');

            // Data calls
            freesat.behind.laterCallback = freesat.behind.onMinus24DataFirstCallback;
            freesat.behind.dataInterface.getLaterData(freesat.behind.pageRows, freesat.behind.topPositionIndex,freesat.behind.day,starthour,hours,freesat.behind.onData.laterLoaded);
        },

        middleStepAniMinus24Hours: function() {
            freesat.console.log('middleStepAniMinus24Hours');
            document.getElementById('laterProgrammeItemContainer' + freesat.behind.animationClass.gridX).removeEventListener('webkitAnimationEnd', freesat.behind.animationClass.middleStepAniMinus24Hours);

            if (freesat.behind.animationClass.isLaterLoaded) {
                document.getElementById('laterProgrammeItemContainer' + freesat.behind.gridX).addEventListener('webkitTransitionEnd', freesat.behind.animationClass.finalStepAniMinus24Hours);
                setTimeout(function() {
                    freesat.behind.laterProgrammeItemContainer.removeClass('later-off-left');
                    freesat.behind.timestrip.removeClass('later-off-left');
                }, 50);
            } else {
                freesat.behind.laterAniCallback = freesat.behind.animationClass.middleStepAniMinus24Hours;
            }
        },

        finalStepAniMinus24Hours: function() {
            freesat.console.log('finalStepAniMinus24Hours');
            document.getElementById('laterProgrammeItemContainer' + freesat.behind.gridX).removeEventListener('webkitTransitionEnd', freesat.behind.animationClass.finalStepAniMinus24Hours);
            freesat.behind.laterProgrammeItemContainer.removeClass('transition-horizontal');
            // Remove previous gridX container
            freesat.behind.get('laterProgrammeItemContainer' + (freesat.behind.gridX - 1)).detach();
            freesat.behind.get('straplineTimeStrip' + (freesat.behind.gridX - 1)).detach();
            freesat.behind.isSetLaterFocus = false;
            freesat.behind.laterFunc.setLaterFocus('plus24');

            if (freesat.behind.day === 5) {
                freesat.footer.show('blue');
            }
            freesat.isAnimating = false;
        },

        /**
         * Calculates the day according to the freesat.behind.gridStartTime
         *
         * @returns {number} - representing the day variable with zero being today
         */

        getDay: function() {
            var dayInSeconds = Math.round(24 * 60 * 60),
                today,
                dayStartTime,
                timeDifference;

            today = new Date(freesat.behind.nowStartTime * 1000);
            dayStartTime = (new Date(today.getFullYear(), today.getMonth(), today.getDate()).getTime() / 1000);
            timeDifference = freesat.behind.gridStartTime - dayStartTime;

            return Math.floor(timeDifference / dayInSeconds);
        },


        startLaterToLater: function(goto) {
            var dayInSeconds = Math.round(24 * 60 * 60),
                limit = freesat.behind.animationClass.forwardDays;

            freesat.console.log('startLaterToLater: ' + goto);

            freesat.isAnimating = true;
            freesat.behind.animationClass.isLaterLoaded = false;

            // Remove current highlight
            try {
                freesat.behind.get('hidden-button').setFocus();
            } catch (e) {
                freesat.console.log('ERROR - Cannot find hidden focus: ' + e );
            }

            if (goto === 'later-later') {
                freesat.behind.gridStartTime += (2 * 60 * 60);
                freesat.behind.day = freesat.behind.animationClass.getDay();

                freesat.console.log('DAY: ' + freesat.behind.day);

                if (freesat.behind.day >= limit) {
                    // Reset values
                    freesat.behind.day -= 1;
                    freesat.behind.gridStartTime -= (2 * 60 * 60);
                    freesat.console.log('CANNOT GO ANY LATER');
                    freesat.behind.get('event_' + freesat.behind.gridX + '_' + freesat.behind.gridY + '_' + freesat.behind.row + '_' +freesat.behind.column).setFocus();
                    freesat.isAnimating = false;
                    return;
                }
            } else if (goto === 'plus24') {
                freesat.behind.gridStartTime += dayInSeconds;

            } else if (goto === 'minus24') {
                freesat.behind.gridStartTime -= dayInSeconds;

            } else if (goto === 'earlier-later') {
                freesat.behind.gridStartTime -= (2 * 60 * 60);
                freesat.behind.day = freesat.behind.animationClass.getDay();
            }

            if (freesat.behind.day < 0) {
                freesat.behind.day = 0;
            }

            if (freesat.behind.gridStartTime < freesat.behind.nowStartTime) {
                freesat.behind.gridStartTime = freesat.behind.nowStartTime;
            }

            if (freesat.behind.day === (limit - 1) && freesat.behind.laterFunc.blueVisible) {
                freesat.footer.hide('blue');
                freesat.behind.laterFunc.blueVisible = false;
            }

            if (freesat.behind.day === (limit - 2) && !freesat.behind.laterFunc.blueVisible) {
                freesat.footer.show('blue');
                freesat.behind.laterFunc.blueVisible = true;
            }

            if (freesat.behind.transitionTimer) {
                clearTimeout(freesat.behind.transitionTimer);
            }
            // Delay before next step
            freesat.behind.transitionTimer = setTimeout(function() {
                freesat.behind.animationClass.hideLaterGrid();
            },100);
        },

        hideLaterGrid: function() {

            freesat.behind.get('laterProgrammeItemContainer').addClass('hide');
//            try {
//                freesat.behind.laterProgrammeItemContainer.detach();
////                freesat.behind.get('laterProgrammeItemContainer' + freesat.behind.gridX).detach();
//            } catch (e) {
//                freesat.console.log('ERROR Cannot remove laterProgrammeItemContainer: ' + e);
//            }

            // Clear header and update date
            freesat.header.unsetNow();
            freesat.header.setDate(freesat.behind.gridStartTime);

            if (freesat.behind.transitionTimer) {
                clearTimeout(freesat.behind.transitionTimer);
            }

            // Delay before next step
            freesat.behind.transitionTimer = setTimeout(function() {
                freesat.behind.animationClass.updateTimeline();
            },100);
        },

        updateTimeline: function() {
            if (freesat.behind.transitionTimer) {
                clearTimeout(freesat.behind.transitionTimer);
            }

            freesat.behind.createItem.createLaterTimeStrip();

//            // Delay before next step
            freesat.behind.nowNextToLaterTimer = setTimeout(function() {
                freesat.behind.animationClass.makeLaterCall();
            },100);
        },

        makeLaterCall: function() {
            var starthour,
                hours = 3;

            if (freesat.behind.transitionTimer) {
                clearTimeout(freesat.behind.transitionTimer);
            }

            freesat.console.log('makeLaterCall');

            starthour = new Date(freesat.behind.gridStartTime * 1000).getHours();

            // Data calls
            freesat.behind.laterCallback = freesat.behind.onPlus24DataFirstCallback;
            freesat.behind.dataInterface.getLaterData(freesat.behind.pageRows, freesat.behind.topPositionIndex,freesat.behind.day,starthour,hours,freesat.behind.onData.laterLoaded);

        },

        AM_ScreenView: function(){
            var urlParam = this.getAM_urlParam();
            freesat.am.screenView(urlParam);
        },

        getAM_urlParam: function(){
            var pageOffset = freesat.behind.nowNextPageOffset,
                diffTime = new Date(freesat.behind.gridStartTime * 1000) - new Date(),
                /*
                [timeOffset] indicates 2 hour window from now eg. 0 for now,
                    today, 1 for now + 2 hours, 12 for this time tomorrow etc.
                */
                timeOffset = Math.ceil(diffTime/(60*60*1000))/2;
                
            return '/tvGuide/later/time' + timeOffset + '/page' + pageOffset;
        }
    }
);
/**
 * Creates a new nownext instance.
 * @name Nownext
 * @memberof freesat.controllers.tvguide
 * @class A nownext class, providing animation functionality
 * @author <a href="mailto:rhys.jeffreys@accedo.tv">Rhys Jeffreys</a>
 */
accedo.Class.create("freesat.controllers.tvguide.Nownext", [], {},
    {
        isLaterLoaded: false,
        pagingCallback: null,

        onTransitionEnd: function() {
            document.getElementById('epgGuideContainer').removeEventListener('webkitTransitionEnd', freesat.behind.animationClass.onTransitionEnd);
            freesat.behind.epgGuideContainer.removeClass('transition-vertical').removeClass('off-top');

            try {
                freesat.behind.get('epgPage' + (freesat.behind.page - 1)).detach();
                freesat.behind.get('channelbarpage' + (freesat.behind.page - 1)).detach();
            } catch (e) {
                freesat.console.log('ERROR Removing EPG page' + (freesat.behind.page - 1) + ': ' + e);
            }

            if (freesat.behind.isPageDown) {
//                freesat.behind.populateNowNext();
                freesat.behind.isPageDown = false;
            }
            freesat.console.log('[onTransitionEnd] freesat.behind.isPageDown = '+freesat.behind.isPageDown);
            if (freesat.behind.isPageUp) {
                freesat.behind.isPageUp = false;
            }
            freesat.isAnimating = false;
            freesat.console.log('NN onTransitionEnd');
        },
        goToChannel: function (channelNumber) {
            if (freesat.behind.hasEarlierError) {
                console.log('Ignoring channel change because dialogue is showing');
                return;
            }

            var prevTopIndex = freesat.behind.topPositionIndex;
            freesat.behind.setTopPositionIndex();

            if (prevTopIndex > freesat.behind.topPositionIndex) {
                freesat.behind.animationClass.paging('up', true);
            } else if (prevTopIndex < freesat.behind.topPositionIndex) {
                freesat.behind.animationClass.paging('down', true);
            } else {
                freesat.behind.populateNowNext();
                freesat.behind.channelUtils.channelCheck();
                freesat.behind.channelUtils.highlightChannel();

            }
        },

        startPaging: function (dir) {
            var urlParam;

            freesat.behind.hideFocus();
            freesat.behind.channelUtils.checkTsTVDeact();

            if (dir === 'down'){
                freesat.behind.nowNextPageOffset++;
            } else {
                freesat.behind.nowNextPageOffset--;
            }

            if (freesat.behind.transitionTimer) {
                clearTimeout(freesat.behind.transitionTimer);
            }
            freesat.behind.channelUtils.removeChannelHighlight(freesat.behind.row);
            try {
                freesat.behind.get('channelNumberColumnContainer' + freesat.behind.page).removeClass('fade-in');
            } catch (e) {
                freesat.console.log('channelNumberColumnContainer has no fade-in class: ' + e);
            }
            // Delay before next step
            freesat.behind.transitionTimer = setTimeout(function() {
                freesat.masterController.showLoading();
                freesat.behind.animationClass.hidePagingGrid(dir);
            },100);
        },

        hidePagingGrid: function(dir) {
//            timeTrack('hide grid');
            freesat.behind.nowNextGrid.addClass('hidden').removeClass('fade-in');
            freesat.behind.resetHeader();

            if (freesat.behind.transitionTimer) {
                clearTimeout(freesat.behind.transitionTimer);
            }
            // Delay before next step
            freesat.behind.transitionTimer = setTimeout(function() {
                freesat.behind.animationClass.paging(dir);
            },100);
        },
        
        paging: function(dir, alreadyUpdatedIndex) {
            var channels_length,
                index_adjust,
                display_length,
                new_index;

//            timeTrack('page ' + dir);

            if (!freesat.isAnimating) {
                freesat.isAnimating = true;
                channels_length = freesat.behind.channelList.length;

                if (!alreadyUpdatedIndex) {
                    
                    if (dir === 'up') {
                        freesat.behind.isPageUp = true;
                        new_index = freesat.behind.topPositionIndex - 7;
                        
                        if (new_index < 0) {
                            freesat.behind.topPositionIndex = Math.floor(channels_length / 7) * 7;

                            if (freesat.behind.topPositionIndex === channels_length) {
                                freesat.behind.topPositionIndex = channels_length - 7;
                            }
                        } else {
                            freesat.behind.topPositionIndex = new_index;
                        }
                    } else {
                        new_index = freesat.behind.topPositionIndex + 7;

                        if (new_index < channels_length) {
                            freesat.behind.topPositionIndex = new_index;
                        } else {
                            freesat.behind.topPositionIndex = 0;
                        }
                    }
                }
                index_adjust = freesat.behind.topPositionIndex;

                // Check for short channel list
                if (channels_length < freesat.behind.PAGE_ITEMS) {
                    display_length = channels_length;
                } else {
                    display_length = (channels_length - index_adjust); // Get items from top index minus channels
                    display_length = (display_length > freesat.behind.PAGE_ITEMS) ? freesat.behind.PAGE_ITEMS : display_length; // If
                    freesat.behind.canPage = true;
                }
//                timeTrack('new channelbar');
                freesat.behind.channelUtils.createChannelBar(display_length, index_adjust);

                if (freesat.behind.isGenreList) {
                    freesat.behind.dataInterface.getNowAndNextGenre(freesat.behind.animationClass.onPagingCallback, freesat.behind.topPositionIndex, 8);
                } else {
                    freesat.behind.dataInterface.getNowAndNextAll(freesat.behind.animationClass.onPagingCallback, freesat.behind.topPositionIndex, 8);
                }
            }
        },

        onPagingCallback: function() {
//            timeTrack('paging callback');
            freesat.behind.populateNowNext();
            freesat.behind.channelUtils.channelCheck();

            // Reset variables
            if (freesat.behind.isPageDown) {
                freesat.behind.isPageDown = false;
            } else if (freesat.behind.isPageUp) {
                freesat.behind.isPageUp = false;
            }
            freesat.isAnimating = false;
            freesat.behind.nowNextGrid.removeClass('hidden');
//            timeTrack('paging complete');
        },

        firstStepAniNowNextToEarlier: function(){
            freesat.isAnimating = true;

//            timeTrack('firstStepAniNowNextToEarlier');

            freesat.behind.arrowContainer.addClass('fade-out');
            freesat.behind.footerButtons.addClass('fade-out');
            freesat.behind.channelFilter.addClass('fade-out');
            freesat.behind.resetHeader();
            freesat.header.get('header').removeClass('now-page').addClass('earlier-page');
            document.getElementById('arrowContainer').addEventListener('webkitAnimationEnd', freesat.behind.animationClass.middleStepAniNowNextToEarlier);

            freesat.behind.get('channelNumberColumnContainer' + freesat.behind.page).addClass('fade-out');

            if (freesat.behind.dataInterface) {
                freesat.behind.dataInterface.getEarlierData(freesat.channelData.channelList.getChannel('ccid:'+String(freesat.behind.channelLCNlist[freesat.behind.row])),freesat.behind.day,6,18,freesat.behind.onData.earlierLoaded);
            }
            freesat.behind.highlightedChannelId = freesat.behind.channelLCNlist[freesat.behind.row];
            freesat.behind.lastRow = freesat.behind.row;
            freesat.behind.channelTopIndex = freesat.behind.topPositionIndex;
            freesat.header.get('freesatLogo').setSrc("images/1280x720/logo/freetime-125x24.png");
        },

        middleStepAniNowNextToEarlier: function(){
//            timeTrack('middleStepAniNowNextToEarlier');
            if (freesat.behind.transitionTimer) {
                clearTimeout(freesat.behind.transitionTimer);
            }
//            document.getElementById('arrowContainer').removeEventListener('webkitAnimationEnd', freesat.behind.animationClass.middleStepAniNowNextToEarlier);
            freesat.behind.column = 'earlier';
            freesat.setZone('earlier');
            document.getElementById('earlierPage').addEventListener('webkitAnimationEnd', freesat.behind.animationClass.finalStepAniNowNextToEarlier);
            freesat.behind.nowNextPage.addClass('channel-logo-right');
            freesat.behind.earlierPage.addClass('earlier-epg-right').removeClass('hidden');
            freesat.behind.get('leftArrow').addClass('hidden');
            freesat.behind.leftArrowHidden = true;

//            document.getElementById('tlgGridContainer').addEventListener('webkitAnimationEnd', freesat.front.hideNowNext);
        },

        finalStepAniNowNextToEarlier: function(){
            freesat.behind.channelUtils.removeChannelHighlight(freesat.behind.row);
            document.getElementById('earlierPage').removeEventListener('webkitAnimationEnd', freesat.behind.animationClass.finalStepAniNowNextToEarlier);

            freesat.behind.arrowContainer.removeClass('hidden').removeClass('fade-out');
            freesat.footer.hide('green');
            freesat.behind.footerButtons.removeClass('fade-out').addClass('fade-in');

            try {
                freesat.behind.get('channelNumberColumnContainer' + freesat.behind.page).addClass('hidden');
            } catch (e) {
                console.log('NO CHANNEL NUMBER CONTAINER: ' + e);
            }
            freesat.behind.animationClass = new freesat.controllers.tvguide.Earlier();

            freesat.behind.animationClass.AM_ScreenView();
            
            freesat.behind.createEarlierChannelList();
//            freesat.console.log('[[[[[finalStepAniNowNextToEarlier]]]]] starting  assignCCIDtoTSTVchannels');
//            freesat.channelData.assignCCIDtoTSTVchannels();
//            freesat.console.log('[[[[[finalStepAniNowNextToEarlier]]]]] finishing assignCCIDtoTSTVchannels');
//            var chList = freesat.channelData.returnCUTVchannellist();
//            freesat.behind.earlierChannelList = chList;
//            var display_length = (chList.length>7)?7:chList.length;
//            freesat.behind.earlierTopPositionIndex = Math.floor(chList.indexOf(String(freesat.behind.highlightedChannelId))/7);
//            freesat.behind.earlierChannelRow = chList.indexOf(String(freesat.behind.highlightedChannelId)) % 7;
//            freesat.behind.channelUtils.createChannelBar(display_length, freesat.behind.earlierTopPositionIndex);
//            freesat.isAnimating = false;
//            freesat.oipfElement.setKeysetWithNumbers();
//            freesat.behind.rightArrow.deactivateFocus();
//            freesat.behind.channelUtils.highlightGivenChannel(freesat.behind.earlierChannelRow);
        },

        startNowNextTransition: function(goto) {
            freesat.console.log('startNowNextToLater: ' + goto);
            freesat.isAnimating = true;
            freesat.behind.animationClass.isLaterLoaded = false;
            freesat.behind.nowNextTopPositionIndex = freesat.behind.topPositionIndex;
            freesat.behind.hideFocus();

            if (goto === 'later' || goto === 'plus24') {
                // Set grid start time
                freesat.behind.setNowGridStartTime();
            }

            if (goto === 'earlier') {
                freesat.oipfElement.setKeysetWithNumbers();
            }

            if (goto === 'later') {

                if (freesat.behind.hasLater) {

                    if (freesat.behind.lastGridStartTime === freesat.behind.gridStartTime &&
                        freesat.behind.topPositionIndex === freesat.behind.laterTopPositionIndex) {
                        freesat.behind.useExisting = true;
                    } else {
                        freesat.behind.laterProgrammeItemContainer.removeAll();
                    }
                }

                if (freesat.behind.day !== 0) {
                    freesat.behind.day = 0;
                }
            } else if (goto === 'plus24') {
                freesat.behind.gridStartTime += (24 * 60 * 60);
            }

            if (freesat.behind.transitionTimer) {
                clearTimeout(freesat.behind.transitionTimer);
            }
            // Delay before next step
            freesat.behind.transitionTimer = setTimeout(function() {
                freesat.behind.animationClass.hideNowNextGrid(goto);
            },100);
        },

        hideNowNextGrid: function(goto) {
            var page,
                f;

//            timeTrack('hideNowNextGrid');
            // Hide Now & Next
            freesat.behind.resetHeader();

            if (goto === 'later' || goto === 'plus24') {
                f = freesat.behind.animationClass.showLater;
                page = 'later-page';
                freesat.header.setDate(freesat.behind.gridStartTime);
            } else if (goto === 'earlier' || goto === 'minus24') {
                freesat.behind.animationClass.callEarlier();
                f = freesat.behind.animationClass.middleStepAniNowNextToEarlier;
                page = 'earlier-page';
                freesat.behind.arrowContainer.addClass('hidden');
                freesat.behind.nowNextStrapline.addClass('hidden');
            }

            freesat.header.get('header').removeClass('now-page').addClass(page);
            freesat.behind.nowNextGrid.addClass('hidden').removeClass('fade-in');

            if (freesat.behind.transitionTimer) {
                clearTimeout(freesat.behind.transitionTimer);
            }

            // Delay before next step
            freesat.behind.transitionTimer = setTimeout(function() {
                f();
            },100);
        },

        callEarlier: function() {
            var rowVal = (freesat.behind.earlierChannelFocused)? freesat.behind.earlierChannelRow : freesat.behind.row;
            freesat.behind.arrowContainer.addClass('fade-out');
            freesat.behind.footerButtons.addClass('fade-out');

            freesat.behind.channelFilter.addClass('hidden');

            freesat.behind.get('channelNumberColumnContainer' + freesat.behind.page).addClass('fade-out');
            var stashRow = rowVal;
            if (freesat.behind.dataInterface) {
                freesat.behind.dataInterface.getEarlierData(freesat.channelData.channelList.getChannel('ccid:'+String(freesat.behind.channelLCNlist[rowVal])),freesat.behind.day,6,18,freesat.behind.onData.earlierLoaded);
            }
            if(freesat.behind.earlierChannelFocused){
                freesat.behind.earlierChannelRow  = stashRow;
            }else{
                freesat.behind.row  = stashRow;
            }
            freesat.behind.highlightedChannelId = freesat.behind.channelLCNlist[rowVal];
            freesat.behind.lastRow = rowVal;

            freesat.behind.channelTopIndex = freesat.behind.topPositionIndex;
            freesat.header.get('freesatLogo').setSrc("images/1280x720/logo/freetime-125x24.png");

        },

        showLater: function() {
            var f;

            if (freesat.behind.useExisting) {
                f = freesat.behind.animationClass.highlightLaterExisting;
            } else {
                f = freesat.behind.animationClass.makeLaterCall;
            }
//            timeTrack('showLater');
            if (freesat.behind.transitionTimer) {
                clearTimeout(freesat.behind.transitionTimer);
            }

            freesat.behind.rightArrow.addClass('hidden');
            freesat.behind.straplineNext.removeClass('highlight'); // .addClass('hidden')

            freesat.behind.laterPage.removeClass('hidden');
            freesat.behind.tvguide.addClass('hide-next-timeline');

            freesat.behind.createItem.createLaterTimeStrip();
            freesat.behind.get('straplineNowNextContainer').addClass('hidden');

            freesat.behind.column = 'later';
            freesat.setZone('later');
            freesat.behind.nowNextGrid.addClass('hidden').removeClass('fade-in');
            freesat.behind.laterPage.removeClass('hidden');
            freesat.behind.tvguide.addClass('hide-next-timeline');

            // Delay before next step
            freesat.behind.transitionTimer = setTimeout(function() {
                f();
            },100);
        },

        makeLaterCall: function() {
            var starthour,
                hours = 3;

//            timeTrack('makeLaterCall');

            if (freesat.behind.transitionTimer) {
                clearTimeout(freesat.behind.transitionTimer);
            }

            freesat.console.log('makeLaterCall - channels: ' + freesat.behind.pageRows);

            starthour = new Date(freesat.behind.gridStartTime * 1000).getHours();

            // Data calls
            freesat.behind.laterCallback = freesat.behind.onNowLaterDataFirstCallback;
            freesat.behind.dataInterface.getLaterData(freesat.behind.pageRows, freesat.behind.topPositionIndex,freesat.behind.day,starthour,hours,freesat.behind.onData.laterLoaded);

        },

        highlightLaterExisting: function() {
            freesat.behind.animationClass = new freesat.controllers.tvguide.Later();
            freesat.behind.laterFunc.setLaterFocus('load');
//            timeTrack('setLaterFocus');
            freesat.isAnimating = false;
        },

        firstStepAniNowNextToLater: function(){
            var starthour,
                hours = 3;

            freesat.console.log('firstStepAniNowNextToLater');

            freesat.isAnimating = true;
            freesat.behind.animationClass.isLaterLoaded = false;

            starthour = new Date(freesat.behind.gridStartTime * 1000).getHours();

            if (freesat.behind.day !== 0) {
                freesat.behind.day = 0;
            }
//            freesat.dataStore.allData.laterAll = [];

            // Hide Now & Next
//            freesat.behind.resetHeader();
//            freesat.header.get('header').removeClass('now-page').addClass('later-page');
//            freesat.behind.rightArrow.addClass('hidden');
//            freesat.behind.straplineNext.addClass('hidden').removeClass('highlight');

//            freesat.behind.column = 'later';
//            freesat.setZone('later');
//            freesat.behind.nowNextGrid.addClass('hidden').removeClass('fade-in');
//            freesat.behind.laterPage.removeClass('hidden');
//            freesat.behind.tvguide.addClass('hide-next-timeline');

            // Data calls

            freesat.behind.laterCallback = freesat.behind.onNowLaterDataFirstCallback;
            freesat.behind.dataInterface.getLaterData(freesat.behind.pageRows, freesat.behind.topPositionIndex,freesat.behind.day,starthour,hours,freesat.behind.onData.laterLoaded);

//            freesat.behind.epgGuideContainer.addClass('fade-now-out');
//            freesat.behind.tvguide.addClass('load-later');

//            document.getElementById('rightArrow').addEventListener('webkitAnimationEnd', freesat.behind.animationClass.middleStepAniNowNextToLater);

        },

        middleStepAniNowNextToLater: function(){
            freesat.console.log('middleStepAniNowNextToLater ' + freesat.behind.animationClass.isLaterLoaded);
            document.getElementById('rightArrow').removeEventListener('webkitAnimationEnd', freesat.behind.animationClass.middleStepAniNowNextToLater);
            if (freesat.behind.animationClass.isLaterLoaded) {
                document.getElementById('straplineTimeStrip' + freesat.behind.gridX).addEventListener('webkitTransitionEnd', freesat.behind.animationClass.finalStepAniNowNextToLater, false);
                freesat.behind.column = 'later';
                freesat.setZone('later');
                freesat.behind.nowNextGrid.addClass('hidden').removeClass('fade-in');
                freesat.behind.laterPage.removeClass('hidden');

                // Require short delay to instantiate the transitions
                setTimeout(function() {
                    freesat.behind.tvguide.addClass('hide-next-timeline').removeClass('load-later');
                }, 50);

            } else {
                freesat.behind.laterAniCallback = freesat.behind.animationClass.middleStepAniNowNextToLater;
            }
        },

        finalStepAniNowNextToLater: function(){
            try {
                freesat.console.log('finalStepAniNowNextToLater');
                document.getElementById('straplineTimeStrip' + freesat.behind.gridX).removeEventListener('webkitTransitionEnd', freesat.behind.animationClass.finalStepAniNowNextToLater);
                freesat.behind.laterFunc.setLaterFocus('load');
                freesat.behind.epgGuideContainer.removeClass('fade-now-out');
                freesat.behind.animationClass = new freesat.controllers.tvguide.Later();
            } catch (e) {
                freesat.console.log('[Error] finalStepAniNowNextToLater ' + e);
            }
        },

        firstStepAniNowNextToPlus24Hours: function() {
            var starthour,
                hours = 3;

            freesat.console.log('firstStepAniNowNextToPlus24Hours');
            freesat.isAnimating = true;

            if (freesat.behind.hasLater) {
                // Remove previous gridX container
                freesat.behind.get('laterProgrammeItemContainer').detach(); //  + (freesat.behind.gridX)
                freesat.behind.get('straplineTimeStrip' + (freesat.behind.gridX)).detach();
            }

            freesat.behind.setNowGridStartTime();
            freesat.behind.gridStartTime += (24 * 60 * 60);
            starthour = new Date(freesat.behind.gridStartTime * 1000).getHours();
            freesat.behind.animationClass.isLaterLoaded = false;

            // Hide elements
            freesat.behind.nowNextGrid.addClass('hidden');
            freesat.behind.nowNextStrapline.addClass('hidden');
            freesat.behind.rightArrow.addClass('hidden');
            freesat.behind.column = 'later';
            freesat.setZone('later');
            freesat.behind.laterPage.removeClass('hidden');

//            freesat.dataStore.allData.laterAll = [];
            freesat.behind.laterCallback = freesat.behind.onPlus24DataFirstCallback;
//            document.getElementById('epgNowNextContainer').addEventListener('webkitAnimationEnd', freesat.behind.animationClass.middleStepAniNowNextToPlus24Hours);

            freesat.behind.dataInterface.getLaterData(freesat.behind.pageRows, freesat.behind.topPositionIndex,freesat.behind.day,starthour,hours,freesat.behind.onData.laterLoaded);
            freesat.behind.animationClass = new freesat.controllers.tvguide.Later();
        },

        middleStepAniNowNextToPlus24Hours: function() {
            freesat.console.log('middleStepAniNowNextToPlus24Hours - loaded: ' + freesat.behind.animationClass.isLaterLoaded);
            document.getElementById('epgNowNextContainer').removeEventListener('webkitAnimationEnd', freesat.behind.animationClass.middleStepAniNowNextToPlus24Hours);

            if (freesat.behind.animationClass.isLaterLoaded) {
                document.getElementById('laterProgrammeItemContainer' + freesat.behind.gridX).addEventListener('webkitTransitionEnd', freesat.behind.animationClass.finalStepAniNowNextToPlus24Hours);

                freesat.console.log('addEventListener: laterProgrammeItemContainer' + freesat.behind.gridX);
                freesat.behind.column = 'later';
                freesat.setZone('later');
                freesat.behind.laterPage.removeClass('hidden');

                // Need timeout delay in order to instigate a transition
                setTimeout(function() {
                    freesat.behind.laterProgrammeItemContainer.removeClass('later-off-right');
                    freesat.behind.timestrip.removeClass('later-off-right');
                }, 50);

            } else {
//                setTimeout(function() {
//                    freesat.behind.animationClass.middleStepAniNowNextToPlus24Hours();
//                }, 500);
                freesat.behind.laterAniCallback = freesat.behind.animationClass.middleStepAniNowNextToPlus24Hours;
            }
        },

        finalStepAniNowNextToPlus24Hours: function() {
            freesat.console.log('firstStepAniNowNextToPlus24Hours');
            document.getElementById('laterProgrammeItemContainer' + freesat.behind.gridX).removeEventListener('webkitTransitionEnd', freesat.behind.animationClass.finalStepAniPlus24Hours);
            freesat.behind.laterProgrammeItemContainer.removeClass('transition-horizontal');
            freesat.behind.laterFunc.setLaterFocus('plus24');
            freesat.behind.animationClass = new freesat.controllers.tvguide.Later();
            freesat.isAnimating = false;
        },

        AM_ScreenView: function(){
            var urlParam = this.getAM_urlParam();
            freesat.am.screenView(urlParam);
        },

        getAM_urlParam: function(){
            var filter = "allChannels",
            nowNextPageOffset = freesat.behind.nowNextPageOffset;

            if (freesat.behind.filter.genres.length){
                filter = ('' + freesat.behind.filter.genres[freesat.behind.filter.selected]).toAMStandardised();
            }

            return '/tvGuide/nowNext/' + filter + '/page' + nowNextPageOffset;
        }
    }
);

/**
 * Creates a new OnData instance.
 * @name OnData
 * @memberof freesat.controllers.tvguide
 * @class An OnData class
 * @author <a href="mailto:rhys.jeffreys@accedo.tv">Rhys Jeffreys</a>
 */
accedo.Class.create("freesat.controllers.tvguide.OnData", [], {},
    {
        nownextLoaded : function(e) {
            trace('gettingData'); // end tag for getting data
            trace('renderToScreen', true);//start tag for render to screen
//            if (e) {
//                freesat.behind._data = e;
                freesat.behind.nowNextGridSetup();
//            }
        },

        earlierLaunchLoaded : function(channel) {
            freesat.behind.launchedInEarlier = true;
            if (channel) {
                freesat.behind.get('straplineNow').removeClass('highlight');
                freesat.behind.arrowContainer.addClass('hidden');
                freesat.behind.nowNextStrapline.addClass('hidden');
                freesat.behind.channelFilter.addClass('hidden');
                freesat.behind.get('peekChannelGradient').addClass('peekChannelGradient');
                freesat.behind.animationClass.middleStepAniNowNextToEarlier();
                freesat.behind.onData.earlierLoaded(channel);
                freesat.behind.setFooter(true);
                freesat.footer.show('yellow');
                freesat.footer.show('blue');
                if (freesat.behind.canPageDown || freesat.behind.canPageUp) {
                    freesat.footer.show('paging');
                } else {
                    freesat.footer.hide('paging');
                }
            } else {
                if(!freesat.behind.earlierChannelFocused){
                    if (freesat.behind.dataInterface.earlier.isIpAvailable()) {
                        freesat.behind.earlierFunc.showNotAvailable();
                    }else{
                        freesat.behind.earlierFunc.showNotConnected();
                    }
                }else{
                    freesat.behind.get('leftArrow').addClass('hidden');
                    freesat.behind.arrowContainer.removeClass('fade-out').addClass('fade-in');
                    freesat.behind.programmeContainer = freesat.behind.get('earlierProgrammeItemContainer');
                    freesat.behind.programmeImages = freesat.behind.get('programmeImageContainer');
                    freesat.behind.programmeContainer.removeAll();
                    freesat.behind.programmeImages.removeAll();
                    freesat.isAnimating = false;
                }
            }
        },

        showNoEarlierProgrammes: function() {
            var earlierChannel, channelName, rightArrow;

            if (freesat.behind.animationClass.plus24Hours) {
                rightArrow = (freesat.behind.day === 0) ? 'now' : '';

                freesat.behind.animationClass.thirdStepAniEarlierPlus24Hours();
                freesat.behind.get('rightArrow-label').setText(rightArrow);
                freesat.behind.get('leftArrow-label').setText('');
                freesat.behind.get('straplineEarlierTitle').setText('');
            }
            earlierChannel = freesat.behind.earlierChannel;
            channelName = earlierChannel.dsd || '';
            freesat.behind.get('leftArrow').addClass('hidden');
            freesat.behind.arrowContainer.removeClass('fade-out').addClass('fade-in');
            freesat.behind.programmeContainer = freesat.behind.get('earlierProgrammeItemContainer');
            freesat.behind.programmeImages = freesat.behind.get('programmeImageContainer');
            freesat.behind.freesatServiceID = earlierChannel.freesatServiceID;
            freesat.behind.get('straplineEarlierChannelName').setText(channelName);
            freesat.behind.programmeContainer.removeAll();
            freesat.behind.programmeContainer.attach(new accedo.ui.widget.Label({
                id: '#no-programmes-available',
                text: 'No programmes available'
            }));
            freesat.behind.programmeImages.removeAll();
            freesat.isAnimating = false;
        },

        earlierLoaded : function(channel) {

            if (channel) {
                freesat.behind.earlierChannel = channel;
                freesat.behind.earlierGridSetup();

                if (freesat.behind.animationClass.minus24Hours || freesat.behind.animationClass.plus24Hours) {
                    freesat.behind.animationClass.isEarlierLoaded = true;

                    if (freesat.behind.animationClass.minus24Hours) {
                        freesat.behind.animationClass.thirdStepAniEarlierMinus24Hours();
                    } else {
                        freesat.behind.animationClass.thirdStepAniEarlierPlus24Hours();
                    }
                }
                if(freesat.behind.earlierChannelFocused){
                    freesat.isAnimating = false;
                    if ((-freesat.behind.day) >= (freesat.dataStore.allData.earlierAll[freesat.behind.freesatServiceID].length - 1)) {
                        freesat.behind.leftArrow.addClass('hidden');
                        freesat.behind.leftArrowHidden = true;

                        if (!freesat.dataStore.allData.earlierAll[freesat.behind.freesatServiceID][-freesat.behind.day]) {
                            freesat.behind.onData.showNoEarlierProgrammes();
                        }
                    }
                    freesat.behind.arrowContainer.removeClass('fade-out').addClass('fade-in');
                }
            } else {

                if (!freesat.behind.earlierChannelFocused) {

                    if (freesat.behind.dataInterface.earlier.isIpAvailable()) {
                        freesat.behind.earlierFunc.showNotAvailable();
                    } else {
                        freesat.behind.earlierFunc.showNotConnected();
                    }
                } else {
                    freesat.behind.onData.showNoEarlierProgrammes();
                }
            }

            if (freesat.behind.earlierChannelNavigating) {
                freesat.behind.earlierChannelNavigating = false;
            }
        },

        pictureLoaded : function(progData) {
            if(progData) {
                var programmeImages = freesat.behind.get('programmeImageContainer');
                var image_one = new freesat.widget.ProgramItemWithImage({
                    id:'image_one',
                    css:'programItemWithImage',
                    url:'images/sc/00ant-and-dec.jpg',
                    data:progData[0],
                    nextDown:'image_two',
                    nextLeft:'leftArrow',
                    nextRight:'programmeGridItem_0'
                });
                image_one.notifyFocused = freesat.behind.setEarlierHeader;
                var image_two = new freesat.widget.ProgramItemWithImage({
                    id:'image_two',
                    css:'programItemWithImage',
                    url:'images/sc/00auction-hero.jpg',
                    data:progData[1],
                    nextUp:'image_one',
                    nextLeft:'leftArrow',
                    nextRight:'programmeGridItem_0'
                });
                image_two.notifyFocused = freesat.behind.setEarlierHeader;

                programmeImages.attach(image_one);
                programmeImages.attach(image_two);

                image_one.onKey = freesat.behind.handleEarlierItemSelection(true);
                image_two.onKey = freesat.behind.handleEarlierItemSelection(true);

                programmeImages.onKey = function(vKey){
                    switch (vKey)
                    {
                        case accedo.VKey.KEY_DOWN:
                            break;
                        case accedo.VKey.KEY_UP:
                            break;
                    }
                };
            }
        },

        laterLoaded: function(channelIndex, startday, starthour, numberofhours) {
            freesat.behind.laterCallback(channelIndex, startday, starthour, numberofhours);
        },

        nowNextGenreLoaded: function() {
            freesat.console.log('nowNextGenreLoaded');
            freesat.behind.nowNextData = freesat.dataStore.allData.nowNextGenre;
            freesat.behind.channelList = freesat.channelData.genreList;
            freesat.behind.populateNowNext();

        }
    }
);
/**
 * @name Tvguide
 * @namespace
 * @memberOf freesat.controllers
 * @class
 */
accedo.Class.create('freesat.controllers.Tvguide', 'accedo.ui.Controller', ['freesat.view.Tvguide', 'freesat.controllers.tvguide.ChannelUtils', 'freesat.controllers.tvguide.Earlier', 'freesat.controllers.tvguide.Nownext', 'freesat.controllers.tvguide.Later', 'freesat.controllers.tvguide.OnData', 'freesat.controllers.tvguide.CreateItem', 'freesat.controllers.tvguide.Filter'], {}, {
    dataInterface: null,
    elementContainer: null,
    controllerLoadedInterval: null,
    footerLoaded: null,
    footerOpts: null,
    currentButton: null,
    channelUtils: null,
    animationClass: null,
    currentTime: null,
    currentTimeHours: null,
    currentTimeMinutes: null,
    gridStartTime: null,
    nowStartTime: null,
    createItem: null,
    highlightedChannelId: null,
    column: 'now',
    page: 0,
    row: 0,
    gridX: 0,
    gridY: 0,
    day: 0,
    topPositionIndex: 0,
    channelLCNlist: [],
    laterCallback: null,
    tapPageUp: false,
    tapPageDown: false,
    isPageDown: false,
    isPageUp: false,
    isAnimating: false,
    isGenreList: false,
    updateGenreTitle: false,
    updateChannelbar: false,
    isSetLaterFocus: false,
    // Earlier vars
    programmeItems: [],
    laterGridModel: [],
    laterCurrent: null,
    laterPaging: false,
    currentRows: 0,
    canPage: false,
    canPageDown: false,
    canPageUp: false,
    hasEarlier: false,
    hasEarlierPromo: false,
    hasNowNext: false,
    nowNextData: null,
    channelList: null,
    hasLater: false,
    leftArrowHidden: false,
    freesatServiceID: null,
    earlierChannel: null,
    earlierChannelFocused: false,
    earlierChannelRow: 0,
    earlierChannelLCN: null,
    earlierChannelList: null,
    earlierTopPositionIndex: 0,
    firstBack: false,
    // CONSTANTS
    PAGE_ITEMS: 7,
    MAX_PAGE_ITEMS: 15,
    ITEM_HEIGHT: 46,

    pageRows: this.PAGE_ITEMS,
    gridIsSetup: false,

    setupDoneBoo: false,
    setupCallback: null,

    laterAniCallback: null,

    earlierFunc: null,
    laterFunc: null,
    handleSelection: null,
    nowNextPageOffset: 0, // Count of paging for AM
    earlierPageOffset: 1,
    laterPageOffset: 0,
    
    initialize: function($super) {
        $super();
        freesat.oipfElement.setKeysetWithoutNumbers();
        freesat.behind = this;
        this._data = [];
        this.handleSelection = new freesat.controllers.tvguide.HandleSelection();
        this.earlierFunc = new freesat.controllers.tvguide.func.Earlier();
        this.laterFunc = new freesat.controllers.tvguide.func.Later();
        this.animationClass = new freesat.controllers.tvguide.Nownext();
        this.channelUtils = new freesat.controllers.tvguide.ChannelUtils();
        this.onData = new freesat.controllers.tvguide.OnData();
        this.createItem = new freesat.controllers.tvguide.CreateItem();
        this.filter = new freesat.controllers.tvguide.Filter();
        this.setTopPositionIndex();
        if(freesat.getZone() !=='earlier'){
            freesat.setZone('now');
        }
        freesat.behind.setView(freesat.view.Tvguide);
    },

    postSetup: function () {
        if(freesat.channelData.isReady){
            freesat.channelData.registerCallback(freesat.behind.finalInit);
        }else{
            freesat.behind.finalInit();
        }
    },

    finalInit: function() {
        freesat.behind.dataInterface = freesat.dataStore.getInterface();
        if (freesat.behind.dataInterface.ready) {
            this.onDataInterfaceReady();
        }else{
            freesat.behind.dataInterface.readyCallback = this.onDataInterfaceReady;
        }
        freesat.behind.dataInterface.nownext.updateFunc  = freesat.behind.updateNowNext;
    },

    onDataInterfaceReady: function(){
        if(freesat.getZone() ==='earlier'){
            var cookierow = freesat.getBackCookieValue('row');
            var cookiecol = freesat.getBackCookieValue('day');
            freesat.backItemName = "";
            try {
                freesat.backItemName = atob(freesat.getBackCookieValue('name'));
            } catch (e) {
                freesat.console.log("could not recoved back item name");
            }
            var ccid = freesat.getBackCookieValue('ccid');
            freesat.console.log('CCID >>> ' +ccid+ '    ROW >>> '+cookierow + ' day >>> '+ cookiecol);
            freesat.temprow = (cookierow)?parseInt(cookierow,null):1;
            freesat.behind.day = (cookiecol)?parseInt(cookiecol,null):1;
            freesat.clearBackCookie('section');
            freesat.clearBackCookie('row');
            freesat.clearBackCookie('day');
            freesat.clearBackCookie('name');
            freesat.clearBackCookie('ccid');
            freesat.behind.channelLCNlist = [];
            try{
                var lcn = Number(ccid.split(':')[1]);
                freesat.behind.setRowAndTopIndex(lcn);

                for(var i=0; i < 8; i++){
                    freesat.behind.channelLCNlist.push(Number(freesat.channelData.channelList[i+freesat.behind.topPositionIndex].ccid.split(':')[1]));
                }

                if(lcn === freesat.behind.channelLCNlist[freesat.behind.row]){
                    var channel = freesat.channelData.channelList.getChannel(ccid);
                    if (freesat.behind.dataInterface) {
                        freesat.behind.dataInterface.getEarlierData(channel,freesat.behind.day,6,18,freesat.behind.onData.earlierLaunchLoaded);
                    }
                    freesat.behind.highlightedChannelId = lcn;
                    freesat.behind.lastRow = freesat.behind.row;

                    freesat.console.log('=== START FTVG EARLIER ===');
                }else{
                    freesat.console.log('EARLIER START CCID miss match');
                    freesat.behind.nowNextRestart();
                }
            }catch(e){
                freesat.console.log('EARLIER START ERROR '+ e);
                freesat.behind.nowNextRestart();
            }
        }else if(freesat.getZone() ==='now'){
            freesat.console.log('tvguide.onDataInterfaceReady zone=now');
            freesat.behind.nowNextStart();
        }
    },
    nowNextRestart: function(){
        var lcn = freesat.getCurrentChannel();
        freesat.behind.setRowAndTopIndex(lcn);
        freesat.setZone('now');
        freesat.behind.nowNextStart();
    },
    nowNextStart: function(){

        trace('appXDKInitialise'); // end tag for the app initialise
        trace('gettingData',true); // start tag for getting data
        freesat.behind.dataInterface.abortiveSearch = false; // Reset abortiveSearch, if it's been set to true by freesat.behind.dataInterface.voidAllSearchs() coming from search
        freesat.behind.dataInterface.updateFunc = freesat.behind.updateNowNext;
        freesat.behind.dataInterface.getNowAndNextAll(freesat.behind.onData.nownextLoaded, freesat.behind.topPositionIndex, 8);
    },

    nowNextRedraw: function() {
        freesat.behind.animationClass.paging('', true);
    },

    setup: function() {
        freesat.oipfElement.videoBroadcast.onChannelChangeSucceeded = freesat.masterController.channelChanged;

        freesat.behind.footerController = freesat.behind.get("footer-controller");
        freesat.behind.headerController = freesat.behind.get("header-controller");
        freesat.footer = freesat.header = null; // ensures these are refreshed correctly upon tvguide setup
        // freesat.behind.get('less24Icon').addClass('alpha0');
        freesat.behind.leftArrow = freesat.behind.get('leftArrow');
        freesat.behind.rightArrow = freesat.behind.get('rightArrow');
        freesat.behind.arrowContainer = freesat.behind.get('arrowContainer');
        //            oipfObjectFactory.createVideoBroadcastObject();
        freesat.behind.elementContainer = freesat.behind.get('container');
        freesat.behind.epgGuideContainer = freesat.behind.get('epgGuideContainer');
        freesat.behind.epgGuideContainerElement = document.getElementById('epgGuideContainer');
        freesat.behind.nowNextPage = freesat.behind.get('nowNextPage');
        freesat.behind.channelFilter = freesat.behind.get('channelFilter');
        freesat.behind.earlierPage = freesat.behind.get('earlierPage');
        freesat.behind.laterPage = freesat.behind.get('laterPage');
        freesat.behind.laterProgrammeItemMask = freesat.behind.get('laterProgrammeItemMask');
        freesat.behind.straplineTimeStripMask = freesat.behind.get('straplineTimeStripMask');
        freesat.behind.tvguide = freesat.behind.get('tvguide');
        freesat.behind.nowNextStrapline = freesat.behind.get('straplineNowNextContainer');
        freesat.behind.straplineNext = freesat.behind.get('straplineNext');
        freesat.behind.channelbar = freesat.behind.get('channelbarcontainer');
        freesat.behind.nowNextGrid = freesat.behind.get('epgNowNextContainer');
        freesat.behind.footerButtons = freesat.behind.get('footer');
        freesat.actionData = new freesat.models.vo.MenuObject();
        freesat.actionData.context = 'Watch now';
        freesat.actionData.timeZone = 'now';

        freesat.behind.createTTLinterval();
        freesat.behind.footerOpts = {'red': 'Home Menu', 'green': 'Filter Channels', 'yellow': '-24hrs', 'blue': '+24hrs', 'paging': 'Page Up / Down'};

        freesat.behind.get("earlier-connectionBackButton").onKey = function (vKey) {
            if (vKey === accedo.VKey.KEY_OK || vKey === accedo.VKey.KEY_BACK || vKey === accedo.VKey.KEY_RIGHT) {
                freesat.behind.animationClass.firstStepAniEarlierToNowNext();
            }
            return true;
        };

        freesat.oipfElement.videoBroadcast.onRecordingEvent = function(state, error, recordingId) {
            freesat.console.log('onRecordingEvent');
            freesat.behind.updateRecordingReminderIcons();
        }

        freesat.behind.setupDone();

    },

    updateRecordingReminderIcons: function() {
        var recHandler = freesat.masterController.recordingsHandler;

        switch (zone) {
            case 'now':
                freesat.behind.updateNowNext();
                break;
            case 'later':
                var grid = freesat.behind.laterProgrammeItemContainer.get('laterGrid');
                if (!grid) {
                    freesat.console.log('WARNING: couldn\'t find grid');
                    return;
                }

                var rowContainers = grid.getChildren();
                for (var rowIndex = 0; rowIndex < rowContainers.length; rowIndex++) {
                    var progItems = rowContainers[rowIndex].getChildren();
                    for (var progIndex = 0; progIndex < progItems.length; progIndex++) {
                        if (!rowContainers[rowIndex] instanceof freesat.widget.LaterEpgLineItem) {
                            freesat.console.log('WARNING: unexpected class found instead of epg line item');
                            continue;
                        }

                        var progItem = progItems[progIndex];
                        if (progItem.getProgrammeData()) {
                            progItem.setIconType(progItem.getProgrammeData());
                        }
                    }
                }
                break;
        }

        if (freesat.header.current) {
            freesat.header.metaIcons.unset(freesat.header.programmeMetadataIconsContainer);
            freesat.header.metaIcons.set(freesat.header.current, freesat.header.programmeMetadataIconsContainer);

        }
    },

    setupDone: function(){
        freesat.behind.setupDoneBoo = true;
        if(freesat.behind.setupCallback){freesat.behind.setupCallback();}
    },
    createTTLinterval: function() {
        if (freesat.pageTTLinterval) {
            clearInterval(freesat.pageTTLinterval);
        }
        freesat.pageTTLinterval = setInterval(freesat.masterController.clearToFullscreen, 300000);
    },

    nowNextGridSetup: function() {
        if(freesat.behind.setupDoneBoo){
            freesat.behind.setTopPositionIndex();
            freesat.behind.nowNextData = freesat.dataStore.allData.nowNextAll;
            freesat.behind.channelList = freesat.channelData.channelList;
            freesat.behind.populateNowNext();
            freesat.behind.gridIsSetup = true;
            freesat.behind.setItemFocus();

            
            // Copy initial Now & Next values to variables
            freesat.behind.nowNextLCNList = freesat.behind.channelLCNlist;
            freesat.behind.nowNextRows = freesat.behind.pageRows;
            freesat.behind.nowNextRow = freesat.behind.row;
            freesat.behind.nowNextTopPositionIndex = freesat.behind.topPositionIndex;
            trace('ftvgLoad'); //end tag for loading to user interactivity
            trace('renderToScreen'); //end tag for renderToScreen
            freesat.behind.setFooter();

            setTimeout(function () {
                freesat.behind.get('peekChannelGradient').addClass('peekChannelGradient');
                freesat.marketingOptIn.showDialogIfRequired();
            }, 100);

            setTimeout(freesat.loadRemainingSections, 600);
       }else{
            freesat.behind.setupCallback = freesat.behind.nowNextGridSetup;
       }
    },

    /**
     * setTopPositionIndex
     * @description sets the top possition index
     */
    setTopPositionIndex: function(){
        this.setRowAndTopIndex(freesat.getCurrentChannel());
    },
    setRowAndTopIndex: function(channelLCN) {
        var sChannelList = (freesat.behind.channelList)?freesat.behind.channelList:false;
        var currentChannelIndex = freesat.behind.channelUtils.returnChannelIndex(channelLCN, sChannelList);
        freesat.behind.row = currentChannelIndex % 7;
        freesat.behind.lastRow = currentChannelIndex % 7;
        freesat.behind.topPositionIndex = 7 * (Math.floor(currentChannelIndex / 7));

    },
    changeTopPositionIndex: function(dataSet, value) {
        var newTopPos = freesat.behind.topPositionIndex + value;
        if (newTopPos >= dataSet.length) {
            newTopPos = 0;
        } else if (newTopPos < 0) {
            newTopPos = (dataSet.length-(dataSet.length%3));
        }
        freesat.behind.topPositionIndex = newTopPos;
    },

    populateNowNext: function() {
        var nowNextData = freesat.behind.nowNextData,
            dataLength = freesat.behind.channelList.length,
            indexAdjust = freesat.behind.topPositionIndex,
            prepend = false, grid_exists = false,
            display_length, pageGrid, nowContainer, nextContainer, i,
            index, nowElement, nextElement,
            allEvents, nowData, nextData, empty_rows, debug;

        if (dataLength < 7) {
            display_length = dataLength;
        } else {
            display_length = (dataLength - indexAdjust);
            if (display_length > 7) {
                display_length = 7;
            }


            freesat.behind.canPage = true;
        }
        freesat.console.log('>>LENGTH: ' + dataLength + '; DISPLAY ITEMS: ' + display_length);
        freesat.console.log('DATA: ' + nowNextData.length + '; CHANNELS: ' + freesat.behind.channelList.length);
        freesat.behind.pageRows = display_length;

        if (!freesat.behind.hasNowNext) { // Remove empty holding page
            freesat.console.log('hasNowNext: ' + freesat.behind.hasNowNext);
            freesat.behind.get('epgPage').detach();
            freesat.behind.get('channelbarpage').detach();
        }

        if (document.getElementById('epgPage' + freesat.behind.page)) {
            grid_exists = true;
            pageGrid = freesat.behind.get('epgPage' + freesat.behind.page).detach();
//            pageGrid.removeAll();
        } else {
            pageGrid = new accedo.ui.Container({
                id: '#epgPage' + freesat.behind.page,
                css: 'epgPage'
            });
        }

        if (display_length < 7 && freesat.behind.hasNowNext && freesat.behind.canPage) { // Clear empty rows
            empty_rows = 7 - display_length;
            index = display_length;

            freesat.console.log('EMPTY ROWS: ' + empty_rows);

            for (i = 0; i < empty_rows; i++) {

                try {
                    nowElement = pageGrid.get('now' + freesat.behind.page + '_' + (index + 1));
                    nowElement.setProgrammeData();
                    nextElement = pageGrid.get('next' + freesat.behind.page + '_' + (index + 1));
                    nextElement.setProgrammeData();
                } catch (e) {
                    freesat.console.log('tvguide.populateNowNext a : '+e);
                }
                index += 1;
            }


        }

        if (freesat.behind.hasNowNext) { // Use existing
            freesat.console.log('USE EXISTING');

            for (i = 0; i < display_length; i++) {
                index = i + indexAdjust;

                allEvents = nowNextData[index];
                if (allEvents) {
                    try{
                        nowData = allEvents[0];
                        nowElement = pageGrid.get('now' + freesat.behind.page + '_' + (i + 1));

                        if (nowData) {
                            nowData.isNow = true;
                        } else {
                            freesat.console.log('NO NOW DATA: ' + index);
                        }

                        if (nowElement) {
                            nowElement.setProgrammeData(nowData);
                        } else {
                            freesat.console.log('NO NOW ELEMENT: ' + i);
                        }

                        nextData = allEvents[1];
                        nextElement = pageGrid.get('next' + freesat.behind.page + '_' + (i + 1));
                        nextData.isNow = false;
                        nextElement.setProgrammeData(nextData);
                    } catch (e) {
                        freesat.console.log('tvguide.populateNowNext b : '+e);
                        nowContainer = pageGrid.get('epgNowContainer'+freesat.behind.page);
                        nextContainer = pageGrid.get('epgNextContainer'+freesat.behind.page);
                        nowData = allEvents[0];
                        nextData = allEvents[1];
                        this.createItem.nowNextItem(nowData, nowContainer, i, true);
                        this.createItem.nowNextItem(nextData, nextContainer, i, false);
                    }
                }
            }
        } else { // Create new
            freesat.console.log('CREATE NEW');
            nowContainer = this.createItem.nowNextContainer(true);
            nextContainer = this.createItem.nowNextContainer(false);

            for (i = 0; i < display_length; i++) {
                index = i + indexAdjust;
                allEvents = nowNextData[index];
                if (allEvents) {
                    nowData = allEvents[0];
                    this.createItem.nowNextItem(nowData, nowContainer, i, true);
                    nextData = allEvents[1];
                    this.createItem.nowNextItem(nextData, nextContainer, i, false);
                }
            }

            pageGrid.attach(nowContainer);
            pageGrid.attach(nextContainer);
        }


        if (!freesat.behind.hasNowNext || freesat.behind.filter.isVisible) {
            freesat.behind.channelUtils.createChannelBar(display_length, indexAdjust);
        }


        if (freesat.behind.isPageUp) {
            prepend = true;
        }

//        if (!grid_exists) {
            freesat.behind.nowNextGrid.attach(pageGrid, prepend);
//        }

        if (freesat.behind.filter.isVisible) {
            freesat.behind.filter.toggleMenu();
        }

        if (freesat.behind.tapPageUp) {
            setTimeout(function() {
                freesat.behind.setItemFocus();
            }, 25);
            freesat.behind.tapPageUp = false;
        } else {
            freesat.behind.setItemFocus();
        }

        if (freesat.behind.updateGenreTitle) {
            freesat.behind.get('channelFilterLabel').setText(freesat.behind.filter.genres[freesat.behind.filter.selected]);
            freesat.behind.updateGenreTitle = false;
        }
        freesat.behind.hasNowNext = true;
        freesat.behind.animationClass.AM_ScreenView();
    },

    updateNowNext: function(){
        var i, nowItem, nextItem,
            len = freesat.behind.pageRows,
            nowNextData = freesat.dataStore.allData.nowNextAll;

        freesat.console.log('updateNowNext');

        if (freesat.behind.isGenreList) {
            nowNextData = freesat.dataStore.allData.nowNextGenre;
        }

        for(i = 0; i < len; i++){
            try{
                nowItem = freesat.behind.get('now' + freesat.behind.page + '_' + (i + 1));
                nowItem.setProgrammeData(nowNextData[i+freesat.behind.topPositionIndex][0]);
                nextItem = freesat.behind.get('next' + freesat.behind.page + '_' + (i + 1));
                nextItem.setProgrammeData(nowNextData[i+freesat.behind.topPositionIndex][1]);
            } catch (e) {
                freesat.console.log('tvguide.updateNowNext : '+e);
            }
        }
    },

    setItemFocus: function() {
        if(freesat.behind.gridIsSetup){
            var element, selector;

            if (freesat.behind.pageRows <= freesat.behind.row) {
                freesat.behind.row = (freesat.behind.pageRows - 1);
            }
            selector = freesat.behind.column + freesat.behind.page + '_' + (freesat.behind.row + 1);
            if(document.getElementById(selector)){
                freesat.behind.get(selector).setFocus();
                freesat.behind.channelUtils.highlightChannel();
                freesat.behind.channelUtils.channelCheck();
            }
            freesat.console.log('item focused : ' + selector + ' : FTVG Ready for user');
            try{
                window.ftvgOnly = null;
                element = document.getElementById('ftvgContainer');
                element.parentNode.removeChild(element);
                freesat.console.log('ftvgContainer : removed');
                document.getElementById('video').style.zIndex = 10;
            }catch(e){

            }
        }
    },

    earlierGridSetup: function () {
        freesat.behind.earlierFunc.earlierGridSetup();
    },
    populateEarlier: function(freshDrawn) {
        freesat.behind.earlierFunc.populateEarlier(freshDrawn);
    },

    onNowLaterDataFirstCallback: function(channelIndex, startday, starthour, numberofhours) {
        freesat.behind.laterFunc.onNowLaterDataFirstCallback(channelIndex, startday, starthour, numberofhours);
    },
    onLaterPagingCallback: function(channelIndex, startday, starthour, numberofhours) {
        freesat.behind.laterFunc.onLaterPagingCallback(channelIndex, startday, starthour, numberofhours);
    },
    onLaterPageDownCallback: function(channelIndex, startday, starthour, numberofhours) {
        freesat.behind.laterFunc.onLaterPageDownCallback(channelIndex, startday, starthour, numberofhours);
    },
    onLaterPageUpCallback: function(channelIndex, startday, starthour, numberofhours) {
        freesat.behind.laterFunc.onLaterPageUpCallback(channelIndex, startday, starthour, numberofhours);
    },
    onLaterGenreCallback: function(channelIndex, startday, starthour, numberofhours) {
        freesat.behind.laterFunc.onLaterGenreCallback(channelIndex, startday, starthour, numberofhours);
    },
    onPlus24DataFirstCallback: function(channelIndex, startday, starthour, numberofhours) {
//        var lastGridX = freesat.behind.gridX - 1;
        freesat.console.log('onPlus24DataFirstCallback');
        freesat.behind.gridX++;

        if (document.getElementById('laterProgrammeItemContainer')) {
            freesat.behind.laterProgrammeItemContainer = freesat.behind.get('laterProgrammeItemContainer').detach();
        } else {
            freesat.behind.laterProgrammeItemContainer = new accedo.ui.Container({
                id: '#laterProgrammeItemContainer',
                css: 'laterProgrammeItemContainer'
            });
        }
        freesat.behind.animationClass.AM_ScreenView();
        
//        freesat.behind.laterProgrammeItemContainer = new accedo.ui.Container({
//            id: '#laterProgrammeItemContainer' + freesat.behind.gridX,
//            css: 'laterProgrammeItemContainer' // later-off-right transition-horizontal
//        });
//        freesat.behind.timestrip = new accedo.ui.Container({
//            id: '#straplineTimeStrip' + freesat.behind.gridX,
//            css: 'laterTimeStrip' //  later-off-right
//        });

        // Remove existing programmes and timestrip
//        if (freesat.behind.hasLater) {
//
//            if (document.getElementById('laterProgrammeItemContainer' + lastGridX)) {
//                freesat.behind.get('laterProgrammeItemContainer' + lastGridX).detach();
//            }
//
////            if (document.getElementById('straplineTimeStrip' + lastGridX)) {
////                freesat.behind.get('straplineTimeStrip' + lastGridX).detach();
////            }
//        }

        // Create new
//        freesat.behind.createItem.createLaterTimeStrip();
        freesat.behind.laterFunc.populateLater(false, channelIndex, startday, starthour, numberofhours);
//        freesat.behind.straplineTimeStripMask.attach(freesat.behind.timestrip);
        freesat.behind.laterProgrammeItemMask.attach(freesat.behind.laterProgrammeItemContainer);

        // Set variable states
        freesat.behind.hasLater = true;
        freesat.behind.isSetLaterFocus = false;
        freesat.isAnimating = false;
        freesat.behind.laterFunc.setLaterFocus('plus24');
//        freesat.behind.animationClass.isLaterLoaded = true;

//        if (freesat.behind.laterAniCallback) {
//            freesat.behind.laterAniCallback();
//            freesat.behind.laterAniCallback = null;
//        }
    },

    onMinus24DataFirstCallback: function(channelIndex, startday, starthour, numberofhours) {
        freesat.behind.gridX++;
        freesat.behind.laterProgrammeItemContainer = new accedo.ui.Container({
            id: '#laterProgrammeItemContainer' + freesat.behind.gridX,
            css: 'laterProgrammeItemContainer' //  later-off-left transition-horizontal
        });
        freesat.behind.timestrip = new accedo.ui.Container({
            id: '#straplineTimeStrip' + freesat.behind.gridX,
            css: 'laterTimeStrip' // later-off-left
        });

        // Remove existing programmes and timestrip
        freesat.behind.get('laterProgrammeItemContainer' + (freesat.behind.gridX - 1)).detach();
        freesat.behind.get('straplineTimeStrip' + (freesat.behind.gridX - 1)).detach();

        // Create new
        freesat.behind.createItem.createLaterTimeStrip();
        freesat.behind.laterFunc.populateLater(false, channelIndex, startday, starthour, numberofhours);
        freesat.behind.straplineTimeStripMask.attach(freesat.behind.timestrip);
        freesat.behind.laterProgrammeItemMask.attach(freesat.behind.laterProgrammeItemContainer);

        // Set variable states
        freesat.behind.isSetLaterFocus = false;
        freesat.isAnimating = false;
        freesat.behind.laterFunc.setLaterFocus('plus24');
//        freesat.behind.animationClass.isLaterLoaded = true;

//        if (freesat.behind.laterAniCallback) {
//            freesat.behind.laterAniCallback();
//            freesat.behind.laterAniCallback = null;
//        }
    },

    handleLaterToEarlier: function() {
        if (freesat.behind.day === 0) {
            freesat.behind.animationClass.startLaterToEarlier(); // firstStepAniLaterToEarlier();
        }
    },

    handleLaterToEarlierLater: function() {
        freesat.console.log('handle callback later to earlier later');
        freesat.behind.animationClass.startLaterToLater('earlier-later'); // firstStepAniLaterToEarlierLater();
    },

    handleLaterToLater: function() {
        freesat.behind.animationClass.startLaterToLater('later-later'); // firstStepAniLaterToLater();
    },
    setNowGridStartTime: function() {
        var now = Math.round(new Date().getTime() / 1000.0);
        this.gridStartTime = (Math.floor(now/1800)) * 1800;
        this.nowStartTime = this.gridStartTime;
    },

    setHeader: function(button, avoidRetry) {
        if (freesat.header) {
            if (freesat.behind.headerTimeout) clearTimeout(freesat.behind.headerTimeout);
            if (freesat.behind.controllerLoadedInterval !== null) clearInterval(freesat.behind.controllerLoadedInterval);
            if (!button) button = freesat.behind.currentButton;
            freesat.behind.headerTimeout = setTimeout(function () {
                freesat.header.setNow(button._data);
            }, 150);
        } else {
            if (!avoidRetry) {
                freesat.behind.controllerLoadedInterval = setInterval(function () {
                    freesat.behind.headerController.navigate("freesat.controllers.subcontrollers.Header");
                    freesat.behind.setHeader(button, true);
                }, 100);
            }
        }
    },
    setEarlierHeader: function(button, avoidRetry) {
        if (!button) button = freesat.behind.currentButton;
        if (freesat.header) {
            freesat.header.setEarlier(button._data);
            if (freesat.behind.controllerLoadedInterval !== null) {
                clearInterval(freesat.behind.controllerLoadedInterval);
            }
        } else {
            if (!avoidRetry) {
                freesat.behind.controllerLoadedInterval = setInterval(function () {
                    freesat.behind.headerController.navigate("freesat.controllers.subcontrollers.Header");
                    freesat.header.get('header').removeClass('now-page').addClass('earlier-page');
                    freesat.behind.setEarlierHeader(button, true);
                }, 100);
            }
        }
    },

    resetHeader: function() {
        if (freesat.header) {
            if (freesat.getZone() === 'now' || freesat.getZone() === 'later') {
                freesat.header.unsetNow();
            } else if (freesat.getZone() === 'earlier') {
                freesat.header.unsetEarlier();
            }
        }
    },

    setFooter: function(doItNow) {
        var opts = freesat.behind.footerOpts;
        if (freesat.footer) {
            freesat.footer.set(opts);

            if (freesat.behind.footerLoaded !== null) {
                clearTimeout(freesat.behind.footerLoaded);
            }
        } else {
            if (doItNow) {
                freesat.behind.footerController.navigate("freesat.controllers.subcontrollers.Footer");
                freesat.behind.footerButtons = freesat.behind.get('footer');
                freesat.behind.setFooter();
            } else {
                freesat.behind.footerLoaded = setTimeout(function () {
                    freesat.behind.footerController.navigate("freesat.controllers.subcontrollers.Footer");
                    freesat.behind.footerButtons = freesat.behind.get('footer');
                    freesat.behind.setFooter();
                }, 100);
            }
        }
    },

    highlightLeftArrow: function() {
        freesat.behind.rightArrow.deactivateFocus();
        freesat.behind.leftArrow.activateFocus();
    },

    highlightRightArrow: function() {
        freesat.behind.leftArrow.deactivateFocus();
        freesat.behind.rightArrow.activateFocus();
    },

    setArrowLabels: function() {
        var leftText, rightText;
        switch (freesat.getZone()) {
            case 'earlier':
                leftText = 'earlier';
                rightText = 'now';
                freesat.behind.highlightRightArrow();
                break;
            case 'now':
                leftText = 'earlier';
                rightText = 'later';
                freesat.behind.highlightLeftArrow();
                break;
            case 'later':
                leftText = 'earlier';
                rightText = 'later';
                break;
        }
        freesat.behind.leftArrow.setText(leftText);
        freesat.behind.rightArrow.setText(rightText);
    },

    createButtonElement: function(text, id, left, top, width, height, nLeft, nRight, nDown, nUp) {
        var obj = {
            id: '#' + id,
            css: 'testBtn',
            text: text
        };
        if (nUp) {
            obj.nextUp = nUp;
        }
        if (nDown) {
            obj.nextDown = nDown;
        }
        if (nRight) {
            obj.nextRight = nRight;
        }
        if (nLeft) {
            obj.nextLeft = nLeft;
        }
        var ele = new accedo.ui.widget.Button(obj);
        freesat.behind.elementContainer.attach(ele);
        ele.root.setStyle({
            'top': String(top) + 'px',
            'left': String(left) + 'px',
            'width': String(width) + 'px',
            'height': String(height) + 'px',
            'background-color': '#123456',
            'position': 'absolute'
        });
        return ele;
    },

    reset: function() {
        clearInterval(freesat.pageTTLinterval);
    },

    setEarlierPictureFocus: function() {

        if (freesat.behind.hasEarlierPromo) {
            freesat.console.log('SET FOCUS PROMO IMAGE');
            setTimeout(function() {
                freesat.behind.get('promoImage0').setFocus();
            }, 25);

        }
    },

    setEarlierFocus: function() {
        freesat.behind.column = 'earlier';
        setTimeout(function() {
            freesat.behind.get('programmeGridItem_' + freesat.behind.row).setFocus();
        }, 25);
    },

    handleEarlierEarlier: function() {

        if ((-freesat.behind.day) < (freesat.dataStore.allData.earlierAll[freesat.behind.freesatServiceID].length - 1)) {
            freesat.behind.day -= 1;
            freesat.behind.animationClass.firstStepAniEarlierMinus24Hours();
        }
    },

    createEarlierChannelList: function() {
        var chList, display_length;

        freesat.console.log('starting  assignCCIDtoTSTVchannels');
        freesat.channelData.assignCCIDtoTSTVchannels();
        freesat.console.log('finishing assignCCIDtoTSTVchannels');
        chList = freesat.channelData.returnCUTVchannellist();
        freesat.behind.earlierChannelList = chList;
        display_length = (chList.length > freesat.behind.PAGE_ITEMS) ? freesat.behind.PAGE_ITEMS : chList.length;

        freesat.behind.earlierTopPositionIndex = Math.floor(chList.indexOf(String(freesat.behind.highlightedChannelId))/7) * 7;
        freesat.behind.earlierChannelRow = chList.indexOf(String(freesat.behind.highlightedChannelId)) % 7;

        freesat.behind.channelUtils.createChannelBar(display_length, freesat.behind.earlierTopPositionIndex);
        freesat.isAnimating = false;
        freesat.behind.rightArrow.deactivateFocus();
        freesat.behind.channelUtils.highlightGivenChannel(freesat.behind.earlierChannelRow);
    },

    hideFocus: function() {
        // Remove current highlight
        try {
            freesat.behind.get('hidden-button').setFocus();
        } catch (e) {
            freesat.console.log('ERROR - Cannot find hidden focus: ' + e );
        }
    },

    onKey: function(vKey) {
        freesat.behind.createTTLinterval();
        if (!freesat.isAnimating) {
            var keyHandling = new freesat.controllers.tvguide.KeyHandler();
            return keyHandling.onKey(vKey);
        }
        return false;
    },

    getAM_urlParam: function(){

        if (this.animationClass.getAM_urlParam){
            return this.animationClass.getAM_urlParam();
        }
    }
});
