/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */

"use strict";

const Cc = Components.classes;
const Ci = Components.interfaces;
const Cu = Components.utils;

this.EXPORTED_SYMBOLS = ["PanaServerUrlInternal"];

Cu.import("resource://gre/modules/Services.jsm");
Cu.import("resource://gre/modules/XPCOMUtils.jsm");
Cu.import("resource://gre/modules/FileUtils.jsm");

XPCOMUtils.defineLazyModuleGetter(this, "NetUtil",
  "resource://gre/modules/NetUtil.jsm");

this.PanaServerUrlInternal = {
  _serverURL: null,
  _latestURL: null,
  _mhcXpanaHttps: null,
  _mhcSecHttp: null,
  _mhcSecHttps: null,
  init: function() {
    // initialize of serverURL
//@line 29 "/home/builder/auto-build/GBL16MT5595/work.04111431_v3232/newarch/usr/src/b2g/b2g/gecko/dom/panatv/serverurl/PanaServerUrl.jsm"
    let file = new FileUtils.File('/etc/server_url')
//@line 33 "/home/builder/auto-build/GBL16MT5595/work.04111431_v3232/newarch/usr/src/b2g/b2g/gecko/dom/panatv/serverurl/PanaServerUrl.jsm"
    if (!file || !file.exists()) {
      return;
    }

    let fis = Cc["@mozilla.org/network/file-input-stream;1"].createInstance(Ci.nsIFileInputStream);
    fis.init(file, -1, 0, 0);
    let data = NetUtil.readInputStreamToString(fis, fis.available(), {charset:"UTF-8"});
    if (!data) {
      return;
    }

    if (data.match("^ajaxurl (.+)$", "m")) {
      let ret = data.match("^ajaxurl (.+)$", "m");
      this._serverURL = ret[1];
    }

    if (data.match("^latesturl (.+)$", "m")) {
      let ret = data.match("^latesturl (.+)$", "m");
      this._latestURL = ret[1];
    }

    if (data.match("^mhc_xpana_https (.+)$", "m")) {
      let ret = data.match("^mhc_xpana_https (.+)$", "m");
      this._mhcXpanaHttps = ret[1];
    }

    if (data.match("^mhc_sec_http (.+)$", "m")) {
      let ret = data.match("^mhc_sec_http (.+)$", "m");
      this._mhcSecHttp = ret[1];
    }

    if (data.match("^mhc_sec_https (.+)$", "m")) {
      let ret = data.match("^mhc_sec_https (.+)$", "m");
      this._mhcSecHttps = ret[1];
    }

  },

  get serverURL() {
    return this._serverURL;
  },

  get latestURL() {
    return this._latestURL;
  },

  get mhcXpanaHttps() {
    return this._mhcXpanaHttps;
  },

  get mhcSecHttp() {
    return this._mhcSecHttp;
  },

  get mhcSecHttps() {
    return this._mhcSecHttps;
  }
}

PanaServerUrlInternal.init();
