/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* Copyright (c) 2014 Panasonic Corporation */

/* This Source Code Form is "Incompatible With Secondary Licenses",
 * as defined by the Mozilla Public License, v. 2.0. */

"use strict";

const DEBUG = false;
function debug(s) {
  if (DEBUG) dump("-*- ModelDataInternal: " + s + "\n");
}

const Cc = Components.classes;
const Ci = Components.interfaces;
const Cu = Components.utils;

const MODELDATA_FILE_PATH = "/tmp/modeldata.json";

this.EXPORTED_SYMBOLS = ["ModelDataInternal"];

Cu.import("resource://gre/modules/XPCOMUtils.jsm");
Cu.import("resource://gre/modules/NetUtil.jsm");
Cu.import("resource://gre/modules/FileUtils.jsm");

this.ModelDataInternal = {
  init: function() {
    debug('init ()');
    this.readfile();

    this._tvconfiguration = Cc["@mozilla.org/dom/tvconfigurationManager;1"].createInstance(Ci.nsITVConfigurationManager);
  },

  readfile: function() {
    debug('readfile()');
    let file = new FileUtils.File(MODELDATA_FILE_PATH);
    if (!file || !file.exists()) {
      return;
    }

    let fis = Cc["@mozilla.org/network/file-input-stream;1"].createInstance(Ci.nsIFileInputStream);
    fis.init(file, -1, -1, Ci.nsIFileInputStream.CLOSE_ON_EOF);
    let data = NetUtil.readInputStreamToString(fis, fis.available(), {charset:"UTF-8"});
    if (!data) {
      return;
    }

    try {
      this._modeldata = JSON.parse(data);
    } catch(e) {
      if (DEBUG) debug("Error parsing " + MODELDATA_FILE_PATH + " : " + e);
      return;
    }
  },

  get data() {
    debug('get data');
    return this._modeldata;
  },

  get: function get(aName) {
    debug("get - name:" + aName);

    //At first, check the json file
    if (this._modeldata.hasOwnProperty(aName)) {
      return this._modeldata[aName];
    }

    //Second, get from TVconfiguration module 
    if (this._tvconfiguration.isValidConfigurationName(aName)) {
      return this._tvconfiguration.getData(aName);
    }
  }
};

ModelDataInternal.init();
