/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */

'use strict';

this.EXPORTED_SYMBOLS = ['InputDeviceSetting'];

const Cu = Components.utils;
const Cc = Components.classes;
const Ci = Components.interfaces;

Cu.import('resource://gre/modules/Services.jsm');
Cu.import("resource://gre/modules/XPCOMUtils.jsm");

XPCOMUtils.defineLazyServiceGetter(this, "ppmm",
				   "@mozilla.org/parentprocessmessagemanager;1",
				   "nsIMessageBroadcaster");

XPCOMUtils.defineLazyServiceGetter(this, "cpmm",
                                   "@mozilla.org/childprocessmessagemanager;1",
                                   "nsIMessageSender");

this.InputDeviceSetting = {

  init: function InputDeviceSettingInit() {
    //dump("InputDeviceSetting.js inint!!!!\n");	
    ppmm.addMessageListener("InputDeviceSetting:MouseMode", this);
    ppmm.addMessageListener("InputDeviceSetting:DragMode", this);
    ppmm.addMessageListener("InputDeviceSetting:TouchPadMode", this);
    ppmm.addMessageListener("InputDeviceSetting:RemoteArrowKeyMode", this);
    ppmm.addMessageListener("InputDeviceSetting:KeyboardArrowKeyMode", this);
    ppmm.addMessageListener("InputDeviceSetting:MouseMode:Request", this);
    ppmm.addMessageListener("InputDeviceSetting:DragMode:Request", this);
    ppmm.addMessageListener("InputDeviceSetting:TouchPadMode:Request", this);
    ppmm.addMessageListener("InputDeviceSetting:RemoteArrowKeyMode:Request", this);
    ppmm.addMessageListener("InputDeviceSetting:KeyboardArrowKeyMode:Request", this);
  },

  receiveMessage: function InputDeviceSettingReceiveMessage(msg) {
    //dump("receiveMessage" + msg.name + ":" + msg.json + "\n");
    switch (msg.name) {
    case "InputDeviceSetting:MouseMode":
      Services.obs.notifyObservers(null, "mouse-mode-changed", msg.json.mode);
	  break;
    case "InputDeviceSetting:DragMode":
      Services.obs.notifyObservers(null, "drag-emulate-mode-changed", msg.json.mode);
	  break;
    case "InputDeviceSetting:TouchPadMode":
      Services.obs.notifyObservers(null, "touchpad-emulate-mode-changed", msg.json.mode);
      break;
    case "InputDeviceSetting:RemoteArrowKeyMode":
      Services.obs.notifyObservers(null, "remote-arrow-key-emulate-mode-changed", msg.json.mode);
      break;
    case "InputDeviceSetting:KeyboardArrowKeyMode":
      Services.obs.notifyObservers(null, "keyboard-arrow-key-emulate-mode-changed", msg.json.mode);	  
	  break;
	  
    case "InputDeviceSetting:MouseMode:Request":
    case "InputDeviceSetting:DragMode:Request":
    case "InputDeviceSetting:TouchPadMode:Request":
    case "InputDeviceSetting:RemoteArrowKeyMode:Request":
    case "InputDeviceSetting:KeyboardArrowKeyMode:Request":
      Services.obs.notifyObservers(null, "pana-inputdevicesetting-request",
								   JSON.stringify({
									 type:msg.name,
									 mode:msg.json.mode,
									 manifestURL:msg.json.manifestURL,
									 origin:msg.json.origin
								   })
								  );
	  break;
    }
  },  
};

this.InputDeviceSetting.init();
