/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */

"use strict";

const DEBUG = false;
function debug(s) {
  if (DEBUG) dump("-*- [InputDeviceSetting]: " + s + "\n");
}
/*
let console = {
  log: debug
};
*/

const Cc = Components.classes;
const Ci = Components.interfaces;
const Cu = Components.utils;
const CC = Components.Constructor;
const Cr = Components.results;

Cu.import("resource://gre/modules/XPCOMUtils.jsm");
Cu.import("resource://gre/modules/Services.jsm");

/*
var fm = Cc["@mozilla.org/focus-manager;1"].
    getService(Ci.nsIFocusManager);
*/

XPCOMUtils.defineLazyServiceGetter(this, "cpmm",
  "@mozilla.org/childprocessmessagemanager;1", "nsIMessageSender");

XPCOMUtils.defineLazyServiceGetter(this, "fm",
                                   "@mozilla.org/focus-manager;1",
                                   "nsIFocusManager");

function InputDeviceSetting() {
  this.wrappedJSObject = this;
}

InputDeviceSetting.prototype = {
  _hasPermission: false,
  _appStatus: null,
  _wrap: function _wrap(obj) {
    return ObjectWrapper.wrap(obj, this._window);
  },
  
  init: function(aWindow) {
    //debug("input eumulate init");
    //debug(aWindow.document.nodePrincipal);
    let appsService = Cc["@mozilla.org/AppsService;1"]
                        .getService(Ci.nsIAppsService);
    let app = appsService.getAppByLocalId(aWindow.document.nodePrincipal.appId);
    this.manifestURL = app.manifestURL;
    this.origin = app.origin;
    
    //debug("[@]" + this.manifestURL + "[:]" + this.origin + "\n");

    let perm = Services.perms.testExactPermissionFromPrincipal(aWindow.document.nodePrincipal,
                                                               "pana-ext");
    if (perm === Ci.nsIPermissionManager.ALLOW_ACTION) {
      this._hasPermission = true;
    }
    this._appStatus = aWindow.document.nodePrincipal.appStatus;
    this._window = aWindow;
  },
  _canSet: function() {
    if (!this._hasPermission) {
      return false;
    }
    if (this._appStatus == Ci.nsIPrincipal.APP_STATUS_CERTIFIED) {
      return true;      
    }

    if (this._appStatus == Ci.nsIPrincipal.APP_STATUS_PRIVILEGED) {
        return true; 
    }
    return false;
  },

  sendMessage: function(msg, mode) {
    if (!this._canSet()) {
      //debug("set error");
      return; 
    }
    var data = {
      mode:mode
    };
    if (this._appStatus !== Ci.nsIPrincipal.APP_STATUS_CERTIFIED) {
      data.manifestURL = this.manifestURL;
      data.origin = this.origin;
      msg = msg + ":Request";
    }
    cpmm.sendAsyncMessage(msg, data);  
  },
  
  setMouseMode: function(mode) {
    this.sendMessage('InputDeviceSetting:MouseMode', mode);
  },
  
  setDragMode: function(mode) {
    this.sendMessage('InputDeviceSetting:DragMode', mode);
  },
    
  setTouchPadMode: function(mode) {
    this.sendMessage('InputDeviceSetting:TouchPadMode', mode);
  },

  setRemoteArrowKeyMode: function(mode) {
    this.sendMessage('InputDeviceSetting:RemoteArrowKeyMode', mode);
  },

  setKeyboardArrowKeyMode: function(mode) {
    this.sendMessage('InputDeviceSetting:KeyboardArrowKeyMode', mode);    
  },
  set onrequest(handler) {
    if (this._appStatus == Ci.nsIPrincipal.APP_STATUS_CERTIFIED) {
      this.__DOM_IMPL__.setEventHandler("onrequest", handler);
    } else {

    }
  },
  get onrequest() {
    if (this._appStatus == Ci.nsIPrincipal.APP_STATUS_CERTIFIED) {
      return this.__DOM_IMPL__.getEventHandler("onrequest");
    } else {
      return null;
    }
  },
  classID: Components.ID("{1eb55bac-05ef-11e4-9ab6-6805ca00bbeb}"),
  contractID: "@mozilla.org/InputDeviceSetting;1",
  QueryInterface: XPCOMUtils.generateQI([Ci.nsISupports,
                                         Ci.nsIDOMGlobalPropertyInitializer])
};

this.NSGetFactory = XPCOMUtils.generateNSGetFactory([InputDeviceSetting]);
