//
// Copyright (C) 2009 Panasonic Corporation. All Rights Reserved.
//

var DEMO_MODE = true;
var DEMO_VIDEO_URL = path + "skype/"
  + function(){
    switch( system.locale.country ){
    case "00":
    case "SG":
    case "ID":
      return "demo-asia.mp4";
    default:
      return "demo.mp4";
    }
  }();
var DEMO_CANADA_FRENCH = (system.locale.language == "fr-CA");
var DEMO_USER_ID = "Clint1644";
var DEMO_DISCLAIMER = DEMO_CANADA_FRENCH ? "Avec cette application, une connexion Internet et une caméra de communication pour VIERA sont requises." :
  "To use this application, an Internet connection and a Communication Camera for VIERA are required.";


//try {

const ENABLE_EBUS = DEMO_MODE ? false : true;
const ENABLE_FAKE_VIDEO = DEMO_MODE ? true : false;

// SKYPE REQUEST COMMANDS
var sk_cnt = 0;
const SKYPE_LOGIN = sk_cnt++;
const SKYPE_LOGOUT = sk_cnt++;
const SKYPE_PLACE_CALL = sk_cnt++;
const SKYPE_END_CALL = sk_cnt++;
const SKYPE_ANSWER_CALL = sk_cnt++;
const SKYPE_START_VIDEO = sk_cnt++;
const SKYPE_STOP_VIDEO = sk_cnt++;
const SKYPE_GET_CONTACT_LIST = sk_cnt++;
const SKYPE_RESET_VIDEO = sk_cnt++;
const SKYPE_GET_HISTORY_LIST = sk_cnt++;
const SKYPE_GET_AVAILABILITY = sk_cnt++;
const SKYPE_GET_CREDIT = sk_cnt++;

// SKYPE_EVENT
sk_cnt = 2;
//const SKYPE_CONNECTED_EV = sk_cnt++;
//const SKYPE_DISCONNECTED_EV = sk_cnt++;
const SKYPE_ON_NEW_CALL_EV = sk_cnt++;
const SKYPE_CONTACT_LIST_EV = sk_cnt++;
const SKYPE_WAITING_ANSWER_EV = sk_cnt++;
const SKYPE_WAITING_ANSWER_WITH_VIDEO_EV = sk_cnt++;
const SKYPE_CALL_MEMBER_ON_CHANGE_EV = sk_cnt++;
const SKYPE_DETAIL_ALL_EV = sk_cnt++;
const SKYPE_DETAIL_CONTACTS_EV = sk_cnt++;
const SKYPE_DETAIL_PRIVATE_EV = sk_cnt++;
const SKYPE_GET_AVAILABILITY_EV = sk_cnt++;
const SKYPE_GET_CREDIT_EV = sk_cnt++;
const SKYPE_HISTORY_LIST_EV = sk_cnt++;
const SKYPE_STATUS_EV = sk_cnt++;
const SKYPE_NOTIFY_CONTACT_ON_CHANGE_EV = sk_cnt++;

var def_settings;
var def_history;
var def_account;
var def_add_contact;
var def_add_contact_result_list;
var def_find_contact_result_list;
var def_settings_video;
var def_settings_sound;
var def_settings_profile;
var def_settings_calls;
var def_settings_privacy;
var def_settings_connection;
var def_settings_advanced;
var def_history_list;

var def_call_fullscreen_cmd;

// utilities
var extend = function(destination, source) {
  for (var property in source)
    destination[property] = source[property];
};

var sk_setf_text = function(obj, str, offset) {
  obj.width = get_text_width(obj, str);
  setf_text(obj, str);
  if (offset != null) obj.translate[0] = offset + obj.width/2;
};

var make_common_obj = function() {

  MyHostName = "http://192.168.0.100:8000/";
  path = MyHostName + "data/";

  common_key = {};
  common_key.set_cursor = function(sobj, cobj){
    var old = sobj.cursor;
    if (old == cobj)
      return;
    if (old) {
      if (old.leave_focus)
        old.leave_focus (old);
      old.in_cursor = false;
      old.toggle_cursor = false;
    }
    if (cobj) {
      if (cobj.enter_focus)
        cobj.enter_focus (cobj);
      cobj.in_cursor = true;
    }
    sobj.cursor = cobj;
  };
};


if (typeof ureg == "undefined") {
  make_common_obj();
}

const STAGE_BACKGROUND_COLOR = [0,175,240,255];
const LIST_ITEM_BG_HEIGHT = 160;
const LIST_ITEM_FOCUS = [181,231,181,255];
const LIST_ITEM_UNFOCUS = [90,198,239,255];
const LIST_ITEM_BACK_TO = [192,192,192,255];

const CONFIG_SUBCMD_NUM = 10;
const BACK_TO_TEXT = "Back to Profile";

var enable_keyhook = false;

var http_request_handler = { handler:{}, };
http_request_handler.get = function(param, id) {
  this.cancel(id);
  this.query = {
    url:param.url,
    method:"GET",
    header:"",
    sync:param.sync,
    onload:function(status, header, body) {
      try {
        if (typeof param.prepare == "function") {
          param.prepare(body);
        } else {
          eval(body);
        }
        if (typeof param.hook == "function") param.hook();
      } catch (e) {
        console.log("[ERROR] <" + e.name + "> " + e.message);
      }
    },
  };
  this.handler[id] = http_request(this.query);
};
http_request_handler.cancel = function(id) {
  if (this.handler[id]) {
    console.log("[cancel]", id);
    cancel_http_request(this.handler[id]);
  }
};

var def_sub_cmd = {
  contact_list : [
    { icon:path+"skype/img/Calls.png", label:DEMO_CANADA_FRENCH ? "Appeler" : "Call",
      action:function() {
	if( DEMO_MODE ) return;
        start_call(scroll_list_manager.get_current_id(), "voice");
      }, },
    { icon:path+"skype/img/Calls.png", label: DEMO_CANADA_FRENCH ? "Vidéoconférence" : "Video Call",
      action:function() {
	if( DEMO_MODE ){
	  if( scroll_list_manager.get_current_id() != DEMO_USER_ID ){
	    return;
	  }
	}
        start_call(scroll_list_manager.get_current_id(), "video");
      } },
    { icon:path+"skype/img/info.png", label: DEMO_CANADA_FRENCH ? "Afficher le profil" : "View Profile",
      action:function() {
	if( DEMO_MODE ) return;
      }, },
    { icon:path+"skype/img/trash.png", label: DEMO_CANADA_FRENCH ? "Retirer" : "Remove",
      action:function() {
	if( DEMO_MODE ) return;
      }, },
    { icon:path+"skype/img/block_contact.png", label: DEMO_CANADA_FRENCH ? "Bloquer" : "Block",
      action:function() {
	if( DEMO_MODE ) return;
      }, },
    { icon:path+"skype/img/send_im.png",label: DEMO_CANADA_FRENCH ?  "Envoyer un message" : "Send IM",
      action:function() {
	if( DEMO_MODE ) return;
	scroll_list_manager.start_chat(scroll_list_manager.get_current_id(), "chat");
      } }
  ],
  history :[
    { icon:path+"skype/img/Calls.png", label:"Call",
      action:function() {
        start_call(scroll_list_manager.get_current_id(), "voice");
      }, },
    { icon:path+"skype/img/Calls.png", label:"Video Call",
      action:function() {
        start_call(scroll_list_manager.get_current_id(), "video");
      } },
    { icon:path+"skype/img/info.png", label:"View Profile", action:function() {}, },
    { icon:path+"skype/img/trash.png", label:"Delete", action:function() {}, },
    { icon:path+"skype/img/block_contact.png", label:"Block", action:function() {}, },
    { icon:path+"skype/img/send_im.png",label: "Send IM", action:function() {}, }
  ],
  add_contact : [
    { icon:path+"skype/img/add_contact.png", label:"Add contact",
      action:function() { }, },
    { icon:path+"skype/img/info.png", label:"View profile",
      action:function() { } },
    { icon:path+"skype/img/Calls.png", label:"Call",
      action:function() {
        input_area.disappear(function() {
          start_call(scroll_list_manager.get_current_id(), "voice");
        });
      }},
  ],
  find_contact :[
    { icon:path+"skype/img/add_contact.png", label:"Add contact",
      action:function() { }, },
    { icon:path+"skype/img/info.png", label:"View profile",
      action:function() { } },
    { icon:path+"skype/img/Calls.png", label:"Call",
      action:function() {
        input_area.disappear(function() {
          start_call(scroll_list_manager.get_current_id(), "voice");
        });
      }},
    { icon:path+"skype/img/block_contact.png", label:"Block", action:function() {}, },
  ],
  voicemail :[
    { icon:path+"skype/img/play_video.png", label:"Play",
      action:function() { }, },
    { icon:path+"skype/img/trash.png", label:"Delete",
      action:function() { } },
  ],
  authorization : [
    { icon:path+"skype/img/add_contact.png", label:"Accept",
      action:function() { }, },
    { icon:path+"skype/img/hide.png", label:"Ignore",
      action:function() { } },
    { icon:path+"skype/img/block_contact.png", label:"Block",
      action:function() { } },
  ],
  settings_privacy : [
    { icon:path+"skype/img/add_contact.png", label:"Add contact",
      action:function() { console.log("Add contact"); } },
    { icon:path+"skype/img/info.png", label:"View Profile",
      action:function() { console.log("View Profile"); } },
    { icon: path+"skype/img/Calls.png", label:"Call",
      action:function() {
        scroll_list_manager.detail = null;
        scroll_list_manager.detail_index = null;
        start_call(scroll_list_manager.get_current_id(), "voice");
      } },
    { icon:path+"skype/img/block_contact.png", label:"UnBlock",
      action:function() { console.log("UnBlock"); } },
  ],
}

var def_contact_list = [
  { id:"Clint1644", display_name:"Clint1644", icon:path+"skype/img/avatar_yura02.jpg", mood_text:"Lucky and happy today!!",
    status:"online", location: DEMO_CANADA_FRENCH ? "" : "United States",},
  { id:"nombre_AAA", display_name:"nombre_AAA", icon:path+"skype/img/avatar_dog.jpg", mood_text:"Ahora Estoy en Barcelona.",
    status:"offline", location: DEMO_CANADA_FRENCH ? "" : "Spain",},
  { id:"doux-couer", display_name:"doux-couer", icon:path+"skype/img/avatar_boy.jpg", mood_text:"Je suis de bonne humeur.",
    status:"away", location: DEMO_CANADA_FRENCH ? "" : "France",},
  { id:"Froher_Mann0212", display_name:"Froher_Mann0212", icon:path+"skype/img/avatar_dad.jpg", mood_text:"Ich bin jetzt so hungrig.",
    status:"offline", location: DEMO_CANADA_FRENCH ? "" : "Germany",},
  { id:"Ciber_la_Signora", display_name:"Ciber_la_Signora", icon:path+"skype/img/avatar_fish.jpg", mood_text:"Sta piovendo.",
    status:"do_not_disturb", location: DEMO_CANADA_FRENCH ? "" : "Italy" },
];

var def_voicemail_result_list = [
  { user:"skypeuser1", icon:path+"skype/img/angel_skype.png", date:"2001-08-02 10:45:23+09:00",  location:"Poway, United States", },
  { user:"skypeuser2", icon:path+"skype/img/desert_skype.png", date:"2001-08-02 10:45:23+09:00", location:"Barcelona, Spain", },
  { user:"skypeuser3", icon:path+"skype/img/devil_skype.png", date:"2001-08-02 10:45:23+09:00", location:"Zurich, Switzerland", },
  { user:"skypeuser4", icon:path+"skype/img/skype_headset.png", date:"2001-08-02 10:45:23+09:00", location:"Limerick, Ireland", },
  { user:"skypeuser5", icon:path+"skype/img/chrismas_skype.png", date:"2001-08-02 10:45:23+09:00", location:"China" },
  { user:"skypeuser6", icon:path+"skype/img/college_skype.png", date:"2001-08-02 10:45:23+09:00", location:"Sydney, Australia", },
  { user:"skypeuser7", icon:path+"skype/img/party_skype.png", date:"2001-08-02 10:45:23+09:00", location:"Poway, United States", },
  { user:"skypeuser8", icon:path+"skype/img/skype_aid.png", date:"2001-08-02 10:45:23+09:00", location:"Poway, United States", },
];

var def_authorization_result_list = [
  { user:"Skype User1 (skypeuser1)", icon:path+"skype/img/angel_skype.png", message:"I am feeling fantastic today :)", location:"Poway, United States",},
  { user:"Skype User2 (skypeuser2)", icon:path+"skype/img/devil_skype.png", message:"Wife wants food. Back soon.", location:"Barcelona, Spain",},
  { user:"Skype User3 (skypeuser3)", icon:path+"skype/img/chrismas_skype.png", message:"Blogging Til it Hurts", location:"Zurich, Switzerland"},
  { user:"Skype User4 (skypeuser4)", icon:path+"skype/img/college_skype.png", message:"Hey, I'm new and improved.", location:"Limerick, Ireland",},
  { user:"Skype User5 (skypeuser5)", icon:path+"skype/img/party_skype.png", message:"local golf champions, 3 years in a row!", location:"China"},
];

var def_account_result_list = [];

var def_status = [
  { icon:path+"skype/img/online.png", label:"Online"},
  { icon:path+"skype/img/do_not_disturb.png", label:"Do not disturb", },
  { icon:path+"skype/img/away.png", label:"Away", },
  { icon:path+"skype/img/offline.png", label:"Invisible", },
  { icon:path+"skype/img/offline.png", label:"Offline", },
  { icon:path+"skype/img/offline.png", label:"PendingAuth", },
];



function sphere(param) {
  param.icon = param.icon || "";
  param.label1 = param.label1 || "";
  param.label2 = param.label2 || "";
  param.toggle_src = param.toggle_src || "";
  param.toggle_label = param.toggle_label || "";
  param.action = param.action || function() { console.log("default action"); };
  param.type = param.type || "";

  switch(param.size) {
   case 80:
    this.frame_size = 180;
    break;
  default:
    this.frame_size = 286;
  }

  var label1_y;
  if (param.size == 80) {
    label1_y = -105;
  } else {
    label1_y = -85;
  }

  this.translate = param.translate;
  this.components = [
    this.act = new actor({ base_col_width:0, cursor_width:0, })
  ];
  this.act.bg_image = [
    this.sphere = new gbox({ width:Math.ceil(param.size*1.7), height:Math.ceil(param.size*1.7),
                             color:[0,0,0,20], round_enable:true,
                             round_width:Math.ceil(param.size*1.7/2), round_height:Math.ceil(param.size*1.7/2),
			   }),
    this.frame = new gimage({ width:this.frame_size, height:this.frame_size,
			      src:path+"skype/img/skypeframe.png", color:[181,231,181,255], visible_p:false, }),
    this.icon = new gimage({ width:param.size, height:param.size, src:param.icon, }),
    this.toggle_icon = new gimage({ width:100, height:100, src:param.toggle_src || "", visible_p:false }),
    this.toggle_label = new gtextbox({ width:250, height:80, text:param.toggle_label || "",
                                       translate:[0,label1_y,0],
                                       align:CENTER, valign:MIDDLE, visible_p:false }),
    this.label1 = new gtextbox({ width:250, height:80, text:param.label1, align:CENTER,
				 visible_p: !DEMO_CANADA_FRENCH,
                                 valign:MIDDLE, margin_leading:-10, translate:[0,label1_y,0], }),
    this.label2 = new gtext({ width:250, translate:[230,0,0], text:param.label2, align:LEFT, font_size:40 }),
    this.newly = new container({ visible_p:false, translate:[50,50,0], components:[
      this.newly_circle = new gbox({ width:40, height:40,  color:[255,0,0,255],
                                     round_enable:true, round_width:20, round_height:20, }),
      this.newly_text = new gtext({ width:30, align:CENTER, }),
    ] }),
  ];
  this.act.action = param.action;
  if( DEMO_MODE ){
    this.newly_circle.color[0] = 100;
    this.newly_text.color = [120,120,120,255];
    setf_text( this.newly_text, this.newly_text.text );
  }
};

function cmd_btn(index, translate, data) {
  data = data || {};

  this.index = index;
  this.translate = translate;
  this.components = [
    this.act = new actor({ base_col_width:0, cursor_width:0, }),
  ];
  this.act.bg_image = [
    this.bg = new gbox({ width:370, height:50, color:[180,180,180,255],
			 round_enable:true, round_width:10, round_height:10, }),
    this.label = new gtext({ width:350, text:data.label || "", translate:[DEMO_CANADA_FRENCH ?20:10,0,0],
                             color:[100,100,100,255], align:CENTER, }),
    this.icon = new gimage({ width:45, height:45, src:data.icon || "",
			     translate:[DEMO_CANADA_FRENCH?-150 :-140,0,0], }),
  ];
  this.act.action = data.action || function() { console.log(text); };
};
cmd_btn.prototype = new container({});
cmd_btn.prototype.set_data = function(data) {
  this.visible_p = true;
  if( DEMO_MODE ){
    if( (data.label == def_sub_cmd.contact_list[1].label) && (scroll_list_manager.get_current_id()==DEMO_USER_ID) ){
      this.label.color = [40,40,40,255];
      this.icon.color = [255,255,255,255];
      this.bg.color = [200,200,200,255];
    }else{
      this.label.color = [100,100,100,255];
      this.icon.color = [80,80,80,255];
      this.bg.color = [140,140,140,255];
    }
  }

  setf_text(this.label, data.label || "");
  this.icon.src = data.icon || "";
  this.act.action = data.action || function() {};
};
cmd_btn.prototype.free = function(data) {
  this.visible_p = false;
  setf_text(this.label, "");
  this.icon.src = "";
  this.act.action = function() {};
};
cmd_btn.prototype.enter_focus = function() {
  this.bg.color = [181,231,181,255];
  if( DEMO_MODE ){
    if( (this.label.text != def_sub_cmd.contact_list[1].label) || (scroll_list_manager.get_current_id()!=DEMO_USER_ID) ){
      this.bg.color = [181-70,231-20,181-50,255];
    }
  }
  common_key.set_cursor(this, this.act);
};
cmd_btn.prototype.leave_focus = function() {
  this.bg.color = [180,180,180,255];
  if( DEMO_MODE ){
    if( (this.label.text != def_sub_cmd.contact_list[1].label) || (scroll_list_manager.get_current_id()!=DEMO_USER_ID) ){
      this.bg.color = [140,140,140,255];
    }else{
      this.bg.color = [200,200,200,255];
    }
  }

  common_key.set_cursor(this, null);
};

var page_title = new container({ translate:[150,480,0] });
page_title.components = [ new gtext({ font_size:48}) ];
page_title.title = page_title.components[0];
page_title.set_title = function(str) {
  sk_setf_text(this.title, str);
};
page_title.clear = function() {
  this.title.width = 0;
  setf_text(this.title, "");
};

function scroll_item (index, translate) {
  var _this = this;
  this.index = index;
  this.translate = translate;
  this.components = [
    this.act = new actor({ base_col_width:0, cursor_width:0 })
  ];
  this.act.bg_image = [
    this.bg = new gbox({ width:1300, height:LIST_ITEM_BG_HEIGHT, color:LIST_ITEM_UNFOCUS,
			 round_enable:true, round_width:30, round_height:30, }),
    this.icon = new gimage({ translate:[-550,0,0], width:120, height:120 }),
    this.icon_type = new gtext({ translate:[-540,-40,0], visible_p:false }),
    this.display_name = new gtext({ color:[120,120,120,255], translate:[0,42,0], font_size:38, }),
    this.status = new gimage({ width:60, height:60, translate:[-430,40,0] }),
    this.mood_text_bg = new container({
      components:[
        this.circle1 = new gimage({ width:15, height:15, src:"", translate:[-450,-30,0], }),
        this.circle2 = new gimage({ width:25, height:25, src:"", translate:[-420,-35,0], }),
        new gbox({ width:1000, height:70, translate:[110,-35,0], round_enable:true,
	           round_width:30, round_height:30, }),
      ]
    }),
    this.message_text_bg = new container({
      visible_p:false,
      components:[
        new gpolygon({ translate:[-460,-35,0], vertex:[ 32, 15, 0, 0, 15, 0, 34, -15, 0, ], }),
        new gbox({ width:1040, height:70, translate:[90,-35,0],
                   round_enable:true, round_width:30, round_height:30, }),
      ],
    }),
    this.mood_text = new gtext({ translate:[0,-35,0], color:[0,0,0,255], }),
    this.content_text = new gtextbox({ translate:[0,30,0], width:1200, height:96, valign:MIDDLE}),
    this.subcmd_list = new container({ visible_p:false, }),
    this.arrow = new container({ visible_p:false }),
    this.title = new gtext({}),
    this.value = new gtext({ translate:[0,-40,0], color:[0,130,255,255] }),
    this.user = new gtext({ font_size:38, }),
    this.date = new gtext({ translate:[0,-50,0] }),
    this.location = new gtext({ translate:[0,40,0] }),
    this.cmd_list =
      new container({ visible_p:false,
                      components :[
                        new cmd_btn(0, [-390,-130,0]),
                        new cmd_btn(1, [0,-130,0]),
                        new cmd_btn(2, [390,-130,0]),
                        new cmd_btn(3, [-390,-190,0]),
                        new cmd_btn(4, [0,-190,0]),
                        new cmd_btn(5, [390,-190,0]),
                      ],
                    }),
    this.backto_image = new gimage({ translate:[-300,0,0], src:"", visible_p:false }),
    this.backto_text = new gtext({ font_size:40, visible_p:false })
  ];

  this.cmd_list.enter_focus = function() {
    this.index = 0;
    common_key.set_cursor(this, this.components[0]);
  };
  this.cmd_list.leave_focus = function() {
    common_key.set_cursor(this, null);
  };
  this.cmd_list.key_move_def = [
    [null,3,null,1],
    [null,4,0,2],
    [null,5,1,null],
    [0,null,null,4],
    [1,null,3,5],
    [2,null,4,null],
  ];
  this.cmd_list.key_hook = function(up_down, key) {
    switch(key) {
     case TXK_UP:
      if (this.components[this.key_move_def[this.cursor.index][0]] &&
          this.components[this.key_move_def[this.cursor.index][0]].visible_p) {
	common_key.set_cursor(this, this.components[this.key_move_def[this.cursor.index][0]]);
	return true;
      }
      break;
     case TXK_DOWN:
      if (this.components[this.key_move_def[this.cursor.index][1]] &&
          this.components[this.key_move_def[this.cursor.index][1]].visible_p) {
	common_key.set_cursor(this, this.components[this.key_move_def[this.cursor.index][1]]);
	return true;
      }
      break;
     case TXK_LEFT:
      if (this.components[this.key_move_def[this.cursor.index][2]] &&
          this.components[this.key_move_def[this.cursor.index][2]].visible_p) {
	common_key.set_cursor(this, this.components[this.key_move_def[this.cursor.index][2]]);
	return true;
      }
      break;
     case TXK_RIGHT:
      if (this.components[this.key_move_def[this.cursor.index][3]] &&
          this.components[this.key_move_def[this.cursor.index][3]].visible_p) {
	common_key.set_cursor(this, this.components[this.key_move_def[this.cursor.index][3]]);
      }
      return true;
      break;
     case TXK_ENTER:
      this.cursor.act.action();
      return true;
    }
    return false;
  };


  for (var i = 0; i < CONFIG_SUBCMD_NUM; i++) {
    this.subcmd_list.components.push(new setting_result_subcmd(i));
  }
  this.subcmd_list.enter_focus = function() {
    this.index = this.selected;
    common_key.set_cursor(this, this.components[this.selected]);
  };
  this.subcmd_list.leave_focus = function() {
    common_key.set_cursor(this, null);
  };
  this.subcmd_list.free = function() {
    for (var i = 0; i < this.components.length; i++) {
      this.components[i].free();
    }
  };
  this.subcmd_list.update = function() {
    this.components[this.selected].check.visible_p = false;
    this.selected = this.index;
    this.components[this.selected].check.visible_p = true;
  };
  this.subcmd_list.get_selected = function() {
    return this.selected;
  };
  this.subcmd_list.get_index = function() {
    return this.index;
  };
  this.subcmd_list.get_selected_text = function() {
    return this.components[this.selected].text.text;
  };
  this.subcmd_list.key_hook = function(up_down, key) {
    switch(key) {
     case TXK_UP:
      if (this.components[this.index-1] && this.components[this.index-1].visible_p) {
        common_key.set_cursor(this, this.components[--this.index]);
        return true;
      }
      break;
     case TXK_DOWN:
      if (this.components[this.index+1] && this.components[this.index+1].visible_p) {
        common_key.set_cursor(this, this.components[++this.index]);
        return true;
      }
      break;
    }
    return false;
  };

  this.arrow.components.push(
    new gpolygon({ translate:[670,0,0], vertex:[0, 18, 0, 0, -18, 0, 18, 0, 0], })
  );

  this.act.action = function() {
    console.log("default action");
    return;
  };
};
scroll_item.prototype = new container({});
scroll_item.prototype.enter_focus = function() {
  if(!this.expandp) {
    this.bg.color = LIST_ITEM_FOCUS;
    common_key.set_cursor(this, this.act);
  } else if(this.subcmd_list.visible_p) {
    common_key.set_cursor(this, this.subcmd_list);
  } else if(this.cmd_list.visible_p) {
    common_key.set_cursor(this, this.cmd_list);
  }
};
scroll_item.prototype.leave_focus = function() {
  if(this.backto_image.visible_p) {
    this.bg.color = LIST_ITEM_BACK_TO;
  } else {
    this.bg.color = LIST_ITEM_UNFOCUS;
  }
  common_key.set_cursor(this, null);
};
scroll_item.prototype.clear_data = function() {
  this.id = "";
  this.bg.color = LIST_ITEM_UNFOCUS;
  this.icon.src = "";
  this.icon.translate = [-550,0,0];
  this.icon.width = 120;
  this.icon.height = 120;
  setf_text(this.icon_type, "");
  this.icon_type.visible_p = false;
  setf_text(this.display_name, "");
  this.status.src = "";
  this.mood_text_bg.visible_p = false;
  this.message_text_bg.visible_p = false;
  setf_text(this.mood_text, "");
  setf_text(this.content_text, "");
  setf_text(this.backto_text, "");
  this.arrow.visible_p = false;
  setf_text(this.title, "");
  setf_text(this.value, "");
  setf_text(this.user, "");
  this.user.translate[1] = 0;
  setf_text(this.date, "");
  setf_text(this.location, "");
  this.cmd_list.visible_p = false;
  this.subcmd_list.visible_p = false;
  this.backto_image.visible_p = false;
  this.backto_image.src = "";
  this.backto_text.visible_p = false;
  this.circle1.src = "";
  this.circle2.src = "";
};
scroll_item.prototype.set_cmd_list = function(data) {
  for (var i = 0; i < data.length; i++) {
    this.cmd_list.components[i].set_data(data[i]);
  }
  for (i = data.length; i < this.cmd_list.components.length; i++) {
    this.cmd_list.components[i].free();
  }
};
scroll_item.prototype.free_cmd_list = function(data) {
  for (var i = 0; i < this.cmd_list.components.length; i++) {
    this.cmd_list.components[i].free();
  }
};
scroll_item.prototype.set_subcmd_list = function(data) {
  this.subcmd_list.selected = data.value;
  for (var i = 0; i < data.choices.length; i++) {
    this.subcmd_list.components[i].free();
    this.subcmd_list.components[i].set_subcmd(data);
  }
  for (i = data.choices.length; i < this.subcmd_list.components.length; i++) {
    this.subcmd_list.components[i].free();
  }
};
scroll_item.prototype.free_subcmd_list = function(data) {
  for (var i = 0; i < this.subcmd_list.components.length; i++) {
    this.subcmd_list.components[i].free();
  }
};
scroll_item.prototype.set_data = function(data) {
  var _this = this;
  var width;

  this.clear_data();

  this.type = scroll_list_manager.get_type ? scroll_list_manager.get_type() : "";

  if (this.type) {
    var tmp = this.type.split("_")[0];
    if (tmp == "history") this.type = "history";
    else if(tmp == "settings") this.type = "settings";
  }

  // set return
  if (data.backto_text) {
    this.bg.color = LIST_ITEM_BACK_TO;
    sk_setf_text(this.backto_text, data.backto_text);
    this.backto_text.visible_p = true;
    this.backto_image.src = path+"skype/img/return.png";
    this.backto_image.visible_p = true;

    this.act.action = function() {
      console.log("return action");
      if (description_text.free) description_text.free();
      switch(_this.type) {
       case "settings":
        var title = scroll_list_manager.get_label();
        settings_list.components[settings_list.index].set_data({ label1:"", label2:title, });

        if (scroll_list_manager.detail_index) {
          scroll_list_manager.disappear(function() {
            scroll_list_manager.appear( scroll_list_manager.get_type(), function() {
              common_key.set_cursor(sobj, null);
              common_key.set_cursor(sobj, scroll_list_manager);
            });
          }, scroll_list_manager.detail_index);
        } else {
          settings_list.disappear(function() {
            scroll_list_manager.disappear(function() {
              settings_list.appear(def_settings, function() {
                common_key.set_cursor(sobj, settings_list);
              });
            });
          });
        }
        break;
       case "history":
        history_list.disappear(function() {
          scroll_list_manager.disappear(function() {
            history_list.appear(def_history, function() {
              common_key.set_cursor(sobj, history_list);
            });
          });
        });
        break;
       case "add_contact":
       case "find_contact":
        scroll_list_manager.disappear(function() {
          input_area.upper_text.visible_p = true;
          input_area.move_box([0,-85,0]);
          skype_keyboard.appear(function() { common_key.set_cursor(sobj, skype_keyboard); });
        });
        break;
      }
    };

    // contact_list
  } else if (typeof data.mood_text != "undefined") {
    sk_setf_text(this.display_name, data.display_name, -380);
    this.icon.src = data.icon;
    sk_setf_text(this.mood_text, data.mood_text, -340);
    this.circle1.src = path+"skype/img/circle.png";
    this.circle2.src = path+"skype/img/circle.png";
    this.mood_text_bg.visible_p = true;

    if (data.status == "do_not_disturb")
      this.status.src = path + "skype/img/" + data.status + ".png";
    else
      this.status.src = path + "skype/img/" + data.status.split("_")[0] + ".png";

    this.id = data.id;
    if (data.location) {
      width = get_text_width(this.location, data.location);
      this.location.width = width;
      this.location.translate[0] = 600 - width/2;
      setf_text(this.location, data.location);
      this.location.visible_p = true;
    }
    this.act.action = function() {
      if (!this.expandp) {
        _this.leave_focus();
        scroll_list_manager.expand();
      } else {
        scroll_list_manager.shrink();
      }
    };

    // history, voicemail, authorization, search result
  } else if (data.user) {
    sk_setf_text(this.user, data.user, -400);

    this.user.visible_p = true;

    if (data.date) {
      width = get_text_width(this.date, data.date);
      this.date.width = width;
      this.date.translate[0] = 600 - width/2;
      setf_text(this.date, data.date);
      this.date.visible_p = true;
    }
    if (data.location) {
      width = get_text_width(this.location, data.location);
      this.location.width = width;
      this.location.translate[0] = 600 - width/2;
      setf_text(this.location, data.location);
      this.location.visible_p = true;
    }
    if (data.message) {
      sk_setf_text(this.mood_text, data.message, -340);

      this.message_text_bg.visible_p = true;
      this.user.translate[1] = 40;
    }
    if (data.type) {
      this.icon.translate = [-540,20,0];
      this.icon.width = 80;
      this.icon.height = 80;
      var tmp = data.type.replace("%20", " ");
      sk_setf_text(this.icon_type, tmp);

      this.icon_type.visible_p = true;
      this.icon.src = path+"skype/img/" + data.type + ".png";
      this.icon.visible_p = true;
    } else if (sphere_list.selected == "voicemail" ||
               sphere_list.selected == "authorization" ||
               sphere_list.selected == "account") {
      this.icon.src = data.icon;
      this.icon.visible_p = true;
    }

    if (this.type == "account") {
      this.act.action = data.action;
      return;
    }

    this.act.action = function() {
      if (!this.expandp) {
        _this.leave_focus();
        scroll_list_manager.expand();
      } else {
        scroll_list_manager.shrink();
      }
    };

    // settings
  } else if (data.title) {
    setf_text(this.content_text, data.title);
    this.content_text.visible_p = true;

    if (data.choices) { // choices
      width = get_text_width(this.value, data.choices[data.value]);
      this.value.translate[0] = 600 - width/2;
      this.value.width = width;
      setf_text(this.value, data.choices[data.value]);
      this.value.visible_p = true;

      this.act.action = function() {
        if (_this.expandp) {
          if(_this.subcmd_list.get_selected() == _this.subcmd_list.get_index()) {
            scroll_list_manager.shrink();
            _this.enter_focus();
            return;
          }
          _this.subcmd_list.update();
          scroll_list_manager.feed[scroll_list_manager.index].value = _this.subcmd_list.get_selected();
          width = get_text_width(_this.value, _this.subcmd_list.get_selected_text());
          _this.value.translate[0] = 600 - width/2;
          _this.value.width = width;
          setf_text(_this.value, _this.subcmd_list.get_selected_text());
        } else {
          _this.leave_focus();
          scroll_list_manager.expand();
        }
      };

    } else if (data.value) { // only value
      width = get_text_width(this.value, data.value);
      this.value.width = width;
      this.value.translate[0] = 600 - width/2;
      setf_text(this.value, data.value);
      this.value.visible_p = true;
      this.act.action = eval(data.action);
    } else if (data.detail) { // detail
      this.arrow.visible_p = true;

      this.act.action = function() {
        console.log("detail action");

        var title = scroll_list_manager.get_label() + " - "+ _this.content_text.text;
        settings_list.components[settings_list.index].set_data({ label1:"", label2:title, });

        scroll_list_manager.show_detail(scroll_list_manager.get_type(),  _this.index-2,
                                        function(){
                                          common_key.set_cursor(sobj, null);
                                          common_key.set_cursor(sobj, scroll_list_manager);
                                        }, data.description || null);
      };
    } else {
      if (scroll_list_manager.detail) {
        if (data.action) {
          this.act.action = eval(data.action);
        } else {
          this.act.action = function() {
            if (!_this.expandp) {
              _this.leave_focus();
              scroll_list_manager.expand();
            } else {
              scroll_list_manager.shrink();
            }
          };
        };
      } else {
        this.act.action = eval(data.action);
      }
    }
    // status
  } else {
    this.icon.src = data.icon;
    sk_setf_text(this.user, data.label, -400);
    this.user.visible_p = true;
    this.act.action = function() {
      sphere_list.components[1].set_data({ icon:data.icon, label1:data.label, label2:"", });
    };
  }

  return;
};
scroll_item.prototype.appear = function(hook_func, draw) {
  this.move([160,this.translate[1],0], hook_func, draw);
};
scroll_item.prototype.disappear = function(hook_func, draw) {
  this.move([-1650,this.translate[1],0], hook_func, draw);
};
scroll_item.prototype.get_expand_height = function() {
  if(sphere_list.selected == "settings") {
    var data = scroll_list_manager.feed[scroll_list_manager.index];
    if(data.choices) return data.choices.length*40;
    else return def_sub_cmd[scroll_list_manager.detail].length > 3 ? 170 : 100;
  } else if (sphere_list.selected == "add_contact") {
    return def_sub_cmd[add_contact_list.selected].length > 3 ? 170 : 100;
  } else {
    return def_sub_cmd[sphere_list.selected].length > 3 ? 170 : 100;
  }
};
scroll_item.prototype.expand = function(target_translate, hook_func) {
  enable_keyhook = false;
  this.expandp = true;

  var hook, ret, data;

  if (this.type == "settings" && scroll_list_manager.detail != "settings_privacy") {
    data = scroll_list_manager.feed[scroll_list_manager.index];
    ret = data.choices.length*40;

    this.value.visible_p = false;

    this.dst_h = this.bg.height+ret;
    this.target_bg_y = -ret/2;

    hook = function() {
      this.subcmd_list.visible_p = true;
      this.set_subcmd_list(data);
      common_key.set_cursor(this, this.subcmd_list);
      if (hook_func) hook_func();
    };
  } else {
    if(scroll_list_manager.detail)
      data = def_sub_cmd[scroll_list_manager.detail];
    else
      data = def_sub_cmd[this.type];

    ret = this.get_expand_height();
    this.dst_h = this.bg.height+ret;
    this.target_bg_y = -ret/2;

    hook = function() {
      this.cmd_list.visible_p = true;
      this.set_cmd_list(data);
      common_key.set_cursor(this, this.cmd_list);
      if (hook_func) hook_func();
    };
  }

  this.move(target_translate, hook ? hook : null, true);
};
scroll_item.prototype.shrink = function(target_translate, target_height) {
  enable_keyhook = false;
  this.value.visible_p = true;
  this.cmd_list.visible_p = false;
  this.subcmd_list.visible_p = false;
  this.expandp = false;
  this.dst_h = target_height;
  this.target_bg_y = 0;
  var hook = function() {
    this.free_subcmd_list();
    this.free_cmd_list();
  };
  this.move(target_translate, hook, true);
};
scroll_item.prototype.move = function(target_translate, hook_func, drawp) {
  this.call_from_expand = (this.move.caller == this.expand);
  this.call_from_shrink = (this.move.caller == this.shrink);
  this.call_from_disappear = (this.move.caller == this.disappear);

  this.drawp = drawp || false;
  this.hook_func = hook_func;

  this.dst_x = target_translate[0];
  this.dst_y = target_translate[1];
  this.dst_z = target_translate[2];

  this.COUNT = 12;

  append_timer(this, 50, this.effect);
};
scroll_item.prototype.effect = function(obj, count) {
  if (count == obj.COUNT) {
    delete_timer(obj);
    if (obj.call_from_expand || obj.call_from_shrink) {
      obj.bg.height = obj.dst_h;
      obj.bg.translate[1] = obj.target_bg_y;
      enable_keyhook = true;
    } else if (obj.call_from_disappear) {
      if(obj.expandp) {
	obj.expandp = false;
	obj.bg.height = LIST_ITEM_BG_HEIGHT;
	obj.bg.translate[1] = 0;
	obj.cmd_list.visible_p = false;
        obj.subcmd_list.visible_p = false;
      }
    }
    obj.translate[0] = obj.dst_x;
    obj.translate[1] = obj.dst_y;
    obj.translate[2] = obj.dst_z;
    if (obj.drawp)
      force_redraw();
    if (obj.hook_func && typeof obj.hook_func == "function")
      obj.hook_func();
  } else {
    if (obj.call_from_expand || obj.call_from_shrink) {
      obj.bg.height += Math.ceil((obj.dst_h - obj.bg.height)/3);
      obj.bg.translate[1] += (obj.target_bg_y - obj.bg.translate[1])/3;
    }
    obj.translate[0] += (obj.dst_x - obj.translate[0])/3;
    obj.translate[1] += (obj.dst_y - obj.translate[1])/3;
    obj.translate[2] += (obj.dst_z - obj.translate[2])/3;
    if (obj.drawp)
      force_redraw();
  }
};
scroll_item.prototype.key_move_def = [
  [null,3,null,1],
  [null,4,0,2],
  [null,5,1,null],
  [0,null,null,4],
  [1,null,3,5],
  [2,null,4,null],
];
scroll_item.prototype.key_hook = function(up_down, key) {
  if (this.cursor && this.cursor.key_hook && this.cursor.key_hook(up_down, key))
    return true;

  return false;
};

var webcam = new container({ translate:[50,20,0], });
webcam.create = function() {
  this.visible_p = true;
  if (this.components > 0) {
    this.bg.visible_p = false;
    this.bg.width = 10;
    this.bg.height = 10;
    this.video.visible_p = false;
    this.avatar.src = DEMO_MODE ? "" : path+"skype/img/avatar_female.png";
    return;
  }
  this.components = [
    this.bg = new gbox({ width:10, height:10, color:[0,0,0,255], visible_p:false,
			 round_enable:true, round_width:15, round_height:15, }),
    this.video = new videobox({ width:Math.ceil(1280*0.8), height:Math.ceil(720*0.8), color:[0,0,0,0],
				draw_type:DIRECT, visible_p:false, translate:[0,0,0], }),
    this.cover = new gbox({ width:Math.ceil(1280*0.8), height:Math.ceil(720*0.8), color:[0,0,0,255],
                            visible_p:false,}),
    this.avatar = new gimage({ width:Math.ceil(720*0.8), height:Math.ceil(720*0.8),
                               draw_type:DIRECT, visible_p:false,
			       translate:[0,0,0], src: DEMO_MODE ? "" : path+"skype/img/avatar_female.png", }),
    this.frame = new container({
      visible_p:false,
      components:[
        new gbox({width:Math.ceil(1280*0.8)+20, height: Math.ceil(720*0.8)+20, color:[0,0,0,0],
                  round_enable:true, round_width:15, round_height:15,}),
        new gbox({translate:[0,0,-0.1], width:Math.ceil(1280*0.8)+40, height: Math.ceil(720*0.8)+40, color:LIST_ITEM_FOCUS,
                  round_enable:true, round_width:15, round_height:15,}),
      ],
    }),
  ];
  var _this = this;
  this.player = new MoviePlayer({});
  if( !DEMO_MODE ){
  set_screen_mode(PIP_MOVIE_MODE);
  }
  this.player.event_hook = function(obj, event, index) {
    switch( event ){
     case PLAY_OK:
      //console.log("<Movie.event> PLAY_OK");
      Loading.off();
      if (!webcam.is_playing) call_duration.start();
      _this.play_on();
      break;

     case PLAY_NG:
      console.log("<Movie.event> PLAY_NG");
     case PLAY_FINISH:
      //console.log("<Movie.event> PLAY_FINISH");
      if( !DEMO_MODE ){
      _this.video.visible_p = false;
      force_redraw();
      }else{
	skype_main.key_hook(KEY_PRESS,TXK_DOWN);//tentative
	call_cmd_list.components[2].act.action();
      }
      break;
    default:
      console.log("<Movie.event> Unkown Event : " + event );
    }
  };
};
webcam.free = function() {
  if(this.components.length == 0) return;
  this.visible_p = false;
  this.avatar.src = "";

};
webcam.play_on = function() {
  if (scroll_list_manager.call_type != "voice") this.cover.visible_p = false;
  this.is_playing = true;
  force_redraw();
};
webcam.play = function() {
  this.video.visible_p = true;
  force_redraw();
  this.player.connect(VideoDev, AudioDev);
  set_screen_mode(PIP_MOVIE_MODE);
  this.player.stop();
  var url = DEMO_VIDEO_URL;
  this.is_playing = false;
  this.player.play(url);
};
webcam.stop = function() {
  this.video.visible_p = false;
  this.player.stop();
  this.player.disconnect();
};
webcam.init = function() {
  this.translate = [50, 10, 0];
  this.video.width = Math.ceil(1280*0.8);
  this.video.height = Math.ceil(720*0.8);
  this.cover.width  = this.video.width;
  this.cover.height = this.video.height;
};
webcam.appear = function(hook_func, type, answer) {
  this.init();
  this.hook_func = hook_func;
  this.bg.visible_p = true;
  append_timer(this, 50,
	       function(obj, count) {
		 if (count > 20) {
		   delete_timer(obj);
		   obj.bg.width = Math.ceil(1280*0.8) + 20;
		   obj.bg.height = Math.ceil(720*0.8) + 20;
		   this.avatar.visible_p = (type && type == "voice");
		   if (!answer) Loading.on(type);
                   if (!answer) this.cover.visible_p = true;
		   this.video.visible_p = true;

		   if (obj.hook_func)
		     obj.hook_func();
		 } else if (count > 10) {
                   obj.bg.height += Math.ceil((720*0.8-10)/10);
		 } else {
                   obj.bg.width += Math.ceil((1280*0.8-10)/10);
		 }
		 force_redraw();
	       });
};
webcam.disappear = function(hook_func) {
  if (!this.visible_p) return;
  this.hook_func = hook_func;
  if (ENABLE_FAKE_VIDEO) this.stop();

  this.video.visible_p = false;
  this.avatar.visible_p = false;
  this.cover.visible_p = false;
  Loading.off();
  append_timer(this, 50,
	       function(obj, count) {
		 if (count > 20) {
		   delete_timer(obj);
		   obj.bg.width = 15;
		   obj.bg.height = 15;
		   this.bg.visible_p = false;
		   this.video.visible_p = false;
		   if (obj.hook_func)
		     obj.hook_func();
		 } else if (count > 10) {
                   obj.bg.width -= Math.ceil((1280*0.8-10)/10);
		 } else {
                   obj.bg.height -= Math.ceil((720*0.8-10)/10);
		 }
		 force_redraw();
	       });
};
webcam.enter_focus = function() {
  this.frame.visible_p = true;
};
webcam.leave_focus = function() {
  this.frame.visible_p = false;
};
webcam.move = function(target_translate, target_width, target_height, hook_func) {
  this.hook_func = hook_func;
  this.COUNT = 12;
  this.src_x = this.translate[0];
  this.src_y = this.translate[1];
  this.src_z = this.translate[2];
  this.src_w = this.video.width;
  this.src_h = this.video.height;
  this.dst_x = target_translate[0];
  this.dst_y = target_translate[1];
  this.dst_z = target_translate[2];
  this.dst_w = target_width;
  this.dst_h = target_height;

  append_timer(this, 100, this.effect);
};
webcam.effect = function(obj, count) {
  if (count == this.COUNT) {
    delete_timer(obj);
    obj.translate[0] = obj.dst_x;
    obj.translate[1] = obj.dst_y;
    obj.translate[2] = obj.dst_z;
    obj.bg.width     = obj.dst_w + 20;
    obj.bg.height    = obj.dst_h + 20;
    obj.video.width  = obj.dst_w;
    obj.video.height = obj.dst_h;
    obj.cover.width  = obj.dst_w;
    obj.cover.height = obj.dst_h;
    obj.avatar.width = Math.ceil( obj.dst_h * 0.8 );
    obj.avatar.height = obj.avatar.width;
    force_redraw();
    if (this.hook_func)
      this.hook_func();
  } else {
    obj.translate[0] = (obj.dst_x - obj.src_x)*count/obj.COUNT + obj.src_x;
    obj.translate[1] = (obj.dst_y - obj.src_y)*count/obj.COUNT + obj.src_y;
    obj.translate[2] = (obj.dst_z - obj.src_z)*count/obj.COUNT + obj.src_z;
    if (count <= 6 && obj.src_w > obj.dst_w
	|| this.COUNT - count < 6 && obj.src_w < obj.dst_w) {
      obj.video.width  += Math.ceil( (obj.dst_w - obj.src_w)/6 );
      obj.video.height += Math.ceil( (obj.dst_h - obj.src_h)/6 );
      obj.bg.width     = obj.video.width  + 20;
      obj.bg.height    = obj.video.height + 20;
      obj.cover.width  = obj.video.width;
      obj.cover.height = obj.video.height;
      obj.avatar.height = Math.ceil( obj.video.height * 0.8 );
      obj.avatar.width  = obj.avatar.height;
    }
    force_redraw();
  }
};
webcam.key_hook = function(up_down, key) {
  switch(key) {
   case TXK_D1:
    console.log("reset_video 1");
    if (ENABLE_EBUS && ces.flag) {
      ebus.skype.request(SKYPE_RESET_VIDEO);
      ces.wait();
    }
    return true;

   case TXK_ENTER:
    console.log("Full screen");
    this.translate = [0,0,0];
    this.video.width = 1920;
    this.video.height = 1080;
    this.cover.width  = this.video.width;
    this.cover.height = this.video.height;
    if (ENABLE_EBUS)
      myview.set_full_mode(true);
    else
      myview.visible_p = false;

    call_duration.translate = call_duration.FULLSCREEN_TRANSLATE;
    call_cmd_list.is_fullscreen = true;
    call_cmd_list.translate[0] = -call_cmd_list.SLIDE_WIDTH;
    call_cmd_list.index = 0;
    call_cmd_list.set_data(def_call_fullscreen_cmd);
    common_key.set_cursor(sobj, call_cmd_list);
    call_cmd_list_show_timer.start();
    return true;
   case TXK_DOWN:
    common_key.set_cursor(sobj, call_cmd_list);
    return true;
  default:
    return true;
  }
};

var Loading = new container({ translate : [50, 150, 0], visible_p : false, });
Loading.create = function() {
  if (this.components.length > 0) return;
  this.components = [
    new gimage({ src:path + "common/loading_circle.png", translate : [0, -100, 0],
		 rotation:[0, 0, 0, 1], }),
    new gtext({ translate:[0, -230, 0], width:300, align:CENTER, color:[255,255,255,255], }),
  ];
};
Loading.on = function(type) {
  this.create();
  this.r = -1;
  Loading.components[1].color[3] = 255;
  append_timer(this, 100, function(obj, count) {
    if (count > 3600) {
      delete_timer(obj);
      this.visible_p = false;
    } else {
      obj.components[0].rotation[0] -= 30;
      obj.components[1].color[3] += this.r * Math.ceil(255/12);
      if (type == "video")
        setf_text(obj.components[1], DEMO_CANADA_FRENCH ? "" : "Starting video");
      else
        setf_text(obj.components[1], DEMO_CANADA_FRENCH ? "" : "Calling ...");
    }
    this.visible_p = true;
    force_redraw();
  });
};
Loading.off = function() {
  this.visible_p = false;
  delete_timer(this);
  force_redraw();
};
Loading.move = function( target_translate ) {
  this.translate = (!target_translate) ? [50, 150, 0]:target_translate;
};

var ces = {};
ces.init = function() {
  this.flag = true;
  delete_timer(this);
};
ces.WAIT_COUNT = 3000;
ces.wait = function() {
  this.flag = false;
  append_timer(this, this.WAIT_COUNT, function(obj, count) {
    delete_timer(obj);
    obj.flag = true;
  });
};

var call_end = function(hook_func) {
  console.log("End Call");
  enable_keyhook = false;
  sphere_list.enable();
  if (ENABLE_EBUS) {
    console.log("stop video");
    ebus.skype.request(SKYPE_STOP_VIDEO);
  }

  if(call_cmd_list.is_fullscreen) {
    def_call_fullscreen_cmd[4].action(); // Return action
  }

  myview.disappear();
  webcam.disappear(hook_func);
  call_duration.disappear();
  call_cmd_list.disappear();
  if (call_cmd_list.visible_p)
//     if(input_area.visible_p) {
//       input_area.disappear();
    if (incoming_call_disp.item) {
      var draw = true;
      incoming_call_disp.item.move([160, 710, 0], function() {
        incoming_call_disp.visible_p = false;
      }, draw);
    } else {
      scroll_list_manager.components[scroll_list_manager.cindex].move(
        [scroll_list_manager.components[scroll_list_manager.cindex].translate[0],
         -1*scroll_list_manager.scroll*170+scroll_list_manager.TOP_TRANSLATE,
         scroll_list_manager.components[scroll_list_manager.cindex].translate[2]]);
    }
  else
    scroll_list_manager.disappear(hook_func);
  //common_key.set_cursor(sobj, sphere_list);
};

var top_mask = new container({ visible_p:false });
top_mask.components = [
  new gbox({ translate:[0,440,0], width:1920, height:200, color:STAGE_BACKGROUND_COLOR})
];
top_mask.free = function() {
  this.visible_p = false;
};

var def_country_code = [
  {"country":"Canada", code:"1", flag:path+"skype/img/country/Canada.png"},
  {"country":"United States", code:"1", flag:path+"skype/img/country/UnitedStates.png"},
  {"country":"Russian Federation", code:"7", flag:path+"skype/img/country/RussianFederation.png"},
  {"country":"Egypt", code:"20", flag:path+"skype/img/country/Egypt.png"},
  {"country":"South Africa", code:"27", flag:path+"skype/img/country/SouthAfrica.png"},
  {"country":"Greece", code:"30", flag:path+"skype/img/country/Greece.png"},
  {"country":"Netherlands", code:"31", flag:path+"skype/img/country/Netherlands.png"},
  {"country":"Belgium", code:"32", flag:path+"skype/img/country/Belgium.png"},
  {"country":"France", code:"33", flag:path+"skype/img/country/France.png"},
  {"country":"Spain", code:"34", flag:path+"skype/img/country/Spain.png"},
  {"country":"Hungary", code:"36", flag:path+"skype/img/country/Hungary.png"},
  {"country":"Italy", code:"39", flag:path+"skype/img/country/Italy.png"},
  {"country":"Romania", code:"40", flag:path+"skype/img/country/Romania.png"},
  {"country":"Switzerland", code:"41", flag:path+"skype/img/country/Switzerland.png"},
  {"country":"Austria", code:"43", flag:path+"skype/img/country/Austria.png"},
  {"country":"Great Britain", code:"44", flag:path+"skype/img/country/GreatBritain.png"},
  {"country":"Denmark", code:"45", flag:path+"skype/img/country/Denmark.png"},
  {"country":"Sweden", code:"46", flag:path+"skype/img/country/Sweden.png"},
  {"country":"Norway", code:"47", flag:path+"skype/img/country/Norway.png"},
  {"country":"Poland", code:"48", flag:path+"skype/img/country/Poland.png"},
  {"country":"Germany", code:"49", flag:path+"skype/img/country/Germany.png"},
  {"country":"Peru", code:"51", flag:path+"skype/img/country/Peru.png"},
  {"country":"Mexico", code:"52", flag:path+"skype/img/country/Mexico.png"},
  {"country":"Cuba", code:"53", flag:path+"skype/img/country/Cuba.png"},
  {"country":"Argentina", code:"54", flag:path+"skype/img/country/Argentina.png"},
  {"country":"Brazil", code:"55", flag:path+"skype/img/country/Brazil.png"},
  {"country":"Chile", code:"56", flag:path+"skype/img/country/Chile.png"},
  {"country":"Colombia", code:"57", flag:path+"skype/img/country/Colombia.png"},
  {"country":"Venezuela", code:"58", flag:path+"skype/img/country/Venezuela.png"},
  {"country":"Malaysia", code:"60", flag:path+"skype/img/country/Malaysia.png"}
];

var sk_textbox = new container();
sk_textbox.create = function() {
  if (this.components.length > 0) return;
  this.components = [
    this.act = new actor({ base_col_width:0, cursor_width:0 }),
  ];
  this.act.bg_image = [
    this.bg = new gbox({ width:700, height:85, round_enable:true, round_width:15, round_height:15, }),
    this.search_text = new gtext({ width:620, color:[0,0,0,255], font_size:40 })
  ];
};
sk_textbox.set_search_text = function(str) {
  var width = get_text_width(this.search_text, str);
  this.search_text.align = (width > 620) ? RIGHT : LEFT;
  setf_text(this.search_text, str);
};
sk_textbox.enter_focus = function() {
  this.bg.color = LIST_ITEM_FOCUS;
  common_key.set_cursor(this, this.act);
};
sk_textbox.leave_focus = function() {
  this.bg.color = [255,255,255,255];
  common_key.set_cursor(this, null);
};
sk_textbox.free = function() {
  setf_text(this.search_text, "");
};

var country_sel_cont = new container({ translate:[-155,0,0] });
var country_sel_btn = new container({});

var input_area = new container({ translate:[150,390,0], visible_p:false });
input_area.cindex = 0;
input_area.visible_p = false;
input_area.text_str = [];
input_area.create = function() {
  if (this.components.length > 0) return;
  sk_textbox.create();
  this.components = [
    this.search = new container({ components:[
      this.upper_text = new gtext({}),
      this.box = new container({ translate:[0,-85,0], components:[
        sk_textbox,
        country_sel_btn
      ] }),
    ] })
  ];
};
input_area.init = function() {
  this.cindex = 0;
  this.box.translate = [0,-85,0];
  this.upper_text.visible_p = true;
  this.search.translate[0] = 1700;
  this.text_str.splice(0, this.text_str.length);
  sk_textbox.set_search_text("");
};
input_area.enter_focus = function() {
  common_key.set_cursor(this, country_sel_btn);
};
input_area.leave_focus = function() {
  common_key.set_cursor(this, null);
};
input_area.appear = function(translate) {
  if(!login.visible_p) top_mask.visible_p = true;
  this.init();
  this.visible_p = true;
  translate = translate || [0,0,0];
  input_area.move_search(translate);
};
input_area.disappear = function(hook_func) {
  if(!this.visible_p) {
    if(hook_func) hook_func();
    return;
  }
  input_area.move_search([-1700,0,0], function() {
    input_area.visible_p = false;
    if(hook_func)
      hook_func();
  });
};
input_area.set_search_text = function(ch) {
  if (this.text_str.length > 15) return;

  this.text_str.push(ch);
  var str = "";
  for (var i = 0; i < this.text_str.length; i++) {
    str += this.text_str[i];
  }
  sk_textbox.set_search_text(str);
};
input_area.del_search_text = function() {
  this.text_str.pop();
  var str = "";
  for (var i = 0; i < this.text_str.length; i++) {
    str += this.text_str[i];
  }
  sk_textbox.set_search_text(str);
};
input_area.move_search = function(target_translate, hook_func) {
  this.search.hook_func = hook_func;
  this.search.dst_x = target_translate[0];
  this.search.dst_y = target_translate[1];
  this.search.dst_z = target_translate[2];
  this.search.COUNT = 12;

  append_timer(this.search, 100, this.effect);
};
input_area.move_box = function(target_translate, hook_func) {
  this.box.hook_func = hook_func;
  this.box.dst_x = target_translate[0];
  this.box.dst_y = target_translate[1];
  this.box.dst_z = target_translate[2];
  this.box.COUNT = 12;

  append_timer(this.box, 100, this.effect);
};
input_area.effect = function(obj, count) {
  if (count == this.COUNT) {
    delete_timer(obj);
    obj.translate[0] = obj.dst_x;
    obj.translate[1] = obj.dst_y;
    obj.translate[2] = obj.dst_z;
    force_redraw();
    if (this.hook_func)
      this.hook_func();
  } else {
    obj.translate[0] += (obj.dst_x - obj.translate[0])/3;
    obj.translate[1] += (obj.dst_y - obj.translate[1])/3;
    obj.translate[2] += (obj.dst_z - obj.translate[2])/3;
    force_redraw();
  }
};
input_area.set_upper_text = function(str) {
  sk_setf_text(this.upper_text, str);
};
input_area.free = function() {
  if (this.components.length == 0) return;
  this.visible_p = false;
  setf_text(this.upper_text, "");
  sk_textbox.free();
  if (country_sel_btn.free) country_sel_btn.free();
};
input_area.key_hook = function(up_down, key) {
  if (this.cursor.key_hook(up_down,key))
    return true;

  switch(key) {
   case TXK_DOWN:
    common_key.set_cursor(sobj, skype_dial_pad);
    return true;
   case TXK_LEFT:
    common_key.set_cursor(sobj, sphere_list);
    return true;
  }
};

var skype_keyboard = new container({ visible_p:false });
var skype_dial_pad = new container({ visible_p:false });

var chat = new container({ translate:[-12,0,-0.1], });
var chat_cmd_list = new container({ visible_p:false });
skype_keyboard.name = "skype_keyboard"; // DEBUG
skype_dial_pad.name = "skype_dial_pad"; // DEBUG
chat.name = "chat"; // DEBUG

var pkg_mgr = {};
pkg_mgr.prepare = function(obj, url) {
  if (obj.preeval) return;
  //console.log("[prepare]", obj.name);

  http_request_handler.get({
    url:url,
    sync:false,
    prepare:function(body) {
      obj.preeval = body;
      console.log("[preeval]", obj.name);
    },
  }, obj.name);
};
pkg_mgr.require = function(obj, url, hook) {
  if (obj.components.length > 0) {
    if (typeof hook == "function") hook();
    return;
  }

  if (obj.preeval) {
    try {
      eval(obj.preeval);
      console.log("[only eval]", obj.name);
      if (typeof hook == "function") hook();
    } catch (e) {
      console.log("[ERROR] <" + e.name + "> " + e.message);
    }
    return;
  }
  http_request_handler.get({
    url:url,
    sync:true,
    hook:function() {
      console.log("[retrieve and eval]", obj.name);
      if (typeof hook == "function") hook();
    },
  }, obj.name);
};

var scroll_list_manager = new container({});
scroll_list_manager.name = "scroll_list_manager";
pkg_mgr.prepare(scroll_list_manager, path+"skype/sk_scroll_list_manager.js");

var sphere_list_back = new gbox({ width:300, height:1080, color:[0,0,0,20], translate:[-1300,0,0], });
var sphere_list = new container({});
sphere_list.name = "sphere_list";
var call_cmd_list_show_timer = {};
pkg_mgr.prepare(sphere_list, path+"skype/sk_sphere_list.js");

var sphere_cont = new container({});
sphere_cont.components = [
  sphere_list_back,
  sphere_list
];
sphere_cont.free = function() {
  for (var i = 0; i < this.components.length; i++) {
    if(this.components[i].free) this.components[i].free();
  }
};

var call_cmd_list = new container({ visible_p:false, });

function key_btn(translate, width, height) {
  this.components = [
    this.act = new actor({ translate:translate, cursor_width:0, base_col_width:0 })
  ];
  this.act.bg_image = [
    this.bg = new gbox({ width:width, height:height, color:LIST_ITEM_UNFOCUS,
                         round_enable:true, round_width:5, round_height:5, }),
    this.text = new gtext({ width:30, align:CENTER }),
    this.icon = new gimage({ translate:[0,25,0], width:48, height:48, }),
    this.next_button =
      new container({ visible_p:false,
                      components:[
	                this.from = new gtext({}),
	                this.to = new gtext({}),
	                new gpolygon({ vertex:[ 10, 0, 0,  0, 10, 0,  0,-10, 0,],
	                               color:[255,255,255,255] }),
	                new gbox({ translate:[-5,0,0], width:10, height:10 })
                      ]
                    })
  ];
};
key_btn.prototype = new container({});
key_btn.prototype.set_keytop_change_btn = function(from, to) {
  sk_setf_text(this.from, from, -75);
  sk_setf_text(this.to, to, 15);
};
key_btn.prototype.free = function() {
  setf_text(this.text, "");
  this.icon.src = "";
  setf_text(this.from, "");
  setf_text(this.to, "");
};

var searching_anim = new container({ translate:[-50,0,0.1], visible_p:false });

var call_duration = new container({});
call_duration.FULLSCREEN_TRANSLATE = [-750, 450, 0];
call_duration.DEFAULT_TRANSLATE = [750, 290, 0];
call_duration.create = function() {
  if (this.components.length > 0) return;

  this.visible_p = false;
  this.translate = this.DEFAULT_TRANSLATE;
  this.components = [
    new gtext({ width:176, text:"Call duration", visible_p:!DEMO_CANADA_FRENCH }),
    this.duration = new gtext({ translate:[0,-50,0], width:100 })
  ];
  this.set_data("00:00:00");
};
call_duration.counting = function(obj, count) {
  delete_timer(obj);
  obj.cnt++;
  obj.set_data((Math.floor(obj.cnt/(60*60))%60 < 10 ? "0" : "") + Math.floor(obj.cnt/(60*60))%60 + ":" +
               (Math.floor(obj.cnt/60)%60 < 10 ? "0" : "") + Math.floor(obj.cnt/60)%60 + ":" +
               (obj.cnt%60 < 10 ? "0" : "") + obj.cnt%60);
  append_timer(obj, 1000, obj.counting);
};
call_duration.start = function() {
  this.cnt = 0;
  console.log("call_duration.start");
  delete_timer(this);
  append_timer(this, 1000, this.counting);
};
call_duration.appear = function() {
  this.create();
  this.set_data("00:00:00");
  this.visible_p = true;
};
call_duration.disappear = function() {
  delete_timer(this);
  this.visible_p = false;
};
call_duration.set_data = function(duration) {
  sk_setf_text(this.duration, duration);
};

var scrollbar = new container({translate:[880, 0, 0], visible_p:false});

function setting_result_subcmd(num) {
  this.index = num;
  this.components = [];
  this.visible_p = false;
  this.components = [
    this.act = new actor({ translate:[0,-35-50*num,0], base_col_width:0, cursor_width:0, }),
  ];
  this.act.bg_image = [
    this.circle = new gbox({ translate:[-550,0,0.1], width:28, height:28, color:[0,0,0,0],
			     round_enable:true, round_width:14, round_height:14 }),
    this.checkbox = new gbox({ translate:[-550,0,0], width:38, height:38, color:[255,255,255,255],
			       round_enable:true, round_width:19, round_height:19 }),
    this.check = new gimage({ translate:[-552,0,0.1], width:20, height:20, src:path + "skype/img/check.png" }),
    this.text = new gtext({ translate:[150,0,0]})
  ];
};
setting_result_subcmd.prototype = new container({});
setting_result_subcmd.prototype.enter_focus = function() {
  this.checkbox.color = LIST_ITEM_FOCUS;
  common_key.set_cursor(this, this.act);
};
setting_result_subcmd.prototype.leave_focus = function() {
  this.checkbox.color = [255,255,255,255];
  common_key.set_cursor(this, null);
};
setting_result_subcmd.prototype.set_subcmd = function(data) {
  var p = this.act;
  if (data) {
    this.visible_p = true;
    this.checkbox.color = [255,255,255,255];
    this.check.visible_p = (this.index == data.value);
    this.text.width = get_text_width(this.text, data.choices[this.index]);
    this.text.translate[0] = -650 + this.text.width/2 + 150;
    setf_text(this.text, data.choices[this.index]);
  } else {
    setf_text(this.text, "");
    this.visible_p = false;
  }
  return this.check.visible_p;
};
setting_result_subcmd.prototype.free = function() {
  setf_text(this.text, "");
  this.visible_p = false;
};

var settings_list = new container({ visible_p:false, });
settings_list.name = "settings_list"; // DEBUG

var add_contact_list = new container({ visible_p:false, });
add_contact_list.name = "add_contact_list"; // DEBUG

var history_list = new container({ visible_p:false, });
history_list.name = "history_list"; // DEBUG

var account_list = new container({ visible_p:false, });
account_list.name = "account_list"; // DEBUG

var hook_answered = false;
var start_call = function(id, type, hook_func, answer) {
  if(myview.visible_p) {
    if (answer) {
      console.log("answered!!!");
      hook_answered = true;
      if (ENABLE_EBUS) {
        ebus.skype.request(SKYPE_ANSWER_CALL);
        ebus.skype.request(SKYPE_START_VIDEO);
      }
    }
    return;
  }
  enable_keyhook = false;
  top_mask.visible_p = false;
  scrollbar.visible_p = false;
  page_title.clear();
  scroll_list_manager.call_type = type;
  console.log("call_type = ", type);
  console.log("answer = ", answer);
  if (answer) { // incoming_call
    console.log("answered!!!");
    if (ENABLE_EBUS) { ebus.skype.request(SKYPE_ANSWER_CALL); }

    pkg_mgr.require(sphere_list, path+"skype/sk_sphere_list.js", function() {
      sphere_list.create();
    });

    sphere_list.appear(function() {
      sphere_list.set_visible();
    } );

  } else {
    console.log("id = ", id);
    if (ENABLE_EBUS) ebus.skype.request(SKYPE_PLACE_CALL, id);
  }

  sphere_list.disable();

  if(call_cmd_list.is_fullscreen) {
      if (ENABLE_EBUS)
	  myview.set_full_mode(false);
      else
	  myview.visible_p = true;
      call_duration.translate = call_duration.DEFAULT_TRANSLATE;
      call_cmd_list.is_fullscreen = false;
      call_cmd_list.translate[0] = 0;
      call_cmd_list.set_data(def_call_cmd);
      call_cmd_list.index = 0;
  }

  var hook = function() {
    if (scroll_list_manager.components.length > 0) {
      for (var i = 0; i < scroll_list_manager.components.length; i++) {
        if (i == scroll_list_manager.cindex) {
          scroll_list_manager.components[i].shrink([scroll_list_manager.components[i].translate[0],
	                                            -scroll_list_manager.scroll*170+435 + ( DEMO_MODE ? -35 : 0 ),
	                                            scroll_list_manager.components[i].translate[2]],
                                                   LIST_ITEM_BG_HEIGHT);
        } else {
          scroll_list_manager.components[i].disappear( function() { this.visible_p = false });
        }
      }
    }

    webcam.create();
    webcam.appear(function() {
      myview.create();
      myview.appear();
      call_duration.appear();
      call_cmd_list.create();
      call_cmd_list.appear(function() {
	call_cmd_list.components[0].move(call_cmd_list.components[0].translate, 100, null, true);
	common_key.set_cursor(sobj, call_cmd_list);
	if (ENABLE_FAKE_VIDEO) webcam.play();
        enable_keyhook = true;
      });
    }, type, answer);
  };

  if(skype_dial_pad.visible_p && sphere_list.selected == "call_phones") {
    input_area.move_box([0,0,0], function(){ input_area.upper_text.visible_p = false; });
    skype_dial_pad.disappear(hook);
    return;
  }

  var tmp = scroll_list_manager.type ? scroll_list_manager.get_type().split("_") : "";
  if (tmp[0] == "history" || tmp[0] == "settings")
    this.type = tmp[0];
  switch(this.type) {
   case "history":
    history_list.disappear(hook);
    return;
   case "settings":
    settings_list.disappear(hook);
    return;
   case "add_contact":
   case "find_contact":
    input_area.disappear(hook);
    return;
  default :
    hook();
    return;
  }
};
scroll_list_manager.start_chat = function(id, type, hook_func, answer) {
  sphere_list.disable();
  page_title.clear();
  this.chat_type = type;
  var hook = function() {
    top_mask.visible_p = false;
    for (var i = 0; i < scroll_list_manager.components.length; i++) {
      if (i == scroll_list_manager.cindex) {
        scroll_list_manager.components[i].shrink([scroll_list_manager.components[i].translate[0],
				                  -scroll_list_manager.scroll*170+435,
				                  scroll_list_manager.components[i].translate[2]], LIST_ITEM_BG_HEIGHT);
        scrollbar.visible_p = false;
	call_cmd_list.disappear();

        pkg_mgr.require(chat, path+"skype/sk_chat.js", function() {
          chat.create();
	  chat_cmd_list.create();
	  chat_cmd_list.init();
	  chat_cmd_list.appear([-100,-420,0]);
          chat.appear(function(){
	    common_key.set_cursor(sobj, chat_cmd_list);
	  });
        });

      } else {
        scroll_list_manager.components[i].disappear();
      }
    }
  };

  switch(this.chat_type) {
  case "voice":
    webcam.move([758, 0, 0], 300, 168, hook);
    Loading.move([758, 156, 0]);
    break;
  case "video":
    webcam.move([758, 0, 0], 300, 168, hook);
    Loading.move([758, 156, 0]);
    break;
  case "chat":
  default:
    hook();
    break;
  }
};

var description_text = new container({translate:[0,0,0.1],visible_p:false});

var skype_credit_cont = new container({});

var myview = new container({ visible_p:false });
myview.create = function() {
  if (this.components.length > 0) {
    this.bg.width = 8;
    this.bg.height = 8;
    if(!ENABLE_EBUS) this.view.src = path+"skype/img/myphoto.jpg";
    return;
  }
  this.components = [
    this.bg = new gbox({ width:8, height:8, color:[0,0,0,255], translate:[1568-1920/2+300/2, -650+1080/2-168/2,0],
                         visible_p:false, round_enable:true, round_width:10, round_height:10, }),
  ];

  if (ENABLE_EBUS) {
    this.view = new videobox({ width:300, height:168, source:1, color:[0,0,0,0], visible_p:false,
                               translate:[1568-1920/2+300/2, -650+1080/2-168/2,0], draw_type:DIRECT, });
    this.components.push(this.view);
  } else {
    this.view = new gimage({ width:300, height:168, src:path+"skype/img/myphoto.jpg", draw_type:DIRECT,
                             translate:[1568-1920/2+300/2, -650+1080/2-168/2,0], visible_p:false, });
    this.components.push(this.view);
  }

  if( DEMO_MODE ){
    this.components.push(
      new gtextbox({
	color:[200,200,255,255],
	translate:[
	  this.view.translate[0]+1 + 10,
	  this.view.translate[1]-1 + 250,
	  this.view.translate[2],
	],
	width:300, height:270, font_size:28,
	valign:MIDDLE, font_name:"F015T-medium",
	margin_leading:-3,
	text: DEMO_DISCLAIMER,
      }),
      new gtextbox({
	color:[40,60,60,255],
	translate:[
	  this.view.translate[0] + 10,
	  this.view.translate[1] + 250,
	  this.view.translate[2],
	],
	width:300, height:270, font_size:28,
	valign:MIDDLE, font_name:"F015T-medium",
	margin_leading:-3,
	text: DEMO_DISCLAIMER,
      })
    );
  }

};
myview.free = function() {
  if(this.components.length == 0) return;
  this.visible_p = false;
  this.view.src = "";
};
myview.set_full_mode = function(bool) {
  this.view.translate[0] = bool ? 1920/2 : 1568-1920/2+300/2;
};
myview.appear = function(hook_func) {
  this.hook_func = hook_func;
  this.visible_p = true;
  this.bg.visible_p = true;
  this.view.visible_p = false;
  append_timer(this, 50,
	       function(obj, count) {
		 if (count > 20) {
		   delete_timer(obj);
		   obj.bg.height = 168+10;
		   obj.bg.width = 300+10;
		   obj.view.visible_p = true;
		   if (obj.hook_func)
		     obj.hook_func();
		 } else if (count > 10) {
		   obj.bg.height += Math.ceil((168-8)/10);
		 } else {
		   obj.bg.width += Math.ceil((300-8)/10);
		 }
		 force_redraw();
	       });
};
myview.disappear = function(hook_func) {
  if (!this.visible_p) return;
  this.hook_func = hook_func;
  this.view.visible_p = false;
  append_timer(this, 50,
	       function(obj, count) {
		 if (count > 20) {
		   delete_timer(obj);
		   obj.bg.width = 8;
		   obj.bg.height = 8;
                   obj.bg.visible_p = false;
                   obj.visible_p = false;
		   if (obj.hook_func)
		     obj.hook_func();
		 } else if (count > 10) {
		   obj.bg.width -= Math.ceil((300-8)/10);
		 } else {
		   obj.bg.height -= Math.ceil((168-8)/10);
		 }
		 force_redraw();
	       });
};

var notify_msg = new container({});
notify_msg.create = function() {
  if (this.components.length > 0) return;
  this.components = [
    new gimage({ width:80, height:80, src:path+"skype/img/online.png",
                 translate:[-800,0,0], }),
    new gtext({ width:600, text:"skypeuser1 is online",
                translate:[-400,0,0], font_size:38, }),
  ];
};

var notify_cont = new container({ translate:[0,-540-150,0], visible_p:false, });
notify_cont.create = function() {
  if (this.components.length > 0) return;
  notify_msg.create();
  this.components = [
    new gbox({ width:1920, height:100, color:[0,0,0,200], }),
    notify_msg,
  ];
};
notify_cont.appear = function() {
  var _this = this;
  this.create();
  delete_timer(this);
  this.visible_p = true;
  this.move([0,-540+50,0], function() {
    append_timer(_this, 5000, function(obj, count) {
      delete_timer(obj);
      obj.disappear();
    });
  });
};
notify_cont.disappear = function() {
  var _this = this;
  delete_timer(this);
  this.move([0,-540-150,0], function() {
    _this.visible_p = false;
  });
};
notify_cont.move = function(target_translate, hook_func) {
  this.hook_func = hook_func;

  this.dst_x = target_translate[0];
  this.dst_y = target_translate[1];
  this.dst_z = target_translate[2];

  this.COUNT = 12;

  append_timer(this, 50, this.effect);
};
notify_cont.effect = function(obj, count) {
  if (count == this.COUNT) {
    delete_timer(obj);
    this.translate[0] = this.dst_x;
    this.translate[1] = this.dst_y;
    this.translate[2] = this.dst_z;
    force_redraw();
    if (this.hook_func)
      this.hook_func();
  } else {
    this.translate[0] += (this.dst_x - this.translate[0])/3;
    this.translate[1] += (this.dst_y - this.translate[1])/3;
    this.translate[2] += (this.dst_z - this.translate[2])/3;
    force_redraw();
  }
};

// @@TV
var bplayer = new BroadcastPlayer ();
function connect_bplayer(){
  //bplayer.connect (VideoDev, AudioDev);
  set_screen_mode (PIP_EXVIDEO_MODE);
  set_screen_mode (OSD_ONLY_MODE);
};
//connect_bplayer();

// function disconnect_bplayer(){
//   set_screen_mode (OSD_ONLY_MODE);
//   bplayer.disconnect ();
// }

var login = new container({ visible_p:false });
login.name = "login";

var notify_call = new container({ visible_p:false, });
notify_call.name = "notify_call";

var incoming_call_disp = new container({});


var sk_in_hook_on_stage = function () {
  this.visible_p = false;

  pkg_mgr.require(sphere_list, path+"skype/sk_sphere_list.js", function() {
    sphere_list.create();
  });

  if (ENABLE_EBUS) ebus.skype.connect();
  sphere_list.selected = "contact_list";
  if (ENABLE_EBUS) ebus.skype.request(SKYPE_GET_CONTACT_LIST);
  if (!ENABLE_EBUS) scroll_list_manager.appear("contact_list");

  sobj.COUNT = 30;
  append_timer(sobj, 50, function(obj, count) {
    if (count > obj.COUNT) {
      delete_timer(obj);
      obj.bg_image[0].color[3] = 255;
    } else {
      obj.bg_image[0].color[3] += Math.ceil(255/obj.COUNT);
    }
    force_redraw();
  });

  sphere_list_back.move([-860+80,0,0]);

  sphere_list.appear(function() {
    sphere_list.set_visible();
    common_key.set_cursor(sobj, sphere_list);
    enable_keyhook = true;
  });

};


var sobj = stage({
  "symbol": "skype_main",
  "in":[
    {
      "from": ["home_screen", "skype_account_make"],
      "hook": function(obj) {
	try{
	  system.screen.set_freq( system.screen.FREQ_60HZ );
	  console.log("+++ Change Freq. ==> 60Hz");
	}catch(e){
	  console.log("--- Cannot change freq. (60Hz)");
	}

        ces.init();
        obj.translate = [0,0,0];

        pkg_mgr.require(scroll_list_manager, path+"skype/sk_scroll_list_manager.js", function() {
          scrollbar.create();
          scroll_list_manager.create();
        });

        login.automatically = true;
        if(login.automatically) {
          sk_in_hook_on_stage();
        } else {
          pkg_mgr.require(skype_keyboard, path+"skype/sk_keyboard.js");
          pkg_mgr.require(login, path+"skype/sk_login.js", function() {
            login.create();
            login.appear(function() {
              common_key.set_cursor(obj, login);
              enable_keyhook = true;
              input_area.create();
            });
          });

        }

        complete_on_stage (obj);

        // TODO
	if(!DEMO_MODE){
        pkg_mgr.prepare(login, path+"skype/sk_login.js");
        pkg_mgr.prepare(notify_call, path+"skype/sk_notify_call.js");
        pkg_mgr.prepare(skype_keyboard, path+"skype/sk_keyboard.js");
        pkg_mgr.prepare(skype_dial_pad, path+"skype/sk_dial_pad.js");
        pkg_mgr.prepare(chat, path+"skype/sk_chat.js");
        pkg_mgr.prepare(settings_list, path+"skype/sk_settings.js");
        pkg_mgr.prepare(history_list, path+"skype/sk_history.js");
        pkg_mgr.prepare(add_contact_list, path+"skype/sk_add_contact.js");
        pkg_mgr.prepare(account_list, path+"skype/sk_account.js");
	}
      },
    },
    {
      "from": ["default"],
      "hook": function(obj) {
        ces.init();
        connect_bplayer();
        console.log("Incoming call");
        if (ENABLE_EBUS) ebus.skype.connect();
	complete_on_stage (obj);
      }
    }
  ],
  "out":[
    {
      "to":["home_screen"],
      "hook":function(obj) {
	//webcam.stop();
	if( DEMO_MODE){
	  try{
	    sphere_list.leave_focus();
	    webcam.free();
	    try{
	      call_cmd_list.components[2].act.action();
	    }catch(e){}
	    myview.free();
	  }catch(e){
	    // No Problem
	  }
	}
	Loading.off();
        if (ENABLE_EBUS) ebus.skype.disconnect ();
        common_key.set_cursor(sobj, null);
        var _this = this;
        var hook = function() {
	  complete_off_stage(obj);
          obj.translate = [0,0,0];
          page_title.clear();

          for (var i = 0; i < _this.components.length; i++) {
            if (_this.components[i].free) _this.components[i].free();
          }

          if (call_cmd_list.visible_p) {
            if (ENABLE_EBUS) ebus.skype.request(SKYPE_END_CALL);
            call_end();
          }

          if(settings_list.visible_p) {
            settings_list.clear_sphere();
          } else if(add_contact_list.visible_p) {
            add_contact_list.clear_sphere();
          } else if(history_list.visible_p) {
            history_list.clear_sphere();
          } else if(account_list.visible_p) {
            account_list.clear_sphere();
          }
	};
        for (var i = 0; i < this.components.length; i++)
          delete_timer(this.components[i]);
        for (var i = 0; i < scroll_list_manager.components.length; i++)
          delete_timer(scroll_list_manager.components[i]);
        for (var i = 0; i < settings_list.components.length; i++)
          delete_timer(settings_list.components[i]);
        for (var i = 0; i < add_contact_list.components.length; i++)
          delete_timer(add_contact_list.components[i]);
        for (var i = 0; i < history_list.components.length; i++)
          delete_timer(history_list.components[i]);
        for (var i = 0; i < account_list.components.length; i++)
          delete_timer(account_list.components[i]);
        if(input_area.search) delete_timer(input_area.search);
        if(input_area.box) delete_timer(input_area.box);
        if(scrollbar.bar) delete_timer(scrollbar.bar);
        if(scrollbar.pos) delete_timer(scrollbar.pos);
        delete_timer(sphere_list_back);
        delete_timer(call_cmd_list_show_timer);
        if (typeof country_sel_cont != "undefined") delete_timer(country_sel_cont);
        if(country_sel_btn.bg) delete_timer(country_sel_btn.bg);
        if(country_sel_btn.focus) delete_timer(country_sel_btn.focus);

        anim.out_to.far_right(sobj, 0, hook);
      }
    },
    {
      "to":["skype_account_make"],
      "hook":function(obj) {
        delete_timer(login);
        login.index = 0;
        for (var i = 0; i < login.components.length; i++)
          login.components[i].visible_p = false;
        for (var i = 0; i < login.items.components.length; i++) {
          var p = login.items.components[i];
          if(p instanceof login_box) {
            p.expandp = false;
            p.focus.visible_p = false;
            p.selects.visible_p = false;
            p.arrow.visible_p = true;
            p.translate[2] = 0;
            p.box.translate = [0,0,0];
            p.box.height = 100;
            p.back_box.translate = [0,0,0.1];
            p.back_box.height = 90;
            p.input_text.visible_p = true;
          }
        }
      }
    },
    {
      "to":["default"],
      "hook":function(obj) {
	var hook = function() {
	  //webcam.player.disconnect();
	  complete_off_stage(obj);
	};
	anim.out_to.left(sobj, 0, hook);
      },
    },
  ],
  "key_hook": function (up_down, key){
    if (up_down != KEY_PRESS)
      return true;

    if (!enable_keyhook){
      if( key==TXK_HOME ){
	return false;
      }else{
	return true;
      }
    }

    if (this.cursor != null && this.cursor.key_hook(up_down, key)) {
      force_redraw();
      return true;
    }
    switch(key) {
     case TXK_RETURN:
     case TXK_LEFT:
      if (sphere_list.enablep) {
	common_key.set_cursor(this, sphere_list);
        force_redraw();
	return true;
      }
      break;
//      case TXK_YELLOW:
//       if (ENABLE_EBUS) ebus.skype.request(SKYPE_LOGIN, "skype4tv4", "aaaa1111");
//       return true;
//      case TXK_BLUE:
//       if (ENABLE_EBUS) ebus.skype.request(SKYPE_LOGIN, "skype4tv5", "aaaa1111");
//       return true;
//      case TXK_GREEN:
//       if (ENABLE_EBUS) ebus.skype.request(SKYPE_GET_CONTACT_LIST);
//       return true;
    }

    return false;
  },
  "bg_image": [
    new gbox ({ width:11520, height:6480, color:STAGE_BACKGROUND_COLOR, translate:[0, 0, -3325.5]}),
  ],
  "components": [
    login,
    searching_anim,
    scroll_list_manager,
    incoming_call_disp,
    top_mask,
    settings_list,
    add_contact_list,
    history_list,
    account_list,
    description_text,
    skype_credit_cont,
    input_area,
    sphere_cont,
    chat,
    chat_cmd_list,
    webcam,
    call_cmd_list,
    myview,
    call_duration,
    Loading,
    page_title,
    notify_cont,
    notify_call,
    scrollbar,
    skype_keyboard,
    skype_dial_pad,
  ]
});


if (ENABLE_EBUS) {

  var get_contact_list = function(list) {
    var contacts = [];
    for (var i = 0; i < list.length; i++) {
      var c = list[i];
      contacts.push({ id:c.SKYPENAME, display_name:c.DISPLAYNAME, icon:def_contact_list[i%12].icon,
                      mood_text:c.MOOD_TEXT, status:c.AVAILABILITY.toLowerCase(), });
    }
    return contacts;
  };

  var get_history_list = function(list) {
    var history = [];
    history.push({ backto_text:"Back to History", });
    for (var i = 0; i < list.length; i++) {
      var c = list[i];
      history.push({ type:c.STATUS, user:c.USER, date:c.DATE, location:c.LOCATION, });
    }
    return history;
  };

  function skype_event_hook (stg, obj, ev, event, data) {
    switch(ev){
     case obj.CONNCETED_EV:
      console.log("JsEvConnected");
      break;
     case obj.DISCONNECTED_EV:
      console.log("JsEvDisconnected");
      break;
     case obj.SKYCLIENT_EV:
      console.log("JsEvSkyclient");
      switch (event) {
       case SKYPE_ON_NEW_CALL_EV:
        console.log ("JsOnNewCall", data);
        pkg_mgr.require(notify_call, path+"skype/sk_notify_call.js", function() {
          notify_call.appear(data, function() {
            common_key.set_cursor(sobj, notify_call);
          });
        });
        break;
       case SKYPE_CONTACT_LIST_EV:
        console.log ("JsContactList");
        var clist = data;
        def_contact_list = get_contact_list(eval(clist));
        //console.log(def_contact_list.toSource());

        pkg_mgr.require(scroll_list_manager, path+"skype/sk_scroll_list_manager.js", function() {
          scrollbar.create();
          scroll_list_manager.create();
          sphere_list.selected = "contact_list";
          scroll_list_manager.appear("contact_list", function() {
            if (sobj.cursor != sphere_list)
              common_key.set_cursor(sobj, scroll_list_manager);
          });
        });
        break;
       case SKYPE_HISTORY_LIST_EV:
        console.log ("HISTORY_LIST_EV: listnum = " + eval(data).length);
        var clist = data;
        def_history_list = get_history_list(eval(clist));
        scroll_list_manager.appear("history_all", function() {
          if (sobj.cursor != sphere_list)
            common_key.set_cursor(sobj, scroll_list_manager);
        });
        break;
       case SKYPE_WAITING_ANSWER_EV:
        console.log("JsWaitingAnswer", data);
      
        var answer = true;
        start_call(null, "voice", function() {
          sphere_list.appear(function() {
            sphere_list.set_visible();
          } );
        }, answer);
      
        break;
       case SKYPE_WAITING_ANSWER_WITH_VIDEO_EV:
        console.log("JsWaitingAnswerWithVideo", data);

        scroll_list_manager.call_type = "video"; // temporary

        incoming_call_disp.components = [
          incoming_call_disp.item = new scroll_item(0, [160, 710, 0]),
        ];
        var draw = true;
        incoming_call_disp.item.move([160, 435, 0], null, draw);

        incoming_call_disp.item.set_data({
          id:data, display_name:data, icon:path+"skype/img/angel_skype.png",
          mood_text:"",
          status:"online",
        });

        var answer = true;
        start_call(null, "video", function() {
          sphere_list.appear(function() {
            sphere_list.set_visible();
          } );
        }, answer);

        break;
       case SKYPE_CALL_MEMBER_ON_CHANGE_EV:
        console.log("JsCallMemberOnChange", data);
        if (data == "INPROGRESS") {
          Loading.off();
          webcam.play_on();
          call_duration.appear();
          call_duration.start();
          return;
        } else if (data == "FINISHED") {
          if (hook_answered) {
            hook_answered = false;
            return;
          }

          call_end(function() {
            if (ENABLE_EBUS) ebus.skype.request(SKYPE_GET_CONTACT_LIST);
            if (!ENABLE_EBUS) {
              scroll_list_manager.appear("contact_list", function() {
                common_key.set_cursor(sobj, scroll_list_manager);
                enable_keyhook = true;
              });
            }
          });
        } else if (data == "MISSED") {
          if (notify_call.visible_p)  {
            notify_call.disappear(function() {
              common_key.set_cursor(sobj, sphere_list);
            });
          }
        } else if (data == "REFUSED" || data == "CANCELLED") {

          if (notify_call.visible_p) {
            notify_call.disappear(function() {
              common_key.set_cursor(sobj, sphere_list);
            });
            return;
          }

          if (webcam.video.visible_p) {
            call_end(function() {
              ebus.skype.request(SKYPE_GET_CONTACT_LIST);
            });
          }

        } else if (data == "BOTH_ENABLED") {
          console.log("start_video");
          ebus.skype.request(SKYPE_START_VIDEO);
        }
        break;
      default:
        console.log ("unknown event");
      }
    }
  }
  sobj.add_event_hook (ebus.skype, skype_event_hook);

}

if( DEMO_MODE ){
  skype_main.components.push(
    new gtext({
      "translate":[0+1, 508-1, 0],
      "width":1800,
      "height":64,
      "color":[0xff,0xff,0xff,179],
      //"color": MSG_COLOR ? MSG_COLOR : [0x7f, 0x7f, 0x7f, 255],
      text: MSG_DEMONSTRATION ? MSG_DEMONSTRATION : "Demonstration" ,
      "font_name": "F015T-bold",
      "align": RIGHT,
    }),
    new gtext({
      "translate":[0, 508, 0],
      "width":1800,
      "height":64,
      "color": MSG_COLOR ? MSG_COLOR : [0x7f, 0x7f, 0x7f, 255],
      text: MSG_DEMONSTRATION ? MSG_DEMONSTRATION : "Demonstration" ,
      "font_name": "F015T-bold",
      "align": RIGHT,
    })
  );
}


//} catch (e) {
//  console.log(e.name + ":" + e.message);
//}
