//
// Copyright (C) 2008-2009 Panasonic Corporation. All Rights Reserved.
//

add_package_load_path( "st_util", path+"settings/pkg_st_util.js");
//add_stage_load_path( "st_mainmenu", path+"settings/st_mainmenu.js");
//add_package_load_path("abstract", path+"abstract.js");

(function(){
var set = new Icon({});

set.name = "settings";

// [private]
set.logo_src  = path + "settings/settings-logo.png";
set.vc_src    = path + "settings/viera-cast02.png";
set.image_src = path + "settings/monkey-wrench.png";
//set.lock_src = path + "settings/locked.png";

set.TEXT = {
  "en-US" : {
    "SETTINGS" : "Settings",
    "SETTINGS_font_size" : 35,
  },
  "es-US" : {
    "SETTINGS" : "Configuración",
    "SETTINGS_font_size" : 32,
  },
  "fr-CA" : {
    "SETTINGS" : "Réglages",
    "SETTINGS_font_size" : 35,
  },
  "en-GB" : {
    "SETTINGS" : "Setup",
    "SETTINGS_font_size" : 35,
  },
  "hu-HU" : {
    "SETTINGS" : "Beállítások",
    "SETTINGS_font_size" : 35,
  },
  "hr-HR" : {
    "SETTINGS" : "Postavljanje",
    "SETTINGS_font_size" : 35,
  },
  "cs-CZ" : {
    "SETTINGS" : "Nastavení",
    "SETTINGS_font_size" : 35,
  },
  "ru-RU" : {
    "SETTINGS" : "Установки",
    "SETTINGS_font_size" : 35,
  },
  "bg-BG" : {
    "SETTINGS" : "Настройки",
    "SETTINGS_font_size" : 35,
  },
  "ro-RO" : {
    "SETTINGS" : "Setare",
    "SETTINGS_font_size" : 35,
  },
  "sk-SK" : {
    "SETTINGS" : "Ďalšie nastavenia",
    "SETTINGS_font_size" : 26,
  },
  "sl-SI" : {
    "SETTINGS" : "Nastavitev",
    "SETTINGS_font_size" : 35,
  },
  "pl-PL" : {
    "SETTINGS" : "Ustawianie",
    "SETTINGS_font_size" : 35,
  },
  "sr-YU" : {
    "SETTINGS" : "Postavka",
    "SETTINGS_font_size" : 35,
  },
  "de-DE" : {
    "SETTINGS" : "Setup",
    "SETTINGS_font_size" : 35,
  },
  "es-ES" : {
    "SETTINGS" : "Configuración",
    "SETTINGS_font_size" : 32,
  },
  "nl-NL" : {
    "SETTINGS" : "Instellingen",
    "SETTINGS_font_size" : 35,
  },
  "no-NO" : {
    "SETTINGS" : "Oppsett",
    "SETTINGS_font_size" : 35,
  },
  "fi-FI" : {
    "SETTINGS" : "Asetukset",
    "SETTINGS_font_size" : 35,
  },
  "fr-FR" : {
    "SETTINGS" : "Configuration",
    "SETTINGS_font_size" : 32,
  },
  "da-DK" : {
    "SETTINGS" : "Indstilling",
    "SETTINGS_font_size" : 35,
  },
  "tr-TR" : {
    "SETTINGS" : "Kurulum Ayarı",
    "SETTINGS_font_size" : 30,
  },
  "it-IT" : {
    "SETTINGS" : "Impostazione",
    "SETTINGS_font_size" : 32,
  },
  "sv-SE" : {
    "SETTINGS" : "Inställningar",
    "SETTINGS_font_size" : 32,
  },
  "pt-PT" : {
    "SETTINGS" : "Configuração",
    "SETTINGS_font_size" : 32,
  },
  "el-GR" : {
    "SETTINGS" : "Ρυθμίσεις",
    "SETTINGS_font_size" : 35,
  },
  "et-EE" : {
    "SETTINGS" : "Seadistus",
    "SETTINGS_font_size" : 35,
  },
  "lv-LV" : {
    "SETTINGS" : "Iestatīšana",
    "SETTINGS_font_size" : 35,
  },
  "lt-LT" : {
    "SETTINGS" : "Sąranka",
    "SETTINGS_font_size" : 35,
  },
}
set.TEXT[ "en-IE" ] = set.TEXT[ "en-GB" ];
set.TEXT[ "en-BR" ] = set.TEXT[ "en-GB" ];
set.TEXT[ "es-BR" ] = set.TEXT[ "es-US" ];
set.TEXT[ "pt-BR" ] = set.TEXT[ "pt-PT" ];

set.lang = ureg.read("language");
if( !set.TEXT[ set.lang ]){
  if (ureg.read("market") == "EU") {
    set.lang = "en-IE";
  } else {
    set.lang = "en-US";
  }
  console.log("[ST] cannot read \"language\" " + ureg.read("language") + ". use default \"" + set.lang + "\".");
}
//add_package_load_path ("lang_settings", path + "settings/pkg_lang_settings_" + set.lang + ".js");

set.mainPanel = null;
set.setPanel = function (){
  // mainPanel
  var p = new container ({});
  p.components = [
    p.back    = new gbox({ width:360, height:252, color:[0,33,74,255] }),
    p.logo    = new gimage({translate: [0,96,0], src: this.logo_src,
			    onload: NULL_FUNCTION}),
    p.caption = new gtext({ translate: [0,96,0], width:340, color:[0,0,0,255],
			    align:CENTER, font_name: "F015T-bold",
			    font_size: this.TEXT[this.lang].SETTINGS_font_size}),
    p.vc      = new gimage({translate: [0,-101,0], src: this.vc_src,
			    onload: NULL_FUNCTION}),
    p.image   = new gimage({translate: [0,-12,0],
			    onload: NULL_FUNCTION}),
    p.lock = new gimage({ src:"", onload:NULL_FUNCTION,
			  width:42*2,height:40*2,
			  translate:[60,-20,0],
			  color:[120,120,120,160] }),
  ];
  this.components.push( p );
  this.mainPanel = p;
};



set.setAlpha = function(alpha){
  var v = (alpha==255);
  var p = this.mainPanel;
  p.back.color[3]  = alpha;
  p.logo.color[3]  = alpha;
  p.vc.color[3]    = alpha;
  p.image.color[3] = alpha;
  p.caption.visible_p = v;
}

set.freeResource = function () {
  this.mainPanel.logo.src  = "";
  this.mainPanel.vc.src    = "";
  this.mainPanel.image.src = "";
  setf_text(this.mainPanel.caption, "");
}

set.resumeResource = function () {
  this.mainPanel.logo.src  = this.logo_src;
  this.mainPanel.vc.src    = this.vc_src;
  this.mainPanel.image.src = this.image_src;
  setf_text(this.mainPanel.caption, this.TEXT[this.lang].SETTINGS);
}

set.getFrameColor = function (){
  return [99,151,184,255];
}

/*set.lock = function(){
  this.mainPanel.lock.src = this.lock_src;
  }*/

/*set.unlock = function(){
  this.mainPanel.lock.src = "";
  }*/


//// END
set.setPanel();
set.resumeResource();
return set;
 })();
