//
// Copyright (C) 2008-2009 Panasonic Corporation. All Rights Reserved.
//


add_package_load_path ("pw_util",path + "picasa/pkg_pw_util.js");
add_package_load_path ("pw_popup", path + "picasa/pkg_pw_popup.js"); //Picasa Shortcut
add_package_load_path ("pw_scroll_class", path + "picasa/pkg_pw_scroll_class.js"); //Picasa Shortcut

add_stage_load_path ("pw_mainmenu", path + "picasa/pw_mainmenu.js");
add_stage_load_path ("pw_myphotos", path + "picasa/pw_myphotos.js");//shortcut

(function(){
var pw = new Icon({});

pw.name = "picasa";

// [private]
pw.logo_src = path + "picasa/picasa-logo.png";

pw.TEXT = {
  "en-US":{
    ICON_TITLE: "Featured Photos",
    LOCKED: "Locked.",
  },
  "es-US":{
    ICON_TITLE: "Fotos en portada",
    LOCKED: "Bloqueado",
  },
  "fr-CA":{
    ICON_TITLE: "Photos sélectionnées",
    LOCKED: "Bloqué",
  },
  "en-GB":{
    ICON_TITLE: "Featured Photos",
    LOCKED: "Locked.",
  },
  "es-ES":{
    ICON_TITLE: "Fotos destacadas",
    LOCKED: "Bloqueado",
  },
  "fr-FR":{
    ICON_TITLE: "Sélection de photos",
    LOCKED: "Bloqué",
  },
  "de-DE":{
    ICON_TITLE: "Empfohlene Fotos",
    LOCKED: "Gesperrt",
  },
  "it-IT":{
    ICON_TITLE: "Foto in primo piano",
    LOCKED: "Bloccato.",
  },
}
pw.TEXT["en-IE"] = pw.TEXT["en-GB"];
pw.TEXT["en-BR"] = pw.TEXT["en-GB"];
pw.TEXT["es-BR"] = pw.TEXT["es-US"];


pw.lang = ureg.read("language");
if( !pw.TEXT[ pw.lang ]){
  if (ureg.read("market") == "EU") {
    pw.lang = "en-IE";
  } else {
    pw.lang = "en-US";
  }
  console.log("[PW] cannot read \"language\" " + ureg.read("language") + ". use default \"" + pw.lang + "\".");
}
add_package_load_path ("lang_picasa", path + "picasa/pkg_lang_picasa_" + pw.lang + ".js");


pw.feed = {};
pw.feed.data = null;
pw.feed.http_req_id = -1;
pw.feed.country = "00";
pw.getFeed = function( data_url, data_obj ) {
  cancel_http_request( data_obj.http_req_id );
  data_obj.http_req_id = http_request ({
    "url": data_url,
    "method": "GET",
    "onload": function (status, header, body) {
      if (status == 200) {
	body = body.replace(/\u2028/g," ");
	body = body.replace(/\u000D/g," ");
	data_obj.data = eval("("+body+")");
	pw.mainPanel.thumb.initImage(data_obj.data.contents[0].thumbnail);
	pw.anim_num ++;
	pw.ready = true;
      }
    },
    "sync": false,
  });
}

pw.loadFeed = function(){
  this.ready = false;
  this.anim_ready = false;

  if (this.feed.data) {
    this.ready = true;
    return;
  }

  this.getFeed(
    MyHostName+"picasa/featured?start-index=1&max-results=35&thumbsize=144",
    this.feed );
};


pw.mainPanel = null;
pw.lockPanel = null;
pw.setPanel = function (){
  // mainPanel
  var p = new container ({});
  p.components = [
    p.back    = new gbox({ width:360, height:252, color:[0,0,0,255] }),
    p.logo    = new gimage({translate: [0,96,0], src: this.logo_src,
			    onload: NULL_FUNCTION}),
    p.thumb   = new WipeGimage ( {"translate":[0,-30,0]}, 360, 192 ),
    p.label   = new gbox ({ translate: [0,-109,0], width:360, height:34,
			    color:[0,0,0,153] }),
    p.caption = new gtext({ translate: [0,-105,0], width:340,
			    font_size: 26, omitter: "..."})
  ];
  p.thumb.checkImage(true);
  this.components.push( p );
  this.mainPanel = p;

  // lockPanel
  var q = new container ({visible_p:false});
  q.components = [
    q.back    = new gbox({ width:360, height:252, color:[10,64,0,255]}),
    q.logo    = new gimage({src: this.logo_src, onload: NULL_FUNCTION}),
    q.caption = new gtext({ translate: [0,-80,0], width:340, align: CENTER,
			    font_name: "F015T-bold",
                            color: [150,150,150,255], font_size: 42})
  ];
  this.components.push( q );
  this.lockPanel = q;
};

pw.setLock = function( b ){
  this.mainPanel.visible_p = !b;
  this.lockPanel.visible_p = b;
}

pw.isLock = function(){
  return this.lockPanel.visible_p;
}


// [public]
pw.lock = function(){
  this.setLock( true );
}
pw.unlock = function(){
  this.setLock( false );
}

pw.anim_num = 1; // private
pw.anim_ready = false; // private
pw.animation = function( count ){
    if( this.isLock() )
      return;
  if(count==16){
    this.anim_ready = true;
    this.anim_num ++;
    var num = this.anim_num%6;
    //this.mainPanel.thumb.setImage( this.feed.data.contents[num].thumbnail);
    this.mainPanel.thumb.setImage(path + "picasa/thumb"+ (num+1) + ".jpg");
  }
  if (this.anim_ready) {
    this.mainPanel.thumb.animation( count );
  }
}

pw.ready = false; // private

pw.enter_focus = function(){
  if( this.isLock() == false ){
    append_timer( this, 600, function(obj,cnt){
      switch (cnt) {
      case 1:
	prepare_package( "lang_picasa" );
      //prepare_package( "pkg_common_feed" );
	break;
      case 2:
	prepare_package ("common_menu");
	prepare_package ("pw_util");
	break;
      case 3:
	prepare_stage( "pw_mainmenu" );
      //prepare_package ("msgbox");
	break;
      default:
	delete_timer(obj);
      }});
  }
}
pw.leave_focus = function(){
  if( this.isLock() )
    return;
  delete_timer( this );
  discard_stage( "pw_mainmenu" );
}

pw.enter_stage = function(){
    //this.loadFeed();
    this.mainPanel.thumb.visible_p = true;
    this.mainPanel.thumb.initImage( path + "picasa/thumb1.jpg");
  discard_stage( "pw_myphotos" );
}
pw.leave_stage = function(){
  delete_timer( this );
  this.mainPanel.thumb.clearImage();
  this.mainPanel.thumb.visible_p = false;
}

pw.action = function(){
  if (this.isLock())
    return;
  on_stage( "pw_mainmenu" );
}

pw.setAlpha = function(alpha){
  var v = (alpha==255);

  var p = this.mainPanel;
  p.back.color[3] = alpha;
  p.logo.color[3] = alpha;
  p.thumb.visible_p   = v;
  p.label.visible_p   = v;
  p.caption.visible_p = v;

  var q = this.lockPanel;
  q.back.color[3] = alpha;
  q.logo.color[3] = alpha;
  q.caption.visible_p = v;
}

pw.freeResource = function ()
{
  this.mainPanel.logo.src = "";
  this.lockPanel.logo.src = "";
  setf_text(this.mainPanel.caption, "");
  setf_text(this.lockPanel.caption, "");
}

pw.resumeResource = function ()
{
  this.mainPanel.logo.src = this.logo_src;
  setf_text(this.mainPanel.caption, this.TEXT[this.lang].ICON_TITLE);
  this.lockPanel.logo.src = this.logo_src;
  setf_text(this.lockPanel.caption, this.TEXT[this.lang].LOCKED);
}

pw.getFrameColor = function (){
  return [0, 153, 43, 255];
}

//// END
pw.setPanel();
pw.resumeResource();
return pw;
 })();
