//
// Copyright (C) 2008-2009 Panasonic Corporation. All Rights Reserved.
//


const CAMERA_POS = -1661.036724459;
const BG_COLOR = [1, 23, 46, 255];
const NULL_FUNCTION = function(){return null;};

const plist = [   // Position list
  [-640+18,  370, 0],
  [   0,  370, 0],
  [ 640-18,  370, 0],
  [-640+18,   0, 0],
  [ 640-18,   0, 0],
  [-640+18, -370-1, 0],
  //  [   0, -360, 0],
  [ 640-18, -370-1, 0],
];

const ICON_SIZE = [360,252];

const LAYER_DISTANCE = 180;//240;
const BILLIARD_COUNT = 6;
const BILLIARD_Z_UNIT = LAYER_DISTANCE/BILLIARD_COUNT;
const MOREBACK_COUNT = 8;
const MOREBACK_Z_UNIT = LAYER_DISTANCE/MOREBACK_COUNT;


var LANG_HS = null;
var hs_enable_keyhook = false;


// @@GLOBAL_VARIABLES

// @-PATH
MyHostName = "file:///nv/demo/";
MyHostNameS = MyHostName;
path = MyHostName;




/*
if(nvram[0].read("beep") == "off"){
  try{
    system.effect_sound.mute = true;
  }catch(e){
    disable_click_sound();
  }
}
*/



// @@TV
var bplayer = new BroadcastPlayer ();
function connect_bplayer(){
  bplayer.connect (VideoDev, AudioDev);
  set_screen_mode (PIP_EXVIDEO_MODE);
};
connect_bplayer();


function disconnect_bplayer(){
  set_screen_mode (OSD_ONLY_MODE);
  bplayer.disconnect ();
}


// @@Translation
/* "MORE" and "BACK" : Optional */
var TRANS_TEXT = {
  "en-US" : {
    SPACE_TITLE : "COMING SOON",
    SPACE_TITLE_FONT_SIZE : 27,
    "PLEASE_CONFIRM_CLOCK_SETTING" : "Please confirm clock setting.",
    "DEMO":  "Demonstration",
  },
  "es-US" : {
    SPACE_TITLE : "Próximamente",
    SPACE_TITLE_FONT_SIZE : 27,
    "PLEASE_CONFIRM_CLOCK_SETTING" : "Confirmar configuración de reloj.",
    "DEMO":  "Demostración",
  },
  "fr-CA" : {
    SPACE_TITLE : "BIENTÔT DISPONIBLE",
    SPACE_TITLE_FONT_SIZE : 27,
    "PLEASE_CONFIRM_CLOCK_SETTING" : "Vérifiez le réglage de l’horloge.",
    MORE: "Suiv.",
    BACK: "Préc.",
    "DEMO":  "Démonstration",
  },
  "en-GB" : {
    SPACE_TITLE : "COMING SOON",
    SPACE_TITLE_FONT_SIZE : 27,
    "DEMO":  "Demonstration",
  },
  "hu-HU" : {
    SPACE_TITLE : "HAMAROSAN JÖN",
    SPACE_TITLE_FONT_SIZE : 27,
    MORE: "Tovább",
    BACK: "Vissza",
    "DEMO" : "Bemutatás",
  },
  "hr-HR" : {
    SPACE_TITLE : "USKORO",
    SPACE_TITLE_FONT_SIZE : 27,
    MORE: "Dalje",
    BACK: "Natrag",
    "DEMO" : "Demonstracija",
  },
  "cs-CZ" : {
    SPACE_TITLE : "BRZY UVIDÍTE",
    SPACE_TITLE_FONT_SIZE : 27,
    MORE: "Dozadu",
    BACK: "Vpřed",
    "DEMO" : "Předvedení",
  },
  "ru-RU" : {
    SPACE_TITLE : "СКОРО",
    SPACE_TITLE_FONT_SIZE : 27,
    MORE: "ЕЩЕ",
    BACK: "НАЗАД",
    "DEMO" : "Демонстрация",
  },
  "bg-BG" : {
    SPACE_TITLE : "ПРЕДСТОЯЩО",
    SPACE_TITLE_FONT_SIZE : 27,
    MORE: "ОЩЕ",
    BACK: "НАЗАД",
    "DEMO" : "Демонстрация",
  },
  "ro-RO" : {
    SPACE_TITLE : "ÎN CURÂND",
    SPACE_TITLE_FONT_SIZE : 27,
    MORE: "Altele",
    BACK: "Înapoi",
    "DEMO" : "Demonstraţie ",
  },
  "sk-SK" : {
    SPACE_TITLE : "UŽ ČOSKORO",
    SPACE_TITLE_FONT_SIZE : 27,
    MORE: "ĎALEJ",
    BACK: "SPÄŤ",
    "DEMO" : "Ukážka",
  },
  "sl-SI" : {
    SPACE_TITLE : "Kmalu tudi pri vas",
    SPACE_TITLE_FONT_SIZE : 27,
    MORE: "VEČ",
    BACK: "NAZAJ",
    "DEMO" : "Predstavitev",
  },
  "pl-PL" : {
    SPACE_TITLE : "DOSTĘPNE WKRÓTCE",
    SPACE_TITLE_FONT_SIZE : 27,
    MORE: "Więcej",
    BACK: "Powrót",
    "DEMO" : "Demonstracja",
  },
  "sr-YU" : {
    SPACE_TITLE : "USKORO",
    SPACE_TITLE_FONT_SIZE : 27,
    MORE: "Još",
    BACK: "Nazad",
    "DEMO" : "Demonstracija",
  },
  "de-DE" : {
    SPACE_TITLE : "BALD ERHÄLTLICH",
    SPACE_TITLE_FONT_SIZE : 27,
    MORE: "Mehr",
    BACK: "Zurück",
    "DEMO" : "Demonstration",
  },
  "es-ES" : {
    SPACE_TITLE : "PRÓXIMAMENTE",
    SPACE_TITLE_FONT_SIZE : 27,
    MORE: "MÁS",
    BACK: "ATRÁS",
    "DEMO" : "Demostración",
  },
  "nl-NL" : {
    SPACE_TITLE : "BINNENKORT",
    SPACE_TITLE_FONT_SIZE : 27,
    MORE: "VERDER",
    BACK: "TERUG",
    "DEMO" : "Demonstratie",
  },
  "no-NO" : {
    SPACE_TITLE : "KOMMER SNART",
    SPACE_TITLE_FONT_SIZE : 25,
    MORE: "MER",
    BACK: "TILB.",
    "DEMO" : "Demonstrasjon",
  },
  "fi-FI" : {
    SPACE_TITLE : "TULOSSA PIAN",
    SPACE_TITLE_FONT_SIZE : 27,
    MORE: "Lisää",
    BACK: "Taakse",
    "DEMO" : "Esittely",
  },
  "fr-FR" : {
    SPACE_TITLE : "PROCHAINE SORTIE",
    SPACE_TITLE_FONT_SIZE : 27,
    MORE: "Plus",
    BACK: "Retour",
    "DEMO" : "Démonstration",
  },
  "da-DK" : {
    SPACE_TITLE : "KOMMER SNART",
    SPACE_TITLE_FONT_SIZE : 25,
    MORE: "MERE",
    BACK: "TILB.",
    "DEMO" : "Demonstration",
  },
  "tr-TR" : {
    SPACE_TITLE : "ÇOK YAKINDA",
    SPACE_TITLE_FONT_SIZE : 27,
    MORE: "İLERİ",
    BACK: "GERİ",
    "DEMO" : "Tanıtım",
  },
  "it-IT" : {
    SPACE_TITLE : "PROSSIMAMENTE",
    SPACE_TITLE_FONT_SIZE : 23,
    MORE: "AVANTI",
    BACK: "IND.",
    "DEMO" : "Dimostrazione",
  },
  "sv-SE" : {
    SPACE_TITLE : "KOMMER SNART",
    SPACE_TITLE_FONT_SIZE : 25,
    MORE: "MER",
    BACK: "BAKÅT",
    "DEMO" : "Demonstration",
  },
  "pt-PT" : {
    SPACE_TITLE : "Disp. Brevemente",
    SPACE_TITLE_FONT_SIZE : 27,
    MORE: "Mais",
    BACK: "Voltar",
    "DEMO" : "Demonstração",
  },
  "el-GR" : {
    SPACE_TITLE : "ΠΡΟΣΕΧΩΣ",
    SPACE_TITLE_FONT_SIZE : 27,
    MORE: "Εμπροσ",
    BACK: "Πισω",
    "DEMO" : "Επίδειξη",
  },
  "et-EE" : {
    SPACE_TITLE : "TULEKUL",
    SPACE_TITLE_FONT_SIZE : 27,
    MORE: "Edasi",
    BACK: "Tagasi",
    "DEMO" : "Demonstratsioon",
  },
  "lv-LV" : {
    SPACE_TITLE : "Drīzumā",
    SPACE_TITLE_FONT_SIZE : 27,
    MORE: "VAIRĀK",
    BACK: "ATP.",
    "DEMO" : "Demonstrācija",
  },
  "lt-LT" : {
    SPACE_TITLE : "JAU GREITAI",
    SPACE_TITLE_FONT_SIZE : 27,
    MORE: "Pirmyn",
    BACK: "Atgal",
    "DEMO" : "Demonstravimas",
  },
  "en-BR" : {
    SPACE_TITLE : "COMING SOON",
    SPACE_TITLE_FONT_SIZE : 27,
    MORE: "MORE",
    BACK: "BACK",
    "DEMO":  "Demonstration",
  },
  "es-BR" : {
    SPACE_TITLE : "Próximamente",
    SPACE_TITLE_FONT_SIZE : 27,
    MORE: "Más",
    BACK: "Atrás",
    "DEMO":  "Demostración",
  },
  "pt-BR" : {
    SPACE_TITLE : "Em breve",
    SPACE_TITLE_FONT_SIZE : 27,
    MORE: "Mais",
    BACK: "Voltar",
    "DEMO" : "Demonstração",
  },
};
TRANS_TEXT[ "en-IE" ] = TRANS_TEXT[ "en-GB" ];





// @-lang
var setGlobal_lang = function(){
  lang = 0; // 0:English , 1:Spanish, 2: French
  if (system.language.indexOf("en") == 0) {
    lang = 0;
  } else if (system.language.indexOf("es") == 0) {
    lang = 1;
  } else if (system.language.indexOf("fr") == 0) {
    lang = 2;
  }
}();

// @-ureg
//     registerApp(), read(AppName) , write(AppName,strData)
var ajaxce_ureg_init = function(){
  const MAXLEN = 1024;
  var isString = function(obj){
    if(obj == null)
      return false;
    return (typeof(obj)=="string" || obj instanceof String);
  }

  var ureg = new Object();
  ureg.root = new Object();

  ureg.RegisterApp = function(AppName){
    ureg.root[AppName] = new String("nodata");
  }
  ureg.read = function(AppName){
    try {
      return ureg.root[AppName];
    }catch(e){
      return false;
    }
  }
  ureg.copy = function(AppName){
    try {
      var ret =new String(ureg.root[AppName]);
      return ret;
    }catch(e){
      return false;
    }
  }
  ureg.write = function(AppName,string){
    if(isString(string)==false){
      return false;
    }
    if(string.length > MAXLEN)
      return false;
    for(var p in ureg.root){
      if(p == AppName){
        return ureg.root[AppName] = new String(string);
      }
    }
    return false;
  }
  return ureg;
}
ureg = ajaxce_ureg_init();



// @ version_more_than
// Check Current Version
/*
version_more_than = function(t_version) {
  var t_ver = t_version;
  var p_ver = system.player_version;

  t_ver = t_ver.split(".");
  p_ver = p_ver.split(".");

  for (var i = 0; i < t_ver.length; i++) {
    if (parseInt(t_ver[i]) < parseInt(p_ver[i])) {
      return true;
    } else if (parseInt(t_ver[i]) > parseInt(p_ver[i])) {
      return false;
    }
  }
  return true;
}
*/



///////////////////////////////////////
// for Debug
//   debug.level:
//     0 = No Message(release) ,
//     1 = FATAL   , 2 = ERROR
//     3 = WARNING , 4 = information
var level = 3;
function setDebugLevel( num ){
  if( !(num<0) && !(4<num) ){
    level = num;
  }else{
    error("Illegal Debug Level.(0-4)");
  }
}


var regexp = new RegExp("\n","g");
function fatal( msg ){
  if( 1 <= this.level )
    console.log("  [*FATAL*] " + msg.toString().replace( regexp, "\n            ") );
}
function error( msg ){
  if( 2 <= this.level )
    console.log("  [*ERROR*] " + msg.toString().replace( regexp, "\n            ") );
}
function warn( msg ){
  if( 3 <= this.level )
    console.log("  [WARNING] " + msg.toString().replace( regexp, "\n            ") );
}
function info( msg ){
  if( 4 <= this.level )
    console.log("  [ INFO  ] " + msg.toString().replace( regexp, "\n            ") );
}



/* [Test] debug print */
var showDebugLevel = function(){
  console.log("\n _______________________________________");
  console.log("|  \"Function Test\" <Debug Level Check>  |\n");
  fatal("Level.1 : Fatal message ON");
  error("Level.2 : Error message ON");
  warn( "Level.3 : Warn  message ON");
  info( "Level.4 : Info  message ON");
  console.log("|_______________________________________|\n");
}();
//




/* common_key */
var action_flag = false;
var bAnimating = false;

function make_common_key(){
  common_key = {};

  common_key.set_cursor = function(sobj, cobj){
    var old = sobj.cursor;
    if (old == cobj)
      return;
    if (old) {
      if (old.leave_focus)
	old.leave_focus (old);
      old.in_cursor = false;
      old.toggle_cursor = false;
    }
    if (cobj) {
      if (cobj.enter_focus)
	cobj.enter_focus (cobj);
      cobj.in_cursor = true;
    }
    sobj.cursor = cobj;
  }

  common_key.find_key_move = function(stg, cobj){
    var key_array = stg.key_move;
    if (!key_array)
      return null;
    for (var i = 0; i < key_array.length; i++) {
      if (key_array[i][0] == cobj){
	return key_array[i];}
    }
    return null;
  }

  common_key.key_action_actor = function(aobj){
    if (aobj.action){
      aobj.action (aobj);
    }else {
      append_timer (aobj, 250,
		    function (obj, count) {
		      if (count >= 4){
			delete_timer (obj);
			obj.toggle_cursor = false;
		      } else {
			obj.toggle_cursor = !obj.toggle_cursor;
		      }
		      force_redraw ();
		    });
      aobj.toggle_cursor = true;
    }
  }

  common_key.key_action_stage = function(sobj, n){
    var cobj = sobj.cursor;
    if (n > 4 || !cobj)
      return;
    if (n == 4)
      common_key.key_action_actor (cobj, n);
    else {
      while (1) {
	var next;
	var key_move = common_key.find_key_move (sobj, cobj);
	if (!key_move)
	  break;
	next = key_move [n+1];
	if (!next)
	  break;
	if (!next.visible_p) {
	  cobj = next;
	  continue;
	}
	common_key.set_cursor (sobj, next);
	break;
      }
    }
  }

  // for disabling key input during animation
  common_key.disable_ow_emul_hook2 = function(){
    bAnimating = true;
  }

  common_key.enable_ow_emul_hook2 = function(){
    bAnimating = false;
  }

  common_key.old_way_emulate_hook = function( up_down, key){
    return common_key.old_way_emulate_hook2( this, up_down, key );
  }

  common_key.old_way_emulate_hook2 = function(stg, up_down, key){
    if (up_down != KEY_PRESS)
      return false;

    if (action_flag==true){
      delete_timer (stg.cursor);
      stg.toggle_cursor = true;
    };

    if (bAnimating==true){
      //console.log("Skip Key Input");
      return false;
    }

    play_click_sound(0);

    switch (key) {
    case TXK_UP:
      common_key.key_action_stage (stg, 0);
      break;
    case TXK_DOWN:
      common_key.key_action_stage (stg, 1);
      break;
    case TXK_LEFT:
      common_key.key_action_stage (stg, 2);
      break;
    case TXK_RIGHT:
      common_key.key_action_stage (stg, 3);
      break;
    case TXK_ENTER:
      common_key.key_action_stage (stg, 4);
      break;
    case TXK_RED:
    case TXK_GREEN:
    case TXK_BLUE:
    case TXK_YELLOW:
    case TXK_D1:
    case TXK_D2:
    case TXK_D3:
    case TXK_D4:
    case TXK_D5:
    case TXK_D6:
    case TXK_D7:
    case TXK_D8:
    case TXK_D9:
    case TXK_D0:
    case TXK_ASTERISK:
    case TXK_SHARP:
      break;
    default:
      return false;
      break;
    }
    force_redraw ();
    return true;
  }
}///* End of Common_key */
make_common_key();



/**** New Animation Function ****/

function make_anim(){
  anim = {}; /* Global*/
  anim.simple = function (obj, src, dst, interval, total, comp_hook, redraw_flag) {
    return this.move (obj, src, dst, interval, total, 0, 0, redraw_flag, comp_hook);
  };

  anim.in_from = {
    "near":   function (gObj, wait, hook) {
      return anim.move (gObj, [0, 0, 900], [0, 0, 0], 50, 12, wait, 0, true, hook);
    },
    "far_left": function (gObj, wait, hook) {
      return anim.move (gObj, [-2000, 0, -4000], [0, 0, 0], 50, 12, wait, 0, true, hook);
    },
    "far_right": function (gObj, wait, hook) {
      return anim.move (gObj, [+2000, 0, -4000], [0, 0, 0], 50, 12, wait, 0, true, hook);
    },
    "left":   function (gObj, wait, hook) {
      return anim.move (gObj, [-2000, 0, 0], [0, 0, 0], 50, 12, wait, 0, true, hook);
    },
    "right":  function (gObj, wait, hook) {
      return anim.move (gObj, [+2000, 0, 0], [0, 0, 0], 50, 12, wait, 0, true, hook);
    },
    "far_bottom": function (gObj, wait, hook) {
      return anim.move (gObj, [0, -2000, -4000], [0, 0, 0], 50, 12, wait, 0, true, hook);
    },
    "far_top": function (gObj, wait, hook) {
      return anim.move (gObj, [0, +2000, -4000], [0, 0, 0], 50, 12, wait, 0, true, hook);
    },
  };

  anim.out_to = {
    "near":   function (gObj, wait, hook) {
      return anim.move (gObj, [0, 0, 0], [0, 0, 900], 50, 12, wait, 0, false, hook);
    },
    "far_left": function (gObj, wait, hook) {
      return anim.move (gObj, [0, 0, 0], [-2000, 0, -4000], 50, 12, wait, 0, false, hook);
    },
    "far_right": function (gObj, wait, hook) {
      return anim.move (gObj, [0, 0, 0], [+2000, 0, -4000], 50, 12, wait, 0, false, hook);
    },
    "left":   function (gObj, wait, hook) {
      return anim.move (gObj, [0, 0, 0], [-2000, 0, 0], 50, 12, wait, 0, false, hook);
    },
    "right":  function (gObj, wait, hook) {
      return anim.move (gObj, [0, 0, 0], [+2000, 0, 0], 50, 12, wait, 0, false, hook);
    },
    "far_bottom": function (gObj, wait, hook) {
      return anim.move (gObj, [0, 0, 0], [0, -2000, -4000], 50, 12, wait, 0, false, hook);
    },
    "far_top": function (gObj, wait, hook) {
      return anim.move (gObj, [0, 0, 0], [0, +2000, -4000], 50, 12, wait, 0, false, hook);
    },
  };

  anim.move = function(gObj, src, dst, interval, total, before, after, redraw_flag, comp_hook) {
    var ret = function(){
      var period = total - before - after;
      var delta0 = (dst[0] - src[0]) / period;
      var delta1 = (dst[1] - src[1]) / period;
      var delta2 = (dst[2] - src[2]) / period;
      var onload = function (gObj, count) {
	if (count >= total) {
	  delete_timer (gObj);
	  gObj.translate[0] = dst[0];
	  gObj.translate[1] = dst[1];
	  gObj.translate[2] = dst[2];
	  if (comp_hook){
	    append_timer( gObj, 30, function(obj,count){
	      delete_timer( obj );
	      comp_hook ( obj );
	      force_redraw();
	    });
	  }
	  force_redraw();
	} else if (count >= before && count < total - after ) {
	  gObj.translate[0] += delta0;
	  gObj.translate[1] += delta1;
	  gObj.translate[2] += delta2;
	  if (redraw_flag)
	    force_redraw();
	}
      };
      gObj.translate[0] = src[0];
      gObj.translate[1] = src[1];
      gObj.translate[2] = src[2];

      delete_timer (gObj);
      append_timer (gObj, interval, onload);
    }();
    return true;
  };
}
//}();/**** End of New Animation ***/






// Load language and market from system.

/**** Language ***/
var loadSystemLanguage = function(){
  ureg.RegisterApp("language");
  if( !system.locale ){   /* PZ850U ? */
    ureg.write( "language", system.language.substr(0,5) );
  }else{                  /* '09 model (US or EU) */
    if( system.locale.language == null ||
	system.locale.language == "" ){
      ureg.write( "language", "en-US" ); /* error : default */
    }else if( system.locale.language == "en-AU" ){
      ureg.write( "language", "en-IE" );
    }else{
      ureg.write( "language", system.locale.language.substr(0,5) );
    }
  }
  return ureg.read("language");
}();


var selectTEXT = function(){
  var tmp = ureg.read("language");
  if( !TRANS_TEXT[ tmp ] ){
    warn("<HS> cannot read \"language\" " + tmp + ". "
	 + "use default \"en-US\"." );
    tmp = "en-US";
  }
  LANG_HS = TRANS_TEXT[ tmp ];

  if( LANG_HS[ "MORE" ] == undefined )
    LANG_HS[ "MORE" ] = "MORE";
  if( LANG_HS[ "BACK" ] == undefined )
    LANG_HS[ "BACK" ] = "BACK";

  MSG_DEMONSTRATION = LANG_HS["DEMO"];
  MSG_COLOR = [0x7f, 0x7f, 0x7f, 255];
}();



/**** Country ***/
var loadSystemMarket = function(){
  ureg.RegisterApp("market");
  if( !system.locale ){                               /* PZ850U ? */
    ureg.write( "market", "US" );
  }else if(system.locale.country.indexOf("US") == 0){ /* US model */
    ureg.write( "market", "US" );
  }else if(system.locale.country == null ||
	   system.locale.country == ""){              /* EU model ? (E_EU) */
    ureg.write( "market", "EU" );
  }else{                                              /* EU model */
    ureg.write( "market", "EU" );
  }
  return ureg.read("market");
}();




// @@LOAD_PATH


////////////////////////////////////////
// Stage Load Path
set_system_home_stage ("home_screen", path + "home-screen.js");
//add_stage_load_path ("disclaimer", path + "disclaimer.js");

////////////////////////////////////////
// Package Load Path
var tmp_lang = ureg.read("language").substr(0,5);

// in the near future, supports 25 languages
switch(tmp_lang) {
case "en-US":
case "es-US":
case "fr-CA":
case "en-GB":
case "en-IE":
case "hu-HU":
case "hr-HR":
case "cs-CZ":
case "ru-RU":
case "bg-BG":
case "ro-RO":
case "sk-SK":
case "sl-SI":
case "pl-PL":
case "sr-YU":
case "de-DE":
case "es-ES":
case "nl-NL":
case "no-NO":
case "fi-FI":
case "fr-FR":
case "da-DK":
case "tr-TR":
case "it-IT":
case "sv-SE":
case "pt-PT":
case "el-GR":
case "et-EE":
case "lv-LV":
case "lt-LT":
case "en-BR":
case "es-BR":
case "pt-BR":
  break;
default:
  tmp_lang = (ureg.read("market") != "US") ? "en-IE" : "en-US";
  break;
}
//add_package_load_path("lang_common", path + "lib/pkg_lang_common_" + tmp_lang + ".js");
//add_package_load_path("lang_disclaimer", path + "lib/pkg_lang_disclaimer_" + tmp_lang + ".js");
//add_package_load_path("lang_settings", path + "settings/pkg_lang_settings_" + tmp_lang + ".js");

// supports only 5 language
tmp_lang = ureg.read("language").substr(0,5);
switch(tmp_lang) {
case "en-US":
case "es-US":
case "fr-CA":
case "en-GB":
case "es-ES":
case "fr-FR":
case "de-DE":
case "it-IT":
case "en-IE":
case "en-BR":
case "es-BR":
  break;
default:
  tmp_lang = (ureg.read("market") != "US") ? "en-IE" : "en-US";
  break;
}
//add_package_load_path("lang_login_dialog",    path + "lib/pkg_lang_login_dialog_" + tmp_lang + ".js");
//add_package_load_path("common_popup",         path + "lib/pkg_common_popup.js");
add_package_load_path("common_animation",     path + "lib/pkg_common_animation.js");
add_package_load_path("common_menu",          path + "lib/pkg_common_menu.js");
//add_package_load_path("pkg_common_keyboard",  path + "lib/pkg_common_keyboard.js");
//add_package_load_path("pkg_keyboard",         path + "lib/pkg_keyboard.js");
//add_package_load_path("pkg_common_feed",      path + "lib/pkg_common_feed.js");
//add_package_load_path("pkg_common_teleinput", path + "lib/pkg_common_teleinput.js");
//add_package_load_path("msgbox",               path + "lib/pkg_msgbox.js");
//add_package_load_path("pkg_common_listbox",   path + "lib/pkg_common_listbox.js");
//add_package_load_path("login_dialog",         path + "lib/pkg_login_dialog.js");
//add_package_load_path ("pkg_common_screensaver", path + "lib/pkg_common_screensaver.js");





/// Moving Focus __________ @focus
const focus_color = [128, 230, 255, 255];
const focus_onload = function(){
  focus.loaded_image.push( true );
  if( focus.loaded_image.length == 2 ){
    focus.visible_p = true;
    delete focus.loaded_image;
    info("FOCUS IMAGE ... OK !");
  }
}

var focus = new actor({
  visible_p: false,
  translate:[0,0,100],
  rotation:[0,1,0,0],
  base_col_width : 0,
  cursor_width:10,
  bg_image:[
    new gimage({width:1920,height:26,src:path+"common/focus_line.png",draw_type:DIRECT,
		rotation:[-180,0,0,1],color:focus_color,onload:focus_onload, }),
    new gimage({width:1920,height:26,src:path+"common/focus_line.png",draw_type:DIRECT,
		rotation:[-90,0,0,1],color:focus_color,onload:NULL_FUNCTION,  }),
    new gimage({width:1920,height:26,src:path+"common/focus_line.png",draw_type:DIRECT,
		rotation:[0,0,0,1],color:focus_color,onload:NULL_FUNCTION,    }),
    new gimage({width:1920,height:26,src:path+"common/focus_line.png",draw_type:DIRECT,
		rotation:[90,0,0,1],color:focus_color,onload:NULL_FUNCTION,   }),

    new gimage({width:34,height:34,src:path+"common/focus_angle.png",draw_type:DIRECT,
		rotation:[180,0,0,1],color:focus_color,onload:focus_onload,  }),
    new gimage({width:34,height:34,src:path+"common/focus_angle.png",draw_type:DIRECT,
		rotation:[-90,0,0,1],color:focus_color,onload:NULL_FUNCTION,  }),
    new gimage({width:34,height:34,src:path+"common/focus_angle.png",draw_type:DIRECT,
		rotation:[0,0,0,1],color:focus_color,onload:NULL_FUNCTION,    }),
    new gimage({width:34,height:34,src:path+"common/focus_angle.png",draw_type:DIRECT,
		rotation:[90,0,0,1],color:focus_color,onload:NULL_FUNCTION,   }),
  ]
});

focus.RATE = 0.6;
//focus.draw_flag = true;
focus.dx = 0;
focus.dy = 0;
focus.dz = 0;
focus.dw = 0;
focus.dh = 0;
focus.max_count = 0;
focus.width = 0;
focus.height = 0;
focus.loaded_image = []; // will be deleted.

focus.moveTo = function(x,y,z,w,h,angle,end_func, rate){
  delete_timer( this );
  //  this.draw_flag = true;

  this.RATE = 0.6;
  this.max_count = 9;
  if( rate ){
    this.max_count *= this.RATE/rate;
    this.RATE = rate;
    //    this.draw_flag = false;
  }

  // start : first time (count=0)
  ////  if( this.draw_flag ) force_redraw();

  this.dx = x-this.translate[0];
  this.dy = y-this.translate[1];
  this.dz = z-this.translate[2];
  this.translate[0] += this.dx * this.RATE;
  this.translate[1] += this.dy * this.RATE;
  this.translate[2] += this.dz * this.RATE;

  this.dw = w-this.width;
  this.dh = h-this.height;
  this.da = angle-this.rotation[0];

  this.setSize(
    this.width + Math.floor(this.dw * this.RATE),
    this.height + Math.floor(this.dh * this.RATE),
    this.rotation[0] + this.da * this.RATE
  );

  // end : first time

  append_timer( this, 50, function(obj,count){
    ////    if( obj.draw_flag ) force_redraw();

    obj.dx = x-obj.translate[0];
    obj.dy = y-obj.translate[1];
    obj.dz = z-obj.translate[2];
    obj.translate[0] += obj.dx * obj.RATE;
    obj.translate[1] += obj.dy * obj.RATE;
    obj.translate[2] += obj.dz * obj.RATE;

    obj.dw = w-obj.width;
    obj.dh = h-obj.height;
    obj.setSize(
      obj.width + Math.floor(obj.dw * obj.RATE),
      obj.height + Math.floor(obj.dh * obj.RATE)
    );

    obj.da = angle-obj.rotation[0];
    obj.rotation[0] += obj.da * obj.RATE;

    if( count >= obj.max_count ){
      delete_timer( obj );
      //@  console.log("DELETE TIMER (count="+count+")");
      /////      force_redraw();

      obj.translate[0] = x;
      obj.translate[1] = y;
      obj.translate[2] = z;

      obj.setSize(w,h,angle);
      if( typeof end_func == "function"){
	end_func();
      }
    }
  });
}

focus.setSize = function(w,h,angle){
  this.width = w;
  this.height = h;

  this.bg_image[0].width = w-16;
  this.bg_image[2].width = w-16;
  this.bg_image[1].width = h-16;
  this.bg_image[3].width = h-16;

  // frame
  this.bg_image[0].translate[1] = h/2+13;
  this.bg_image[2].translate[1] = -h/2-13;
  this.bg_image[1].translate[0] = -w/2-13;
  this.bg_image[3].translate[0] = w/2+13;

  // angle
  this.bg_image[0+4].translate[1] = h/2+9;
  this.bg_image[2+4].translate[1] = -h/2-9;
  this.bg_image[1+4].translate[0] = -w/2-9;
  this.bg_image[3+4].translate[0] = w/2+9;

  this.bg_image[0+4].translate[0] = w/2+9;
  this.bg_image[2+4].translate[0] = -w/2-9;
  this.bg_image[1+4].translate[1] = h/2+9;
  this.bg_image[3+4].translate[1] = -h/2-9;

  if( typeof angle == "number" ){
    this.rotation[0] = angle;
  }
}
focus.setSize(1920,1080);



//// @COLOR_KEY
//var map_color_key = function() {
function map_color_key() {
  const RED    = [192,   0,   0, 255]; // RED
  const GREEN  = [  0, 128,  32, 255]; // GREEN
  const BLUE   = [  0,   0, 192, 255]; // BLUE
  const YELLOW = [192, 192,   0, 255]; // YELLOW

  var COLOR_KEY_TYPE = {
    "US_TYPE" : [
      { "COLOR": RED,    "KEY_CODE": TXK_RED,    },
      { "COLOR": GREEN,  "KEY_CODE": TXK_GREEN,  },
      { "COLOR": BLUE,   "KEY_CODE": TXK_BLUE,   },
      { "COLOR": YELLOW, "KEY_CODE": TXK_YELLOW, },
    ],
    "PAL_TYPE" : [
      { "COLOR": RED,    "KEY_CODE": TXK_RED,    },
      { "COLOR": GREEN,  "KEY_CODE": TXK_GREEN,  },
      { "COLOR": YELLOW, "KEY_CODE": TXK_YELLOW, },
      { "COLOR": BLUE,   "KEY_CODE": TXK_BLUE,   },
    ],
    "JP_TYPE" : [ // dummy
      { "COLOR": BLUE,   "KEY_CODE": TXK_BLUE,   },
      { "COLOR": RED,    "KEY_CODE": TXK_RED,    },
      { "COLOR": GREEN,  "KEY_CODE": TXK_GREEN,  },
      { "COLOR": YELLOW, "KEY_CODE": TXK_YELLOW, },
    ],
  };

  switch(ureg.read("market").toString()) {
  case "US":
    info("Color key type: US_TYPE");
    COLOR_KEY = COLOR_KEY_TYPE[ "US_TYPE" ];
    break;
  case "EU":
    info("Color key type: PAL_TYPE");
    COLOR_KEY = COLOR_KEY_TYPE[ "PAL_TYPE" ];
    break;
  default:
    info("Unable to judge type of COLOR_KEY.");
    COLOR_KEY = COLOR_KEY_TYPE[ "JP_TYPE" ];
    break;
  }
}






//
// draw_type is fixed. ( CIRCUMSCRIBED )
//
/**********************/
/* == WipeGimage == */
var WipeGimage = function( init ,width ,height ){
  this.base = container; // inherit
  init.components = [ ];
  this.base( init );

  this.images = [
    new gimage({
      src: null,  width: width,  height: height,
      draw_type: CIRCUMSCRIBED,
      onload:NULL_FUNCTION,
    }),
    new gbox({
      width: width,  height: height, color: [0,0,0,255]
    }),
    new gimage({
      src: null,  width: width,  height: height,
      draw_type: CIRCUMSCRIBED,
      onload:NULL_FUNCTION,
    }),
  ];

  this.width  = width;
  this.height = height;
  this.components = this.images;
}

// public
//   * String url  : URL for the new image file
WipeGimage.prototype.setImage = function( url ){
  this.anim_ready = false;
  this.images[0].src = url;
  this.images[0].height = -1;
  this.images[0].visible_p = true;
  this.images[1].height = 0;
}
WipeGimage.prototype.initImage = function(url) {
  this.anim_ready = false;
  this.images[2].src = url;
  this.images[2].height = this.height;
  this.images[1].height = 0;
  this.images[2].visible_p = true;
}
// public
WipeGimage.prototype.clearImage = function(){
  this.anim_ready = false;
  this.images[0].src = "";
  this.images[2].src = "";
  this.images[1].height = 0;
}
// public
WipeGimage.prototype.checkImage = function(b) {
  this.check_image = b;
}
// private
WipeGimage.prototype.changePosition = function(){
  this.images.reverse();
}
// private
WipeGimage.prototype.width  = -1;
// private
WipeGimage.prototype.height = -1;
// private
WipeGimage.prototype.check_image = false;
// private
WipeGimage.prototype.anim_ready = false;
// public
WipeGimage.prototype.animation = function( count ){
  var p = this.images;
  if (count == 1 && (p[0].src_width != 0 || !this.check_image)) {
    this.changePosition();
    this.anim_ready = true;
  }
  if (p[2].src_width ==0 || !this.anim_ready && this.check_image) {
    return;
  }

  var hm = Math.floor( p[2].src_height / p[2].src_width  * this.width );
  if (count == 1) {
    p[1].height = 0;
    p[2].height = -1;
  } else if (count >= 5 && count <= 13) {
    var h = Math.floor( 1.0 * this.height * (count*count) / (13*13) );
    p[1].height = (h<this.height) ? h:this.height;
    p[2].height = (h<hm) ? h:hm;
  } else if (count == 14) {
    p[1].height = this.height;
    p[2].height = (this.height < hm) ? this.height : hm;
  }
}

// @@gtriangle
// this object will be implemented by built-in class
// and shall be used instead of gpolygon!
//try {
//	new gtriangle({});
//}catch(e){
//	gtriangle = function(init)
//	{
//
//	this.translate = init.translate;
//	this.color = init.color;
//	var p = init.vertex;
//	this.vertex = [p[0][0],p[0][1],p[0][2],
//								 p[1][0],p[1][1],p[1][2],
//								 p[2][0],p[2][1],p[2][2]];
//	};
//	gtriangle.prototype = new gpolygon({});
//}



// @@Icon
// Constructor method
function Icon () {
  this.superClass = container;
  this.superClass({});
}

// Super Class
Icon.prototype = new container({});

Icon.prototype.name = "coming_soon";
Icon.prototype.baseboard = null;


Icon.prototype.lock = function(){
  return false;
};

Icon.prototype.unlock = function(){
  return false;
};

Icon.prototype.init = function(){

  // tentative
  if (this.name == Icon.prototype.name)
  {
    if (this.components.length ==0)
    {
      var backboard = new gbox({translate: [0,0,0],
	width:ICON_SIZE[0], height:ICON_SIZE[1],
	color:[24,41,66,255] });
      this.components.push( backboard );
      this.components.push(
	new gtext({
	  width:340, align:CENTER,
	  font_name: "F015T-bold",  color:[127,127,127,255],
	  font_size: LANG_HS[ "SPACE_TITLE_FONT_SIZE" ],
	}));
    }
  }
};

Icon.prototype.isReady = function(){
  return true;
};

Icon.prototype.animation = function( count ){};
Icon.prototype.key_hook = function( up_down, key ){
  if( up_down != KEY_PRESS )
    return true;
  return false;
};

Icon.prototype.enter_focus = function(){
  if (this.name == Icon.prototype.name){
    setf_text( this.components[1], LANG_HS[ "SPACE_TITLE" ] );
  }
};

Icon.prototype.leave_focus = function(){
  if (this.name == Icon.prototype.name){
    setf_text( this.components[1], "" );
  }

};

Icon.prototype.setVisible = function( b ){
  this.visible_p = b;
};

Icon.prototype.enter_stage = NULL_FUNCTION;
Icon.prototype.leave_stage = NULL_FUNCTION;

Icon.prototype.action = function(){
  throw new Error("action() is not found.");
};


Icon.prototype.setAlpha = function(alpha){
  if ( (this.name == Icon.prototype.name) && (this.components.length != 0) )
  {
    this.components[0].color[3] = alpha;
  }
};

Icon.prototype.getSecureVersion = function(){
  // return [category, major, minor];
  return null;
};

Icon.prototype.freeResource = NULL_FUNCTION;
Icon.prototype.resumeResource = NULL_FUNCTION;

Icon.prototype.getFrameColor = function(){
  return [127,127,127,255];
};







//
// From settings
//

var def_prop = {
  "name" : 0,
  "position" : 1,
  "need_check" : 2,
  "removable" : 3,
  "list_up" : 4,
};

var sort_cdata = function(cdata) {
  return cdata.sort(function(a, b) {
    return a[def_prop.position] > b[def_prop.position];
  });
};


/* cdata = cutomize data */
function convert_to_cdata(iconlst) {
  var cdata = [];
  var convert = function(name, value) {
    var a = [];
    a.push(name);
    a.push(value.position);
    a.push(value.need_check);
    a.push(value.removable);
    a.push(value.list_up);
    return a;
  };

  for (var i in iconlst)
    cdata.push(convert(i, iconlst[i]));

  sort_cdata(cdata);
  return cdata;
};

/*
function convert_to_icon_list(cdata) {
  if (!cdata) return null;

  var iconlist = {};
  for (var i = 0; i < cdata.length; i++) {
    iconlist[cdata[i][def_prop.name]] = {};
    iconlist[cdata[i][def_prop.name]].position = cdata[i][def_prop.position];
    iconlist[cdata[i][def_prop.name]].need_check = cdata[i][def_prop.need_check];
    iconlist[cdata[i][def_prop.name]].removable = cdata[i][def_prop.removable];
    iconlist[cdata[i][def_prop.name]].list_up = cdata[i][def_prop.list_up];
  }
  //console.log(iconlist.toSource());
  return iconlist;
};
*/

/*
function write_cdata(key, cdata) {
  try {
    //console.log(cdata.toSource());
    nvram[0].write(key, cdata.toSource());
    return true;
  } catch(e) {
    error("[ERROR] <" + e.name + "> " + e.message);
    return false;
  }
};
*/

/*
function read_cdata(key) {
  var cdata = null;
  try {
    cdata = eval(nvram[0].read(key));
    //console.log("read_cdata = " + cdata.toSource());
  } catch(e) {
    error("[ERROR] <" + e.name + "> " + e.message);
  }
  return cdata;
};
*/

/*
function store_icon_list(key, iconlist) {
  return write_cdata(key, convert_to_cdata(iconlist));
};
*/

/*
function get_icon_list(key) {
  var iconlist = convert_to_icon_list(read_cdata(key));
  return iconlist;
};
*/

// <END> SETTING functions




/*************************************************************/
/*                     START Homescreen                      */
/*************************************************************/



// @Baseboard
function Baseboard( appli_name ){

  this.shadow_color = this.SHADOW_COLOR.concat();//copy array
  this.shadow =  new gbox({
    width:this.SHADOW_SIZE[0],
    height:this.SHADOW_SIZE[1],
    color:this.shadow_color,
    round_enable:true,round_width:10,round_height:10,
  });

  this.frame = new gimage({
    visible_p:false,
    src:path+"common/icon_frame24.png",
    color:[200,60,60,255],
    onload:NULL_FUNCTION,
  });

  this.frame2 = new gbox({
    visible_p:false,
    width:this.SHADOW_SIZE[0]+20,
    height:this.SHADOW_SIZE[1]+20,
    color:BG_COLOR,
    round_enable:true,round_width:10,round_height:10,
  });


  this.icon_area = new container({});

  this.superClass = container;
  this.superClass({});
  this.components.push(
    this.shadow, this.frame2, this.frame, this.icon_area
  );

  if( appli_name instanceof String ){
    this.setAppliName( appli_name );
  }

}
//Baseboard.prototype = new container({})


/* static variables */
Baseboard.prototype.SHADOW_SIZE = ICON_SIZE;
Baseboard.prototype.SHADOW_COLOR = [40,64,96,255];


/* instance variables */
Baseboard.prototype.appli_name = null;
Baseboard.prototype.icon = null;
Baseboard.prototype.if_loaded_change = false;
Baseboard.prototype.is_icon_init = false;
Baseboard.prototype.is_locked = undefined;
Baseboard.prototype.is_reserved = false;

/* GUI parts */
Baseboard.prototype.shadow = null;
Baseboard.prototype.frame = null;
Baseboard.prototype.frame2 = null;
Baseboard.prototype.icon_area = null;


Baseboard.prototype.setIconVisible = function(b){
  this.frame.visible_p = b;
  this.frame2.visible_p = b;
  this.shadow.visible_p = !b;

  var icon = this.getIcon();
  if( icon != null ){
    this.icon.setVisible( b );
  }
}

Baseboard.prototype.getIcon = function(){
  if( this.icon instanceof Icon ){
    return this.icon;
  }

  if( this.appli_name == null ){
    this.icon = "new Icon()";
  }

  if( typeof this.icon == "string" ){
    info( "@Baseboard.getIcon() : eval " + this.appli_name );
    try{
      this.icon = eval( this.icon );
    }catch(e){
      error("@Baseboard: cannot eval \""+this.appli_name+"/icon.js\".");
      this.icon = new Icon();
    }
    this.icon.baseboard = this;
    this.icon_area.components.push( this.icon );

    if( this.if_loaded_change ){
      this.icon.init();
      this.icon.enter_stage();
    }

    /*if( this.is_locked == undefined ){
      this.is_locked = check_lock_needed( this.icon );
    }*/
    this.setFrameColor( this.icon.getFrameColor() );
    return this.icon;
  }else{
    this.setLoadedChange( true );
    return null;
  }
}

Baseboard.prototype.checkLockIcon = function(){
  if( !(this.icon instanceof Icon) ){
    return;
  }
  try{
    /*
    this.is_locked = check_lock_needed( this.icon );
    if( this.is_locked == false )
      this.icon.unlock();
    */
  }catch(e){
    error("Baseboard.prototype.checkLockIcon : "+e);
  }
}

Baseboard.prototype.unLockIcon = function(){
  if( this.is_locked && this.getIcon() ){
    this.icon.unlock();
  }
  this.is_locked = false;
}

Baseboard.prototype.setFrameColor = function( color ){
  this.frame.color = color;
}

Baseboard.prototype.setLoadedChange = function( if_loaded_change ){
  this.if_loaded_change = if_loaded_change;
}

Baseboard.prototype.setReserved = function( b ){
  this.is_reserved = b;
}

Baseboard.prototype.getReserved = function(){
  return this.is_reserved;
}

Baseboard.prototype.setAppliName = function( appli_name, if_loaded_change ){
  info("@Baseboard.setAppliName() : "+appli_name);

  this.is_icon_init = false;
  this.is_locked = undefined;
  this.is_reserved = true;
  this.setLoadedChange( if_loaded_change );

  this.appli_name = appli_name;
  this.setFrameColor( [255,255,255,255] );
  this.icon = null;
  this.icon_area.components = [];

  if( appli_name == null ){
    this.icon = null;
    this.setIconVisible( if_loaded_change );
    return;
  }

  var me = this;
  http_request({"url" : path + this.appli_name + "/icon.js",
 		"method" : "GET",
 		"onload" : function(status, header, body) {
		  if( status == 200 ){
		    me.icon = body;
		    if( me.if_loaded_change ){
		      me.setIconVisible(true);
		    }
		  }else{
		    error("@Baseboard : cannont GET \""+me.appli_name+"\" icon.js : status="+status);
		    me.icon = "new Icon();";
		  }
		},
 		"sync" : false,
	       });
}

Baseboard.prototype.setAlpha = function( alpha ){
  alpha = Math.floor(alpha);
  this.shadow.color[3] = alpha;
  this.frame.color[3] = alpha;

  if( alpha == 255 ){
    this.frame2.visible_p = true;
  }else{
    this.frame2.visible_p = false;
  }

  if( this.icon instanceof Icon ){
    try{
      if( this.frame.visible_p ){
	this.icon.setAlpha( alpha );
      }
    }catch(e){
      error( "[" + this.icon.name + "] icon.setAlpha("+alpha+")\n" + e.message );
    }
  }
}

Baseboard.prototype.setTranslate = function( x, y, z ){
  if( typeof x == "number" ){
    this.translate[0] = x;
  }
  if( typeof y == "number" ){
    this.translate[1] = y;
  }
  if( typeof z == "number" ){
    this.translate[2] = z;
  }
}

Baseboard.prototype.setVisible = function( b ){
  this.visible_p = b;
}

Baseboard.prototype.applyIconFunction = function( func_name, args ){
  if( this.icon instanceof Icon ){
    try{
      if( (func_name=="enter_stage") && (!this.is_icon_init) ){
	try{
	  this.icon.init();
	  this.is_icon_init = true;
	}catch( e ){
	  error( "[" + this.icon.name + "] icon.init()\n" + e.message );
	}
      }else if( (func_name == "animation") && (this.icon.isReady()==false) ){
	return;
      }else if( func_name == "enter_focus" ){
	/*
	if( check_secure_version( this.icon ) == false ){
	  update_secure_version();
	}
	*/
      }

      this.icon[ func_name ].apply( this.icon, args );
    }catch( e ){
      warn("<Exception> " + e + "\n"
	   + "@Baseboard.applyIconFunction(\""+func_name+"\", "+args+") : "+this.appli_name);
    }
  }
}

Baseboard.prototype.requestFocus = function(){
  error("@Baseboard.prototype.requestFocus() <NO ACTION>");
}

Baseboard.prototype.action = function(){
  if( this.getIcon() ){
    /*
    if( check_secure_version( this.icon ) == false ){
      throw new Error("Need to update Secure_Version. <" + this.appli_name + ">" );
    }
    */
    this.icon.action();
  }
}



// @LayerContainer
function LayerContainer(id){
  this.superClass = container;
  this.superClass({})
  this.id = id;
  this.visible_p = false;
}

LayerContainer.prototype.id = null;

LayerContainer.prototype.setComponents = function( obj_array ){
  this.components = obj_array;
}

LayerContainer.prototype.setZ = function( z, not_setAlpha ){
  this.translate[2] = z;

  if( not_setAlpha )
    return;

  if( z<=0 ){
    this.applyBaseboardFunction( "setAlpha", [Math.floor(255+z/3)] );
  }else{
    this.applyBaseboardFunction( "setAlpha", [255-z-15] );
  }
}

LayerContainer.prototype.applyBaseboardFunction = function( func_name, args ){
  for( var i=0 ; i<this.components.length ; i++ ){
    Baseboard.prototype[ func_name ].apply( this.components[i], args );
  }
}

LayerContainer.prototype.setVisible = function( b ){
  this.visible_p = b;
  if( b )
    this.applyBaseboardFunction( "setIconVisible", [b]);
}




// @FocusArea
function FocusArea( position ){
  this.position = position;
}

FocusArea.prototype.position = null;
FocusArea.prototype.requestFocus = function(){
  info("<FOCUS> " + this.position );

  focus.moveTo(
    plist[this.position][0],
    plist[this.position][1],
    plist[this.position][2],
    ICON_SIZE[0]+14,ICON_SIZE[1]+14,0 );
}

FocusArea.prototype.action = function(){
  base[ home_screen.layer ][ this.position ].action();
}

FocusArea.prototype.enter_focus = function(){
  return base[ home_screen.layer ][ this.position ].applyIconFunction("enter_focus");
}

FocusArea.prototype.leave_focus = function(){
  return base[ home_screen.layer ][ this.position ].applyIconFunction("leave_focus");
}


// @AnimationManager
var AnimationManager = {};
AnimationManager.count = 0;
AnimationManager.animation = function( obj, count ){
  delete_timer( obj );
  obj.count++;
  force_redraw();

  for( var i=0 ; i<base[home_screen.layer].length ; i++){
    base[ home_screen.layer ][i].applyIconFunction( "animation", [ obj.count ] );
  }
  AnimationManager.startAnimation( obj.count );
  if( obj.count == 60 ){
    obj.count = 0;
    //    console.log( new Date() );
  }
};

AnimationManager.startAnimation = function(){
  append_timer( this, 55, this.animation );
}

AnimationManager.pauseAnimation = function(){
  delete_timer( this );
}

AnimationManager.stopAnimation = function(){
  delete_timer( this );
  this.count = 0;
}


/****************/
/* Make Objects */
/****************/
var fposi = [];//new Array( plist.length );
for( var i = 0 ; i<plist.length ; i++ ){
  fposi.push(new FocusArea(i));
}





var base_container = new container({});

var base = [[],[],[]]; // length ==> 3-Layers
var layer_area = new Array(base.length);

for( var i=base.length-1 ; i>=0 ;i-- ){
  base_container.components.push( layer_area[i]=new LayerContainer(i) );
  layer_area[i].setComponents( base[i] );

  for( var j=0 ; j<plist.length ; j++ ){
    var tmp = null;
    tmp = new Baseboard();
    tmp.setTranslate(plist[j][0], plist[j][1], 0 );
    base[i][j] = tmp;
  }
}





// @ARROWs
const ARROW_TEXT_COLOR = [[168,168,168,255],[200,200,200,255]];
const ARROW_TEXT_COLOR2 = [[168,168,168,47],[200,200,200,47]];
const ARROW_Y = [-260,-340];//[More,Back]
const MORE_BACK_FONT_SIZE = 32*2;

/* Arrow MORE */
var arrow_more = new container({
  visible_p: false,
  translate:[0,ARROW_Y[0]*2,CAMERA_POS],
  components:[ ],
});
arrow_more.components.push(
  arrow_more.light
    = new container({
      visible_p : false,
      components:[
	new gimage({src:path+"common/arrow_more_light.png",
		    translate:[0,-16,0],
		    draw_type:DIRECT,width:191*2,height:71*2,
		    onload: NULL_FUNCTION,
		   }),
	new gtext({ text:LANG_HS.MORE,width:120*2,height:40*2,
		    translate:[126*2,-30*2 +8*2,0],
		    flip: FLIP_VERTICAL,
		    font_name:"F015T-bold",
		    font_size:MORE_BACK_FONT_SIZE,
		    color: ARROW_TEXT_COLOR2[0],
		  }),
	new gimage({ translate:[126*2,-30*2 +8*2,0],
		     visible_p: (LANG_HS.MORE!="") ? true : false,
		     src:path+"common/gradation_v.png",
		     width:120*2,height:24*2,draw_type:DIRECT,
		     flip:FLIP_VERTICAL,
		     color:BG_COLOR,
		     onload:NULL_FUNCTION,
		   }),
      ]}),

  arrow_more.image
    = new gimage({src:path+"common/arrow_more.png",
		  draw_type:DIRECT,width:78*2,height:39*2,
		  onload: NULL_FUNCTION,
		 }),
  arrow_more.enable_text
    = new gtext({text:LANG_HS.MORE,width:120*2,height:40*2,
		 translate:[126*2,8*2,0],
		 color: ARROW_TEXT_COLOR[0],
		 font_name:"F015T-bold",
		 font_size:MORE_BACK_FONT_SIZE,
		}),
  arrow_more.disable_text
    = new gtext({text:LANG_HS.MORE,width:120*2,height:40*2,
		 translate:[126*2,8*2,0],
		 font_name:"F015T-bold",
		 font_size:MORE_BACK_FONT_SIZE,
		 color:[49,66,90,255],
		 visible_p : false,
		})
);

arrow_more.animation = function(count){
  if( count == MOREBACK_COUNT ){
    this.translate[2] = CAMERA_POS;
  }else{
    this.translate[2] = CAMERA_POS-8*count;
  }
}

arrow_more.requestFocus = function(){
  focus.moveTo( (LANG_HS.MORE!="")?20:0,-400,-900,600,280,-80);
}

arrow_more.setEnable = function( b ){
  this.enable_text.visible_p = b;
  this.disable_text.visible_p = !b;
  this.image.color[3] = b ? 255 : 100;
}

arrow_more.action = function(){
  startMore();
}


arrow_more.enter_focus = function(){
  this.light.visible_p = true;
}
arrow_more.leave_focus = function(){
  this.light.visible_p = false;
}



/* Arrow BACK */
var arrow_back = new container({
  visible_p: false,
  translate:[0,ARROW_Y[1]*2,CAMERA_POS],
  components:[  ],
});

arrow_back.components.push(
  arrow_back.light
    = new container({
      visible_p : false,
      components:[
	new gimage({ src:path+"common/arrow_back_light.png",
		     translate:[0,-16,0],
		     draw_type:DIRECT,width:160*3,height:160,
		     onload: NULL_FUNCTION,
		   }),
	new gtext({ text:LANG_HS.BACK,width:128*2,height:40*2,
		    translate:[150*2,-34*2+18,0],
		    flip: FLIP_VERTICAL,
		    font_name:"F015T-bold",
		    font_size:MORE_BACK_FONT_SIZE+8,
		    color: ARROW_TEXT_COLOR2[1],
		  }),
	new gimage({ translate:[150*2,-34*2+18,0],
		     visible_p: (LANG_HS.BACK!="") ? true : false,
		     src:path+"common/gradation_v.png",
		     width:128*2,height:34*2,draw_type:DIRECT,
		     flip:FLIP_VERTICAL,
		     color:BG_COLOR,
		     onload:NULL_FUNCTION,
		   }),
      ]}),

  arrow_back.image
    = new gimage({ src:path+"common/arrow_back.png",
		   color:[255,255,255,100],
		   draw_type:DIRECT,width:124*2,height:70*2,
		   onload: NULL_FUNCTION,
		 }),
  arrow_back.enable_text
    = new gtext({ text:LANG_HS.BACK,width:128*2,height:40*2,
		  translate:[150*2,16,0],
		  color: ARROW_TEXT_COLOR[1],
		  font_name:"F015T-bold",
		  font_size:MORE_BACK_FONT_SIZE+8,
		  visible_p : false,
		}),
  arrow_back.disable_text
    = new gtext({ text:LANG_HS.BACK,width:128*2,height:40*2,
		  translate:[150*2,16,0],
		  font_name:"F015T-bold",
		  font_size:MORE_BACK_FONT_SIZE+8,
		  color:[49,66,90,255],
		})
);

arrow_back.animation = function( count ){
  if( count == MOREBACK_COUNT ){
    this.translate[2] = CAMERA_POS;
  }else{
    this.translate[2] = CAMERA_POS+8*count;
  }
}

arrow_back.requestFocus = function(){

  focus.moveTo( (LANG_HS.BACK!="")?20:0, -400-340*Math.tan(10*Math.PI/180),-560,600,300,-80);
}

arrow_back.action = function(){
  startBack();
};

arrow_back.setEnable = arrow_more.setEnable;
arrow_back.enter_focus = arrow_more.enter_focus;
arrow_back.leave_focus = arrow_more.leave_focus;

arrow_back.setEnable( false );




// @TEXT_INFORMATION
var text_information = new container({
  visible_p:false,
  translate:[0,-416,0],
  components:[
    new gtext({width:640,//height:40,
	       text:"",
	       font_size:28,align:CENTER,
	       color:[168,168,168,255],
	      })
  ]});

text_information.show = function( msg ){
/*
  delete_timer( this );
*/
  setf_text( this.components[0], msg );
  this.visible_p = true;
/*
  append_timer( this, 5000, function(obj){
    delete_timer( obj );
    obj.visible_p = false;
    setf_text( obj.components[0], "" );
  });
*/
}




// @TV
const tv_frame_onload = function(){
  tv.loaded_image.push( true );
  if( tv.loaded_image.length == 8 ){
    tv.components[0].visible_p = true;
    delete tv.loaded_image;
  }
}

const TV_SIZE = [576,324];
var tv = new Icon();
tv.action = function(){ exit(0); };
tv.translate=[0,0,-CAMERA_POS*2];
tv.loaded_image=[];
tv.components.push(
  new container({
    visible_p:false,
    translate:[0,0,CAMERA_POS],
    components:[
      new gimage({src:path+"common/tv_frame_left.png",
		  onload: tv_frame_onload,
		  translate:[-TV_SIZE[0]-16,0,0],
		  width:32, height:TV_SIZE[1]*2,draw_type:DIRECT,
		 }),
      new gimage({src:path+"common/tv_frame_right.png",
		  onload: tv_frame_onload,
		  translate:[TV_SIZE[0]+16,0,0],
		  width:32,height:TV_SIZE[1]*2,draw_type:DIRECT,
		 }),
      new gimage({src:path+"common/tv_frame_top.png",
		  onload: tv_frame_onload,
		  translate:[0,TV_SIZE[1]+16,0],
		  width:TV_SIZE[0]*2,height:32,draw_type:DIRECT,
		 }),
      new gimage({src:path+"common/tv_frame_bottom.png",
		  onload: tv_frame_onload,
		  translate:[0,-TV_SIZE[1]-18,0],
		  width:TV_SIZE[0]*2,height:34,draw_type:DIRECT,
		 }),
      new gimage({src:path+"common/tv_frame_lt.png",
		  onload: tv_frame_onload,
		  translate:[-TV_SIZE[0]-16,TV_SIZE[1]+16,0],
		  width:32,height:32,
		 }),
      new gimage({src:path+"common/tv_frame_rt.png",
		  onload: tv_frame_onload,
		  translate:[TV_SIZE[0]+16,TV_SIZE[1]+16,0],
		  width:32,height:32,
		 }),
      new gimage({src:path+"common/tv_frame_rb.png",
		  onload: tv_frame_onload,
		  translate:[TV_SIZE[0]+16,-TV_SIZE[1]-18,0],
		  width:32,height:34,
		 }),
      new gimage({src:path+"common/tv_frame_lb.png",
		  onload: tv_frame_onload,
		  translate:[-TV_SIZE[0]-16,-TV_SIZE[1]-18,0],
		  width:32,height:34,
		 }),
    ]
  }),
  new videobox ({
    translate:[0,0,0],
    "width": 576,"height": 324,
    "overscan": true,
    "color": [255, 255, 255, 0]}),
  arrow_more,
  arrow_back,
  text_information
);

tv.requestFocus = function( isSlow ){
  focus.moveTo( 0,0,-1,576+26,324+26,0, null, (isSlow==true?0.12:null) );
}




//@LOGO
var hs_logo = new gimage({
  src:path+"common/vieracast-horizontal.png",
  translate:[0,-470,-CAMERA_POS*2],
  onload: NULL_FUNCTION,});
//  new gimage({src:path+"common/panasonic-logo.png",translate:[0,-510,0], onload: NULL_FUNCTION,})



ureg.RegisterApp("stage_param");
ureg.write("stage_param","start_up");

///// Homescreen!
var home_screen = stage (
  {
    "symbol": "home_screen",
    "keep_me": true,
    "in":
    [
      {
	"from": ["default"],
	"hook": function (obj) {
	  var prev_stage = ureg.read("stage_param");
	  switch (prev_stage.substring(0)) {
	  case "start_up":
	    complete_on_stage(obj);
	    ureg.write("stage_param","home_screen");
	    //@@	    hs_enable_keyhook = true;
	    break;

	  case "home_screen":
	    delete_timer( focus );
	    focus.visible_p = false;
	    focus.translate=[0,0,100];
	    focus.setSize(1920,1080,0);/*w,h,angle*/

	    layer_area[ home_screen.layer ].applyBaseboardFunction("applyIconFunction",["leave_stage"]);
	    try{
	      home_screen.cursor.leave_focus();
	    }catch(e){
	      //No Problem
	    }

	    for(var i=0; i<base.length ;i++ ){
	      layer_area[i].setZ( 0 );
	      if( i<=home_screen.layer ){
		layer_area[i].setVisible( true );
		layer_area[i].applyBaseboardFunction( "setAlpha", [255] );
		layer_area[i].applyBaseboardFunction( "setIconVisible", [false] );
	      }
	    }

	    home_screen.layer = 0;
	    arrow_more.setEnable( true );
	    arrow_back.setEnable( false );

	    obj.move_and_focus(obj, tv);
	    break;

	  case "youtube":
	  case "bild":
	  case "skype":
	    try{
	      system.screen.set_freq( system.screen.FREQ_NATIVE );
	      warn("+++ Change Freq. ==> Native");
	    }catch(e){
	      warn("--- Cannot change freq. (Native)");
	    }
	    // not break;

	    /*
	  case "settings":
	    if( is_customized() ){
	      reset_icons();
	      load_icons();
	      obj.move_and_focus(obj, null, function(){
		layer_area[ home_screen.layer ].applyBaseboardFunction("setLoadedChange",[true]);
		layer_area[ home_screen.layer ].applyBaseboardFunction("setIconVisible",[true]);
		check_lock_state_of_all_icons();
		try{
		  home_screen.cursor.enter_focus();
		}catch(e){
		  // No Problem
		}
	      });
	      break;
	    }else{
	      // Not break
	    }
            */

	  default:
	    /*
	    if (ureg.read("user_checked_lock_state") == "true") {
	      check_lock_state_of_all_icons();
	      ureg.write("user_checked_lock_state", "false");
	    }
	    */
	    obj.move_and_focus(obj);
	    break;
	  }
	},
      },
      /*
      {
	"from": ["disclaimer"],
	"hook": function(obj){
	  complete_on_stage(obj);
	  launch_homescreen();
	},
      },
      */
    ],
    "out":
    [
      {
	"to": ["default"],
	"hook": function( obj ){
	  set_key_lock(false,"out.to<default>");
	  tv.visible_p = false;
	  hs_logo.visible_p = false;

	  disconnect_bplayer();
	  AnimationManager.stopAnimation();
	  disconnect_sc_event();

	  if( this.cursor instanceof FocusArea ){
	    var app = base[ this.layer ][ this.cursor.position ].appli_name ;
	    ureg.write("stage_param", app );
	    //start_vieracast_application( app, this.layer*plist.length+this.cursor.position );
	  }

	  anim.out_to.near( obj, 0 ,
			    function(){
			      for( var i=0 ; i<base.length ; i++ ){
				layer_area[ i ].applyBaseboardFunction("applyIconFunction",["freeResource"]);
			      }
			      complete_off_stage(obj);
			    });
	},
      },
      /*
      {
	"to": ["disclaimer"],
	"hook":function(obj){
	    //start_vieracast_application( "disclaimer", -1 );
	  complete_off_stage(obj);
	},
      },
      */
    ],
    "bg_translate": [ 0, 0, CAMERA_POS*2],
    "bg_image": [
      new gbox ({
	"width": 1920*3,
	"height": 1080*3,
	"color": BG_COLOR,}),
      tv,
      hs_logo,

      new gtext({
	rotation:[-90,0,0,1],
        "translate":[900, 0, -CAMERA_POS*2],
        "width":1080-120,
        "height":64,
        "color": [0x7f,0x7f,0x7f,0xff],
        "text": "VIERA CAST - "+ MSG_DEMONSTRATION,
        "font_name": "F015T-bold",
      }),
    ],
    "components": [  base_container, focus ],
    "key_hook": function( up_down, key ){
      if( !hs_enable_keyhook )   return true;

      if( this.cursor.key_hook && this.cursor.key_hook( up_down, key ) ){
	return true;
      }

      if( up_down!= KEY_PRESS )    return true;

      play_click_sound(0);

      var next = null;
      switch( key ){
      case TXK_EXIT: return false; // for STB

      case TXK_UP:
      case TXK_DOWN:
      case TXK_LEFT:
      case TXK_RIGHT:
	next = getNextFocusObject( this, key );
	break;

      case TXK_ENTER:
	if( this.cursor instanceof FocusArea ){
	  if( base[ home_screen.layer ][this.cursor.position].is_locked ){
	    AnimationManager.stopAnimation();
	    layer_area[ home_screen.layer ].applyBaseboardFunction("applyIconFunction",["leave_stage"]);
	    appear_kb();
	    return true;
	  }else{
	    pullBaseboard(
	      function(){
		var name = base[ home_screen.layer ][ home_screen.cursor.position ].appli_name;
		ureg.RegisterApp( name + "_icon_pos" );
		ureg.write( name+"_icon_pos", "["+plist[home_screen.cursor.position].join(",")+"]" );
		home_screen.cursor.action();
	      });
	  }
	}else if( this.cursor.action ){ // Not Application
	  home_screen.cursor.action();
	}else{
	  warn("@home_screen.key_hook : this.curosr does not have action function.");
	}
	return true;
	break;

      default:
	return false;
      }

      if( next ){
	info("NEXT CURSOR = "+next);
	setCursor( next );
      }else{
	info("Cannot find NEXT CURSOR");
      }

      return true;
    }
  });


home_screen.layer = 0;
home_screen.cursor = tv;




//////////////// Create main components

/*
ureg.RegisterApp("user_checked_lock_state");
ureg.RegisterApp("user_customized");
ureg.write("user_customized", "false");


function check_lock_state_of_all_icons(){
  info( "check_lock_state_of_all_icons()" );
  for( var i=0 ; i<layer_area.length ; i++ ){
    layer_area[i].applyBaseboardFunction("checkLockIcon")
  }
}

function unlock_icons() {
  info( "unlock_icons()" );
  for( var i=0 ; i<layer_area.length ; i++ ){
    layer_area[i].applyBaseboardFunction("unLockIcon")
  }
}
*/


home_screen.move_and_focus = function(sobj, cobj, end_func) {
  complete_on_stage (sobj);
  for( var i=0 ; i<base.length ; i++ ){
    layer_area[ i ].applyBaseboardFunction("applyIconFunction",["resumeResource"]);
  }

  set_key_lock(false,"from Home to Home.");

  anim.in_from.near( sobj, 0,
		     function (obj) {
		       append_timer (obj, 300,
				     function (obj, count) {
				       delete_timer (obj);
				       tv.visible_p = true;
				       focus.visible_p = true;
				       hs_logo.visible_p = true;
				       force_redraw();

				       tv.components[1].width += 2;
				       tv.components[1].height += 2;
				       connect_bplayer();
				       ureg.write("stage_param","home_screen");

				       pushBaseboard( function(){
					 tv.components[1].width = TV_SIZE[0];
					 tv.components[1].height = TV_SIZE[1];
					 if( cobj != null ){
					   setCursor (cobj,true);
					 }
					 try{
					   end_func();
					 }catch(e){
					   //No Problem
					 }
				       });
				     });
		     });
}




/*
/////////////////
// LOCK

var unLockKB = null;
var lock_pass = null;
var popup = null;
var home_keyboard = null;
var kb_ok = null;
var kb_cancel = null;
var org_keyhook = null;
var org_keymove = null;
var org_cursor = null;
var kb_enable_keyhook = false;

function appear_kb() {

  try {
    require ("pkg_common_feed");
    lock_pass = pkg_common_feed.get_LockPassword();


    set_screen_mode (OSD_ONLY_MODE);
    bplayer.disconnect ();
    org_keyhook = home_screen.key_hook;
    org_keymove = home_screen.key_move;
    org_cursor = home_screen.cursor;
    if (unLockKB == null) {
      Make_Keyboard ();
    } else {
      unLockKB.revive();
      home_keyboard.revive();
    }

    popup.visible_p = true;
    common_popup.create_animation (popup, function() { kb_enable_keyhook = true; });
    common_key.set_cursor (home_screen, home_keyboard);


    home_screen.key_hook = function (up_down, key) {
      if (!kb_enable_keyhook)
	return true;

      if (this.cursor == home_keyboard) {
	if (home_keyboard.keyhook (up_down, key) == true)
	  return true;
      }

      if (up_down != KEY_PRESS)
	return true;

      if (key == TXK_RETURN || key == TXK_HOME) {
	delete_timer(unLockKB);
	common_popup.delete_animation (popup, kb_finalize);
	return true;
      }

      return common_key.old_way_emulate_hook2 (this, up_down, key);
    }

    home_screen.key_move = [
      [home_keyboard, null,          kb_ok, null,  null],
      [kb_ok,         home_keyboard, null,  null,  kb_cancel],
      [kb_cancel,     home_keyboard, null,  kb_ok, null],
    ];
  } catch (e) {
    error("CATCH Exception> " + e);
  }
}

function Make_Keyboard() {
  require ("lang_settings");
  require ("pkg_keyboard");

  var kbText = lang_settings.GetMessageText();

  home_keyboard = pkg_keyboard.create();
  home_keyboard.set_translate([0, -120, 0]);
  home_keyboard.set_guide_translate([-570, 0, 0]);
  home_keyboard.set_mode ("PASSWD");

  unLockKB = new container ({
    "components": [
      new gbox (
	{
	  "translate": [0.0, 320.0, 0.0],
	  "width":  600,
	  "height":  50,
	  "color": [128, 128, 128, 128],
	}),
      new gtext (
	{
	  "translate": [0.0, 320.0, 0.0],
	  "width": 1000,
	  "text" : kbText.ENTER_PASSWORD,
	  "font_name": "F015T-regular",
	  "align": CENTER,
	  "font_size": 35,
	}),
      kb_ok = new actor (
	{
	  "translate": [-120.0, -320.0, 0.0],
	  "base_col": [[150, 150, 150, 255], [100, 100, 100, 255]],
	  "bg_image": [
	    new gbox (
	      {
		"width": 200,
		"height": 50,
		"color": [56, 56, 56, 255],
	      }),
	    new gtext (
	      {
		"width": 200,
		"height": 50,
		"text"     : kbText.DONE,
		"font_name": "F015T-bold",
		"align": CENTER,
		"font_size": 30,
	      }),
	  ],
	  "action": function () {
	    var inp_pass = home_keyboard.getText ();
	    home_keyboard.setText ("");

	    if (lock_pass == inp_pass) {
	      delete_timer(unLockKB);
	      common_popup.delete_animation (popup, function() {
		kb_finalize();
		base[ home_screen.layer ][home_screen.cursor.position].applyIconFunction("leave_focus");
		unlock_icons();
		base[ home_screen.layer ][home_screen.cursor.position].applyIconFunction("enter_focus");
	      });
	      return;
	    } else {
	      setf_text(unLockKB.components[1], kbText.FAILED_);
	      append_timer(unLockKB, 3000, function(obj,count){
		delete_timer(obj);
		setf_text(unLockKB.components[1], kbText.ENTER_PASSWORD);
		common_key.set_cursor(home_screen, home_keyboard);
	      });

	      return;
	    }
	  },
	}),

      kb_cancel = new actor (
	{
	  "translate": [120.0, -320.0, 0.0],
	  "base_col": [[150, 150, 150, 255], [100, 100, 100, 255]],
	  "bg_image": [
	    new gbox (
	      {
		"width": 200,
		"height": 50,
		"color": [56, 56, 56, 255],
	      }),
	    new gtext (
	      {
		"width": 200,
		"height": 50,
		"text": kbText.CANCEL,
		"font_name": "F015T-bold",
		"align": CENTER,
		"font_size": 30,
	      }),
	  ],
	  "action": function () {
	    delete_timer(unLockKB);
	    common_popup.delete_animation (popup, kb_finalize);

	  },
	}),
      home_keyboard,
    ],
  });


  unLockKB.free = function() {
    setf_text(this.components[1], "");
    setf_text(kb_ok.bg_image[1], "");
    setf_text(kb_cancel.bg_image[1], "");
  };
  unLockKB.revive = function() {
    setf_text(this.components[1], kbText.ENTER_PASSWORD);
    setf_text(kb_ok.bg_image[1], kbText.DONE);
    setf_text(kb_cancel.bg_image[1], kbText.CANCEL);
  };


  require ("common_popup");
  unLockKB.visible_p = false;
  popup = common_popup.make_popup (700, 850, [0,0,0], unLockKB);
  home_screen.components.push (popup);
}

function kb_finalize() {
  connect_bplayer();

  home_keyboard.setText ("");
  unLockKB.free();
  home_keyboard.free();
  home_screen.key_move = org_keymove;
  home_screen.key_hook = org_keyhook;
  kb_enable_keyhook = false;
  common_key.set_cursor (home_screen, org_cursor);
  play_click_sound (0);

  layer_area[ home_screen.layer ].applyBaseboardFunction("applyIconFunction",["enter_stage"]);
  AnimationManager.startAnimation();
}
*/










//______________________________________________________ PUSH and PULL

function pullBaseboard( end_func ){
  info(">> START pullBaseboard <<");

  var call_end_function = function(){
    if( end_func ){
      append_timer( home_screen, 30,function(obj){
	delete_timer( obj );
	try{
	  end_func();
	  set_key_lock(true,"pullBaseboard() : after end_func");
	}catch(e){
	  error("pullBaseboard( end_func ) : "+e);
	  pushBaseboard();
	}
      });
    }else{
      set_key_lock(true,"pullBaseboard() : after animation");
    }
  };

  AnimationManager.stopAnimation();
  layer_area[ home_screen.layer ].applyBaseboardFunction("applyIconFunction",["leave_stage"]);

  if( home_screen.layer == base.length-1 ){
    call_end_function();
    return;
  }



  set_key_lock(false,"pullBaseboard() : before animation");
  append_timer(home_screen, 50, function(obj,count){
    for(var i=home_screen.layer+1 ; i<base.length ;i++ ){
      if( count < BILLIARD_COUNT*(base.length-home_screen.layer-1)-(i-home_screen.layer)*BILLIARD_COUNT){
	layer_area[i].setZ( -LAYER_DISTANCE*(i-home_screen.layer) );
      }else{
	layer_area[i].setZ(  -LAYER_DISTANCE*(i-home_screen.layer)
			     + (count-(BILLIARD_COUNT*(base.length-home_screen.layer-1)-(i-home_screen.layer)*BILLIARD_COUNT))*BILLIARD_Z_UNIT -1*i);
      }
    }

    if( count == BILLIARD_COUNT*(base.length-home_screen.layer-1) ){
      delete_timer( obj );
      call_end_function();
    }
    force_redraw();
  });
}


function pushBaseboard( end_func ){
  info(">> START pushBaseboard <<");

  var call_end_function = function(){
    if( end_func ){
      append_timer( home_screen, 30,function(obj){
	delete_timer( obj );
	try{
	  end_func();
	  set_key_lock(true,"pushBaseboard() : after end_func");
	}catch(e){
	  error("pushBaseboard() : "+e);
	}
      });
    }else{
      set_key_lock(true,"pushBaseboard() : after animation");
    }
    layer_area[ home_screen.layer ].applyBaseboardFunction("applyIconFunction",["enter_stage"]);
    AnimationManager.startAnimation();
    connect_sc_event();
  };

  if( home_screen.layer == base.length-1 ){
    call_end_function();
    return;
  }

  set_key_lock(false,"pushBaseboard() : before animation");
  append_timer(home_screen, 50, function(obj,count){
    force_redraw();
    for(var i=home_screen.layer ; i<base.length ;i++ ){
      if( count <= (i-home_screen.layer)*BILLIARD_COUNT)
	layer_area[i].setZ( -count*BILLIARD_Z_UNIT );
    }
    if( count == BILLIARD_COUNT*(base.length-home_screen.layer-1) ){
      delete_timer( obj );
      append_timer( obj,30, function(){
	delete_timer( obj );

	layer_area[home_screen.layer].applyBaseboardFunction( "setIconVisible", [true]  );
	call_end_function();
      });
    }
  });
}



//______________________________________________________ MORE and BACK


function startMore(){
  if( home_screen.layer == base.length-1 ){
    info("No More");    return;
  }

  AnimationManager.stopAnimation();
  set_key_lock(false, "startMore() : before animation");

  layer_area[ home_screen.layer +1 ].applyBaseboardFunction( "setIconVisible", [true]);
  layer_area[ home_screen.layer +1 ].applyBaseboardFunction( "setAlpha", [255]);
  layer_area[ home_screen.layer ].applyBaseboardFunction("applyIconFunction",["leave_stage"]);
  layer_area[ home_screen.layer +1 ].applyBaseboardFunction("applyIconFunction",["leave_stage"]);
  force_redraw();


  var finish_func = function( obj ){
    delete_timer( obj );
    layer_area[ home_screen.layer ].applyBaseboardFunction( "setIconVisible", [false] );
    layer_area[ home_screen.layer ].setVisible( false );
    home_screen.layer +=1;

    if( home_screen.layer == base.length -1 ){
      arrow_more.setEnable( false );
      setCursor( arrow_back );
    }else if( home_screen.layer == 1 ){
      arrow_back.setEnable( true );
    }

    append_timer( obj, 100,
		  function( obj ){
		    delete_timer( obj );
		    layer_area[ home_screen.layer ].applyBaseboardFunction(
		      "applyIconFunction", ["enter_stage"]
		    );
		    set_key_lock(true,"startMore() : after finish_func");
		    AnimationManager.startAnimation();
		  });
  };

  var z=0;
  append_timer( home_screen, 50, function(obj,count){
    for( var i=0 ; i<base.length ; i++ ){
      z=layer_area[i].translate[2];
      //      layer_area[i].setZ( z+MOREBACK_Z_UNIT, (i==home_screen.layer+1)?true:false   );
      layer_area[i].setZ( z+MOREBACK_Z_UNIT );
    }
    arrow_more.animation(count);

    if(count==MOREBACK_COUNT){
      delete_timer(obj);
      append_timer( obj, 50, finish_func );
    }
    force_redraw();
  });
}


function startBack(){
  if( home_screen.layer == 0 ){
    info("Cannot Back");
    return;
  }

  AnimationManager.stopAnimation();
  set_key_lock(false,"startBack() : before animation");

  layer_area[ home_screen.layer-1].applyBaseboardFunction( "setIconVisible", [false] );
  layer_area[ home_screen.layer-1].setVisible( true );
  layer_area[ home_screen.layer ].applyBaseboardFunction("applyIconFunction",["leave_stage"]);
  layer_area[ home_screen.layer-1 ].applyBaseboardFunction("applyIconFunction",["leave_stage"]);


  var finish_func = function( obj ){
    delete_timer( obj );
    layer_area[ home_screen.layer ].applyBaseboardFunction( "setIconVisible", [false] );
    home_screen.layer -=1;
    if( home_screen.layer == 0 ){
      arrow_back.setEnable( false );
      setCursor( arrow_more );
    }else if(home_screen.layer==base.length-2){
      arrow_more.setEnable( true );
    }
    append_timer( obj, 100,
		  function( obj ){
		    delete_timer( obj );
		    layer_area[ home_screen.layer ].applyBaseboardFunction(
		      "applyIconFunction", ["enter_stage"]
		    );
		    set_key_lock(true,"startBack() : after animation");
		    //      layer_area[ home_screen.layer ].applyBaseboardFunction( "setAlpha", [255]);
		    AnimationManager.startAnimation();
		  });
  };

  var z=0;
  append_timer( home_screen, 50, function(obj,count){
    for( var i=0 ; i<base.length ; i++ ){
      z=layer_area[i].translate[2];
      //      layer_area[i].setZ( z-MOREBACK_Z_UNIT, (i==home_screen.layer)?true:false );
      layer_area[i].setZ( z-MOREBACK_Z_UNIT );
    }
    arrow_back.animation(count);

    if(count==MOREBACK_COUNT){
      delete_timer(obj);
      append_timer( obj, 50, finish_func );
    }
    force_redraw();
  });
}







const TURN_FROM_POSITION = [ // [ layer, position ]
  [ 0, 0 ],  [ 0, 1 ],  [ 0, 2 ],  [ 0, 3 ],  [ 0, 4 ],  [ 0, 5 ],  [ 0, 6 ],
  [ 1, 0 ],  [ 1, 1 ],  [ 1, 2 ],  [ 1, 3 ],  [ 1, 4 ],  [ 1, 5 ],  [ 1, 6 ],
  [ 2, 0 ],  [ 2, 1 ],  [ 2, 2 ],  [ 2, 3 ],  [ 2, 4 ],  [ 2, 5 ],  [ 2, 6 ],
];


/*
function is_customized(){
  if( get_icon_list("CUSTOM") == null ){
    info("User reset icons.");
    return true;
  }
  if( ureg.read("user_customized") == "true" ){
    info("User cusromized icons.");
    ureg.write("user_customized", "false");
    return true;
  }
  return false;
}


function reset_icons(){
  for( var i=0 ; i<layer_area.length ; i++){
    layer_area[i].applyBaseboardFunction("setAppliName",[null,false]);
  }
}
*/

function load_icons(){
  var layer = 0;
  var pos = 0;
  /*
  var ok = get_icon_list( "CUSTOM" );
  info("<get_icon_list('CUSTOM')> : "+ok);
  var ng = get_icon_list( "CUSTNG" );
  info("<get_icon_list('CUSTNG')> : "+ng);


  if( ok == null )    ok = {};
  if( ng == null )    ng = {};
  */

  var ok = {};
  var ng = {};

  for( var i in ok ){
    //@@@  if( layer != 0 ) break;
    layer = Math.floor(ok[i].position/7);
    if( layer >= base.length )
      break;

    pos = ok[i].position % 7;
    //base[ layer ][ pos ].setAppliName( new String(i), false );
  }


  var icon_list_url = "";
  var full_list = null;

  if (ureg.read("market") == "US") {
    icon_list_url = path + "config/icon-list-" + system.locale.country.toLowerCase() + ".json";
  } else { // not US
    switch(system.locale.country) {
    case "DE": // GERMANY
    case "AT": // AUSTRIA
    case "FR": // FRANCE
    case "IT": // ITALY
    case "ES": // SPAIN
    case "PT": // PORTUGAL
    case "CH": // SWITZERLAND
    case "MT": // MALTA
    case "AD": // ANDORRA

    case "DK": // DENMARK
    case "SE": // SWEDEN
    case "NO": // NORWAY
    case "FI": // FINLAND
    case "LU": // LUXEMBOURG
    case "BE": // BELGIUM
    case "NL": // NETHERLANDS
    case "TR": // TURKEY
    case "GR": // GREECE

    case "PL": // POLAND
    case "CZ": // CZECH
    case "HU": // HUNGARY
    case "SK": // SLOVAKIA
    case "SI": // SLOVENIA
    case "EE": // ESTONIA
    case "LT": // LITHUANIA
    case "EEU": // East-EU

    case "UK": // UNITED KINGDOM (illegal for ISO)
    case "IE": // IRELAND

    case "RU": // RUSSIA
    case "HR": // CROATIA
    case "IS": // ICELAND (from 2010)
    case "OTH": // OTHER (illegal for ISO)
      icon_list_url = path + "config/icon-list-eu.json"; // European configuration
      break;
    /*
    case "XX": 
      icon_list_url = path + "config/icon-list-" + system.locale.country.toLowerCase()+ ".json";
      break;
   */
    default:
      icon_list_url = path + "config/icon-list-asia.json"; // default configuration (ASIA)
    }
  }

  http_request({"url" : icon_list_url,
		"method" : "GET",
		"onload" : function( status, header, body ){
		  if( status == 200 ){
		    ureg.RegisterApp( "icon_list" );
		    try{
		      full_list = eval("("+body+")");
		      ureg.write( "icon_list", convert_to_cdata(full_list).toSource() );
		    }catch(e){
		      error("Cannot eval \""+icon_list_url+"\".\n"+body);
		      return;
		    }
		  }else{
		    error("Cannot get \""+icon_list_url+"\".");
		    return;
		  }

		  /*
		  for( var name in ok ){
		    delete full_list[ name ];
		  }
		  for( var name in ng ){
		    delete full_list[ name ];
		  }
		  */

		  //var str = "";
		  for( var name in full_list ){
		      //str+=name+", ";
		    layer = Math.floor(full_list[name].position/7);
		    //@@@    if( layer != 0 ) break;
		    if( layer < base.length ){
		      pos = full_list[name].position % 7 ;
		    }else{
		      pos = null;
		    }

		    if( full_list[ name ].need_check ){
		      base[ layer ][ pos ].setReserved( true );
		      check_icon_showable( new String(name), full_list[name], layer, pos, ok, ng );
		      continue;
		    }

		    if( (pos!=null) && base[ layer ][ pos ].getReserved() == false ){
		      base[ layer ][ pos ].setAppliName( new String(name), false );
		      ok[ name ] = full_list[ name ];
		    }else{
		      for( var i=0 ; i<TURN_FROM_POSITION.length ; i++ ){
			var bb = base[ TURN_FROM_POSITION[i][0] ][ TURN_FROM_POSITION[i][1] ];
			if( bb.getReserved() == false ){
			  bb.setAppliName( new String(name), false );
			  full_list[ name ].position = i;
			  ok[name] = full_list[ name ];
			  //warn("New Application \""+ name +"\" : [layer,position] = "+TURN_FROM_POSITION[i]);
			  i = TURN_FROM_POSITION.length;
			  continue;
			}
		      }
		    }
		  }

		  //store_icon_list( "CUSTOM", ok );
		  /*
		  if( str != "" )
		    error("< New Application Coming !>  = "+str);
		  */
		},
		"sync": false,
		});
}

function check_icon_showable( appli_name, info_data, layer, position, ok_list, ng_list ){
  info("  ---- start ---- check_icon_showable : " + appli_name );

  var func_if_true = function(){ // true
    ok_list[ appli_name ] = info_data;
    //store_icon_list( "CUSTOM", ok_list );
    if( position != null ){
      base[ layer ][ position ].setAppliName( appli_name, false );
      if( layer == 0 ) //mmm
	base[ layer ][ position ].setLoadedChange( true  );
    }
  };

  var func_if_false = function(){ // false
    ng_list[ appli_name ] = info_data;
    //store_icon_list( "CUSTNG", ng_list );
    base[ layer ][ position ].setReserved( false  );
  };

  try{
    ICON_CHECKER[ appli_name ]( func_if_true, func_if_false, false );
  }catch( e ){
    base[ layer ][ position ].setReserved( false  );
    error("ICON_CHECKER[\"" + appli_name + "\"]() : " + e );
  }

}



/*
function check_secure_version( icon ){
  var version = icon.getSecureVersion();
  if( !version ){
    return true;
  }

  var major_version = system.service.major_version;
  var minor_version = system.service.minor_version;
  if( (major_version >= version[1])
    && (minor_version >= version[2]) ){
    return true;
  }else{ // Needed to update.
    return false;
  }
}
*/


/*
function update_secure_version(){
  info("<update_secure_version> Start to update secure version.");
  var onload = function( ret, status ){
    switch( ret ){
    case 0: // success
      break;
    case -1: // curl error
      if( status == 60 ){
	error("--- Please Confirm Clock Setting ---");
	text_information.show( LANG_HS["PLEASE_CONFIRM_CLOCK_SETTING"] );
      }
      break;
    case -2: // http error
      break;
    case -3: // security error
      break;
    case -4: // internal error
      break;
    default:;
      break;
    }
  }
  system.service.update_table({"onload":onload});
}
*/



function getNextFocusObject( stg, key ){
  info("getNextFocusObject()");

  var key_array = stg.key_move;
  if( !key_array ) return;

  var id = 0;
  switch( key ){
  case TXK_UP:      id = 1;    break;
  case TXK_DOWN:    id = 2;    break;
  case TXK_LEFT:    id = 3;    break;
  case TXK_RIGHT:   id = 4;    break;
  default:    return;
  }

  for( var i=0 ; i<key_array.length ; i++ ){
    if( key_array[i][0] == stg.cursor ){
      if( key_array[i][id] instanceof Function ){
	return key_array[i][id]();
      }else{
	return key_array[i][id];
      }
    }
  }
}



function setCursor( next, focus_arg ){
  //  if( home_screen.cursor && home_screen.cursor.leave_focus){
  try{
    home_screen.cursor.leave_focus();
  }catch(e){ /* No Problem */ }

  home_screen.cursor = next;

  try{
    next.enter_focus( focus_arg );
  }catch(e){ /* No Problem */ }

  try{
    next.requestFocus( focus_arg );
  }catch(e){ /* No Problem */ }
}

/*
function check_lock_needed( icon ){
  var lock = false;
  switch (icon.name) {
  case "youtube":
    lock = nvram[0].read(getKeywordLoginSetting("YTLOCKSTATE"));
    break;
  case "picasa":
    lock = nvram[0].read(getKeywordLoginSetting("PWLOCKSTATE"));
    break;
  default:
    lock = nvram[0].read(getKeywordLoginSetting(icon.name.toUpperCase() + "LOCKSTATE"));
    break;
  }
  if( lock ){
    icon.lock();
    return true;
  }else{
    return false;
  }
}
*/


home_screen.makeKeyMove = function(){
  var arrow_more_if_possible = function(){
    if( home_screen.layer == base.length-1 ){
      return arrow_back;
    }else{
      return arrow_more;
    }
  };

  var ads_if_possible = function(){
    return null;
  }

  this.key_move = [
    /*          <UP>      <DOWN>                  <LEFT>                  <RIGHT>  */
    [ fposi[0], null,     fposi[3],               null,                   fposi[1] ],
    [ fposi[1], null,     tv,                     fposi[0],               fposi[2] ],
    [ fposi[2], null,     fposi[4],               fposi[1],               null     ],

    [ fposi[3], fposi[0], fposi[5],               null,                   tv       ],
    [ tv,       fposi[1], arrow_more_if_possible, fposi[3],               fposi[4] ],
    [ fposi[4], fposi[2], fposi[6],               tv,                     null     ],

    [ fposi[5], fposi[3], null,                   null,                   arrow_more_if_possible ],
    [ fposi[6], fposi[4], null,                   arrow_more_if_possible, null     ],

    [ arrow_more, tv,
      function(){
	if( home_screen.layer == 0){
	  return ads_if_possible();
	}else{
	  return arrow_back;
	}
      }, fposi[5], fposi[6] ],
    [ arrow_back,
      function(){
	if( home_screen.layer == base.length-1 ){
	  return tv;
	}else{
	  return arrow_more;
	}
      },null, fposi[5], fposi[6] ],
  ];
};
home_screen.makeKeyMove();







function set_key_lock( b, msg ){
  info( "set_key_lock: " + b + "  <MSG>: " + msg );
  // false : Lock keu input.
  hs_enable_keyhook = b;
}


/*
function start_vieracast_application( app, position ){
  info(">> start application >> " + app );
  http_request({ url: MyHostName+"vcapp/info?app=" + app + "&lang=" + system.locale.language
		 + "&country=" + system.locale.country + "&pos=" + position,
		 method: "GET",
		 sync: false,
		 onload: NULL_FUNCTION,
	       });
}
*/




/*** Launch Homescreen ***/
function launch_homescreen(){
  //  load_icons();
  for( var i=0 ; i<layer_area.length ; i++ ){
    layer_area[i].visible_p = true;
  }

  append_timer( tv, 300, function(obj,count){
    delete_timer( obj );
    make_anim();
    map_color_key();
    pushBaseboard(
      function(){
	layer_area[0].applyBaseboardFunction("setLoadedChange",[true]);
	arrow_more.visible_p = true;
	arrow_back.visible_p = true;
	prepare_package("common_menu");

	append_timer(tv,100,function(obj){
	  delete_timer( obj );
	  //start_vieracast_application( "home_screen", -1 );
	  setCursor(tv, true);
	});
      }
    );
  });
}



// <START> EVENT_HOOK
function sc_event_hook( arg0, arg1, arg2 ){
  var event = null;
  if( typeof arg0 == "number" ){
    // version 0.5.x
    event = arg0;
  }else{
    // version 0.6.x (and more)
    event = arg2;
  }

  switch( event ){
  case system.screensaver.PRE_START:
    info("[ScreenSaver] start.");
    AnimationManager.pauseAnimation();
    break;
  case system.screensaver.POST_FINISH:
    info("[ScreenSaver] finish.");
    AnimationManager.startAnimation();
    break;
  default:
    fatal( "Ilegal event : " + event  + "(type:"+typeof event+")");
  }
};

function connect_sc_event(){
  try{
    home_screen.add_event_hook( system.screensaver, sc_event_hook );
  }catch(e){
    error("@connect_sc_event() : "+e.toSource());
  }
}

function disconnect_sc_event(){
  try{
    home_screen.del_event_hook( system.screensaver );
  }catch(e){
    error("@disconnect_sc_event() : "+e.toSource());
  }
}
// <END> EVENT_HOOK




load_icons();

//var disclaimer_flag = null;
//var disclaimer_ret = null;
append_timer(home_screen, 5, function(obj, count) {
  delete_timer(obj);
  //disclaimer_ret = nvram[0].read("disclaimer");
  //disclaimer_flag = eval( "(" + disclaimer_ret + ")" );
  /*
  if (disclaimer_flag == true) {
    launch_homescreen();
  } else {
    try {
	//on_stage("disclaimer");
	launch_homescreen();
    } catch (e) {
      error(e.toString());
    }
  }
  */
  launch_homescreen();
});



// _________________________________________________ @ICON_CHECKER
ICON_CHECKER = null;
var make_icon_checker = function(){
  if ( ICON_CHECKER ){
    return;
  }

  ICON_CHECKER = {
    amazon: function( func_if_true, func_if_false, sync ){
      var end_func = function( ret ){
	try{
	  if( ret ) func_if_true();
	  else      func_if_false();
	}catch(e){
	//No Problem
 	}
	return ret;
      }

      if( system.locale.country != "US" ){
	return end_func( false );
      }

      http_request({
	url: "https://atv-ext.amazon.com/cdp/usage/CheckUsage?deviceTypeID=A13E6DL99XCZT&deviceID=unknown&firmware=latest&version=1&format=json",
	method: "GET",
	sync: sync,
	onload: function( status, header, body ){
	  switch (status) {
	  case 200:
	    try {
	      var data = eval ("(" + body + ")");
	      if( typeof data.message.body == "boolean" ){
		end_func( data.message.body );
	      }
	    } catch(err) {
	      error("[ERROR:cannot eval]: " + err.toSource());
	    }
	    break;

	  case -60: // enable clock alert
	    error("--- Please Confirm Clock Setting ---");
	    text_information.show( LANG_HS["PLEASE_CONFIRM_CLOCK_SETTING"] );
	    break;

	  default:

	  }
	}});
      return null;
    },// amazon:END

    tagesschau: function( func_if_true, func_if_false, sync ){
      var NAME = "tagesschau";
      var end_func = function( ret ){
	try{
	  if( ret ) func_if_true();
	  else      func_if_false();
	}catch(e){
	//No Problem
 	}
	return ret;
      }

      try{
	var mapps = eval( nvram[0].read("MORE_APPS") );
	var tmp = mapps[ NAME ][0];
	delete mapps[ NAME ];
	nvram[0].write("MORE_APPS", mapps.toSource());

	return end_func( tmp );
      }catch(e){
	// No Problem
      }

      switch(system.locale.country) {
      case "AD":  // Andorra
      case "AT":  // Austria
      case "CH":  // Switzerland
      case "CZ":  // Czech
      case "DE":  // Germany
      case "DK":  // Denmark
      case "EE":  // Estonia
      case "EEU": // East. EU
      case "ES":  // Spain
      case "FI":  // Finland
      case "GR":  // Greece
      case "HR":  // Croatia
      case "HU":  // Hungary
      case "LT":  // Lithuania
      case "LU":  // Luxembourg
      case "NO":  // Norway
      case "PL":  // Poland
      case "PT":  // Portugal
      case "SE":  // Sweden
      case "SI":  // Slovenia
      case "SK":  // Slovakia
      case "UK":  // UK (illegal for ISO)
      case "IS":  // ICELAND (from 2010)
      case "OTH": // OTHER (illegal for ISO)
	return end_func( true );
      default:
	return end_func( false );
      }
    },//tagesschau:END

    skype: function( func_if_true, func_if_false, sync, func_cannot_judge ){
      if( (typeof ebus != "undefined")  &&
	  (typeof ebus.skype != "undefined") &&
	  (ebus.skype.allowed == true) ){
	try{
	  func_if_true();
	}catch(e){  /* No Problem */	}
	return true;
      }else{
	try{
	  func_cannot_judge();
	}catch(e){  /* No Problem */	}
	return false;
      }
    },//skype:END

  }//[END] ICON_CHECKER

  return;
}();





