//
// Copyright (C) 2008-2009 Panasonic Corporation. All Rights Reserved.
//
// adjust text length
var make_text = function (box, text) {

  var words = text.split(" ");
  var line = [];
  line[0] = "";
  line[1] = "";

  if (words.length <= 1 || box.width >= get_text_width (box, text)) {
    line[0] = text;
    return line;
  }

  var len = 0;
  var word_count = 0;
  var first_line = "";
  len = get_text_width (box, words[word_count]);

  if (len > box.width) {
    line[0] = text;
    return line;
  }

  while (len < box.width) {
    first_line = first_line + " " + words[word_count++];
    len = get_text_width (box, first_line);
  }
  word_count--;

  for (var i=0; i<word_count; i++) {
    if (i == 0) {
      line[0] =  words[i];
    } else {
      line[0] = line[0] + " " + words[i];
    }
  }
  for (var i=word_count; i<words.length; i++) {
    if (i == word_count) {
      line[1] = words[i];
    } else {
      line[1] = line[1] + " " + words[i];
    }
  }
  return line;
}

add_stage_load_path("es_main", path + "eurosport/es_main.js");

var es = new Icon();

// language descision
es.TEXT = {
  "en-GB": {
    LOCKED: "Locked"
  },
  "es-ES": {
    LOCKED: "Bloqueado"
  },
  "fr-FR": {
    LOCKED: "Bloqué"
  },
  "de-DE": {
    LOCKED: "Gesperrt"
  },
  "it-IT": {
    LOCKED: "Bloccato"
  }
}

es.lang = ureg.read("language");
if (!es.TEXT[es.lang]) {
  es.lang = "en-GB";
  warn("[ES] cannot read \"language\" " + ureg.read("language") + ". use default \"" + es.lang + "\".");
}
add_package_load_path("lang_eurosport", path + "eurosport/lang/pkg_lang_eurosport_" + es.lang + ".js");

// icon properties
es.name = "eurosport";
es.anim_num = 0;
es.feed = {
  data: null,
  http_req_id: -1,
};
es.feed_selected = 0;
es.feed_offset = 0;
es.feed_ready = false;
es.anim_ready = false;
es.logo_src = path + "eurosport/360x60_esp_logo.png";
es.mainPanel = null;
es.lockPanel = null;
es.IMAGE_PATH = path;

// create ui functions
es.setPanel = function() {
  // mainPanel
  var p = new container({});
  p.components = [
    p.back = new gbox({
      width: 360,
      height: 252,
      color: [0, 0, 0, 255]
    }), 
    p.logo = new gimage({
      translate: [0, 96, 0],
      src: this.logo_src,
      onload: function() {},
      onerror: function() {}
    }),
    p.thumb = new WipeGimage({"translate": [0, -30, 0]}, 360, 192),
    p.label = new gbox({
      translate: [0, -94, 0],
      width: 360,
      height: 64,
      color: [0, 0, 0, 153]
    }),
    p.caption = new container({
      "translate": [0,-94,0],
      "components": [
        new gtext({translate:[0,+16,0], width:340, height:32,
          font_size:26, align:LEFT
        }),
        new gtext({translate:[0,-14,0], width:340, height:32,
          font_size:26, align:LEFT, omitter:"..."
        })
      ]
    }),
  ];
  
  this.components.push(p);
  this.mainPanel = p;
  
  // lockPanel
  var q = new container({visible_p: false});
  q.components = [
    q.back = new gbox({
      width: 360,
      height: 252,
      color: [64, 16, 16, 255]
    }),
    q.logo = new gimage({
      src: this.logo_src,
      onload: function() {},
    onerror: function() {}
    }),
    q.caption = new gtext({
      translate: [0, -80, 0],
      width: 340,
      align: CENTER,
      font_name: "F015T-bold",
      color: [150, 150, 150, 255],
      font_size: 42
    })
  ];
  
  this.components.push(q);
  this.lockPanel = q;
};

es.getFrameColor = function() {
  return [0x12, 0x4c, 0x9a, 255];
}

es.setCaption = function(text_container) {
  setf_text(this.mainPanel.caption.components[0], text_container[0]);
  setf_text(this.mainPanel.caption.components[1], text_container[1]);
}

es.loadFeed = function() {
  this.feed_ready = false;
  this.anim_ready = false;
  this.feed_offset = 0;
  this.feed_selected = 0;
  this.anim_num = 0;
  this.feed.data = [
    {"id": 0,
     "thumb_1": "eurosport/demo/HS_A.jpg",
     "title": "FIA WTCC Porto",
     "date": "05/07/2009"},
    {"id": 1,
     "thumb_1": "eurosport/demo/HS_B.jpg",
     "title": "Australian Open 2010",
     "date": "22/01/2010"},
    {"id": 2,
     "thumb_1": "eurosport/demo/HS_C.jpg",
     "title": "Australian Open 2010",
     "date": "21/01/2010"},
    {"id": 3,
     "thumb_1": "eurosport/demo/HS_D.jpg",
     "title": "IRC Monte Carlo 2010",
     "date": "21/01/2010"},
    {"id": 4,
     "thumb_1": "eurosport/demo/HS_E.jpg",
     "title": "IAAF Athletics Wch Berlin 2009",
     "date": "20/08/2009"},
    {"id": 5,
     "thumb_1": "eurosport/demo/HS_F.jpg",
     "title": "Tour de France 2009 -stage 21-",
     "date": "26/07/2009"},
    {"id": 6,
     "thumb_1": "eurosport/demo/HS_G.jpg",
     "title": "Tour de France 2009 -stage 3-",
     "date": "06/07/2009"},
    {"id": 7,
     "thumb_1": "eurosport/demo/HS_H.jpg",
     "title": "Roland Garros 2009",
     "date": "31/05/2009"},
  ];
  for(var i=0; i< this.feed.data.length; i++) {
      this.feed.data[i].title_2 = make_text(this.mainPanel.caption.components[0], this.feed.data[i].title);
      this.feed.data[i].title = "";
  }
  this.mainPanel.thumb.initImage(this.IMAGE_PATH + this.feed.data[0].thumb_1);
  this.setCaption(this.feed.data[0].title_2);
  this.feed_ready = true;
}

// init, action and status functions
es.init = function() {
  // init logo for mainPanel and lockPanel
  // init lockPanel text
  this.mainPanel.logo.src = this.logo_src;
  this.lockPanel.logo.src = this.logo_src;
  setf_text(this.lockPanel.caption, this.TEXT[this.lang].LOCKED);
  
  this.loadFeed();
}

es.action = function() {
  if (this.isLock()) 
    return;
  var id = 0;
  try {
    var id = this.feed.data[this.feed_selected].id;
  } catch (e) {
    warn("[ES] get video id for offset " + this.feed_selected + " failed: " + e);
  }
  try {
    var ret = ureg.read("eurosport_video_id");
    if (typeof ret == "undefined") {
      ureg.RegisterApp("eurosport_video_id");
    }
    ureg.write("eurosport_video_id", id.toString());
    on_stage("es_main");
  } catch (e) {
    fatal("[ES] launch failed: " + e);
  }
}

es.isReady = function() {
  return this.feed_ready;
}

// animation function
es.animation = function(count) {
  if (this.isLock()) 
    return;
  if (count == 5)
    this.feed_selected = this.feed_offset;

  if (count == 16 && this.feed_ready) {
    this.anim_ready = true;
    this.anim_num++;
    this.feed_offset = this.anim_num % this.feed.data.length;
    this.mainPanel.thumb.setImage(es.IMAGE_PATH + this.feed.data[this.feed_offset].thumb_1);
  }
  if (this.anim_ready) {
    if (count == 5) {
      this.mainPanel.caption.visible_p = false;
    }
    if (count == 15) {
      this.setCaption(this.feed.data[this.feed_offset].title_2);
      this.mainPanel.caption.visible_p = true;
    }
    this.mainPanel.thumb.animation(count);
  }
}

// enter and leave functions
es.enter_stage = function() {
  this.feed.data = null;
  this.loadFeed();

  if (this.feed.data != null) {
    this.anim_ready = false;
    this.mainPanel.thumb.initImage(es.IMAGE_PATH + this.feed.data[this.feed_offset].thumb_1);
    this.mainPanel.caption.visible_p = true;
    this.setCaption(this.feed.data[this.feed_offset].title_2);
  }
  this.mainPanel.thumb.animation(0);
}

es.leave_stage = function() {
  delete_timer(this);
  this.mainPanel.thumb.clearImage();
}

es.enter_focus = function() {
  if (this.isLock() == false) {
    append_timer(this, 1000, function(obj) {
      delete_timer(obj);
      prepare_stage("es_main");
    });
  }
}

es.leave_focus = function() {
  delete_timer(this);
  discard_package("lang_eurosport");
  discard_stage("es_main");
}

es.setAlpha = function(alpha) {
  var v = (alpha == 255);

  var p = this.mainPanel;
  p.back.color[3] = alpha;
  p.logo.color[3] = alpha;
  p.thumb.visible_p = v;
  p.label.visible_p = v;
  p.caption.visible_p = v;

  var q = this.lockPanel;
  q.back.color[3] = alpha;
  q.logo.color[3] = alpha;
  q.caption.visible_p = v;
}

es.freeResource = function() {
  this.mainPanel.logo.src = "";
  this.lockPanel.logo.src = "";
  this.setCaption(["", ""]);
  setf_text(this.lockPanel.caption, "");
}

es.resumeResource = function() {
  this.mainPanel.logo.src = this.logo_src;
  this.lockPanel.logo.src = this.logo_src;
  setf_text(this.lockPanel.caption, this.TEXT[this.lang].LOCKED);
}

// locking functions
es.isLock = function() {
  return this.lockPanel.visible_p;
}

es.lock = function() {
  this.setLock(true);
}

es.setLock = function(b) {
  this.mainPanel.visible_p = !b;
  this.lockPanel.visible_p = b;
}

es.unlock = function() {
  this.setLock(false);
}

// change return value
// to activate child lock
es.isLockable = function() {
  return false;
}

//// END
es.setPanel();
es;
