//
// Copyright (C) 2008 Panasonic Corporation. All Rights Reserved.
//

var ES_DEMO = true;

if (!ES_DEMO) {
  require ("common_popup");
}
require ("lang_eurosport");

var es_text = lang_eurosport.GetMessageText();  

var MAX_RESULTS = 40;
var VIDEO_NUM = 14;
var VIDEO_DISP = 8;

var es_url_detail = MyHostName + "eurosport/videodetails.js";
var es_url_short = MyHostName + "eurosport/videoshort.js";
var es_url_category = MyHostName + "eurosport/videocategory.js";
if (ES_DEMO) {
  //var es_prefix_thumb = "file:///nv/demo/"
  var es_prefix_thumb = path;
  var es_prefix_video = "file:///nv/demo/";
} else {
  var es_prefix_thumb = "http://i.eurosport.com";
  var es_prefix_video = "http://vodp.eurosport.com";
}
var es_playing_content_id = 0;

function mylog (str) {
  //console.log (str);
}

function thumb_debug () {
  /* expected size of thumbnail */
  var t0w = 128;
  var t0h = 96;
  var t1w = 458;
  var t1h = 238;
  var t2w = 208;
  var t2h = 156;
  
  /* compare actual size of thumbnail */
  for (var i=0; i<es_vlist_scroll.feed.data.length; i++) {
    if (es_vlist_scroll.feed.data[i].thumb_0_w != t0w ||
      es_vlist_scroll.feed.data[i].thumb_0_h != t0h) {
      console.log ("VIDEO " + i + " THUMB 0: " + 
       es_vlist_scroll.feed.data[i].thumb_0_w + 
       "x" + 
       es_vlist_scroll.feed.data[i].thumb_0_h);
    }
    if (es_vlist_scroll.feed.data[i].thumb_1_w != t1w ||
     es_vlist_scroll.feed.data[i].thumb_1_h != t1h) {
      console.log ("VIDEO " + i + " THUMB 1: " + 
       es_vlist_scroll.feed.data[i].thumb_1_w + 
       "x" + 
       es_vlist_scroll.feed.data[i].thumb_1_h);
    }
    if (es_vlist_scroll.feed.data[i].thumb_2_w != t2w ||
     es_vlist_scroll.feed.data[i].thumb_2_h != t2h) {
      console.log ("VIDEO " + i + " THUMB 2: " + 
       es_vlist_scroll.feed.data[i].thumb_2_w + 
       "x" + 
       es_vlist_scroll.feed.data[i].thumb_2_h);
    }
  }
}

//////////////////////////////////////////////////
// VlistActor
//////////////////////////////////////////////////
function VlistActor(init) {
  this.base = container;
  init.components = [];
  this.base(init);
  
  es_item = new actor({
    "base_col": [[0xff, 0xff, 0xff, 15], [0xff, 0xff, 0xff, 15]],
    "visible_p": true,
    "bg_image":  [
      new gbox({//0
        "height": 170,
        "width": 410,
        "color": [153, 153, 153, 26]
      }),
      new gbox({//1
        "height": 150,
        "width": 200,
        "color": [0x00, 0x00, 0x00, 0xff],
        "translate": [-92.0, 0.0, 0.0]
      }),
      new gimage({//2
        "src": "",
        "height": 150,
        "width": 200,
        "translate": [-92.0, 0.0, 0.0]
      }),
      new gtext({//3
        "translate": [110.0, 66.0, 0.0],
        "width": 180,
        "height": 32,
        "font_size": 24,
        "margin": [0,0,2,2]
      }),
      new gtextbox({//4
        "translate": [115, -10.0, 0.0],
        "width": 180,
        "height": 130,
        "font_name": "F015T-bold",
        "font_size": 30,
        "margin": [0,0,0,0],
        "margin_leading": -6
      })
    ]
  });
  
  this.components = [es_item];
}

VlistActor.prototype = new container({});

VlistActor.prototype.set_translate = function (position) {
  this.components[0].translate = position;
}

//////////////////////////////////////////////////
// VlistScroll
/////////////////////////////////////////////////
function VlistScroll(init) {
  this.base = actor;
  this.base = container;
  init.components = [];
  this.base(init);
  
  var item = new scroll({
    "translate": [0.0, 0.0, 0.0],
    "width": 780,
    "height": 658,
    "column": 2,
    "column_width": 380,
    "row_height": 179,
  });
  this.components = [item];
}

VlistScroll.prototype = new container({});

VlistScroll.prototype.set_actors = function (list) {
  this.components[0].components = list;
}
VlistScroll.prototype.set_key_hook = function (key_hook) {
  this.components[0].key_hook = key_hook;
}
VlistScroll.prototype.set_supply_data = function (supply_data) {
  this.components[0].supply_data = supply_data;
}

VlistScroll.prototype.init_feed = function () {
  var feed = new Object();
  feed.data = [];
  this.feed = feed;
  
  for (var i = 0; i < VIDEO_NUM; i++) {
    this.components[0].components[i].bg_image[2].src = "";
    if( ES_DEMO && (i!=0) ){
      this.components[0].components[i].bg_image[3].color = [102,102,102,255];
      this.components[0].components[i].bg_image[4].color = [102,102,102,255];
    }
    setf_text (this.components[0].components[i].bg_image[3], "");
    setf_text (this.components[0].components[i].bg_image[4], "");    
    this.components[0].components[i].action = function (obj) {};
    this.components[0].components[i].visible_p = false;
  }
}

VlistScroll.prototype.do_get_handle = -1;
VlistScroll.prototype.do_get_feed = function (url, lang, family_id, 
    sport_id, event_id, competition_id, 
    max_results, sync, add_func) {

  mylog ("URL: " + url + " LANG:" + lang + " FAM_ID:" + family_id + 
   " SPORT_ID:" + sport_id + " EVENT_ID:" + event_id + 
   " COMP_ID:" + competition_id + " MAX:" + max_results);
  
  // START DEMO MODE
  if (ES_DEMO) {
    if (add_func) {
      this.feed.data = [
        {"id": 0,
         "thumb_2": "eurosport/demo/EU_A.jpg",
         "title": "FIA WTCC Porto",
         "date": "05/07/2009"},
        {"id": 1,
         "thumb_2": "eurosport/demo/EU_B.jpg",
         "title": "Australian Open 2010",
         "date": "22/01/2010"},
        {"id": 2,
         "thumb_2": "eurosport/demo/EU_C.jpg",
         "title": "Australian Open 2010",
         "date": "21/01/2010"},
        {"id": 3,
         "thumb_2": "eurosport/demo/EU_D.jpg",
         "title": "IRC Monte Carlo 2010",
         "date": "21/01/2010"},
        {"id": 4,
         "thumb_2": "eurosport/demo/EU_E.jpg",
         "title": "IAAF Athletics Wch Berlin 2009",
         "date": "20/08/2009"},
        {"id": 5,
         "thumb_2": "eurosport/demo/EU_F.jpg",
         "title": "Tour de France 2009 -stage 21-",
         "date": "26/07/2009"},
        {"id": 6,
         "thumb_2": "eurosport/demo/EU_G.jpg",
         "title": "Tour de France 2009 -stage 3-",
         "date": "06/07/2009"},
        {"id": 7,
         "thumb_2": "eurosport/demo/EU_H.jpg",
         "title": "Roland Garros 2009",
         "date": "31/05/2009"},
      ];
      add_func(200);
    }
    return -1;
  } 
  // END DEMO MODE
  
  if (sync == null) {
    sync = false;
  }
  
  var self = this;
  var feed = this.feed;
  
  var onload_func = function (status, header, body) {
    var pre_eval = null;
    if (add_func) {
      if (status == 200) {
        try {
          pre_eval = eval("("+body.replace(/\u2028/g," ")+")");
          feed.data = pre_eval;
        }
        catch (e) {
          console.log ("Feed eval failed: " + e );
        }
      }
      add_func(status);
    }
    es_vlist_loading_obj.end_action ();
    self.do_get_handle = -1;
  };
  
  var req_url = [0, -1, -1, -1, -1, 40];
  if (lang) req_url[0] = lang;
  if (family_id) req_url[1] = family_id;
  if (sport_id) req_url[2] = sport_id;
  if (event_id) req_url[3] = event_id;
  if (competition_id) req_url[4] = competition_id;
  if (max_results) req_url[5] = max_results;
  
  var req = {
    "url": url + "," + req_url[0] + "," + req_url[1] + "," + req_url[2] + "," + 
      req_url[3] + "," + req_url[4] + "," + req_url[5],
    "method": "GET",
    "sync": sync,
    "onload": onload_func,
  };
  
  es_vlist_loading_obj.start_action ();
  
  if (this.do_get_handle!=-1) {
    console.log ("CANCEL PREVIOUS FEED REQUEST handle:" + this.do_get_handle);
    cancel_http_request(this.do_get_handle);
  }
  this.do_get_handle = http_request( req );
  return this.do_get_handle;
}

VlistScroll.prototype.do_get_video_handle = -1;
VlistScroll.prototype.do_get_video = function (url, lang_id, video_id, sync, add_func) {
  // START DEMO MODE
  if (ES_DEMO) {
    if (add_func) {
      add_func(200, "eurosport/demo/WTCC2009.mp4");
    }
    return -1;
  }
  // END DEMO MODE
  
  if( sync == null ) {
    sync = false;
  }
  
  var self = this;
  
  var onload_func = function (status, header, body) {
    var pre_eval = null;
    var content = "";
    
    if (add_func) {
      if (status == 200) {
        try {
                pre_eval = eval("("+body+")");
        }
        catch (e) {
          console.log ("Video eval failed");
        }
        if( pre_eval && pre_eval.length == 1) {
          content = pre_eval[0].content;
        }
      }
      add_func(status, content);
    }
    self.do_get_video_handle = -1;
  };
  
  var req_url = [0, 0];
  if (lang_id) req_url[0] = lang_id;
  if (video_id) req_url[1] = video_id;
  
  var req = {
    "url": url + "," + req_url[0] + "," + req_url[1],
    "method": "GET",
    "sync": sync,
    "onload": onload_func,
  };
  
  if (this.do_get_video_handle!=-1) {
    console.log ("CANCEL PREVIOUS VIDEO REQUEST");
    cancel_http_request(this.do_get_video_handle);
  }
  this.do_get_video_handle = http_request( req );
  return this.do_get_video_handle;
}

VlistScroll.prototype.do_get_category_handle = -1;
VlistScroll.prototype.do_get_category = function (url, lang_id, sync, add_func) {

  // START DEMO MODE
  if (ES_DEMO) {
    if (add_func) {
      add_func(200, [
        {"name": "All Sports"},
        {"name": "Football"},
        {"name": "Tennis"},
        {"name": "Motorsport"}
      ]);
    }
    return -1;
  }
  // END DEMO MODE
  
  if( sync == null ) {
    sync = false;
  }
  
  var self = this;
  
  var onload_func = function (status, header, body) {
    var pre_eval = null;
    
    if (add_func) {
      if (status == 200) {
        try {
          pre_eval = eval("("+body+")");
        }
        catch (e) {
          console.log ("Category eval failed"); 
        }
      }   
      add_func(status, pre_eval);
    }
    self.do_get_category_handle = -1;
  };
    
  var req_url = [0];
  if (lang_id) req_url[0] = lang_id;
  
  var req = {
    "url": url + "," + req_url[0],
    "method": "GET",
    "sync": sync,
    "onload": onload_func,
  };

  if (this.do_get_category_handle!=-1) {
    console.log ("CANCEL PREVIOUS CATEGORY REQUEST");
    cancel_http_request(this.do_get_category_handle);
  }
  this.do_get_category_handle = http_request( req );
  return this.do_get_category_handle;
}

// ///////////////////////////////////
// ////////// EXIT FUNCTION //////////
// ///////////////////////////////////
var es_exit = function () {
  on_stage ("home_screen");
};

// //////////////////////////////////////////////////////////
// ////////// LOGO & LEFT BANNER (GOTO HOME SCREEN)//////////
// //////////////////////////////////////////////////////////
var es_logo = new gimage({
  "translate": [0.0, 420.0, 1.0],
  "src": path + "eurosport/esp_logo.png",
  "height": 120,
  "width": 850,
  "draw_type": DIRECT,
});

var es_leftbanner = new container({
  "translate": [-890.0, -100.0, 0.0],
  "components": [
    new actor({
      "base_col": [[0, 0, 0, 0], [0, 0, 0, 0]],
      "bg_image":[
      new gbox({
        "translate": [0.0, 50.0, 0.0],
        "height": 800,
        "width": 50,
        "color": [0, 0, 0, 0]
      }),
      new gimage({
            "src": path + "common/arrow_left.png"
      }),
      new gtext({
        "text": es_text.RETURN_TO,
        "translate": [0.0, -280.0, 0.0],
        "rotation": [90.0, 0.0, 0.0, 1.0],
        "width": 500,
        "color": [102, 102, 102, 255],
        "font_size": 42,
        "align": RIGHT
      }),
      new gtext({
        "text": es_text.VIERA_CAST_HOME,
        "translate": [0.0, 330.0, 0.0],
        "rotation": [90.0, 0.0, 0.0, 1.0],
        "width": 600,
        "color": [102, 102, 102, 255],
        "font_size": 42,
        "align": LEFT
      }),
      ]
    }),      
  ]
});

// ////////////////////////////////////////
// ////////// COUNTRY SELECT TAB //////////
// ////////////////////////////////////////
function make_lang_item(tablist) {
  var list = new Array ();
  var item = null;
  
  for (var i in tablist) {
    
    if( i != "toStringJSON" ){
      item = new actor({
        "translate": [tablist[i].pos, 0.0, 0.0],
        "base_col": [[0, 0, 0, 0], [0, 0, 0, 0]],
        "bg_image": [
          new gimage({
            "src": path + tablist[i].png_off,
            "width": 51,
            "height": 30,
            "visible_p": true
          }),
          new gimage({
            "src": path + tablist[i].png,
            "width": 51 ,
            "height": 30,
            "visible_p": false
          })
        ],
      });
      
      if (ES_DEMO) {
        item.action = null;
            } else {
        item.action = function (obj) {
          mylog ("FLAG ICON ACTION");
          
          es_set_color_tab (this.lang);
          
          // get new default video list
          es_vlist_scroll.init_feed();
          es_vlist_arrow_up.visible_p = false;
          es_vlist_arrow_down.visible_p = false;
          es_vlist_scroll.do_get_feed(es_url_short, 
                    this.lang, -1, -1, -1, -1, MAX_RESULTS, 
                    false, es_feed_callback_fn);
          
          // set flag icons
          for (var j=0; j<es_langtab.components.length-2; j++) {
            es_langtab.components[j].bg_image[0].visible_p = true;
            es_langtab.components[j].bg_image[1].visible_p = false;
          }
          this.bg_image[1].visible_p = true;
          
          // write to memory
          nvram[3].write ("es_country", this.id);
        }
      };
      item.lang = tablist[i].lang;
      item.id = i;
      list.push (item);
    }
  }
  
  list.push (
    new gbox({
      "width": 354,
      "height": 40,
      "color": [0x10, 0x18, 0x30, 0xff],
      "translate": [tablist["PL"].pos+212, 0.0, 0.0],
    }),
    new gtext({
      "text": es_text.CHANGE_COUNTRY_SETTING,
      "width": 354,
      "color": [255, 255, 255, 255],
      "font_size": 27,
      "align": LEFT,
      "translate": [tablist["PL"].pos+212, 0.0, 0.0]
    })
  );
    
  return new container ({"translate": [-850.0/2, 316.0, 1.0],
    "components": list});  
}

var es_langtab_array = {
  "UK": {
    "pos": 0.0+36,   
    "lang": "0", 
    "png": "eurosport/flag/uk.png",
    "png_off": ES_DEMO ? "eurosport/flag/uk.png" : "eurosport/flag/uk2_off.png",    
  },
  "FR": {
    "pos": 60.0+36, 
    "lang": "3", 
    "png": ES_DEMO ? "eurosport/flag/fr2_off.png" : "eurosport/flag/fr.png",
    "png_off": "eurosport/flag/fr2_off.png",    
  },
  "DE": {
    "pos": 120.0+36, 
    "lang": "1", 
    "png": ES_DEMO ? "eurosport/flag/de2_off.png" : "eurosport/flag/de.png",
    "png_off": "eurosport/flag/de2_off.png",    
  },
  "IT": {
    "pos": 180.0+36, 
    "lang": "4", 
    "png": ES_DEMO ? "eurosport/flag/it2_off.png" : "eurosport/flag/it.png",
    "png_off": "eurosport/flag/it2_off.png",    
  },
  "ES": {
    "pos": 240.0+36, 
    "lang": "6", 
    "png": ES_DEMO ? "eurosport/flag/es2_off.png" : "eurosport/flag/es.png",
    "png_off": "eurosport/flag/es2_off.png",    
  },
  "RU": {
    "pos": 300.0+36, 
    "lang": "15", 
    "png": ES_DEMO ? "eurosport/flag/ru2_off.png" : "eurosport/flag/ru.png",
    "png_off": "eurosport/flag/ru2_off.png",    
  },
  "SE": {
    "pos": 360.0+36, 
    "lang": "7", 
    "png": ES_DEMO ? "eurosport/flag/se_off.png" : "eurosport/flag/se.png",
    "png_off": "eurosport/flag/se_off.png",    
  },
  "PL": {
    "pos": 420.0+36, 
    "lang": "14", 
    "png": ES_DEMO ? "eurosport/flag/pl_off.png" : "eurosport/flag/pl.png",
    "png_off": "eurosport/flag/pl_off.png",    
  }
};

var es_langtab = make_lang_item(es_langtab_array);


// /////////////////////////////////
// ////////// ERROR POPUP //////////
// /////////////////////////////////

if (ES_DEMO) {
 
  var es_error_popup = new container ({
    "visible_p": false,
    "components":[]
  });
  var es_display_error_popup = function (status) {};

} else {

  var es_error_popup = new common_popup.ErrorPopup (Object ());

  var es_display_error_popup = function (status) {
    mylog ("DISPLAY ERROR POPUP status:" + status);
    
    es_main.need_cursor_init = false;
    
    if (es_error_popup.visible_p == false) {
      es_error_popup.set_translate ([0.0, 0.0, 0.0]);
      
      // see ajaxceplayer, js_http_request.c, load_content()
      // status > 0 : HTTP error code 
      // status < 0 : CURL error code 
      // e.g. -28: -CURLE_OPERATION_TIMEDOUT    
      es_error_popup.set_status ("");
      es_error_popup.set_body (es_text.COMMUNICATION_ERROR__STATUS + status);
      es_error_popup.set_action ( 
      function () {
        es_error_popup.visible_p = false;
        es_error_popup.set_status ("");
        es_error_popup.set_body ("");
        common_key.set_cursor (es_main, es_error_popup.prev_cursor_pos);
        es_main.key_move = es_error_popup.prev_key_move;
        force_redraw();
      }
      );
      
      es_error_popup.prev_cursor_pos = es_main.cursor;
      es_error_popup.prev_key_move = es_main.key_move;
      es_error_popup.visible_p = true;
      es_error_popup.set_cursor (es_main);
    }
  }
}


// ////////////////////////////////////
// ////////// LEFT COLOR TAB //////////
// ////////////////////////////////////
function make_tab_item(tablist) {
  var list = new Array ();
  var item = null;
  
  var tab_width = 12;
  var border = 6;
  var height = 50;

  for(var i=0; i< 4; i++) {    
    item = new actor({
      "translate": [0.0, 0.0, 0.0],
      "base_col": [[0xff, 0xff, 0xff, 15], [0xff, 0xff, 0xff, 15]],
      "cursor_width":6, 
      "visible_p": false,
      "bg_image": [
        new gbox({
          "height": height,
          "color": [0xff, 0xff, 0xff, 25]
        }),
        new gtext({
          "height": height,
          "font_size": 0,	  
          "align": CENTER,
          "translate": [12,0,0],
          "margin": [0, 0, 0, 0]
        }),
        new gbox({ // COLOR_KEY
          "width": 12,
          "height": height-border*2,
          "color": tablist[i].color,
          "translate": [0,0,0]
        }),
      ]
    });
    item.type = "contents";
    item.tabnum = i;
    item.sport_id = "-1";
    item.event_id = "-1";
    item.family_id = "-1";
    item.competition_id = "-1";
    item.org_color = item.bg_image[0].color;
    item.selected_color = [51, 80, 109, 255];
    if( ES_DEMO && (i!=0) ){
      item.bg_image[1].color = [102,102,102,255];
    }
    list.push (item);
  }
  return new container ({"translate": [0.0, 260.0, 1.0],
    "components": list});  
}

var es_lefttab = make_tab_item([
  {"color": [192, 0, 0, 255]},// TXK_RED},
  {"color": [0, 128, 32, 255]},// TXK_GREEN
  {"color": [192, 192, 0, 255]},// TXK_YELLOW
  {"color": [0, 0, 192, 255]},// TXK_BLUE
]);

var es_feed_callback_fn = function (status) {
  mylog ("INIT CATEGORY LIST CALLBACK FN status:" + status);
  
  scroll_init(es_videolist_container, es_vlist_scroll.feed.data.length);
  
  // set initial down arrow ..
  if (es_vlist_scroll.feed.data.length > VIDEO_DISP) {
    es_vlist_arrow_down.visible_p = true;
  }
  
  // set cursor position if 
  // 0) keep cursor position if not null
  // 1) video as specified by HomeScreen
  // 2) first video in list
  // 3) first color tab
  // 4) first flag icon
  if (es_main.need_cursor_init == true) {
    es_main.need_cursor_init = false;

    if (es_vlist_scroll.feed.data.length > 0) {
     
      var init_pos = 0;
      try {
        var ret = parseInt(ureg.read("eurosport_video_id"));
        for (var pos=0; pos<es_vlist_scroll.feed.data.length; pos++) {
          if (es_vlist_scroll.feed.data[pos].id == ret) {
            init_pos = pos;
            break;
          }
        }
        if (pos == es_vlist_scroll.feed.data.length) {
          console.log ("ES: could not find initial cursor pos for id " + ret);
        }
      } catch (e) {
        console.log ("ES: could not get initial cursor pos: " + e);
      }
      
      mylog ("SELECT VIDEO POS:" + init_pos);
      
      scroll_jump (es_videolist_container, init_pos, TOP);
      if (init_pos > 1) {
        es_vlist_arrow_up.visible_p = true;
      }

      scroll_enter( es_videolist_container );
      
      var id = es_videolist_container.focus_comp_id;
      var focus_obj = es_videolist_container.components[id];
      common_key.set_cursor (es_main, focus_obj);
      force_redraw();
      
      // start play back
      es_videolist_container.components[id].action(
        es_videolist_container.components[id].action); 
    }
    else if (es_main, es_lefttab.components[0].visible_p == true) {
      common_key.set_cursor(es_main, es_lefttab.components[0]);
    }
    else {
      common_key.set_cursor(es_main, es_langtab.components[0]);
    }
  }
  
  if (status != 200) {
    es_display_error_popup (status);
  }
};

var es_lefttab_set_width_fn = function (eval) {
  // dynamically decide width for each color tab
  var es_font_size = [36, 32, 28, 24];
  var es_text_length = [0, 0, 0, 0];  
  var w_text_sum = 0;
  var w_total = 834;
  var w_gap = 6;
  var w_safety = 30;
  var w_available = w_total - 4*w_safety - 3*w_gap;
  var x_pos = -w_total/2;
  var color_tab_width = 12;
  var color_tab_border = 6;

  for (f=0; f<es_font_size.length; f++) {
    w_text_sum = 0
    for (i=0; i<es_lefttab.components.length; i++) {
      es_lefttab.components[i].bg_image[1].font_size = es_font_size[f];
      if (eval != null && i<eval.length) {
        es_text_length[i] = 
        get_text_width (es_lefttab.components[i].bg_image[1], eval[i].name);	
      } else {
        es_text_length[i] = 0;
      }
      w_text_sum += es_text_length[i];
    }    

    if (w_text_sum < w_available) {
      break;
    }
  }
  
  var w_buffer = w_available - w_text_sum;  
  //console.log ("Text size: " + es_text_length + " Total: " + w_text_sum + " Buffer: " +   
  for (i=0; i<4; i++) {
    var w_text = es_text_length[i] + Math.floor(w_buffer/4); 
    var w_box = w_text + w_safety;
    es_lefttab.components[i].visible_p = true;
    es_lefttab.components[i].translate = [x_pos + w_box/2, 0.0, 0.0];
    es_lefttab.components[i].bg_image[0].width = w_box;
    es_lefttab.components[i].bg_image[1].width = w_text;
    es_lefttab.components[i].bg_image[2].translate = 
      [-w_box/2+color_tab_border+color_tab_width/2,0,0];   
    x_pos += w_box + w_gap;  
  }  
}

var es_set_color_tab = function (lang_id) {

  var es_category_callback_fn = function (status, eval) {
    es_lefttab_set_width_fn (eval);
    
    for (i=0; i<es_lefttab.components.length; i++) {
      if (eval != null && i<eval.length) {
        setf_text (es_lefttab.components[i].bg_image[1], eval[i].name);
        
        if (ES_DEMO) {
          es_lefttab.components[i].action = null;
        } else {
          es_lefttab.components[i].sport_id = eval[i].sportid;
          es_lefttab.components[i].family_id = eval[i].familyid;
          es_lefttab.components[i].event_id = eval[i].eventid;
          es_lefttab.components[i].competition_id = eval[i].competitionid;
          
          es_lefttab.components[i].action = function () {
            // set color and focus
            for (var j=0; j<es_lefttab.components.length; j++) {
              es_lefttab.components[j].bg_image[0].color = 
          es_lefttab.components[j].org_color;
            }
            this.bg_image[0].color = this.selected_color;
            common_key.set_cursor (es_main, this);
            force_redraw();    
            
            // set new video scroll list
            es_vlist_scroll.init_feed();
            es_vlist_arrow_up.visible_p = false;
            es_vlist_arrow_down.visible_p = false;
            es_vlist_scroll.do_get_feed(
              es_url_short, lang_id, this.family_id, this.sport_id, this.event_id, 
              this.competition_id, MAX_RESULTS, false, function (status) {
          scroll_init(es_videolist_container, es_vlist_scroll.feed.data.length);
          
          // set initial down arrow ..
          if (es_vlist_scroll.feed.data.length > VIDEO_DISP) {
            es_vlist_arrow_down.visible_p = true;
          }
          
          // enable for debugging soize of thumbnail image
          //thumb_debug ();
          if (status != 200) {
            es_display_error_popup (status);
          }
              }
            );
          }
        }
      } else {
        setf_text (es_lefttab.components[i].bg_image[1], "");
        es_lefttab.components[i].sport_id = "-1";
        es_lefttab.components[i].family_id = "-1";
        es_lefttab.components[i].event_id = "-1";
        es_lefttab.components[i].competition_id = "-1";
        es_lefttab.components[i].action = function () {
          common_key.set_cursor (es_main, this);
          force_redraw();    
        };
      }
      
      if (ES_DEMO && i==0) {
        es_lefttab.components[i].bg_image[0].color = 
        es_lefttab.components[i].selected_color;
      } else {
        es_lefttab.components[i].bg_image[0].color = 
        es_lefttab.components[i].org_color;
      }
    }
    force_redraw();    
  }

  es_vlist_scroll.do_get_category (es_url_category, lang_id, 
    false, es_category_callback_fn);
};


// ///////////////////////////////////////
// ////////// VIDEO SCROLL LIST //////////
// ///////////////////////////////////////
var es_make_big_star = function (color) {
  return new container ({
    "components": [
      new gpolygon ({
        "color": color,
        "vertex": [13,35,0, -47,-34,0, 13,-7,0 ]
      }),
      new gpolygon ({
        "color": color,
        "vertex": [47,7,0, -47,7,0, -9,-18,0 ]
      }),
      new gpolygon ({
        "color": color,
        "vertex": [13,-7,0, -9,-18,0, 13,-34,0]
      }),
    ]
  })
};

if (ES_DEMO) {
  var es_vlist_loading_obj = new container({
    "visible_p": false,
    "components":[]
  });
  es_vlist_loading_obj.animation = function (count) {};
  es_vlist_loading_obj.start_action = function () {};
  es_vlist_loading_obj.end_action = function () {};

} else {

  var es_vlist_loading_trans = [
    [-128.0, 127.0, 0.0],
    [-10.0,  190.0, 0.0],
    [109.0,  218.0, 0.0],
    [216.0,  192.0, 0.0],
    [286.0,  127.0, 0.0],
    
    [189.0,  -127.0, 0.0],
    [67.0,   -193.0, 0.0],
    [-57.0,  -218.0, 0.0],
    [-168.0, -195.0, 0.0],
    [-227.0, -127.0, 0.0]
  ];
  
  var es_vlist_loading_obj = new container({
    "translate": [0, -100.0, 0.0],
    "visible_p": false,
    "components":[
      es_make_big_star ([74,82,99,255]),
      es_make_big_star ([156,165,173,255]),
      es_make_big_star ([239,257,247,255])
    ]
  });
  
  es_vlist_loading_obj.animation = function (count) {
    for (i=0; i<es_vlist_loading_obj.components.length; i++) {
      es_vlist_loading_obj.components[i].translate = 
        es_vlist_loading_trans [(count+i) % es_vlist_loading_trans.length];
    }
  }
  
  es_vlist_loading_obj.start_action = function () {
    for (i=0; i<es_vlist_loading_obj.components.length; i++) {
      es_vlist_loading_obj.components[i].translate = 
        es_vlist_loading_trans [i % es_vlist_loading_trans.length];
    }
    this.visible_p = true;
    force_redraw ();
    delete_timer(this);
    append_timer(this, 100, function (obj, count){
      obj.animation(count);
      force_redraw();
    });
  }
  
  es_vlist_loading_obj.end_action = function () {
    delete_timer(this);
    this.visible_p = false;
    force_redraw();
  }
}

var es_vlist_scroll_key_hook =  function (up_down, keysym) { 
  var ret = true;
  if (up_down != KEY_PRESS) {
    return false;
  }
  
  var fn_enter_focus = function (obj) {
    var focus_obj = obj.components[obj.focus_comp_id];
    common_key.set_cursor (es_main, focus_obj);
    es_vlist_arrow_up.visible_p = obj.scrollable[0];
    es_vlist_arrow_down.visible_p = obj.scrollable[1];
  };
  
  switch (keysym) {
  case TXK_LEFT:
    if (!scroll_move (this, keysym)) {
      fn_enter_focus(this);
    } else {
      scroll_leave (this);
      es_exit ();
    }
    ret = true;
    break;
    
  case TXK_RIGHT:
    if (!scroll_move (this, keysym)) {
      fn_enter_focus(this);
    } else if (es_stream.uri) {
      common_key.set_cursor (es_main, es_player_video);
      scroll_leave (this);
    }
    ret = true;
    break;
    
  case TXK_UP:
    if (!scroll_move (this, keysym)) {
      fn_enter_focus(this);
    } else if (es_lefttab.components[0].visible_p == true) {
      common_key.set_cursor(es_main, es_lefttab.components[0]);
      scroll_leave (this);
    } else {
      common_key.set_cursor(es_main, es_langtab.components[0]);
      scroll_leave (this);
    }
    ret = true;
    break;
    
  case TXK_DOWN:
    if (!scroll_move (this, keysym)) {
      fn_enter_focus(this);
    } else if (this.focus_data_id < es_vlist_scroll.feed.data.length-1) {
      scroll_move (this, TXK_UP);
      scroll_move (this, TXK_DOWN);
      if (!scroll_move (this, keysym)) {
        fn_enter_focus(this);
      }
    } else {
      return true;
    }
    ret = true;
    break;
    
  default:
    ret = false;
    break;
  }
  
  force_redraw();
  
  // play sound
  if(ret == true) {
    play_click_sound (0);
  }
  
  return ret;
};

var es_vlist_scroll_supply_data = function (obj) {
  var feed_logical_id = obj.req_data_id;
  var feed = es_vlist_scroll.feed.data[feed_logical_id];
  var handle = -1;
  var id = obj.req_comp_id;
  
  if(feed) {
    var comp = obj.components[id];
    
    if (feed.thumb_2) {
      comp.bg_image[2].src = es_prefix_thumb + feed.thumb_2;
    } else {
      comp.bg_image[2].src = "";
    }
    setf_text (comp.bg_image[4], feed.title);
    setf_text (comp.bg_image[3], feed.date);
    
    if (ES_DEMO && feed_logical_id != 0) {
      comp.action = null;
    } else { 
      comp.action = function (obj) {
        es_playing_content_id = feed_logical_id;
        mp4_play_feed_id (es_playing_content_id);
      };
    }

    mylog ("supply data " + obj.req_data_id + " return true");
    return true;
  } else {
    mylog ("supply data " + obj.req_data_id + " return true");
    return false;
  }
};

var es_vlist_main = new Array();
for (var i=0; i<VIDEO_NUM; i++) {
  var es_vlist_actor = new VlistActor(Object());    
  var row = Math.ceil((i+1)/2)-1;
  var column = i%2;
  //console.log (i + " " + row + " " +column + " " + 
  // (-211.0+column*422.0) + " " + (132.0-row*180.0));
  es_vlist_actor.set_translate([-210.0+column*420.0, 132.0-row*179.0, 0.0]);
  es_vlist_main.push(es_vlist_actor.components[0]);
}

var es_vlist_scroll = new VlistScroll(Object());
es_vlist_scroll.set_actors(es_vlist_main);
es_vlist_scroll.set_key_hook(es_vlist_scroll_key_hook);
es_vlist_scroll.set_supply_data(es_vlist_scroll_supply_data);
es_vlist_scroll.init_feed();
es_videolist_container = es_vlist_scroll.components[0];
scroll_init(es_videolist_container,0);

var es_videolist = new container({
  "translate": [-406, 0.0, 0.0],
  "components": [
    es_logo,
    es_langtab,   
    es_lefttab,
    new gbox({ // base videolist mask
      "height": 1080,
      "width": 850,
      "color": [153, 153, 153, 26],
      "translate": [0.0, 0.0, 0.0]
    }),
    es_videolist_container,
    es_vlist_loading_obj,
    new gbox({ // top mask for scroll area
      "height": 316,
      "width": 850,
      "color": [0x10, 0x18, 0x30, 0xff],
      "translate": [0.0, (1080-316)/2, 0.0]
    }),
    new gbox({ // bottom mask for scroll area
      "height": 98,
      "width": 850,
      "color": [0x10, 0x18, 0x30, 0xff],
      "translate": [0.0, -(1080-98)/2, 0.0]
    }),
    new gimage({
      "src": path+"common/arrow_down_invisible.png",
      "translate": [30.0, -(1080-98)/2, 0.0]
    }),
    new gimage({
      "src": path+"common/arrow_up_invisible.png",
      "translate": [-30.0, -(1080-98)/2, 0.0]
    }),    
    es_vlist_arrow_down =  new gimage({
      "src": path+"common/arrow_down.png",
      "translate": [30.0, -(1080-98)/2, 0.0],
      "visible_p": false
    }),
    es_vlist_arrow_up = new gimage({
      "src": path+"common/arrow_up.png",
      "translate": [-30.0, -(1080-98)/2, 0.0],
      "visible_p": false
    })
  ],
});

// /////////////////////////////////////////////
// ////////// VIDEO PLAYER CONTROL FN //////////
// /////////////////////////////////////////////
var es_make_small_star = function (color) {
  return new container ({
    "components": [
      new gpolygon ({
        "color": color,
        "vertex": [10,27,0, -37,-27,0, 10,-6,0 ]
      }),
      new gpolygon ({
        "color": color,
        "vertex": [37,5,0, -37,5,0, -6,-14,0 ]
      }),
      new gpolygon ({
        "color": color,
        "vertex": [10,-6,0, -6,-14,0, 10,-27,0]
      }),
    ]
    })
};

if (ES_DEMO) {

  var es_player_loading_obj = new container({
    "visible_p": false,
    "components":[]
  });
  es_player_loading_obj.animation = function (count) {};
  es_player_loading_obj.start_action = function () {};
  es_player_loading_obj.end_action = function () {};

} else {
  
  var es_player_loading_trans = [
    [ 0.0,    150.0, 0.0],
    [ 105.0,  105.0, 0.0],
    [ 150.0,  0.0,   0.0],
    [ 105.0, -105.0, 0.0],
    [ 0.0,   -150.0, 0.0],
    [-105.0, -105.0, 0.0],
    [-150.0,  0.0,   0.0],
    [-105.0,  105.0, 0.0],
  ];
    
  var es_player_loading_obj = new container({
    "translate": [0, 0, 1.0],
    "visible_p": false,
    "components":[
      es_make_small_star ([26, 26, 26, 255]),
      es_make_small_star ([26, 26, 26, 255]),
      es_make_small_star ([26, 26, 26, 255]),
      es_make_small_star ([26, 26, 26, 255]),
      es_make_small_star ([26, 26, 26, 255]),
      es_make_small_star ([128, 128, 128, 255]),
      es_make_small_star ([179, 179, 179, 255]),
      es_make_small_star ([255, 255, 255, 255]),
    ]
  });
  
  es_player_loading_obj.animation = function (count) {
    for (i=0; i<es_player_loading_obj.components.length; i++) {
      es_player_loading_obj.components[i].translate = 
        es_player_loading_trans [(count+i) % es_player_loading_trans.length];
    }
    force_redraw ();
  }
  
  es_player_loading_obj.start_action = function () {
    es_videobox.color = [0, 0, 0, 255];
    for (i=0; i<es_player_loading_obj.components.length; i++) {
      es_player_loading_obj.components[i].translate = 
        es_player_loading_trans [i % es_player_loading_trans.length];
    }
    this.visible_p = true;
    delete_timer(this);
    append_timer(this, 100, function (obj, count) {
      obj.animation(count);
      force_redraw();
    });
  }
  
  es_player_loading_obj.end_action = function () {
    es_videobox.color = [0, 0, 0, 0];
    delete_timer(this);
    this.visible_p = false;
    force_redraw();
  }
}

var es_btn_prev_fn = function (obj) {
  if ((es_stream.state == PLAYING && es_stream.elapsed > 0)
      || (es_stream.state == STOP)) {
    // keep current es_playing_content_id
  } else {
    es_playing_content_id--;
  }
  if( es_playing_content_id < 0 ) {
    es_playing_content_id = 0;
    mp4_play_feed_id (es_playing_content_id);
  } else {
    // es_stream.stop (); ??
    mp4_play_feed_id (es_playing_content_id);
  }
}

var es_btn_play_fn = function (obj) {
  var uri = es_stream.uri;
  if (uri) {
    if (es_play_icon.visible_p) {
      es_play_icon.visible_p = false;
      es_play_fs_icon.visible_p = false;
      es_pause_icon.visible_p = true;
      es_pause_fs_icon.visible_p = true;
      es_stream.play (uri);
    } else {
      es_play_icon.visible_p = true;
      es_play_fs_icon.visible_p = true;
      es_pause_icon.visible_p = false;
      es_pause_fs_icon.visible_p = false;
      es_stream.pause ();
    }
    force_redraw();
  }
}

var es_btn_next_fn = function (obj) {
  es_playing_content_id++;

  if (es_playing_content_id >= es_vlist_scroll.feed.data.length) {
    es_playing_content_id--;
    return;
  }
  mp4_play_feed_id (es_playing_content_id);
}

// //////////////////////////////////
// ////////// VIDEO PLAYER //////////
// //////////////////////////////////
var es_stream = new MoviePlayer (new Object ());

function mp4_play_feed_id (id) {
  var feed = es_vlist_scroll.feed.data[id];
  
  es_stream.stop ();
  
  setf_text (es_time_count, "00:00");
  setf_text (es_time_countmax, "/00:00");
  setf_text (es_time_count_full, "00:00");
  setf_text (es_time_countmax_full, "/00:00");
  es_time_pointer.translate[0] = -368;
  es_fullscreen_sequence_time_pointer.translate[0]  = -455.0;
  
  es_pause_icon.visible_p = true;
  es_pause_fs_icon.visible_p = true;
  es_play_icon.visible_p = false;
  es_play_fs_icon.visible_p = false;

  setf_text(es_error_message.bg_image[1], "");
  es_error_message.visible_p = false;
  setf_text(es_fullscreen_error_message.bg_image[1], "");
  es_fullscreen_error_message.visible_p = false;

  if (feed) {  
    es_player_loading_obj.start_action();
    es_fullscreen_loading_obj.start_action();
    if(800 < get_text_width (es_player_fake_textbox, feed.title)) {
      es_player.components[0].translate = [0.0, 360.0, 0.0];      
    } else {
      es_player.components[0].translate = [0.0, 310.0, 0.0];
    }
    setf_text (es_player.components[0], feed.title);
    es_vlist_scroll.do_get_video (es_url_detail, feed.lang, feed.id, false, mp4_play);
  } else {
    es_player_loading_obj.end_action();
    es_fullscreen_loading_obj.end_action();
    setf_text (es_player.components[0], "");
    setf_text (es_error_message.bg_image[1], es_text.NO_ADDITIONAL_CONTENT);
    es_error_message.visible_p = true;
    setf_text (es_fullscreen_error_message.bg_image[1], es_text.NO_ADDITIONAL_CONTENT);
    es_fullscreen_error_message.visible_p = true;
    force_redraw();
  }
}

function mp4_play (status, content) {
  es_stream.event_hook = function (obj, event) {
    var stm = obj;
    
    if (event == PLAY_FINISH) {
      es_time_pointer.translate[0] = -368 + 566;
      es_fullscreen_sequence_time_pointer.translate[0] = -455 + 740;
      force_redraw();
      
      // return from fullscreen back to mainscreen
      if (es_fullscreen.visible_p==true) {
        es_fullscreen_btn_exit.action(es_fullscreen_btn_exit);
      }
    } else if (event == PLAY_NG) {
      var err = stm.error;	
      es_stream.stop ();
      es_player_loading_obj.end_action();
      es_fullscreen_loading_obj.end_action();
      
      if (err == CONTENT_ERROR) {
        setf_text(es_error_message.bg_image[1], 
            es_text.ERROR__BAD_CONTENT);
        setf_text(es_fullscreen_error_message.bg_image[1], 
            es_text.ERROR__BAD_CONTENT);
            } else if (err == URL_ERROR) {
        setf_text(es_error_message.bg_image[1], 
            es_text.ERROR__UNABLE_TO_CONNECT_TO_WEB_ADDRESS);
        setf_text(es_fullscreen_error_message.bg_image[1], 
            es_text.ERROR__UNABLE_TO_CONNECT_TO_WEB_ADDRESS);
            } else if (err == HTTP_ERROR) {
        setf_text(es_error_message.bg_image[1], 
            es_text.COMMUNICATION_ERROR__STATUS + stm.http_status);
        setf_text(es_fullscreen_error_message.bg_image[1], 
            es_text.COMMUNICATION_ERROR__STATUS + stm.http_status);
            } else if (err == DECODE_ERROR) {
        setf_text(es_error_message.bg_image[1], 
            es_text.ERROR__BAD_CONTENT);
        setf_text(es_fullscreen_error_message.bg_image[1], 
            es_text.ERROR__BAD_CONTENT);
      }
      es_error_message.visible_p = true;
      es_fullscreen_error_message.visible_p = true;
      force_redraw();
    } else if (event == PLAY_OK) {
      var unit = 1000;
      var duration_norm = stm.duration/unit;
      var elapsed_norm = stm.elapsed/unit;
      var count = 
        ("0" + Math.floor(elapsed_norm/60)).substr(-2,2) 
        + ":" 
        + ("0" + Math.floor(elapsed_norm%60)).substr(-2,2);
            var countmax =
        "/" 
        + ("0" + Math.floor(duration_norm/60)).substr(-2,2) 
        + ":" 
        + ("0" + Math.floor(duration_norm%60)).substr(-2,2);
      
      if (stm.count == 0) {
        es_player_loading_obj.end_action();
        es_fullscreen_loading_obj.end_action();
      }
      if( stm.count != stm.elapsed) {
        stm.count = stm.elapsed;
        es_error_message.visible_p = false;
        es_fullscreen_error_message.visible_p = false;
      }
      
      if (stm.elapsed >= 0 && stm.elapsed <= stm.duration) {	  
        // update progress bar in video player control
        if (es_time_countmax.text != countmax) {
          setf_text (es_time_countmax, countmax);
        }
        if (es_time_count.text != count) {
          setf_text (es_time_count, count);
        }
        es_time_pointer.translate[0] =
          -368 + 566 * stm.elapsed / stm.duration;
        
        // update progress bar in fullscreen control
        if (es_time_countmax_full.text != countmax) {
          setf_text (es_time_countmax_full, countmax);
        }
        if (es_time_count_full.text != count) {
          setf_text (es_time_count_full, count);
        }
        es_fullscreen_sequence_time_pointer.translate[0] =
          -455 + 740 * stm.elapsed / stm.duration;
      }
    }
  };
  
  if (content) {
    es_stream.count = 0;
    es_stream.elapsed = 0;
    es_stream.uri = es_prefix_video + content;
    mylog ("PLAY " + es_stream.uri);
    es_stream.play (es_stream.uri);
    return true;
  } else {
    es_player_loading_obj.end_action();
    es_fullscreen_loading_obj.end_action();    
    setf_text (es_error_message.bg_image[1], es_text.NO_ADDITIONAL_CONTENT);
    es_error_message.visible_p = true;
    setf_text (es_fullscreen_error_message.bg_image[1], es_text.NO_ADDITIONAL_CONTENT);
    es_fullscreen_error_message.visible_p = true;
    force_redraw();
  }
  return false;
}

var es_player_fake_textbox = new gtext({
  "width": 800,
  "font_size": 42,
  "font_name": "F015T-bold",
  "align": LEFT
});  

var es_player = new container({
  "translate": [480.0, -20.0, 0.0],
  "components": [
    // -------------------------------------
    // - title
    // -------------------------------------
    new gtextbox ({
      "text": "",
      "width": 800,
      "height": 102,
      "margin": [0,0,0,0],
      "margin_leading": 0,
      "color": [0xff, 0xff, 0xff, 0xff],
      "font_size": 42,
      "font_name": "F015T-bold",
      "align": LEFT,
      "translate": [0.0, 310.0, 0.0]
    }),      
    // -------------------------------------
    // - background for video
    // -------------------------------------
    new gbox({
      "width": 816,
      "height": 820,
      "color": [0x01, 0x17, 0x2e, 0xff],
      "translate": [0.0, -110.0, 0.0]
    }),
    // -------------------------------------
    // - video box
    // -------------------------------------
    new gbox({
      "width": 796,
      "height": 600,
      "color": [255, 255, 255, 25]
    }),
    // -------------------------------------
    // - video actor with videobox
    // -------------------------------------
    es_player_video = new actor({
      "base_col": [[0, 0, 0, 0], [0, 0, 0, 0]],
      "bg_image": [
        es_videobox = new videobox({
          "width":796,
          "height":600,
          "draw_type": DIRECT,
          "color":[0, 0, 0, 0],
        })
      ],
      "action": function (obj) {
        // switch off main screen
        es_mainscreen.visible_p = false;
        es_main.cursor = null;
        
        // switch on full screen (no animation)
        //es_fullscreen_video.width = 1440;
        //es_fullscreen_video.height = 1080;
        //es_fullscreen_video.translate[0] = 0;
        //es_fullscreen_video.translate[1] = 0;
        set_screen_mode (FULL_MOVIE_MODE);
        es_fullscreen_control.visible_p = false;
        es_fullscreen.visible_p = true;
        es_fullscreen_btn_play.in_cursor = true;
        es_main.cursor = es_fullscreen_btn_play;
        es_main.key_move = es_fullscreen_keymove;
        force_redraw ();
      }
    }),
    // -------------------------------------
    // - control box for video
    // -------------------------------------
    es_player_btn_prev = new actor({
      "translate": [-266.0, -332.0, 0.0],
      "base_col": [[0, 0, 0, 0], [0, 0, 0, 0]],
      "action": es_btn_prev_fn,
      "bg_image": [
        new gbox({
          "width": 264,
          "height": 56,
          "color": [255, 255, 255, 25]
        }),
        new container ({
          "visible_p": true,
          "components": [
            new gbox ({
              "translate": [-9, 0, 0],
              "color": ES_DEMO ? [102, 102, 102, 255] : [255,255,255,255],
              "width": 7,
              "height": 36,
            }),
            new gpolygon ({
              "translate": [4, 0, 0],      
              "color": ES_DEMO ? [102, 102, 102, 255] : [255,255,255,255],
              "vertex": [ 9,18,0,   -9,0,0,   9,-18,0 ],
            })
          ]
        })
      ]
    }),
    es_player_btn_play = new actor({
      "translate": [0.0, -332.0, 0.0],
      "base_col": [[0, 0, 0, 0], [0, 0, 0, 0]],
      "action": es_btn_play_fn,
      "bg_image": [
        new gbox({
          "width": 250,
          "height": 56,
          "color": [255, 255, 255, 25]
        }),
        es_pause_icon = new container ({
          "visible_p": false,
          "components": [
            new gbox ({
              "translate": [-7, 0, 0],
              "color": [255, 255, 255, 255],
              "width": 7,
              "height": 36,
            }),
            new gbox ({
              "translate": [+7, 0, 0],
              "color": [255, 255, 255, 255],
              "width": 7,
              "height": 36,
            }),
          ]
        }),
        es_play_icon = new container ({
          "components": [
            new gpolygon ({
              "translate": [0, 0, 0],      
              "color": [255, 255, 255, 255],
              "vertex": [ 9,0,0,   -9,18,0,   -9,-18,0 ],
            })
          ]
        })
      ]
    }),
    es_player_btn_next = new actor({
      "translate": [266.0, -332.0, 0.0],
      "base_col": [[0, 0, 0, 0], [0, 0, 0, 0]],
      "action": es_btn_next_fn,
      "bg_image": [
        new gbox({
          "width": 264,
          "height": 56,
          "color": [255, 255, 255, 25]
        }),
        new container ({
          "visible_p": true,
          "components": [
            new gbox ({
              "translate": [+9, 0, 0],
              "color": ES_DEMO ? [102, 102, 102, 255] : [255,255,255,255],
              "width": 7,
              "height": 36,
            }),
            new gpolygon ({
              "translate": [-4, 0, 0],      
              "color": ES_DEMO ? [102, 102, 102, 255] : [255,255,255,255],
              "vertex": [ -9,18,0,    -9,-18,0,   9,0,0 ],
            })	    
          ]
        })
      ]
    }),
    // -------------------------------------
    // - progress bar for video
    // -------------------------------------
    new gbox({
      "width": 796,
      "height": 36,
      "color": [255, 255, 255, 25],
      "translate": [0.0, -400.0, 0.0]
    }),
    new gbox({
      "width": 580,
      "height": 14,
      "color": [0x0c, 0x16, 0x21, 0xff],
      "translate": [-85.0, -400.0, 0.0]
    }),
    es_time_pointer = new gbox({
      "width": 14,
      "height": 14,
      "translate": [-368.0, -400.0, 0.0]
    }),
    es_time_count = new gtext({
      "translate": [290.0, -398.0, 0.0],
      "width": 160,
      "height": 36,
      "text": "00:00",
      "font_size": 28,
      "margin": [0,0,12,12]
    }),
    es_time_countmax = new gtext({
      "translate": [360.0, -398.0, 0.0],
      "width": 160,
      "height": 36,
      "text": "/00:00",
      "font_size": 28,
      "margin": [0,0,12,12]
    }),
    // -------------------------------------
    // - error icon on video player
    // -------------------------------------
    es_error_message = new actor({
      "base_col_width": 0,
      "cursor_width": 0,
      "visible_p": false,
      "bg_image": [
        new gimage({
          "src": path + "common/not_found.png",
          "width": 320,
          "height": 240,
          "translate": [0.0, 20.0, 0.0]
        }),
        new gtextbox({
          "width": 750,
          "height": 150,
          "translate": [0.0, -160.0, 0.0],
          "color": [56, 56, 56, 255],
          "font_size": 38,
          "align": CENTER
        })
      ]
    }),
    // --------------------------
    // - loading object for video
    // --------------------------
    es_player_loading_obj,      
  ]
});

if (ES_DEMO) {
  es_player_btn_prev.action = null;
  es_player_btn_next.action = null;
}
  

// ///////////////////////////////////////////
// ////////// FULLSCREEN VIDEO MODE //////////
// ///////////////////////////////////////////
if (ES_DEMO) {
  var es_fullscreen_loading_obj = new container({
    "visible_p": false,
    "components":[]
  });
  es_fullscreen_loading_obj.animation = function (count) {};
  es_fullscreen_loading_obj.start_action = function () {};
  es_fullscreen_loading_obj.end_action = function () {};

} else {

  var es_fullscreen_loading_trans = [
    [ 0.0,    150.0, 0.0],
    [ 105.0,  105.0, 0.0],
    [ 150.0,  0.0,   0.0],
    [ 105.0, -105.0, 0.0],
    [ 0.0,   -150.0, 0.0],
    [-105.0, -105.0, 0.0],
    [-150.0,  0.0,   0.0],
    [-105.0,  105.0, 0.0],
  ];
  
  var es_fullscreen_loading_obj = new container({
    "translate": [0, 0, 1.0],
    "visible_p": false,
    "components":[
      es_make_small_star ([26, 26, 26, 255]),
      es_make_small_star ([26, 26, 26, 255]),
      es_make_small_star ([26, 26, 26, 255]),
      es_make_small_star ([26, 26, 26, 255]),
      es_make_small_star ([26, 26, 26, 255]),
      es_make_small_star ([128, 128, 128, 255]),
      es_make_small_star ([179, 179, 179, 255]),
      es_make_small_star ([255, 255, 255, 255]),
    ]
  });
  
  es_fullscreen_loading_obj.animation = function (count) {
    for (i=0; i<es_fullscreen_loading_obj.components.length; i++) {
      es_fullscreen_loading_obj.components[i].translate = 
	es_fullscreen_loading_trans [(count+i) % es_fullscreen_loading_trans.length];
    }
    force_redraw ();
  }
  
  es_fullscreen_loading_obj.start_action = function () {
    es_fullscreen_video.color = [0, 0, 0, 255];
    for (i=0; i<es_fullscreen_loading_obj.components.length; i++) {
      es_fullscreen_loading_obj.components[i].translate = 
	es_fullscreen_loading_trans [i % es_fullscreen_loading_trans.length];
    }
    this.visible_p = true;
    delete_timer(this);
    append_timer(this, 100, function (obj, count){
      obj.animation(count);
      force_redraw();
    });
  }
  
  es_fullscreen_loading_obj.end_action = function () {
    es_fullscreen_video.color = [0, 0, 0, 0];
    delete_timer(this);
    this.visible_p = false;
    force_redraw();
  }
}

var es_fullscreen_bg = new gbox({
  "width": 1920,
  "height": 1080,
  "color": [0, 0, 0, 255]
});

var es_fullscreen_video = new videobox({
  "width": 1440,
  "height": 1080,
  "draw_type": DIRECT,
  "color": [0, 0, 0, 0]
});

var es_fullscreen_btn_prev = new actor({
  "translate": [-344.0, 20.0, 0.0],
  "base_col": [[0, 0, 0, 0], [0, 0, 0, 0]],
  "bg_image": [
    new gbox ({
      "width": 264,
      "height": 56,
      "color": [103, 103, 103, 102]
    }),
    new container ({
      "visible_p": true,
      "components": [
        new gbox ({
          "translate": [-9, 0, 0],
          "color": ES_DEMO ? [102, 102, 102, 255] : [255,255,255,255],
          "width": 7,
          "height": 36,
        }),
        new gpolygon ({
          "translate": [4, 0, 0],      
          "color": ES_DEMO ? [102, 102, 102, 255] : [255,255,255,255],
          "vertex": [ 9,18,0,   -9,0,0,   9,-18,0 ],
        })
      ]
    })
  ],
  "action": es_btn_prev_fn
});

if (ES_DEMO) {
  es_fullscreen_btn_prev.action = null;
}

var es_fullscreen_btn_play = new actor({
  "translate": [-76.0, 20.0, 0.0],
  "base_col": [[0, 0, 0, 0], [0, 0, 0, 0]],
  "bg_image": [
    new gbox ({
      "width": 264,
      "height": 56,
      "color": [103, 103, 103, 102]
    }),
    es_pause_fs_icon =  new container ({
      "visible_p": false,
      "components": [
        new gbox ({
          "translate": [-7, 0, 0],
          "color": [255, 255, 255, 255],
          "width": 7,
          "height": 36,
        }),
        new gbox ({
          "translate": [+7, 0, 0],
          "color": [255, 255, 255, 255],
          "width": 7,
          "height": 36,
        }),
      ]
    }),
    es_play_fs_icon = new container ({
      "components": [
        new gpolygon ({
          "translate": [0, 0, 0],      
          "color": [255, 255, 255, 255],
          "vertex": [ 9,0,0,   -9,18,0,   -9,-18,0 ],
        })
      ]
    })
  ],
  "action": es_btn_play_fn
});

var es_fullscreen_btn_next = new actor({
  "translate": [192.0, 20.0, 0.0],
  "base_col": [[0, 0, 0, 0], [0, 0, 0, 0]],
  "bg_image": [
    new gbox ({
      "width": 264,
      "height": 56,
      "color": [103, 103, 103, 102]
    }),
    new container ({
      "visible_p": true,
      "components": [
        new gbox ({
          "translate": [+9, 0, 0],
          "color": ES_DEMO ? [102, 102, 102, 255] : [255,255,255,255],
          "width": 7,
          "height": 36,
        }),
        new gpolygon ({
          "translate": [-4, 0, 0],      
          "color": ES_DEMO ? [102, 102, 102, 255] : [255,255,255,255],
          "vertex": [ -9,18,0,    -9,-18,0,   9,0,0 ],
        })
      ]
    })
  ],
  "action": es_btn_next_fn
});

if (ES_DEMO) {
  es_fullscreen_btn_next.action = null;
}

var es_fullscreen_btn_exit = new actor({
  "translate": [402.0, 20.0, 0.0],
  "base_col": [[0, 0, 0, 0], [0, 0, 0, 0]],
  "bg_image": [
    new gbox({
      "width": 148,
      "height": 56,
      "color": [103, 103, 103, 102]
    }),
    new gtext({
      "text": es_text.RETURN,
      "width": 148,
      "height": 56,
      "font_size": 36,
      "align": CENTER
    })
  ],
  "action": function (obj) {
    es_fullscreen_control.display_off ();
    set_screen_mode (PIP_MOVIE_MODE);
    
    es_mainscreen.visible_p = true;
    es_fullscreen.visible_p = false;
    
    es_main.key_move = es_mainscreen_keymove; 
    common_key.set_cursor (es_main, es_player_video);
    
    force_redraw ();
  },
});

var es_fullscreen_sequence_time_pointer = new gbox({
  "translate": [-455.0,0,0],
  "width": 14,
  "height": 14
});

var es_fullscreen_sequence = new actor({
  "translate": [0.0, -30.0, 0.0],
  "base_col": [[0, 0, 0, 0],[0, 0, 0, 0]],
  "bg_image": [
    new gbox({
      "width": 952,
      "height": 36,
      "color": [103, 103, 103, 127]
    }),
    new gbox({
      "width": 754,
      "height": 14,
      "color": [0, 0, 0, 127],
      "translate": [-85.0, 0.0, 0.0]
    }),
    es_fullscreen_sequence_time_pointer,
    es_time_count_full = new gtext({
      "text": "00:00",
      "translate": [310.0, 2.0, 0.0],
      "width": 160,
      "height": 36,
      "font_size": 28,
      "margin": [0,0,12,12],
      "align": RIGHT
    }),
    es_time_countmax_full = new gtext({
      "text": "/00:00",
      "translate": [390.0, 2.0, 0.0],
      "width": 160,
      "height": 36,
      "font_size": 28,
      "margin": [0,0,12,12],
      "align": RIGHT
    })
  ]
});

var es_fullscreen_control = new container({
  "translate": [0.0, -400.0, 10.0],
  "components": [
    new gbox({
      "width": 984,
      "height": 128,
      "color": [41, 41, 41, 255]
    }),
    es_fullscreen_btn_prev,
    es_fullscreen_btn_play,
    es_fullscreen_btn_next,
    es_fullscreen_btn_exit,
    es_fullscreen_sequence
  ]
});

es_fullscreen_control.display_on = function () {
  delete_timer (this);
  this.visible_p = true;
  force_redraw ();
  append_timer (this, 3000, function (obj, count) {
    delete_timer (obj);
    obj.visible_p = false;
    force_redraw ();
  });  
};

es_fullscreen_control.display_off = function () {
  delete_timer (this);
  this.visible_p = false;
  force_redraw ();
};

var es_fullscreen_error_message = new actor({
  "translate": [0,0,0],
  "base_col_width": 0,
  "cursor_widrh": 0,
  "visible_p": false,
  "bg_image": [
    new gimage({
      "src": path + "common/not_found.png",
      "width": 320,
      "height": 240,
      "translate": [0.0, 20.0, 0.0]
    }),
    new gtextbox({
      "width": 750,
      "height": 150,
      "translate": [0.0, -160.0, 0.0],
      "color": [56, 56, 56, 255],
      "font_size": 38,
      "align": CENTER
    })
  ]
});

var es_fullscreen = new container({
    "components":[
      es_fullscreen_bg,
      es_fullscreen_video,
      es_fullscreen_control,
      es_fullscreen_loading_obj,
      es_fullscreen_error_message
    ],
  "visible_p": false,
});

var es_fullscreen_keymove = [
  [es_fullscreen_btn_play,
   es_fullscreen_btn_play, es_fullscreen_btn_play,
   es_fullscreen_btn_prev, es_fullscreen_btn_next],
  [es_fullscreen_btn_next,
   es_fullscreen_btn_next, es_fullscreen_btn_next,
   es_fullscreen_btn_play, es_fullscreen_btn_exit],
  [es_fullscreen_btn_prev,
   es_fullscreen_btn_prev, es_fullscreen_btn_prev,
   es_fullscreen_btn_prev, es_fullscreen_btn_play],
  [es_fullscreen_btn_exit,
   es_fullscreen_btn_exit, es_fullscreen_btn_exit,
   es_fullscreen_btn_next, es_fullscreen_btn_exit]
]

// /////////////////////////////////////////////
// ////////// EUROSPORT STAGE ES_MAIN //////////
// /////////////////////////////////////////////
try {
  var msg_demo = MSG_DEMONSTRATION;
} catch (e) {
  var msg_demo = "Demonstration";
}

var es_demo_text = new gtext ({
  "visible_p": ES_DEMO,
  "translate": [600, 500, 0],
  "width": 600,
  "height": 64,
  "color": [0x7f, 0x7f, 0x7f, 255],
  "text": msg_demo,
  "font_name": "F015T-bold",
  "align": RIGHT,
});

// ES COMPONENTS
var es_mainscreen = new container({
  "components":[
    es_leftbanner,
    es_videolist,
    es_player,
    es_error_popup,
    es_demo_text
  ],
  "visible_p": true
});

// ////////// KEY HOOK //////////
function es_key_hook(up_down, key) {
  var fn_enter_last_focus = function () {
    if (es_vlist_scroll.feed.data.length > 0) {
      var id = es_videolist_container.focus_comp_id;
      var focus_obj = es_videolist_container.components[id];
      if (focus_obj) {
	scroll_enter( es_videolist_container );
	common_key.set_cursor(es_main, focus_obj);
	force_redraw();
	return true;
      }
    }
    return false;
  };
  
  var fn_enter_color_focus = function (id) {
    if (es_lefttab.components[id].visible_p == true) {
      scroll_leave ( es_videolist_container );
      es_lefttab.components[id].action(es_lefttab);
      common_key.set_cursor(
	es_main, es_lefttab.components[id]);
      return true;
    }
    return false;
  }
  
  if (up_down != KEY_PRESS) {
    return false;
  }
  
  if (es_fullscreen.visible_p) {
    if (es_fullscreen_control.visible_p == false) {
      es_fullscreen_control.display_on();
      play_click_sound (0);
      return true;
    } else {
      if (key == TXK_RETURN) {
	es_fullscreen_btn_exit.action (es_fullscreen_btn_exit);
	return true;
      } else {
	es_fullscreen_control.display_on(); //OK?
      }
    }
  } else if (es_mainscreen.visible_p) {
    if (key == TXK_RETURN) {
      es_exit ();
      return true;
    } else if (!ES_DEMO && key == TXK_GREEN) {
      fn_enter_color_focus (1);
      play_click_sound (0);
      return true;
    } else if (!ES_DEMO && key == TXK_BLUE) {
      fn_enter_color_focus (3);
      play_click_sound (0);
      return true;
    } else if (!ES_DEMO && key == TXK_YELLOW) {	
      fn_enter_color_focus (2);
      play_click_sound (0);
      return true;
    } else if (!ES_DEMO && key == TXK_RED) {
      fn_enter_color_focus (0);
      play_click_sound (0);
      return true;
    }
  }
  
  switch (this.cursor) {
    
  case es_langtab.components[7]:
    if (key == TXK_RIGHT) {
      if (es_stream.uri) {
        common_key.set_cursor(es_main, es_player_video); 
        force_redraw();
        play_click_sound (0);
        return true;
      }
    }
    // no break
  case es_langtab.components[0]:
  case es_langtab.components[1]:
  case es_langtab.components[2]:
  case es_langtab.components[3]:
  case es_langtab.components[4]:
  case es_langtab.components[5]:
  case es_langtab.components[6]:
    // If lefttab invisible, then goto videolist
    if (key == TXK_DOWN) {
      if (es_lefttab.components[0].visible_p == false) {
        if (fn_enter_last_focus ()) {
          play_click_sound (0);
          return true;
        } else {
          // no action
        }
      }
    }
    break;        
    
  case es_lefttab.components[3]:
    if (key == TXK_RIGHT) {
      if (es_stream.uri) {
        common_key.set_cursor(es_main, es_player_video);
        force_redraw();
        play_click_sound (0);
        return true;
      }
    }
    // no break
  case es_lefttab.components[0]:
  case es_lefttab.components[1]:
  case es_lefttab.components[2]:
    if (key == TXK_DOWN ) {
      if (fn_enter_last_focus ()) {
        play_click_sound (0);
        return true;
      } else {
        // no action
      }
    }
    break;
    
  case es_player_video:
  case es_player_btn_prev:
    if (key == TXK_LEFT) {
      if (fn_enter_last_focus ()) {
        play_click_sound (0);
        return true;
      } else {
        common_key.set_cursor(es_main, es_lefttab.components[3]);
        force_redraw();
        play_click_sound (0);
        return true;
      }
    }
    break;
    
  default:
    break;
  }  
  
  // return to vieracast home
  if (key == TXK_LEFT &&
      (this.cursor == es_langtab.components[0] ||
       this.cursor == es_lefttab.components[0])) {
    es_exit ();
    return true;
  }
  
  // play_click_sound (0);
  mylog ("ES default key handler: " + up_down + " " + key);
  return common_key.old_way_emulate_hook2 (this, up_down, key);
}

// for access count
if (!ES_DEMO) {
  var es_count = new gimage({"visible_p": false, "src":""});
}

var es_main = stage({
  "symbol": "es_main",
  "in":
  [
    {
      "from": ["default"],
      "hook": function (obj) { 

        if (obj.es_stream) {
          obj.es_stream.connect (VideoDev, AudioDev);	
        }
        set_screen_mode (PIP_MOVIE_MODE);

        obj.cursor = null;
        obj.need_cursor_init = true; 
        
        // reset video progress bar
        setf_text (es_time_count, "00:00");
        setf_text (es_time_countmax, "/00:00");
        setf_text (es_time_count_full, "00:00");
        setf_text (es_time_countmax_full, "/00:00");	  
        es_time_pointer.translate[0] = -368;
        es_fullscreen_sequence_time_pointer.translate[0] = -455.0;

        var country_id = 0;
        if (!ES_DEMO) {
          try {
            var country_flash = nvram[3].read ("es_country");
            country_id = es_langtab_array[country_flash].lang;
            console.log ("Eurosport: read country_id: " + country_id + " " + country_flash);
            if (country_flash == null || country_id == undefined ) {
              console.log ("Eurosport: set country_id 0 UK");
              country_id = 0; // UK
            }	    
          } catch (e) {
            console.log ("Eurosport: set country_id 0 UK: " + e);
            country_id = 0; // UK
          }
        }

        // set flag icons
        for (var j=0; j<es_langtab.components.length-2; j++) {
          es_langtab.components[j].bg_image[0].visible_p = true;
          if (es_langtab.components[j].lang == country_id) {
            es_langtab.components[j].bg_image[1].visible_p = true;
          } else {
            es_langtab.components[j].bg_image[1].visible_p = false;
          }
        }

        es_vlist_scroll.init_feed();
        es_vlist_arrow_up.visible_p = false;
        es_vlist_arrow_down.visible_p = false;

        complete_on_stage (obj);

        var end_hook = function (obj) {	
          es_set_color_tab (country_id);
              
          es_vlist_scroll.do_get_feed(es_url_short, country_id, 
                    -1, -1, -1, -1, MAX_RESULTS, 
                    false, es_feed_callback_fn); 
        }
              
        try {
          var icon_pos = eval( "(" + ureg.read("eurosport_icon_pos") +")" );
          if( icon_pos[0] < 0 ) {
            anim.in_from.far_left (obj, 0, end_hook)
          } else if ( icon_pos[0] > 0 ){
            anim.in_from.far_right (obj, 0, end_hook)
          } else if ( icon_pos[1] < 0 ) {
            anim.in_from.far_bottom (obj, 0, end_hook);
          } else if ( icon_pos[1] > 0 ) {
            anim.in_from.far_top (obj, 0, end_hook);
          } else {
                  end_hook (obj);
                }
        } catch(e) {
                end_hook (obj);
        }
         if (!ES_DEMO) {
          es_count.src = path + "eurosport/count.png";
        }
      }
    }
  ],
  "out":
  [
    {
      "to": ["default"],
      "hook": function (obj) {

        if (obj.es_stream) {
          obj.es_stream.stop ();
          obj.es_stream.disconnect ();
        }
        
        obj.es_main.need_cursor_init = false;	
        es_pause_icon.visible_p = true;
        es_pause_fs_icon.visible_p = true;	  
        es_play_icon.visible_p = false;
        es_play_fs_icon.visible_p = false;
        
        // loading_obj.end_action	  
        es_vlist_loading_obj.end_action ();
        es_player_loading_obj.end_action();
        es_fullscreen_loading_obj.end_action();
        
        // error message
        es_error_message.visible_p = false;
        es_fullscreen_error_message.visible_p = false;	
        es_error_popup.visible_p = false;
        
        // unset cursor
        if (es_main.cursor) {
          es_main.cursor.in_cursor = false;
        }
        es_main.cursor = null;
        
        for (i=0; i<es_lefttab.components.length; i++) {
          es_lefttab.components[i].visible_p = false;
        }
        
        es_vlist_scroll.init_feed();
        
        // cancel any pending HTTP requests
        if (es_vlist_scroll.do_get_handle!=-1) {
          cancel_http_request(es_vlist_scroll.do_get_handle);
        }
        if (es_vlist_scroll.do_get_video_handle!=-1) {
          cancel_http_request(es_vlist_scroll.do_get_video_handle);
        }
        if (es_vlist_scroll.do_get_category_handle!=-1) {
          cancel_http_request(es_vlist_scroll.do_get_category_handle);
        }
        
        // clear video title
        setf_text (es_player.components[0], "");

        try {
          var icon_pos = eval( "(" + ureg.read("eurosport_icon_pos") + ")" );
          if( icon_pos[0] < 0 ) {
            anim.out_to.far_left(obj, 0, complete_off_stage);
          } else if ( icon_pos[0] > 0 ) {
            anim.out_to.far_right(obj, 0, complete_off_stage);
          } else if ( icon_pos[1] < 0 ) {
            anim.out_to.far_bottom (obj, 0, complete_off_stage);
          } else if ( icon_pos[1] > 0 ) {
            anim.out_to.far_top (obj, 0, complete_off_stage);
          } else {
                  complete_off_stage (obj);
                }
        } catch(e) {
          complete_off_stage (obj);
        }
        if (!ES_DEMO) {
          es_count.src = "";
        }
      }
    },
  ],
  "bg_image": [
    new gbox({
      "width": 1920 * 6,
      "height": 1080 * 6, 
      "color": [1, 23, 46, 255],
      "translate": [0.0, 0.0, -3325.5]
    })
  ],
  "components": [
    new gimage({
      "translate": [-1200.0, -300.0, -3300.0],
      "src": path+"eurosport/logoESP.png",
      "width": 810 * 3,
      "height": 501 * 3
    }),
    es_mainscreen,
    es_fullscreen
  ],
  "key_hook": es_key_hook
});

// ////////// KEY MOVE //////////
var es_mainscreen_keymove = [
  [es_langtab.components[0], null, es_lefttab.components[0], 
   null, es_langtab.components[1]],
  [es_langtab.components[1], null, es_lefttab.components[0], 
   es_langtab.components[0], es_langtab.components[2]],
  [es_langtab.components[2], null, es_lefttab.components[0], 
   es_langtab.components[1], es_langtab.components[3]],
  [es_langtab.components[3], null, es_lefttab.components[0], 
   es_langtab.components[2], es_langtab.components[4]],
  [es_langtab.components[4], null, es_lefttab.components[0], 
   es_langtab.components[3], es_langtab.components[5]],
  [es_langtab.components[5], null, es_lefttab.components[0], 
   es_langtab.components[4], es_langtab.components[6]],
  [es_langtab.components[6], null, es_lefttab.components[0], 
   es_langtab.components[5], es_langtab.components[7]],
  [es_langtab.components[7], null, es_lefttab.components[0], 
   es_langtab.components[6], null],

  [es_lefttab.components[0], es_langtab.components[0], null, 
   null, es_lefttab.components[1]],
  [es_lefttab.components[1], es_langtab.components[0], null, 
   es_lefttab.components[0], es_lefttab.components[2]],
  [es_lefttab.components[2], es_langtab.components[0], null, 
   es_lefttab.components[1], es_lefttab.components[3]],
  [es_lefttab.components[3], es_langtab.components[0], null, 
   es_lefttab.components[2], null],
  [es_player_video, null, es_player_btn_play, 
   null, null],
  [es_player_btn_play, es_player_video, null, 
   es_player_btn_prev, es_player_btn_next],
  [es_player_btn_prev, es_player_video, null, 
   null, es_player_btn_play],
  [es_player_btn_next, es_player_video, null, 
   es_player_btn_play, null],
];

es_main.key_move = es_mainscreen_keymove;



