//
// Copyright (C) 2008-2009 Panasonic Corporation. All Rights Reserved.
//

//add_stage_load_path ("bb_mainmenu",  path + "bloomberg/bb_mainmenu.js");
//add_stage_load_path ("bb_market",    path + "bloomberg/bb_market.js");
//add_stage_load_path ("bb_lookup",    path + "bloomberg/bb_lookup.js");
//add_stage_load_path ("bb_headlines", path + "bloomberg/bb_headlines.js");
//add_stage_load_path ("bb_info",      path + "bloomberg/bb_info.js");

//add_package_load_path ("common_menu", path + "lib/pkg_common_menu.js");
//add_package_load_path ("bb_util",     path + "bloomberg/pkg_bb_util.js");

(function(){
var stock = new Icon({});

stock.name = "bloomberg";

// [private]
stock.logo_src = path + "bloomberg/bloomberg-logo.png";

/**** TENTATIVE : depend on market ***/
stock.mkt = ureg.read("market");
if (!system.locale || system.locale.country.indexOf("US") == 0){ // US model
  stock.MARKET = [ { "name": "DOW",     "id":"INDU:IND" },
		   { "name": "S&P 500", "id":"SPX:IND" },
		   { "name": "NASDAQ",  "id":"CCMP:IND" },
		 ];
}else{ // not "US"
  switch( system.locale.country ){
  case "DE":
  case "AT":
  case "FR":
  case "IT":
  case "ES":
  case "PT":
  case "NL":
  case "DK":
  case "SE":
  case "NO":
  case "FI":
  case "BE":
  case "CH":
  case "GR":
  case "PL":
  case "CZ":
  case "HU":
  case "EEU":
  case "UK":
  case "IE":
  case "SK":
  case "HR":
  case "SI":
  case "EE":
  case "LT":
    stock.MARKET = [ { "name": "FTSE 100", "id":"UKX:IND" },
		     { "name": "CAC 40",   "id":"CAC:IND" },
		     { "name": "DAX",      "id":"DAX:IND" },
		   ]; // EU model
    break;
  case "AU":
  case "NZ":
    stock.MARKET = [ { "name": "DOW",     "id":"INDU:IND" },
		     { "name": "FTSE 100","id":"UKX:IND" },
		     { "name": "S&P/ASX", "id":"AS51:IND" },
		   ]; // AU & NZ
    break;
  default:
    stock.MARKET = [ { "name": "DOW",      "id":"INDU:IND" },
		     { "name": "FTSE 100", "id":"UKX:IND" },
		     { "name": "NIKKEI",   "id":"NKY:IND" },
		   ];
  }
}
/*** END ***/
stock.lang = ureg.read("language");

//stock.http_req_id = -1;
/*stock.getFeed = function( url ) {
  var onload = function (status, header, body) {
    if (status == 200) {
      var feed = eval("("+body+")");
      for (var i=0; i<3 ;i++) {
	var p = stock.mainPanel.stock[i];
	if (i<feed.length)
	  p.setData(stock.MARKET[i].name, feed[i].last, feed[i].change);
	else
	  p.setData("- - - - -", "- - - - -", "- - - - -");
      }
    }else{
      for (var i=0; i<3 ;i++) {
	var p = stock.mainPanel.stock[i];
	p.setData("- - - - -", "- - - - -", "- - - - -");
      }
    }
  };

  cancel_http_request( this.http_req_id );
  this.http_req_id = http_request ({url:url, onload:onload, sync:false});
  }*/

/*stock.loadFeed = function(){
  this.getFeed( MyHostName+"us/bloomberg/index.js,"
		+ stock.MARKET[0].id + ","
		+ stock.MARKET[1].id + ","
		+ stock.MARKET[2].id);
		};*/




stock.StockData = function (init){
  this.base = container;
  this.base( init );
  this.components = [
    this.back   = new gbox  ({width:360, height:62, color:[8,16,24,255] }),
    this.line   = new gbox  ({translate:[   0, 31,0], width:360, height:1,  color:[61,61,61,255] }),
    this.name   = new gtext ({translate:[   0, 15,0], width:320, font_size:28, omitter:"..."}),
    this.value  = new gtext ({translate:[ -60,-15,0], width:140, font_size:28, align:RIGHT}),
    this.change = new gtext ({translate:[ 100,-15,0], width:140, font_size:28, align:RIGHT}),
  ];
}

stock.StockData.prototype = new container({});

stock.StockData.prototype.setData = function ( name, value, change ){
  this.change.color = [255,255,255,255];
  if (change<0){
    this.change.color = [198,68,62,255];
  }else if (change>0){
    this.change.color = [109,209,80,255];
  }

  setf_text (this.name,   "" + name);
  setf_text (this.value,  "" + value);
  setf_text (this.change, "" + change);
}

stock.StockData.prototype.clearData = function (){
  setf_text (this.name,   "");
  setf_text (this.value,  "");
  setf_text (this.change, "");  
}

stock.StockData.prototype.setHighLight = function (b){
  if (b)
    this.back.color = [24,33,41,255];
  else
    this.back.color = [8,16,24,255];
}

stock.mainPanel = null;
stock.setPanel = function (){
  // mainPanel
  var p = new container ({});
  p.stock = [];
  p.components = [
    p.back     = new gbox({ width:360, height:252, color:[0,0,0,255] }),
    p.logo     = new gimage({translate: [0,96,0], src: this.logo_src,
			    onload: NULL_FUNCTION}),
    p.stock[0] = new stock.StockData ( {"translate":[0, 30,0]} ),
    p.stock[1] = new stock.StockData ( {"translate":[0,-34,0]} ),
    p.stock[2] = new stock.StockData ( {"translate":[0,-98,0]} ),
  ];
  p.stock[1].setHighLight(true);

  for(var i=0; i<3; i++)
      p.stock[i].setData("- - - - -", "- - - - -", "- - - - -");

  this.components.push( p );
  this.mainPanel = p;
};



stock.enter_stage = function(){
  // reduce texture memory
  //discard_stage ("bb_info");
  //discard_stage ("bb_market");
  //discard_stage ("bb_lookup");
  //discard_stage ("bb_headlines");
  //this.loadFeed();
  for (var i=0;i<this.mainPanel.stock.length;i++){
    this.mainPanel.stock[i].visible_p = true;
  }
}
stock.leave_stage = function(){
  delete_timer( this );
  //cancel_http_request( this.http_req_id );
  for (var i=0;i<this.mainPanel.stock.length;i++){
    this.mainPanel.stock[i].visible_p = false;
  }
}

stock.setAlpha = function(alpha){
  var v = (alpha==255);
  this.mainPanel.logo.color[3] = alpha;
  this.mainPanel.back.color[3] = alpha;
  for (var i=0;i<this.mainPanel.stock.length;i++){
    this.mainPanel.stock[i].visible_p = v;
  }
}

stock.freeResource = function ()
{
  this.mainPanel.logo.src = "";
  for (var i=0;i<this.mainPanel.stock.length;i++){
    this.mainPanel.stock[i].clearData();
  }
}

stock.resumeResource = function ()
{
  this.mainPanel.logo.src = this.logo_src;
  for(var i=0; i<3; i++)
      stock.mainPanel.stock[i].setData("- - - - -", "- - - - -", "- - - - -");
}

stock.getFrameColor = function (){
  return [99, 151, 184, 255];
}

//// END
stock.setPanel();
return stock;
 })();
