(load "/usr/local/slisp/station.lsp")(load "/usr/local/slisp/play.lsp")(defvar msg-pipe nil)(defmacro set-msg-pipe (fd)
`(setf msg-pipe (register-message 'msg-form
:fd ,fd
:header-size 8
:length-field 4)))(defvar is-aus nil)(defvar is-uk nil)(defvar is-ireland nil)(defvar is-nz nil)(defvar is-china nil)(defvar is-hk nil)(defvar is-asia nil)(defvar is-cont nil)(defvar is-nordic nil)(defvar is-finland nil)(defvar is-france nil)(defvar is-hungary nil)(defvar is-brazil nil)(defvar is-us nil)(defvar vao-enable nil)(defvar current-network 0)(defvar event-id nil)(defvar req-event-id nil)(defvar audio-choice-num nil)(defvar audio-track-list nil)(defvar changed-audio-track nil)(defvar select-dualmode -1)(defvar use-sad nil)(defvar with-downmix-loro nil)(defvar with-ac3 nil)(defvar with-ac3-plus nil)(defvar with-he-aac nil)(defvar with-ad nil)(defvar with-hd nil)(defvar with-freesat nil)(defvar with-dvb-t2 nil)(defvar preferred-audio nil)(defvar preferred-common-lang nil)(defvar preferred-audio-format nil)(defvar preferred-audio-format-list nil)(defvar preferred-subtitle nil)(defvar preferred-teletext nil)(defvar preferred-audio-type nil)(defvar ad-enable nil)(defvar ad-pid -1)(defvar ad-vol nil)(defvar ad-speaker nil)(defvar ad-earphone nil)(defvar is-ad-broadcast-mix nil)(defvar is-ad-receiver-mix nil)(defvar use-visual-impaired-ad nil)(defvar use-nar-ad nil)(defvar ad-list nil)(defvar subtitle-choice-num nil)(defvar subtitle-track-list nil)(defvar teletext-choice-num nil)(defvar with-ttx-sttl nil)(defvar sbtvd-captionlist nil)(defvar sbtvd-superimposedlist nil)(defvar old-sbtvd-captionlist nil)(defvar old-sbtvd-superimposedlist nil)(defvar with-play-cp-opt nil)(defvar pmt-dccd-gene -1)(defvar si-dccd-gene -1)(defvar play-hdd-opt-category nil)(defvar pmt-parsed nil)(defvar multi-play-hi-prio (+ (get-default-prio) 2))(defvar net-mode nil)(defvar req-subtitle nil)(defmacro ad-by-multiaudio-p (track)
`(if (and use-sad (eq 1 (get-track-audio-sad-found ,track)))(and (eq 1 (get-track-audio-sad-mix-type ,track))(eq 1 (get-track-audio-sad-ed-class ,track))(or (eq 3 (get-track-audio-type ,track))(if (eq current-network 3)(eq 0 (get-track-audio-type ,track)))))(and (string-equal "NAR" (get-track-audio-lang ,track))(or (eq 0 (get-track-audio-type ,track))(eq 3 (get-track-audio-type ,track))))))(defun send-trick-cap-info (cap)(write-bytes msg-pipe SC_RES_DLNA_TRICK_CAP 4 cap))(defun send-rental-limit ()(when (and notify-rental-limit rental-limit)(timeout-count-stop)(setf err-msg SC_RES_DIVX_RENTAL_LIMIT)(write-bytes msg-pipe err-msg 8 rental-limit)(setf notify-rental-limit nil)))(defmacro get-track-pid (track)
`(first ,track))(defmacro get-track-tag (track)
`(second ,track))(defmacro get-track-stype (track)
`(first (third ,track)))(defmacro get-track-video-codec (track)
`(first (third ,track)))(defmacro set-track-video-pcr (track val)
`(setf (nth 1 (nth 2 ,track)) ,val))(defmacro get-track-video-pcr (track)
`(second (third ,track)))(defmacro get-track-audio-format (track)
`(first (third ,track)))(defmacro get-track-audio-lang (track)
`(second (third ,track)))(defun get-lang-list (alist)(mapcan #'(lambda (lst)(list (get-track-audio-lang lst)))
alist))(defun get-sad-lang-list (alist)(mapcan #'(lambda (lst)(list (get-track-audio-sad-lang lst)))
alist))(defmacro get-track-audio-type (track)
`(third (third ,track)))(defun get-track-audio-dualmode (track)(case (get-stream-type)((STREAM_TTS_MODE STREAM_TS_MODE)(nth 3 (nth 2 track)))(STREAM_PS_MODE
(nth 1 track))(STREAM_DIVX_MODE
(nth 4 track))))(defun set-track-audio-dualmode (track val)(case (get-stream-type)((STREAM_TTS_MODE STREAM_TS_MODE)(setf (nth 3 (nth 2 track)) val))(STREAM_PS_MODE
(setf (nth 1 track) val))(STREAM_DIVX_MODE
(setf (nth 4 track) val))))(defmacro set-track-audio-language (track lang)
`(setf (nth 1 (nth 2 ,track)) ,lang))(defmacro get-track-audio-aac-type (track)
`(sixth (third ,track)))(defmacro get-track-subtitle-lang (track)
`(first (third ,track)))(defmacro get-track-subtitle-type (track)
`(second (third ,track)))(defmacro get-track-subtitle-composition-id (track)
`(third (third ,track)))(defmacro get-track-subtitle-ancillary-id (track)
`(fourth (third ,track)))(defmacro get-track-teletext-lang (track)
`(first (third ,track)))(defmacro get-track-teletext-type (track)
`(second (third ,track)))(defmacro get-track-teletext-magazine-number (track)
`(third (third ,track)))(defmacro get-track-teletext-page-number (track)
`(fourth (third ,track)))(defmacro tag2pid (tag lst)
`(first (find-if #'(lambda (x)(eq ,tag (second x)))
,lst)))(defmacro tag2track (tag lst)
`(find-if #'(lambda (x)(eq ,tag (second x)))
,lst))(defmacro get-default-video (lst)
`(car ,lst))(defmacro get-default-audio (lst)
`(car ,lst))(defmacro get-track-audio-sad-found (track)
`(first (fourth ,track)))(defmacro get-track-audio-sad-lang-present (track)
`(second (fourth ,track)))(defmacro get-track-audio-sad-lang (track)
`(third (fourth ,track)))(defmacro get-track-audio-sad-lang-if-avail (track)
`(if (and use-sad
(eq 1 (get-track-audio-sad-found ,track))(eq 1 (get-track-audio-sad-lang-present ,track)))(get-track-audio-sad-lang ,track)(get-track-audio-lang ,track)))(defmacro get-track-audio-sad-mix-type (track)
`(fourth (fourth ,track)))(defmacro get-track-audio-sad-ed-class (track)
`(fifth (fourth ,track)))(defmacro get-track-audio-adpid (track)
`(fifth (third ,track)))(defun get-adpid-list (alist)(mapcan #'(lambda (lst)(list (get-track-audio-adpid lst)))
alist))(defmacro set-track-audio-adpid (track val)
`(setf (nth 4 (nth 2 ,track)) ,val))(defmacro get-track-dual-audio-pid (track)
`(nth 0 ,track))(defmacro get-track-dual-audio-lang (track)
`(nth 1 ,track))(defmacro set-track-dual-audio-lang (track lang)
`(setf (nth 1 ,track) ,lang))(defmacro get-track-dual-audio-second-lang (track)
`(nth 2 ,track))(defmacro set-track-dual-audio-second-lang (track lang)
`(setf (nth 2 ,track) ,lang))(defmacro set-track-dual-audio-dualmode (track val)
`(setf (nth 3 ,track) ,val))(defmacro get-track-dual-audio-dualmode (track)
`(nth 3 ,track))(defun append-track (track lst)(setf-cdr (last lst) (cons track nil)))(defun set-parental-level (free level))(defun set-avsync-without-pcr (onoff)(set-video-ext 'video
(if onoff
"avsync-without-pcr"
nil)))(defun copy-audio-track (track)(case (get-stream-type)((STREAM_TTS_MODE STREAM_TS_MODE)(list (get-track-pid track)(get-track-tag track)(list (get-track-audio-format track)(copy-string (get-track-audio-lang track))(get-track-audio-type track)(get-track-audio-dualmode track)(get-track-audio-adpid track)(get-track-audio-aac-type track))(list (get-track-audio-sad-found track)(get-track-audio-sad-lang-present track)(copy-string (get-track-audio-sad-lang track))(get-track-audio-sad-mix-type track)(get-track-audio-sad-ed-class track))))(STREAM_PS_MODE
(copy-list track))(STREAM_DIVX_MODE
(list (nth 0 track) (nth 1 track) (nth 2 track) (list (copy-string (nth 0 (nth 3 track))) (nth 1 (nth 3 track))) (nth 4 track)))))(defmacro dual-mono-p (sym)
`(eq (audio-channel ,sym) 7))(defun decide-audio-dmix-mode (format)(if (eq with-downmix-loro t)
'AUDIO_DOWNMIX_LO_RO
(if (eq format #x11)
'AUDIO_DOWNMIX_LO_RO
'AUDIO_DOWNMIX_LT_RT)))(defun send-audio-choice-list-with-dualmode (type alist aid)(unless req-dualmode
(setf req-dualmode 0))(audio-dualmode 'audio req-dualmode)(let ((new-alist nil) (track))(mapcar #'(lambda (x)(if (and (eq aid (nth 0 x)) (eq (get-track-audio-dualmode x) -1))(progn
(setf track (copy-audio-track x))(set-track-audio-dualmode track 0)(if new-alist
(append-track track new-alist)(setf new-alist (cons track nil)))(setf track (copy-audio-track x))(set-track-audio-dualmode track 1)(append-track track new-alist))(if new-alist
(append-track x new-alist)(setf new-alist (cons x nil)))))
alist)(send-audio-choice-list type new-alist)))(defun clear-dualmode (send)(let ((alist nil) (last-delid nil))(setf req-dualmode nil)(when send
(mapcar #'(lambda (x)(if (eq (get-track-audio-dualmode x) -1)(if alist
(append-track x alist)(setf alist (cons x nil)))(unless (eq last-delid (nth 0 x))(setf last-delid (nth 0 x))(set-track-audio-dualmode x -1)(if alist
(append-track x alist)(setf alist (cons x nil))))))
audio-choice-list)(send-audio-choice-list (get-stream-type) alist))(audio-dualmode 'audio 0)))(defvar err-msg nil)(defvar last-progress nil)(defun send-loading-msg (decode)(when msg-pipe
(setf err-msg SC_RES_DLNA_WAIT)(if decode
(write-bytes msg-pipe err-msg 4 -1)(unless divx-hdrl
(set-timer #'(lambda (arg)(let ((progress (or (stream-load-rate 'stream-in content-uri) -1)))(unless (eq last-progress progress)(setf last-progress progress)(write-bytes msg-pipe err-msg 4 last-progress))))
'load-rate-timer
nil
nil
500))(setf last-progress (if divx-hdrl -1 (or (stream-load-rate 'stream-in content-uri) -1)))(write-bytes msg-pipe err-msg 4 last-progress))))(defun send-timeout-msg ()(when msg-pipe
(setf err-msg SC_RES_DLNA_NOT_PLAY)(write-bytes msg-pipe err-msg 4 0)))(defun send-play-ng-msg (code)(when msg-pipe
(timeout-count-stop)(setf err-msg SC_RES_DLNA_NOT_ACCESS)(write-bytes msg-pipe err-msg 8 0 code)))(defmacro send-play-ok-msg ())(defun clear-msg ()(timeout-count-stop)(when (and msg-pipe err-msg)(write-bytes msg-pipe SC_RES_DLNA_ERR_CLEAR 4 1)(setf err-msg nil)))(defun send-teletext-choice-list (type lst)(unless (and (equal teletext-choice-list lst) (eq event-id last-teletext-event))(if lst
(progn
(when teletext-choice-list
(write-bytes msg-pipe SC_RES_TELETEXT 0))(write-bytes msg-pipe SC_RES_TELETEXT (* (length lst) 24) lst))(write-bytes msg-pipe SC_RES_TELETEXT 0))(setf last-teletext-event event-id)(setf teletext-choice-list lst)))(defun send-sbtvd-captionlist (lst)(unless (eq old-sbtvd-captionlist lst)(if (eq lst nil)(write-bytes msg-pipe SC_RES_SBTVD_CAPTION 8 0 0)(write-bytes msg-pipe SC_RES_SBTVD_CAPTION (* (length lst) 8) lst))(setf old-sbtvd-captionlist lst)))(defun send-sbtvd-superimposedlist (lst)(unless (eq old-sbtvd-superimposedlist lst)(if (eq lst nil)(write-bytes msg-pipe SC_RES_SBTVD_SUPERIMPOSED 8 0 0)(write-bytes msg-pipe SC_RES_SBTVD_SUPERIMPOSED (* (length lst) 8) lst))(setf old-sbtvd-superimposedlist lst)))(defun insert-sort-sbtvd-captionlist (tag pid lst)(let ((pos nil))(when (and lst (< (length lst) 8))(setf pos (position-if #'(lambda (x) (<= tag (second x))) lst))(if (not pos)(setf-cdr (last lst) (cons (list pid tag) nil))(setf-nthcdr pos lst (cons (nth pos lst) (nthcdr (1+ pos) lst)))(setf-nth pos lst (list pid tag))))(when (null lst)(setf lst (cons (list pid tag) nil)))
lst))(defvar *dlna-open-timeout* 3000)(defvar *dlna-play-timeout* 5000)(defun timeout-count-start (msec decode)(unless (or (find-timer 'loading-timer)(find-timer 'timeout-timer))(when (and msg-pipe err-msg)(write-bytes msg-pipe SC_RES_DLNA_ERR_CLEAR 4 1)(setf err-msg nil))(set-timer #'(lambda (arg)(send-loading-msg arg)(set-timer #'(lambda (arg)(timeout-count-stop)(send-timeout-msg))
'timeout-timer
nil
1
30000))
'loading-timer
decode
1
msec)))(defun timeout-count-stop ()(cancel-timer 'load-rate-timer)(cancel-timer 'loading-timer)(cancel-timer 'timeout-timer))(defmacro send-finish-event (id)
`(write-bytes msg-pipe SC_RES_CONTENT_ID 4 ,id))(defmacro send-hdd-fatal ()
`(write-bytes msg-pipe SC_RES_HDD_FATAL 4 0))(defmacro send-hdd-hangup ()
`(write-bytes msg-pipe SC_RES_HDD_HUNGUP 4 0))(defmacro send-content-time-msg (id tm)
`(write-bytes msg-pipe SC_RES_CONTENT_TIME 8 ,id
(or ,tm 0)))(defmacro send-play-time-msg (id tm)
`(write-bytes msg-pipe SC_RES_PLAY_TIME 8 ,id
(or ,tm 0)))(defmacro send-play-pause-event ()
`(if req-content-id
(write-bytes msg-pipe SC_RES_PAUSE_OK 12
req-content-id
(if req-stream-s-index req-stream-s-index -1)
0)))(defun send-video-lost ()(when (boundp 'SC_RES_VIDEO_LOST)(write-bytes msg-pipe SC_RES_VIDEO_LOST 0)))(defun send-audio-decode-info (result)(if result
(case (get-stream-type)((STREAM_TTS_MODE STREAM_TS_MODE)(if (eq result 'DECODE_SUCCESS)(progn
(send-dual-audio-choice-list (create-dual-audio-choice-list
'audio audio-choice-list))(send-playing-audio (get-stream-type)(list (get-audio-pid 'audio)(audio-stream-info 'audio 'channel 'lfe)(if (dual-mono-p 'audio)(progn
(when (eq select-dualmode -1)(setf select-dualmode 0))(audio-dualmode 'audio select-dualmode))
-1)(get-track-audio-lang (first audio-choice-list)))))(if (and (eq result 'DECODE_ERROR)(not playing-audio))(send-playing-audio (get-stream-type) (list #x1fff '(-1 -1) -1 "---"))(send-playing-audio (get-stream-type)(list (get-audio-pid 'audio) '(-1 -1) -1 "---")))))(otherwise
(if (eq result 'DECODE_SUCCESS)(send-playing-audio (get-stream-type)(list (get-audio-codec-id (get-stream-audio-codec))(audio-stream-info 'audio 'channel)))(send-playing-audio (get-stream-type) (list -1 -1)))))))(setf last-cp-info nil)(defun do-copy-protection ()(let ((cp-info (list
(cp-ref 'cp "optout-control-code")(cp-ref 'cp "optout-category-code")(if (cp-ref 'cp "digital-audio")
1
0)(if (cp-ref 'cp "analog-ex-video")
1
0)(cp-ref 'cp "analog-ex-video-mv")(cp-ref 'cp "analog-ex-video-cgms")(if (cp-ref 'cp "analog-ex-audio")
1
0))))(unless (equal last-cp-info cp-info)(setf last-cp-info cp-info)(write-bytes (or msg-pipe rui-msg-pipe) SC_RES_COPYCONTROL 28 cp-info))))(defvar video-choice-list nil)(defvar audio-choice-list nil)(defvar pmt-ver nil)(defvar dual-audio-choice-list nil)(defvar subtitle-choice-list nil)(defvar teletext-choice-list nil)(defvar last-video-event nil)(defvar last-audio-event nil)(defvar last-subtitle-event nil)(defvar last-teletext-event nil)(defvar playing-video nil)(defvar playing-audio nil)(defvar playing-audio-ps nil)(defvar unsupported-audio nil)(defun send-video-choice-list (type lst)(unless (and (equal video-choice-list lst) (eq event-id last-video-event))(if lst
(let ((pos))(setf pos (position (assoc req-video lst) lst))(unless pos
(setf pos 0))(case type
(STREAM_TTS_MODE
(write-bytes (or msg-pipe rui-msg-pipe) SC_RES_VIDEO (+ (* (length lst) 16) 8) 1 pos lst))(STREAM_TS_MODE
(write-bytes (or msg-pipe rui-msg-pipe) SC_RES_VIDEO (+ (* (length lst) 16) 8) 4 pos lst))(STREAM_PS_MODE
(write-bytes (or msg-pipe rui-msg-pipe) SC_RES_VIDEO (+ (* (length lst) 4) 8) 2 pos lst))(STREAM_DIVX_MODE
(write-bytes (or msg-pipe rui-msg-pipe) SC_RES_VIDEO (+ (* (length lst) 12) 8) 3 pos
(mapcar #'(lambda (x)(let ((y))(setf y (copy-list x))(setf (nth 2 y) (uimsbf 32 (nth 2 y)))
y))
lst)))(STREAM_MKV_MODE
(let ((dur (if mkv-duration mkv-duration 0)))(write-bytes (or msg-pipe rui-msg-pipe) SC_RES_VIDEO (+ (* (length lst) 12) 12) 5 pos dur lst)))))(write-bytes (or msg-pipe rui-msg-pipe) SC_RES_VIDEO 0))(setf last-video-event event-id)(setf video-choice-list lst)))(defun send-dual-audio-choice-list (lst)(unless (equal dual-audio-choice-list lst)(if lst
(progn
(write-bytes (or msg-pipe rui-msg-pipe) SC_RES_DUAL_AUDIO (+ (* (length lst) 16) 8) 4 1 lst))(write-bytes (or msg-pipe rui-msg-pipe) SC_RES_DUAL_AUDIO 0))(setf dual-audio-choice-list lst)))(defun send-audio-choice-list (type lst)(unless (and (equal audio-choice-list lst) (eq event-id last-audio-event))(if lst
(let ((pos))(setf pos (position-if #'(lambda (x)(and (eq req-audio (nth 0 x))(or (not req-dualmode)(eq req-dualmode (get-track-audio-dualmode x)))))
lst))(unless pos
(setf pos 0))(case type
(STREAM_TTS_MODE
(write-bytes (or msg-pipe rui-msg-pipe) SC_RES_AUDIO (+ (* (length lst) 52) 8) 1 pos lst))(STREAM_TS_MODE
(write-bytes (or msg-pipe rui-msg-pipe) SC_RES_AUDIO (+ (* (length lst) 52) 8) 4 pos lst))(STREAM_PS_MODE
(write-bytes (or msg-pipe rui-msg-pipe) SC_RES_AUDIO (+ (* (length lst) 8) 8) 2 pos lst))(STREAM_DIVX_MODE
(write-bytes (or msg-pipe rui-msg-pipe) SC_RES_AUDIO (+ (* (length lst) 29) 8) 3 pos lst))(STREAM_MKV_MODE
(write-bytes (or msg-pipe rui-msg-pipe) SC_RES_AUDIO (+ (* (length lst) 29) 8) 5 pos lst))))(if unsupported-audio
(write-bytes (or msg-pipe rui-msg-pipe) SC_RES_AUDIO 4 -1)(write-bytes (or msg-pipe rui-msg-pipe) SC_RES_AUDIO 0)))(setf last-audio-event event-id)(setf audio-choice-list lst)))(defun send-subtitle-choice-list (type lst reset)(unless (and (equal subtitle-choice-list lst) (eq event-id last-subtitle-event))(if lst
(let ((pos) (msg))(setf pos (position (assoc req-subtitle lst) lst))(if (= reset 1)(setf msg SC_RES_SUBTITLE)(setf msg SC_RES_SUBTITLE_NORESET))(unless pos
(setf pos 0))(case type
(STREAM_TTS_MODE
(write-bytes (or msg-pipe rui-msg-pipe) msg (+ (* (length lst) 24) 8) 1 pos lst))(STREAM_TS_MODE
(write-bytes (or msg-pipe rui-msg-pipe) msg (+ (* (length lst) 24) 8) 4 pos lst))(STREAM_DIVX_MODE
(write-bytes (or msg-pipe rui-msg-pipe) SC_RES_SUBTITLE (+ (* (length lst) 29) 8) 3 pos
(mapcar #'(lambda (x)(let ((y))(setf y (copy-list x))(setf (nthcdr 4 y) nil)(setf (nth 3 y) (uimsbf 32 (nth 3 y)))
y))
lst)))(STREAM_MKV_MODE
(write-bytes (or msg-pipe rui-msg-pipe) SC_RES_SUBTITLE (+ (* (length lst) 29) 8) 5 pos lst))))(write-bytes (or msg-pipe rui-msg-pipe) SC_RES_SUBTITLE 0))(setf last-subtitle-event event-id)(setf subtitle-choice-list lst)))(defun send-playing-video (info)(unless (equal playing-video info)(write-bytes (or msg-pipe rui-msg-pipe) SC_RES_PLAYING_VIDEO 4 (if info info -1))(setf playing-video info)))(defun send-playing-audio (type info)(case type
((STREAM_TTS_MODE STREAM_TS_MODE)(unless (equal playing-audio info)(write-bytes (or msg-pipe rui-msg-pipe)
SC_RES_PLAYING_AUDIO (+ 20 8) 4 1 (if (and info (nth 0 info))(list (nth 0 info)(list
(if (nth 0 (nth 1 info))(nth 0 (nth 1 info))
-1)(if (nth 1 (nth 1 info))(nth 1 (nth 1 info))
-1))(if (nth 2 info)(nth 2 info)
-1)(if (nth 3 info)(nth 3 info)
-1))(list -1 '(-1 -1) -1 "---")))(setf playing-audio info)))((STREAM_PS_MODE)(unless nil
(write-bytes (or msg-pipe rui-msg-pipe)
SC_RES_PLAYING_AUDIO (+ 8 8) 2 1 (if info (list (nth 0 info)(nth 1 info))(list -1 -1)))(setf playing-audio-ps info)))))(defun send-mkv-choice-list (vlist alist slist)(send-video-choice-list (get-stream-type) vlist)(send-audio-choice-list (get-stream-type) alist)(send-subtitle-choice-list (get-stream-type) slist 1))(defun send-divx-choice-list (vlist alist slist)(send-video-choice-list (get-stream-type) vlist)(if req-dualmode
(send-audio-choice-list-with-dualmode (get-stream-type) alist req-audio)(send-audio-choice-list (get-stream-type) alist))(send-subtitle-choice-list (get-stream-type) slist 1))(defun send-ps-choice-list (vlist alist slist)(send-video-choice-list (get-stream-type) vlist)(send-audio-choice-list (get-stream-type) alist))(defun ppmt-parser (pmt)(set-video-pcr 'video nil)(set-audio-pcr 'audio nil)(setf audio-track-list nil)(setf subtitle-track-list nil)(setf sbtvd-captionlist nil)(setf sbtvd-superimposedlist nil)(setf pmt-dccd-gene -1)(setf ad-list nil)(if (eq with-ttx-sttl t)(send-pmt-parsing nil))(if (not pmt)(progn
(cancel-timer 'ppmt-delayed-eval-timer)(setf pmt-ver nil)(setf pmt-svcid nil)(send-video-choice-list nil nil)(send-audio-choice-list nil nil)(send-dual-audio-choice-list nil)(send-subtitle-choice-list nil nil 1)(when hdd-mode
(send-teletext-choice-list nil nil))(send-playing-video nil)(send-playing-audio 'STREAM_TTS_MODE nil)(when is-brazil (send-sbtvd-captionlist nil))(when is-brazil (send-sbtvd-superimposedlist nil))(set-video-pid 'video nil)(set-audio-pid 'audio nil))(let ((header) (firstlp) (secondlp) (esheader) (esdesclp) (pcrpid) (update nil)(stype) (espid) (tag) (track) (lang) (type) (info-desc) (txt-sttl-desc)(vlist nil) (alist nil) (slist nil) (tlist nil)(sad-lang (copy-string "---")) (sad-mix-type -1)(sad-ed-class -1) (sad-found 0) (sad-lang-present -1)(lang-list nil) (type-list nil)(dualmode nil))(setf header (first pmt))(setf firstlp (second pmt))(setf secondlp (third pmt))(setf pmt-svcid (+ (* (nth 3 header) #x100) (nth 4 header)))(setf pcrpid (+ (* (logand (nth 8 header) #x1F) #x100)(nth 9 header)))(unless (eq pmt-ver (nth 5 header))(when pmt-ver
(setf update t))(setf pmt-ver (nth 5 header)))(mapcar #'(lambda (desc)(when (eq (+ 2 (second desc)) (length desc))(case (first desc)(#xc1
(let ((cct) (drcd))(setf drcd (/ (logand (nth 2 desc) #xc0) #x40))(setf cct (/ (logand (nth 2 desc) #x0c) #x04))(setf pmt-dccd-gene drcd)(when (= drcd #x01)(setf pmt-dccd-gene
(cond ((= cct #x3)
-1)((= cct #x1)
#x3)(t
#x0)))))))))
firstlp)(mapcar #'(lambda (eslp)(setf esheader   (first eslp))(setf esdesclp (second eslp))(setf stype (first esheader))(setf espid (+ (* (logand (second esheader) #x1F) #x100)(third esheader)))(setf tag -1)(setf aac-type -1)(setf lang (copy-string "---"))(setf type 0)(setf info-desc nil)(setf txt-sttl-desc nil)(setf lang-list nil)(setf type-list nil)(setf sad-mix-type -1)(setf sad-ed-class -1)(setf sad-lang (copy-string "---"))(setf sad-lang-present -1)(setf sad-found 0)(mapcar #'(lambda (desc)(when (eq (+ 2 (second desc)) (length desc))(case (first desc)(#x52
(setf tag (third desc)))(#x0a
(let ((desclen))(setf desclen (- (second desc) 1))(do ((loopcount 0 (+ loopcount 4)))((> loopcount desclen) loopcount)(setf lang (copy-string "---"))(setf-char lang 0 (nth (+ 2 loopcount) desc))(setf-char lang 1 (nth (+ 3 loopcount) desc))(setf-char lang 2 (nth (+ 4 loopcount) desc))(if lang-list
(setf-cdr (last lang-list) (cons lang nil))(setf lang-list (cons lang nil)))(setf type (nth 5 desc))(if type-list
(setf-cdr (last type-list) (cons type nil))(setf type-list (cons type nil))))))((#x66 #x6a #x7a)(setf info-desc desc))(#x7f
(case (third desc)(#x06
(setf sad-found 1)(setf sad-mix-type (/ (logand (nth 3 desc) #x80) #x80))(setf sad-ed-class (/ (logand (nth 3 desc) #x7c) #x04))(setf sad-lang-present (logand (nth 3 desc) #x01))(if sad-lang-present
(progn
(setf sad-lang (copy-string "---"))(setf-char sad-lang 0 (nth 4 desc))(setf-char sad-lang 1 (nth 5 desc))(setf-char sad-lang 2 (nth 6 desc)))))))((#x56 #x59)(when (and txt-sttl-desc (/= (first (car txt-sttl-desc)) (first desc)))(setf txt-sttl-desc nil))(setf txt-sttl-desc (cons desc txt-sttl-desc)))((#x7c)(if (= (logand (fourth desc) #x80) #x80)(setf aac-type (fifth desc)))))))
esdesclp)(case stype
((#x01 #x02 #x1b)(unless (and (eq stype #x1b) (not (or with-hd (not (eq current-network 1)))))(setf track (list espid tag (list stype pcrpid)))(if vlist
(append-track track vlist)(setf vlist (cons track nil)))))((#x24)(when with-4k
(setf track (list espid tag (list stype pcrpid)))(if vlist
(append-track track vlist)(setf vlist (cons track nil)))))(#x80
(when is-us
(unless (and (eq stype #x1b) (not (or with-hd (not (eq current-network 1)))))(setf track (list espid tag (list stype pcrpid)))(if vlist
(append-track track vlist)(setf vlist (cons track nil))))))((#x03 #x04 #x0f #x11 #x81)(unless lang-list
(setf lang-list (cons lang nil)))(do ((loopcount 0 (+ loopcount 1)))((> loopcount (- (length lang-list) 1)) loopcount)(unless (or (and (eq stype #x11) (not with-he-aac))(and (eq stype #x81) (not with-ac3)))(setf track (list espid
tag
(list stype
(nth loopcount lang-list)(if type-list
(nth loopcount type-list)
-1)
-1
-1
aac-type)(list sad-found
sad-lang-present
sad-lang
sad-mix-type
sad-ed-class)))(if (and with-ad
is-ad-receiver-mix
(or (eq type 0) (eq type 3))(or (and is-uk
(eq type 3)(eq sad-found 0))(and
(eq sad-found 1)(eq sad-ed-class 1)(eq sad-mix-type 0)))(or (eq stype #x03)(eq stype #x04)(eq stype #x11)))(if ad-list
(setf-cdr (last ad-list) (cons track nil))(setf ad-list (cons track nil)))(when (or (not with-ad) (not (eq sad-found 1)) (eq sad-mix-type 1) (and (eq sad-mix-type 0) (/= sad-ed-class 1)))(if audio-track-list
(setf-cdr (last audio-track-list) (cons track nil))(setf audio-track-list (cons track nil)))(if alist
(append-audio-track track alist)(setf alist (cons track nil))))))))(#x06
(when info-desc
(case (first info-desc)((#x6a #x7a)(let ((fmt nil))(when (and with-ac3 (eq (first info-desc) #x6a))(setf fmt #x81))(when (and with-ac3-plus (eq (first info-desc) #x7a))(setf fmt #x82))(when fmt
(unless lang-list
(setf lang-list (cons lang nil)))(do ((loopcount 0 (+ loopcount 1)))((> loopcount (- (length lang-list) 1)) loopcount)(setf track (list espid
tag
(list fmt
(nth loopcount lang-list)(if type-list
(nth loopcount type-list)
-1)
-1
-1
aac-type)(list sad-found
sad-lang-present
sad-lang
sad-mix-type
sad-ed-class)))(if (and with-ad
is-ad-receiver-mix
(or (eq type 0) (eq type 3))(or (and is-uk
(eq type 3)(eq sad-found 0))(and
(eq sad-found 1)(eq sad-ed-class 1)(eq sad-mix-type 0)))(eq fmt #x82))(if ad-list
(setf-cdr (last ad-list) (cons track nil))(setf ad-list (cons track nil)))(when (or (not with-ad) (not (eq sad-found 1)) (eq sad-mix-type 1) (and (eq sad-mix-type 0) (/= sad-ed-class 1)))(if audio-track-list
(setf-cdr (last audio-track-list) (cons track nil))(setf audio-track-list (cons track nil)))(if alist
(append-audio-track track alist)(setf alist (cons track nil)))))))))))(when txt-sttl-desc
(case (first (car txt-sttl-desc))(#x59
(mapcar #'(lambda (info)(if (>= (second info) 8)(do ((x 0 (+ x 8)) (lp (nthcdr 2 info) (setf lp (nthcdr 8 lp)))(composition-id) (ancillary-id))((>= x (second info)))(setf lang (copy-string "---"))(setf-char lang 0 (nth 0 lp))(setf-char lang 1 (nth 1 lp))(setf-char lang 2 (nth 2 lp))(setf type (nth 3 lp))(setf composition-id (+ (* (nth 4 lp) #x100) (nth 5 lp)))(setf ancillary-id (+ (* (nth 6 lp) #x100) (nth 7 lp)))(setf track (list espid tag (list lang type composition-id ancillary-id)))(if subtitle-track-list
(setf-cdr (last subtitle-track-list) (cons track nil))(setf subtitle-track-list (cons track nil)))(if slist
(append-subtitle-track track slist)(setf slist (cons track nil))))(setf track (list espid tag (list (copy-string "---")  0 0 0)))(if subtitle-track-list
(setf-cdr (last subtitle-track-list) (cons track nil))(setf subtitle-track-list (cons track nil)))(if slist
(append-track track slist)(setf slist (cons track nil)))))
txt-sttl-desc))(#x56
(mapcar #'(lambda (info)(if (>= (second info) 5)(do ((x 0 (+ x 5)) (lp (nthcdr 2 info) (setf lp (nthcdr 5 lp)))(magazine-number) (page-number))((>= x (second info)))(setf lang (copy-string "---"))(setf-char lang 0 (nth 0 lp))(setf-char lang 1 (nth 1 lp))(setf-char lang 2 (nth 2 lp))(setf type (/ (logand (nth 3 lp) #xf8) #x8))(setf magazine-number (logand (nth 3 lp) #x07))(setf page-number (nth 4 lp))(setf track (list espid tag (list lang type magazine-number page-number)))(if tlist
(append-teletext-track track tlist)(setf tlist (cons track nil))))(setf track (list espid tag (list (copy-string "---") 0 0 0)))(if tlist
(append-teletext-track track tlist)(setf tlist (cons track nil)))))
txt-sttl-desc))))(when is-brazil
(when (and (>= tag #x30) (<= tag #x37))(setf sbtvd-captionlist
(insert-sort-sbtvd-captionlist
tag espid sbtvd-captionlist)))(when (and (>= tag #x38) (<= tag #x3F))(setf sbtvd-superimposedlist
(insert-sort-sbtvd-captionlist
tag espid sbtvd-superimposedlist)))))))
secondlp)(when is-nz
(set-preferred-common-lang audio-track-list subtitle-track-list)(setf alist nil)(mapcar #'(lambda (x)(if alist
(append-audio-track x alist)(setf alist (cons x nil))))
audio-track-list)(setf slist nil)(mapcar #'(lambda (x)(if slist
(append-subtitle-track x slist)(setf slist (cons x nil))))
subtitle-track-list))(when ad-list
(mapcar #'(lambda (x)(mapcar #'(lambda (y)(when (and (< (get-track-audio-adpid y) 0)(or
(and (= (get-track-audio-type y) 0)(if (or (= (get-track-audio-format y) #x03) (= (get-track-audio-format y) #x04))(or (= (get-track-audio-format x) #x03) (= (get-track-audio-format x) #x04))(eq (get-track-audio-format y) (get-track-audio-format x)))(string= (get-track-audio-sad-lang-if-avail x) (get-track-audio-sad-lang-if-avail y)))(and is-uk
(or (and (eq eng-found-alist 0)(string= "und" (get-track-audio-sad-lang-if-avail y))(or (string= "eng" (get-track-audio-sad-lang-if-avail x))(string= "en" (get-track-audio-sad-lang-if-avail x))))(and (eq eng-found-ad-list 0)(string= "und" (get-track-audio-sad-lang-if-avail x))(or (string= "eng" (get-track-audio-sad-lang-if-avail y))(string= "en" (get-track-audio-sad-lang-if-avail y)))))))(or (eq (get-track-audio-format y) #x03)(eq (get-track-audio-format y) #x04)(eq (get-track-audio-format y) #x82)(eq (get-track-audio-format y) #x11)))(set-track-audio-adpid y (get-track-pid x))))
alist))
ad-list)(setf alist nil)(mapcar #'(lambda (x)(if alist
(append-audio-track x alist)(setf alist (cons x nil))))
audio-track-list))(when with-play-cp-opt
(when hdd-mode
(set-cp-opt-generation 'cp (get-play-cp-opticalout-generation))(set-cp-opt-category 'cp play-hdd-opt-category)))(eval-copy-protection)(setf last-video (if (and req-video (assoc req-video vlist))(assoc req-video vlist)(get-default-video vlist)))(if (and (eq is-finland t) update)(progn
(setf req-audio (get-track-pid (get-default-audio alist)))(setf dualmode nil)))(if (and req-audio (assoc req-audio alist))(progn
(setf last-audio (assoc req-audio alist))(setf dualmode req-dualmode))(if (and last-audio (assoc (get-track-pid last-audio) alist))(progn
(setf last-audio (assoc (get-track-pid last-audio) alist))(setf dualmode select-dualmode))(progn
(setf last-audio (get-default-audio alist))(setf dualmode nil))))(setf req-video (get-track-pid last-video))(setf req-audio (get-track-pid last-audio))(if (and (or dlna-mode net-mode) (get-trik-video-pid)(not (and (eq (get-trik-video-pid) (get-track-pid last-video))(eq (get-trik-video-codec) (get-track-stype last-video))(eq (get-trik-audio-pid) (get-track-pid last-audio))(eq (get-trik-audio-format) (get-track-stype last-audio)))))(progn
(cancel-timer 'ppat-reset-timer)(cancel-timer 'ppmt-reset-timer)(section-disable 'ppat)(section-disable 'ppmt)(set-timer #'(lambda (arg)(set-timer #'(lambda (arg)(make-event 'restart-pat-reset-monitor)(make-event 'restart-pmt-reset-monitor))
'ppmt-block-timer
nil
1
2000)(unless (and (eq (get-trik-video-pid) (get-track-pid last-video))(eq (get-trik-video-codec) (get-track-stype last-video)))(setf stop-mode nil))(setf trik-mode nil)(make-event 'trik-mode-off)(clear-dualmode nil)(set-video-pcr 'video (get-track-video-pcr last-video))(set-video-pid 'video (get-track-pid last-video))(set-trik-video-pid (get-video-pid 'video))(set-trik-video-codec (get-track-stype last-video))(when (and last-video-codec (not (eq last-video-codec (get-trik-video-codec))))(setf stop-mode nil))(audio-attr 'audio (if (eq (get-track-stype last-video) #x1b) 'avc
(if (eq (get-track-stype last-video) #x24) 'hevd 'mpeg2)))(set-audio-pcr 'audio (get-video-pcr 'video))(when hdd-mode
(set-audio-dmix-mode 'audio (decide-audio-dmix-mode (get-track-audio-format last-audio))))(set-audio-pid 'audio (get-track-pid last-audio))(set-trik-audio-pid (get-audio-pid 'audio))(set-trik-audio-format (get-track-stype last-audio)))
'ppmt-delayed-eval-timer
nil
1
0))(set-video-pcr 'video (get-track-video-pcr last-video))(set-video-pid 'video (get-track-pid last-video))(set-trik-video-pid (get-video-pid 'video))(set-trik-video-codec (get-track-stype last-video))(when (and last-video-codec (not (eq last-video-codec (get-trik-video-codec))))(setf stop-mode nil))(audio-attr 'audio (if (eq (get-track-stype last-video) #x1b) 'avc
(if (eq (get-track-stype last-video) #x24) 'hevd 'mpeg2)))(setf track (assoc (get-audio-pid 'audio) alist))(when (and update track (not (equal track changed-audio-track)))(setf changed-audio-track nil)(setf track nil))(unless track
(ad-stop)(unless track
(setf track (car alist))))(set-audio-pcr 'audio (get-video-pcr 'video))(when hdd-mode
(set-audio-dmix-mode 'audio (decide-audio-dmix-mode (get-track-audio-format last-audio))))(set-audio-pid 'audio (get-track-pid last-audio))(when track
(ad-play (get-track-audio-adpid track)))(set-trik-audio-pid (get-audio-pid 'audio))(set-trik-audio-format (get-track-stype last-audio)))(send-video-choice-list (get-stream-type) vlist)(send-audio-choice-list (get-stream-type)(create-audio-choice-list 'audio audio-track-list))(if dualmode
(setf select-dualmode dualmode)(setf select-dualmode
(get-track-audio-dualmode (assoc (get-audio-pid 'audio) audio-choice-list))))(send-dual-audio-choice-list (create-dual-audio-choice-list
'audio audio-choice-list))(send-subtitle-choice-list (get-stream-type) slist 1)(when hdd-mode
(send-teletext-choice-list (get-stream-type) tlist))(when is-brazil
(send-sbtvd-captionlist sbtvd-captionlist)(send-sbtvd-superimposedlist sbtvd-superimposedlist))(send-playing-video (get-video-pid 'video))(if (eq with-ttx-sttl t)(send-pmt-parsing t)))))(defun ad-play (pid)(setf ad-pid pid)(make-event 'ad-valid-check)(make-event 'ad-pid-update))(defun ad-stop ()(setf ad-pid -1)(make-event 'ad-valid-check))(register-device 'video-for-ad
"video"
(get-default-prio)
#'(lambda (sig)))(register-device 'audio-desc
"audio"
(get-default-prio)
#'(lambda (sig)(case sig
(AVAILABLE
(set-owner 'audio-desc t))(LOST
(set-owner 'audio-desc nil)))))(register-node 'audio-desc-valid
#'(lambda ()(and is-ad-receiver-mix hdd-mode ad-enable (>= ad-pid 0)(eq trik-speed 100)))
#'(lambda ()(eval-events (list 'ad-valid-check 'audio-available)))
#'(lambda ()
t))(register-node 'audio-desc-play
#'(lambda ()
t)
#'(lambda ()(when (assoc (get-audio-pid 'audio) audio-choice-list)(unless (device-open-p 'video-for-ad)(setf video-for-ad-ch (search-video-for-ad-of-surfer))(video-config 'video-for-ad
:codec 'VIDEO_CODEC_NONE
:use "AD")(if video-for-ad-ch
(device-open 'video-for-ad (video-openquery :ch video-for-ad-ch))(device-open 'video-for-ad (video-openquery :error t))))(unless (device-open-p 'audio-desc)(my-device-open 'audio-desc (device-id 'video-for-ad)))(write-bytes msg-pipe SC_RES_AUDIO_DESC_PLAY 4 1)(audio-play 'audio-desc
:psi (if (or (eq (get-stream-type) 'STREAM_TTS_MODE)(eq (get-stream-type) 'STREAM_TS_MODE)) 'psi-in nil)
:pid ad-pid
:ad-main-ch (device-id 'audio)
:pcr (get-audio-pcr 'audio)))(eval-events (list 'ad-pid-update 'audio-result-update)))
#'(lambda ()(write-bytes msg-pipe SC_RES_AUDIO_DESC_PLAY 4 0)(audio-stop 'audio-desc)(my-device-close 'audio-desc)(device-close 'video-for-ad)))(register-node 'audio-desc-volume
#'(lambda ()
t)
#'(lambda ()(audio-volume 'audio-desc ad-vol)(eval-events (list 'ad-volume-change)))
#'(lambda ()))(register-node 'resource-lost
#'(lambda ()
t)
#'(lambda ()(stream-stop 'stream-in)(write-bytes msg-pipe SC_RES_RESOURCE_LOST 0))
#'(lambda ()
nil))(defun send-pmt-parsing (done)(unless (equal pmt-parsed done)(write-bytes msg-pipe SC_RES_PMT_PARSING 4 (if done 1 0))(setf pmt-parsed done)))(defun change-audio (id dualmode)(when audio-choice-list
(let ((track))(if (or (eq (get-stream-type) 'STREAM_TTS_MODE)(eq (get-stream-type) 'STREAM_TS_MODE))(progn
(setf select-dualmode dualmode)(setf req-dualmode dualmode)(setf track (find-if #'(lambda (x)(and (eq (get-track-pid x) id)(eq (get-track-audio-dualmode x) dualmode)))
audio-choice-list))(when (and (and (eq (get-audio-pid 'audio) id)(eq (get-audio-result 'audio) 'DECODE_SUCCESS))(dual-mono-p 'audio))(when (>= dualmode 0)(unless (eq dualmode 2)(send-dual-audio-choice-list (create-dual-audio-choice-list
'audio audio-choice-list)))(send-playing-audio (get-stream-type)(list (get-audio-pid 'audio)(audio-stream-info 'audio 'channel 'lfe)(if (>= dualmode 0)(audio-dualmode 'audio dualmode)
-1)(get-track-audio-lang (first audio-choice-list)))))))(setf track (assoc id audio-choice-list)))(when track
(if (or (and (get-audio-pid 'audio) (not (eq (get-audio-pid 'audio) id)))(and (get-audio-streamid 'audio) (not (eq (get-audio-streamid 'audio) id)))(and (eq (get-stream-type) 'STREAM_MKV_MODE) (not (eq req-audio id))))(progn
(temp-priority)(when (or dlna-mode net-mode)(setf trik-mode nil)(make-event 'trik-mode-off))(setf req-audio id)(case (get-stream-type)((STREAM_TTS_MODE STREAM_TS_MODE)(ad-stop)(set-trik-audio-pid (get-track-pid track))(set-trik-audio-format (get-track-stype track))(when hdd-mode
(set-audio-dmix-mode 'audio (decide-audio-dmix-mode (get-track-audio-format track))))(set-audio-pid 'audio (get-track-pid track))(setf last-audio track)(setf changed-audio-track track)(audio-dualmode 'audio dualmode)(ad-play (get-track-audio-adpid track)))(STREAM_DIVX_MODE
(clear-dualmode t)(set-audio-format 'audio (get-divx-audio-codec (nth 2 track)))(set-audio-streamid 'audio (nth 0 track))(make-event 'audio-update))(STREAM_MKV_MODE
(let ((atrack (assoc id mkv-atracks)))(clear-dualmode nil)(set-audio-format 'audio (get-mkv-audio-supported (nth 5 atrack)))(set-audio-pcr 'audio (get-stream-pcr-pid))(set-audio-pid 'audio (get-stream-audio-pid))(make-event 'audio-update)))))(unless (eq req-dualmode dualmode)(setf req-dualmode (audio-dualmode 'audio dualmode))))))))(defun change-subtitle (id)(when subtitle-choice-list
(let ((track))(setf track (assoc id subtitle-choice-list))(when (and (or (eq (get-stream-type) 'STREAM_DIVX_MODE)(eq (get-stream-type) 'STREAM_MKV_MODE))
track
(not (eq req-subtitle id)))(setf req-subtitle id)(make-event 'subtitle-change)))))(defvar src-audio-desc '(10 0))(defun content-fixed-local ()(setf event-id req-event-id))(defun connect-local (type)(set-video-hook 'video #'(lambda (sig)(when (eq sig 'LOST)(send-video-lost))))(append-t
'trik-play
'audio-desc-valid
'audio-desc-play
'audio-desc-volume)(append-nil
'player-resource
'resource-lost))(defun disconnect-local (type))(defun hdd-start (content okkake drm s-index s-pos e-index e-pos)(hdd-start-prepare content okkake drm)(setf chap-navi-mode nil)(setf play-mode "normal")(when (and s-index s-pos)(setf play-mode "resume")(setf req-stream-s-index s-index)(setf req-stream-s-pos s-pos))(setq req-stream-e-index e-index)(setq req-stream-e-pos e-pos)(setf req-event-id content)(setf trik-speed 100)(setf req-pause nil)(set-avsync-without-pcr (if (eq current-network 6)
t
nil))(make-event 'request-play))(defun hdd-chapter-skip (index pos)(hdd-start-prepare content-id play-retry-mode content-drm)(setq req-stream-s-index index)(setq req-stream-s-pos pos)(setf play-mode "resume")(if req-pause
(progn
(setf trik-speed 0)(setq pause-play t))(setf trik-speed 100))(make-event 'request-play))(defun hdd-chapter-start-with-pause (content okkake drm s-index s-pos seconds)(hdd-start-prepare content nil drm)(setq req-stream-s-index s-index)(setq req-stream-s-pos s-pos)(setq navi-mode nil)(setq chap-navi-mode t)(setq play-pause-mode t)(setq play-skip-pause-seconds seconds)(setf pause-play t)(setf req-event-id content)(setf play-mode "resume")(setf trik-speed (if seconds 100 101))(setq req-pause t)(audio-mute 'audio)(make-event 'request-play))(defun hdd-resume-start (content okkake drm)(hdd-start-prepare content okkake drm)(setf chap-navi-mode nil)(setf play-mode "resume")(setf trik-speed 100)(setf req-pause nil)(setf req-event-id content)(make-event 'request-play))(defun hdd-seek-start (content okkake drm seek)(hdd-start-prepare content okkake drm)(setf chap-navi-mode nil)(if seek
(progn
(setf play-mode "resume")(setf seek-time seek))(setf play-mode "normal"))(setf trik-speed 100)(setq req-pause nil)(setf req-event-id content)(make-event 'request-play))(defun hdd-next (content okkake drm)(unless (eq req-content-id content)(hdd-start-prepare content okkake drm)(if (> trik-speed 0)(setf play-mode "normal")(setf play-mode "reverse"))(setf req-pause nil)(setf req-event-id content)(make-event 'request-play)))(defun dlna-divx-start (uri index protocol dxst dlnadoc seek components attr new-event-id)(unless (eq req-event-id new-event-id)(stop)(setf notify-trick-cap t)(setf req-event-id new-event-id))(setf dxst-subtitle (if (or (not dxst) (string= "(null)" dxst) (eq (char dxst 0) 0)) nil dxst))(setf not-dlnadoc (not dlnadoc))(setf req-video (if (and (nth 0 components) (>= (nth 0 components) 0)) (nth 0 components) nil))(setf req-audio (if (and (nth 1 components) (>= (nth 1 components) 0)) (nth 1 components) nil))(setf req-dualmode (if (and (nth 2 components) (>= (nth 2 components) 0)) (nth 2 components) nil))(setf req-subtitle (if (and (nth 3 components) (>= (nth 3 components) 0)) (nth 3 components) nil))(setf content-drm (if seek (if (< seek 0) 'save 'load) nil))(setf content-size (nth 0 attr))(setf content-duration (nth 1 attr))(dlna-play-start-inner uri index protocol 100 (if (<= seek 0) nil seek)))(defun dlna-divx-next (uri index protocol dxst dlnadoc attr new-event-id)(unless (eq req-event-id new-event-id)(stop)(setf notify-trick-cap t)(setf req-event-id new-event-id))(setf notify-trick-cap t)(setf req-event-id new-event-id)(setf dxst-subtitle (if (or (not dxst) (string= "(null)" dxst) (eq (char dxst 0) 0)) nil dxst))(setf not-dlnadoc (not dlnadoc))(setf req-video nil)(setf req-audio nil)(setf req-dualmode nil)(setf req-subtitle nil)(setf content-size (nth 0 attr))(setf content-duration (nth 1 attr))(dlna-next-inner uri index protocol))(defun dlna-movie-start (uri index protocol dxst dlnadoc seek components attr new-event-id)(unless (movie-p)(movie-env))(dlna-divx-start uri index protocol dxst dlnadoc seek components attr new-event-id))(defun dlna-movie-next (uri index protocol dxst dlnadoc attr new-event-id)(unless (movie-p)(movie-env))(dlna-divx-next uri index protocol dxst dlnadoc attr new-event-id))(defun dlna-music-start (uri index protocol dlnadoc seek components attr loop new-event-id)(unless (music-p)(music-env))(dlna-divx-start uri index protocol nil dlnadoc seek components attr new-event-id))(defun dlna-music-next (uri index protocol dlnadoc attr new-event-id)(unless (music-p)(music-env))(dlna-divx-next uri index protocol nil dlnadoc attr new-event-id))(defun play-local ())(defun stop-local ()(send-video-choice-list nil nil)(send-audio-choice-list nil nil)(send-subtitle-choice-list nil nil 1)(send-playing-audio 'STREAM_PS_MODE nil)(when hdd-mode
(send-teletext-choice-list nil nil)))(defun dlna-start-local (speed seek))(defun dlna-is-stream-type-skip-enable ()(if (or (eq (get-stream-type) 'STREAM_TTS_MODE)(eq (get-stream-type) 'STREAM_TS_MODE)(eq (get-stream-type) 'STREAM_PS_MODE))
1
0))(defun set-preferred-audio (pref)(setf preferred-audio pref)(when is-nz
(set-preferred-common-lang audio-track-list subtitle-track-list)))(defun set-preferred-audio-type (pref)(setf preferred-audio-type pref)(when is-nz
(set-preferred-common-lang audio-track-list subtitle-track-list)))(defun set-preferred-audio-format (format)(if (or is-nordic is-hungary)(setf preferred-audio-format-list (case format
(4
(list
(list #x11 0)(list #x82 1)(list #x81 1)(list #x11 1)(list #x03 1)))(5
(list
(list #x11 1)(list #x03 1)(list #x11 0)(list #x82 1)(list #x81 1)))(2
(list
(list #x03 1)(list #x11 0)(list #x82 1)(list #x81 1)(list #x11 1)))(otherwise
nil)))(setf preferred-audio-format (case format
(0
(list #x81))(1
(list #x82))(2
(list #x03 #x04))(3
(list #x11))(otherwise
nil)))))(defun set-preferred-subtitle (pref)(setf preferred-subtitle pref)(when is-nz
(set-preferred-common-lang audio-track-list subtitle-track-list)))(defun audio-description-enable (t-or-nil)(setf ad-enable t-or-nil)(make-event 'ad-valid-check)(when is-ad-broadcast-mix
(send-audio-choice-list (get-stream-type) (create-audio-choice-list
'audio audio-track-list))))(defun audio-description-volume (vol)(setf ad-vol vol)(make-event 'ad-volume-change))(defun audio-description-sp (t-or-nil)(setf ad-speaker t-or-nil)(eval-copy-protection))(defun set-req-audio-pid (pid)(setf req-audio pid))(defun set-si-dccd-gene (gene)(setf si-dccd-gene gene)(when hdd-mode
(set-cp-opt-generation 'cp (get-play-cp-opticalout-generation))(set-cp-opt-category 'cp play-hdd-opt-category))(eval-copy-protection))(defun get-play-cp-opticalout-generation ()(let ((gene  (if (= pmt-dccd-gene -1)
si-dccd-gene
pmt-dccd-gene)))(when (= gene 2)(setf gene 3))
gene))(defun multi-play-hi-prio-mode (onoff)(when with-multi-play
(if (eq onoff 1)(progn
(my-device-priority 'video multi-play-hi-prio)(my-device-priority 'audio multi-play-hi-prio)(my-device-priority 'stream-in multi-play-hi-prio))(progn
(my-device-priority 'video (get-default-prio))(my-device-priority 'audio (get-default-prio))(my-device-priority 'stream-in (get-default-prio))))))(defvar video-for-ad-ch nil)(defun search-video-for-ad-of-surfer (lst)(let ((video-owner-list nil) (no 0))(setf video-for-ad-ch nil)(setf video-owner-list (video-get-owners 'video))(mapcar #'(lambda (owner)(when (string= owner "surfer")(setf video-for-ad-ch (+ no 1)))(setf no (1+ no))) video-owner-list))
video-for-ad-ch)
