PICTURES = 7;
FOG_LEVEL = 12;
FAR_LIMIT = 4900 - 256 * FOG_LEVEL;
PHOTO_FRAME = 40;
MOVE_SPEED = 5;
TIMER_INTERVAL = 50;
MOVE_SPEED_LOW_LOAD = 10;
TIMER_INTERVAL_LOW_LOAD = 100;

START_HEIGHT = 800;

var big_pic_obj = new Array ();
var big_pic_sub_obj = new Array ();
var big_pic_paper_obj = new Array ();
var big_pic_paper2_obj = new Array ();
var big_pic_shadow_obj = new Array ();

var big_pic_width = 960;
var big_pic_height = 640;

var f_photo_number = 0;
var f_last_load_photo_number = 0;
var floor_depth = 0;

rot_pic0 = new Array (-15, 10, 25, -30, 0, 10, -20); // rotate
rot_pic1 = new Array (-250, -1250, -200, -1000, -900, -50, -1450); //left,right
rot_pic2 = new Array (1250, 900, 1300, 1200, 900, 900, 900); // height

f_photo_number_buf = [-1,-1,-1,-1,-1,-1,-1];
var f_ptr_buf = new Array ();
var f_ptr_buf_size = new Array ();
var f_ptr_sub_buf = new Array ();
var f_ptr_sub_buf_size = new Array ();
var f_image_ready = new Array ();
var f_ptr_ready = new Array ();
var f_ptr_sub_ready = new Array ();

var photo_num_buf = new Array ();
var photo_mode_buf = new Array ();
var photo_p_num_buf = new Array ();
var photo_buf_read_num = 0;
var photo_buf_write_num = 0;
var reading = false;

flow_base = new gbox ({
    "translate":[0, 0, 10],
    "rotation": [0, 0, 0, 0],
    "width": 1920,
    "height": 1080,
    "color_enable": true,
    "color": [224, 240, 240, 255],
});

floor_obj = new gimage ({
    "translate":[0, 0, 0],
    "rotation": [0, 0, 0, 0],
    "src" : "file:///usr/local/png/flowframe_back.png",
    "width": 1920,
    "height":1080,
    "color_enable": true,
    "color": [255,255,255,255],
    "draw_type": DIRECT,
    "enable_dither": false,
});

var big_pic_y_pos = -2000;
for (var i=0; i<PICTURES; i++)
{
    big_pic_y_pos += rot_pic2[i];
    big_pic_paper2_obj[i] = new gbox ({
	"color": [255,255,255,255],
	"translate": [rot_pic1[i],big_pic_y_pos,0],
	"rotation": [rot_pic0[i], 0, 0, 1],
	"width": big_pic_width * 2,
	"height": big_pic_height * 2,
	"visible_p": false,
    });
    big_pic_paper_obj[i] = new gimage ({
	"color": [255,255,255,255],
	"translate": [rot_pic1[i],big_pic_y_pos,0],
	"rotation": [rot_pic0[i], 0, 0, 1],
	"src": "file:///usr/local/png/flowframe_fuchi.png",
	"width": big_pic_width * 2 + PHOTO_FRAME,
	"height": big_pic_height * 2 + PHOTO_FRAME,
	"enable_dither": true,
	"visible_p": false,
	"draw_type": DIRECT,
    });
    big_pic_obj[i] = new gimage ({
	"color": [255,255,255,255],
	"translate": [rot_pic1[i],big_pic_y_pos,0],
	"rotation": [rot_pic0[i], 0, 0, 1],
	"width": big_pic_width * 2,
	"height": big_pic_height * 2,
	"enable_dither": true,
	"visible_p": false,
	"enable_expmem": true,
	"draw_type": CIRCUMSCRIBED,
    });
    big_pic_sub_obj[i] = new gimage ({
	"color": [255,255,255,255],
	"translate": [rot_pic1[i],big_pic_y_pos,0],
	"rotation": [rot_pic0[i], 0, 0, 1],
	"width": big_pic_width * 2,
	"height": big_pic_height * 2,
	"enable_dither": true,
	"visible_p": false,
	"enable_expmem": true,
	"draw_type": CIRCUMSCRIBED,
    });
    big_pic_shadow_obj[i] = new gimage ({
	"color": [255,255,255,255],
	"translate": [rot_pic1[i] + 50 ,big_pic_y_pos - 50, -120],
	"rotation": [rot_pic0[i], 0, 0, 1],
	"src": "file:///usr/local/png/p_shadow.png",
	"width": big_pic_width * 2.2,
	"height": big_pic_height * 2.2,
	"enable_dither": true,
	"visible_p": false,
	"draw_type": INSCRIBED,
    });
}

var clear_flow_frame = function () {
    for (var i=0; i<PICTURES; i++)
    {
	if (f_ptr_sub_buf[i] != 0)
	{
	    big_pic_sub_obj[i].free_expmem (f_ptr_sub_buf[i]);
	    f_ptr_sub_buf[i] = 0;
	    f_ptr_sub_buf_size[i] = 0;
	}
	if (f_ptr_buf[i] != 0)
	{
	    big_pic_obj[i].free_expmem (f_ptr_buf[i]);
	    f_ptr_buf[i] = 0;
	    f_ptr_buf_size[i] = 0;
	}
	big_pic_paper_obj[i].src = "";
	big_pic_paper_obj[i] = 0;
	big_pic_paper2_obj[i] = 0;
	big_pic_obj[i] = 0;
	big_pic_sub_obj[i] = 0;
	big_pic_shadow_obj[i].src = "";
	big_pic_shadow_obj[i] = 0;
	f_ptr_buf[i] = 0;
	f_ptr_buf_size[i] = 0;
	f_ptr_ready[i] = 0;
	f_ptr_sub_ready[i] = 0;
    }
    big_pic_base2_obj = 0;
    big_pic_base_obj = 0;
    floor_obj.src = "";
    floor_obj = 0;
}

big_pic_base2_obj = 
    new container ({
	"translate": [0,0,-3400],
	"rotation": [-64, 1, 0, 0],
	"components":[ 
	    big_pic_shadow_obj[6],
	    big_pic_shadow_obj[5],
	    big_pic_shadow_obj[4],
	    big_pic_shadow_obj[3],
	    big_pic_shadow_obj[2],
	    big_pic_shadow_obj[1],
	    big_pic_shadow_obj[0],
	    big_pic_paper2_obj[6],
	    big_pic_obj[6],
	    big_pic_sub_obj[6],
	    big_pic_paper_obj[6],
	    big_pic_paper2_obj[5],
	    big_pic_obj[5],
	    big_pic_sub_obj[5],
	    big_pic_paper_obj[5],
	    big_pic_paper2_obj[4],
	    big_pic_obj[4],
	    big_pic_sub_obj[4],
	    big_pic_paper_obj[4],
	    big_pic_paper2_obj[3],
	    big_pic_obj[3],
	    big_pic_sub_obj[3],
	    big_pic_paper_obj[3],
	    big_pic_paper2_obj[2],
	    big_pic_obj[2],
	    big_pic_sub_obj[2],
	    big_pic_paper_obj[2],
	    big_pic_paper2_obj[1],
	    big_pic_obj[1],
	    big_pic_sub_obj[1],
	    big_pic_paper_obj[1],
	    big_pic_paper2_obj[0],
	    big_pic_obj[0],
	    big_pic_sub_obj[0],
	    big_pic_paper_obj[0],
	],
	"visible_p": true,
    });

big_pic_base_obj = 
    new container ({
	"translate": [800, 0, 0],
	"rotation": [15, 0, 1, 0],
	"components":[ 
	    big_pic_base2_obj,
	],
	"visible_p": true,
    });


var change_floor_depth = function ()
{
    floor_depth++;
    if(floor_depth > 30)
    {
	floor_depth = 0;
    }
    floor_obj.translate[1] = -floor_depth;
}

var flowframe_load_image = function (num, mode, num2){
    var p_num;

    if(num2 != -1)
    {
	if(f_image_ready[num2] == true)
	{
	    if (f_ptr_sub_buf[num2] != 0 && f_ptr_sub_ready[num2] == 0)
	    {
		f_ptr_sub_ready[num2] = 1;
		big_pic_sub_obj[num2].ready_expmem (f_ptr_sub_buf[num2]);
	    }
	}
	else
	{
	    if (f_ptr_buf[num2] != 0 && f_ptr_ready[num2] == 0)
	    {
		f_ptr_ready[num2] = 1;
		big_pic_obj[num2].ready_expmem (f_ptr_buf[num2]);
	    }
	}
	f_image_ready[num2] = true;
	write_back_bytes2 (33, [0]);
    }

    write_back_bytes2 (35,[0]);
    switch(mode)
    {
    case 0:
	if(photo_mode_buf[photo_buf_read_num] == 0)
	{
	    reading = false;
	    return;
	}
	num = photo_num_buf[photo_buf_read_num];
	mode = photo_mode_buf[photo_buf_read_num];
	p_num = photo_p_num_buf[photo_buf_read_num];
	photo_num_buf[photo_buf_read_num] = 0;
	photo_mode_buf[photo_buf_read_num] = 0;
	photo_p_num_buf[photo_buf_read_num] = 0;
	photo_buf_read_num++;
	if(photo_buf_read_num >= 10)
	{
	    photo_buf_read_num = 0;
	}
	break;
    case 1:
	if(reading)
	{
	    photo_mode_buf[photo_buf_write_num] = mode;
	    photo_num_buf[photo_buf_write_num] = num;
	    photo_buf_write_num++;
	    if(photo_buf_write_num >= 10)
	    {
		photo_buf_write_num = 0;
	    }
	    return;
	}
	break;
    case 2:
	if(reading)
	{
	    photo_mode_buf[photo_buf_write_num] = mode;
	    photo_num_buf[photo_buf_write_num] = num;
	    photo_p_num_buf[photo_buf_write_num] = f_photo_number_buf[num];
	    photo_buf_write_num++;
	    if(photo_buf_write_num >= 10)
	    {
		photo_buf_write_num = 0;
	    }
	    return;
	}
	p_num = f_photo_number_buf[num];
	break;
    }

    switch(mode)
    {
    case 0:
	break;
    case 1:
	reading = true;
	f_ptr = big_pic_obj[num].alloc_expmem (big_pic_width / 2, big_pic_height / 2, RGBA8888_BLOCK);
	f_ptr_buf[num] = f_ptr[0];
	f_ptr_buf_size[num] = f_ptr[1] * f_ptr[2] * 4;
	f_ptr_ready[num] = 0;
	f_image_ready[num] = false;
	write_back_bytes2 (30, [0]);
	write_back_bytes2 (10, [f_ptr[0], f_ptr[1], f_ptr[2], f_photo_number, num, f_ptr_buf_size[num]]);
	f_last_load_photo_number = f_photo_number;
	f_photo_number_buf[num] = f_photo_number;
	f_photo_number++; 
	//if(!slideshow_repeat && start_pos == f_photo_number) //loop all picture
	if(!slideshow_repeat && items == f_photo_number) //loop end is last picture
	{
	    loop_over = true;
	}
	if(f_photo_number >= items)
	{
	    f_photo_number = 0;
	}
	break;
    case 2:
	reading = true;
	f_ptr = big_pic_sub_obj[num].alloc_expmem (big_pic_width / 4, big_pic_height / 4, RGBA8888_BLOCK);
	f_ptr_sub_buf[num] = f_ptr[0];
	f_ptr_sub_buf_size[num] = f_ptr[1] * f_ptr[2] * 4;
	f_ptr_sub_ready[num] = 0;
	write_back_bytes2 (30, [0]);
	write_back_bytes2 (10, [f_ptr[0], f_ptr[1], f_ptr[2], p_num, num, f_ptr_sub_buf_size[num]]);
	break;
    }
}

var timer_hook3 = function (obj, count){
    for (var i=0; i<PICTURES; i++)
    {
	if (low_load_animation)
	{
	    big_pic_obj[i].translate[1] += MOVE_SPEED_LOW_LOAD;
	    big_pic_sub_obj[i].translate[1] += MOVE_SPEED_LOW_LOAD;
	    big_pic_paper_obj[i].translate[1] += MOVE_SPEED_LOW_LOAD;
	    big_pic_paper2_obj[i].translate[1] += MOVE_SPEED_LOW_LOAD;
	    big_pic_shadow_obj[i].translate[1] += MOVE_SPEED_LOW_LOAD;
	}
	else
	{
	    big_pic_obj[i].translate[1] += MOVE_SPEED;
	    big_pic_sub_obj[i].translate[1] += MOVE_SPEED;
	    big_pic_paper_obj[i].translate[1] += MOVE_SPEED;
	    big_pic_paper2_obj[i].translate[1] += MOVE_SPEED;
	    big_pic_shadow_obj[i].translate[1] += MOVE_SPEED;
	}
	
	if(big_pic_obj[i].translate[1] > FAR_LIMIT / 3 && f_photo_number_buf[i] >= 0)
	{
	    flowframe_load_image (i,2,-1);
	    f_photo_number_buf[i] = -1;
	}
	
	if(big_pic_obj[i].translate[1] > FAR_LIMIT)
	{
	    big_pic_obj[i].color[3] = 255 - parseInt((big_pic_obj[i].translate[1] - FAR_LIMIT) / FOG_LEVEL);
	    big_pic_sub_obj[i].color[3] = 255 - parseInt((big_pic_obj[i].translate[1] - FAR_LIMIT) / FOG_LEVEL);
	    big_pic_paper_obj[i].color[3] = 255 - parseInt((big_pic_obj[i].translate[1] - FAR_LIMIT) / FOG_LEVEL);
	    big_pic_paper2_obj[i].color[3] = 255 - parseInt((big_pic_obj[i].translate[1] - FAR_LIMIT) / FOG_LEVEL);
	    big_pic_shadow_obj[i].color[3] = 255 - parseInt((big_pic_obj[i].translate[1] - FAR_LIMIT) / FOG_LEVEL);
	    if (big_pic_obj[i].color[3] < 0)
	    {
		//read new picture
		if(loop_over)
		{
		    f_photo_number = items - 1;
		    flow_quit_func ();
		}
		if(f_ptr_buf[i] != 0)
		{
		    big_pic_obj[i].free_expmem(f_ptr_buf[i]);
		    f_ptr_buf[i] = 0;
		    f_ptr_buf_size[i] = 0;
		    f_ptr_ready[i] = 0;
		}
		if(f_ptr_sub_buf[i] != 0)
		{
		    big_pic_sub_obj[i].free_expmem(f_ptr_sub_buf[i]);
		    f_ptr_sub_buf[i] = 0;
		    f_ptr_sub_buf_size[i] = 0;
		    f_ptr_sub_ready[i] = 0;
		}
		flowframe_load_image (i,1,-1);		
		f_image_ready[i] = false;
		big_pic_obj[i].translate[1] = -2100;
		big_pic_sub_obj[i].translate[1] = -2100;
		big_pic_paper_obj[i].translate[1] = -2100;
		big_pic_paper2_obj[i].translate[1] = -2100;
		big_pic_shadow_obj[i].translate[1] = -2100 -50;
		
		big_pic_obj[i].translate[2] = START_HEIGHT;
		big_pic_sub_obj[i].translate[2] = START_HEIGHT;
		big_pic_paper_obj[i].translate[2] = START_HEIGHT;
		big_pic_paper2_obj[i].translate[2] = START_HEIGHT;
		
		big_pic_obj[i].color[3] = 255;
		big_pic_sub_obj[i].color[3] = 255;
		big_pic_paper_obj[i].color[3] = 255;
		big_pic_paper2_obj[i].color[3] = 255;
		big_pic_shadow_obj[i].color[3] = 255;
		big_pic_obj[i].visible_p = false;
		big_pic_sub_obj[i].visible_p = false;
		big_pic_paper_obj[i].visible_p = false;
		big_pic_paper2_obj[i].visible_p = false;
		big_pic_shadow_obj[i].visible_p = false;
		
		move_calendar ();
		change_floor_depth ();
		flow_set_last_focus ();
		write_back_bytes2 (32,[focus]);    
	    }
	}
	if (big_pic_obj[i].translate[2] > 0)
	{
	    big_pic_obj[i].translate[2] -= 10;
	    big_pic_sub_obj[i].translate[2] -= 10;
	    big_pic_paper_obj[i].translate[2] -= 10;
	    big_pic_paper2_obj[i].translate[2] -= 10;
	}
	if (big_pic_obj[i].translate[2] < 200 && f_image_ready[i] == true)
	{
	    big_pic_obj[i].visible_p = true;
	    big_pic_sub_obj[i].visible_p = true;
	    big_pic_paper_obj[i].visible_p = true;
	    big_pic_paper2_obj[i].visible_p = true;
	    big_pic_shadow_obj[i].visible_p = true;
	}
	force_redraw ();
    }
};

var flowframe_key = function (up_down, key) {
    if (up_down==KEY_PRESS) {
	if (frame_mode == false)
	{
	    return true;
	}
	if (key_invalid_flg)
	{
	    return true;
	}
	switch (key)
	{
	case TXK_STOP:
	    key = TXK_DOWN;
	    break;
	case TXK_FF:
	case TXK_SKIP_NEXT:
	    key = TXK_RIGHT;
	    break;
	case TXK_REW:
	case TXK_SKIP_PREV:
	    key = TXK_LEFT;
	    break;
	case TXK_PAUSE:
	    key = TXK_ENTER;
	    break;
	default:
	    break;
	}

	switch (key) {
	case TXK_RIGHT:
	    if(calendar_year != 0xff)
	    {
		calendar_month++;
		if(calendar_month == 13)
		{
		    calendar_month = 1;
		    calendar_year++;
		    if(calendar_year == 2100)
		    {
			calendar_year--;
			calendar_month = 12;
		    }
		}
		set_calendar(calendar_year,calendar_month);
		force_redraw ();
	    }
            break;
	case TXK_LEFT:
	    if(calendar_year != 0xff)
	    {
		calendar_month--;
		if(calendar_month == 0)
		{
		    calendar_month = 12;
		    calendar_year--;
		    if(calendar_year == 1899)
		    {
			calendar_year++;
			calendar_month = 1;
		    }
		}
		set_calendar(calendar_year,calendar_month);
		force_redraw ();
	    }
            break;
	case TXK_DOWN:
	    flow_quit_func ();
	    break;
	case TXK_UP:
            break;
	case TXK_ENTER:
	    flow_move_single ();
	    break;
	case TXK_RETURN:
	    flow_quit_func ();
            break;
	case TXK_BLUE:
            break;
	case TXK_RED:
            break;
	case TXK_YELLOW:
            break;
	case TXK_GREEN:
            break;
	case TXK_EXIT:
	    break;
	default:
            break;
	}
    }
};

function flowframe_appear_obj () {
    viv_mode = MODE_FLOWFRAME;

    photo_buf_read_num = 0;
    photo_buf_write_num = 0;
    for(var i = 0; i < 10; i++)
    {
	photo_mode_buf[i] = 0; 
	photo_num_buf[i] = 0; 
	photo_p_num_buf[i] = 0; 
    }
    for(var i = 0; i < PICTURES; i++)
    {
	f_image_ready[i] = false;
    }

    f_photo_number = focus;
    start_pos = focus;
    loop_over = false; 

    s.components[0] = flow_base;
    s.components[1] = floor_obj;
    s.components[2] = big_pic_base_obj;
    s.components[3] = calendar_base_obj;

    set_calendar_size (100);
    set_calendar_color (150);

    if(calendar_mode == false)
    {
	calendar_base_obj.translate[0] = -10000;
	big_pic_base_obj.translate[0] = 1600;
    }
    else
    {
	calendar_base_obj.translate[0] = 300;
	big_pic_base_obj.translate[0] = 800;
    }

    write_back_bytes2 (22,[MODE_FLOWFRAME]);

    //console.log("low_load_animation = "+low_load_animation);
    if (low_load_animation)
    {
    	append_timer (this, TIMER_INTERVAL_LOW_LOAD, timer_hook3);
    }
    else
    {
    	append_timer (this, TIMER_INTERVAL, timer_hook3);
    }
}

var flow_set_last_focus = function () {
    focus = f_last_load_photo_number;
}

var flow_quit_func = function () {
    frame_mode = false;
    single_mode = false;
    clear_flow_frame();
    clear_stage();
    delete_timer (this);
    write_back_bytes2 (28,[0]);
}
    
var flow_change_func = function () {
    frame_mode = false;
    single_mode = false;
    clear_flow_frame();
    clear_stage();
    delete_timer (this);
}

var flow_move_single = function () {
    hide_flag = true;
    delete_timer (this);
    flow_set_last_focus ();
    write_back_bytes2 (27,[focus]);
    clear_flow_frame();
    clear_stage();
}
