MAX_PICTURES = 7;
DISTANCE = 0;
PICTURE_WIDTH = 652;
PICTURE_HEIGHT = 480;
FILM_WIDTH = 672;
FILM_HEIGHT = 743;

TIMER_INT = 30;
ANIM_SPEED = 1;
TIMER_INT_LOW_LOAD = 100;
ANIM_SPEED_LOW_LOAD = 3;

var cinema_frame_obj = new Array ();
var cinema_picture_obj = new Array ();
var ptr_buf = new Array ();
var ptr_buf_size = new Array ();
var pct_buf = new Array ();
var ptr_ready = new Array ();
var cinema_y_pos = 0;
var p_count = 0;
var c_photo_number = 0;

cinema_frame_left_obj = new gimage ({
    "color": [255, 255, 255, 255],
    "translate": [1, 5, -6],
    "rotation": [0, 0, 0, 0],
    "src": "file:///usr/local/png/film_left.png",
    "width": FILM_WIDTH / 2,
    "height": FILM_HEIGHT,
    "visible_p": true,
    "enable_dither": true,
    "draw_type": INSCRIBED,
});

for (var j=0; j<MAX_PICTURES; j++)
{
    cinema_picture_obj[j] = new gimage ({
	"color": [255, 255, 255, 255],
	"translate": [504 + j * FILM_WIDTH - 15 - j, 8, 0],
	"rotation": [0, 0, 0, 0],
	"width": PICTURE_WIDTH,
	"height": PICTURE_HEIGHT,
	"visible_p": true,
	"enable_dither": true,
	"enable_expmem": true,
	//"draw_type": INSCRIBED,
	"draw_type": FULL,
    });
    cinema_frame_obj[j] = new gimage ({
	"translate": [504 + j * FILM_WIDTH - j, 0, 0],
	"rotation": [0, 0, 0, 0],
	"src": "file:///usr/local/png/film_center.png",
	"width": FILM_WIDTH,
	"height": FILM_HEIGHT,
	"visible_p": true,
	"enable_dither": true,
	"draw_type": INSCRIBED,
    });
}

cinema_frame_right_obj = new gimage ({
    "color": [255, 255, 255, 255],
    "translate": [(FILM_WIDTH / 4 + FILM_WIDTH / 2) * 2 + FILM_WIDTH * (MAX_PICTURES - 1) - MAX_PICTURES - 1, 5, -6],
    "rotation": [0, 0, 0, 0],
    "src": "file:///usr/local/png/film_right.png",
    "width": FILM_WIDTH / 2,
    "height": FILM_HEIGHT,
    "visible_p": true,
    "enable_dither": true,
    "draw_type": INSCRIBED,
});

cinema_bg_obj = new gbox ({
    "translate":[0, 0, 10],
    "rotation": [0, 0, 0, 0],
    "width": 1920,
    "height": 1080,
    "color_enable": true,
    "color": [34, 16, 17, 255],
});

cinema_base_obj = new container ({
    "translate": [-1500, 0, DISTANCE],
    "rotation": [0, 0, 0, 0],
    "components":[ 
	cinema_picture_obj[6],
	cinema_picture_obj[5],
	cinema_picture_obj[4],
	cinema_picture_obj[3],
	cinema_picture_obj[2],
	cinema_picture_obj[1],
	cinema_picture_obj[0],
	cinema_frame_obj[6],
	cinema_frame_obj[5],
	cinema_frame_obj[4],
	cinema_frame_obj[3],
	cinema_frame_obj[2],
	cinema_frame_obj[1],
	cinema_frame_obj[0],
	cinema_frame_left_obj,
	cinema_frame_right_obj,
    ],
    "visible_p": true,
});

var clear_cinema_frame = function() {
    for (var j=0; j<MAX_PICTURES; j++)
    {
	if (ptr_buf[j] != 0)
	{
	    cinema_picture_obj[j].free_expmem(ptr_buf[j]);
	    ptr_buf[j] = 0;
	    ptr_buf_size[j] = 0;
	    ptr_ready[j] = 0;
	}
	cinema_frame_obj[j].src = "";
	cinema_frame_obj[j] = 0;
	cinema_picture_obj[j] = 0;
	ptr_buf[j] = 0;
	ptr_buf_size[j] = 0;
	pct_buf[j] = 0;
	ptr_ready[j] = 0;
    }
    cinema_base_obj = 0;
    cinema_bg_obj = 0;
    cinema_frame_left_obj.src = "";
    cinema_frame_left_obj = 0;
    cinema_frame_right_obj.src = "";
    cinema_frame_right_obj = 0;
    p_count = -1;
}

var read_cinema_picture = function (num)
{
    if(num != -1)
    {
	if (ptr_buf[num] != 0 && ptr_ready[num] == 0)
	{
	    ptr_ready[num] = 1;
	    cinema_picture_obj[num].ready_expmem(ptr_buf[num]);
	}
    }
    if(p_count == -1)
    {
	write_back_bytes2 (33, [0]);
	return;
    }
    write_back_bytes2 (30, [0]);
    if(ptr_buf[p_count] != 0)
    {
	cinema_picture_obj[p_count].free_expmem(ptr_buf[p_count]);
    }
    ptr = cinema_picture_obj[p_count].alloc_expmem (PICTURE_WIDTH/2, PICTURE_HEIGHT/2, RGBA8888_BLOCK);
    write_back_bytes2 (10, [ptr[0], PICTURE_WIDTH/2, PICTURE_HEIGHT/2, c_photo_number, p_count, ptr[1] * ptr[2] * 4]);
    ptr_buf[p_count] = ptr[0];
    ptr_buf_size[p_count] = ptr[1] * ptr[2] * 4;
    ptr_ready[p_count] = 0;
    pct_buf[p_count] = c_photo_number;
    
    c_photo_number++;
    if(c_photo_number >= items)
    {
	c_photo_number = 0;
    }
    p_count++;
    if(p_count == MAX_PICTURES)
    {
 	p_count = -1;
    }
}

var create_cinema_frame = function (){
    top_picture_number = c_photo_number;
    p_count = 0;
    cinema_base_obj.translate[0] = 0;
    cinema_base_obj.translate[1] = cinema_y_pos;
    for(var i = 0; i < MAX_PICTURES; i++)
    {
	if(ptr_buf[i] != 0)
	{
	    cinema_picture_obj[i].free_expmem(ptr_buf[i]);
	    ptr_buf[i] = 0;
	    ptr_buf_size[i] = 0;
	    ptr_ready[i] = 0;
	}
    }
    read_cinema_picture(-1);
}

var timer_hook_cinema = 
    function (obj, count){
	if (low_load_animation)
	{
	    cinema_base_obj.translate[0] -= ANIM_SPEED_LOW_LOAD;
	}
	else
	{
	    cinema_base_obj.translate[0] -= ANIM_SPEED;
	}
	if(cinema_base_obj.translate[0] % FILM_WIDTH == 0)
	    {
		write_back_bytes2 (35,[0]);
	    }
	if((cinema_base_obj.translate[0] + 20) % FILM_WIDTH == 0)
	    {
		if(!slideshow_repeat && items == pct_buf[parseInt(-cinema_base_obj.translate[0] / FILM_WIDTH)] + 1)
		    {
			loop_over = true;
		    }
	    }
	force_redraw ();
	if(cinema_base_obj.translate[0] <= -4700)
	{
	    if(loop_over)
		{
		    c_photo_number = items - 1;
		    cinema_quit_func ();
		    return;
		}
	    cinema_y_pos -= 10;
	    if(cinema_y_pos < -180)
	    {
		cinema_y_pos = 180;
	    } 
	    create_cinema_frame();
	    delete_timer (obj);
	    if (low_load_animation)
	    {
		append_timer (this, TIMER_INT_LOW_LOAD, timer_hook_cinema);
	    }
	    else
	    {
		append_timer (this, TIMER_INT, timer_hook_cinema);
	    }
	}
	if (low_load_animation)
	{
	    if(count % (FILM_WIDTH / ANIM_SPEED_LOW_LOAD) == 0)
	    {
		cinema_set_last_focus ();
		write_back_bytes2 (32,[focus]);
	    }
	}
	else
	{
	    if(count % (FILM_WIDTH / ANIM_SPEED) == 0)
	    {
		cinema_set_last_focus ();
		write_back_bytes2 (32,[focus]);
	    }
	}
    }

function cinemaframe_appear_obj () {
    viv_mode = MODE_CINEMAFRAME;
    c_photo_number = focus;
    start_pos = focus;
    loop_over = false;

    for (var j=0; j<MAX_PICTURES; j++)
    {
	ptr_buf[j] = 0;
	ptr_buf_size[j] = 0;
	pct_buf[j] = 0;
	ptr_ready[j] = 0;
    }

    s.components[0] = cinema_bg_obj;
    s.components[1] = cinema_base_obj;

    write_back_bytes2 (22,[MODE_CINEMAFRAME]);

    create_cinema_frame();
    if (low_load_animation)
    {
	append_timer (this, TIMER_INT_LOW_LOAD, timer_hook_cinema);
    }
    else
    {
	append_timer (this, TIMER_INT, timer_hook_cinema);
    }
}

var cinema_key = function (up_down, key) {
    if (up_down != KEY_PRESS)
	return true;
    if (frame_mode == false)
    {
	return true;
    }
    if (key_invalid_flg)
    {
	return true;
    }

    switch (key)
    {
    case TXK_STOP:
	key = TXK_DOWN;
	break;
    case TXK_FF:
    case TXK_SKIP_NEXT:
	key = TXK_RIGHT;
	break;
    case TXK_REW:
    case TXK_SKIP_PREV:
	key = TXK_LEFT;
	break;
    case TXK_PAUSE:
	key = TXK_ENTER;
	break;
    default:
	break;
    }
    
    switch (key)
    {
    case TXK_RIGHT:
	break;
    case TXK_LEFT:
	break;
    case TXK_DOWN:
    	cinema_quit_func ();
	break;
    case TXK_UP:
	break;
    case TXK_ENTER:
	cinema_move_single ();
	break;
    case TXK_RETURN:
	cinema_quit_func ();
        break;
    }
};

var cinema_set_last_focus = function () {
    focus = top_picture_number +  parseInt((-(cinema_base_obj.translate[0] - 860)) / FILM_WIDTH);
    focus %= items;
    if(loop_over)
    {
	focus = items - 1;
    }
}

var cinema_quit_func = function () {
    cinema_set_last_focus ();
    write_back_bytes2 (32,[focus]);    
    p_count = -1;
    frame_mode = false;
    single_mode = false;
    clear_cinema_frame();
    clear_stage();
    delete_timer (this);
    write_back_bytes2 (28,[0]);
}

var cinema_change_func = function () {
    cinema_set_last_focus ();
    write_back_bytes2 (32,[focus]);    
    p_count = -1;
    frame_mode = false;
    single_mode = false;
    clear_cinema_frame();
    clear_stage();
    delete_timer (this);
}

var cinema_move_single = function () {
    hide_flag = true;
    delete_timer (this);
    cinema_set_last_focus ();
    write_back_bytes2 (27,[focus]);
    clear_cinema_frame();
    clear_stage();
}
