function set_effect_sound (num, uri)
{
  return system.effect_sound.set_sound (num, uri);
}

function play_effect_sound (num)
{
  return system.effect_sound.play (num);
}

set_effect_sound (0, "file:///usr/local/ajaxce/etc/07_12_02.aif");

var bSoundEnable = true;
function get_click_sound_status()
{
   return bSoundEnable;
}

function enable_click_sound()
{
   bSoundEnable = true; 
}

function disable_click_sound()
{
   bSoundEnable = false; 
}

function play_click_sound( num )
{
   if(typeof(num) != "number")
	  {
		 console.log("play_click_sound:bad arg");
		 num = 0;
	  }
   if(true == bSoundEnable)
	  play_effect_sound( num );
}

function default_system_key_hook (up_down, key)
{
  if (up_down != KEY_PRESS)
    return false;

  play_click_sound (0);

  switch (key) {
  case TXK_HOME:
    var home = get_system_home_stage ();
    if (home) {
      prepare_stage(home.symbol);
      on_stage (home.symbol);
    }
    return true;
  case TXK_EXIT:
    exit (0);
  }
  return false;
}

set_system_key_hook (default_system_key_hook);


/* ========== for StrongAuth ========== */

/** DEVELOPER is "Panasonic" */
var BAD_MSG = "Illegal Function!";

function getDeveloperId(){
  return "AI39si7jB9CE4nuJ3u1PT0-XJwSjZJ3WwJWV2YVHwZxmKvI-2U7gMDc0cQCw0Nc7GOxCLObL3NSnY9AkJ5wKU_0KUmo_7BFMKA";
}
getDeveloperId.toString=function(){ return BAD_MSG; }




var SHARED_KEY = new CipherKey("Do you believe in UniPhier ?");
var DEVELOPER_SECRET = new CipherKey(
  Cipher.dec_base64("uyHHAxsv/SWFb/GNkz9Suw==")
);


function getKeywordDeviceKey(){
  return "yt_device_key";
}
getKeywordDeviceKey.toString=function(){ return BAD_MSG; }


function getKeywordDeviceId(){
  return "yt_device_id";
}
getKeywordDeviceId.toString=function(){ return BAD_MSG; }




//===============

function doRegistStrongAuth(){
  var dev_key = null;
  var req = new Object();
  req.url = "https://vieracast.tv/strongauth";
  req.header = [["X-DeveloperId",getDeveloperId()]];
  req.method = "GET";
  req.sync = true;
  req.onload = function(status,header,body){
    if( status==200 ){
      console.log("(bserver)REGIST:OK");
      console.log("--- BODY\n"+body+"\n\n\n---");

      var val = eval( "("+ body +")" );
      nvram[0].write( getKeywordDeviceId(),  val.DeviceId );
      nvram[0].write( getKeywordDeviceKey(), val.DeviceKey );
      dev_key = val.DeviceKey;

    }else{
      console.log("[[doRegistStrongAuth]] ====== Failed to regist.("+status +")");
      console.log("  --- HEAD --- "+header);
      console.log("  --- BODY --- "+body);
      throw new Error("Cannot regist device at StrongAuth.");
    }
  };
  
  http_request( req );
  return dev_key;
}
doRegistStrongAuth.toString=function(){ return BAD_MSG; }



function getDeviceKeyBin(){
  var enc_64 = nvram[0].read( getKeywordDeviceKey() );
  if( enc_64 == null ){
    //  console.log("[getDeviceKeyBin]  "+ "Not registed...");
    enc_64 = doRegistStrongAuth();
  }else{
    //    console.log("[getDeviceKeyBin] already registed... ");
  }
  
  var enc_bin = Cipher.dec_base64( enc_64 );
  var bin = Cipher.dec_aes_128_ecb( DEVELOPER_SECRET, enc_bin );
  
  return  bin;
}
getDeviceKeyBin.toString=function(){ return BAD_MSG; }


function getStrongAuthHeader( url ){
  var seed = getRandomString(20);
  var hash = getRequestHash( seed+url );
  var key = Cipher.enc_base64( 
    Cipher.enc_aes_128_cbc_vc( SHARED_KEY, getDeviceKeyBin() )
  );
  
  key = Cipher.enc_base64(
    Cipher.enc_aes_128_cbc_vc(
      SHARED_KEY, 
      Cipher.enc_base64( getDeviceKeyBin() )
    )
  );
  

  var device = getDeviceId64();
  
  /* debug print : start */
  console.log("\n");
  console.log("X-Request-Hash: " + hash);
  console.log("X-Seed: " + seed );
  console.log("X-Key: " + key );
  console.log("X-Device-Id: " + device );
  /* debug print : end */
  
  return [
    [ "X-Request-Hash", hash ],
    [ "X-Seed", seed ],
    [ "X-Key", key ],
    [ "X-Device-Id", device ]
  ];
}
getStrongAuthHeader.toString=function(){ return BAD_MSG; }



function getRandomString( len ){
  var result="";
  for( var i=0, max=(Math.random()*(len-1))+1 ; i<max ; i++){
    result+=String.fromCharCode(Math.floor(Math.random()*25)+65);
  }
  return result;
}
getRandomString.toString=function(){ return BAD_MSG; }



function getRequestHash( str ){
  var hash = Cipher.enc_base64(
    Cipher.hmac( Cipher.SHA1, new CipherKey(getDeviceKeyBin()), str )
  );
  console.log("[getRequestHash] "+ hash);
  return hash;
}
getRequestHash.toString=function(){ return BAD_MSG; }



function getDeviceId64(){
  return nvram[0].read( getKeywordDeviceId() );
}
getDeviceId64.toString = function(){ return BAD_MSG; }



/* ========== for VIERA CAST Settings ========== */
function getKeywordLoginSetting( service ){
  return "setting_login_keyword_" + service;
}
getKeywordLoginSetting.toString = function(){ return BAD_MSG; }


function mytest(){
  console.log(">>>>>>>>> MY TEST <<<<<");
}