//
// Copyright (C) 2008 Panasonic Corporation. All Rights Reserved.
//

add_package_load_path ("pw_util",path + "picasa/pkg_pw_util.js");
add_package_load_path ("pw_popup", path + "picasa/pkg_pw_popup.js"); //Picasa Shortcut
add_package_load_path ("pw_scroll_class", path + "picasa/pkg_pw_scroll_class.js"); //Picasa Shortcut

add_stage_load_path ("pw_mainmenu", path + "picasa/pw_mainmenu.js");
add_stage_load_path ("pw_myphotos", path + "picasa/pw_myphotos.js");//shortcut



var yt = new Icon({});

yt.name = "picasa";
yt.isLeft = true;
yt.base_col       = [0, 153, 43, 255] ;
yt.username_color = [0, 255,  0, 255] ;
yt.TEXT = {
  "en-US":{
    ICON_TITLE: "Featured Photos",
    LOCKED: "Locked.",
  },
  "es-US":{
    ICON_TITLE: "Fotos en portada",
    LOCKED: "Bloqueado",
  },
  "fr-CA":{
    ICON_TITLE: "Photos sélectionnées",
    LOCKED: "Bloqué",
  },
  "en-GB":{
    ICON_TITLE: "Featured Photos",
    LOCKED: "Locked.",
  },
  "es-ES":{
    ICON_TITLE: "Fotos destacadas",
    LOCKED: "Bloqueado",
  },
  "fr-FR":{
    ICON_TITLE: "Sélection de photos",
    LOCKED: "Bloqué",
  },
  "de-DE":{
    ICON_TITLE: "Empfohlene Fotos",
    LOCKED: "Gesperrt",
  },
  "it-IT":{
    ICON_TITLE: "Foto in primo piano",
    LOCKED: "Bloccato.",
  },
  "en-IE":{
    ICON_TITLE: "Featured Photos",
    LOCKED: "Locked.",
  },
}
yt.lang = ureg.read("language");
if( !yt.TEXT[ yt.lang ]){
  if (ureg.read("market") == "EU") {
    yt.lang = "en-GB";
  } else {
    yt.lang = "en-US";
  }
  console.log("[PW] cannot read \"language\" " + ureg.read("language") + ". use default \"" + yt.lang + "\".");
}
add_package_load_path ("lang_picasa", path + "picasa/pkg_lang_picasa_" + yt.lang + ".js");

yt.display_name = "Picasa";

yt.HEIGHT_ROTATEGIMAGE = 142;
yt.SERVICE_NAME = "lh2";

// start GUI parts ///////////
yt.GUI = function(){ // [lines]
  var tmp = null;

  tmp = new gbox ({
    "width": 75,  "height": 3, "color": yt.base_col,
    "translate": [-100,0,0]});
  yt.components.push( tmp );

  tmp = new gbox ({
    "width": 3,  "height": 152, "color": yt.base_col,
    "translate": [-174,0,0]});
  yt.components.push( tmp );

}();


yt.GUI = function(Logo,Logo2,username,activity_text){// [main]
  yt.main = new actor ({
    "translate": [ 78, 0, 0 ],
    "base_col": [yt.base_col, yt.base_col],
    "bg_image": [
      new gbox ({ // #0 background
	"width": 286, "height": 286, "color":[0, 24, 48, 255] }),
      new gimage ({ "src": Logo, "translate":[0.0, 107.0, 0.0],
		    width:286,}),
      new gbox({ "width": 280, "height": yt.HEIGHT_ROTATEGIMAGE, // #2 Thumbnail base
		 "color": [0,0,0,255],  "translate": [0,-4,0],}),
      yt.thumb = new gimage ( {"translate":[0,-4,0], // #3
			       src:path+"picasa/thumb.jpg",
			       width:280, height:yt.HEIGHT_ROTATEGIMAGE, draw_type:CIRCUMSCRIBED }),
      new gtext ({  //#4 title
	"translate": [ 0, -93, 0 ],
	"width" : 280, height:36,
	"text" : activity_text,
	"font_size": 27,
	"margin": [0,0,8,0],
      }),
      yt.username = new gtext ({ // #5 username,
	"translate": [ 0, -123, 0 ],
	"width" : 280,
	"color" : yt.username_color,
	"text": username,
	"font_size": 25,
	"margin": [0,0,10,0]}),
      new gimage ({
	"src": Logo2,
	"translate": [116.0, -124.0, 0.0]}),
    ]
  });
  
  yt.components.push( yt.main );

}( path + "picasa/Picasa-Logo_322x83+1331+323.png",
   path + "picasa/Picasa-CameraIcon_35x25+1613+608.png",
   "Carol",
   yt.TEXT[yt.lang].ICON_TITLE  );
// param:(Logo,Logo2,username,activity_text)




yt.icon=[];
yt.GUI = function(){// [minis]
  for( var i=0 ; i<3 ; i++ ){
    yt.icon[i] = new actor ({
      "translate":[-174,103*(1-i),0],
      "base_col": [yt.base_col,yt.base_col],
      "bg_image": [
	new gbox ({
	  "width": 80,
	  "height": 80,
	  "color": [0, 0, 0, 255]}),
	new gimage ({
	  "src":   path + "common/not_found.png",
	  "width": 76,
	  "height": 76,
	  "draw_type": CIRCUMSCRIBED,
	})
      ]});
    yt.components.push( yt.icon[i] );
  }
}();


// end GUI parts ///////////




yt.lockPanel = null;
yt.getLockPanel = function(){
  if( this.lockPanel != null ){
    return this.lockPanel;
  }

  var p = new actor ({
    "base_col": [[0,153,43,255],[0,153,43,255]],
    "visible_p": false,
    "bg_image": [
      new gbox ({
	"width" : 440,
	"height": 292,
	"color": [10,64,0,255] ,
      }),
      new gimage ({
	"src":   path + "picasa/Picasa-Logo_322x83+1331+323.png",
	"translate": [0, 20, 0],
      }),
      new gtext ({
	"text": yt.TEXT[yt.lang].LOCKED, 
	"translate": [0, -80, 0],
	"color": [180, 180, 180, 255],
	"width" : 500,
	"font_size": 42,
	"font_name": "F015T-bold",
	"align" : CENTER, 
	}),
    ]});
  this.components.push( p );
  this.lockPanel = p;
  return p;
};

yt.lock = function(){
  this.setLock( true );
}
yt.unlock = function(){
  this.setLock( false );
}

yt.setDimension = function( w, h, d ){
  // @TODO : w & h
  if( this.isLock() == false ){
    if( (d==null) || (d>=yt.HEIGHT_ROTATEGIMAGE*2) ){
      this.thumb.visible_p = true;
    }else if( d < yt.HEIGHT_ROTATEGIMAGE * 2 ){
      this.thumb.visible_p = false;
    }
  }
}

yt.setLock = function( b ){
  var p = this.getLockPanel();
  p.visible_p = b;
  this.thumb.visible_p = !b;
}

yt.isLock = function(){
  return this.getLockPanel().visible_p;
}

yt.setTranslate = function(x,y,z){
  if( typeof x == "number" ){
    if( ((x<0)&&(this.isLeft==false)) ||
	((x>=0)&&(this.isLeft==true)) ){ // side switch
      for( var i=0 ; i<this.components.length ; i++ ){
	this.components[i].translate[0] *= -1;
      }
    }
    if( x < 0 ){
      this.isLeft = true;
    }else{
      this.isLeft = false;
    }
    this.translate[0] = x;
  }
  if( typeof y == "number" ){
    this.translate[1] = y;
  }
  if( typeof z == "number" ){
    this.translate[2] = z;
  }
}

yt.anim_num = 0;





yt.feed = new Object();
yt.feed.data = null;
yt.feed.http_req_id = -1;
yt.feed.country = "00";




yt.enter_focus = function(){
  prepare_stage( "pw_mainmenu" );
  prepare_package( "lang_picasa" );

  this.cursor = this.main;
  this.cursor.in_cursor = true;
  this.getLockPanel().in_cursor = true;
}
yt.leave_focus = function(){
  discard_stage( "pw_mainmenu" );
//  discard_stage( "lang_picasa" );

  this.cursor.in_cursor = false;
  this.cursor = this.main;
  this.getLockPanel().in_cursor = false;
}

yt.enter_stage = function(){
  this.init();
  this.thumb.visible_p = true;
}
yt.leave_stage = function(){
//  setf_text( this.username, "" );
  this.thumb.visible_p = false;
}

yt.key_hook = function( up_down, key ){
  if (up_down != KEY_PRESS)
    return true;

  switch( key ){
  case TXK_UP:
    switch( this.cursor ){
    case this.main:
    case this.icon[0]:
      return false;
      
    case this.icon[1]:
      this.changeCursor( this.icon[0] );
      return true;
      
    case this.icon[2]:
      this.changeCursor( this.icon[1] );
      return true;
    }
    console.log("@@@ ERROR @@@ : illegal this.cursor");
    return false;

  case TXK_DOWN:
    switch( this.cursor ){
    case this.main:
    case this.icon[2]:
      return false;
    case this.icon[0]:
      this.changeCursor( this.icon[1] );
      return true;
    case this.icon[1]:
      this.changeCursor( this.icon[2] );
      return true;
    }
    console.log("@@@ ERROR @@@ : illegal this.cursor");
    return false;

  case TXK_LEFT:
    if( this.isLeft ){
      switch( this.cursor ){
      case this.main:
	this.changeCursor( this.icon[1] );
	return true;
      case this.icon[0]:
      case this.icon[1]:
      case this.icon[2]:
	return false;
      }
    }else{
      switch( this.cursor ){
      case this.main:
	return false;
      case this.icon[0]:
      case this.icon[1]:
      case this.icon[2]:
	this.changeCursor( this.main );
	return true;
      }
    }
    console.log("@@@ ERROR @@@ : illegal this.cursor");
    return false;

  case TXK_RIGHT:
    this.isLeft = !this.isLeft;
    var ret = this.key_hook( up_down, TXK_LEFT );
    this.isLeft = !this.isLeft;
    return ret;

  case TXK_ENTER:
    switch( this.cursor ){
    case this.main:
      this.start();//T.B.D.
      break;
    case this.icon[0]:
    case this.icon[1]:
    case this.icon[2]:
      break;
    default:
      // Illegal
      return false;
    }
    return true;
  default:
    return false;
  }
  return false;
}

// [private]
yt.changeCursor = function( to ){
  this.cursor.in_cursor = false;
  this.cursor = to;
  this.cursor.in_cursor = true;
}


// [private]
yt.start = function(){
  on_stage( "pw_mainmenu" );
}



//// END
yt;

