//
// Copyright (C) 2008 Panasonic Corporation. All Rights Reserved.
//

// var dstart = new Date();
// var print_time = function(str) {
//   var d = new Date();
//   console.log((d - dstart)/1000 + " : " + str );
// }
// print_time("home_screen start");


var bplayer = new BroadcastPlayer ();
bplayer.connect (VideoDev, AudioDev);
set_screen_mode (PIP_EXVIDEO_MODE);

lang = 0; // 0:English , 1:Spanish, 2: French 
if (system.language.indexOf("en") == 0) {
  lang = 0;
} else if (system.language.indexOf("es") == 0) {
  lang = 1;
} else if (system.language.indexOf("fr") == 0) {
  lang = 2;
}

var TEXT = {
  "en-US":  "Demonstration",
  "es-US":  "Demostración",
  "fr-CA":  "Démonstration",
  "en-GB":  "Demonstration",
  "en-IE":  "Demonstration",
  "hu-HU" : "Bemutatás",
  "hr-HR" : "Demonstracija",
  "cs-CZ" : "Předvedení",
  "ru-RU" : "Демонстрация",
  "bg-BG" : "Демонстрация",
  "ro-RO" : "Demonstraţie ",
  "sk-SK" : "Ukážka",
  "sl-SL" : "Predstavitev",
  "pl-PL" : "Demonstracja",
  "sr-YU" : "Demonstracija",
  "de-DE" : "Demonstration",
  "es-ES" : "Demostración",
  "nl-NL" : "Demonstratie",
  "no-NO" : "Demonstrasjon",
  "fi-FI" : "Esittely",
  "fr-FR" : "Démonstration",
  "da-DK" : "Demonstration",
  "tr-TR" : "Tanıtım",
  "it-IT" : "Dimostrazione",
  "sv-SE" : "Demonstration",
  "pt-PT" : "Demonstração",
  "el-GR" : "Επίδειξη",
  "et-EE" : "Demonstratsioon",
  "lv-LV" : "Demonstrācija",
  "lt-LT" : "Demonstravimas",
};

var ajaxce_ureg_init = function()
{
  const MAXLEN = 256;
  var isString = function(obj){
    if(obj == null)
      return false;
    return (typeof(obj)=="string" || obj instanceof String);
  }

  var ureg = new Object();
  ureg.root = new Object();
  ureg.RegisterApp = function(AppName)
  {
    ureg.root[AppName] = new String("nodata");
  }
  ureg.read = function(AppName)
  {
    try {
      return ureg.root[AppName];
    } catch(e){
      return false;
    }
  }
  ureg.copy = function(AppName)
  {
    try {
      var ret =new String(ureg.root[AppName]);
      return ret;
    } catch(e){
      return false;
    }
  }
  ureg.write = function(AppName,string)
  {
    if(isString(string)==false){
      return false;
    }
    if(string.length > MAXLEN)
      return false;
    for(var p in ureg.root){
      if(p == AppName){
        return ureg.root[AppName] = new String(string);
      }
    }
  }
  return ureg;
}
ureg = ajaxce_ureg_init();


// Load language and market from system.

/**** Language : TENTATIVE ***/
var loadSystemLanguage = function(){
  ureg.RegisterApp("language");
  if( !system.locale ){// PZ850U ?
    ureg.write( "language", system.language.substr(0,5) );
  }else{ // '09 model (US or EU)
    if( system.locale.language == null ||
	system.locale.language == "" ){
      ureg.write( "language", "en-US" ); //default language
    }else{
      ureg.write( "language", system.locale.language.substr(0,5) );
    }
  }
  //console.log("[System Language] = "+ureg.read("language"));
  return ureg.read("language");
}();


/**** Country : TENTATIVE ***/
var loadSystemMarket = function(){
  ureg.RegisterApp("market");
  if( !system.locale ){                    // PZ850U ?
    ureg.write( "market", "US" );
  }else if( system.locale.country.indexOf("US") == 0 ){ // US model ?
    ureg.write( "market", "US" );
  }else if(system.locale.country == null ||
	   system.locale.country == ""){   // EU model ? (E_EU)
      ureg.write( "market", "EU" );
  }else{                                   // EU model ?
    ureg.write( "market", "EU" );
  }
  //console.log("[System Market] = "+ureg.read("market"));
  return ureg.read("market");
}();

/* URL switching */
if( ureg.read("market") == "US" ){
  MyHostName = "http://vieracast.tv/";
  MyHostNameS = "https://vieracast.tv/";
}else if( ureg.read("market") == "EU" ){
  MyHostName = "http://vieracast.eu/";
  MyHostNameS = "https://vieracast.eu/";
}else{
  console.log("[@ ERROR @] cannot judge market.");
  exit( 0 );
}


//path = MyHostName + "data/";
path = "file:///nv/demo/";
set_system_home_stage ("home_screen", path + "home-screen.js");


MSG_COLOR = [0x7f, 0x7f, 0x7f, 255];
MSG_DEMONSTRATION = TEXT[ ureg.read("language") ];
if( ! MSG_DEMONSTRATION ){
  console.log("[HS] cannot read \"language\" " + ureg.read("language") + ". use default \"" + "en-GB" + "\".");
  MSG_DEMONSTRATION = TEXT[ "en-GB" ];
}


///// Homescreen!
var home_screen = stage (
  {
    "symbol": "home_screen",
    "keep_me": true,
    "bg_translate": [0.0, 0.0, -3325.5],
    "in":
    [
      {
	"from": ["default"],
	"hook": function (obj) {
	  var prev_stage = ureg.read("stage_param");
	  switch (prev_stage.substring(0)) {
	  case "start_up":
	    complete_on_stage(obj);
	    ureg.write("stage_param","home_screen");
	    break;
	  case "home_screen":
	    obj.move_and_focus(obj, tv);
	    break;
	  case "youtube":
	    try{
	      system.screen.set_freq( system.screen.FREQ_NATIVE );
	      console.log("+++ Change Freq. ==> Native");
	    }catch(e){
	      console.log("--- Cannot change freq. (Native)");
	    }
	    // not break;
	  default:
	    obj.move_and_focus(obj);
	    break;
	  }
	},
      },
      {
	"from": ["disclaimer"],
	"hook": function(obj){
	  start_eval_timer();
	  complete_on_stage(obj);
	},
      },
    ],
    "out":
    [
      {
	"to": ["default"],
	"hook": function( obj ){
	  set_screen_mode (OSD_ONLY_MODE);
	  tv.visible_p = false;
	  bplayer.disconnect ();
	  stop_animation_timer();
	  leave_stage_all_icons();
	  ureg.write("stage_param", this.cursor.name);
	  anim.out_to.near( obj, 0 , complete_off_stage );
	},
      },
      {
	"to": ["disclaimer"],
	"hook":function(obj){
	  complete_off_stage(obj);
	},
      },
    ],
    "bg_image": [
      new gbox (
	{
	  "width": 11520,
	  "height": 6480,
	  "color": [1, 23, 46, 255]}),
      new gtext({
        "translate":[0, 480, 3323],
        "width":1800,
        "height":64,
        "color": MSG_COLOR,
        "text": "VIERA CAST - "+ MSG_DEMONSTRATION,
        "font_name": "F015T-bold",
        "align": CENTER,
      })
    ],
    "components": [ ],
    "key_hook": function (up_down, key) {
      if (up_down != KEY_PRESS)
	return true;
      return true;
    },
  });


//////////////// Create main components
var tv = new actor ({
  "base_col": [[102, 103, 103, 255], [57, 58, 58, 255]],
  "base_col_width": 12,
  "bg_image": [
    new videobox ({
      "width": 576,"height": 324,
      "overscan": true,
      "color": [255, 255, 255, 0]}),
  ],
  "action": function(){ exit(0); },
});
home_screen.components.push(tv);

// Preload HsBackGroundImage
var HsBackGroundImage =  new gimage (
  {
    "src": path + "homescreen_background.png",
    "width": 826 * 3, 
    "height": 826 * 3,
  });
home_screen.bg_image.push(HsBackGroundImage);




var plist = [   // Position list
  [-640,  360, 0],
  [   0,  360, 0],
  [ 640,  360, 0],
  [-640,   23, 0],
  [ 640,   23, 0],
  [-640, -320, 0],
  [   0, -360, 0],
  [ 640, -320, 0],
];

var ilist = []; // for key_move

var preeval = []; // pre-eval array
preeval.c = 0; // Icon counter

var lock_state_list = {};
var check_lock_state = function(icon) {
  var lock = null;

  if (icon.name == null)
    return;

  lock_state_list[icon.name] = false;

  switch (icon.name) {
  case "youtube":
    lock = nvram[0].read(getKeywordLoginSetting("YTLOCKSTATE"));
    if (lock) {
      icon.lock();
      lock_state_list[icon.name] = true;
    }
    break;
  case "picasa":
    lock = nvram[0].read(getKeywordLoginSetting("PWLOCKSTATE"));
    if (lock) {
      icon.lock();
      lock_state_list[icon.name] = true;
    }
    break;
  default:
    lock = nvram[0].read(getKeywordLoginSetting(icon.name.toUpperCase() + "LOCKSTATE"));
    if (lock) {
      icon.lock();
      lock_state_list[icon.name] = true;
    }
    break;
  }
}

var unlock_icons = function() {
  for (var i = 0; i < ilist.length; i++) {
    ilist[i].unlock();
    lock_state_list[ilist[i].name] = false;
  }
}

var init_icons = function() {
  for (var i = 0; i < ilist.length; i++) {
    append_timer(ilist[i], 1, function(obj, count) {
		   delete_timer(obj);
		   obj.init();
		   force_redraw();
		 });

  }
}

var set_dimension_of_all_icons = function(w, h, d) {
  for (var i = 0; i < ilist.length; i++) {
    ilist[i].setDimension(w, h, d);
  }
}

var enter_stage_all_icons = function(w, h, d) {
  for (var i = 0; i < ilist.length; i++) {
    ilist[i].enter_stage();
  }
}

var leave_stage_all_icons = function(w, h, d) {
  for (var i = 0; i < ilist.length; i++) {
    ilist[i].leave_stage();
  }
}


var eval_icon = function() {
  if (preeval.c < 8 && preeval.length != 0) {
    var icon = preeval.pop();
    var i = icon.pos;

    append_timer(icon, 1, function(obj, count) {
		   delete_timer(obj);
		   icon = eval(icon.body);
		   icon.setTranslate(plist[i][0], plist[i][1], plist[i][2]);
		   ilist[i] = icon;
		   check_lock_state(icon);
		   home_screen.components.push(icon);
		   preeval.c++;
		   force_redraw();
		 });
  } 
};

var start_eval_timer = function() {
  append_timer(preeval, 50, function(obj, count) {
		 delete_timer(obj);

		 eval_icon();

		 if (preeval.c >= 8) {
		   set_key_move();
		   map_color_key();
		   init_icons();
		   start_animation_timer();
		 } else { 
		   start_eval_timer();
		 }
	       });
};

var mycount = 1;
var start_animation_timer = function() {
  append_timer(tv, 100, function(obj, count) {
		 delete_timer(obj);
		 if (mycount == 30) {
		   wait_animation_timer();
		 } else {
		   for (var i = 0; i < ilist.length; i++) {
		     if (ilist[i].isReady()) {
		       ilist[i].animation(mycount);
		     }
		   }
		   mycount++;
		   force_redraw();
		   start_animation_timer();
		 }
	       });
};

var wait_animation_timer = function() {
  mycount = 1;
  append_timer(tv, 5000, function(obj, count) {
		 delete_timer(obj);
		 start_animation_timer();
	       });
};

var stop_animation_timer = function() {
  delete_timer(tv);
}


var retrieve_icon = function(service, i) {
  http_request({"url" : path + service + "/icon.js",
 		"method" : "GET",
 		"onload" : function(status, header, body) {
		  onloadfunc(status, header, body, i);
		},
 		"sync" : false,
 	       });
};

function onloadfunc(status, header, body, i) {
  var icon = new Object();
  if(status == 200) {
    icon.body = body;
    icon.pos = i;
    preeval.push(icon);
  } else {
    icon.body = "new Icon();";
    icon.pos = i;
    preeval.push(icon);
  }
}

var icon_list = null;
var store_icon_list = function(status, header, body) {
  if (status == 200) {
    try {
      icon_list = eval("("+body+")");
      for (var i = 0; i < icon_list.length; i++) {
	retrieve_icon(icon_list[i].name, i);
      }
    }catch(e){
      console.log("[ERROR] cannot eval icon: " + icon_list[i].name);
    }
  } else {
    console.log("[ERROR] status: " + status);
  }
};

var set_key_move = function() {
  home_screen.key_move = [
    [ilist[0], null,     ilist[3], null,     ilist[1]],
    [ilist[1], null,     tv,       ilist[0], ilist[2]],
    [ilist[2], null,     ilist[4], ilist[1], null    ],
    [ilist[3], ilist[0], ilist[5], null,     tv      ],
    [tv,       ilist[1], ilist[6], ilist[3], ilist[4]],
    [ilist[4], ilist[2], ilist[7], tv,       null    ],
    [ilist[5], ilist[3], null,     null,     ilist[6]],
    [ilist[6], tv,       null,     ilist[5], ilist[7]],
    [ilist[7], ilist[4], null,     ilist[6], null    ],
  ];
  
  home_screen.key_hook = key_hook;
  common_key.set_cursor(home_screen, tv);
}

var key_hook = function(up_down, key) {
  var ret = false;

  if (up_down != KEY_PRESS)
    return true;

  play_effect_sound(0);
  force_redraw();

  if (this.cursor instanceof Icon) {
    switch (key) {
    case TXK_ENTER:
      if (lock_state_list[this.cursor.name]) {
	set_dimension_of_all_icons(null, null, 0);
	appear_kb();
	return true;
      } // not break
    default:
      ret = this.cursor.key_hook( up_down, key );
      if (ret == true) {
	return true;
      }
      break;
    }
  }

  
  switch (key) {
  default:
    return common_key.old_way_emulate_hook2(home_screen, up_down, key);
  }
  
}

home_screen.move_and_focus = function(sobj, cobj) {
  complete_on_stage (sobj);

  anim.in_from.near( sobj, 0,
		     function (obj) {
		       if( cobj != null ){
		         common_key.set_cursor (home_screen, cobj);
		       }

		       append_timer (obj, 300,
				     function (obj, count) {
				       delete_timer (obj);
				       tv.visible_p = true;
				       force_redraw();
				       set_screen_mode (PIP_EXVIDEO_MODE);
				       bplayer.connect (VideoDev, AudioDev);
				       ureg.write("stage_param","home_screen");
				       enter_stage_all_icons();
				       wait_animation_timer();
				     });
		     });
}

home_screen.onStageFromHS = function( targetStageName ){
  if( !targetStageName ){
    return;
  }
  //ureg.write("stage_param", targetStageName);
  on_stage( targetStageName );
}


////////////////////////////////////////
// Stage Load Path
add_stage_load_path ("disclaimer", path + "disclaimer.js");

////////////////////////////////////////
// Package Load Path 
var tmp_lang = ureg.read("language").substr(0,5);
switch(tmp_lang) {
case "en-US":
case "es-US":
case "fr-CA":
case "en-GB":
case "es-ES":
case "fr-FR":
case "de-DE":
case "it-IT":
case "en-IE":
  break;
default:
  if (ureg.read("market") == "EU") {
    tmp_lang = "en-GB";
  } else {
    tmp_lang = "en-US";
  }
  break;
}

add_package_load_path ("lang_common", path + "lib/pkg_lang_common_" + tmp_lang + ".js");
add_package_load_path ("lang_disclaimer", path + "lib/pkg_lang_disclaimer_" + tmp_lang + ".js");

add_package_load_path ("common_popup", path + "lib/pkg_common_popup.js");
add_package_load_path ("common_animation", path + "lib/pkg_common_animation.js");
add_package_load_path ("common_menu",path + "lib/pkg_common_menu.js");
add_package_load_path ("pkg_common_keyboard", path +  "lib/pkg_common_keyboard.js");
add_package_load_path ("pkg_common_feed", path + "lib/pkg_common_feed.js");
add_package_load_path ("pkg_common_teleinput",path +  "lib/pkg_common_teleinput.js");
add_package_load_path ("msgbox", path + "lib/pkg_msgbox.js");
add_package_load_path ("pkg_common_listbox",path +  "lib/pkg_common_listbox.js");
add_package_load_path ("common_key", path +   "lib/pkg_common_key.js");
add_package_load_path ("login_dialog",path +  "lib/pkg_login_dialog.js");


//////////////// Main

ureg.RegisterApp("stage_param");
ureg.write("stage_param","start_up");

var loadIconList = function(){
  var icon_list = "";
  if (ureg.read("market") == "US") {
    icon_list = path + "config/icon-list-us.json";
  } else { // PAL
    switch( system.locale.country ){
    case "DE":
    case "AT":
    case "FR":
    case "IT":
    case "ES":
    case "PT":
    case "NL":
    case "DK":
    case "SE":
    case "NO":
    case "FI":
    case "BE":
    case "CH":
    case "GR":
    case "PL":
    case "CZ":
    case "HU":
    case "EEU":
    case "UK":
    case "IE":
    case "SK":
    case "HR":
    case "SI":
    case "EE":
    case "LT":
      icon_list = path + "config/icon-list-eu.json";
      break;
    default: // "AU", "NZ", ...
      icon_list = path + "config/icon-list-global.json";
    }
  }
  http_request({"url" : icon_list,
               "method" : "GET",
               "onload" : store_icon_list,
               "sync": false,
              });
}();

var disclaimer_flag = null;
var disclaimer_ret = null;
append_timer(home_screen, 5, function(obj, count) {
	       delete_timer(obj);
	       disclaimer_ret = nvram[0].read("disclaimer");
               disclaimer_flag = true; // For DEMO foce TRUE
               //disclaimer_flag = eval( "(" + disclaimer_ret + ")" );
	       if (disclaimer_flag == true) {
		 start_eval_timer();
	       } else {
		 try {
		   home_screen.onStageFromHS("disclaimer");
		 } catch (e) {
		   console.log(e.toString());
		 }
	       }
	     });


/* common_key */
common_key = {};

common_key.set_cursor = function(sobj, cobj)
{
  var old = sobj.cursor;
  if (old == cobj)
    return;
  if (old) {
    if (old.leave_focus)
      old.leave_focus (old);
    old.in_cursor = false;
    old.toggle_cursor = false;
  }
  if (cobj) {
    if (cobj.enter_focus)
      cobj.enter_focus (cobj);
    cobj.in_cursor = true;
  }
  sobj.cursor = cobj;
}

common_key.find_key_move = function(stg, cobj)
{
  var key_array = stg.key_move;
  
  if (!key_array)
    return null;
  for (var i = 0; i < key_array.length; i++) {
    if (key_array[i][0] == cobj){
      return key_array[i];}
  }
  return null;
}

common_key.key_action_actor = function(aobj)
{
  if (aobj.action){
    aobj.action (aobj);
  }else {
    append_timer (aobj, 250,
		  function (obj, count) {
		    if (count >= 4){
		      delete_timer (obj);
		      obj.toggle_cursor = false;
		    } else {
		      obj.toggle_cursor = !obj.toggle_cursor;
		    }
		    force_redraw ();
		  });
    aobj.toggle_cursor = true;
  }
}

common_key.key_action_stage = function(sobj, n)
{
  var cobj = sobj.cursor;
  if (n > 4 || !cobj)
    return;
  if (n == 4)
    common_key.key_action_actor (cobj, n);
  else {
    while (1) {
      var next;
      var key_move = common_key.find_key_move (sobj, cobj);
      if (!key_move)
	break;
      next = key_move [n+1];
      if (!next)
	break;
      if (!next.visible_p) {
	cobj = next;
	continue;
      }
      common_key.set_cursor (sobj, next);
      break;
    }
  }
}

common_key.old_way_emulate_hook = function( up_down, key){
  return common_key.old_way_emulate_hook2( this, up_down, key );
}

common_key.old_way_emulate_hook2 = function(stg, up_down, key)
{  
  if (up_down != KEY_PRESS)
    return false;

  switch (key) {
  case TXK_UP:
    common_key.key_action_stage (stg, 0);
    break;
  case TXK_DOWN:
    common_key.key_action_stage (stg, 1);
    break;
  case TXK_LEFT:
    common_key.key_action_stage (stg, 2);
    break;
  case TXK_RIGHT:
    common_key.key_action_stage (stg, 3);
    break;
  case TXK_ENTER:
    common_key.key_action_stage (stg, 4);
    break;
  case TXK_RED:
  case TXK_GREEN:
  case TXK_BLUE:
  case TXK_YELLOW:
  case TXK_D1:
  case TXK_D2:
  case TXK_D3:
  case TXK_D4:
  case TXK_D5:
  case TXK_D6:
  case TXK_D7:
  case TXK_D8:
  case TXK_D9:
  case TXK_D0:
  case TXK_ASTERISK:
  case TXK_SHARP:
    break;
  default:
    return false;
    break;
  }
  force_redraw ();
  return false;
}
///* End of Common_key */



/**** New Animation Function ****/
anim = {}; // Global
anim.simple = function (obj, src, dst, interval, total, comp_hook, redraw_flag) {
  return this.move (obj, src, dst, interval, total, 0, 0, redraw_flag, comp_hook);
};

anim.in_from = {
  "near":   function (gObj, wait, hook) {
    return anim.move (gObj, [0, 0, 900], [0, 0, 0], 40, 12, wait, 0, true, hook);
  },
  "far_left": function (gObj, wait, hook) {
    return anim.move (gObj, [-2000, 0, -4000], [0, 0, 0], 40, 12, wait, 0, true, hook);
  },
  "far_right": function (gObj, wait, hook) {
    return anim.move (gObj, [+2000, 0, -4000], [0, 0, 0], 40, 12, wait, 0, true, hook);
  },
  "left":   function (gObj, wait, hook) {
    return anim.move (gObj, [-2000, 0, 0], [0, 0, 0], 40, 12, wait, 0, true, hook);
  },
  "right":  function (gObj, wait, hook) {
    return anim.move (gObj, [+2000, 0, 0], [0, 0, 0], 40, 12, wait, 0, true, hook);
  }
};

anim.out_to = {
  "near":   function (gObj, wait, hook) {
    return anim.move (gObj, [0, 0, 0], [0, 0, 900], 40, 12, wait, 0, false, hook);
  },
  "far_left": function (gObj, wait, hook) {
    return anim.move (gObj, [0, 0, 0], [-2000, 0, -4000], 40, 12, wait, 0, false, hook);
  },
  "far_right": function (gObj, wait, hook) {
    return anim.move (gObj, [0, 0, 0], [+2000, 0, -4000], 40, 12, wait, 0, false, hook);
  },
  "left":   function (gObj, wait, hook) {
    return anim.move (gObj, [0, 0, 0], [-2000, 0, 0], 40, 12, wait, 0, false, hook);
  },
  "right":  function (gObj, wait, hook) {
    return anim.move (gObj, [0, 0, 0], [+2000, 0, 0], 40, 12, wait, 0, false, hook);
  }
};

anim.move = function(gObj, src, dst, interval, total, before, after, redraw_flag, comp_hook) {
  var ret = function(){
    var period = total - before - after;
    var delta0 = (dst[0] - src[0]) / period;
    var delta1 = (dst[1] - src[1]) / period;
    var delta2 = (dst[2] - src[2]) / period;
    var onload = function (gObj, count) {
      if (count >= total) {
	delete_timer (gObj);
	gObj.translate = dst;
	if (comp_hook){
	  append_timer( gObj, 5, function(obj,count){
	    delete_timer( obj );
	    comp_hook ( obj );
	    force_redraw();
	  });
	}
	force_redraw();
      } else if (count >= before && count < total - after ) {
	gObj.translate[0] += delta0;
	gObj.translate[1] += delta1;
	gObj.translate[2] += delta2;
	if (redraw_flag)
	  force_redraw();
      }
    };    
    gObj.translate = src;
    delete_timer (gObj);
    append_timer (gObj, interval, onload);
  }();

  return true;
};
/**** End of New Animation ***/


/* == RotateGimage == */
var RotateGimage = function( init ,width ,height, draw_type ){
  this.base = container; // inherit
  init.components = [ ];
  init.translate[1] += height/2;
  this.base( init );
  
  this.images = [
    new container({
      rotation: [0,1,0,0],
      components:[
	new gimage({
	  translate: [0,-height/2,0],
	  src: null,  width: width,  height: height,
	}),
      ]}),
    new container({
      rotation: [ 270, 1, 0, 0 ],
      components:[
	new gimage({
	  translate: [0, -height/2, 0],
	  src: null,  width: width,  height: height,
	}),
      ]}),
  ];
  
  if( draw_type != null ){
    this.images[0].components[0].draw_type = draw_type;
    this.images[1].components[0].draw_type = draw_type;
  }
  this.components = this.images;
}

// public
//   * String url  : URL for the new image file
RotateGimage.prototype.setImage = function( url ){
  this.changePosition();

  this.images[1].rotation[0]=270;
  this.images[1].components[0].src = url;
  this.images[1].visible_p = true;
}

// public
RotateGimage.prototype.clearImage = function(){
  this.images[0].components[0].src = "";
  this.images[1].components[0].src = "";
  this.images[0].visible_p = false;
}

// private
RotateGimage.prototype.changePosition = function(){
  this.images[0].visible_p = false;
  this.images.reverse();
  this.images[0].rotation[0]=0;
  this.images[1].rotation[0]=270;
}

// [New] public
RotateGimage.prototype.animation = function( count ){
  if( count == 0 ){
    this.images[1].rotation[0] = 0; // reset position (not called by homescreen)
  }else if (count<5 ){
    this.images[1].rotation[0] = 270; // start position
  }else if(count>13){
    this.images[1].rotation[0] = 0; // end position
  }else{// 5-13 ( 9 counts )
    this.images[1].rotation[0] = 270 + 10*(count-4);
  }
}



// Constructor method
function Icon () {
  this.superClass = container;
  this.superClass({});
}
// Super Class
Icon.prototype = new container({});

Icon.prototype.name = null;
Icon.prototype.display_name = null;

Icon.prototype.lock = function(){
  return false;
}
Icon.prototype.unlock = function(){
  return false;
}
Icon.prototype.init = function(){
  if( this.components.length==0 && this.name == null ){
    var a = new actor({
      "base_col_width":0,
      "bg_image":[ new gimage({ "src": path + "common/not_found.png",}), ]
    });
    this.components.push( a );
  }
}
Icon.prototype.isReady = function(){
  return true;
}
Icon.prototype.animation = function( count ){}
Icon.prototype.key_hook = function( up_down, key ){
  return false;
}
Icon.prototype.enter_focus = function(){
  var a = this.components[0];
  if( a instanceof actor ){
    a.in_cursor = true;
  }
}
Icon.prototype.leave_focus = function(){
  var a = this.components[0];
  if( a instanceof actor ){
    a.in_cursor = false;
  }
}
Icon.prototype.setVisible = function( b ){
  this.visible_p = b;
}
Icon.prototype.setTranslate = function(x,y,z){

  if( typeof x == "number" ){
    this.translate[0] = x;
  }
  if( typeof y == "number" ){
    this.translate[1] = y;
  }
  if( typeof z == "number" ){
    this.translate[2] = z;
  }
}
Icon.prototype.setRotation = function( angle, vx, vy, vz ){

  if( typeof angle == "number" ){
    this.rotation[0] = angle;
  }
  if( typeof vx == "number" ){
    this.rotation[1] = vx;
  }
  if( typeof vy == "number" ){
    this.rotation[2] = vy;
  }
  if( typeof vz == "number" ){
    this.rotation[3] = vz;
  }
}
Icon.prototype.setDimension = function ( w, h, d ){}
Icon.prototype.enter_stage = function (){}
Icon.prototype.leave_stage = function (){}



/////////////////
// LOCK

var unLockKB = null;
var lock_pass = null;
var popup = null;
var home_keyboard = null;
var kb_ok = null;
var kb_cancel = null;
var org_keyhook = null;
var org_keymove = null;
var org_cursor = null;

var appear_kb = function() {
  
  try {
    stop_animation_timer();

    require ("pkg_common_feed");
    lock_pass = pkg_common_feed.get_LockPassword();


    set_screen_mode (OSD_ONLY_MODE);
    bplayer.disconnect ();
    org_keyhook = home_screen.key_hook;
    org_keymove = home_screen.key_move;
    org_cursor = home_screen.cursor;
    if (unLockKB == null) {
      Make_Keyboard ();
    }

    popup.visible_p = true;
    common_popup.create_animation (popup);
    common_key.set_cursor (home_screen, unLockKB.components[0]);

    home_screen.key_hook = function (up_down, key) {
      if ((key == TXK_RETURN) && (up_down == KEY_PRESS)) {
	common_popup.delete_animation (popup, kb_hook_func);
	return true;
      } else if (this.cursor == home_keyboard) {
	if (home_keyboard.keyhook (up_down, key) == true)
	  return true;
      }
      return common_key.old_way_emulate_hook2 (this, up_down, key);
    }

    home_screen.key_move = [
      [home_keyboard, null,          kb_ok, null,  null],
      [kb_ok,         home_keyboard, null,  null,  kb_cancel],
      [kb_cancel,     home_keyboard, null,  kb_ok, null],
    ];
  } catch (e) {
    console.log("CATCH Exception> " + e);
  }
}

var Make_Keyboard = function () {
  require ("lang_common");
  require ("pkg_common_keyboard");

  var kbText = lang_common.GetMessageText();

  if (ureg.read("market") == "US") {
    home_keyboard = new pkg_common_keyboard.Keyboard ();
  } else {
    home_keyboard = new pkg_common_keyboard.Keyboard ("en");
  }

  home_keyboard.translate = [0, 30, 0];
  home_keyboard.set_keyboard (0);
  home_keyboard.setMode ("PASSWD");

  unLockKB = new container ({
    "components": [
      home_keyboard,

      new gbox (
	{
	  "translate": [0.0, 270.0, 0.0],
	  "width":  600,
	  "height":  50,
	  "color": [128, 128, 128, 128],
	}),
      new gtext (
	{
	  "translate": [0.0, 270.0, 0.0],
	  "width": 1000,
	  "text" : kbText.ENTER_PASSWD,
	  "font_name": "F015T-regular",
	  "align": CENTER,
	  "font_size": 35,
	}),
      kb_ok = new actor (
	{
	  "translate": [-120.0, -320.0, 0.0],
	  "base_col": [[150, 150, 150, 255], [100, 100, 100, 255]],
	  "bg_image": [
	    new gbox (
	      {
		"width": 200,
		"height": 50,
		"color": [56, 56, 56, 255],
	      }),
	  new gtext (
	    {
	      "width": 200,
	      "height": 50,
	      "text"     : kbText.DONE,
	      "font_name": "F015T-bold",
	      "align": CENTER,
	      "font_size": 30,
	    }),
	  ],
	  "action": function () {
	    var inp_pass = home_keyboard.getText ();
	    home_keyboard.setText ("");

	    if (lock_pass == inp_pass) {
	      common_popup.delete_animation (popup, function() {
					       kb_hook_func();
					       unlock_icons();
					     });
	      return;
	    } else {
	      common_key.set_cursor (home_screen,home_keyboard);
	      return;
	    }
	  },
	}),

      kb_cancel = new actor (
	{
	  "translate": [120.0, -320.0, 0.0],
	  "base_col": [[150, 150, 150, 255], [100, 100, 100, 255]],
	  "bg_image": [
	    new gbox (
	      {
		"width": 200,
		"height": 50,
		"color": [56, 56, 56, 255],
	      }),
	    new gtext (
	      {
		"width": 200,
		"height": 50,
		"text": kbText.CANCEL,
		"font_name": "F015T-bold",
		"align": CENTER,
		"font_size": 30,
	      }),
	  ],
	  "action": function () {
	    common_popup.delete_animation (popup, kb_hook_func);

	  },
	}),
    ],
			    });

  require ("common_popup");
  unLockKB.visible_p = false;
  popup = common_popup.make_popup (700, 800, [0,0,0], unLockKB);
  home_screen.components.push (popup);
}

var kb_hook_func = function() {
  set_screen_mode (PIP_EXVIDEO_MODE);
  bplayer.connect (VideoDev, AudioDev);
  home_screen.key_move = org_keymove;
  home_screen.key_hook = org_keyhook;
  common_key.set_cursor (home_screen, org_cursor);
  play_effect_sound (0);
  set_dimension_of_all_icons(null, null, null);
  start_animation_timer();
}



//// COLOR_KEY

var get_keyid = function(key_code) {
  switch (key_code) {
  case TXK_RED:
    return "TXK_RED";
    break;
  case TXK_GREEN:
    return "TXK_GREEN";
    break;
  case TXK_BLUE:
    return "TXK_BLUE";
    break;
  case TXK_YELLOW:
    return "TXK_YELLOW";
    break;
  default:
    break;
  }
};

var map_color_key = function() {
  const RED    = [192,   0,   0, 255]; // RED
  const GREEN  = [  0, 128,  32, 255]; // GREEN
  const BLUE   = [  0,   0, 192, 255]; // BLUE
  const YELLOW = [192, 192,   0, 255]; // YELLOW

  var timer = {};
  append_timer(timer, 1, function(obj, count) {
		 delete_timer(obj);
		 timer = null;
		 var COLOR_KEY_TYPE = {
		   "US_TYPE" : [
		     {
		       "COLOR": RED,
		       "KEY_CODE": TXK_RED,
		     },
		     {
		       "COLOR": GREEN,
		       "KEY_CODE": TXK_GREEN,
		     },
		     {
		       "COLOR": BLUE,
		       "KEY_CODE": TXK_BLUE,
		     },
		     {
		       "COLOR": YELLOW,
		       "KEY_CODE": TXK_YELLOW,
		     },
		   ],
		   "PAL_TYPE" : [
		     {
		       "COLOR": RED,
		       "KEY_CODE": TXK_RED,
		     },
		     {
		       "COLOR": GREEN,
		       "KEY_CODE": TXK_GREEN,
		     },
		     {
		       "COLOR": YELLOW,
		       "KEY_CODE": TXK_YELLOW,
		     },
		     {
		       "COLOR": BLUE,
		       "KEY_CODE": TXK_BLUE,
		     },
		   ],
		   "JP_TYPE" : [ // dummy
		     {
		       "COLOR": BLUE,
		       "KEY_CODE": TXK_BLUE,
		     },
		     {
		       "COLOR": RED,
		       "KEY_CODE": TXK_RED,
		     },
		     {
		       "COLOR": GREEN,
		       "KEY_CODE": TXK_GREEN,
		     },
		     {
		       "COLOR": YELLOW,
		       "KEY_CODE": TXK_YELLOW,
		     },
		   ],

		 };

		 switch(ureg.read("market").toString()) {
		 case "US":
		   console.log("Color key type: US_TYPE");
		   COLOR_KEY = COLOR_KEY_TYPE[ "US_TYPE" ];
		   break;
		 case "EU":
		   console.log("Color key type: PAL_TYPE");
		   COLOR_KEY = COLOR_KEY_TYPE[ "PAL_TYPE" ];
		   break;
		 default:
		   console.log("Unable to judge type of COLOR_KEY.");
		   COLOR_KEY = COLOR_KEY_TYPE[ "JP_TYPE" ];
		   break;
		 }

		 for (var i = 0; i < COLOR_KEY.length; i++) {
		   console.log("COLOR_KEY[" + i + "] = " + get_keyid(COLOR_KEY[i].KEY_CODE));
		 }
	       });
};

