//
// Copyright (C) 2008 Panasonic Corporation. All Rights Reserved.
//


var stock = new Icon();
stock.name = "bloomberg";
stock.WIDTH = 548;
stock.HEIGHT = 205;

stock.MARKET = null;
/**** TENTATIVE : depend on market ***/
stock.mkt = ureg.read("market");

if( stock.mkt == "US" ){ // US model
  stock.MARKET = [ { "name": "DOW",     "id":"INDU:IND" },
		   { "name": "S&P 500", "id":"SPX:IND" },
		   { "name": "NASDAQ",  "id":"CCMP:IND" },
		 ];
}else if( stock.mkt == "EU" ){ // EU model
  switch( system.locale.country ){
  case "AU":
  case "NZ":
    stock.MARKET = [ { "name": "DOW",     "id":"INDU:IND" },
		     { "name": "FTSE 100","id":"UKX:IND" },
		     { "name": "S&P/ASX", "id":"AS51:IND" },
		   ];
    break;
  default:
    stock.MARKET = [ { "name": "FTSE 100", "id":"UKX:IND" },
		     { "name": "CAC 40",   "id":"CAC:IND" },
		     { "name": "DAX",      "id":"DAX:IND" },
		   ];
  }
}else{
  stock.MARKET = [ { "name": "DOW",      "id":"INDU:IND" },
		   { "name": "FTSE 100", "id":"UKX:IND" },
		   { "name": "NIKKEI",   "id":"NKY:IND" },
		 ];
}
/*** END ***/

stock.lang = ureg.read("language");
//if( !stock.TEXT[ stock.lang ]){
//  console.log("cannot read \"language\". use default \"en-US\".");
//  stock.lang = "en-US";
//}

stock.display_name = "Bloomberg";

stock.components.push(
  new actor ({
    "base_col": [[99, 151, 184, 255], [99, 151, 184, 255]],
    "bg_image": [
      new gbox ({
	"width" : stock.WIDTH,
	"height": stock.HEIGHT,
	"color": [0x08, 0x10, 0x18, 255]
      }),
      new gbox ({
	"width": 542,
	"height": 38,
	"color": [255, 255, 255, 18],
	"translate": [0.0, 0.0-38, 0.0]
      }),
      new gimage({
 	"src": path + "bloomberg/bb_banner1.png",
 	"translate": [0.0, 103.0-38, 0.0]
      })
    ]
  })
);

var createStockPanel = function(stkObj, position){
  //private
  var make_stock_quote =  function (name, y_position) {
    return new container ({
      "translate": [0.0, 0.0, 0.0],
      "components": [
	new gtext ({
	  "translate": [-195.0, y_position, 0.0],
	  "width": 150,
	  "text": name,
	  "font_size": 32,
	  "margin": [0,0,10,0],
	}),
	new gtext ({
	  "translate": [-25.0, y_position, 0.0],
	  "width": 150,
	  "text": "-- -- -- -- --",
	  "font_size": 32,
	  "align": RIGHT,
	}),
	new gtext ({
	  "translate": [169.0, y_position, 0.0],
	  "width": 130,
	  "text": "-- -- -- ",
	  "font_size": 32,
	  "align": RIGHT }),
      ],
    });
  };
  //private
  stkObj.stock_quote0 = make_stock_quote( stock.MARKET[0].name , 45.0-38);
  stkObj.stock_quote0_value = stkObj.stock_quote0.components[1];
  stkObj.stock_quote0_chg = stkObj.stock_quote0.components[2];
  //private
  stkObj.stock_quote1 = make_stock_quote( stock.MARKET[1].name , 5.0-38);
  stkObj.stock_quote1_value = stkObj.stock_quote1.components[1];
  stkObj.stock_quote1_chg = stkObj.stock_quote1.components[2];
  //private
  stkObj.stock_quote2 = make_stock_quote( stock.MARKET[2].name , -35.0-38);
  stkObj.stock_quote2_value = stkObj.stock_quote2.components[1];
  stkObj.stock_quote2_chg = stkObj.stock_quote2.components[2];
  
  stkObj.components.push(stkObj.stock_quote0);
  stkObj.components.push(stkObj.stock_quote1);
  stkObj.components.push(stkObj.stock_quote2);

  //public
  stkObj.DrawData = function(stock_data)
  {
    var data = null;
    var target = [
      {"value": stkObj.stock_quote0_value, "change": stkObj.stock_quote0_chg},
      {"value": stkObj.stock_quote1_value, "change": stkObj.stock_quote1_chg},
      {"value": stkObj.stock_quote2_value, "change": stkObj.stock_quote2_chg}];
    for (var i=0;i<3;i++) {
      // set price
      try {
	data = stock_data[i].last;
      }catch(e){
	data = "-- -- -- -- --";
      }
      setf_text( target[i].value, ""+data);
      
      // set change
      var color = [255,255,255,255];
      try {
	data = stock_data[i].change;
	if (data > 0) color = [109,209,80,255];
	else if (data < 0) color = [198,68,62,255];
      }catch(e){
	color = [255,255,255,255];
	data = "-- -- --";
      }
      target[i].change.color = color;
      setf_text( target[i].change, ""+data);
    }	
  };
}(stock,[0.0, -360.0, 0.0]);

stock.DrawData(null);



stock.stock_data = null;




//END
stock;