

(load "/usr/local/slisp/play-market.lsp")(load "/usr/local/slisp/pal/recording.lsp")(load "/usr/local/slisp/pal/option-menu.lsp")

(setf timeshift-mode t)(switch-hdd-mode)

(defvar SC_PLAY_PRIO 2000)(defvar play-prio SC_PLAY_PRIO)(defvar *keep-time* 0)(defvar loop-limit 10800)(setf data-dir "/tmp/mnt/ustorage2")

(defvar record-start nil)(defvar record-pause nil)(defvar play-start nil)(defvar request-pids nil)(defvar request-pcr nil)(defvar start-speed nil)(defvar pause-live nil)

(defvar content-time nil)(defvar play-time nil)(defvar cut-time nil)(defvar keep-time nil)

(defvar open-sesami nil)(defvar current-svc-info nil)

(defvar svl-key nil)(defvar no-copy-status nil)

(defvar video-choice-num nil)(defvar last-video-pid nil)

(defvar with-tsport-ci1 nil)(defvar with-tsport-ci2 nil)(defvar with-latin-parental nil)(defvar with-si-copy-control nil)(defvar pmt-parental-exist 0)(defvar pmt-parental-age 0)(defvar parental-lock nil)(defvar user-parental-age 0)(defvar eit-parental-age 0)

(defvar pmt-rec-ctrl-data nil)(defvar eit-rec-ctrl-data nil)(defvar sdt-rec-ctrl-data nil)

(defvar pmt-retention-mode nil)(defvar eit-retention-mode nil)(defvar sdt-retention-mode nil)


(defvar follow-live-uri 0)(defvar umt-version 1)

(defvar with-satip nil)

(defvar video-ch nil)(defvar VIDEO_MONITOR_PRIO 1)

(defun set-eit-rec-ctrl-data (data retention-mode)(setf eit-rec-ctrl-data data)(setf eit-retention-mode retention-mode)(when (and request-pids
(or (not pmt-rec-ctrl-data)(not pmt-retention-mode)))(eval-partial-stream)))

(defun set-sdt-rec-ctrl-data (data retention-mode)(setf sdt-rec-ctrl-data data)(setf sdt-retention-mode retention-mode)(when (and request-pids
(or (and (not pmt-rec-ctrl-data) (not eit-rec-ctrl-data))(and (not pmt-retention-mode) (not eit-retention-mode))))(eval-partial-stream)))

(defvar tuning-tuner 'tuner)

(defun get-tuning-tuner ()
'tuner)

(defun my-select-channel ()(if (tsl-equal (get-tuning-tsl-key) (get-tuner-tsl-key (get-tuning-tuner)))(if (eq (get-tuning-svcid) (get-psi-svcid 'psi))(make-event 'psi-update)(set-psi-valid 'psi nil)(set-psi-error 'psi nil)(make-event 'psi-invalid)(search-svcid-in-pat (get-tuning-svcid))(make-event 'service-change))(set-psi-valid 'psi nil)(set-psi-error 'psi nil)(make-event 'psi-invalid)(make-event 'tuner-req)))

(register-device 'ca-out
"ca"
(get-default-prio)
#'(lambda (sig)(case sig
((CA_RECORD_COMPONENT CA_COPY_PROTECTION)(eval-partial-stream)))))(register-device 'cp-out
"cp"
(get-default-prio)
#'(lambda (sig)(case sig
((INFO_CHANGE)(eval-partial-stream)))))(register-device 'tsport-ci1
"tsport"
(get-default-prio)
#'(lambda (sig)(case sig
(SOURCE_CHANGE
(make-event 'tsport-ci1-change)))))(register-device 'tsport-ci2
"tsport"
(get-default-prio)
#'(lambda (sig)(case sig
(SOURCE_CHANGE
(make-event 'tsport-ci2-change)))))(register-node 'my-tuner-freq-valid
#'(lambda ()(tsl-equal (get-tuning-tsl-key) (get-tuner-tsl-key (get-tuning-tuner))))
#'(lambda ()(set-tuner-tsl-key (get-tuning-tuner) (get-tuning-tsl-key))

(eval-events (list 'tuner-req 'tuner-change)))
#'(lambda ()
nil))(register-node 'my-tuner-connect
#'(lambda ()(tuner-status (get-tuning-tuner)))
#'(lambda ()(unless (tuner-connect (get-tuning-tuner)
:tsl (get-tuner-tsl-key (get-tuning-tuner)))(set-tuner-tsl-key (get-tuning-tuner) (tuner-tsl-key (get-tuning-tuner))))(eval-events (list 'tuner-lock 'tuner-unlock 'tuner-disconnect)))
#'(lambda ()(tuner-disconnect (get-tuning-tuner))))

(register-node 'my-tsport-connect
#'(lambda (key)(get-connected-tsport-dev))
#'(lambda (key)(when with-tsport-ci1
(when (device-open-p 'ca-out)(my-device-close 'ca-out))(if (eq (get-connected-tsport-dev) 'tsport-ci2)(progn
(my-device-open 'ca-out 1)(write-bytes msg-pipe SC_CREC_CAM_SLOT 4 1))(if (eq (get-connected-tsport-dev) 'tsport-ci1)(progn
(my-device-open 'ca-out 0)(write-bytes msg-pipe SC_CREC_CAM_SLOT 4 0))(write-bytes msg-pipe SC_CREC_CAM_SLOT 4 -1)))(when (device-open-p 'ca-out)(init-ca-object 'ca-out)))(let ((cur-tsport-dev (get-connected-tsport-dev)))(when (or (not cur-tsport-dev)(eq cur-tsport-dev 'tsport))(when (device-open-p 'tsport-ci1)(tsport-disconnect 'tsport-ci1))(when (device-open-p 'tsport-ci2)(tsport-disconnect 'tsport-ci2))(tsport-connect 'tsport (get-tuning-tuner))))(eval-events (list 'tsport-avaialble 'tsport-change
'tsport-ci1-change 'tsport-ci2-change)))
#'(lambda (key)(tsport-disconnect 'tsport)))

(register-node 'parental-check
#'(lambda (key)(if with-latin-parental
(not (or (child-lock-p key)(parental-lock-p)))(not (parental-lock-p))))
#'(lambda ()(eval-events (list 'parental-check)))
#'(lambda ()(write-bytes msg-pipe SC_CREC_RECORDING 4 -1)
nil))

(register-node 'timeshift-check
#'(lambda ()(or record-start (not play-start)))
#'(lambda ()(when (and (not pause-live) (not record-start) play-start)(write-bytes msg-pipe SC_CREC_PLAYP2RECP 4 0))(eval-events (list 'record-restart)))
#'(lambda ()))(register-node 'timeshift-record
#'(lambda ()
t)
#'(lambda ()(stream-open 'stream-out
:mode "loop"
:mode (and nodirect-mode "nodirect")
:stream-dir stream-dir
:data-dir data-dir
:drm content-drm
:limit loop-limit)(setf record-start t)(write-bytes msg-pipe SC_CREC_RECORDING 4 1)(eval-timeshift-play))
#'(lambda ()(write-bytes msg-pipe SC_CREC_RECORDING 4 0)(stream-close 'stream-out)(setf record-start nil)))(register-node 'play-start
#'(lambda ()
play-start)
#'(lambda ()(eval-events (list 'play-start 'play-stop)))
#'(lambda ()(video-stop 'video)(audio-stop 'audio)(audio-stop 'audio-desc)(my-device-priority 'video (get-default-prio))(my-device-priority 'audio (get-default-prio))(my-device-priority 'audio-desc (get-default-prio))(device-close 'audio-desc)(my-device-priority 'video-for-ad (get-default-prio))(device-close 'video-for-ad)(my-device-priority 'psi-in (get-default-prio))))(register-node 'timeshift-play
#'(lambda ()
stream-valid)
#'(lambda ()(unless stream-valid
(setf stream-valid (stream-open 'stream-in
:mode "keep"))(if stream-valid
(set-timer #'(lambda (arg)(unless record-start
(setf keep-time (1- keep-time)))(let ((stream-ctime (stream-content-time 'stream-in))(stream-ptime (stream-play-time 'stream-in)))(setf content-time (or stream-ctime 0))(setf play-time (or stream-ptime 0))(setf cut-time (- content-time keep-time))(setf skip-seconds nil)(let ((ctime content-time) (ptime play-time)(playrec-time-p (and stream-ctime stream-ptime)))(when (> cut-time 0)(setf ctime (- content-time cut-time))(setf ptime (- play-time cut-time))(when (and (< ctime 0) (not record-start))(write-bytes msg-pipe SC_CREC_PLAYP2RECP 4 0))(when (and (<= ptime 0) stream-ptime)(when (< trik-speed 100)(pause)(write-bytes msg-pipe SC_CREC_RECP2PLAYP 4 0))(setf skip-seconds (- cut-time play-time))(setf ptime 0)))(when playrec-time-p
(write-bytes msg-pipe SC_CREC_PLAYREC_TIME 8 ptime ctime)))))
'timeshift-monitor
nil
nil
500)(set-timer #'(lambda (arg)(make-event 'play-retry))
'play-retry-timer
nil
1
500)))(eval-events (list 'play-retry)))
#'(lambda ()(cancel-timer 'timeshift-monitor)(setf content-time nil)(setf play-time nil)(setf cut-time nil)(setf keep-time *keep-time*)(cancel-timer 'play-time-timer)(setf current-time nil)(stream-close 'stream-in)(setf stream-valid nil)))(defun eval-timeshift-play ()(unless play-start
(when (and start-speed
record-start
(device-source-p 'video 'tsport)(eq (video-status 'video) 'DECODE_SUCCESS))(my-device-priority 'video play-prio)(my-device-priority 'audio play-prio)

(when ad-enable
(unless (device-open-p 'video-for-ad)(video-config 'video-for-ad
:codec 'VIDEO_CODEC_NONE
:use "AD")(device-open 'video-for-ad (video-openquery :error t))(my-device-priority 'video-for-ad play-prio))(unless (device-open-p 'audio-desc)(my-device-open 'audio-desc (device-id 'video-for-ad))))

(my-device-priority 'audio-desc play-prio)(my-device-priority 'psi-in play-prio)(set-video-result 'video nil)(set-audio-result 'audio nil)(stream-keep 'stream-in 'stream-out)(setf stop-mode t)(setf req-pause nil)(setf trik-speed start-speed)(video-pause 'video)(audio-stop 'audio)(audio-stop 'audio-desc)(setf play-start t)(make-event 'play-start))))(defvar content-management nil)(defun set-content-management (val)(unless (eq content-management val)(setf content-management val)(eval-partial-stream)))(defun eval-partial-stream ()(let ((pids nil) (emi) (content-emi nil) (video nil) (audio nil) (retention 0) (cc-parental nil))(when (eq (cp-create 'cp-out
:psi 'psi
:src (get-tuning-tuner)
:dst 'stream-out
:info 1
:type 1
:ca 'ca-out
:live-uri follow-live-uri
:umt-ver umt-version
:request 3
:content-management content-management)
t)(cp-set 'cp-out 'partial)(mapcar #'(lambda (z)(if with-si-copy-control
(progn
(setf emi (if pmt-rec-ctrl-data
pmt-rec-ctrl-data
(if eit-rec-ctrl-data
eit-rec-ctrl-data
(if sdt-rec-ctrl-data
sdt-rec-ctrl-data
0))))(setf retention (if pmt-retention-mode
pmt-retention-mode
(if eit-retention-mode
eit-retention-mode
(if sdt-retention-mode
sdt-retention-mode
0)))))(setf emi (cp-ref-pid 'cp-out (car z))))(setf cc-parental (cp-ref-cc-parental 'cp-out))(if (or (eq cc-parental t) (not emi)(and (eq emi 3) (eq retention 1)))
nil
(setf content-emi (if (or (eq content-emi 3) (eq emi 3))
3
(if (or (eq content-emi 2) (eq emi 2))
2
(if (or (eq content-emi 1) (eq emi 1))
1
0))))(when (and (not video) (eq (second z) 'video))(setf video (first z)))(when (and (not audio) (eq (second z) 'audio))(setf audio (first z)))(if pids
(setf-cdr (last pids) (cons (car z) nil))(setf pids (cons (car z) nil)))))
request-pids)(send-no-copy (not content-emi))(unless (and video audio)(setf pids nil))(request-partial request-pcr video nil audio nil content-emi (cp-ref-dtcp 'cp-out) pids nil))))

(defun timeshift-record-start ()(setf eit-rec-ctrl-data nil)(setf sdt-rec-ctrl-data nil)(setf eit-retention-mode nil)(setf sdt-retention-mode nil)(my-device-open 'psi-in 1)(my-device-open 'cp nil)(my-device-open 'tsport-in (if (eq tuner-no 0) "memin0" "memin1"))(my-device-open 'stream-in 'tsport-in)(stream-trik 'stream-in 'video 'audio)(my-device-open 'stream-out (if (eq tuner-no 0) 2 1))(my-device-open 'partial 'stream-out)(when (boundp 'config-ca)(my-device-open 'ca-out nil))(my-device-open 'cp-out nil)(my-device-open 'psi (if (eq tuner-no 0) 0 2))

(let ((port))(setf port (list nil nil nil nil))(if (eq tuner-no 0)(setf (nth 0 port) "FE_IN1")(setf (nth 1 port) "FE_IN2"))(when with-tsport-ci1
(setf follow-live-uri 1)(setf umt-version 1)(tsport-config 'tsport-ci1 (list (nth 0 port) (nth 1 port)))(my-device-open 'tsport-ci1 "ci0")(setf (nth 2 port) "CI_IN1"))(when with-tsport-ci2
(tsport-config 'tsport-ci2 (list (nth 0 port) (nth 1 port)))(my-device-open 'tsport-ci2 "ci1")(setf (nth 3 port) "CI_IN2"))(tsport-config 'tsport port))

(my-device-open 'tsport (if (eq tuner-no 0) 0 2))(when (boundp 'config-tuner)(tuner-config 'tuner config-tuner))(my-device-open 'tuner tuner-no)

(setf st-status (stream-status 'stream-out))

(video-config 'video-mon :use "MONITOR" :hint 0)(my-device-priority 'video VIDEO_MONITOR_PRIO)(my-device-open 'video-mon (video-openquery :ch video-ch))(init-video-object 'video-mon)

(my-device-priority 'video (get-default-prio))(my-device-priority 'audio (get-default-prio))(connect-fix-ch video-ch)(init-section-object 'ppat)(init-section-object 'ppmt)(init-psi-object 'psi-in #'ppmt-parser)(init-cp-object 'cp)

(init-partial-object 'partial)(init-ca-object 'ca-out)(init-cp-object 'cp-out)(init-tuner-object 'tuner)(set-tuner-hook 'tuner #'(lambda (sig)(when (eq sig 'TUNER_LOCK)(let ((tsl (tuner-tsl-key 'tuner)))(unless (tsl-equal (get-tuning-tsl-key) tsl)(set-tuning-tsl-key tsl)(set-tuning-tsid (tsl-get-data (get-tuning-tsl-key) 'tsid))(set-tuning-svcid nil)(my-select-channel)(set-cur-svc))))))

(init-section-object 'pat)(init-section-object 'pmt)(init-section-object 'eit-for-sit)(init-section-object 'sdt-for-sit)(init-psi-object 'psi #'(lambda (pmt)(search-svcid-in-pat (get-psi-svcid 'psi))(set-tuning-svcid (get-psi-svcid 'psi))(set-cur-svc)(setf pmt-rec-ctrl-data nil)(setf pmt-retention-mode nil)(setf pmt-parental-exist 0)(if (or (not pmt) (child-lock-p))(progn
(send-no-copy nil)(set-eit-for-sit-filter nil nil nil)(set-sdt-for-sit-filter nil nil nil)(set-video-pid 'video-mon nil)(cancel-partial))


(let ((header) (firstlp) (secondlp) (esheader) (esdesclp) (stype) (espid) (tag)(level-idc) (track) (video-type) (vlist) (stream))(setf header (first pmt))(setf firstlp (second pmt))(setf secondlp (third pmt))(setf request-pcr (+ (* (logand (nth 8 header) #x1F) #x100)(nth 9 header)))(setf request-pids nil)(setf video-type nil)(setf vlist nil)(unless (equal (tsl-get-data (get-tuning-tsl-key) 'ntype 'ya_nid) '(1 #x3b))(set-eit-for-sit-filter #x12 #x4e (get-tuning-svcid))(set-sdt-for-sit-filter #x11 #x42 (get-tuning-tsid)))(mapcar #'(lambda (desc)(when (eq (+ 2 (second desc)) (length desc))(case (first desc)(#x55
(when with-latin-parental
(detect-rating-country-code "BRA" (nth 1 desc) (nthcdr 2 desc))))(#xC1
(when with-si-copy-control
(setf pmt-rec-ctrl-data (logand (/ (third desc) 64) #x03))))

(#xDE
(when with-si-copy-control
(setf pmt-retention-mode (logand (/ (third desc) 16) #x01))))

)))
firstlp)(make-event 'parental-check)(when with-latin-parental
(make-event 'psi-update)(make-event 'parental-check))(mapcar #'(lambda (eslp)(setf esheader (first eslp))(setf esdesclp (second eslp))(setf espid (+ (* (logand (second esheader) #x1F) #x100)(third esheader)))(setf stype (first esheader))(setf stream nil)(setf level-idc 0)(case stype
((#x01 #x02 #x1b)(mapcar #'(lambda (desc)(case (first desc)(#x28
(when (eq stype #x1b)(setf level-idc (fifth desc))))))
esdesclp)(unless (or (eq video-type #x1b) with-hd)(setf video-type stype))(unless (and (eq stype #x1b) (not (or with-hd (not (eq current-network SC_TV_DVB)))))(setf track (list espid tag stype level-idc))(if vlist
(append-video-track track vlist)(setf vlist (cons track nil)))))

((#x03 #x04 #x0f #x11 #x81)(setf stream 'audio))

(#x05
(mapcar #'(lambda (desc)(case (first desc)(#x5F
(when (and (eq (nth 1 desc) 4)(eq (nth 2 desc) #x46)(eq (nth 3 desc) #x53)(eq (nth 4 desc) #x41)(eq (nth 5 desc) #x54))(setf private t)))(#xD1
(when (and with-freesat
(eq current-network SC_TV_FREESAT)(eq (+ 2 (nth 1 desc)) (length desc)) private)(when (and (eq (nth 1 desc) 1)(eq (nth 2 desc) #x02))(set-eit-for-sit-filter espid #xd1 (get-tuning-svcid)))(when (and (eq (nth 1 desc) 2)(eq (nth 2 desc) #x03)(eq (nth 3 desc) #x04))(set-sdt-for-sit-filter espid #x46 (get-tuning-tsid)))))))
esdesclp))

(#x06
(mapcar #'(lambda (desc)(case (first desc)((#x6a #x7a)(setf stream 'audio))

(#x52
(when is-brazil
(setf tag (third desc))(when (and (>= tag #x30)(<= tag #x3F))(setf stream t))))

((#x56 #x59)(setf stream t))))
esdesclp))

(otherwise
nil))(when stream
(if request-pids
(setf-cdr (last request-pids) (cons (list espid stream) nil))(setf request-pids (cons (list espid stream) nil)))))
secondlp)(when vlist
(setf track nil)(setf track (find-if #'(lambda (x)(= (get-video-pid 'video-mon) (get-track-pid x))) vlist))(unless track
(setf track (find-if #'(lambda (x)(= last-video-pid (get-track-pid x))) vlist)))(unless track
(setf track (car vlist)))(setf last-video-pid (get-track-pid track))(when (or (= request-pcr #x1fff) (and (eq request-pcr #x1ffe)(eq current-network SC_TV_OVER_IP)(> (length vlist) 0)))(setf request-pcr (get-track-pid track)))(if request-pids
(progn
(setf-nthcdr 0 request-pids (cons (nth 0 request-pids) (nthcdr (1+ 0) request-pids)))(setf-nth 0 request-pids (list (get-track-pid track) 'video)))

(setf request-pids (cons (list (get-track-pid) 'video) nil))))(when (or (not (device-open-p 'ca-out)) (ca-status 'ca-out))(eval-partial-stream))))))

(set-tuning-tsl-key (get-tuner-tsl-key (get-tuning-tuner)))(set-tuning-tsid (tsl-get-data (get-tuning-tsl-key) 'tsid))(set-tuning-svcid (get-psi-svcid 'psi))(set-cur-svc)(svl-query svl-key 'child_lock)(resource-node 'record-resource (list 'stream-out))(resource-node 'play-resource (list 'stream-in))

(append-t
'device-check
'record-resource
'my-tuner-freq-valid
'my-tuner-connect
'my-tsport-connect
'pat-request
'psi-valid
'parse-pmt
'parental-check
'pmt-pid-valid
'pmt-request
'record-file-check
'partial-start
'timeshift-check
'timeshift-record)

(append-t
'device-check
'play-resource
'play-start
'timeshift-play
'tsport-play
'speed-100
'ppat-request
'ppmt-pid-valid
'ppmt-request
'parse-ppmt
'display-cp-valid)

(append-t
'display-cp-valid
'video-pid-valid
'video-play)

(append-t
'display-cp-valid
'audio-pid-valid
'audio-play)

(append-t
'trik-play
'audio-desc-valid
'audio-desc-play
'audio-desc-volume)

(append-t
'ppat-request
'ppat-reset-monitor)

(append-t
'ppmt-request
'ppmt-reset-monitor)

(append-t
'partial-start
'sit-insert)

(append-t
'pat-request
'eit-for-sit-request)

(append-t
'pat-request
'sdt-for-sit-request)

(append-t
'timeshift-play
'trik-mode
'play-speed-set
'trik-play
'decode-monitor)

(append-t
'trik-mode
'play-monitor)

(eval-node 'device-check))

(defun timeshift-record-stop ()(cancel-node 'device-check)(init-node 'device-check)

(my-device-close 'cp)(my-device-close 'psi-in)(my-device-close 'tsport-in)(my-device-close 'stream-in)(my-device-close 'stream-out)(my-device-close 'partial)(my-device-close 'ca-out)(my-device-close 'cp-out)(my-device-close 'psi)(my-device-close 'tsport)(my-device-close 'tuner)(my-device-close 'video-mon)

(setf content-management nil)(setf record-start nil)(setf play-start nil)(setf request-pids nil)(setf request-pcr nil)(setf content-time nil)(setf play-time nil)(setf start-speed nil)(setf pause-live nil)

(setf pause-play nil)(setf stopped t)(setf play-valid nil)(setf play-speed 100)(setf trik-speed 100)(setf skip-seconds nil)(setf last-skip-seconds nil)(setf trik-mode nil)(setf skip-restart nil)(setf pmt-svcid nil)(setf last-video-codec nil))

(defun set-avsync-without-pcr (onoff)(set-video-ext 'video
(if onoff
"avsync-without-pcr"
nil)))

(defun timeshift-play-start (speed)(when (and (eq speed 0) (not (device-open-p 'partial)))(setf pause-live t)(timeshift-record-start))(when (< speed 100)(setf start-speed speed)(set-video-hook 'video #'(lambda (sig)(when (eq sig 'DECODE_SUCCESS)(eval-timeshift-play)(when req-pause
(send-play-time)(pause-action)))))(set-avsync-without-pcr (if (eq current-network SC_TV_OVER_IP)
t
nil))(eval-timeshift-play)))

(defun timeshift-play-stop ()(setf play-start nil)(setf start-speed nil)(setf stop-mode nil)(make-event 'play-stop)(video-stop 'video)(audio-stop 'audio)(audio-stop 'audio-desc)(my-device-priority 'video (get-default-prio))(my-device-priority 'audio (get-default-prio))(my-device-priority 'audio-desc (get-default-prio))(device-close 'audio-desc)(my-device-priority 'video-for-ad (get-default-prio))(device-close 'video-for-ad)(my-device-priority 'psi-in (get-default-prio))(if pause-live
(timeshift-record-stop)(make-event 'record-restart)))

(defun child-lock-p ()(and (eq (svl-get-data svl-key 'child_lock) 1)(not open-sesami)))

(defun set-open-sesami (on-off)(setf open-sesami (if (eq on-off 0) nil t))(when open-sesami
(setf parental-lock nil))(make-event 'psi-update))

(defun set-user-parental-age (age)(setf user-parental-age age)(make-event 'psi-update))

(defun set-eit-parental-age (age)(setf eit-parental-age age)(make-event 'psi-update))

(defun set-parental-lock (lock)(setf parental-lock lock)(make-event 'psi-update))

(defun parental-lock-p ()(if with-latin-parental
(and (not (file-close (file-open unlock-file 'read)))(not (= user-parental-age 1))(<= user-parental-age
(if (= pmt-parental-exist 1)
pmt-parental-age
eit-parental-age)))
parental-lock))

(defun detect-rating-country-code (code length data)(let ((country-code)(rating))(when (and (> length 0) data)(setf country-code (copy-string "---"))(setf-char country-code 0 (nth 0 data ))(setf-char country-code 1 (nth 1 data ))(setf-char country-code 2 (nth 2 data ))(setf rating (logand (nth 3 data) #x0f))

(if (and (string-equal code country-code)(>= rating 0x1)(<= rating 0x6))(progn
(setf pmt-parental-exist 1)(setf pmt-parental-age rating))(detect-rating-country-code code (- length 4) (nthcdr 4 data))))))

(defun set-cur-svc ()(let ((lst)(ntype (tsl-get-data (get-tuning-tsl-key) 'ntype))(onid (tsl-get-data (get-tuning-tsl-key) 'onid))(tsid (tsl-get-data (get-tuning-tsl-key) 'tsid))(svcid (get-tuning-svcid))(phych (tsl-get-data (get-tuning-tsl-key) 'physical_ch)))(setf lst (list ntype onid tsid svcid phych))(unless (equal current-svc-info lst)(if (and ntype onid tsid svcid phych (> ntype 0))(progn
(setf svl-key (svl-create-key "SVL"
:onid onid
:tsid tsid
:svcid svcid
:physical_ch phych))(svl-query svl-key 'child_lock)(write-bytes msg-pipe SC_CREC_CURSVC 20 ntype onid tsid svcid phych))(setf svl-key nil)(write-bytes msg-pipe SC_CREC_CURSVC 4 -1)))(setf current-svc-info lst)))

(defun send-no-copy (status)(unless (eq no-copy-status status)(write-bytes msg-pipe SC_CREC_NO_COPY 4 (if status 1 0))(setf no-copy-status status)))

(defmacro get-track-pid (track)
`(first ,track))(defmacro get-track-tag (track)
`(second ,track))(defmacro get-track-video-codec (track)
`(third ,track))(defmacro get-track-video-level (track)
`(fourth ,track))(defun get-codec-priority (codec level)(if (eq codec #x1b)(+ 1 level)
0))

(defun append-video-track (track lst)(when (or (not video-choice-num) (< (length lst) video-choice-num))(let ((pos nil))(setf pos (position-if #'(lambda (x)(> (get-codec-priority (get-track-video-codec track) (get-track-video-level track))(get-codec-priority (get-track-video-codec x) (get-track-video-level x))))
lst))(if (not pos)(setf-cdr (last lst) (cons track nil))(progn
(setf-nthcdr pos lst (cons (nth pos lst) (nthcdr (1+ pos) lst)))(setf-nth pos lst track))))))


(defun get-connected-tsport-dev ()(if (device-source-p 'tsport (get-tuning-tuner))
'tsport
(if (and (device-open-p 'tsport-ci1)(device-source-p 'tsport 'tsport-ci1)(device-source-p 'tsport-ci1 (get-tuning-tuner)))
'tsport-ci1
(if (and (device-open-p 'tsport-ci2)(device-source-p 'tsport 'tsport-ci2)(device-source-p 'tsport-ci2 (get-tuning-tuner)))
'tsport-ci2
nil))))
