(function(window,dom){
var filterMenu,
mystream=window.MYSTREAM=window.MYSTREAM||{},
domFocus=dom.FOCUS,
FILTER_ID={
ALL:0,
BROADCAST:1,
RECORDED:2,
VOD:3,
YOUTUBE:4,
MUSIC:5,
VIDEO:6,
PHOTO:7,
MEMO:8,
BOOKMARK:9
};
filterMenu={
SCREEN_STATE:{
CLOSED:0,
OPENED:1,
TRANSITION:2
},
FIX_WORDS:null,
screenState:0,
selectIndex:0,
focusIndex:0,
closeCallback:null,
forceCloseCallback:null,
focus:null,
filterList:null,
init:function(config,callback){
this.FIX_WORDS={
FILTER_BY:LANG('LT_MYSTRM_FILTER'),
SHOW_ALL:LANG('LT_MYSTRM_ALL')
};
this.focus=new domFocus.Focus(document.getElementById('filterFocus'));
this.closeCallback=callback;
this.filterList=[{id:FILTER_ID.ALL,title:LANG('LT_ALL')}];
if(config.supportYoutube){
this.filterList.push({id:FILTER_ID.YOUTUBE,title:'YouTube'});}
if(config.supportBroadcast){
this.filterList.push({id:FILTER_ID.BROADCAST,title:LANG('LT_MYSTRM_TVPROGRAM')});}
if(config.supportRecordedTV){
this.filterList.push({id:FILTER_ID.RECORDED,title:LANG('LT_MYSTRM_RECORDED_TV')});}
if(config.supportVOD){
this.filterList.push({id:FILTER_ID.VOD,title:LANG('LT_MYSTRM_VOD')});}
this.filterList.push({id:FILTER_ID.MUSIC,title:LANG('LT_MUSIC_GENRE')},
{id:FILTER_ID.VIDEO,title:LANG('LT_MYSTRM_VIDEO')},
{id:FILTER_ID.PHOTO,title:LANG('LT_MYSTRM_PHOTO')});
if(config.supportMemo){
this.filterList.push({id:FILTER_ID.MEMO,title:LANG('LT_MYSTRM_MEMO')});}
if(config.supportBookmark){
this.filterList.push({id:FILTER_ID.BOOKMARK,title:LANG('LT_HOME_GADGET_BOOKMARKS')});}
},
open:function(){
DEBUG.console(DEBUG.LVL.VERBOSE,'open filter menu');
var eleFilterBox,eleLiTemplate,eleWrap,eleChoiceBox,eleDiv,eleLi,eleUl,i,max,that=this;
this.forceCloseCallback=null;
this.focusIndex=this.selectIndex;
eleFilterBox=document.getElementById('filterListBox');
eleWrap=dom.createElement('div',{id:'filterListBoxWrap'});
eleUl=dom.createElement('ul',{id:'filterListBoxUl'});
eleLiTemplate=dom.createElement('li',{className:'filterList'});
var filterListLength=this.filterList.length;
for(i=0;i<filterListLength;i++){
eleLi=eleLiTemplate.cloneNode(true);
eleLi.id='filterList'+i;
eleLi.textContent=this.filterList[i].title;
eleUl.appendChild(eleLi);}
eleWrap.appendChild(eleUl);
eleFilterBox.appendChild(eleWrap);
this.screenState=this.SCREEN_STATE.TRANSITION;
eleFilterBox.classList.add('open');
dom.addTransitionEndCallback(eleFilterBox,'opacity',function(){
that.screenState=that.SCREEN_STATE.OPENED;
if(that.forceCloseCallback){
that.close(false,null);
return;}
that.focus.set(document.getElementById('filterList'+that.focusIndex));});},
close:function(callback,filterId){
DEBUG.console(DEBUG.LVL.VERBOSE,'close filter menu');
var that=this,eleFilterBox=document.getElementById('filterListBox');
if(callback){
this.forceCloseCallback=callback;}
if(this.screenState===this.SCREEN_STATE.TRANSITION){
return;}
this.screenState=this.SCREEN_STATE.TRANSITION;
that.focus.off();
eleFilterBox.classList.add('close');
eleFilterBox.classList.remove('open');
dom.addTransitionEndCallback(eleFilterBox,'opacity',function(){
var callback=that.closeCallback;
eleFilterBox.innerHTML='';
eleFilterBox.classList.remove('close');
that.screenState=that.SCREEN_STATE.CLOSED;
if(that.forceCloseCallback){
callback=that.forceCloseCallback;
that.forceCloseCallback=null;}
callback(filterId);});},
keyDownHandler:function(event){
var that=this;
if(this.focus.currentState===domFocus.STATE.OFF){
return;}
switch(event.keyCode){
case KeyEvent.DOM_VK_RETURN:
var eleLabel=document.getElementById('listFilterText');
this.selectIndex=this.focusIndex;
eleLabel.textContent=this.createLabelText(this.focusIndex);
this.close(false,this.filterList[this.focusIndex].id);
break;
case KeyEvent.DOM_VK_UP:
if(this.focusIndex===0){
this.focusIndex=this.filterList.length-1;}else {
this.focusIndex-=1;}
this.focus.move(document.getElementById('filterList'+this.focusIndex));
break;
case KeyEvent.DOM_VK_DOWN:
if(this.focusIndex>=this.filterList.length-1){
this.focusIndex=0;}else {
this.focusIndex+=1;}
this.focus.move(document.getElementById('filterList'+this.focusIndex));
break;
case KeyEvent.DOM_VK_BACK_SPACE:
this.focusIndex=this.selectIndex;
this.close(false,null);
break;
default:
}
},
resetFilter:function(filterId){
var index=0,i,max,eleLabel;
if(filterId){
for(i=0,max=this.filterList.length;i<max;i+=1){
if(this.filterList[i].id===filterId){
index=i;
break;}
}
}
eleLabel=document.getElementById('listFilterText');
eleLabel.textContent=this.createLabelText(index);
this.focusIndex=this.selectIndex=index;},
createLabelText:function(index){
return (index===0)?this.FIX_WORDS.SHOW_ALL:
this.FIX_WORDS.FILTER_BY+' '+
this.filterList[index].title;}
};
mystream.FILTER_MENU=filterMenu;
mystream.FILTER_ID=FILTER_ID;}(window,DOMUTIL));
