/**
 * Created with JetBrains WebStorm.
 * User: Dean Clancy
 * Date: 26/11/13
 * Time: 23:04
 * To change this template use File | Settings | File Templates.
 */
var olgOnly = function(){

    var vbo = null,
        configObj = null,
        manager = null,
        searchManager = null,
        search_stack = [],
        linesToRender = 0,
        ui = null,
        channelChanger = null,
        config,
        state_olg = true,
        action_menu = false,
        searching = false,
        focusRow = 0,
        pageRows = 0,
        topRow = 0,
        notHidden = true;

    config = {
        channelIDs: [],
        channelImages: [],
        LOCAL_VARS: {
            ui_banner_timeout: 5,
            NO_DATA: 'No data available'
        },
        LOCAL_CONFIG_FILE: "file:///transient/freetime/freetimed/ram/freetimeconf.xml",

        getQueryString: function() {
            var query = window.location.search,
                options,
                option,
                len,
                i;

            if (query) {
                query = query.replace('?', '');
                options = query.split('&');
                len = options.length;

                for (i = 0; i < len; i++) {
                    option = options[i].split('=');
                    config.LOCAL_VARS[option[0]] = option[1];
                }
            }
        },

        parseJSONImages: function(json) {
            if(json){
                var data = JSON.parse(json),
                    images = data.imageMappings.img,
                    len = images.length,
                    fsatid,
                    img_index,
                    i;

                for (i = 0; i < len; i++) {
                    fsatid = images[i].id.replace('fs-img://fsatid/', '').replace('-hi', '');

                    if (config.channelIDs.indexOf(fsatid) === -1) {
                        config.channelIDs.push(fsatid);
                        config.channelImages.push({
                            fsatid: fsatid,
                            img: config.LOCAL_VARS.recdata_loc + images[i].stb
                        });
                    } else {
                        img_index = config.channelIDs.indexOf(fsatid);

                        if (images[i].id === ('fs-img://fsatid/' + fsatid + '-hi')) {
                            config.channelImages[img_index].img_hi = config.LOCAL_VARS.recdata_loc + images[i].stb;
                        }
                        if (images[i].id === ('fs-img://fsatid/' + fsatid)) {
                            config.channelImages[img_index].img = config.LOCAL_VARS.recdata_loc + images[i].stb;
                        }
                    }
                }
            }
        },

        parseXMLConfig: function(xml) {
            var mode,
                data,
                recdata_loc,
                ui_banner_timeout,
                file_url = '/img/imgmap.json';

            mode = (config.LOCAL_VARS.mode) ? config.LOCAL_VARS.mode : 'dtt';

            try {

                if (mode === 'dtt') {
                    data = xml.getElementsByTagName(mode)[0];
                    recdata_loc = data.getElementsByTagName('recdata_loc')[0].childNodes[0].nodeValue;

                    if (recdata_loc) {
                        file_url = recdata_loc + file_url;
                        config.LOCAL_VARS.recdata_loc = recdata_loc;
                        config.getFile(file_url, 'json', config.parseJSONImages);
                    }
                }
                ui_banner_timeout = xml.getElementsByTagName('ui_banner_timeout')[0].childNodes[0].nodeValue;

                if (ui_banner_timeout) {
                    config.LOCAL_VARS.ui_banner_timeout = ui_banner_timeout;
                }

            } catch (e) {
                ui_banner_timeout = 5;
            }
        },

        getFile: function(file, type, callback) {
            var client, response;
            try{
                if (window.XMLHttpRequest) {
                    client = new XMLHttpRequest();
                }
                client.open("GET", file, false);
                client.onreadystatechange = function() {
                    if (type === 'xml') {
                        response = client.responseXML;
                    } else {
                        if(client.responseText){
                            response = client.responseText;
                        }
                    }

                    if(client.readyState === 4){
                        callback(response);
                    }
                };
                client.send();
            }catch(e){
            }
        }
    };

    ui = {
        clockInterval: null,
        timeout: null,
        no_data_timeout: null,
        visible: false,
        infoVisible: false,
        column: 'now',
        blank_cell: {
            name: '',
            startTime: '',
            duration: 0
        },
        empty_programme: {
            name: config.LOCAL_VARS.NO_DATA,
            startTime: '',
            duration: 0
        },

        no_data_avail_display : false,

        setNoDataDispTimer: function() {
            ui.clearNoDataDispTimer();
            ui.no_data_timeout = setTimeout(ui.dispNoDataAvail, 2000);
        },
        clearNoDataDispTimer: function() {
            if (ui.no_data_timeout) {
                clearTimeout(ui.no_data_timeout);
            }
            ui.no_data_avail_display = false;
        },
        dispNoDataAvail: function () {
            ui.no_data_avail_display = true;
            channelChanger.updateProgrammes();
        },

        toggle: function() {
            var cssClass = "";
            if (ui.visible) {
                cssClass = "hidden";
                linesToRender = 0;
                ui.visible = false;
                setKeysetHide();
                hide3LG();
                if (ui.infoVisible) {
                    ui.toggleInfo();
                }
            } else {
                ui.setupClockUpdate();
                ui.updateClock();
                ui.visible = true;
                setKeysetShow();
            }
            document.getElementById('zappertlg-inst').className = cssClass;
        },
        toggleInfo: function() {
            var cssClass = "";
            clearTimeout(ui.timeout);

            if (ui.infoVisible) {
//                clearTimeout(ui.timeout);
                cssClass = "hidden";
                ui.infoVisible = false;
                ui.timeout = setTimeout(ui.toggle, (config.LOCAL_VARS.ui_banner_timeout * 1000));
            } else {
                if (!ui.visible) {
                    setKeysetShow();
                    channelChanger.updateProgrammes();
                }
                ui.infoVisible = true;
                ui.setNoDataDispTimer();
            }
            if(!state_olg) cssClass += ' show-tlg';
            document.getElementById('tlg-info-banner-mask').className = cssClass;
        },
        updateClock: function() {
            var clock = document.getElementById('zapper-clock'),
                now = new Date(),
                hour = ui.addLeadingZero(now.getHours()),
                minutes = ui.addLeadingZero(now.getMinutes()),
                time;
            if(!state_olg){
                if(now % 300000 < 60000){
                    linesToRender = 3;
                     guideCreateLine(currentPage[0],1);
                    if(currentPage[1]>-1){
                        guideCreateLine(currentPage[1],2);
                    }else{
                        --linesToRender;
                    }
                    if(currentPage[2]>-1){
                        guideCreateLine(currentPage[2],3);
                    }else{
                        --linesToRender;
                    }
                }
            }
            time = hour + ':' + minutes;
            clock.innerHTML = time;
        },
        setupClockUpdate: function(){
            if(ui.clockInterval === null){
                ui.clockInterval = setInterval(ui.updateClock, 30000);
            }
        },
        clearClockUpdate: function(){
            if(ui.clockInterval){
                clearInterval(ui.clockInterval);
                ui.clockInterval = null;
            }
        },
        addLeadingZero: function(value) {
            if (value < 10) {
                value = '0' + value;
            }
            return value;
        }
    };

    channelChanger = {
        truncate: function(str){
            if (str.length > 9) {
                return str.substring(0, 7) + "...";
            } else {
                return str;
            }
        },
        setChannelLogo: function(channel, labelElement, logoElement, hi, highlight){
            var freesatServiceID = channel.freesatServiceID,
                channelImageIndex = config.channelIDs.indexOf(freesatServiceID), img_url,
                labelClass = labelElement.className;

            if (channelImageIndex !== -1) { // Check if channel logo is available and set
//                img_url = config.channelImages[channelImageIndex].img_hi;
                img_url = (hi)? config.channelImages[channelImageIndex].img_hi : config.channelImages[channelImageIndex].img;
                channelChanger.highlightEle(hi,highlight);
                if (labelClass.indexOf('hidden') === -1) {
                    labelClass = labelClass + ' hidden';
                }
                logoElement.setAttribute('src', img_url);

            } else { // Add invalid url to hide previous image // Clear logo and show label
                logoElement.setAttribute('src', 'noimage');
                if (labelClass.indexOf('hidden') !== -1) labelClass = labelClass.replace(' hidden', '');
                labelClass = channelChanger.highlightText(hi, labelClass);
                channelChanger.highlightEle(hi,highlight);
            }
            labelElement.className = labelClass;
        },
        highlightText: function(hi, labelClass){
            if(labelClass){
                if(hi){
                    if(labelClass.indexOf('highlight')===-1) labelClass += (' highlight')
                }else{
                    labelClass = labelClass.replace(' highlight', '');
                }
            }
            return labelClass;
        },
        highlightEle: function(hi, highlight){
            if(highlight){
                if(hi){
                    if(highlight.className.indexOf('highlight')===-1) highlight.className += (' highlight');
                }else{
                    highlight.className = highlight.className.replace(' highlight', '');
                }
            }
        },

        updateProgrammes: function() {
            var nowElement = document.getElementById('zapping-banner-now'),
                nextElement = document.getElementById('zapping-banner-next'),
                channel = vbo.currentChannel,
                channelName = channel.name || '',
                icons = document.getElementById('tlg-banner-icons'),
                shortChannelName = channelChanger.truncate(channelName),
                selected, programmeName, description, episode, timeoutDuration, programmes, now, next, empty,
                nowTime, prog;

            notHidden = !channel.hidden;
            channelChanger.setChannelLogo(channel, document.getElementById('zapping-banner-ch-icon-label'), document.getElementById('olg-channel-logo'), true);
            nowElement.className = nowElement.className.replace(' focused', '');
            nextElement.className = nextElement.className.replace(' focused', '');

            programmes = vbo.programmes;

            if (ui.no_data_avail_display) {
                empty = ui.empty_programme;
            } else {
                empty = ui.blank_cell;
            }
            if (programmes.length === 2) {
                ui.clearNoDataDispTimer();
            }
            if (programmes.length === 0) {
                now = empty;
                next = empty;
            } else if (programmes.length === 1) {
                nowTime = Math.round(new Date().getTime() / 1000);
                prog = vbo.programmes[0];

                if (prog.startTime > nowTime) {
                    now = empty;
                    next = prog;
                } else {
                    now = prog;
                    next = empty;
                }
            } else {
                now = vbo.programmes[0];
                next = vbo.programmes[1];
            }
            if (ui.column === 'now') {
                selected = now;
                nowElement.className += ' focused';
            } else {
                selected = next;
                nextElement.className += ' focused';
            }
            programmeName = selected.name || '';
            description = selected.description || 'No description available';
            episode = selected.episode;

            document.getElementById('zapping-banner-ch-no').innerHTML = channel.ccid.split(':')[1];
            document.getElementById('zapping-banner-ch-icon-label').innerHTML = shortChannelName;

            document.getElementById('programmeNameLabel-olg-now').innerHTML = now.name;
            document.getElementById('timeLabel-now').innerHTML = formatGuideTime(now.startTime);
            document.getElementById('programmeNameLabel-olg-next').innerHTML = next.name;
            document.getElementById('timeLabel-next').innerHTML = formatGuideTime(next.startTime);

            channelChanger.updateInfoPanel(selected, episode, channelName, programmeName, description);
//            if (!ui.visible) {
//                ui.toggle();
//            }
//
//            if (!ui.infoVisible && !ui.no_data_avail_display) {
//
//                if (ui.timeout) {
//                    clearTimeout(ui.timeout);
//                }
//                timeoutDuration = (config.LOCAL_VARS.ui_banner_timeout * 1000);
//                ui.timeout = setTimeout(ui.toggle, timeoutDuration);
//            }
        },
        updateInfoPanel: function(selected, episode, channelName, programmeName, description){
            var season = 'Season 0 Episode {e}', remaining;

                if (episode) {
                season = season.replace('{e}', episode);
            } else {
                season = '';
            }

            if (ui.column === 'now') {
                remaining = formatTimeRemaining(selected.startTime, selected.duration);
            } else {
                var startDate = new Date(selected.startTime*1000);
                var endDate = new Date((selected.startTime*1000)+(selected.duration*1000));
                var stMin = String(startDate.getMinutes());
                while(stMin.length<2){
                    stMin = '0'+stMin;
                }
                var endMin = String(endDate.getMinutes());
                while(endMin.length<2){
                    endMin = '0'+endMin;
                }
                remaining = startDate.getHours()+':'+stMin+ ' - '+ endDate.getHours()+':'+endMin;
            }
            document.getElementById('tlg-banner-ch-name').innerHTML = channelName;
            document.getElementById('tlg-banner-prog-name').innerHTML = programmeName;
            document.getElementById('tlg-banner-synopsis').innerHTML = description;
            document.getElementById('tlg-banner-season').innerHTML = season;
            document.getElementById('tlg-banner-time-remaining').innerHTML = remaining;
        },
        channelUp: function() {

            if (ui.visible) {
                ui.toggle();
            }
            vbo.nextChannel();
            vbo.bindToCurrentChannel();
            ui.setNoDataDispTimer();
        },

        channelDown: function() {

            if (ui.visible) {
                ui.toggle();
            }
            vbo.prevChannel();
            vbo.bindToCurrentChannel();
            getConfig();
            ui.setNoDataDispTimer();
        },
        changeToChannel: function(ccid){
            var channel = oipfChannelList.getItem(oipfChannelList.findListPosByCCID(ccid));
            vbo.setChannel(channel, false);
            vbo.bindToCurrentChannel();
        },
        onChannelChange: function() {
            if(!state_olg)clearGuide();
            ui.column = 'now';

            document.getElementById('programmeNameLabel-olg-now').innerHTML = '';
            document.getElementById('timeLabel-now').innerHTML = '';
            document.getElementById('programmeNameLabel-olg-next').innerHTML = '';
            document.getElementById('timeLabel-next').innerHTML = '';

            channelChanger.updateAndShowBanner();
        },

        onProgrammesChanged: function() {
            console.log('onProgrammesChanged');
            channelChanger.updateProgrammes();
        },

        updateAndShowBanner: function() {
            ui.column = 'now';
            channelChanger.updateProgrammes();
            channelChanger.showBanner();
        },
        
        showBanner: function() {
            if (!ui.visible) {
                ui.toggle();
            }

            if (!ui.infoVisible && !ui.no_data_avail_display) {

                if (ui.timeout) {
                    clearTimeout(ui.timeout);
                }
                timeoutDuration = (config.LOCAL_VARS.ui_banner_timeout * 1000);
                ui.timeout = setTimeout(ui.toggle, timeoutDuration);
            }
        }
    };


    function getConfig() {
        config.getQueryString();
        config.getFile(config.LOCAL_CONFIG_FILE, 'xml', config.parseXMLConfig);
    }

    function moveChannel(line_no){
        var fsname     = document.getElementById('chlogo'+(focusRow+1)+'-label');
        var flogo     = document.getElementById('chlogo'+(focusRow+1)+'img');
        var fhighlight= document.getElementById('chlogo'+(focusRow+1)+'bg');
        var sname     = document.getElementById('chlogo'+(line_no+1)+'-label');
        var logo     = document.getElementById('chlogo'+(line_no+1)+'img');
        var highlight= document.getElementById('chlogo'+(line_no+1)+'bg');
        channelChanger.setChannelLogo(oipfChannelList.getItem(topRow + focusRow), fsname, flogo, false, fhighlight);
        channelChanger.setChannelLogo(oipfChannelList.getItem(topRow+ line_no), sname, logo, true, highlight);
    }

    function formatGuideTime(seconds){
        var d = new Date(seconds * 1000),
            local_offset = d.getTimezoneOffset(),
            _date;

        if (typeof seconds !== "number") {
            return '';
        }

        try {
            _date = new Date((seconds  - (local_offset * 60)) * 1000);

            var dateStr = _date.toISOString().substr(0, _date.toISOString().length-5);
            var tArr = dateStr.split('T');
            return tArr[1].substr(0,5);
        } catch (Error) {
            _date = new Date(seconds);
            if(_date && seconds) {
                var retString  = '<h1>:<m1>';
                var tArr1 = seconds.split('T')[1].split(':');
                return retString.replace('<h1>',tArr1[0]).replace('<m1>',tArr1[1]);
            }
        }
    }

    var oipfFindPrograms = function(pos,line_no) {
        if (searching === false) {
            searching = true;
            this.mSearch = searchManager.createSearch( 1 );
            var ch = oipfChannelList.getItem(pos);
            this.mSearch.findProgrammesFromStream(ch, null);
            searchManager.onMetadataSearch = oipfOnMetadataFindProgs(this,line_no);
            this.mSearch.result.getResults(0, 2);
        }else{
            // push the search onto the stack
            search_stack.push(pos);
        }
    };
    var oipfOnMetadataFindProgs = function(scope,line_no) {
        return function(search, state) {
            if (state===0) {
                search.onMetadataSearch = null;
                guideUpdateNowNext(search.result, line_no);
                searching = false;
                if (search_stack.length) {
                    // shift first one off the stack
                    var pos = search_stack.shift();
                    oipfFindPrograms(pos,line_no+1);
                }
            }
            else {

            }
        };
    };
    var guideUpdateNowNext = function(result, line_no) {
        var progs = oipfChannelList.setProgrammes(result);
        var len = progs.length;
            // find grid line
            var now       = document.getElementById('programmeNameLabel_now'+line_no);
            var now_time  = document.getElementById('programmeTimeHourLabel_now'+line_no);
            var next      = document.getElementById('programmeNameLabel_next'+line_no);
            var next_time = document.getElementById('programmeTimeHourLabel_next'+line_no);
        if (len > 0) {
            try{
                now.innerHTML      = progs[0].name;
                now_time.innerHTML = progs[0].startTimeString;
                if (len > 1) {
                    next.innerHTML      = progs[1].name;
                    next_time.innerHTML = progs[1].startTimeString;
                }
            }catch(e){}
        }else{
            now.innerHTML = ' No Data';
            next.innerHTML = ' No Data';
        }
        --linesToRender;
        if(linesToRender<1)updateInfoPanel();
    };

    var guideCreateLine = function(pos, line_no) {
        currentPage[line_no-1] = pos;
        var lcn       = document.getElementById('ch'+line_no);
        var sname     = document.getElementById('chlogo'+line_no+'-label');
        var logo     = document.getElementById('chlogo'+line_no+'img');
        var highlight= document.getElementById('chlogo'+line_no+'bg');
        var now       = document.getElementById('programmeNameLabel_now'+line_no);
        var now_time  = document.getElementById('programmeTimeHourLabel_now'+line_no);
        var next      = document.getElementById('programmeNameLabel_next'+line_no);
        var next_time = document.getElementById('programmeTimeHourLabel_next'+line_no);

        var ccid  = oipfChannelList.getLcn(pos);
        var hidden = oipfChannelList.getHidden(pos);
        if (hidden === true) {
            lcn.innerHTML = "***";
        }
        else {
            lcn.innerHTML = ccid;
        }
        sname.innerHTML = oipfChannelList.getName(pos);
        channelChanger.setChannelLogo(oipfChannelList.getItem(pos), sname, logo, ((focusRow+1)===line_no), highlight);
        now.innerHTML = '';
        now_time.innerHTML = ' - -:- -';
        next.innerHTML = '';
        next_time.innerHTML = ' - -:- -';

        var progs = oipfChannelList.getProgrammes(pos);
        if (progs.length > 0) {
            // test cache is up to date. If not perform new search
            var timeNow = new Date();
            //var progEnd = (progs[0].startTime + progs[0].duration) * 1000;
            if ( progs[0].progEnd < timeNow) {
                // perform oipf search
                oipfFindPrograms(pos, line_no);
            }else {
                now.innerHTML      = progs[0].name;
                now_time.innerHTML = progs[0].startTimeString;
                if (progs.length > 1) {
                    next.innerHTML      = progs[1].name;
                    next_time.innerHTML = progs[1].startTimeString;
                }
                --linesToRender;
            }
        }else {
            oipfFindPrograms(pos, line_no);
        }
    };

    var clearTLG = function(){
        for(var i=1; i<4; i++){
            document.getElementById('ch'+i).innerHTML = '';
            document.getElementById('chlogo'+i+'-label').innerHTML = '';
            document.getElementById('programmeNameLabel_now'+i).innerHTML = '';
            document.getElementById('programmeTimeHourLabel_now'+i).innerHTML = '';
            document.getElementById('programmeNameLabel_next'+i).innerHTML = '';
            document.getElementById('programmeTimeHourLabel_next'+i).innerHTML = '';
        }
    };

    function formatDuration(time) {
        var hours,
            minutes,
            duration = '';

        if (typeof time !== "number" || time === 0) {
            return '';
        }

        minutes = Math.floor(time / 60);

        if (minutes > 60) {
            hours = Math.floor(minutes / 60);
            minutes -= (hours * 60);
            duration += hours + ' hr ';
        }
        duration += minutes + ' mins';
        return duration;
    }

    function formatTimeRemaining(startTime, duration) {
        var d = new Date(),
            currentTime = d.getTime() / 1000,
            hours,
            minutes,
            remainingTimeInSeconds,
            remaining = '';

        if (typeof startTime !== "number") {
            return '';
        }
        remainingTimeInSeconds =  (startTime + duration) - currentTime;
        minutes = Math.ceil(remainingTimeInSeconds / 60);

        if (minutes > 60) {
            hours = Math.floor(minutes / 60);
            minutes -= (hours * 60);
            remaining += hours + ' hr ';
        }
        remaining += minutes + ' mins left';
        return remaining;
    }

    function setKeysetShow() {
        var red = 0x1; //red
        var green = 0x2; //green
        var yellow = 0x4; //yellow
        var blue = 0x8; //blue
        var nav = 0x10;
        var pgUpDown = 0x40;
        var info = 0x80;
        var mask = nav + pgUpDown + info+green+yellow+blue+red;
        try {
            var app = document.getElementById('appmgr').getOwnerApplication(document);
            app.privateData.keyset.setValue(mask);
            app.privateData.keyset.value = mask;
            app.show();
        } catch (e) {
            // ignore
        }
        document.getElementById('olg-strapline').className = '';
    }
    function setKeysetHide() {
        var red = 0x1; //red
        var green = 0x2; //green
        var yellow = 0x4; //yellow
        var blue = 0x8; //blue
        var nav = 0x10;
        var pgUpDown = 0x40;
        var info = 0x80;
        var mask = nav + pgUpDown + info+green+yellow+blue;
        try {
            var app = document.getElementById('appmgr').getOwnerApplication(document);
            app.privateData.keyset.setValue(mask);
            app.privateData.keyset.value = mask;
            app.hide();
        } catch (e) {
            // ignore
        }
        document.getElementById('olg-strapline').className = 'hidden';
    }

    var launch3LG = function() {
        if(notHidden && oipfChannelList.getLength()>0){
            clearTLG();
            clearEmptyRows(0);
            state_olg = false;
            if(ui.infoVisible) {
                var bannerMsk = document.getElementById('tlg-info-banner-mask');
                var cssClass = bannerMsk.className;
                cssClass += ' show-tlg';
                bannerMsk.className = cssClass;
            }
            resetTimer();
            document.getElementById('olg-strapline').className = 'hidden';
            document.getElementById('zapping-banner').className = 'hidden';
            document.getElementById('tlg-strapline').className = '';
            document.getElementById('tlgGuideMask').className = 'tlgGuideMask';
            document.getElementById('tlg-grad').className = '';
            oipfChannelList.setCurrentPos();
            var curIndex = oipfChannelList.findListPosByCCID(oipfChannelList._currentCCID);
            focusRow = curIndex % 3;
            topRow = Math.floor(curIndex/3)*3;
            try{
                document.getElementById(ui.column + (focusRow+1)).className += ' focused';
            }catch(e){
                //ignore
            }
            getPage();
        }
    };
//    resetTimer();

    function clearEmptyRows(rows) {
        var empty_rows = 3 - rows,
            i, highlight,
            index = rows + 1;

        for (i = 0; i < empty_rows; i++) {
            document.getElementById('chlogo' + index + '-label').innerHTML = '';
            document.getElementById('chlogo'+ index + 'img').setAttribute('src', 'noimage');
            highlight= document.getElementById('chlogo'+ index + 'bg');

            if (highlight.className.indexOf('highlight') !== -1) {
                highlight.className = highlight.className.replace(' highlight', '');
            }
            index += 1;
        }
    }

    var currentPage = [-1,-1,-1];
    var getPage = function(dir) {
        try{
            var oipfChannelListLength = oipfChannelList.getLength(),
                rows = 1;

            if (topRow+1 < oipfChannelListLength) {
                rows += 1;

                if (topRow+2 < oipfChannelListLength) {
                    rows += 1;
                }
            }
            pageRows = rows;

            if (dir === 'up') {
                focusRow = rows - 1;
            }
            ++linesToRender;
            guideCreateLine(topRow,1);
            if (topRow+1 < oipfChannelListLength) {
                ++linesToRender;
                guideCreateLine(topRow+1,2);
                if (topRow+2 < oipfChannelListLength) {
                    ++linesToRender;
                    guideCreateLine(topRow+2,3);
                }else{
                    currentPage[2] = -1;
                }
            }else{
                currentPage[1] = -1;
            }
            if (rows < 3) { // Clear empty channel logos
                clearEmptyRows(rows);
            }
        }catch(e){
            clearGuide();
        }
    };
    
    function clearAllTimeouts() {
        clearTimeout(ui.timeout);
        clearTimeout(ui.no_data_timeout);
    }

    function hide3LG() {
        ui.clearClockUpdate();
        state_olg = true;
        try{
            var ele = document.getElementById(ui.column + (focusRow+1));
            ele.className = ele.className.split(' ')[0];
            document.getElementById('olg-strapline').className = '';
            document.getElementById('zapping-banner').className = '';
            document.getElementById('tlg-strapline').className = 'hidden';
            document.getElementById('tlgGuideMask').className = 'tlgGuideMask hidden';
            document.getElementById('tlg-grad').className = 'hidden';
            linesToRender = 0;
        }catch(e){
            clearGuide();
        }

    }
    function resetTimer(){
        if (!ui.infoVisible) {
            if (ui.timeout) {
                clearTimeout(ui.timeout);
            }
            var stateMultiplier = (state_olg)?1:3;
            timeoutDuration = ((stateMultiplier  *config.LOCAL_VARS.ui_banner_timeout) * 1000);
            ui.timeout = setTimeout(ui.toggle, timeoutDuration);
        }
    }
    function onKey(evt){
        if(state_olg){
            olgKey(evt);
        }else{
            tlgKey(evt);
        }
    }
    function updateInfoPanel(){
        try{
            var ccid = 'ccid:'+document.getElementById('ch'+String(focusRow+1)).innerHTML;
            var channel = oipfChannelList.getItem(oipfChannelList.findListPosByCCID(ccid)),
                channelName = channel.name || '',
                progs = oipfChannelList.getProgrammes(topRow + focusRow),
                ind = (ui.column==='now')?0: 1,
                selected = progs[ind],
                programmeName = selected.name || '',
                description = selected.description || 'No description available',
                episode = selected.episode;

            channelChanger.updateInfoPanel(selected, episode, channelName, programmeName, description);
        }catch(e){
            //data not ready yet
            this.upInterval = setInterval(retryUpdateInfo, 100);
        }
    }
    function retryUpdateInfo(){
        clearInterval(this.upInterval);
        updateInfoPanel();
    }

    function tlgKey(evt){
        var ele;

        switch (evt.keyCode){
            case 13: //KEY_OK
                if(action_menu){
                    var action = document.getElementById('tlg-Highlight').innerHTML;
                    if(action === 'Close menu'){
                        clearActionMenu();
                    }else{
                        var ccid = 'ccid:'+document.getElementById('ch'+String(focusRow+1)).innerHTML;
                        clearGuide();
                        channelChanger.changeToChannel(ccid);
                    }
                }else{
                    if(ui.column === 'now'){
                        try{
                            if (ui.infoVisible) {
                                ui.toggleInfo();
                            }
                            clearTimeout(ui.timeout);
                            action_menu = true;
                            var aItem = document.getElementById(ui.column + (focusRow+1));
                            aItem.className = aItem.className.replace(' focused', '');
                            document.getElementById(ui.column + (focusRow+1)).className += ' disable';
                            var menu = document.getElementById('tlg-SelectionMenu');
                            menu.style.top = String(-46 + (focusRow * 50)) + 'px';
                            menu.className = '';
                        }catch(e){
                            clearGuide()
                        }
                    }else{
                        resetTimer();
                    }

                }
                break;
            case 38: //KEY_UP;
                if(action_menu){
                    actionSwap();
                }else{
                    try{
                        resetTimer();
                        if(focusRow>0){
                            ele = document.getElementById(ui.column + (focusRow+1));
                            ele.className = ele.className.split(' ')[0];
                            moveChannel(focusRow-1);
                            --focusRow;
                            document.getElementById(ui.column + (focusRow+1)).className += ' focused';
                        }else{
                            if(!pagingBusy()){
//                                linesToRender=3;
                                clearTLG();
                                ele = document.getElementById(ui.column + (focusRow+1));
                                ele.className = ele.className.split(' ')[0];
                                if(topRow>2){
                                    topRow -= 3;
                                }else{
                                    var len = oipfChannelList.getLength();
                                    topRow = Math.floor(len/3)*3;
                                    if(topRow === len){
                                        topRow-=3;
                                    }
//                                    if(topRow - len < 3)linesToRender = topRow - len;
                                }
                                getPage('up');
                                document.getElementById(ui.column + (focusRow+1)).className += ' focused';
                            }
                        }
                        updateInfoPanel();
                    }catch(e){
                        clearGuide();
                    }
                }
                break;
            case 40: //KEY_DOWN;
                if(action_menu){
                    actionSwap();
                }else{
                    try{
                        resetTimer();
                        if (focusRow < (pageRows - 1)) {
                            ele = document.getElementById(ui.column + (focusRow+1));
                            ele.className = ele.className.split(' ')[0];
                            moveChannel(focusRow+1);
                            ++focusRow;
                            document.getElementById(ui.column + (focusRow+1)).className += ' focused';
                        } else {
                            if(!pagingBusy()){
//                                linesToRender=3;
                                clearTLG();
                                ele = document.getElementById(ui.column + (focusRow+1));
                                ele.className = ele.className.split(' ')[0];
                                if(topRow+3<oipfChannelList.getLength()){
                                    topRow += 3;
                                }else{
                                    topRow = 0;
                                }
                                focusRow = 0;
                                getPage('down');
                                document.getElementById(ui.column + (focusRow+1)).className += ' focused';
                            }
                        }
                        updateInfoPanel();
                    }catch(e){
                        clearGuide();
                    }
                }
                break;
            case 37: //KEY_LEFT;
                if(!action_menu){
                    resetTimer();
                    if(ui.column === 'next'){
                        ele = document.getElementById(ui.column + (focusRow+1));
                        ele.className = ele.className.split(' ')[0];
                        ui.column = 'now';
                        document.getElementById(ui.column + (focusRow+1)).className += ' focused';
                        updateInfoPanel();
                    }
                }
                break;

            case 39: //KEY_RIGHT;
                if(!action_menu){
                    resetTimer();
                    if(ui.column === 'now'){
                        ele = document.getElementById(ui.column + (focusRow+1));
                        ele.className = ele.className.split(' ')[0];
                        ui.column = 'next';
                        document.getElementById(ui.column + (focusRow+1)).className += ' focused';
                        updateInfoPanel();
                    }
                }
                break;
            case 33: //KEY_KEYBOARD_PAGE_UP;
                clearGuide();
                channelChanger.channelUp();
                break;
            case 34: //KEY_KEYBOARD_PAGE_DOWN;
                clearGuide();
                channelChanger.channelDown();
                break;
            case 461: // Back button
                if(action_menu){
                    clearActionMenu();
                }else{
                    clearGuide();
                }
                break;
            case 457: // Info button
                if(!action_menu){
                    if (!ui.visible) {
                        channelChanger.updateAndShowBanner();
                    } else{
                        ui.toggleInfo();
                    }
                }
                break;
        }
    }
    function clearGuide(){
        if (ui.infoVisible) {
            ui.toggleInfo();
        }
        clearActionMenu();
        if (ui.visible) {
            ui.toggle();
            clearAllTimeouts();
        }
        hide3LG();
        linesToRender = 0;
    }
    function clearActionMenu(){
        try{
            var aItem = document.getElementById(ui.column + (focusRow+1));
            aItem.className = aItem.className.replace(' disable', '');
            document.getElementById(ui.column + (focusRow+1)).className += ' focused';
            action_menu = false;
            document.getElementById('tlg-SelectionMenu').className = 'hidden';
            resetTimer();
        }catch(e){
            clearGuide();
        }
    }
    function actionSwap(){
        var low = document.getElementById('tlg-Lowlight');
        var high = document.getElementById('tlg-Highlight');
        var lowTxt = low.innerHTML;
        var highTxt = high.innerHTML;
        low.innerHTML = highTxt;
        high.innerHTML = lowTxt;
    }
    function olgKey(evt){
        switch (evt.keyCode){
            case 13: //KEY_OK
                if(channelChanger && channelChanger.hideTimeout){
                    channelChanger.hideChanger();
                }else{
                    if (ui.visible) {
                        launch3LG();
                    } else {
//                    if (!ui.visible) {
                        channelChanger.updateAndShowBanner();
                    }
                }
                break;
            case 38: //KEY_UP;
            case 40: //KEY_DOWN;
                if (ui.visible) {
                    launch3LG();
                } else {
//                if (!ui.visible) {
                    channelChanger.updateAndShowBanner();
                }
                break;
            case 37: //KEY_LEFT;
                if (ui.visible) {
                    if (ui.column === 'next') {
                        channelChanger.updateAndShowBanner();
                    } else {
                        launch3LG();
                    }
                } else {
                    channelChanger.updateAndShowBanner();
                }
                break;

            case 39: //KEY_RIGHT;
                if (ui.visible) {

                    if (ui.column === 'now') {
                        ui.column = 'next';
                        channelChanger.updateProgrammes();
                        channelChanger.showBanner();
                    } else {
                        launch3LG();
                    }
                } else {
                    channelChanger.updateAndShowBanner();
                }
                break;
            case 33: //KEY_KEYBOARD_PAGE_UP;
                channelChanger.channelUp();
                break;
            case 34: //KEY_KEYBOARD_PAGE_DOWN;
                channelChanger.channelDown();
                break;

            case 461: // Back button

                if (ui.visible) {
                    ui.toggle();
                    clearAllTimeouts();
                }
                break;

            case 457: // Info button

                if (!ui.visible) {
                    channelChanger.updateAndShowBanner();
                } else {
                    ui.toggleInfo();
                 }
                break;
        }
    }

    var pagingBusy = function(){
        return (linesToRender > 0);
    };
    return{

        init: function(){
            document.onkeyup = onKey;
            setKeysetHide();
            getConfig();

            setInterval(getConfig, (30 * 60 * 1000));

            try {
                vbo = window.oipfObjectFactory.createVideoBroadcastObject();
                vbo.setAttribute('id', 'video');
                vbo.onProgrammesChanged = channelChanger.onProgrammesChanged; //onProgrammesChanged;
                vbo.onChannelChangeSucceeded = channelChanger.onChannelChange;
                document.body.appendChild(vbo);
                vbo.bindToCurrentChannel();
            } catch(e) {
            }
            channelChanger.updateAndShowBanner();
            document.getElementById('video').style.cssText = "width: 1280px; height: 720px;";

            try{
                manager = window.oipfObjectFactory.createApplicationManagerObject();
                document.body.appendChild(manager);

                configObj = window.oipfObjectFactory.createConfigurationObject();
                document.body.appendChild(configObj);
            }catch(e){
            }
            try {
                searchManager = window.oipfObjectFactory.createSearchManagerObject();
//                searchManager.onMetadataUpdate = this.onMetadataUpdate(this);
                document.body.appendChild(searchManager);
            }
            catch (e) {
            }
            oipfChannelList.init(vbo);

        }
    };
}();