
var DEBUG={
level:0,
regexp:new RegExp("\n","g"),
setLevel:function(num){
if(!(num<0)&&!(4<num)){
this.level=num;}else{
error("Illegal Debug Level.(0-4)");}
},
showLevel:function(){
console.log("\n _______________________________________");
console.log("|  \"Function Test\" <Debug Level Check>  |\n");
this.fatal("Level.1 : Fatal message ON");
this.error("Level.2 : Error message ON");
this.warn("Level.3 : Warn  message ON");
this.info("Level.4 : Info  message ON");
console.log("|_______________________________________|\n");},
fatal:function(msg){
if(1<=this.level)
console.log("  [*FATAL*] "+msg.toString().replace(this.regexp,"\n            "));},
error:function(msg){
if(2<=this.level)
console.log("  [*ERROR*] "+msg.toString().replace(this.regexp,"\n            "));},
warn:function(msg){
if(3<=this.level)
console.log("  [WARNING] "+msg.toString().replace(this.regexp,"\n            "));},
info:function(msg){
if(4<=this.level)
console.log("  [ INFO  ] "+msg.toString().replace(this.regexp,"\n            "));},
};

function append_functions(obj,functions){
for(var name in functions){
if(typeof obj[name]=="undefined"){
obj[name]=functions[name];}else if(typeof obj[name]!="function"){
throw new Error("Cannot apply \""+name+"\" function to: "+obj);}else{
}
}
};
function readFromPlist(product_id,key){
var ret=null;
http_request({url:APPLI_PATH+product_id+"/Info.plist",
sync:true,method:"GET",
onload:function(status,header,body){
try{
if(status==200){
try{
ret=body.match(new RegExp("^"+key+"=(.*)$","m"))[1];}catch(e){
ret="";}
}else{
DEBUG.warn("Cannot find \"Info.plist\" of ID="+product_id);}
}catch(e){
DEBUG.error("readFromPlist() : "+e.message);}
}
});
return ret;};
function readFromDefaultURL(key){
var file="file:///etc/server_url";
var ret=null;
http_request({url:file,
sync:true,method:"GET",
onload:function(status,header,body){
try{
if(status==200){
try{
ret=body.match("^"+key+"\\s(.*)$","m")[1];}catch(e){
ret="";}
}else{
DEBUG.warn("Cannot find \""+file+"\"");}
}catch(e){
DEBUG.error("readFromDefaultURL() : "+e.message);}
}
});
return ret;};
function apps_launch_appli(product_id,args,pos,rep){
weblink.clear();if(!rep){rep={};}
rep.action="apps";
if(pos!==undefined){
rep.pos=pos;}
var ret=readFromPlist(product_id,"pbrowser");
var rval=apputil.launch_apl(product_id,args,null,rep,null,null,null,null,ret);
switch(rval){
case apputil.CODE.SUCCESS:
case apputil.CODE.ALREADY_LAUNCHED:
case apputil.CODE.WAIT_IP_AVAILABLE:
return;
case apputil.CODE.NO_MODULE:
DEBUG.info("This product("+product_id+") has only a gadget.");
throw new Error("MSG:"+LANG("LT_APPS_GADGET_MESSAGE"));
return;
case apputil.CODE.INSTALLING:
DEBUG.info("This product("+product_id+") is installing.");
throw new Error("MSG:"+LANG("LT_APPS_INSTALLING_MESSAGE"));
return;
case apputil.CODE.COMING_SOON:
DEBUG.info("This product("+product_id+") is coming soon.");
throw new Error("MSG:"+LANG("LT_APPS_COMING_SOON_MESSAGE"));
return;
case apputil.CODE.NV_FULL:
DEBUG.info("This product("+product_id+") is installing.");
throw new Error("MSG:"+LANG("LT_APPS_INSTALLING_MESSAGE"));
return;
case apputil.CODE.NO_INFO_PLIST:
DEBUG.fatal("Cannot read from \"Info.plist\". Please check "+product_id+".");
return;
case apputil.CODE.NETWORK_ERROR:
DEBUG.info("Cannot judge firmware is the latest or not.");
return;
case apputil.CODE.NETWORK_DL_CONFIRM:
DEBUG.info("Need to update.");
return;
case apputil.CODE.DISCLAIMER:
DEBUG.info("--------- show DISCLAIMER !");
return;
case apputil.CODE.LOCKED:
DEBUG.info("LOCKED: "+product_id);
var err=new Error("PASS:"+product_id);
err.report=rep;
throw err;
break;
case apputil.CODE.NO_PRODUCT_ID:
case apputil.CODE.LAUNCH_ERROR:
case apputil.CODE.NETWORK_DL_PREPARE:
return;
default:
console.log(" unknown return code: "+rval);
return;}
return;};
function isIN(x,y,pos,size){return (
(pos[0]-size[0]/2<x) && (x<pos[0]+size[0]/2)
&&(pos[1]-size[1]/2<y) && (y<pos[1]+size[1]/2)
);};


function AppsPlate(focus_moveto,marquee_obj,delay){
this.superClass=container;
this.superClass({
rotation:[0,1,0,0],
components:[
],
});
this.focus_moveto=focus_moveto;
this.marquee=marquee_obj;
this.item=[];
if(delay==true){

}else{
this.makeInstance();}
};
AppsPlate.prototype=new container({});
AppsPlate.prototype.width=0;
AppsPlate.prototype.height=0;
AppsPlate.prototype.cursor=0;AppsPlate.prototype.old_cursor=0;AppsPlate.prototype.show_lock=false;AppsPlate.prototype.show_remove=false;AppsPlate.prototype.show_restrict=false;AppsPlate.prototype.show_mkt=false;AppsPlate.prototype.disable_func=null;AppsPlate.prototype.item=null;AppsPlate.prototype.focus_moveto=null;AppsPlate.prototype.marquee=null;
AppsPlate.prototype.select_focus=null;
AppsPlate.prototype.INTERVAL_H=235;
AppsPlate.prototype.INTERVAL_V=172;AppsPlate.prototype.SELECTED_FOCUS_COLOR=[255,40,40,255];
AppsPlate.prototype.init=function(){
for(var i=0;i<this.item.length;i++){
this.item[i].init();}
this.selectCurrentProduct(false);};
AppsPlate.prototype.makeInstance=function(){
if(this.item.length!=0)return;
var icon=null;
for(var i=0;i<21;i++){
icon=new ApplicationIcon();
icon.translate=[this.INTERVAL_H*(i%7-3),
-this.INTERVAL_V*(Math.floor(i/7)-1)+20,0];
this.components.push(icon);
this.item.push(icon);}
force_redraw();};
AppsPlate.prototype.addApps=function(list,sync,page_index){
for(var i=0;i<this.item.length;i++){
if(this.disable_func!=null){
this.item[i].setDisableFunc(this.disable_func);}
if(i<list.length){
if(page_index===undefined){this.item[i].setProduct(list[i],this.marquee,sync,i);}else{this.item[i].setProduct(list[i],this.marquee,sync,7+page_index*21+i);}
}else{
this.item[i].init();}
}
this.marquee.setVisible(false);};
AppsPlate.prototype.showLockState=function(b){
this.show_lock=b;
this.makeInstance();
this.item.forEach(function(val){val.showLockState(b);});};
AppsPlate.prototype.showRemoveState=function(b){
this.show_remove=b;
this.makeInstance();
this.item.forEach(function(val){val.showRemoveState(b);});};
AppsPlate.prototype.showRestrictedState=function(b){
this.show_restrict=b;
this.makeInstance();
var self=this;
this.item.forEach(function(val){val.showRestrictedState(b,self.marquee);});};
AppsPlate.prototype.showMarketIcon=function(b){
this.show_mkt=b;
this.makeInstance();
this.item.forEach(function(val){val.showMarketIcon(b);});};
AppsPlate.prototype.setDisableFunc=function(func){
this.disable_func=func;};
AppsPlate.prototype.updateIcons=function(){
var self=this;
this.item.forEach(function(val){val.update(self.marquee);});};
AppsPlate.prototype.setFocus=function(b,keysym,pos){
var line=Math.floor(pos/7);
if(b==true){
switch(keysym){
case TXK_UP:
this.cursor=7*2+pos;
break;
case TXK_LEFT:
this.cursor=6+7*line;
break;
case TXK_RIGHT:
this.cursor=0+7*line;
break;
default:
if(isNaN(pos)==false){
this.cursor=pos;}
break;}
if(this.cursor==-1){
this.cursor=this.old_cursor;}
this.correctFocus((keysym==-1));
try{
this.item[this.cursor].setFocus(b,keysym);}catch(e){
DEBUG.warn("AppsPlate.setFocus("+b+","+keysym+","+pos+")\n"+e.message);}
return this.cursor;}else{if(this.cursor==-1){
this.cursor=this.old_cursor;}
var ret=this.cursor;
this.marquee.setVisible(false);
this.item[this.cursor].setFocus(b,keysym);
this.old_cursor=this.cursor;
this.cursor=-1;
return ret;}
};
AppsPlate.prototype.key_hook=function(updown,keysym){
if(updown!=KEY_PRESS)return false;
switch(keysym){
case TXK_LEFT:
if(this.cursor%7==0){
return false;}
this.item[this.cursor].setFocus(false,keysym);
this.cursor--;
this.item[this.cursor].setFocus(true,keysym);
this.correctFocus();
return true;
case TXK_RIGHT:
if(this.cursor%7==6){
return false;}else if(this.cursor==this.item.length-1){
return false;}
this.item[this.cursor].setFocus(false,keysym);
this.cursor++;
this.item[this.cursor].setFocus(true,keysym);
this.correctFocus();
return true;
case TXK_UP:
if(this.cursor<7){
return false;}
this.item[this.cursor].setFocus(false,keysym);
this.cursor-=7;
this.item[this.cursor].setFocus(true,keysym);
this.correctFocus();
return true;
case TXK_DOWN:
if(this.cursor>=this.item.length-7){
return false;}
this.item[this.cursor].setFocus(false,keysym);
this.cursor+=7;
this.item[this.cursor].setFocus(true,keysym);
this.correctFocus();
return true;
case TXK_ENTER:
try{
return this.item[this.cursor].launch_appli();}catch(e){
throw e;
}
default:
}
return false;};
AppsPlate.prototype.point_hook=function (type,identifier,x,y,screenX,screenY){
if(type=="touchmove")return false;
DEBUG.warn("AppaPlate.prototype.point_hook = function ("
+type+", "+identifier+", "+x+", "+y+", "
+screenX+", "+screenY+"){");
var pos=null;
var size=null;
var tmp=-1;
for(var i=0;i<this.item.length;i++){
pos=this.item[i].getFocusPosition();
size=this.item[i].getFocusSize();
if(isIN(x,y,pos,size)==true){
tmp=i;
break;}
}
if(tmp==-1){
return false;}else if(tmp==this.cursor){
if(type=="touchend"){
HOME_SOUND_PLAY("enter");
this.key_hook(KEY_PRESS,TXK_ENTER);
return true;}else{
return false;}
}else{
if(type=="touchstart"){
try{
this.item[this.cursor].setFocus(false);}catch(e){
DEBUG.warn("AppsPlate.prototype.point_hook()\nthis.cursor = "+this.cursor+"\n"+e.message);}
HOME_SOUND_PLAY(0);
this.cursor=tmp;
this.correctFocus();
return true;}else{
return false;}
}
};
AppsPlate.prototype.setPartialView=function(b){
this.visible_p=!b;
return;

};
AppsPlate.prototype.setCurrentLockState=function(b){
this.item[this.cursor].setLockState(b);};
AppsPlate.prototype.getCurrentProduct=function(){
return [this.cursor,this.item[this.cursor].getProduct(),this.item[this.cursor].lockable,this.item[this.cursor].removable,this.item[this.cursor].restricted,];};
AppsPlate.prototype.selectCurrentProduct=function(b){
if(b==true){
if(this.select_focus==null){
this.select_focus=new Focus({color:this.SELECTED_FOCUS_COLOR,bold:true});
for(var i=0,max=this.select_focus.components.length;i<max;i++){
this.select_focus.components[i].depth_test=true;}
this.select_focus.visible_p=false;
this.components.push(this.select_focus);}
var tmp=this.item[this.cursor].getFocusSize();
this.select_focus.setSize(tmp[0]-4,tmp[1]-4);
this.select_focus.translate=this.item[this.cursor].getFocusPosition();
this.select_focus.visible_p=true;
return this.cursor;}else{
if(this.select_focus!=null){
this.select_focus.visible_p=false;}
}
};
AppsPlate.prototype.set_select_focus=function(index){
var tmp=this.item[index].getFocusSize();
this.select_focus.setSize(tmp[0]-4,tmp[1]-4);
this.select_focus.translate=this.item[index].getFocusPosition();
this.select_focus.visible_p=true;
return this.cursor;};
AppsPlate.prototype.correctMarquee=function(){
if(this.cursor!=-1){
if(this.marquee.setTitleObject(this.item[this.cursor].getTitleObject())==true){
var ret=this.item[this.cursor].setTitleVisible(false);
if(ret==true)this.marquee.setVisible(true);}
}
};
AppsPlate.prototype.correctFocus=function(not_move_focus){
var pos=this.item[this.cursor].getTranslate();
this.item[this.cursor].setTitleVisible(true);
this.marquee.setVisible(false);
this.marquee.setTranslate(pos[0],pos[1]+this.item[this.cursor].TITLE_Y,pos[2]);
var me=this;
if(not_move_focus==true){
}else{
this.focus_moveto(this.item[this.cursor].getFocusPosition(),
this.item[this.cursor].getFocusSize(),
null,null,
function(focus){
focus.visible_p=true;
me.correctMarquee();});}
};
append_functions(AppsPlate.prototype,GraphicsLib);
append_functions(AppsPlate.prototype,AnimationLib);
if(system.mdl_cfg.apps_context!=system.mdl_cfg.APPS_CONTEXT_SURFER){
AppsPlate.prototype.TIME_INTERVAL=20;}
if(SU_IS_SLOW_ANIM){
AppsPlate.prototype.moveTo=AnimationLib.moveToDirect;}

function ApplicationIcon(){
this.superClass=container;
this.superClass({
components:[
this.back=new container({
translate:[0,this.ICON_Y,0],
components:[
new gbox({color:system.fdp_color.BASE_SUB_A,
width:160,height:112,
round_enable:true,round_width:6,round_height:6,
}),
this.market_icon=new gimage({width:160,height:112,
color:this.MARKET_ICON_COLOR,
src:this.MARKET_ICON_IMG,
visible_p:false,
}),
]}),
this.dummy_icon=new container({}),
this.icon=new gimage({width:160,height:112,translate:[0,this.ICON_Y,0],
blend:true,
onload:this.icon_onload,onerror:this.icon_onerror,depth_test:true}),
this.title=new gtext({width:this.TITLE_W,height:this.TITLE_H,
font_size:this.TITLE_FONT_SIZE,redraw:false,
color:this.TITLE_COLOR,omitter:"...",
translate:[0,this.TITLE_Y,0],align:CENTER,depth_test:true
}),
this.lock=new gimage({src:"",
onload:ApplicationIcon.prototype.NULL_FUNC,
translate:[108,70-12,0],depth_test:true,
width:38,height:34,
}),
]
});
if((system.mdl_cfg.with_pen_support_web_browser||system.mdl_cfg.with_pen_support_startup_ui)==true){
this.components.push(
this.pen=new gimage({src:"",
onload:ApplicationIcon.prototype.NULL_FUNC,
translate:[102,-8-14,0],depth_test:true,
})
);}
this.icon.parent=this;
this.dummy_icon.parent=this;
this.init();};
ApplicationIcon.prototype=new container({});
ApplicationIcon.prototype.BASE_HOST="";ApplicationIcon.prototype.LOCKED_LIST=null;
ApplicationIcon.prototype.LOCKED_IMG=IMG_PATH+"locked.png";
ApplicationIcon.prototype.PEN_IMG=IMG_PATH+"touchpen_support.png";
ApplicationIcon.prototype.MARKET_ICON_IMG=APPLI_PATH+APPMARKET_APPS+"/icon.png";
ApplicationIcon.prototype.MARKET_ICON_COLOR=[160,160,160,100];
ApplicationIcon.prototype.ICON_Y=20;
ApplicationIcon.prototype.NULL_FUNC=function(){};
ApplicationIcon.prototype.TITLE_FONT_SIZE=26;
ApplicationIcon.prototype.TITLE_W=AppsPlate.prototype.INTERVAL_H-21;
ApplicationIcon.prototype.TITLE_H=40;
ApplicationIcon.prototype.TITLE_Y=-58;
ApplicationIcon.prototype.TITLE_COLOR=system.fdp_color.TEXT_ONBASE;
ApplicationIcon.prototype.TITLE_GRAYOUT_COLOR=system.fdp_color.BASE_SUB;
ApplicationIcon.prototype.ICON_NORMAL_COLOR=[255,255,255,255];
ApplicationIcon.prototype.ICON_GRAYOUT_COLOR=[80,80,80,255];
ApplicationIcon.prototype.apps_name="";ApplicationIcon.prototype.product_id=null;ApplicationIcon.prototype.req_id=-1;ApplicationIcon.prototype.position=-1;ApplicationIcon.prototype.back=null;ApplicationIcon.prototype.market_icon=null;ApplicationIcon.prototype.dummy_icon=null;ApplicationIcon.prototype.icon=null;ApplicationIcon.prototype.lock=null;ApplicationIcon.prototype.pen=null;ApplicationIcon.prototype.title=null;ApplicationIcon.prototype.show_lock=false;ApplicationIcon.prototype.lockable=false;ApplicationIcon.prototype.locked=null;ApplicationIcon.prototype.show_remove=false;ApplicationIcon.prototype.removable=false;ApplicationIcon.prototype.removed=null;ApplicationIcon.prototype.show_restrict=false;ApplicationIcon.prototype.disable_func=null;ApplicationIcon.prototype.show_mkt=false;ApplicationIcon.prototype.restricted=false;ApplicationIcon.prototype.restrict=null;ApplicationIcon.prototype.onFocusFlg=false;

ApplicationIcon.prototype.icon_onload=function(){
this.parent.back.visible_p=true;
if(this.draw_flag==true){
delete(this.draw_flag);
force_redraw();}
};
ApplicationIcon.prototype.icon_onerror=function(){
this.parent.back.visible_p=false;
this.parent.dummy_icon.visible_p=true;
if(this.parent.dummy_icon.components.length==0){
this.parent.dummy_icon.components.push(
new gbox({width:160,height:112,round_enable:true,round_width:8,round_height:8,
color:[127,127,127,255],translate:[0,this.parent.ICON_Y,0],}),
new gtextbox({width:152,height:108,
align:CENTER,valign:MIDDLE,font_size:22,
color:[40,40,40,255],translate:[0,this.parent.ICON_Y,0],})
);}
setf_text(this.parent.dummy_icon.components[1],this.parent.app_name);};
ApplicationIcon.prototype.init=function(){
this.product_id=null;
this.position=ApplicationIcon.prototype.position;
this.app_name="";
this.back.visible_p=true;
this.dummy_icon.visible_p=false;
this.icon.src="";
setf_text(this.title,"");
this.lockable=false;
this.lock.src="";
this.locked=false;
this.removable=false;
this.removed=false;
this.restricted=false;
this.restrict=false;
if(this.pen!=null){
this.pen.visible_p=false;}
cancel_http_request(this.req_id);};
ApplicationIcon.prototype.getProduct=function(){
return this.product_id;};
ApplicationIcon.prototype.showLockState=function(b){
this.show_lock=b;
this.correctLockState();};
ApplicationIcon.prototype.showRemoveState=function(b){
this.show_remove=b;
this.correctRemoveState();};
ApplicationIcon.prototype.showRestrictedState=function(b,marqueeObj){
this.show_restrict=b;
this.correctRestrictedState(marqueeObj);};
ApplicationIcon.prototype.setDisableFunc=function(func){
this.disable_func=func;};
ApplicationIcon.prototype.showMarketIcon=function(b){
this.show_mkt=b;};
ApplicationIcon.prototype.update=function(MarqueeObj){
if(this.product_id==null)return;
if(typeof this.icon.src=="string")return;
this.correctInfo(MarqueeObj);};
ApplicationIcon.prototype.setProduct=function(id,MarqueeObj,sync,pos){
if(this.product_id!=id){
this.init();}else{
this.product_id=null;
this.app_name="";
this.back.visible_p=true;
this.dummy_icon.visible_p=false;
this.locked=false;
this.removed=false;
this.restrict=false;}
if(!id){
this.icon.src="";
setf_text(this.title,"");
return;}
this.product_id=id;
this.position=pos;
this.correctInfo(MarqueeObj,sync);};
ApplicationIcon.prototype._get_property=function(info_plist,key){try{
if(info_plist.match(new RegExp("^"+key+"=(.*)$","m"))[1]=="true"){
return true;}else{
return false;}
}catch(e){
return false;}
};
ApplicationIcon.prototype.correctInfo=function(MarqueeObj,sync){
var id=this.product_id;
var me=this;
this.req_id=http_request({url:APPLI_PATH+id+"/Info.plist",
sync:!!sync,method:"GET",
onload:function(status,header,body){
try{
if(status==200){
var title="";
try{
title=body.match(new RegExp("^title."+system.locale.language.substr(0,5)+"=(.*)$","m"))[1];}catch(ex_no_key){
try{
title=body.match(new RegExp("^title."+system.locale.language.substr(0,2)+"=(.*)$","m"))[1];}catch(ex_never_key){
try{
title=body.match(new RegExp("^title=(.*)$","m"))[1];}catch(ex_no_title){
DEBUG.error("No title in \"Info.plist\". Please check ID="+me.product_id);
title=id;}
}
}
if(me.app_name!=title){
me.app_name=title;
setf_text(me.title,me.app_name);}
me.lockable=me._get_property(body,"lockable");
me.removable=me._get_property(body,"removable");
me.restricted=me._get_property(body,"restricted");
if(me.pen!=null){
if(me._get_property(body,"touchpen")==true){
me.pen.src=ApplicationIcon.prototype.PEN_IMG;
me.pen.visible_p=true;}else{
me.pen.visible_p=false;}
}
if(ApplicationIcon.prototype.LOCKED_LIST==null){
var tmp=readFromNV2List("locked_list");
ApplicationIcon.prototype.LOCKED_LIST=((tmp==null)?[]:tmp);}
me.locked=ApplicationIcon.prototype.LOCKED_LIST.some(
function(val){return (val==id);}
);
me.correctLockState();
if(me.show_remove==true){
me.correctRemoveState();}
me.correctRestrictedState(MarqueeObj);
if(!MarqueeObj.getVisible()&&me.onFocusFlg&&!(me.restricted&&me.show_restrict)){
if(MarqueeObj.setTitleObject(me.title)==true){
me.title.visible_p=false;
MarqueeObj.setVisible(true);}
}
try{
var matching=body.match(new RegExp("^latest_check=(installing|coming_soon)$","m"));
if(matching==null){
if(me.icon.src!=APPLI_PATH+id+"/icon.png"){
if(!isString(me.icon.src)){
me.icon.src="";
me.icon.draw_flag=true;}else if(SU_IS_SLOW_ANIM){
me.icon.draw_flag=true;}
me.icon.src=APPLI_PATH+id+"/icon.png";}
}else{http_request({url:APPLI_PATH+id+"/icon.png",
sync:!false,method:"GET",
onload:function(status,header,bin){
if(status==200){
me.icon.src="";
me.icon.draw_flag=true;
me.icon.src=bin;
console.log("me.icon.src = bin;@correctInfo "+me.product_id);
bin.length=0;}
}
});}
}catch(e){
me.icon.src=APPLI_PATH+id+"/icon.png";}
}else{
DEBUG.error("Cannot find \"Info.plist\" of ID="+me.product_id);
me.app_name="[E-"+id+"]";
setf_text(me.title,me.app_name);
me.lockable=false;
me.removable=false;
me.restricted=false;}
}catch(e){
DEBUG.error(e.message);}
}
});};
ApplicationIcon.prototype.setLockState=function(b){
this.locked=b;
this.correctLockState();};
ApplicationIcon.prototype.correctLockState=function(){
if(this.show_lock==true){
if(this.lockable==false){
this.icon.color=this.ICON_GRAYOUT_COLOR;
this.title.color=this.TITLE_GRAYOUT_COLOR;}else{
this.icon.color=this.ICON_NORMAL_COLOR;
this.title.color=this.TITLE_COLOR;}
}else{
if(this.disable_func!=null){
this.setEnable(!this.disable_func(this.product_id,this));}else{
this.icon.color=this.ICON_NORMAL_COLOR;
this.title.color=this.TITLE_COLOR;}
}
if(this.locked==true){
if(!((this.show_restrict==true)&&(this.restricted==true))){
this.lock.src=this.LOCKED_IMG;}else{
this.lock.src="";}
}else{
this.lock.src="";}
};
ApplicationIcon.prototype.setRemoveState=function(b){
this.removed=b;
this.correctRemoveState();};
ApplicationIcon.prototype.correctRemoveState=function(){
if(this.show_remove==true){
if((this.removable==false)||
((this.show_restrict==true)&&(this.restricted==true))){
this.icon.color=this.ICON_GRAYOUT_COLOR;
this.title.color=this.TITLE_GRAYOUT_COLOR;}else{
this.icon.color=this.ICON_NORMAL_COLOR;
this.title.color=this.TITLE_COLOR;}
}else{
this.icon.color=this.ICON_NORMAL_COLOR;
this.title.color=this.TITLE_COLOR;}
};
ApplicationIcon.prototype.setRestrictedState=function(b,marqueeObj){
this.restrict=b;
this.correctRestrictedState(marqueeObj);};
ApplicationIcon.prototype.correctRestrictedState=function(MarqueeObj){
var MarqueeVisibleFlg=false;
if(MarqueeObj){
MarqueeVisibleFlg=MarqueeObj.getVisible();}
if(this.show_restrict==true){
if(this.restricted==true){
this.icon.visible_p=false;
this.title.visible_p=false;
if(this.onFocusFlg){
MarqueeObj.setVisible(false);}
}else{
this.icon.visible_p=true;
if(!(this.onFocusFlg&&MarqueeVisibleFlg)){
this.title.visible_p=true;}else{
this.title.visible_p=false;}
}
}else{
this.icon.visible_p=true;
if(!(this.onFocusFlg&&MarqueeVisibleFlg)){
this.title.visible_p=true;}else{
this.title.visible_p=false;}
}
if(this.locked==true){
if(!((this.show_restrict==true)&&(this.restricted==true))){
if(this.lock.src!=this.LOCKED_IMG){
this.lock.src=this.LOCKED_IMG;}
}else{
this.lock.src="";}
}else{
this.lock.src="";}
};
ApplicationIcon.prototype.setEnable=function(b){
if(b==true){
this.icon.color=this.ICON_NORMAL_COLOR;
this.title.color=this.TITLE_COLOR;}else{
this.icon.color=this.ICON_GRAYOUT_COLOR;
this.title.color=this.TITLE_GRAYOUT_COLOR;}
};
ApplicationIcon.prototype.getTitleObject=function(){
return this.title;};
ApplicationIcon.prototype.setTitleVisible=function(b){
var ret=true;
if(!((this.show_restrict==true)&&(this.restricted==true))){
this.title.visible_p=b;}else{
ret=false;}
return ret;};
ApplicationIcon.prototype.setFocus=function(b,keysym){
if(b==true){
this.onFocusFlg=true;}else{this.onFocusFlg=false;
if(!((this.show_restrict==true)&&(this.restricted==true))){
this.title.visible_p=true;}
}
if((this.show_mkt==true)&&(this.product_id==null)){
this.market_icon.visible_p=b;}
};
ApplicationIcon.prototype.getFocusPosition=function(){
return [this.translate[0]+this.icon.translate[0],
this.translate[1]+this.icon.translate[1],
this.translate[2]+this.icon.translate[2],
];};
ApplicationIcon.prototype.getFocusSize=function(){
return [this.icon.width+4,this.icon.height+4];};
ApplicationIcon.prototype.launch_appli=function(){
if(this.product_id==null){
if(this.market_icon.visible_p){
return apps_launch_appli(APPMARKET_APPS,null,this.position,{empty_space:"true"});}else{
return false;}
}
if((this.show_restrict==true)&&(this.restricted==true))return false;
return apps_launch_appli(this.product_id,null,this.position);};
append_functions(ApplicationIcon.prototype,GraphicsLib);


function AdBanner(defalt_img,img_number){
this.superClass=container;
this.superClass({
components:[
this.back=new container({
components:[
new gbox({width:this.width+12,height:this.height+12,
color:system.fdp_color.BTN_BORDER,
round_enable:true,round_width:2,round_height:2}),
new gbox({width:this.width+8,height:this.height+8,
color:system.fdp_color.BASE}),
]})
]
});
this.defalt_img=defalt_img;
this.img_cnt=img_number;
var self=this;
var onerror_func=function(){
if(this.src!=self.defalt_img){
this.src=self.defalt_img;}
}
this.ad_back=new gimage({blend:true,onerror:onerror_func,
width:500,height:180});
this.ad=new gimage({src:this.defalt_img,blend:true,onerror:onerror_func,
width:500,height:180});
this.components.push(this.ad_back,this.ad);
append_functions(this.ad,GraphicsLib);
append_functions(this.ad,AnimationLib);};
AdBanner.prototype=new container({});
AdBanner.prototype.back=null;AdBanner.prototype.title=null;AdBanner.prototype.ad=null;AdBanner.prototype.ad_back=null;AdBanner.prototype.width=500;
AdBanner.prototype.height=180;
AdBanner.prototype.do_get_handle=-1;AdBanner.prototype.ad_info=[];AdBanner.prototype.anim_cnt=0;AdBanner.prototype.img_cnt=-1;AdBanner.prototype.img_src=null;AdBanner.prototype.cash_img=[];
AdBanner.prototype.cash_img_length=0;
AdBanner.prototype.start_flg=false;
AdBanner.prototype.BASE_HOST="";AdBanner.prototype.product_id=APPMARKET_APPS;
AdBanner.prototype.setAdImage=function(img_url){
if(this.img_src==null)this.ad.src=img_url;
this.ad_back.src=img_url;
this.img_src=img_url;};
AdBanner.prototype.resetAdImage=function(){
this.ad.src="";
this.ad_back.src="";
this.img_src="";};
AdBanner.prototype.setText=function(b){
if(b==true){
this.components.push(
this.title=new gtextbox({width:448,height:100,font_size:26,style:BOLD,
align:LC_TEXT_ALIGN,valign:MIDDLE,
text:LANG("LT_VC_LEAD_MES1"),
translate:[0,32,0],color:[40,40,40,255]})
);}else{
try{
this.title.visible_p=false;}catch(e){
}
}
};
AdBanner.prototype.cashImg=function(){
this.cash_img=[];
this.cash_img_length=this.ad_info.length;
var testurl=readFromDefaultURL("testurl");
try{
var host=testurl.match(new RegExp("(http://[^/]*)/"))[1];}catch(e){
host=testurl.match(new RegExp("(https://[^/]*)/"))[1];
host=host.replace("https://","http://");}

var path_ad_image=host+"/catalog/advertisement/";
for(var i=0;i<this.cash_img_length;i++){
this.cash_img[i]=new gimage({src:path_ad_image+
this.ad_info[i].thumbnail});}
};
AdBanner.prototype.animation=function(obj,cnt){
if(obj.cash_img_length==0)return false;
if((cnt==60)&&(obj.start_flg==false)){
obj.start_flg=true;
if(obj.title)obj.title.visible_p=false;}
if(obj.start_flg==false)return false;
obj.anim_cnt++;
if(obj.anim_cnt<32){
if(SU_IS_SLOW_ANIM)return false;
obj.ad.setAlpha(obj.ad.getAlpha()-8);
return true;}else if(obj.anim_cnt==32){
obj.ad.src=obj.img_src;
if(SU_IS_SLOW_ANIM)return false;
obj.ad.setAlpha(255);
return true;}else if(obj.anim_cnt==100){
obj.anim_cnt=0;
obj.img_cnt++;
if(obj.img_cnt>obj.cash_img_length-1)obj.img_cnt=0;
obj.setAdImage(obj.cash_img[obj.img_cnt].src);
if(SU_IS_SLOW_ANIM){
obj.ad.setAlpha(255);
return true;}else{
return false;}
}
return false;};
AdBanner.prototype.showAnim=function(bool){
if(this.ad_info.length==0)return;
if(bool){
this.cashImg();
this.img_cnt++;
if(this.img_cnt>this.cash_img_length-1)this.img_cnt=0;
this.setAdImage(this.cash_img[this.img_cnt].src);}else{
delete_timer(this);}
};
AdBanner.prototype.setFocus=function(b){
};
AdBanner.prototype.getFocusPosition=function(){
return this.translate;};
AdBanner.prototype.getFocusSize=function(){
return [this.width+12,this.height+12];};
AdBanner.prototype.getAdInfo=function(func){
var self=this;
if(self.ad_info.length>0){
if(func){
func();}
return;}
var me=this;
var onload_func=function (status,header,body){
var pre_eval=null;
if(status==200){
try{
require("json2");
provide("json2");
pre_eval=JSON.parse(body.replace(/\u2028/g," "));
if((pre_eval.error)&&(pre_eval.error!="0")){
}else {
self.ad_info=pre_eval;
if(func){
func();}
}
}catch(e){
DEBUG.error("<<AD INFO EVAL NG>> : "+e.message);}
}else {
}
self.do_get_handle=-1;};

var host=getHostName();
var limit=4;
var request_url=host+"/market/ad-info?country="+system.locale.country+
"&language="+system.locale.language.substr(0,5)+"&limit="+limit;
var req={
"url":request_url,
"method":"GET",
"sync":false,
"onload":onload_func,
};
if(self.do_get_handle!=-1){
DEBUG.info("Cancel previous feed request handle: "+self.do_get_handle);
cancel_http_request(self.do_get_handle);}
self.do_get_handle=http_request(req);

return self.do_get_handle;}
AdBanner.prototype.launch_appli=function(){
if(this.product_id==null)return;

var args="-T -s -R -l "+"vmarket:jump=";
try{
args=args+this.ad_info[this.img_cnt].id;}catch(e){
args=args+"null";}
return apps_launch_appli(this.product_id,args);};
append_functions(AdBanner.prototype,GraphicsLib);
append_functions(AdBanner.prototype,AnimationLib);
function getMarketLogoPath(){
var path;
switch(system.locale.language.substr(0,5)){
case "ja-JP":
path=IMG_PATH+"mkt_icon_jp.png";
break;
case "fr-CA":
path=IMG_PATH+"mkt_icon_ca.png";
break;
default:
path=IMG_PATH+"mkt_icon.png";
break;}
return path;}
function MarketBanner(){
this.superClass=AdBanner;
this.superClass();
this.setAdImage(getMarketLogoPath());};
MarketBanner.prototype=new AdBanner();
MarketBanner.prototype.width=390;
MarketBanner.prototype.product_id=MARKETTOP_APPS;
MarketBanner.prototype.launch_appli=function(){
if(this.product_id==null)return;
var args="-T -R";

return apps_launch_appli(this.product_id,args);};
MarketBanner.prototype.getMarketIcon=function(sobj){
var me=this;
me.sobj=sobj;

var onload_func=function (status,header,body){
var pre_eval=null;
if(status==200){
try{
me.mkt_icon=secure_eval(body,"var NULL_FUNCTION=function(){};\n");
me.mkt_icon.set_logo(getMarketLogoPath());
me.components.push(me.mkt_icon);
me.mkt_budge=me.mkt_icon.getMarketBudge();
me.sobj.components.push(me.mkt_budge);
me.mkt_icon.activate(true);}catch(e){
console.log("MarketBanner Error = "+e.message);};};
me.do_get_handle=-1;};
var host=getHostName();
var request_url=host+
(SU_IS_4K==false?"/data/market_plus/icon/mkt_apps_icon.js"
:"/data/market_plus/icon/mkt_apps_4k2k_icon.js");
var req={
"url":request_url,
"method":"GET",
"sync":false,
"onload":onload_func,
};
if(me.do_get_handle!=-1){
DEBUG.info("Cancel previous feed request handle: "+me.do_get_handle);
cancel_http_request(me.do_get_handle);}
me.do_get_handle=http_request(req);

return me.do_get_handle;};

function AppsPlateOperator(focus_moveto){this.superClass=container;
this.superClass({
components:[

this.arrow_l=new gimage({src:IMG_PATH+"apps_arrow_l.png",translate:[-822-34,44,0],blend:true,
color:system.fdp_color.ICON_ONBASE,
width:41,height:87}),
this.arrow_r=new gimage({src:IMG_PATH+"apps_arrow_r.png",translate:[822+34,44,0],blend:true,
color:system.fdp_color.ICON_ONBASE,
width:42,height:88}),
]
});
if(system.mdl_cfg.with_pen_support_startup_ui==true){
this.components.push(
this.arrow_l_fcs=new gimage({src:IMG_PATH+"apps_arrow_l_fcs.png",translate:this.arrow_l.translate,blend:true,
width:47,height:93,visible_p:false}),
this.arrow_r_fcs=new gimage({src:IMG_PATH+"apps_arrow_r_fcs.png",translate:this.arrow_r.translate,blend:true,
width:47,height:93,visible_p:false})
);
this.arrow_l.getFocusSize=function(){return [this.width+32,this.height+64];};
this.arrow_r.getFocusSize=this.arrow_l.getFocusSize;}
var me=this;
this.focus_moveto=focus_moveto;
this.focusMoveTo=function(tra,size,angle,speed,func){
me.focus_moveto([tra[0]+me.translate[0],
tra[1]+me.translate[1],
tra[2]+me.translate[2]],
size,null,30,func);};
this.marquee=new MarqueeText();
this.page=[new AppsPlate(this.focusMoveTo,this.marquee,true),
new AppsPlate(this.focusMoveTo,this.marquee,true),
new AppsPlate(this.focusMoveTo,this.marquee),new AppsPlate(this.focusMoveTo,this.marquee,true),
new AppsPlate(this.focusMoveTo,this.marquee,true),
];
this.page.forEach(
function(val,idx,arry){
val.translate[0]=(idx-2)*AppsPlateOperator.prototype.PAGE_INTERVAL;
me.components.push(val);}
);
this.page[0].visible_p=false;
this.page[4].visible_p=false;
this.indicator=new AppsPlateIndicator(this.focusMoveTo);
this.indicator.translate[1]=-268;
this.components.push(this.indicator,this.marquee);};
AppsPlateOperator.prototype=new container({});
AppsPlateOperator.prototype.PAGE_INTERVAL=1610;
AppsPlateOperator.prototype.cursor=null;AppsPlateOperator.prototype.focus_moveto=null;AppsPlateOperator.prototype.page=null;AppsPlateOperator.prototype.page_index=0;AppsPlateOperator.prototype.select_page_index=null;AppsPlateOperator.prototype.select_index=null;AppsPlateOperator.prototype.show_lock=false;AppsPlateOperator.prototype.show_remove=false;AppsPlateOperator.prototype.show_restrict=false;AppsPlateOperator.prototype.show_mkt=false;AppsPlateOperator.prototype.disable_func=null;AppsPlateOperator.prototype.focusMoveTo=null;AppsPlateOperator.prototype.marquee=null;
AppsPlateOperator.prototype.page_data=null;AppsPlateOperator.prototype.indicator=null;AppsPlateOperator.prototype.arrow_l=null;AppsPlateOperator.prototype.arrow_r=null;
AppsPlateOperator.prototype.tmp={};
AppsPlateOperator.prototype.showLockState=function(b){
this.show_lock=b;
this.page.forEach(function(val){val.showLockState(b);});};
AppsPlateOperator.prototype.showRemoveState=function(b){
this.show_remove=b;
this.page.forEach(function(val){val.showRemoveState(b);});};
AppsPlateOperator.prototype.showRestrictedState=function(b){
this.show_restrict=b;
this.page.forEach(function(val){val.showRestrictedState(b);});};
AppsPlateOperator.prototype.showMarketIcon=function(b){
this.show_mkt=b;
this.page.forEach(function(val){val.showMarketIcon(b);});};
AppsPlateOperator.prototype.setDisableFunc=function(func){
this.disable_func=func;
this.page.forEach(function(val){val.setDisableFunc(func);});};
AppsPlateOperator.prototype.updateIcons=function(){
this.page[2].updateIcons();};
AppsPlateOperator.prototype.set_focus_moveto=function(focus_moveto){
this.focus_moveto=focus_moveto;};
AppsPlateOperator.prototype.setSizeRatio=function(ratio){
if(this.indicator){
this.indicator.setSizeRatio(ratio);}
};
AppsPlateOperator.prototype.key_hook=function(updown,keysym){
if(updown!=KEY_PRESS)return false;
if(this.cursor==this.indicator){
}else if(this.page[2].key_hook(updown,keysym)==true){
return true;}
switch(keysym){
case TXK_LEFT:
if(this.page_index==0){
return (this.cursor==this.indicator);}
var pos=this.page[2].setFocus(false,keysym);
if(this.cursor==this.indicator){
this.correctPagePositionDirect();}
this.nextPage(false);
if(this.cursor!=this.indicator){
this.page[2].setFocus(true,keysym,pos);}
return true;
case TXK_RIGHT:
if(this.page_index==this.page_data.length-1){
return (this.cursor==this.indicator);}
var pos=this.page[2].setFocus(false,keysym);
if(this.cursor==this.indicator){
this.correctPagePositionDirect();}
this.nextPage(true);
if(this.cursor!=this.indicator){
this.page[2].setFocus(true,keysym,pos);}
return true;
case TXK_UP:
if(this.cursor==this.indicator){
this.cursor.setFocus(false,keysym);
this.cursor=this.page[2];
this.page[2].setFocus(true,keysym,3);
return true;}else{
return false;}
case TXK_DOWN:
if(this.cursor!=this.indicator){
this.page[2].setFocus(false,keysym);
this.cursor=this.indicator;
this.indicator.setFocus(true,keysym);
return true;}else{
return false;}
default:
}
return false;};
AppsPlateOperator.prototype.getTranslate=function(){
return this.translate;};
AppsPlateOperator.prototype.point_hook=function (type,identifier,x,y,screenX,screenY){
if(type=="touchmove")return false;
DEBUG.warn("AppsPlateOperator.prototype.point_hook = function ("
+type+", "+identifier+", "+x+", "+y+", "
+screenX+", "+screenY+"){");
if(isIN(x,y,this.arrow_r.translate,this.arrow_r.getFocusSize())==true){
if(this.page_index==this.page_data.length-1){
return false;}
switch(type){
case "touchstart":
this.arrow_r_fcs.visible_p=true;
this.arrow_l_fcs.visible_p=false;
force_redraw();
HOME_SOUND_PLAY(0);
break;
case "touchend":
if(this.arrow_r_fcs.visible_p==false){
return false;}else{
this.arrow_r_fcs.visible_p=false;
force_redraw();}
HOME_SOUND_PLAY("enter");
var pos=this.page[2].setFocus(false,-1);
this.nextPage(true,true);
this.page[2].setFocus(true,-1,pos);
break;
default:
}
return false;}
if(isIN(x,y,this.arrow_l.translate,this.arrow_l.getFocusSize())==true){
if(this.page_index==0){
return false;}
switch(type){
case "touchstart":
this.arrow_l_fcs.visible_p=true;
this.arrow_r_fcs.visible_p=false;
force_redraw();
HOME_SOUND_PLAY(0);
break;
case "touchend":
if(this.arrow_l_fcs.visible_p==false){
return false;}else{
this.arrow_l_fcs.visible_p=false;
force_redraw();}
HOME_SOUND_PLAY("enter");
var pos=this.page[2].setFocus(false,-1);
this.nextPage(false,true);
this.page[2].setFocus(true,-1,pos);
break;
default:
}
return false;}
this.resetArrows();
var pos=this.page[2].translate;
return this.page[2].point_hook(type,identifier,x-pos[0],y-pos[1],screenX,screenY);}
AppsPlateOperator.prototype.resetArrows=function(){
this.arrow_r_fcs.visible_p=false;
this.arrow_l_fcs.visible_p=false;
force_redraw();};
AppsPlateOperator.prototype.addApps=function(list,start_index){
var arry=[];
var page=null;
for(var i=0;i<list.length;i++){
if(page==null){
page=[];
arry.push(page);}
page.push(list[i]);
if(page!=null&&page.length==21){
page=null;}
}
this.page_data=arry;
if(this.page_data[start_index]){
this.page_index=start_index;}else if(this.page_data[start_index-1]){
this.page_index=start_index-1;}else{
this.page_index=0;}
this.indicator.setMaxNumber(this.page_data.length);
this.correctPageView();
this.page[1].setPartialView(true);
this.page[3].setPartialView(true);};
AppsPlateOperator.prototype.setFocus=function(b,keysym,col){
if(this.cursor==this.indicator){
var tmp=this.cursor.setFocus(b,keysym,col);
if(b==false){
this.cursor=this.page[2];}
return tmp;}else{
return this.page[2].setFocus(b,keysym,col);}
};
AppsPlateOperator.prototype.selectCurrentProduct=function(b){
var tmp=this.page[2].selectCurrentProduct(b);
if(b==true){
this.select_page_index=this.page_index;
this.select_index=tmp;}else{
this.select_page_index=null;
this.select_index=null;}
};
AppsPlateOperator.prototype.setCurrentLockState=function(b){
this.page[2].setCurrentLockState(b);};
AppsPlateOperator.prototype.getCurrentPage=function(){
return this.page_index;};
AppsPlateOperator.prototype.getCurrentProduct=function(){
if(this.cursor==this.indicator){
return null;}else{
var tmp=this.page[2].getCurrentProduct();
return [tmp[0]+21*this.page_index+7,tmp[1],tmp[2],tmp[3],tmp[4]];}
};
AppsPlateOperator.prototype.nextPage=function(b,need_marquee_care){
var x=0;
this.page[1].setPartialView(false);
this.page[3].setPartialView(false);
if(b==true){
x=this.page.length-1;
this.page_index++;
this.page.push(this.page.shift());}else{
this.page_index--;
this.page.unshift(this.page.pop());}
if(this.page_index==this.select_page_index){
this.page[2].set_select_focus(this.select_index);}

this.correctPageView();
for(var i=0;i<this.page.length;i++){
if(i!=x){
var f=null;
if(i==1||i==3){
f=function(obj){
obj.init();
obj.setPartialView(true);};}else if(i==0||i==4){
f=function(obj){
obj.visible_p=false;}
}else if(i==2){
if(need_marquee_care==true){
var ob=this.page[2];
f=function(){ob.correctMarquee();};}
}
this.page[i].moveTo([AppsPlateOperator.prototype.PAGE_INTERVAL*(i-2),0,0],
null,null,36*((system.mdl_cfg.apps_context==system.mdl_cfg.APPS_CONTEXT_SURFER)?1:2),f);}else{
this.page[i].translate[0]=(b?2:-2)*AppsPlateOperator.prototype.PAGE_INTERVAL;}
}
append_timer(this.tmp,3000,
function(obj){
delete_timer(obj);
force_redraw();
});};
AppsPlateOperator.prototype.correctPagePositionDirect=function(){
for(var i=0;i<this.page.length;i++){
delete_timer(this.page[i]);
this.page[i].translate[0]=AppsPlateOperator.prototype.PAGE_INTERVAL*(i-2);}
};
AppsPlateOperator.prototype.correctPageView=function(){
this.page[1].visible_p=!(this.page_index==0);
if(this.page[1].visible_p==true){
this.page[1].makeInstance();}
this.page[3].visible_p=!(this.page_index==this.page_data.length-1);
if(this.page[3].visible_p==true){
this.page[3].makeInstance();}
try{
this.indicator.setNumber(this.page_index);
if(this.page_data[this.page_index].length>0){
this.page[2].addApps(this.page_data[this.page_index],false,this.page_index);}
this.arrow_l.visible_p=this.page[1].visible_p;
this.arrow_r.visible_p=this.page[3].visible_p;}catch(e){
DEBUG.error("[---] No more page");}
};

function AppsPlatePagePoint(){
this.superClass=container;
this.superClass({
components:[
this.mask=new gbox({width:this.width-4,height:this.height-4,
color:[0,0,0,0],translate:[0,0,0.2],depth_test:true,blend:true}),
this.border=new gbox({width:this.width,height:this.height,
color:system.fdp_color.ICON_ONBASE,
depth_test:true}),
this.focus=new gbox({width:this.width-8,height:this.height-8,
color:system.fdp_color.ICON_ONBASE,
visible_p:false}),
]
});}
AppsPlatePagePoint.prototype.width=32;
AppsPlatePagePoint.prototype.height=22;
AppsPlatePagePoint.prototype.mask=null;AppsPlatePagePoint.prototype.border=null;AppsPlatePagePoint.prototype.focus=null;
AppsPlatePagePoint.prototype.setEnable=function(b){
this.focus.visible_p=b;};
AppsPlatePagePoint.prototype.setSizeRatio=function(ratio){
var r=1/ratio;
var target_w=Math.floor(AppsPlatePagePoint.prototype.width*r);
var target_h=Math.floor(AppsPlatePagePoint.prototype.height*r);
var bor=Math.floor(4*r);
this.mask.width=target_w-bor;
this.mask.height=target_h-bor;
this.border.width=target_w;
this.border.height=target_h;
this.focus.width=target_w-bor*2;
this.focus.height=target_h-bor*2;};

function AppsPlateIndicator(focus_moveto){
this.superClass=container;
this.superClass({
components:[]
});
this.focus_moveto=focus_moveto;
this.arrow_l=new gimage({src:IMG_PATH+"apps_indicator_arrow.png",
color:system.fdp_color.FCS,
rotation:[180,0,0,1],
visible_p:false,
width:28,height:44});
this.arrow_r=new gimage({src:IMG_PATH+"apps_indicator_arrow.png",
color:system.fdp_color.FCS,
visible_p:false,
width:28,height:44});
this.arrow=new container({components:[this.arrow_l,this.arrow_r],
visible_p:false});}
AppsPlateIndicator.prototype=new container({});
AppsPlateIndicator.prototype.INTERVAL=48;
AppsPlateIndicator.prototype.ORIGIN_INTERVAL=48;
AppsPlateIndicator.prototype.cursor=0;
AppsPlateIndicator.prototype.width=0;AppsPlateIndicator.prototype.height=AppsPlatePagePoint.prototype.height*2;
AppsPlateIndicator.prototype.focus_moveto=null;AppsPlateIndicator.prototype.arrow=null;AppsPlateIndicator.prototype.arrow_l=null;AppsPlateIndicator.prototype.arrow_r=null;
AppsPlateIndicator.prototype.setNumber=function(num){
if(this.cursor==num)return;
this.cursor=num;
this.components.forEach(function(val,idx,arry){
if(val instanceof AppsPlatePagePoint){
val.setEnable((num==idx));}
});
this.correctArrow();};
AppsPlateIndicator.prototype.setMaxNumber=function(max){
this.components=[];
this.cursor=0;
var x=-(max-1)/2;
for(var i=0;i<max;i++){
var img=new AppsPlatePagePoint();
if(i==0)img.setEnable(true);
this.components.push(img);
}
this.components.push(this.arrow);
this.correctPositions();};
AppsPlateIndicator.prototype.correctArrow=function(){
this.arrow_l.visible_p=(this.cursor!=0);
this.arrow_r.visible_p=(this.cursor!=(this.components.length-2));};
AppsPlateIndicator.prototype.correctPositions=function(){
var x=-(this.components.length-1-1)/2;
for(var i=0;i<this.components.length-1;i++){
this.components[i].translate[0]=this.INTERVAL*(x+i);}
this.width=(this.components.length-1+0.5)*this.INTERVAL;
this.arrow_l.translate[0]=-(this.width+this.INTERVAL)/2;
this.arrow_r.translate[0]=(this.width+this.INTERVAL)/2;};
AppsPlateIndicator.prototype.setSizeRatio=function(ratio){
var r=1/ratio;
this.INTERVAL=Math.floor(this.ORIGIN_INTERVAL*r);
this.components.forEach(
function(val){
if(val instanceof AppsPlatePagePoint){
val.setSizeRatio(ratio);}
});
this.correctPositions();};
AppsPlateIndicator.prototype.key_hook=function(updown,keysym){
if(updown!=KEY_PRESS)return false;
switch(keysym){
case TXK_LEFT:
case TXK_RIGHT:
return true;}
return false;};
AppsPlateIndicator.prototype.setFocus=function(b){
this.arrow.visible_p=b;
if(b==true){
this.correctArrow();
this.focus_moveto(this.translate,[this.width,this.height]);}else{
}
}

function FavoriteList(focus_moveto){
this.superClass=container;
this.superClass({
components:[
this.back=new container({
translate:[0,38,0],
components:[
this.border0=new gbox({width:1920,height:2,color:system.fdp_color.BORDER_ONBASE,
translate:[0,104-48,0]
}),
this.border1=new gbox({width:1920,height:2,color:system.fdp_color.BORDER_ONBASE,
translate:[0,-104-48,0]
}),
]
}),
]});
this.focus_moveto=focus_moveto;
this.item=[];
for(var i=0;i<7;i++){
var icon=new FavoriteIcon();
icon.translate[0]=this.INTERVAL*(i-(7-1)/2);
this.components.push(icon);
this.item.push(icon);}
this.marquee=new MarqueeText();
this.components.push(this.marquee);}
FavoriteList.prototype=new container({});
FavoriteList.prototype.INTERVAL=AppsPlate.prototype.INTERVAL_H;
FavoriteList.prototype.item=null;FavoriteList.prototype.cursor=0;FavoriteList.prototype.old_cursor=0;FavoriteList.prototype.show_lock=false;FavoriteList.prototype.show_remove=false;FavoriteList.prototype.show_restrict=false;FavoriteList.prototype.show_mkt=false;FavoriteList.prototype.disable_func=null;FavoriteList.prototype.back=null;FavoriteList.prototype.marquee=null;FavoriteList.prototype.border0=null;FavoriteList.prototype.border1=null;FavoriteList.prototype.SELECTED_FOCUS_COLOR=AppsPlate.prototype.SELECTED_FOCUS_COLOR;
FavoriteList.prototype.select_focus=null;
FavoriteList.prototype.set_focus_moveto=function(focus_moveto){
this.focus_moveto=focus_moveto;};
FavoriteList.prototype.setSizeRatio=function(ratio){
var r=1/ratio;
this.border0.height=2*r;
this.border1.height=2*r;};
FavoriteList.prototype.addApps=AppsPlate.prototype.addApps;
FavoriteList.prototype.selectCurrentProduct=function(b){
if(b==true){
if(this.select_focus==null){
this.select_focus=new Focus({color:this.SELECTED_FOCUS_COLOR,bold:true});
this.select_focus.visible_p=false;
var index=this.components.indexOf(this.marquee);
this.components.splice(index,1);
this.components.push(this.select_focus);
this.components.push(this.marquee);}
var tmp=this.item[this.cursor].getFocusSize();
this.select_focus.setSize(tmp[0]-4,tmp[1]-4);
this.select_focus.translate=this.item[this.cursor].getFocusPosition();
this.select_focus.visible_p=true;}else{
if(this.select_focus!=null){
this.select_focus.visible_p=false;}
}
};
FavoriteList.prototype.makeInstance=function(){return;};
FavoriteList.prototype.showLockState=AppsPlate.prototype.showLockState;
FavoriteList.prototype.showRemoveState=AppsPlate.prototype.showRemoveState;
FavoriteList.prototype.showRestrictedState=AppsPlate.prototype.showRestrictedState;
FavoriteList.prototype.showMarketIcon=AppsPlate.prototype.showMarketIcon;
FavoriteList.prototype.setDisableFunc=AppsPlate.prototype.setDisableFunc;
FavoriteList.prototype.updateIcons=AppsPlate.prototype.updateIcons;
FavoriteList.prototype.setCurrentLockState=AppsPlate.prototype.setCurrentLockState;
FavoriteList.prototype.getCurrentProduct=AppsPlate.prototype.getCurrentProduct;
FavoriteList.prototype.correctFocus=function(){
var tra=this.item[this.cursor].getFocusPosition();
var size=this.item[this.cursor].getFocusSize();
var me=this;
var pos=this.item[this.cursor].getTranslate();
this.marquee.setVisible(false);
this.marquee.setTranslate(pos[0],pos[1]+this.item[this.cursor].TITLE_Y,pos[2]);
this.focus_moveto([tra[0]+this.translate[0],
tra[1]+this.translate[1],
tra[2]+this.translate[2]],
size,null,30,
function(focus){
focus.visible_p=true;
if(me.marquee.setTitleObject(me.item[me.cursor].getTitleObject())==true){
var ret=me.item[me.cursor].setTitleVisible(false);
if(ret==true)me.marquee.setVisible(true);};});};
FavoriteList.prototype.setFocus=function(b,keysym,col){
var ret=this.cursor;
if(b==true){
switch(keysym){
case TXK_UP:
case TXK_DOWN:
if(!(typeof col=="number"&&!isNaN(col))){
col=0;}
this.cursor=col;
break;}
if(this.cursor==-1){
this.cursor=this.old_cursor;}
this.item[this.cursor].setFocus(true,keysym);
this.correctFocus(true)
}else{
if(this.cursor==-1){
this.cursor=this.old_cursor;}
this.item[this.cursor].setFocus(false,keysym);
this.marquee.setVisible(false);
this.old_cursor=this.cursor;
this.cursor=-1;}
return ret;};
FavoriteList.prototype.key_hook=function(updown,keysym){
if(updown!=KEY_PRESS)return false;
switch(keysym){
case TXK_LEFT:
if(this.cursor<=0){
return false;}
this.item[this.cursor].setFocus(false,keysym);
this.cursor--;
this.item[this.cursor].setFocus(true,keysym);
this.correctFocus(true);
return true;
case TXK_RIGHT:
if(this.cursor==this.item.length-1){
return false;}
this.item[this.cursor].setFocus(false,keysym);
this.cursor++;
this.item[this.cursor].setFocus(true,keysym);
this.correctFocus();
return true;
case TXK_ENTER:
try{
return this.item[this.cursor].launch_appli();}catch(e){
throw e;
}
default:
}
return false;};
FavoriteList.prototype.getTranslate=function(){
return this.translate;};
FavoriteList.prototype.point_hook=function (type,identifier,x,y,screenX,screenY){
if(type=="touchmove")return false;
DEBUG.warn("FavoriteList.prototype.point_hook = function ("
+type+", "+identifier+", "+x+", "+y+", "
+screenX+", "+screenY+"){");
var pos=null;
var size=null;
var tmp=-1;
for(var i=0;i<this.item.length;i++){
pos=this.item[i].getFocusPosition();
size=this.item[i].getFocusSize();
if(isIN(x,y,pos,size)==true){
tmp=i;
break;}
}
if(tmp==-1){
return false;}else if(tmp==this.cursor){
if(type=="touchend"){
HOME_SOUND_PLAY("enter");
this.key_hook(KEY_PRESS,TXK_ENTER);
return true;}else{
return false;}
}else{
if(type=="touchstart"){
try{
this.item[this.cursor].setFocus(false);}catch(e){
}
HOME_SOUND_PLAY(0);
this.cursor=tmp;
this.correctFocus();
return true;}else{
return false;}
}
};

function FavoriteIcon(){
this.superClass=ApplicationIcon;
this.superClass();
this.lock.translate[1]-=ApplicationIcon.prototype.ICON_Y;
if(this.pen!=null){
this.pen.translate[1]-=ApplicationIcon.prototype.ICON_Y;}
};
FavoriteIcon.prototype=new ApplicationIcon({});
FavoriteIcon.prototype.ICON_Y=0;
FavoriteIcon.prototype.TITLE_Y=-84;

function MarqueeText(){
this.superClass=container;
this.superClass({
visible_p:false,
components:[
this.mask_l=new gbox({width:1920-this.width,height:this.height,color:[0,0,0,0],
translate:[-1920/2,0,0.15],depth_test:true}),
this.mask_r=new gbox({width:1920-this.width,height:this.height,color:[0,0,0,0],
translate:[1920/2,0,0.15],depth_test:true}),
this.text=new gtext({height:this.height,color:this.TITLE_COLOR,depth_test:true}),
]
});};
MarqueeText.prototype=new container({});
MarqueeText.prototype.TITLE_COLOR=ApplicationIcon.prototype.TITLE_COLOR;
MarqueeText.prototype.RESOLUTION=(function(){
if(system.mdl_cfg.apps_context==system.mdl_cfg.APPS_CONTEXT_SURFER){
return 1;}else{
return 2;}
})();
MarqueeText.prototype.width=ApplicationIcon.prototype.TITLE_W;
MarqueeText.prototype.height=ApplicationIcon.prototype.TITLE_H;
MarqueeText.prototype.text=null;MarqueeText.prototype.mask_l=null;MarqueeText.prototype.mask_r=null;
MarqueeText.prototype.init=function(){
this.stopAnimation();
setf_text(this.text,"");}
MarqueeText.prototype.setSize=function(w,h){
this.width=w;
this.mask_l.width=1920-w;
this.mask_r.width=1920-w;
this.height=h+20;
this.mask_l.height=this.height;
this.mask_r.height=this.height;};
MarqueeText.prototype.setVisible=function(b){
this.visible_p=b;
if(b==false){
this.init();}
}
MarqueeText.prototype.getVisible=function(){
return this.visible_p;}
MarqueeText.prototype.setTitleObject=function(title_obj){
var dim=get_dimension_textbox(title_obj);
this.setSize(title_obj.width,
get_text_font_height(title_obj,title_obj.text));
this.text.width=get_text_width(title_obj,title_obj.text);
this.text.color=title_obj.color;
if((SU_IS_SLOW_ANIM==true)||(this.text.width<this.width)){
this.init();
return false;}
this.text.font_size=title_obj.font_size;
this.text.translate[0]=-(this.width-this.text.width)/2
setf_text(this.text,title_obj.text);
this.startAnimation();
return true;};
MarqueeText.prototype.startAnimation=function(){
var start=this.text.translate[0];
var target=start-this.text.width;
var step=Math.ceil((start-target)/ 5000*80 /this.RESOLUTION);
var cnt=0;
append_timer(this,Math.floor(80/this.RESOLUTION),
function(obj,count){
force_redraw();
cnt++;
if(cnt<10*obj.RESOLUTION){return;}
obj.text.translate[0]-=step;
if(obj.text.translate[0]<target){
obj.text.translate[0]=start;
cnt=0;}
});};
MarqueeText.prototype.stopAnimation=function(){
delete_timer(this);};
append_functions(MarqueeText.prototype,GraphicsLib);
append_functions(MarqueeText.prototype,AnimationLib);

function ApplicationList(favorite_list,apps_plate_operator){
this.superClass=container;
this.superClass({
rotation:[0,0,0,0],
components:[favorite_list,apps_plate_operator]
});
this.favorites=favorite_list;
this.apps_list=apps_plate_operator;
this.cur_list=[this.favorites,this.apps_list];
};
ApplicationList.prototype=new container({});
ApplicationList.prototype.width=1920;
ApplicationList.prototype.height=800;
ApplicationList.prototype.show_lock=false;ApplicationList.prototype.show_remove=false;ApplicationList.prototype.show_restrict=false;ApplicationList.prototype.show_mkt=false;ApplicationList.prototype.disable_func=null;ApplicationList.prototype.favorites=null;ApplicationList.prototype.apps_list=null;ApplicationList.prototype.cur_list=null;ApplicationList.prototype.cursor=0;
ApplicationList.prototype.init=function(){
ApplicationIcon.prototype.LOCKED_LIST=null;};
ApplicationList.prototype.addApps=function(list,start_index){
this.favorites.addApps(list.slice(0,7),true);
this.apps_list.addApps(list.slice(7),start_index);};
ApplicationList.prototype.showLockState=function(b){
this.show_lock=b;
this.cur_list.forEach(function(val){val.showLockState(b);});};
ApplicationList.prototype.showRemoveState=function(b){
this.show_remove=b;
this.cur_list.forEach(function(val){val.showRemoveState(b);});};
ApplicationList.prototype.showRestrictedState=function(b){
this.show_restrict=b;
this.cur_list.forEach(function(val){val.showRestrictedState(b);});};
ApplicationList.prototype.showMarketIcon=function(b){
this.show_mkt=b;
this.cur_list.forEach(function(val){val.showMarketIcon(b);});};
ApplicationList.prototype.setDisableFunc=function(func){

this.disable_func=func;
this.cur_list.forEach(function(val){val.setDisableFunc(func);});};
ApplicationList.prototype.updateIcons=function(){
this.favorites.updateIcons();
this.apps_list.updateIcons();};
ApplicationList.prototype.setSize=function(w,h){var ratio_w=w/1920;
var rot=Math.acos(ratio_w)*180/Math.PI;
this.rotation[0]=rot;
this.width=w;
this.height=w*9/16;
if(this.apps_list){
this.apps_list.setSizeRatio(ratio_w);}
if(this.favorites){
this.favorites.setSizeRatio(ratio_w);}
};
ApplicationList.prototype.onFocus=function(b,keysym){
this.setFocus(b,keysym);};
ApplicationList.prototype.setFocus=function(b,keysym,col){
var ret=this.cur_list[this.cursor].setFocus(b,keysym,col);
if((b==false)&&(keysym==-1)){
this.cursor=0;}
return ret;};
ApplicationList.prototype.selectCurrentProduct=function(b){
if(b==true){
this.cur_list[this.cursor].selectCurrentProduct(true);}else{
for(var i=0;i<this.cur_list.length;i++){
this.cur_list[i].selectCurrentProduct(false);}
}
};
ApplicationList.prototype.setCurrentLockState=function(b){
ApplicationIcon.prototype.LOCKED_LIST=null;
this.cur_list[this.cursor].setCurrentLockState(b);};

ApplicationList.prototype.getCurrentProduct=function(){
return this.cur_list[this.cursor].getCurrentProduct();};
ApplicationList.prototype.orderAppsList=function(list){
var split_favorite_list=list.slice(0,7);
var split_app_list=list.slice(7);
var tmp_list=[];
var page_app_list=[];
var app_num=0;

var page_num=Math.ceil(split_app_list.length/21);
for(var i=0;i<page_num;i++){
if(split_app_list.length>=(i*21+21)){
page_app_list[i]=split_app_list.slice(21*i,21*(i+1));}else{
page_app_list[i]=split_app_list.slice(21*i);}
app_num=0;
for(var j=0;j<page_app_list[i].length;j++){
if(page_app_list[i][j]!=null){
app_num++;}
}
if(app_num>0){
tmp_list=tmp_list.concat(page_app_list[i]);}
}
return split_favorite_list.concat(tmp_list);};
ApplicationList.prototype.resetArrows=function(){
this.apps_list.resetArrows();};
ApplicationList.prototype.key_hook=function(updown,keysym){
if(updown!=KEY_PRESS)return false;

try{
if(this.cur_list[this.cursor].key_hook(updown,keysym)==true){
return true;}
}catch(e){
throw e;
return false;}
var arg=null;
switch(keysym){
case TXK_UP:
if(this.cursor==0){
return false;}
arg=this.cur_list[this.cursor].setFocus(false,keysym);
this.cursor--;
this.cur_list[this.cursor].setFocus(true,keysym,arg);
return true;

case TXK_DOWN:
if(this.cursor==this.cur_list.length-1){
return false;}
arg=this.cur_list[this.cursor].setFocus(false,keysym);
this.cursor++;
this.cur_list[this.cursor].setFocus(true,keysym,arg);
return true;
default:
}
return false;};
ApplicationList.prototype.point_hook=function (type,identifier,x,y,screenX,screenY){
if(type=="touchmove")return false;
DEBUG.warn("ApplicationList.prototype.point_hook = function ("
+type+", "+identifier+", "+x+", "+y+", "
+screenX+", "+screenY+"){");

var target=null;
if(y>100){
target=0;
this.resetArrows();}else{
target=1;}
var pos=this.cur_list[target].getTranslate();
if(this.cur_list[target].point_hook(type,identifier,screenX-pos[0],screenY-pos[1],screenX,screenY)==true){
if(this.cursor==target){
}else if(type=="touchstart"){
this.cur_list[this.cursor].setFocus(false,-1);
this.cursor=target;
this.cur_list[this.cursor].setFocus(true,-1);
return true;}else{
return false;}
}else{
return false;}
};
append_functions(ApplicationList.prototype,GraphicsLib);
append_functions(ApplicationList.prototype,AnimationLib);
if(SU_IS_SLOW_ANIM){
ApplicationList.prototype.moveTo=AnimationLib.moveToDirect;
ApplicationList.prototype.slide=AnimationLib.slideDirect;}

