var app_name="0387878700140035";
var png_path=APPLI_PATH+app_name+"/gadget/";
var analog_hands=[
{
hours:png_path+"clock_h.png",
minutes:png_path+"clock_min.png"
},
{
hours:png_path+"clock_h2.png",
minutes:png_path+"clock_min2.png"
},
{
hours:png_path+"clock_h_n.png",
minutes:png_path+"clock_min_n.png"
},
{
hours:png_path+"clock_h2_n.png",
minutes:png_path+"clock_min2_n.png"
}
];
var analog_pack=[
{
mojiban:png_path+"mojiban1.png",
hands:analog_hands[0]
},
{
mojiban:png_path+"mojiban2.png",
hands:analog_hands[1]
},
{
mojiban:png_path+"mojiban1_n.png",
hands:analog_hands[2]
},
{
mojiban:png_path+"mojiban2_n.png",
hands:analog_hands[3]
}
];
var digit_table=[
{
size:[150,150],
image:[
png_path+"d2_0.png",
png_path+"d2_1.png",
png_path+"d2_2.png",
png_path+"d2_3.png",
png_path+"d2_4.png",
png_path+"d2_5.png",
png_path+"d2_6.png",
png_path+"d2_7.png",
png_path+"d2_8.png",
png_path+"d2_9.png"
]
}
];
var digital_pack=[
{
back:png_path+"d1_base.png",
colon:png_path+"d1_colon.png",
digit:digit_table[0],
non:png_path+"d2_non.png"
},
{
back:png_path+"d2_base.png",
colon:png_path+"d2_colon.png",
digit:digit_table[1],
non:png_path+"d2_non.png"
}
];
var tz_table=new Array(
[0,-12,"","LT_TZ_DATELINE_STANDARD",true],
[1,-11,"","LT_TZ_MIDWAY_ISLAND",true],
[3,-10,"","LT_TZ_HAWAIIAN_STANDARD",true],
[4,-9,"","LT_TZ_ALASKAN_STANDARD",true],
[5,-8,"","LT_TZ_PACIFIC_STANDARD",true],
[6,-7,"","LT_TZ_CHIHUAHUA",true],
[7,-7,"","LT_TZ_LA_PAZ",true],
[8,-7,"","LT_TZ_MAZATLAN",true],
[9,-7,"","LT_TZ_US_MOUNTAIN_STANDARD",true],
[10,-6,"","LT_TZ_CANADA_CENTRAL_STANDARD",true],
[11,-6,"","LT_TZ_GUADALAJARA",true],
[12,-6,"","LT_TZ_MEXICO_CITY",true],
[13,-6,"","LT_TZ_MONTERREY",true],
[14,-6,"","LT_TZ_CENTRAL_STANDARD",true],
[15,-6,"","LT_TZ_CENTRAL_AMERICA_STANDARD",true],
[16,-5,"","LT_TZ_US_EASTERN_STANDARD",true],
[17,-5,"","LT_TZ_EASTERN_STANDARD",true],
[18,-5,"","LT_TZ_BOGOTA",true],
[19,-5,"","LT_TZ_LIMA",true],
[20,-5,"","LT_TZ_QUITO",true],
[23,-4.5,"","LT_TZ_CARACAS",true],
[21,-4,"","LT_TZ_PACIFIC_SA_STANDARD",true],
[22,-4,"","LT_TZ_CENTRAL_BRAZILIAN_STANDARD",true],
[24,-4,"","LT_TZ_LA_PAZ",true],
[28,-4,"","LT_TZ_GEORGETOWN",true],
[25,-3.5,"","LT_TZ_NEWFOUNDLAND_STANDARD",true],
[26,-3,"","LT_TZ_GREENLAND_STANDARD",true],
[27,-3,"","LT_TZ_BUENOS_AIRES",true],
[29,-3,"","LT_TZ_E_SOUTH_AMERICA_STANDARD",true],
[30,-2,"","LT_TZ_MID_ATLANTIC_STANDARD",true],
[31,-1,"","LT_TZ_CAPE_VERDE_STANDARD",true],
[32,-1,"","LT_TZ_AZORES_STANDARD",true],
[33,0,"","LT_TZ_CASABLANCA",true],
[34,0,"","LT_TZ_MONROVIA",true],
[35,0,"","LT_TZ_GREENWICH",true],
[36,0,"","LT_TZ_EDINBURGH",true],
[37,0,"","LT_TZ_LISBON",true],
[38,0,"","LT_TZ_LONDON",true],
[39,1,"","LT_TZ_AMSTERDAM",true],
[40,1,"","LT_TZ_BERLIN",true],
[41,1,"","LT_TZ_BERN",true],
[42,1,"","LT_TZ_ROMA",true],
[43,1,"","LT_TZ_STOCKHOLM",true],
[44,1,"","LT_TZ_VIENNA",true],
[45,1,"","LT_TZ_BELGRADE",true],
[46,1,"","LT_TZ_BRATISLAVA",true],
[47,1,"","LT_TZ_BUDAPEST",true],
[48,1,"","LT_TZ_LJUBLJANA",true],
[49,1,"","LT_TZ_PRAHA",true],
[50,1,"","LT_TZ_BRUSSELS",true],
[51,1,"","LT_TZ_COPENHAGEN",true],
[52,1,"","LT_TZ_MADRID",true],
[53,1,"","LT_TZ_PARIS",true],
[54,1,"","LT_TZ_SARAJEVO",true],
[55,1,"","LT_TZ_SKOPJE",true],
[56,1,"","LT_TZ_WARSAW",true],
[57,1,"","LT_TZ_ZAGREB",true],
[58,1,"","LT_TZ_W_CENTRAL_AFRICA_STANDARD",true],
[73,1,"","LT_TZ_NAMIBIA_STANDARD",true],
[59,2,"","LT_TZ_ATHENS",true],
[60,2,"","LT_TZ_BUCHAREST",true],
[61,2,"","LT_TZ_ISTANBUL",true],
[62,2,"","LT_TZ_EGYPT_STANDARD",true],
[63,2,"","LT_TZ_HARARE",true],
[64,2,"","LT_TZ_PRETORIA",true],
[65,2,"","LT_TZ_HELSINKI",true],
[66,2,"","LT_TZ_KIEV",true],
[67,2,"","LT_TZ_RIGA",true],
[68,2,"","LT_TZ_SOFIA",true],
[69,2,"","LT_TZ_TALLINN",true],
[70,2,"","LT_TZ_VILNIUS",true],
[71,2,"","LT_TZ_ISRAEL_STANDARD",true],
[72,3,"","LT_TZ_E_EUROPE_STANDARD",true],
[74,3,"","LT_TZ_ARABIC_STANDARD",true],
[75,3,"","LT_TZ_KUWAIT",true],
[76,3,"","LT_TZ_RIYADH",true],
[80,3,"","LT_TZ_E_AFRICA_STANDARD",true],
[81,3.5,"","LT_TZ_IRAN_STANDARD",true],
[77,4,"","LT_TZ_MOSKOW",true],
[78,4,"","LT_TZ_ST_PETERSBURG",true],
[79,4,"","LT_TZ_VOLGORAD",true],
[82,4,"","LT_TZ_ABU_DHABI",true],
[83,4,"","LT_TZ_MUSCAT",true],
[84,4,"","LT_TZ_AZERBAIJAN_STANDARD",true],
[85,4,"","LT_TZ_GEORGIAN_STANDARD",true],
[86,4,"","LT_TZ_CAUCASUS_STANDARD",true],
[87,4.5,"","LT_TZ_AFGHANISTAN_STANDARD",true],
[89,5,"","LT_TZ_ISLAMABAD",true],
[90,5.,"","LT_TZ_ST_KARACHI",true],
[91,5,"","LT_TZ_TASHKENT",true],
[92,5.5,"","LT_TZ_CHENNAI",true],
[93,5.5,"","LT_TZ_KOLKATA",true],
[94,5.5,"","LT_TZ_MUMBAI",true],
[95,5.5,"","LT_TZ_NEW_DELI",true],
[101,5.5,"","LT_TZ_SRI_LANKA_KOTTE_STANDARD",true],
[96,5.75,"","LT_TZ_NEPAL_STANDARD",true],
[88,6,"","LT_TZ_EKATERINBURG_STANDARD",true],
[97,6,"","LT_TZ_ALMATY",true],
[99,6,"","LT_TZ_ASTANA",true],
[100,6,"","LT_TZ_DHAKA",true],
[102,6.5,"","LT_TZ_MYANMAR_STANDARD",true],
[98,7,"","LT_TZ_NOVOSIBIRSK",true],
[103,7,"","LT_TZ_BANGKOK",true],
[104,7,"","LT_TZ_HANOI",true],
[105,7,"","LT_TZ_JAKARTA",true],
[106,8,"","LT_TZ_NORTH_ASIA_STANDARD",true],
[107,8,"","LT_TZ_BEIJING",true],
[108,8,"","LT_TZ_CHONGQING",true],
[109,8,"","LT_TZ_HONG_KONG",true],
[110,8,"","LT_TZ_URUMQI",true],
[112,8,"","LT_TZ_ULAANBAATAR",true],
[113,8,"","LT_TZ_KUALA_LUMPUR",true],
[114,8,"","LT_TZ_SINGAPORE",true],
[115,8,"","LT_TZ_W_AUSTRALIA_STANDARD",true],
[116,8,"","LT_TZ_TAIPEI_STANDARD",true],
[111,9,"","LT_TZ_IRKUTSK",true],
[117,9,"","LT_TZ_OSAKA",true],
[118,9,"","LT_TZ_SAPPORO",true],
[119,9,"","LT_TZ_TOKYO",true],
[120,9,"","LT_TZ_KOREA_STANDARD",true],
[122,9.5,"","LT_TZ_CEN_AUSTRALIA_STANDARD",true],
[123,9.5,"","LT_TZ_AUS_CENTRAL_STANDARD",true],
[124,10,"","LT_TZ_E_AUSTRALIA_STANDARD",true],
[121,10,"","LT_TZ_YAKUTSK_STANDARD",true],
[125,10,"","LT_TZ_CANBERRA",true],
[126,10,"","LT_TZ_MELBOURNE",true],
[127,10,"","LT_TZ_SYDNEY",true],
[128,10,"","LT_TZ_GUAM",true],
[129,10,"","LT_TZ_PORTMORESBY",true],
[130,10,"","LT_TZ_TASMANIA_STANDARD",true],
[131,11,"","LT_TZ_VLADIVOSTOK_STANDARD",true],
[133,11,"","LT_TZ_SOLOMON_ISLANDS",true],
[134,11,"","LT_TZ_NEW_CALEDONIA",true],
[132,12,"","LT_TZ_MAGADAN",true],
[135,12,"","LT_TZ_AUCKLAND",true],
[136,12,"","LT_TZ_WELLINGTON",true],
[137,12,"","LT_TZ_FIJI_ISLANDS",true],
[138,12,"","LT_TZ_KAMCHATKA",true],
[139,12,"","LT_TZ_MARSHALL_ISLANDS",true],
[2,13,"","LT_TZ_SAMOA",true],
[140,13,"","LT_TZ_TONGA_STANDARD",true]
);
var TZ_TABLE=
{
IDX:0,
OFFSET:1,
SHORT_NAME:2,
LONG_NAME:3,
SUMMER_TIME:4
};
var CLOCK_STYLE=
{
ANALOG1:0,
ANALOG2:1,
DIGITAL1:2,
DIGITAL2:3,
NONE:4
};
var clFree=function(c){
c=c||this;
if(c instanceof gtext||c instanceof gtextbox)setf_text(c,"");
else if(c instanceof gimage)c.src="";
else if(c.bg_image)for(var i=0,a=c.bg_image,
len=a.length;i<len;i++)clFree(a[i]);
if(c.components)for(var j=0,b=c.components,
length=b.length;j<length;j++)clFree(b[j]);};
var analogClock=function(w,h)
{
this.superClass=container;
this.superClass({});
this.nightDay=-1;

this.mojiban=new gimage({
src:analog_pack[0].mojiban,
width:w,
height:h
});
this.h_hands=new gimage({
rotation:[0,0,0,1],
src:analog_pack[0].hands.hours,
width:w,
height:h
});
this.m_hands=new gimage({
rotation:[0,0,0,1],
src:analog_pack[0].hands.minutes,
width:w,
height:h
});
this.components.push(this.mojiban);
this.components.push(this.h_hands);
this.components.push(this.m_hands);};
analogClock.prototype.setHands=function(hour,minute,second)
{
if(hour==-1&&minute==-1&&second==-1){
hour=0;
minute=0;
second=0;}

var h=-(hour*30+minute/2);
var m=-(minute*6);

if(-360>=h&&h>=-720)h=h+360;
if(-360>=m&&m>=-720)m=m+360;
var r=0.3;
if(m>=-1)r=1;
this.animateHands({obj:this.h_hands,angle:h,rate:r});
this.animateHands({obj:this.m_hands,angle:m,rate:r});};
analogClock.prototype.animateHands=function(param)
{
var obj=param.obj;
if(obj.rotation[0]==param.angle)return;
TIMER_RESOLUTION=100;
delete_timer(obj);
if(param.func)param.func(obj);
obj.tmp={};
obj.endpos={};
obj.tmp.RATE=0.6;
obj.tmp.max_count=param.count?param.count:9;
if(param.rate){
obj.tmp.RATE=param.rate;}
if(param.count)obj.tmp.max_count=param.count;
if(!param.angle)param.angle=0;
obj.tmp.da=param.angle-obj.rotation[0];
obj.rotation[0]+=obj.tmp.da*obj.tmp.RATE;

force_redraw();
append_timer(obj,TIMER_RESOLUTION,function (obj,count){
obj.tmp.da=param.angle-obj.rotation[0];
obj.rotation[0]+=obj.tmp.da*obj.tmp.RATE;
if(count>=obj.tmp.max_count||
obj.rotation[0]==param.angle){
delete_timer(obj);

obj.rotation[0]=param.angle;
if(typeof param.end_func=="function"){
param.end_func(obj);}
}
force_redraw();});};
analogClock.prototype.setAnalogStyle=function(style,hour)
{
var offset=0;
if(!(hour>=6&&hour<=17)&&clock_isSystimeAvailable())offset+=2;

if(this.nightDay!=(style+offset)){
this.mojiban.src=analog_pack[(style+offset)].mojiban;
this.h_hands.src=analog_pack[(style+offset)].hands.hours;
this.m_hands.src=analog_pack[(style+offset)].hands.minutes;
this.nightDay=style+offset;}
};
analogClock.prototype.setClockSize=function(w,h,style)
{
var adjustment=0.70;
this.mojiban.width=w;
this.h_hands.width=Math.floor(w*adjustment);
this.m_hands.width=Math.floor(w*adjustment);
this.mojiban.height=h;
this.h_hands.height=Math.floor(h*adjustment);
this.m_hands.height=Math.floor(h*adjustment);
if(style==CLOCK_STYLE.ANALOG2){
this.h_hands.translate[1]=Math.floor(w/40*adjustment);
this.m_hands.translate[1]=Math.floor(w/40*adjustment);}
};
analogClock.prototype.free=function()
{
clFree(this);};
var digitalClock=function(w,h)
{
this.superClass=container;
this.superClass({});

this.back=new gimage({
src:digital_pack[0].back,
width:w,
height:h
});
this.colon=new gimage({
translate:[0.0,0.0,0.0],
src:digital_pack[0].colon,
width:w,
height:h
});
this.colon2=new gimage({
translate:[0.0,0.0,0.0],
src:digital_pack[1].colon,
width:w,
height:h
});
this.lh_digit=new gimage({
translate:[-Math.floor(digital_pack[0].digit.size[0]/2),0,0],
src:digital_pack[0].digit.image[0],
width:w,
height:h
});
this.rh_digit=new gimage({
translate:[-Math.floor(digital_pack[0].digit.size[0]/4),0,0],
src:digital_pack[0].digit.image[0],
width:w,
height:h
});
this.lm_digit=new gimage({
translate:[Math.floor(digital_pack[0].digit.size[0]/4),0,0],
src:digital_pack[0].digit.image[0],
width:w,
height:h
});
this.rm_digit=new gimage({
translate:[Math.floor(digital_pack[0].digit.size[0]/2),0,0],
src:digital_pack[0].digit.image[0],
width:w,
height:h
});
this.time_text=new gtext({
width:360,
align:CENTER,
color:[0,0,0,255]
});
this.ampm_text=new gtext({
width:160,
align:CENTER,
color:[0,0,0,255],
text:""
});

this.components.push(this.back);
this.components.push(this.colon);
this.components.push(this.colon2);
this.components.push(this.lh_digit);
this.components.push(this.rh_digit);
this.components.push(this.lm_digit);
this.components.push(this.rm_digit);
this.components.push(this.time_text);
this.components.push(this.ampm_text);};
digitalClock.prototype.setDigit=function(hour,minute)
{
if(hour==-1&&minute==-1){
this.lh_digit.src=digital_pack[0].non;
this.rh_digit.src=digital_pack[0].non;
this.lm_digit.src=digital_pack[0].non;
this.rm_digit.src=digital_pack[0].non;
setf_text(this.time_text,"- -   - -");}else{
var h=hour;
var m=minute;
var ampm;
if(hour<12){
ampm="AM";}else{
ampm="PM";}
if(hour>12)h-=12;
if(h==0)h=12;
if(h<10)h="0"+h;
if(m<10)m="0"+m;
if(this.time_text.text!=h+" "+m||this.ampm_text.text!=ampm){
setf_text(this.time_text,h+" "+m);
this.lh_digit.src=digital_pack[0].digit.image[Math.floor(hour/10)];
this.rh_digit.src=digital_pack[0].digit.image[Math.floor(hour%10)];
this.lm_digit.src=digital_pack[0].digit.image[Math.floor(minute/10)];
this.rm_digit.src=digital_pack[0].digit.image[Math.floor(minute%10)];}
if(this.ampm_text.text!=ampm){
setf_text(this.ampm_text,ampm);}
}
};
digitalClock.prototype.setDigitalStyle=function(style)
{
this.back.src=digital_pack[style-digital_pack.length].back;
this.digit=digital_pack[style-digital_pack.length].digit;
if(style==CLOCK_STYLE.DIGITAL1){
this.lh_digit.visible_p=false;
this.rh_digit.visible_p=false;
this.lm_digit.visible_p=false;
this.rm_digit.visible_p=false;
this.colon2.visible_p=false;

this.time_text.visible_p=true;
this.ampm_text.visible_p=true;
this.colon.visible_p=true;}else{
this.time_text.visible_p=false;
this.ampm_text.visible_p=false;
this.colon.visible_p=false;

this.lh_digit.visible_p=true;
this.rh_digit.visible_p=true;
this.lm_digit.visible_p=true;
this.rm_digit.visible_p=true;
this.colon2.visible_p=true;}
};
digitalClock.prototype.setClockSize=function(w,h,style)
{
var adjustment=0.35;
this.back.width=Math.floor(w*(adjustment+0.65));
this.colon.height=Math.floor(h*0.11);
this.colon2.height=Math.floor(h*0.17);
this.lh_digit.width=Math.floor(w*(adjustment*0.5));
this.rh_digit.width=Math.floor(w*(adjustment*0.5));
this.lm_digit.width=Math.floor(w*(adjustment*0.5));
this.rm_digit.width=Math.floor(w*(adjustment*0.5));

this.colon.translate[1]=Math.floor(w*0.051);
this.lh_digit.translate=[-Math.floor(this.lh_digit.width*1.85),0,0];
this.rh_digit.translate=[-Math.floor(this.rh_digit.width/2*1.4),0,0];
this.lm_digit.translate=[Math.floor(this.lm_digit.width/2*1.4),0,0];
this.rm_digit.translate=[Math.floor(this.rm_digit.width*1.85),0,0];

this.time_text.font_size=Math.floor(w/3);
this.time_text.width=Math.floor(w/1.2);
this.time_text.translate[1]=Math.floor(w/12);
setf_text(this.time_text,this.time_text.text);
this.ampm_text.font_size=Math.floor(w/7);
this.ampm_text.translate[1]=Math.floor(-w/5.5);
setf_text(this.ampm_text,this.ampm_text.text);};
digitalClock.prototype.free=function()
{
clFree(this);};
var clockObj=function(base_w,base_h)
{
this.tz=0;
this.style=CLOCK_STYLE.ANALOG1;
this.base_width=base_w;
this.base_height=base_h;
this.aclock=new analogClock();
this.dclock=new digitalClock();
this.alpha=255;};
clockObj.prototype.appearClock=function()
{
if((this.style==CLOCK_STYLE.ANALOG1)||
(this.style==CLOCK_STYLE.ANALOG2))
{
this.aclock.visible_p=true;
this.dclock.visible_p=false;}
else if(this.style==CLOCK_STYLE.DIGITAL1||
this.style==CLOCK_STYLE.DIGITAL2)
{
this.dclock.visible_p=true;
this.aclock.visible_p=false;}
else
{
this.hideClock();}
};
clockObj.prototype.hideClock=function()
{
this.aclock.visible_p=false;
this.dclock.visible_p=false;};
clockObj.prototype.checkVisible=function()
{
var ret=false;
if((this.aclock.visible_p==true)||
(this.dclock.visible_p==true))
{
ret=true;}
return ret;};
clockObj.prototype.setClockSize=function (w,h)
{
this.aclock.setClockSize(w,h,this.style);
this.dclock.setClockSize(w,h,this.style);};
clockObj.prototype.setTranslate=function(t_x,t_y,t_z)
{
this.aclock.translate=[t_x,t_y,t_z];
this.dclock.translate=[t_x,t_y,t_z];};
clockObj.prototype.getStyle=function()
{
return this.style;};
clockObj.prototype.setStyle=function(style,clock_mode)
{
var hms=this.getClockTime(this.tz,clock_mode);
var hour=hms[0];

this.style=style;
switch(this.style)
{
case CLOCK_STYLE.ANALOG1:
case CLOCK_STYLE.ANALOG2:
this.aclock.setAnalogStyle(style,hour);
this.appearClock();
break;
case CLOCK_STYLE.DIGITAL1:
case CLOCK_STYLE.DIGITAL2:
this.dclock.setDigitalStyle(style);
this.appearClock();
break;
case CLOCK_STYLE.NONE:
this.hideClock();
break;
default:
this.style=CLOCK_STYLE.ANALOG1;
this.aclock.setAnalogStyle(CLOCK_STYLE.ANALOG1,hour);
this.appearClock();
break;}
};
clockObj.prototype.getClockTime=function(tz,clock_mode)
{
if(clock_mode==CLOCK_MODE.C){
var systime=clock_getSysTime();
return [systime.tm_hour,systime.tm_min,systime.tm_sec];}

var cur_date=new Date();
var setting=nv_getClockSetting(this.p_type,clock_mode);
cur_date.setTime(cur_date.getTime()+
(tz_table[tz][TZ_TABLE.OFFSET]+setting[2])*3600*1000);
return [cur_date.getUTCHours(),cur_date.getUTCMinutes(),
cur_date.getUTCSeconds()];};
clockObj.prototype.setClockTime=function(tz,clock_mode)
{
var hour,min,sec;
var hms=this.getClockTime(tz,clock_mode);
hour=hms[0];
min=hms[1];
sec=hms[2];

if(!clock_isSystimeAvailable()){
this.setAlpha(90);
hour=-1;
min=-1;
sec=-1;}else{
this.setAlpha(255);}
if(this.style==CLOCK_STYLE.ANALOG1||
this.style==CLOCK_STYLE.ANALOG2){
this.aclock.setAnalogStyle(this.style,hour);
this.aclock.setHands(hour,min,sec);
this.dclock.setDigit(hour,min);}

if(this.style==CLOCK_STYLE.DIGITAL1||
this.style==CLOCK_STYLE.DIGITAL2){
this.dclock.setDigit(hour,min);}
};
clockObj.prototype.update=function(clock_mode)
{
this.setClockTime(this.tz,clock_mode);};
clockObj.prototype.setTimeZone=function(tz)
{
this.tz=tz;};
clockObj.prototype.getTimeZone=function()
{
return this.tz;};
clockObj.prototype.setAlpha=function(alpha_value)
{
if(alpha_value!=null)this.alpha=alpha_value;

for(var i=0;i<this.aclock.components.length;i++){
if(this.aclock.components[i] instanceof gimage||
this.aclock.components[i] instanceof gtext||
this.aclock.components[i] instanceof gtextbox){
this.aclock.components[i].color[3]=this.alpha;}
}
for(i=0;i<this.dclock.components.length;i++){
if(this.dclock.components[i] instanceof gimage||
this.dclock.components[i] instanceof gtext||
this.dclock.components[i] instanceof gtextbox){
this.dclock.components[i].color[3]=this.alpha;}
}
};
clockObj.prototype.getAlpha=function()
{
return this.alpha;};
var FADE_TYPE=
{
IN:0,
OUT:1
};
clockObj.prototype.fade=function(param)
{
delete_timer(this);
if(param.func)param.func(this);
this.tmp={};
this.endpos={};
this.tmp.RATE=0.6;
this.tmp.max_count=param.count?param.count:9;
if(param.rate){
this.tmp.RATE=param.rate;}
if(param.count)this.tmp.max_count=param.count;
this.target=param.target;
this.tmp.dtarget=param.target;
this.tmp.f_type=FADE_TYPE.IN;
if(param.fade_type)this.tmp.f_type=param.fade_type;

force_redraw();
this.tmp_target=0;
append_timer(this,50,function (obj,count){
obj.tmp.dtarget=param.target-obj.getAlpha();
obj.tmp_target+=Math.floor(obj.tmp.dtarget*obj.tmp.RATE);
obj.setAlpha(this.getAlpha()-obj.tmp_target*-1);

if(count>=obj.tmp.max_count||
((obj.f_type==FADE_TYPE.OUT)?
(this.getAlpha()<=obj.target):
(this.getAlpha()>=obj.target))){

delete_timer(obj);

obj.setAlpha(param.target);
if(typeof param.end_func=="function"){
param.end_func(obj);}
}
force_redraw();});};
clockObj.prototype.free=function()
{
this.aclock.free();
this.dclock.free();}
clockObj.prototype.increaseZ=function()
{

this.aclock.h_hands.translate[2]=0.1;
this.aclock.m_hands.translate[2]=0.2;

for(var i=1;i<this.dclock.components.length;i++){
this.dclock.components[i].translate[2]=0.1;}
};
clockObj.prototype.getAMPMTime=function()
{
return this.dclock.time_text.text.replace(" ",":")+" "+
this.dclock.ampm_text.text;};
