var app_name="0387878700140019";
var js_path=APPLI_PATH+app_name+"/gadget/";
var png_path=js_path;
var CL_MSG=load_pkg_lang(js_path+"lang",app_name);
var with_lunar_date=is_china;
LUNAR_DATE=function(str){return "";};
if(with_lunar_date){
try{
add_package_load_path("lang_lunar_date",js_path+"/pkg_lang_lunar_date.js");
prepare_package("lang_lunar_date");
require("lang_lunar_date");
LUNAR_DATE=function(str){
return lang_lunar_date.MessageText[str];};}catch(e){
console.log("[error] can not load pkg_lang_lunar_date.js");}
}
function getFontSizeOfText(obj,text,min_font_size){
var w=obj.width;
var orig_size=obj.font_size;
for(var s=orig_size;s>min_font_size;s--){
var l=get_text_width(obj,text);
if(l<w){
break;}else {
obj.font_size=s;}
}
obj.font_size=orig_size;
return s;}
var caltext_setting=
{
month:
{
width:280,
font_size:36,
color:[85,85,85,255],
translate:[0,90,0.1],
},
lunar_day:
{
width:170,
font_size:36,
min_font_size:24,
color:[85,85,85,255],
translate:[105,-72,0.2],
},
day:
{
width:200,
font_size:36,
color:[85,85,85,255],
translate:[with_lunar_date?-90:0,-72,0.2],}
}
var digit_setting=
{
width:64,
height:138,
translate:[0,-20,0.1],
}
var DigitObj=function(setting)
{
this.superClass=container;
this.superClass({});
this.width=setting.width;
this.height=setting.height;
this.translate=[
setting.translate[0],
setting.translate[1],
setting.translate[2]
];
this.digit=new gtext({
width:this.width,
color:[85,85,85,255],
translate:[0,25,0.1],
font_size:110,
});
this.components.push(this.digit);}
DigitObj.prototype.setDigit=function(num)
{
setf_text(this.digit,num.toString());}
var DailyCalendarObj=function(w,h)
{
this.superClass=container;
this.superClass({});
this.width=w;
this.height=h;
this.dateArea=new container({});
this.monthArea=new container({});
this.translate=[0,0,0];
this.year=0;
this.month=0;
this.date=0;
this.day=0;
this.month_bg=new gbox({
width:this.width,height:this.height-180,
color:[245,175,175,255],
translate:[0,this.height/2-(this.height-180)/2,0.1]
});
this.day_bg=new gbox({
width:this.width,height:180,
color:[235,235,235,255],
translate:[0,-this.month_bg.height/2,0.1]
});

this.date_l=new DigitObj(digit_setting);
this.date_r=new DigitObj(digit_setting);
this.components.push(
this.month_bg,
this.day_bg,
this.date_l,
this.date_r
);
this.lunar_date_text=new gtext({
width:caltext_setting.lunar_day.width,
font_size:caltext_setting.lunar_day.font_size,
color:caltext_setting.lunar_day.color,
translate:caltext_setting.lunar_day.translate.slice(),
align:LEFT,
valign:MIDDLE,
text:"",
visible_p:with_lunar_date,
});
this.day_text=new gtext({
width:caltext_setting.day.width,
font_size:caltext_setting.day.font_size,
color:caltext_setting.day.color,
translate:caltext_setting.day.translate.slice(),
align:with_lunar_date?RIGHT:CENTER,
valign:MIDDLE,
text:"",
});
this.month_text=new gtext({
width:caltext_setting.month.width,
font_size:caltext_setting.month.font_size,
color:caltext_setting.month.color,
translate:caltext_setting.month.translate.slice(),
align:CENTER,
valign:MIDDLE,
text:"",
});
this.components.push(this.month_text,this.day_text,this.lunar_date_text);
if(with_lunar_date){
this.lunar=new DateLunar();}
}
DailyCalendarObj.prototype.setVisible=function(visible)
{
this.visible_p=visible;}
DailyCalendarObj.prototype.setCalendarText=function(year,month,date,day)
{
var day_list=[CL_MSG("LT_CL_SUNDAY"),CL_MSG("LT_CL_MONDAY"),CL_MSG("LT_CL_TUESDAY"),
CL_MSG("LT_CL_WEDNESDAY"),CL_MSG("LT_CL_THURSDAY"),CL_MSG("LT_CL_FRIDAY"),
CL_MSG("LT_CL_SATURDAY")];
var mon_list=[CL_MSG("LT_CL_JAN"),CL_MSG("LT_CL_FEB"),CL_MSG("LT_CL_MAR"),CL_MSG("LT_CL_APR"),
CL_MSG("LT_CL_MAY"),CL_MSG("LT_CL_JUN"),CL_MSG("LT_CL_JUL"),CL_MSG("LT_CL_AUG"),
CL_MSG("LT_CL_SEP"),CL_MSG("LT_CL_OCT"),CL_MSG("LT_CL_NOV"),CL_MSG("LT_CL_DEC"),];
var date1=Math.floor(date/10);
var date2=Math.floor(date%10);
this.date_l.setDigit(date1);
this.date_r.setDigit(date2);
if(date1==0)
{
this.date_r.translate[0]=0;
this.date_l.visible_p=false;}
else
{
this.date_l.visible_p=true;
this.date_l.translate[0]=-Math.floor(this.date_l.width/2)+3;
this.date_r.translate[0]=Math.floor(this.date_r.width/2)-3;}
setf_text(this.day_text,day_list[day]);
setf_text(this.month_text,mon_list[month]);
if(with_lunar_date){
var first_day=new Date();
first_day.setFullYear(year,month,1);
var start_day=first_day.getDay();
if(start_day==0)start_day=7;
var lunar_date="";
if((year>1900)&&(year<=2100)){
var sTermInfo=this.sTermInfo[year-1901][month];
var firstday=15-((sTermInfo>>4)&0x0f);
var secondday=15+(sTermInfo&0x0f);
var holiday_index=0;
var lunarholiday_index=0;
var lunar_str="";
var d=new Date(Date.UTC(year,month,date,0,0,0));
this.lunar.setDate(d);
if(firstday==date)lunar_str=LUNAR_DATE("LUNAR_SOLAR")[month*2];
if(secondday==date)lunar_str=LUNAR_DATE("LUNAR_SOLAR")[month*2+1];
if((month==4)&&(date+start_day==15))lunar_str=LUNAR_DATE("HOLIDAY_MO");
if((month==5)&&(date+start_day==22))lunar_str=LUNAR_DATE("HOLIDAY_FA");
if((month==10)&&(date==28-(start_day+2)%7))lunar_str=LUNAR_DATE("HOLIDAY_TH");

for(holiday_index=0;holiday_index<this.sHoliday[month].length;holiday_index++){
if(this.sHoliday[month][holiday_index].date==date+""){
var flg=true;
if((month==6)&&(date==1)&&(year<1921))flg=false;if((month==7)&&(date==1)&&(year<1933))flg=false;if((month==9)&&(date==1)&&(year<1949))flg=false;if(flg)lunar_str=this.sHoliday[month][holiday_index].text;}
}
if((this.lunar.month=="12")&&(this.lunar.monthDays(this.lunar.year,this.lunar.month)==29))this.sLunarHoliday[8].date="12-29";
else this.sLunarHoliday[8].date="12-30";
for(lunarholiday_index=0;lunarholiday_index<this.sLunarHoliday.length;lunarholiday_index++){
if((!this.lunar.isLeap)&&(this.sLunarHoliday[lunarholiday_index].date==this.lunar.month+"-"+this.lunar.day)){
lunar_str=this.sLunarHoliday[lunarholiday_index].text;}
}
if(lunar_str==""){
lunar_str=this.lunar.chinaDate()+"";
if(this.lunar.day==1){
lunar_date=lunar_str+LUNAR_DATE("LUNAR_NUM0")+LUNAR_DATE("LUNAR_NUM1");}else {
lunar_date=this.lunar.chinaMonth()+""+lunar_str;}
}else {
lunar_date=lunar_str;}
}
this.lunar_date_text.font_size=caltext_setting.lunar_day.font_size;
this.lunar_date_text.font_size=getFontSizeOfText(this.lunar_date_text,lunar_date+"",
caltext_setting.lunar_day.min_font_size);
setf_text(this.lunar_date_text,lunar_date+"");}
};
DailyCalendarObj.prototype.update=function()
{
var l_now=new Date();
var l_date=l_now.getDate();
var l_month=l_now.getMonth();
var l_year=l_now.getFullYear();
var l_day=l_now.getDay();
if((l_year!=this.year)||
(l_month!=this.month)||
(l_date!=this.date)||
(l_day!=this.day))
{
this.setCalendarText(l_year,l_month,l_date,l_day);
this.year=l_year;
this.month=l_month;
this.date=l_date;
this.day=l_day;
return true;}
return false;}
DailyCalendarObj.prototype.getTodaysDate=function()
{
return [this.year,this.month,this.date,this.day];}

if(with_lunar_date){
DailyCalendarObj.prototype.sTermInfo=new Array(
[0X96,0XB4,0X96,0XA6,0X97,0X97,0X78,0X79,0X79,0X69,0X78,0X77],
[0X96,0XA4,0X96,0X96,0X97,0X87,0X79,0X79,0X79,0X69,0X78,0X78],
[0X96,0XA5,0X87,0X96,0X87,0X87,0X79,0X69,0X69,0X69,0X78,0X78],
[0X86,0XA5,0X96,0XA5,0X96,0X97,0X88,0X78,0X78,0X79,0X78,0X87],
[0X96,0XB4,0X96,0XA6,0X97,0X97,0X78,0X79,0X79,0X69,0X78,0X77],
[0X96,0XA4,0X96,0X96,0X97,0X97,0X79,0X79,0X79,0X69,0X78,0X78],
[0X96,0XA5,0X87,0X96,0X87,0X87,0X79,0X69,0X69,0X69,0X78,0X78],
[0X86,0XA5,0X96,0XA5,0X96,0X97,0X88,0X78,0X78,0X69,0X78,0X87],
[0X96,0XB4,0X96,0XA6,0X97,0X97,0X78,0X79,0X79,0X69,0X78,0X77],
[0X96,0XA4,0X96,0X96,0X97,0X97,0X79,0X79,0X79,0X69,0X78,0X78],
[0X96,0XA5,0X87,0X96,0X87,0X87,0X79,0X69,0X69,0X69,0X78,0X78],
[0X86,0XA5,0X96,0XA5,0X96,0X97,0X88,0X78,0X78,0X69,0X78,0X87],
[0X95,0XB4,0X96,0XA6,0X97,0X97,0X78,0X79,0X79,0X69,0X78,0X77],
[0X96,0XB4,0X96,0XA6,0X97,0X97,0X79,0X79,0X79,0X69,0X78,0X78],
[0X96,0XA5,0X97,0X96,0X97,0X87,0X79,0X79,0X69,0X69,0X78,0X78],
[0X96,0XA5,0X96,0XA5,0X96,0X97,0X88,0X78,0X78,0X79,0X77,0X87],
[0X95,0XB4,0X96,0XA6,0X96,0X97,0X78,0X79,0X78,0X69,0X78,0X87],
[0X96,0XB4,0X96,0XA6,0X97,0X97,0X79,0X79,0X79,0X69,0X78,0X77],
[0X96,0XA5,0X97,0X96,0X97,0X87,0X79,0X79,0X69,0X69,0X78,0X78],
[0X96,0XA5,0X96,0XA5,0X96,0X97,0X88,0X78,0X78,0X79,0X77,0X87],
[0X95,0XB4,0X96,0XA5,0X96,0X97,0X78,0X79,0X78,0X69,0X78,0X87],
[0X96,0XB4,0X96,0XA6,0X97,0X97,0X79,0X79,0X79,0X69,0X78,0X77],
[0X96,0XA4,0X96,0X96,0X97,0X87,0X79,0X79,0X69,0X69,0X78,0X78],
[0X96,0XA5,0X96,0XA5,0X96,0X97,0X88,0X78,0X78,0X79,0X77,0X87],
[0X95,0XB4,0X96,0XA5,0X96,0X97,0X78,0X79,0X78,0X69,0X78,0X87],
[0X96,0XB4,0X96,0XA6,0X97,0X97,0X78,0X79,0X79,0X69,0X78,0X77],
[0X96,0XA4,0X96,0X96,0X97,0X87,0X79,0X79,0X79,0X69,0X78,0X78],
[0X96,0XA5,0X96,0XA5,0X96,0X96,0X88,0X78,0X78,0X78,0X87,0X87],
[0X95,0XB4,0X96,0XA5,0X96,0X97,0X88,0X78,0X78,0X79,0X77,0X87],
[0X96,0XB4,0X96,0XA6,0X97,0X97,0X78,0X79,0X79,0X69,0X78,0X77],
[0X96,0XA4,0X96,0X96,0X97,0X87,0X79,0X79,0X79,0X69,0X78,0X78],
[0X96,0XA5,0X96,0XA5,0X96,0X96,0X88,0X78,0X78,0X78,0X87,0X87],
[0X95,0XB4,0X96,0XA5,0X96,0X97,0X88,0X78,0X78,0X69,0X78,0X87],
[0X96,0XB4,0X96,0XA6,0X97,0X97,0X78,0X79,0X79,0X69,0X78,0X77],
[0X96,0XA4,0X96,0X96,0X97,0X97,0X79,0X79,0X79,0X69,0X78,0X78],
[0X96,0XA5,0X96,0XA5,0X96,0X96,0X88,0X78,0X78,0X78,0X87,0X87],
[0X95,0XB4,0X96,0XA5,0X96,0X97,0X88,0X78,0X78,0X69,0X78,0X87],
[0X96,0XB4,0X96,0XA6,0X97,0X97,0X78,0X79,0X79,0X69,0X78,0X77],
[0X96,0XA4,0X96,0X96,0X97,0X97,0X79,0X79,0X79,0X69,0X78,0X78],
[0X96,0XA5,0X96,0XA5,0X96,0X96,0X88,0X78,0X78,0X78,0X87,0X87],
[0X95,0XB4,0X96,0XA5,0X96,0X97,0X88,0X78,0X78,0X69,0X78,0X87],
[0X96,0XB4,0X96,0XA6,0X97,0X97,0X78,0X79,0X79,0X69,0X78,0X77],
[0X96,0XA4,0X96,0X96,0X97,0X97,0X79,0X79,0X79,0X69,0X78,0X78],
[0X96,0XA5,0X96,0XA5,0XA6,0X96,0X88,0X78,0X78,0X78,0X87,0X87],
[0X95,0XB4,0X96,0XA5,0X96,0X97,0X88,0X78,0X78,0X79,0X77,0X87],
[0X95,0XB4,0X96,0XA6,0X97,0X97,0X78,0X79,0X78,0X69,0X78,0X77],
[0X96,0XB4,0X96,0XA6,0X97,0X97,0X79,0X79,0X79,0X69,0X78,0X78],
[0X96,0XA5,0XA6,0XA5,0XA6,0X96,0X88,0X88,0X78,0X78,0X87,0X87],
[0XA5,0XB4,0X96,0XA5,0X96,0X97,0X88,0X79,0X78,0X79,0X77,0X87],
[0X95,0XB4,0X96,0XA5,0X96,0X97,0X78,0X79,0X78,0X69,0X78,0X77],
[0X96,0XB4,0X96,0XA6,0X97,0X97,0X79,0X79,0X79,0X69,0X78,0X78],
[0X96,0XA5,0XA6,0XA5,0XA6,0X96,0X88,0X88,0X78,0X78,0X87,0X87],
[0XA5,0XB4,0X96,0XA5,0X96,0X97,0X88,0X78,0X78,0X79,0X77,0X87],
[0X95,0XB4,0X96,0XA5,0X96,0X97,0X78,0X79,0X78,0X68,0X78,0X87],
[0X96,0XB4,0X96,0XA6,0X97,0X97,0X78,0X79,0X79,0X69,0X78,0X77],
[0X96,0XA5,0XA5,0XA5,0XA6,0X96,0X88,0X88,0X78,0X78,0X87,0X87],
[0XA5,0XB4,0X96,0XA5,0X96,0X97,0X88,0X78,0X78,0X79,0X77,0X87],
[0X95,0XB4,0X96,0XA5,0X96,0X97,0X88,0X78,0X78,0X69,0X78,0X87],
[0X96,0XB4,0X96,0XA6,0X97,0X97,0X78,0X79,0X79,0X69,0X78,0X77],
[0X96,0XA4,0XA5,0XA5,0XA6,0X96,0X88,0X88,0X88,0X78,0X87,0X87],
[0XA5,0XB4,0X96,0XA5,0X96,0X96,0X88,0X78,0X78,0X78,0X87,0X87],
[0X96,0XB4,0X96,0XA5,0X96,0X97,0X88,0X78,0X78,0X69,0X78,0X87],
[0X96,0XB4,0X96,0XA6,0X97,0X97,0X78,0X79,0X79,0X69,0X78,0X77],
[0X96,0XA4,0XA5,0XA5,0XA6,0X96,0X88,0X88,0X88,0X78,0X87,0X87],
[0XA5,0XB4,0X96,0XA5,0X96,0X96,0X88,0X78,0X78,0X78,0X87,0X87],
[0X95,0XB4,0X96,0XA5,0X96,0X97,0X88,0X78,0X78,0X69,0X78,0X87],
[0X96,0XB4,0X96,0XA6,0X97,0X97,0X78,0X79,0X79,0X69,0X78,0X77],
[0X96,0XA4,0XA5,0XA5,0XA6,0XA6,0X88,0X88,0X88,0X78,0X87,0X87],
[0XA5,0XB4,0X96,0XA5,0X96,0X96,0X88,0X78,0X78,0X78,0X87,0X87],
[0X95,0XB4,0X96,0XA5,0X96,0X97,0X88,0X78,0X78,0X69,0X78,0X87],
[0X96,0XB4,0X96,0XA6,0X97,0X97,0X78,0X79,0X79,0X69,0X78,0X77],
[0X96,0XA4,0XA5,0XA5,0XA6,0XA6,0X88,0X88,0X88,0X78,0X87,0X87],
[0XA5,0XB5,0X96,0XA5,0XA6,0X96,0X88,0X78,0X78,0X78,0X87,0X87],
[0X95,0XB4,0X96,0XA5,0X96,0X97,0X88,0X78,0X78,0X69,0X78,0X87],
[0X96,0XB4,0X96,0XA6,0X97,0X97,0X78,0X79,0X78,0X69,0X78,0X77],
[0X96,0XA4,0XA5,0XB5,0XA6,0XA6,0X88,0X89,0X88,0X78,0X87,0X87],
[0XA5,0XB4,0X96,0XA5,0X96,0X96,0X88,0X88,0X78,0X78,0X87,0X87],
[0X95,0XB4,0X96,0XA5,0X96,0X97,0X88,0X78,0X78,0X79,0X78,0X87],
[0X96,0XB4,0X96,0XA6,0X96,0X97,0X78,0X79,0X78,0X69,0X78,0X77],
[0X96,0XA4,0XA5,0XB5,0XA6,0XA6,0X88,0X88,0X88,0X78,0X87,0X87],
[0XA5,0XB4,0X96,0XA5,0XA6,0X96,0X88,0X88,0X78,0X78,0X77,0X87],
[0X95,0XB4,0X96,0XA5,0X96,0X97,0X88,0X78,0X78,0X79,0X77,0X87],
[0X95,0XB4,0X96,0XA5,0X96,0X97,0X78,0X79,0X78,0X69,0X78,0X77],
[0X96,0XB4,0XA5,0XB5,0XA6,0XA6,0X87,0X88,0X88,0X78,0X87,0X87],
[0XA5,0XB4,0XA6,0XA5,0XA6,0X96,0X88,0X88,0X78,0X78,0X87,0X87],
[0XA5,0XB4,0X96,0XA5,0X96,0X97,0X88,0X78,0X78,0X79,0X77,0X87],
[0X95,0XB4,0X96,0XA5,0X96,0X97,0X88,0X79,0X78,0X69,0X78,0X87],
[0X96,0XB4,0XA5,0XB5,0XA6,0XA6,0X87,0X88,0X88,0X78,0X87,0X86],
[0XA5,0XB4,0XA5,0XA5,0XA6,0X96,0X88,0X88,0X88,0X78,0X87,0X87],
[0XA5,0XB4,0X96,0XA5,0X96,0X96,0X88,0X78,0X78,0X79,0X77,0X87],
[0X95,0XB4,0X96,0XA5,0X86,0X97,0X88,0X78,0X78,0X69,0X78,0X87],
[0X96,0XB4,0XA5,0XB5,0XA6,0XA6,0X87,0X88,0X88,0X78,0X87,0X86],
[0XA5,0XB3,0XA5,0XA5,0XA6,0X96,0X88,0X88,0X88,0X78,0X87,0X87],
[0XA5,0XB4,0X96,0XA5,0X96,0X96,0X88,0X78,0X78,0X78,0X87,0X87],
[0X95,0XB4,0X96,0XA5,0X96,0X97,0X88,0X76,0X78,0X69,0X78,0X87],
[0X96,0XB4,0XA5,0XB5,0XA6,0XA6,0X87,0X88,0X88,0X78,0X87,0X86],
[0XA5,0XB3,0XA5,0XA5,0XA6,0XA6,0X88,0X88,0X88,0X78,0X87,0X87],
[0XA5,0XB4,0X96,0XA5,0X96,0X96,0X88,0X78,0X78,0X78,0X87,0X87],
[0X95,0XB4,0X96,0XA5,0X96,0X97,0X88,0X78,0X78,0X69,0X78,0X87],
[0X96,0XB4,0XA5,0XB5,0XA6,0XA6,0X87,0X88,0X88,0X78,0X87,0X86],
[0XA5,0XB3,0XA5,0XA5,0XA6,0XA6,0X88,0X88,0X88,0X78,0X87,0X87],
[0XA5,0XB4,0X96,0XA5,0X96,0X96,0X88,0X78,0X78,0X78,0X87,0X87],
[0X95,0XB4,0X96,0XA5,0X96,0X97,0X88,0X78,0X78,0X69,0X78,0X87],
[0X96,0XB4,0XA5,0XB5,0XA6,0XA6,0X87,0X88,0X88,0X78,0X87,0X86],
[0XA5,0XB3,0XA5,0XA5,0XA6,0XA6,0X88,0X88,0X88,0X78,0X87,0X87],
[0XA5,0XB4,0X96,0XA5,0XA6,0X96,0X88,0X88,0X78,0X78,0X87,0X87],
[0X95,0XB4,0X96,0XA5,0X96,0X97,0X88,0X78,0X78,0X69,0X78,0X87],
[0X96,0XB4,0XA5,0XB5,0XA6,0XA6,0X87,0X88,0X87,0X78,0X87,0X86],
[0XA5,0XB3,0XA5,0XB5,0XA6,0XA6,0X88,0X88,0X88,0X78,0X87,0X87],
[0XA5,0XB4,0X96,0XA5,0XA6,0X96,0X88,0X88,0X78,0X78,0X87,0X87],
[0X95,0XB4,0X96,0XA5,0X96,0X97,0X88,0X78,0X78,0X79,0X78,0X87],
[0X96,0XB4,0XA5,0XB5,0XA5,0XA6,0X87,0X88,0X87,0X78,0X87,0X86],
[0XA5,0XB3,0XA5,0XB5,0XA6,0XA6,0X87,0X88,0X88,0X78,0X87,0X87],
[0XA5,0XB4,0X96,0XA5,0XA6,0X96,0X88,0X88,0X78,0X78,0X87,0X87],
[0X95,0XB4,0X96,0XA5,0X96,0X97,0X88,0X78,0X78,0X79,0X77,0X87],
[0X95,0XB4,0XA5,0XB4,0XA5,0XA6,0X87,0X88,0X87,0X78,0X87,0X86],
[0XA5,0XC3,0XA5,0XB5,0XA6,0XA6,0X87,0X88,0X88,0X78,0X87,0X87],
[0XA5,0XB4,0XA6,0XA5,0XA6,0X96,0X88,0X88,0X78,0X78,0X87,0X87],
[0XA5,0XB4,0X96,0XA5,0X96,0X96,0X88,0X78,0X78,0X79,0X77,0X87],
[0X95,0XB4,0XA5,0XB4,0XA5,0XA6,0X97,0X87,0X87,0X78,0X87,0X86],
[0XA5,0XC3,0XA5,0XB5,0XA6,0XA6,0X87,0X88,0X88,0X78,0X87,0X86],
[0XA5,0XB4,0XA5,0XA5,0XA6,0X96,0X88,0X88,0X88,0X78,0X87,0X87],
[0XA5,0XB4,0X96,0XA5,0X96,0X96,0X88,0X78,0X78,0X79,0X77,0X87],
[0X95,0XB4,0XA5,0XB4,0XA5,0XA6,0X97,0X87,0X87,0X78,0X87,0X96],
[0XA5,0XC3,0XA5,0XB5,0XA6,0XA6,0X87,0X88,0X88,0X78,0X87,0X86],
[0XA5,0XB3,0XA5,0XA5,0XA6,0XA6,0X88,0X88,0X88,0X78,0X87,0X87],
[0XA5,0XB4,0X96,0XA5,0X96,0X96,0X88,0X78,0X78,0X78,0X87,0X87],
[0X95,0XB4,0XA5,0XB4,0XA5,0XA6,0X97,0X87,0X87,0X78,0X87,0X96],
[0XA5,0XC3,0XA5,0XB5,0XA6,0XA6,0X87,0X88,0X88,0X78,0X87,0X86],
[0XA5,0XB3,0XA5,0XA5,0XA6,0XA6,0X88,0X88,0X88,0X78,0X87,0X87],
[0XA5,0XB4,0X96,0XA5,0X96,0X96,0X88,0X78,0X78,0X78,0X87,0X87],
[0X95,0XB4,0XA5,0XB4,0XA5,0XA6,0X97,0X87,0X87,0X78,0X87,0X96],
[0XA5,0XC3,0XA5,0XB5,0XA6,0XA6,0X87,0X88,0X88,0X78,0X87,0X86],
[0XA5,0XB3,0XA5,0XA5,0XA6,0XA6,0X88,0X88,0X88,0X78,0X87,0X87],
[0XA5,0XB4,0X96,0XA5,0XA6,0X96,0X88,0X88,0X78,0X78,0X87,0X87],
[0X95,0XB4,0XA5,0XB4,0XA5,0XA6,0X97,0X87,0X87,0X78,0X87,0X96],
[0XA5,0XC3,0XA5,0XB5,0XA6,0XA6,0X87,0X88,0X88,0X78,0X87,0X86],
[0XA5,0XB3,0XA5,0XA5,0XA6,0XA6,0X88,0X88,0X88,0X78,0X87,0X87],
[0XA5,0XB4,0X96,0XA5,0XA6,0X96,0X88,0X88,0X78,0X78,0X87,0X87],
[0X95,0XB4,0XA5,0XB4,0XA5,0XA6,0X97,0X87,0X87,0X78,0X87,0X96],
[0XA5,0XC3,0XA5,0XB5,0XA5,0XA6,0X87,0X88,0X87,0X78,0X87,0X86],
[0XA5,0XB3,0XA5,0XB5,0XA6,0XA6,0X88,0X88,0X88,0X78,0X87,0X87],
[0XA5,0XB4,0X96,0XA5,0XA6,0X96,0X88,0X88,0X78,0X78,0X87,0X87],
[0X95,0XB4,0XA5,0XB4,0XA5,0XA6,0X97,0X87,0X87,0X88,0X87,0X96],
[0XA5,0XC3,0XA5,0XB4,0XA5,0XA6,0X87,0X88,0X87,0X78,0X87,0X86],
[0XA5,0XB3,0XA5,0XB5,0XA6,0XA6,0X87,0X88,0X88,0X78,0X87,0X87],
[0XA5,0XB4,0X96,0XA5,0XA6,0X96,0X88,0X88,0X78,0X78,0X87,0X87],
[0X95,0XB4,0XA5,0XB4,0XA5,0XA5,0X97,0X87,0X87,0X88,0X86,0X96],
[0XA4,0XC3,0XA5,0XB4,0XA5,0XA6,0X97,0X87,0X87,0X78,0X87,0X86],
[0XA5,0XC3,0XA5,0XB5,0XA6,0XA6,0X87,0X88,0X88,0X78,0X87,0X87],
[0XA5,0XB4,0XA5,0XA5,0XA6,0X96,0X88,0X88,0X88,0X78,0X87,0X87],
[0XA5,0XB4,0XA5,0XB4,0XA5,0XA5,0X97,0X87,0X87,0X88,0X86,0X96],
[0XA4,0XC3,0XA5,0XB4,0XA5,0XA6,0X97,0X87,0X87,0X78,0X87,0X86],
[0XA5,0XC3,0XA5,0XB5,0XA6,0XA6,0X87,0X88,0X88,0X78,0X87,0X87],
[0XA5,0XB4,0XA5,0XA5,0XA6,0XA6,0X88,0X88,0X88,0X78,0X87,0X87],
[0XA5,0XB4,0XA5,0XB4,0XA5,0XA5,0X97,0X87,0X87,0X88,0X86,0X96],
[0XA4,0XC3,0XA5,0XB4,0XA5,0XA6,0X97,0X87,0X87,0X78,0X87,0X96],
[0XA5,0XC3,0XA5,0XB5,0XA6,0XA6,0X87,0X88,0X88,0X78,0X87,0X86],
[0XA5,0XB4,0XA5,0XA5,0XA6,0XA6,0X88,0X88,0X88,0X78,0X87,0X87],
[0XA5,0XB4,0XA5,0XB4,0XA5,0XA5,0X97,0X87,0X87,0X87,0X96,0X96],
[0XA4,0XC3,0XA5,0XB4,0XA5,0XA6,0X97,0X87,0X87,0X78,0X87,0X96],
[0XA5,0XC3,0XA5,0XB5,0XA6,0XA6,0X87,0X88,0X88,0X78,0X87,0X86],
[0XA5,0XB3,0XA5,0XA5,0XA6,0XA6,0X88,0X88,0X88,0X78,0X87,0X87],
[0XA5,0XB4,0XA5,0XB4,0XA5,0XA5,0X97,0X87,0X87,0X87,0X96,0X96],
[0XA4,0XC3,0XA5,0XB4,0XA5,0XA6,0X97,0X87,0X87,0X78,0X87,0X96],
[0XA5,0XC3,0XA5,0XB5,0XA6,0XA6,0X87,0X88,0X88,0X78,0X87,0X86],
[0XA5,0XB3,0XA5,0XA5,0XA6,0XA6,0X88,0X88,0X88,0X78,0X87,0X87],
[0XA5,0XB4,0XA5,0XB4,0XB5,0XA5,0X97,0X97,0X87,0X87,0X96,0X96],
[0XA4,0XC3,0XA5,0XB4,0XA5,0XA6,0X97,0X87,0X87,0X78,0X87,0X96],
[0XA5,0XC3,0XA5,0XB5,0XA5,0XA6,0X87,0X88,0X87,0X78,0X87,0X86],
[0XA5,0XB3,0XA5,0XA5,0XA6,0XA6,0X88,0X88,0X88,0X78,0X87,0X87],
[0XA5,0XB4,0XA5,0XB4,0XB5,0XA5,0X97,0X97,0X87,0X87,0X96,0X96],
[0XA4,0XC3,0XA5,0XB4,0XA5,0XA6,0X97,0X87,0X87,0X88,0X87,0X96],
[0XA5,0XC3,0XA5,0XB5,0XA5,0XA6,0X87,0X88,0X87,0X78,0X87,0X86],
[0XA5,0XB3,0XA5,0XB5,0XA6,0XA6,0X87,0X88,0X88,0X78,0X87,0X87],
[0XA5,0XB4,0XA5,0XB4,0XB5,0XA5,0X97,0X97,0X87,0X87,0X96,0X96],
[0XA4,0XC3,0XA5,0XB4,0XA5,0XA6,0X97,0X87,0X87,0X88,0X87,0X96],
[0XA5,0XC3,0XA5,0XB4,0XA5,0XA6,0X97,0X88,0X87,0X78,0X87,0X86],
[0XA5,0XB3,0XA5,0XB5,0XA6,0XA6,0X87,0X88,0X88,0X78,0X87,0X87],
[0XA5,0XB4,0XA5,0XB4,0XB5,0XA5,0X97,0X97,0X87,0X87,0X96,0X96],
[0XA4,0XC3,0XA5,0XB4,0XA5,0XA5,0X97,0X87,0X87,0X88,0X86,0X96],
[0XA5,0XC3,0XA5,0XB4,0XA5,0XA6,0X97,0X87,0X87,0X78,0X87,0X86],
[0XA5,0XC3,0XA5,0XB5,0XA6,0XA6,0X87,0X88,0X88,0X78,0X87,0X87],
[0XA5,0XB4,0XB4,0XB4,0XB5,0XA5,0X97,0X97,0X97,0X87,0X96,0X96],
[0XB4,0XC3,0XA5,0XB4,0XA5,0XA5,0X97,0X87,0X87,0X88,0X86,0X96],
[0XA4,0XC3,0XA5,0XB4,0XA5,0XA6,0X97,0X87,0X87,0X78,0X87,0X86],
[0XA5,0XC3,0XA5,0XB5,0XA6,0XA6,0X87,0X88,0X88,0X78,0X87,0X87],
[0XA5,0XB4,0XB4,0XB4,0XB5,0XB5,0X97,0X97,0X97,0X87,0X96,0X96],
[0XB4,0XC3,0XA5,0XB4,0XA5,0XA5,0X97,0X87,0X87,0X88,0X86,0X96],
[0XA4,0XC3,0XA5,0XB4,0XA5,0XA6,0X97,0X87,0X87,0X78,0X87,0X96],
[0XA5,0XC3,0XA5,0XB5,0XA6,0XA6,0X87,0X88,0X88,0X78,0X87,0X86],
[0XA5,0XB4,0XB4,0XB4,0XB5,0XB5,0X97,0X97,0X97,0X87,0X96,0X96],
[0XB4,0XC3,0XA5,0XB4,0XA5,0XA5,0X97,0X87,0X87,0X87,0X96,0X96],
[0XA4,0XC3,0XA5,0XB4,0XA5,0XA6,0X97,0X87,0X87,0X78,0X87,0X96],
[0XA5,0XC3,0XA5,0XB5,0XA6,0XA6,0X87,0X88,0X88,0X78,0X87,0X86],
[0XA5,0XB3,0XB4,0XB4,0XB5,0XB5,0X97,0X97,0X97,0X87,0X96,0X96],
[0XB4,0XC3,0XA5,0XB4,0XA5,0XA5,0X97,0X97,0X87,0X87,0X96,0X96],
[0XA4,0XC3,0XA5,0XB4,0XA5,0XA6,0X97,0X87,0X87,0X78,0X87,0X96],
[0XA5,0XC3,0XA5,0XB5,0XA6,0XA6,0X87,0X88,0X88,0X78,0X87,0X86],
[0XA5,0XB3,0XA5,0XA5,0XA6,0XA6,0X88,0X88,0X88,0X78,0X87,0X87]
);
DailyCalendarObj.prototype.sHoliday=new Array(
[{"date":"1","text":LUNAR_DATE("HOLIDAY_11")}],[{"date":"14","text":LUNAR_DATE("HOLIDAY_214")}],
[{"date":"8","text":LUNAR_DATE("HOLIDAY_38")},{"date":"12","text":LUNAR_DATE("HOLIDAY_312")}],
[{"date":"1","text":LUNAR_DATE("HOLIDAY_41")}],
[{"date":"1","text":LUNAR_DATE("HOLIDAY_51")},{"date":"4","text":LUNAR_DATE("HOLIDAY_54")}],
[{"date":"1","text":LUNAR_DATE("HOLIDAY_61")}],[{"date":"1","text":LUNAR_DATE("HOLIDAY_71")}],
[{"date":"1","text":LUNAR_DATE("HOLIDAY_81")}],
[{"date":"10","text":LUNAR_DATE("HOLIDAY_910")}],
[{"date":"1","text":LUNAR_DATE("HOLIDAY_101")}],
[{"date":"1","text":LUNAR_DATE("HOLIDAY_111")},{"date":"11","text":LUNAR_DATE("HOLIDAY_1111")}],
[{"date":"25","text":LUNAR_DATE("HOLIDAY_1225")}]);
DailyCalendarObj.prototype.sLunarHoliday=new Array(
{"date":"1-1","text":LUNAR_DATE("LUNARHOLIDAY_11")},{"date":"1-15","text":LUNAR_DATE("LUNARHOLIDAY_115")},
{"date":"5-5","text":LUNAR_DATE("LUNARHOLIDAY_55")},{"date":"7-7","text":LUNAR_DATE("LUNARHOLIDAY_77")},
{"date":"7-15","text":LUNAR_DATE("LUNARHOLIDAY_715")},{"date":"8-15","text":LUNAR_DATE("LUNARHOLIDAY_815")},
{"date":"9-9","text":LUNAR_DATE("LUNARHOLIDAY_99")},{"date":"12-8","text":LUNAR_DATE("LUNARHOLIDAY_128")},
{"date":"12-30","text":LUNAR_DATE("LUNARHOLIDAY_1230")});

function DateLunar(){
}
DateLunar.prototype.setDate=function (objDate){
var i,leap=0,temp=0;
var baseDate=new Date(Date.UTC(1900,0,31));
var offset=(objDate-baseDate)/86400000;


this.objDate=objDate;
for(i=1900;i<=2100&&offset>0;i++){
temp=this.lYearDays(i);
offset-=temp;}
if(offset<0){
offset+=temp;
i--;}
this.year=i;
leap=this.leapMonth(i);
this.isLeap=false;
for(i=1;i<13&&offset>0;i++){
if(leap>0&&i==(leap+1)&&this.isLeap==false){
--i;
this.isLeap=true;
temp=this.leapDays(this.year);}else {
temp=this.monthDays(this.year,i);}
if(this.isLeap==true&&i==(leap+1))this.isLeap=false;
offset-=temp;}
if(offset==0&&leap>0&&i==leap+1)
if(this.isLeap){
this.isLeap=false;}else{
this.isLeap=true;
--i;}

if(offset<0){
offset+=temp;--i;}
this.month=i;
this.day=offset+1;};
DateLunar.prototype.lunarInfo=new Array(
0x4bd8,0x4ae0,0xa570,0x54d5,0xd260,0xd950,0x5554,0x56af,0x9ad0,0x55d2,0x4ae0,0xa5b6,0xa4d0,0xd250,0xd295,0xb54f,0xd6a0,0xada2,0x95b0,0x4977,0x497f,0xa4b0,0xb4b5,0x6a50,0x6d40,0xab54,0x2b6f,0x9570,0x52f2,0x4970,0x6566,0xd4a0,0xea50,0x6a95,0x5adf,0x2b60,0x86e3,0x92ef,0xc8d7,0xc95f,0xd4a0,0xd8a6,0xb55f,0x56a0,0xa5b4,0x25df,0x92d0,0xd2b2,0xa950,0xb557,0x6ca0,0xb550,0x5355,0x4daf,0xa5b0,0x4573,0x52bf,0xa9a8,0xe950,0x6aa0,0xaea6,0xab50,0x4b60,0xaae4,0xa570,0x5260,0xf263,0xd950,0x5b57,0x56a0,0x96d0,0x4dd5,0x4ad0,0xa4d0,0xd4d4,0xd250,0xd558,0xb540,0xb6a0,0x95a6,0x95bf,0x49b0,0xa974,0xa4b0,0xb27a,0x6a50,0x6d40,0xaf46,0xab60,0x9570,0x4af5,0x4970,0x64b0,0x74a3,0xea50,0x6b58,0x5ac0,0xab60,0x96d5,0x92e0,0xc960,0xd954,0xd4a0,0xda50,0x7552,0x56a0,0xabb7,0x25d0,0x92d0,0xcab5,0xa950,0xb4a0,0xbaa4,0xad50,0x55d9,0x4ba0,0xa5b0,0x5176,0x52bf,0xa930,0x7954,0x6aa0,0xad50,0x5b52,0x4b60,0xa6e6,0xa4e0,0xd260,0xea65,0xd530,0x5aa0,0x76a3,0x96d0,0x4afb,0x4ad0,0xa4d0,0xd0b6,0xd25f,0xd520,0xdd45,0xb5a0,0x56d0,0x55b2,0x49b0,0xa577,0xa4b0,0xaa50,0xb255,0x6d2f,0xada0,0x4b63,0x937f,0x49f8,0x4970,0x64b0,0x68a6,0xea5f,0x6b20,0xa6c4,0xaaef,0x92e0,0xd2e3,0xc960,0xd557,0xd4a0,0xda50,0x5d55,0x56a0,0xa6d0,0x55d4,0x52d0,0xa9b8,0xa950,0xb4a0,0xb6a6,0xad50,0x55a0,0xaba4,0xa5b0,0x52b0,0xb273,0x6930,0x7337,0x6aa0,0xad50,0x4b55,0x4b6f,0xa570,0x54e4,0xd260,0xe968,0xd520,0xdaa0,0x6aa6,0x56df,0x4ae0,0xa9d4,0xa4d0,0xd150,0xf252,0xd520);
DateLunar.prototype.lYearDays=function (y){
var i,sum=348;
for(i=0x8000;i>0x8;i>>=1)sum+=(this.lunarInfo[y-1900]&i)?1:0;
return(sum+this.leapDays(y));};
DateLunar.prototype.leapDays=function (y){
if(this.leapMonth(y))return((this.lunarInfo[y-1899]&0xf)==0xf?30:29);
else return(0);};
DateLunar.prototype.leapMonth=function (y){
var lm=this.lunarInfo[y-1900]&0xf;
return(lm==0xf?0:lm);};
DateLunar.prototype.monthDays=function (y,m){
return((this.lunarInfo[y-1900]&(0x10000>>m))?30:29);};
DateLunar.prototype.cyclical=function (){
var num=this.year-1900+36;
return(LUNAR_DATE("LUNAR_GAN[num%10]")+LUNAR_DATE("LUNAR_ZHI[num%12]"));};
DateLunar.prototype.chinaMonth=function (){
var nStr1=[LUNAR_DATE("LUNAR_NUM0"),LUNAR_DATE("LUNAR_NUM1"),LUNAR_DATE("LUNAR_NUM2"),LUNAR_DATE("LUNAR_NUM3"),LUNAR_DATE("LUNAR_NUM4"),
LUNAR_DATE("LUNAR_NUM5"),LUNAR_DATE("LUNAR_NUM6"),LUNAR_DATE("LUNAR_NUM7"),LUNAR_DATE("LUNAR_NUM8"),LUNAR_DATE("LUNAR_NUM9"),LUNAR_DATE("LUNAR_NUM10")];
var lunarMonth=this.month;
var s;
if(lunarMonth>10){s=LUNAR_DATE("LUNAR_NUM10")+nStr1[lunarMonth-10];}else {s=nStr1[lunarMonth];}s+=LUNAR_DATE("LUNAR_MONTH");
if(lunarMonth==1)s=LUNAR_DATE("LUNAR_MONTH1");
if(this.isLeap)s=LUNAR_DATE("LUNAR_RUN")+s;
if(s==LUNAR_DATE("LUNAR_RUN")+LUNAR_DATE("LUNAR_NUM10")+LUNAR_DATE("LUNAR_NUM1")+LUNAR_DATE("LUNAR_MONTH"))s=LUNAR_DATE("LUNAR_RUN11");
return(s);};
DateLunar.prototype.chinaDate=function (){
var nStr1=new Array(LUNAR_DATE("LUNAR_DAY"),LUNAR_DATE("LUNAR_NUM1"),LUNAR_DATE("LUNAR_NUM2"),LUNAR_DATE("LUNAR_NUM3"),LUNAR_DATE("LUNAR_NUM4"),
LUNAR_DATE("LUNAR_NUM5"),LUNAR_DATE("LUNAR_NUM6"),LUNAR_DATE("LUNAR_NUM7"),LUNAR_DATE("LUNAR_NUM8"),LUNAR_DATE("LUNAR_NUM9"),LUNAR_DATE("LUNAR_NUM10"));
var nStr2=new Array(LUNAR_DATE("LUNAR_NUM0"),LUNAR_DATE("LUNAR_NUM10"),LUNAR_DATE("LUNAR_NUM20"),LUNAR_DATE("LUNAR_NUM30"),'　');
var lunarday=this.day;
var s;
switch(lunarday){
case 1:s=this.chinaMonth();break;
case 10:s=LUNAR_DATE("LUNAR_NUM0")+LUNAR_DATE("LUNAR_NUM10");break;
case 20:s=LUNAR_DATE("LUNAR_NUM2")+LUNAR_DATE("LUNAR_NUM10");break;
case 30:s=LUNAR_DATE("LUNAR_NUM3")+LUNAR_DATE("LUNAR_NUM10");break;
default:s=nStr2[Math.floor(lunarday/10)];s+=nStr1[lunarday%10];}
return(s);};}
provide("daily_calendar_obj");
