//
// Copyright (C) 2011 Panasonic Corporation. All Rights Reserved.
//

const PANEL_WIDTH = 1280;
const PANEL_HEIGHT = 812;
const PANEL_TRANSLATE = [0,0,0];
const YELLOW = [255,255,0,255];
const LIGHT_BLUE = [155,155,255,255];
const BLUE = [55,55,255,255];
const RED = [255,55,55,255];
const BLACK = [0,0,0,255];
const GLAY = [100,100,100,255];
const WHITE = [255,255,255,255];
const TITLE_HEIGHT = Math.floor(PANEL_HEIGHT/5);
const TITLE_TRANSLATE = [0,Math.floor((PANEL_HEIGHT - TITLE_HEIGHT)/2),0];
const ITEM_WIDTH = PANEL_WIDTH - 100;
const ITEM_HEIGHT = PANEL_HEIGHT - TITLE_HEIGHT - 10;
const ITEM_TRANSLATE = [0,-Math.floor((PANEL_HEIGHT - ITEM_HEIGHT)/2),0];
const POPUP_WIDTH = ITEM_WIDTH;
const POPUP_HEIGHT = 100;
const POPUP_TRANSLATE = [0,-300,0];
const CHEAT_CODE = [TXK_UP, TXK_DOWN, TXK_LEFT, TXK_RIGHT, TXK_D8, TXK_D7, TXK_D8, TXK_D7];
var cheat_mode = false;
var cheat_code_count = 0;


var bg = new gbox ({
  width:1920,
  height:1080,
  translate: [0, 0, 0],
  color:GLAY});
var panel = new gbox ({
  width:PANEL_WIDTH,
  height:PANEL_HEIGHT,
  translate: PANEL_TRANSLATE,
  color:LIGHT_BLUE});
var title_bg = new gbox ({
  width:PANEL_WIDTH,
  height:TITLE_HEIGHT,
  translate: TITLE_TRANSLATE,
  color:BLACK});
var title_text = new gtext ({
  width: PANEL_WIDTH,
  translate: TITLE_TRANSLATE,
  text: "For developers only",
  font_size: TITLE_HEIGHT - 30,
  align: CENTER});

function create_item (str, trans, bool) {
  var c = new container ({
    translate: trans});
  var circle = new gbox ({
    width:20,
    height:20,
    round_enable:true,
    round_width:10,
    round_height:10,
    translate:[-Math.floor(ITEM_WIDTH/2),0,0],
    color:BLACK});
  var detail = new gtext ({
    width: ITEM_WIDTH - 100,
    translate:[0,0,0],
    text: str,
    font_size: 50,
    color: BLACK,
    align: LEFT});

  if (bool)
    c.components.push(circle);
  c.components.push(detail);
  return c;
}

function create_mini_item (str, trans, bool) {
  var c = new container ({
    translate: trans});
  var circle = new gbox ({
    width:10,
    height:10,
    translate:[-Math.floor(ITEM_WIDTH/2)+100,0,0],
    color:BLACK});
  var detail = new gtext ({
    width: ITEM_WIDTH - 100,
    translate:[100,0,0],
    text: str,
    font_size: 40,
    color: BLACK,
    align: LEFT});

  if (bool)
    c.components.push(circle);
  c.components.push(detail);
  return c;
}

var item1 = create_item ("If you want to use VIERA Connect, ", [0,150,0], true);
var item2 = create_item ("please delete following files from this SD card.", [0,75,0], false);
var item3 = create_mini_item (".__vc_developer_tool_alter_data_key.dat", [0,0,0], true);
var item4 = create_mini_item (".__vc_developer_tool_serial_number.dat", [0,-75,0], true);

function check_cheat_code (keysym) {
  if (keysym == CHEAT_CODE[cheat_code_count]) {
    cheat_code_count += 1;
  } else {
    cheat_code_count = 0;
  }
  if (cheat_code_count == CHEAT_CODE.length) {
    cheat_mode = true;
    cheat_code_count = 0;
  }
}

var popup = new container ({visible_p: false});
popup.components.push (new gbox ({
  width: POPUP_WIDTH + 10,
  height: POPUP_HEIGHT + 10,
  translate: POPUP_TRANSLATE,
  color: BLACK}));
popup.components.push (new gbox ({
  width: POPUP_WIDTH,
  height: POPUP_HEIGHT,
  translate: POPUP_TRANSLATE,
  color: BLUE}));
popup.components.push (new gtext ({
  width: POPUP_WIDTH,
  translate: POPUP_TRANSLATE,
  text: "",
  font_size: 40,
  color: WHITE,
  align: CENTER}));

function popup_message (str, col) {
  popup.visible_p = true;
  popup.components[1].color = col;
  setf_text (popup.components[2], str);
}

var home_stage = stage ({
  symbol: "home_screen",
  in:[{
    from: ["default"],
    hook: function (obj) {
      //      set_screen_mode (PIP_PICTURE_MODE);
      set_screen_mode (OSD_ONLY_MODE);
      console.log ("on stage: ");
      complete_on_stage(obj);
    }}],
  out: [
    {
      to: ["default"],
      hook: function (obj) {
        complete_off_stage (obj);
      }
    }
  ],
  components: [
    bg,
    panel,
    title_bg,
    title_text,
    item1,
    item2,
    item3,
    item4,
    popup
  ],
  key_hook: function (up_down, keysym) {
    if (up_down==KEY_DOWN) {
      if (popup.visible_p) {
        popup.visible_p = false;
        force_redraw ();
      }
      if (cheat_mode) {
        switch (keysym) {
         case TXK_ENTER:
	  break;
         case TXK_D1:
          try {
            ebus.developer_tool.get_serial_number ();
            popup_message ("complete to get serial number", BLUE);
          } catch (e) {
            popup_message (e.message, RED);
          }
	  break;
         case TXK_D2:
          try {
            ebus.developer_tool.update_device_data ();
            popup_message ("complete to update data", BLUE);
          } catch (e) {
            popup_message (e.message, RED);
          }
	  break;
         case TXK_D3:
          try {
            ebus.developer_tool.restore_device_data ();
            popup_message ("complete to restore data", BLUE);
          } catch (e) {
            popup_message (e.message, RED);
          }
	  break;
        }
        cheat_mode = false;
      } else {
        check_cheat_code (keysym);
      }
    }
    return true;
  }
});
