var Tool = {
    stage : null,
    index : 1,
    updateFlg : true,
    innerFlg : false,
    current : {},
    prev : {},
    currentText : {},
    focus : null,
    ctrlFlg : false,
    altFlg : false,
    currents : [],
    groups : {},
    spriteSheet : null,
    defaultFocus : null,
    root : null,
    cursor : new createjs.Container(),
    menu : null,
    noneSelect : false,
    begin : false,
    background : null
};

var UI = {
    frontStage : null,
    backStage : null,
    currKeyCode : null,
    loadedModule : [],
    currModule : {},
    time : 0,
    keyState : null,
    loader : new createjs.LoadQueue(false),
    mouse : {x:0, y:0},
    trueMouse : {x:0, y:0}
};

function init () {
    var backStage = new createjs.Stage("backCanvas");
    var backG = new createjs.Graphics();
    backG.setStrokeStyle(1, 'round', 'round');
    backG.beginStroke("#555555");
    backG.beginFill("#555555");
    backG.drawRect(0, 0, 5760, 1080);
    var bg = new createjs.Shape(backG);
    backStage.addChild(bg);
    backStage.update();
    bg.on("mousedown", function (evt) {
        hideMenu();
        Tool.noneSelect = true;
        UI.trueMouse = {x:evt.stageX, y:evt.stageY};
    });

    Tool.stage = new createjs.Stage("TVCanvas");
    var background = new createjs.Bitmap("background.png");
    Tool.stage.addChildAt(background, 0);
    Tool.background = background;
    background.on("mousedown", function (evt) {
        hideMenu();
        Tool.noneSelect = true;
        UI.trueMouse = {x:evt.stageX, y:evt.stageY};
    });

    document.onkeydown = function (evt) {
        Tool.ctrlFlg = evt.ctrlKey;
        Tool.altFlg = evt.altKey;
    };
    document.onkeyup = function (evt) {
        Tool.ctrlFlg = evt.ctrlKey;
        Tool.altFlg = evt.altKey;
        for (var i = 0; i < Tool.currents.length; i++) {
            Tool.currents[i].children.pop();
        }
        Tool.currents = [];
        if (evt.keyCode == 17) {
            hideMenu();
        }
    };

    var g = new createjs.Graphics();
    g.setStrokeStyle(5, 'round', 'round');
    g.beginStroke("#FFFFFF");
    g.drawRect(0, 0, 1, 1);
    Tool.focus = new createjs.Shape(g);
    Tool.stage.addChild(Tool.focus);

    showImport();

    createjs.Ticker.timingMode = createjs.Ticker.RAF;
    createjs.Ticker.framerate = 60;
    createjs.Ticker.on("tick", updateStage);

    var resPanel = new createjs.DOMElement("resPanel");
    resPanel.y = 1080;
    resPanel.scaleY = 0;
    Tool.stage.addChild(resPanel);
    Tool.resPanel = resPanel;

    var tempPanel = new createjs.DOMElement("tempPanel");
    tempPanel.x = 500;
    tempPanel.y = 1080;
    tempPanel.scaleY = 0;
    Tool.stage.addChild(tempPanel);
    Tool.tempPanel = tempPanel;

    var textPanel = new createjs.DOMElement("textPanel");
    textPanel.x = 500;
    textPanel.y = 1080;
    textPanel.scaleY = 0;
    Tool.stage.addChild(textPanel);
    Tool.textPanel = textPanel;
}

function showResPanel() {
    document.getElementById("resPanel").innerHTML = "";
    createjs.Tween.get(Tool.resPanel).to({y:0}, 300);
    Tool.resPanel.scaleY = 1;
    var loader = new createjs.LoadQueue(true);
    loader.on("complete", function () {
        var text = loader.getResult("resource.txt");
        var arr = text.split(",");
        for (var i = 0; i < arr.length - 1; i++) {
            var imgTag = document.createElement("img");
            imgTag.src = arr[i];
            imgTag.style.marginTop = 5;
            imgTag.style.marginLeft = 5;
            imgTag.onclick = function (evt) {

                if (Tool.current && Tool.current.parent) {
                    makeChildUnEditable(Tool.current.parent);
                }
                var container = new createjs.Container();
                var bitmap = new createjs.Bitmap(evt.target);
                container.addChild(bitmap);
                container.setBounds(0, 0, bitmap.getBounds().width, bitmap.getBounds().height);
                container.name = "image" + Tool.index++;
                container.resType = CONST.RES_TYPE.IMAGE;
                container.img = this.filename;
                Tool.root.addChildAt(container);
                container.x = 910;
                container.y = 420;
                //resetBounds(Tool.root);
                if (Tool.current.name) {
                    Tool.current.children.pop();
                }
                Tool.current = container;
                var yellowFocus = new createjs.Shape(getHalo(Tool.current, "#FFFF00"));
                Tool.current.addChild(yellowFocus);
                Tool.prev = Tool.current;
                makeChildEditable(Tool.current.parent);



                createjs.Tween.get(Tool.resPanel).to({y:1080}, 300).call(function(){Tool.resPanel.scaleY = 0;});
            };
            document.getElementById("resPanel").appendChild(imgTag);
        }
    }, null, true);
    loader.loadFile({src:"resource.txt", type:createjs.AbstractLoader.TEXT});
}

function showBackgroundPanel() {
    document.getElementById("resPanel").innerHTML = "";
    createjs.Tween.get(Tool.resPanel).to({y:0}, 300);
    Tool.resPanel.scaleY = 1;
    var loader = new createjs.LoadQueue(true);
    loader.on("complete", function () {
        var text = loader.getResult("resource.txt");
        var arr = text.split(",");
        for (var i = 0; i < arr.length - 1; i++) {
            var imgTag = document.createElement("img");
            imgTag.src = arr[i];
            imgTag.style.marginTop = 5;
            imgTag.style.marginLeft = 5;
            imgTag.onclick = function (evt) {

                Tool.background.image = evt.target;


                createjs.Tween.get(Tool.resPanel).to({y:1080}, 300).call(function(){Tool.resPanel.scaleY = 0;});
            };
            document.getElementById("resPanel").appendChild(imgTag);
        }
    }, null, true);
    loader.loadFile({src:"resource.txt", type:createjs.AbstractLoader.TEXT});
}

function applyProperty (prop, value) {
    Tool.current[prop] = value;
}

function applyBounds (prop, value) {
    Tool.current._bounds[prop] = value;
    Tool.current.children.pop();
    var yellowFocus = new createjs.Shape(getHalo(Tool.current, "#FFFF00"));
    Tool.current.addChild(yellowFocus);
    Tool.prev = Tool.current;
}

function applyText (prop, value) {
    Tool.current.children[0][prop] = value;
    if (prop == "warp") {
        if (value == "warp") {
            Tool.current.children[0].lineWidth = Tool.current.getBounds().width;
        } else {
            Tool.current.children[0].lineWidth = null;
        }
    }
    if (prop == "textAlign") {
        var bounds = Tool.current.getBounds();
        if (value == "left") {
            Tool.current.children[0].x = 0;
        } else if (value == "right") {
            Tool.current.children[0].x = bounds.width;
        } else if (value == "center") {
            Tool.current.children[0].x = bounds.width / 2;
        }
    }
}

function pauseStage () {
    Tool.updateFlg = false;
}

function continueStage () {
    Tool.updateFlg = true;
}

function updateStage () {
    if (Tool.updateFlg) {
        if (Tool.current) {
            document.getElementById("itemId").value = Tool.current.name;
            document.getElementById("itemX").value = Math.round(Tool.current.x);
            document.getElementById("itemY").value = Math.round(Tool.current.y);
            if (Tool.current.getBounds) {
                document.getElementById("itemW").value = Math.round(Tool.current.getBounds().width);
                document.getElementById("itemH").value = Math.round(Tool.current.getBounds().height);
            } else {
                document.getElementById("itemW").value = "NA";
                document.getElementById("itemH").value = "NA";
            }

            if (Tool.current.children && Tool.current.children[0].text) {
                document.getElementById("textValue1").value = Tool.current.children[0].text;
                document.getElementById("textFont1").value = Tool.current.children[0].font;
                document.getElementById("textColor1").value = Tool.current.children[0].color;
                document.getElementById("textAlign1").value = Tool.current.children[0].textAlign;
                if (Tool.current.children[0].lineWidth) {
                    document.getElementById("warp1").value = "warp";
                } else {
                    document.getElementById("warp1").value = "inline";
                }

            }




            if (Tool.current.bounds) {
                Tool.focus.x = Tool.current.x;
                Tool.focus.y = Tool.current.y;
                Tool.focus.regX = Tool.current.bounds.width / 2;
                Tool.focus.regY = Tool.current.bounds.height / 2;
            }
        }
        Tool.stage.update();
    }
}

function showMenu () {
    var menuId = null;
    if (!Tool.begin) {
        menuId = "mainMenu";
    }
    else if (Tool.currents.length > 0) {
        menuId = "groupMenu";
    }
    else if (Tool.noneSelect) {
        menuId = "moduleMenu";
    }
    else {
        menuId = "itemMenu";
    }
    var div = document.getElementById(menuId);
    div.style.left = UI.trueMouse.x + "px";
    div.style.top = UI.trueMouse.y + "px";
    div.style.visibility = "visible";
    Tool.menu = menuId
}

function hideMenu () {
    if (!Tool.menu) {
        return;
    }
    var div = document.getElementById(Tool.menu);
    div.style.left = UI.trueMouse.x + "px";
    div.style.top = UI.trueMouse.y + "px";
    div.style.visibility = "hidden";
}

function showImport () {
    //var container = new createjs.Container();
    //
    //var tagImage = new createjs.Bitmap("tagImage.png");
    //tagImage.x = 900;
    //tagImage.y = -80;
    //tagImage.alpha = 0.7;
    //container.addChild(tagImage);
    //var divImage = new createjs.DOMElement("imagePanel");
    //divImage.x = 0;
    //divImage.y = -200;
    //divImage.alpha = 0.7;
    //container.addChild(divImage);
    //tagImage.on("click", function() {
    //    if (tagImage.y == -80) {
    //        createjs.Tween.get(tagImage).to({y:125}, 500, createjs.Ease.quadOut);
    //        createjs.Tween.get(divImage).to({y:0}, 500, createjs.Ease.quadOut);
    //    } else {
    //        createjs.Tween.get(tagImage).to({y:-80 }, 500, createjs.Ease.quadOut);
    //        createjs.Tween.get(divImage).to({y:-200}, 500, createjs.Ease.quadOut);
    //    }
    //});
    //
    document.getElementById("imgSelect").onchange = importImg;
    document.getElementById("spriteSelect").onchange = importSprite;
    document.getElementById("moduleSelect").onchange = openModule;
    document.getElementById("templateSelect").onchange = openTemplate;
    document.getElementById("backgroundSelect").onchange = changeBackground;

    var div = document.getElementById("mainMenu");
    div.style.left = 700 + "px";
    div.style.top = 400 + "px";
    div.style.visibility = "visible";
    Tool.menu = "mainMenu";
    //
    //Tool.stage.addChild(container);
}

//function createShape () {
//    makeChildUnEditable(Tool.current.parent);
//    var container = new createjs.Container();
//    var g = new createjs.Graphics();
//    eval(document.getElementById("shape").value);
//    var shape = new createjs.Shape(g);
//    container.addChild(shape);
//    container.setBounds(0, 0, g.width, g.height);
//    container.name = "shape" + Tool.index++;
//    container.graphicsId = shape;
//    Tool.current.parent.addChildAt(container, Tool.current.parent.children.length - 1);
//    resetBounds(Tool.root);
//    makeChildEditable(Tool.current.parent);
//
//}

function changeBackground (event) {
    hideMenu();
    var fileList = event.target.files;
    for (var i = 0; i < fileList.length; i++) {
        var reader = new FileReader();
        reader.filename = fileList[i].name;
        reader.onloadend = function(event) {
            var image = document.createElement("img");
            image.src = event.target.result;
            Tool.background.image = image;
            Tool.background.img = reader.filename;
        };
        reader.readAsDataURL(fileList[i]);
    }
}

function importImg (event) {
    hideMenu();
    var fileList = event.target.files;
    for (var i = 0; i < fileList.length; i++) {
        var reader = new FileReader();
        reader.filename = fileList[i].name;
        reader.onloadend = function(event) {
            if (Tool.current && Tool.current.parent) {
                makeChildUnEditable(Tool.current.parent);
            }
            var container = new createjs.Container();
            var image = document.createElement("img");
            image.src = event.target.result;
            var bitmap = new createjs.Bitmap(image);
            container.addChild(bitmap);
            container.setBounds(0, 0, bitmap.getBounds().width, bitmap.getBounds().height);
            container.name = "image" + Tool.index++;
            container.resType = CONST.RES_TYPE.IMAGE;
            container.img = this.filename;
            Tool.root.addChildAt(container);
            container.x = 910;
            container.y = 420;
            //resetBounds(Tool.root);
            if (Tool.current.name) {
                Tool.current.children.pop();
            }
            Tool.current = container;
            var yellowFocus = new createjs.Shape(getHalo(Tool.current, "#FFFF00"));
            Tool.current.addChild(yellowFocus);
            Tool.prev = Tool.current;
            makeChildEditable(Tool.current.parent);
        };
        reader.readAsDataURL(fileList[i]);
    }
}

function importSprite (event) {
    hideMenu();
    var fileList = event.target.files;
    for (var i = 0; i < fileList.length; i++) {
        var reader = new FileReader();
        reader.onloadend = function(event) {
            var json = JSON.parse(event.target.result);
            json.images[0] = "assets/ThemeDefault/" + json.images[0];
            var spriteSheet = new createjs.SpriteSheet(json);
            Tool.spriteSheet = spriteSheet;
            for (var i= 0; i < spriteSheet.animations.length; i++) {
                if (Tool.current && Tool.current.parent) {
                    makeChildUnEditable(Tool.current.parent);
                }
                var container = new createjs.Container();
                var sprite = new createjs.Sprite(spriteSheet, spriteSheet.animations[i]);
                container.addChild(sprite);
                container.setBounds(0, 0, sprite.getBounds().width, sprite.getBounds().height);
                container.name = "sprite" + Tool.index++;
                container.resType = CONST.RES_TYPE.SPRITE;
                container.img = this.filename;
                Tool.root.addChildAt(container);
                container.x = 910;
                container.y = 420;
                //resetBounds(Tool.root);
                if (Tool.current.name) {
                    Tool.current.children.pop();
                }
                Tool.current = container;
                var yellowFocus = new createjs.Shape(getHalo(Tool.current, "#FFFF00"));
                Tool.current.addChild(yellowFocus);
                Tool.prev = Tool.current;
                makeChildEditable(Tool.current.parent);
            };
        };
        reader.readAsText(fileList[i]);
    }
}

function getHalo(target, color) {
    if (target) {
        var g = new createjs.Graphics();
        g.clear();
        g.setStrokeStyle(2, 'round', 'round');
        g.beginStroke(color);
        if (target.children[0].text) {
            g.drawRect(-5 + target.getBounds().x, -5 + target.getBounds().y, target.getBounds().width + 10, target.getBounds().height + 10);
        } else {
            g.drawRect(-5, -5, target.getBounds().width + 10, target.getBounds().height + 10);
        }
        return g;
    }
}

function moveTo (target, index) {
    if (target.parent.children[index] && target.parent.children[index] != target) {
        var parent = target.parent;
        parent.removeChild(target);
        parent.addChildAt(target, index);
    }
}

function renameGroup () {
    var newId = document.getElementById("groupId").value;
    for (var id in Tool.groups) {
        if (Tool.groups[id]) {
            for (var i = 0; i < Tool.groups[id].length; i++) {
                if (Tool.current == Tool.groups[id][i]) {
                    Tool.groups[newId] = Tool.groups[id];
                    delete Tool.groups[id];
                    break;
                }
            }
        }
    }
}

function alignUp () {
    for (var i = 0; i < Tool.currents.length; i++) {
        Tool.currents[i].y = Tool.currents[0].y;
    }
}

function alignDown () {
    for (var i = 0; i < Tool.currents.length; i++) {
        Tool.currents[i].y = Tool.currents[0].y + Tool.currents[0].getBounds().height - Tool.currents[i].getBounds().height;
    }
}

function alignLeft () {
    for (var i = 0; i < Tool.currents.length; i++) {
        Tool.currents[i].x = Tool.currents[0].x;
    }
}

function alignRight () {
    for (var i = 0; i < Tool.currents.length; i++) {
        Tool.currents[i].x = Tool.currents[0].x + Tool.currents[0].getBounds().width - Tool.currents[i].getBounds().width;
    }
}

function alignCenterH () {
    for (var i = 0; i < Tool.currents.length; i++) {
        Tool.currents[i].x = Tool.currents[0].x + Tool.currents[0].getBounds().width / 2 - Tool.currents[i].getBounds().width / 2;
    }
}

function alignCenterV () {
    for (var i = 0; i < Tool.currents.length; i++) {
        Tool.currents[i].y = Tool.currents[0].y + Tool.currents[0].getBounds().height / 2 - Tool.currents[i].getBounds().height / 2;
    }
}

function alignAvgH () {
    for (var i = 0; i < Tool.currents.length; i++) {
        Tool.currents[i].x = Tool.currents[0].x + (Tool.currents[Tool.currents.length - 1].x - Tool.currents[0].x) / (Tool.currents.length - 1) * i;
    }
}

function alignAvgV () {
    for (var i = 0; i < Tool.currents.length; i++) {
        Tool.currents[i].y = Tool.currents[0].y + (Tool.currents[Tool.currents.length - 1].y - Tool.currents[0].y) / (Tool.currents.length - 1) * i;
    }
}

function sameH () {
    var gap = Tool.currents[1].x - Tool.currents[0].x - Tool.currents[0].getBounds().width;
    for (var i = 2; i < Tool.currents.length; i++) {
        Tool.currents[i].x = Tool.currents[i - 1].x + Tool.currents[i - 1].getBounds().width + gap;
    }
}

function sameV () {
    var gap = Tool.currents[1].y - Tool.currents[0].y - Tool.currents[0].getBounds().height;
    for (var i = 2; i < Tool.currents.length; i++) {
        Tool.currents[i].y = Tool.currents[i - 1].y + Tool.currents[i - 1].getBounds().height + gap;
    }
}

function createTemplate () {
    var root = Tool.root;
    var result = "";
    result += "{";
    result += "\n";
    if (root.children.length == 0) {
        return;
    }
    if (root.children.length == 1 &&
        (root.children[0].resType != CONST.RES_TYPE.GROUP && root.children[0].resType != CONST.RES_TYPE.MULTIPLE)) {

        var child = root.children[0];

        result += '"' + child.name + '" : {';
        result += "\n";
        result += '"type": 0,';
        result += "\n";
        result += '"position": {"x": ' + Math.round(child.x) + ', "y": ' + Math.round(child.y) + '},';
        result += "\n";
        result += '"items" : {';
        result += "\n";
        if (child.resType == CONST.RES_TYPE.PLACEHOLDER) {
            result += '"img" : {';
            result += "\n";
            result += '"type" : ' + child.resType + ',';
            result += "\n";
            result += '"bound" : {"w" :' + child.getBounds().width + ', "h" :' + child.getBounds().height + '}';
            result += "\n";
        } else if (child.resType == CONST.RES_TYPE.TEXT) {
            result += '"txt" : {';
            result += "\n";
            result += '"type" : ' + child.resType + ',';
            result += "\n";
            result += '"bound" : {"w":' + child.getBounds().width + ', "h":' + child.getBounds().height + '},';
            result += "\n";
            result += '"innerPos" : {"x" :' + child.children[0].x + ', "y" :' + child.children[0].y + '},';
            result += "\n";
            result += '"value" :"' + child.children[0].text + '",';
            result += "\n";
            result += '"font" :"' + child.children[0].font + '",';
            result += "\n";
            result += '"color" :"' + child.children[0].color + '",';
            result += "\n";
            result += '"align" :"' + child.children[0].textAlign + '",';
            result += "\n";
            if (child.children[0].lineWidth) {
                result += '"warp" :' + true + '';
                result += "\n";
            } else {
                result += '"warp" :' + false + '';
                result += "\n";
            }
        } else {
            result += '"anchor" : {';
            result += "\n";
            result += '"type" : ' + child.resType + ',';
            result += "\n";
            result += '"position" : {"x":0, "y":0}';
            result += "\n";
        }
        result += '}';
        result += "\n";
        result += '}';
        result += "\n";
        result += '}';
        result += "\n";

    } else {
        result += makeTemplateString(root.children);
    }
    result += "}";
    result += "\n";

    window.requestFileSystem = window.requestFileSystem || window.webkitRequestFileSystem; //文件系统请求标识
    window.resolveLocalFileSystemURL = window.resolveLocalFileSystemURL || window.webkitResolveLocalFileSystemURL; //根据URL取得文件的读取权限

    window.requestFileSystem(window.TEMPORARY, 1024*1024, function (fs) {

        fs.root.getFile("temp.js", {create: false, exclusive: false}, function (fe) {
            fe.remove(function(){});
        });
    });

    window.requestFileSystem(window.TEMPORARY, 1024*1024, function (fs) {

        fs.root.getFile("temp.js", {create: true, exclusive: false}, function (fe) {
            fe.createWriter(function (fw) {
                fw.onwriteend = function (e) {
                    document.getElementById("module").href = fe.toURL();
                    document.getElementById("module").download = root.children[0].name + ".json";
                };
                var bb = new Blob([result], {type:"text/plain"});
                fw.write(bb);
            })
        });
    });

    hideMenu();
    var div = document.getElementById("resultMenu");
    div.style.left = UI.trueMouse.x + "px";
    div.style.top = UI.trueMouse.y + "px";
    div.style.visibility = "visible";
    Tool.menu = "resultMenu";
}

function makeTemplateString(items) {
    var result = "";
    for (var name in items) {
        if (items.hasOwnProperty(name)) {
            var child = items[name];
            if (!child.hasOwnProperty("children")) {
                continue;
            }
            if ((child.hasOwnProperty("type") && child.type == null) || child.type == CONST.RES_TYPE.GROUP) {
                result += '"' + child.name + '"' + ' : {';
                result += "\n";
                result += '"type" : ' + CONST.RES_TYPE.GROUP + ',';
                result += "\n";
                result += '"position" : {"x" :' + Math.round(child.x) + ', "y" :' + Math.round(child.y) + '},';
                result += "\n";
                result += '"items" : {';
                result += "\n";
                result += makeTemplateString(child.children);
                result += "}";
                result += "\n";
                result += "},";
                result += "\n";
                continue;
            }
            if (child.type == CONST.RES_TYPE.MULTIPLE) {
                result += '"' + child.name + '"' + ' : {';
                result += "\n";
                result += '"type" : ' + CONST.RES_TYPE.MULTIPLE + ',';
                result += "\n";
                result += '"position" : {"x" :' + Math.round(child.x) + ', "y" :' + Math.round(child.y) + '},';
                result += "\n";
                result += '"navigation" : {"leftTo" : ' + findNavLeft(child) + ', "rightTo" : ' + findNavRight(child) + ', "upTo" : ' + findNavUp(child) + ', "downTo" : ' + findNavDown(child) + '},';
                result += "\n";
                result += '"items" : {';
                result += "\n";
                result += makeTemplateString(child.children);
                result += "}";
                result += "\n";
                result += "},";
                result += "\n";
                continue;
            }
            if (child.children[0].image) {
                result += '"' + child.name + '"' + ' : {';
                result += "\n";
                result += '"type" : ' + CONST.RES_TYPE.ANCHOR + ',';
                result += "\n";
                result += '"position" : {"x" :' + Math.round(child.x) + ', "y" :' + Math.round(child.y) + '},';
                result += "\n";
            }
            if (child.children[0].graphics) {
                result += '"' + child.name + '"' + ' : {';
                result += "\n";
                result += '"type" : ' + CONST.RES_TYPE.PLACEHOLDER + ',';
                result += "\n";
                result += '"bound" : {"w" :' + child.getBounds().width + ', "h" :' + child.getBounds().height + '},';
                result += "\n";
            }
            if (child.children[0].text) {
                result += '"' + child.name + '"' + ' : {';
                result += "\n";
                result += '"type" : ' + CONST.RES_TYPE.TEXT + ',';
                result += "\n";
                result += '"bound" : {"w":' + child.getBounds().width + ', "h":' + child.getBounds().height + '},';
                result += "\n";
                result += '"innerPos" : {"x" :' + child.children[0].x + ', "y" :' + child.children[0].y + '},';
                result += "\n";
                result += '"value" :"' + child.children[0].text + '",';
                result += "\n";
                result += '"font" :"' + child.children[0].font + '",';
                result += "\n";
                result += '"color" :"' + child.children[0].color + '",';
                result += "\n";
                result += '"align" :"' + child.children[0].textAlign + '",';
                result += "\n";
            }
            result += '"position" : {"x" :' + Math.round(child.x) + ', "y" :' + Math.round(child.y) + '}';
            if (child.parent.type != CONST.RES_TYPE.MULTIPLE) {
                result += ",";
                result += "\n";
                result += '"navigation" : {"leftTo" : ' + findNavLeft(child) + ', "rightTo" : ' + findNavRight(child) + ', "upTo" : ' + findNavUp(child) + ', "downTo" : ' + findNavDown(child) + '}';
                result += "\n";
            } else {
                result += "\n";
            }
            result += "},";
            result += "\n";
        }
    }
    result =  result.substring(0, result.lastIndexOf(","));
    result += "\n";
    return result;
}

function createModule () {

    var root = Tool.root;
    var result = "";
    result += "UI." + document.getElementById("moduleId").value + "Setup = {";
    result += "\n";
    result += "\n";
    if (root.info.spriteSheet) {
        result += "    spriteSheet : {";
        result += "\n";
        result += '        image : "' + root.info.spriteSheet._images[0].src.substring(root.info.spriteSheet._images[0].src.lastIndexOf("assets/ThemeDefault"), root.info.spriteSheet._images[0].src.length) + '",';
        result += "\n";
        result += "        frames : [";
        result += "\n";
        for (var i = 0; i < root.info.spriteSheet._frames.length; i++) {
            var frame = root.info.spriteSheet._frames[i].rect;
            result += "           [";
            result += frame.x + "," + frame.y + "," + frame.width + "," + frame.height;
            result += "]";
            if (!(i == root.info.spriteSheet._frames.length - 1)) {
                result += ",";
            }
            result += "\n";
        }
        result += "        ],";
        result += "\n";
        result += "        animations : {";
        result += "\n";

        for (var i = 0; i < root.info.spriteSheet._animations.length; i++) {
            var anime = root.info.spriteSheet._animations[i];
            result += '            "' + anime + '":[' + i + ']';
            if (!(i == root.info.spriteSheet._animations.length - 1)) {
                result += ",";
            }
            result += "\n";
        }
        result += "        }";
        result += "\n";
        result += "    },";
    }
    result += "\n";

    //if (root.info.shapes) {
    //    result += "shapes : {";
    //    result += "\n";
    //    for (var name in root.info.shapes) {
    //        result += "    " + name + " : new createjs.Graphics()";
    //        result += "\n";
    //        result += "},";
    //        result += "\n";
    //    }
    //}

    if (root.info.background) {
        result += 'background : {';
        result += "\n";

        if (root.info.background.image.src.indexOf("base64") != -1) {
            result += '    image : "' + "assets/ThemeDefault/" + document.getElementById("moduleId").value  + "/" + root.info.background.img + '",';
            result += "\n";
        } else {
            result += '    image : "' + root.info.background.image.src.substring(root.info.background.image.src.lastIndexOf("assets/ThemeDefault"),root.info.background.image.src.length) + '"';
            result += "\n";
        }

        result += '},';
        result += "\n";
        result += 'focus : {';
        result += "\n";
        result += 'default : "' + Tool.defaultFocus + '"';
        result += "\n";
        result += '},';
        result += "\n";
    }

    result += "    items : {";
    result += "\n";
    result += makeItemsString(root.children);
    result += "    }";
    result += "\n";
    result += "};";
    result += "\n";

    document.getElementById("module").value = result;

    var func = "";
    func += "UI." + document.getElementById("moduleId").value + "Function = {";
    func += "\n";
    func += "    onShow : function (target) {";
    func += "\n";
    func += "        UI.getTween(target).to({alpha:1}, 1000);";
    func += "\n";
    func += "    },";
    func += "\n";
    func += "    onFocus : function (target) {";
    func += "\n";
    func += "        UI.getTween(target).to({scaleX:1.1, scaleY:1.1}, 300);";
    func += "\n";
    func += "    },";
    func += "\n";
    func += "    onNormal : function (target) {";
    func += "\n";
    func += "        UI.getTween(target).to({scaleX:1, scaleY:1}, 300);";
    func += "\n";
    func += "    },";
    func += "\n";

    func += getfuncString(root.children);

    func =  func.substring(0, func.lastIndexOf(","));
    func += "\n";
    func += "};";

    document.getElementById("function").value = func;

    window.requestFileSystem = window.requestFileSystem || window.webkitRequestFileSystem; //文件系统请求标识
    window.resolveLocalFileSystemURL = window.resolveLocalFileSystemURL || window.webkitResolveLocalFileSystemURL; //根据URL取得文件的读取权限

    window.requestFileSystem(window.TEMPORARY, 1024*1024, function (fs) {

        fs.root.getFile("setup.js", {create: false, exclusive: false}, function (fe) {
            fe.remove(function(){});
        });

        fs.root.getFile("function.js", {create: false, exclusive: false}, function (fe) {
            fe.remove(function(){});
        });
    });

    window.requestFileSystem(window.TEMPORARY, 1024*1024, function (fs) {

        fs.root.getFile("setup.js", {create: true, exclusive: false}, function (fe) {
            fe.createWriter(function (fw) {
                fw.onwriteend = function (e) {
                    document.getElementById("module").href = fe.toURL();
                };
                var bb = new Blob([result], {type:"text/plain"});
                fw.write(bb);
            })
        });

        fs.root.getFile("function.js", {create: true, exclusive: false}, function (fe) {
            fe.createWriter(function (fw) {
                fw.onwriteend = function (e) {
                    document.getElementById("function").href = fe.toURL();
                };
                var bb = new Blob([func], {type:"text/plain"});
                fw.write(bb);
            })
        })
    });

    hideMenu();
    var div = document.getElementById("resultMenu");
    div.style.left = UI.trueMouse.x + "px";
    div.style.top = UI.trueMouse.y + "px";
    div.style.visibility = "visible";
    Tool.menu = "resultMenu";
}

function getfuncString(items) {
    var func = "";
    for (var name in items) {
        if (items.hasOwnProperty(name)) {
            var child = items[name];
            if (child.hasOwnProperty("type")) {
                if (child.type == null) {
                    func += getfuncString(child.children);
                } else {
                    func += "    " + child.name + " : {";
                    func += "\n";
                    func += "        onEnter : function (target) {";
                    func += "\n";
                    func += "            UI.getTween(target).to({scaleX:1.2, scaleY:1.2}, 500, createjs.Ease.elasticOut);";
                    func += "\n";
                    func += "        }";
                    func += "\n";
                    func += "    },";
                    func += "\n";
                }
            }  else if (child.type != CONST.RES_TYPE.TEXT) {
                func += "    " + child.name + " : {";
                func += "\n";
                func += "        onEnter : function (target) {";
                func += "\n";
                func += "            UI.getTween(target).to({scaleX:1.2, scaleY:1.2}, 500, createjs.Ease.elasticOut);";
                func += "\n";
                func += "        }";
                func += "\n";
                func += "    },";
                func += "\n";
            }
        }
    }
    return func;
}

function setDefaultFocus () {
    hideMenu();
    Tool.defaultFocus = Tool.current.name;
}

function findNavUp (self) {
    for (var i = 0; i < 300; i = i + 10) {
        var point = self.parent.localToGlobal(self.x, self.y);
        var item = Tool.stage.getObjectUnderPoint(point.x + self.getBounds().width / 2, point.y - 1 - i);
        if (!item) {
            continue;
        }
        var target = item.parent.parent;
        if (!target) {
            continue;
        }
        if (!target.name) {
            continue;
        }
        if ((target.hasOwnProperty("type") && target.type == null) || target.type == CONST.RES_TYPE.GROUP) {
            continue;
        }
        if (target.hasOwnProperty("type") && target.type == CONST.RES_TYPE.MULTIPLE) {
            if (target.name != self.name) {
                return '"' + target.name + '"';
            }
        }
        if (target.name != self.name) {
            return '"' + target.name + '"';
        }
    }
    return 'null';
}

function findNavDown (self) {
    for (var i = 0; i < 300; i = i + 10) {
        var point = self.parent.localToGlobal(self.x, self.y);
        var item = Tool.stage.getObjectUnderPoint(point.x + self.getBounds().width / 2, point.y + self.getBounds().height + 1 + i);
        if (!item) {
            continue;
        }
        var target = item.parent.parent;
        if (!target) {
            continue;
        }
        if (!target.name) {
            continue;
        }
        if ((target.hasOwnProperty("type") && target.type == null) || target.type == CONST.RES_TYPE.GROUP) {
            continue;
        }
        if (target.hasOwnProperty("type") && target.type == CONST.RES_TYPE.MULTIPLE) {
            if (target.name != self.name) {
                return '"' + target.name + '"';
            }
        }
        if (target.name != self.name) {
            return '"' + target.name + '"';
        }
    }
    return 'null';
}

function findNavLeft (self) {
    for (var i = 0; i < 500; i = i + 10) {
        var point = self.parent.localToGlobal(self.x, self.y);
        var item = Tool.stage.getObjectUnderPoint(point.x - 1 - i, point.y + self.getBounds().height / 2);
        if (!item) {
            continue;
        }
        var target = item.parent.parent;
        if (!target) {
            continue;
        }
        if (!target.name) {
            continue;
        }
        if ((target.hasOwnProperty("type") && target.type == null) || target.type == CONST.RES_TYPE.GROUP) {
            continue;
        }
        if (target.hasOwnProperty("type") && target.type == CONST.RES_TYPE.MULTIPLE) {
            if (target.name != self.name) {
                return '"' + target.name + '"';
            }
        }
        if (target.name != self.name) {
            return '"' + target.name + '"';
        }
    }
    return 'null';
}

function findNavRight (self) {
    for (var i = 0; i < 500; i = i + 10) {
        var point = self.parent.localToGlobal(self.x, self.y);
        var item = Tool.stage.getObjectUnderPoint(point.x + self.getBounds().width + 1 + i, point.y + self.getBounds().height / 2);
        if (!item) {
            continue;
        }
        var target = item.parent.parent;
        if (!target) {
            continue;
        }
        if (!target.name) {
            continue;
        }
        if ((target.hasOwnProperty("type") && target.type == null) || target.type == CONST.RES_TYPE.GROUP) {
            continue;
        }
        if (target.hasOwnProperty("type") && target.type == CONST.RES_TYPE.MULTIPLE) {
            if (target.name != self.name) {
                return '"' + target.name + '"';
            }
        }
        if (target.name != self.name) {
            return '"' + target.name + '"';
        }
    }
    return 'null';
}

function openModule () {
    Tool.begin = true;
    var div = document.getElementById("mainMenu");
    div.style.visibility = "hidden";
    hideMenu();
    var fileList = event.target.files;
    for (var i = 0; i < fileList.length; i++) {
        var reader = new FileReader();
        reader.onloadend = function(event) {
            var script = document.createElement("script");
            script.src = event.target.result;
            document["head"].appendChild(script);
            setTimeout(loadResource, 1000);
        };
        reader.readAsDataURL(fileList[i]);
    }
}

function openModule () {
    Tool.begin = true;
    var div = document.getElementById("mainMenu");
    div.style.visibility = "hidden";
    hideMenu();
    var fileList = event.target.files;
    for (var i = 0; i < fileList.length; i++) {
        var reader = new FileReader();
        reader.onloadend = function(event) {
            var script = document.createElement("script");
            script.src = event.target.result;
            document["head"].appendChild(script);
            setTimeout(loadResource, 1000);
        };
        reader.readAsDataURL(fileList[i]);
    }
}

function openTemplate () {
    Tool.begin = true;
    var div = document.getElementById("mainMenu");
    div.style.visibility = "hidden";
    hideMenu();
    var fileList = event.target.files;
    for (var i = 0; i < fileList.length; i++) {
        var reader = new FileReader();
        reader.filename = fileList[i].name;
        reader.onloadend = function(event) {
            var json = JSON.parse(event.target.result);
            createView(json, reader.filename);
        };
        reader.readAsText(fileList[i]);
    }
}

function createView(json, filename) {
    var moduleRoot = setupTemplate(json);
    moduleRoot.name = filename;
    moduleRoot.setBounds(0, 0, 1920, 1080);
    Tool.stage.addChild(moduleRoot);
    Tool.root = moduleRoot;

    makeChildEditable(moduleRoot);
    Tool.prev = Tool.current = moduleRoot.children[0];
    var yellowFocus = new createjs.Shape(getHalo(Tool.current, "#FFFF00"));
    Tool.current.addChild(yellowFocus);
}

function setupTemplate(json) {
    var moduleNode = new createjs.Container();
    for (var name in json) {
        if (json.hasOwnProperty(name)) {
            var child = json[name];
            if (!child.type || child.type == CONST.RES_TYPE.MULTIPLE) {
                var group = moduleNode.addChild(setupTemplate(child.items));
                group.name = name;
                var groupBounds = group.getBounds();
                group.setBounds(0, 0, groupBounds.width, groupBounds.height);
                group.x = child.position.x;
                group.y = child.position.y;
                group.type = child.type;
                if (child.type == CONST.RES_TYPE.MULTIPLE) {
                    group.resType = CONST.RES_TYPE.MULTIPLE;
                } else {
                    group.resType = CONST.RES_TYPE.GROUP;
                }

                if (child.navigation) {
                    group.nav = child.navigation;
                }
                continue;
            }
            var item = new createjs.Container();
            switch (child.type) {
                case CONST.RES_TYPE.PLACEHOLDER:
                    var shape = new createjs.Shape();
                    shape.graphics
                        .c()
                        .es()
                        .ss(1, 'round', 'round')
                        .s("rgba(0, 0, 0, 1)")
                        .f("rgba(100, 100, 100, 0.8)")
                        .dr(0, 0, child.bound.w, child.bound.h);
                    shape.setBounds(0, 0, child.bound.w, child.bound.h);
                    item.addChild(shape);
                    var sizeInfo = new createjs.Text(child.bound.w + "x" + child.bound.h, "20px SourceSansPro-Light", "#FF0000");
                    item.addChild(sizeInfo);
                    item.resType = CONST.RES_TYPE.PLACEHOLDER;
                    break;
                case CONST.RES_TYPE.ANCHOR:
                    var bitmap = new createjs.Bitmap("anchor.png");
                    item.addChild(bitmap);
                    item.resType = CONST.RES_TYPE.ANCHOR;
                    child.bound = {w:50, h:50};
                    break;
                case CONST.RES_TYPE.TEXT:
                    var textValue = child.value;
                    var textFont = child.font;
                    var textAlign = child.align;
                    var textColor = child.color;
                    var boundW = child.bound.w;
                    //var boundH = json.bound.h;
                    var text = new createjs.Text(textValue, textFont, textColor);
                    text.textAlign = textAlign;
                    if (textAlign == "left") {
                        text.x = 0;
                    } else if (textAlign == "right") {
                        text.x = boundW;
                    } else if (textAlign == "center") {
                        text.x = boundW / 2;
                    }
                    item.addChild(text);
                    item.resType = CONST.RES_TYPE.TEXT;
                    break;
                default:
                    break;
            }
            item.name = name;
            item.setBounds(0, 0, child.bound.w, child.bound.h);
            item.x = child.position.x;
            item.y = child.position.y;
            item.nav = child.navigation;
            moduleNode.addChild(item);
        }
    }
    var moduleNodeBounds = moduleNode.getBounds();
    moduleNode.setBounds(0, 0, moduleNodeBounds.width, moduleNodeBounds.height);
    return moduleNode;
}

function newModule() {
    Tool.begin = true;
    var div = document.getElementById("mainMenu");
    div.style.visibility = "hidden";
    hideMenu();

    var moduleRoot = new createjs.Container();
    moduleRoot.info = {};
    moduleRoot.info.background = Tool.background;
    moduleRoot.name = "";
    moduleRoot.setBounds(0, 0, 1920, 1080);
    Tool.stage.addChild(moduleRoot);
    Tool.root = moduleRoot;

    makeChildEditable(moduleRoot);
    //Tool.prev = Tool.current = moduleRoot.children[0];
    //var yellowFocus = new createjs.Shape(getHalo(Tool.current, "#FFFF00"));
    //Tool.current.addChild(yellowFocus);
}

function loadResource () {
    var moduleId = null;
    for (var name in UI) {
        if (name.lastIndexOf("Setup") > 0 && name.lastIndexOf("Setup") == name.length - 5) {
            moduleId = name.substring(0, name.lastIndexOf("Setup"));
        }
    }
    document.getElementById("moduleId").value = moduleId;
    var manifest = [];
    if (UI[moduleId + "Setup"].spriteSheet) {
        manifest.push(UI[moduleId + "Setup"].spriteSheet.image);
    }
    if (UI[moduleId + "Setup"].sound) {
        manifest = manifest.concat(UI[moduleId + "Setup"].sound);
    }
    if (UI[moduleId + "Setup"].background) {
        manifest.push(UI[moduleId + "Setup"].background.image);
    }
    addManifest(manifest, UI[moduleId + "Setup"].items);
    UI.loader.on("complete", createModuleView, null, true, moduleId);
    UI.loader.loadManifest(manifest, true, "../../");
}

function addManifest (manifest, items) {
    for (var name in items) {
        if (items.hasOwnProperty(name)) {
            var child = items[name];
            if (child.type == CONST.RES_TYPE.IMAGE) {
                manifest.push(child.image);
            } else if (!child.type || child.type == CONST.RES_TYPE.MULTIPLE) {
                addManifest(manifest, child.items);
            }
        }
    }
}

function createModuleView (event, moduleId) {
    var moduleSetup = UI[moduleId + "Setup"];
    var info = new createjs.Container();
    if (moduleSetup.spriteSheet) {
        info.spriteSheet = new createjs.SpriteSheet({
            "images":  ["../../" + moduleSetup.spriteSheet.image],
            "frames": moduleSetup.spriteSheet.frames,
            "animations": moduleSetup.spriteSheet.animations
        });
    }
    info.shapes = {};
    if (moduleSetup.shapes) {
        for (var name in moduleSetup.shapes) {
            if (moduleSetup.shapes.hasOwnProperty(name)) {
                info.shapes[name] = moduleSetup.shapes[name];
            }
        }
    }
    if (moduleSetup.background) {
        var background = new createjs.Bitmap(this.getResult(moduleSetup.background.image));
        Tool.background.image = background.image;
        Tool.stage.update();
        info.background = background;
    }
    if (moduleSetup.focus) {
        Tool.defaultFocus = moduleSetup.focus.default;
    }
    var moduleRoot = UI.setupModule(moduleSetup.items, UI.loader, info);
    moduleRoot.info = info;
    moduleRoot.name = moduleId;
    moduleRoot.setBounds(0, 0, 1920, 1080);
    Tool.stage.addChild(moduleRoot);
    Tool.root = moduleRoot;

    makeChildEditable(moduleRoot);
    Tool.prev = Tool.current = moduleRoot.children[0];
    var yellowFocus = new createjs.Shape(getHalo(Tool.current, "#FFFF00"));
    Tool.current.addChild(yellowFocus);
}

function makeItemsString(items) {
    var result = "";
    for (var name in items) {
        if (items.hasOwnProperty(name)) {
            var child = items[name];
            if (!child.hasOwnProperty("children")) {
                continue;
            }
            if (child.hasOwnProperty("type") && child.type == null) {
                result += child.name + " : {";
                result += "\n";
                result += "position : {x:" + Math.round(child.x) + ", y:" + Math.round(child.y) + "},";
                result += "\n";
                result += "items : {";
                result += "\n";
                result += makeItemsString(child.children);
                result += "}";
                result += "\n";
                result += "},";
                result += "\n";
                continue;
            }
            if (child.type == CONST.RES_TYPE.MULTIPLE) {
                result += child.name + " : {";
                result += "\n";
                result += "type : CONST.RES_TYPE.MULTIPLE,";
                result += "\n";
                result += "position : {x:" + Math.round(child.x) + ", y:" + Math.round(child.y) + "},";
                result += "\n";
                result += 'navigation : {leftTo : ' + findNavLeft(child) + ', rightTo : ' + findNavRight(child) + ', upTo : ' + findNavUp(child) + ', downTo : ' + findNavDown(child) + '},';
                result += "\n";
                result += "items : {";
                result += "\n";
                result += makeItemsString(child.children);
                result += "}";
                result += "\n";
                result += "},";
                result += "\n";
                continue;
            }
            if (child.children[0].image) {
                result += child.name + " : {";
                result += "\n";
                result += "type : CONST.RES_TYPE.IMAGE,";
                result += "\n";
                if (child.children[0].image.src.indexOf("base64") != -1) {
                    result += '    image : "' + "assets/ThemeDefault/" + document.getElementById("moduleId").value + "/" + child.img + '",';
                    result += "\n";
                } else {
                    result += '    image : "' + child.children[0].image.src.substring(child.children[0].image.src.lastIndexOf("assets/ThemeDefault", child.children[0].image.src.length)) + '",';
                    result += "\n";
                }
            }
            if (child.children[0].currentAnimation) {
                result += child.name + " : {";
                result += "\n";
                result += "type : CONST.RES_TYPE.SPRITE,";
                result += "\n";
                result += '    animation : "' + child.children[0].currentAnimation + '",';
                result += "\n";
            }
            if (child.children[0].graphics) {
                result += child.name + " : {";
                result += "\n";
                result += "type : CONST.RES_TYPE.SHAPE,";
                result += "\n";
                result += 'graphics : "' + child.graphicsId + '",';
                result += "\n";
                result += 'size : {w : ' + child.children[0].getBounds().width + ', h : ' + child.children[0].getBounds().height + '},';
                result += "\n";
            }
            if (child.children[0].text) {
                result += child.name + " : {";
                result += "\n";
                result += "type : CONST.RES_TYPE.TEXT,";
                result += "\n";
                result += 'bound : {w:' + child.getBounds().width + ', h:' + child.getBounds().height + '},';
                result += "\n";
                result += 'innerPos : {x:' + child.children[0].x + ', y:' + child.children[0].y + '},';
                result += "\n";
                result += 'value:"' + child.children[0].text + '",';
                result += "\n";
                result += 'font:"' + child.children[0].font + '",';
                result += "\n";
                result += 'color:"' + child.children[0].color + '",';
                result += "\n";
                result += 'align:"' + child.children[0].textAlign + '",';
                result += "\n";
            }
            result += 'position : {x:' + Math.round(child.x) + ', y:' + Math.round(child.y) + '}';
            if (child.parent.type != CONST.RES_TYPE.MULTIPLE) {
                result += ",";
                result += "\n";
                result += 'navigation : {leftTo : ' + findNavLeft(child) + ', rightTo : ' + findNavRight(child) + ', upTo : ' + findNavUp(child) + ', downTo : ' + findNavDown(child) + '}';
                result += "\n";
            } else {
                result += "\n";
            }
            result += "},";
            result += "\n";
        }
    }
    result =  result.substring(0, result.lastIndexOf(","));
    result += "\n";
    return result;
}

UI.setupModule = function (items, loader, info) {
    var moduleNode = new createjs.Container();
    for (var name in items) {
        if (items.hasOwnProperty(name)) {
            var child = items[name];
            if (!child.type || child.type == CONST.RES_TYPE.MULTIPLE) {
                var group = moduleNode.addChild(UI.setupModule(child.items, loader, info));
                group.name = name;
                var groupBounds = group.getBounds();
                group.setBounds(0, 0, groupBounds.width, groupBounds.height);
                group.x = child.position.x;
                group.y = child.position.y;
                group.type = child.type;
                if (child.navigation) {
                    group.nav = child.navigation;
                }
                continue;
            }
            var item = new createjs.Container();
            switch (child.type) {
                case CONST.RES_TYPE.SPRITE:
                    var sprite = new createjs.Sprite(info.spriteSheet, child.animation);
                    var spriteBounds = sprite.getBounds();
                    sprite.setBounds(0, 0, spriteBounds.width, spriteBounds.height);
                    sprite.stop();
                    item.addChild(sprite);
                    break;
                case CONST.RES_TYPE.IMAGE:
                    var bitmap = new createjs.Bitmap(loader.getResult(child.image));
                    var bitmapBounds = bitmap.getBounds();
                    bitmap.setBounds(0, 0, bitmapBounds.width, bitmapBounds.height);
                    item.addChild(bitmap);
                    break;
                case CONST.RES_TYPE.SHAPE:
                    var shape = new createjs.Shape(info.shapes[child.graphics]);
                    shape.setBounds(0, 0, child.size.w, child.size.h);
                    item.addChild(shape);
                    item.graphicsId = child.graphics;
                    break;
                case CONST.RES_TYPE.TEXT:
                    var text = new createjs.Text(child.value, child.font ? child.font : "40px SourceSansPro-Light", "#FFF");
                    text.setBounds(0, 0, child.size.w, child.size.h);
                    item.addChild(text);
                    break;
                default:
                    break;
            }
            item.name = name;
            var itemBounds = item.getBounds();
            item.setBounds(0, 0, itemBounds.width, itemBounds.height);
            item.x = child.position.x;
            item.y = child.position.y;
            item.nav = child.navigation;
            moduleNode.addChild(item);
        }
    }
    var moduleNodeBounds = moduleNode.getBounds();
    moduleNode.setBounds(0, 0, moduleNodeBounds.width, moduleNodeBounds.height);
    return moduleNode;
};

function makeChildUnEditable(target) {
    for (var i = 0; i < target.children.length; i++) {
        var container = target.children[i];
        container.removeAllEventListeners("mousedown");
        container.removeAllEventListeners("pressmove");
        container.removeAllEventListeners("dblclick");
    }
}

function removeItems() {
    hideMenu();
    Tool.current.parent.removeChild(Tool.current);
    //Tool.prev = Tool.current = Tool.current.parent.children[Tool.current.parent.children.length - 1];
    //var focus = new createjs.Shape(getHalo(Tool.current, "#FFFF00"));
    //focus.setBounds(0, 0, Tool.current.getBounds().width, Tool.current.getBounds().height);
    //Tool.current.addChild(focus);
}

function makeChildEditable (target) {

    for (var i = 0; i < target.children.length; i++) {
        var container = target.children[i];
        container.on("mousedown", function (evt) {
            hideMenu();
            Tool.noneSelect = false;
            if (Tool.ctrlFlg) {
                var flg = true;
                for (var i = 0; i < Tool.currents.length; i++) {
                    if (Tool.currents[i] == evt.currentTarget) {
                        flg = false;
                    }
                }
                if (flg) {
                    var focus = new createjs.Shape(getHalo(evt.currentTarget, "#FF00FF"));
                    focus.setBounds(0, 0, evt.currentTarget.getBounds().width, evt.currentTarget.getBounds().height);
                    evt.currentTarget.addChild(focus);
                    Tool.currents.push(evt.currentTarget);
                }
                UI.trueMouse = {x:evt.stageX, y:evt.stageY};
            } else {
                if (evt.currentTarget.name) {
                    Tool.prev = Tool.current;
                    Tool.current = evt.currentTarget;
                    if (Tool.prev.children) {
                        Tool.prev.children.pop();
                    }
                    var focus = new createjs.Shape(getHalo(Tool.current, "#FFFF00"));
                    focus.setBounds(0, 0, Tool.current.getBounds().width, Tool.current.getBounds().height);
                    evt.currentTarget.addChild(focus);
                } else {
                    Tool.noneSelect = true;
                }
                UI.mouse = Tool.current.globalToLocal(evt.stageX, evt.stageY);
                UI.trueMouse = {x:evt.stageX, y:evt.stageY};
            }
        });

        container.on("pressmove", function (evt) {
            if (!Tool.ctrlFlg) {
                var point = Tool.current.parent.globalToLocal(evt.stageX, evt.stageY);
                Tool.current.x = point.x - UI.mouse.x;
                Tool.current.y = point.y - UI.mouse.y;
            }
        });

        container.on("dblclick", function (evt) {
            if (Tool.altFlg) {
                if (!evt.currentTarget.parent.hasOwnProperty("type")) {
                    return;
                }
                makeChildUnEditable(evt.currentTarget.parent);
                resetBounds(Tool.root);
                evt.currentTarget.children.pop();
                evt.currentTarget.parent.children.pop();
                Tool.current = evt.currentTarget.parent;
                Tool.prev = Tool.current;
                var yellowFocus = new createjs.Shape(getHalo(Tool.current, "#FFFF00"));
                Tool.current.addChild(yellowFocus);
                makeChildEditable(Tool.current.parent);
            } else {
                if (!evt.currentTarget.hasOwnProperty("type")) {
                    return;
                }
                makeChildUnEditable(Tool.current.parent);
                if (Tool.prev.children) {
                    Tool.prev.children.pop();
                }
                Tool.current = evt.currentTarget.children[0];
                var yellowFocus = new createjs.Shape(getHalo(Tool.current, "#FFFF00"));
                Tool.current.addChild(yellowFocus);
                Tool.prev = Tool.current;

                makeChildEditable(evt.currentTarget);
                var redFocus = new createjs.Shape(getHalo(evt.currentTarget, "#FF0000"));
                evt.currentTarget.addChild(redFocus);
            }
        });
    }
}

function resetBounds(container) {
    for (var i = 0; i < container.children.length; i++) {
        var child = container.children[i];
        if (child.hasOwnProperty("type")) {
            resetBounds(child);
            child._bounds = null;
            var bounds = child.getBounds();
            child.setBounds(0, 0, bounds.width, bounds.height);
            child.x = child.x + bounds.x;
            child.y = child.y + bounds.y;
            for (var j = 0; j < child.children.length; j++) {
                var item = child.children[j];
                item.x = item.x - bounds.x;
                item.y = item.y - bounds.y;
            }
        }
    }
}

function removeGroup() {
    hideMenu();
    if (!Tool.current.hasOwnProperty("type")) {
        return;
    }
    makeChildUnEditable(Tool.current.parent);
    Tool.current.children.pop();
    var childs = [];
    for (var i = 0; i < Tool.current.children.length; i++) {
        child = Tool.current.children[i];
        var point = Tool.current.localToLocal(child.x, child.y, Tool.current.parent);
        child.x = point.x;
        child.y = point.y;
        childs.push(child);
    }
    for (var i = 0; i < childs.length; i++) {
        Tool.current.parent.addChild(childs[i]);
    }
    Tool.current.parent.removeChild(Tool.current);
    Tool.prev = Tool.current = childs[0];
    var yellowFocus = new createjs.Shape(getHalo(Tool.current, "#FFFF00"));
    Tool.current.addChild(yellowFocus);
    resetBounds(Tool.root);
    makeChildEditable(Tool.current.parent);
}

function createGroup () {
    hideMenu();
    Tool.current.children.pop();
    if (Tool.currents.length == 1) {
        return;
    }
    makeChildUnEditable(Tool.current.parent);
    var childs = [];
    var container = new createjs.Container();
    container.name = "newGroup" + Tool.index++;
    container.resType = CONST.RES_TYPE.GROUP;
    container.type = null;
    container.setBounds(0, 0, 1920, 1080);
    Tool.current.parent.addChild(container);
    Tool.prev = Tool.current = container;
    for (var i = 0; i < Tool.currents.length; i++) {
        child = Tool.currents[i];
        child.children.pop();
        var point = container.localToGlobal(child.x, child.y);
        child.x = point.x;
        child.y = point.y;
        childs.push(child);
    }
    Tool.currents = [];
    for (var i = 0; i < childs.length; i++) {
        Tool.current.parent.removeChild(childs[i]);
        container.addChild(childs[i]);
    }
    resetBounds(Tool.root);
    var yellowFocus = new createjs.Shape(getHalo(Tool.current, "#FFFF00"));
    Tool.current.addChild(yellowFocus);
    makeChildEditable(Tool.current.parent);
}

function createMuti () {
    hideMenu();
    Tool.current.children.pop();
    if (Tool.currents.length == 1) {
        return;
    }
    makeChildUnEditable(Tool.current.parent);
    var childs = [];
    var container = new createjs.Container();
    container.name = "newMuti" + Tool.index++;
    container.resType = CONST.RES_TYPE.MULTIPLE;
    container.type = CONST.RES_TYPE.MULTIPLE;
    container.setBounds(0, 0, 1920, 1080);
    Tool.current.parent.addChild(container);
    Tool.prev = Tool.current = container;
    for (var i = 0; i < Tool.currents.length; i++) {
        child = Tool.currents[i];
        child.children.pop();
        var point = container.localToGlobal(child.x, child.y);
        child.x = point.x;
        child.y = point.y;
        childs.push(child);
    }
    Tool.currents = [];
    for (var i = 0; i < childs.length; i++) {
        Tool.current.parent.removeChild(childs[i]);
        container.addChild(childs[i]);
    }
    resetBounds(Tool.root);
    var yellowFocus = new createjs.Shape(getHalo(Tool.current, "#FFFF00"));
    Tool.current.addChild(yellowFocus);
    makeChildEditable(Tool.current.parent);
}

function showTempPanel() {
    hideMenu();
    createjs.Tween.get(Tool.tempPanel).to({x:500, y: 500, scaleY : 1}, 300);
}

function createTempImg() {
    createjs.Tween.get(Tool.tempPanel).to({x:500, y: 1080, scaleY : 0}, 300);
    var tempW = document.getElementById("tempW").value;
    var tempH = document.getElementById("tempH").value;
    if (Tool.current && Tool.current.parent) {
        makeChildUnEditable(Tool.current.parent);
    }
    var container = new createjs.Container();
    var shape = new createjs.Shape();
    shape.graphics
        .c()
        .es()
        .ss(1, 'round', 'round')
        .s("rgba(0, 0, 0, 1)")
        .f("rgba(100, 100, 100, 0.8)")
        .dr(0, 0, tempW, tempH);
    shape.setBounds(0, 0, tempW, tempH);
    container.addChild(shape);
    var text = new createjs.Text(tempW + "x" + tempH, "20px SourceSansPro-Light", "#FF0000");
    container.addChild(text);
    container.setBounds(0, 0, tempW, tempH);
    container.name = "tempImg" + Tool.index++;
    container.resType = CONST.RES_TYPE.PLACEHOLDER;
    //container.img = this.filename;
    Tool.root.addChildAt(container);
    container.x = 910;
    container.y = 420;
    //resetBounds(Tool.root);
    if (Tool.current.name) {
        Tool.current.children.pop();
    }
    Tool.current = container;
    var yellowFocus = new createjs.Shape(getHalo(Tool.current, "#FFFF00"));
    Tool.current.addChild(yellowFocus);
    Tool.prev = Tool.current;
    makeChildEditable(Tool.current.parent);
    moveTo(Tool.current, Tool.current.parent.children.length - 1);
}

function createAnchor() {
    if (Tool.current && Tool.current.parent) {
        makeChildUnEditable(Tool.current.parent);
    }
    var container = new createjs.Container();
    var bitmap = new createjs.Bitmap("anchor.png");
    bitmap.setBounds(0, 0, 50, 50);
    container.addChild(bitmap);
    container.name = "anchor" + Tool.index++;
    container.resType = CONST.RES_TYPE.ANCHOR;
    Tool.root.addChildAt(container);
    container.x = 910;
    container.y = 420;
    if (Tool.current.name) {
        Tool.current.children.pop();
    }
    Tool.current = container;
    var yellowFocus = new createjs.Shape(getHalo(Tool.current, "#FFFF00"));
    Tool.current.addChild(yellowFocus);
    Tool.prev = Tool.current;
    makeChildEditable(Tool.current.parent);
    moveTo(Tool.current, Tool.current.parent.children.length - 1);
}

function showTextPanel() {
    hideMenu();
    createjs.Tween.get(Tool.textPanel).to({x:500, y: 500, scaleY : 1}, 300);
}

function createText () {
    createjs.Tween.get(Tool.textPanel).to({x:500, y: 1080, scaleY : 0}, 300);
    var textValue = document.getElementById("textValue").value;
    var textFont = document.getElementById("textFont").value;
    var textAlign = document.getElementById("textAlign").value;
    var warp = document.getElementById("warp").value;
    var textColor = document.getElementById("textColor").value;
    var boundW = document.getElementById("boundW").value;
    var boundH = document.getElementById("boundH").value;
    if (Tool.current && Tool.current.parent) {
        makeChildUnEditable(Tool.current.parent);
    }
    var container = new createjs.Container();
    var text = new createjs.Text(textValue, textFont, textColor);
    text.textAlign = textAlign;
    if (textAlign == "left") {
        text.x = 0;
    } else if (textAlign == "right") {
        text.x = boundW;
    } else if (textAlign == "center") {
        text.x = boundW / 2;
    }

    if (warp == "warp") {
        text.lineWidth = boundW;
    }

    //if (text.getMeasuredWidth() > boundW) {
    //    var tempText = new createjs.Text("", "40px Airal", "#FFFFFF");
    //    var tempStr = text.text;
    //    text.text = "";
    //    for (var i = 0; i < tempStr.length; i++) {
    //        tempText.text += tempStr[i];
    //        if (tempText.getMeasuredWidth() > boundW) {
    //            text.text += tempText.text + "\n";
    //            tempText.text = "";
    //        } else if (i == tempStr.length - 1) {
    //            text.text += tempText.text;
    //            break;
    //        }
    //    }
    //
    //}

    container.addChild(text);
    container.setBounds(0, 0, boundW, boundH);
    container.name = "text" + Tool.index++;
    container.resType = CONST.RES_TYPE.TEXT;
    container.img = this.filename;
    Tool.root.addChildAt(container);
    container.x = 910;
    container.y = 420;
    if (Tool.current.name) {
        Tool.current.children.pop();
    }
    Tool.current = container;
    var yellowFocus = new createjs.Shape(getHalo(Tool.current, "#FFFF00"));
    Tool.current.addChild(yellowFocus);
    Tool.prev = Tool.current;
    makeChildEditable(Tool.current.parent);
    moveTo(Tool.current, Tool.current.parent.children.length - 1);
}

function copyItem (srcObj) {
    hideMenu();
    if (Tool.current && Tool.current.parent) {
        makeChildUnEditable(Tool.current.parent);
    }
    if (Tool.current.name) {
        Tool.current.children.pop();
    }

    var dstObj = setupClone([srcObj]).children[0];

    dstObj.x = srcObj.x + 20;
    dstObj.y = srcObj.y + 20;
    dstObj.name = "newCopy" + Tool.index++;
    dstObj.resType = srcObj.resType;
    srcObj.parent.addChild(dstObj);


    Tool.current = dstObj;
    var yellowFocus = new createjs.Shape(getHalo(Tool.current, "#FFFF00"));
    Tool.current.addChild(yellowFocus);
    Tool.prev = Tool.current;
    moveTo(Tool.current, Tool.current.parent.children.length - 1);
    makeChildEditable(Tool.current.parent);
}

function setupClone(itemArray) {
    var moduleNode = new createjs.Container();

    for (var i = 0; i < itemArray.length; i++) {
        var item = itemArray[i];
        if (!item.children) {
            continue;
        }
        if (item.resType == CONST.RES_TYPE.GROUP || item.resType == CONST.RES_TYPE.MULTIPLE) {
            var group = moduleNode.addChild(setupClone(item.children));
            group.name = item.name;
            group.setBounds(0, 0, item.getBounds().width, item.getBounds().height);
            if (item.parent.resType == CONST.RES_TYPE.GROUP || item.parent.resType == CONST.RES_TYPE.MULTIPLE) {
                group.x = item.x;
                group.y = item.y;
            }
            group.type = item.type;
            group.resType = item.resType;
            if (item.navigation) {
                group.nav = item.navigation;
            }

            continue;
        }
        var copy = new createjs.Container();

        if (item.resType == CONST.RES_TYPE.PLACEHOLDER) {
            var shape = new createjs.Shape();
            shape.graphics
                .c()
                .es()
                .ss(1, 'round', 'round')
                .s("rgba(0, 0, 0, 1)")
                .f("rgba(100, 100, 100, 0.8)")
                .dr(0, 0, item.children[0].getBounds().width, item.children[0].getBounds().height);
            shape.setBounds(0, 0,  item.children[0].getBounds().width, item.children[0].getBounds().height);
            copy.addChild(shape);
            var sizeInfo = new createjs.Text(item.children[0].getBounds().width + "x" + item.children[0].getBounds().height, "20px SourceSansPro-Light", "#FF0000");
            copy.addChild(sizeInfo);
        } else if (item.resType == CONST.RES_TYPE.TEXT) {
            var textValue = item.children[0].text;
            var textFont = item.children[0].font;
            var textAlign = item.children[0].textAlign;
            var textColor = item.children[0].color;
            var boundW = item.getBounds().width;
            //var boundH = json.bound.h;
            var text = new createjs.Text(textValue, textFont, textColor);
            text.textAlign = textAlign;
            if (textAlign == "left") {
                text.x = 0;
            } else if (textAlign == "right") {
                text.x = boundW;
            } else if (textAlign == "center") {
                text.x = boundW / 2;
            }
            copy.addChild(text);
        }
        copy.name = "newCopy" + Tool.index++;
        copy.resType = item.resType;
        copy.setBounds(0, 0, item.getBounds().width, item.getBounds().height);
        if (item.parent.resType == CONST.RES_TYPE.GROUP || item.parent.resType == CONST.RES_TYPE.MULTIPLE) {
            copy.x = item.x;
            copy.y = item.y;
        }
        //else {
        //    copy.nav = item.navigation;
        //    return copy;
        //}
        copy.nav = item.navigation;
        moduleNode.addChild(copy);
    }
    var moduleNodeBounds = moduleNode.getBounds();
    moduleNode.setBounds(0, 0, moduleNodeBounds.width, moduleNodeBounds.height);
    return moduleNode;
}