/**
 * Created by Administrator on 17-5-15.
 */
var http_adapter = {};
var g_requestTimeout = 20 * 1000;
var lastCountryCode = null;
var lastCountryCodeFor4K = null;
(function () {
    http_adapter.init = function (callback) {

        DBG_INFO("http_adapter.init");
        cache_adapter.init();
    };

    var getExpiresTime = function (xhr) {
        var expires_time = 0;
        var last_modified = Date.parse(xhr.getResponseHeader("Last-Modified"));
        if (isNaN(last_modified)) {
            last_modified = new Date().valueOf();
        }
        last_modified = last_modified / GLOBAL.MILLIBASE;
        var max_age_tmp = xhr.getResponseHeader("Cache-Control");
        var max_age = NaN;
        if (typeof max_age_tmp == "string") {
            max_age = parseInt(max_age_tmp.substr(max_age_tmp.indexOf("=")+1));
        }
        //1.use Cache-Control
        if(!isNaN(max_age)) {
            expires_time = new Date().valueOf() / GLOBAL.MILLIBASE + max_age;
        } else {
            //2.if no Cache-Control, use Expires
            expires_time = Date.parse(xhr.getResponseHeader("Expires"));
            if (!isNaN(expires_time)) {
                expires_time = expires_time / GLOBAL.MILLIBASE;
            } else {
                //3.neither, use 24h as default value
                max_age = 86400;
                expires_time = last_modified + max_age;
            }
        }
        return expires_time;
    };

    /*ICD of 4K now word 3.1.1  data for launcher Recommendation */

    http_adapter.getRecommendationForLauncher = function (timeStamp,callback) {
        if (typeof callback != "function") {
            callback = function () {
                DBG_INFO("http_adapter.getRecommendationForLauncher does not need callback");
            };
        }
        var token = uso_util.getToken();
        if(token == 0){
            DBG_ERROR("http_adapter.getRecommendationForLauncher does not have Token!!!!!!");
            callback(1,null);
            return;

        }

        // get time_stamp from db
        var stamp = 0;
        var cache_name= "Launcher4kNow";
        var cache_data = cache_adapter.getCache(cache_name,true);
        if(timeStamp == null){
            if (!!cache_data) {
                if(cache_data != "noData") {
                    stamp = cache_data.time_stamp;
                }
            }
        }
        var ask_url = "https://"+uso_util.get4kNowDomain()+"/launcher/4k_now?time_stamp="+stamp+"&"+uso_util.get4kNowSystemParameters(token);
        DBG_ERROR("getRecommendationForLauncher:"+ask_url);
        $.ajax({
            type: 'get',
            url: ask_url,
            headers: {
                "Accept": "application/vnd.dvb.ait+xml",
                "Accept-Encoding":"gzip"
            },
            timeout: g_requestTimeout,
            success: function (data, status, xhr) {
                DBG_ALWAYS("getRecommendationForLauncher Ask success!!!");
                try {

                    if (xhr.status == 304) {
                        if (!!cache_data) {
                            if(cache_data == "noData") {
                                http_adapter.getRecommendationForLauncher(0,callback);
                            }else{
                                callback(0,cache_data);
                            }
                        }
                    }else{
                        if(data.result == 0){
                            //need save data to DB
                            cache_adapter.setCache(cache_name, data,getExpiresTime(xhr));
                        }
                        callback(data.result,data);
                    }
                } catch (e) {
                    DBG_ALWAYS("getRecommendationForLauncher Ask success!!!:" + e.message);
                }

            },
            error: function (xhr, textStatus, errorThrown) {
                DBG_ALWAYS("getRecommendationForLauncher Ask fail!!!" + xhr.status);
                if (null != callback) callback(1,null);
            }
        });

    };

    /*ICD of WebAppStoreAPI 3.3   get home app store category list*/
    var storeTabListTimeStamp = 0;

    http_adapter.getAppStoreTabList = function (timeStamp,callback) {
        if (typeof callback != "function") {
            callback = function () {
                DBG_INFO("http_adapter.getAppStoreTabList does not need callback");
            };
        }
        var token = uso_util.getToken();
        if(token == 0){
            DBG_ERROR("http_adapter.getAppStoreTabList does not have Token!!!!!!");
            callback(1,null);
            return;

        }
        if(lastCountryCode!=null){
            if(lastCountryCode!=GLOBAL.CURRENT_COUNTRY){
                var del_cache= "StoreTabList"+lastCountryCode;
                var del_data = cache_adapter.getCache(del_cache,true);
                if (!!del_data) {
                    if(del_data != "noData") {
                        DBG_ERROR("del lastCountryCode data!!!!!!!!!! "+lastCountryCode);
                        cache_adapter.deleteCache(del_cache);
                    }
                }
            }
        }
        lastCountryCode = model.basicSetting.getTvsetLocation();
        // get time_stamp from db
        var cache_name= "StoreTabList"+GLOBAL.CURRENT_COUNTRY;
        var cache_data = cache_adapter.getCache(cache_name,true);
        var stamp = 0;
        if(timeStamp == null){
            if (!!cache_data) {
                if(cache_data != "noData") {
                    stamp = cache_data.cacheTimeStamp;
                }
            }
        }
        storeTabListTimeStamp = stamp;
        var ask_url = "https://"+uso_util.getAppStoreDomain()+"/webappstoreapi/tab/getTabList?cacheTimeStamp="+stamp+"&"+uso_util.getAppStoreSystemParameters(token)+"&language_ids=-1";
        DBG_ERROR("getAppStoreTabList:"+ask_url);
        $.ajax({
            type: 'get',
            url: ask_url,
            headers: {
                "Accept": "application/vnd.dvb.ait+xml",
                "Accept-Encoding":"gzip"
            },
            timeout: g_requestTimeout,
            success: function (data, status, xhr) {
                DBG_ALWAYS("http_adapter.getAppStoreTabList Ask success!!! "+xhr.status);
                try {
                    if (xhr.status == 304) {
                        if (!!cache_data) {
                            if(cache_data == "noData") {
                                http_adapter.getAppStoreTabList(0,callback);
                            }else{
                                callback(0,cache_data);
                            }
                        }
                    }else{
                        callback(data.resultCode,data);
                        if(data.resultCode == 0){
                            //need save data to DB
                            cache_adapter.setCache(cache_name, data,getExpiresTime(xhr));
                        }
                    }
                } catch (e) {
                    DBG_ALWAYS("http_adapter.getAppStoreTabList Ask success!!!:" + e.message);
                }

            },
            error: function (xhr, textStatus, errorThrown) {
                DBG_ALWAYS("http_adapter.getAppStoreTabList Ask fail!!!" + xhr.status);
                if (null != callback) callback(1,null);
            }
        });

    };

    /*ICD of WebAppStoreAPI 3.4  category data */

    http_adapter.getAppStoreTabDetail = function (tabId,tabindex,timeStamp,callback) {
        if (typeof callback != "function") {
            callback = function () {
                DBG_INFO("http_adapter.getAppStoreTabDetail does not need callback");
            };
        }
        var token = uso_util.getToken();
        if(token == 0){
            DBG_ERROR("http_adapter.getAppStoreTabDetail does not have Token!!!!!!");
            callback(1,null);
            return;

        }
        // get time_stamp from db

        var stamp = 0;
        if(storeTabListTimeStamp == 0){
            stamp = 0;
        }else{
            var cache_name= "StoreTabListDetail"+tabId;
            var cache_data = cache_adapter.getCache(cache_name,true);
            if(timeStamp == null){
                if (!!cache_data) {
                    if(cache_data != "noData") {
                        stamp = cache_data.cacheTimeStamp;
                    }
                }
            }
        }

        var url = "https://"+uso_util.getAppStoreDomain()+"/webappstoreapi/tab/getTabDetail?tabId="+tabId+"&"+uso_util.getAppStoreSystemParameters(token)+"&cacheTimeStamp="+stamp+"&language_ids=-1";
        var log = {"srceventcode":"221000","eventcode":"221001","chipplatform":GLOBAL.PLATFORM,"tabid":tabId,"tabindex":tabindex,"devicemsg":GLOBAL.MODEL_NAME};
        var logStr = objToString(log);
        var temp = model.basicSetting.getImproveHis();
        var ask_url = url;
        if(temp ==1){
            ask_url = url+"&upJson="+encodeURI(logStr);
        }
        DBG_ERROR("getAppStoreTabDetail:"+ask_url);
        $.ajax({
            type: 'get',
            url: ask_url,
            headers: {
                "Accept": "application/vnd.dvb.ait+xml",
                "Accept-Encoding":"gzip"
            },
            timeout: g_requestTimeout,
            success: function (data, status, xhr) {
                DBG_ALWAYS("http_adapter.getAppStoreTabDetail Ask success!!!:"+xhr.status);
                try {
                    if (xhr.status == 304) {
                        if (!!cache_data) {
                            if(cache_data == "noData") {
                                http_adapter.getAppStoreTabDetail(tabId,0,callback);
                            }else{
                                callback(0,cache_data);
                            }
                        }
                    }else{
                        callback(data.resultCode,data);
                        if(data.resultCode == 0){
                            //need save data to DB
                            cache_adapter.setCache(cache_name, data,getExpiresTime(xhr));
                        }

                    }
                } catch (e) {
                    DBG_ALWAYS("http_adapter.getAppStoreTabDetail Ask success!!!:" + e.message);
                }

            },
            error: function (xhr, textStatus, errorThrown) {
                DBG_ALWAYS("http_adapter.getAppStoreTabDetail Ask fail!!!" + xhr.status);
                if (null != callback) callback(1,null);
            }
        });
    };

    /*ICD of WebAppStoreAPI 3.5  all app  data */

    http_adapter.getAppStoreAllApp = function (tabId,tabindex,timeStamp,page,callback) {
        if (typeof callback != "function") {
            callback = function () {
                DBG_INFO("http_adapter.getAppStoreAllApp does not need callback");
            };
        }
        var token = uso_util.getToken();
        if(token == 0){
            DBG_ERROR("http_adapter.getAppStoreAllApp does not have Token!!!!!!");
            callback(1,null);
            return;

        }
        var stamp = 0;
        if(storeTabListTimeStamp == 0){
            stamp = 0;
        }else{
            // get time_stamp from db
            var cache_name= "StoreAllApp"+page;
            var cache_data = cache_adapter.getCache(cache_name,true);
            if(timeStamp == null){
                if (!!cache_data) {
                    if(cache_data != "noData") {
                        stamp = cache_data.cacheTimeStamp;
                    }
                }
            }
        }

        var url = "https://"+uso_util.getAppStoreDomain()+"/webappstoreapi/application/getAllWebApps?tabId="+tabId+"&"+uso_util.getAppStoreSystemParameters(token)+"&cacheTimeStamp="+stamp+"&page="+page+"&language_ids=-1";
        var log = {"srceventcode":"221000","eventcode":"221001","chipplatform":GLOBAL.PLATFORM,"tabid":tabId,"tabindex":tabindex,"devicemsg":GLOBAL.MODEL_NAME};
        var logStr = objToString(log);
        var temp = model.basicSetting.getImproveHis();
        var ask_url = url;
        if(temp ==1){
            ask_url = url+"&upJson="+encodeURI(logStr);
        }

        DBG_ERROR("getAppStoreAllApp:"+ask_url);
        $.ajax({
            type: 'get',
            url: ask_url,
            headers: {
                "Accept": "application/vnd.dvb.ait+xml",
                "Accept-Encoding":"gzip"
            },
            timeout: g_requestTimeout,
            success: function (data, status, xhr) {
                DBG_ALWAYS("http_adapter.getAppStoreAllApp Ask success!!!"+xhr.status);
                try {
                    if (xhr.status == 304) {
                        if (!!cache_data) {
                            if(cache_data == "noData") {
                                http_adapter.getAppStoreTabDetail(tabId,0,callback);
                            }else{
                                callback(0,cache_data);
                            }
                        }
                    }else{
                        callback(data.resultCode,data);
                        if(data.resultCode == 0){
                            //need save data to DB
                            cache_adapter.setCache(cache_name, data,getExpiresTime(xhr));
                        }

                    }
                } catch (e) {
                    DBG_ALWAYS("http_adapter.getAppStoreAllApp Ask success!!!:" + e.message);
                }

            },
            error: function (xhr, textStatus, errorThrown) {
                DBG_ALWAYS("http_adapter.getAppStoreAllApp Ask fail!!!" + xhr.status);
                if (null != callback) callback(1,null);
            }
        });
    };

    function getCurrentLanguageId() {
        var langs = ["chi", "eng", "fre", "kor", "rus", "jpn", "spa", "ger", "zho", "ara", "per",
            "tha", "ita", "dut", "por", "cze", "hun", "gre", "bul", "rum", "mal",
            "hbr", "tur", "ind", "uzb", "nor", "swe", "dan", "fin", "vie"
            , "mya", "hin", "eng", "ukr", "slk", "pol", "srp", "mac", "alb", "hrv", "lav", "est", "lit"];

        return langs.indexOf(GLOBAL.CURRENT_LANGUAGE);

    }

    /*ICD of WebAppStoreAPI 3.6  app  detail */

    http_adapter.getAppStoreAppDetail = function (appId,source,sourceID,upJson,callback) {
        if (typeof callback != "function") {
            callback = function () {
                DBG_INFO("http_adapter.getAppStoreAppDetail does not need callback");
            };
        }
        var token = uso_util.getToken();
        if(token == 0){
            DBG_ERROR("http_adapter.getAppStoreAppDetail does not have Token!!!!!!");
            callback(1,null);
            return;

        }

        var url = "https://"+uso_util.getAppStoreDomain()+"/webappstoreapi/application/getWebAppDetail?appId="+appId+"&"+uso_util.getAppStoreSystemParameters(token)+"&language_ids="+getCurrentLanguageId();
        if(source == 4){
            var log = {"srceventcode":"222000","eventcode":"222000","chipplatform":GLOBAL.PLATFORM,"srcappid":sourceID,"devicemsg":GLOBAL.MODEL_NAME};
        }else if(source == 1 || source == 3){
            var log = {"srceventcode":"224000","eventcode":"222000","chipplatform":GLOBAL.PLATFORM,"srcthirdpartyid":source,"devicemsg":GLOBAL.MODEL_NAME};
        }else{
            var log = {"srceventcode":"221001","eventcode":"222000","chipplatform":GLOBAL.PLATFORM,"srctabid":3,"srccolumnid":2,"srcrowid":1,"srctabindex":3,"devicemsg":GLOBAL.MODEL_NAME};
        }
        if(!!upJson){
            log.srctabid = upJson.srctabid;
            log.srccolumnid = upJson.srccolumnid;
            log.srcrowid = upJson.srcrowid;
            log.srctabindex = upJson.srctabindex;
        }
        var logStr = objToString(log);
        var temp = model.basicSetting.getImproveHis();
        var ask_url = url;
        if(temp ==1){
            ask_url = url+"&upJson="+encodeURI(logStr);
        }
        DBG_ERROR("getAppStoreAppDetail:"+ask_url);
        $.ajax({
            type: 'get',
            url: ask_url,
            headers: {
                "Accept": "application/vnd.dvb.ait+xml",
                "Accept-Encoding":"gzip"
            },
            timeout: g_requestTimeout,
            success: function (data, status, xhr) {
                DBG_ALWAYS("http_adapter.getAppStoreAppDetail Ask success!!!");
                try {
                    callback(data.resultCode,data);
                } catch (e) {
                    DBG_ALWAYS("http_adapter.getAppStoreAppDetail Ask success!!!:" + e.message);
                }

            },
            error: function (xhr, textStatus, errorThrown) {
                DBG_ALWAYS("http_adapter.getAppStoreAppDetail Ask fail!!!" + xhr.status);
                if (null != callback) callback(1,null);
            }
        });
    };

    /*ICD of WebAppStoreAPI 3.7  Related app  */

    http_adapter.getAppStoreRelatedApps = function (appId,callback) {
        if (typeof callback != "function") {
            callback = function () {
                DBG_INFO("http_adapter.getAppStoreRelatedApps does not need callback");
            };
        }
        var token = uso_util.getToken();
        if(token == 0){
            DBG_ERROR("http_adapter.getAppStoreRelatedApps does not have Token!!!!!!");
            callback(1,null);
            return;

        }

        var ask_url = "https://"+uso_util.getAppStoreDomain()+"/webappstoreapi/application/getRelatedApps?appId="+appId+"&"+uso_util.getAppStoreSystemParameters(token)+"&language_ids="+getCurrentLanguageId();
        DBG_ERROR("getAppStoreRelatedApps:"+ask_url);
        $.ajax({
            type: 'get',
            url: ask_url,
            headers: {
                "Accept": "application/vnd.dvb.ait+xml",
                "Accept-Encoding":"gzip"
            },
            timeout: g_requestTimeout,
            success: function (data, status, xhr) {
                DBG_ALWAYS("http_adapter.getAppStoreRelatedApps Ask success!!!");
                try {
                    callback(data.resultCode,data);
                } catch (e) {
                    DBG_ALWAYS("http_adapter.getAppStoreRelatedApps Ask success!!!:" + e.message);
                }

            },
            error: function (xhr, textStatus, errorThrown) {
                DBG_ALWAYS("http_adapter.getAppStoreRelatedApps Ask fail!!!" + xhr.status);
                if (null != callback) callback(1,null);
            }
        });
    };


    /*ICD of WebAppStoreAPI 3.9    */

    http_adapter.getSysCfg = function (callback) {
        if (typeof callback != "function") {
            callback = function () {
                DBG_INFO("http_adapter.getSysCfg does not need callback");
            };
        }
        var token = uso_util.getToken();
        if(token == 0){
            DBG_ERROR("http_adapter.getSysCfg does not have Token!!!!!!");
            callback(1,null);
            return;

        }

        var ask_url = "https://"+uso_util.getAppStoreDomain()+"/webappstoreapi/common/getSysCfg?"+uso_util.getAppStoreSystemParameters(token);
        DBG_ERROR("getSysCfg:"+ask_url);
        $.ajax({
            type: 'get',
            url: ask_url,
            headers: {
                "Accept": "application/vnd.dvb.ait+xml",
                "Accept-Encoding":"gzip"
            },
            timeout: g_requestTimeout,
            success: function (data, status, xhr) {
                DBG_ALWAYS("http_adapter.getSysCfg Ask success!!!");
                try {
                    var cache_name= "AppStoreLineCnt";
                    cache_adapter.setCache(cache_name, data,getExpiresTime(xhr));
                    callback(data.resultCode,data);
                } catch (e) {
                    DBG_ALWAYS("http_adapter.getSysCfg Ask success!!!:" + e.message);
                }

            },
            error: function (xhr, textStatus, errorThrown) {
                DBG_ALWAYS("http_adapter.getSysCfg Ask fail!!!" + xhr.status);
                if (null != callback) callback(1,null);
            }
        });
    };


    /*ICD of WebAppStoreAPI 3.9    */

    http_adapter.checkAppOnlineStatus = function (appId,callback) {
        if (typeof callback != "function") {
            callback = function () {
                DBG_INFO("http_adapter.checkAppOnlineStatus does not need callback");
            };
        }
        var token = uso_util.getToken();
        if(token == 0){
            DBG_ERROR("http_adapter.checkAppOnlineStatus does not have Token!!!!!!");
            callback(1,null);
            return;

        }

        var ask_url = "https://"+uso_util.getAppStoreDomain()+"/webappstoreapi/application/checkAppOnlineStatus?appIdStr="+appId+"&"+uso_util.getAppStoreSystemParameters(token);
        DBG_ERROR("checkAppOnlineStatus:"+ask_url);
        $.ajax({
            type: 'get',
            url: ask_url,
            headers: {
                "Accept": "application/vnd.dvb.ait+xml",
                "Accept-Encoding":"gzip"
            },
            timeout: g_requestTimeout,
            success: function (data, status, xhr) {
                DBG_ALWAYS("http_adapter.checkAppOnlineStatus Ask success!!!");
                try {
                    callback(data.resultCode,data);
                } catch (e) {
                    DBG_ALWAYS("http_adapter.checkAppOnlineStatus Ask success!!!:" + e.message);
                }
            },
            error: function (xhr, textStatus, errorThrown) {
                DBG_ALWAYS("http_adapter.getSysCfg Ask fail!!!" + xhr.status);
                if (null != callback) callback(1,null);
            }
        });
    };

    /*ICD of 4K now word 3.1.4  personalized recommend  */

    http_adapter.getPersonalized = function (callback) {
        if (typeof callback != "function") {
            callback = function () {
                DBG_INFO("http_adapter.getPersonalized does not need callback");
            };
        }
        var token = uso_util.getToken();
        if(token == 0){
            DBG_ERROR("http_adapter.getPersonalized does not have Token!!!!!!");
            callback(1,null);
            return;

        }

        var ask_url = "https://"+uso_util.get4kNowDomain()+"/recommendation/personalized_medias?"+uso_util.get4kNowSystemParameters(token);
        DBG_ERROR("getPersonalized:"+ask_url);
//        var parm = "&chip_platform="+GLOBAL.PLATFORM+"&device_id="+GLOBAL.DEVICE_ID+"&original=search&event_code=232000&column_id=0&src_event_code=201000";
//        var temp = model.basicSetting.getImproveHis();
//        if(temp ==1){
//            ask_url = ask_url+parm+"&devicemsg="+GLOBAL.MODEL_NAME;
//        }
        $.ajax({
            type: 'get',
            url: ask_url,
            headers: {
                "Accept": "application/vnd.dvb.ait+xml",
                "Accept-Encoding":"gzip"
            },
            timeout: g_requestTimeout,
            success: function (data, status, xhr) {
                DBG_ALWAYS("http_adapter.getPersonalized Ask success!!!");
                try {
                    callback(data.result,data);
                } catch (e) {
                    DBG_ALWAYS("http_adapter.getPersonalized Ask success!!!:" + e.message);
                }

            },
            error: function (xhr, textStatus, errorThrown) {
                DBG_ALWAYS("http_adapter.getPersonalized Ask fail!!!" + xhr.status);
                if (null != callback) callback(1,null);
            }
        });
    };

    http_adapter.getHotKeywords = function (keyword, callback) {
        if (typeof callback != "function") {
            callback = function () {
                DBG_INFO("http_adapter.getHotKeywords does not need callback");
            };
        }
        var token = uso_util.getToken();
        if(token == 0){
            DBG_ERROR("http_adapter.getHotKeywords does not have Token!!!!!!");
            callback(1,null);
            return;

        }
        var key_word = encodeURIComponent(keyword);
        var ask_url = "https://"+uso_util.getDiscoveryDomain()+"/search/hot_words?keyword="+key_word+"&limit=30&"+uso_util.getDiscoverySystemParameters(token);
//        ask_url = encodeURI(ask_url);
        DBG_ERROR("getHotKeywords:"+ask_url);
        $.ajax({
            type: 'get',
            url: ask_url,
            headers: {
                "Accept": "application/vnd.dvb.ait+xml",
                "Accept-Encoding":"gzip"
            },
            timeout: g_requestTimeout,
            success: function (data, status, xhr) {
//                DBG_ALWAYS("http_adapter.getHotKeywords Ask success!!!:"+objToString(data));
                try {
                    callback(keyword,data.result,data);
                } catch (e) {
                    DBG_ALWAYS("http_adapter.getHotKeywords Ask success!!!:" + e.message);
                }

            },
            error: function (xhr, textStatus, errorThrown) {
                DBG_ALWAYS("http_adapter.getHotKeywords Ask fail!!!" + xhr.status);
                if (null != callback) callback(keyword,1,null);
            }
        });
    };

    /*ICD of 4K now word 3.1.5.2  search default hot keywords  */

    http_adapter.getDefaultHotKeywords = function (callback) {
        if (typeof callback != "function") {
            callback = function () {
                DBG_INFO("http_adapter.getDefaultHotKeywords does not need callback");
            };
        }

        var ask_url = "https://"+uso_util.getDiscoveryDomain()+"/search/default_hot_words?&limit=30&"+uso_util.getDiscoverySystemParameters();
//        ask_url = encodeURI(ask_url);
        DBG_ERROR("getDefaultHotKeywords:"+ask_url);
        $.ajax({
            type: 'get',
            url: ask_url,
            headers: {
                "Accept": "application/vnd.dvb.ait+xml",
                "Accept-Encoding":"gzip"
            },
            timeout: g_requestTimeout,
            success: function (data, status, xhr) {
                DBG_ALWAYS("http_adapter.getDefaultHotKeywords Ask success!!!");
                try {
                    callback(data.result,data);
                } catch (e) {
                    DBG_ALWAYS("http_adapter.getDefaultHotKeywords Ask success!!!:" + e.message);
                }

            },
            error: function (xhr, textStatus, errorThrown) {
                DBG_ALWAYS("http_adapter.getDefaultHotKeywords Ask fail!!!" + xhr.status);
                if (null != callback) callback(1,null);
            }
        });
    };

    /*ICD of 4K now word 3.1.5.3  search content  */

    http_adapter.getSearchContent = function (keyword, callback) {
        if (typeof callback != "function") {
            callback = function () {
                DBG_INFO("http_adapter.getSearchContent does not need callback");
            };
        }
        var token = uso_util.getToken();
        if(token == 0){
            DBG_ERROR("http_adapter.getSearchContent does not have Token!!!!!!");
            callback(1,null);
            return;

        }
        var key_word = encodeURIComponent(keyword);
        var ask_url = "https://"+uso_util.getDiscoveryDomain()+"/search/contents?keyword="+key_word+"&limit=30&"+uso_util.getDiscoverySystemParameters(token);
//        var parm = "&chip_platform="+GLOBAL.PLATFORM+"&device_id="+GLOBAL.DEVICE_ID+"&original=search&event_code=232000&column_id=0&src_event_code=201001";
//        var temp = model.basicSetting.getImproveHis();
//        if(temp ==1){
//            ask_url = ask_url+parm+"&devicemsg="+GLOBAL.MODEL_NAME;
//        }
        DBG_ERROR("getSearchContent:"+ask_url);
        $.ajax({
            type: 'get',
            url: ask_url,
            headers: {
                "Accept": "application/vnd.dvb.ait+xml",
                "Accept-Encoding":"gzip"
            },
            timeout: g_requestTimeout,
            success: function (data, status, xhr) {
                DBG_ALWAYS("http_adapter.getSearchContent Ask success!!!");
                try {
                    callback(data.result,data);
                } catch (e) {
                    DBG_ALWAYS("http_adapter.getSearchContent Ask success!!!:" + e.message);
                }
            },
            error: function (xhr, textStatus, errorThrown) {
                DBG_ALWAYS("http_adapter.getSearchContent Ask fail!!!" + xhr.status);
                if (null != callback) callback(1,null);
            }
        });
    };

    var fourKnowTabListTimestamp = 0;
    http_adapter.get4knowTabList = function (timeStamp,callback) {
        if (typeof callback != "function") {
            callback = function () {
                DBG_INFO("http_adapter.get4knowTabList does not need callback");
            };
        }
        var token = uso_util.getToken();
        if(token == 0){
            DBG_ERROR("http_adapter.get4knowTabList does not have Token!!!!!!");
            callback(1,null);
            return;

        }
        if(lastCountryCodeFor4K!=null){
            if(lastCountryCodeFor4K!=GLOBAL.CURRENT_COUNTRY){
                var del_cache= "4knowTabList"+lastCountryCodeFor4K;
                var del_data = cache_adapter.getCache(del_cache,true);
                if (!!del_data) {
                    if(del_data != "noData") {
                        DBG_ERROR("del lastCountryCode data!!!!!!!!!! "+lastCountryCodeFor4K);
                        cache_adapter.deleteCache(del_cache);
                    }
                }
            }
        }
        lastCountryCodeFor4K = model.basicSetting.getTvsetLocation();
        // get time_stamp from db
        var cache_name= "4knowTabList"+GLOBAL.CURRENT_COUNTRY;
        var cache_data = cache_adapter.getCache(cache_name,true);
        var stamp = 0;
        if(timeStamp == null){
            if (!!cache_data) {
                if(cache_data != "noData") {
                    stamp = cache_data.time_stamp;
                }
            }
        }
        fourKnowTabListTimestamp = stamp;
        var ask_url = "https://"+uso_util.get4kNowDomain()+"/homepage/pattern?time_stamp="+stamp+"&"+uso_util.get4kNowSystemParameters(token);
        DBG_ERROR("get4knowTabList ask_url="+ask_url);
        $.ajax({
            type: 'get',
            //data: data, // pass the data object as the POST data instead of defining an object inline
            dataType: "json",
            url: ask_url,
            headers: {
//                'x-auth-hash': g_token,
                "Accept": "application/vnd.dvb.ait+xml",
                "Accept-Encoding":"gzip"
//                "x-auth-timestamp": g_fvpTimeStamp
            },
            timeout: g_requestTimeout,
            success: function (data, status, xhr) {
                DBG_ERROR("http_adapter.get4knowTabList Ask success!!!");
                try {
                    DBG_ERROR("xhr.status="+xhr.status);
                    if (xhr.status == 304) {

                        if (!!cache_data) {
//                            DBG_ERROR("get4knowTabList cache_data=" + objToString(cache_data));
                            if(cache_data == "noData") {
                                http_adapter.get4knowTabList(0,callback);
                            }else{
                                callback(0,cache_data);
                            }
                        }
                    }else if(xhr.status == 200){
                        callback(data.result,data);
                        if(data.result == 0){
                            cache_adapter.setCache(cache_name, data,getExpiresTime(xhr));
                        }
//                        DBG_ERROR("get4knowTabList data222===" + objToString(data));

                    }else{//error handle
                        if (null != callback){
                            callback(1,null);
                        }
                    }
                } catch (e) {
                    DBG_ERROR("http_adapter.get4knowTabList Ask failed!!!:" + e.message);
                    if (null != callback){
                        callback(1,null);
                    }
                }

            },
            error: function (xhr, textStatus, errorThrown) {
                DBG_ERROR("http_adapter.get4knowTabList Ask fail!!!" + xhr.status);
                if (null != callback){
                    callback(1,null);
                }
                }
        });

    };
    http_adapter.get4knowTabDetail = function (timeStamp,tag_id,categoryType,log,callback) {
        if (typeof callback != "function") {
            callback = function () {
                DBG_INFO("http_adapter.get4knowTabDetail does not need callback");
            };
        }
        var token = uso_util.getToken();
        if(token == 0){
            DBG_ERROR("http_adapter.get4knowTabDetail does not have Token!!!!!!");
            callback(1,null);
            return;

        }

        var stamp = 0;
        if(fourKnowTabListTimestamp == 0){
            stamp = 0;
        }else{
            // get time_stamp from db
            var cache_name= "";
            if(categoryType=="apps") {
                cache_name= "4knowAppList"+tag_id;
            }else if(categoryType=="videos"){
                cache_name= "4knowVideoList"+tag_id;
            }
            var cache_data = cache_adapter.getCache(cache_name,true);

            if(timeStamp == null){
                if (!!cache_data) {
                    if(cache_data != "noData") {
                        stamp = cache_data.time_stamp;
                    }
                }
            }
        }
        var ask_url = "https://"+uso_util.get4kNowDomain()+"/homepage/"+categoryType+"?"+uso_util.get4kNowSystemParameters(token)+"&time_stamp="+stamp+"&tag_id="+tag_id;

//        var temp = model.basicSetting.getImproveHis();
//        if(temp ==1){
//            if(!!log){
//                var parm = "&chip_platform="+GLOBAL.PLATFORM+"&device_id="+GLOBAL.DEVICE_ID+"&original=4k_now&event_code=212000";
//                var parm1 = "&src_event_code=201000&src_column_id="+log.src_column_id+"&src_group_id="+log.src_group_id
//                        +"&src_row_id="+log.src_row_id;
//                ask_url = ask_url+parm+parm1+"&devicemsg="+GLOBAL.MODEL_NAME;
//
//            }
//        }

        DBG_ERROR("get4knowTabDetail ask_url="+ask_url);
        $.ajax({
            type: 'get',
            dataType: "json",
            url: ask_url,
            headers: {
//                'x-auth-hash': g_token,
                "Accept": "application/vnd.dvb.ait+xml",
                "Accept-Encoding":"gzip"
//                "x-auth-timestamp": g_fvpTimeStamp
            },
            timeout: g_requestTimeout,
            success: function (data, status, xhr) {
                DBG_ERROR("http_adapter.get4knowTabDetail Ask success!!!");
                try {
                    if (xhr.status == 304) {
                        if (!!cache_data) {
                            if(cache_data == "noData") {
                                http_adapter.get4knowVideosDetail(0,tag_id,callback);
                            }else{
                                callback(0,cache_data);
                            }
                        }
                    }else if(xhr.status == 200){
                        callback(data.result,data);
                        if(data.result == 0){
                            cache_adapter.setCache(cache_name, data,getExpiresTime(xhr));
                        }

                    }else{
                        if (null != callback){
                            callback(1,null);
                        }
                    }
                } catch (e) {
                    DBG_ERROR("http_adapter.get4knowTabDetail Ask fail!!!:" + e.message);
                    if (null != callback){
                        callback(1,null);
                    }
                }

            },
            error: function (xhr, textStatus, errorThrown) {
                DBG_ERROR("http_adapter.get4knowTabDetail Ask fail!!!" + xhr.status);
                if (null != callback){
                    callback(1,null);
                }
            }
        });
    };
    http_adapter.get4knowAppsDetail = function (timeStamp,tag_id,callback) {
        if (typeof callback != "function") {
            callback = function () {
                DBG_INFO("http_adapter.get4knowTabDetail does not need callback");
            };
        }
        var token = uso_util.getToken();
        if(token == 0){
            DBG_ERROR("http_adapter.get4knowAppsDetail does not have Token!!!!!!");
            callback(1,null);
            return;

        }
        // get time_stamp from db
        var cache_name= "4knowAppList";
        var cache_data = cache_adapter.getCache(cache_name,true);
        var stamp = 0;
        if(timeStamp == null){
            if (!!cache_data) {
                if(cache_data != "noData") {
                    stamp = cache_data.time_stamp;
                }
            }
        }
        var ask_url = "https://"+uso_util.get4kNowDomain()+"/homepage/apps?"+uso_util.get4kNowSystemParameters(token)+"&time_stamp="+stamp+"&tag_id="+tag_id;
        DBG_ERROR("get4knowAppsDetail ask_url="+ask_url);
        $.ajax({
            type: 'get',
            url: ask_url,
            dataType: "json",
            headers: {
                "Accept": "application/vnd.dvb.ait+xml",
                "Accept-Encoding":"gzip"
            },
            timeout: g_requestTimeout,
            success: function (data, status, xhr) {
                DBG_ERROR("http_adapter.get4knowAppsDetail Ask success!!!");
                try {
                    if (xhr.status == 304) {
                        if (!!cache_data) {
                            if(cache_data == "noData") {
                                http_adapter.get4knowAppsDetail(0,tag_id,callback);
                            }else{
                                callback(0,cache_data);
                            }
                        }
                    }else if(xhr.status == 200){
                        callback(data.result,data);
                        if(data.result == 0){
                            cache_adapter.setCache(cache_name, data,getExpiresTime(xhr));
                        }

                    }else{

                    }
                } catch (e) {
                    DBG_ERROR("http_adapter.get4knowAppsDetail Ask success!!!:" + e.message);
                }

            },
            error: function (xhr, textStatus, errorThrown) {
                DBG_ERROR("http_adapter.get4knowAppsDetail Ask fail!!!" + xhr.status);
                if (null != callback) callback(1,null);
            }
        });
    };
    http_adapter.getVideoDetailById = function (mediaId,source,timeStamp,log,callback) {//donot need cache  vendor list also return here
        if (typeof callback != "function") {
            callback = function () {
                DBG_INFO("http_adapter.getMediaDetail does not need callback");
            };
        }
        var token = uso_util.getToken();
        if(token == 0){
            DBG_ERROR("http_adapter.getVideoDetailById does not have Token!!!!!!");
            callback(1,null);
            return;

        }
        var sourceTmp = source;
        if(source=="notification"){
            sourceTmp = "discovery";
        }
        var ask_url = "https://"+uso_util.get4kNowDomain()+"/media/detail?media_id="+mediaId+"&source="+sourceTmp+"&"+uso_util.get4kNowSystemParameters(token);

        var temp = model.basicSetting.getImproveHis();
        if(temp ==1){
            if(!!log){
                var original = 0;
                if(source=="discovery"){
                    original = 2;
                }
                if(source=="4k_now"){
                    var parm = "&chip_platform="+GLOBAL.PLATFORM+"&device_id="+GLOBAL.DEVICE_ID+"&original="+original+"&event_code=212000";
                    var parm1 = "&src_event_code="+log.src_event_code+"&src_column_id="+log.src_column_id+"&src_group_id="+log.src_group_id
                        +"&src_row_id="+log.src_row_id+"&src_tab_id="+log.src_tab_id+"&src_tab_index="+log.src_tab_index+"&src_media_id="+log.src_media_id;
                    ask_url = ask_url+parm+parm1+"&device_msg="+GLOBAL.MODEL_NAME;
                }else if(source=="notification"){
                    var parm = "&chip_platform="+GLOBAL.PLATFORM+"&device_id="+GLOBAL.DEVICE_ID+"&original="+original+"&event_code=212000";
                    var parm1 = "&src_event_code="+log.src_event_code+"&src_object_id="+mediaId+"&src_object_type=0&src_third_party_id=4";
                    ask_url = ask_url+parm+parm1+"&device_msg="+GLOBAL.MODEL_NAME;
                }
                else
                {
                    var parm = "&chip_platform="+GLOBAL.PLATFORM+"&device_id="+GLOBAL.DEVICE_ID+"&original="+original+"&event_code=212000&column_id="+log.column_id;
                    var parm1 = "&src_event_code="+log.src_event_code+"&src_tab_id="+log.src_tab_id+"&src_tab_index="+log.src_tab_index+"&src_object_id="
                        +mediaId+"&src_object_type=0&src_third_party_id=3";
                    ask_url = ask_url+parm+parm1+"&device_msg="+GLOBAL.MODEL_NAME;
                }
            }
        }
        DBG_ERROR("getVideoDetailById ask_url="+ask_url);
        $.ajax({
            type: 'get',
            url: ask_url,
            dataType: "json",
            headers: {
//                'x-auth-hash': g_token,
                "Accept": "application/vnd.dvb.ait+xml",
                "Accept-Encoding":"gzip"
//                "x-auth-timestamp": g_fvpTimeStamp
            },
            timeout: g_requestTimeout,
            success: function (data, status, xhr) {
                DBG_ERROR("http_adapter.getMediaDetail Ask success!!!");
                try {
                    callback(data.result,data);
                } catch (e) {
                    DBG_ALWAYS("http_adapter.getMediaDetail Ask success!!!:" + e.message);
                }

            },
            error: function (xhr, textStatus, errorThrown) {
                DBG_ERROR("http_adapter.getMediaDetail Ask fail!!!" + xhr.status);
                if (null != callback) callback(1,null);
            }
        });
    };
    http_adapter.getRelatedVideoById = function (mediaId,source,timeStamp,callback) {//donot need cache
        if (typeof callback != "function") {
            callback = function () {
                DBG_INFO("http_adapter.getRelatedMedias does not need callback");
            };
        }
        var token = uso_util.getToken();
        if(token == 0){
            DBG_ERROR("http_adapter.getRelatedVideoById does not have Token!!!!!!");
            callback(1,null);
            return;

        }

        var stamp = 0;
        if(timeStamp == null){

        }
        var ask_url = "https://"+uso_util.get4kNowDomain()+"/recommendation/related_medias?media_id="+mediaId+"&source="+source+"&"+uso_util.get4kNowSystemParameters(token)+"&cacheTimeStamp="+stamp;
        DBG_ERROR("getRelatedVideoById ask_url="+ask_url);
        $.ajax({
            type: 'get',
            url: ask_url,
            dataType: "json",
            headers: {
//                'x-auth-hash': g_token,
                "Accept": "application/vnd.dvb.ait+xml",
                "Accept-Encoding":"gzip"
//                "x-auth-timestamp": g_fvpTimeStamp
            },
            timeout: g_requestTimeout,
            success: function (data, status, xhr) {
                DBG_ALWAYS("http_adapter.getRelatedMedias Ask success!!!");
                try {
                    if(xhr.status == 200){
                        callback(data.result,data);
                    }else{
                        if (null != callback){
                            callback(1,null);
                        }
                    }
                } catch (e) {
                    DBG_ALWAYS("http_adapter.getRelatedMedias Ask success!!!:" + e.message);
                    if (null != callback){
                        callback(1,null);
                    }
                }

            },
            error: function (xhr, textStatus, errorThrown) {
                DBG_ALWAYS("http_adapter.getRelatedMedias Ask fail!!!" + xhr.status);
                if (null != callback){
                    callback(1,null);
                }
            }
        });
    }

})();
