DBG_INFO("PubFunc.js start " + debugRunTime());


/**
 * Created by jiaguili on 16-1-20.
 */
function _getIndex(a, b) {
    if (!a) {
        return -1;
    }
    for (var i = 0; i < a.length; i++) {
        if (a[i] == b) {
            return i;
        }
    }
    return -1;
}
function _getIndexByNum(a, b) {
    for (var i = 0; i < a.length; i++) {
        if (a[i].number == b) {
            return i;
        }
    }
    return -1;
}
function _getIndexByCode(a, b) {
    for (var i = 0; i < a.length; i++) {
        if (a[i].code == b) {
            return i;
        }
    }
    return -1;
}
function _getIndexById(a, b) {
    for (var i = 0; i < a.length; i++) {
        if (a[i].id == b) {
            return i;
        }
    }
    return -1;
}
function _cloneObj(obj) {
    return $.extend({}, obj);
}
function isObjectValueEqual(a, b) {
    // Of course, we can do it use for in
    // Create arrays of property names
    var aProps = Object.getOwnPropertyNames(a);
    var bProps = Object.getOwnPropertyNames(b);

    // If number of properties is different,
    // objects are not equivalent
    if (aProps.length != bProps.length) {
        return false;
    }

    for (var i = 0; i < aProps.length; i++) {
        var propName = aProps[i];

        // If values of same property are not equal,
        // objects are not equivalent
        if (a[propName] !== b[propName]) {
            return false;
        }
    }

    // If we made it this far, objects
    // are considered equivalent
    return true;
}
function ChangeTimeformat(hours, min, format) {
    var time = {
        "hour": "",
        "min": "",
        "flag": 0
    }
    if ((min + "").length < 2) {
        time.min = "0" + min;
    } else {
        time.min = min;
    }
    if (format == 0) {
        if (hours > 11) {
            if (hours > 12) {
                time.hour = (parseInt(hours, 10) - 12);
                time.flag = 1;


            }
            else {
                time.hour = parseInt(hours, 10);
                time.flag = 1;
            }

        }
        else {
            if (hours == 0) {
                time.hour = "12";
                time.flag = 0;

            }
            else {

                time.hour = parseInt(hours, 10) + "";
                time.flag = 0;
            }
        }
        if (( time.hour + "").length < 2) {
            time.hour = "0" + time.hour;
        }
    }
    else {
        if ((hours + "").length < 2) {
            time.hour = "0" + hours;
        }
        else {
            time.hour = hours;
        }
    }
    return time;
}

function ChangeInttoTime(times, format) {
    var str = {
        "hour": "",
        "min": "",
        "flag": 0
    };
    if (times < 0) {
        return null;
    }
    var time1 = parseInt(times / 3600);
    var time2 = parseInt((times - time1 * 3600) / 60);
    DBG_INFO("changthe time " + time1 + time2);
//    var str="";
    if (("" + time2).length < 2) {
        time2 = "0" + time2;
    }
    if (format == 0) {
        if (time1 > 11) {
            if (time1 > 12) {
                time1 = parseInt(time1) - 12;
                //str=time1+":"+time2+" PM";
            }
            else {
                time1 = parseInt(time1);
                // str=time1+":"+time2+" PM";
            }
            str.hour = time1;
            str.min = time2;
            str.flag = 1;

        }
        else {
            if (time1 == 0) {
                time1 = "12"
            }
            time1 = parseInt(time1);
            // str=time1+":"+time2+" AM";
            str.hour = time1;
            str.min = time2;
            str.flag = 0;

        }
        if (( str.hour + "").length < 2) {
            str.hour = "0" + str.hour;
        }

    }
    else {
        if (("" + time1).length < 2) {
            time1 = "0" + time1;
        }
        // str=time1+":"+time2;
        str.hour = time1;
        str.min = time2;
        str.flag = 0;
    }
    return str;
}
function copyObj(frmObj) {
    var toObj = Array.isArray(frmObj) ? [] : {};
    return $.extend(toObj, frmObj, true);
}
function getSysCountryZoneList(verArea, CurrentSubArea) {
    var countryMapList=[];
    if(verArea=="SA")
    {

        countryMapList = [
            {
                //"name": "Philippines",
                "code": "PHL",
                "defzone":0,
                "zoneCodeList":[8*3600],
                "osdList":["UTC+8"]
            },
            {
                //"name": "Argentina",
                "code": "ARG",
                "defzone":0,
                "zoneCodeList":[-3*3600,-4*3600],
                "osdList":["UTC-3","UTC-4"]
            },
            {
                //"name": "Brazil",
                "code": "BRA",
                "defzone":1,
                "zoneCodeList":[-2*3600,-3*3600,-4*3600,-5*3600],
                "osdList":["Brasilia Time +1 (UTC-2)","Brasilia Time (UTC-3)","Brasilia Time -1 (UTC-4)","Brasilia Time -2 (UTC-5)"]
            },
            //{
            //
            //    //"name": "Panama",
            //    "code": "PAN",
            //    "defzone":0,
            //    "zoneCodeList":[28],
            //    "osdList":["UTC-5"]
            //},
            //
            //{
            //
            //    //"name": "Venezuela",
            //    "code": "VEN",
            //    "defzone":0,
            //    "zoneCodeList":[29],
            //    "osdList":["UTC-4.5"]
            //},
            {
                //"name": "Uruguay",
                "code": "URY",
                "defzone":1,
                "zoneCodeList":[-2*3600,-3*3600],
                "osdList":["UTC-2","UTC-3"]
            },
            {
                //"name": "Peru",
                "code": "PER",
                "defzone":0,
                "zoneCodeList":[-5*3600],
                "osdList":["UTC-5"]
            },
            {
                //"name": "Paraguay",
                "code": "PRY",
                "defzone":0,
                "zoneCodeList":[-4*3600],
                "osdList":["UTC-4"]
            },
            {
                //"name": "Bolivia",
                "code": "BOL",
                "defzone":0,
                "zoneCodeList":[-4*3600],
                "osdList":["UTC-4"]
            },
            {
                //"name": "Ecuador",
                "code": "ECU",
                "defzone":0,
                "zoneCodeList":[-5*3600,-6*3600],
                "osdList":["UTC-5","UTC-6"]
            } ,
            {
                //"name": "Chile",//智利
                "code": "CHL",
                "defzone":0,
                "zoneCodeList":[-4*3600],
                "osdList":["UTC-4"]
            },
            {
                //"name": "Costa Rica",//哥斯达黎加
                "code": "CRI",
                "defzone":0,
                "zoneCodeList":[-6*3600],
                "osdList":["UTC-6"]
            },
            {
                //"name": "Colombia",
                "code": "COL",
                "defzone":0,
                "zoneCodeList":[-5*3600],
                "osdList":["UTC-5"]
            }
        ]
    }
    else  if(verArea=="NA")
    {
        countryMapList = [
            {
                //"name": "USA",
                "code": "USA",
                "defzone":0,
                "zoneCodeList":[0, 2, 3, 4, 5, 6, 7],
              //  "osdList":["Eastern（UTC-5)","Indiana (UTC-6)","Central (UTC-6)","Mountain (UTC-7)","Arizona (UTC-7)","Pacific (UTC-8)","Alaska (UTC-9)","Hawaii(UTC-10)"]
                "osdList": ["[SE0648]", "[SE0650]", "[SE0651]", "[SE0652]", "[SE0653]", "[SE0654]", "[SE0655]"]
            },
            {
                //"name": "Canada",
                "code": "CAN",
                "defzone":0,
                "zoneCodeList":[9, 10, 0, 2, 3, 5],
                "osdList": ["[FTE0050]", "[FTE0051]", "[SE0648]", "[SE0650]", "[SE0651]", "[SE0653]"]
            },
            {
                //"name": "Mexico",
                "code": "MEX",
                "defzone":0,
                "zoneCodeList": [2, 3, 5],
                "osdList": ["[SE0650]", "[SE0651]", "[SE0653]"]
            },
            {
                //"name": "Panama",
                "code": "PAN",
                "defzone":0,
                "zoneCodeList": [0],
                "osdList": ["[SE0648]"]
            },
            {
                //"name": "Costa Rica",
                "code": "CRI",
                "defzone":0,
                "zoneCodeList": [2],
                "osdList": ["[SE0650]"]
            },
            {
                //"name": "Nicaragua",
                "code": "NIC",
                "defzone":0,
                "zoneCodeList": [2],
                "osdList": ["[SE0650]"]
            },
            {
                //"name": "Honduras",
                "code":"HND",
                "defzone":0,
                "zoneCodeList": [2],
                "osdList": ["[SE0650]"]
            },
            {
                //"name": "El Salvador",
                "code": "SLV",
                "defzone":0,
                "zoneCodeList": [2],
                "osdList": ["[SE0650]"]
            } ,
            {
                //"name": "Guatemala",
                "code": "GTM",
                "defzone":0,
                "zoneCodeList": [2],
                "osdList": ["[SE0650]"]
            },
            {
                //"name": "Dominican Republic",
                "code": "DMA",
                "defzone":0,
                "zoneCodeList": [10],
                "osdList": [ "[FTE0051]"]
            },
            {
                //"name": "Trinidad",
                "code": "TTO",
                "defzone":0,
                "zoneCodeList": [10],
                "osdList": [ "[FTE0051]"]
            },
            {
                //"name": "Curacao",
                "code": "CUW",
                "defzone":0,
                "zoneCodeList": [10],
                "osdList": [ "[FTE0051]"]
            },
            {
                //"name": "Barbados",
                "code": "BRB",
                "defzone":0,
                "zoneCodeList": [10],
                "osdList": [ "[FTE0051]"]
            },
            {
                //"name": "St. Maarten",
                "code": "MAF",
                "defzone":0,
                "zoneCodeList": [10],
                "osdList": [ "[FTE0051]"]
            },
            {
                //"name": "Puerto Rico",
                "code": "PRI",
                "defzone":0,
                "zoneCodeList": [10],
                "osdList": [ "[FTE0051]"]
            },
            {
                //"name": "Cuba",
                "code": "CUB",
                "defzone":0,
                "zoneCodeList": [0],
                "osdList": ["[SE0648]"]
            },
            {
                //"name": "Jamaica",
                "code": "JAM",
                "defzone":0,
                "zoneCodeList": [0],
                "osdList": ["[SE0648]"]
            }
        ]
    }
    else  if(verArea=="EU")
    {
        countryMapList = [
            {
                //"name": "Germany",
                "code": "DEU",
                "defzone":0,
                "zoneCodeList":[1*3600,65535],
                "osdList":["CET(UTC+1)","[GE0012]"]
            },
            {
                //"name": "Austria",
                "code": "AUT",
                "defzone":0,
                "zoneCodeList":[1*3600,65535],
                "osdList":["CET(UTC+1)","[GE0012]"]
            },
            {
                // "name": "Italy",
                "code": "ITA",
                "defzone":0,
                "zoneCodeList":[1*3600,65535],
                "osdList":["CET(UTC+1)","[GE0012]"]
            },
            {
                //"name": "England",
                "code": "GBR",
                "defzone":0,
                "zoneCodeList":[0,65535],
                "osdList":["WET(UTC+0)","[GE0012]"]
            },
            {
                //"name": "Spain",
                "code": "ESP",
                "defzone":1,
                "zoneCodeList":[0,1*3600,65535],
                "osdList":["WET(UTC+0)","CET(UTC+1)","[GE0012]"]
            },
            {
                //"name": "France",
                "code": "FRA",
                "defzone":0,
                "zoneCodeList":[1*3600,65535],
                "osdList":["CET(UTC+1)","[GE0012]"]
            },
            {
                //"name": "Switzerland",
                "code": "CHE",
                "defzone":0,
                "zoneCodeList":[1*3600,65535],
                "osdList":["CET(UTC+1)","[GE0012]"]
            },
            {
                //"name": "Portuguesa",
                "code": "PRT",
                "defzone":0,
                "zoneCodeList":[0,65535],
                "osdList":["WET(UTC+0)","[GE0012]"]
            },
            {
                //"name": "Sweden",
                "code": "SWE",
                "defzone":0,
                "zoneCodeList":[1*3600,65535],
                "osdList":["CET(UTC+1)","[GE0012]"]
            },
            {
                //"name": "Denmark",
                "code": "DNK",
                "defzone":0,
                "zoneCodeList":[1*3600,65535],
                "osdList":["CET(UTC+1)","[GE0012]"]
            },
            {
                //"name": "Finland",
                "code": "FIN",
                "defzone":0,
                "zoneCodeList":[2*3600,65535],
                "osdList":["UTC+2","[GE0012]"]
            },
            {
                //"name": "Norway",
                "code": "NOR",
                "defzone":0,
                "zoneCodeList":[1*3600,65535],
                "osdList":["CET(UTC+1)","[GE0012]"]
            },
            {
                //"name": "Turkish",
                "code": "TUR",
                "defzone":0,
                "zoneCodeList":[2*3600,65535],
                "osdList":["UTC+2","[GE0012]"]
            },
            {
                //"name": "Czech",
                "code": "CZE",
                "defzone":0,
                "zoneCodeList":[2*3600,65535],
                "osdList":["CET(UTC+1)","[GE0012]"]
            },
            {
                //"name": "Slovakia",
                "code": "SVK",
                "defzone":0,
                "zoneCodeList":[1*3600,65535],
                "osdList":["CET(UTC+1)","[GE0012]"]
            },
            {
                //"name": "Poland",
                "code": "POL",
                "defzone":0,
                "zoneCodeList":[1*3600,65535],
                "osdList":["CET(UTC+1)","[GE0012]"]
            },
            {
                //"name": "Hungary",
                "code": "HUN",
                "defzone":0,
                "zoneCodeList":[1*3600,65535],
                "osdList":["CET(UTC+1)","[GE0012]"]
            },
            {
                //"name": "Bulgaria",
                "code": "BGR",
                "defzone":0,
                "zoneCodeList":[2*3600,65535],
                "osdList":["UTC+2","[GE0012]"]
            },
            {
                //"name": "Russia",//俄罗斯
                "code": "RUS",
                "defzone":2,
                "zoneCodeList":[2*3600,3*3600,4*3600,5*3600,6*3600,7*3600,8*3600,9*3600,10*3600,11*3600,12*3600,65535],
//                "osdList":["Kaliningrad Time(UTC+2)","Moscow Time(UTC+3)","Samara Time(UTC+4)","Yekaterinburg Time(UTC+5)","Omsk Time(UTC+6)",
//                    "Krasnoyarsk Time(UTC+7)","Irkutsk Time (UTC+8)","Yakutsk Time (UTC+9)","Vladivostok Time (UTC+10)","Srednekolymsk Time (UTC+11)","Kamchatka Time (UTC+12)","[GE0012]"]
                "osdList":["[FTE0074]","[FTE0075]","[FTE0076]","[FTE0077]","[FTE0078]",
                    "[FTE0079]","[FTE0080]","[FTE0081]","[FTE0082]","[FTE0083]","[FTE0084]","[GE0012]"]
            },
            {
                //"name": "Uzbekistan",//乌兹别克斯坦(Hisense)
                "code": "UZB",
                "defzone":0,
                "zoneCodeList":[5*3600,65535],
                "osdList":["UTC+5","[GE0012]"]
            },
            {
                // "name": "Kyrgyz",//吉尔吉斯斯坦(Hisense)
                "code": "KGZ",
                "defzone":0,
                "zoneCodeList":[ 6*3600,65535],
                "osdList":["UTC+6","[GE0012]"]
            },
            {
                //"name": "Tajikistan",// 塔吉克斯坦(Hisense)
                "code": "TJK",
                "defzone":0,
                "zoneCodeList":[5*3600,65535],
                "osdList":["UTC+5","[GE0012]"]
            } ,
            {
                // "name": "Croatia",// 克罗地亚(Hisense)
                "code":"HRV",
                "defzone":0,
                "zoneCodeList":[1*3600,65535],
                "osdList":["CET(UTC+1)","[GE0012]"]
            },
            {
                // "name": "Algeria", //阿尔及利亚
                "code": "DZA",
                "defzone":0,
                "zoneCodeList":[1*3600,65535],
                "osdList":["(UTC+1)","[GE0012]"]
            },
            {
                //"name": "Iraq", //伊拉克
                "code": "IRQ",
                "defzone":0,
                "zoneCodeList":[3*3600,65535],
                "osdList":["UTC+3","[GE0012]"]
            },
            {
                //"name": "Saudi Arabia", //沙特阿拉伯
                "code": "SAU",
                "defzone":0,
                "zoneCodeList":[3*3600,65535],
                "osdList":["UTC+3","[GE0012]"]
            },
            {
                // "name": "Latvia",// 拉脱维亚(Hisense)
                "code": "LVA",
                "defzone":0,
                "zoneCodeList":[2*3600,65535],
                "osdList":["UTC+2","[GE0012]"]
            },
            {
                // "name": "Estonia",// 爱沙尼亚(Hisense)
                "code": "EST",
                "defzone":0,
                "zoneCodeList":[2*3600,65535],
                "osdList":["UTC+2","[GE0012]"]
            },
            {
                // "name": "Lithuania",// 立陶宛(Hisense)
                "code": "LTU",
                "defzone":0,
                "zoneCodeList":[2*3600,65535],
                "osdList":["UTC+2","[GE0012]"]
            }
        ]
        //["Germany", "Austria", "Italy", "England", "Spain", "France", "Switzerland", "Portuguesa",
        // "Sweden", "Denmark", "Finland", "Norway", "Turkish", "Czech", "Slovakia", "Poland", "Hungary", "Bulgaria"]
    }
    else if(verArea=="COL")
    {
        countryMapList = [
            {
                //"name": "Colombia",
                "code": "COL",
                "defzone":0,
                "zoneCodeList":[-5*3600],
                "osdList":["UTC-5"]
            }
        ]
    }
    else  //if(verArea=="EM")
    {
        if(CurrentSubArea==SubAreaIndex.MiddleEast)
        {
            countryMapList = [
                {
                    //"name": "Egypt", //埃及
                    "code": "EGY",
                    "defzone":0,
                    "zoneCodeList":[2*3600,65535],
                    "osdList":["UTC+2","[GE0012]"]
                },
                {
                    // "name": "Algeria", //阿尔及利亚
                    "code": "DZA",
                    "defzone":0,
                    "zoneCodeList":[1*3600,65535],
                    "osdList":["UTC+1","[GE0012]"]
                },
                {
                    //"name": "Iran", //伊朗
                    "code": "IRN",
                    "defzone":0,
                    "zoneCodeList":[3.5*3600,65535],
                    "osdList":["UTC+3.5","[GE0012]"]
                },
                {
                    //"name": "Iraq", //伊拉克
                    "code": "IRQ",
                    "defzone":0,
                    "zoneCodeList":[3*3600,65535],
                    "osdList":["UTC+3","[GE0012]"]
                },
                {
                    //"name": "Saudi Arabia", //沙特阿拉伯
                    "code": "SAU",
                    "defzone":0,
                    "zoneCodeList":[3*3600,65535],
                    "osdList":["UTC+3","[GE0012]"]
                },
                {
                    // "name": "United Arab Emirates", //阿联酋
                    "code": "ARE",
                    "defzone":0,
                    "zoneCodeList":[4*3600,65535],
                    "osdList":["UTC+4","[GE0012]"]
                },
                {
                    //"name": "Kuwait", //科威特
                    "code": "KWT",
                    "defzone":0,
                    "zoneCodeList":[3*3600,65535],
                    "osdList":["UTC+3","[GE0012]"]
                },
                {
                    //"name": "Yemen", //也门
                    "code": "YEM",
                    "defzone":0,
                    "zoneCodeList":[3*3600,65535],
                    "osdList":["UTC+3","[GE0012]"]
                },
                {
                    // "name": "Oman", //阿曼
                    "code": "OMN",
                    "defzone":0,
                    "zoneCodeList":[4*3600,65535],
                    "osdList":["UTC+4","[GE0012]"]
                },
                {
                    //"name": "Qatar", //卡塔尔
                    "code": "QAT",
                    "defzone":0,
                    "zoneCodeList":[3*3600,65535],
                    "osdList":["UTC+3","[GE0012]"]
                },
                {
                    //"name": "Jordan", //约旦
                    "code": "JOR",
                    "defzone":0,
                    "zoneCodeList":[2*3600,65535],
                    "osdList":["UTC+2","[GE0012]"]
                },
                {
                    //"name": "Dubai", //迪拜
                    "code": "DXB",
                    "defzone":0,
                    "zoneCodeList":[4*3600,65535],
                    "osdList":["UTC+4","[GE0012]"]
                },
                {
                    //"name": "Palestine", //巴勒斯坦
                    "code": "PSE",
                    "defzone":0,
                    "zoneCodeList":[5*3600,65535],
                    "osdList":["UTC+5","[GE0012]"]
                }
                ,
                {
                    //"name": "Bahrain", //巴林
                    "code": "BHR",
                    "defzone":0,
                    "zoneCodeList":[3*3600,65535],
                    "osdList":["UTC+3","[GE0012]"]
                },
                {
                    //"name": "Lebanon", //黎巴嫩
                    "code": "LBN",
                    "defzone":0,
                    "zoneCodeList":[3*3600,65535],
                    "osdList":["UTC+3","[GE0012]"]
                },
                {
                    //"name": "Syria", //叙利亚
                    "code": "SYR",
                    "defzone":0,
                    "zoneCodeList":[2*3600,65535],
                    "osdList":["UTC+2","[GE0012]"]
                }
            ]
        }
        else if(CurrentSubArea==SubAreaIndex.CIS)
        {
            countryMapList = [
                {
                    //"name": "Israel", //以色列
                    "code": "ISR",
                    "defzone":0,
                    "zoneCodeList":[2*360,65535],
                    "osdList":["UTC+2","[GE0012]"]
                },
                {
                    //"name": "Russia",//俄罗斯
                    "code": "RUS",
                    "defzone":2,
                    "zoneCodeList":[2*3600,3*3600,4*3600,5*3600,6*3600,7*3600,8*3600,9*3600,10*3600,11*3600,12*3600,65535],
//                    "osdList":["Kaliningrad Time(UTC+2)","Moscow Time(UTC+3)","Samara Time(UTC+4)","Yekaterinburg Time(UTC+5)","Omsk Time(UTC+6)",
//                        "Krasnoyarsk Time(UTC+7)","Irkutsk Time (UTC+8)","Yakutsk Time (UTC+9)","Vladivostok Time (UTC+10)","Srednekolymsk Time (UTC+11)","Kamchatka Time (UTC+12)","[GE0012]"]
                    "osdList":["[FTE0074]","[FTE0075]","[FTE0076]","[FTE0077]","[FTE0078]",
                        "[FTE0079]","[FTE0080]","[FTE0081]","[FTE0082]","[FTE0083]","[FTE0084]","[GE0012]"]
                },
                {
                    //"name": "Uzbekistan",//乌兹别克斯坦(Hisense)
                    "code": "UZB",
                    "defzone":0,
                    "zoneCodeList":[7,35],
                    "osdList":["UTC+5","[GE0012]"]
                },
                {
                    // "name": "Kyrgyz",//吉尔吉斯斯坦(Hisense)
                    "code": "KGZ",
                    "defzone":0,
                    "zoneCodeList":[10,35],
                    "osdList":["UTC+6","[GE0012]"]
                },
                {
                    //"name": "Turkmenistan",//土库曼斯坦(Hisense)
                    "code": "TKM",
                    "defzone":0,
                    "zoneCodeList":[7,35],
                    "osdList":["UTC+5","[GE0012]"]
                },
                {
                    "code": "KAZ",
                    "defzone":0,
                    "zoneCodeList":[6*3600,65535],
                    "osdList":["UTC+6","[GE0012]"]
                },
                {
                    //"name": "Ukraine",//乌克兰(Hisense)
                    "code": "UKR",
                    "defzone":0,
                    "zoneCodeList":[2*3600,65535],
                    "osdList":["UTC+2","[GE0012]"]
                },
                {
                    // "name": "Azerbaijan",//阿塞拜疆(Hisense)
                    "code": "AZE",
                    "defzone":0,
                    "zoneCodeList":[4*3600,65535],
                    "osdList":["UTC+4","[GE0012]"]
                },
                {
                    //"name": "Georgia",//格鲁吉亚(Hisense)
                    "code": "GEO",
                    "defzone":0,
                    "zoneCodeList":[4*3600,65535],
                    "osdList":["UTC+4","[GE0012]"]
                },
                {
                    //"name": "Armenia",// 亚美尼亚(Hisense)
                    "code": "ARM",
                    "defzone":0,
                    "zoneCodeList":[4*3600,65535],
                    "osdList":["UTC+4","[GE0012]"]
                },
                {
                    //"name": "Serbia",// 塞尔维亚(Hisense)
                    "code": "SRB",
                    "defzone":0,
                    "zoneCodeList":[1*3600,65535],
                    "osdList":["UTC+1","[GE0012]"]
                },
                {
                    //"name": "Tajikistan",// 塔吉克斯坦(Hisense)
                    "code": "TJK",
                    "defzone":0,
                    "zoneCodeList":[5*3600,65535],
                    "osdList":["UTC+5","[GE0012]"]
                },
                {
                    //"name": "Belarus",// 白俄罗斯(Hisense)
                    "code": "BLR",
                    "defzone":0,
                    "zoneCodeList":[2*3600,65535],
                    "osdList":["UTC+2","[GE0012]"]
                },
                {
                    //"name": "Moldova",// 摩尔多瓦(Hisense)
                    "code": "MDA",
                    "defzone":0,
                    "zoneCodeList":[2*3600,65535],
                    "osdList":["UTC+2","[GE0012]"]
                }
            ]
        }
        else if(CurrentSubArea==SubAreaIndex.ASIAN)
        {
            countryMapList = [
                {
                    //"name": "Taiwan",//台湾（OEM)
                    "code": "TWN",
                    "defzone":0,
                    "zoneCodeList":[8*3600,65535],
                    "osdList":["UTC+8","[GE0012]"]
                },
                {
                    //"name": "Australia",//澳大利亚（OEM)
                    "code": "AUS",
                    "defzone":0,
                    "zoneCodeList":[10*3600,10*3600,10*3600,8*3600,9.5*3600,9.5*3600,10*3600,10*3600,65535],
                    "osdList":["VIC","QLD","TAS","WA","SA","NT","NSW","ACT","[GE0012]"]
                },
                {
                    //"name": "Thailand",//泰国（OEM)
                    "code": "THA",
                    "defzone":0,
                    "zoneCodeList":[7*3600,65535],
                    "osdList":["UTC+7","[GE0012]"]
                },
                {
                    //"name": "Vietnam",// 越南
                    "code": "VNM",
                    "defzone":0,
                    "zoneCodeList":[5*3600,65535],
                    "osdList":["UTC+5","[GE0012]"]
                },
                {
                    //"name": "Myanmar",//缅甸
                    "code": "MMR",
                    "defzone":0,
                    "zoneCodeList":[6.5*3600,65535],
                    "osdList":["UTC+6.5","[GE0012]"]
                },
                {
                    //"name": "Malaysia",//马来西亚
                    "code": "MYS",
                    "defzone":0,
                    "zoneCodeList":[8*3600,65535],
                    "osdList":["UTC+8","[GE0012]"]
                    //"MYS"
                },
                {
                    //"name": "India",//印度
                    "code": "IND",
                    "defzone":0,
                    "zoneCodeList":[5.5*3600,65535],
                    "osdList":["UTC+5.5","[GE0012]"]
                },
                {
                    // "name": "Indonesia",//印度尼西亚
                    "code": "IDN",
                    "defzone":0,
                    "zoneCodeList":[7*3600,65535],
                    "osdList":["UTC+7","[GE0012]"]
                },
                {
                    //"name": "Sri Lanka",//斯里兰卡
                    "code": "LKA",
                    "defzone":0,
                    "zoneCodeList":[5.5*3600,65535],
                    "osdList":["UTC+5.5","[GE0012]"]
                },
                {
                    //"name": "Maldives",//马尔代夫
                    "code": "MDV",
                    "defzone":0,
                    "zoneCodeList":[5*3600,65535],
                    "osdList":["UTC+5","[GE0012]"]
                },
                {
                    //"name": "Fiji",///斐济
                    "code": "FJI",
                    "defzone":0,
                    "zoneCodeList":[12*3600,65535],
                    "osdList":["UTC+12","[GE0012]"]
                },
                {
                    //"name": "Bengal",//孟加拉
                    "code": "BGD",
                    "defzone":0,
                    "zoneCodeList":[6*3600,65535],
                    "osdList":["UTC+6","[GE0012]"]
                },
                // 巴基斯坦
                {
                    //"name": "Pakistan",
                    "code": "PAK",
                    "defzone":0,
                    "zoneCodeList":[5*3600,65535],
                    "osdList":["UTC+5","[GE0012]"]
                },
                //  尼泊尔
                {
                    //"name": "Nepal",
                    "code": "NPL",
                    "defzone":0,
                    "zoneCodeList":[5.75*3600,65535],
                    "osdList":["UTC+5.75","[GE0012]"]
                },
                //  柬埔寨
                {
                    //"name": "Cambodia",
                    "code": "KHM",
                    "defzone":0,
                    "zoneCodeList":[7*3600,65535],
                    "osdList":["UTC+7","[GE0012]"]
                },
                {
                    //"name": "Mongolia",//蒙古
                    "code": "MNG",
                    "defzone":0,
                    "zoneCodeList":[8*3600,65535],
                    "osdList":["UTC+8","[GE0012]"]
                },
                {
                    //"name": "Other",//其他
                    "code": "ZZZ",
                    "defzone":13,
                    // "zoneCodeList":[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35],
                    "zoneCodeList":[0,1*3600,2*3600,3*3600,3.5*3600,4*3600,4.5*3600,5*3600,5.5*3600,5.75*3600,
                        6*3600,6.5*3600,7*3600,8*3600,9*3600,9.5*3600,10*3600,11*3600,12*3600,12.75*3600,
                        13*3600,-12*3600,-11*3600,-10*3600,-9*3600,-8*3600,-7*3600,-6*3600,-5*3600,-4.5*3600,
                        -4*3600,-3.5*3600,-3*3600,-2*3600,-1*3600,65535],
                    "osdList":["UTC+0","UTC+1","UTC+2","UTC+3","UTC+3.5","UTC+4","UTC+4.5","UTC+5","UTC+5.5","UTC+5.75","UTC+6","UTC+6.5",
                        "UTC+7","UTC+8","UTC+9","UTC+9.5","UTC+10","UTC+11","UTC+12","UTC+12.75","UTC+13","UTC-12","UTC-11","UTC-10","UTC-9",
                        "UTC-8","UTC-7","UTC-6","UTC-5","UTC-4.5","UTC-4","UTC-3.5","UTC-3","UTC-2","UTC-1","[GE0012]"]
                }
            ]
        }
        else
        {
            countryMapList = [
                {
                    //"name": "South Africa",//南非
                    "code": "ZAF",
                    "defzone":0,
                    "zoneCodeList":[2*3600,65535],
                    "osdList":["UTC+2","[GE0012]"]
                },
                {
                    //"name": "Morocco",//摩洛哥(Hisense)
                    "code": "MAR",
                    "defzone":0,
                    "zoneCodeList":[0,65535],
                    "osdList":["UTC+0","[GE0012]"]
                },
                {
                    //"name": "Nigeria",//尼日利亚(Hisense)
                    "code": "NGA",
                    "defzone":0,
                    "zoneCodeList":[3600,65535],
                    "osdList":["UTC+1","[GE0012]"]
                },
                {
                    // "name": "Libya",//利比亚(Hisense)
                    "code": "LBY",
                    "defzone":0,
                    "zoneCodeList":[2*3600,65535],
                    "osdList":["UTC+2","[GE0012]"]
                },
                {
                    //"name": "Tunisia",//突尼斯
                    "code": "TUN",
                    "defzone":0,
                    "zoneCodeList":[1*3600,65535],
                    "osdList":["UTC+1","[GE0012]"]
                },
                {
                    //"name": "Ghana",//加纳(Hisense+OEM)
                    "code": "GHA",
                    "defzone":0,
                    "zoneCodeList":[0,65535],
                    "osdList":["UTC+0","[GE0012]"]
                },
                {
                    //"name": "Sierra Leone",//塞拉利昂(Hisense)
                    "code": "SLE",
                    "defzone":0,
                    "zoneCodeList":[0,65535],
                    "osdList":["UTC+0","[GE0012]"]
                },
                {
                    // "name": "Cote d'Ivoire",// 科特迪瓦(Hisense+OEM)
                    "code": "CIV",
                    "defzone":0,
                    "zoneCodeList":[0,65535],
                    "osdList":["UTC+0","[GE0012]"]
                },
                {
                    //"name": "Angola",// 安哥拉(Hisense+OEM)
                    "code": "AGO",
                    "defzone":0,
                    "zoneCodeList":[1*3600,65535],
                    "osdList":["UTC+1","[GE0012]"]
                }
                ,
                {
                    //"name": "Benin",// 贝宁(Hisense)
                    "code": "BEN",
                    "defzone":0,
                    "zoneCodeList":[1*3600,65535],
                    "osdList":["UTC+1","[GE0012]"]
                },
                {
                    //"name": "Republic of Liberia",// 利比里亚(Hisense)
                    "code": "LBR",
                    "defzone":0,
                    "zoneCodeList":[0,65535],
                    "osdList":["UTC+0","[GE0012]"]
                },
                {
                    //"name": "Guinea",// 几内亚(Hisense)
                    "code": "GIN",
                    "defzone":0,
                    "zoneCodeList":[0,65535],
                    "osdList":["UTC+0","[GE0012]"]
                },
                {
                    //"name": "Senegal",// 塞内加尔(Hisense)
                    "code": "SEN",
                    "defzone":0,
                    "zoneCodeList":[0,65535],
                    "osdList":["UTC+0","[GE0012]"]
                },
                {
                    //"name": "Congo-Kinshasa",//  刚果（金）(Hisense+OEM)
                    "code": "COD",
                    "defzone":0,
                    "zoneCodeList":[1*3600,65535],
                    "osdList":["UTC+1","[GE0012]"]
                },
                {
                    //"name": "Cameroon",//喀麦隆(Hisense+OEM)
                    "code": "CMR",
                    "defzone":0,
                    "zoneCodeList":[1*3600,65535],
                    "osdList":["UTC+1","[GE0012]"]
                },
                {
                    //"name": "Zimbabwe",// 津巴布韦(Hisense)
                    "code": "ZWE",
                    "defzone":0,
                    "zoneCodeList":[2*3600,65535],
                    "osdList":["UTC+2","[GE0012]"]
                },
                {
                    //"name": "Congo-Brazzaville",// 刚果布(Hisense)
                    "code": "COG",
                    "defzone":0,
                    "zoneCodeList":[1*3600,65535],
                    "osdList":["UTC+1","[GE0012]"]
                },
                {
                    // "name": "Burundi",// 布隆迪(Hisense)
                    "code": "BDI",
                    "defzone":0,
                    "zoneCodeList":[2*3600,65535],
                    "osdList":["UTC+2","[GE0012]"]
                },
                {
                    //"name": "Somalia",// 索马里(Hisense)
                    "code": "SOM",
                    "defzone":0,
                    "zoneCodeList":[3*3600,65535],
                    "osdList":["UTC+3","[GE0012]"]
                },
                {
                    //"name": "Uganda",//乌干达(Hisense)
                    "code": "UGA",
                    "defzone":0,
                    "zoneCodeList":[3*3600,65535],
                    "osdList":["UTC+3","[GE0012]"]
                },
                {
                    // "name": "Tanzania",//坦桑尼亚(Hisense)
                    "code": "TZA",
                    "defzone":0,
                    "zoneCodeList":[3*3600,65535],
                    "osdList":["UTC+3","[GE0012]"]
                },
                {
                    //"name": "Mauritius",//  毛里求斯(Hisense)
                    "code": "MUS",
                    "defzone":0,
                    "zoneCodeList":[4*3600,65535],
                    "osdList":["UTC+4","[GE0012]"]
                },
                {
                    //"name": "Sudan",//苏丹(Hisense)
                    "code": "SDN",
                    "defzone":0,
                    "zoneCodeList":[3*3600,65535],
                    "osdList":["UTC+3","[GE0012]"]
                },
                {
                    //"name": "Djibouti",//吉布提(Hisense)
                    "code": "DJI",
                    "defzone":0,
                    "zoneCodeList":[3*3600,65535],
                    "osdList":["UTC+3","[GE0012]"]
                },
                {
                    //"name": "Ethiopia",// 埃塞俄比亚(Hisense)
                    "code": "ETH",
                    "defzone":0,
                    "zoneCodeList":[3*3600,65535],
                    "osdList":["UTC+3","[GE0012]"]
                },
                {
                    // "name": "Kenya",// 肯尼亚(Hisense+OEM)
                    "code": "KEN",
                    "defzone":0,
                    "zoneCodeList":[3*3600,65535],
                    "osdList":["UTC+3","[GE0012]"]
                },
                {
                    //"name": "Mozambique",// 莫桑比克(Hisense)
                    "code": "MOZ",
                    "defzone":0,
                    "zoneCodeList":[2*3600,65535],
                    "osdList":["UTC+2","[GE0012]"]
                },
                {
                    //"name": "Madagascar",// 马达加斯加(Hisense)
                    "code": "MDG",
                    "defzone":0,
                    "zoneCodeList":[3*3600,65535],
                    "osdList":["UTC+3","[GE0012]"]
                }
            ]
        }
    }
    return countryMapList;
}
function GetSysCountryList(verArea, CurrentSubArea) {
    var countryMapList = [];
    if (verArea == "SA") {
        countryMapList = [
            {


                "name": "Argentina",
                "code": "ARG"
            },
            {
                "name": "Bolivia",//玻利维亚
                "code": "BOL"
            },
            {

                "name": "Brazil",
                "code": "BRA"
            },
            {
                "name": "Chile",//智利
                "code": "CHL"
            },
            {

                "name": "Colombia",
                "code": "COL"
            },
            {

                "name": "Costa Rica",//哥斯达黎加
                "code": "CRI"
            },
            {

                "name": "Ecuador",
                "code": "ECU"
            },
            {

                "name": "Paraguay",//巴拉圭
                "code": "PRY"
            },
            {

                "name": "Peru",
                "code": "PER"
            },
            {

                "name": "Philippines",
                "code": "PHL"
            },
            {

                "name": "Uruguay",
                "code": "URY"
            }
        ];

    }
    else if (verArea == "COL") {
        countryMapList = [{

            "name": "Colombia",
            "code": "COL"
        }]
    }
    else if (verArea == "NA") {
        countryMapList = [
            {
                "number": 80,
                "name":"[SE0642]",// "USA",
                "code": "USA"
            },
            {
                "number": 81,
                "name": "[SE0643]",//"Canada",
                "code": "CAN"
            },
            {
                "number": 82,
                "name": "[SE0644]",//"Mexico",
                "code": "MEX"
            },
            {
                "number": 97,
                "name": "[SE0899]",//"Panama",
                "code": "PAN"
            },
            {
                "number": 94,
                "name": "[SE2657]",//"Costa Rica",哥斯达黎加
                "code": "CRI"
            }
            ,
            {
                "number": 83,
                "name": "[OT0288]",//"Nicaragua",尼加拉瓜
                "code": "NIC"
            },
            {
                "number": 84,
                "name": "[OT0289]",//"Honduras"//洪都拉斯
                "code": "HND"
            },
            {
                "number": 85,
                "name": "[OT0290]",//"El Salvador",萨尔瓦多
                "code": "SLV"
            },
            {
                "number": 86,
                "name": "[OT0291]",//"Guatemala",危地马拉
                "code": "GTM"
            },
            {
                "number": 87,
                "name": "[OT0292]",//"Dominican Republic",多米尼加
                "code": "DMA"
            },

            {
                "number": 96,
                "name": "[OT0293]",//"Cuba",古巴
                "code": "CUB"
            },
            {
                "number": 88,
                "name": "[OT0294]",//"Trinidad",特立尼达
                "code": "TTO"
            },
            {
                "number": 89,
                "name": "[OT0295]",//"Jamaica",
                "code": "JAM"
            },
            {
                "number": 90,
                "name": "[OT0296]",//"Curacao",库拉索
                "code": "CUW"
            },
            {
                "number": 91,
                "name": "[OT0297]",//"Barbados",巴巴多斯
                "code": "BRB"
            },
            {
                "number": 92,
                "name": "[OT0298]",//"St. Maarten",圣马丁
                "code": "MAF"
            },
            {
                "number": 93,
                "name": "[OT0299]",//"Puerto Rico",波多黎各
                "code": "PRI"
            }
        ]
    }
    else if (verArea == "EU") {
        countryMapList = [
            {
                "name": "Germany",
                "code": "DEU"
            },
            {

                "name": "Austria",
                "code": "AUT"
            },
            {

                "name": "Italy",
                "code": "ITA"
            },
            {

                "name": "UK",
                "code": "GBR"
            },
            {

                "name": "Spain",
                "code": "ESP"
            },
            {

                "name": "France",
                "code": "FRA"
            },
            {

                "name": "Switzerland",
                "code": "CHE"
            },
            {

                "name": "Portugal",
                "code": "PRT"
            },
            {

                "name": "Sweden",
                "code": "SWE"
            },
            {

                "name": "Denmark",
                "code": "DNK"
            },
            {

                "name": "Finland",
                "code": "FIN"
            },
            {

                "name": "Norway",
                "code": "NOR"
            },
            {

                "name": "Turkey",
                "code": "TUR"
            },
            {

                "name": "Czech Republic",
                "code": "CZE"
            },
            {

                "name": "Slovakia",
                "code": "SVK"
            },
            {

                "name": "Poland",
                "code": "POL"
            },
            {

                "name": "Hungary",
                "code": "HUN"
            },
            {

                "name": "Bulgaria",
                "code": "BGR"
            },
            {
                "name": "Russia_EU",//俄罗斯
                "code": "RUS"
            },
            {
                "name": "Uzbekistan_EU",//乌兹别克斯坦(Hisense)
                "code": "UZB"
            },
            {
                "name": "Kirghizstan_EU",//吉尔吉斯斯坦(Hisense)
                "code": "KGZ"
            },
            {
                "name": "Tajikistan_EU",// 塔吉克斯坦(Hisense)
                "code": "TJK"
            }
        ]
        //["Germany", "Austria", "Italy", "England", "Spain", "France", "Switzerland", "Portuguesa",
        // "Sweden", "Denmark", "Finland", "Norway", "Turkish", "Czech", "Slovakia", "Poland", "Hungary", "Bulgaria"]

    }
    else  //if(verArea=="EM")
    {
        if (CurrentSubArea == "MiddleEast" || CurrentSubArea == 0) {
            countryMapList = [
                {
                    "name": "Egypt", //埃及
                    "code": "EGY"
                },
                {
                    "name": "Algeria", //阿尔及利亚
                    "code": "DZA"
                },
                {
                    "name": "Iran", //伊朗
                    "code": "IRN"
                },
                {
                    "name": "Iraq", //伊拉克
                    "code": "IRQ"
                },
                {
                    "name": "Saudi Arabia", //沙特阿拉伯
                    "code": "SAU"
                },
                {
                    "name": "UAE", //阿联酋
                    "code": "ARE"
                },
                {
                    "name": "Kuwait", //科威特
                    "code": "KWT"
                },
                {
                    "name": "Yemen", //也门
                    "code": "YEM"
                },
                {
                    "name": "Oman", //阿曼
                    "code": "OMN"
                },
                {
                    "name": "Qatar", //卡塔尔
                    "code": "QAT"
                },
                {
                    "name": "Jordan", //约旦
                    "code": "JOR"
                },
                {
                    "name": "Dubai", //迪拜
                    "code": "DXB"
                }
                ,
                {
                    "name": "Palestine", //巴勒斯坦
                    "code": "PSE"
                }
                ,
                {
                    "name": "Bahrain", //巴林
                    "code": "BHR"
                },
                {
                    "name": "Lebanon", //黎巴嫩
                    "code": "LBN"
                },
                {
                    "name": "Syria", //叙利亚
                    "code": "SYR"
                }
            ]
        }
        else if (CurrentSubArea == "CIS" || CurrentSubArea == 1) {
            countryMapList = [
                {
                    "name": "Israel", //以色列
                    "code": "ISR"
                },
                {
                    "name": "Russia",//俄罗斯
                    "code": "RUS"
                },
                {
                    "name": "Uzbekistan",//乌兹别克斯坦(Hisense)
                    "code": "UZB"
                },
                {
                    "name": "Kirghizstan",//吉尔吉斯斯坦(Hisense)
                    "code": "KGZ"
                },
                {
                    "name": "Turkmenistan",//土库曼斯坦(Hisense)
                    "code": "TKM"
                },
                {
                    "name": "Kazakhstan",//哈萨克斯坦(Hisense)
                    "code": "KAZ"
                },
                {
                    "name": "Ukraine",//乌克兰(Hisense)
                    "code": "UKR"
                },
                {
                    "name": "Azerbaijan",//阿塞拜疆(Hisense)
                    "code": "AZE"
                },
                {
                    "name": "Georgia",//格鲁吉亚(Hisense)
                    "code": "GEO"
                },
                {
                    "name": "Armenia",// 亚美尼亚(Hisense)
                    "code": "ARM"
                },
                {
                    "name": "Serbia",// 塞尔维亚(Hisense)
                    "code": "SRB"
                },
                {
                    "name": "Tajikistan",// 塔吉克斯坦(Hisense)
                    "code": "TJK"
                },
                {
                    "name": "Belarus",// 白俄罗斯(Hisense)
                    "code": "BLR"
                },
                {
                    "name": "Moldova",// 摩尔多瓦(Hisense)
                    "code": "MDA"
                }

            ]
        }
        else if (CurrentSubArea == "Asian" || CurrentSubArea == 2) {
            countryMapList = [
                {

                    "name": "Taiwan",//台湾（OEM)
                    "code": "TWN"
                },
                {

                    "name": "Australia",//澳大利亚（OEM)
                    "code": "AUS"
                },
                {

                    "name": "Thailand",//泰国（OEM)
                    "code": "THA"
                },
                {

                    "name": "Vietnam",// 越南
                    "code": "VNM"
                },
                {

                    "name": "Myanmar",//缅甸
                    "code": "MMR"
                },
                {

                    "name": "Malaysia",//马来西亚
                    "code": 'MYS'
                    //"MYS"
                },
                {
                    "name": "India",//印度
                    "code": "IND"
                },
                {
                    "name": "Indonesia",//印度尼西亚
                    "code": "IDN"
                },
                {
                    "name": "Sri Lanka",//斯里兰卡
                    "code": "LKA"
                },
                {
                    "name": "Maldives", //马尔代夫
                    "code": "MDV"
                },
                {
                    "name": "Fiji",//斐济
                    "code": "FJI"
                }
                ,
                {
                    "name": "Bengal",//孟加拉
                    "code": "BGD"
                },
                // 巴基斯坦
                {
                    "name": "Pakistan",
                    "code": "PAK"
                },
                //  尼泊尔
                {
                    "name": "Nepal",
                    "code": "NPL"
                },
                //  柬埔寨
                {
                    "name": "Cambodia",
                    "code": "KHM"
                },
                {
                    "name": "Mongolia",//蒙古
                    "code": "MNG"
                },
                {
                    "name": "Others",//其他
                    "code": "ZZZ"
                }
            ]
        }
        else {
            countryMapList = [
                {

                    "name": "South Africa",//南非
                    "code": "ZAF"
                },
                {

                    "name": "Morocco",//摩洛哥(Hisense)
                    "code": "MAR"
                },
                {

                    "name": "Nigeria",//尼日利亚(Hisense)
                    "code": "NGA"
                },
                {

                    "name": "Libya",//利比亚(Hisense)
                    "code": "LBY"
                },
                {
                    "name": "Tunisia",//突尼斯
                    "code": "TUN"
                },
                {

                    "name": "Ghana",//加纳(Hisense+OEM)
                    "code": "GHA"
                },
                {

                    "name": "Sierra Leone",//塞拉利昂(Hisense)
                    "code": "SLE"
                },
                {

                    "name": "Cote d'Ivoire",// 科特迪瓦(Hisense+OEM)
                    "code": "CIV"
                },
                {

                    "name": "Angola",// 安哥拉(Hisense+OEM)
                    "code": "AGO"
                }
                ,
                {

                    "name": "Benin",// 贝宁(Hisense)
                    "code": "BEN"
                },
                {

                    "name": "Liberia",// 利比里亚(Hisense)
                    "code": "LBR"
                },
                {

                    "name": "Guinea",// 几内亚(Hisense)
                    "code": "GIN"
                },
                {
                    "name": "Senegal",// 塞内加尔(Hisense)
                    "code": "SEN"
                },
                {
                    "name": "Congo (DRC)",//  刚果（金）(Hisense+OEM)
                    "code": "COD"
                },
                {

                    "name": "Cameroon",//喀麦隆(Hisense+OEM)
                    "code": "CMR"
                },
                {

                    "name": "Zimbabwe",// 津巴布韦(Hisense)
                    "code": "ZWE"
                },
                {

                    "name": "Congo-Brazzaville",// 刚果布(Hisense)
                    "code": "COG"
                },
                {
                    "name": "Burundi",// 布隆迪(Hisense)
                    "code": "BDI"
                },
                {
                    "name": "Somalia",// 索马里(Hisense)
                    "code": "SOM"
                },
                {

                    "name": "Uganda",//乌干达(Hisense)
                    "code": "UGA"
                },
                {

                    "name": "Tanzania",//坦桑尼亚(Hisense)
                    "code": "TZA"
                },
                {

                    "name": "Mauritius",//  毛里求斯(Hisense)
                    "code": "MUS"
                },
                {

                    "name": "Sudan",//苏丹(Hisense)
                    "code": "SDN"
                },
                {

                    "name": "Djibouti",//吉布提(Hisense)
                    "code": "DJI"
                },
                {

                    "name": "Ethiopia",// 埃塞俄比亚(Hisense)
                    "code": "ETH"
                },
                {

                    "name": "Kenya",// 肯尼亚(Hisense+OEM)
                    "code": "KEN"
                },
                {

                    "name": "Mozambique",// 莫桑比克(Hisense)
                    "code": "MOZ"
                },
                {

                    "name": "Madagascar",// 马达加斯加(Hisense)
                    "code": "MDG"
                }
            ]
        }
    }
    return countryMapList;
}
function getCurDisclaimerfile(fteCountry) {
    var curBrand = GLOBAL.UI_BRAND;
    var curcountry = (fteCountry == undefined) ? GLOBAL.CURRENT_COUNTRY : fteCountry;
    var fileName = " ";
    var strItem = "";
    DBG_ERROR("current brand " + curBrand);
    //change the eula  the usa and canada has alexa and the acr
    if (curcountry == "USA") {
        if (curBrand == 'shp') {
            fileName = "Disclaimer_shp_usa_eng.html";
        }
        else {
            fileName = "Disclaimer_his_usa_eng.html";
        }
    }
    else if (curcountry == "CAN") {
        fileName = "Disclaimer_" + curBrand + "_" + curcountry.toLowerCase() + "_" + GLOBAL.CURRENT_LANGUAGE + ".html";

    }
    else if(curcountry == "MEX"){
        fileName = "Disclaimer_" + curBrand + "_" + curcountry.toLowerCase() + ".html";
    }

    else {
        switch (curBrand) {

            case 'shp':
                fileName = "Disclaimer_us_sharp.html";
                break;
            case 'his':
            case 'hisense':
                fileName = "Disclaimer_us_his.html";
                break;
            default://OEM
                fileName = "Disclaimer_us_oem.html";
                break;
        }

    }
    return fileName;
}
var isNeedtoUpdateNtpTime=false;
function onCurNTPTimeValidChaged(value){
    DBG_ERROR("onCurNTPTimeValidChaged"+value);
    if(value==1){
        if(checkIsNeedPopupAcrTip()){
            openMsgBoxByType(MsgBoxType.ACR_TIP);
        }
        DBG_ERROR("isNeedtoUpdateNtpTime"+isNeedtoUpdateNtpTime);
        if(isNeedtoUpdateNtpTime==true){
            var utctime=model.datetime.getCurLocalTime();
            Hisense.File.write("acrTimeFile",utctime+'' ,1);
            DBG_ERROR("write acrTimeFile"+utctime);
        }
    }
}
function isCurCountryhasACR(){
    return (acrflag&&_getIndex(hasACRCountryList,GLOBAL.CURRENT_COUNTRY)>-1);
}
function checkIsNeedPopupAcrTip(){
    var fileIsValid=false;
    DBG_ERROR("acrflag"+acrflag);
    if(acrflag&&g_acrSwitch.GlobalSwitch == AcrSwitch.ON&&model.system.getUserMode()==0&&!GLOBAL.TTS&&isCurCountryhasACR()){
        fileIsValid=Hisense.File.exists("hisenseUI/hasPopUpAcrDialog", 1);
        DBG_ERROR("fileIsValid"+fileIsValid);
        if(!fileIsValid){
            return true;
        }
        else {
            if(g_acrSwitch.settingSwitch==AcrSwitch.ON){
                var lastpopTime= Hisense.File.read("acrTimeFile" ,1);
            var utctime=model.datetime.getCurLocalTime();
            if(utctime-parseInt(lastpopTime,10)>(365*2)*24*3600){
                stopAcrServer("Setting");
                Hisense.File.delete("hisenseUI/hasPopUpAcrDialog", 1);
                return true;
            }
            else  if(utctime-parseInt(lastpopTime,10)>(365+11*30)*24*3600){
                return true;
            }
            }
        }
    }
    return false;
}
//function checkIsDisclaimerChanged(){
//    try{
//    var brandfile= getCurDisclaimerfile();
//    var ret = readFileFromNative("disclaimer_chg_list.ini", 1);
//    DBG_INFO("read disclaimer_chg_list ret  " + ret + typeof ret);
//    if(null !== ret)
//    {
//        for(var i=0;i<ret.length;i++)
//       {
//         ret[i]=ret[i].replace(/\s+/g,"");
//        if(ret[i].toLowerCase()==brandfile.toLowerCase())
//        {
//           return true;
//        }
//       }
//
//    }
//    return false;
//    }catch (e)
//    {
//        DBG_ERROR(e.message)
//        return false;
//    }
//
//}

function GetSysOSDLanguageMapList(verArea, CurrentSubArea) {
    var langMapList = [];
    if (verArea == "SA") {
        langMapList = [
            {
                "number": 1,
                "name": " English ",
                "code": "eng"
            },
            {
                "number": 4,
                "name": "Español",
                "code": "spa"
            },
            {
                "number": 16,
                "name": "Português",
                "code": "por"
            }];
    }
    else if (verArea == "NA") {
        langMapList = [
            {
                "number": 1,
                "name": " English ",
                "code": "eng"
            },
            {
                "number": 4,
                "name": "Español",
                "code": "spa"
            },
            {
                "number": 2,
                "name": "Français",
                "code": "fre"
            }
        ]
    }
    else if (verArea == "EU") {
        langMapList = [
            {
                "number": 0,
                "name": " English ",
                "code": "eng"
            },
            {
                "number": 1,
                "name": "Français ",
                "code": "fre"
            },
            {
                "number": 16,
                "name": "Deutsch ",
                "code": "ger"
            },
            {
                "number": 17,
                "name": "Italiano ",
                "code": "ita"
            },
            {
                "number": 2,
                "name": "Español ",
                "code": "spa"
            },
            {
                "number": 3,
                "name": "Português ",
                "code": "por"
            },
            {
                "number": 18,
                "name": "Svenska ",
                "code": "swe"
            },
            {
                "number": 19,
                "name": "Dansk ",
                "code": "dan"
            },
            {
                "number": 20,
                "name": "Suomi ",
                "code": "fin"
            },
            {
                "number": 21,
                "name": "Norsk ",
                "code": "nor"
            },
            {
                "number": 22,
                "name": "Čeština ",
                "code": "cze"
            },
            //斯洛伐克语
            {
                "number": 23,
                "name": "Slovenčina ",
                "code": "slk"
            },
            {//波兰语
                "number": 24,
                "name": "Polski ",
                "code": "pol"
            },
            {//匈牙利语
                "number": 25,
                "name": " Magyar ",
                "code": "hun"
            },
            {//保加利亚语
                "number": 26,
                "name": "Български ",
                "code": "bul"
            },
            {//土耳其语
                "number": 27,
                "name": "Türkçe ",
                "code": "tur"
            },
            {
                "number": 6,//
                "name": "中文",
                "code": "chi"
            },
            {
                "number": 5,//俄语Russian
                "name": "Русский ",
                "code": "rus"
            },
            {//乌兹别克语
                "number": 10,
                "name": "O'zbekiston ",
                "code": "uzb"
            }


        ]
    }
    else if (verArea == "COL") {
        langMapList = [
            {
                "number": 0,
                "name": " English ",
                "code": "eng"
            },
            {
                "number": 2,
                "name": "Español ",
                "code": "spa"
            },
            {
                "number": 3,
                "name": "Português ",
                "code": "por"
            }
        ]
    }
    else {
        if (CurrentSubArea == "MiddleEast") {
            langMapList = [
                {
                    "number": 0,
                    "name": " English ",
                    "code": "eng"
                },
                {
                    "number": 1,
                    "name": "Français ",
                    "code": "fre"
                },
                {
                    "number": 2,
                    "name": "Español ",
                    "code": "spa"
                },

                {
                    "number": 3,
                    "name": "Português ",
                    "code": "por"
                },
                {
                    "number": 4,//阿拉伯语 Arabic
                    "name": "العربية",
                    "code": "ara"
                },
                {
                    "number": 5,//俄语Russian
                    "name": "русский ",
                    "code": "rus"
                },
                {
                    "number": 6,//
                    "name": "中文",
                    "code": "chi"
                },
//                {
//                    "number":8,//泰语Thai
//                    "name":"ภาษาไทย",
//                    "code":"tha"
//                },
                {
                    "number": 28,//波斯语Persian
                    "name": "فارسی",
                    "code": "per"
                }

//                 {
//                     "number":11,//印度语Hindi
//                     "name":"हिंदी",
//                     "code":"hin"
//                 }
            ]
        }
        else if (CurrentSubArea == "CIS") {
            langMapList = [
                {
                    "number": 0,
                    "name": " English ",
                    "code": "eng"
                },
                {
                    "number": 1,
                    "name": "Français ",
                    "code": "fre"
                },
                {
                    "number": 2,
                    "name": "Español ",
                    "code": "spa"
                },

                {
                    "number": 3,
                    "name": "Português ",
                    "code": "por"
                },
                {
                    "number": 4,//阿拉伯语 Arabic
                    "name": "العربية",
                    "code": "ara"
                },
                {
                    "number": 5,//俄语Russian
                    "name": "Русский ",
                    "code": "rus"
                },
                {
                    "number": 6,//
                    "name": "中文",
                    "code": "chi"
                },
//
                {
                    "number": 10,//乌兹别克语Uzbek
                    "name": "O'zbekiston‎",
                    "code": "uzb"
                },
                {
                    "number": 28,//波斯语Persian
                    "name": "فارسی",
                    "code": "per"
                },
                {
                    "number": 12,//乌克兰Ukrainian
                    "name": "український",
                    "code": "ukr"
                },
                {
                    "number": 13,//马来Malay
                    "name": "Bahasa Melayu",
                    "code": "mal"
                },
                {
                    "number": 14,//希伯来
                    "name": "עברית",
                    "code": "hbr"
                }
            ]
        }
        else if (CurrentSubArea == "Asian") {
            langMapList = [
                {
                    "number": 0,
                    "name": "English ",
                    "code": "eng"
                },
                {
                    "number": 1,
                    "name": "Français ",
                    "code": "fre"
                },
                {
                    "number": 2,
                    "name": "Español ",
                    "code": "spa"
                },

                {
                    "number": 3,
                    "name": "Português ",
                    "code": "por"
                },
                {
                    "number": 4,//阿拉伯语 Arabic
                    "name": "العربية",
                    "code": "ara"
                },
                {
                    "number": 5,//俄语Russian
                    "name": "Русский ",
                    "code": "rus"
                },
                {
                    "number": 6,//
                    "name": "中文",
                    "code": "chi"
                },
                {
                    "number": 7,//越南语Vietnamese
                    "name": "Tiếng Việt",
                    "code": "vie"
                },
                {
                    "number": 8,//泰语Thai
                    "name": "ภาษาไทย",
                    "code": "tha"
                },
                {
                    "number": 29,//印度尼西亚Indonesian
                    "name": "Bhs Indonesia",
                    "code": "ind"
                },
                {
                    "number": 11,//印度语Hindi
                    "name": "हिंदी",
                    "code": "hin"
                },
                {
                    "number": 13,//马来Malay
                    "name": "Bahasa Melayu",
                    "code": "mal"
                }
//         {////繁體中文
//             "number":15,//
//             "name":"繁體中文",
//             "code":"zho"
//         }

            ]
        }
        else {
            langMapList = [
                {
                    "number": 0,
                    "name": "English ",
                    "code": "eng"
                },
                {
                    "number": 1,
                    "name": "Français ",
                    "code": "fre"
                },
                {
                    "number": 2,
                    "name": "Español ",
                    "code": "spa"
                },

                {
                    "number": 3,
                    "name": "Português ",
                    "code": "por"
                },
                {
                    "number": 4,//阿拉伯语 Arabic
                    "name": "العربية",
                    "code": "ara"
                },
                {
                    "number": 5,//俄语Russian
                    "name": "Русский ",
                    "code": "rus"
                },
                {
                    "number": 6,//
                    "name": "中文",
                    "code": "chi"
                }

            ]
        }

    }

    return langMapList;
}

function getBrandCode(area) {
//    var brand, OEMList = [
//        "jvc", "pio", "psc", "nob", "san",
//        "phi", "ilo", "sei", "ton", "blu",
//        "pan", "riv", "kal"
//    ];
    try {
        var brand = model.system.getCurBrand();
    }
    catch (ex) {
        brand = "his";
    }
    DBG_ERROR("CUR BRAND: "+brand);
//    var index = CONST.BRAND_LIST.indexOf(GLOBAL.UI_BRAND);
//    if (index < 0) {
//        GLOBAL.UI_BRAND = CONST.BRAND_LIST[0];
//    }
//    if (OEMList.indexOf(brand)) {
//        GLOBAL.LAUNCHER_BRAND = "SA_OEM";
//    }
//    else if ("COL" == area) {
//        GLOBAL.LAUNCHER_BRAND = "VIDAALite";
//    }
//    else {
//        GLOBAL.LAUNCHER_BRAND = "Hisense";
//    }
    //DBG_ERROR("write file start");
    //writeFileToNative("brandcode", brand, 1);
    //DBG_ERROR("write file end");
    return brand;
}

function getLanguageCode(area, subArea) {
    var langIndex = model.language.getOsd(), langObj;
    langObj = GetSysOSDLanguageMapList(area, subArea).find(function (v) {
        return (v.number == langIndex);
    });
    return langObj ? langObj.code : "eng";
}

function getCountryCode(area, subArea) {
    var countryindex = model.basicSetting.getTvsetLocation();
    var countryObj = GetSysCountryList(area, subArea).find(function (v) {
        return (v.number == countryindex);
    });
    if(countryObj){
        return countryObj.code
    }
    else
    {
        var countylist=GetSysCountryList(area, subArea);
        model.basicSetting.setTvsetLocation(countylist[0].number);
         return countylist[0].code;
    }
  //  return countryObj ? countryObj.code : "USA";
//    if (!GetSysCountryList(area, subArea).find(function (v) {
//            return (v.number == country);
//        })) {
//        DBG_ALWAYS("fix the country");
//        var countylist=GetSysCountryList(area, subArea);
//        if(countylist.length>0){
//            model.basicSetting.setTvsetLocation(countylist[0].number);
//            country=countylist[0].code;
//        }
//
//    }
//    return country;
        }
function ChangeCountryNumToCode(value){
    var countryList=GetSysCountryList(GLOBAL.CURRENT_AREA, GLOBAL.CURRENT_SUB_AREA)
    var index=_getIndexByNum(countryList,value);
    if(index>=0)
    {
        return  countryList[index].code;
    }
    else
    {
        //   model.basicSetting.setTvsetLocation(countryList[0].number);
        return  countryList[0].code;
}
}
function ChangeLangNumToCode(value){
    var langList=GetSysOSDLanguageMapList(GLOBAL.CURRENT_AREA, GLOBAL.CURRENT_SUB_AREA)
    var index=_getIndexByNum(langList,value);
    if(index>=0)
    {
       return  langList[index].code;
    }
    else
    {

       // model.language.setOsd(langList[0].number);
        return  langList[0].code;
    }
}

function getTimezoneSeconds(){
    //if("NA" == GLOBAL.CURRENT_AREA) return 3600 * parseInt(model.timerfunc.getTimeZone());
    return 36000;//model.timerfunc.getTimeZoneDeviation();
}

function checkHBBTVIsOn() {
    return (GLOBAL.CURRENT_SOURCE == SourceList.TV && GLOBAL.HBBTV_KEYSET > 15 && GLOBAL.HBBTV_KEYSET != 0x2000)
}

function checkCECControlIsOn() {
    if (GLOBAL.CURRENT_SOURCE < SourceList.HDMI1 || GLOBAL.CURRENT_SOURCE > SourceList.HDMI4) return false;
    return (1 == GLOBAL.CEC_CONTROL);// && 1 == GLOBAL.CEC_DEVICE_EXIST);
}

function isCECByPass() {
    return (1 == GLOBAL.CEC_CONTROL && 1 == GLOBAL.CEC_DEVICE_EXIST && 1 == GLOBAL.CEC_ARC_STATE);
}

function sendKeyToCEC(keyCode, v){
    if(Config.tv) {
        UI.sendKeyResult(null,false);
        switch (keyCode){
            case CONST.KEY.VK_PLAY:
                UI.callTTS("[PI0010]");
                break;
            case CONST.KEY.VK_PAUSE:
                UI.callTTS("[DMP0027]")
                break;
            case CONST.KEY.VK_STOP:
                UI.callTTS("[SE0100]");
                break;
            case CONST.KEY.VK_FAST_FWD:
                UI.callTTS("[SE1039]");
                break;
            case CONST.KEY.VK_FAST_BKW:
                UI.callTTS("[SE1040]");
                break;
            default :
                break;
        }
//        model.cec.sendKeyToCEC(CONST.CEC_KEYMAP[keyCode], UI.keyState);
    }
    else{
        UIObserver.publishMessage(UIObserver.MESSAGE_NAME.VOLUME_CHANGED, v + (CONST.KEY.VK_VOLUME_DOWN == keyCode ? -1 : 1));
    }
}

function isJson(obj) {
    var isjson = typeof (obj) == "object" && !obj.length &&
        obj.toString().toLowerCase() == "[object object]";
    return isjson;
}

/**
 * 仅删除已加载的js文件，但不会释放该js文件中已有的对象
 * @param fileName  js文件名字，尽量全，防止误删
 * @constructor
 */
function DeleteLoadedJsFile(fileName) {
    try {
        var jsNode = findJsNode(fileName);
        jsNode && (document.head.removeChild(jsNode));

        function findJsNode(val) {
            var jsLen = document.scripts.length;
            for (var i = 0; i < jsLen; i++) {
                if (document.scripts[i].src.indexOf(val) > -1) {
                    return document.scripts[i];
                }
            }
            return false;
        }
    } catch (ex) {
        DBG_ERROR(ex.message);
    }
}

function isFileExist(path, workRoot) {
    if (!Config.tv) return null;
    var ret = false;
    try {
        ret = Hisense.File.exists(path, workRoot);
        DBG_INFO("file[" + path + "] exist[" + ret + "]");
    }
    catch (ex) {
        DBG_ERROR(ex.message);
    }
    return ret;
}
/**
 * 获取网络状态
 * @returns {number}
 */
function getNetworkSatus() {


    if (!Config.tv) return 1;

    try {

        var netStatus = model.network.getEnumNetworkAvailable();
        if (netStatus == 1) {
            var net = 0;
            switch (model.network.getEnumNetworking()) {
                case NetWorkType.ETHER:
                    net = 1;
                    break;
                case NetWorkType.WIRELESS:
                    var quality = model.network.getLink_quality();
                    net = 10 + Math.ceil(quality / 25);//model.network.getApSignal();
                    break;
                default :
                    net = 0;
                    break;
            }
            DBG_INFO('network status = ' + net);
            return net;
        }
        else {
            DBG_INFO('network status = 0');
            return 0;
        }
    }
    catch (ex) {
        DBG_INFO(ex.message, DebugLevel.ERROR)
        return 0;
    }
}
/**
 * 检查文件下载状态
 * @param path
 * @param workRoot
 * @param callback
 * @param identify
 * @param m_interval
 * @param max_times
 */
function checkDownloadState(path, workRoot, callback, identify, m_interval, max_times) {

    !m_interval && (m_interval = 2000);
    !max_times && (max_times = 5);
    var m_times = 0;

    var timerKey = null;

    if (null != identify.match("current")) {
        timerKey = "current";
    }
    else if (null != identify.match("forecast")) {
        timerKey = "forecast";
    }
    else if (null != identify.match("search")) {
        timerKey = "search";
    }
    else if (null != identify.match("lnchrState")) {
        timerKey = "lnchrState";
    }
    else {
        DBG_INFO("download checktimer error:" + identify);
        callback.call(this, null, identify);
        return;
    }

    clearInterval(AccuWeatherData.dnldChkTimer[timerKey]);

    AccuWeatherData.dnldChkTimer[timerKey] = setInterval(function () {
        var obj = readFileFromNative(path, workRoot);
        DBG_INFO('check file: "' + path + '" download state. times = ' + (m_times++));

        if (!!obj) {
            clearInterval(AccuWeatherData.dnldChkTimer[timerKey]);
            AccuWeatherData.dnldChkTimer[timerKey] = -1;
            DBG_INFO('download file: "' + path + '" success');
            callback.call(this, obj, identify);

        }
        else if (m_times >= max_times) {
            clearInterval(AccuWeatherData.dnldChkTimer[timerKey]);
            AccuWeatherData.dnldChkTimer[timerKey] = -1;
            DBG_INFO('download file: "' + path + '" failed', DebugLevel.WARNING);
            callback.call(this, null, identify);

        }
    }, m_interval);
}

/**
 * 重命名(移动)本地文件，如果tv==false，从内存修改
 * @param destPath
 * @param srcPath
 * @param destWorkingRoot
 * @param srcWorkingRoot
 */
function moveNativeFile(destPath, srcPath, destWorkingRoot, srcWorkingRoot) {
    if (!Config.tv) {
        var tempSrcData = {}, tempDestData = {};
        cloneObj(AccuWeatherData.fileDataTemp[srcPath], tempSrcData);
        cloneObj(AccuWeatherData.fileDataTemp[destPath], tempDestData);

        AccuWeatherData.fileDataTemp[srcPath] = tempDestData;
        AccuWeatherData.fileDataTemp[destPath] = tempSrcData;

        return;
    }
    var ret = Hisense.File.move(destPath, srcPath, destWorkingRoot, srcWorkingRoot)
    if (0 != ret) {
        DBG_INFO('move native file: "' + srcPath + '"' +
            ' to file:  "' + destPath + '" error. Error code = ' + ret, DebugLevel.ERROR);
    }
    else {
        DBG_INFO('move native file: "' + srcPath + '"' +
            ' to file:  "' + destPath + '" success');
    }
}
/**
 * 从本地删除文件，如果tv==false，从内存删除
 * @param path
 * @param workRoot
 */
function deleteNativeFile(path, workRoot) {
    if (!Config.tv) {
        AccuWeatherData.fileDataTemp[path] = null;
        return;
    }
    var ret = Hisense.File.delete(path, workRoot);
    if (0 != ret) {
        //DBG_INFO('remove native file: "' + path + '" error. Error code = ' + ret, DebugLevel.ERROR);
    }
    else {
        DBG_INFO('remove native file: "' + path + '" success');
    }
}

/**
 * 从本地读文件，如果tv=false，从内存创建新的在读
 * @param path
 * @param workRoot
 * @returns {*}
 */
function readFileFromNative(path, workRoot) {
    if (!Config.tv) {
        if (!AccuWeatherData.fileDataTemp[path]) {
            switch (path) {
                case "weather/cities":
                    AccuWeatherData.fileDataTemp[path] =AccuWeatherData.accuweatherTempData;
                    break;
                case "weather/current/15-349727_1_AL":
                    AccuWeatherData.fileDataTemp[path] = AccuWeatherData.dataTemp["15-349727_1_AL"]["current"];
                    break;
                case "weather/current/7894":
                    AccuWeatherData.fileDataTemp[path] = AccuWeatherData.dataTemp["7894"]["current"];
                    break;
                case "weather/forecast/15-349727_1_AL":
                    AccuWeatherData.fileDataTemp[path] = AccuWeatherData.dataTemp["15-349727_1_AL"]["forecast"];
                    break;
                case "weather/forecast/7894":
                    AccuWeatherData.fileDataTemp[path] = AccuWeatherData.dataTemp["7894"]["forecast"];
                    break;
                case "launcher/Appinfo.json":
                    AccuWeatherData.fileDataTemp[path] = AccuWeatherData.favappinfo;
                    break;
            }
        }
        return AccuWeatherData.fileDataTemp[path];
    }
    DBG_INFO('read native file "' + path + '"; workRoot = ' + workRoot);
    var res = Hisense.File.read(path, workRoot);
    var obj = null;
    if (isNaN(res)) {
        obj = strToObject(res);
    }
    else {
        // DBG_INFO('read native file "' + path + '" error, code =' + res, DebugLevel.ERROR);
    }
    return obj;
}
/**
 * 写文件到本地，如果tv==false，写入内存
 * @param path
 * @param content
 * @param workRoot
 */
function writeFileToNative(path, content, workRoot) {
    if (!Config.tv) {
        if("undefined" != typeof (AccuWeatherData)) AccuWeatherData.fileDataTemp[path] = strToObject(content);
        return true;
    }
    var res = Hisense.File.write(path,content,workRoot);
    //DBG_ERROR('write file "' + path + '" error, code = ' + res, DebugLevel.ERROR);
    if (0 != res) {
        DBG_ERROR('write file "' + path + '" error, code = ' + res, DebugLevel.ERROR);
        return false;
    }

    return true;
}

/**
 * 下载文件到本地
 * @param url
 * @param path
 * @param workRoot
 * @param timeout
 * @returns {boolean}
 */
function downloadFileToNative(url, path, workRoot, timeout) {

    try {
        timeout = !!timeout ? timeout : 10;
        deleteNativeFile(path, workRoot);
        DBG_INFO('download url = ' + url);
        var asyncSuccess = Config.tv ? Hisense.File.downloadAsync(url, path, workRoot, timeout) : 0;
        DBG_ALWAYS("async success flag[" + asyncSuccess + "]");
        if (asyncSuccess != 0) {
            DBG_INFO('async download failed "' + url + '"', DebugLevel.ERROR);
            return false;
        } else {
            return true;
        }
    } catch (ex) {
        DBG_ERROR(ex);
    }
}
/**
 * 克隆对象
 * @param fromObj
 * @param toObj
 */
function cloneObj(fromObj, toObj) {
    for (var i in fromObj) {
        if (Array.isArray(fromObj[i])) {
            toObj[i] = [];
            cloneObj(fromObj[i], toObj[i]);
            continue;
        }
        else if (typeof fromObj[i] == "object") {
            toObj[i] = {};
            cloneObj(fromObj[i], toObj[i]);
            continue;
        }
        toObj[i] = fromObj[i];
    }
}

/**
 * 获取一个跟原对象同样的副本，对副本修改不会影响到原对象，仅限数组或Json对象
 * @param obj
 */
function getObjCopy(obj){
    if(Array.isArray(obj)){
        return JSON.parse(JSON.stringify({name:obj}))["name"];
    } else {
        return JSON.parse(JSON.stringify(obj));
    }
}

/**
 * 缓存网路文件到本地
 * @param urlArr
 * @param cacheDir
 * @param cacheIndex
 * @returns {boolean}
 */
function cacheFileToNative(urlArr, cacheDir, cacheIndex) {
    if (!Config.tv || 0 == urlArr.length) return null;
    var res = Hisense.File.cache(objToString(urlArr), cacheDir, cacheIndex);
    if (0 != res) {
        DBG_INFO('cache file error, code = ' + res, DebugLevel.ERROR);
        return false;
    }
    return true;
}

function readCacheIndex(path) {
    if (!Config.tv) return null;
    DBG_INFO('read cache file "' + path + '"');
    var res = Hisense.File.readCacheIndex(path);
    var obj = null;
    if (isNaN(res)) {
        obj = strToObject(res);
    }
    else {
        DBG_INFO('read cache file "' + path + '" error, code =' + res, DebugLevel.ERROR);
    }
    return obj;
}

function getHourByFormat(hour, format) {

    var formatHour = {}, str = " ";
    if (0 == format) {// 12h
        if (hour > 12) {
            hour -= 12;
            str = " PM"
        }
        else if (hour == 12) {
            str = " PM";
        }
        else if (hour == 0) {
            hour = 12;
            str = " AM"
        }
        else {
            str = " AM"
        }
    }
    else {
        hour = ('0' + hour).slice(-2);
    }
    formatHour.HOUR = hour;
    formatHour.APM = str;
    return formatHour;
}

function recheckDSTSeconds() {
    if (!Config.tv || "NA" == GLOBAL.CURRENT_AREA || GLOBAL.FREEVIEW_VERSION) return;
    var nw = Date.now();
    if (0 && Math.abs(nw - GLOBAL.DST_UPDATE_TIME) > 1000) {
        //6586 use DEVIATION_FROM_UTC, don't need GLOBAL.DST_SECONDS
        GLOBAL.DST_SECONDS = 0;//(parseInt(model.datetime.getDaylightSavings()) * 3600);
        GLOBAL.DST_UPDATE_TIME = nw;
    }
}

/**
 * get the date string of the given time
 * @param {number} longTime seconds from 1970.1.1
 * @param {boolean} is_short no year mode
 * @return {string} date_string(no time string)
 */
function UTCToLocalDate(longTime, is_short) {
    recheckDSTSeconds();
    if (isNaN(longTime)) {
        longTime = 0;
    }
    var date = new Date(getLocalTimeByUTC(longTime) * GLOBAL.MILLIBASE);
    var yyyy = date.getUTCFullYear();
    var mm = date.getUTCMonth() + 1;
    var dd = date.getUTCDate();
    var date_string = "";
    switch (GLOBAL.DATE_FORMAT){
        case "ymd":
            date_string = is_short ? "" : yyyy + GLOBAL.DATE_SEPARATOR;
            date_string +=  mm + GLOBAL.DATE_SEPARATOR + dd;
            break;
        case "mdy":
            date_string =  mm + GLOBAL.DATE_SEPARATOR + dd;
            date_string += is_short ? "" : GLOBAL.DATE_SEPARATOR + yyyy;
            break;
        case "dmy":
        default:
            date_string =  dd + GLOBAL.DATE_SEPARATOR + mm;
            date_string += is_short ? "" : GLOBAL.DATE_SEPARATOR + yyyy;
            break;
    }
    return date_string;
}
function getInfobarUTCDate(longTime) {
    recheckDSTSeconds();
    if (isNaN(longTime)) {
        longTime = 0;
    }
    var date = new Date(getLocalTimeByUTC(longTime) * GLOBAL.MILLIBASE);
    var yyyy = date.getUTCFullYear();
    var mm = date.getUTCMonth() + 1;
    var dd = date.getUTCDate();
    return [yyyy, mm, dd];
}
function updateDateFormat() {
    var format = "dmy";
    var separator = "/";
    DBG_INFO("updateDateFormat CURRENT_AREA is " + GLOBAL.CURRENT_AREA);
    DBG_INFO("updateDateFormat CURRENT_COUNTRY is " + GLOBAL.CURRENT_COUNTRY);
    DBG_INFO("updateDateFormat CURRENT_LANGUAGE is " + GLOBAL.CURRENT_LANGUAGE);
    //set format
    if ((GLOBAL.CURRENT_COUNTRY == "IRN" && GLOBAL.CURRENT_LANGUAGE == "per")
        || GLOBAL.CURRENT_COUNTRY == "TWN"
        || GLOBAL.CURRENT_COUNTRY == "LTU") {
        format = "ymd";
    } else if (GLOBAL.CURRENT_AREA == "NA" && GLOBAL.CURRENT_COUNTRY != "MEX") {
        format = "mdy";
    }

    //set separator
    if (GLOBAL.CURRENT_AREA == "SA"
        || GLOBAL.CURRENT_AREA == "NA"
        || GLOBAL.CURRENT_COUNTRY == "LTU") {
        separator = "-";
    } else if (GLOBAL.CURRENT_COUNTRY == "DEU"
        || GLOBAL.CURRENT_COUNTRY == "CZE"
        || GLOBAL.CURRENT_COUNTRY == "LVA"
        || GLOBAL.CURRENT_COUNTRY == "EST") {
        separator = ".";
    }
    GLOBAL.DATE_FORMAT = format;
    GLOBAL.DATE_SEPARATOR = separator;
}

function UTCToLocalTime(longTime, f, sec) {
    recheckDSTSeconds();
    var d = new Date(getLocalTimeByUTC(longTime) * GLOBAL.MILLIBASE);
    var formatHour = getHourByFormat(d.getUTCHours(), (undefined != f) ? f : GLOBAL.TIME_FORMAT);
    var m = "0" + d.getUTCMinutes();
    return formatHour.HOUR + ':' + m.slice(-2) + formatHour.APM.replace(/\s+$/, '');//hh:mm
}

function getLocalTimeByUTC(utc) {
    if (!Config.tv) return (utc + GLOBAL.TIMEZONE_SECONDS);
    //6586 use DEVIATION_FROM_UTC, don't need GLOBAL.DST_SECONDS
    if (!GLOBAL.FREEVIEW_VERSION) return (utc + GLOBAL.DEVIATION_FROM_UTC);
    //if (!GLOBAL.FREEVIEW_VERSION) return (utc + GLOBAL.TIMEZONE_SECONDS + GLOBAL.DST_SECONDS);
    //model.timerfunc.setUTCToLocalTime(utc);
    return parseInt(model.timerfunc.getUTCToLocalTime());
}

function getDVBLongTime() {
    var utcTime = 0;
    if (Config.tv) {
        utcTime = parseInt(model.datetime.getBroadcastTime());
    }
    else {
        utcTime = Math.ceil(Date.now() / GLOBAL.MILLIBASE);
    }
    return utcTime;
}

function getCurrrentLocalTime()
{
    var utcTime = 0;
    var timeZoneSec = 0;
    var localtime = model.datetime.getCurLocalTime();
   // var localtime = utcTime + GLOBAL.TIMEZONE_SECONDS + GLOBAL.DST_SECONDS;
    return (new Date((localtime) * GLOBAL.MILLIBASE ));
}
function getSystemTime() {
    try {
        var t = {};
        t.curtimeformat =tv? model.datetime.getTimeFormat():0;
       // DBG_INFO("get cur timeformat " + operateData.curtimeformat);
        var localTime = tv? model.datetime.getCurLocalTime(): Date.now();
        DBG_INFO("curLocalTime " + localTime);
        var tempTime = new Date(tv? (localTime * 1000): localTime);
        t.year = tempTime.getUTCFullYear();
        t.month = tempTime.getUTCMonth()+1;
        t.day = tempTime.getUTCDate();
        t.hour = tempTime.getUTCHours();
        t.min = tempTime.getUTCMinutes();
        t.sec = tempTime.getUTCSeconds();
        DBG_INFO("YY:" + t.year + " MM:" + t.month + " DD:" + t.day + " HH:" + t.hour + " mm:" + t.min);
       // t.date = ('0' + (localTime.getUTCMonth() + 1)).slice(-2) + '.' + ('0' + localTime.getUTCDate()).slice(-2) + '.' + localTime.getUTCFullYear();
        var time = ChangeTimeformat(t.hour, t.min, t.curtimeformat);
        t.time = time;

        var is_short = false;
        var yyyy = t.year;
        var mm = ('0' + t.month).slice(-2);
        var dd = ('0' + t.day).slice(-2);
        switch (GLOBAL.DATE_FORMAT){
            case "ymd":
                t.date = is_short ? "" : yyyy + GLOBAL.DATE_SEPARATOR;
                t.date +=  mm + GLOBAL.DATE_SEPARATOR + dd;
                break;
            case "mdy":
                t.date =  mm + GLOBAL.DATE_SEPARATOR + dd;
                t.date += is_short ? "" : GLOBAL.DATE_SEPARATOR + yyyy;
                break;
            case "dmy":
            default:
                t.date =  dd + GLOBAL.DATE_SEPARATOR + mm;
                t.date += is_short ? "" : GLOBAL.DATE_SEPARATOR + yyyy;
                break;
        }
        if (GLOBAL.DATE_SEPARATOR == "." && is_short) {
            t.date += GLOBAL.DATE_SEPARATOR;
        }

        var formatHour = getHourByFormat(tempTime.getUTCHours(), t.curtimeformat);
        t.format_time = formatHour.HOUR + ":" + ('0' + t.min).slice(-2) + formatHour.APM.replace(/\s+$/, '');
        DBG_INFO("curtime" + JSON.stringify(t));
        return t;
    }
    catch (e) {
        DBG_ERROR(e.message);
    }
}

function getSystemLongTime(){
    var utcTime = 0;
    if (Config.tv) {
        utcTime = parseInt(model.datetime.getBroadcastTime());
        //DBG_INFO("system utcTime[" + utcTime + "]");
//        utcTime = Math.ceil(Date.now() / GLOBAL.MILLIBASE);
    }
    else {
        utcTime = Math.ceil(Date.now() / GLOBAL.MILLIBASE);
    }
    return utcTime;
}


function UTCToLocalWeek(longTime) {
    var utcdate = new Date(getLocalTimeByUTC(longTime) * GLOBAL.MILLIBASE);
    return getCurrentContentLanguage(CONST.SHORT_WEEK[utcdate.getUTCDay()]);
}

function getProgramLocalTime(t1, t2, mode, f) {
    var localDT1 = new Date(getLocalTimeByUTC(t1) * GLOBAL.MILLIBASE);
    var localDT2 = new Date(getLocalTimeByUTC(t2) * GLOBAL.MILLIBASE);

    var localT1 = UTCToLocalTime(t1, f);
    var localT2 = UTCToLocalTime(t2, f);

    var str, localDay1, localDay2;

    localDay1 = ('0' + localDT1.getUTCDate()).slice(-2) + " " + CONST.SHORT_MONTH[localDT1.getUTCMonth()];
    localDay2 = ('0' + localDT2.getUTCDate()).slice(-2) + " " + CONST.SHORT_MONTH[localDT2.getUTCMonth()];

    switch (mode) {
        case 1:
            str = localT1 + " - " + localT2 + " " + localDay1;
            break;
        case 2:
            str = localT1;
            break;
        case 3 :
            str = localT1 + " " + localDay1;
            break;
        case 4:
            str = localT1 + " " + localDay1 + " - " + localT2 + " " + localDay2;
            break;
        default:
            str = localT1 + " - " + localT2;
            break;
    }

    return str;

}

function filterUnicaode(str) {
    var ret = str;
    try {
        ret = str.replace("\u001b", "");
    }
    catch (ex) {
        DBG_ERROR(ex.message);
    }
    return ret;
}

function changeSourceToTV() {
    var livetvData = liveTV.getChannelListOprtData();
    DBG_ERROR("livetvData.crntList is " + objToString(livetvData.crntList));
    if (!!livetvData && !!livetvData.crntList && !!livetvData.crntList.name) {
        var chnls;
        if (livetvData.listIndex == CHLISTINDEX.ALL) {
            chnls = livetvData.allChannels[livetvData.crntList.name];
        }
        else if (livetvData.listIndex == CHLISTINDEX.FAV) {
            chnls = livetvData.favChannels[livetvData.crntList.name];
        }
        if (!!chnls && chnls.length > 0) {
            var isFavList = livetvData.listIndex == CHLISTINDEX.FAV;
            if (!!chnls[livetvData.channelIndex]) {
                checkAndPlayChannel(chnls[livetvData.channelIndex], isFavList); //MSD6586US-1786
            }
            else {
                checkAndPlayChannel(chnls[0], isFavList);
            }
            return;
        }
    }

    var keys = Object.keys(livetvData.allChannels);
    DBG_ERROR("keys is " + objToString(keys));
    var tunerIndex = 0;
    for (var i = 0; i < keys.length; i++) {
        if (keys[i].substring(0, 3) != "FAV"/* && livetvData.allChannels[keys[i]].length > 0*/) {
            if (keys[i].toLowerCase() == "cable") {
                tunerIndex = 1;
                //model.channelSearch.setSource(16);
            }
            else if (keys[i].toLowerCase() == "antenna") {
                tunerIndex = 0;
                //model.channelSearch.setSource(15);
            }
            var chnl = liveTV.mainTunerModePlayToChannel(tunerIndex);
            if (chnl.uid == 0){
                DBG_ERROR(".............................Current channel is 0, play the first channel.");
                chnl = livetvData.allChannels[keys[i]][0];  //maybe don't exist
            }
            if (!!chnl) {
                checkAndPlayChannel(chnl);
                return;
            }
        }
    }
    var currSource = tv ? model.source.getCurrentSource(): "TV";
    if(currSource == "TV") {
        DBG_ERROR("send message by UI TV source to TV");
        setTimeout(function(){
            UIObserver.publishMessage(UIObserver.MESSAGE_NAME.CURRENT_SOURCE_CHANGED, "TV");
        },1000);
    }
    DBG_ERROR("change source to 'TV without channels'");
    tv && model.tvservice.playChannel(0, "TV", 0, null, 0);
}

UI.sourceChangeCounter = 0;
function changeSourceTo(id) {
    DBG_ERROR("change source to: " + id);
    if (Config.tv) {
        if (checkIsAppOn()) {
            DBG_ERROR("changeSourceTo:app is not stop,stop it then change source");
            appControl.stopCurrentApp();
            appStoppedFunc = function () {
                changeSourceTo(id);
                resumeDTV();
                appStoppedFunc = null;
            };
            return;
        }
        if (GLOBAL.MEDIA_STARTUP_FLAG) {
//            appControl.stopCurrentApp();
        }

        var currentSourceId = getCurrentSourceId();
        clearTimeout(GLOBAL.SOURCE_CHANGING_TIMER_SELF);
        if(currentSourceId == id){
            GLOBAL.SOURCE_CHANGING_TIMER_SELF = setTimeout(function(){
                DBG_ERROR("current source == change to source UI send onchange byself!!!! ");
                UIObserver.publishMessage(UIObserver.MESSAGE_NAME.CURRENT_SOURCE_CHANGED, mapInputsDataById(id));
            },1000);
        }
        else {
            if (id == 0) { //tv
                changeSourceToTV();
            }
            else {
                var playId = mapInputsDataById(id);
                model.servicemode.setSourceVideoInfo(""); //clear source video info
                model.tvservice.playChannel(0, playId, 0, null, 0);
            }
        }

        GLOBAL.SOURCE_CHANGING = true;
        clearTimeout(GLOBAL.SOURCE_CHANGING_TIMER);
        GLOBAL.SOURCE_CHANGING_TIMER = setTimeout(function() {
            DBG_ERROR("change source fail.");
            GLOBAL.SOURCE_CHANGING = false;
            //liveTV.setWaitSourceChange(false);
        }, 15000);
        //遥控器逻辑：
        try{
            var tmpData = initAllInputsData().sourceList;
            if(!!tmpData){
                var tmpCData = null;
                for(var i = 0;i<tmpData.length;i++){
                    if(tmpData[i].id==id){
                        tmpCData = tmpData[i];
                    }
                }
                if(!!tmpCData){
                    var isLock = tmpCData.locked?1:0;
                    pubStateSourceSwitch(id,tmpCData.name,parseInt(tmpCData.signal),isLock,0,tmpCData.rename);
                }else{
                    DBG_ERROR("tmpCdata is null");
                }
            }else{
                DBG_ERROR("tmpData is null");
            }

        }catch (ex){
            DBG_ERROR(ex.message);
        }
    }
    else {
        setTimeout(function(){
            UIObserver.publishMessage(UIObserver.MESSAGE_NAME.CURRENT_SOURCE_CHANGED, mapInputsDataById(id));
        },1000);
    }
    DBG_TODO("set recent input");
    var obj = {
        "name":0,
        "url":0
    };
    writeFileToNative("launcher/ott.txt",objToString(obj), 1);
    ReadInputRecent(id);
    UI.sourceChangeCounter++;
    if (UI.sourceChangeCounter >= 20) {
        DBG_ERROR("change source count 20 times,start gc..");
        UI.sourceChangeCounter = 0;
        if (window.gc) {
            window.gc();
        }
    }
    return true;
}

function ReadInputRecent(id){
    var ret = readFileFromNative("hisenseUI/recentinput.txt", 1);
    DBG_INFO("read recent fie ret  " + JSON.stringify(ret));
    var rencentInput={};
    rencentInput.source =[];
    if(null != ret) {
        rencentInput = ret;
        if(rencentInput.source.length >=7){
            rencentInput.source.splice(6,rencentInput.source.length-6);
        }
        if(rencentInput.source.indexOf(id)>-1)rencentInput.source.splice(rencentInput.source.indexOf(id),1);
    }
    rencentInput.source.splice(0,0,id);
    DBG_INFO('recentInput:'+JSON.stringify(rencentInput));
    writeFileToNative("hisenseUI/recentinput.txt", JSON.stringify(rencentInput), 1);
}

function objectFindByKey(array, key, value) {
    if (!Array.isArray(array)) return null;
    var i, k, founded;
    if (Array.isArray(key)) {
        for (i = 0; i < array.length; i++) {
            founded = true;
            for (k = 0; k < key.length; k++) {
                if (array[i][key[k]] != value[k]) {
                    founded = false;
                    break;
                }
            }
            if (founded) {
                return array[i];
            }
        }
    }
    else {
        for (i = 0; i < array.length; i++) {
            if (array[i][key] == value) {
                return array[i];
            }
        }
    }
    return null;
}

function getMaskValue(name, val) {
    var flag = 0;
    val = parseInt(val);
    switch (name) {
       /*
        case Mask.HD:
            flag = val & (1 << 2);
            break;
        case Mask.SKIP:
            flag = !(val & (1 << 3));
            break;
        case Mask.FAVTYPE:
            flag = val & ServicelistModel.SERVICE_BITMASK_IS_FAVORITE;
            break;
        case Mask.LOCK:
            flag = val & (1 << 8);
            break;
        case Mask.ENCRYPT:
            flag = val & (1 << 11);
            break;
        case Mask.VISIBLE:
            flag = !(val & (1 << 15));
            break;
        case Mask.HIDDEN:
            flag = !(val & (1 << 1));
            break;
        */
        case Mask.SKIP:
            flag = val & ServicelistModel.SERVICE_BITMASK_IS_SKIPPED;
            break;
        case Mask.FAVTYPE:
            flag = val & ServicelistModel.SERVICE_BITMASK_IS_FAVORITE;
            break;
        case Mask.LOCK:
            flag = val & ServicelistModel.SERVICE_BITMASK_IS_LOCKED;
            break;
        case Mask.ANALOG:
            flag = val & ServicelistModel.SERVICE_BITMASK_IS_ANALOG;
            break;
        case Mask.AUDIOONLY:
            flag = val & ServicelistModel.SERVICE_BITMASK_AUDIO_ONLY;
            break;
        default :
            break;
    }
    return !!flag;
}

function fetchSignalAndPublish(notPublishMessage) {
    debugWhoCallMe("fetchSignalAndPublish");
    var temp_signal_message = SvrMsg.EMPTY;

    DBG_ERROR("signal array is [" +
        (GLOBAL.S_NO_CHANNEL ? 1 : 0) +
        (GLOBAL.S_LOCKING? 1: 0) +
        (GLOBAL.S_NO_SIGNAL? 1: 0) +
        (GLOBAL.S_SCRAMBLED? 1: 0) +
        (GLOBAL.S_AUDIO_CHANNEL ? 1 : 0) + "]");

    if (GLOBAL.S_NO_CHANNEL && GLOBAL.CURRENT_SOURCE == SourceList.TV) {
        temp_signal_message = SvrMsg.NO_CHANNEL;
    }
    else if (GLOBAL.S_LOCKING) {
        temp_signal_message = SvrMsg.LOCKED_CH;
    }
    else if (GLOBAL.S_NO_SIGNAL) {
        temp_signal_message = SvrMsg.NO_SIGNAL;
    }
    else if (GLOBAL.S_SCRAMBLED && GLOBAL.CURRENT_SOURCE == SourceList.TV) {
        temp_signal_message = SvrMsg.SCRAMBLED;
    }
    else if (GLOBAL.S_AUDIO_CHANNEL && GLOBAL.CURRENT_SOURCE == SourceList.TV) {
        temp_signal_message = SvrMsg.AUDIO_PROG;
    }

    if (!notPublishMessage) {
        UIObserver.publishMessage(UIObserver.MESSAGE_NAME.SIGNAL_CHANGED, temp_signal_message);
    }
    else {
        GLOBAL.CURRENT_SVR_MSG = temp_signal_message;
        DBG_ERROR("only update GLOBAL.CURRENT_SVR_MSG to " + GLOBAL.CURRENT_SVR_MSG);
    }
}

function tryToShowOperateTip() {
    if (checkLiveTVState(LIVETV.CONTROL) && liveTV.checkOperateTip()) {
        liveTV.setFirstPlayFlag(false);
        UI.popSubModule();
        UI.pushSubModule(LIVETV.MAIN, LIVETV.OPERATE_TIP, true);
    }
}

function createListIterator(onGetAllChannelListEvent) {
    var listIterator = null;
    if ("NA" == GLOBAL.CURRENT_AREA) {
        listIterator = {
            readNextRows: function () {
                onGetAllChannelListEvent({
                    type: TableIterator.EVENT_TYPE_ROWS_READ,
                    rows: [
                        ["Antenna", "6", "0", "1", "1"],
                        ["Cable", "7", "0", "1", "1"]
                    ]
                });
            }
        }
    }
    else {
        listIterator = new TableIterator(
            model.servicelist.createFavoritelistIterator,
            true,
            [
                {
                    field: ServicelistModel.FIELD_FAVORITE_LIST_ATTR,
                    condition: Model.FIELD_COND_ANY_BIT_SET,
                    value: 0x61
                }
            ],
            [
                ServicelistModel.FIELD_FAVORITE_LIST_NAME,
                ServicelistModel.FIELD_FAVORITE_LIST_ID,
                ServicelistModel.FIELD_FAVORITE_LIST_ATTR,
                ServicelistModel.FIELD_FAVORITE_LIST_ACTIVE,
                ServicelistModel.FIELD_FAVORITE_LIST_RIGHTS
            ],
            [
                {field: ServicelistModel.FIELD_FAVORITE_LIST_NAME, direction: 1}
            ],
            onGetAllChannelListEvent
        );
    }
    if (null == listIterator) DBG_ERROR("create iterator error.");
    return listIterator;
}

function createChannelIterator(list, onGetChannelsEvent, epgFlag) {
    var channelIterator = null;
    DBG_ERROR("createChannelIterator list is :" + objToString(list));
    if (!Config.tv) {

        var allChannels = converChannelsToEventRows();
        channelIterator = {
            index: 0,
            readNextRows: function (idx) {
                onGetChannelsEvent(list, !!allChannels[list.name] ? allChannels[list.name] : []);
            },
            fetchTotalCount: function () {
                onGetChannelsEvent(list, {
                    type: TableIterator.EVENT_TYPE_TOTAL_COUNT,
                    totalCount: !!allChannels[list.name] ? allChannels[list.name].rows.length : 0
                });
            },
            seekToRow: function (idx) {
                channelIterator.index = idx;
            }
        }
        return channelIterator;
    }
    if (list == null) return null;

    var servicelist_uuid = list.uid, sl_name = list.name;

    var satelliteId = list.satId;
    if (sl_name) {
        DBG_INFO("createServicelistIterator:::::" + sl_name);
        channelIterator = new TableIterator(
            model.servicelist.createServicelistIterator,
            true,
            [
                {
                    field: ServicelistModel.SERVICELIST_FIELD_FRONTEND,
                    condition: Model.FIELD_COND_EQUAL,
                    value: servicelist_uuid
                }
            ],
            [
                ServicelistModel.SERVICELIST_FIELD_NAME,
                ServicelistModel.SERVICELIST_FIELD_FRONTEND,
                ServicelistModel.SERVICELIST_FIELD_MAJOR_CHANNEL_NUMBER,
                ServicelistModel.SERVICELIST_FIELD_MINOR_CHANNEL_NUMBER,
                ServicelistModel.SERVICELIST_FIELD_GCN,
                ServicelistModel.SERVICELIST_FIELD_ATTR,
                ServicelistModel.SERVICELIST_FIELD_NO
            ],
            [
                {field: ServicelistModel.SERVICELIST_FIELD_NO, direction: 1},
                {field: ServicelistModel.SERVICELIST_FIELD_NAME, direction: 1}
            ],
            onGetChannelsEvent.bind(this, list)
        );
    }
    return channelIterator;
}

function converChannelsToEventRows() {

    var request = new XMLHttpRequest();
    request.open("GET", "module/liveTV/channels.json", false);
    request.send(null);
    var response = request.responseText;
    var channels = JSON.parse(response);
    var keys = Object.keys(channels);
    var file = {};
    for (var i = 0; i < keys.length; i++) {
        var chnls = channels[keys[i]];
        file[keys[i]] = {type: 1, rows: []};
        for (var j = 0; j < chnls.length; j++) {
            var chnl = chnls[j];
//            file[keys[i]].rows.push([chnl.number, chnl.name, chnl.uid, chnl.type, chnl.attr, chnl.playId, chnl.serviceType]);
            file[keys[i]].rows.push([chnl.name, 1, chnl.number, 2, chnl.uid, /*chnl.type,*/ chnl.attr, chnl.number]);
        }
    }
    return file;
}

function createOneActiveWinProgram(channelIds, serviceIds, startLine, endLine, onGetOneActiveProgramsEvent) {
    var programIterator = null;
    if (!tv) {
        programIterator = {
            offset: 0,
            readNextRows: function(count) {
                var m_event = {
                    type: TableIterator.EVENT_TYPE_ROWS_READ
                };
                m_event.rows = createFakeProgram({number: this.offset}, startLine, endLine, count);
                onGetOneActiveProgramsEvent(m_event);
            },
            seekToRow: function(offset, type){
                this.offset = offset;
            }
        };
        return programIterator;
    }

    programIterator = new TableIterator(
        model.epg.createEpgIterator,
        true, [{
            field: EpgModel.FIELD_EPG_SERVICE_ID,
            condition: Model.FIELD_COND_EQUAL,
            value: channelIds
        }, {
            field: EpgModel.FIELD_EPG_TRANSPORT_STREAM_ID,
            condition: Model.FIELD_COND_EQUAL,
            value: serviceIds
        }, {
            field: EpgModel.FIELD_EPG_START_TIME_UTC,
            condition: Model.FIELD_COND_GREATEREQUAL,
            value: startLine
        }, {
            field: EpgModel.FIELD_EPG_END_TIME_UTC,
            condition: Model.FIELD_COND_LESSEQUAL,
            value: endLine
        }], [
            EpgModel.FIELD_EPG_EVENT_ID,
            EpgModel.FIELD_EPG_TITLE,
            EpgModel.FIELD_EPG_SHORT_TEXT,
            EpgModel.FIELD_EPG_THEMES,
            EpgModel.FIELD_EPG_START_TIME_UTC,
            EpgModel.FIELD_EPG_END_TIME_UTC,
            EpgModel.FIELD_EPG_SERVICE_ATTRIBUTES,
            EpgModel.FIELD_EPG_DESCRIPTION,
            EpgModel.FIELD_EPG_CRIDS
        ], [{
            field: EpgModel.FIELD_EPG_START_TIME_UTC,
            direction: 1
        }],
        onGetOneActiveProgramsEvent);
    return programIterator;
}
function createFakeProgram(chnl, startTime, endTime, count){
    var i, rows = [], leftEndTime = startTime + Math.ceil(Math.random() * 60) * 20;
    if (0 === endTime) {
        startTime = getDVBLongTime();
        endTime = startTime + 3 * 3600;
        count = count == 4 ? Math.floor(Math.random() * 5) : count;
        for (i = 0; i < count; i++) {
            var row = [];
            row[0] = (i + 1);
            row[1] = "channel " + chnl.number + " fake program " + (i + 1);
            row[2] = leftEndTime;
            row[3] = row[2] + Math.ceil(Math.random() * 60) * 60;
            row[4] = chnl.number + " fake program detail";
            leftEndTime = row[3];
            rows.push(row);
            if (leftEndTime >= endTime) return rows;
        }
    } else {
        for (i = 0; i < count; i++) {
            var row = [];
            row[0] = (i + 1);
            row[1] = chnl.number + " fake program " + i;
            row[2] = chnl.number + " fake program short " + i + " short text";
            row[3] = "0x" + Math.floor(Math.random() * 9) + "0";
            row[4] = leftEndTime;
            row[5] = row[4] + Math.ceil(Math.random() * 60) * 60;
            row[6] = 0;
            row[7] = chnl.number + " fake program short " + i + " detail infomation";
            if (i % 2 == 0) {
                row[7] += row[7];
                row[7] += row[7];
                row[7] += row[7];
                row[7] += row[7];
                row[7] += row[7];
            }
            leftEndTime = row[5];
            rows.push(row);
            if (leftEndTime >= endTime) return rows;
        }
    }
    return rows;
}

function releaseIterator(iterator){
    try{
        if (!!iterator) {
            iterator.disconnect();
            iterator = null;
        }
    }
    catch (ex) {
        DBG_ERROR("releaseIterator:" + ex.message)
    }
}

function compareChannel(a, b) {
    if (null == a || null == b) return false;
//    return (a.uid == b.uid && a.playId == b.playId && a.satId == b.satId);
    return (a.listUid == b.listUid && a.uid == b.uid && a.number == b.number);
}

//====================== app start =============================//

function checkAppStarted(appName) {
    if (null == UI.getGhostModule(APPMODULE.CONTROL)) return false;
    if(AMState.STOPPED == appControl.getCurrentAMState()) return false;
    return (appName == appControl.getCurrentAPPName());
}

function checkIsAppOn(appName){
    if(null == UI.getGhostModule(APPMODULE.CONTROL)) return false;
    if(AMState.STOPPED == appControl.getCurrentAMState()) return false;
    if(null == appName) return true;
    return appName == appControl.getCurrentAPPName();
}

function recheckAppNameByCommand(appname, appcmd) {
    try {
        if (null == appname) {
            return findAppNameByParam(appcmd);
        } else {
            return appname;
        }
    } catch (ex) {
        DBG_ERROR(ex.message);
    }
}

/**
 * 仅用来创建HTML Native 应用
 * @param appName
 * @returns {boolean}
 */
function startHiPageApp(appName,startMethod,appParam) {
    var hipageApp = true;
    switch (appName) {
        case APPNAME.ACCUWEATHER:
            UI.pushModule('accuweather');
            break;
        case APPNAME.MIRACAST:

            break;
        case APPNAME.HIMEDIA:
            //UI.pushModule('himedia');
            DBG_INFO("START METHOD : "+ startMethod);
            if(!!startMethod && startMethod == CMDMethod.MENU){
                UI.pushModule("hiMedia", {caller: "launcher"});
            }else{
                UI.pushModule("hiMedia", {caller: "key_media"});
            }


            break;
        case APPNAME.SEARCH:
            //UI.pushModule('himedia');
            if(!!startMethod && startMethod == CMDMethod.MENU){
                UI.pushSubModule("searchUSO", "search", true);
            }else{
                if(!!appParam){
                    if(!!appParam.caller){
                        if(appParam.caller.toString()=="voice"){
                            UI.pushSubModule("searchUSO", "search", true, {caller: "voice",key:appParam.key});
                        }
                    }else{
                        if(appParam == "SearchNOW"){
                            UI.pushSubModule("searchUSO", "search", true,{caller: "remote"});
                        }
                    }
                }else{
                    UI.pushSubModule("searchUSO", "search", true,{caller: "remote"});
                }

            }
            break;
        case APPNAME.HISENSESTORE:
            //UI.pushModule('himedia');
            UI.pushSubModule("AppStore", "appStore", true);
            break;
        case APPNAME.NEW4KNOW:
            //UI.pushModule('himedia');
            UI.pushSubModule("fourknow", "fourknowMain", true);
            break;
        default:
            hipageApp = false;
            break;
    }
    return hipageApp;
}

//该函数仅用于打开 appcontrol页面
function openAppControl(appname, appcmd, cmdType, startMethod, appStarted, appColor,storeType,localAppName) {
    try {
        DBG_INFO('openAppControl');
        if (startHiPageApp(appname,startMethod)) return true;
        var appGhost = UI.getGhostModule(APPMODULE.CONTROL);
        if (null == appGhost) UI.pushGhostModule(APPMODULE.MAIN, APPMODULE.CONTROL, true);
        appControl.setAppParameters(appname, appcmd, cmdType, startMethod,storeType,localAppName);

        if (appStarted) {
            appControl.setCurrentAMState(AMState.STARTED);
            appControl.focusCurrentApp();
        }
        else {
            //todo ghl show and open
            appControl.startCurrentApp();
        }
    } catch (ex) {
        DBG_ERROR(ex.message);
    }
}


function logReportForAppRun(appName,startMethod,appParam,runFlag){
    try{
        var LocalAppName=null;
        if(appName==APPNAME.THIRDPARTY){
            LocalAppName=appParam;
        }else{
            LocalAppName=appName;
        }
        var tmp_param = {
            AppName: LocalAppName,
            LaunchSource: 1
        }
        if (CMDMethod.REMOTECONTROL == startMethod || CMDMethod.STARTUP == startMethod) {
            tmp_param.LaunchSource = 2;
        }
        if(runFlag){
            DBG_INFO("log report GTAPPRun start:" + startMethod);
            LGReport.GTAPPRunStart(tmp_param.AppName,tmp_param.LaunchSource);
        }else{
            DBG_INFO("log report GTAPPRun closed");
            LGReport.GTAPPRunClose(tmp_param.AppName,tmp_param.LaunchSource);
        }

    }catch (ex) {
        DBG_ERROR(ex.message);
    }

}
var needBackTo4know = false;
function startThirdPartyApp(appName, appCMD, cmdType, startMethod, appStarted, appColor,appParam,storeType,from4know) {
    try {
        // if (window.gc) window.gc();
        DBG_ERROR("startThirdPartyApp: "+appName+","+appCMD+","+cmdType+","+startMethod+","+appStarted+","+appColor+","+appParam+","+storeType);
        try{
            appName = recheckAppNameByCommand(appName, appCMD);
            var LocalAppName = appName.toLowerCase().replace(" ", "");
            if(appName == "browser"){
                UI.callTTS(appParam);
            }else if(appName == APPNAME.NEW4KNOW){
                UI.callTTS("4k now");
            }else if(appName == APPNAME.HISENSESTORE){
                UI.callTTS("Apps Now");
            }else if(appName == APPNAME.SEARCH){
                UI.callTTS("Search NOW");
            }else if(appName==APPNAME.THIRDPARTY && appParam){
                LocalAppName=appParam.toLowerCase().replace(" ", "");
                UI.callTTS(appParam);
            }else if(appName == APPNAME.AMAZON) {
                UI.callTTS("Prime Video");
            }else if(appName == "appstore") {
                UI.callTTS("viewed app store");
            }
            else{
                UI.callTTS(appName);
            }
            DBG_ERROR("!!!!!!!!!!!!!!!!" + appName);
            if(!!from4know){
                needBackTo4know = true;
            }else{
                needBackTo4know = false;
            }
            var HiPageAPPVec = ['hiMedia', 'accuweather'];

            if (HiPageAPPVec.indexOf(UI.getCurrModule().name) > -1) {
                DBG_INFO('HiPageAPPVec.indexOf(appName) > -1; appName' + appName);
                if (appName.toLowerCase() == UI.getCurrModule().name.toLowerCase()) {
                    DBG_INFO('appName == UI.getCurrModule().name');
                    //focus current hipageapp
                    return;
                } else {
                    //stop current hipageapp，并切currentapp不要主动转移焦点给其他模块
                    DBG_INFO('appName != UI.getCurrModule().name');
                    if (UI.getCurrModule().name == 'accuweather') {
                        DBG_INFO('appName == APPNAME.ACCUWEATHER');
                        //accuweather.onkey_BACKSPACE();
                        UI.popModule();

                    } else if (UI.getCurrModule().name == 'hiMedia') {
                        DBG_INFO('appName == hiMedia');
                        //UI.popModule('hiMedia');
                        UI.popModule();
                    } else {
                        DBG_INFO('undefined HIPAGEAPP, donothing');
                    }
                }
            }

            var appGhost = UI.getGhostModule(APPMODULE.CONTROL);
        }catch (ex){
            DBG_ERROR("startThirdPartyApp:"+ex.stack);
        }
        if (null != appGhost) {
            DBG_ERROR('null != appGhost');
            DBG_INFO('appName: ' + appName + ",LocalAppName:" + LocalAppName);
            var amState = appControl.getCurrentAMState();
            if(AMState.STOPPED == amState){
                if (startHiPageApp(appName,startMethod)) return true;
                openAppControl(appName, appCMD, cmdType, startMethod, appStarted, appColor,storeType,LocalAppName);
                return;
            }else{
                if ((appName != APPNAME.THIRDPARTY && storeType!=StoreType.YOUTUBE && CMDMethod.DIALSERVER != startMethod) && (appName == appControl.getCurrentAPPName() || appName == appControl.getCurrentLocalAPPName())) {
                    if(appName == APPNAME.OTT &&appCMD !=appControl.getCurrentAPPCMD()){

                    }else{
                        appControl.focusCurrentApp();
                        return true;
                    }
                }
                if(appName == APPNAME.THIRDPARTY && (!!appControl.getCurrentLocalAPPName()) && LocalAppName==appControl.getCurrentLocalAPPName()){
                    appControl.focusCurrentApp();
                    return true;
                }

                DBG_INFO('appControl.getCurrentAMState(): ' + amState);
                if (AMState.STARTED != amState) {
                    DBG_ERROR("app[" + appControl.getCurrentAPPName() + "] is on state[" + amState + "], can not start app[" + appName + "]");
                    //TODO: need to process focus module
                    return false;
                }
                appIntermediate = true;
                appStoppedFunc = openAppControl.bind(this, appName, appCMD, cmdType, startMethod, appStarted, appColor,storeType,LocalAppName)
                appControl.stopCurrentApp();
                return true;
            }

        }
        if (startHiPageApp(appName,startMethod,appParam)) return true;
        openAppControl(appName, appCMD, cmdType, startMethod, appStarted, appColor,storeType,LocalAppName);

    } catch (ex) {
        DBG_ERROR("startThirdPartyApp:"+ex.stack);
    }

}

function focusPageByModule(module) {
    try {
        resumeDTV();
        switch (module) {
            case "livetv":
                openLiveTVModule([Msg.INFO, 0]);
                break;
            case "launcher":
                //openLaucher();
                break;
            default :
                openLiveTVModule([Msg.INFO, 0]);
                break;
        }
    } catch (ex) {
        DBG_ERROR(ex.message);
    }
}

function findAppNameByParam(param) {
    try {
        var i, keys = Object.keys(APPNAME);
        for (i = 0; i < keys.length; i++) {
            if (param == APPNAME[keys[i]]) {
                return APPNAME[keys[i]];
            }
        }
        DBG_ERROR("set app name as default");
        return APPNAME.THIRDPARTY;
    } catch (ex) {
        DBG_ERROR(ex.message);
    }
}

function onAmStateChanged(appName,appStatus,source) {

//    DBG_ERROR("am notify [" + val + "]");
//    var strvec = val.split(" ");
//    //strvec[0]是应用名称  strvec[2]状态
//    if (appPagesList.indexOf(strvec[0]) < 0) return;
//    if ("opera4x" == strvec[0] && AMState.STARTED == strvec[2]) return;
    DBG_ERROR("onAmStateChanged:"+appName+","+appStatus);
    if(!UI.preloadAppControlFinish){
        DBG_ERROR("onAmStateChanged:UI.preloadAppControlFinish false return");
        return;
    }
    if("failed" == appStatus){
        appStatus = AMState.STOPPED;
    }
    if ("factory_lite" == appName && AMState.STOPPED == appStatus) {
        appControl.setCurrentAMState(AMState.STOPPED);
        appControl.stopCurrentApp();
        if(!!GLOBAL.WAIT_POWERON){return;}
        liveTV.initChannelList();
        openLiveTVModule();
        resumeDTV();
        if (GLOBAL.NEED_START_OPERA4X) {
            DBG_ERROR("NEED_START_OPERA4X");
            sendAM(":am,am,:start=opera4x","opera4x","start","");
            GLOBAL.NEED_START_OPERA4X = false;
        }
        return;
    }

    //var localAppName = appControl.getCurrentLocalAPPName();//App列表中显示的App名称
    //var appName = appControl.getCurrentAPPName();
    try {
        var appGhost = UI.getGhostModule(APPMODULE.CONTROL);
        if(!appGhost){
            DBG_ERROR("onAmStateChanged:appGhost is null!");
        }
        if(!!appGhost && appName == APPNAME.NETFLIX && startMethod == CMDMethod.STARTUP){
            model.system.stopAnimation(0);
        }
        if (null != appGhost && (AMState.STOPPED == appStatus || AMState.PAUSED == appStatus) && !appStoppedFunc) {
            var appUrl = appControl.getCurrentAPPCMD();//AM命令中传入的启动URL,不是预设的StartCommand
            var startMethod = appControl.getCurrentStartMethod();


            if (GLOBAL.WAIT_POWERON || GLOBAL.TV_SUSPENDING) {
                if (startMethod == CMDMethod.BYAPP) {
                    appControl.setCurrentStartMethod(CMDMethod.MENU);
                    return;
                }
            }
            if (appUrl &&
                appUrl.indexOf("4ka.husard") == -1 &&
                startMethod == CMDMethod.BYAPP) {
                DBG_ERROR("1. am notify, launch 4KNow again.");
                appControl.setCurrentAMState(AMState.STOPPED);
                appControl.stopCurrentApp();
                // for log report @shixin6
                try {
                    logReportForAppRun(appControl.getCurrentAPPName(),appControl.getCurrentStartMethod(),appControl.getCurrentLocalAPPName(),false);
                } catch (ex) { DBG_ERROR(ex.message) }
                startThirdPartyApp(null, "https://4ka.husard.com/", 36, CMDMethod.MENU, false, "#FFFFFF","4K Now");

                return;
            } else {
                if (appUrl &&
                    appUrl.indexOf("4ka.husard") != -1 &&
                    (AMState.STOPPED == appStatus || AMState.PAUSED == appStatus)) {
                    var fileText = Hisense.File.read('appbyapp.json', 0);
                    Hisense.File.write("appbyapp.json", "none", 0);
                    DBG_ERROR("2. am notify, am command: "+fileText);
                    if (
                        fileText
                            && "none" != fileText
                            && "" != fileText
                            && 2 != fileText
                            && '2' != fileText
                        )
                    {
                        var appInfo = JSON.parse(fileText);
                        DBG_ERROR("3. am notify, to launch 3rd App: "+appInfo.toString());
                        appControl.setCurrentAMState(AMState.STOPPED);
                        appControl.stopCurrentApp();
                        installAppFrom4kNow(appInfo.clientUrl);
                        // for log report @shixin6
                        try {
                            logReportForAppRun(appControl.getCurrentAPPName(),appControl.getCurrentStartMethod(),appControl.getCurrentLocalAPPName(),false);
                        } catch (ex) { DBG_ERROR(ex.message) }
                        //installAppFrom4kNow(appInfo.client);
                        if (appInfo.action == 'app') {
                            if (appInfo.clientUrl == '') {
                                startThirdPartyApp(appInfo.client, appInfo.client, 37, CMDMethod.BYAPP, false, "#FFFFFF",appInfo.client);
                            } else {
                                startThirdPartyApp('opera4x', appInfo.clientUrl, 37, CMDMethod.BYAPP, false, "#FFFFFF",appInfo.client);
                            }
                        } else {
                            if (appInfo.clientUrl == '') {
                                startThirdPartyApp(appInfo.client, appInfo.deepLink, 37, CMDMethod.BYAPP, false, "#FFFFFF",appInfo.client);
                            } else {
                                startThirdPartyApp('opera4x', appInfo.deepLink, 37, CMDMethod.BYAPP, false, "#FFFFFF",appInfo.client);
                            }
                        }
                        return;
                    }
                }
            }
        }

        var setAppName = [APPNAME.NETFLIX, APPNAME.AMAZON, APPNAME.VUDU, APPNAME.YOUTUBE,APPNAME.THIRDPARTY,APPNAME.YOUTUBEKIDS,APPNAME.YOUTUBETV];
        if(setAppName.indexOf(appName) > -1){
            DBG_INFO("onAmStateChanged:set current app to biz.the appName is:"+appName);
            try{
                if(!!source && source == APPNAME.YOUTUBE){
                    model.source.appStatusSet(APPNAME.YOUTUBE,appStatus);
                }else if(appName == "youtube_kids"){
                     model.source.appStatusSet('youtube_kids',appStatus);
                }else if(appName == "youtube_tv"){
                     model.source.appStatusSet('youtube_tv',appStatus);
                }else if(appName == "opera4x" && appControl.getCurrentAPPName() == APPNAME.EPOS){
                    DBG_ERROR("onAmStateChanged:current app name is epos");
                }else{
                    model.source.appStatusSet(appName,appStatus);
                }
            }catch (ex){
                DBG_ERROR("onAmStateChanged:"+ex.message);
            }
        }
        if((appName==APPNAME.AMAZON||appName==APPNAME.AMAZONRUBY||source==APPNAME.YOUTUBE || (!!appGhost && appControl.getCurrentAPPName() == APPNAME.EPOS))
            &&(AMState.STARTED == appStatus || AMState.STOPPED == appStatus || AMState.RESUMED == appStatus)){
            DBG_ERROR("Hide appLoading!");
            UI.endLoading();
        }
        switch (appStatus) {
            case AMState.STARTED:
            case AMState.RESUMED:
            {
                if("netflix" == appName){
                    GLOBAL.DROP_NETFLIX_STOP = false;
                    try {
                        var AcrNotificationToast = UI.getSubModule("AcrNotificationToast");
                        AcrNotificationToast.alpha = 0;
                    } catch (ex) {
                        DBG_ERROR(ex.message);
                    }
                }
                if (null == appGhost || AMState.STARTING != appControl.getCurrentAMState()) {
                    DBG_ALWAYS("started by system.");
                    if(!!source && source == "youtube"){
                        appName = "youtube";
                    }
                    UI.popAllModule();
                    startThirdPartyApp(findAppNameByParam(appName), appName, CMDType.COMMON, CMDMethod.COMMON, true);
                }
                else {
                    if(UI.getCurrSubModule().name != "blank" && UI.getCurrModule().name == "searchUSO" && UI.getCurrModule().name == "AppStore"){
                        UI.popAllModule();
                    }
                    appControl.setCurrentAMState(AMState.STARTED);
                    appControl.focusCurrentApp();
                }
                try{
                    if(acrflag && isCurCountryhasACR()){
                        var name=null;
                        if(appControl.getCurrentAPPName()==APPNAME.THIRDPARTY){
                            name=appControl.getCurrentLocalAPPName();
                        }else{
                            name=appControl.getCurrentAPPName();
                        }
                        AcrJSI.inputSource("appName",name);
                    }

                }catch(ex){DBG_ERROR(ex.message)}
                try{
                    logReportForAppRun(appControl.getCurrentAPPName(),appControl.getCurrentStartMethod(),appControl.getCurrentLocalAPPName(),true);
                }catch(ex){DBG_ERROR(ex.message)}
                UI.unlockAllKeys("appStarted");
                break;
            }
            case AMState.STOPPED:
            case AMState.PAUSED:
            {
                DBG_ERROR("onAmStateChanged:"+appStatus);
                if (null == appGhost) {
                    DBG_ERROR("onAmStateChanged: appGhost is null, return");
                    try{
                        if(appControl.getCurrentAMState() == AMState.STOPPING){
                            appControl.setCurrentAMState(AMState.STOPPED);
                            appControl.stopCurrentApp();
                            appStoppedFunc = null;
                            resumeDTV();
                            openLiveTVModule();
                            UI.unlockAllKeys("appStopped");
                        }
                    }catch (ex){
                        DBG_ERROR("onAmStateChanged:"+ex.message);
                    }
                    return;
                }
                try {
                    if(acrflag && isCurCountryhasACR()){
                        AcrJSI.inputSource("appName","am");
                    }
                } catch (ex) { DBG_ERROR(ex.message) }

                if(appName == "amazon" && (appControl.getCurrentAMName() == APPNAME.AMAZON || appControl.getCurrentAMName() == APPNAME.AMAZONRUBY)){
                    DBG_INFO("onAmStateChanged:"+appControl.getCurrentAMName());
                }else{
                    DBG_ERROR("onAmStateChanged:"+appControl.getCurrentAMName()+","+appName);
                    if (appControl.getCurrentAMName() != appName) return;
                }
                // for log report @shixin6
                try {
                    logReportForAppRun(appControl.getCurrentAPPName(),appControl.getCurrentStartMethod(),appControl.getCurrentLocalAPPName(),false);

                } catch (ex) { DBG_ERROR(ex.message) }

                var sysStoped = AMState.STOPPING != appControl.getCurrentAMState();

                appControl.setCurrentAMState(AMState.STOPPED);
                appControl.stopCurrentApp();
                DBG_ERROR("appStoppedFunc="+appStoppedFunc+"sysStoped="+sysStoped);
                if (appStoppedFunc) {
                    appStoppedFunc.call(this);
                }
                else {
                    var needResumeDtv = true;
                    if (sysStoped) {
                        DBG_ERROR("stopped by system");
                        if (appControl.getCurrentStartMethod() == CMDMethod.MENU) {
                            DBG_INFO('appControl.getCurrentStartMethod() == CMDMethod.MENU, currModel is '+UI.getCurrModule().name+",UI.isLoadingModule ="+UI.isLoadingModule);
                            //添加CMDMethod 分类，打开AllApp页面?
                            if (UI.getCurrModule().name == "AppStore" || UI.getCurrModule().name == "searchUSO"|| UI.getCurrModule().name == "fourknow" ) {
                                hideForAppStorePlay(1);
                                needResumeDtv = false;
                            }else if(UI.getCurrSubModule().name=="launcherMovieDetail"){
                                hideForAppStorePlay(1);
                            }else if(needBackTo4know){
                                needResumeDtv = false;
                                startThirdPartyApp(APPNAME.NEW4KNOW,"4know-hisense",37, CMDMethod.MENU, false, 0xFFFFFF,APPNAME.NEW4KNOW,98);
                            }else if (!UI.isLoadingModule && UI.getCurrModule().name != "launcher") {
                                UI.pushModule("launcher");
                            }

                        }else if (appControl.getCurrentStartMethod() == CMDMethod.COMMANDURL) {
//                            if (UI.getCurrModule().name == "base") {
//                                UI.pushModule("launcher");
//                            }
//                            else
                            if (UI.getCurrModule().name == "AppStore" || UI.getCurrModule().name == "searchUSO"|| UI.getCurrModule().name == "fourknow" ) {
                                hideForAppStorePlay(1);
                                needResumeDtv = false;
                            }else if(UI.getCurrSubModule().name=="launcherMovieDetail"){
                                hideForAppStorePlay(1);
                            }else if(needBackTo4know){
                                needResumeDtv = false;
                                startThirdPartyApp(APPNAME.NEW4KNOW,"4know-hisense",37, CMDMethod.MENU, false, 0xFFFFFF,APPNAME.NEW4KNOW,98);
                            }else if (!UI.isLoadingModule && UI.getCurrModule().name != "launcher") {
                                UI.pushModule("launcher");
                            }
                        }
                        else {
                            if(checkStartOttApp(appControl.getCurrentLocalAPPName())){
                                needResumeDtv = false;
                                startOTTApp();
                            }else{
                                if(UI.getCurrModule().name != "liveTV"){
                                    UI.popAllModule();
                                }
                                openLiveTVModule();
                            }
                        }
                    }else{
                        if(UI.getCurrSubModule().name == "blank"){
                            DBG_ERROR("onAmStateChanged:getCurrSubModule is blank,open livetv");
                            openLiveTVModule();
                        }
                    }
                    DBG_INFO('=============================resumeDTV()=====================');
                    if(needResumeDtv){
//                       if(checkStartOttApp(appControl.getCurrentLocalAPPName())){
                            var obj = {
                                "name":0,
                                "url":0
                            };
                            writeFileToNative("launcher/ott.txt",objToString(obj), 1);
//                        }
                        resumeDTV();
                    }
                }

                appStoppedFunc = null;
                UI.unlockAllKeys("appStopped");
                break;
            }
            case AMState.DIALSTART:
            {
                UI.popAllModule();

                startThirdPartyApp(appName, null, CMDType.NATIVEAPP, CMDMethod.DIALSERVER, false, null);
                break;
            }
            case AMState.DIALSTOP:
            {
                appControl.stopCurrentApp(CMDMethod.DIALSERVER);
                break;
            }
            default :
                break;
        }
    }
    catch (ex) {
        DBG_ERROR(ex.message);
    }
}

//"opera4x {"type": "HBBTVKeySet","keyset": "###"}"
//"opera4x {"type": "AppStatus","source": "hbbtv|youtube|store|browser|operastore","status": "started|paused|stopped/failed"}"
//"apm {"type": "AppSTR","status": "suspend/resume"}"
//"apm {"type": "AppStatus","source": "opera4x/netflix/vudu/factory_lite","status": "failed"}"
//"nativeAPP {"type":"AppStatus","source":"netflix/vudu/factory_lite","status": "started|paused|stopped/failed"}"
//"dial" {"type":"DialEvent","status":"start","DstSource":"Netflix","arg":""}
//EPOS  {type: "APPMessage", target: "launcher","action":"popAllModule"}
var appEventValue = null;
var dialStartArg = "";
var dialStopArg = "";
function onAppEventMessageChanged(val){
    DBG_ERROR("onAppEventMessageChanged:"+val);
    var strvec = val.split(" {");
    var eventFrom = strvec[0];
    var eventInfo =JSON.parse("{" + strvec[1]);
    if(eventFrom == "opera4x" && eventInfo.type == "APPMessage") {
        if(eventInfo.action == "stopEpos") {
            appControl.stopCurrentApp();
        }
        if(eventInfo.action == "stopEposToLiveTV") {
            appControl.stopCurrentApp();
            appStoppedFunc = function(){ openLiveTVModule();  resumeDTV();};
        }
        if(eventInfo.action == "eposCallpopAllModule") {
            UI.popAllModule();
            appControl.focusCurrentApp();
        }
        return;
    }
    if(appEventValue==val){
        var appGhost = UI.getGhostModule(APPMODULE.CONTROL);
        if (!(null == appGhost || AMState.STARTING == appControl.getCurrentAMState() || AMState.STOPPING == appControl.getCurrentAMState())) {
            DBG_ERROR("onAppEventMessageChanged:DUPLICATE MESSAGE!!");
            return;
        }
    }
    try{
        switch (eventFrom){
            case "opera4x":
            {
                switch (eventInfo.type){
                    case "AppStatus":
                    {
                        DBG_ERROR("onAppEventMessageChanged:"+eventInfo.source+","+eventInfo.status);
                        if(eventInfo.status == "started" && eventInfo.source == "opera4x"){
                            GLOBAL.OPERA_STARTED = true;
                            if(GLOBAL.OTT_NEED_START_OPERA_STARTED){
                                var ott = readFileFromNative("launcher/ott.txt", 1);
                                var appUrl = ott.url;
                                DBG_INFO("wch in onAppEventMessageChanged appUrl is :"+appUrl);
                                sendAM(":am,opera4x,:resume=[-s,store,-u," + appUrl + "]",
                                    "opera4x","resume","source:store\r\nurl:"+appUrl+"\r\n"+"launch:remote\r\n");
                            }
                            DBG_ERROR("onAppEventMessageChanged:start opera4x");
                        }else if(!eventInfo.source){
                            DBG_ERROR("onAppEventMessageChanged:source is null!");
                        }else if(eventInfo.source == "hbbtv"){
                            DBG_ERROR("onAppEventMessageChanged:app is hbbtv!");
                        }else{
                            onAmStateChanged(eventFrom,eventInfo.status,eventInfo.source);
                        }
                        break;
                    }
                    default :
                    {
                        DBG_ERROR("onAppEventMessageChanged:from opera4x,type is:"+eventInfo.type);
                        break;
                    }
                }
                break;
            }
            case "nativeAPP":
            {
                switch (eventInfo.type){
                    case "AppStatus":
                    {
                        DBG_ERROR("onAppEventMessageChanged:"+eventInfo.source+","+eventInfo.status);
                        if(!eventInfo.source){
                            DBG_ERROR("onAppEventMessageChanged:source is null!");
                        }else if("opera4x" == eventInfo.source){
                            DBG_ERROR("onAppEventMessageChanged:source is opera4x!");
                        }else{
                            onAmStateChanged(eventInfo.source,eventInfo.status,"");
                        }
                        break;
                    }
                    default :
                        DBG_ERROR("onAppEventMessageChanged:from nativeAPP,type is"+eventInfo.type);
                        break;
                }
                break;
            }
            case "apm":
            {
                switch (eventInfo.type){
                    case "AppSTR":{
                        if(eventInfo.status == "resume"){
                            DBG_INFO("onAppEventMessageChanged:eventInfo.status is resume");
                            recoverTVState();
                        }else if(eventInfo.status == "suspend"){
                            DBG_INFO("onAppEventMessageChanged:eventInfo.status:suspend");
                            onEnterSuspendChanged();
                        }else{
                            DBG_ERROR("onAppEventMessageChanged:eventInfo.status:"+eventInfo.status);
                        }
                        break;
                    }
                    case "AppStatus":
                    {
                        DBG_ERROR("onAppEventMessageChanged:"+eventInfo.source+","+eventInfo.status);
                        if(!eventInfo.source){
                            DBG_ERROR("onAppEventMessageChanged:source is null!");
                        }else{
                            onAmStateChanged(eventInfo.source,eventInfo.status,"");
                        }
                        break;
                    }
                    default :
                        DBG_ERROR("onAppEventMessageChanged:from apm,type is"+eventInfo.type);
                        break;

                }
                break;
            }
            case "dial":
            {
                switch (eventInfo.type){
                    case "DialEvent":{
                        if(eventInfo.status == "start"){
                            dialStartArg = eventInfo.arg;
                            onAmStateChanged(eventInfo.DstSource,AMState.DIALSTART,"");
                        }else if(eventInfo.status == "stop"){
                            dialStopArg = eventInfo.arg;
                            onAmStateChanged(eventInfo.DstSource,AMState.DIALSTOP,"");
                        }else{
                            DBG_ERROR("onAppEventMessageChanged:eventInfo.status:"+eventInfo.status);
                        }
                        break;
                    }
                    default :{
                        DBG_ERROR("onAppEventMessageChanged:from dial,eventInfo.type:"+eventInfo.type);
                        break;
                    }
                }
                break;
            }
            default :
            {
                DBG_ERROR("onAppEventMessageChanged:eventFrom:"+eventFrom);
                break;
            }
        }
    }catch (ex){
        DBG_ERROR("onAppEventMessageChanged:"+ex);
    }
    appEventValue=val;
}
function StartFactory() {
    try {
        UI.popAllModule();
        if(APPMODULE.LayoutToast == "LayoutToast"){
            UI.popGhostModule("LayoutToast");
            APPMODULE.LayoutToast = null;
        }else if(APPMODULE.KpadToast == "KpadToast"){
            UI.popGhostModule("KeypadToast");
            APPMODULE.KpadToast = null;
        }
        startThirdPartyApp(APPNAME.FACTORY, null, CMDType.COMMON, CMDMethod.COMMON, false);
    } catch (ex) {
        DBG_ERROR(ex.message);
    }
}

//====================== app end =============================//


function sendAM(command,appName,state,param) {
    DBG_ERROR("sendAM:"+command + ","+appName+","+state+","+param);
    if(Config.tv){
        if (!param) {
            param = "";
        }
        if(GLOBAL.NEED_START_OPERA4X && appName == "opera4x" && state == "resume"){
            DBG_ERROR("NEED_START_OPERA4X sendAM:change opera4x resume to start");
            state = "start";
            GLOBAL.NEED_START_OPERA4X = false;
        }
        modeljs.sendam(command,appName,state,param);
    }
    else {
        var app = command.split("=")[1];
        var state = command.split("=")[0].split(":").reverse()[0];
        setTimeout(function () {
            if (state == "resume") state = "resumed";
            if (state == "start") state = "started";
            if (state == "stop") state = "stopped";
            if (state == "pause") state = "paused";
            if (state == "hotkey") state = "started";
            if (app == "0xef007") app = "netflix";
            onAmStateChanged(app + " !tv " + state);
        }, 3000);
    }
}

function getCurrentWeatherData(refreshWeather) {
    DBG_INFO("get weather data for launcher state bar");
    var WeatherData = {};
    var branch= GLOBAL.CURRENT_AREA =='EU'?true:false;
    try {
        var isDefaultData = false;
        try{
            var cities = readFileFromNative("weather/cities", 1);
        }catch(ex){
            DBG_ERROR(ex.message);
            cities=null;
        }
        DBG_INFO('cities:'+objToString(cities));
        try {
            DBG_INFO("hisenseUIConfig[DefaultCity]:"+hisenseUIConfig["DefaultCity"]);
        } catch (ex) {
            DBG_ERROR(ex.message);
            DBG_INFO("null == hisenseUIConfig:"+(null == hisenseUIConfig));
        }
        if(null == cities && (null == hisenseUIConfig || !hisenseUIConfig["DefaultCity"])) {
            if(branch){
//                var defCityKey = tv ? model.basicSetting.getTvsetLocation() + "City" : "CHNCity";
                //var curCountryList = GetSysCountryList(GLOBAL.CURRENT_AREA,GLOBAL.CURRENT_SUB_AREA);
                var tmp = tv ? ChangeCountryNumToCode(model.basicSetting.getTvsetLocation()): "ZAF";
                DBG_INFO("model.basicSetting.getTvsetLocation(): " + tmp);
                //var curCountryListId = _getIndexByNum(curCountryList, tmp);
                //DBG_INFO("use default cit33333333 [" + curCountryListId + "]");
                var defCityKey = tmp + "City";
                DBG_INFO("use default city [" + defCityKey + "]");
                try{
                    AccuWeatherData.defCityList = readFileFromNative("hisenseUI/data/weather/cities",2);//3rd_rw/
                    DBG_INFO("init defCityList"+objToString(AccuWeatherData.defCityList));
                }catch(ex){DBG_ERROR("AccuWeatherData.defCityList is error:"+ex.message)}
                if(!!AccuWeatherData.defCityList[defCityKey]){
                    cities = AccuWeatherData.defCityList[defCityKey];
                }else{
                    DBG_INFO("can not find this default city[" + defCityKey + "]", DebugLevel.ERROR);
                    cities = $.extend({}, AccuWeatherData.defCityList["CHNCity"]);
                }
                isDefaultData = true;
            }else{
                WeatherData="noLocation";
                refreshWeather(WeatherData);
               return;
            }
        }
        else if(null == cities || cities.cityList.length == 0) {
            DBG_ERROR("null == cities");
            WeatherData="noLocation";
            refreshWeather(WeatherData);
            return;
        }
        else{
            isDefaultData=false;
        }
        DBG_ERROR('cities:'+objToString(cities));
        var defInd = cities.defInd;
        var locId = cities.cityList[defInd].locId;
        var unit = cities.cityList[defInd].unit;
        WeatherData.name = cities.cityList[defInd].locName;
        var cityPath = {
            current: (isDefaultData ? "hisenseUI/data/weather/current/" : "weather/current/") + locId,
            forecast: (isDefaultData ? "hisenseUI/data/weather/forecast/" : "weather/forecast/") + locId
        };

        var newCityPath = {
            current: ("weather/current/") + locId,
            forecast: ("weather/forecast/") + locId
        };
        try {
            getWeatherData(refreshWeather,unit,isDefaultData,cityPath,WeatherData,cities);
        } catch (ex) {
            DBG_ERROR(ex.message);
        }
        try {
            updateWeatherData(locId, unit,getWeatherData.bind(this,refreshWeather,unit,false,newCityPath,WeatherData,cities));
        } catch (ex) {
            DBG_ERROR(ex.message);
        }
    }
    catch(ex) {
        DBG_INFO(ex.message, DebugLevel.ERROR);
        WeatherData="noLocation";
        refreshWeather(WeatherData);
    }
}

function getWeatherData(callBack,unit,isDefaultData,cityPath,WeatherData,cities){
    /* Update WeatherData Object for refreshing statusBar */
    try{
       var cw = readFileFromNative(cityPath.current, isDefaultData ? 2:1);
       var fw = readFileFromNative(cityPath.forecast, isDefaultData ? 2:1);

    }catch (ex){DBG_ERROR(ex.message)}

    if(null == cw || null == fw) {
        cities.cityList.splice(defInd, 1);
        cities.defInd = 0;
        DBG_INFO("read current weather failed. remove index", DebugLevel.ERROR);
        return;
    }
    var units = {
        Metric: '°C',
        Imperial: '°F'
    };
    WeatherData.degree = cw[0].Temperature[unit].Value + units[unit];
    WeatherData.weather = cw[0].WeatherText;
    WeatherData.icon =  ('0' + cw[0].WeatherIcon).slice(-2);
    DBG_INFO(objToString(WeatherData));
    if(callBack) callBack(WeatherData);//刷新Launcher页面 Current Weather数据
}

function updateWeatherData(locId, itemUnit,callBack){
    /*Upload data to temp*/
    var m_interval = 2000;
    var max_times = 2;
    if(!networkConnected()){
        DBG_INFO("network is not ok");
        return;
    }
    var newWeatherWorkRoot =1;
    var currentPath = setTempPath(locId, URLType.CURRENT),
        forecastPath = setTempPath(locId, URLType.FORECAST);

    var currentURL = setUrlSta(locId, URLType.CURRENT, itemUnit),
        forecastURL = setUrlSta(locId, URLType.FORECAST, itemUnit);


    if(downloadFileToNative(currentURL, currentPath, newWeatherWorkRoot, 10)) {
        checkDownloadState(currentPath, newWeatherWorkRoot, updateWeatherDataCallback.bind(this,callBack), currentPath, m_interval, max_times);
    }

    if(downloadFileToNative(forecastURL, forecastPath, newWeatherWorkRoot, 10)) {
        checkDownloadState(forecastPath, newWeatherWorkRoot, updateWeatherDataCallback.bind(this,callBack), forecastPath, m_interval, max_times);
    }

}

function updateWeatherDataCallback(callBack,obj, identify){
    /*Move data to dest*/
    var newWeatherWorkRoot =1;
    var callbackID=identify;
    if(null == obj || "string" == typeof(obj)) {
        DBG_INFO('get new weather failed');
        if("string" == typeof(obj)) {
            deleteNativeFile(identify, newWeatherWorkRoot);
        }
        return;
    }
    var destPath = '', locId = '';
    DBG_INFO('updateWeatherDataCallback identify = ' + identify);
    if(identify.indexOf('current') > -1) {
        locId = identify.split('current')[1];
        destPath = setPath(locId, URLType.CURRENT);
    }
    else if(identify.indexOf('forecast') > -1) {
        locId = identify.split('forecast')[1];
        destPath = setPath(locId, URLType.FORECAST);
    }
    if('' != destPath) {
        moveNativeFile(destPath, identify, 1, newWeatherWorkRoot);
    }
    DBG_INFO('callback:'+callBack);
    if(callbackID.indexOf('forecast') > -1){
        callBack.call(this);//重新刷新数据
    }
}

function URLType() {
}
URLType.CURRENT = 0;
URLType.FORECAST = 1;
URLType.SEARCH = 2;

function setTempPath(key, urlType) {
    var path = '';
    switch(urlType) {
        case URLType.CURRENT:
            path += ('current' + key);
            break;
        case URLType.FORECAST:
            path += ('forecast' + key);
            break;
        default :
            DBG_INFO('url type error', DebugLevel.ERROR);
            path += 'error';
            break;
    }
    return path;
}
function setPath(key, urlType) {
    var path = 'weather/';
    switch(urlType) {
        case URLType.CURRENT:
            path += ('current/' + key);
            break;
        case URLType.FORECAST:
            path += ('forecast/' + key);
            break;
        case URLType.SEARCH:
            path += 'searchlist';
            break;
        default :
            DBG_INFO('url type error', DebugLevel.ERROR);
            path += 'error';
            break;
    }
    return path;
}
function setUrlSta(key, urlType, itemUnit) {
    var url = '';
    var langMap = {
        eng: "en", fre: "fr", spa: "es", ger: "de", ita: "it", por: "pt",
        nor: "no", swe: "sv", dan: "da", fin: "fi", chi: "zh", cze: "cs",
        slk: "sk", pol: "pl", hun: "hu", bgr: "bg", tur: "tr", uzb: "uz",
        ara: "ar", rus: "ru", tha: "th", per: "fa", hin: "hi", heb: "he",
        ukr: "uk", vie: "vi", bur: "en", ind: "id", mal: "ms", bul: "bg",
        hrv: "hr", mac: "mk", alb: "en", srp: "sr", lav: "lv", est: "et",
        lit: "lt", slv: "sl", dut: "nl" ,kur: "en" ,rum: "ro", hbr: "he",
        zho: "zh-tw"
    };
    try {
        var langcode = !!GLOBAL.CURRENT_LANGUAGE ? langMap[GLOBAL.CURRENT_LANGUAGE] : "en";
    } catch (ex) {
        langcode = "en";
        DBG_ERROR(ex.message);
    }
    var apiKey = '5f7afc280da94a37a8a4cef4930c48d8';
    var params = '?language=' + langcode+ '&apikey=' + apiKey + '&metric=' + (itemUnit == 'Metric');
    switch(urlType) {
        case URLType.CURRENT:
            url = 'http://api.accuweather.com/currentconditions/v1/' + key + '.json' + params + '&details=true';
            break;
        case URLType.FORECAST:
            url = 'http://api.accuweather.com/forecasts/v1/daily/5day/' + key + params;
            break;
        case URLType.SEARCH:
            url = 'http://api.accuweather.com/locations/v1/search' + params + "&q=" + key;
            break;
        default :
            DBG_INFO('url type error', DebugLevel.ERROR);
            break;
    }
    //DBG_INFO(url, DebugLevel.INFO);
    return encodeURI(url);
}
function networkConnected() {
    try {
        var cnnct = tv ? model.network.getEnumNetworkAvailable() : 1;
        return (1 == cnnct);
    }
    catch (ex) {
        DBG_INFO(ex.message, DebugLevel.ERROR);
        return false;
    }
}

function openToastPage(type) {
    GLOBAL.CURRENT_TOAST_TYPE = type;
    UI.pushGhostModule("setting","SettingSysToast");
}

function openToastPageWithString(str) {
    UI.pushGhostModule("setting","SettingSysToast", str);
}


function Disable_common(submodule,target_arrary,flag){
    try {
        switch (flag) {
            case true:
                if (target_arrary.length == 0) {
                    DBG_ERROR("target_arrary is error ");
                }
                for (var i = 0; i < target_arrary.length; i++) {
                    var temp_group = UI.getItem(submodule, target_arrary[i]);
                    temp_group.disable = true;
                    temp_group.alpha=0.3;
                }
                break;
            case false:
                if (target_arrary.length == 0) {
                    DBG_ERROR("target_arrary is error ");
                }
                for (var i = 0; i < target_arrary.length; i++) {
                    var temp_group = UI.getItem(submodule, target_arrary[i]);
                    temp_group.disable = false;
                    temp_group.alpha=1;
                }
                break;
            default :
                break;
        }
        UI.updateStage();
    }catch(ex){DBG_ERROR("Disable_common is error"+ex.message);}
}
function initSwitchData(submodule, groupname,pic_switch) {
    try {
        var switchBar = UI.getItem(submodule, groupname);
        var switchComp = UI.getItem(switchBar, pic_switch);
        switch (groupname){
            case "Video_Description_group":
                var tmpData=tv?model.sound.getAudioType():0;
                DBG_INFO("model.system.getAudioType():"+tmpData);
                break;
            case "Audio_Menu_Prompts_group":
                //if(GLOBAL.CURRENT_LANGUAGE=="fre"){
                //    Disable_common(submodule,["Audio_Menu_Prompts_group"],true);
                //}else{
                //    Disable_common(submodule,["Audio_Menu_Prompts_group"],false);
                //}
                tmpData =tv?model.tts.getI32SwitchStatus():0;
                DBG_INFO("model.sound.getI32SwitchStatus():"+tmpData);
                break;
            case "High_Contrast_Menu_group":
                tmpData=tv?model.system.getMenuHighLightControl():0;
                switch (tmpData){
                    case 0:GLOBAL.HICONTRAST=false;
                        break;
                    case 1:GLOBAL.HICONTRAST=true;
                        break;
                    default :break;
                }
                DBG_INFO("model.system.getMenuHighLightControl():"+tmpData);
                break;
            default:
                var tmpData = -1;
                break;

        }
        switchComp.setSwitch(tmpData);
        //switchBar.updateCache();
        UI.updateStage();

    } catch (ex) {
        DBG_ERROR(ex.message)
    }
}
function getTTsLanguage(){
    try{
        if(tv){
            var langList=['eng','spa'];
            var index=getI32LangIdx();
            setTTsLanguage(langList[index]);
        }
    }catch(ex){DBG_ERROR('getTTsLanguage:'+ex.message)}

}
function setTTsLanguage(code){
    try{
        if (tv){
            switch (code){
                case "spa": setI32LangIdx(1);
                    GLOBAL.TTS_LANGUAGE='spa';
                    UI.initTTSLanguage();
                    break;
                default :   setI32LangIdx(0);
                    GLOBAL.TTS_LANGUAGE='eng';
                    UI.initTTSLanguage();
                    break;
            }
        }
    }catch(ex){DBG_ERROR(ex.message)}
}
function HighControlEnterHandler(flag){
    var type = flag == true ? 1 : 0;
    DBG_INFO("HighControl type:" + type);
    switch (type){
        case 0:GLOBAL.HICONTRAST=false;
            break;
        case 1:GLOBAL.HICONTRAST=true;
            break;
        default :break;
    }
    if (!!tv) {
        //GLOBAL.HICONTRAST=true;
        model.system.setMenuHighLightControl(type);
    }
}
//====================log report start=======================//
function hasModule(name){
    return UI.isExistModule(name);
}

function navStatePause(pauseFlag){
    try{
        if(tv){
            if(pauseFlag==true){
                model.system.setLauncherIsStarting(0);//pause
            }else{
                model.system.setLauncherIsStarting(1);//resume
            }
        }
    }catch(ex){DBG_ERROR('navStatePauseOrResume is error:'+ex.message)}
}
function launcherPanelCloseReport(para){
    try{
        var param={
            PanelName:UI.getCurrSubModule().name,
            CloseReason:1
        };
        if(!!para){
            param.CloseReason=para.CloseReason;
        }
        if(param.PanelName=="notifications"||param.PanelName=="allApps"||param.PanelName=="allInputs")
        {
            DBG_INFO("log report GTLauncherPanel "+param.PanelName+" is closed");
            LGReport.GTLauncherPanelClose(param.PanelName,param.CloseReason);
        }
    }catch(ex){DBG_ERROR(ex.message);}
}

function launcherPanelGlobalKeyProForLGReport(key){
    try{
        if(!UI.getCurrModule()||!UI.getCurrSubModule()||!UI.getCurrSubModule().name){
            DBG_ERROR('receive lgkey:'+key+',subModule is null,just return');
            return;
        }else{
            switch (UI.getCurrSubModule().name){
                case 'notifications':
                case 'allApps':
                case 'allInputs':
                    if(key=='onkey_LAUNCHER'||key=='onkey_LIVETV')
                        launcherPanelCloseReport();
                    break;
                default :break;
            }
            DBG_INFO('receive lgkey:'+key);
        }
    }catch(ex){DBG_ERROR('launcherPanelGlobalKeyProForLGReport is error:'+ex.message)}

}
function onPlayMainPauseChanged(val){
    DBG_ERROR("onPlayMainPauseChanged:"+val);
    if(val == 0){
        var crntSourceObj = liveTV.getCurrentSourceObj();
        DBG_ERROR("onPlayMainPauseChanged: " + crntSourceObj.name + "," + GLOBAL.CURRENT_SOURCE);
        if(crntSourceObj.id == GLOBAL.CURRENT_SOURCE){
            if(crntSourceObj.id == SourceList.TV){
                var crntChannel = liveTV.getCurrentChannelInfo();
                DBG_ERROR("curnChannel.name:"+crntChannel.name);
                UIObserver.publishMessage(UIObserver.MESSAGE_NAME.CURRENT_CHANNEL_CHANGED, crntChannel);
            }else{
                DBG_ERROR("other source send message " + mapInputsDataById(crntSourceObj.id));
                UIObserver.publishMessage(UIObserver.MESSAGE_NAME.CURRENT_SOURCE_CHANGED, mapInputsDataById(crntSourceObj.id));
            }
        }
    }
}

//---------------------b2b start---------------------//
function loadB2BModule(){
    try{
        b2bModuleParaInit();
        if(B2BPara.GHASB2B){
            $LAB.script("module/b2bCommandHandle.js");
        }
    }catch(ex){DBG_ERROR(ex.stack)}
}

function b2bKeyHandle(key, b2bKey){
    try{
        var b2bKeyInfo = {};
        b2bKeyInfo.keyCode = UI.keyCode;
        if(!!b2bKey){
            b2bKeyInfo.from ='rs232'
        }
        switch (key.state){
            case 1:
                b2bKeyInfo.state = 'down';
                break;
            case 2:
                b2bKeyInfo.state = "repeat";
                break;
            default :
                b2bKeyInfo.state = "up";
                break;
        }
        if(b2bKeyInfo.state =="down"){
            DBG_ERROR('g_hasB2B:'+B2BPara.GHASB2B+',b2bDisableKey:'+B2BPara.B2BDISABLEKEY);
        }
        if(!!B2BPara.GHASB2B&&b2bKeyDisableDispatch(b2bKeyInfo,B2BPara.B2BDISABLEKEY)==true){
            if(b2bKeyInfo.state =="down"){
                DBG_ERROR('b2bDisableKey');
            }
            UI.sendKeyResult(key, true);
            return true;
        };
    }catch(ex){DBG_ERROR(ex.message)}
}

function initDefIndexArray(){
    var defData={
        "PowerOnFixed":{defIndex:1},
        "232cPowOn":{defIndex:0},
        'PanelButton':{defIndex:0},
        "RcPathThrough":{defIndex:0},
        'RcButton':{defIndex:0},
        "MenuButton":{defIndex:0},
        "LoudSpeaker":{defIndex:0},
        "VolumeFixed":{defIndex:1},
        "maxVolume":{defIndex:100},
        "VolumeFixLevel":{defIndex:100},
        "AvPositionFixed":{defIndex:1},
        "OnScreenDisplay":{defIndex:0},
        "InputModeStart":{defIndex:0},
        "InputModeFixed":{defIndex:1},
        "UsbBehavior":{defIndex:0},
        "PixelShifting":{defIndex:0},
        "FunctionMode":{defIndex:1}
    };
    var keysArray=Object.keys(defData);
    B2BPara.defDataStructKeys=keysArray;
    for(var i=0;i<keysArray.length;i++){
        B2BPara.defIndexArray.push(defData[keysArray[i]].defIndex)
    }
    DBG_ALWAYS(objToString(B2BPara.defIndexArray));
}

initDefIndexArray();
//B2BPara.defIndexArray=[1,0,0,0,0,0,1,1,100,100,1,0,0,1,0,1];//default index for reset :del PixelShifting index

function openB2BModule(){
    UI.pushSubModule(B2BPara.MAIN,B2BPara.FUNCTIONMN,true);
}

function closeB2BModule(){
    UI.clearAllSubModule(B2BPara.MAIN);
}

function initScreenOffFlagState(){
    try{
        var state=tv?model.b2b.getScreenDisplayEnable():false;
        if(!!state){
            B2BPara.SCREENOFFFLAG=true
        }else{
            B2BPara.SCREENOFFFLAG=false;
        }
    }catch(ex){DBG_ERROR('initScreenOffFlagState is error:'+ex.message)}
}

function initPageDefData(){
    var pageDefData={};
    for (var i=0;i<B2BPara.defDataStructKeys.length;i++){
        pageDefData[B2BPara.defDataStructKeys[i]]={}
    }
    for (var drp in pageDefData){//init local default Data
        pageDefData[drp]={index:0,disable:false,disableItemFirstRunFlag:false}
    }
    return pageDefData;
}

function initB2bPanelBntAndRcBntHandler(){
    if(tv&&!!B2BPara.GHASB2B){
        if(model.b2b.getMenuButton()==1||model.b2b.getRcButton()==1){
            B2BPara.B2BDISABLEKEY=true;
        }else{
            B2BPara.B2BDISABLEKEY=false;
        }
        model.b2b.onMenuButtonChaged = onMenuButtonChaged;
        model.b2b.onRcButtonChaged = onRcButtonChaged;
    }
}

function onMenuButtonChaged(index){
    B2BPara.B2BMENUBUTTON=index;
    b2bDisableKeyHandler();
}

function onRcButtonChaged(index){
    B2BPara.B2BRCBUTTON=index;
    b2bDisableKeyHandler();
}

function b2bDisableKeyHandler(){
    if(B2BPara.B2BMENUBUTTON==1||B2BPara.B2BRCBUTTON==1){
        B2BPara.B2BDISABLEKEY=true;
    }else{
        B2BPara.B2BDISABLEKEY=false;
    }
}

function onScreenDisplay(index){
    try{
        if(tv){
            if(index==0){//display yes
                model.b2b.setScreenDisplayEnable(index);
                B2BPara.SCREENOFFFLAG=false;
                //model.system.setEnumScreenState(1);
                DBG_ALWAYS("On the screen");
            }else{//display no
                model.b2b.setScreenDisplayEnable(index);
                B2BPara.SCREENOFFFLAG=true;
                //model.system.setEnumScreenState(0);
                DBG_ALWAYS("Off the screen");
            }
        }
    }catch(ex){DBG_ERROR('onScreenDisplay is error'+ex.message)}

}

function exeSendDefIndexToBm(pageDefData,which){
    if(!tv){return;}
    try{
        DBG_ERROR("exeSendDefIndexToBm start");
        model.b2b.setPwrOnFixed(pageDefData.PowerOnFixed.index);
        model.b2b.setRs232PwrOn(pageDefData["232cPowOn"].index);
        model.b2b.setPanelButton(pageDefData.PanelButton.index);
        model.b2b.setRcPassThroughEnable(pageDefData.RcPathThrough.index);
        model.b2b.setRcButton(pageDefData.RcButton.index);
        model.b2b.setMenuButton(pageDefData.MenuButton.index);
        model.sound.setSpeakerArc(pageDefData.LoudSpeaker.index);
        model.b2b.setVolumeFixedMode(pageDefData.VolumeFixed.index);
        model.b2b.setMaxVolume(pageDefData.maxVolume.index);
        if(which==B2BPara.funMenu){
            if(pageDefData.VolumeFixed.index==1){
                model.b2b.setVolumeFixedLevel(pageDefData.maxVolume.index);
            }else{
                model.b2b.setVolumeFixedLevel(pageDefData.VolumeFixLevel.index);
            }
        }else{
            model.b2b.setVolumeFixedLevel(pageDefData.VolumeFixLevel.index);
        }
        model.b2b.setAvPositionFixed(pageDefData.AvPositionFixed.index);
        onScreenDisplay(pageDefData.OnScreenDisplay.index);
        model.b2b.setInputSourceId(pageDefData.InputModeStart.index);
        model.b2b.setUsbBehavior(pageDefData.UsbBehavior.index);
        model.b2b.setFunctionModeEnable(pageDefData.FunctionMode.index);
       // model.video.setPixShift(pageDefData.PixelShifting.index);
        model.b2b.setInputSourceMode(pageDefData.InputModeFixed.index);
        DBG_ERROR("exeSendDefIndexToBm finish");
    }catch(ex){DBG_ERROR('exeSendDefIndexToBm is error:'+ex.message)}

}

function b2bModuleParaInit(){
    try{
        B2BPara.GHASB2B = hasB2BorNot();
        if(B2BPara.GHASB2B){
            initG_MaxVolume();
        }
        DBG_ALWAYS('g_hasB2B:'+B2BPara.GHASB2B);
        if(!!B2BPara.GHASB2B){
            initB2bPanelBntAndRcBntHandler();
            initScreenOffFlagState();
        }
    }catch(ex){DBG_ERROR('b2bModuleParaInit is error:'+ex.stack)}
}

function b2bMaxVolOnChg(value){
    try{
        B2BPara.GMAXVOLUE=value;
        liveTV.setMaxVolume(B2BPara.GMAXVOLUE);
        DBG_ALWAYS('MaxVolume change g_maxvolue is:'+B2BPara.GMAXVOLUE);
    }catch(ex){DBG_ERROR('b2bMaxVolOnChg is error:'+ex.message)}
}

function hasB2BorNot(){
    try{
        if(tv){
            return model.hisfactory.getB2Bmode()==0?true:false;
        }else{
            return false;
        }
    }catch(ex){DBG_ERROR('hasB2BorNot is error:'+ex.message)}

}

function initG_MaxVolume(){
    try{
        if(B2BPara.GHASB2B&&tv){
            B2BPara.GMAXVOLUE=model.b2b.getMaxVolume();
            model.b2b.onRs232MaxVolumeChaged=b2bMaxVolOnChg;
        }else{
            B2BPara.GMAXVOLUE=100;
        }
        liveTV.setMaxVolume(B2BPara.GMAXVOLUE);
        DBG_ALWAYS('initG_MaxVolume');
        DBG_ALWAYS('g_maxvolue:'+B2BPara.GMAXVOLUE);
    }catch(ex){DBG_ERROR('initG_MaxVolume is error:'+ex.message)}
}

function b2bVolumeCtrlNoResponse(){
    try{
        DBG_ALWAYS('g_hasB2B is :'+B2BPara.GHASB2B+"g_maxvolue is"+B2BPara.GMAXVOLUE);
        //if(B2BPara.GHASB2B && model.sound.getSpeakerDevice()==0) {
        //    return true;
        //}
        if(B2BPara.GHASB2B&&model.b2b.getVolumeFixedMode()==0){
            return true;
        }
        return false;
    }catch(ex){DBG_ERROR(ex.message)}
}

function b2bkeyPadDisableOkForPowerOnFixed(){
    try{
        if(!!B2BPara.GHASB2B&&tv&&(model.b2b.getPwrOnFixed()==0)){
            return true;
        }else{
            return false;
        }
    }catch(ex){DBG_ERROR('b2bKapMenuDisableEnter:'+ex.message)}
}

function MixBarForB2bInputModeFixed(){
    try{
        if(hasB2BorNot()==false){
            return;
        }
        if(b2bkeyPadDisableOkForPowerOnFixed()){
            MixBarData.mixBar_power_content.disable = true;
        }
        else {
            MixBarData.mixBar_power_content.disable = false;
        }
        MixBarData.mixBar_Item.disableItem=[];
        if(model.b2b.getInputSourceMode()==1){
            return;
        }
        var CurrentUseSource = tv ? model.source.getCurrentSource() : 0;
        $.each(MixBarData.operateData.source, function (k, v) {
            if (v.id != CurrentUseSource) {
                MixBarData.mixBar_Item.disableItem.push(k);
            }
        });

    }
    catch (ex){
        DBG_ERROR(ex.message);
    }

}

//---------------------b2b end---------------------//

//-------------------------b2b function paga init---------------//
function b2bKeyDisableDispatch(b2bKeyInfo,flag){
    b2bKeySwitchFun(b2bKeyInfo);
    var disPatchKey=[CONST.KEY.VK_KEYPAD_VOLUME_UP,CONST.KEY.VK_KEYPAD_VOLUME_DOWN,CONST.KEY.VK_KEYPAD_CHANNEL_UP,
        CONST.KEY.VK_KEYPAD_CHANNEL_DOWN,CONST.KEY.VK_KEYPAD_MENU,CONST.KEY.VK_KEYPAD_INPUT];
    if(b2bKeyInfo.state=='down') {
        DBG_ERROR('funMenuPageShow:'+B2BPara.FUNMENUPAGESHOW);
    };
    if(b2bKeyInfo.from=='rs232'){
        return false;// dispatch cmd from rs232
    }
    if(disPatchKey.indexOf(b2bKeyInfo.keyCode)!=-1){
        return false;
    }
    if(!B2BPara.FUNMENUPAGESHOW&&!!flag){
        return true;
    }else{
        return false;
    }
}
function b2bKeySwitchFun(b2bKeyInfo){
    try{
        if(b2bKeyInfo.state!='down') {
            return;
        }
        switch (b2bKeyInfo.keyCode){
            case CONST.KEY.VK_ZERO:b2bKeyVectorAdd0();
                break;
            case CONST.KEY.VK_ONE:b2bKeyVectorAdd1();
                break;
            case CONST.KEY.VK_TWO:clearB2bKeyVector();
                break;
            case CONST.KEY.VK_THREE:b2bKeyVectorAdd3();
                break;
            case CONST.KEY.VK_FOUR:clearB2bKeyVector();
                break;
            case CONST.KEY.VK_FIVE:clearB2bKeyVector();
                break;
            case CONST.KEY.VK_SIX:clearB2bKeyVector();
                break;
            case CONST.KEY.VK_SEVEN:b2bKeyVectorAdd7();
                break;
            case CONST.KEY.VK_EIGHT:clearB2bKeyVector();
                break;
            case CONST.KEY.VK_NINE:clearB2bKeyVector();
                break;
            case CONST.KEY.VK_MENU:b2bKeyVectorAddMenu();
                break;
            default :
                break;
        }
    }catch(ex){DBG_ERROR("b2bKeySwitchFun is error:"+ex.message)}

}
var b2bKeyVector = [];
function b2bKeyVectorAddMenu() {
    if (b2bKeyVector.length >= 5) {
        b2bKeyVector.shift();
    }

    b2bKeyVector.push({key: "Menu", time: new Date().getTime()});

    DBG_INFO("b2bKeyVector " + JSON.stringify(b2bKeyVector));
}
function b2bKeyVectorAdd7() {
    if (b2bKeyVector.length >= 5) {
        b2bKeyVector.shift();
    }

    b2bKeyVector.push({key: "7", time: new Date().getTime()});

    DBG_INFO("b2bKeyVector " + JSON.stringify(b2bKeyVector));
}
function b2bKeyVectorAdd3() {
    if (b2bKeyVector.length >= 5) {
        b2bKeyVector.shift();
    }
    b2bKeyVector.push({key: "3", time: new Date().getTime()});

    DBG_INFO("b2bKeyVector " + JSON.stringify(b2bKeyVector));
}
function b2bKeyVectorAdd1() {
    if (b2bKeyVector.length >= 5) {
        b2bKeyVector.shift();
    }
    b2bKeyVector.push({key: "1", time: new Date().getTime()});
    DBG_INFO("b2bKeyVector " + JSON.stringify(b2bKeyVector));
}
function b2bKeyVectorAdd0() {
    if (b2bKeyVector.length >= 5) {
        b2bKeyVector.shift();
    }
    b2bKeyVector.push({key: "0", time: new Date().getTime()});
    DBG_INFO("b2bKeyVector " + JSON.stringify(b2bKeyVector));

    if (b2bKeyVector.length >= 5&&B2BPara.GHASB2B) {
        if (b2bKeyVector[0].key=='Menu'&&b2bKeyVector[1].key==7&&b2bKeyVector[2].key==3&& b2bKeyVector[3].key==1&& b2bKeyVector[4].key==0) {
            if (b2bKeyVector[4].time - b2bKeyVector[0].time <= 5000) {
                DBG_INFO("enter functionMenuPage");
                try {
                    UI.popAllModule();
                    openB2BModule();
                } catch (ex) {
                    DBG_ERROR(ex.message);
                }
            } else {
                DBG_INFO("b2bKeyVector is OK, but TimeOutT");
            }
            b2bKeyVector = [];
        }
    }
}
function clearB2bKeyVector() {
    try {
        DBG_ERROR("beforeClear " + JSON.stringify(b2bKeyVector));
        b2bKeyVector = [];
        DBG_ERROR("AfterClear " + JSON.stringify(b2bKeyVector));
    } catch (ex) {
        debugE(ex.message);
    }
}
function b2bVideoControlKeyNoDispatch(keyCode){
    try{
        var disableDispatch=false;
        var disableDispatchKeyArray=[CONST.KEY.VK_PAUSE,CONST.KEY.VK_PLAY,CONST.KEY.VK_TRACK_PREV,CONST.KEY.VK_TRACK_NEXT,
            CONST.KEY.VK_FAST_FWD,CONST.KEY.VK_FAST_BKW,CONST.KEY.VK_STOP,CONST.KEY.VK_UP,CONST.KEY.VK_DOWN,CONST.KEY.VK_LEFT,
            CONST.KEY.VK_RIGHT,CONST.KEY.VK_ENTER];
        if(-1!=disableDispatchKeyArray.indexOf(keyCode)){
            disableDispatch=true;
            DBG_ERROR('before keyboard.send_key_to_dfb:'+keyCode+",disableDispatch:"+disableDispatch);
            for(var dp in CONST.KEYCODE_MAP){
                if(CONST.KEYCODE_MAP.hasOwnProperty(dp)&&CONST.KEYCODE_MAP[dp]==keyCode){
                    keyCode=dp;
                    break;
                }
            }
            DBG_ERROR('keyboard.send_key_to_dfb(keyCode)'+keyCode);
            guijs.send_key_to_dfb(keyCode);//
            return disableDispatch;
        }else{
            disableDispatch=false;
            return disableDispatch;
        }

    }catch(ex){DBG_ERROR('switch keyCode is error:'+ex.message); return false;}
}

//-------------------------b2b function paga end---------------//


var B2B_PowerOnFixed_Flag=1;

function SetB2BPowerOnFixed(value){
    DBG_ERROR("SetB2BPowerOnFixed:"+value);
    B2B_PowerOnFixed_Flag = value;
}

function GetB2BPowerOnFixed(){
    DBG_ERROR("B2B_PowerOnFixed_Flag:"+B2B_PowerOnFixed_Flag);
    return B2B_PowerOnFixed_Flag;
}

var resume_dtv_timer = 0;
var pause_dtv_timer = 0;
function resumeDTV(delay) {
    if(GLOBAL.TV_SUSPENDING || !tv) return;
    clearTimeout(resume_dtv_timer);
    clearTimeout(pause_dtv_timer);
    if(null == delay){
        DBG_ERROR("resumeDTV");
        model.tvservice.setPlayMainPause(0);
    }
    else{
        resume_dtv_timer = setTimeout(function(){
            DBG_ERROR("resumeDTV");
            model.tvservice.setPlayMainPause(0);
        }, delay);
    }
}
function pauseDTV(delay) {
    if(!tv) return;
    clearTimeout(pause_dtv_timer);
    clearTimeout(resume_dtv_timer);
    if(null == delay){
        DBG_ERROR("pauseDTV");
        model.tvservice.setPlayMainPause(1);
    }
    else{
        pause_dtv_timer = setTimeout(function(){
            DBG_ERROR("pauseDTV");
            model.tvservice.setPlayMainPause(1);
        }, delay);
    }
}
function pauseHBBTV() {
//    sendAM(":am,hbbtv,:pause=hbbtv",
//        "opera4x","pause","source:hbbtv");
}
function resumeHBBTV() {
//    sendAM(":am,hbbtv,:resume=hbbtv",
//        "opera4x","resume","source:hbbtv");
}
function stopHBBTV(direct) {
//    sendAM(":am,am,:stop=hbbtv",
//        "opera4x","stop","source:hbbtv");
}
function startHBBTV() {
//    sendAM(":am,am,:start=hbbtv",
//        "opera4x","start","source:hbbtv");
}
function StartAnyViewCast() {
    try {
        if (checkIsAppOn()) {
            DBG_ERROR("StartAnyViewCast:app is not stop,stop it then start anyviewcast");
            appControl.stopCurrentApp();
            appStoppedFunc = function () {
                StartAnyViewCast();
                appStoppedFunc = null;
            };
            return;
        }
        UI.pushSubModule("miracast", "miracastMain", true);
        UI.base.cursor.alpha = 0;
        pauseDTV();
        if (tv) {
            model.miracast.ActionStartApp();
            setTimeout(function(){
                DBG_INFO("StartAnyViewCast:miracast started");
                model.source.appStatusSet("miracast","started");
            },500);
        }


    }
    catch (ex) {
        DBG_ERROR(ex.message);
    }

    // anyviewcast is source, so starting anyviewcast, need clear ott.txt
    DBG_INFO("start anyviewcast need clear ott")
    var obj = {
        "name":0,
        "url":0
    };
    writeFileToNative("launcher/ott.txt",objToString(obj), 1);

}

function calculatePercent(start, current, end) {
    if (0 == end - start || current - start <= 0) return 0;
    return Math.floor((current - start) / (end - start) * 100);
}


function openMsgBoxByType(t){
    if(!!t&&t==MsgBoxType.DEVICE_CONNECTED){
        if(UI.checkFuncQueueValue(openMsgBox,MsgBoxType.DEVICE_CONNECTED)||isModuleOpened(COMMON.MAIN))
        {   DBG_INFO("Drop this usb tip.");
            return false;
        }
    }
    UI.addToFuncQueue(openMsgBox, t);
}

function openMsgBox(t, param){
    GLOBAL.MSG_BOX_TYPE = t;
    if(GLOBAL.MSG_BOX_TYPE==MsgBoxType.ACR_TIP&&
        (model.system.getUserMode()!=0||GLOBAL.TTS||(!isCurCountryhasACR())))
    {
        DBG_ERROR("state error, do not pop the acr dialog")
       return;
    }
    if(checkLiveTVState()) UI.clearAllSubModule();
    //UI.pushModule(COMMON.MAIN);
    switch (GLOBAL.MSG_BOX_TYPE) {
        case MsgBoxType.DEVICE_CONNECTED:
            //    Message box.
            if (!cancelPopupDialog()) {
                //add a timer to push deviceConnect page to fix MSD6586US-6040
                setTimeout(function () {
                    UI.pushSubModule(COMMON.MAIN, COMMON.DEVICE_CONNECTED, true);
                }, 0);
            }else{
                GLOBAL.MSG_BOX_TYPE = MsgBoxType.NONE;
            }
            break;
        case MsgBoxType.DLNA_DIALOG:
            UI.pushSubModule(COMMON.MAIN, COMMON.DLNA_DIALOG, true, param);
            break;
        case MsgBoxType.DLNA_DIALOG2:
            UI.pushSubModule(COMMON.MAIN, COMMON.DLNA_DIALOG2, true, param);
            break;
        case MsgBoxType.STANDBY_TIP:
            UI.pushSubModule(COMMON.MAIN, COMMON.AUTO_STANDBY, true);
            break;
        case MsgBoxType.NETWORK_TIP:
            UI.pushSubModule(COMMON.MAIN, COMMON.NETWORK_TIP, true, {caller: param});
            break;
        case MsgBoxType.HEADPHONE_TIP:
            UI.pushSubModule(COMMON.MAIN, COMMON.HEADPHONE_MODE, true);
            break;
        case MsgBoxType.EULA:
            UI.pushSubModule(COMMON.MAIN, COMMON.EULA, true);
            break;
        case MsgBoxType.COMMON_DIALOG:
            UI.pushSubModule(COMMON.MAIN, COMMON.COMMON_DIALOG, true, null, param);
            break;
        case MsgBoxType.ACR_TIP :
                registerKeyCodesForUI();
                UI.pushSubModule(COMMON.MAIN, COMMON.ACR_TIP, true);
            break;
        case MsgBoxType.AVS_HIS_EXPIRED:
        case MsgBoxType.AVS_AMAZON_EXPIRED:
        case MsgBoxType.AVS_DEVICE_REPLACE:
        case MsgBoxType.AVS_DEVICE_DUPLICATE:
        case MsgBoxType.AVS_DEVICE_DEREGISTERED:
            UI.pushSubModule(COMMON.MAIN, COMMON.AVS_DIALOG, true, t);
            break;
        default :
            break;
    }
}

function closeMsgBox(){
    var originModule = common.getOriginModule();
    UI.popSubModule();
    if(null == originModule) return false;
    if(UI.getCurrModule().name == "common") return false;
    DBG_ALWAYS("closeMsgBox  originModule.name = "+originModule.name);
    switch (originModule.name){
        case "base":
            registerKeyCodesForApp();
            break;
        case LIVETV.MAIN:
            openLiveTVModule();
            break;
        //case "launcher":
        //    UI.focusTo(originModule.currFocus);
        //    break;
        default :
            break;
    }
}

function onStandbyTipChanged(val) {
    DBG_ERROR("onStandbyTipChanged "+val);
    if(val==0){
        return;
    }
    var cancelStandby = Config.tv &&
        (1 == GLOBAL.FACTORY ||
        1 == model.channelSearch.getRunning()||
        0!= model.system.getUserMode())
       // 1 == model.hotel.getHotelMode() && 0 == model.hotel.getAutoSleep());
    if (cancelStandby) {
        if (StandbyFlag.HOTELMODE_SLEEP == val) model.timerfunc.setHotelmodeSleepTimer(0);
        if (StandbyFlag.STANDBY_TIME == val) {
            if( 1==model.timerfunc.getStandbyMode()){
                model.timerfunc.setStandbyMode(0);
            }
        }
    }
    else {
        DBG_INFO("standby tip: " + val);
        GLOBAL.STANDBY_FLAG = parseInt(val);
        if(GLOBAL.STANDBY_FLAG >0)
        {
            openMsgBoxByType(MsgBoxType.STANDBY_TIP);
        }

    }
}

function getWizardSetFlag() {   //1 facotry ok or setting->reset, 3 setting->wizard
    if (tv == false) {
        if (!!localStorage.getItem("wizardSetFlag")) {
            return parseInt(localStorage.getItem("wizardSetFlag"));
        }
        else {
            localStorage.setItem("wizardSetFlag", 1);
            return 1;
        }
    }
    else {
        try {

            var wizardSetFlag = model.system.getFteshow();
            DBG_INFO("getWizardSetFlag: model.system.getFteshow() = " + wizardSetFlag);
            return wizardSetFlag;
        }
        catch (ex) {
            DBG_ERROR("getWizardSetFlag: " + ex.message);
        }
    }

}
function setWizardSetFlag(flag) {
    if (tv == false) {
        localStorage.setItem("wizardSetFlag", flag);
    }
    else {
        model.system.setFteshow(flag);
        DBG_ERROR("model.system.setFteshow is " + model.system.getFteshow());
    }
}

function isModuleOpened(module){
    return module == UI.getCurrModule().name;
}
function isChScanSubModuleOpened(){
    try {
        return (UI.getCurrSubModule().name =="ChAutoScanPanel")||(UI.getCurrSubModule().name=="ChManualScanPanel"); //自动搜台、手动搜台屏蔽弹出框
    }
    catch (ex) {
        DBG_ERROR("isChScanSubModuleOpened: " + ex.message);
    }
}
function cancelPopupDialog() {
    try {

        var cancelPopup =
            isModuleOpened("FTE") ||
            isModuleOpened("hiMedia")||
            isModuleOpened(APPMODULE.MAIN) ||
            isModuleOpened(COMMON.MAIN) ||
            isModuleOpened(APPNAME.DLNA) ||
            isModuleOpened("launcher") ||
            !!(model.hisfactory.getStateOpen())||
            checkAppStarted(APPNAME.EPOS) ||
            (startEposFlag == true) ||
            checkIsAppOn() ||
            checkLiveTVState(LIVETV.OPERATE_TIP) ||
            isChScanSubModuleOpened();
        DBG_INFO("cancel_pop = " +cancelPopup);
        return cancelPopup;
    }
    catch (ex){
        DBG_ERROR(ex.message);
        return true;
    }
}

function onUsbDeviceChanged(val){
    DBG_ERROR("usb changed: " + objToString(val));
    //dbtag:20160920-popup a media window when plugin USB disk
    if (val[1].indexOf("FSL2") != -1 ) {
      if (VolumeModelDefines.ENUM_SL2_TVAPI_VOLUME_ADDED == val[0]) {
          GLOBAL.CURRENT_DEVICE_NAME = val[2];
          if(!(val[val.length-1]==0)){
              g_notificationCrtTimeStamp = getSystemLongTimeForNotification();
          }

        if(cancelPopupDialog()||val[9]==0) return;
        var currentB2BState = model.b2b.getUsbBehavior();
        if(!!currentB2BState){
            UI.popAllModule();
            UI.pushModule("hiMedia", {caller: "DS"});
        }else {
            openMsgBoxByType(MsgBoxType.DEVICE_CONNECTED);
        }
      }
      else if(VolumeModelDefines.ENUM_SL2_TVAPI_VOLUME_REMOVED == val[0]){
          GLOBAL.CURRENT_DEVICE_NAME = "";
          g_notificationTimeStamp = getSystemLongTimeForNotification();
          UI.deleteFuncQueue(openMsgBox,MsgBoxType.DEVICE_CONNECTED);
          if (MsgBoxType.DEVICE_CONNECTED == GLOBAL.MSG_BOX_TYPE) {
            closeMsgBox();
          }
          //增加拔U盘时的toast
          try{
            if (!checkIsAppOn(APPNAME.NETFLIX) && (model.system.getNotificationSwitch()!=0)){
                GLOBAL.CURRENT_TOAST_TYPE = TOASTTYPE.REMOVE_HDD;
                UI.pushGhostModule("setting", "SettingSysToast");
            }
          }
          catch(ex){
            DBG_ERROR(ex.message);
          }
        //deletelauncherNotification();
      }
   }
}

function onLanguageChanged(value){

    DBG_ALWAYS("onLanguageChanged "+value);
    var code=ChangeLangNumToCode(value);
    UI.changeLanguage(code);
    setTimeout(function(){
        modeljs.sendAppMessage("opera4x",'{"type":"APPMessage","source":"launcher","status":"changeLanguage"}');
    }, 100);
    DBG_ALWAYS("onLanguageChanged "+code);
    //if(code=="spa"){
    //    tv ? model.tts.setI32LangIdx(1):1;//set tts language for spa
    //}
    //if(code=="eng"){
    //    tv ? model.tts.setI32LangIdx(0):1;//set tts language for eng
    //}
    if(tv){   //判断tts是否打开
        GLOBAL.TTS = isTtsPlay();
    }

}

function  onCountryCodeChanged(value){
    try
    {
        DBG_ERROR("onCountryChanged"+ value );
        if (AVSClient) {
            AVSClient.setting.syncVoiceSupportType();
        };
    }catch (e)
    {
    DBG_ERROR(e.message)
    }
}
function onMenuTimeoutChanged(value){
    DBG_ALWAYS("onMenuTimeoutChanged "+value);
    UI.setSettingMenuTimeout();
}

function onNetworkStatusChanged(value){
    if(!!value){
        if(value == 1){
            DBG_INFO("[onNetworkStatusChanged]value:" + value);
            if(!!HOTKEY_TIMEOUT.VUDUTIMEOUT){
                clearTimeout(HOTKEY_TIMEOUT.VUDUTIMEOUT);
                HOTKEY_TIMEOUT.VUDUTIMEOUT=null;
                try{
                    UI.popGhostModule(APPMODULE.WAITING);}
                catch (ex){
                    DBG_ERROR(ex.message);
                }
                DBG_ALWAYS("start VUDU on network changed!");
                UI.pushGhostModule(APPMODULE.MAIN, APPMODULE.CONTROL);
//                UI.callTTS("[SE0739]",0);
                openAppControl(APPNAME.VUDU, APPNAME.VUDU, CMDType.NATIVEAPP, CMDMethod.STARTUP, false, null);
            }
            if(!!HOTKEY_TIMEOUT.YOUTUBETIMEOUT){
                clearTimeout(HOTKEY_TIMEOUT.YOUTUBETIMEOUT);
                HOTKEY_TIMEOUT.YOUTUBETIMEOUT=null;
                try{
                    UI.popGhostModule(APPMODULE.WAITING);}
                catch (ex){
                    DBG_ERROR(ex.message);
                }
                DBG_ALWAYS("start YOUTUBE on network changed!");
                UI.pushGhostModule(APPMODULE.MAIN, APPMODULE.CONTROL);
                UI.callTTS("[LA0015]",0);
                openAppControl(APPNAME.YOUTUBE, APPNAME.YOUTUBE, CMDType.NATIVEAPP, CMDMethod.STARTUP, false, null);

            }
            if(!!HOTKEY_TIMEOUT.OTT){
                clearTimeout(HOTKEY_TIMEOUT.OTT);
                HOTKEY_TIMEOUT.OTT=null;
                try{
                    UI.popGhostModule(APPMODULE.WAITING);
                }
                catch (ex){
                    DBG_ERROR(ex.message);
                }
                DBG_ERROR("start OTT on network changed!");
                UI.pushGhostModule(APPMODULE.MAIN, APPMODULE.CONTROL);
                openAppControl(APPNAME.OTT, APPNAME.OTT, CMDType.NATIVEAPP, CMDMethod.STARTUP, false, null);

            }
            if(!!HOTKEY_TIMEOUT.AMAZONTIMEOUT){
                clearTimeout(HOTKEY_TIMEOUT.AMAZONTIMEOUT);
                HOTKEY_TIMEOUT.AMAZONTIMEOUT=null;
                try{
                    UI.popGhostModule(APPMODULE.WAITING);}
                catch (ex){
                    DBG_ERROR(ex.message);
                }
                DBG_ALWAYS("start AMAZONRUBY on network changed!");
                UI.pushGhostModule(APPMODULE.MAIN, APPMODULE.CONTROL);
                openAppControl(APPNAME.AMAZON, APPNAME.AMAZON, CMDType.NATIVEAPP, CMDMethod.STARTUP, false, null);
            }


            try{
                if(value == NetWorkConnect.CONNECT){
                    var networkConfig = tv?readFileFromNative('networkConfig.txt', 1):null;
                    if(networkConfig == null){
                        var info = {"netwok":1,"dlna":0};
                        if(tv)writeFileToNative("networkConfig.txt", objToString(info), 1);
                    }else{
                        if(networkConfig.netwok == 0){
                            networkConfig.netwok = 1;
                            if(tv)writeFileToNative("networkConfig.txt", objToString(networkConfig), 1);
                        }
                    }
                }
            }
            catch (ex){
                DBG_ERROR(ex.message);
            }
        }
    }
    if (!!AVSClient) {
        AVSClient.setting.notifyNetworkChanged(value);
    }
}

function registerKeyCodesForUI(){
    if(null != UI.getGhostModule(APPMODULE.CONTROL)) {
        UI.registerKeyCodes(null);
        UI.setKeyGroup(7);
    }
}

function registerKeyCodesForApp(){
    var appGhost = UI.getGhostModule(APPMODULE.CONTROL);
    if(null != appGhost) appControl.focusCurrentApp();
    else openLiveTVModule([Msg.INFO, 0]);
}

function isTtsPlay(){
    if(tv){
     var  flag = model.tts.getI32SwitchStatus();
    }else{
        var  flag = true;
    }
    return flag;
}

function SettingGetApplist()
{
    try {
        var applist=[];
        var ret = readFileFromNative("launcher/settingappinfo.txt", 1);
        DBG_INFO("read applist fie ret  " + ret + typeof ret);
        if(null != ret)
        {
            for(var i=0;i<ret.length;i++)
            {
                ret[i]=ret[i].replace(/\s+/g,"");
                if(ret[i].toLowerCase()=="netflix"||ret[i].toLowerCase()=="vudu")
                {
                    applist.push(ret[i].toLowerCase())
                }
            }
        }
        else
        {
            getAllAppDataForSetting();
            var ret1 = readFileFromNative("launcher/settingappinfo.txt", 1);
            DBG_INFO("read applist fie ret  " + ret1 + typeof ret1);
            if(null != ret1)
            {
                for(var i=0;i<ret1.length;i++)
                {
                    ret1[i]=ret1[i].replace(/\s+/g,"");
                    if(ret1[i].toLowerCase()=="netflix"||ret1[i].toLowerCase()=="vudu")
                    {
                        applist.push(ret1[i].toLowerCase())
                    }
                }
            }

        }
        DBG_INFO("get the applist "+ JSON.stringify(applist));
        return applist;
    } catch (ex) {
        DBG_ERROR(ex.message);
         applist=[];
        return applist;
    }

}
var remoteAppTimer = null;
function openLiveTVModule(msgFlag) {
    DBG_INFO("openLiveTVModule start " + new Date().getTime());
    if(StrDef.UNDEFINED == typeof (liveTV)){
        UI.pushModule(LIVETV.MAIN);
    }
    else {
        liveTV.setMsgFlag(msgFlag);
        clearTimeout(remoteAppTimer);
        //原因是切换source或者换台后数据拿不到
        remoteAppTimer = setTimeout(function(){liveTV.remoteAppFunc("openLiveTVModule");},500);
        UI.pushSubModule(LIVETV.MAIN, LIVETV.CONTROL, true);
        if (!liveTV.getInitedFlag()) return;
        liveTV.showLiveTVUI();
    }
    DBG_INFO("openLiveTVModule end " + new Date().getTime());
}

var usbRegTimer = 0;
function registerUSBNotify(){
    clearTimeout(usbRegTimer);
    usbRegTimer = setTimeout(function(){
        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.USB_DEVICE_CHANGED, onUsbDeviceChanged);

        getUsbDiskList();
    }, 30000);
}

var DISKIterator = null;
var DiskList =[];
var getUsbDiskList = function () {
    DBG_INFO("getUsbDiskList");
    DiskList =[];
    if (Config.tv) {
        try {
            DISKIterator = new TableIterator(
                model.volume.createTableMainIterator,
                true,
                [
                    {
                        field: VolumeModelDefines.ENUM_SL2_TVAPI_VOLUME_TABLE_FIELD_STATE,
                        condition: Model.FIELD_COND_EQUAL,
                        value: VolumeModelDefines.ENUM_SL2_TVAPI_VOLUME_STATE_CONNECTED
                    }
                ],
                [
                    VolumeModelDefines.ENUM_SL2_TVAPI_VOLUME_TABLE_FIELD_ID,
                    VolumeModelDefines.ENUM_SL2_TVAPI_VOLUME_TABLE_FIELD_NAME,
                    VolumeModelDefines.ENUM_SL2_TVAPI_VOLUME_TABLE_FIELD_TYPE,
                    VolumeModelDefines.ENUM_SL2_TVAPI_VOLUME_TABLE_FIELD_STATE,
                    VolumeModelDefines.ENUM_SL2_TVAPI_VOLUME_TABLE_FIELD_SUBSTATE,
                    VolumeModelDefines.ENUM_SL2_TVAPI_VOLUME_TABLE_FIELD_PURPOSE
                ],
                [
                    { field: VolumeModelDefines.ENUM_SL2_TVAPI_VOLUME_TABLE_FIELD_NAME, direction: 1 }
                ],
                onVolumeMainIteratorEvent.bind(this,VolumeModelDefines.SL2_TVAPI_VOLUME_FSAL2_MEDIA_TYPE_HDD)
            );
        }
        catch (e) {
            DBG_ERROR(e.message);
        }
    } else {
        DiskList[0] = {path: "/mnt/usb/sda1/", name: ""};
        DiskList[1] = {path: "/mnt/usb/sdb1/", name: "yangcheng3"};
        DiskList[2] = {path: "/mnt/usb/sdc1/", name: "lalala"};
        DiskList[3] = {path: "/mnt/usb/sdd1/", name: null};
    }
};
var onVolumeMainIteratorEvent = function(deviceType,event){
    DBG_ERROR("onVolumeMainIteratorEvent event = " + objToString(event));
    switch (event.type) {
        case TableIterator.EVENT_TYPE_TOTAL_COUNT:
            if (event.totalCount > 0) {
                DISKIterator.readNextRows(event.totalCount);
            }else{
                DiskList =[];
                DISKIterator.disconnect();
            }
            break;
        case TableIterator.EVENT_TYPE_ROWS_READ:
            if (deviceType == VolumeModelDefines.SL2_TVAPI_VOLUME_FSAL2_MEDIA_TYPE_HDD) {
                if (event.rows.length > 0) {
                    DiskList =[];
                    for (var i = 0; i < event.rows.length; i++) {
                        var tempId = event.rows[i][0];
                        var tempType = event.rows[i][2];
                        var tempName = event.rows[i][1];
                        var tempPurose = parseInt(event.rows[i][5]);
                        DBG_INFO("tempPurose" + tempPurose)
                        if (!tempName) {
                            tempName = "USB " + i;
                        }
                        if ((tempType == VolumeModelDefines.SL2_TVAPI_VOLUME_FSAL2_MEDIA_TYPE_HDD && tempId.indexOf("FSL2") != -1)) {
                            DiskList.push({path: tempId, name: tempName, DiskUUID: tempId.replace("FSL2://",""), deviceType: "usb"});
                        }
                    }
                    DBG_INFO("onVolumeMainIteratorEvent volumesList = " +objToString(DiskList))
                    DISKIterator.disconnect();
                } else {
                    DBG_ERROR("volumesList length less than 0");
                    DISKIterator.disconnect();
                }
            }else{
                //没有usb设备
                DiskList= [];
            }
            break;
    }
}

//str function
function onEnterSuspendChanged(){
    DBG_ERROR("onEnterSuspendChanged:STR started!");
    GLOBAL.DISABLE_MESSAGE = true;
    //if (UI.keyActive) {
        try {
            GLOBAL.WAIT_POWERON = GLOBAL.TV_SUSPENDING = true;
            Hiwebsocket.disconnect();
            clearTimeout(usbRegTimer);
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.USB_DEVICE_CHANGED, onUsbDeviceChanged);
            if (checkIsAppOn()) {
                appControl.setCurrentAMState(AMState.STOPPED);
                appControl.stopCurrentApp();
            }
            UIObserver.publishMessage(UIObserver.MESSAGE_NAME.ENTER_SUSPEND_MODE, 1);
            UIObserver.clearNotifications();
            g_SystemAudioOnlyFlag=0;
            sysUpgradeCancelnotify();
            UI.clearFuncQueue();
            UI.clearEposMenuTimeout();
            //清除一键开机的timeout
            if(!!HOTKEY_TIMEOUT.AMAZONTIMEOUT){
                clearTimeout(HOTKEY_TIMEOUT.AMAZONTIMEOUT);
                HOTKEY_TIMEOUT.AMAZONTIMEOUT=null;
                try{
                    UI.popGhostModule(APPMODULE.WAITING);}
                catch (ex){
                    DBG_ERROR(ex.message);
                }}
            if(!!HOTKEY_TIMEOUT.YOUTUBETIMEOUT){
                clearTimeout(HOTKEY_TIMEOUT.YOUTUBETIMEOUT);
                HOTKEY_TIMEOUT.YOUTUBETIMEOUT=null;
                try{
                    UI.popGhostModule(APPMODULE.WAITING);}
                catch (ex){
                    DBG_ERROR(ex.message);
                }}
            if(!!HOTKEY_TIMEOUT.VUDUTIMEOUT){
                clearTimeout(HOTKEY_TIMEOUT.VUDUTIMEOUT);
                HOTKEY_TIMEOUT.VUDUTIMEOUT=null;
                try{
                    UI.popGhostModule(APPMODULE.WAITING);}
                catch (ex){
                    DBG_ERROR(ex.message);
                }}
            if (UI.isSoftKeyBoard) {
                host.keyboard.onKeyDown({which : 27});
                UI.isSoftKeyBoard = false;
            }

            UI.popAllModule();
//            UI.base.currFocus = UI.base.currSubModule.currFocus = UI.base.blank;

            UI.registerKeyCodes(null);
            UI.setKeyGroup(7);
            //sendAM(":am,am,:stop=opera4x");
        }
        catch (ex){
            DBG_ERROR(ex.stack);
        }
    //    model.system.SwitchOffTvSTR();
    //}
    try{
        if(acrflag){
            AcrJSI.killHamService();
        }
    }catch(e){
        DBG_ERROR("--STR : kill Ham service!!!");
    }
    DBG_ERROR("--STR : UI onEnterSuspendChanged is done!--");
}

function recoverTVState(){
    if(!GLOBAL.WAIT_POWERON) return false;
    GLOBAL.WAIT_POWERON = GLOBAL.TV_SUSPENDING = false;
    GLOBAL.UNLOCKED = false;
    UI.popAllModule();

    var newLanguage = getLanguageCode(GLOBAL.CURRENT_AREA, GLOBAL.CURRENT_SUB_AREA);

    if (GLOBAL.CURRENT_LANGUAGE != newLanguage) {
        GLOBAL.CURRENT_LANGUAGE = newLanguage;
        UI.changeLanguage(GLOBAL.CURRENT_LANGUAGE);
    }

    UI.clearFuncQueue();
    launcher.refreshLauncherData();

    GLOBAL.APP_POWER_ON = getPowerOnType();
    GLOBAL.IS_APP_STR = false;
    GLOBAL.CEC_CONTROL = parseInt(model.cec.getFunctionality());
    GLOBAL.CEC_DEVICE_EXIST = parseInt(model.sound.getArcDevExist());
    GLOBAL.CEC_ARC_STATE = parseInt(model.cec.getHdmiDevicesArcState());

    var cover = Config.tv ? (getWizardSetFlag() != 0) : false;
    if (cover) {
        if(GLOBAL.TTS){
            setTimeout(function(){
                UI.callTTS("[SE0341]",0,false,false);
            },200);
        }
        UI.pushModule("FTE");
        UI.setKeyGroup(7);
        UI.unlockAllKeys("init");
    }
    else if(HOTEKEY_MAP.NONE != GLOBAL.APP_POWER_ON) {
        try{
            DBG_INFO("Start APP with hotkey in STR.");
            GLOBAL.IS_APP_STR = true;
            var appGhost = UI.getGhostModule(APPMODULE.CONTROL);
            switch (HOTEKEY_MAP.APPNAME[GLOBAL.APP_POWER_ON]) {
                case APPNAME.NETFLIX:
                    //由于STR下，在NETFLIX下面关机事不关闭NETFLIX的，所以下次使用NETFLIX一键开机时系统会自动启动NETFLIX，而不需要UI启动
                    if(GLOBAL.TTS){
                        setTimeout(function(){
                            UI.callTTS("[SE0341]"+" "+"[SE0734]",0,false,false);
                        },200);

                    }
                    if (null != appGhost && appControl.getCurrentAPPName()==APPNAME.NETFLIX && AMState.STARTED == appControl.getCurrentAMState()){
                        DBG_ALWAYS("Netflix has been started by system.Do nothing.");
                    }
                    else{
                        UI.pushGhostModule(APPMODULE.MAIN, APPMODULE.CONTROL);
                        openAppControl(HOTEKEY_MAP.APPNAME[GLOBAL.APP_POWER_ON], null, CMDType.NATIVEAPP, CMDMethod.STARTUP, false, null);
                    }
                    break;
                case APPNAME.AMAZON:
                    if(GLOBAL.TTS){
                        setTimeout(function(){
                            UI.callTTS("[SE0341]"+" "+"Amazon",0,false,false);
                        },200);
                    }

                    if (null != appGhost && appControl.getCurrentAPPName()==APPNAME.AMAZON && AMState.STARTED == appControl.getCurrentAMState()){
                        DBG_ERROR("AMAZON has been started by system.Do nothing.");
                    }
                    else {
                        UI.pushGhostModule(APPMODULE.MAIN, APPMODULE.CONTROL);
                        openAppControl(APPNAME.AMAZON, APPNAME.AMAZON, CMDType.NATIVEAPP, CMDMethod.STARTUP, false, null);
                    }
                    break;
                case APPNAME.AMAZONRUBY:
                    if(GLOBAL.TTS){
                        setTimeout(function(){
                            UI.callTTS("[SE0341]"+" "+"Amazon",0,false,false);
                        },200);
                    }

                    if (null != appGhost && appControl.getCurrentAPPName()==APPNAME.AMAZONRUBY && AMState.STARTED == appControl.getCurrentAMState()){
                        DBG_ERROR("AMAZONRUBY has been started by system.Do nothing.");
                    }
//                    else if (!getNetworkSatus()) {
//                        try {
//                            UI.pushGhostModule(APPMODULE.MAIN, APPMODULE.WAITING);
//                        }
//                        catch (ex) {
//                            DBG_ERROR("startLoading error " + ex.message);
//                        }
//                        HOTKEY_TIMEOUT.AMAZONTIMEOUT = setTimeout(function () {
//                            clearTimeout(HOTKEY_TIMEOUT.AMAZONTIMEOUT);
//                            HOTKEY_TIMEOUT.AMAZONTIMEOUT = null;
//                            UI.popGhostModule(APPMODULE.CONTROL);
//                            UI.popGhostModule(APPMODULE.WAITING);
//                            try{UI.registerKeyCodes(null);
//                                UI.setKeyGroup(7);
//                                UI.unlockAllKeys("init");}catch (ex){DBG_ERROR(ex.message);}
//                            DBG_ALWAYS("start AMAZON by hotkey fail,show network dialog!"+checkIsAppOn());
//                            if(isModuleOpened(COMMON.MAIN)){
//                                closeMsgBox();
//                            }
//                            openMsgBoxByType(MsgBoxType.NETWORK_TIP);
//                        }, 15000);
//                    }
                    else {
                        UI.pushGhostModule(APPMODULE.MAIN, APPMODULE.CONTROL);
                        openAppControl(APPNAME.AMAZONRUBY, APPNAME.AMAZONRUBY, CMDType.NATIVEAPP, CMDMethod.STARTUP, false, null);
                    }
                    break;
                case APPNAME.VUDU:
                    if(GLOBAL.TTS){
                        setTimeout(function(){
                            UI.callTTS("[SE0341]"+" "+"[SE0739]",0,false,false);
                        },200);
                    }
                    if (null != appGhost && appControl.getCurrentAPPName()==APPNAME.VUDU && AMState.STARTED == appControl.getCurrentAMState()){
                        DBG_ERROR("VUDU has been started by system.Do nothing.");
                    }else if (!getNetworkSatus()) {
                        try {
                            UI.pushGhostModule(APPMODULE.MAIN, APPMODULE.WAITING);
                        }
                        catch (ex) {
                            DBG_ERROR("startLoading error " + ex.message);
                        }
                        HOTKEY_TIMEOUT.VUDUTIMEOUT = setTimeout(function () {
                            clearTimeout(HOTKEY_TIMEOUT.VUDUTIMEOUT);
                            HOTKEY_TIMEOUT.VUDUTIMEOUT = null;
                            UI.popGhostModule(APPMODULE.CONTROL);
                            UI.popGhostModule(APPMODULE.WAITING);
                            try{UI.registerKeyCodes(null);
                                UI.setKeyGroup(7);
                                UI.unlockAllKeys("init");}catch (ex){DBG_ERROR(ex.message);}
                            DBG_ALWAYS("start VUDU by hotkey fail,show network dialog!");
                            if(isModuleOpened(COMMON.MAIN)){
                                closeMsgBox();
                            }
                            if(!getNetworkSatus()){
                                openMsgBox(MsgBoxType.NETWORK_TIP,"VUDU");
                            }else{
                                UI.pushGhostModule(APPMODULE.MAIN, APPMODULE.CONTROL);
                                openAppControl(APPNAME.VUDU, APPNAME.VUDU, CMDType.NATIVEAPP, CMDMethod.STARTUP, false, null);
                            }
                        }, 15000);
                    }
                    else {
                        UI.pushGhostModule(APPMODULE.MAIN, APPMODULE.CONTROL);
                        openAppControl(APPNAME.VUDU, APPNAME.VUDU, CMDType.NATIVEAPP, CMDMethod.STARTUP, false, null);
                    }
                    break;
                case APPNAME.YOUTUBE:
                    if(GLOBAL.TTS){
                        setTimeout(function(){
                            UI.callTTS("[SE0341]"+" "+"[LA0015]",0,false,false);
                        },200);
                    }
                    if (null != appGhost && appControl.getCurrentAPPName()==APPNAME.YOUTUBE && AMState.STARTED == appControl.getCurrentAMState()){
                        DBG_ERROR("YOUTUBE has been started by system.Do nothing.");
                    }else if (!getNetworkSatus()) {
                        try {
                            UI.pushGhostModule(APPMODULE.MAIN, APPMODULE.WAITING);
                        }
                        catch (ex) {
                            DBG_ERROR("startLoading error " + ex.message);
                        }
                        HOTKEY_TIMEOUT.YOUTUBETIMEOUT = setTimeout(function () {
                            clearTimeout(HOTKEY_TIMEOUT.YOUTUBETIMEOUT);
                            HOTKEY_TIMEOUT.YOUTUBETIMEOUT = null;
                            UI.popGhostModule(APPMODULE.CONTROL);
                            UI.popGhostModule(APPMODULE.WAITING);
                            try{UI.registerKeyCodes(null);
                                UI.setKeyGroup(7);
                                UI.unlockAllKeys("init");}catch (ex){DBG_ERROR(ex.message);}
                            DBG_ALWAYS("start YOUTUBE by hotkey fail,show network dialog!");
                            if(isModuleOpened(COMMON.MAIN)){
                                closeMsgBox();
                            }
                            if(!getNetworkSatus()){
                                openMsgBox(MsgBoxType.NETWORK_TIP,"YOUTUBE");
                            }else{
                                UI.pushGhostModule(APPMODULE.MAIN, APPMODULE.CONTROL);
                                openAppControl(APPNAME.YOUTUBE, APPNAME.YOUTUBE, CMDType.NATIVEAPP, CMDMethod.STARTUP, false, null);
                            }
                        }, 15000);
                    }
                    else {
                        UI.pushGhostModule(APPMODULE.MAIN, APPMODULE.CONTROL);
                        openAppControl(APPNAME.YOUTUBE, APPNAME.YOUTUBE, CMDType.NATIVEAPP, CMDMethod.STARTUP, false, null);
                    }
                    break;
                default :
                    DBG_ERROR("Start hotkey app fail,the index is error:" + GLOBAL.APP_POWER_ON);
                    break;
            }}
        catch (ex){
            DBG_ERROR(ex.message);
        }
        if(model.system.getUserMode() == 1 || model.system.getUserMode() == 2) {
            DBG_INFO("currUserMode is Store Mode,need to start epos timer");
            writeFileToNative(RETAILMODE_FLAG_FILE, "close", 0);
            UI.setEposMenuTimeout(startRetailmodeTimer,retailmodeTimeout);
        }
//        UI.pushGhostModule(APPMODULE.MAIN, APPMODULE.CONTROL, true);
//        openAppControl(HOTEKEY_MAP.APPNAME[GLOBAL.APP_POWER_ON], null, CMDType.NATIVEAPP, CMDMethod.STARTUP, false, null);
    }
    else {
        if(GLOBAL.TTS){
            setTimeout(function(){
                UI.callTTS("[SE0341]",0,false,false);
            },200);
        }
        if(model.system.getUserMode() == 1 || model.system.getUserMode() == 2) {
            DBG_INFO("currUserMode is Store Mode,refresh retailtimer");
            writeFileToNative(RETAILMODE_FLAG_FILE, "close", 0);
            //有了弹出框就不需要直接启动timer了
            //UI.refreshEposMenuTimeout();
            //UI.popAllModule();
            DBG_ERROR("STORE MODE ");
            UI.clearEposMenuTimeout();
            UI.pushSubModule("EposMessage","startEposCountDown",true);
        } else {

            var ott = readFileFromNative("launcher/ott.txt", 1);
            DBG_ERROR("curr  source  OTT  is "+JSON.stringify(ott));
            if(ott!=null && ott.name != 0 ){
                DBG_ERROR("start ott!!!!!!!!!!!!!!! ");
                pauseDTV();
                GLOBAL.APP_POWER_ON = HOTEKEY_MAP.OTT;
                if (!getNetworkSatus()) {
                    try {
                        UI.pushGhostModule(APPMODULE.MAIN, APPMODULE.WAITING);
                    }
                    catch (ex) {
                        DBG_ERROR("startLoading error " + ex.message);
                    }
                    HOTKEY_TIMEOUT.OTT = setTimeout(function () {
                        clearTimeout(HOTKEY_TIMEOUT.OTT);
                        HOTKEY_TIMEOUT.OTT = null;
                        UI.popGhostModule(APPMODULE.CONTROL);
                        UI.popGhostModule(APPMODULE.WAITING);
                        try {
                            UI.registerKeyCodes(null);
                            UI.setKeyGroup(7);
                            UI.unlockAllKeys("init");
                        } catch (ex) {
                            DBG_ERROR(ex.message);
                        }
                        DBG_ERROR("start OTT by hotkey fail,show network dialog!");
                        //用于关闭USB弹出框
                        if (isModuleOpened(COMMON.MAIN)) {
                            closeMsgBox();
                        }
                        openMsgBox(MsgBoxType.NETWORK_TIP,APPNAME.OTT);
                    }, 15000);
                } else {
                    startThirdPartyApp(APPNAME.OTT,ott.url,37, CMDMethod.REMOTECONTROL, false, "#FFFFFF",ott.name,98);
                }
            }else{
                if(GLOBAL.TTS){
                    setTimeout(function(){
                        openLiveTVModule();
                    },200);
                }else{
                    openLiveTVModule();
                }
            }

//            UI.initLiveTV(false);
        }
    }

//    if (!GLOBAL.IS_APP_STR) {
////        sendAM(":dtv_app_mtk,am,:wakeup=hotkey");//暫時屏蔽
//    }

    registerUSBNotify();
    UIObserver.publishMessage(UIObserver.MESSAGE_NAME.ENTER_SUSPEND_MODE, 0);

    setTimeout( function(){recoverUpgradenotify();
    },3000);
    model.system.setGuiLoopFinished(1);
    GLOBAL.DISABLE_MESSAGE = false;

    //sync avs setting status from hisense cloud
    AVSClient.setting.syncStatus();

    DBG_ERROR("--STR : UI recoverTVState is done!--");
}

var timerToReadDropboxUserIni;
function StartTimerReadDropboxUserIni() {
    DBG_INFO("StartTimerReadDropboxUserIni Function !!");
    try {
        if (!!timerToReadDropboxUserIni) {
            clearTimeout(timerToReadDropboxUserIni);
        }
        timerToReadDropboxUserIni = setTimeout(function () {
            ReadDropboxUserIni();
        }, 3000);
    }
    catch (ex) {
        DBG_ERROR(ex.message);
    }
}

function powerOnStartoTTAPP(){
    try{
        var ott = readFileFromNative("launcher/ott.txt", 1);
        DBG_ERROR('ott:'+objToString(ott));
        if(ott!=null && ott.name != 0 ){
            pauseDTV();
        }
    }catch(ex){DBG_ERROR(ex.stack)}
}

function startOTTApp(){
    var ott = readFileFromNative("launcher/ott.txt", 1);
    if(ott!=null && ott.name != 0 ){
        DBG_ERROR("start ott!!!!!!!!!!!!!!! ");
        DBG_INFO('ott:'+objToString(ott));
        GLOBAL.APP_POWER_ON = HOTEKEY_MAP.OTT;
        pauseDTV();
        if (!getNetworkSatus()) {
            try {
                UI.pushGhostModule(APPMODULE.MAIN, APPMODULE.WAITING);
            }
            catch (ex) {
                DBG_ERROR("startLoading error " + ex.message);
            }
            HOTKEY_TIMEOUT.OTT = setTimeout(function () {
                clearTimeout(HOTKEY_TIMEOUT.OTT);
                HOTKEY_TIMEOUT.OTT = null;
                UI.popGhostModule(APPMODULE.CONTROL);
                UI.popGhostModule(APPMODULE.WAITING);
                try {
                    UI.registerKeyCodes(null);

                    UI.setKeyGroup(7);
                    UI.unlockAllKeys("init");
                } catch (ex) {
                    DBG_ERROR(ex.message);
                }
                DBG_ALWAYS("start OTT by hotkey fail,show network dialog!");
                //用于关闭USB弹出框
                if (isModuleOpened(COMMON.MAIN)) {
                    closeMsgBox();
                }
                openMsgBox(MsgBoxType.NETWORK_TIP,APPNAME.OTT);
            }, 15000);
        } else {
            startThirdPartyApp(APPNAME.OTT,ott.url,37, CMDMethod.REMOTECONTROL, false, "#FFFFFF",ott.name,98);
        }
    }
}

function ottRun(){
    try{
        var ott = readFileFromNative("launcher/ott.txt", 1);
        DBG_ALWAYS('ott:'+objToString(ott));
        return (ott!=null && ott.name != 0)
    }catch(ex){DBG_ERROR(ex.stack);return false}
}

function checkStartOttApp(name){
    var ott = readFileFromNative("launcher/ott.txt", 1);
    if(ott!=null && ott.name != 0 ){
        if(name && name != APPNAME.OTT){
            DBG_ERROR('current app name:'+name);
            DBG_ERROR("ott start-appStoppedFunc changed");

            return true;
        }
    }
    return false;
}

function ReadDropboxUserIni() {
    try {
        DBG_INFO("ReadDropboxUserIni Function!!!");
        var urlToken = Hisense.File.read("hisenseUI/dropboxuser.ini", 1);
        DBG_INFO("urlToken: " + urlToken);
        if (urlToken.length > 10) {
            //asyncReStartApp('app_lau_browser', 'dropbox_token');
            //startThirdPartyApp(APPNAME.DROPBOX, null, CMDType.HISENSEPAGE, CMDMethod.COMMANDURL, false);
            try {
                sendAM(":am,opera4x,store:resume=[-s,hisense,-u,file:///opt/hisenseUI/html/hisenseUI/module/dropbox/hisenseUI/dropbox.html?module=dropbox]",
                "opera4x","resume","source:hisense\r\nurl:file:///opt/hisenseUI/html/hisenseUI/module/dropbox/hisenseUI/dropbox.html?module=dropbox\r\n");
            }
            catch (ex) {
                DBG_ERROR(ex.message);
            }
        }
        else {
//            var sysflag="";
//            try{sysflag=model.system.getReturnlocalappFlag()}
//            catch (ex){DBG_ERROR(ex.message);}
            DBG_INFO("urlToken invalid:"+UI.getCurrModule().name);
            if(!!appControl && appControl.getCurrentAPPName()==APPNAME.DROPBOX&&UI.getCurrModule().name=="base"){
                StartTimerReadDropboxUserIni();
            }
            else{
                DBG_ALWAYS("no need to start timer!"+!!appControl+ appControl.getCurrentAPPName()+UI.getCurrModule().name);
            }
        }

    }
    catch (ex) {
        DBG_ERROR(ex.message);
    }
}

var upgradeLoadRetryCount=0;
var upgradeLoadPercent=0;
var upgradeType=0; //others user can cancel    2 force update
var autoUpgradeflag=false;
var autoUpgradeValue=0;
var curUpdateErrType=0;
function sysUpgradeCancelnotify(){
 //   model.softupdate.onAutoAnnouncementChaged = cancelupupdadenotify;
  //  model.softupdate.onDownloadProgressChaged=cancelupupdadenotify;
    UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.SYSTEM_OTA_DETECT_NOTIFY, onOTAUpdateNotify);
    UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.SYSTEM_OTA_DOWNLOAD_PROGRESS, onOTADownloadProgressChaged);
    DBG_ALWAYS("cancel the upgrade register notify")
}
function cancelupupdadenotify(value){
    return;
}
function sysUpgradeInit() {
    try {
      //  model.softupdate.onAutoAnnouncementChaged = onOTAUpdateNotify;
      //  model.softupdate.onDownloadProgressChaged=onOTADownloadProgressChaged;
        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.SYSTEM_OTA_DETECT_NOTIFY, onOTAUpdateNotify);
        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.SYSTEM_OTA_DOWNLOAD_PROGRESS, onOTADownloadProgressChaged);
        setTimeout( function(){
            model.softupdate.StartSearch(100);
            DBG_ERROR("start the ota auto check");
        },10000);

    } catch (e) {
        DBG_ERROR(e.message);
    }
}
function recoverUpgradenotify(){
    upgradeLoadRetryCount=0;
    upgradeLoadPercent=0;
    upgradeType=0; //others user can cancel    2 force update
    autoUpgradeflag=false;
    autoUpgradeValue=0;
    curUpdateErrType=0;
    var progress=0;
    DBG_ERROR("recoverUpgradenotify ");
      //  model.softupdate.onAutoAnnouncementChaged = onOTAUpdateNotify;
     //   model.softupdate.onDownloadProgressChaged=onOTADownloadProgressChaged;
    UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.SYSTEM_OTA_DETECT_NOTIFY, onOTAUpdateNotify);
    UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.SYSTEM_OTA_DOWNLOAD_PROGRESS, onOTADownloadProgressChaged);

    model.softupdate.StartSearch(100);
    DBG_ERROR("start the ota auto check");
}
function onOTAUpdateNotify(value) {
    DBG_ALWAYS("softwareUpdateNotify[" + value + "]");
    if(tv)
    {
        upgradeType=model.softupdate.getHisenseUpgradeMode();
    }
    else
    {
        upgradeType=1;
    }
    DBG_INFO("ota get the upgrade mode is "+upgradeType);
    if(value==4){
        autoUpgradeflag=true;
        autoUpgradeValue=value;
        UI.addToFuncQueue(SettingDoUpdateNotify,value);
    }
    else if(value==5){
      //  UI.pushGhostModule("setting","SettingUpdateLoadTip");
        autoUpgradeflag=false;
    }
    else if(value==6)
    {
      //  UI.pushGhostModule("setting","SettingUpdateLoadTip");
        autoUpgradeflag=false;
        model.softupdate.StartDownload();
        DBG_ALWAYS("start OTA download");
    }
    else if(value==7)
    {
        onOTADownloadProgressChaged(100);
    }

}
function SettingDoUpdateNotify(value){
    try {
        //todo to check is ok to popup the upgrade dialog
        if(tv)
        {
            upgradeType=model.softupdate.getHisenseUpgradeMode();
        }
        else
        {
            upgradeType=1;
        }
        DBG_INFO("ota get the upgrade mode is "+upgradeType);
        if(value==4){
            UI.pushSubModule("setting","SettingUpdateVersion",true);
            autoUpgradeflag=false;
        }else if(value==5)
        {
            UI.pushSubModule("setting","SettingUpdateDowload",true,null,5);
            autoUpgradeflag=false;
            model.softupdate.StartDownload();
            DBG_ALWAYS("start OTA download");
        }

    } catch (e) {
        DBG_ERROR(e.message);
    }
}
function onOTADownloadProgressChaged(value){
    DBG_ALWAYS("onOTADownloadProgressChaged"+value);
    if(value>=0&&value<100)
    {
        upgradeLoadPercent=value;
        var SettingUpdateDowload=UI.getSubModule("SettingUpdateDowload");
        if(!!SettingUpdateDowload)
        {
            SettingUpdateDowload.fresh(upgradeLoadPercent);
        }
        var SettingUpdateLoadTip=UI.getGhostModule("SettingUpdateLoadTip");
        if(!!SettingUpdateLoadTip){
            SettingUpdateLoadTip.fresh(upgradeLoadPercent);
        }
        if(typeof(launcher) != "undefined"&&!launcher.getDownLoadIcon())
        {
            launcher.setDownLoadIcon(true);
            GLOBAL.LAUNCHER_OTA_UPDATE = true;
            DBG_INFO("OTA update is true");
        }

    }
    else{
        if(typeof(launcher) != "undefined"){
            launcher.setDownLoadIcon(false);
            GLOBAL.LAUNCHER_OTA_UPDATE = false;
            DBG_INFO("OTA update is false");
        }
        try
        {
            if(UI.getCurrSubModule()
                && !!UI.getCurrSubModule().isUpgrade
                &&UI.getCurrSubModule().isUpgrade){
                if(value==100){
                    UI.popSubModule();

                    UI.addToFuncQueue(SettingDoDownloadProcess,value);
                    //UI.pushSubModule("setting","SettingUpdateDownloadOk",true);
                    //changed by jiaguili 1017/7/20. pushSubModule() maybe causr the SettingUpdateDownloadOk lost focus
                    //because some submodule onshow will start some async event (himedia devicebrowser)
                }
                else if(value<=104||value==201){
                    upgradeLoadRetryCount++;
                    UI.popSubModule();
                    if(upgradeLoadRetryCount<2){
                        UI.pushSubModule("setting","SettingUpdateLoadRetry",true);
                        upgradeLoadPercent=0;
                    }
                    else
                    {
                        curUpdateErrType=4;
                        UI.pushSubModule("setting","SettingUpdateDialog",true);

                    }
                }
                else if(value==202)
                {
                    UI.popSubModule();
                    upgradeLoadPercent=0;
                    curUpdateErrType=5;
                    UI.pushSubModule("setting","SettingUpdateDialog",true);

                }
                else if(value==203)
                {
                    UI.popSubModule();
                    curUpdateErrType=6;
                    UI.pushSubModule("setting","SettingUpdateDialog2",true);

                }
            }
            else
            {
                if(value<=104||(value>200&&value<=203)){
                    UI.addToFuncQueue(SettingDoDownloadProcess,value);
                }

            }
        }catch (e)
        {
            DBG_ERROR(e.message)
        }

        //UI.addToFuncQueue(SettingDoDownloadProcess,value);
    }

}
function SettingDoDownloadProcess(value){
    UI.inactiveKey();
    if(value==100){
        if(UI.getCurrSubModule()&& UI.getCurrSubModule().name=="SettingUpdateDowload"){
            UI.popSubModule();
        }
        UI.pushSubModule("setting","SettingUpdateDownloadOk",true);
    }
    else if(value<=104){
        try
        {
            if(UI.getCurrSubModule()&& UI.getCurrSubModule().name=="SettingUpdateDowload"){
                UI.popSubModule();
            }
        }catch (e)
        {
            DBG_ERROR(e.message)
        }

        upgradeLoadRetryCount++;
        if(upgradeLoadRetryCount<2){
            UI.pushSubModule("setting","SettingUpdateLoadRetry",true);
            upgradeLoadPercent=0;
        }
        else
        {
            curUpdateErrType=4;
            UI.pushSubModule("setting","SettingUpdateDialog",true);

        }

    }
    else if(value==201){
        if( UI.getCurrSubModule().name=="SettingUpdateDowload"){
            UI.popSubModule();
        }
        upgradeLoadPercent=0;
        upgradeLoadRetryCount++;
        if(upgradeLoadRetryCount<2){
            UI.pushSubModule("setting","SettingUpdateLoadRetry",true);

        }
        else
        {
            curUpdateErrType=4;
            UI.pushSubModule("setting","SettingUpdateDialog",true);

        }
    }
    else if(value==202)
    {
        try
        {
            if(UI.getCurrSubModule()&& UI.getCurrSubModule().name=="SettingUpdateDowload"){
                UI.popSubModule();
            }
        }catch (e)
        {
            DBG_ERROR(e.message)
        }
        upgradeLoadPercent=0;
        curUpdateErrType=5;
        UI.pushSubModule("setting","SettingUpdateDialog",true);

    }
    else if(value==203)
    {
        try
        {
            if(UI.getCurrSubModule()&& UI.getCurrSubModule().name=="SettingUpdateDowload"){
                UI.popSubModule();
            }
        }catch (e)
        {
            DBG_ERROR(e.message)
        }
        curUpdateErrType=6;
        UI.pushSubModule("setting","SettingUpdateDialog2",true);

    }
    UI.activeKey();
}
function getAudioList(){
    var audioLanguageList = [
        {"value": "#3005", "text": "[GE0006]"},
        {"value": "#3006", "text": "[SE0192]"},
        {"value": "#3007", "text": "[SE0193]"},
        {"value": "#3008", "text": "[SE0194]"},
        {"value": "#3009", "text": "[SE0195]"},
        {"value": "#3010", "text": "[SE0196]"},
        {"value": "#3011", "text": "[SE0192]"},
        {"value": "#3012", "text": "[SE0207]"},
        {"value": "#3013", "text": "[SE0206]"},
        {"value": "#3014", "text": "[SE0198]"},
        {"value": "#3015", "text": "[SE0200]"},
        {"value": "#3016", "text": "[SE0208]"},
        {"value": "#3017", "text": "[SE0199]"},
        {"value": "#3018", "text": "[SE0209]"},
        {"value": "#3019", "text": "[SE0201]"},
        {"value": "#3020", "text": "[SE0202]"},
        {"value": "#3021", "text": "[SE0203]"},
        {"value": "#3022", "text": "[SE0205]"},
        {"value": "#3023", "text": "[SE0204]"},
        {"value": "#3024", "text": "[SE0210]"},
        {"value": "#3025", "text": "[SE0215]"},
        {"value": "#3026", "text": "[SE0217]"},
        {"value": "#3027", "text": "[SE0218]"},
        {"value": "#3028", "text": "[SE0219]"},
        {"value": "#3029", "text": "[SE0211]"},
        {"value": "#3030", "text": "[SE0220]"},
        {"value": "#3031", "text": "[SE0221]"},
        {"value": "#3032", "text": "[SE0222]"},
        {"value": "#3033", "text": "[SE0223]"},
        {"value": "#3034", "text": "[SE0224]"},
        {"value": "#3035", "text": "[SE0225]"},
        {"value": "#3036", "text": "[SE0226]"},
        {"value": "#3037", "text": "[SE0227]"},
        {"value": "#3038", "text": "[SE0218]"},
        {"value": "#3039", "text": "[SE0229]"},
        {"value": "#3040", "text": "[SE0212]"},
        {"value": "#3041", "text": "[SE0213]"},
        {"value": "#3042", "text": "[SE0214]"},
        {"value": "#3043", "text": "[SE0230]"},
        {"value": "#3044", "text": "[SE0231]"},
        {"value": "#3045", "text": "[SE0232]"},
        {"value": "#3046", "text": "[SE0233]"},
        {"value": "#3047", "text": "[SE1080]"},
        {"value": "#3048", "text": "Belarusian"},
        {"value": "#3073", "text": "[SE2525]"},
        {"value": "#3080", "text": "Original version"},
        {"value": "#3081", "text": "Uncoded  languages"},
        {"value": "#3098", "text": "[SE1521]"},
        {"value": "#3099", "text": "[SE2145]"},
        {"value": "#3100", "text": "[SE2552]"},
        {"value": "#3101", "text": "Uncoded  languages"}

    ];
    return audioLanguageList;
}
function getAudioIndent(){
    var AudioIndent = [
        {identIndex: SoundModel.IDENT_MONO,               doblyFlag: 0 ,identName: "[SE0828]"},
        {identIndex: SoundModel.IDENT_STEREO,             doblyFlag: 0 ,identName: "[SE0453]"},
        {identIndex: SoundModel.IDENT_DUAL,               doblyFlag: 0 ,identName: "[SE0451]"},
        {identIndex: SoundModel.IDENT_PCM_STEREO,         doblyFlag: 0 ,identName: "[SE0453]"},
        {identIndex: SoundModel.IDENT_DPLII_STEREO,       doblyFlag: 0 ,identName: "[SE0453]"},
        {identIndex: SoundModel.IDENT_DTS_10,             doblyFlag: 0 ,identName: "[SE0828]"},
        {identIndex: SoundModel.IDENT_DTS_20,             doblyFlag: 0 ,identName: "[SE0453]"},
        {identIndex: SoundModel.IDENT_DTS_21,             doblyFlag: 0 ,identName: "2.1CH"},
        {identIndex: SoundModel.IDENT_DTS_30,             doblyFlag: 0 ,identName: "3.0CH"},
        {identIndex: SoundModel.IDENT_DTS_31,             doblyFlag: 0 ,identName: "3.1CH"},
        {identIndex: SoundModel.IDENT_DTS_40,             doblyFlag: 0 ,identName: "4.0CH"},
        {identIndex: SoundModel.IDENT_DTS_41,             doblyFlag: 0 ,identName: "4.1CH"},
        {identIndex: SoundModel.IDENT_DTS_50,             doblyFlag: 0 ,identName: "5.0CH"},
        {identIndex: SoundModel.IDENT_DTS_51,             doblyFlag: 0 ,identName: "5.1CH"},
        {identIndex: SoundModel.IDENT_DD_10,              doblyFlag: 1 ,identName: "[SE0828]"},
        {identIndex: SoundModel.IDENT_DD_20,              doblyFlag: 1 ,identName: "[SE0453]"},
        {identIndex: SoundModel.IDENT_DD_21,              doblyFlag: 1 ,identName: "2.1CH"},
        {identIndex: SoundModel.IDENT_DD_30,              doblyFlag: 1 ,identName: "3.0CH"},
        {identIndex: SoundModel.IDENT_DD_31,              doblyFlag: 1 ,identName: "3.1CH"},
        {identIndex: SoundModel.IDENT_DD_40,              doblyFlag: 1 ,identName: "4.0CH"},
        {identIndex: SoundModel.IDENT_DD_41,              doblyFlag: 1 ,identName: "4.1CH"},
        {identIndex: SoundModel.IDENT_DD_50,              doblyFlag: 1 ,identName: "5.0CH"},
        {identIndex: SoundModel.IDENT_DD_51,              doblyFlag: 1 ,identName: "5.1CH"},
        {identIndex: SoundModel.IDENT_DD_PLUS_10,         doblyFlag: 1 ,identName: "[SE0828]"},
        {identIndex: SoundModel.IDENT_DD_PLUS_20,         doblyFlag: 1 ,identName: "[SE0453]"},
        {identIndex: SoundModel.IDENT_DD_PLUS_21,         doblyFlag: 1 ,identName: "2.1CH"},
        {identIndex: SoundModel.IDENT_DD_PLUS_30,         doblyFlag: 1 ,identName: "3.0CH"},
        {identIndex: SoundModel.IDENT_DD_PLUS_31,         doblyFlag: 1 ,identName: "3.1CH"},
        {identIndex: SoundModel.IDENT_DD_PLUS_40,         doblyFlag: 1 ,identName: "4.0CH"},
        {identIndex: SoundModel.IDENT_DD_PLUS_41,         doblyFlag: 1 ,identName: "4.1CH"},
        {identIndex: SoundModel.IDENT_DD_PLUS_50,         doblyFlag: 1 ,identName: "5.0CH"},
        {identIndex: SoundModel.IDENT_DD_PLUS_51,         doblyFlag: 1 ,identName: "5.1CH"},
        {identIndex: SoundModel.IDENT_DD_PLUS_60,         doblyFlag: 1 ,identName: "6.0CH"},
        {identIndex: SoundModel.IDENT_DD_PLUS_61,         doblyFlag: 1 ,identName: "6.1CH"},
        {identIndex: SoundModel.IDENT_DD_PLUS_70,         doblyFlag: 1 ,identName: "7.0CH"},
        {identIndex: SoundModel.IDENT_DD_PLUS_71,         doblyFlag: 1 ,identName: "7.1CH"},
        {identIndex: SoundModel.IDENT_DD_PULSE_10,        doblyFlag: 1 ,identName: "[SE0828]"},
        {identIndex: SoundModel.IDENT_DD_PULSE_20,        doblyFlag: 1 ,identName: "[SE0453]"},
        {identIndex: SoundModel.IDENT_DD_PULSE_21,        doblyFlag: 1 ,identName: "2.1CH"},
        {identIndex: SoundModel.IDENT_DD_PULSE_30,        doblyFlag: 1 ,identName: "3.0CH"},
        {identIndex: SoundModel.IDENT_DD_PULSE_31,        doblyFlag: 1 ,identName: "3.1CH"},
        {identIndex: SoundModel.IDENT_DD_PULSE_40,        doblyFlag: 1 ,identName: "4.0CH"},
        {identIndex: SoundModel.IDENT_DD_PULSE_41,        doblyFlag: 1 ,identName: "4.1CH"},
        {identIndex: SoundModel.IDENT_DD_PULSE_50,        doblyFlag: 1 ,identName: "5.0CH"},
        {identIndex: SoundModel.IDENT_DD_PULSE_51,        doblyFlag: 1 ,identName: "5.1CH"},
        {identIndex: SoundModel.IDENT_DD_PULSE_60,        doblyFlag: 1 ,identName: "6.0CH"},
        {identIndex: SoundModel.IDENT_DD_PULSE_61,        doblyFlag: 1 ,identName: "6.1CH"},
        {identIndex: SoundModel.IDENT_DD_PULSE_70,        doblyFlag: 1 ,identName: "7.0CH"},
        {identIndex: SoundModel.IDENT_DD_PULSE_71,        doblyFlag: 1 ,identName: "7.1CH"},
        {identIndex: SoundModel.IDENT_DTS_DUAL_MONO,      doblyFlag: 0 ,identName: "[SE0451]"},
        {identIndex: SoundModel.IDENT_DD_DUAL_MONO,       doblyFlag: 1 ,identName: "[SE0451]"},
        {identIndex: SoundModel.IDENT_DD_PLUS_DUAL_MONO,  doblyFlag: 1 ,identName: "[SE0451]"},
        {identIndex: SoundModel.IDENT_DD_PULSE_DUAL_MONO, doblyFlag: 1 ,identName: "[SE0451]"},
        {identIndex: SoundModel.IDENT_DTS_HD_10,          doblyFlag: 0 ,identName: "[SE0828]"},
        {identIndex: SoundModel.IDENT_DTS_HD_DUAL_MONO,   doblyFlag: 0 ,identName: "[SE0451]"},
        {identIndex: SoundModel.IDENT_DTS_HD_20,          doblyFlag: 0 ,identName: "[SE0453]"},
        {identIndex: SoundModel.IDENT_DTS_HD_21,          doblyFlag: 0 ,identName: "2.1CH"},
        {identIndex: SoundModel.IDENT_DTS_HD_30,          doblyFlag: 0 ,identName: "3.0CH"},
        {identIndex: SoundModel.IDENT_DTS_HD_31,          doblyFlag: 0 ,identName: "3.1CH"},
        {identIndex: SoundModel.IDENT_DTS_HD_40,          doblyFlag: 0 ,identName: "4.0CH"},
        {identIndex: SoundModel.IDENT_DTS_HD_41,          doblyFlag: 0 ,identName: "4.1CH"},
        {identIndex: SoundModel.IDENT_DTS_HD_50,          doblyFlag: 0 ,identName: "5.0CH"},
        {identIndex: SoundModel.IDENT_DTS_HD_51,          doblyFlag: 0 ,identName: "5.1CH"},
        {identIndex: SoundModel.IDENT_DTS_HD_60,          doblyFlag: 0 ,identName: "6.0CH"},
        {identIndex: SoundModel.IDENT_DTS_HD_61,          doblyFlag: 0 ,identName: "6.1CH"},
        {identIndex: SoundModel.IDENT_DTS_HD_70,          doblyFlag: 0 ,identName: "7.0CH"},
        {identIndex: SoundModel.IDENT_DTS_HD_71,          doblyFlag: 0 ,identName: "7.1CH"},
        {identIndex: SoundModel.IDENT_DD_HD_10,           doblyFlag: 1 ,identName: "[SE0828]"},
        {identIndex: SoundModel.IDENT_DD_HD_DUAL_MONO,    doblyFlag: 1 ,identName: "[SE0451]"},
        {identIndex: SoundModel.IDENT_DD_HD_20,           doblyFlag: 1 ,identName: "[SE0453]"},
        {identIndex: SoundModel.IDENT_DD_HD_21,           doblyFlag: 1 ,identName: "2.1CH"},
        {identIndex: SoundModel.IDENT_DD_HD_30,           doblyFlag: 1 ,identName: "3.0CH"},
        {identIndex: SoundModel.IDENT_DD_HD_31,           doblyFlag: 1 ,identName: "3.1CH"},
        {identIndex: SoundModel.IDENT_DD_HD_40,           doblyFlag: 1 ,identName: "4.0CH"},
        {identIndex: SoundModel.IDENT_DD_HD_41,           doblyFlag: 1 ,identName: "4.1CH"},
        {identIndex: SoundModel.IDENT_DD_HD_50,           doblyFlag: 1 ,identName: "5.0CH"},
        {identIndex: SoundModel.IDENT_DD_HD_51,           doblyFlag: 1 ,identName: "5.1CH"},
        {identIndex: SoundModel.IDENT_DD_HD_60,           doblyFlag: 1 ,identName: "6.0CH"},
        {identIndex: SoundModel.IDENT_DD_HD_61,           doblyFlag: 1 ,identName: "6.1CH"},
        {identIndex: SoundModel.IDENT_DD_HD_70,           doblyFlag: 1 ,identName: "7.0CH"},
        {identIndex: SoundModel.IDENT_DD_HD_71,           doblyFlag: 1 ,identName: "7.1CH"},
        {identIndex: SoundModel.IDENT_DTS_210,            doblyFlag: 0 ,identName: "21.0CH"},
        {identIndex: SoundModel.IDENT_DTS_310,            doblyFlag: 0 ,identName: "31.0CH"},
        {identIndex: SoundModel.IDENT_DTS_HD_210,         doblyFlag: 0 ,identName: "21.0CH"},
        {identIndex: SoundModel.IDENT_DTS_HD_310,         doblyFlag: 0 ,identName: "31.0CH"},
        {identIndex: SoundModel.IDENT_DD_210,             doblyFlag: 1 ,identName: "21.0CH"},
        {identIndex: SoundModel.IDENT_DD_310,             doblyFlag: 1 ,identName: "31.0CH"},
        {identIndex: SoundModel.IDENT_DD_PLUS_210,        doblyFlag: 1 ,identName: "21.0CH"},
        {identIndex: SoundModel.IDENT_DD_PLUS_310,        doblyFlag: 1 ,identName: "31.0CH"},
        {identIndex: SoundModel.IDENT_DD_PULSE_210,       doblyFlag: 1 ,identName: "21.0CH"},
        {identIndex: SoundModel.IDENT_DD_PULSE_310,       doblyFlag: 1 ,identName: "31.0CH"},
        {identIndex: SoundModel.IDENT_DD_HD_210,          doblyFlag: 1 ,identName: "21.0CH"},
        {identIndex: SoundModel.IDENT_DD_HD_310,          doblyFlag: 1 ,identName: "31.0CH"}
    ];
    return AudioIndent;
}
function getAudioLanguageList(){
    try {
        var dtvAudioList=[];
        var audioInfo;
        try {
            if(tv){
                audioInfo = JSON.parse(model.tvservice.getAudioLanguageInfo());
            }else{
                audioInfo = AudioLanListData.TempData;
            }
        } catch (ex) {
            DBG_ERROR(ex.message);
        }
        if(!!audioInfo){
            var totalNum = audioInfo['AudioLanguageInfo'].length;
            for(var i=0; i<totalNum;i++){
                var tempAudioInfo = {};
                tempAudioInfo.audioIndex = audioInfo['AudioLanguageInfo'][i]['audioIndex'];
                tempAudioInfo.audioInfoText = audioInfo['AudioLanguageInfo'][i]['audioInfoText'];
                tempAudioInfo.audioIso639 = audioInfo['AudioLanguageInfo'][i]['audioIso639'];
                tempAudioInfo.audioType = audioInfo['AudioLanguageInfo'][i]['audioType'];
                tempAudioInfo.audioPurpose = audioInfo['AudioLanguageInfo'][i]['audioPurpose'];
                tempAudioInfo.audioTrack = audioInfo['AudioLanguageInfo'][i]['audioTrack'];
                dtvAudioList.push(tempAudioInfo);
            }
            return dtvAudioList;
        }else{
            DBG_ERROR("audioInfo is error");
            return dtvAudioList;
        }
    } catch (ex) {
        DBG_ERROR(ex.message);
    }
}
function DtvAudioLanguageInit(){
    try {
        crntDtvAudioList=[];
        var AudioLanList=getAudioLanguageList();
        if(AudioLanList.length>0){
            crntDtvAudioList=AudioLanList;
            if(UI.getCurrSubModule().name == "menuChip"){
                UI.getCurrSubModule().close();
                UI.pushSubModule("setting", "AudioLanguageList", true, menuChipParam);
            }
        }else{
            GLOBAL.CURRENT_TOAST_TYPE = TOASTTYPE.AUDIO_LANGUAGE_TIP;
            UI.pushGhostModule("setting", "SettingSysToast");
        }
    } catch (ex) {
        DBG_ERROR(ex.message);
    }
}

function getCurAudioIdent(val){
    var audioEnumIdent = getAudioIndent();
    var audioTrackInfo=null;
    for(var j=0; j < audioEnumIdent.length; j++){
        if(audioEnumIdent[j].identIndex == val){
            audioTrackInfo = Config.language[UI.getMsgId(audioEnumIdent[j].identName)];
            break;
        }
    }
    return audioTrackInfo;
}

function SettingSndARCWorkingStateInit() {
    try {
        var audioDeviceExist = tv?model.cec.getIsAudioDeviceExist():1;
        DBG_INFO('model.cec.getIsAudioDeviceExist(): ' + audioDeviceExist);
        var arcState = tv?model.cec.getHdmiDevicesArcState():0;
        DBG_INFO('model.cec.getHdmiDevicesArcState(): ' + arcState);
        var cecState = tv?model.cec.getFunctionality():1;
        DBG_INFO('model.cec.getFunctionality(): ' + cecState);
        ARCDeviceWorkingState = (arcState && audioDeviceExist && cecState);
    } catch (ex) {
        DBG_ERROR(ex.message);
    }
}
function getARCDeviceWorkingState() {
    try {
        if (null == ARCDeviceWorkingState) {
            ARCDeviceWorkingState = 0;
            //TODO 获取ARC是否工作状态
        }
        return ARCDeviceWorkingState;
    } catch (ex) {
        DBG_ERROR(ex.message);
    }
}
function onIsAudioDeviceExistChagedSndInterface(val){
    try {
        var AudioFlag = AudioPageFlag();
        if (AudioFlag) {
            DBG_INFO('onIsAudioDeviceExistChagedSndInterface:' + val);
            var audioDeviceExist = val;

        //var headphoneInsertTvMuteState = getHeadphoneInsertTvMuteState();
        //DBG_INFO('getHeadphoneInsertTvMuteState()' + headphoneInsertTvMuteState);

        var arcState = model.cec.getHdmiDevicesArcState();
        DBG_INFO('model.cec.getHdmiDevicesArcState(): ' + arcState);

        var cecState = model.cec.getFunctionality();
        DBG_INFO('model.cec.getFunctionality(): ' + cecState);

            if (ARCDeviceWorkingState != (arcState && audioDeviceExist && cecState)) {
                ARCDeviceWorkingState = (arcState && audioDeviceExist && cecState);
                DBG_INFO('ARCDeviceWorkingState: ' + ARCDeviceWorkingState + ", sound UI will change state!");
                onARCDeviceWorkingStateChanged(ARCDeviceWorkingState);
            } else {
                DBG_INFO('ARCDeviceWorkingState: ' + ARCDeviceWorkingState + ", do nothing");
            }
        }


    } catch (ex) {
        DBG_ERROR(ex.message);
    }
}
function onARCDeviceWorkingStateChanged(val) {  //todo check
    try {
        DBG_INFO('onARCDeviceWorkingStateChanged: ' + val);
        var AudioSpeaker = UI.getSubModule("AudioSpeaker");
        if(!!AudioSpeaker){
            //AudioSpeaker.DisableSoundByARCOn();
        }
        var AudioAdvance = UI.getSubModule("AudioAdvance");
        if(!!AudioAdvance){
            //AudioAdvance.DisableSoundAdByARCOn();
        }
    } catch (ex) {
        DBG_ERROR(ex.message);
    }
}
function AudioPageFlag(){
    if (UI.getCurrSubModule().name == "AudioMainPanel" ||
        UI.getCurrSubModule().name == "AudioAdvance") {
        return true;
    }
    else {
        return false;
    }
}
function onHdmiDevicesArcStateChagedSndInterface(val){
    try {
        var AudioFlag = AudioPageFlag();
        if (AudioFlag) {
            DBG_INFO('onHdmiDevicesArcStateChagedSndInterface:' + val);
            var arcState = val;

        var audioDeviceExist = model.cec.getIsAudioDeviceExist();
        DBG_INFO('model.cec.getIsAudioDeviceExist(): ' + audioDeviceExist);

        var cecState = model.cec.getFunctionality();
        DBG_INFO('model.cec.getFunctionality(): ' + cecState);

            if (ARCDeviceWorkingState != (arcState && audioDeviceExist && cecState)) {
                ARCDeviceWorkingState = (arcState && audioDeviceExist && cecState);
                DBG_INFO('ARCDeviceWorkingState: ' + ARCDeviceWorkingState + ", sound UI will change state!");
                onARCDeviceWorkingStateChanged(ARCDeviceWorkingState);
            } else {
                DBG_INFO('ARCDeviceWorkingState: ' + ARCDeviceWorkingState + ", do nothing");
            }
        }
    } catch (ex) {
        DBG_ERROR(ex.message);
    }
}
function onFunctionalityChagedSndInterface(val) {
    try {
        var AudioFlag = AudioPageFlag();
        if (AudioFlag) {
            DBG_INFO('onFunctionalityChagedSndInterface: ' + val);
            var cecState = val;

            var audioDeviceExist = model.cec.getIsAudioDeviceExist();
            DBG_INFO('model.cec.getIsAudioDeviceExist(): ' + audioDeviceExist);
            var arcState = model.cec.getHdmiDevicesArcState();
            DBG_INFO('model.cec.getHdmiDevicesArcState(): ' + arcState);

            if (ARCDeviceWorkingState != (arcState && audioDeviceExist && cecState)) {
                ARCDeviceWorkingState = (arcState && audioDeviceExist && cecState);
                DBG_INFO('ARCDeviceWorkingState: ' + ARCDeviceWorkingState + ", sound UI will change state!");
                onARCDeviceWorkingStateChanged(ARCDeviceWorkingState);
            } else {
                DBG_INFO('ARCDeviceWorkingState: ' + ARCDeviceWorkingState + ", do nothing");
            }
        }
    } catch (ex) {
        debugE(ex.message);
    }
}

function getARCStateInit(){
    try {
        var arcDev=tv?model.sound.getArcDevExist():1;
        var tvSpeaker = tv?model.sound.getSpeakerArc():1;//1:TVSpeaker;2:ARC;3:spidf;
        DBG_ERROR("arcDev: "+arcDev+" tvSpeaker: "+tvSpeaker);
        var isArcOn;
        if(tvSpeaker==2||tvSpeaker==3){
            isArcOn=1;
        }else{
            isArcOn=0;
        }
        ARCDeviceState = arcDev&&isArcOn;
        return ARCDeviceState;
    } catch (ex) {
        DBG_ERROR(ex.message);
    }
}
function onArcDeviceExistChaged(val){
    try {
        DBG_ERROR("onArcDevExistChaged: "+val);
        var arcDev=val;
        var tvSpeaker = tv?model.sound.getSpeakerArc():1;//1:TVSpeaker;2:ARC;3:spidf;
        DBG_ERROR("arcDev: "+arcDev+" tvSpeaker: "+tvSpeaker);
        var isArcOn;
        if(tvSpeaker==2||tvSpeaker==3){
            isArcOn=1;
        }else{
            isArcOn=0;
        }
        ARCDeviceState = arcDev&&isArcOn;
        onARCDeviceWorkingStateChanged(ARCDeviceState);

    } catch (ex) {
        DBG_ERROR(ex.message);
    }
}


/**
 *
 * @param flag 1：Power off, 2：Sleep Timer 待机, 3：Inactivity Timer待机（无信号待机）
 */
function switchOffTV(flag){
    if(!Config.tv) return false;
    if(1 == model.system.getFastBoot()){
        onEnterSuspendChanged();
        model.system.SwitchOffTv(flag);
    } else
    {
        model.system.SwitchOffTv(flag);
    }
}

function clearOpenFromStandbyFlag(){
    GLOBAL.APP_POWER_ON = HOTEKEY_MAP.NONE;
    if (Config.tv) {
        model.system.setOpenFromStandby(HOTEKEY_MAP.NONE);
        model.system.stopAnimation(0);
    }
}


function setWindowSize(x, y, w, h) {

    var rX = Math.round(10000 * x / 1920),
        ry = Math.round(10000 * y / 1080),
        rw = Math.round(10000 * w / 1920),
        rh = Math.round(10000 * h / 1080);
    var size = [rX, ry, rw, rh];
    DBG_ALWAYS("set window size:" + objToString(size));
    try {
        Config.tv && model.video.setWindow0(size);
    }
    catch (ex) {
        DBG_ERROR(ex.message);
    }
}

function setMheg5Status(v) {
    try {
        if (Config.tv && ("UK" == GLOBAL.CURRENT_COUNTRY)) {
            model.mheg5.setI32Status(v);
        }
    }
    catch (ex) {
        DBG_ERROR(ex.message);
    }
}


function openEPGModule(){
    UI.pushModule(EPGMDL.NAME, EPGMDL.MAIN);
}

function closeEPGModule() {
    try{
        UI.clearAllSubModule(EPGMDL.NAME);
    }
    catch (ex){

    }
}

function getI32Volume() {
    try{
        if (!tv) {
            return 50
        }else{
            return model.tts.getI32Volume();
        }
    }catch(ex){DBG_ERROR(ex.stack)}
}

function setI32Volume( index ) {
    try{
        if(tv){
            model.tts.setI32Volume(parseInt(index));
        }
        setTtsKeyValue('volume' ,index);
    }catch(ex){DBG_ERROR(ex.stack)}
}

function getI32Pitch() {
    try{
        if (!tv) {
            return 30
        }else{
            return model.tts.getI32Pitch();
        }
    }catch(ex){DBG_ERROR(ex.stack)}
}

function setI32Pitch( index ) {
    try{
        if(tv){
            model.tts.setI32Pitch(parseInt(index));
        }
        setTtsKeyValue('pitch' ,index);
    }catch(ex){DBG_ERROR(ex.stack)}

}

function getI32LangIdx() {
    try{
        if(!tv){
            return 0
        }else{
           return model.tts.getI32LangIdx();
        }
    }catch(ex){DBG_ERROR(ex.stack)}
}

function setI32LangIdx( index ) {
    try{
        if(tv){
            model.tts.setI32LangIdx(parseInt(index));
        }
        setTtsKeyValue('lang' ,index);
    }catch(ex){DBG_ERROR(ex.stack)}
}

function getI32Speed() {
    try{
        if (!tv) {
            return 2
        }else{
            return model.tts.getI32Speed();
        }
    }catch(ex){DBG_ERROR(ex.stack)}

}

function setI32Speed( index ) {
    try{
        if (tv) {
            model.tts.setI32Speed(parseInt(index))
        }
        setTtsKeyValue('rate' ,index);
    }catch(ex){DBG_ERROR(ex.stack)}
}

function getI32FocusSpeechAudio() {
    try{
        if (!tv) {
            return 1;
        }else{
            return model.tts.getI32FocusSpeechAudio();
        }
    }catch(ex){DBG_ERROR(ex.stack)}
}

function setI32FocusSpeechAudio( type ) {
    try{
        var volume = type ? 50 : 100;
        DBG_INFO('SpeechAudio :'+volume);
          if(tv){
              model.tts.setI32FocusSpeechAudio(type);
              Hisense.System.setTTSBgVol(volume);
          }
    }catch(ex){DBG_ERROR(ex.stack)}
}


function setTtsKeyValue(key, value){
    try{
        DBG_INFO('tts key['+key+'],value['+value+']');
        if(UI.ttsUtterance){
            switch (key){
                case 'lang':
                    ttsLangHandler(value);
                    break;
                case 'pitch':
                    ttsPitchHandler(value);
                    break;
                case 'rate':
                    ttsRateHandler(value);
                    break;
                case 'volume':
                    ttsVolumeHandler(value);
                    break;
                default :
                    break;
            }
        }else{
            DBG_ERROR('UI.ttsUtterance is :'+UI.ttsUtterance);
        }

    }catch(ex){DBG_ERROR(ex.stack)}
}

function initTtsValueHandler(){
    try{
        ttsLangHandler( getI32LangIdx());
        ttsPitchHandler( getI32Pitch());
        ttsRateHandler( getI32Speed());
        ttsVolumeHandler( getI32Volume());
        setI32FocusSpeechAudio( getI32FocusSpeechAudio());
    }catch(ex){DBG_ERROR(ex.stack)}
}

function ttsLangHandler(index){
    var langArray=['en_US','es_ES'];
    if(index>langArray.length){
        DBG_ERROR('index is error:'+index);
    }
    //UI.ttsUtterance.lang=langArray[index];
    tv && Hisense.System.setTTSLanguage(langArray[index]);
    DBG_INFO('UI.ttsUtterance.lang:'+langArray[index])
}

function ttsPitchHandler(index){
    //UI.ttsUtterance.pitch=index/50;
    tv && Hisense.System.setTTSPitch(index*3+100);
    DBG_INFO("UI.ttsUtterance.pitch:"+index*3+100)
}

function ttsRateHandler(index){
    //UI.ttsUtterance.rate=rateArray[index];
    tv && Hisense.System.setTTSRate(index);
    DBG_INFO('UI.ttsUtterance.rate:'+index)
}

function ttsVolumeHandler(index){
    //UI.ttsUtterance.volume=index/100;
    tv && Hisense.System.setTTSVol(index);
    DBG_INFO('UI.ttsUtterance.volume:'+index)
}

function setVideoDescription(type){
    if (!!tv) {
        DBG_INFO("VideoDescriptiontype:" + type);
        model.sound.setAudioType(type);
        DBG_ALWAYS("nuaaywj call basic setting for audio mode,type:" + type);
        model.basicSetting.setEnumDvbAudioMode(type);
    }
}

function setTTSSwitch(type){
    if (!!tv) {
        if(type){
            Hisense.System.stopSpeaking();
        }
        model.tts.setI32SwitchStatus(type);
        Hisense.System.setTTSEnable(type);
    }
    GLOBAL.TTS = !!type;
}

function sendKeyToBluetooth(keyCode,v){
    try {
        tv ? model.bluetooth.sendKeyToBluetooth(CONST.BLUETOOTH_KEYMAP[keyCode],UI.keyState) : false;
    }
    catch (ex) {
        DBG_ERROR(ex.message);
    }
}

function if2SearchForB2b(){
    var tvSource = tv ?model.source.getCurrentSource():'TV';
    if(checkIsAppOn()||GLOBAL.MEDIA_STARTUP_FLAG ||(tvSource != 'TV')){
        return false;
    }
    return true;
}

function CheckB2BDisableFlag(){
    try {
        if(tv && !!B2BPara.GHASB2B){
            DBG_ALWAYS('model.b2b.getAvPositionFixed():'+model.b2b.getAvPositionFixed());
            if(model.b2b.getAvPositionFixed()==0){
                DBG_ALWAYS('b2bFirstUlDisable pic and sound');
                GLOBAL.B2BPicEnableFlag = false;
                GLOBAL.B2BSndEnableFlag = false;
            }else{
                if(tv && model.b2b.getVolumeFixedMode()==0){
                    DBG_ALWAYS('b2bFirstUlDisable sound');
                    GLOBAL.B2BSndEnableFlag = false;
                }else{
                    GLOBAL.B2BSndEnableFlag = true;
                    DBG_ALWAYS('b2bFirstUlNormal sound');
                }
                GLOBAL.B2BPicEnableFlag = true;
                DBG_ALWAYS('b2bFirstUlNormal picture ');
            }
        }
    } catch (ex) {
        DBG_ERROR(ex.message);
    }
}

function openChAutoScanPage(){
    var hasParentLock = tv ? model.parentlock.getSModel(): 1;
    DBG_INFO("hasParentLock:::::"+ hasParentLock);
    var hasChannels = liveTV.getHasChannelFlag();
    DBG_INFO("hasChannels:::::"+ hasChannels);
    if(hasParentLock){
        GLOBAL.StartSearchFromLiveTV = true;
        GLOBAL.LockParentIndex = LockParent.AUTOSCAN;
        UI.pushSubModule("setting", "ChParLockInputDialog", true);
    }else{
        if(hasChannels){
            GLOBAL.StartSearchFromLiveTV = true;
            UI.pushSubModule("setting", "ChClearChannelDialog", true);
        } else{
            GLOBAL.StartSearchFromLiveTV = true;
            UI.pushSubModule("setting", "ChAutoScanPanel", true);
        }
    }
}

/*  the function about ACR */

function sendMsg(){
    AcrJSI.poke();
    setTimeout(function() {sendMsg();}, 60000);
}
function startAcrNotification(cos){
    clearTimeout(g_acrCmdTimeout);
    g_acrSwitch.acrNotification = cos;

    g_acrCmdTimeout = setTimeout(function() {
        saveAcrSwitchData();
    }, 300);
}
function startAcrServer(cos){
    clearTimeout(g_acrCmdTimeout);
    g_acrSwitch.settingSwitch = AcrSwitch.ON;
    if(cos == "Setting" || cos == "FTE"){
        g_acrSwitch.lastSettingSwitch = g_acrSwitch.settingSwitch;
    }
    g_acrCmdTimeout = setTimeout(function() {
        saveAcrSwitchData();
        startAcrServerSendCmd(cos);}, 1000);
    try{
        var SettingSysAdv = UI.getSubModule("SettingSysAdv");
        if (!!SettingSysAdv) {
            SettingSysAdv.freshACRstatus(true);
        }

    }catch(e){
        DBG_ERROR(e.message)
    }
}
function startAcrServerSendCmd(cos){
    DBG_ERROR("!!!!!!!!!!!!!startAcrServer!!!!!!!!!!" + cos);
    g_acrSwitch.acrStatus = AcrStatus.ACR_START;
    AcrJSI.startAcr(true, cos);
    if(g_acrSwitch.acrPeriod == 0){
        g_acrSwitch.acrPeriod = getSystemLongTime()+60*60*24*30*g_acrSwitch.acrPeriodIndex;
        saveAcrSwitchData();
    }
//    setTimeout(function() {AcrJSI.poke();}, 15000);
//    setTimeout(function() { sendMsg();}, 60000);
}

function stopAcrServer(cos){
    clearTimeout(g_acrCmdTimeout);
    g_acrSwitch.settingSwitch = AcrSwitch.OFF;
    if(cos == "Setting" || cos == "FTE"){
        g_acrSwitch.lastSettingSwitch = g_acrSwitch.settingSwitch;
    }
    g_acrCmdTimeout = setTimeout(function() {
        saveAcrSwitchData();
        stopAcrServerSendCmd(cos);}, 1000);
    try{
        var SettingSysAdv = UI.getSubModule("SettingSysAdv");
        if (!!SettingSysAdv) {
            SettingSysAdv.freshACRstatus(false);
        }

    }catch(e){
        DBG_ERROR(e.message)
    }
}
function stopAcrServerSendCmd(cos){
    DBG_ERROR("!!!!!!!!!!!!!stopAcrServer!!!!!!!!!!" + cos);
    g_acrSwitch.acrStatus = AcrStatus.ACR_STOP;
    AcrJSI.startAcr(false, cos);
}

function setAcrPeriod(index){
    g_acrSwitch.acrPeriodIndex = index;
    g_acrSwitch.acrPeriod = getSystemLongTime()+60*60*24*30*g_acrSwitch.acrPeriodIndex;
    //todo start acr
    saveAcrSwitchData();
}
function initInputSourceForACR(){
    if(!acrflag){
        return;
    }
    var sourceMap = {
        0: "TV",
        1: "AV",
        2: "COMPONENT",
        3: "VGA",
        4: "HDMI 1",
        5: "HDMI 2",
        6: "HDMI 3",
        7: "HDMI 4",
        8: "SCART"
    };

    var curSourceId = getCurrentSourceId();
    try {
        AcrJSI.inputSource("inputName",sourceMap[curSourceId]);
        if(curSourceId == 0){
            var mainPlay = model.tvservice.getMainPlay();
            if(mainPlay.length > 0 && !!mainPlay[MPChannel.NAME]){
                AcrJSI.inputSource("channelName",mainPlay[MPChannel.NAME]);
            }
        }

        var info = GLOBAL.CURRENT_LANGUAGE  + '_'+ GLOBAL.CURRENT_COUNTRY;
        var acrInfo = info.toLowerCase();
        AcrJSI.inputSource("localeName",acrInfo);

        var map = {
            0: "Eastern",
            1: "Indiana",
            2: "Central",
            3: "Mountain",
            4: "Arizona",
            5: "Pacific",
            6: "Alaska",
            7: "Hawaii",
//            8: "Alaska",
            9: "Newfoundland",
            10: "Atlantic"
        };
        var temp =tv? model.datetime.getTimeZone():0;
        AcrJSI.inputSource("deviceLocation",map[temp]);

//        var serviceNo = tv?model.system.getServiceNo():"aa";
        var serviceNo = tv?model.hisfactory.getProductType():"aa";

        AcrJSI.inputSource("modelName",serviceNo);

    }catch (e) {
        DBG_ERROR("initInputSourceForACR:"+ e.message);
    }


}

function readXMLDOM(url, workRoot) {
    if (!Config.tv) {
        var xmlBasePath = (workRoot == 2) ? '../' : "../../appdata/";
        var dom = loadxmldoc(xmlBasePath + url + "?time=" + Date.now());
        return dom;
    }
    var dom = null;
    DBG_INFO('xml path = ' + url + '; workRoot = ' + workRoot);
    var obj = Hisense.File.read(url, workRoot);
    if (isNaN(obj)) {
        try {
            dom = (new DOMParser()).parseFromString(obj, "text/xml");
        }
        catch (e) {
            DBG_INFO("launcher_debug_readXML_error:" + e.message, DebugLevel.ERROR);
            dom = null;
        }
        return dom;
    }
    else {
        DBG_INFO("error in reading xml: " + obj, DebugLevel.ERROR);
        return null;
    }
}

function loadxmldoc(x) {
    try {
        DBG_INFO("XMLHttpRequest[" + x + "]");
        var xmlDoc;
        if (window.ActiveXObject) {
            xmlDoc = new ActiveXObject("Microsoft.XMLDOM");
            xmlDoc.async = false;
            xmlDoc.load(x);
        }
        else if (window.XMLHttpRequest) {
            xmlDoc = getxml(x).responseXML;
        }
        else {
            return false;
        }


        return xmlDoc;
    }
    catch (ex) {
        DBG_ERROR(ex.message);
        return null;
    }
}
var xmlhttpMain = null;
function getxmlhttp() {
    if (window.ActiveXObject) {
        try {
            xmlhttpMain = new ActiveXObject("Msxml2.XMLHTTP");
        }
        catch (e) {
            xmlhttpMain = new ActiveXObject("Microsoft.XMLHTTP");
        }
    }
    else if (window.XMLHttpRequest) {
        xmlhttpMain = new XMLHttpRequest();
    }
    return xmlhttpMain;
}

function getxml(x) {
    if (null == xmlhttpMain) {
        getxmlhttp();
    }
    if (xmlhttpMain != null) {
        xmlhttpMain.open("GET", x, false);
        xmlhttpMain.send(null);
    }
    else {
        DBG_INFO("Your browser does not support XMLHTTP.11");
        return false;
    }
    return (xmlhttpMain);
}

function saveAcrSwitchData(){
    if(!acrflag || !isCurCountryhasACR()){
        return;
    }
    if (tv) {
        writeFileToNative('launcher/acrSwitch.json', objToString(g_acrSwitch), 1);
    }
}
function getServiceSwitchJSON(dom){
    var srvjson = {
        acrFlag: 1
    };
    try {
        if(null != dom) {
            srvjson.acrFlag = dom.getElementsByTagName("acrFlag")[0].textContent;
        }
    }
    catch (ex){
        DBG_ERROR(ex.message);
    }
    return srvjson;
}

function initAcrServer() {
    if(!acrflag){
        return;
    }
    DBG_ERROR("!!!!!!!!!!!!!initAcrServer Acr!!!!!!!!!!1111111111111");
    try{
    var srvUpdate = {},
        switchDom = readXMLDOM('launcher/data/SwitchFeatureList.xml', 1),
        switchJson = getServiceSwitchJSON(switchDom);
    if (null != switchJson) {
        srvUpdate.acrFlag = switchJson.acrFlag;
    }
    else {
        srvUpdate.acrFlag = AcrSwitch.ON;
    }
    }catch(e){

    }
    g_acrSwitch.GlobalSwitch = srvUpdate.acrFlag;
    var acrSwitch = readFileFromNative('launcher/acrSwitch.json', 1);
    if (null == acrSwitch) {
        g_acrSwitch.settingSwitch = AcrSwitch.OFF;
        g_acrSwitch.lastSettingSwitch = AcrSwitch.OFF;
        g_acrSwitch.acrPeriod = 0;
        g_acrSwitch.acrNotification = AcrSwitch.ON;
        g_acrSwitch.acrPeriodIndex = 12;

    }else{
        g_acrSwitch.settingSwitch = acrSwitch.settingSwitch;
        g_acrSwitch.lastSettingSwitch = acrSwitch.lastSettingSwitch;
        g_acrSwitch.settingSwitch = acrSwitch.lastSettingSwitch;
        g_acrSwitch.acrPeriod = acrSwitch.acrPeriod;
        g_acrSwitch.acrNotification = acrSwitch.acrNotification;
        g_acrSwitch.acrPeriodIndex = acrSwitch.acrPeriodIndex;
    }
    if(g_acrSwitch.GlobalSwitch == AcrSwitch.OFF){
        DBG_ERROR("ACR doesn't start cos of Global Switch when power on");
//        stopAcrServerSendCmd("GLOBAL");
//        g_acrSwitch.lastSettingSwitch = g_acrSwitch.settingSwitch;
        g_acrSwitch.settingSwitch = AcrSwitch.OFF;
    }else{
        if(g_acrSwitch.settingSwitch == AcrSwitch.OFF){
            DBG_ERROR("ACR doesn't start cos of Setting Switch when power on");
//            stopAcrServerSendCmd("Setting");
        }else{
            if(model.system.getUserMode()!=0 || isTtsPlay()){
                g_acrSwitch.settingSwitch = AcrSwitch.OFF;
                DBG_ERROR("ACR doesn't start cos of tv is Store Mode or tts is On when power on");
            }else{
                DBG_ERROR("ACR start when power on");
                startAcrServerSendCmd("Setting");
            }
        }
    }
    saveAcrSwitchData();

}

function SetRecentUse(operstring, parentStr, substring) {
    try{
        if(!!operstring&&operstring!=""){
            var ret = Hisense.File.read("recentuse.txt",1);
            DBG_INFO("read recent fie ret  "+typeof ret);
            if(typeof ret=="string"&&ret!=''){
                var index=null;
                var recentuse=JSON.parse(ret);
                DBG_INFO("111111111111111111111")
                if(recentuse.length==4&&(recentuse[0].name!=undefined)&&(recentuse[0].parentStr!=undefined)&&(recentuse[0].pageStr!=undefined))
                {
                    DBG_INFO("2222222222222222")
                    for(var k=0;k<(recentuse.length<3?recentuse.length:3);k++)
                    {
                        if(recentuse[k].name==operstring)
                        {
                            index=k;
                            break;
                        }
                    }
                    if(index!=null)
                    {
                        DBG_INFO("index"+index)
                        if(index==1)
                        {
                            var temp= _cloneObj(recentuse[0]);
                            recentuse[0]=_cloneObj(recentuse[1]);
                            recentuse[1]=_cloneObj(temp);

                        }
                        else if(index==2)
                        {
                            var temp=_cloneObj( recentuse[0]);
                            recentuse[0]=_cloneObj(recentuse[2]);
                            recentuse[2]=_cloneObj(recentuse[1]);
                            recentuse[1]=_cloneObj(temp);
                        }
                        else if(index==3)
                        {
                            var temp=_cloneObj( recentuse[0]);
                            recentuse[0]=_cloneObj(recentuse[3]);
                            recentuse[3]=_cloneObj(recentuse[2]);
                            recentuse[2]=_cloneObj(recentuse[1]);
                            recentuse[1]=_cloneObj(temp);
                        }
                    }
                    else
                    {
                        recentuse[3]=_cloneObj(recentuse[2]);
                        recentuse[2]=_cloneObj(recentuse[1]);
                        recentuse[1]=_cloneObj(recentuse[0]);
                        recentuse[0].name=operstring;
                        recentuse[0].parentStr=parentStr;
                        recentuse[0].pageStr=substring;
                    }
                    DBG_INFO("set recent use "+JSON.stringify(recentuse));

                    Hisense.File.write("recentuse.txt", JSON.stringify(recentuse), 1);
                }
            }
        }

    }catch (e)
    {
        DBG_INFO(e.message);
    }
}


function getIsInlockTime() {
    var isInLock = 1;
    try {

        var dateTmpS = model.parentlock.getStart();
        var start = ChangeInttoTime(dateTmpS, 1);
        start.hour = parseInt(start.hour);
        start.min = parseInt(start.min);


        var dateTmpE = model.parentlock.getEnd();
        var end = ChangeInttoTime(dateTmpE, 1);

        end.hour = parseInt(end.hour);
        end.min = parseInt(end.min);


        var localTime = tv? model.datetime.getCurLocalTime(): Date.now();
        DBG_ERROR("getCurLocalTime "+localTime);
        var tempTime = new Date((localTime) * 1000);
        var current = {};
        current.hour = parseInt(tempTime.getUTCHours());
        current.min = parseInt(tempTime.getUTCMinutes());


        var twoDays = false;
        if(end.hour < start.hour) {
            end.hour = end.hour + 24;
        }
        else if(end.hour == start.hour) {
            if(end.min < start.min) {
                end.hour = end.hour + 24;
            }
        }
        DBG_INFO("current:" + JSON.stringify(current) + "start:" + JSON.stringify(start) + "end:" + JSON.stringify(end), DebugLevel.ALWAYS);

        if(!twoDays) {
            if(current.hour > start.hour) {
                if(current.hour < end.hour) {
                    isInLock = 1;
                }
                else if(current.hour == end.hour) {
                    if(current.min >= end.min) {
                        isInLock = 0;
                    }
                    else {
                        isInLock = 1;
                    }
                }
                else if(current.hour > end.hour) {
                    isInLock = 0;
                }
            }
            else if(current.hour == start.hour) {
                if(current.min >= start.min) {
                    if(current.hour < end.hour) {
                        isInLock = 1;
                    }
                    else if(current.hour == end.hour) {
                        if(current.min >= end.min) {
                            isInLock = 0;
                        }
                        else {
                            isInLock = 1;
                        }
                    }
                    else if(current.hour > end.hour) {
                        isInLock = 0;
                    }
                }
                else if(current.min < start.min) {
                    isInLock = 0;
                }
            }
            else if(current.hour < start.hour) {
                isInLock = 0;
            }
        }
    }
    catch (ex) {
        isInLock = 1;
        DBG_ERROR("getIsInlockTime: " + ex.message);
    }
    var endweekly = model.parentlock.getEndWeekly();
    DBG_INFO("endweekly:" +  objToString(endweekly));
    var weeklyArray = endweekly.split(",");
    var curweekly = [0, 0, 0, 0, 0, 0, 0];
    for(var i=0;i<weeklyArray.length;i++)
    {
        if(weeklyArray[i].toLowerCase() == "sun")
        {
            curweekly[0] = 1;
        }
        else if(weeklyArray[i].toLowerCase() == "mon")
        {
            curweekly[1] = 1;
        }
        else if(weeklyArray[i].toLowerCase() == "tue")
        {
            curweekly[2] = 1;
        }
        else if(weeklyArray[i].toLowerCase() == "wed")
        {
            curweekly[3] = 1;
        }
        else if(weeklyArray[i].toLowerCase() == "thu")
        {
            curweekly[4] = 1;
        }
        else if(weeklyArray[i].toLowerCase() == "fri")
        {
            curweekly[5] = 1;
        }
        else if(weeklyArray[i].toLowerCase() == "sat")
        {
            curweekly[6] = 1;
        }
    }
    var longtime = getSystemLongTime();
    var utcdate = new Date(getLocalTimeByUTC(longtime) * GLOBAL.MILLIBASE);
    var number = utcdate.getUTCDay();
    if(isInLock && curweekly[number]){
        isInLock = 1;
    }else{
        isInLock = 0;
    }
    DBG_INFO("isInLock is " + isInLock);
    return isInLock;
}

function KeyMTSHandler() {
    try{
        if(GLOBAL.NO_SIGNAL){
            DBG_INFO("NO SIGNAL");
            return;
        }
        if(GLOBAL.CURRENT_SOURCE !=SourceList.TV){
            DBG_INFO("Not TV");
            return;
        }
        var crntChannel = liveTV.getCurrentChannelInfo();
        if(CONST.ATV == crntChannel.type){
            var sapArr = ["[SE0828]","[SE0453]","[SE0827]"];//Mono,Stereo,SAP
            var sap = tv ? model.sound.getSap() : 1;
            var index = (sap+1)%3;
            DBG_INFO("model.sound.setSap:"+index);
            tv&&model.sound.setSap(index);
            GLOBAL.MTSToastStr = sapArr[index];
            UI.pushGhostModule("setting","MTSToast");
        }
        else{
            var audioLanlist= getAudioList();
            var audioTypeVec=["","Dolby D", "Dolby D+", "HE-AAC"];
            var tmpList = [];
            var tmpAudioList=[];
            DtvAudioLanguageInit();
            var audioList = crntDtvAudioList;
            DBG_ERROR("audioList: "+audioList+"audioList.length: "+audioList.length);
            for (var i = 0; i < audioList.length; i++) {
                var audioCode = audioList[i].audioIso639;
                var audioType = audioList[i].audioType;
                var audioPurpose= audioList[i].audioPurpose;
//                var audioTrackIndex = tv?model.sound.getAudioIdent():3;
//                DBG_ERROR("audioTrack:"+audioTrackIndex);
//                var audioTrack=getCurAudioIdent(audioTrackIndex);
                DBG_ERROR("audio Code: "+audioCode);
                DBG_ERROR("audio Type: "+audioType);
                DBG_ERROR("audio Purpose: "+audioPurpose);
                var audioTypeTmp=null;
                var flag = 0;
                for(var j = 0; j < audioLanlist.length; j++){
                    if(audioLanlist[j].value == audioCode) {
                        var tmpVar = audioLanlist[j].text;
                        if(!!audioType&&(audioType>0&&audioType<4)){
                            audioTypeTmp = audioTypeVec[audioType];
                        }
                        if(0){//!!audioTrack
//                            if(!!audioTypeTmp){
//                                tmpVar+=("("+audioTypeTmp+" "+audioTrack+")")
//                            }else{
//                                tmpVar+=("("+audioTrack+")")
//                            }
                        }else if(!!audioTypeTmp){
                            tmpVar+=("("+audioTypeTmp+")")
                        }
                        if(audioPurpose==1||audioPurpose==2){
                            tmpVar += "(AD)";
                        }else if(audioPurpose==3){
                            tmpVar += "[H.I]";
                        }else if(audioPurpose==4||audioPurpose==5){
                            tmpVar += "[V.I]";
                        }
                        tmpList.push(tmpVar);
                        flag = 1;
                        break;
                    }else{
                        flag = 0;
                    }
                }
                if(!flag){
                    tmpVar = audioCode;
                    if(!!audioType&&(audioType>0&&audioType<4)){
                        audioTypeTmp = audioTypeVec[audioType];
                    }
                    if(0){//!!audioTrack
//                        if(!!audioTypeTmp){
//                            tmpVar+=("("+audioTypeTmp+" "+audioTrack+")")
//                        }else{
//                            tmpVar+=("("+audioTrack+")")
//                        }
                    }else if(!!audioTypeTmp){
                        tmpVar+=("("+audioTypeTmp+")")
                    }
                    if(audioPurpose==1||audioPurpose==2){
                        tmpVar += "(AD)";
                    }else if(audioPurpose==3){
                        tmpVar += "[H.I]";
                    }else if(audioPurpose==4||audioPurpose==5){
                        tmpVar += "[V.I]";
                    }
                    tmpList.push(tmpVar);
                }
                if(tmpList.length > 0){
                    tmpAudioList = tmpList;
                }
            }
            var audioIndex = tv?model.tvservice.getAudioIndex():0;
            DBG_ERROR("model.tvservice.getAudioIndex:"+audioIndex);
            if(tmpAudioList.length>1){
                var index = (audioIndex+1)%(tmpAudioList.length);
                DBG_ERROR("model.system.setCurChannelAudioLanguageSelsect:"+index);
                tv&&model.system.setCurChannelAudioLanguageSelsect(index);
                GLOBAL.MTSToastStr = tmpAudioList[index];
                UI.pushGhostModule("setting","MTSToast");
            }
            else if(tmpAudioList.length==1){
                DBG_ERROR("curLanguageList:"+tmpAudioList);
                DBG_ERROR("audioIndex:"+audioIndex);
                GLOBAL.MTSToastStr = tmpAudioList[audioIndex];
                UI.pushGhostModule("setting","MTSToast");
            }else{
                GLOBAL.CURRENT_TOAST_TYPE = TOASTTYPE.AUDIO_LANGUAGE_TIP;
                UI.pushGhostModule("setting", "SettingSysToast");
            }
        }
    }
    catch (ex){
        DBG_ERROR(ex.message);
    }

}

function KeyNRTHandler(){
    try {
        if(GLOBAL.CURRENT_SOURCE !=SourceList.TV){
            DBG_INFO("Not TV");
            return;
        }
        if(!GLOBAL.TUNER_AVAILIBALE){
            DBG_ERROR('tuner available:'+GLOBAL.TUNER_AVAILIBALE+ ',disable NRT');
            return;
        }
        var VideoDesList = ["[SE2951]: [GE0006]", "[SE2951]: [GE0004]"];
        var type =tv ? model.sound.getAudioType() : 1;
        type = type ? 0 : 1;
        setVideoDescription(type);
        GLOBAL.MTSToastStr = VideoDesList[type];
        UI.pushGhostModule("setting","MTSToast");
    } catch (ex) {
        DBG_ERROR(ex.message);
    }
}

function KeyCCHandler(){
    try {
        if(!GLOBAL.TUNER_AVAILIBALE){
            DBG_ERROR('tuner available:'+GLOBAL.TUNER_AVAILIBALE+ ',disable cc');
            return;
        }
        var CCArr = ["[SE0832]","[SE0831]","[SE0833]"];//["CC Off","CC On","CC on when mute"];
        var CC = tv ? model.closedcaption.getControl() : 0;//var id=tv ? model.closedcaption.getControl():0;
        var index = (CC+1)%3;
        if(tv) model.closedcaption.setControl(index);
        DBG_INFO("model.closedcaption.setControl:"+index);
        GLOBAL.MTSToastStr = CCArr[index];
        UI.pushGhostModule("setting","MTSToast");
    } catch (ex) {
        DBG_ERROR(ex.message);
    }
}

function launcherPanelCloseReport(para){
    try{
        var param={
            PanelName:UI.getCurrSubModule().name,
            CloseReason:1
        };
        if(!!para){
            param.CloseReason=para.CloseReason;
        }
        if(param.PanelName=="notifications"||param.PanelName=="allApps"||param.PanelName=="allInputs")
        {
            DBG_INFO("log report GTLauncherPanel "+param.PanelName+" is closed");
            //logReport("GTLauncherPanel",param,0);
        }
    }catch(ex){DBG_ERROR(ex.message);}
}

function launcherPanelGlobalKeyProForLGReport(key){
    try{
        if(!UI.getCurrModule()||!UI.getCurrSubModule()||!UI.getCurrSubModule().name){
            DBG_ERROR('receive lgkey:'+key+',subModule is null,just return');
            return;
        }else{
            switch (UI.getCurrSubModule().name){
                case 'notifications':
                case 'allApps':
                case 'allInputs':
                    if(key=='onkey_LAUNCHER'||key=='onkey_LIVETV')
                        launcherPanelCloseReport();
                    break;
                default :break;
            }
            DBG_INFO('receive lgkey:'+key);
        }
    }catch(ex){DBG_ERROR('launcherPanelGlobalKeyProForLGReport is error:'+ex.message)}

}
function getPowerOnType(){
    DBG_INFO("getPowerOnType start " + new Date().getTime());
    try{
        var standbyType = tv ? parseInt(model.system.getOpenFromStandby()) : 0;
        DBG_ERROR("getPowerOnType:standbyType="+standbyType);
        switch (standbyType){
            case SystemModelDefines.ENUM_SYSTEM_OPEN_FROM_STANDBY_NETFLIX:
                standbyType = HOTEKEY_MAP.NETFLIX;
                clearTimeout(GLOBAL.UI_LOADING_TIMER);
                GLOBAL.UI_LOADING_TIMER = null;
                GLOBAL.APP_ENABLE_START_FLAG = true;
                break;
            case SystemModelDefines.ENUM_SYSTEM_OPEN_FROM_STANDBY_VUDU:
                standbyType = HOTEKEY_MAP.VUDU;
                break;
            case SystemModelDefines.ENUM_SYSTEM_OPEN_FROM_STANDBY_YOUTUBE:
                standbyType = HOTEKEY_MAP.YOUTUBE;
                break;
            case SystemModelDefines.ENUM_SYSTEM_OPEN_FROM_STANDBY_AMAZON:
                standbyType = HOTEKEY_MAP.AMAZON;
                break;
            default :
                standbyType = HOTEKEY_MAP.NONE;
                break;
        }
        return standbyType;
    }catch (ex){
        DBG_ERROR("getPowerOnType:"+ex.message);
        return 0;
    }
    DBG_INFO("getPowerOnType end " + new Date().getTime());

}
function getGameModeEnable() {
    var isDMPRuning = UI.isExistModule ('hiMedia');
    var isTunerChannel = tv ? model.source.getCurrentSource(): 0;
    var isAppOn = checkIsAppOn();
    DBG_ERROR("isDMPRuning: "+isDMPRuning+"isTunerChannel: "+isTunerChannel);
    if((isDMPRuning || (isTunerChannel == "TV")) && !isAppOn){
        return false;
    }
    return true;
}
function getPixMapEnable() {
    try {
        var disableFlag = tv?model.video.getHdmiZoom():0;
        DBG_INFO("model.video.getHdmiZoom(): " + disableFlag);
        return disableFlag;
    } catch (ex) {
        DBG_ERROR(ex.message);
    }
}
function getPanaramicEnable() {
    try {
        var disableFlag = tv?model.video.getPanoramicFlag():0;
        DBG_ERROR("model.video.getPanoramicFlag(): "+disableFlag);
        return disableFlag;
        var curSourceVideoFormat = tv ? model.tvservice.getCurrentSourceVideoFormat() : "20,576,3";
        DBG_INFO("model.tvservice.getCurrentSourceVideoFormat:" + JSON.stringify(curSourceVideoFormat));
        if (curSourceVideoFormat.length > 0) {
            var array = curSourceVideoFormat.split(",");
            //720x576或者720x480
            if (array.length > 1) {
                if (array[0] == 720 && array[1] == 576 ||
                    array[0] == 720 && array[1] == 480 ) {
                    return true;
                }
            }
        }
        return false;
    } catch (ex) {
        DBG_ERROR(ex.message);
    }
}
function checkAspectRatioEnAble() {
    try {
        DBG_INFO("checkAspectRatioEnAble()");
        var appGhost = UI.getGhostModule(APPMODULE.CONTROL);
        var isUhdFlag = tv ? model.video.getUhdFlag() : 0;
        var isDMPRuning = UI.isExistModule ('hiMedia');
        var isWeather = UI.isExistModule ('accuweather');
        if (appGhost != null || isUhdFlag == 1 || true == isDMPRuning ||true == isWeather) {
            DBG_INFO("false: " + appGhost +' ' + isUhdFlag + ' '+isDMPRuning);
            return false;
        } else {
            DBG_INFO("true: " + appGhost +' ' + isUhdFlag + ' '+isDMPRuning);
            return true;
        }
    } catch (ex) {
        DBG_ERROR(ex.message);
    }
}
function getPicSharpnessStep(){
    PicTunerStep.SharpnessStep = (SharpnessData.SharpnessBotMax-SharpnessData.SharpnessBotMin)
        /(SharpnessData.SharpnessValMax-SharpnessData.SharpnessValMin);
    return PicTunerStep.SharpnessStep
}
function getPicHueStep(){
    PicTunerStep.HueStep = (ColorTunerData.HueBotMax-ColorTunerData.HueBotMin)/(ColorTunerData.HueValMax-ColorTunerData.HueValMin);
    return PicTunerStep.HueStep;
}

function readStorage(key){
    return localStorage.getItem(key);
}

function writeStorage(key, value){
    if("string" != typeof (value)) {
        localStorage.setItem(key, objToString(value));
    }else{
        localStorage.setItem(key, value);
    }
}

function deleteStorage(key){
    localStorage.removeItem(key);
}

function clearAllStorage(){
    localStorage.clear();
}
function objToString(obj) {
    if (!!obj && !!obj.getstrings) {
        return obj.getstrings
    }
    return JSON.stringify(obj);
}

function strToObject(str) {
    var obj = null;
    try {
        obj = JSON.parse(str);
    }
    catch (ex) {
        obj = str;
        //DBG_INFO(str + ' to object error: ' + ex.message, DebugLevel.ERROR);
    }
    return obj;
}

function changeSourceByKey (uidlist) {
    var sourceid="";
    var temp=initAllInputsData();
    if (!!temp.sourceList) {
        for (var i = 0; i < temp.sourceList.length; i++) {
            var name=temp.sourceList[i].playId;
            for(var j=0;j<uidlist.length;j++){
                if(name.toLowerCase()==uidlist[j]){
                    sourceid=temp.sourceList[i].id;
                    break;
                }
            }

        }
    }
    if(sourceid!=""){
        UI.popAllModule();
        changeSourceTo(sourceid);
        openLiveTVModule([Msg.WAIT_SOURCE_CHANGE, 1]);
    }

}

var getOopenVchipRegionPage = function()
{
    try
    {
        var retval = {
            "datalist":[],
            "selectlist":[]
        }
        var temp=model.parentlock.getOpenVchip();
        DBG_ERROR("openVchip"+JSON.stringify(temp));
        try{
            var openVchip = JSON.parse(temp);
        }
        catch(ex) {
            DBG_ERROR(ex.message);
            openVchip={"Open V-chip":[]}
        }
        DBG_ERROR("openVchip"+JSON.stringify(openVchip))
        var regionNames = [];
        for (var i = 0; i < openVchip['Open V-chip'].length; i++)
        {
            regionNames[i] = openVchip['Open V-chip'][i]['regionName'];
        }

        retval.datalist = regionNames;
        return retval;
    }
    catch (e)
    {
        DBG_ERROR(e.message)
    }
};
var getOpenVchipDimensionPage = function(RegionSelect)
{
    try
    {
        var retval = {
            "datalist":[],
            "selectlist":[]
        }

        var openVchip = JSON.parse(model.parentlock.getOpenVchip());
        var dimensionNames = [];
        var dimensionInfo = openVchip['Open V-chip'][RegionSelect]['dimensionInfo'];

        for (var dimIdx = 0; dimIdx < dimensionInfo.length; dimIdx++)
        {
            dimensionNames[dimIdx] = dimensionInfo[dimIdx]['dimensionName'];
        }
        retval.datalist = dimensionNames;
        return retval;
    }
    catch (e)
    {
        DBG_ERROR(e.message)
    }
};
var getOpenVchipRatingValuePage = function(RegionSelect, DimensionSelect)
{
    try
    {
        var retval = {
            "datalist":[],
            "selectlist":[]
        }
        var temp=model.parentlock.getOpenVchip();
        DBG_ERROR("getOpenVchip"+JSON.stringify(temp));
        try{
            var openVchip = JSON.parse(temp);
        }
        catch(ex) {
            DBG_ERROR(ex.message);
            openVchip={"Open V-chip":[]}
        }

        //var openVchip = JSON.parse(this.getOpenVchip());
        var ratingValues = [];
        var selectList = [];
        var isFirstRatingNA = false;
        var ratingInfo = openVchip['Open V-chip'][RegionSelect]['dimensionInfo'][DimensionSelect]['ratingValue'];
        var settingValue = openVchip['Open V-chip'][RegionSelect]['dimensionInfo'][DimensionSelect]['setting'];

        if(!ratingInfo[0]['abbrev'].length)
        {
            DBG_INFO("first rating NA!");
            isFirstRatingNA = true;
        }

        for (var ratingIdx = 0; ratingIdx < ratingInfo.length; ratingIdx++)
        {
            if((ratingIdx == 0) && isFirstRatingNA)
            {
                continue;
            }
            else
            {
                ratingValues.push(ratingInfo[ratingIdx]['abbrev']);
            }
        }

        for (var i = 0; i < ratingInfo.length; i++)
        {
            if((i == 0) && isFirstRatingNA)
            {
                continue;
            }
            else
            {
                selectList.push(settingValue&(1<<i)?1:0)
            }
        }

        retval.datalist = ratingValues;
        retval.selectlist = selectList;

        return retval;
    }
    catch (e)
    {
        DBG_ERROR(e.message)
    }
};
var setLevelPage = function(regionSelect, dimensionSelect, ratingValueSelect, enLock)
{
    try
    {
        var openVchip = JSON.parse(model.parentlock.getOpenVchip());
        var ratingInfo = openVchip['Open V-chip'][regionSelect]['dimensionInfo'][dimensionSelect]['ratingValue'];
        var settingValue = openVchip['Open V-chip'][regionSelect]['dimensionInfo'][dimensionSelect]['setting'];
        var gradScale = openVchip['Open V-chip'][regionSelect]['dimensionInfo'][dimensionSelect]['graduatedScale'];

        var isFirstRatingNA = false;
        var ratingInfoLength = ratingInfo.length;
        if(!ratingInfo[0]['abbrev'].length)
        {
            DBG_INFO("first rating NA!");
            isFirstRatingNA = true;
        }

        if(isFirstRatingNA)
        {
            ratingInfoLength--;
            settingValue = settingValue>>1;
        }

        if(gradScale ==1)
        {
            if(!enLock)
            {
                for(var i = 0; i <= ratingValueSelect; i++)
                {
                    settingValue &= ~(1<<i);
                }
            }
            else
            {
                for(var i = ratingValueSelect; i < ratingInfoLength; i++)
                {
                    settingValue |= (1<<i);
                }
            }
        }
        else if(gradScale ==0)
        {
            if(!enLock)
            {
                settingValue &= ~(1<<ratingValueSelect);
            }
            else
            {
                settingValue |= (1<<ratingValueSelect);
            }
        }

        var selectList = [];
        for (var i = 0; i < ratingInfoLength; i++)
        {
            selectList.push(settingValue&(1<<i)?1:0)
        }

        if(isFirstRatingNA)
        {
            settingValue = settingValue<<1;
        }

        openVchip['Open V-chip'][regionSelect]['dimensionInfo'][dimensionSelect]['setting']=settingValue;
        model.parentlock.setOpenVchip(JSON.stringify(openVchip));

        return selectList;
    }
    catch (e)
    {
        DBG_ERROR(e.message)
    }
};
var DeviceInfo = {
    instance:"",
    createNew: function() {
        //自引用对象
        var deviceInfo = {};
        //设备标识码
        var deviceId= "";
        //版本信息
        var versionInfo = "";
        //机型信息
        var modelName = "";
        //品牌名称，该值也保存在initBrand全局变量中，后续考虑去掉
        var brandName = "";

        deviceInfo.setBrandName = function(param) {
            brandName = param;
        }
        deviceInfo.getBrandName = function() {
            return brandName;
        };
        //TODO 通过底层接口获取deviceId
        // deviceInfo.setDeviceId("");
        if(tv){
            //  deviceInfo.setVersionInfo(model.softupdate.getCurrentPacket());
            //deviceInfo.setModelName(getCurrentTVNO());
            deviceInfo.setBrandName(GLOBAL.UI_BRAND);
        }else{
            //  deviceInfo.setVersionInfo("");
            //  deviceInfo.setModelName("");
            deviceInfo.setBrandName(GLOBAL.UI_BRAND);
        }

        return deviceInfo;
    },
    getInstance:function(){
        if(!DeviceInfo.instance){
            DeviceInfo.instance = DeviceInfo.createNew();
        }
        return DeviceInfo.instance;
    }

};
/**
 * OEM特殊要求处理类
 */
var OEMFunction = {
    instance:"",
    createNew: function() {
        //自引用对象
        var o = {};

//        o.getLauncherTheme = function(){
//            if(DeviceInfo.getInstance().getBrandName()=="shp"){
//                return "shp/";
//            }else if(DeviceInfo.getInstance().getBrandName()=="his"){
//                return "his/";
//            }
//        }
        o.getBrandColor=function(){

            if(DeviceInfo.getInstance().getBrandName()=="his"){
                return "0x00a9c2"
            }else{
                return "0xbb2071"
            }

        }
        o.getBrandSelectFocusImage=function(){
            if(DeviceInfo.getInstance().getBrandName()=="shp"){
                return "setting/shp/ic_radiobutton_focused.png"
            }else {
                return "setting/his/ic_radiobutton_focused.png"
            }
        }
        o.sdkGetBrandColor=function(){

            if(DeviceInfo.getInstance().getBrandName()=="his"){
                return ["0x00a9c2","0x00a9c2"]
            }else{
                return ["0xA10764","0x80014E"]
            }

        }

        o.sdkGetBrandPicture = function(){
            if(DeviceInfo.getInstance().getBrandName()=="his"){
                return "sdk/ic_switch_on_his.png"
            }else {
                return "sdk/ic_switch_on_shp.png"
            }
        }
        return o;
    },
    getInstance:function(){
        if(!OEMFunction.instance){
            OEMFunction.instance = OEMFunction.createNew();
        }
        return OEMFunction.instance;
    }

};
function getCardWheelColor(){
    try {
        if(DeviceInfo.getInstance().getBrandName()=="his"){
            return CardColorDef.BLUEGREEN
        }else{
            return CardColorDef.ROSERED
        }
    } catch (ex) {
        DBG_ERROR(ex.message);
    }

}



function startFteFromSetting() {
       if (checkIsAppOn()) {
        DBG_ERROR("changeSourceTo:app is not stop,stop it then change source");
        appControl.stopCurrentApp();
        appStoppedFunc = function () {
            startFteFromSetting();
            appStoppedFunc = null;
        };
        return;
    }
    UI.popAllModule();
    UI.pushModule("FTE");
}
function onSystemPwrUseCaseChanged(val){
    DBG_ERROR("onSystemPwrUseCaseChanged:"+val);
    if(val == 0){
        UI.ttsCancel = true;
        UI.callTTS("[SE0983]",0,false,false);
    }
}
/**
 * 国家为美国时替换没有exit按键的操作提示
 * @returns {boolean}true:是美国；false：不是美国
 */
function isAmericanFlag() {
    var userCountry =GLOBAL.CURRENT_COUNTRY;
    DBG_ERROR("userCountry is :::: "+userCountry);
    if(userCountry == "" || userCountry == null){
        userCountry ="CAN";
    }
    if(userCountry == "USA"){
        return true;
    } else {
        //工厂下：美国（80），加拿大（81），墨西哥（82）
        var facCountry = tv ? model.hisfactory.getHisFactoryCountry() : "81";
        DBG_ERROR("facCountry is :::: " + facCountry);
        if (facCountry == "" || facCountry == null) {
            facCountry = "81";
        }
        if (facCountry == "80") {
            return true;
        }
    }
    return false;
}
/**
 * 封装了timeout的创建，逻辑中确保创建前清除前任变量。
 * @param timerName  timeout变量名
 * @param func 爆发方法
 * @param timeOut 爆发延时，单位： 毫秒
 * @returns {number|*}  timeout创建结果
 * @constructor
 */
function timerFunction(timerName,func,timeOut){
    if(!!timerName){
        clearTimeout(timerName);
    }
    var time = timeOut;
    if(time == null){
        time =0;
    }
    timerName =setTimeout(func,time);
    return timerName;
}

function getBoundsOfText(txt, fontSize) {
    if (!txt) txt = "";
    if (!fontSize) fontSize = "36px";
    try {
        var text = new PIXI.Text(txt,
            {
                fontFamily: "SourceSansPro-Light",
                fontSize: fontSize,
                fill: parseInt("0xffffff", 16),
                align: "center",
                wordWrapWidth: 500,
                wordWrap: false,
                lineHeight: 0
            });
        return text.getBounds();
    }
    catch (ex) {
        DBG_ERROR("getBoundsOfText: " + ex.message);
        return {x: 0, y: 0, width: 2, height: 2}
    }
}


function hideForAppStorePlay(alpha) {
    if(!alpha){
        UI.hideModule(launcher);
    }else{
        UI.showModule(launcher);
    }
    DBG_ERROR("hideForAppStorePlay:"+alpha);
    var appStoreDetail = UI.getSubModuleById("AppStore", "appStoreDetail");
    if (!!appStoreDetail) {
        appStoreDetail.alpha = alpha;
        if (0 == alpha) {
            appStoreDetail.onkey = function(focus, evt) {
                if (CONST.APP_BASE_KEY.indexOf(evt.keyCode) > -1) {
                    return true;
                }
                else {
                    DBG_ERROR("appStoreDetail alpha is 0, disable key")
                }
            }
        }
        else {
            appStoreDetail.onkey = null;
        }
    }
    var appStore = UI.getSubModuleById("AppStore", "appStore");
    if (!!appStore){
        appStore.alpha = alpha;
        if (0 == alpha) {
            appStore.onkey = function(focus, evt) {
                if (CONST.APP_BASE_KEY.indexOf(evt.keyCode) > -1) {
                    return true;
                }
                else {
                    DBG_ERROR("appStore alpha is 0, disable key")
                }
            }
        }
        else {
            appStore.onkey = null;
        }
    }
    var search = UI.getSubModuleById("searchUSO", "search");
    if (!!search){
        search.alpha = alpha;
        if (0 == alpha) {
            search.onkey = function(focus, evt) {
                if (CONST.APP_BASE_KEY.indexOf(evt.keyCode) > -1) {
                    return true;
                }
                else {
                    DBG_ERROR("search alpha is 0, disable key")
                }
            }
        }
        else {
            search.onkey = null;
        }
    }
    var searchAppDetail = UI.getSubModuleById("searchUSO", "searchAppDetail");
    if (!!searchAppDetail){
        searchAppDetail.alpha = alpha;
        if (0 == alpha) {
            searchAppDetail.onkey = function(focus, evt) {
                if (CONST.APP_BASE_KEY.indexOf(evt.keyCode) > -1) {
                    return true;
                }
                else {
                    DBG_ERROR("searchAppDetail alpha is 0, disable key")
                }
            }
        }
        else {
            searchAppDetail.onkey = null;
        }
    }
    var searchMovieDetail = UI.getSubModuleById("searchUSO", "searchMovieDetail");
    if (!!searchMovieDetail){
        searchMovieDetail.alpha = alpha;
        if (0 == alpha) {
            searchMovieDetail.onkey = function(focus, evt) {
                if (CONST.APP_BASE_KEY.indexOf(evt.keyCode) > -1) {
                    return true;
                }
                else {
                    DBG_ERROR("searchMovieDetail alpha is 0, disable key")
                }
            }
        }
        else {
            searchMovieDetail.onkey = null;
        }
    }
    var searchMovieDetailV = UI.getSubModuleById("searchUSO", "searchMovieDetailV");
    if (!!searchMovieDetailV){
        searchMovieDetailV.alpha = alpha;
        if (0 == alpha) {
            searchMovieDetailV.onkey = function(focus, evt) {
                if (CONST.APP_BASE_KEY.indexOf(evt.keyCode) > -1) {
                    return true;
                }
                else {
                    DBG_ERROR("searchMovieDetailV alpha is 0, disable key")
                }
            }
        }
        else {
            searchMovieDetailV.onkey = null;
        }
    }
    var forknowMain = UI.getSubModuleById("fourknow", "fourknowMain");
    if (!!forknowMain){
        forknowMain.alpha = alpha;
        if (0 == alpha) {
            forknowMain.onkey = function(focus, evt) {
                if (CONST.APP_BASE_KEY.indexOf(evt.keyCode) > -1) {
                    return true;
                }
                else {
                    DBG_ERROR("forknowMain alpha is 0, disable key")
                }
            }
        }
        else {
            forknowMain.onkey = null;
        }
    }
    var fourknowDetailpage = UI.getSubModuleById("fourknow", "fourknowDetailpage");
    if (!!fourknowDetailpage){
        fourknowDetailpage.alpha = alpha;
        if (0 == alpha) {
            fourknowDetailpage.onkey = function(focus, evt) {
                if (CONST.APP_BASE_KEY.indexOf(evt.keyCode) > -1) {
                    return true;
                }
                else {
                    DBG_ERROR("fourknowDetailpage alpha is 0, disable key")
                }
            }
        }
        else {
            fourknowDetailpage.onkey = null;
        }
    }
    var fourknowAppDetail = UI.getSubModuleById("fourknow", "fourknowAppDetail");
    if (!!fourknowAppDetail){
        fourknowAppDetail.alpha = alpha;
        if (0 == alpha) {
            fourknowAppDetail.onkey = function(focus, evt) {
                if (CONST.APP_BASE_KEY.indexOf(evt.keyCode) > -1) {
                    return true;
                }
                else {
                    DBG_ERROR("fourknowAppDetail alpha is 0, disable key")
                }
            }
        }
        else {
            fourknowAppDetail.onkey = null;
        }
    }

    var launcherMovieDetail = UI.getSubModuleById("launcher", "launcherMovieDetail");
    if (!!launcherMovieDetail){
        launcherMovieDetail.alpha = alpha;
        if (0 == alpha) {
            launcherMovieDetail.onkey = function(focus, evt) {
                if (CONST.APP_BASE_KEY.indexOf(evt.keyCode) > -1) {
                    return true;
                }
                else {
                    DBG_ERROR("launcherMovieDetail alpha is 0, disable key")
                }
            }
        }
        else {
            launcherMovieDetail.onkey = null;
        }
    }

    if (alpha == 1) {
        UI.focusTo(UI.getCurrFocus());
        UI.setKeyGroup(7);
        UI.registerKeyCodes();
    }
    UI.updateStage();
}
function onOttShowPwdDialogChanged(val){
    DBG_ERROR("onOttShowPwdDialogChanged--------------------:"+val);
    if(val == 1){ //hide
        registerKeyCodesForUI();
        model.system.setOttPwdCheckFlag(0);
        model.system.setOttCurSourceLocked(1);
        UI.pushSubModule("common", "commonPasswordDialog", true, {caller: "showPasswordDialogForOTT"});
    }else if(val == 0){  //show
        if( UI.getCurrSubModule().name=="commonPasswordDialog"){
            UI.popSubModule();
            if(checkIsAppOn())
            {
                registerKeyCodesForApp();
            }
        }

    }
}
function checkIsOTTLock(){

    var curApp ;
    var appblockflag;
    if(GLOBAL.UNLOCKED){
        return false;
    }
    curApp =appControl.getCurrentAPPName();
    DBG_ERROR("curApp"+curApp);
    var ott = readFileFromNative("launcher/ott.txt", 1);
    DBG_ERROR("curr  source  OTT  is "+ JSON.stringify(ott));
    if(!tv)ott = {"name":"Xumo","url":"https://hisense-lite-app.xumo.com/latest/index.html"};
    if(ott!=null && ott.name != 0 ){

    }else{
        return false;
    }

    var deletedApps = readFileFromNative('launcher/lockedApp.txt', 1);
    if (null == deletedApps) {
        return false;
    }
    for (var i = 0; i < deletedApps.length; i++) {
        if ($.inArray(ott.url, deletedApps) > -1) {
            DBG_ALWAYS("ott:have locked");
            appblockflag = true;
            break;
        }
    }

//    if(g_ottList.length>0){
//        for(var x=0;x<g_ottList.length;x++){
//            if(g_ottList[x].data.url == ott.url){
//                appblockflag=g_ottList[x].Locked;
//                break;
//            }
//        }
//    }
    DBG_ERROR("appblockflag"+appblockflag);
    var isLock = false;
    if(appblockflag&&curApp==APPNAME.OTT){
        var sMode = tv?model.parentlock.getSModel():1;
        var lockTime =  getIsInlockTime();
        DBG_ERROR("sMode"+sMode);
        DBG_ERROR("lockTime"+lockTime);
        if(sMode!=0 && lockTime==1){
            isLock = true;
        }
    }
    else
    {
        isLock = false;
    }
    return isLock;
}

function setOttToDefaultSource(url,id){
    var obj = {
        "id":id,
        "url":url
    };
    writeFileToNative("launcher/DefaultSource.txt",objToString(obj), 1);
}

function UI_Hisense_GetParentControls(){
    var ratingJson = {
        enable:0,
        US_TV_Ratings:"OFF",
        Unrated:"OFF",
        US_TV_Children_Ratings:"OFF",
        US_MOVIE_Ratings:"OFF",
        Canadian_English_Ratings:"OFF",
        Canadian_French_Ratings:"OFF"
    };

    if(tv){
        ratingJson.enable = model.parentlock.getSModel();
        var templist=model.parentlock.getUsTvRating();
        var arrayList = [];
        for(var i=0;i<6;i++)
        {
            arrayList.push(templist[i*6]);
        }
        // 0 : Y  1: Y7  2:G  3:PG 4:14    5:MA
        if(arrayList.length == 6){
            if(arrayList[0] == 1){
                ratingJson.US_TV_Children_Ratings = "TV-Y";
                ratingJson.US_TV_Ratings = "TV-Y";
            }else if(arrayList[1] == 1){
                ratingJson.US_TV_Children_Ratings = "TV-Y7";
                ratingJson.US_TV_Ratings = "TV-Y7";
            }else if(arrayList[2] == 1){
                ratingJson.US_TV_Ratings = "TV-G";
            }else if(arrayList[3] == 1){
                ratingJson.US_TV_Ratings = "TV-PG";
            }else if(arrayList[4] == 1){
                ratingJson.US_TV_Ratings = "TV-14";
            }else if(arrayList[5] == 1){
                ratingJson.US_TV_Ratings = "TV-MA";
            }
        }

        var usmovielist = ["G", "PG", "PG-13", "R", "NC-17", "X"];
        var movieRating = model.parentlock.getUsMovieRating();

        if(movieRating>=0 && movieRating<=5){
            ratingJson.US_MOVIE_Ratings = usmovielist[movieRating];
        }

        var canadaenglist = ["C", "C8+", "G", "PG", "14+", "18+"];
        var canEngRating = model.parentlock.getCanEnglishRating();

        if(canEngRating>=0 && canEngRating<=5){
            ratingJson.Canadian_English_Ratings = canadaenglist[canEngRating];
        }

        var canadafrelist =  ["G", "8ans+", "13ans+", "16ans+", "18ans+"];

        var canFreRating = model.parentlock.getCanFrenchRating();

        if(canFreRating>=0 && canFreRating<=4){
            ratingJson.Canadian_French_Ratings = canadafrelist[canFreRating];
        }
        if (model.parentlock.getBlockUnrated() == 1) {
            ratingJson.Unrated = "Unrated";
            DBG_INFO("getBlockUnrated 0")
        }
    }else{
        ratingJson = {"enable":1,Unrated:"OFF","US_TV_Ratings":"OFF","US_TV_Children_Ratings":"OFF","US_MOVIE_Ratings":"OFF","Canadian_English_Ratings":"OFF","Canadian_French_Ratings":"OFF"}
    }
    DBG_ERROR("UI_Hisense_GetParentControls:"+objToString(ratingJson));
    return ratingJson;
}

function showNetworkToastNeverSet(){
    if (checkIsAppOn(APPNAME.NETFLIX) || model.system.getNotificationSwitch()==0 ||
        GLOBAL.FACTORY == 1){
        UI.updateStage();
        return;
    }
    var duration  = parseInt(model.timerfunc.getTvRunningTime())/60;
    DBG_ERROR("showNetworkToastNeverSet duration:"+duration);
    if(duration >= 24){
        var networkConfig = tv?readFileFromNative('networkConfig.txt', 1):{"netwok":0,"dlna":0};
        if(networkConfig == null || networkConfig.netwok == 0){
            UI.pushGhostModule("networkSetToast", "networkSetToast",{caller: "network"});
            setTimeout(function(){UI.popGhostModule("networkSetToast")},8*1000);
            try{
                if(networkConfig == null){
                    var info = {"netwok":1,"dlna":0};
                    if(tv)writeFileToNative("networkConfig.txt", objToString(info), 1);
                }else{
                    if(networkConfig.netwok == 0){
                        networkConfig.netwok = 1;
                        if(tv)writeFileToNative("networkConfig.txt", objToString(networkConfig), 1);
                    }
                }
            }
            catch (ex){
                DBG_ERROR(ex.message);
            }
        }else{
            if(networkConfig.dlna == 0){
                if(duration >= 40){
                    UI.pushGhostModule("networkSetToast", "networkSetToast",{caller: "dlna"});
                    setTimeout(function(){UI.popGhostModule("networkSetToast")},8*1000);
                }
                try{
                    networkConfig.dlna = 1;
                    if(tv)writeFileToNative("networkConfig.txt", objToString(networkConfig), 1);
                }
                catch (ex){
                    DBG_ERROR(ex.message);
                }
            }
        }
    }
}

function startSearchAppByVoice(keyword){
    UI.popAllModule();
    startThirdPartyApp(APPNAME.SEARCH, "search-hisense", CMDType.NATIVEAPP, CMDMethod.REMOTECONTROL, false,null,{caller: "voice",key:keyword});
//    UI.pushSubModule("searchUSO", "search", true, {caller: "voice",key:keyword});

}
function setTvName(name) {
    try {
        GLOBAL.OLD_NAME = model.system.getMachinename();
        if(avs_support || avg_support){
        AVSClient.register.reportDeviceName(name, false);
        }
        model.system.setMachinename(name);
        DBG_ERROR("name is " + name );
    }catch (e) {
        DBG_ERROR(e.message)
    }
}

function onTvNameReportChanged(val){
    DBG_ERROR("onTvNameReportChanged val is "  + val);//0(OK);1(dup_name);2(Failed)
    if(UI.getCurrModule().name == "Alexa")return;
    if(val == 0){
        UI.pushSubModule("setting","SettingSysAdvRenameOK",true);
        // registerUpdate(1);
    }else if(val == 1){
//            showWifiConnectToast(SHOW,dupText);
        //  GLOBAL.CURRENT_TOAST_TYPE=TOASTTYPE.AVS_DUPLEX_NAME;
        //  UI.pushGhostModule("setting","SettingSysToastBig");
        openMsgBoxByType(MsgBoxType.AVS_DEVICE_DUPLICATE);
    }else{
        GLOBAL.CURRENT_TOAST_TYPE=TOASTTYPE.AVS_NETWORK_ERROR;
        UI.pushGhostModule("setting","SettingSysToastBig");
    }
}

function registerKeyCodesForKeypad() {
    DBG_INFO("registerKeyCodesForKeypad");
    try {
        appControl.registerAppKeyCodes([],[CONST.KEY.VK_UP,CONST.KEY.VK_DOWN,CONST.KEY.VK_LEFT,CONST.KEY.VK_RIGHT,CONST.KEY.VK_ENTER,CONST.KEY.VK_BACKSPACE,CONST.KEY.VK_EXIT]);
        UI.setKeyGroup(7);
    } catch(e) {
        DBG_ERROR("registerKeyCodesForKeypad is wrong: " + e.message);
    }
}

function  startAppByVoice(name){
    var appInfo = null;
    var appName = name.toLowerCase().replace(" ", "");
    var mainNameArr = name.split(" ");
    var mainName = name;
    if (mainNameArr.length > 1) {
        mainName = mainNameArr[0].toLowerCase();
    }
    try{
        for (var i = 0; i < launcher.allAppsData.imgs.length; i++) {
            var tmpName = launcher.allAppsData.txts[i].toLowerCase().replace(" ", "");
            DBG_ALWAYS("all apps name is: " + launcher.allAppsData.txts[i]);
            if(appName == tmpName){
                appInfo = {
                    "url": launcher.allAppsData.urls[i],
                    "name": launcher.allAppsData.txts[i],
                    "urlType": launcher.allAppsData.urlTypes[i],
                    "storeType": launcher.allAppsData.storeTypes[i]
                };
                break;
            }
            if(tmpName.indexOf(mainName)>-1){
                appInfo = {
                    "url": launcher.allAppsData.urls[i],
                    "name": launcher.allAppsData.txts[i],
                    "urlType": launcher.allAppsData.urlTypes[i],
                    "storeType": launcher.allAppsData.storeTypes[i]
                };
                break;
            }
        }
    }catch(e){
        DBG_ERROR("launcher all app is null!!!");
    }
    if(appInfo ==null){
        DBG_ERROR("Can not find the app from launcher!!!!"+name);
        var preApps = readFileFromNative('launcher/preset.txt', 1);
//        var preApps = {"AppInfo":[{"AppName":"Netflix","IconURL":"launcher/app/launcher1/netflix.png","InstallTime":"","RunTimes":0,"URL":"netflix","StartCommand":"netflix","UrlType":37,"StoreType":98,"PreInstall":true},{"AppName":"YouTube","IconURL":"launcher/app/launcher1/youtube.png","InstallTime":"","RunTimes":0,"URL":"youtube","StartCommand":"youtube","UrlType":37,"StoreType":98,"PreInstall":true},{"AppName":"ClaroVideo","IconURL":"launcher/app/launcher1/clarovideo.png","InstallTime":"","RunTimes":0,"URL":"http://tv2hisense.clarovideo.net/FRONTEND/","StartCommand":"http://tv2hisense.clarovideo.net/FRONTEND/","UrlType":37,"StoreType":98,"PreInstall":true},{"AppName":"YouTube Kids","IconURL":"launcher/app/launcher1/youtubekids.png","InstallTime":"","RunTimes":0,"URL":"youtube_kids","StartCommand":"youtube_kids","UrlType":37,"StoreType":98,"PreInstall":true},{"AppName":"TV Browser","IconURL":"launcher/app/launcher1/TVBrowser.png","InstallTime":"","RunTimes":0,"URL":"browser","StartCommand":"browser","UrlType":37,"StoreType":98,"PreInstall":true},{"AppName":"Media","IconURL":"launcher/app/launcher1/media.png","InstallTime":"","RunTimes":0,"URL":"media","StartCommand":"media","UrlType":37,"StoreType":98,"PreInstall":true},{"AppName":"Search","IconURL":"launcher/app/launcher1/search-his.png","InstallTime":"","RunTimes":0,"URL":"SearchNow","StartCommand":"SearchNow","UrlType":37,"StoreType":81,"PreInstall":true},{"AppName":"Anyview Cast","IconURL":"launcher/app/launcher1/anyviewcast.png","InstallTime":"","RunTimes":0,"URL":"miracast","StartCommand":"miracast","UrlType":37,"StoreType":98,"PreInstall":true},{"AppName":"Game Center","IconURL":"launcher/app/launcher1/gamecenter.png","InstallTime":"","RunTimes":0,"URL":"gamecenter","StartCommand":"gamecenter","UrlType":37,"StoreType":98,"PreInstall":true},{"AppName":"Vewd","IconURL":"launcher/app/launcher1/OperaTVStore.png","InstallTime":"","RunTimes":0,"URL":"appstore","StartCommand":"appstore","UrlType":37,"StoreType":95,"PreInstall":true},{"AppName":"AccuWeather","IconURL":"launcher/app/launcher1/accuweather.png","InstallTime":"","RunTimes":0,"URL":"accuweather","StartCommand":"accuweather","UrlType":36,"StoreType":98,"PreInstall":true},{"AppName":"Dailymotion","IconURL":"launcher/app/launcher1/Dailymotion.png","InstallTime":"","RunTimes":0,"URL":"http://tvsam-02.ext.dc3.dailymotion.com/live/?manufacturer=hisense","StartCommand":"http://tvsam-02.ext.dc3.dailymotion.com/live/?manufacturer=hisense","UrlType":36,"StoreType":98,"PreInstall":true},{"AppName":"Qubit","IconURL":"launcher/app/launcher1/Qubit.png","InstallTime":"","RunTimes":0,"URL":"http://opera.qubit.tv","StartCommand":"http://opera.qubit.tv","UrlType":36,"StoreType":98,"PreInstall":true},{"AppName":"TED","IconURL":"launcher/app/launcher1/TED.png","InstallTime":"","RunTimes":0,"URL":"https://hisense.tvstore.opera.com:84/api/tvapps/runapp/ted/?closeWindow=1","StartCommand":"https://hisense.tvstore.opera.com:84/api/tvapps/runapp/ted/?closeWindow=1","UrlType":36,"StoreType":95,"PreInstall":true},{"AppName":"Viewster","IconURL":"launcher/app/launcher1/viewster.png","InstallTime":"","RunTimes":0,"URL":"http://www.viewster.tv/Viewster_v5/index.html","StartCommand":"http://www.viewster.tv/Viewster_v5/index.html","UrlType":36,"StoreType":98,"PreInstall":true},{"AppName":"WoWTV","IconURL":"launcher/app/launcher1/WoWTV.png","InstallTime":"","RunTimes":0,"URL":"http://smarttvlive.wowtv.com/hisense/index.html","StartCommand":"http://smarttvlive.wowtv.com/hisense/index.html","UrlType":36,"StoreType":98,"PreInstall":true},{"AppName":"Toon Goggles","IconURL":"launcher/app/launcher1/ToonGoggles.png","InstallTime":"","RunTimes":0,"URL":"http://html5.toongoggles.com/","StartCommand":"http://html5.toongoggles.com/","UrlType":36,"StoreType":98,"PreInstall":true},{"AppName":"YuppTV","IconURL":"launcher/app/launcher1/YuppTV.png","InstallTime":"","RunTimes":0,"URL":"http://www.yupptv.com/hisense/index.html","StartCommand":"http://www.yupptv.com/hisense/index.html","UrlType":36,"StoreType":98,"PreInstall":true}]};
        if (null != preApps && !!preApps.AppInfo) {
            for (var i = 0; i < preApps.AppInfo.length; i++) {
                DBG_ALWAYS("preset txt apps name is: " + preApps.AppInfo[i].AppName);
                var tmpName1 = preApps.AppInfo[i].AppName.toLowerCase().replace(" ", "");
                if (appName == tmpName1) {
                    appInfo = {
                        "url": preApps.AppInfo[i].URL,
                        "name": preApps.AppInfo[i].AppName,
                        "urlType": preApps.AppInfo[i].UrlType,
                        "storeType": preApps.AppInfo[i].StoreType
                    };
                    break;
                }
                if(tmpName1.indexOf(mainName)>-1){
                    appInfo = {
                        "url": preApps.AppInfo[i].URL,
                        "name": preApps.AppInfo[i].AppName,
                        "urlType": preApps.AppInfo[i].UrlType,
                        "storeType": preApps.AppInfo[i].StoreType
                    };
                    break;
                }
            }
        }
    }

    if(appInfo!=null){
        var appName1 = null;
        if(appInfo.url == "search-hisense"){
            appName1 = APPNAME.SEARCH;
        }else if(appInfo.url == "4know-hisense"){
            appName1 = APPNAME.NEW4KNOW;
        }else if(appInfo.url == "appstore-hisense"){
            appName1 = APPNAME.HISENSESTORE;
        }

        UI.popAllModule();
        startThirdPartyApp(appName1, appInfo.url, appInfo.urlType, CMDMethod.REMOTECONTROL, false, 0xFFFFFF,appInfo.name, appInfo.storeType);

    }else{
        DBG_ERROR("Can not find the app by this name:"+name);
    }

}

function startOttByVoice(ottname){
    var appName = ottname.toLowerCase().replace(" ", "");
    for(var x=0;x<g_ottList.length;x++){
        var tmpName = g_ottList[x].Name.toLowerCase().replace(" ", "");
        if(tmpName == appName){
            var obj = {
                "name":g_ottList[x].Name,
                "url":g_ottList[x].data.url
            };
            writeFileToNative("launcher/ott.txt",objToString(obj), 1);
            UI.popAllModule();
            startThirdPartyApp(APPNAME.OTT,obj.url,37, CMDMethod.REMOTECONTROL, false, "#FFFFFF",obj.name,98);
            return;
        }
    }
    DBG_ERROR("Can not find the OTT by this name:"+ottname);
}

function startAnyViewCastByVoice(){
    UI.popAllModule();
    StartAnyViewCast();
}
function getFile(address) {
    var xmlhttp = new XMLHttpRequest();
    xmlhttp.open("GET", address, false);
    xmlhttp.send();
    var xmlDoc = xmlhttp.responseText;

    return xmlDoc;
}

/**
 * 获取livetv按键是否被用户配置过
 * @returns {*}
 */
function getLiveTVSystemDefaultInput() {
    if (!window.localStorage["LiveTVSystemDefaultInput"]) {
        window.localStorage["LiveTVSystemDefaultInput"] = "NOTSET";
    }
    DBG_ERROR(" LiveTVSystemDefaultInput" + window.localStorage["LiveTVSystemDefaultInput"]);
    return window.localStorage["LiveTVSystemDefaultInput"];
}

/**
 * 设置livetv按键是否被用户配置过
 */
function setLiveTVSystemDefaultInput() {
    window.localStorage["LiveTVSystemDefaultInput"] = "SETTED";
}

/**
 * Livetv 选择通道是否被打开过
 * @returns {*}
 */
function getLiveTVSourceOpened() {
    if (!window.localStorage["LiveTVSourceOpened"]) {
        window.localStorage["LiveTVSourceOpened"] = "NOTOPEN";
    }
    DBG_ERROR("LiveTVSourceOpened" + window.localStorage["LiveTVSourceOpened"]);
    return window.localStorage["LiveTVSourceOpened"];
}

/**
 * 设置Livetv 选择通道被打开过
 */
function setLiveTVSourceOpened() {
    window.localStorage["LiveTVSourceOpened"] = "OPENED";
}

var lastBluetoothRemoteMsg = 0;
var lastBluetoothRemoteTimer = null;
function bluetoothOnRCPairedChaged(v){
    if(UI.getCurrModule().name == "FTE")return;
    DBG_ERROR("bluetoothOnRCPairedChaged:" + v);
    var BluetoothRemoteFlowPageExist = false;
    lastBluetoothRemoteMsg = v;
    if(UI.getCurrModule().name == "common" && UI.getCurrSubModule().name != "BluetoothRemoteFlow"){
        closeMsgBox();
    }
    if(UI.isLoadingModule && (UI.loadingSubModuleName == "BluetoothRemoteFlow")){
        DBG_ERROR(" ------ a subModule is loading, delay to send message");
        clearTimeout(lastBluetoothRemoteTimer);
        lastBluetoothRemoteTimer = setTimeout(function(){
            bluetoothOnRCPairedChaged(lastBluetoothRemoteMsg);
        },500);
        return;
    }
    if (UI.getCurrSubModule().name == "BluetoothRemoteFlow") {
        BluetoothRemoteFlowPageExist = true;
    }
//    if(v == BluetoothModelDefines.SL2_TVAPI_I32_BLUETOOTH_ENUM_STATE_CONNECT_SUCCESS){
    if(v == 1){
        if(BluetoothRemoteFlowPageExist){
            var BluetoothRemoteFlow = UI.getSubModule("BluetoothRemoteFlow");
            BluetoothRemoteFlow.changeBluetoothRemoteFlowPage(BLUETOOTH_REMOTE_STATUS.SUCESS);
        }else{
            UI.pushSubModule(COMMON.MAIN, "BluetoothRemoteFlow", true,{open:BLUETOOTH_REMOTE_STATUS.SUCESS});
        }
//    }else if(v == BluetoothModelDefines.SL2_TVAPI_I32_BLUETOOTH_ENUM_STATE_PAIRING){
    }else if(v == 3){
        if(BluetoothRemoteFlowPageExist){
            var BluetoothRemoteFlow = UI.getSubModule("BluetoothRemoteFlow");
            BluetoothRemoteFlow.changeBluetoothRemoteFlowPage(BLUETOOTH_REMOTE_STATUS.CONNECT);
        }else{
            UI.pushSubModule(COMMON.MAIN, "BluetoothRemoteFlow", true,{open:BLUETOOTH_REMOTE_STATUS.CONNECT});
//            if(!tv){
//                setTimeout(function(){
//                    bluetoothOnRCPairedChaged(BluetoothModelDefines.SL2_TVAPI_I32_BLUETOOTH_ENUM_STATE_CONNECT_SUCCESS);
//                },5000);
//            }
        }
//    }else if(v == BluetoothModelDefines.SL2_TVAPI_I32_BLUETOOTH_ENUM_STATE_UNPAIR_SUCCESS){
    }else if(v == 4){
        GLOBAL.CURRENT_TOAST_TYPE = TOASTTYPE.BLUETOOTH_REMOTE_UNPAIRED;
        UI.pushGhostModule("setting", "SettingSysToast");
//    }else if(v == BluetoothModelDefines.SL2_TVAPI_I32_BLUETOOTH_ENUM_STATE_CONNECT_FAIL){
    }else if(v == 2){
        //FAIL
        if(BluetoothRemoteFlowPageExist){
            var BluetoothRemoteFlow = UI.getSubModule("BluetoothRemoteFlow");
            BluetoothRemoteFlow.changeBluetoothRemoteFlowPage(BLUETOOTH_REMOTE_STATUS.FAIL);
        }else{
            UI.pushSubModule(COMMON.MAIN, "BluetoothRemoteFlow", true,{open:BLUETOOTH_REMOTE_STATUS.FAIL});
        }
//    }else if(v == BluetoothModelDefines.SL2_TVAPI_I32_BLUETOOTH_ENUM_STATE_DISCONNECT){
    }else if(v == 5){
        GLOBAL.CURRENT_TOAST_TYPE = TOASTTYPE.BLUETOOTH_REMOTE_DISCONNECT;
        UI.pushGhostModule("setting", "SettingSysToast");
    }
    else{
        DBG_ERROR("discard this message!");
    }
}
DBG_INFO("PubFunc.js end " + debugRunTime());

