// Init
UI.moduleBuilder['setting']['storeModeUpdate'] = function(){
    var HIDE = 0;
    var SHOW = 1;

    var LANGUAGE = {
        "videoCheck":"[SE3693]",//"Checking the Build-In Video package...",
        "videoUpdate":"[SE3695]",//"Updating Build-In Video... Please wait a minute.",
        "pictureCheck":"[SE3694]",//"Checking the E-Pos package...",
        "pictureUpdate":"[SE3696]",//"Updating E-Pos... Please wait a minute.",
        "Connecting": Config.language["SE3273"].replace("[]","[0%]") // Updating…[],Please wait a minite.
    };
    var mainPanelData = {
        updateVideoSheetBgImg:{"color":"0x131520"},
        updateVideoImg:"setting/ic_loading1.png",
        updateVideoText:"[SE3693]"//"Checking the Build-In Video package...",
    };
    var template = Util.readJson("module/setting/storeModeUpdate.json");
    var storeModeUpdate = SubModule.create(mainPanelData, template);
    var updateVideoImg = UI.getItem(storeModeUpdate, "updateVideoImg");
    var updateVideoText = UI.getItem(storeModeUpdate,"updateVideoText");
    var enableKeyGroup = [CONST.KEY.VK_BACKSPACE,CONST.VK_EXIT];
    storeModeUpdate.noAutoClose = true;
    storeModeUpdate.updateVideoTimer = 0;
    storeModeUpdate.updateCon = "video";
    storeModeUpdate.needCancelUpData = true;
    storeModeUpdate.needStartEpos = true;
    storeModeUpdate.onPush =  function(){
        storeModeUpdate.needStartEpos = true;
        updateAddLoadingTween();
        UI.registerKeyCodes(enableKeyGroup);    //按键屏蔽
        UI.clearEposMenuTimeout();
        if(checkIsAppOn() && appControl.getCurrentAPPName() == APPNAME.EPOS){
            appControl.stopCurrentApp();
        }
//        setTestConnectStatusGrpAlpha(SHOW,"Checking the build-in video package", "setting/ic_loading1.png");
//        setTestConnectStatusGrpAlpha(SHOW,Config.language["SE3273"].replace("[]","[0%]"), "setting/ic_loading1.png");
        if(!!storeModeUpdate.param.update){
            storeModeUpdate.updateCon = storeModeUpdate.param.update;
        }
        DBG_INFO("storeModeUpdate.onPush:"+storeModeUpdate.updateCon);
        if(storeModeUpdate.updateCon == "picture"){
            UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.SYSTEM_STOREMODE_COPY_RETURN_CODE,onUpgradeBuiltInPictureRetcode);
            updateSetText(LANGUAGE.pictureUpdate);
            try{
                storeModeUpdate.needCancelUpData = true;
                if(tv){
                    model.system.setUpgradeBuiltInVideoCopy("EP##EPOS");
                }else{
                    setTimeout(function(){
                        onUpgradeBuiltInPictureRetcode(0);
                    },3000);
                }
            }catch (ex){
                DBG_ERROR(ex.message);
                UI.popSubModule();
                GLOBAL.CURRENT_TOAST_TYPE = TOASTTYPE.SYSERRORTIP;
                UI.pushGhostModule("setting", "SettingSysToast");
            }
        }else{
            UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.SYSTEM_STOREMODE_COPY_RETURN_CODE,onUpgradeBuiltInVideoRetcode);
            UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.SYSTEM_STOREMODE_UPGRADE_VIDEO_PROGRESS,onUpgradeBuiltInVideoProgress);
            updateSetText(LANGUAGE.videoCheck);
            storeModeUpdate.needCancelUpData = true;
            try{
                if(tv){
                    if(GLOBAL.LAUNCHER_BRAND == "his"){
                        model.system.setUpgradeBuiltInVideoCopy("VD##StoreModeDemo");
                    }else{
                        model.system.setUpgradeBuiltInVideoCopy("VD##Demo_Sharp");
                    }
                }else{
//                    setTimeout(function(){
//                        onUpgradeBuiltInVideoProgress(1);
//                    },3000);
                    setTimeout(function(){
                        onUpgradeBuiltInVideoRetcode(3);
                    },5000);
                }
            }catch (ex){
                DBG_ERROR(ex.message);
                UI.popSubModule();
                GLOBAL.CURRENT_TOAST_TYPE = TOASTTYPE.SYSERRORTIP;
                UI.pushGhostModule("setting", "SettingSysToast");
            }
        }
    };
    storeModeUpdate.onShow =  function(){
    };
    function onUpgradeBuiltInVideoProgress(pro){
        DBG_INFO("onUpgradeBuiltInVideoProgress :"+pro);
        // UI.setText(updateVideoText,"Updating..."+pro+"% Please wait a minite.");
        UI.setText(updateVideoText, Config.language["SE3273"].replace("[]","[" + pro + "%]"),0,true,620,true); //Updating…[],Please wait a minite.
    }

    function onUpgradeBuiltInVideoRetcode(code){
        DBG_INFO("[SellerSetting] onUpgradeBuiltInVideoRetcode  : code:"+code);
        storeModeUpdate.needCancelUpData = false;
        switch (code) {
            case 0:
                UI.popSubModule();
                GLOBAL.CURRENT_TOAST_TYPE = TOASTTYPE.UPDATESUCESSTIP;
                UI.pushGhostModule("setting", "SettingSysToast");
                break;
            case 1:
                UI.popSubModule();
                DBG_INFO("[SellerSetting] onUpgradeBuiltInVideoRetcode  : code:"+code);
                GLOBAL.CURRENT_TOAST_TYPE = TOASTTYPE.STORE_MODE_NO_USB_TIP;
                UI.pushGhostModule("setting", "SettingSysToast");
                break;
            case 2://No upgrade package detected.
            case 3://File size is too big to update
            case 4://systerm ERROR
                storeModeUpdate.needStartEpos = false;
                UI.popSubModule();
                UI.pushSubModule("setting", "storeModeUpdateFail", true,{"update":storeModeUpdate.updateCon,"errorType":code});
                break;
            default:
                break;

        }
    }
    function onUpgradeBuiltInPictureRetcode(code){
        DBG_INFO("onUpgradeBuiltInPictureRetcode  : code:"+code);
        storeModeUpdate.needCancelUpData = false;
        switch (code) {
            case 0://success
                UI.popSubModule();
                GLOBAL.CURRENT_TOAST_TYPE = TOASTTYPE.UPDATESUCESSTIP;
                UI.pushGhostModule("setting", "SettingSysToast");
                break;
            case 1://no usb
                UI.popSubModule();
                GLOBAL.CURRENT_TOAST_TYPE = TOASTTYPE.STORE_MODE_NO_USB_TIP;
                UI.pushGhostModule("setting", "SettingSysToast");
                break;
            case 2://no picture
            case 4://system error
                storeModeUpdate.needStartEpos = false;
                UI.popSubModule();
                UI.pushSubModule("setting", "storeModeUpdateFail", true,{"update":storeModeUpdate.updateCon,"errorType":code});
                break;
            default:
                break;

        }
    }
    function updateSetText(txt){
        if(!!txt){
            UI.setText(updateVideoText,txt,0,true,620,true);
            UI.updateStage();
        }
    }
    function updateAddLoadingTween(){
        UI.getTween(updateVideoImg, true, true).to({rotation: updateVideoImg.rotation + Math.PI*2}, 3000);
        UI.updateStage();
    }
    function updateRemoveLoadingTween(){
        createjs.Tween.removeTweens(updateVideoImg);
        updateVideoImg.rotation = 0;
    }
    function setTestConnectStatusGrpAlpha(alpha,text,img){
        updateVideoImg.alpha = alpha;
        if(text!=null){
            UI.setText(updateVideoText,text,0,true,620,true);
        }
        if(img!=null){
            UI.setImage(updateVideoImg,img);
            if(img == "setting/ic_loading1.png"){
                UI.getTween(updateVideoImg, true, true).to({rotation: updateVideoImg.rotation + Math.PI*2}, 3000);
            }else{
                createjs.Tween.removeTweens(updateVideoImg);
                updateVideoImg.rotation = 0;
            }
        }
        if(alpha == HIDE){
            createjs.Tween.removeTweens(updateVideoImg);
            updateVideoImg.rotation = 0;
        }
        UI.updateStage();
    }
    storeModeUpdate.onPop = function(){
        if(storeModeUpdate.updateCon == "picture"){
            if(tv && storeModeUpdate.needCancelUpData){
                model.system.setUpgradeBuiltInVideoCopy("CN##EPOS");
            }
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.SYSTEM_STOREMODE_COPY_RETURN_CODE,onUpgradeBuiltInPictureRetcode);
        }else{
            if(tv && storeModeUpdate.needCancelUpData){
                model.system.setUpgradeBuiltInVideoCopy("CN##StoreModeDemo");
            }
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.SYSTEM_STOREMODE_COPY_RETURN_CODE,onUpgradeBuiltInVideoRetcode);
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.SYSTEM_STOREMODE_UPGRADE_VIDEO_PROGRESS,onUpgradeBuiltInVideoProgress);
        }
        updateRemoveLoadingTween();
        try{
            UI.setEposMenuTimeout(startRetailmodeTimer, retailmodeTimeout);
        }catch (ex){
            DBG_ERROR("storeModeUpdate.onPop:"+ex.message);
        }
        UI.registerKeyCodes(null);  //解锁按键屏蔽
        if(storeModeUpdate.needStartEpos){
            startePos(true);
        }
    };
    storeModeUpdate.onkey_BACKSPACE = function(){
        UI.popSubModule();
    }
};

