// Init


UI.moduleBuilder['setting']['picWteBal2PotAdjust'] = function(){
    try {
        var initData = {
            percentBG: UI["liveTV_bg"],
            UpArrow: "setting/pic/card_wheel/UpArrow.png",
            DownArrow: "setting/pic/card_wheel/DownArrow.png",
            cardWheelBg: {color: getCardWheelColor()},
            cardWheelShadow: "setting/pic/card_wheel/shadow_top.png",
            cardWheelIcon_0: "setting/pic/card_wheel/r_offset.png",
            cardWheelIcon_1: "setting/pic/card_wheel/g_offset.png",
            cardWheelIcon_2: "setting/pic/card_wheel/b_offset.png",
            cardWheelIcon_3: "setting/pic/card_wheel/r_gain.png",
            cardWheelIcon_4: "setting/pic/card_wheel/g_gain.png",
            cardWheelIcon_5: "setting/pic/card_wheel/b_gain.png"
        };
        var template = Util.readJsonObject("module/setting/picWteBal2PotAdjust.json");

        var pctCmpVec = ['ROffset', 'GOffset', 'BOffset', 'RGain', 'GGain', 'BGain'];
        var pctCmpLanVec = ['[SE0497]', '[SE0499]', '[SE0501]', '[SE0503]', '[SE0505]', '[SE0507]']; //专门为多语言添加
        var pctCmpDescriptionVec = ['[SE0498]', '[SE0500]', '[SE0502]', '[SE0504] ', '[SE0506]','[SE0508]'];

        for (var i = 0; i < pctCmpVec.length; i++) {
            template.picWteBal2PotAdjust.items[pctCmpVec[i]] = getObjCopy(Util.readJsonObject("templates/percentSingle.json")).percentBar;
            template.picWteBal2PotAdjust.items[pctCmpVec[i]].position.y = 0;
            template.picWteBal2PotAdjust.items[pctCmpVec[i]].items.title.value = pctCmpLanVec[i] ;//pctCmpVec[i].substr(0, 1) + "-" + pctCmpVec[i].substr(1);
            template.picWteBal2PotAdjust.items[pctCmpVec[i]].items.description.value = pctCmpDescriptionVec[i];
            template.picWteBal2PotAdjust.items[pctCmpVec[i]].navigation =
            {
                "leftTo": null,
                "rightTo": null,
                "upTo": pctCmpVec[i - 1 >= 0 ? i - 1 : 5],
                "downTo": pctCmpVec[i + 1 <= 5 ? i + 1 : 0]
            };
            //"picWteBal2PotROffset"
            if (pctCmpVec[i] != PictureConfig.PicWteBal2PotSign.substr(13)) {
                template.picWteBal2PotAdjust.items[pctCmpVec[i]].position.y = 2000;
            }
        }

        var cardWheel = {
            "type": 0,
            "position": {
                "x": -250,
                "y": 20
            },
            "items": {}
        };

        var cardWheelItem = {
            "type": 0,
            "position": {
                "x": 0,
                "y": 124
            },
            "navigation": {
                "leftTo": null,
                "rightTo": null,
                "upTo": null,
                "downTo": null
            },
            "items": {
                "cardWheelBg": {
                    "type": 7,
                    "bound": {
                        "w": 230,
                        "h": 160
                    },
                    "position": {
                        "x": 0,
                        "y": 0
                    }
                },
                "cardWheelShadow": {
                    "type": 7,
                    "bound": {
                        "w": 280,
                        "h": 200
                    },
                    "position": {
                        "x": -30,
                        "y": -20
                    }
                },
                "cardWheelIcon": {
                    "type": 7,
                    "bound": {
                        "w": 72,
                        "h": 72
                    },
                    "position": {
                        "x": 79,
                        "y": 44
                    }
                }
            }
        };


        // 20 50 150 200 0
        //位置不准确，缩放为中心缩放
        var cardWheelItemIndexVec = [{y: 0}, {y: 95}, {y: 190}, {y: 95}, {y: 95}, {y: 95}];

        for (var i = 0; i < cardWheelItemIndexVec.length; i++) {
            var cardWheelItemTemp = getObjCopy(cardWheelItem);
            cardWheelItemTemp.position.y = cardWheelItemIndexVec[i].y;
            cardWheelItemTemp.items['cardWheelIcon_' + i] = getObjCopy(cardWheelItemTemp.items.cardWheelIcon);
            delete (cardWheelItemTemp.items.cardWheelIcon);
            cardWheel.items["cardWheel_" + i] = cardWheelItemTemp;
        }

        template.picWteBal2PotAdjust.items['cardWheel'] = cardWheel;

        var picWteBal2PotAdjust = SubModule.create(initData, template);
        picWteBal2PotAdjust.noAutoClose = true;

        var PicWteBal2PotAdjustPageData = {
            ROffsetVal: 0,
            GOffsetVal: 0,
            BOffsetVal: 0,
            RGainVal: 0,
            GGainVal: 0,
            BGainVal: 0
        };

        picWteBal2PotAdjust.onPush = function () {
            try {
                var CmpVec = [ROffset, GOffset, BOffset, RGain, GGain, BGain];

                for (var i = 0; i < CmpVec.length; i++) {
                    CmpVec[i].alpha = 0;
                    CmpVec[i].y = 0;
                }

                cardWheelObj.init();

                picWteBal2PotAdjust.currFocus = UI.getItem(picWteBal2PotAdjust, PictureConfig.PicWteBal2PotSign.substr(13));
                PicWteBal2PotAdjustPageInit();

                for (var i = 0; i < pctCmpVec.length; i++) {
                    var bar = eval(pctCmpVec[i]);
                    var cmp = UI.getItem(eval(pctCmpVec[i]), "percentBarLine");
                    setOnkeyLeftRightFunc(bar, cmp, eval('PicWteBal2PotAdjustPageData.' + pctCmpVec[i] + "Val"));
                }

                UI.updateStage();
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        };

        picWteBal2PotAdjust.onShow = function () {
            try {
                var normalCfg = {y: 0 + 175, alpha: 1};
                UI.getItem(picWteBal2PotAdjust, PictureConfig.PicWteBal2PotSign.substr(13)).alpha = 1;
                UI.getItem(picWteBal2PotAdjust, PictureConfig.PicWteBal2PotSign.substr(13)).y = normalCfg.y;
                UI.hideCursor();
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        };

        function PicWteBal2PotAdjustPageInit() {
            try {
                PicWteBal2PotAdjustPageData.ROffsetVal = tv ? model.video.getRoffset() : 0;
                DBG_INFO('model.video.getRoffset(): ' + PicWteBal2PotAdjustPageData.ROffsetVal);
                UI.getItem(eval(pctCmpVec[0]), "percentBarLine").setPercentNoVoice(PicWteBal2PotAdjustPageData.ROffsetVal);

                PicWteBal2PotAdjustPageData.GOffsetVal = tv ? model.video.getGoffset() : 1;
                DBG_INFO('model.video.getGoffset(): ' + PicWteBal2PotAdjustPageData.GOffsetVal);
                UI.getItem(eval(pctCmpVec[1]), "percentBarLine").setPercentNoVoice(PicWteBal2PotAdjustPageData.GOffsetVal);

                PicWteBal2PotAdjustPageData.BOffsetVal = tv ? model.video.getBoffset() : 2;
                DBG_INFO('model.video.getBoffset(): ' + PicWteBal2PotAdjustPageData.BOffsetVal);
                UI.getItem(eval(pctCmpVec[2]), "percentBarLine").setPercentNoVoice(PicWteBal2PotAdjustPageData.BOffsetVal);

                PicWteBal2PotAdjustPageData.RGainVal = tv ? model.video.getRgain() : 3;
                DBG_INFO('model.video.getRgain(): ' + PicWteBal2PotAdjustPageData.RGainVal);
                UI.getItem(eval(pctCmpVec[3]), "percentBarLine").setPercentNoVoice(PicWteBal2PotAdjustPageData.RGainVal);

                PicWteBal2PotAdjustPageData.GGainVal = tv ? model.video.getGgain() : 4;
                DBG_INFO('model.video.getGgain(): ' + PicWteBal2PotAdjustPageData.GGainVal);
                UI.getItem(eval(pctCmpVec[4]), "percentBarLine").setPercentNoVoice(PicWteBal2PotAdjustPageData.GGainVal);

                PicWteBal2PotAdjustPageData.BGainVal = tv ? model.video.getBgain() : 5;
                DBG_INFO('model.video.getBgain(): ' + PicWteBal2PotAdjustPageData.BGainVal);
                UI.getItem(eval(pctCmpVec[5]), "percentBarLine").setPercentNoVoice(PicWteBal2PotAdjustPageData.BGainVal);
                var index=pctCmpVec.indexOf(PictureConfig.PicWteBal2PotSign.substr(13));
                TTSCall(index);
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }

        function TTSCall(index){
            UI.callTTS(pctCmpLanVec[index]+eval("PicWteBal2PotAdjustPageData."+PictureConfig.PicWteBal2PotSign.substr(13)+"Val") + " ");
            DBG_INFO("UI.callTTS: "+ eval("PicWteBal2PotAdjustPageData."+PictureConfig.PicWteBal2PotSign.substr(13)+"Val"));
        }

        var ROffset = UI.getItem(picWteBal2PotAdjust, "ROffset");
        var GOffset = UI.getItem(picWteBal2PotAdjust, "GOffset");
        var BOffset = UI.getItem(picWteBal2PotAdjust, "BOffset");
        var RGain = UI.getItem(picWteBal2PotAdjust, "RGain");
        var GGain = UI.getItem(picWteBal2PotAdjust, "GGain");
        var BGain = UI.getItem(picWteBal2PotAdjust, "BGain");

        function CardWheelFunc() {

            var self = this;
            var cardWheelVec = [];
            self.cardWheelVec = cardWheelVec;
            var cardWheelLength = 6;
            for (var i = 0; i < cardWheelLength; i++) {
                self.cardWheelVec.push(UI.getItem(picWteBal2PotAdjust, "cardWheel_" + i));
            }
            var posYVec = [0 + 80, 95 + 80, 190 + 80, 95 + 80, 95 + 80, 95 + 80];
            var DelayTimeData = {
                Time_0: 0,
                Time_400: 400
            };
            var ToVecNumeber = {
                Vec0: 0,
                Vec1: 1,
                Vec2: 2
            };
            var ToYPosition = {
                Y_57: 57,
                Y_80: 80,
                Y_105: 105
            };

            //初始化，0位于最高的一个，当前哪个元素应该是Vector第一个
            self.setHeadIdx = function (idx) {
                try {
                    DBG_INFO('self.setHeadIdx: ' + idx);
                    for (var i = 0; i < idx; i++) {
                        cardWheelVec.unshift(cardWheelVec.pop());
                    }
                    getTweenTime(ToVecNumeber.Vec1,DelayTimeData.Time_0,ToYPosition.Y_80);
                    switchLayer(cardWheelVec)
                } catch (ex) {
                    DBG_ERROR(ex.message);
                }
            };

            self.init = function () {
                var PicWteBal2PotSignVec = ['picWteBal2PotROffset', 'picWteBal2PotGOffset', 'picWteBal2PotBOffset', 'picWteBal2PotRGain', 'picWteBal2PotGGain', 'picWteBal2PotBGain'];
                var idx = PicWteBal2PotSignVec.indexOf(PictureConfig.PicWteBal2PotSign);

                cardWheelVec = [];
                for (var i = 0; i < cardWheelLength; i++) {
                    cardWheelVec.push(UI.getItem(picWteBal2PotAdjust, "cardWheel_" + i));
                    var cardWheelShadow = UI.getItem(cardWheelVec[cardWheelVec.length - 1], "cardWheelShadow");
                    cardWheelShadow.doFlip = true;
                }
                self.setHeadIdx(({0: 1, 1: 0, 2: 5, 3: 4, 4: 3, 5: 2}[idx]));
            };

            function switchLayer(cardWheelVec) {
                UI.moveTo(cardWheelVec[1], 5);
                UI.moveTo(cardWheelVec[2], 4);
                UI.moveTo(cardWheelVec[3], 3);
                UI.moveTo(cardWheelVec[4], 2);
                UI.moveTo(cardWheelVec[5], 1);
                UI.moveTo(cardWheelVec[0], 0);
            }

            self.keyUp = function () {
                cardWheelVec.unshift(cardWheelVec.pop());
                getTweenTime(ToVecNumeber.Vec0,DelayTimeData.Time_400,ToYPosition.Y_57);
            };

            self.keyDown = function () {
                cardWheelVec.push(cardWheelVec.shift());
                getTweenTime(ToVecNumeber.Vec2,DelayTimeData.Time_400,ToYPosition.Y_105);
            };

            function getTweenTime(number,time,position) {
                DBG_INFO('posYVec['+number + '] ' + 'delayTime:' + time + ' toPosition:' + position);
                UI.getTween(cardWheelVec[1]).to({y: posYVec[number], alpha: 1}, time/2, UI.ease.quadOut).call(switchLayer, [cardWheelVec]).to({
                    y: posYVec[1]
                }, time/2, UI.ease.quadIn);
                UI.getTween(UI.getItem(cardWheelVec[1],"cardWheelIcon_"+cardWheelVec[1].name.substr(10))).to({y: position}, time/2,UI.ease.quadOut).to({y:ToYPosition.Y_80,alpha: 1},time/2,UI.ease.quadIn);
                UI.getTween(UI.getItem(cardWheelVec[1],"cardWheelIcon_"+cardWheelVec[1].name.substr(10)).scale).to({x: 1, y: 1});

                UI.getTween(cardWheelVec[2]).to({y: posYVec[2], alpha: 0.8}, time);
                UI.getTween(UI.getItem(cardWheelVec[2],"cardWheelIcon_"+cardWheelVec[2].name.substr(10))).to({y: 105, alpha: 0.8}, 100);
                UI.getTween(UI.getItem(cardWheelVec[2],"cardWheelIcon_"+cardWheelVec[2].name.substr(10)).scale).to({x: 0.67, y: 0.67});
                UI.getTween(cardWheelVec[0]).to({y: posYVec[0], alpha: 0.8}, time);
                UI.getTween(UI.getItem(cardWheelVec[0],"cardWheelIcon_"+cardWheelVec[0].name.substr(10))).to({y: 57, alpha: 0.8}, 100);
                UI.getTween(UI.getItem(cardWheelVec[0],"cardWheelIcon_"+cardWheelVec[0].name.substr(10)).scale).to({x: 0.67, y: 0.67});


                UI.getTween(cardWheelVec[3]).to({y: posYVec[3], alpha: 0}, 0);
                UI.getTween(UI.getItem(cardWheelVec[3],"cardWheelIcon_"+cardWheelVec[3].name.substr(10))).to({y: 80, alpha: 0}, 100);
                UI.getTween(UI.getItem(cardWheelVec[3],"cardWheelIcon_"+cardWheelVec[3].name.substr(10)).scale).to({x: 1, y: 1});
                UI.getTween(cardWheelVec[4]).to({y: posYVec[4], alpha: 0}, 0);
                UI.getTween(UI.getItem(cardWheelVec[4],"cardWheelIcon_"+cardWheelVec[4].name.substr(10))).to({y: 80, alpha: 0}, 100);
                UI.getTween(UI.getItem(cardWheelVec[4],"cardWheelIcon_"+cardWheelVec[4].name.substr(10)).scale).to({x: 1, y: 1});
                UI.getTween(cardWheelVec[5]).to({y: posYVec[5], alpha: 0}, 0);
                UI.getTween(UI.getItem(cardWheelVec[5],"cardWheelIcon_"+cardWheelVec[5].name.substr(10))).to({y: 80, alpha: 0}, 100);
                UI.getTween(UI.getItem(cardWheelVec[5],"cardWheelIcon_"+cardWheelVec[5].name.substr(10)).scale).to({x: 1, y: 1});
            }
        }

        var cardWheelObj = new CardWheelFunc();

        function CreatePercent(cmp, cmpTxt, val) {
            try {
                Percent.create(cmp, cmpTxt, val, -25, 25);
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }

        function setModelValue(name, val) {
            try {
                DBG_INFO('name:' + name);
                switch (name) {
                    case "ROffset":
                        tv && model.video.setRoffset(val);
                        DBG_INFO("model.video.setRoffset(" + val + ")");
                        break;
                    case "GOffset":
                        tv && model.video.setGoffset(val);
                        DBG_INFO("model.video.setGoffset(" + val + ")");
                        break;
                    case "BOffset":
                        tv && model.video.setBoffset(val);
                        DBG_INFO("model.video.setBoffset(" + val + ")");
                        break;
                    case "RGain":
                        tv && model.video.setRgain(val);
                        DBG_INFO("model.video.setRgain(" + val + ")");
                        break;
                    case "GGain":
                        tv && model.video.setGgain(val);
                        DBG_INFO("model.video.setGgain(" + val + ")");
                        break;
                    case "BGain":
                        tv && model.video.setBgain(val);
                        DBG_INFO("model.video.setBgain(" + val + ")");
                        break;
                    default:
                        DBG_ERROR('name error');
                        break;
                }
                eval("PicWteBal2PotAdjustPageData."+name+"Val"+"=val");
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }

        function setOnkeyLeftRightFunc(bar, comp, val) {

            bar.onkey_LEFT = function () {
                DBG_INFO(bar.name + "onkey_LEFT");
                val -= 1;
                var minVal = -25;
                val < minVal && (val = minVal);
                comp.setPercent(val);
                setModelValue(bar.name, val);
            };
            bar.onkey_RIGHT = function () {
                DBG_INFO(bar.name + "onkey_RIGHT");
                val += 1;
                var maxVal = 25;
                val > maxVal && (val = maxVal);
                comp.setPercent(val);
                setModelValue(bar.name, val);
            };
            bar.onFocus = function () {
                return false;
            }
        }

        function setOnkeyUpDownFunc(cmpOri, cmpUpTo, cmpDownTo) {
            var topCfg = {y: -100 + 175, alpha: 0};
            var normalCfg = {y: 0 + 175, alpha: 1};
            var btmCfg = {y: 100 + 175, alpha: 0};

            cmpOri.onkey_UP = function (focus) {
                DBG_INFO(cmpOri.name + "onkey_UP");
                DBG_INFO(cmpUpTo.name + "onkey_UP");
                UI.getTween(cmpOri).to(btmCfg, 300);
                UI.getTween(cmpUpTo).to(topCfg, 0).to(normalCfg, 400);
                picWteBal2PotAdjust.currFocus = UI.getItem(picWteBal2PotAdjust, focus.upTo);
                PictureConfig.PicWteBal2PotSign = "picWteBal2Pot"+cmpUpTo.name;
                DBG_INFO("PictureConfig.PicWteBal2PotSign: " + PictureConfig.PicWteBal2PotSign);
                var index=pctCmpVec.indexOf(PictureConfig.PicWteBal2PotSign.substr(13));
                TTSCall(index);
                cardWheelObj.keyUp();
            };

            cmpOri.onkey_DOWN = function (focus) {
                DBG_INFO(cmpOri.name + "onkey_DOWN");
                DBG_INFO(cmpDownTo.name + "onkey_DOWN");
                UI.getTween(cmpOri).to(topCfg, 300);
                UI.getTween(cmpDownTo).to(btmCfg, 0).to(normalCfg, 400);
                picWteBal2PotAdjust.currFocus = UI.getItem(picWteBal2PotAdjust, focus.downTo);
                PictureConfig.PicWteBal2PotSign = "picWteBal2Pot"+cmpDownTo.name;
                DBG_INFO("PictureConfig.PicWteBal2PotSign: " + PictureConfig.PicWteBal2PotSign);
                var index=pctCmpVec.indexOf(PictureConfig.PicWteBal2PotSign.substr(13));
                TTSCall(index);
                cardWheelObj.keyDown();
            };
        }

        function setOnkeyEnterFunc(cmp){
            cmp.onkey_ENTER = function (focus) {
                return false;
            }
        }

        setOnkeyEnterFunc(ROffset);
        setOnkeyEnterFunc(GOffset);
        setOnkeyEnterFunc(BOffset);
        setOnkeyEnterFunc(RGain);
        setOnkeyEnterFunc(GGain);
        setOnkeyEnterFunc(BGain);

        for (var i = 0; i < pctCmpVec.length; i++) {
            var bar = eval(pctCmpVec[i]);
            var cmp = UI.getItem(eval(pctCmpVec[i]), "percentBarLine");
            var cmpTxt = UI.getItem(eval(pctCmpVec[i]), "percentBarText");

            CreatePercent(cmp, cmpTxt, eval('PicWteBal2PotAdjustPageData.' + pctCmpVec[i] + "Val"));

            //setOnkeyLeftRightFunc(bar, cmp, eval(pctCmpVec[i] + "Val"));   //放到onPush里面，与否则Val初始值不对
            setOnkeyUpDownFunc(bar, eval(pctCmpVec[i - 1 >= 0 ? i - 1 : i + 6 - 1]), eval(pctCmpVec[i + 1 <= 5 ? i + 1 : i - 6 + 1]));
        }

    } catch (ex) {
        DBG_ERROR(ex.message);
    }
};