// Init
UI.moduleBuilder['setting']['picModeSettings'] = function(){
    try {
        var heightEnum = {
            H_120: 120,
            H_72: 72
        };
        var cmpSpaceEnum = {
            H_0: 0,
            H_10: 10,
            H_24: 24,
            H_48: 48
        };
        var firMagTop = cmpSpaceEnum.H_0;
        var cmpCfgVector = [
            {
                id: "SettingsApplySelect",
                height: heightEnum.H_120
            },
            {
                id: "SettingsBacklight",
                height: heightEnum.H_120
            },
            {
                id: "SettingsContrast",
                height: heightEnum.H_120
            },
            {
                id: "SettingsBrightness",
                height: heightEnum.H_120
            },
            {
                id: "SettingsColor",
                height: heightEnum.H_120
            },
            {
                id: "SettingsTint",
                height: heightEnum.H_120
            },
            {
                id: "SettingsSharpness",
                height: heightEnum.H_120
            },
            {
                id: "SettingsOverScan",
                height: heightEnum.H_120
            },
            {
                id: "SettingsColorTemp",
                height: heightEnum.H_120
            },

            {
                id: "SettingsAquoMotionEnhancement",
                height: heightEnum.H_120
            },
            {
                id: "SettingsJudderReduction",
                height: heightEnum.H_72
            },
            {
                id: "SettingsBlurReduction",
                height: heightEnum.H_72
            },
            {
                id: "SettingsDigitalNoiseReduction",
                height: heightEnum.H_120
            },
            {
                id: "SettingsHDMIDynamicRange",
                height: heightEnum.H_120
            },
            {
                id: "SettingsActiveContrast",
                height: heightEnum.H_120
            },
            {
                id: "SettingsExpert",
                height: heightEnum.H_120
            },
            {
                id: "SettingsReset",
                height: heightEnum.H_120
            }
        ];
        var cmpIdVec = [];
        for (var i = 0; i < cmpCfgVector.length; i++) {
            cmpIdVec.push(cmpCfgVector[i].id);
        }
        function getCmpSpacing(idx) {
            //var idx = cmpIdVec.indexOf(cmpId);
            if (0 == idx) {
                return firMagTop;//first
            } else {
                if (cmpCfgVector[idx].height == heightEnum.H_72 && cmpCfgVector[idx - 1].height == heightEnum.H_72) {
                    return cmpSpaceEnum.H_10;
                } else {
                    return cmpSpaceEnum.H_24
                }
            }
        }
        function getCmpPosY(cmpId) {
            var idx = cmpIdVec.indexOf(cmpId);
            var posY = cmpSpaceEnum.H_0;
            for (var i = 0; i < idx; i++) {
                posY += cmpCfgVector[i].height + getCmpSpacing(i + 1);
            }
            return posY;
        }

        var initData = {
            "picModeSettingsSheet": UI.setting_bg,
            "picModeSettingsIconImg": "setting/"+GLOBAL.LAUNCHER_BRAND+"/ic_picture_154x154.png",
            "JudderReductionPointIcon":"setting/pic/linkage_point.png",
            "BlurReductionPointIcon":"setting/pic/linkage_point.png",
            "SettingsApplySelectBar": UI.btn_normal_bg,
            "SettingsBacklightBG": UI.btn_normal_bg,
            "SettingsContrastBar": UI.btn_normal_bg,
            "SettingsBrightnessBar": UI.btn_normal_bg,
            "SettingsColorBar": UI.btn_normal_bg,
            "SettingsTintBar": UI.btn_normal_bg,
            "SettingsSharpnessBar": UI.btn_normal_bg,
            "SettingsActiveContrastBar": UI.btn_normal_bg,
            "SettingsAquoMotionEnhancementBar": UI.btn_normal_bg,
            "SettingsJudderReductionBar": UI.btn_normal_bg,
            "SettingsBlurReductionBar": UI.btn_normal_bg,
            "SettingsDigitalNoiseReductionBar": UI.btn_normal_bg,
            "SettingsColorTempBar": UI.btn_normal_bg,
            "SettingsHDMIDynamicRangeBar": UI.btn_normal_bg,
            "SettingsExpertBG": UI.btn_normal_bg,
            "SettingsResetBG": UI.btn_normal_bg,
            "SettingsOverScanBar": UI.btn_normal_bg
        };
        var template = Util.readJsonObject("module/setting/picModeSettings.json");

        for (var i = 0; i < cmpCfgVector.length; i++) {
            DBG_INFO(cmpCfgVector[i].id + getCmpPosY(cmpCfgVector[i].id));
            template.picModeSettings.items.picModeSettingsGrp.items[cmpCfgVector[i].id].position.y = getCmpPosY(cmpCfgVector[i].id);
            template.picModeSettings.items.picModeSettingsGrp.items[cmpCfgVector[i].id].position.x = 0;
        }
        var picModeSettings = SubModule.create(initData, template);

        var picModeSettingsGrp = UI.getItem(picModeSettings, "picModeSettingsGrp");
        UI.addMask(picModeSettingsGrp, 1242, 925, 80, 6);
        UI.setView(picModeSettingsGrp, 1242, 925);

        var picModeSettingsSheet = UI.getItem(picModeSettings, "picModeSettingsSheet");
        picModeSettingsSheet.doFlip = true;

        picModeSettings.onPush = function () {
            ModelNotifyInit();
            picModeSettingsPageInit();
            picModeSettings.currFocus = UI.getItem(picModeSettings, "SettingsApplySelect");
            UI.updateStage();
        };
        picModeSettings.onShow = function () {
            DBG_INFO('picModeSettings.onShow');
            var Settings = UI.getSubModule("Settings");
            if (picModeSettings.caller == "Settings"){
                UI.getItem(setting, 'Settings').alpha = 0;
            }
            picModeSettings.alpha = 1;
        };

        var SettingsApplySelect = UI.getItem(picModeSettingsGrp, "SettingsApplySelect");
        var SettingsApplySelectCmp = UI.getItem(SettingsApplySelect, "SettingsApplySelectCmp");
        var SettingsBacklight = UI.getItem(picModeSettingsGrp, "SettingsBacklight");
        var SettingsContrast = UI.getItem(picModeSettingsGrp, "SettingsContrast");
        var SettingsBrightness = UI.getItem(picModeSettingsGrp, "SettingsBrightness");
        var SettingsColor = UI.getItem(picModeSettingsGrp, "SettingsColor");
        var SettingsTint = UI.getItem(picModeSettingsGrp, "SettingsTint");
        var SettingsSharpness = UI.getItem(picModeSettingsGrp, "SettingsSharpness");
        var SettingsOverScan = UI.getItem(picModeSettingsGrp, "SettingsOverScan");
        var SettingsActiveContrast = UI.getItem(picModeSettingsGrp, "SettingsActiveContrast");
        var SettingsAquoMotionEnhancement = UI.getItem(picModeSettingsGrp, "SettingsAquoMotionEnhancement");
        var SettingsJudderReduction = UI.getItem(picModeSettingsGrp, "SettingsJudderReduction");
        var SettingsBlurReduction = UI.getItem(picModeSettingsGrp, "SettingsBlurReduction");
        var SettingsDigitalNoiseReduction = UI.getItem(picModeSettingsGrp, "SettingsDigitalNoiseReduction");
        var SettingsColorTemp = UI.getItem(picModeSettingsGrp, "SettingsColorTemp");
        var SettingsHDMIDynamicRange = UI.getItem(picModeSettingsGrp, "SettingsHDMIDynamicRange");
        var SettingsExpert = UI.getItem(picModeSettingsGrp, "SettingsExpert");
        var SettingsReset = UI.getItem(picModeSettingsGrp, "SettingsReset");

        var picModeSettingsPageData = {
            ColorGamutExist:true,
            isOverScanEnAble: true,
            isMemcSupport: 0,
            isJudderSupport: 0,
            isBlurSupport: 0,
            isEnumSmoothMotionExist: 0,
            SettingsApplySelectVec:["[SE2742]", "[SE2743]"],//["Current Source", "All Source1"],
            SettingsActiveContrastTextVec: ["[GE0006]", "[GE0003]", "[GE0002]", "[GE0001]"],
            SettingsAquoMotionEnhancementTextVec: ["[GE0006]", "[SE0010]", "[SE1437]", "[BR0017]", "[SE0004]", "[SE3129]"],
            SettingsDigitalNoiseReductionTextVec: ["[GE0006]", "[GE0003]", "[GE0002]", "[GE0001]"],
            SettingsMPEGNoiseTextVec: ["[GE0006]", "[GE0003]", "[GE0002]", "[GE0001]"],
            SettingsColorTempTextVec: ["[GE0003]", "[SE3128]", "[GE0002]", "[GE0001]"],
            SettingsHDMIDynamicRangeTextVec:["[GE0012]", "[SE3130]", "[SE0050]"],
            SettingsOverScanTextVec: ["[GE0006]", "[GE0005]"],
            SettingsTintValText:0,

            SettingsApplySelectVal:0,
            SettingsContrastVal:0,
            SettingsBrightnessVal:0,
            SettingsColorVal:0,
            SettingsTintVal:0,
            SettingsSharpnessVal: 0,
            SettingsGameModeVal:0,
            SettingsActiveContrastVal: 0,
            SettingsAquoMotionEnhancementVal: 0,
            SettingsJudderReductionVal: 0,
            SettingsBlurReductionVal: 0,
            SettingsDynamicBacklightControlVal: 0,
            SettingsLocalDimmingVal: 0,
            SettingsDigitalNoiseReductionVal: 0,
            SettingsMPEGNoiseVal: 0,
            SettingsColorTempVal: 0,
            SettingsColorGamutVal:0,
            SettingsHDMIDynamicRangeVal:0,
            SettingsGammaAdjustmentVal: 0,
            SettingsRGBOnlyModeVal: 0,
            SettingsOverScanVal: 0,

            ultraIndexArray:[0,1,2,3,4,5]
        };

        try {
            picModeSettingsPageData.isJudderSupport = tv ? model.video.getJudderReductionExist() : 1;//1
            DBG_INFO("model.video.getJudderReductionExist(): " + picModeSettingsPageData.isJudderSupport);
            picModeSettingsPageData.isBlurSupport = tv ? model.video.getBlurReductionExist() : 1;//1
            DBG_INFO("model.video.getBlurReductionExist(): " + picModeSettingsPageData.isBlurSupport);
        } catch (ex) {
            DBG_ERROR(ex.message);
        }

        var PosYDisable = {
            PosYOverScanUp: 749
        };

        DBG_INFO("getPicSharpnessStep: " + getPicSharpnessStep());

        function picModeSettingsPageInit() {
            try {
                picModeSettingsPageData.SettingsApplySelectVal = tv ? model.video.getApplyMode() : 1;
                DBG_INFO("model.video.getApplyMode()" + picModeSettingsPageData.SettingsApplySelectVal);
                onApplyModeChaged(picModeSettingsPageData.SettingsApplySelectVal);

                picModeSettingsPageData.SettingsContrastVal = tv ? model.video.getContrast() : 50;
                DBG_INFO("model.video.getContrast(): " + picModeSettingsPageData.SettingsContrastVal);
                onContrastChaged(picModeSettingsPageData.SettingsContrastVal);

                picModeSettingsPageData.SettingsBrightnessVal = tv ? model.video.getBrightness() : 50;
                DBG_INFO("model.video.getBrightness(): " + picModeSettingsPageData.SettingsBrightnessVal);
                onBrightnessChaged(picModeSettingsPageData.SettingsBrightnessVal);

                picModeSettingsPageData.SettingsColorVal = tv ? model.video.getColourIntensity() :50;//getColourIntensity()
                DBG_INFO("model.video.getColourIntensity(): " + picModeSettingsPageData.SettingsColorVal);
                onColourIntensityChaged(picModeSettingsPageData.SettingsColorVal);

                picModeSettingsPageData.SettingsTintVal = tv ? model.video.getTint() : -13;
                DBG_INFO("model.video.getTint(): " + picModeSettingsPageData.SettingsTintVal);
                onTintChaged(picModeSettingsPageData.SettingsTintVal);

                picModeSettingsPageData.SettingsSharpnessVal = tv ? model.video.getSharpness() : 14;
                DBG_INFO("model.video.getSharpness(): " + picModeSettingsPageData.SettingsSharpnessVal);
                onSharpnessChaged(picModeSettingsPageData.SettingsSharpnessVal);

                var SettingsActiveContrastValTmp = tv ? model.video.getAdaptiveContrast() : 0;
                DBG_INFO("model.video.getAdaptiveContrast(): " + SettingsActiveContrastValTmp);
                picModeSettingsPageData.SettingsActiveContrastVal = picModeSettingsPageData.SettingsActiveContrastTextVec[SettingsActiveContrastValTmp];
                onAdaptiveContrastChaged(SettingsActiveContrastValTmp);

                picModeSettingsPageData.isMemcSupport = tv ? model.video.getEnumSmoothMotionExist() : 0x8F;//0x87
                DBG_INFO("model.video.getEnumSmoothMotionExist(): " + picModeSettingsPageData.isMemcSupport);
                if (picModeSettingsPageData.isMemcSupport & 0x80) {//7-bit: isMemcSupport
                    var SettingsAquoMotionEnhancementValTmp = tv ? model.video.getEnumSmoothMotion() : 4;
                    DBG_INFO("model.video.getEnumSmoothMotion(): " + SettingsAquoMotionEnhancementValTmp);
                    AquoMotionEnhancementModeIndex();
                    if(picModeSettingsPageData.ultraIndexArray.indexOf(SettingsAquoMotionEnhancementValTmp)<0){
                        SettingsAquoMotionEnhancementValTmp=5;
                    }
                    onEnumSmoothMotionChaged(SettingsAquoMotionEnhancementValTmp);
                    picModeSettingsPageData.isEnumSmoothMotionExist = picModeSettingsPageData.isMemcSupport & 1;//Game模式下灰掉?
                    SetSettingsEnable(SettingsAquoMotionEnhancement, picModeSettingsPageData.isEnumSmoothMotionExist);

                    try {
                        if(!(2 & picModeSettingsPageData.isMemcSupport) || !picModeSettingsPageData.isJudderSupport || !picModeSettingsPageData.isBlurSupport){
                            DeleteJudderBlur();//Don't support Custom
                        }else{
//                            if(picModeSettingsPageData.isJudderSupport){
//                                //Don't support Judder Reduction
                            picModeSettingsPageData.SettingsJudderReductionVal = tv ? model.video.getJudderReduction() : 2;
                            DBG_INFO("model.video.getJudderReduction(): " + picModeSettingsPageData.SettingsJudderReductionVal);
                            onJudderReductionChaged(picModeSettingsPageData.SettingsJudderReductionVal);
                            SetSettingsEnable(SettingsJudderReduction, picModeSettingsPageData.isEnumSmoothMotionExist);
//                            }else{
//                                DeleteJudder();
//                            }
//                            if(picModeSettingsPageData.isBlurSupport){
                            //Don't support Blur Reduction
                            picModeSettingsPageData.SettingsBlurReductionVal = tv ? model.video.getBlurReduction() : 3;
                            DBG_INFO("model.video.getBlurReduction(): " + picModeSettingsPageData.SettingsBlurReductionVal);
                            onBlurReductionChaged(picModeSettingsPageData.SettingsBlurReductionVal);
                            SetSettingsEnable(SettingsBlurReduction, picModeSettingsPageData.isEnumSmoothMotionExist);
//                            }else{
//                                DeleteBlur();
//                            }

                        }
                    } catch (ex) {
                        DBG_ERROR(ex.message);
                    }
                }else{
                    DBG_INFO("setHideSmoothMotion:"+ (picModeSettingsPageData.isMemcSupport & 128));
                    setHideSmoothMotion( );
                }

                var SettingsDigitalDigitalNoiseReductionValTmp = tv ? model.video.getEnumNoiseReduction() : 0;
                DBG_INFO("model.video.getEnumDigitalNoiseReduction(): " + SettingsDigitalDigitalNoiseReductionValTmp);
                picModeSettingsPageData.SettingsDigitalDigitalNoiseReductionVal = picModeSettingsPageData.SettingsDigitalNoiseReductionTextVec[SettingsDigitalDigitalNoiseReductionValTmp];
                onEnumDigitalNoiseReductionChaged(SettingsDigitalDigitalNoiseReductionValTmp);

                var SettingsColorTempValTmp = tv ? model.video.getEnumColourTemperature() : 3;
                DBG_INFO("model.video.getEnumColourTemperature(): " + SettingsColorTempValTmp);
                picModeSettingsPageData.SettingsColorTempVal = picModeSettingsPageData.SettingsColorTempTextVec[SettingsColorTempValTmp];
                onEnumColourTemperatureChaged(SettingsColorTempValTmp);

                var SettingsHDMIDynamicRangeValTemp = tv ? model.video.getHdmiDynamicRange() : 2;
                DBG_INFO("model.video.getHdmiDynamicRange():" + SettingsHDMIDynamicRangeValTemp);
//                picModeSettingsPageData.SettingsHDMIDynamicRangeVal = picModeSettingsPageData.SettingsHDMIDynamicRangeTextVec[SettingsHDMIDynamicRangeValTemp];
                onHdmiDynamicRangeChaged(SettingsHDMIDynamicRangeValTemp);
                picModeSettingsPageData.isHdmiDynamicRangeExist = tv ? model.video.getHdmiDynamicRangeExist() : 1;
                DBG_INFO("model.source.getHdmiDynamicRangeExist(): " + picModeSettingsPageData.isHdmiDynamicRangeExist);
                SetSettingsEnable(SettingsHDMIDynamicRange, picModeSettingsPageData.isHdmiDynamicRangeExist);

                var SettingsOverScanValTmp = tv ? model.video.getOverscan() : 0;
                DBG_INFO("model.video.getOverscan(): " + SettingsOverScanValTmp);
                picModeSettingsPageData.SettingsOverScanVal = picModeSettingsPageData.SettingsOverScanTextVec[SettingsOverScanValTmp];
                onOverscanChaged(SettingsOverScanValTmp);
                picModeSettingsPageData.isOverScanEnAble = checkOverScanEnAble();
                SetSettingsEnable(SettingsOverScan, picModeSettingsPageData.isOverScanEnAble);

            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }
        ApplySelectCommon(SettingsApplySelect, SettingsApplySelectCmp);
        function ApplySelectCommon(label, labelCmp){
            try{
                Select.create(labelCmp, ["Current Source", "All Source"]);
                label.onkey_RIGHT = function () {
                    labelCmp.selectNext();
                    var index=labelCmp.values.indexOf(labelCmp.selected);
                    tv && model.video.setApplyMode(index);
                    DBG_INFO('model.video.setApplyMode('+index + ')');
                    UI.updateStage();
                };
                label.onkey_LEFT = function () {
                    labelCmp.selectNext();
                    var index=labelCmp.values.indexOf(labelCmp.selected);
                    tv && model.video.setApplyMode(index);
                    DBG_INFO('model.video.setApplyMode('+index + ')');
                    UI.updateStage();
                };
            }catch (ex) {
                DBG_ERROR(ex.message);
            }
        }
        switchBar_common(picModeSettingsGrp, "SettingsGameMode", "SettingsGameModeSwitch");
        function switchBar_common(submodule, groupname, pic_switch_name) {
            try {
                var switchBar = UI.getItem(submodule, groupname);
                var switchComp = UI.getItem(switchBar, pic_switch_name);
                Switch.create(switchComp, ({0: false, 1: true}[picModeSettingsPageData.SettingsGameModeVal]));
                //switchBar.updateCache();
                UI.updateStage();
                switchBar.onFocus = function () {
                    switchComp.onFocus();
//                    sndMainPageHelpInfo(groupname);
                    UI.updateStage();
                    return true;
                };
                switchBar.onkey_ENTER = function () {
                    switchMove();
                };
                switchBar.onkey_LEFT = function () {
                    switchMove();
                };
                switchBar.onkey_RIGHT = function () {
                    switchMove();
                };
                function switchMove() {
                    try {
                        tv && model.video.setGameMode(({false: 0, true: 1}[!switchComp.flag]));
                        DBG_INFO('model.video.setGameMode(' + ({false: 0, true: 1}[!switchComp.flag]) + ')');
//                        switchComp.setSwitch(!switchComp.flag);
//                        SettingsGameModeSwitch.switch(({0: false, 1: true}[0]));
                        switchComp.onFocus();
                        UI.updateStage();
                    }
                    catch (ex) {
                        DBG_ERROR(ex.message);
                    }
                }
            }
            catch (e) {
                DBG_ERROR("Switchbar_common func is error");
            }
        }

        function AquoMotionEnhancementModeIndex(){
            try {
                picModeSettingsPageData.ultraIndexArray=[0,1,2,3,4,5];
                var ultraIndex = [];
                if(picModeSettingsPageData.isMemcSupport&comData.ExistFlag){
                    //Smooth / Standard / Clear / Animation / Custom / Off
                    var stdVal = [comData.OffFlag,comData.CustomFlag,comData.FilmFlag,comData.ClearFlag,comData.StandardFlag,comData.SmoothFlag];
                    for(var i=5; i>0;i--){
                        if(i==1){
                            ultraIndex[i] = ((picModeSettingsPageData.isMemcSupport&stdVal[i])
                                && (picModeSettingsPageData.isJudderSupport &&picModeSettingsPageData.isBlurSupport)) ? 0: 1;
                        }else{
                            ultraIndex[i] = picModeSettingsPageData.isMemcSupport&stdVal[i] ? 0: 1;
                        }
                        picModeSettingsPageData.ultraIndexArray.splice(i,ultraIndex[i]);
                    }
                }
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }
        var comData = {
            OffFlag:0xFF,
            CustomFlag:0x02,
            FilmFlag:0x04,
            ClearFlag:0x08,
            StandardFlag:0x10,
            SmoothFlag:0x20,
            ExistFlag:0x80
        };
        var AspectRatioData = {
            Direct : 14,
            PixelMap : 3
        };
        function checkOverScanEnAble() {
            try {
                var appGhost = UI.getGhostModule(APPMODULE.CONTROL);
                var isOverScan= tv ? model.video.getOverscanSupported():0;
                var isUhdFlag = tv ? model.video.getUhdFlag() : 0;
                var isDMPRuning = UI.isExistModule ('hiMedia');
                var isZoom = [AspectRatioData.Direct, AspectRatioData.PixelMap].indexOf(tv ? model.video.getEnumZoom() : 1) > -1;
                var isWeather = UI.isExistModule ('accuweather');
                if (appGhost != null || isUhdFlag == 1 || true == isDMPRuning
                    || true == isZoom ||isOverScan==1 || true == isWeather) {
                    DBG_ERROR("checkOverScanEnAble: "+'appGhost: '+appGhost+ ', isUhdFlag: '+isUhdFlag
                        +',isDMPRuning: '+isDMPRuning+',isZoom: '+isZoom+',isOverScan: '+isOverScan + ',isWeather: '+isWeather);
                    return false;
                } else {
                    return true;
                }
            } catch (ex) {
                DBG_ERROR(ex.message);
                return true;
            }
        }

        function SetSettingsEnable(disableItem, isEnable) {
            try{
                DBG_INFO(disableItem.name + ' '+ isEnable);
                if(!isEnable){
                    DBG_INFO(disableItem.name + ' '+ 'hide');
                    disableItem.disable = true;
                    disableItem.alpha = 0.3;
                }else{
                    DBG_INFO(disableItem.name + ' '+ 'show');
                    disableItem.disable = false;
                    disableItem.alpha = 1;
                }
            }catch (ex) {
                DBG_ERROR(ex.message);
            }
        }

        function DeleteJudderBlur(){
            try {
                DBG_INFO("Hide Judder and Blur");
                SettingsJudderReduction.disable = true;
                SettingsJudderReduction.alpha = 0;
                SettingsBlurReduction.disable = true;
                SettingsBlurReduction.alpha = 0;
                SettingsDigitalNoiseReduction.y = SettingsAquoMotionEnhancement.y + heightEnum.H_120 + cmpSpaceEnum.H_24;
                var array=[SettingsAquoMotionEnhancement, SettingsDigitalNoiseReduction, SettingsHDMIDynamicRange,
                    SettingsActiveContrast, SettingsExpert, SettingsReset];
                for(var i=1; i<array.length;i++){
                    array[i].y=array[i-1].y + heightEnum.H_120 + cmpSpaceEnum.H_24;
                }
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }
        function setHideSmoothMotion( ) {
            try {
                DBG_INFO("Hide Smooth Motion");
                if(SettingsDigitalNoiseReduction.y == SettingsAquoMotionEnhancement.y) return;
                SettingsAquoMotionEnhancement.disable = true;
                SettingsAquoMotionEnhancement.alpha = 0;
                SettingsJudderReduction.disable = true;
                SettingsJudderReduction.alpha = 0;
                SettingsBlurReduction.disable = true;
                SettingsBlurReduction.alpha = 0;
                SettingsDigitalNoiseReduction.y=SettingsAquoMotionEnhancement.y;
                var array=[SettingsColorTemp, SettingsDigitalNoiseReduction, SettingsHDMIDynamicRange,
                    SettingsActiveContrast, SettingsExpert, SettingsReset];
                for(var i=1; i<array.length;i++){
                    array[i].y=array[i-1].y + heightEnum.H_120 + cmpSpaceEnum.H_24;
                }
                UI.updateStage();
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }

        SetHelpInfo();
        function SetHelpInfo() {
            var CmpHelpInfo = {
                SettingsApplySelect: {
                    title: "SettingsApplySelect",
                    info: '[SE2744]' //"Adjust current picture mode to apply to all sources or just current source.."
                },
                SettingsBacklight: {
                    title: "Backlight",
                    info: '[SE0469]'//"Adjust Dynamic Backlight Control, Backlight Level, Automatic Light Sensor .....",
                },
                SettingsContrast: {
                    title: "Contrast",
                    info: '[SE0459]' //"Adjust the Contrast level to increase or decrease how bright images appear."
                },
                SettingsBrightness: {
                    title: "Brightness",
                    info: '[SE0458]'
                },
                SettingsColor: {
                    title: "Color",
                    info: '[SE0460]'//Adjust the colour intensity of the picture for a more vibrant image.
                },
                SettingsTint: {
                    title: "Tint",
                    info: '[SE0479]'//Adjust the colours from a green to magenta tint to view the natural skin tones of people on the screen.
                },
                SettingsSharpness: {
                    title:" ",
                    info: "[SE0480]"
                },
                SettingsActiveContrast: {
                    title: " ",
                    info: "[SE0482]"
                },
                SettingsAquoMotionEnhancement: {
                    title: " ",
                    info: "[SE0527]"
                },
                SettingsJudderReduction: {
                    title: " ",
                    info: ""//"[SE3296]" -- remove description in NA
                },
                SettingsBlurReduction: {
                    title: " ",
                    info: ""//"[SE3297]"  -- remove description in NA
                },
                SettingsDigitalNoiseReduction: {
                    title: " ",
                    info: "[SE0528]"
                },
                SettingsColorTemp: {
                    title: " ",
                    info: "[SE0483]"
                },
                SettingsHDMIDynamicRange: {
                    title: " ",
                    info: "[SE2916]"
                },
                SettingsExpert: {
                    title: "Expert Settings",
                    info: "[SE2919]"//Adjust the color space and Gamma to best suit the content you're viewing.
                },
                SettingsReset: {
                    title: " ",
                    info: '[SE0534]'//"Restore all the picture settings in the current picture mode to the factory default values.",
                },
                SettingsOverScan: {
                    title: " ",
                    info: "[SE0525]"
                }
            };

            try {
                var CmpVec = [SettingsApplySelect,SettingsBacklight,SettingsContrast,SettingsBrightness,SettingsColor,
                    SettingsTint,SettingsSharpness,SettingsOverScan,SettingsColorTemp,SettingsAquoMotionEnhancement,
                    SettingsJudderReduction,SettingsBlurReduction, SettingsDigitalNoiseReduction, SettingsHDMIDynamicRange,SettingsActiveContrast,
                    SettingsExpert,SettingsReset];
                var infoCmp = UI.getItem(picModeSettings, 'picModeSettingsInfo');

                for (var i = 0; i < CmpVec.length; i++) {
                    cmpSetOnNormalFocusFunc(CmpVec[i]);
                }

                function cmpSetOnNormalFocusFunc(cmp) {
                    cmp.onFocus = function () {
                        DBG_INFO('info: ' + CmpHelpInfo[cmp.name].info);
                        UI.setText(infoCmp, CmpHelpInfo[cmp.name].info);
                        return true;
                    };
                }
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }

        function CreateLabelFunc(label, labelStr) {
            try {
                var fontSize = "36px SourceSansPro-Light";
                var cmpValue = UI.getItem(label, "textLabelValue");
                LabelValue.create(cmpValue, labelStr, fontSize, "0xFFFFFF");
                cmpValue.setValue(eval('picModeSettingsPageData.' + label.name + "Val").toString());
                UI.updateStage();
                label.onkey_ENTER = function () {
                    DBG_INFO(label.name + ".onkey_ENTER");
                    switch (label.name){
                        case "SettingsContrast":
                        case "SettingsBrightness":
                        case "SettingsColor":
                        case "SettingsTint":
                        case "SettingsSharpness":
                            PictureConfig.PQAdjustSign = "pic"+label.name.substr(8);
                            UI.pushSubModule("setting", "picPQAdjust", true);
                            HidePicModeSettings();
                            break;
                        case "SettingsActiveContrast":
                        case "SettingsDigitalNoiseReduction":
                        case "SettingsColorTemp":
                        case "SettingsHDMIDynamicRange":
                        case "SettingsAquoMotionEnhancement":
                            if(label.name=="SettingsHDMIDynamicRange"&& !picModeSettingsPageData.isHdmiDynamicRangeExist) {
                                UI.showSimpleTip("[SE3321]");
                            } else {
                                PictureConfig.picModeSign = 'pic' + label.name.substr(8);
                                UI.pushSubModule("setting", "picMode", true);
                                HidePicModeSettings();
                            }
                            break;
                        case "SettingsJudderReduction":
                            if(picModeSettingsPageData.isJudderSupport &&picModeSettingsPageData.isBlurSupport){
                                PictureConfig.PicJudderBlurSign = PicSignDefine.PicJudderBlurSign.PIC_JUDDER;
                                UI.pushSubModule("setting", "picJudderBlurReductionAdjust", true);
//                                }else if(!picModeSettingsPageData.isBlurSupport && picModeSettingsPageData.isJudderSupport){
//                                    PictureConfig.PQ2AdjustSign = PicSignDefine.PQ2AdjustSign.PIC_JUDDER;
//                                    DBG_INFO("PictureConfig.PQ2AdjustSign"+PictureConfig.PQ2AdjustSign);
//                                    UI.pushSubModule("setting", "picPQ2Adjust", true);
                            }
                            HidePicModeSettings();
                            break;
                        case "SettingsBlurReduction":
                            if(picModeSettingsPageData.isJudderSupport &&picModeSettingsPageData.isBlurSupport){
                                PictureConfig.PicJudderBlurSign = PicSignDefine.PicJudderBlurSign.PIC_BLUR;
                                UI.pushSubModule("setting", "picJudderBlurReductionAdjust", true);
//                                }else if(!picModeSettingsPageData.isJudderSupport && picModeSettingsPageData.isBlurSupport){
//                                    PictureConfig.PQ2AdjustSign = PicSignDefine.PQ2AdjustSign.PIC_BLUR;
//                                    UI.pushSubModule("setting", "picPQ2Adjust", true);
                            }
                            HidePicModeSettings();
                            break;
                        case "SettingsOverScan" :
                            if(!picModeSettingsPageData.isOverScanEnAble){
                                UI.showSimpleTip("[SE3322]");//This feature is not available for current signal or application
                            } else {
                                PictureConfig.picOnOffSign = 'picOverScan';
                                UI.pushSubModule("setting", "picOverScanAdjust", true);
                                HidePicModeSettings();
                            }
                            break;
                        default:
                            DBG_ERROR("Label.name ERR");
                            break;
                    }
                };
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }
        var aquoMotionEnhancementStr = GLOBAL.UI_BRAND=="shp"?"[SE3132]":"[OT0255]";
        CreateLabelFunc(SettingsContrast, "[SE0012]");
        CreateLabelFunc(SettingsBrightness, "[SE0011]");
        CreateLabelFunc(SettingsColor, "[SE1833]");
        CreateLabelFunc(SettingsTint, "[SE0054]");
        CreateLabelFunc(SettingsSharpness, "[SE0053]");
        CreateLabelFunc(SettingsActiveContrast, "[SE3137]");
        CreateLabelFunc(SettingsAquoMotionEnhancement, aquoMotionEnhancementStr);
        CreateLabelFunc(SettingsJudderReduction, "[SE2910]");
        CreateLabelFunc(SettingsBlurReduction, "[SE2911]");
        CreateLabelFunc(SettingsDigitalNoiseReduction, "[SE3135]");
        CreateLabelFunc(SettingsColorTemp, "[SE0038]");
        CreateLabelFunc(SettingsHDMIDynamicRange, "[SE3136]");
        CreateLabelFunc(SettingsOverScan, "[SE0524]");

        var onApplyModeChaged = function(val){
            try {
                DBG_INFO("onApplyModeChaged: " + val);
                SettingsApplySelectCmp.changeValue(picModeSettingsPageData.SettingsApplySelectVec, val);
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        };
        var onContrastChaged = function (val) {
            try {
                DBG_INFO("onContrastChaged: " + val);
                picModeSettingsPageData.SettingsContrastVal = val;
                UILabelSetVal(SettingsContrast);
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        };
        var onBrightnessChaged = function (val) {
            try {
                DBG_INFO("onBrightnessChaged: " + val);
                picModeSettingsPageData.SettingsBrightnessVal = val;
                UILabelSetVal(SettingsBrightness);
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        };
        var onColourIntensityChaged = function (val) {
            try {
                DBG_INFO("onColourIntensityChaged: " + val);
                picModeSettingsPageData.SettingsColorVal = val;
                UILabelSetVal(SettingsColor);
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        };
        var onTintChaged = function(val){
            try {
                DBG_INFO("onTintChaged: " + val);
                if (val > 0) {
                    picModeSettingsPageData. SettingsTintValText = "G" + val;
                } else if (val < 0) {
                    picModeSettingsPageData. SettingsTintValText = "R" + (-val);
                } else {
                    picModeSettingsPageData. SettingsTintValText = 0;
                }

                UILabelSetVal(SettingsTint);
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        };
        var onSharpnessChaged = function (val) {
            try {
                DBG_INFO("onSharpnessChaged: " + val);
                picModeSettingsPageData.SettingsSharpnessVal = Math.round(val/PicTunerStep.SharpnessStep);
                UILabelSetVal(SettingsSharpness);
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        };
        var onAdaptiveContrastChaged = function (val) {
            try {
                DBG_INFO("onAdaptiveContrastChaged: " + val);
                picModeSettingsPageData.SettingsActiveContrastVal = picModeSettingsPageData.SettingsActiveContrastTextVec[val];
                UILabelSetVal(SettingsActiveContrast);
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        };
        var onEnumSmoothMotionChaged = function (val) {
            try {
                DBG_INFO("onEnumSmoothMotionChaged: " + val);
                picModeSettingsPageData.SettingsAquoMotionEnhancementVal = picModeSettingsPageData.SettingsAquoMotionEnhancementTextVec[val];
                UILabelSetVal(SettingsAquoMotionEnhancement);
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        };
        var onJudderReductionChaged = function (val) {
            try {
                DBG_INFO("onJudderReductionChaged: " + val);
                picModeSettingsPageData.SettingsJudderReductionVal = val;
                UILabelSetVal(SettingsJudderReduction);
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        };
        var onBlurReductionChaged = function (val) {
            try {
                DBG_INFO("onBlurReductionChaged: " + val);
                picModeSettingsPageData.SettingsBlurReductionVal = val;
                UILabelSetVal(SettingsBlurReduction);
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        };
        var onEnumDigitalNoiseReductionChaged = function (val) {
            try {
                DBG_INFO("onEnumDigitalNoiseReductionChaged: " + val);
                picModeSettingsPageData.SettingsDigitalNoiseReductionVal = picModeSettingsPageData.SettingsDigitalNoiseReductionTextVec[val];
                UILabelSetVal(SettingsDigitalNoiseReduction);
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        };
        var onEnumColourTemperatureChaged = function (val) {
            try {
                DBG_INFO("onEnumColourTemperatureChaged: " + val);
                val = ({0: 3, 1: 2, 2: 0, 3: 1}[val]);
                picModeSettingsPageData.SettingsColorTempVal = picModeSettingsPageData.SettingsColorTempTextVec[val];
                UILabelSetVal(SettingsColorTemp);
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        };
//        var onColorSpaceChaged = function (val) {
//            try {
//                DBG_INFO("onGamutChaged: " + val);
//                picModeSettingsPageData.SettingsColorGamutVal = picModeSettingsPageData.SettingsColorGamutTextVec[val];
//                UILabelSetVal(SettingsColorGamut);
//            } catch (ex) {
//                DBG_ERROR(ex.message);
//            }
//        };
        var onHdmiDynamicRangeChaged = function (val) {
            try {
                DBG_INFO("onBaclLevelChaged: " + val);
                picModeSettingsPageData.SettingsHDMIDynamicRangeVal = picModeSettingsPageData.SettingsHDMIDynamicRangeTextVec[val];
                //PicExpertPageData.ExpertHDMIDynamicRangeVal = val;
                UILabelSetVal(SettingsHDMIDynamicRange);
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        };
        var onOverscanChaged = function (val) {
            try {
                DBG_INFO("onOverscanChaged: " + val);
                picModeSettingsPageData.SettingsOverScanVal = picModeSettingsPageData.SettingsOverScanTextVec[val];
                UILabelSetVal(SettingsOverScan);
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        };

        function UILabelSetVal(label) {
            try {
                DBG_INFO(eval('picModeSettingsPageData.' + label.name + "Val"));
                if(label.name == "SettingsTint"){
                    UI.getItem(label, "textLabelValue").setValue(eval('picModeSettingsPageData.' + label.name + "Val" + "Text"));
                }else{
                    UI.getItem(label, "textLabelValue").setValue(eval('picModeSettingsPageData.' + label.name + "Val"));
                }
                UI.updateStage();
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }

        function ModelNotifyInit() {
            try {
                UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_APPLY_MODE, onApplyModeChaged);
                UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_CONTRAST, onContrastChaged);
                UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_BRIGHTNESS, onBrightnessChaged);
                UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_COLOUR_INTENSITY, onColourIntensityChaged);
                UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_TINT, onTintChaged);
                UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_SHARPNESS, onSharpnessChaged);
                UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_ADAPTIVE_CONTRAST, onAdaptiveContrastChaged);
                UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_SMOOTHR_MOTION, onEnumSmoothMotionChaged);
                UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_JUDDER_REDUCTION, onJudderReductionChaged);
                UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_BLUR_REDUCTION, onBlurReductionChaged);
                UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_NOISE_REDUCTION, onEnumDigitalNoiseReductionChaged);
                UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_COLOR_TEMP, onEnumColourTemperatureChaged);
                UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_HDMI_DYNAMIC_RANGE, onHdmiDynamicRangeChaged);
                UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_OVERSCAN, onOverscanChaged);


            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }
        function UNModelNotifyInit() {
            try {
                UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_APPLY_MODE, onApplyModeChaged);
                UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_CONTRAST, onContrastChaged);
                UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_BRIGHTNESS, onBrightnessChaged);
                UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_COLOUR_INTENSITY, onColourIntensityChaged);
                UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_TINT, onTintChaged);
                UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_SHARPNESS, onSharpnessChaged);
                UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_ADAPTIVE_CONTRAST, onAdaptiveContrastChaged);
                UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_SMOOTHR_MOTION, onEnumSmoothMotionChaged);
                UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_JUDDER_REDUCTION, onJudderReductionChaged);
                UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_BLUR_REDUCTION, onBlurReductionChaged);
                UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_NOISE_REDUCTION, onEnumDigitalNoiseReductionChaged);
                UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_COLOR_TEMP, onEnumColourTemperatureChaged);
                UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_HDMI_DYNAMIC_RANGE, onHdmiDynamicRangeChaged);
                UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_OVERSCAN, onOverscanChaged);
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }

        function HidePicModeSettings() {
            picModeSettings.alpha = 0;
        }

        SettingsApplySelect.onkey_ENTER = function(){
            DBG_INFO('SettingsApplySelect.onkey_ENTER');
            PictureConfig.picApplyModeSign = PicSignDefine.PicApplyModeSign.PIC_APPLY_PICTURE_SETTINGS;
            UI.pushSubModule("setting", "picApplyMode", true);
        };
        SettingsBacklight.onkey_ENTER = function(){
            DBG_INFO('SettingsBacklight.onkey_ENTER');
            HidePicModeSettings();
            PictureConfig.PicBacklightSign = PicSignDefine.PicBacklightSign.PIC_DYNAMIC;
            try {
                var isSensorSupport = tv ? model.video.getLightSensorSupported() : 1;
                DBG_ERROR("model.video.getLightSensorSupported()" + isSensorSupport);
            } catch (ex) {
                DBG_ERROR("model.video.getLightSensorSupported error: " + ex);
            }
            if (isSensorSupport) {
                UI.pushSubModule("setting", "picBacklightAdjust", true);
            } else {
                UI.pushSubModule("setting", "picBacklightAdjustDelEco", true);
            }
        };
        SettingsExpert.onkey_ENTER = function(){
            DBG_INFO('SettingsExpert.onkey_ENTER');
            HidePicModeSettings();
            UI.pushSubModule("setting", "picExpert", true);
        };
        SettingsReset.onkey_ENTER = function(){
            DBG_INFO('SettingsReset.onkey_ENTER');
            PictureConfig.PicResetSign = PicSignDefine.PicResetSign.PIC_RESET;
            UI.pushSubModule("setting", "picReset", true);
        };
        picModeSettings.onPop = function(){
            UNModelNotifyInit();
        };
    } catch (ex) {
        DBG_ERROR(ex.message);
    }
};
