// Init
//PicMainFunc = {};

UI.moduleBuilder['setting']['picMain'] = function(){
    try {

        var heightEnum = {
            H_120: 120,
            H_72: 72
        };

        var cmpSpaceEnum = {
            H_0: 0,
            H_10: 10,
            H_24: 24,
            H_48: 48
        };
        var firMagTop = cmpSpaceEnum.H_48;

        var cmpCfgVector = [
            {
                id: "picMainMode",
                height: heightEnum.H_120
            },
            {
                id: "picMainAspectRatio",
                height: heightEnum.H_120
            },
            {
                id: "picMainSettings",
                height: heightEnum.H_120
            }
        ];
        var cmpIdVec = [];
        for (var i = 0; i < cmpCfgVector.length; i++) {
            cmpIdVec.push(cmpCfgVector[i].id);
        }
        function getCmpSpacing(idx) {
            if (0 == idx) {
                return firMagTop;//first
            } else {
                if (cmpCfgVector[idx].height == heightEnum.H_72 && cmpCfgVector[idx - 1].height == heightEnum.H_72) {
                    return cmpSpaceEnum.H_10;
                } else {
                    return cmpSpaceEnum.H_24
                }
            }
        }
        function getCmpPosY(cmpId) {
            var idx = cmpIdVec.indexOf(cmpId);
            var posY = cmpSpaceEnum.H_0;
            for (var i = 0; i < idx; i++) {
                posY += cmpCfgVector[i].height + getCmpSpacing(i + 1);
            }
            return posY;
        }

        var initData = {
            "picMainSheet": UI.setting_bg,
            "picMainIconImg": "setting/"+GLOBAL.LAUNCHER_BRAND+"/ic_picture_154x154.png",
            "picMainModeBar": UI.btn_normal_bg,
            "picMainAspectRatioBar": UI.btn_normal_bg,
            "picMainSettingsBG": UI.btn_normal_bg
        };
        var template = Util.readJson("module/setting/picMain.json");

        for (var i = 0; i < cmpCfgVector.length; i++) {
            DBG_INFO(cmpCfgVector[i].id + getCmpPosY(cmpCfgVector[i].id));
            template.picMain.items.picMainGrp.items[cmpCfgVector[i].id].position.y = getCmpPosY(cmpCfgVector[i].id);
            template.picMain.items.picMainGrp.items[cmpCfgVector[i].id].position.x = 0;
        }

        var setPicMain = SubModule.create(initData, template);
        var picMainGrp = UI.getItem(setPicMain, "picMainGrp");
        UI.addMask(picMainGrp, 1242, 925, 80, 6);
        UI.setView(picMainGrp, 1242, 925);
    } catch (ex) {
        DBG_ERROR(ex.message);
    }

    try {

        var picMain = UI.getSubModule("picMain");
        picMain.onPush = function () {
            try {
                ModelNotifyInit();
                var isHDRFlag = tv ? model.video.getHdrFlag() : 0;
                var HDRMode = ["[OT0098]","[OT0095]","[OT0099]","[OT0100]","[OT0094]","[SE3404]","[OT0102]"];//["HDR Vivid", "HDR  Standard", "HDR Energy Saving","HDR Theater", "HDR  Game", "HDR Sports", "HDR  Calibrated"],
                    SDRMode = ["[SE0456]", "[SE0004]", "[SE0457]", "[SE0061]", "[SE0008]", "[LA0013]", "[SE3122]"];
                DBG_INFO("model.video.getHdrFlag(): " + isHDRFlag);
                PicMainPageData.picModeTextVec = isHDRFlag ?  HDRMode: SDRMode;
//                model.video.onApplyModeChaged = onApplyModeChaged;
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
            PicMainPageDataInit();
            picMain.currFocus = UI.getItem(picMain, "picMainMode");
            UI.updateStage();
        };
        picMain.onShow = function () {
            if(UI.isExistModule('launcher')){
                UI.hideModule(launcher);
            }
            try {
                UI.getItem(setting, 'mainPanel').alpha = 0;
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
            picMain.alpha = 1;
        };

        var picMainMode = UI.getItem(picMain, "picMainMode");
        var picMainAspectRatio = UI.getItem(picMain, "picMainAspectRatio");
        var picMainSettings = UI.getItem(picMain, "picMainSettings");

        SetHelpInfo();

        function SetHelpInfo() {
            var CmpHelpInfo = {
                picMainMode: {
                    title: "Picture Mode",
                    info: '[SE0455]' //"Select a preset picture mode to best suit the content you're viewing."
                },
                picMainAspectRatio: {
                    title: "Aspect Ratio",
                    info: '[SE0462]'//"Adjust the Aspect Ratio to stretch or zoom in on your picture."
                },
                picMainSettings: {
                    title: "Picture Mode Settings",
                    info: '[SE3752]' //"Adjust display settings for each Picture Mode"
                }
            };
            try {
                var CmpVec = [picMainMode, picMainAspectRatio, picMainSettings];
                var infoCmp = UI.getItem(picMain, 'picMainInfo');
                for (var i = 0; i < CmpVec.length; i++) {
                    cmpSetOnNormalFocusFunc(CmpVec[i]);
                }
                function cmpSetOnNormalFocusFunc(cmp) {
                    cmp.onFocus = function () {
                        DBG_INFO('info: ' + CmpHelpInfo[cmp.name].info);
                        UI.setText(infoCmp, CmpHelpInfo[cmp.name].info);
                        return true;
                    };
                }
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }

        var PicMainPageData = {
            isAspectRatioEnable: true,
            picModeTextVec: ["[SE0456]", "[SE0004]", "[SE0457]", "[SE0061]", "[SE0008]", "[LA0013]", "[SE3122]"],
            picMainAspectRatioTextVec: ["[GE0012]", "[SE0080]", "[SE0049]", "[SE0463]", "[SE0467]", "[SE2901]", "[SE3127]", "[SE0464]"],
            //Auto Normal Zoom Wide Direct Dot-By-Dot Panoramic Cinema
	    
            picMainModeVal: 0,
            picMainAspectRatioVal: 0
        };

        function PicMainPageDataInit() {
            try {
                var picMainModeValTemp = tv ? model.video.getEnumPictureMode() : 1;
                DBG_INFO("model.video.getEnumPictureMode()" + picMainModeValTemp);
                PicMainPageData.picMainModeVal = PicMainPageData.picModeTextVec[picMainModeValTemp];
                onEnumPictureModeChaged(picMainModeValTemp);

                var picMainAspectRatioValTemp = tv ? model.video.getEnumZoom() : 14;
                DBG_INFO("model.video.getEnumZoom()" + picMainAspectRatioValTemp);
                onEnumZoomChaged(picMainAspectRatioValTemp);
                PicMainPageData.isAspectRatioEnable =  checkAspectRatioEnAble();
                SetModeEnable(picMainAspectRatio, PicMainPageData.isAspectRatioEnable);
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }

        function SetModeEnable(disableItem, isEnable){
            try {
                DBG_INFO(disableItem.name + ' '+ isEnable);
                if(!isEnable){
                    DBG_INFO(disableItem.name + ' '+ 'hide');
                    disableItem.disable = true;
                    disableItem.alpha = 0.3;
                }else{
                    DBG_INFO(disableItem.name + ' '+ 'show');
                    disableItem.disable = false;
                    disableItem.alpha = 1;
                }
                UI.updateStage();
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }

        var onEnumPictureModeChaged = function (val) {
            try {
                DBG_INFO("onEnumPictureModeChaged: " + val);
                PicMainPageData.picMainModeVal = PicMainPageData.picModeTextVec[val];
                UILabelSetVal(picMainMode);
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        };
        var onEnumZoomChaged = function (val) {
            try {
                DBG_INFO("onEnumZoomChaged: " + val);
                //Auto Normal Zoom Wide Direct Dot-By-Dot Panoramic Cinema
                val = ({0:3, 1:1, 2:6, 3:5, 4:2, 12:7, 13:0, 14:4}[val]);
                PicMainPageData.picMainAspectRatioVal = PicMainPageData.picMainAspectRatioTextVec[val];
                UILabelSetVal(picMainAspectRatio);
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        };

        function UILabelSetVal(label) {
            try {
                UI.getItem(label, "textLabelValue").setValue(eval('PicMainPageData.' + label.name + "Val"));
                UI.updateStage();
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }

        function ModelNotifyInit() {
            try {
                UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_MODE, onEnumPictureModeChaged);
                UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_ZOOM, onEnumZoomChaged);
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }

        function CreateLabelFunc(label, labelStr) {
            try {
                var cmpValue = UI.getItem(label, "textLabelValue");
                LabelValue.create(cmpValue, labelStr, FontDef.Arial_36, "0xFFFFFF");
                cmpValue.setValue(eval('PicMainPageData.' + label.name + "Val").toString());
                UI.updateStage();

                label.onkey_ENTER = function () {
                    DBG_INFO(label.name + ".onkey_ENTER");
                    HidePicMain();
                    switch(label.name) {
                        case "picMainMode":
                        case "picMainAspectRatio":
                            PictureConfig.picModeSign = "pic"+label.name.substr(7);
                            UI.pushSubModule("setting", "picMode", true);
                            break;
                        default:
                            DBG_ERROR("label.name: "+label.name);
                            break;
                    }
                }
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }

        CreateLabelFunc(picMainMode, "[SE0003]");
        CreateLabelFunc(picMainAspectRatio, "[SE0461]");

        function HidePicMain() {
            picMain.alpha = 0;
        }
        picMainSettings.onkey_ENTER = function(){
            DBG_INFO("picMainSettings.onkey_ENTER");
            HidePicMain();
            UI.pushSubModule("setting", "picModeSettings", true);
        };

        picMain.onPop = function(){
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_MODE, onEnumPictureModeChaged);
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_ZOOM, onEnumZoomChaged);
//            model.video.onApplyModeChaged = null;
        }
    } catch (ex) {
        DBG_ERROR(ex.message);
    }
};