/**
 * Created by manli1 on 2016-5-10.
 */
UI.moduleBuilder['setting']['picApplyMode'] = function(){
    var ImageList = {
        normalImage:"setting/ic_radiobutton_normal.png",
        focusImage:OEMFunction.getInstance().getBrandSelectFocusImage()
    };
    var initData = {
        fullBg: UI['bg_overlay'],
        dialogBg: UI.window_bg
    };
    var template = Util.readJson("module/setting/picApplyMode.json");

    var picApplyModeDataCfg = {
        picApplyPictureSettings: {
            title: '[SE3282]',
            array: [
                {tileBg: UI.item_bg, tileTxt: '[SE2742]'},
                {tileBg: UI.item_bg, tileTxt: '[SE2743]'}
            ]
        },
        picApplyColorTuner: {
            title: '[SE3283]',
            array: [
                {tileBg: UI.item_bg, tileTxt: '[SE3285]'},
                {tileBg: UI.item_bg, tileTxt: '[SE3286]'}
            ]
        },
        picApply2PWhiteBalance: {
            title: '[SE3284]',
            array: [
                {tileBg: UI.item_bg, tileTxt: '[SE3285]'},
                {tileBg: UI.item_bg, tileTxt: '[SE3286]'}
            ]
        },
        picApply10PWhiteBalance: {
            title: '[SE3284]',
            array: [
                {tileBg: UI.item_bg, tileTxt: '[SE3285]'},
                {tileBg: UI.item_bg, tileTxt: '[SE3286]'}
            ]
        },
        picWhtBal2Pot10Pot: {
            title: '[SE0494]',
            array: [
                {tileBg: UI.item_bg, tileTxt: '[SE0496]'},
                {tileBg: UI.item_bg, tileTxt: '[SE0512]'}
            ]
        },
        picWhtBal2Pot20Pot: {
            title: '[SE0494]',
            array: [
                {tileBg: UI.item_bg, tileTxt: '[SE0496]'},
                {tileBg: UI.item_bg, tileTxt: '[SE3565]'}
            ]
        },
        picMainHdmiSelect: {
            title: '[SE2974]',
            array: [
                {tileBg: UI.item_bg, tileTxt: '[SE3178]'},
                {tileBg: UI.item_bg, tileTxt: '[SE3179]'}
            ]
        }
    };

    DBG_INFO('PictureConfig.picApplyModeSign:' + PictureConfig.picApplyModeSign);
    template.picApplyMode.items.title.value = picApplyModeDataCfg[PictureConfig.picApplyModeSign].title;
    var picApplyMode = SubModule.create(initData, template);

    var grid = UI.getItem(picApplyMode, "gird");

    picApplyMode.onPush = function () {
        grid != StrDef.UNDEFINED && grid.removeAllChildren();
        // Grid的配置信息JSON
        var info = {
            template: "DialogListItem",
            direction: CONST.GIRD_DIRECTION.H,
            breakNum: 1,
            distanceX: 0,
            distanceY: 20,
            container: grid
        };
        var array = [];
        var arrayData = picApplyModeDataCfg[PictureConfig.picApplyModeSign].array;
        if (PictureConfig.picApplyModeSign == "picWhtBal2Pot10Pot" && picApplyModePageData.isPicWhtBal20PotSupport) {
            arrayData = picApplyModeDataCfg["picWhtBal2Pot20Pot"].array;
        }

        for (var i = 0; i < arrayData.length; i++) {
            array.push({
                tileBg: arrayData[i].tileBg,
                ItemName: arrayData[i].tileTxt,
                name: "item" + i,
                isFlag: "setting/ic_radiobutton_normal.png"
            });
        }
        Gird.create(array, info);
        UI.setText(UI.getItem(picApplyMode, 'title'), picApplyModeDataCfg[PictureConfig.picApplyModeSign].title);

        picApplyModePageInit();
        //UI.getCurrFocus() = picApplyMode.currFocus = UI.getItem(picApplyMode, "DialogListItem" + picApplyModePageData[PictureConfig.picApplyModeSign + "Val"]);
        var id = picApplyModePageData[PictureConfig.picApplyModeSign + "Val"];
        picApplyMode.currFocus = UI.getItem(picApplyMode, "item" + id);
        UI.updateStage();
    };

    picApplyMode.onShow = function () {
        picApplyMode.alpha = 1;
        setChangeImage();
        UI.focusTo(UI.getItem(grid, "DialogListItem" + picApplyModePageData[PictureConfig.picApplyModeSign + "Val"]));
    };

    var picApplyModePageData = {
        isPicWhtBal20PotSupport: 1,
        picApplyPictureSettingsVal: 0,
        picApplyColorTunerVal: 0,
        picApply2PWhiteBalanceVal: 0,
        picApply10PWhiteBalanceVal: 0,
        picWhtBal2Pot10PotVal: 0,
        picMainHdmiSelectVal:0
    };
    picApplyModePageData.isPicWhtBal20PotSupport = tv ? model.video.getwbfeature() : 1;
    DBG_INFO("model.video.getwbfeature(): " + picApplyModePageData.isPicWhtBal20PotSupport);

    function picApplyModePageInit() {
        try {
            switch (PictureConfig.picApplyModeSign){
                case PicSignDefine.PicApplyModeSign.PIC_APPLY_PICTURE_SETTINGS:
                    picApplyModePageData.picApplyPictureSettingsVal = tv ? model.video.getApplyMode() : 1;
                    DBG_INFO('model.video.getApplyMode(): ' + picApplyModePageData.picApplyPictureSettingsVal);
                    break;
                case PicSignDefine.PicApplyModeSign.PIC_APPLY_COLOR_TUNER:
                    picApplyModePageData.picApplyColorTunerVal = tv ? model.video.getApplyColorTunner() : 1;
                    DBG_INFO('model.video.getApplyColorTunner(): ' + picApplyModePageData.picApplyColorTunerVal);
                    break;
                case PicSignDefine.PicApplyModeSign.PIC_APPLY_2P_WHITE_BALANCE:
                    picApplyModePageData.picApply2PWhiteBalanceVal = tv ? model.video.getApply2p_wb() : 1;
                    DBG_INFO('model.video.getApply2p_wb(): ' + picApplyModePageData.picApply2PWhiteBalanceVal);
                    break;
                case PicSignDefine.PicApplyModeSign.PIC_APPLY_10P_WHITE_BALANCE:
                    picApplyModePageData.picApply10PWhiteBalanceVal = tv ? model.video.getApply10p_wb() : 1;
                    DBG_INFO('model.video.getApply10p_wb(): ' + picApplyModePageData.picApply10PWhiteBalanceVal);
                    break;
                case PicSignDefine.PicApplyModeSign.PIC_WHT_BAL_2POT_10POT:
                    picApplyModePageData.picWhtBal2Pot10PotVal = tv ? model.video.getWhiteBalanceTenTwoPointsMode() : 1;
                    if(!tv){
                        picApplyModePageData.picWhtBal2Pot10PotVal =
                            (PictureConfig.picApplyModeSign == PicSignDefine.PicApplyModeSign.PIC_WHT_BAL_2POT_10POT) ? 0 : 1;
                    }
                    DBG_INFO('model.video.getWhiteBalanceTenTwoPointsMode(): ' + picApplyModePageData.picWhtBal2Pot10PotVal);
                    break;
                case PicSignDefine.PicApplyModeSign.PIC_HDMI_FORMAT:
                    picApplyModePageData.picMainHdmiSelectVal = tv ? model.video.getHdmiSignalFormat() : 1;
                    DBG_INFO('model.video.getHdmiSignalFormat(): ' + picApplyModePageData.picMainHdmiSelectVal);
                    break;
                default:
                    DBG_ERROR("PictureConfig.picApplyModeSign ERR");
                    break;
            }
        } catch (ex) {
            DBG_ERROR(ex.message);
        }
    }

    function setApplyValue(){
        try {
            var index = UI.getCurrFocus().name.split("item")[1];//grid.initSequence.indexOf(focus);
            DBG_INFO('index: ' + index);
            index = parseInt(index);

            switch (PictureConfig.picApplyModeSign){
                case PicSignDefine.PicApplyModeSign.PIC_APPLY_PICTURE_SETTINGS:
                    tv && model.video.setApplyMode(index);
                    DBG_INFO('model.video.setApplyMode(' + index + ')');
                    break;
                case PicSignDefine.PicApplyModeSign.PIC_APPLY_COLOR_TUNER:
                    tv && model.video.setApplyColorTunner(index);
                    DBG_INFO('model.video.setApplyColorTunner(' + index + ')');
                    break;
                case PicSignDefine.PicApplyModeSign.PIC_APPLY_2P_WHITE_BALANCE:
                    tv && model.video.setApply2p_wb(index);
                    DBG_INFO('model.video.setApply2p_wb(' + index + ')');
                    break;
                case PicSignDefine.PicApplyModeSign.PIC_APPLY_10P_WHITE_BALANCE:
                    tv && model.video.setApply10p_wb(index);
                    DBG_INFO('model.video.setApply10p_wb(' + index + ')');
                    break;
                case PicSignDefine.PicApplyModeSign.PIC_WHT_BAL_2POT_10POT:
                    tv && model.video.setWhiteBalanceTenTwoPointsMode(index);
                    DBG_INFO('model.video.setWhiteBalanceTenTwoPointsMode(' + index + ')');
                    break;
                case PicSignDefine.PicApplyModeSign.PIC_HDMI_FORMAT:
                    tv && model.video.setHdmiSignalFormat(index);
                    DBG_INFO('model.video.setHdmiSignalFormat(' + index + ')');
                    break;
                default:
                    DBG_ERROR("PictureConfig.picApplyModeSign ERR");
                    break;
            }
        } catch (ex) {
            DBG_ERROR(ex.message);
        }
    }

    picApplyMode.TimeOutTimer=null;
    grid.onkey_ENTER = function (focus) {
        var index = UI.getCurrFocus().name.split("item")[1];//grid.initSequence.indexOf(focus);
        setApplyValue();
        setChangeImage();
        clearTimeout(picApplyMode.TimeOutTimer);
        picApplyMode.TimeOutTimer=setTimeout(function(){
            if(PictureConfig.picApplyModeSign == PicSignDefine.PicApplyModeSign.PIC_WHT_BAL_2POT_10POT){
                if(index==0){
                    PictureConfig.PicWteBalSign=PicSignDefine.PicWteBalSign.PIC_BALANCE_2_POT;
                }else{
                    PictureConfig.PicWteBalSign=PicSignDefine.PicWteBalSign.PIC_BALANCE_10_POT;
                }
                UI.popSubModule();
//                UI.pushSubModule("setting", "picPanelWhiteBalance", true);
//                if (0 == index && picApplyMode.caller == 'picPanelBal2Pot' ||
//                    1 == index && picApplyMode.caller == 'picPanelBal10Pot'
//                    ) {
//                    UI.popSubModule();
//                    return true;
//                } else {
//                    UI.popSubModule();
//                    UI.popSubModule();
//                    UI.getSubModule("picExpert").alpha = 0;
//
//                    1 == index && UI.pushSubModule("setting", "picPanelBal10Pot", true);
//                    0 == index && UI.pushSubModule("setting", "picPanelBal2Pot", true);
//                }
            } else if (PictureConfig.picApplyModeSign == PicSignDefine.PicApplyModeSign.PIC_HDMI_FORMAT) {
                UI.popSubModule();
                UI.pushSubModule("setting","menuChip",true, picApplyMode.param);
            } else {
                UI.popSubModule();
            }

        },500);
    };

    function setChangeImage(){
        for (var i = 0; i < grid.initSequence.length; i++) {
            UI.setImage(grid.children[i].children[2], ImageList.normalImage);
        }
        UI.setImage(picApplyMode.currFocus.children[2], ImageList.focusImage);
    }

    picApplyMode.onkey_BACKSPACE = function(){
        if(PictureConfig.picApplyModeSign == PicSignDefine.PicApplyModeSign.PIC_HDMI_FORMAT) {
            UI.popSubModule();
            UI.pushSubModule("setting", "menuChip", true, picApplyMode.param);
        }else{
            return true;
        }
    };

    picApplyMode.onPop = function(){
        clearTimeout(picApplyMode.TimeOutTimer);
        picApplyMode.TimeOutTimer=null;
    }

};
